import 'dart:io';

import 'package:flutter/material.dart';
import 'package:photo_view/photo_view.dart';

class ZoomCircle extends StatelessWidget {
  final String imagePath;
  final Size originalSize;
  final Offset zoomCenter; // The location to zoom into (relative to image)
  final double radius;
  final double zoomFactor;
  final Border? border;

  const ZoomCircle({
    super.key,
    required this.imagePath,
    required this.originalSize,
    required this.zoomCenter,
    required this.radius,
    required this.zoomFactor,
    this.border,
  });

  @override
  Widget build(BuildContext context) {
    return Container(
      width: radius,
      height: radius,
      decoration: BoxDecoration(
        shape: BoxShape.circle,
        border: border,
      ),
      child: ClipOval(
        clipBehavior: Clip.antiAlias,
        child: PhotoView(
          initialScale: PhotoViewComputedScale.contained * zoomFactor,
          customSize: Size(originalSize.width, originalSize.height),
          imageProvider: FileImage(File(imagePath)),
          disableGestures: true,
          basePosition: getImageCenteredAlignment(),
        ),
      ),
    );
  }

  Alignment getImageCenteredAlignment() {
    // Shift the image by radius / 2 to position it at the center of the zoom circle, not top left
    // and then scale this to a -1.0 +1.0 scale of the original image size
    return Alignment(
      zoomCenter.dx + (((radius / 2) * zoomCenter.dx) / originalSize.width),
      zoomCenter.dy + (((radius / 2) * zoomCenter.dy) / originalSize.height),
    );
  }
}
