import 'package:flutter/material.dart';
import 'package:miniature_painting_companion/Models/layers_model.dart';
import 'package:miniature_painting_companion/injector.dart';
import 'package:miniature_painting_companion/views/design/app_paddings.dart';
import 'package:miniature_painting_companion/views/design/app_sizes.dart';

import '../../../utils/app_icons.dart';
import '../../design/slidable_card.dart';
import 'new_sticker_layer_dialog.dart';
import 'package:miniature_painting_companion/services/image_asset_service.dart';

class StickerLayerWidget extends StatelessWidget {
  final StickerLayer sticker;

  const StickerLayerWidget({super.key, required this.sticker});

  @override
  Widget build(BuildContext context) {
    ImageAssetService.getSvgIconSized(20, 30, AppIcons.aquila);

    var content = Center(
        child: Row(
      children: [
        const SizedBox(width: AppSizes.size8),
        Expanded(
          child: Container(
            padding: AppPaddings.symmetric_15_10,
            child: Text(
              sticker.name.toUpperCase(),
              textAlign: TextAlign.center,
              style: const TextStyle(fontFamily: 'Gothic'),
            ),
          ),
        ),
        Card(
          shadowColor: Colors.transparent,
          clipBehavior: Clip.hardEdge,
          child: ImageAssetService.getImageOrPlaceholderSized(
              AppSizes.size80, AppSizes.size80, sticker.imagePath),
        ),
        const SizedBox(width: AppSizes.size40),
      ],
    ));

    return SlidableCard(
        startAction: (context) async =>
            {await iDrawableRepo.delete(sticker)},
        endAction: (otherContext) =>
            NewStickerLayerDialog.show(context, null, sticker, null),
        child: content);
  }
}
