
import 'package:flutter/material.dart';
import 'package:hive_ce_flutter/adapters.dart';
import 'package:miniature_painting_companion/Models/layers_model.dart';
import 'package:miniature_painting_companion/utils.dart';
import 'package:miniature_painting_companion/views/design/app_paddings.dart';
import 'package:miniature_painting_companion/views/design/app_sizes.dart';

import '../../../injector.dart';

import '../../../utils/app_icons.dart';
import '../../design/slidable_card.dart';
import '../layers_list_widget.dart';
import '../paint_layer/new_paint_layer_dialog.dart';
import 'new_combined_layer_dialog.dart';
import 'package:miniature_painting_companion/services/image_asset_service.dart';

class CombinedLayerWidget extends StatelessWidget {
  final CombinedLayer layer;

  const CombinedLayerWidget({super.key, required this.layer});

  @override
  Widget build(BuildContext context) {
    var body = Column(
      children: [
        const SizedBox(height: AppSizes.size8),
        Center(
          child: Utils.gothicText(layer.name.toUpperCase()),
        ),
        const SizedBox(height: AppSizes.size8),
        GrowableWidgetList(
          layers: layer.layers,
          onAddClicked: () async {
            await NewPaintLayerDialog.show(context, true, null, (created) async {
              await layer.addLayer(created);
            });
            await iDrawableRepo.save(layer);
          },
        ),
        const SizedBox(height: AppSizes.size8),
      ],
    );

    return SlidableCard(
        startAction: (context) async {
          await iDrawableRepo.delete(layer);
        },
        endAction: (otherContext) =>
            NewCombinedLayerDialog.show(context, layer, null),
        child: body);
  }
}

class GrowableWidgetList extends StatelessWidget {
  const GrowableWidgetList({
    super.key,
    required this.layers,
    required this.onAddClicked,
  });

  final List<IDrawableLayer> layers;
  final void Function() onAddClicked;

  @override
  Widget build(BuildContext context) {
    return Column(
      children: [
        ValueListenableBuilder(
          valueListenable: iDrawableRepo.listenable(),
          builder: (context, Box box, _) => layers.isNotEmpty
              ? Container(
                  color: Colors.grey.withAlpha(50),
                  child: ReorderableWidgetList(
                      itemBuilder: (_, index) =>
                          layers[index].getWidget(Key("$index")),
                      padding: AppPaddings.all8,
                      layers: layers,
                      nested: true),
                )
              : Container(),
        ),
        if (layers.isNotEmpty) const SizedBox(height: AppSizes.size8),
        Ink(
          decoration: const ShapeDecoration(
            color: Colors.blueGrey,
            shape: CircleBorder(),
          ),
          child: IconButton(
            icon: ImageAssetService.getSvgIconSized(
                AppSizes.size30, AppSizes.size30, AppIcons.plus),
            onPressed: () {
              onAddClicked();
            },
          ),
        ),
      ],
    );
  }
}
