// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for English (`en`).
class AppLocalizationsEn extends AppLocalizations {
  AppLocalizationsEn([String locale = 'en']) : super(locale);

  @override
  String get appTitle => 'Minis companion';

  @override
  String get exportData => 'Export data';

  @override
  String get importData => 'Import data';

  @override
  String get drawerHeader => 'Export';

  @override
  String get addMiniature => 'Add miniature';

  @override
  String get accessExternalStorageRequired =>
      'Access to external storage is needed to save data in a file';

  @override
  String get create => 'Create';

  @override
  String get update => 'Update';

  @override
  String get takePicture => 'Take picture';

  @override
  String get choosePicture => 'Choose picture';

  @override
  String get createPaintJob => 'Create paint job';

  @override
  String get updatePaintJob => 'Update paint job';

  @override
  String get createMiniature => 'Create miniature';

  @override
  String get updateMiniature => 'Update miniature';

  @override
  String get createSticker => 'Create sticker';

  @override
  String get updateSticker => 'Update sticker';

  @override
  String get createSeparator => 'Add a separator';

  @override
  String get updateSeparator => 'Update separator';

  @override
  String get createLayer => 'Add a layer';

  @override
  String get updateLayer => 'Update layer';

  @override
  String get createCombinedPaint => 'Add a combined layer';

  @override
  String get updateCombinedPaint => 'Update combined layer';

  @override
  String get addSeparator => 'Add separator';

  @override
  String get addPaintJob => 'Add paint job';

  @override
  String get view => 'View';

  @override
  String get edit => 'Edit';

  @override
  String get clone => 'Clone';

  @override
  String get delete => 'Delete';

  @override
  String get close => 'Close';

  @override
  String get note => 'Note';

  @override
  String get dilutionRange => 'Dilution can only be between 1 and 100';

  @override
  String get addPaintLayer => 'Add paint layer';

  @override
  String get paintName => 'Paint Name';

  @override
  String get paintType => 'Paint type';

  @override
  String get dilution => 'Dilution';

  @override
  String invalidNumber(Object value) {
    return '$value is not a valid number';
  }

  @override
  String get addCombinedLayer => 'Add combined layer';

  @override
  String get name => 'Name';

  @override
  String get errorWhileParsingDate =>
      'Error while parsing the date of some images';

  @override
  String get date => 'Date';

  @override
  String get noPaintFound => 'No paint found';

  @override
  String get addSticker => 'Add sticker';

  @override
  String get data => 'Data';

  @override
  String search_paints(Object manufacturer) {
    return 'Search $manufacturer paints';
  }

  @override
  String get other => 'Other';

  @override
  String get disclaimer => 'Disclaimer';

  @override
  String get settings => 'Settings';

  @override
  String get configurePaintManufacturer => 'Configure paint manufacturer';

  @override
  String get pickPaint => 'Pick a paint';

  @override
  String get paints => 'Paints';

  @override
  String get addCustomPaint => 'Add custom paints';

  @override
  String get noMiniatureCreated => 'No miniature created';

  @override
  String get noCustomPaintCreated => 'No custom paint created';

  @override
  String get favorite => 'Favorite';

  @override
  String get unFavorite => 'Un favorite';

  @override
  String get useMiniatureImage => 'Use miniature image';

  @override
  String get convertToDetail => 'Convert to detail';

  @override
  String get disclaimer_content =>
      'The names of the brands and paints used in the app are copyright and trademarks of the corresponding companies. Minis companion does not claim ownership over the brands and paint names. They only get used as references to the products of the corresponding companies.';

  @override
  String get exportSuccess => 'Export success';

  @override
  String get exportFailed => 'Export failed';

  @override
  String get importSuccess => 'Import success';

  @override
  String get importFailed => 'Import failed';
}
