import 'dart:async';

import 'package:flutter/foundation.dart';
import 'package:flutter/widgets.dart';
import 'package:flutter_localizations/flutter_localizations.dart';
import 'package:intl/intl.dart' as intl;

import 'app_localizations_en.dart';
import 'app_localizations_fr.dart';

// ignore_for_file: type=lint

/// Callers can lookup localized strings with an instance of AppLocalizations
/// returned by `AppLocalizations.of(context)`.
///
/// Applications need to include `AppLocalizations.delegate()` in their app's
/// `localizationDelegates` list, and the locales they support in the app's
/// `supportedLocales` list. For example:
///
/// ```dart
/// import 'l10n/app_localizations.dart';
///
/// return MaterialApp(
///   localizationsDelegates: AppLocalizations.localizationsDelegates,
///   supportedLocales: AppLocalizations.supportedLocales,
///   home: MyApplicationHome(),
/// );
/// ```
///
/// ## Update pubspec.yaml
///
/// Please make sure to update your pubspec.yaml to include the following
/// packages:
///
/// ```yaml
/// dependencies:
///   # Internationalization support.
///   flutter_localizations:
///     sdk: flutter
///   intl: any # Use the pinned version from flutter_localizations
///
///   # Rest of dependencies
/// ```
///
/// ## iOS Applications
///
/// iOS applications define key application metadata, including supported
/// locales, in an Info.plist file that is built into the application bundle.
/// To configure the locales supported by your app, you’ll need to edit this
/// file.
///
/// First, open your project’s ios/Runner.xcworkspace Xcode workspace file.
/// Then, in the Project Navigator, open the Info.plist file under the Runner
/// project’s Runner folder.
///
/// Next, select the Information Property List item, select Add Item from the
/// Editor menu, then select Localizations from the pop-up menu.
///
/// Select and expand the newly-created Localizations item then, for each
/// locale your application supports, add a new item and select the locale
/// you wish to add from the pop-up menu in the Value field. This list should
/// be consistent with the languages listed in the AppLocalizations.supportedLocales
/// property.
abstract class AppLocalizations {
  AppLocalizations(String locale)
      : localeName = intl.Intl.canonicalizedLocale(locale.toString());

  final String localeName;

  static AppLocalizations? of(BuildContext context) {
    return Localizations.of<AppLocalizations>(context, AppLocalizations);
  }

  static const LocalizationsDelegate<AppLocalizations> delegate =
      _AppLocalizationsDelegate();

  /// A list of this localizations delegate along with the default localizations
  /// delegates.
  ///
  /// Returns a list of localizations delegates containing this delegate along with
  /// GlobalMaterialLocalizations.delegate, GlobalCupertinoLocalizations.delegate,
  /// and GlobalWidgetsLocalizations.delegate.
  ///
  /// Additional delegates can be added by appending to this list in
  /// MaterialApp. This list does not have to be used at all if a custom list
  /// of delegates is preferred or required.
  static const List<LocalizationsDelegate<dynamic>> localizationsDelegates =
      <LocalizationsDelegate<dynamic>>[
    delegate,
    GlobalMaterialLocalizations.delegate,
    GlobalCupertinoLocalizations.delegate,
    GlobalWidgetsLocalizations.delegate,
  ];

  /// A list of this localizations delegate's supported locales.
  static const List<Locale> supportedLocales = <Locale>[
    Locale('en'),
    Locale('fr')
  ];

  /// No description provided for @appTitle.
  ///
  /// In en, this message translates to:
  /// **'Minis companion'**
  String get appTitle;

  /// No description provided for @exportData.
  ///
  /// In en, this message translates to:
  /// **'Export data'**
  String get exportData;

  /// No description provided for @importData.
  ///
  /// In en, this message translates to:
  /// **'Import data'**
  String get importData;

  /// No description provided for @drawerHeader.
  ///
  /// In en, this message translates to:
  /// **'Export'**
  String get drawerHeader;

  /// No description provided for @addMiniature.
  ///
  /// In en, this message translates to:
  /// **'Add miniature'**
  String get addMiniature;

  /// No description provided for @accessExternalStorageRequired.
  ///
  /// In en, this message translates to:
  /// **'Access to external storage is needed to save data in a file'**
  String get accessExternalStorageRequired;

  /// No description provided for @create.
  ///
  /// In en, this message translates to:
  /// **'Create'**
  String get create;

  /// No description provided for @update.
  ///
  /// In en, this message translates to:
  /// **'Update'**
  String get update;

  /// No description provided for @takePicture.
  ///
  /// In en, this message translates to:
  /// **'Take picture'**
  String get takePicture;

  /// No description provided for @choosePicture.
  ///
  /// In en, this message translates to:
  /// **'Choose picture'**
  String get choosePicture;

  /// No description provided for @createPaintJob.
  ///
  /// In en, this message translates to:
  /// **'Create paint job'**
  String get createPaintJob;

  /// No description provided for @updatePaintJob.
  ///
  /// In en, this message translates to:
  /// **'Update paint job'**
  String get updatePaintJob;

  /// No description provided for @createMiniature.
  ///
  /// In en, this message translates to:
  /// **'Create miniature'**
  String get createMiniature;

  /// No description provided for @updateMiniature.
  ///
  /// In en, this message translates to:
  /// **'Update miniature'**
  String get updateMiniature;

  /// No description provided for @createSticker.
  ///
  /// In en, this message translates to:
  /// **'Create sticker'**
  String get createSticker;

  /// No description provided for @updateSticker.
  ///
  /// In en, this message translates to:
  /// **'Update sticker'**
  String get updateSticker;

  /// No description provided for @createSeparator.
  ///
  /// In en, this message translates to:
  /// **'Add a separator'**
  String get createSeparator;

  /// No description provided for @updateSeparator.
  ///
  /// In en, this message translates to:
  /// **'Update separator'**
  String get updateSeparator;

  /// No description provided for @createLayer.
  ///
  /// In en, this message translates to:
  /// **'Add a layer'**
  String get createLayer;

  /// No description provided for @updateLayer.
  ///
  /// In en, this message translates to:
  /// **'Update layer'**
  String get updateLayer;

  /// No description provided for @createCombinedPaint.
  ///
  /// In en, this message translates to:
  /// **'Add a combined layer'**
  String get createCombinedPaint;

  /// No description provided for @updateCombinedPaint.
  ///
  /// In en, this message translates to:
  /// **'Update combined layer'**
  String get updateCombinedPaint;

  /// No description provided for @addSeparator.
  ///
  /// In en, this message translates to:
  /// **'Add separator'**
  String get addSeparator;

  /// No description provided for @addPaintJob.
  ///
  /// In en, this message translates to:
  /// **'Add paint job'**
  String get addPaintJob;

  /// No description provided for @view.
  ///
  /// In en, this message translates to:
  /// **'View'**
  String get view;

  /// No description provided for @edit.
  ///
  /// In en, this message translates to:
  /// **'Edit'**
  String get edit;

  /// No description provided for @clone.
  ///
  /// In en, this message translates to:
  /// **'Clone'**
  String get clone;

  /// No description provided for @delete.
  ///
  /// In en, this message translates to:
  /// **'Delete'**
  String get delete;

  /// No description provided for @close.
  ///
  /// In en, this message translates to:
  /// **'Close'**
  String get close;

  /// No description provided for @note.
  ///
  /// In en, this message translates to:
  /// **'Note'**
  String get note;

  /// No description provided for @dilutionRange.
  ///
  /// In en, this message translates to:
  /// **'Dilution can only be between 1 and 100'**
  String get dilutionRange;

  /// No description provided for @addPaintLayer.
  ///
  /// In en, this message translates to:
  /// **'Add paint layer'**
  String get addPaintLayer;

  /// No description provided for @paintName.
  ///
  /// In en, this message translates to:
  /// **'Paint Name'**
  String get paintName;

  /// No description provided for @paintType.
  ///
  /// In en, this message translates to:
  /// **'Paint type'**
  String get paintType;

  /// No description provided for @dilution.
  ///
  /// In en, this message translates to:
  /// **'Dilution'**
  String get dilution;

  /// No description provided for @invalidNumber.
  ///
  /// In en, this message translates to:
  /// **'{value} is not a valid number'**
  String invalidNumber(Object value);

  /// No description provided for @addCombinedLayer.
  ///
  /// In en, this message translates to:
  /// **'Add combined layer'**
  String get addCombinedLayer;

  /// No description provided for @name.
  ///
  /// In en, this message translates to:
  /// **'Name'**
  String get name;

  /// No description provided for @errorWhileParsingDate.
  ///
  /// In en, this message translates to:
  /// **'Error while parsing the date of some images'**
  String get errorWhileParsingDate;

  /// No description provided for @date.
  ///
  /// In en, this message translates to:
  /// **'Date'**
  String get date;

  /// No description provided for @noPaintFound.
  ///
  /// In en, this message translates to:
  /// **'No paint found'**
  String get noPaintFound;

  /// No description provided for @addSticker.
  ///
  /// In en, this message translates to:
  /// **'Add sticker'**
  String get addSticker;

  /// No description provided for @data.
  ///
  /// In en, this message translates to:
  /// **'Data'**
  String get data;

  /// No description provided for @search_paints.
  ///
  /// In en, this message translates to:
  /// **'Search {manufacturer} paints'**
  String search_paints(Object manufacturer);

  /// No description provided for @other.
  ///
  /// In en, this message translates to:
  /// **'Other'**
  String get other;

  /// No description provided for @disclaimer.
  ///
  /// In en, this message translates to:
  /// **'Disclaimer'**
  String get disclaimer;

  /// No description provided for @settings.
  ///
  /// In en, this message translates to:
  /// **'Settings'**
  String get settings;

  /// No description provided for @configurePaintManufacturer.
  ///
  /// In en, this message translates to:
  /// **'Configure paint manufacturer'**
  String get configurePaintManufacturer;

  /// No description provided for @pickPaint.
  ///
  /// In en, this message translates to:
  /// **'Pick a paint'**
  String get pickPaint;

  /// No description provided for @paints.
  ///
  /// In en, this message translates to:
  /// **'Paints'**
  String get paints;

  /// No description provided for @addCustomPaint.
  ///
  /// In en, this message translates to:
  /// **'Add custom paints'**
  String get addCustomPaint;

  /// No description provided for @noMiniatureCreated.
  ///
  /// In en, this message translates to:
  /// **'No miniature created'**
  String get noMiniatureCreated;

  /// No description provided for @noCustomPaintCreated.
  ///
  /// In en, this message translates to:
  /// **'No custom paint created'**
  String get noCustomPaintCreated;

  /// No description provided for @favorite.
  ///
  /// In en, this message translates to:
  /// **'Favorite'**
  String get favorite;

  /// No description provided for @unFavorite.
  ///
  /// In en, this message translates to:
  /// **'Un favorite'**
  String get unFavorite;

  /// No description provided for @useMiniatureImage.
  ///
  /// In en, this message translates to:
  /// **'Use miniature image'**
  String get useMiniatureImage;

  /// No description provided for @convertToDetail.
  ///
  /// In en, this message translates to:
  /// **'Convert to detail'**
  String get convertToDetail;

  /// No description provided for @disclaimer_content.
  ///
  /// In en, this message translates to:
  /// **'The names of the brands and paints used in the app are copyright and trademarks of the corresponding companies. Minis companion does not claim ownership over the brands and paint names. They only get used as references to the products of the corresponding companies.'**
  String get disclaimer_content;

  /// No description provided for @exportSuccess.
  ///
  /// In en, this message translates to:
  /// **'Export success'**
  String get exportSuccess;

  /// No description provided for @exportFailed.
  ///
  /// In en, this message translates to:
  /// **'Export failed'**
  String get exportFailed;

  /// No description provided for @importSuccess.
  ///
  /// In en, this message translates to:
  /// **'Import success'**
  String get importSuccess;

  /// No description provided for @importFailed.
  ///
  /// In en, this message translates to:
  /// **'Import failed'**
  String get importFailed;
}

class _AppLocalizationsDelegate
    extends LocalizationsDelegate<AppLocalizations> {
  const _AppLocalizationsDelegate();

  @override
  Future<AppLocalizations> load(Locale locale) {
    return SynchronousFuture<AppLocalizations>(lookupAppLocalizations(locale));
  }

  @override
  bool isSupported(Locale locale) =>
      <String>['en', 'fr'].contains(locale.languageCode);

  @override
  bool shouldReload(_AppLocalizationsDelegate old) => false;
}

AppLocalizations lookupAppLocalizations(Locale locale) {
  // Lookup logic when only language code is specified.
  switch (locale.languageCode) {
    case 'en':
      return AppLocalizationsEn();
    case 'fr':
      return AppLocalizationsFr();
  }

  throw FlutterError(
      'AppLocalizations.delegate failed to load unsupported locale "$locale". This is likely '
      'an issue with the localizations generation tool. Please file an issue '
      'on GitHub with a reproducible sample app and the gen-l10n configuration '
      'that was used.');
}
