// Copyright 2013 The Flutter Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Autogenerated from Pigeon (v22.4.1), do not edit directly.
// See also: https://pub.dev/packages/pigeon

import Foundation

#if os(iOS)
  import Flutter
#elseif os(macOS)
  import FlutterMacOS
#else
  #error("Unsupported platform.")
#endif

/// Error class for passing custom error details to Dart side.
final class PigeonError: Error {
  let code: String
  let message: String?
  let details: Any?

  init(code: String, message: String?, details: Any?) {
    self.code = code
    self.message = message
    self.details = details
  }

  var localizedDescription: String {
    return
      "PigeonError(code: \(code), message: \(message ?? "<nil>"), details: \(details ?? "<nil>")"
  }
}

private func wrapResult(_ result: Any?) -> [Any?] {
  return [result]
}

private func wrapError(_ error: Any) -> [Any?] {
  if let pigeonError = error as? PigeonError {
    return [
      pigeonError.code,
      pigeonError.message,
      pigeonError.details,
    ]
  }
  if let flutterError = error as? FlutterError {
    return [
      flutterError.code,
      flutterError.message,
      flutterError.details,
    ]
  }
  return [
    "\(error)",
    "\(type(of: error))",
    "Stacktrace: \(Thread.callStackSymbols)",
  ]
}

private func isNullish(_ value: Any?) -> Bool {
  return value is NSNull || value == nil
}

private func nilOrValue<T>(_ value: Any?) -> T? {
  if value is NSNull { return nil }
  return value as! T?
}

/// A Pigeon representation of the macOS portion of an `XTypeGroup`.
///
/// Generated class from Pigeon that represents data sent in messages.
struct AllowedTypes {
  var extensions: [String]
  var mimeTypes: [String]
  var utis: [String]

  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> AllowedTypes? {
    let extensions = pigeonVar_list[0] as! [String]
    let mimeTypes = pigeonVar_list[1] as! [String]
    let utis = pigeonVar_list[2] as! [String]

    return AllowedTypes(
      extensions: extensions,
      mimeTypes: mimeTypes,
      utis: utis
    )
  }
  func toList() -> [Any?] {
    return [
      extensions,
      mimeTypes,
      utis,
    ]
  }
}

/// Options for save panels.
///
/// These correspond to NSSavePanel properties (which are, by extension
/// NSOpenPanel properties as well).
///
/// Generated class from Pigeon that represents data sent in messages.
struct SavePanelOptions {
  var allowedFileTypes: AllowedTypes? = nil
  var directoryPath: String? = nil
  var nameFieldStringValue: String? = nil
  var prompt: String? = nil

  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> SavePanelOptions? {
    let allowedFileTypes: AllowedTypes? = nilOrValue(pigeonVar_list[0])
    let directoryPath: String? = nilOrValue(pigeonVar_list[1])
    let nameFieldStringValue: String? = nilOrValue(pigeonVar_list[2])
    let prompt: String? = nilOrValue(pigeonVar_list[3])

    return SavePanelOptions(
      allowedFileTypes: allowedFileTypes,
      directoryPath: directoryPath,
      nameFieldStringValue: nameFieldStringValue,
      prompt: prompt
    )
  }
  func toList() -> [Any?] {
    return [
      allowedFileTypes,
      directoryPath,
      nameFieldStringValue,
      prompt,
    ]
  }
}

/// Options for open panels.
///
/// These correspond to NSOpenPanel properties.
///
/// Generated class from Pigeon that represents data sent in messages.
struct OpenPanelOptions {
  var allowsMultipleSelection: Bool
  var canChooseDirectories: Bool
  var canChooseFiles: Bool
  var baseOptions: SavePanelOptions

  // swift-format-ignore: AlwaysUseLowerCamelCase
  static func fromList(_ pigeonVar_list: [Any?]) -> OpenPanelOptions? {
    let allowsMultipleSelection = pigeonVar_list[0] as! Bool
    let canChooseDirectories = pigeonVar_list[1] as! Bool
    let canChooseFiles = pigeonVar_list[2] as! Bool
    let baseOptions = pigeonVar_list[3] as! SavePanelOptions

    return OpenPanelOptions(
      allowsMultipleSelection: allowsMultipleSelection,
      canChooseDirectories: canChooseDirectories,
      canChooseFiles: canChooseFiles,
      baseOptions: baseOptions
    )
  }
  func toList() -> [Any?] {
    return [
      allowsMultipleSelection,
      canChooseDirectories,
      canChooseFiles,
      baseOptions,
    ]
  }
}

private class messagesPigeonCodecReader: FlutterStandardReader {
  override func readValue(ofType type: UInt8) -> Any? {
    switch type {
    case 129:
      return AllowedTypes.fromList(self.readValue() as! [Any?])
    case 130:
      return SavePanelOptions.fromList(self.readValue() as! [Any?])
    case 131:
      return OpenPanelOptions.fromList(self.readValue() as! [Any?])
    default:
      return super.readValue(ofType: type)
    }
  }
}

private class messagesPigeonCodecWriter: FlutterStandardWriter {
  override func writeValue(_ value: Any) {
    if let value = value as? AllowedTypes {
      super.writeByte(129)
      super.writeValue(value.toList())
    } else if let value = value as? SavePanelOptions {
      super.writeByte(130)
      super.writeValue(value.toList())
    } else if let value = value as? OpenPanelOptions {
      super.writeByte(131)
      super.writeValue(value.toList())
    } else {
      super.writeValue(value)
    }
  }
}

private class messagesPigeonCodecReaderWriter: FlutterStandardReaderWriter {
  override func reader(with data: Data) -> FlutterStandardReader {
    return messagesPigeonCodecReader(data: data)
  }

  override func writer(with data: NSMutableData) -> FlutterStandardWriter {
    return messagesPigeonCodecWriter(data: data)
  }
}

class messagesPigeonCodec: FlutterStandardMessageCodec, @unchecked Sendable {
  static let shared = messagesPigeonCodec(readerWriter: messagesPigeonCodecReaderWriter())
}

/// Generated protocol from Pigeon that represents a handler of messages from Flutter.
protocol FileSelectorApi {
  /// Shows an open panel with the given [options], returning the list of
  /// selected paths.
  ///
  /// An empty list corresponds to a cancelled selection.
  func displayOpenPanel(
    options: OpenPanelOptions, completion: @escaping (Result<[String], Error>) -> Void)
  /// Shows a save panel with the given [options], returning the selected path.
  ///
  /// A null return corresponds to a cancelled save.
  func displaySavePanel(
    options: SavePanelOptions, completion: @escaping (Result<String?, Error>) -> Void)
}

/// Generated setup class from Pigeon to handle messages through the `binaryMessenger`.
class FileSelectorApiSetup {
  static var codec: FlutterStandardMessageCodec { messagesPigeonCodec.shared }
  /// Sets up an instance of `FileSelectorApi` to handle messages through the `binaryMessenger`.
  static func setUp(
    binaryMessenger: FlutterBinaryMessenger, api: FileSelectorApi?,
    messageChannelSuffix: String = ""
  ) {
    let channelSuffix = messageChannelSuffix.count > 0 ? ".\(messageChannelSuffix)" : ""
    /// Shows an open panel with the given [options], returning the list of
    /// selected paths.
    ///
    /// An empty list corresponds to a cancelled selection.
    let displayOpenPanelChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.file_selector_macos.FileSelectorApi.displayOpenPanel\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      displayOpenPanelChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let optionsArg = args[0] as! OpenPanelOptions
        api.displayOpenPanel(options: optionsArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      displayOpenPanelChannel.setMessageHandler(nil)
    }
    /// Shows a save panel with the given [options], returning the selected path.
    ///
    /// A null return corresponds to a cancelled save.
    let displaySavePanelChannel = FlutterBasicMessageChannel(
      name:
        "dev.flutter.pigeon.file_selector_macos.FileSelectorApi.displaySavePanel\(channelSuffix)",
      binaryMessenger: binaryMessenger, codec: codec)
    if let api = api {
      displaySavePanelChannel.setMessageHandler { message, reply in
        let args = message as! [Any?]
        let optionsArg = args[0] as! SavePanelOptions
        api.displaySavePanel(options: optionsArg) { result in
          switch result {
          case .success(let res):
            reply(wrapResult(res))
          case .failure(let error):
            reply(wrapError(error))
          }
        }
      }
    } else {
      displaySavePanelChannel.setMessageHandler(nil)
    }
  }
}
