import 'package:flutter/material.dart';
import 'package:miniature_painting_companion/extensions/string_extension.dart';
import 'package:miniature_painting_companion/main.dart';
import 'package:miniature_painting_companion/views/design/app_paddings.dart';
import 'package:miniature_painting_companion/views/design/app_sizes.dart';

import '../../Models/hive_models.dart';
import '../../injector.dart';
import '../../repositories/paint_manufacturer_repository.dart';

class ConfigurePaintManufacturerScreen extends StatefulWidget {
  const ConfigurePaintManufacturerScreen({super.key});

  @override
  State<ConfigurePaintManufacturerScreen> createState() =>
      _ConfigurePaintManufacturerScreenState();
}

class _ConfigurePaintManufacturerScreenState
    extends State<ConfigurePaintManufacturerScreen> {
  final PaintManufacturerSettingsRepo _repository =
      getIt<PaintManufacturerSettingsRepo>();
  Map<PaintManufacturer, bool> _manufacturers = {};

  @override
  void initState() {
    super.initState();
    _loadManufacturerStatus();
  }

  Future<void> _loadManufacturerStatus() async {
    final loadedManufacturers = await _repository.loadManufacturers();

    setState(() {
      _manufacturers = loadedManufacturers;
    });
  }

  Future<void> _updateManufacturerStatus(
      PaintManufacturer manufacturer, bool enabled) async {
    await _repository.saveManufacturer(manufacturer, enabled);
    setState(() {
      _manufacturers[manufacturer] = enabled;
    });
  }

  @override
  Widget build(BuildContext context) {
    return Scaffold(
      appBar: AppBar(
        title: Text(localizations.configurePaintManufacturer),
      ),
      body: Padding(
        padding: AppPaddings.all8,
        child: Column(
          spacing: AppSizes.size8,
          children: _manufacturers.entries.map((entry) {
            return Card(
              child: CheckboxListTile(
                title: Text(entry.key.name.capitalize()),
                value: entry.value,
                onChanged: (bool? value) {
                  if (value != null) {
                    _updateManufacturerStatus(entry.key, value);
                  }
                },
              ),
            );
          }).toList(),
        ),
      ),
    );
  }
}
