import 'package:flutter/material.dart';
import 'package:miniature_painting_companion/views/design/app_paddings.dart';
import 'package:reactive_forms/reactive_forms.dart';
import 'package:rflutter_alert/rflutter_alert.dart';

import '../../main.dart';

class ReactiveCRUDDialog {
  static Future<bool?> show(
      context,
      Object? toUpdate,
      List<Widget> content,
      FormGroup form,
      String createString,
      String updateString,
      Function(BuildContext) onSave,
      Function(BuildContext) onUpdate) {
    return Alert(
        // removes the default theme of the extension which doesn't handle dark theme
        style: AlertStyle(
          titleStyle: TextStyle(fontFamily: "Gothic"),
          titlePadding: AppPaddings.bottom24,
          alertPadding: AppPaddings.symmetricHorizontal16,
        ),
        context: context,
        title: (toUpdate == null) ? createString : updateString,
        content: ReactiveForm(
          formGroup: form,
          child: Column(
            children: List.from(content)
              ..addAll([
                ReactiveFormConsumer(
                  builder: (context, form, child) => Padding(
                    padding: AppPaddings.top24,
                    child: FilledButton(
                      onPressed: form.valid == false
                          ? null
                          : () => {
                                if (toUpdate != null)
                                  {onUpdate(context)}
                                else
                                  {onSave(context)},
                                Navigator.pop(context, true)
                              },
                      child: Text(
                        toUpdate == null
                            ? localizations.create
                            : localizations.update,
                        style: const TextStyle(fontSize: 20),
                      ),
                    ),
                  ),
                )
              ]),
          ),
        ),
        buttons: []).show();
  }
}
