import 'package:flutter/material.dart';
import 'package:miniature_painting_companion/Models/layers_model.dart';
import 'package:miniature_painting_companion/views/design/app_paddings.dart';
import 'package:miniature_painting_companion/views/design/app_sizes.dart';

import '../../../injector.dart';

import '../../../utils/app_icons.dart';
import '../../design/slidable_card.dart';
import 'new_separator_layer_dialog.dart';
import 'package:miniature_painting_companion/services/image_asset_service.dart';

class SeparatorLayerWidget extends StatelessWidget {
  final LayerSeparator separator;

  const SeparatorLayerWidget({super.key, required this.separator});

  @override
  Widget build(BuildContext context) {
    var aquila = ImageAssetService.getSvgIconSized(20, 30, AppIcons.aquila);

    var content = Center(
        child: Row(
      children: [
        const SizedBox(width: AppSizes.size8),
        aquila,
        Expanded(
          child: Container(
            padding: AppPaddings.symmetricVertical16,
            child: Text(
              separator.text.toUpperCase(),
              textAlign: TextAlign.center,
              style: const TextStyle(fontFamily: 'Gothic'),
            ),
          ),
        ),
        aquila,
        const SizedBox(width: AppSizes.size8),
      ],
    ));

    return SlidableCard(
        startAction: (context) async =>
            {await iDrawableRepo.delete(separator)},
        endAction: (otherContext) =>
            NewLayerSeparatorDialog.show(context, null, separator, null),
        child: content);
  }
}
