import 'package:flutter/material.dart';
import 'package:hive_ce_flutter/adapters.dart';
import 'package:miniature_painting_companion/main.dart';
import 'package:miniature_painting_companion/views/Layers/sticker/new_sticker_layer_dialog.dart';
import 'package:miniature_painting_companion/views/Layers/zoom_circle.dart';
import 'package:miniature_painting_companion/views/design/app_paddings.dart';

import '../../Models/hive_models.dart';
import '../../injector.dart';
import '../../utils/app_icons.dart';
import '../PaintJob/new_paint_job_dialog.dart';
import '../design/app_sizes.dart';
import 'combined/new_combined_layer_dialog.dart';
import 'layers_list_widget.dart';
import 'paint_layer/new_paint_layer_dialog.dart';
import 'separator/new_separator_layer_dialog.dart';
import 'package:miniature_painting_companion/services/image_asset_service.dart';

class PositionedLayerScreen extends StatefulWidget {
  final PaintJob paintJob;
  final PositionedLayer layer;
  final Size originalImageSize;
  final Offset zoomPosition;

  const PositionedLayerScreen(
      {super.key,
      required this.paintJob,
      required this.layer,
      required this.originalImageSize,
      required this.zoomPosition});

  @override
  State<StatefulWidget> createState() {
    return _PositionedLayerScreenState();
  }
}

class _PositionedLayerScreenState extends State<PositionedLayerScreen> {
  @override
  Widget build(BuildContext context) {
    var l = localizations;
    var paintJob = widget.paintJob;

    return Scaffold(
        appBar: AppBar(
          title: Text(paintJob.name ?? "Layers"),
          actions: [
            IconButton.filled(
                style: ButtonStyle(
                    shape: WidgetStatePropertyAll(OvalBorder()),
                    backgroundColor: WidgetStatePropertyAll(Colors.redAccent),
                    iconColor: WidgetStatePropertyAll(Colors.white)),
                onPressed: () async {
                  Navigator.pop(context);
                  await positionedRepo
                      .delete(widget.layer);
                  await paintJobRepo.save(widget.paintJob);
                },
                icon: Icon(Icons.delete)),
            SizedBox(
              width: AppSizes.size16,
            ),
            InkWell(
              onTap: () async {
                await NewPaintJobDialog.show(context, null, paintJob);
                setState(() {});
              },
              child: ZoomCircle(
                imagePath: widget.paintJob.imagePath!,
                originalSize: widget.originalImageSize,
                zoomCenter: widget.zoomPosition,
                radius: AppSizes.size50,
                zoomFactor: 2.0,
              ),
            ),
            SizedBox(
              width: AppSizes.size8,
            )
          ],
        ),
        body: Padding(
          padding: AppPaddings.symmetricHorizontal16,
          child: ValueListenableBuilder(
            // Can't rely solely on this as the refresh might happen before the new object is add to the layer of our current paintJob
            valueListenable:
                iDrawableRepo.listenable(),
            builder: (context, Box box, _) => ReorderableWidgetList(
                itemBuilder: (_, index) =>
                    widget.layer.layers[index].getWidget(Key("$index")),
                padding: AppPaddings.bottom200,
                layers: widget.layer.layers,
                nested: false),
          ),
        ),
        floatingActionButton: Column(
          mainAxisAlignment: MainAxisAlignment.end,
          children: [
            SizedBox(
              height: AppSizes.size40,
              width: AppSizes.size40,
              child: FloatingActionButton(
                onPressed: () async {
                  await NewStickerLayerDialog.show(context, paintJob, null,
                      (created) async {
                    await widget.layer.addLayer(created);
                    setState(() {});
                  });
                },
                tooltip: l.addSticker,
                heroTag: l.addSticker,
                child: ImageAssetService.getSvgIconSized(
                    AppSizes.size20, AppSizes.size20, AppIcons.plus),
              ),
            ),
            const SizedBox(
              height: AppSizes.size10,
            ),
            SizedBox(
              height: AppSizes.size40,
              width: AppSizes.size40,
              child: FloatingActionButton(
                onPressed: () async {
                  await NewLayerSeparatorDialog.show(context, paintJob, null,
                      (created) async {
                    await widget.layer.addLayer(created);
                    setState(() {});
                  });
                },
                tooltip: l.addSeparator,
                heroTag: l.addSeparator,
                child: ImageAssetService.getSvgIconSized(
                    AppSizes.size20, AppSizes.size20, AppIcons.separator),
              ),
            ),
            const SizedBox(
              height: AppSizes.size10,
            ),
            SizedBox(
              height: AppSizes.size40,
              width: AppSizes.size40,
              child: FloatingActionButton(
                onPressed: () async {
                  await NewCombinedLayerDialog.show(context, null,
                      (created) async {
                    await widget.layer.addLayer(created);
                    setState(() {});
                  });
                },
                tooltip: l.addCombinedLayer,
                heroTag: l.addCombinedLayer,
                child: ImageAssetService.getSvgIconSized(
                    AppSizes.size30, AppSizes.size30, AppIcons.plusCombined),
              ),
            ),
            const SizedBox(
              height: AppSizes.size10,
            ),
            FloatingActionButton(
              onPressed: () async => {
                await NewPaintLayerDialog.show(context, true, null,
                    (created) async {
                  await widget.layer.addLayer(created);
                  setState(() {});
                })
              },
              tooltip: l.addPaintJob,
              heroTag: l.addPaintJob,
              child: ImageAssetService.getSvgIconSized(
                  AppSizes.size40, AppSizes.size40, AppIcons.plus),
            ),
          ],
        ));
  }
}
