import 'package:flutter/cupertino.dart';
import 'package:reactive_forms/reactive_forms.dart';

import '../views/design/updatable_image.dart';

class MustHaveImage extends Validator<dynamic> {
  final GlobalKey<UpdatableImageState> imageKey;

  MustHaveImage({
    required this.imageKey,
  }) : super();

  @override
  Map<String, dynamic>? validate(AbstractControl<dynamic> control) {
    final form = control as FormGroup;
    if (imageKey.currentState?.imagePath == null) {
      form.setErrors({'haveImage': true});
      // force messages to show up as soon as possible
      form.markAsTouched();
    } else {
      form.removeError('haveImage');
    }
    return null;
  }
}
