import 'dart:convert';
import 'dart:io';

import 'package:image_picker/image_picker.dart';
import 'package:path/path.dart' as p;
import 'package:path_provider/path_provider.dart';
import 'package:uuid/v4.dart';

class FileStorageService {
  Future<XFile?> moveFileToAppStorage(XFile? imageFile) async {
    if (imageFile != null) {
      var appDir = (await getApplicationDocumentsDirectory()).path;
      var extension = p.extension(imageFile.path);
      var newPath = "$appDir/${UuidV4().generate()}$extension";
      File(imageFile.path).copySync(newPath);
      return XFile(newPath);
    }
    return null;
  }

  filePathToBase64(String? path) {
    if (path != null) {
      File file = File(path);
      List<int> fileInByte = file.readAsBytesSync();
      return base64Encode(fileInByte);
    }
  }

  base64toFile(String? imagePath, String? base64) {
    if (imagePath != null && !File(imagePath).existsSync()) {
      File(imagePath).createSync(recursive: true);
      File image = File(imagePath);
      image.writeAsBytes(base64Decode(base64!));
      // not really useful but allow for more concise usage
      return imagePath;
    }
    return imagePath;
  }
}
