import 'dart:developer';

import 'package:csv/csv.dart';
import 'package:flutter/services.dart';

import 'hive_models.dart';

class PaintLoader {
  static Future<void> loadCitadelPaintList(
      HiveRepository<BasePaint> paintRepo) async {
    final rawData = await rootBundle
        .loadString("assets/paints/citadel/sorted_paints_images.csv");

    List<List<dynamic>> listData =
        const CsvToListConverter(eol: '\n').convert(rawData);
    // removes title column
    listData.removeAt(0);
    for (var rowAct in listData) {
      try {
        final created = Paint(
            manufacturer: PaintManufacturer.citadel,
            type: rowAct[0].toString(),
            name: rowAct[1].toString(),
            image: rowAct[5].toString(),
            h: rowAct[2],
            s: rowAct[3],
            v: rowAct[4]);
        await paintRepo.put(rowAct[1].toString(), created);
      } catch (e) {
        log('Error while parsing $rowAct skipping', error: e);
      }
    }
  }

  static Future<void> loadTamiyaPaintList(
      HiveRepository<BasePaint> paintRepo) async {
    final rawData = await rootBundle
        .loadString("assets/paints/tamiya/result_tamiya_extract.csv");

    List<List<dynamic>> listData =
        const CsvToListConverter(eol: '\n').convert(rawData);
    // removes title column
    listData.removeAt(0);
    for (var rowAct in listData) {
      try {
        final String? type = rowAct[0]?.toString();
        final String? name = (rowAct[6] != null && rowAct[5] != null)
            ? '${rowAct[6]} ${rowAct[5]}'
            : null;

        if (type == null ||
            type.isEmpty ||
            name == null ||
            name.isEmpty ||
            rowAct[2] == null ||
            rowAct[3] == null ||
            rowAct[4] == null) {
          log('Missing data for $rowAct skipping');
        }
        final created = Paint(
            manufacturer: PaintManufacturer.tamiya,
            type: type!,
            name: name!,
            h: rowAct[2],
            s: rowAct[3],
            v: rowAct[4]);
        await paintRepo.put("${rowAct[1]}_tamiya", created);
      } catch (e) {
        log('Error while parsing $rowAct skipping e', error: e);
      }
    }
  }
}
