/// Enumeration representing different parts of a crop area.
enum CropAreaPart {
  /// Represents no specific part of the crop area.
  none,

  /// Represents the top-left corner of the crop area.
  topLeft,

  /// Represents the top-right corner of the crop area.
  topRight,

  /// Represents the bottom-left corner of the crop area.
  bottomLeft,

  /// Represents the bottom-right corner of the crop area.
  bottomRight,

  /// Represents the left side of the crop area.
  left,

  /// Represents the right side of the crop area.
  right,

  /// Represents the top side of the crop area.
  top,

  /// Represents the bottom side of the crop area.
  bottom,

  /// Represents the inside area of the crop.
  inside,
}
