# Saracroche Android

> 📱 **Also available for iOS**: Check out [Saracroche iOS](https://github.com/cbouvat/saracroche-ios) for iPhone and iPad users!

## Description

Saracroche is an Android app that protects you from unwanted calls by blocking spam phone calls. It's designed to be simple, effective, and privacy-friendly.

## Features

- 🛡️ Automatically blocks numbers
- 📱 Native Android application
- 🔒 Privacy-respectful: no call data is collected
- 🔄 Regular updates of the number database

## Installation

### Google Play Store

[Saracroche is available on the Google Play Store](https://play.google.com/store/apps/details?id=com.cbouvat.android.saracroche)

### F-Droid

[Saracroche is also available on F-Droid](https://f-droid.org/en/packages/com.cbouvat.android.saracroche/)

### Building from Source
1. Clone the repository
2. Open the project in Android Studio
3. Sync the project with Gradle files
4. Build and run the project on your device or emulator

**Requirements:**
- Android Studio
- Android SDK API level 29 or higher
- Gradle 8.0+

## Technology Stack

- **Kotlin** - Primary programming language
- **Jetpack Compose** - Modern UI toolkit
- **MVVM Architecture** - Clean architecture pattern
- **Android Call Screening API** - For call blocking functionality

## List of prefix numbers

The list of prefix numbers is in `blocked-patterns.json` file in the repository.

## Contributing

Contributions are welcome! Here's how you can help:

1. Fork the repository
2. Create a new branch (`git checkout -b feature/amazing-feature`)
3. Commit your changes (`git commit -m 'Add some amazing feature'`)
4. Push to the branch (`git push origin feature/amazing-feature`)
5. Open a Pull Request

## Sponsorship

If you find Saracroche useful, consider sponsoring the project to help with maintenance and new features:

- [Sponsor and support on Saracroche.org](https://saracroche.org/fr/support)

## Star the Project ⭐

If you like Saracroche, please consider giving it a star on GitHub to show your support and help others discover the project.

## License

This project is licensed under the GNU General Public License v3.0 - see the [LICENSE](LICENSE) file for details.
