# Contributing to Saracroche Android

Thank you for considering contributing to Saracroche! We welcome contributions of all kinds, including bug fixes, feature requests, documentation improvements, and more.

## How to Contribute

### 1. Fork the Repository
- Navigate to the [Saracroche Android repository](https://github.com/cbouvat/saracroche-android).
- Click the "Fork" button to create your own copy of the repository.

### 2. Clone the Repository
- Clone your forked repository to your local machine:
  ```bash
  git clone https://github.com/your-username/saracroche-android.git
  cd saracroche-android
  ```

### 3. Create a Branch
- Create a new branch for your feature or bug fix:
  ```bash
  git checkout -b feature/your-feature-name
  ```

### 4. Make Changes
- Make your changes in the appropriate files.
- Follow the coding style and conventions used in the project.
- Ensure your changes are well-documented and tested.

### 5. Commit Your Changes
- Commit your changes with a clear and concise commit message:
  ```bash
  git add .
  git commit -m "Add a brief description of your changes"
  ```

### 6. Push Your Changes
- Push your changes to your forked repository:
  ```bash
  git push origin feature/your-feature-name
  ```

### 7. Open a Pull Request
- Navigate to the original Saracroche repository.
- Click the "New Pull Request" button.
- Select your branch and provide a detailed description of your changes.

## Code of Conduct

Please note that this project is governed by the [Code of Conduct](CODE_OF_CONDUCT.md). By participating, you agree to abide by its terms.

## Reporting Issues

If you encounter a bug or have a feature request, please open an issue in the [GitHub Issues](https://github.com/cbouvat/saracroche-android/issues) section. Provide as much detail as possible to help us address the issue.

## Development Environment

### Prerequisites
- Android Studio

### Building the Project
1. Open the project in Android Studio.
2. Select your target device or simulator.
3. Build and run the project.

## License

By contributing to Saracroche, you agree that your contributions will be licensed under the [GNU General Public License v3.0](LICENSE).
