// This code was autogenerated with `dbus-codegen-rust -c blocking -m None`, see https://github.com/diwic/dbus-rs
// https://github.com/flatpak/xdg-desktop-portal/blob/main/data/org.freedesktop.portal.RemoteDesktop.xml
use dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

pub trait OrgFreedesktopPortalRemoteDesktop {
    fn create_session(&self, options: arg::PropMap) -> Result<dbus::Path<'static>, dbus::Error>;
    fn select_devices(
        &self,
        session_handle: dbus::Path,
        options: arg::PropMap,
    ) -> Result<dbus::Path<'static>, dbus::Error>;
    fn start(
        &self,
        session_handle: dbus::Path,
        parent_window: &str,
        options: arg::PropMap,
    ) -> Result<dbus::Path<'static>, dbus::Error>;
    fn notify_pointer_motion(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
        dx: f64,
        dy: f64,
    ) -> Result<(), dbus::Error>;
    fn notify_pointer_motion_absolute(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
        stream: u32,
        x_: f64,
        y_: f64,
    ) -> Result<(), dbus::Error>;
    fn notify_pointer_button(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
        button: i32,
        state: u32,
    ) -> Result<(), dbus::Error>;
    fn notify_pointer_axis(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
        dx: f64,
        dy: f64,
    ) -> Result<(), dbus::Error>;
    fn notify_pointer_axis_discrete(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
        axis: u32,
        steps: i32,
    ) -> Result<(), dbus::Error>;
    fn notify_keyboard_keycode(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
        keycode: i32,
        state: u32,
    ) -> Result<(), dbus::Error>;
    fn notify_keyboard_keysym(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
        keysym: i32,
        state: u32,
    ) -> Result<(), dbus::Error>;
    fn notify_touch_down(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
        stream: u32,
        slot: u32,
        x_: f64,
        y_: f64,
    ) -> Result<(), dbus::Error>;
    fn notify_touch_motion(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
        stream: u32,
        slot: u32,
        x_: f64,
        y_: f64,
    ) -> Result<(), dbus::Error>;
    fn notify_touch_up(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
        slot: u32,
    ) -> Result<(), dbus::Error>;
    fn connect_to_eis(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
    ) -> Result<arg::OwnedFd, dbus::Error>;
    fn available_device_types(&self) -> Result<u32, dbus::Error>;
    fn version(&self) -> Result<u32, dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target = T>>
    OrgFreedesktopPortalRemoteDesktop for blocking::Proxy<'a, C>
{
    fn create_session(&self, options: arg::PropMap) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call(
            "org.freedesktop.portal.RemoteDesktop",
            "CreateSession",
            (options,),
        )
        .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn select_devices(
        &self,
        session_handle: dbus::Path,
        options: arg::PropMap,
    ) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call(
            "org.freedesktop.portal.RemoteDesktop",
            "SelectDevices",
            (session_handle, options),
        )
        .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn start(
        &self,
        session_handle: dbus::Path,
        parent_window: &str,
        options: arg::PropMap,
    ) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call(
            "org.freedesktop.portal.RemoteDesktop",
            "Start",
            (session_handle, parent_window, options),
        )
        .and_then(|r: (dbus::Path<'static>,)| Ok(r.0))
    }

    fn notify_pointer_motion(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
        dx: f64,
        dy: f64,
    ) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.portal.RemoteDesktop",
            "NotifyPointerMotion",
            (session_handle, options, dx, dy),
        )
    }

    fn notify_pointer_motion_absolute(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
        stream: u32,
        x_: f64,
        y_: f64,
    ) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.portal.RemoteDesktop",
            "NotifyPointerMotionAbsolute",
            (session_handle, options, stream, x_, y_),
        )
    }

    fn notify_pointer_button(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
        button: i32,
        state: u32,
    ) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.portal.RemoteDesktop",
            "NotifyPointerButton",
            (session_handle, options, button, state),
        )
    }

    fn notify_pointer_axis(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
        dx: f64,
        dy: f64,
    ) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.portal.RemoteDesktop",
            "NotifyPointerAxis",
            (session_handle, options, dx, dy),
        )
    }

    fn notify_pointer_axis_discrete(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
        axis: u32,
        steps: i32,
    ) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.portal.RemoteDesktop",
            "NotifyPointerAxisDiscrete",
            (session_handle, options, axis, steps),
        )
    }

    fn notify_keyboard_keycode(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
        keycode: i32,
        state: u32,
    ) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.portal.RemoteDesktop",
            "NotifyKeyboardKeycode",
            (session_handle, options, keycode, state),
        )
    }

    fn notify_keyboard_keysym(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
        keysym: i32,
        state: u32,
    ) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.portal.RemoteDesktop",
            "NotifyKeyboardKeysym",
            (session_handle, options, keysym, state),
        )
    }

    fn notify_touch_down(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
        stream: u32,
        slot: u32,
        x_: f64,
        y_: f64,
    ) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.portal.RemoteDesktop",
            "NotifyTouchDown",
            (session_handle, options, stream, slot, x_, y_),
        )
    }

    fn notify_touch_motion(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
        stream: u32,
        slot: u32,
        x_: f64,
        y_: f64,
    ) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.portal.RemoteDesktop",
            "NotifyTouchMotion",
            (session_handle, options, stream, slot, x_, y_),
        )
    }

    fn notify_touch_up(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
        slot: u32,
    ) -> Result<(), dbus::Error> {
        self.method_call(
            "org.freedesktop.portal.RemoteDesktop",
            "NotifyTouchUp",
            (session_handle, options, slot),
        )
    }

    fn connect_to_eis(
        &self,
        session_handle: &dbus::Path,
        options: arg::PropMap,
    ) -> Result<arg::OwnedFd, dbus::Error> {
        self.method_call(
            "org.freedesktop.portal.RemoteDesktop",
            "ConnectToEIS",
            (session_handle, options),
        )
        .and_then(|r: (arg::OwnedFd,)| Ok(r.0))
    }

    fn available_device_types(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.portal.RemoteDesktop",
            "AvailableDeviceTypes",
        )
    }

    fn version(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(
            &self,
            "org.freedesktop.portal.RemoteDesktop",
            "version",
        )
    }
}
