# Beiträge zu RustDesk

RustDesk begrüßt Beiträge von jedem. Hier sind die Richtlinien, wenn Sie uns
helfen möchten:

## Beiträge

Beiträge zu RustDesk oder seinen Abhängigkeiten sollten in Form von Pull
Requests auf GitHub erfolgen. Jeder Pull Request wird von einem Hauptakteur
(jemand mit der Erlaubnis, Korrekturen einzubringen) geprüft und entweder in den
Hauptbaum eingefügt oder Feedback für notwendige Änderungen gegeben. Alle
Beiträge sollten diesem Format folgen, auch die von Hauptakteuren.

Wenn Sie an einem Problem arbeiten möchten, melden Sie es bitte zuerst an, indem
Sie auf GitHub erklären, dass Sie daran arbeiten möchten. Damit soll verhindert
werden, dass Beiträge zum gleichen Thema doppelt bearbeitet werden.

## Checkliste für Pull Requests

- Verzweigen Sie sich vom Master-Branch und, falls nötig, wechseln Sie zum
  aktuellen Master-Branch, bevor Sie Ihren Pull Request einreichen. Wenn das
  Zusammenführen mit dem Master nicht reibungslos funktioniert, werden Sie
  möglicherweise aufgefordert, Ihre Änderungen zu überarbeiten.

- Commits sollten so klein wie möglich sein und gleichzeitig sicherstellen, dass
  jeder Commit unabhängig voneinander korrekt ist (d. h., jeder Commit sollte
  sich übersetzen lassen und Tests bestehen).

- Commits sollten von einem "Herkunftszertifikat für Entwickler"
  (https://developercertificate.org) begleitet werden, das besagt, dass Sie (und
  ggf. Ihr Arbeitgeber) mit den Bedingungen der [Projektlizenz](../LICENCE)
  einverstanden sind. In Git ist dies die Option `-s` für `git commit`.

- Wenn Ihr Patch nicht begutachtet wird oder Sie eine bestimmte Person zur
  Begutachtung benötigen, können Sie einem Gutachter mit @ antworten und um eine
  Begutachtung des Pull Requests oder einen Kommentar bitten. Sie können auch
  per [E-Mail](mailto:info@rustdesk.com) um eine Begutachtung bitten.

- Fügen Sie Tests hinzu, die sich auf den behobenen Fehler oder die neue
  Funktion beziehen.

Spezifische Git-Anweisungen finden Sie im [GitHub-Workflow](https://github.com/servo/servo/wiki/GitHub-workflow).

## Verhalten

https://github.com/rustdesk/rustdesk/blob/master/docs/CODE_OF_CONDUCT.md

## Kommunikation

RustDesk-Mitarbeiter arbeiten häufig im [Discord](https://discord.gg/nDceKgxnkV).
