# Bijdragen aan RustDesk

RustDesk verwelkomt bijdragen van iedereen. Hier zijn de richtlijnen als u denkt 
ons te willen helpen:

## Bijdragen

Bijdragen aan RustDesk of haar afhankelijkheden moeten worden gedaan in de 
vorm van GitHub pull verzoeken. Elk pull verzoek zal worden beoordeeld door 
een core bijdrager (iemand met toestemming om patches te plaatsen) en ofwel 
worden geplaatst in de hoofd structuur of feedback krijgen voor veranderingen 
die nodig zouden zijn. Alle bijdragen zouden dit formaat moeten volgen, 
zelfs die van kernmedewerkers.

Als je aan een onderwerp wilt werken, eis het dan eerst op door commentaar 
te geven op het GitHub onderwerp dat je eraan wilt werken. Dit is om dubbele 
inspanningen van medewerkers aan hetzelfde issue te voorkomen.

## Checklist Pull Aanvragen

- Maak een vertakking vanaf de master tak en, indien nodig, veranker naar de
  huidige master tak voordat je je pull verzoek indient. Als je het niet netjes 
  samenvoegt met master kan je gevraagd worden om je wijzigingen 
  opnieuw op te bouwen.

- Toezeggingen moeten zo klein mogelijk zijn, terwijl er voor gezorgd moet 
  worden dat elke toezegging onafhankelijk correct is (dat wil zeggen, elke 
  toezegging moet compileren en testen doorstaan).

- Toezeggingen moeten vergezeld gaan van een Certificaat van Oorsprong 
  van de Ontwikkelaar (http://developercertificate.org) ondertekening, die aangeeft 
  dat u (en uw werkgever indien van toepassing) akkoord gaat met de 
  voorwaarden van het [project licentie](../LICENCE). 
  In git is dit de `-s` optie van `git commit`

- Als je patch niet beoordeeld wordt of je hebt een specifiek persoon nodig om hem 
  te beoordelen kunt u @-reply een reviewer vragen in het pull verzoek of een
  commentaar, of je kunt om een review vragen via [email](mailto:info@rustdesk.com).

- Tests toevoegen die relevant zijn voor de gerepareerde bug of de nieuwe functie.

Voor specifieke git instructies, zie [GitHub workflow 101](https://github.com/servo/servo/wiki/GitHub-workflow).

## Gedrag

https://github.com/rustdesk/rustdesk/blob/master/docs/CODE_OF_CONDUCT.md

## Communicatie

RustDesk medewerkers bezoeken frequent [Discord](https://discord.gg/nDceKgxnkV).
