lazy_static::lazy_static! {
pub static ref T: std::collections::HashMap<&'static str, &'static str> =
    [
        ("Status", "Status"),
        ("Your Desktop", "Ihr Desktop"),
        ("desk_tip", "Mit dieser ID und diesem Passwort kann auf Ihren Desktop zugegriffen werden."),
        ("Password", "Passwort"),
        ("Ready", "Bereit"),
        ("Established", "Verbunden"),
        ("connecting_status", "Verbinden mit dem RustDesk-Netzwerk …"),
        ("Enable service", "Vermittlungsdienst aktivieren"),
        ("Start service", "Vermittlungsdienst starten"),
        ("Service is running", "Vermittlungsdienst aktiv"),
        ("Service is not running", "Vermittlungsdienst deaktiviert"),
        ("not_ready_status", "Nicht bereit. Bitte überprüfen Sie Ihre Netzwerkverbindung."),
        ("Control Remote Desktop", "Entfernten Desktop steuern"),
        ("Transfer file", "Datei übertragen"),
        ("Connect", "Verbinden"),
        ("Recent sessions", "Letzte Sitzungen"),
        ("Address book", "Adressbuch"),
        ("Confirmation", "Bestätigung"),
        ("TCP tunneling", "TCP-Tunnelung"),
        ("Remove", "Entfernen"),
        ("Refresh random password", "Zufälliges Passwort erzeugen"),
        ("Set your own password", "Eigenes Passwort festlegen"),
        ("Enable keyboard/mouse", "Tastatur und Maus aktivieren"),
        ("Enable clipboard", "Zwischenablage aktivieren"),
        ("Enable file transfer", "Dateiübertragung aktivieren"),
        ("Enable TCP tunneling", "TCP-Tunnelung aktivieren"),
        ("IP Whitelisting", "IP-Whitelist"),
        ("ID/Relay Server", "ID/Relay-Server"),
        ("Import server config", "Serverkonfiguration importieren"),
        ("Export Server Config", "Serverkonfiguration exportieren"),
        ("Import server configuration successfully", "Serverkonfiguration erfolgreich importiert"),
        ("Export server configuration successfully", "Serverkonfiguration erfolgreich exportiert"),
        ("Invalid server configuration", "Ungültige Serverkonfiguration"),
        ("Clipboard is empty", "Zwischenablage ist leer"),
        ("Stop service", "Vermittlungsdienst stoppen"),
        ("Change ID", "ID ändern"),
        ("Your new ID", "Ihre neue ID"),
        ("length %min% to %max%", "Länge %min% bis %max%"),
        ("starts with a letter", "Beginnt mit Buchstabe"),
        ("allowed characters", "Erlaubte Zeichen"),
        ("id_change_tip", "Nur die Zeichen a-z, A-Z, 0-9, - (Bindestrich) und _ (Unterstrich) sind erlaubt. Der erste Buchstabe muss a-z, A-Z sein und die Länge zwischen 6 und 16 Zeichen betragen."),
        ("Website", "Webseite"),
        ("About", "Über"),
        ("Slogan_tip", "Mit Herzblut programmiert - in einer Welt, die im Chaos versinkt!"),
        ("Privacy Statement", "Datenschutz"),
        ("Mute", "Stummschalten"),
        ("Build Date", "Erstelldatum"),
        ("Version", "Version"),
        ("Home", "Startseite"),
        ("Audio Input", "Audioeingang"),
        ("Enhancements", "Verbesserungen"),
        ("Hardware Codec", "Hardware-Codec"),
        ("Adaptive bitrate", "Bitrate automatisch anpassen"),
        ("ID Server", "ID-Server"),
        ("Relay Server", "Relay-Server"),
        ("API Server", "API-Server"),
        ("invalid_http", "Muss mit http:// oder https:// beginnen"),
        ("Invalid IP", "Ungültige IP-Adresse"),
        ("Invalid format", "Ungültiges Format"),
        ("server_not_support", "Diese Funktion wird noch nicht vom Server unterstützt."),
        ("Not available", "Nicht verfügbar"),
        ("Too frequent", "Zu häufig"),
        ("Cancel", "Abbrechen"),
        ("Skip", "Überspringen"),
        ("Close", "Schließen"),
        ("Retry", "Erneut versuchen"),
        ("OK", "OK"),
        ("Password Required", "Passwort erforderlich"),
        ("Please enter your password", "Bitte geben Sie Ihr Passwort ein"),
        ("Remember password", "Passwort merken"),
        ("Wrong Password", "Falsches Passwort"),
        ("Do you want to enter again?", "Erneut verbinden?"),
        ("Connection Error", "Verbindungsfehler"),
        ("Error", "Fehler"),
        ("Reset by the peer", "Verbindung wurde von der Gegenstelle zurückgesetzt."),
        ("Connecting...", "Verbindung wird hergestellt …"),
        ("Connection in progress. Please wait.", "Die Verbindung wird hergestellt. Bitte warten …"),
        ("Please try 1 minute later", "Bitte versuchen Sie es später erneut"),
        ("Login Error", "Anmeldefehler"),
        ("Successful", "Erfolgreich"),
        ("Connected, waiting for image...", "Verbindung hergestellt. Warte auf anderen Bildschirm …"),
        ("Name", "Name"),
        ("Type", "Typ"),
        ("Modified", "Geändert"),
        ("Size", "Größe"),
        ("Show Hidden Files", "Versteckte Dateien anzeigen"),
        ("Receive", "Empfangen"),
        ("Send", "Senden"),
        ("Refresh File", "Datei aktualisieren"),
        ("Local", "Lokal"),
        ("Remote", "Entfernt"),
        ("Remote Computer", "Entfernter Computer"),
        ("Local Computer", "Dieser Computer"),
        ("Confirm Delete", "Löschen bestätigen"),
        ("Delete", "Löschen"),
        ("Properties", "Eigenschaften"),
        ("Multi Select", "Mehrfachauswahl"),
        ("Select All", "Alles auswählen"),
        ("Unselect All", "Alles abwählen"),
        ("Empty Directory", "Leerer Ordner"),
        ("Not an empty directory", "Ordner ist nicht leer."),
        ("Are you sure you want to delete this file?", "Sind Sie sicher, dass Sie diese Datei löschen wollen?"),
        ("Are you sure you want to delete this empty directory?", "Sind Sie sicher, dass Sie diesen leeren Ordner löschen möchten?"),
        ("Are you sure you want to delete the file of this directory?", "Sind Sie sicher, dass Sie die Datei dieses Ordners löschen möchten?"),
        ("Do this for all conflicts", "Für alle Konflikte merken"),
        ("This is irreversible!", "Dies kann nicht rückgängig gemacht werden!"),
        ("Deleting", "Löschen"),
        ("files", "Dateien"),
        ("Waiting", "Warten"),
        ("Finished", "Fertiggestellt"),
        ("Speed", "Geschwindigkeit"),
        ("Custom Image Quality", "Benutzerdefinierte Bildqualität"),
        ("Privacy mode", "Datenschutzmodus"),
        ("Block user input", "Benutzereingaben blockieren"),
        ("Unblock user input", "Benutzereingaben freigeben"),
        ("Adjust Window", "Fenster anpassen"),
        ("Original", "Original"),
        ("Shrink", "Verkleinern"),
        ("Stretch", "Strecken"),
        ("Scrollbar", "Scroll-Leiste"),
        ("ScrollAuto", "Automatisch scrollen"),
        ("Good image quality", "Hohe Bildqualität"),
        ("Balanced", "Ausgeglichene Bildqualität"),
        ("Optimize reaction time", "Reaktionszeit optimieren"),
        ("Custom", "Benutzerdefiniert"),
        ("Show remote cursor", "Entfernten Cursor anzeigen"),
        ("Show quality monitor", "Qualitätsüberwachung anzeigen"),
        ("Disable clipboard", "Zwischenablage deaktivieren"),
        ("Lock after session end", "Nach Sitzungsende sperren"),
        ("Insert Ctrl + Alt + Del", "Strg + Alt + Entf senden"),
        ("Insert Lock", "Win+L (Sperren) senden"),
        ("Refresh", "Aktualisieren"),
        ("ID does not exist", "Diese ID existiert nicht."),
        ("Failed to connect to rendezvous server", "Verbindung zum Rendezvous-Server fehlgeschlagen"),
        ("Please try later", "Bitte versuchen Sie es später erneut."),
        ("Remote desktop is offline", "Entfernter Desktop ist offline."),
        ("Key mismatch", "Schlüssel stimmen nicht überein."),
        ("Timeout", "Zeitüberschreitung"),
        ("Failed to connect to relay server", "Verbindung zum Relay-Server ist fehlgeschlagen"),
        ("Failed to connect via rendezvous server", "Verbindung über Rendezvous-Server ist fehlgeschlagen"),
        ("Failed to connect via relay server", "Verbindung über Relay-Server ist fehlgeschlagen"),
        ("Failed to make direct connection to remote desktop", "Direkte Verbindung zum entfernten Desktop ist fehlgeschlagen"),
        ("Set Password", "Passwort festlegen"),
        ("OS Password", "Betriebssystem-Passwort"),
        ("install_tip", "Aufgrund der Benutzerkontensteuerung (UAC) kann RustDesk in manchen Fällen nicht ordnungsgemäß funktionieren. Um die Benutzerkontensteuerung zu umgehen, klicken Sie bitte auf die Schaltfläche unten und installieren RustDesk auf dem System."),
        ("Click to upgrade", "Zum Upgraden klicken"),
        ("Configure", "Konfigurieren"),
        ("config_acc", "Um Ihren PC aus der Ferne zu steuern, müssen Sie RustDesk Zugriffsrechte erteilen."),
        ("config_screen", "Um aus der Ferne auf Ihren PC zugreifen zu können, müssen Sie RustDesk die Berechtigung \"Bildschirmaufnahme\" erteilen."),
        ("Installing ...", "Wird installiert …"),
        ("Install", "Installieren"),
        ("Installation", "Installation"),
        ("Installation Path", "Installationspfad"),
        ("Create start menu shortcuts", "Verknüpfung im Startmenü erstellen"),
        ("Create desktop icon", "Desktop-Verknüpfung erstellen"),
        ("agreement_tip", "Durch die Installation akzeptieren Sie die Lizenzvereinbarung."),
        ("Accept and Install", "Akzeptieren und Installieren"),
        ("End-user license agreement", "Lizenzvereinbarung für Endbenutzer"),
        ("Generating ...", "Wird generiert …"),
        ("Your installation is lower version.", "Ihre Version ist veraltet."),
        ("not_close_tcp_tip", "Schließen Sie dieses Fenster nicht, solange Sie den Tunnel benutzen."),
        ("Listening ...", "Lauschen …"),
        ("Remote Host", "Entfernter PC"),
        ("Remote Port", "Entfernter Port"),
        ("Action", "Aktion"),
        ("Add", "Hinzufügen"),
        ("Local Port", "Lokaler Port"),
        ("Local Address", "Lokale Adresse"),
        ("Change Local Port", "Lokalen Port ändern"),
        ("setup_server_tip", "für eine schnellere Verbindung richten Sie bitte Ihren eigenen Server ein."),
        ("Too short, at least 6 characters.", "Zu kurz, mindestens 6 Zeichen."),
        ("The confirmation is not identical.", "Die Passwörter stimmen nicht überein."),
        ("Permissions", "Berechtigungen"),
        ("Accept", "Akzeptieren"),
        ("Dismiss", "Ablehnen"),
        ("Disconnect", "Verbindung trennen"),
        ("Enable file copy and paste", "Kopieren und Einfügen von Dateien zulassen"),
        ("Connected", "Verbunden"),
        ("Direct and encrypted connection", "Direkte und verschlüsselte Verbindung"),
        ("Relayed and encrypted connection", "Vermittelte und verschlüsselte Verbindung"),
        ("Direct and unencrypted connection", "Direkte und unverschlüsselte Verbindung"),
        ("Relayed and unencrypted connection", "Vermittelte und unverschlüsselte Verbindung"),
        ("Enter Remote ID", "Entfernte ID eingeben"),
        ("Enter your password", "Geben Sie Ihr Passwort ein"),
        ("Logging in...", "Anmelden …"),
        ("Enable RDP session sharing", "RDP-Sitzungsfreigabe aktivieren"),
        ("Auto Login", "Automatisch anmelden (nur gültig, wenn Sie \"Nach Sitzungsende sperren\" aktiviert haben)"),
        ("Enable direct IP access", "Direkten IP-Zugang aktivieren"),
        ("Rename", "Umbenennen"),
        ("Space", "Speicherplatz"),
        ("Create desktop shortcut", "Desktop-Verknüpfung erstellen"),
        ("Change Path", "Pfad ändern"),
        ("Create Folder", "Ordner erstellen"),
        ("Please enter the folder name", "Bitte geben Sie den Ordnernamen ein"),
        ("Fix it", "Reparieren"),
        ("Warning", "Warnung"),
        ("Login screen using Wayland is not supported", "Anmeldebildschirm mit Wayland wird nicht unterstützt."),
        ("Reboot required", "Neustart erforderlich"),
        ("Unsupported display server", "Nicht unterstützter Anzeigeserver"),
        ("x11 expected", "X11 erwartet"),
        ("Port", "Port"),
        ("Settings", "Einstellungen"),
        ("Username", "Benutzername"),
        ("Invalid port", "Ungültiger Port"),
        ("Closed manually by the peer", "Von der Gegenstelle manuell geschlossen."),
        ("Enable remote configuration modification", "Änderung der Konfiguration aus der Ferne zulassen"),
        ("Run without install", "Ohne Installation ausführen"),
        ("Connect via relay", "Über Relay-Server verbinden"),
        ("Always connect via relay", "Immer über Relay-Server verbinden"),
        ("whitelist_tip", "Nur IPs auf der Whitelist können zugreifen."),
        ("Login", "Anmelden"),
        ("Verify", "Überprüfen"),
        ("Remember me", "Login merken"),
        ("Trust this device", "Diesem Gerät vertrauen"),
        ("Verification code", "Verifizierungscode"),
        ("verification_tip", "Ein Verifizierungscode wurde an die registrierte E-Mail-Adresse gesendet. Geben Sie den Verifizierungscode ein, um sich erneut anzumelden."),
        ("Logout", "Abmelden"),
        ("Tags", "Tags"),
        ("Search ID", "ID suchen"),
        ("whitelist_sep", "Getrennt durch Komma, Semikolon, Leerzeichen oder Zeilenumbruch"),
        ("Add ID", "ID hinzufügen"),
        ("Add Tag", "Tag hinzufügen"),
        ("Unselect all tags", "Alle Tags abwählen"),
        ("Network error", "Netzwerkfehler"),
        ("Username missed", "Benutzername fehlt"),
        ("Password missed", "Passwort fehlt"),
        ("Wrong credentials", "Falsche Anmeldedaten"),
        ("The verification code is incorrect or has expired", "Der Verifizierungscode ist falsch oder abgelaufen"),
        ("Edit Tag", "Tag bearbeiten"),
        ("Forget Password", "Gespeichertes Passwort löschen"),
        ("Favorites", "Favoriten"),
        ("Add to Favorites", "Zu Favoriten hinzufügen"),
        ("Remove from Favorites", "Aus Favoriten entfernen"),
        ("Empty", "Keine Einträge"),
        ("Invalid folder name", "Ungültiger Ordnername"),
        ("Socks5 Proxy", "SOCKS5-Proxy"),
        ("Socks5/Http(s) Proxy", "SOCKS5/HTTP(S)-Proxy"),
        ("Discovered", "Im LAN erkannt"),
        ("install_daemon_tip", "Um mit System zu starten, muss der Systemdienst installiert sein."),
        ("Remote ID", "Entfernte ID"),
        ("Paste", "Einfügen"),
        ("Paste here?", "Hier einfügen?"),
        ("Are you sure to close the connection?", "Möchten Sie diese Verbindung wirklich schließen?"),
        ("Download new version", "Neue Version herunterladen"),
        ("Touch mode", "Touch-Modus"),
        ("Mouse mode", "Mausmodus"),
        ("One-Finger Tap", "1-Finger-Tipp"),
        ("Left Mouse", "Linksklick"),
        ("One-Long Tap", "1-Finger-Halten"),
        ("Two-Finger Tap", "2-Finger-Tipp"),
        ("Right Mouse", "Rechtsklick"),
        ("One-Finger Move", "Einen Finger bewegen"),
        ("Double Tap & Move", "Doppeltippen und bewegen"),
        ("Mouse Drag", "Maus bewegen"),
        ("Three-Finger vertically", "Drei Finger vertikal bewegen"),
        ("Mouse Wheel", "Mausrad"),
        ("Two-Finger Move", "Zwei Finger bewegen"),
        ("Canvas Move", "Sichtfeld bewegen"),
        ("Pinch to Zoom", "2-Finger-Zoom"),
        ("Canvas Zoom", "Sichtfeld-Zoom"),
        ("Reset canvas", "Sichtfeld zurücksetzen"),
        ("No permission of file transfer", "Keine Berechtigung für die Dateiübertragung"),
        ("Note", "Hinweis"),
        ("Connection", "Verbindung"),
        ("Share screen", "Bildschirm freigeben"),
        ("Chat", "Chat"),
        ("Total", "Gesamt"),
        ("items", "Einträge"),
        ("Selected", "ausgewählt"),
        ("Screen Capture", "Bildschirmaufnahme"),
        ("Input Control", "Eingabesteuerung"),
        ("Audio Capture", "Audioaufnahme"),
        ("Do you accept?", "Verbindung zulassen?"),
        ("Open System Setting", "Systemeinstellung öffnen"),
        ("How to get Android input permission?", "Wie erhalte ich eine Android-Eingabeberechtigung?"),
        ("android_input_permission_tip1", "Damit ein entferntes Gerät Ihr Android-Gerät steuern kann, müssen Sie RustDesk erlauben, den Dienst \"Barrierefreiheit\" zu verwenden."),
        ("android_input_permission_tip2", "Bitte gehen Sie zur nächsten Systemeinstellungsseite, suchen Sie \"Installierte Dienste\" und schalten Sie den Dienst \"RustDesk Input\" ein."),
        ("android_new_connection_tip", "möchte Ihr Gerät steuern."),
        ("android_service_will_start_tip", "Durch das Aktivieren der Bildschirmfreigabe wird der Dienst automatisch gestartet, sodass andere Geräte dieses Android-Gerät steuern können."),
        ("android_stop_service_tip", "Durch das Deaktivieren des Dienstes werden automatisch alle hergestellten Verbindungen getrennt."),
        ("android_version_audio_tip", "Ihre Android-Version unterstützt keine Audioaufnahme, bitte aktualisieren Sie auf Android 10 oder höher, falls möglich."),
        ("android_start_service_tip", "Tippen Sie auf \"Vermittlungsdienst starten\" oder aktivieren Sie die Berechtigung \"Bildschirmaufnahme\", um den Bildschirmfreigabedienst zu starten."),
        ("android_permission_may_not_change_tip", "Die Berechtigungen für bestehende Verbindungen werden erst nach einer erneuten Verbindung geändert."),
        ("Account", "Konto"),
        ("Overwrite", "Überschreiben"),
        ("This file exists, skip or overwrite this file?", "Diese Datei existiert; überspringen oder überschreiben?"),
        ("Quit", "Beenden"),
        ("Help", "Hilfe"),
        ("Failed", "Fehlgeschlagen"),
        ("Succeeded", "Erfolgreich"),
        ("Someone turns on privacy mode, exit", "Jemand hat den Datenschutzmodus aktiviert, wird beendet …"),
        ("Unsupported", "Nicht unterstützt"),
        ("Peer denied", "Die Gegenstelle hat die Verbindung abgelehnt."),
        ("Please install plugins", "Bitte installieren Sie Plugins"),
        ("Peer exit", "Die Gegenstelle hat die Verbindung getrennt."),
        ("Failed to turn off", "Ausschalten fehlgeschlagen"),
        ("Turned off", "Ausgeschaltet"),
        ("Language", "Sprache"),
        ("Keep RustDesk background service", "RustDesk im Hintergrund ausführen"),
        ("Ignore Battery Optimizations", "Akkuoptimierung ignorieren"),
        ("android_open_battery_optimizations_tip", "Möchten Sie die Einstellungen zur Akkuoptimierung öffnen?"),
        ("Start on boot", "Beim Booten starten"),
        ("Start the screen sharing service on boot, requires special permissions", "Bildschirmfreigabedienst beim Booten starten, erfordert zusätzliche Berechtigungen"),
        ("Connection not allowed", "Verbindung abgelehnt"),
        ("Legacy mode", "Kompatibilitätsmodus"),
        ("Map mode", "Zuordnungsmodus"),
        ("Translate mode", "Übersetzungsmodus"),
        ("Use permanent password", "Permanentes Passwort verwenden"),
        ("Use both passwords", "Beide Passwörter verwenden"),
        ("Set permanent password", "Permanentes Passwort festlegen"),
        ("Enable remote restart", "Entfernten Neustart aktivieren"),
        ("Restart remote device", "Entferntes Gerät neu starten"),
        ("Are you sure you want to restart", "Möchten Sie das entfernte Gerät wirklich neu starten?"),
        ("Restarting remote device", "Entferntes Gerät wird neu gestartet"),
        ("remote_restarting_tip", "Entferntes Gerät startet neu, bitte schließen Sie diese Meldung und verbinden Sie sich mit dem permanenten Passwort erneut."),
        ("Copied", "Kopiert"),
        ("Exit Fullscreen", "Vollbild beenden"),
        ("Fullscreen", "Vollbild"),
        ("Mobile Actions", "Mobile Aktionen"),
        ("Select Monitor", "Bildschirm auswählen"),
        ("Control Actions", "Aktionen"),
        ("Display Settings", "Anzeigeeinstellungen"),
        ("Ratio", "Verhältnis"),
        ("Image Quality", "Bildqualität"),
        ("Scroll Style", "Scroll-Stil"),
        ("Show Toolbar", "Symbolleiste anzeigen"),
        ("Hide Toolbar", "Symbolleiste ausblenden"),
        ("Direct Connection", "Direkte Verbindung"),
        ("Relay Connection", "Relay-Verbindung"),
        ("Secure Connection", "Sichere Verbindung"),
        ("Insecure Connection", "Unsichere Verbindung"),
        ("Scale original", "Keine Skalierung"),
        ("Scale adaptive", "Anpassbare Skalierung"),
        ("General", "Allgemein"),
        ("Security", "Sicherheit"),
        ("Theme", "Farbgebung"),
        ("Dark Theme", "Dunkle Farbgebung"),
        ("Light Theme", "Helle Farbgebung"),
        ("Dark", "Dunkel"),
        ("Light", "Hell"),
        ("Follow System", "Systemstandard"),
        ("Enable hardware codec", "Hardware-Codec aktivieren"),
        ("Unlock Security Settings", "Sicherheitseinstellungen entsperren"),
        ("Enable audio", "Audio aktivieren"),
        ("Unlock Network Settings", "Netzwerkeinstellungen entsperren"),
        ("Server", "Server"),
        ("Direct IP Access", "Direkter IP-Zugang"),
        ("Proxy", "Proxy"),
        ("Apply", "Anwenden"),
        ("Disconnect all devices?", "Alle Geräte trennen?"),
        ("Clear", "Zurücksetzen"),
        ("Audio Input Device", "Audioeingabegerät"),
        ("Use IP Whitelisting", "IP-Whitelist verwenden"),
        ("Network", "Netzwerk"),
        ("Pin Toolbar", "Symbolleiste anpinnen"),
        ("Unpin Toolbar", "Symbolleiste lösen"),
        ("Recording", "Aufnahme"),
        ("Directory", "Verzeichnis"),
        ("Automatically record incoming sessions", "Eingehende Sitzungen automatisch aufzeichnen"),
        ("Automatically record outgoing sessions", "Ausgehende Sitzungen automatisch aufzeichnen"),
        ("Change", "Ändern"),
        ("Start session recording", "Sitzungsaufzeichnung starten"),
        ("Stop session recording", "Sitzungsaufzeichnung beenden"),
        ("Enable recording session", "Sitzungsaufzeichnung aktivieren"),
        ("Enable LAN discovery", "LAN-Erkennung aktivieren"),
        ("Deny LAN discovery", "LAN-Erkennung verbieten"),
        ("Write a message", "Nachricht schreiben"),
        ("Prompt", "Meldung"),
        ("Please wait for confirmation of UAC...", "Bitte auf die Bestätigung des Nutzers warten …"),
        ("elevated_foreground_window_tip", "Das aktuell geöffnete Fenster des ferngesteuerten Computers erfordert höhere Rechte. Deshalb ist es derzeit nicht möglich, die Maus und die Tastatur zu verwenden. Bitten Sie den Nutzer, dessen Computer Sie fernsteuern, das Fenster zu minimieren oder die Rechte zu erhöhen. Um dieses Problem zukünftig zu vermeiden, wird empfohlen, die Software auf dem ferngesteuerten Computer zu installieren."),
        ("Disconnected", "Verbindung abgebrochen"),
        ("Other", "Weitere Einstellungen"),
        ("Confirm before closing multiple tabs", "Nachfragen, wenn mehrere Tabs geschlossen werden"),
        ("Keyboard Settings", "Tastatureinstellungen"),
        ("Full Access", "Vollzugriff"),
        ("Screen Share", "Bildschirmfreigabe"),
        ("Wayland requires Ubuntu 21.04 or higher version.", "Wayland erfordert Ubuntu 21.04 oder eine höhere Version."),
        ("Wayland requires higher version of linux distro. Please try X11 desktop or change your OS.", "Wayland erfordert eine höhere Version der Linux-Distribution. Bitte versuchen Sie den X11-Desktop oder ändern Sie Ihr Betriebssystem."),
        ("JumpLink", "View"),
        ("Please Select the screen to be shared(Operate on the peer side).", "Bitte wählen Sie den freizugebenden Bildschirm aus (Bedienung auf der Gegenseite)."),
        ("Show RustDesk", "RustDesk anzeigen"),
        ("This PC", "Dieser PC"),
        ("or", "oder"),
        ("Continue with", "Fortfahren mit"),
        ("Elevate", "Zugriff gewähren"),
        ("Zoom cursor", "Cursor vergrößern"),
        ("Accept sessions via password", "Sitzung mit Passwort bestätigen"),
        ("Accept sessions via click", "Sitzung mit einem Klick bestätigen"),
        ("Accept sessions via both", "Sitzung mit Klick und Passwort bestätigen"),
        ("Please wait for the remote side to accept your session request...", "Bitte warten Sie, bis die Gegenseite Ihre Sitzungsanfrage akzeptiert hat …"),
        ("One-time Password", "Einmalpasswort"),
        ("Use one-time password", "Einmalpasswort verwenden"),
        ("One-time password length", "Länge des Einmalpassworts"),
        ("Request access to your device", "Zugriff auf Ihr Gerät anfordern"),
        ("Hide connection management window", "Fenster zur Verwaltung der Verbindung verstecken"),
        ("hide_cm_tip", "Dies ist nur möglich, wenn der Zugriff über ein permanentes Passwort erfolgt."),
        ("wayland_experiment_tip", "Die Unterstützung von Wayland ist nur experimentell. Bitte nutzen Sie X11, wenn Sie einen unbeaufsichtigten Zugriff benötigen."),
        ("Right click to select tabs", "Tabs mit rechtem Mausklick auswählen"),
        ("Skipped", "Übersprungen"),
        ("Add to address book", "Zum Adressbuch hinzufügen"),
        ("Group", "Gruppe"),
        ("Search", "Suchen"),
        ("Closed manually by web console", "Manuell über die Webkonsole geschlossen"),
        ("Local keyboard type", "Lokaler Tastaturtyp"),
        ("Select local keyboard type", "Lokalen Tastaturtyp auswählen"),
        ("software_render_tip", "Wenn Sie eine Nvidia-Grafikkarte unter Linux verwenden und sich das entfernte Fenster sofort nach dem Verbindungsaufbau schließt, kann ein Wechsel zum Open-Source-Treiber Nouveau und die Verwendung von Software-Rendering helfen. Ein Neustart der Software ist erforderlich."),
        ("Always use software rendering", "Software-Rendering immer verwenden"),
        ("config_input", "Um den entfernten Desktop mit der Tastatur steuern zu können, müssen Sie RustDesk die Berechtigung \"Eingabeüberwachung\" erteilen."),
        ("config_microphone", "Um aus der Ferne sprechen zu können, müssen Sie RustDesk die Berechtigung \"Audio aufzeichnen\" erteilen."),
        ("request_elevation_tip", "Sie können auch erhöhte Rechte anfordern, wenn sich jemand auf der Gegenseite befindet."),
        ("Wait", "Warten"),
        ("Elevation Error", "Berechtigungsfehler"),
        ("Ask the remote user for authentication", "Den entfernten Benutzer zur Authentifizierung auffordern"),
        ("Choose this if the remote account is administrator", "Wählen Sie dies, wenn das entfernte Konto Administrator ist."),
        ("Transmit the username and password of administrator", "Benutzernamen und Passwort des Administrators übertragen"),
        ("still_click_uac_tip", "Der entfernte Benutzer muss immer noch im UAC-Fenster von RustDesk auf \"Ja\" klicken."),
        ("Request Elevation", "Erhöhte Rechte anfordern"),
        ("wait_accept_uac_tip", "Bitte warten Sie, bis der entfernte Benutzer den UAC-Dialog akzeptiert hat."),
        ("Elevate successfully", "Erhöhung der Rechte erfolgreich"),
        ("uppercase", "Großbuchstaben"),
        ("lowercase", "Kleinbuchstaben"),
        ("digit", "Ziffern"),
        ("special character", "Sonderzeichen"),
        ("length>=8", "Länge ≥ 8"),
        ("Weak", "Schwach"),
        ("Medium", "Mittel"),
        ("Strong", "Stark"),
        ("Switch Sides", "Seiten wechseln"),
        ("Please confirm if you want to share your desktop?", "Bitte bestätigen Sie, wenn Sie Ihren Desktop freigeben möchten."),
        ("Display", "Bildschirm"),
        ("Default View Style", "Standard-Ansichtsstil"),
        ("Default Scroll Style", "Standard-Scroll-Stil"),
        ("Default Image Quality", "Standard-Bildqualität"),
        ("Default Codec", "Standard-Codec"),
        ("Bitrate", "Bitrate"),
        ("FPS", "fps"),
        ("Auto", "Automatisch"),
        ("Other Default Options", "Weitere Standardeinstellungen"),
        ("Voice call", "Sprachanruf"),
        ("Text chat", "Text-Chat"),
        ("Stop voice call", "Sprachanruf beenden"),
        ("relay_hint_tip", "Wenn eine direkte Verbindung nicht möglich ist, können Sie versuchen, eine Verbindung über einen Relay-Server herzustellen.\nWenn Sie eine Relay-Verbindung beim ersten Versuch herstellen möchten, können Sie das Suffix \"/r\" an die ID anhängen oder die Option \"Immer über Relay-Server verbinden\" in der Liste der letzten Sitzungen auswählen, sofern diese vorhanden ist."),
        ("Reconnect", "Erneut verbinden"),
        ("Codec", "Codec"),
        ("Resolution", "Auflösung"),
        ("No transfers in progress", "Keine Übertragungen im Gange"),
        ("Set one-time password length", "Länge des Einmalpassworts festlegen"),
        ("RDP Settings", "RDP-Einstellungen"),
        ("Sort by", "Sortieren nach"),
        ("New Connection", "Neue Verbindung"),
        ("Restore", "Verkleinern"),
        ("Minimize", "Minimieren"),
        ("Maximize", "Maximieren"),
        ("Your Device", "Ihr Gerät"),
        ("empty_recent_tip", "Ups, keine aktuellen Sitzungen!\nZeit, eine neue zu planen."),
        ("empty_favorite_tip", "Noch keine favorisierte Gegenstelle?\nLassen Sie uns jemanden finden, mit dem wir uns verbinden können und fügen Sie ihn zu Ihren Favoriten hinzu!"),
        ("empty_lan_tip", "Oh nein, es sieht so aus, als hätten wir noch keine Gegenstelle entdeckt."),
        ("empty_address_book_tip", "Oh je, es scheint, dass in Ihrem Adressbuch derzeit keine Gegenstellen aufgeführt sind."),
        ("Empty Username", "Leerer Benutzername"),
        ("Empty Password", "Leeres Passwort"),
        ("Me", "Ich"),
        ("identical_file_tip", "Diese Datei ist identisch mit der Datei der Gegenstelle."),
        ("show_monitors_tip", "Bildschirme in der Symbolleiste anzeigen"),
        ("View Mode", "Ansichtsmodus"),
        ("login_linux_tip", "Sie müssen sich an einem entfernten Linux-Konto anmelden, um eine X-Desktop-Sitzung zu eröffnen."),
        ("verify_rustdesk_password_tip", "RustDesk-Passwort bestätigen"),
        ("remember_account_tip", "Dieses Konto merken"),
        ("os_account_desk_tip", "Dieses Konto wird verwendet, um sich beim entfernten Betriebssystem anzumelden und die Desktop-Sitzung im Headless-Modus zu aktivieren."),
        ("OS Account", "Betriebssystem-Konto"),
        ("another_user_login_title_tip", "Ein anderer Benutzer ist bereits angemeldet."),
        ("another_user_login_text_tip", "Trennen"),
        ("xorg_not_found_title_tip", "Xorg nicht gefunden."),
        ("xorg_not_found_text_tip", "Bitte installieren Sie Xorg."),
        ("no_desktop_title_tip", "Es ist keine Desktopumgebung verfügbar."),
        ("no_desktop_text_tip", "Bitte installieren Sie den GNOME-Desktop."),
        ("No need to elevate", "Erhöhung der Rechte nicht erforderlich"),
        ("System Sound", "Systemsound"),
        ("Default", "Systemstandard"),
        ("New RDP", "Neue RDP-Verbindung"),
        ("Fingerprint", "Fingerabdruck"),
        ("Copy Fingerprint", "Fingerabdruck kopieren"),
        ("no fingerprints", "Keine Fingerabdrücke"),
        ("Select a peer", "Gegenstelle auswählen"),
        ("Select peers", "Gegenstellen auswählen"),
        ("Plugins", "Plugins"),
        ("Uninstall", "Deinstallieren"),
        ("Update", "Update"),
        ("Enable", "Aktivieren"),
        ("Disable", "Deaktivieren"),
        ("Options", "Einstellungen"),
        ("resolution_original_tip", "Originale Auflösung"),
        ("resolution_fit_local_tip", "Lokale Auflösung anpassen"),
        ("resolution_custom_tip", "Benutzerdefinierte Auflösung"),
        ("Collapse toolbar", "Symbolleiste einklappen"),
        ("Accept and Elevate", "Akzeptieren und Rechte erhöhen"),
        ("accept_and_elevate_btn_tooltip", "Akzeptieren Sie die Verbindung und erhöhen Sie die UAC-Berechtigungen."),
        ("clipboard_wait_response_timeout_tip", "Zeitüberschreitung beim Warten auf die Antwort der Kopie."),
        ("Incoming connection", "Eingehende Verbindung"),
        ("Outgoing connection", "Ausgehende Verbindung"),
        ("Exit", "Beenden"),
        ("Open", "Öffnen"),
        ("logout_tip", "Sind Sie sicher, dass Sie sich abmelden wollen?"),
        ("Service", "Vermittlungsdienst"),
        ("Start", "Starten"),
        ("Stop", "Stopp"),
        ("exceed_max_devices", "Sie haben die maximale Anzahl der verwalteten Geräte erreicht."),
        ("Sync with recent sessions", "Synchronisierung mit den letzten Sitzungen"),
        ("Sort tags", "Tags sortieren"),
        ("Open connection in new tab", "Verbindung in neuem Tab öffnen"),
        ("Move tab to new window", "Tab in neues Fenster verschieben"),
        ("Can not be empty", "Darf nicht leer sein"),
        ("Already exists", "Existiert bereits"),
        ("Change Password", "Passwort ändern"),
        ("Refresh Password", "Passwort aktualisieren"),
        ("ID", "ID"),
        ("Grid View", "Rasteransicht"),
        ("List View", "Listenansicht"),
        ("Select", "Auswählen"),
        ("Toggle Tags", "Tags umschalten"),
        ("pull_ab_failed_tip", "Aktualisierung des Adressbuchs fehlgeschlagen"),
        ("push_ab_failed_tip", "Synchronisierung des Adressbuchs mit dem Server fehlgeschlagen"),
        ("synced_peer_readded_tip", "Die Geräte, die in den letzten Sitzungen vorhanden waren, werden erneut zum Adressbuch hinzugefügt."),
        ("Change Color", "Farbe ändern"),
        ("Primary Color", "Primärfarbe"),
        ("HSV Color", "HSV-Farbe"),
        ("Installation Successful!", "Installation erfolgreich!"),
        ("Installation failed!", "Installation fehlgeschlagen!"),
        ("Reverse mouse wheel", "Mausrad rückwärtsdrehen"),
        ("{} sessions", "{} Sitzungen"),
        ("scam_title", "Sie werden möglicherweise BETROGEN!"),
        ("scam_text1", "Wenn Sie mit jemandem telefonieren, den Sie NICHT KENNEN, dem Sie NICHT VERTRAUEN und der Sie gebeten hat, RustDesk zu benutzen und den Dienst zu starten, fahren Sie nicht fort und legen Sie sofort auf."),
        ("scam_text2", "Es handelt sich wahrscheinlich um einen Betrüger, der versucht, Ihr Geld oder andere private Informationen zu stehlen."),
        ("Don't show again", "Nicht mehr anzeigen"),
        ("I Agree", "Ich bin einverstanden"),
        ("Decline", "Ablehnen"),
        ("Timeout in minutes", "Zeitüberschreitung in Minuten"),
        ("auto_disconnect_option_tip", "Eingehende Sitzungen bei Benutzer-Inaktivität automatisch schließen"),
        ("Connection failed due to inactivity", "Automatische Trennung der Verbindung aufgrund von Inaktivität"),
        ("Check for software update on startup", "Beim Start auf Softwareaktualisierung prüfen"),
        ("upgrade_rustdesk_server_pro_to_{}_tip", "Bitte aktualisieren Sie RustDesk Server Pro auf die Version {} oder neuer!"),
        ("pull_group_failed_tip", "Aktualisierung der Gruppe fehlgeschlagen"),
        ("Filter by intersection", "Nach Schnittmenge filtern"),
        ("Remove wallpaper during incoming sessions", "Hintergrundbild bei eingehenden Sitzungen entfernen"),
        ("Test", "Testen"),
        ("display_is_plugged_out_msg", "Der Bildschirm ist nicht angeschlossen, schalten Sie auf den ersten Bildschirm um."),
        ("No displays", "Keine Bildschirme"),
        ("Open in new window", "In einem neuen Fenster öffnen"),
        ("Show displays as individual windows", "Jeden Bildschirm in einem eigenen Fenster anzeigen"),
        ("Use all my displays for the remote session", "Alle meine Bildschirme für die Fernsitzung verwenden"),
        ("selinux_tip", "SELinux ist auf Ihrem Gerät aktiviert, was dazu führen kann, dass RustDesk als kontrollierte Seite nicht richtig läuft."),
        ("Change view", "Ansicht ändern"),
        ("Big tiles", "Große Kacheln"),
        ("Small tiles", "Kleine Kacheln"),
        ("List", "Liste"),
        ("Virtual display", "Virtueller Bildschirm"),
        ("Plug out all", "Alle ausschalten"),
        ("True color (4:4:4)", "True Color (4:4:4)"),
        ("Enable blocking user input", "Blockieren von Benutzereingaben aktivieren"),
        ("id_input_tip", "Sie können eine ID, eine direkte IP oder eine Domäne mit einem Port (<domain>:<port>) eingeben.\nWenn Sie auf ein Gerät auf einem anderen Server zugreifen wollen, fügen Sie bitte die Serveradresse (<id>@<server_address>?key=<key_value>) hinzu, zum Beispiel\n9123456234@192.168.16.1:21117?key=5Qbwsde3unUcJBtrx9ZkvUmwFNoExHzpryHuPUdqlWM=.\nWenn Sie auf ein Gerät auf einem öffentlichen Server zugreifen wollen, geben Sie bitte \"<id>@public\" ein. Der Schlüssel wird für öffentliche Server nicht benötigt.\n\nWenn Sie bei der ersten Verbindung die Verwendung einer Relay-Verbindung erzwingen wollen, fügen Sie \"/r\" am Ende der ID hinzu, zum Beispiel \"9123456234/r\"."),
        ("privacy_mode_impl_mag_tip", "Modus 1"),
        ("privacy_mode_impl_virtual_display_tip", "Modus 2"),
        ("Enter privacy mode", "Datenschutzmodus aktivieren"),
        ("Exit privacy mode", "Datenschutzmodus beenden"),
        ("idd_not_support_under_win10_2004_tip", "Indirekter Grafiktreiber wird nicht unterstützt. Windows 10, Version 2004 oder neuer ist erforderlich."),
        ("input_source_1_tip", "Eingangsquelle 1"),
        ("input_source_2_tip", "Eingangsquelle 2"),
        ("Swap control-command key", "Steuerungs- und Befehlstasten tauschen"),
        ("swap-left-right-mouse", "Linke und rechte Maustaste tauschen"),
        ("2FA code", "2FA-Code"),
        ("More", "Mehr"),
        ("enable-2fa-title", "Zwei-Faktor-Authentifizierung aktivieren"),
        ("enable-2fa-desc", "Bitte richten Sie jetzt Ihren Authentifikator ein. Sie können eine Authentifizierungs-App wie Authy, Microsoft oder Google Authenticator auf Ihrem Telefon oder Desktop verwenden.\n\nScannen Sie den QR-Code mit Ihrer App und geben Sie den Code ein, den Ihre App anzeigt, um die Zwei-Faktor-Authentifizierung zu aktivieren."),
        ("wrong-2fa-code", "Der Code kann nicht verifiziert werden. Prüfen Sie, ob der Code und die lokalen Zeiteinstellungen korrekt sind."),
        ("enter-2fa-title", "Zwei-Faktor-Authentifizierung"),
        ("Email verification code must be 6 characters.", "Der E-Mail-Verifizierungscode muss aus 6 Zeichen bestehen."),
        ("2FA code must be 6 digits.", "Der 2FA-Code muss 6 Ziffern haben."),
        ("Multiple Windows sessions found", "Mehrere Windows-Sitzungen gefunden"),
        ("Please select the session you want to connect to", "Bitte wählen Sie die Sitzung, mit der Sie sich verbinden möchten"),
        ("powered_by_me", "Unterstützt von RustDesk"),
        ("outgoing_only_desk_tip", "Dies ist eine benutzerdefinierte Ausgabe von RustDesk.\nSie können eine Verbindung zu anderen Geräten herstellen, aber andere Geräte können keine Verbindung zu Ihrem Gerät herstellen."),
        ("preset_password_warning", "Dies ist eine benutzerdefinierte Ausgabe von RustDesk mit einem voreingestellten Passwort. Jeder, der dieses Passwort kennt, kann die volle Kontrolle über Ihr Gerät erlangen. Wenn Sie dies nicht beabsichtigen, deinstallieren Sie diese Software bitte umgehend."),
        ("Security Alert", "Sicherheitswarnung"),
        ("My address book", "Mein Adressbuch"),
        ("Personal", "Persönlich"),
        ("Owner", "Eigentümer"),
        ("Set shared password", "Geteiltes Passwort festlegen"),
        ("Exist in", "Existiert in …?"),
        ("Read-only", "Nur lesen"),
        ("Read/Write", "Lesen/Schreiben"),
        ("Full Control", "Vollständige Kontrolle"),
        ("share_warning_tip", "Die obigen Felder werden geteilt und sind für andere sichtbar."),
        ("Everyone", "Jeder"),
        ("ab_web_console_tip", "Mehr über Webkonsole"),
        ("allow-only-conn-window-open-tip", "Verbindung nur zulassen, wenn das RustDesk-Fenster geöffnet ist"),
        ("no_need_privacy_mode_no_physical_displays_tip", "Keine physischen Bildschirme; keine Notwendigkeit, den Datenschutzmodus zu verwenden."),
        ("Follow remote cursor", "Dem entfernten Cursor folgen"),
        ("Follow remote window focus", "Dem Fokus des entfernten Fensters folgen"),
        ("default_proxy_tip", "Standardprotokoll und -port sind SOCKS5 und 1080"),
        ("no_audio_input_device_tip", "Kein Audio-Eingabegerät gefunden."),
        ("Incoming", "Eingehend"),
        ("Outgoing", "Ausgehend"),
        ("Clear Wayland screen selection", "Wayland-Bildschirmauswahl löschen"),
        ("clear_Wayland_screen_selection_tip", "Nachdem Sie die Bildschirmauswahl gelöscht haben, können Sie den freizugebenden Bildschirm erneut auswählen."),
        ("confirm_clear_Wayland_screen_selection_tip", "Sind Sie sicher, dass Sie die Auswahl des Wayland-Bildschirms löschen möchten?"),
        ("android_new_voice_call_tip", "Eine neue Sprachanrufanfrage wurde empfangen. Wenn Sie die Anfrage annehmen, wird der Ton auf Sprachkommunikation umgeschaltet."),
        ("texture_render_tip", "Verwenden Sie Textur-Rendering, um die Bilder glatter zu machen. Sie können diese Option deaktivieren, wenn Sie Rendering-Probleme haben."),
        ("Use texture rendering", "Textur-Rendering verwenden"),
        ("Floating window", "Schwebendes Fenster"),
        ("floating_window_tip", "Es hilft dabei, RustDesk im Hintergrund auszuführen."),
        ("Keep screen on", "Bildschirm eingeschaltet lassen"),
        ("Never", "Niemals"),
        ("During controlled", "Wenn kontrolliert"),
        ("During service is on", "Wenn der Dienst läuft"),
        ("Capture screen using DirectX", "Bildschirm mit DirectX aufnehmen"),
        ("Back", "Zurück"),
        ("Apps", "Apps"),
        ("Volume up", "Lauter"),
        ("Volume down", "Leiser"),
        ("Power", "Power"),
        ("Telegram bot", "Telegram-Bot"),
        ("enable-bot-tip", "Wenn Sie diese Funktion aktivieren, können Sie den 2FA-Code von Ihrem Bot erhalten. Er kann auch als Verbindungsbenachrichtigung dienen."),
        ("enable-bot-desc", "1. Öffnen Sie einen Chat mit @BotFather.\n2. Senden Sie den Befehl \"/newbot\". Sie erhalten ein Token, nachdem Sie diesen Schritt abgeschlossen haben.\n3. Starten Sie einen Chat mit Ihrem neu erstellten Bot. Senden Sie eine Nachricht, die mit einem Schrägstrich (\"/\") beginnt, z. B. \"/hello\", um ihn zu aktivieren.\n"),
        ("cancel-2fa-confirm-tip", "Sind Sie sicher, dass Sie 2FA abbrechen möchten?"),
        ("cancel-bot-confirm-tip", "Sind Sie sicher, dass Sie Telegram-Bot abbrechen möchten?"),
        ("About RustDesk", "Über RustDesk"),
        ("Send clipboard keystrokes", "Tastenanschläge aus der Zwischenablage senden"),
        ("network_error_tip", "Bitte überprüfen Sie Ihre Netzwerkverbindung und versuchen Sie es dann erneut."),
        ("Unlock with PIN", "Mit PIN entsperren"),
        ("Requires at least {} characters", "Erfordert mindestens {} Zeichen"),
        ("Wrong PIN", "Falsche PIN"),
        ("Set PIN", "PIN festlegen"),
        ("Enable trusted devices", "Vertrauenswürdige Geräte aktivieren"),
        ("Manage trusted devices", "Vertrauenswürdige Geräte verwalten"),
        ("Platform", "Plattform"),
        ("Days remaining", "Verbleibende Tage"),
        ("enable-trusted-devices-tip", "2FA-Verifizierung auf vertrauenswürdigen Geräten überspringen"),
        ("Parent directory", "Übergeordnetes Verzeichnis"),
        ("Resume", "Fortsetzen"),
        ("Invalid file name", "Ungültiger Dateiname"),
        ("one-way-file-transfer-tip", "Die einseitige Dateiübertragung ist auf der kontrollierten Seite aktiviert."),
        ("Authentication Required", "Authentifizierung erforderlich"),
        ("Authenticate", "Authentifizieren"),
        ("web_id_input_tip", "Sie können eine ID auf demselben Server eingeben, direkter IP-Zugriff wird im Web-Client nicht unterstützt.\nWenn Sie auf ein Gerät auf einem anderen Server zugreifen wollen, fügen Sie bitte die Serveradresse (<id>@<server_address>?key=<key_value>) hinzu, zum Beispiel\n9123456234@192.168.16.1:21117?key=5Qbwsde3unUcJBtrx9ZkvUmwFNoExHzpryHuPUdqlWM=.\nWenn Sie auf ein Gerät auf einem öffentlichen Server zugreifen wollen, geben Sie bitte \"<id>@public\" ein. Der Schlüssel wird für öffentliche Server nicht benötigt."),
        ("Download", "Herunterladen"),
        ("Upload folder", "Ordner hochladen"),
        ("Upload files", "Dateien hochladen"),
        ("Clipboard is synchronized", "Zwischenablage ist synchronisiert"),
        ("Update client clipboard", "Client-Zwischenablage aktualisieren"),
        ("Untagged", "Unmarkiert"),
        ("new-version-of-{}-tip", "Es ist eine neue Version von {} verfügbar"),
        ("Accessible devices", "Erreichbare Geräte"),
        ("upgrade_remote_rustdesk_client_to_{}_tip", "Bitte aktualisieren Sie den RustDesk-Client auf der Remote-Seite auf Version {} oder neuer!"),
        ("d3d_render_tip", "Wenn das D3D-Rendering aktiviert ist, kann der entfernte Bildschirm auf manchen Rechnern schwarz sein."),
        ("Use D3D rendering", "D3D-Rendering verwenden"),
        ("Printer", "Drucker"),
        ("printer-os-requirement-tip", "Für die Funktion des Druckerausgangs ist Windows 10 oder höher erforderlich."),
        ("printer-requires-installed-{}-client-tip", "Um den entfernten Druck nutzen zu können, muss {} auf diesem Gerät installiert sein."),
        ("printer-{}-not-installed-tip", "Der Drucker {} ist nicht installiert."),
        ("printer-{}-ready-tip", "Der Drucker {} ist installiert und einsatzbereit."),
        ("Install {} Printer", "Drucker {} installieren"),
        ("Outgoing Print Jobs", "Ausgehende Druckaufträge"),
        ("Incoming Print Jobs", "Eingehende Druckaufträge"),
        ("Incoming Print Job", "Eingehender Druckauftrag"),
        ("use-the-default-printer-tip", "Standarddrucker verwenden"),
        ("use-the-selected-printer-tip", "Ausgewählten Drucker verwenden"),
        ("auto-print-tip", "Automatisch mit dem ausgewählten Drucker drucken"),
        ("print-incoming-job-confirm-tip", "Sie haben einen Druckauftrag aus der Ferne erhalten. Möchten Sie ihn bei sich selbst ausführen?"),
        ("remote-printing-disallowed-tile-tip", "Entferntes Drucken nicht erlaubt"),
        ("remote-printing-disallowed-text-tip", "Die Berechtigungseinstellungen der kontrollierten Seite verweigern den entfernten Druck."),
        ("save-settings-tip", "Einstellungen speichern"),
        ("dont-show-again-tip", "Nicht mehr anzeigen"),
        ("Take screenshot", "Screenshot aufnehmen"),
        ("Taking screenshot", "Screenshot aufnehmen …"),
        ("screenshot-merged-screen-not-supported-tip", "Das Zusammenführen von Screenshots von mehreren Bildschirmen wird derzeit nicht unterstützt. Bitte wechseln Sie zu einem einzelnen Bildschirm und versuchen Sie es erneut."),
        ("screenshot-action-tip", "Bitte wählen Sie aus, wie Sie mit dem Screenshot fortfahren möchten."),
        ("Save as", "Speichern unter"),
        ("Copy to clipboard", "In Zwischenablage kopieren"),
        ("Enable remote printer", "Entfernten Drucker aktivieren"),
        ("Downloading {}", "{} herunterladen"),
        ("{} Update", "{} aktualisieren"),
        ("{}-to-update-tip", "{} wird jetzt geschlossen und die neue Version installiert."),
        ("download-new-version-failed-tip", "Download fehlgeschlagen. Sie können es erneut versuchen oder auf die Schaltfläche \"Herunterladen\" klicken, um von der Versionsseite herunterzuladen und manuell zu aktualisieren."),
        ("Auto update", "Automatisch aktualisieren"),
        ("update-failed-check-msi-tip", "Prüfung der Installationsmethode fehlgeschlagen. Bitte klicken Sie auf die Schaltfläche \"Herunterladen\", um von der Versionsseite herunterzuladen und manuell zu aktualisieren."),
        ("websocket_tip", "Bei der Verwendung von WebSocket werden nur Relay-Verbindungen unterstützt."),
        ("Use WebSocket", "WebSocket verwenden"),
        ("Trackpad speed", "Geschwindigkeit des Trackpads"),
        ("Default trackpad speed", "Standardgeschwindigkeit des Trackpads"),
        ("Numeric one-time password", "Numerisches Einmalpasswort"),
        ("Enable IPv6 P2P connection", "IPv6-P2P-Verbindung aktivieren"),
        ("Enable UDP hole punching", "UDP-Hole-Punching aktivieren"),
        ("View camera", "Kamera anzeigen"),
        ("Enable camera", "Kamera zulassen"),
        ("No cameras", "Keine Kameras"),
        ("view_camera_unsupported_tip", "Das entfernte Gerät kann die Kamera nicht anzeigen."),
        ("Terminal", "Terminal"),
        ("Enable terminal", "Terminal zulassen"),
        ("New tab", "Neuer Tab"),
        ("Keep terminal sessions on disconnect", "Terminalsitzungen beim Trennen der Verbindung beibehalten"),
        ("Terminal (Run as administrator)", "Terminal (als Administrator ausführen)"),
        ("terminal-admin-login-tip", "Bitte geben Sie den Benutzernamen und das Passwort des Administrators der kontrollierten Seite ein."),
        ("Failed to get user token.", "Benutzer-Token konnte nicht abgerufen werden."),
        ("Incorrect username or password.", "Falscher Benutzername oder falsches Passwort."),
        ("The user is not an administrator.", "Der Benutzer ist kein Administrator."),
        ("Failed to check if the user is an administrator.", "Es konnte nicht geprüft werden, ob der Benutzer ein Administrator ist."),
        ("Supported only in the installed version.", "Wird nur in der installierten Version unterstützt."),
        ("elevation_username_tip", "Geben Sie Benutzername oder Domäne\\Benutzername ein"),
        ("Preparing for installation ...", "Installation wird vorbereitet …"),
        ("Show my cursor", "Meinen Cursor anzeigen"),
        ("Scale custom", "Benutzerdefinierte Skalierung"),
        ("Custom scale slider", "Schieberegler für benutzerdefinierte Skalierung"),
        ("Decrease", "Verringern"),
        ("Increase", "Erhöhen"),
        ("Show virtual mouse", "Virtuelle Maus anzeigen"),
        ("Virtual mouse size", "Virtuelle Mausgröße"),
        ("Small", "Klein"),
        ("Large", "Groß"),
        ("Show virtual joystick", "Virtuellen Joystick anzeigen"),
        ("Edit note", "Hinweis bearbeiten"),
        ("Alias", "Alias"),
        ("ScrollEdge", "Scrollen am Rand"),
        ("Allow insecure TLS fallback", "Unsicheres TLS-Fallback zulassen"),
        ("allow-insecure-tls-fallback-tip", "Standardmäßig überprüft RustDesk das Serverzertifikat für Protokolle, die TLS verwenden. Wenn diese Option aktiviert ist, überspringt RustDesk den Überprüfungsschritt und fährt im Falle eines Überprüfungsfehlers fort."),
        ("Disable UDP", "UDP deaktivieren"),
        ("disable-udp-tip", "Legt fest, ob nur TCP verwendet werden soll. Wenn diese Option aktiviert ist, verwendet RustDesk nicht mehr UDP 21116, sondern stattdessen TCP 21116."),
        ("server-oss-not-support-tip", "HINWEIS: RustDesk Server OSS enthält diese Funktion nicht."),
        ("input note here", "Hier eine Notiz eingeben"),
        ("note-at-conn-end-tip", "Am Ende der Verbindung um eine Notiz bitten."),
    ].iter().cloned().collect();
}
