#![allow(
    non_camel_case_types,
    unused,
    clippy::redundant_closure,
    clippy::useless_conversion,
    clippy::unit_arg,
    clippy::double_parens,
    non_snake_case,
    clippy::too_many_arguments
)]
// AUTO GENERATED FILE, DO NOT EDIT.
// Generated by `flutter_rust_bridge`@ 1.80.1.

use crate::flutter_ffi::*;
use core::panic::UnwindSafe;
use flutter_rust_bridge::rust2dart::IntoIntoDart;
use flutter_rust_bridge::*;
use std::ffi::c_void;
use std::sync::Arc;

// Section: imports

// Section: wire functions

fn wire_start_global_event_stream_impl(
    port_: MessagePort,
    app_type: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "start_global_event_stream",
            port: Some(port_),
            mode: FfiCallMode::Stream,
        },
        move || {
            let api_app_type = app_type.wire2api();
            move |task_callback| {
                start_global_event_stream(task_callback.stream_sink::<_, String>(), api_app_type)
            }
        },
    )
}
fn wire_stop_global_event_stream_impl(
    port_: MessagePort,
    app_type: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "stop_global_event_stream",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_app_type = app_type.wire2api();
            move |task_callback| Ok(stop_global_event_stream(api_app_type))
        },
    )
}
fn wire_host_stop_system_key_propagate_impl(
    port_: MessagePort,
    _stopped: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "host_stop_system_key_propagate",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api__stopped = _stopped.wire2api();
            move |task_callback| Ok(host_stop_system_key_propagate(api__stopped))
        },
    )
}
fn wire_peer_get_sessions_count_impl(
    id: impl Wire2Api<String> + UnwindSafe,
    conn_type: impl Wire2Api<i32> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "peer_get_sessions_count",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_id = id.wire2api();
            let api_conn_type = conn_type.wire2api();
            Ok(peer_get_sessions_count(api_id, api_conn_type))
        },
    )
}
fn wire_session_add_existed_sync_impl(
    id: impl Wire2Api<String> + UnwindSafe,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    displays: impl Wire2Api<Vec<i32>> + UnwindSafe,
    is_view_camera: impl Wire2Api<bool> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "session_add_existed_sync",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_id = id.wire2api();
            let api_session_id = session_id.wire2api();
            let api_displays = displays.wire2api();
            let api_is_view_camera = is_view_camera.wire2api();
            Ok(session_add_existed_sync(
                api_id,
                api_session_id,
                api_displays,
                api_is_view_camera,
            ))
        },
    )
}
fn wire_session_add_sync_impl(
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    id: impl Wire2Api<String> + UnwindSafe,
    is_file_transfer: impl Wire2Api<bool> + UnwindSafe,
    is_view_camera: impl Wire2Api<bool> + UnwindSafe,
    is_port_forward: impl Wire2Api<bool> + UnwindSafe,
    is_rdp: impl Wire2Api<bool> + UnwindSafe,
    switch_uuid: impl Wire2Api<String> + UnwindSafe,
    force_relay: impl Wire2Api<bool> + UnwindSafe,
    password: impl Wire2Api<String> + UnwindSafe,
    is_shared_password: impl Wire2Api<bool> + UnwindSafe,
    conn_token: impl Wire2Api<Option<String>> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "session_add_sync",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_id = id.wire2api();
            let api_is_file_transfer = is_file_transfer.wire2api();
            let api_is_view_camera = is_view_camera.wire2api();
            let api_is_port_forward = is_port_forward.wire2api();
            let api_is_rdp = is_rdp.wire2api();
            let api_switch_uuid = switch_uuid.wire2api();
            let api_force_relay = force_relay.wire2api();
            let api_password = password.wire2api();
            let api_is_shared_password = is_shared_password.wire2api();
            let api_conn_token = conn_token.wire2api();
            Ok(session_add_sync(
                api_session_id,
                api_id,
                api_is_file_transfer,
                api_is_view_camera,
                api_is_port_forward,
                api_is_rdp,
                api_switch_uuid,
                api_force_relay,
                api_password,
                api_is_shared_password,
                api_conn_token,
            ))
        },
    )
}
fn wire_session_start_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    id: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_start",
            port: Some(port_),
            mode: FfiCallMode::Stream,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_id = id.wire2api();
            move |task_callback| {
                session_start(
                    task_callback.stream_sink::<_, EventToUI>(),
                    api_session_id,
                    api_id,
                )
            }
        },
    )
}
fn wire_session_start_with_displays_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    id: impl Wire2Api<String> + UnwindSafe,
    displays: impl Wire2Api<Vec<i32>> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_start_with_displays",
            port: Some(port_),
            mode: FfiCallMode::Stream,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_id = id.wire2api();
            let api_displays = displays.wire2api();
            move |task_callback| {
                session_start_with_displays(
                    task_callback.stream_sink::<_, EventToUI>(),
                    api_session_id,
                    api_id,
                    api_displays,
                )
            }
        },
    )
}
fn wire_session_get_remember_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, Option<bool>>(
        WrapInfo {
            debug_name: "session_get_remember",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(session_get_remember(api_session_id))
        },
    )
}
fn wire_session_get_toggle_option_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    arg: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, Option<bool>>(
        WrapInfo {
            debug_name: "session_get_toggle_option",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_arg = arg.wire2api();
            move |task_callback| Ok(session_get_toggle_option(api_session_id, api_arg))
        },
    )
}
fn wire_session_get_toggle_option_sync_impl(
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    arg: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "session_get_toggle_option_sync",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_arg = arg.wire2api();
            Ok(session_get_toggle_option_sync(api_session_id, api_arg))
        },
    )
}
fn wire_session_get_option_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    arg: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, Option<String>>(
        WrapInfo {
            debug_name: "session_get_option",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_arg = arg.wire2api();
            move |task_callback| Ok(session_get_option(api_session_id, api_arg))
        },
    )
}
fn wire_session_login_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    os_username: impl Wire2Api<String> + UnwindSafe,
    os_password: impl Wire2Api<String> + UnwindSafe,
    password: impl Wire2Api<String> + UnwindSafe,
    remember: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_login",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_os_username = os_username.wire2api();
            let api_os_password = os_password.wire2api();
            let api_password = password.wire2api();
            let api_remember = remember.wire2api();
            move |task_callback| {
                Ok(session_login(
                    api_session_id,
                    api_os_username,
                    api_os_password,
                    api_password,
                    api_remember,
                ))
            }
        },
    )
}
fn wire_session_send2fa_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    code: impl Wire2Api<String> + UnwindSafe,
    trust_this_device: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_send2fa",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_code = code.wire2api();
            let api_trust_this_device = trust_this_device.wire2api();
            move |task_callback| {
                Ok(session_send2fa(
                    api_session_id,
                    api_code,
                    api_trust_this_device,
                ))
            }
        },
    )
}
fn wire_session_get_enable_trusted_devices_impl(
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "session_get_enable_trusted_devices",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_session_id = session_id.wire2api();
            Ok(session_get_enable_trusted_devices(api_session_id))
        },
    )
}
fn wire_session_close_impl(port_: MessagePort, session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_close",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(session_close(api_session_id))
        },
    )
}
fn wire_session_refresh_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    display: impl Wire2Api<usize> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_refresh",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_display = display.wire2api();
            move |task_callback| Ok(session_refresh(api_session_id, api_display))
        },
    )
}
fn wire_session_take_screenshot_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    display: impl Wire2Api<usize> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_take_screenshot",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_display = display.wire2api();
            move |task_callback| Ok(session_take_screenshot(api_session_id, api_display))
        },
    )
}
fn wire_session_handle_screenshot_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    action: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "session_handle_screenshot",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_action = action.wire2api();
            move |task_callback| Ok(session_handle_screenshot(api_session_id, api_action))
        },
    )
}
fn wire_session_is_multi_ui_session_impl(
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "session_is_multi_ui_session",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_session_id = session_id.wire2api();
            Ok(session_is_multi_ui_session(api_session_id))
        },
    )
}
fn wire_session_record_screen_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    start: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_record_screen",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_start = start.wire2api();
            move |task_callback| Ok(session_record_screen(api_session_id, api_start))
        },
    )
}
fn wire_session_get_is_recording_impl(
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "session_get_is_recording",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_session_id = session_id.wire2api();
            Ok(session_get_is_recording(api_session_id))
        },
    )
}
fn wire_session_reconnect_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    force_relay: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_reconnect",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_force_relay = force_relay.wire2api();
            move |task_callback| Ok(session_reconnect(api_session_id, api_force_relay))
        },
    )
}
fn wire_session_toggle_option_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    value: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_toggle_option",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_value = value.wire2api();
            move |task_callback| Ok(session_toggle_option(api_session_id, api_value))
        },
    )
}
fn wire_session_toggle_privacy_mode_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    impl_key: impl Wire2Api<String> + UnwindSafe,
    on: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_toggle_privacy_mode",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_impl_key = impl_key.wire2api();
            let api_on = on.wire2api();
            move |task_callback| {
                Ok(session_toggle_privacy_mode(
                    api_session_id,
                    api_impl_key,
                    api_on,
                ))
            }
        },
    )
}
fn wire_session_get_flutter_option_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    k: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, Option<String>>(
        WrapInfo {
            debug_name: "session_get_flutter_option",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_k = k.wire2api();
            move |task_callback| Ok(session_get_flutter_option(api_session_id, api_k))
        },
    )
}
fn wire_session_set_flutter_option_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    k: impl Wire2Api<String> + UnwindSafe,
    v: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_set_flutter_option",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_k = k.wire2api();
            let api_v = v.wire2api();
            move |task_callback| Ok(session_set_flutter_option(api_session_id, api_k, api_v))
        },
    )
}
fn wire_get_next_texture_key_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "get_next_texture_key",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(get_next_texture_key()),
    )
}
fn wire_get_local_flutter_option_impl(
    k: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "get_local_flutter_option",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_k = k.wire2api();
            Ok(get_local_flutter_option(api_k))
        },
    )
}
fn wire_set_local_flutter_option_impl(
    port_: MessagePort,
    k: impl Wire2Api<String> + UnwindSafe,
    v: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "set_local_flutter_option",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_k = k.wire2api();
            let api_v = v.wire2api();
            move |task_callback| Ok(set_local_flutter_option(api_k, api_v))
        },
    )
}
fn wire_get_local_kb_layout_type_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "get_local_kb_layout_type",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(get_local_kb_layout_type()),
    )
}
fn wire_set_local_kb_layout_type_impl(
    port_: MessagePort,
    kb_layout_type: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "set_local_kb_layout_type",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_kb_layout_type = kb_layout_type.wire2api();
            move |task_callback| Ok(set_local_kb_layout_type(api_kb_layout_type))
        },
    )
}
fn wire_session_get_view_style_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, Option<String>>(
        WrapInfo {
            debug_name: "session_get_view_style",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(session_get_view_style(api_session_id))
        },
    )
}
fn wire_session_set_view_style_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    value: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_set_view_style",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_value = value.wire2api();
            move |task_callback| Ok(session_set_view_style(api_session_id, api_value))
        },
    )
}
fn wire_session_get_scroll_style_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, Option<String>>(
        WrapInfo {
            debug_name: "session_get_scroll_style",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(session_get_scroll_style(api_session_id))
        },
    )
}
fn wire_session_set_scroll_style_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    value: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_set_scroll_style",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_value = value.wire2api();
            move |task_callback| Ok(session_set_scroll_style(api_session_id, api_value))
        },
    )
}
fn wire_session_get_image_quality_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, Option<String>>(
        WrapInfo {
            debug_name: "session_get_image_quality",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(session_get_image_quality(api_session_id))
        },
    )
}
fn wire_session_set_image_quality_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    value: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_set_image_quality",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_value = value.wire2api();
            move |task_callback| Ok(session_set_image_quality(api_session_id, api_value))
        },
    )
}
fn wire_session_get_keyboard_mode_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, Option<String>>(
        WrapInfo {
            debug_name: "session_get_keyboard_mode",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(session_get_keyboard_mode(api_session_id))
        },
    )
}
fn wire_session_set_keyboard_mode_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    value: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_set_keyboard_mode",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_value = value.wire2api();
            move |task_callback| Ok(session_set_keyboard_mode(api_session_id, api_value))
        },
    )
}
fn wire_session_get_reverse_mouse_wheel_sync_impl(
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "session_get_reverse_mouse_wheel_sync",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_session_id = session_id.wire2api();
            Ok(session_get_reverse_mouse_wheel_sync(api_session_id))
        },
    )
}
fn wire_session_set_reverse_mouse_wheel_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    value: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_set_reverse_mouse_wheel",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_value = value.wire2api();
            move |task_callback| Ok(session_set_reverse_mouse_wheel(api_session_id, api_value))
        },
    )
}
fn wire_session_get_displays_as_individual_windows_impl(
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "session_get_displays_as_individual_windows",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_session_id = session_id.wire2api();
            Ok(session_get_displays_as_individual_windows(api_session_id))
        },
    )
}
fn wire_session_set_displays_as_individual_windows_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    value: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_set_displays_as_individual_windows",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_value = value.wire2api();
            move |task_callback| {
                Ok(session_set_displays_as_individual_windows(
                    api_session_id,
                    api_value,
                ))
            }
        },
    )
}
fn wire_session_get_use_all_my_displays_for_the_remote_session_impl(
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "session_get_use_all_my_displays_for_the_remote_session",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_session_id = session_id.wire2api();
            Ok(session_get_use_all_my_displays_for_the_remote_session(
                api_session_id,
            ))
        },
    )
}
fn wire_session_set_use_all_my_displays_for_the_remote_session_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    value: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_set_use_all_my_displays_for_the_remote_session",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_value = value.wire2api();
            move |task_callback| {
                Ok(session_set_use_all_my_displays_for_the_remote_session(
                    api_session_id,
                    api_value,
                ))
            }
        },
    )
}
fn wire_session_get_custom_image_quality_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, Option<Vec<i32>>>(
        WrapInfo {
            debug_name: "session_get_custom_image_quality",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(session_get_custom_image_quality(api_session_id))
        },
    )
}
fn wire_session_is_keyboard_mode_supported_impl(
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    mode: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "session_is_keyboard_mode_supported",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_mode = mode.wire2api();
            Ok(session_is_keyboard_mode_supported(api_session_id, api_mode))
        },
    )
}
fn wire_session_set_custom_image_quality_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    value: impl Wire2Api<i32> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_set_custom_image_quality",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_value = value.wire2api();
            move |task_callback| Ok(session_set_custom_image_quality(api_session_id, api_value))
        },
    )
}
fn wire_session_set_custom_fps_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    fps: impl Wire2Api<i32> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_set_custom_fps",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_fps = fps.wire2api();
            move |task_callback| Ok(session_set_custom_fps(api_session_id, api_fps))
        },
    )
}
fn wire_session_get_trackpad_speed_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, Option<i32>>(
        WrapInfo {
            debug_name: "session_get_trackpad_speed",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(session_get_trackpad_speed(api_session_id))
        },
    )
}
fn wire_session_set_trackpad_speed_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    value: impl Wire2Api<i32> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_set_trackpad_speed",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_value = value.wire2api();
            move |task_callback| Ok(session_set_trackpad_speed(api_session_id, api_value))
        },
    )
}
fn wire_session_lock_screen_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_lock_screen",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(session_lock_screen(api_session_id))
        },
    )
}
fn wire_session_ctrl_alt_del_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_ctrl_alt_del",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(session_ctrl_alt_del(api_session_id))
        },
    )
}
fn wire_session_switch_display_impl(
    port_: MessagePort,
    is_desktop: impl Wire2Api<bool> + UnwindSafe,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    value: impl Wire2Api<Vec<i32>> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_switch_display",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_is_desktop = is_desktop.wire2api();
            let api_session_id = session_id.wire2api();
            let api_value = value.wire2api();
            move |task_callback| {
                Ok(session_switch_display(
                    api_is_desktop,
                    api_session_id,
                    api_value,
                ))
            }
        },
    )
}
fn wire_session_handle_flutter_key_event_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    character: impl Wire2Api<String> + UnwindSafe,
    usb_hid: impl Wire2Api<i32> + UnwindSafe,
    lock_modes: impl Wire2Api<i32> + UnwindSafe,
    down_or_up: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_handle_flutter_key_event",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_character = character.wire2api();
            let api_usb_hid = usb_hid.wire2api();
            let api_lock_modes = lock_modes.wire2api();
            let api_down_or_up = down_or_up.wire2api();
            move |task_callback| {
                Ok(session_handle_flutter_key_event(
                    api_session_id,
                    api_character,
                    api_usb_hid,
                    api_lock_modes,
                    api_down_or_up,
                ))
            }
        },
    )
}
fn wire_session_handle_flutter_raw_key_event_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    name: impl Wire2Api<String> + UnwindSafe,
    platform_code: impl Wire2Api<i32> + UnwindSafe,
    position_code: impl Wire2Api<i32> + UnwindSafe,
    lock_modes: impl Wire2Api<i32> + UnwindSafe,
    down_or_up: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_handle_flutter_raw_key_event",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_name = name.wire2api();
            let api_platform_code = platform_code.wire2api();
            let api_position_code = position_code.wire2api();
            let api_lock_modes = lock_modes.wire2api();
            let api_down_or_up = down_or_up.wire2api();
            move |task_callback| {
                Ok(session_handle_flutter_raw_key_event(
                    api_session_id,
                    api_name,
                    api_platform_code,
                    api_position_code,
                    api_lock_modes,
                    api_down_or_up,
                ))
            }
        },
    )
}
fn wire_session_enter_or_leave_impl(
    _session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    _enter: impl Wire2Api<bool> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "session_enter_or_leave",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api__session_id = _session_id.wire2api();
            let api__enter = _enter.wire2api();
            Ok(session_enter_or_leave(api__session_id, api__enter))
        },
    )
}
fn wire_session_input_key_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    name: impl Wire2Api<String> + UnwindSafe,
    down: impl Wire2Api<bool> + UnwindSafe,
    press: impl Wire2Api<bool> + UnwindSafe,
    alt: impl Wire2Api<bool> + UnwindSafe,
    ctrl: impl Wire2Api<bool> + UnwindSafe,
    shift: impl Wire2Api<bool> + UnwindSafe,
    command: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_input_key",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_name = name.wire2api();
            let api_down = down.wire2api();
            let api_press = press.wire2api();
            let api_alt = alt.wire2api();
            let api_ctrl = ctrl.wire2api();
            let api_shift = shift.wire2api();
            let api_command = command.wire2api();
            move |task_callback| {
                Ok(session_input_key(
                    api_session_id,
                    api_name,
                    api_down,
                    api_press,
                    api_alt,
                    api_ctrl,
                    api_shift,
                    api_command,
                ))
            }
        },
    )
}
fn wire_session_input_string_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    value: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_input_string",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_value = value.wire2api();
            move |task_callback| Ok(session_input_string(api_session_id, api_value))
        },
    )
}
fn wire_session_send_chat_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    text: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_send_chat",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_text = text.wire2api();
            move |task_callback| Ok(session_send_chat(api_session_id, api_text))
        },
    )
}
fn wire_session_peer_option_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    name: impl Wire2Api<String> + UnwindSafe,
    value: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_peer_option",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_name = name.wire2api();
            let api_value = value.wire2api();
            move |task_callback| Ok(session_peer_option(api_session_id, api_name, api_value))
        },
    )
}
fn wire_session_get_peer_option_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    name: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "session_get_peer_option",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_name = name.wire2api();
            move |task_callback| Ok(session_get_peer_option(api_session_id, api_name))
        },
    )
}
fn wire_session_input_os_password_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    value: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_input_os_password",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_value = value.wire2api();
            move |task_callback| Ok(session_input_os_password(api_session_id, api_value))
        },
    )
}
fn wire_session_read_remote_dir_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    path: impl Wire2Api<String> + UnwindSafe,
    include_hidden: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_read_remote_dir",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_path = path.wire2api();
            let api_include_hidden = include_hidden.wire2api();
            move |task_callback| {
                Ok(session_read_remote_dir(
                    api_session_id,
                    api_path,
                    api_include_hidden,
                ))
            }
        },
    )
}
fn wire_session_send_files_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    act_id: impl Wire2Api<i32> + UnwindSafe,
    path: impl Wire2Api<String> + UnwindSafe,
    to: impl Wire2Api<String> + UnwindSafe,
    file_num: impl Wire2Api<i32> + UnwindSafe,
    include_hidden: impl Wire2Api<bool> + UnwindSafe,
    is_remote: impl Wire2Api<bool> + UnwindSafe,
    _is_dir: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_send_files",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_act_id = act_id.wire2api();
            let api_path = path.wire2api();
            let api_to = to.wire2api();
            let api_file_num = file_num.wire2api();
            let api_include_hidden = include_hidden.wire2api();
            let api_is_remote = is_remote.wire2api();
            let api__is_dir = _is_dir.wire2api();
            move |task_callback| {
                Ok(session_send_files(
                    api_session_id,
                    api_act_id,
                    api_path,
                    api_to,
                    api_file_num,
                    api_include_hidden,
                    api_is_remote,
                    api__is_dir,
                ))
            }
        },
    )
}
fn wire_session_set_confirm_override_file_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    act_id: impl Wire2Api<i32> + UnwindSafe,
    file_num: impl Wire2Api<i32> + UnwindSafe,
    need_override: impl Wire2Api<bool> + UnwindSafe,
    remember: impl Wire2Api<bool> + UnwindSafe,
    is_upload: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_set_confirm_override_file",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_act_id = act_id.wire2api();
            let api_file_num = file_num.wire2api();
            let api_need_override = need_override.wire2api();
            let api_remember = remember.wire2api();
            let api_is_upload = is_upload.wire2api();
            move |task_callback| {
                Ok(session_set_confirm_override_file(
                    api_session_id,
                    api_act_id,
                    api_file_num,
                    api_need_override,
                    api_remember,
                    api_is_upload,
                ))
            }
        },
    )
}
fn wire_session_remove_file_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    act_id: impl Wire2Api<i32> + UnwindSafe,
    path: impl Wire2Api<String> + UnwindSafe,
    file_num: impl Wire2Api<i32> + UnwindSafe,
    is_remote: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_remove_file",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_act_id = act_id.wire2api();
            let api_path = path.wire2api();
            let api_file_num = file_num.wire2api();
            let api_is_remote = is_remote.wire2api();
            move |task_callback| {
                Ok(session_remove_file(
                    api_session_id,
                    api_act_id,
                    api_path,
                    api_file_num,
                    api_is_remote,
                ))
            }
        },
    )
}
fn wire_session_read_dir_to_remove_recursive_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    act_id: impl Wire2Api<i32> + UnwindSafe,
    path: impl Wire2Api<String> + UnwindSafe,
    is_remote: impl Wire2Api<bool> + UnwindSafe,
    show_hidden: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_read_dir_to_remove_recursive",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_act_id = act_id.wire2api();
            let api_path = path.wire2api();
            let api_is_remote = is_remote.wire2api();
            let api_show_hidden = show_hidden.wire2api();
            move |task_callback| {
                Ok(session_read_dir_to_remove_recursive(
                    api_session_id,
                    api_act_id,
                    api_path,
                    api_is_remote,
                    api_show_hidden,
                ))
            }
        },
    )
}
fn wire_session_remove_all_empty_dirs_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    act_id: impl Wire2Api<i32> + UnwindSafe,
    path: impl Wire2Api<String> + UnwindSafe,
    is_remote: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_remove_all_empty_dirs",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_act_id = act_id.wire2api();
            let api_path = path.wire2api();
            let api_is_remote = is_remote.wire2api();
            move |task_callback| {
                Ok(session_remove_all_empty_dirs(
                    api_session_id,
                    api_act_id,
                    api_path,
                    api_is_remote,
                ))
            }
        },
    )
}
fn wire_session_cancel_job_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    act_id: impl Wire2Api<i32> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_cancel_job",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_act_id = act_id.wire2api();
            move |task_callback| Ok(session_cancel_job(api_session_id, api_act_id))
        },
    )
}
fn wire_session_create_dir_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    act_id: impl Wire2Api<i32> + UnwindSafe,
    path: impl Wire2Api<String> + UnwindSafe,
    is_remote: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_create_dir",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_act_id = act_id.wire2api();
            let api_path = path.wire2api();
            let api_is_remote = is_remote.wire2api();
            move |task_callback| {
                Ok(session_create_dir(
                    api_session_id,
                    api_act_id,
                    api_path,
                    api_is_remote,
                ))
            }
        },
    )
}
fn wire_session_read_local_dir_sync_impl(
    port_: MessagePort,
    _session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    path: impl Wire2Api<String> + UnwindSafe,
    show_hidden: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "session_read_local_dir_sync",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api__session_id = _session_id.wire2api();
            let api_path = path.wire2api();
            let api_show_hidden = show_hidden.wire2api();
            move |task_callback| {
                Ok(session_read_local_dir_sync(
                    api__session_id,
                    api_path,
                    api_show_hidden,
                ))
            }
        },
    )
}
fn wire_session_read_local_empty_dirs_recursive_sync_impl(
    port_: MessagePort,
    _session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    path: impl Wire2Api<String> + UnwindSafe,
    include_hidden: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "session_read_local_empty_dirs_recursive_sync",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api__session_id = _session_id.wire2api();
            let api_path = path.wire2api();
            let api_include_hidden = include_hidden.wire2api();
            move |task_callback| {
                Ok(session_read_local_empty_dirs_recursive_sync(
                    api__session_id,
                    api_path,
                    api_include_hidden,
                ))
            }
        },
    )
}
fn wire_session_read_remote_empty_dirs_recursive_sync_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    path: impl Wire2Api<String> + UnwindSafe,
    include_hidden: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_read_remote_empty_dirs_recursive_sync",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_path = path.wire2api();
            let api_include_hidden = include_hidden.wire2api();
            move |task_callback| {
                Ok(session_read_remote_empty_dirs_recursive_sync(
                    api_session_id,
                    api_path,
                    api_include_hidden,
                ))
            }
        },
    )
}
fn wire_session_get_platform_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    is_remote: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "session_get_platform",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_is_remote = is_remote.wire2api();
            move |task_callback| Ok(session_get_platform(api_session_id, api_is_remote))
        },
    )
}
fn wire_session_load_last_transfer_jobs_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_load_last_transfer_jobs",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(session_load_last_transfer_jobs(api_session_id))
        },
    )
}
fn wire_session_add_job_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    act_id: impl Wire2Api<i32> + UnwindSafe,
    path: impl Wire2Api<String> + UnwindSafe,
    to: impl Wire2Api<String> + UnwindSafe,
    file_num: impl Wire2Api<i32> + UnwindSafe,
    include_hidden: impl Wire2Api<bool> + UnwindSafe,
    is_remote: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_add_job",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_act_id = act_id.wire2api();
            let api_path = path.wire2api();
            let api_to = to.wire2api();
            let api_file_num = file_num.wire2api();
            let api_include_hidden = include_hidden.wire2api();
            let api_is_remote = is_remote.wire2api();
            move |task_callback| {
                Ok(session_add_job(
                    api_session_id,
                    api_act_id,
                    api_path,
                    api_to,
                    api_file_num,
                    api_include_hidden,
                    api_is_remote,
                ))
            }
        },
    )
}
fn wire_session_resume_job_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    act_id: impl Wire2Api<i32> + UnwindSafe,
    is_remote: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_resume_job",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_act_id = act_id.wire2api();
            let api_is_remote = is_remote.wire2api();
            move |task_callback| {
                Ok(session_resume_job(
                    api_session_id,
                    api_act_id,
                    api_is_remote,
                ))
            }
        },
    )
}
fn wire_session_rename_file_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    act_id: impl Wire2Api<i32> + UnwindSafe,
    path: impl Wire2Api<String> + UnwindSafe,
    new_name: impl Wire2Api<String> + UnwindSafe,
    is_remote: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_rename_file",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_act_id = act_id.wire2api();
            let api_path = path.wire2api();
            let api_new_name = new_name.wire2api();
            let api_is_remote = is_remote.wire2api();
            move |task_callback| {
                Ok(session_rename_file(
                    api_session_id,
                    api_act_id,
                    api_path,
                    api_new_name,
                    api_is_remote,
                ))
            }
        },
    )
}
fn wire_session_elevate_direct_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_elevate_direct",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(session_elevate_direct(api_session_id))
        },
    )
}
fn wire_session_elevate_with_logon_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    username: impl Wire2Api<String> + UnwindSafe,
    password: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_elevate_with_logon",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_username = username.wire2api();
            let api_password = password.wire2api();
            move |task_callback| {
                Ok(session_elevate_with_logon(
                    api_session_id,
                    api_username,
                    api_password,
                ))
            }
        },
    )
}
fn wire_session_switch_sides_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_switch_sides",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(session_switch_sides(api_session_id))
        },
    )
}
fn wire_session_change_resolution_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    display: impl Wire2Api<i32> + UnwindSafe,
    width: impl Wire2Api<i32> + UnwindSafe,
    height: impl Wire2Api<i32> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_change_resolution",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_display = display.wire2api();
            let api_width = width.wire2api();
            let api_height = height.wire2api();
            move |task_callback| {
                Ok(session_change_resolution(
                    api_session_id,
                    api_display,
                    api_width,
                    api_height,
                ))
            }
        },
    )
}
fn wire_session_set_size_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    display: impl Wire2Api<usize> + UnwindSafe,
    width: impl Wire2Api<usize> + UnwindSafe,
    height: impl Wire2Api<usize> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_set_size",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_display = display.wire2api();
            let api_width = width.wire2api();
            let api_height = height.wire2api();
            move |task_callback| {
                Ok(session_set_size(
                    api_session_id,
                    api_display,
                    api_width,
                    api_height,
                ))
            }
        },
    )
}
fn wire_session_send_selected_session_id_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    sid: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_send_selected_session_id",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_sid = sid.wire2api();
            move |task_callback| Ok(session_send_selected_session_id(api_session_id, api_sid))
        },
    )
}
fn wire_main_get_sound_inputs_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, Vec<String>>(
        WrapInfo {
            debug_name: "main_get_sound_inputs",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_sound_inputs()),
    )
}
fn wire_main_get_login_device_info_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_login_device_info",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_get_login_device_info()),
    )
}
fn wire_main_change_id_impl(port_: MessagePort, new_id: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_change_id",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_new_id = new_id.wire2api();
            move |task_callback| Ok(main_change_id(api_new_id))
        },
    )
}
fn wire_main_get_async_status_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_async_status",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_async_status()),
    )
}
fn wire_main_get_http_status_impl(port_: MessagePort, url: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, Option<String>>(
        WrapInfo {
            debug_name: "main_get_http_status",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_url = url.wire2api();
            move |task_callback| Ok(main_get_http_status(api_url))
        },
    )
}
fn wire_main_get_option_impl(port_: MessagePort, key: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_option",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_key = key.wire2api();
            move |task_callback| Ok(main_get_option(api_key))
        },
    )
}
fn wire_main_get_option_sync_impl(
    key: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_option_sync",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_key = key.wire2api();
            Ok(main_get_option_sync(api_key))
        },
    )
}
fn wire_main_get_error_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_error",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_error()),
    )
}
fn wire_main_show_option_impl(_key: impl Wire2Api<String> + UnwindSafe) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_show_option",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api__key = _key.wire2api();
            Ok(main_show_option(api__key))
        },
    )
}
fn wire_main_set_option_impl(
    port_: MessagePort,
    key: impl Wire2Api<String> + UnwindSafe,
    value: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_set_option",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_key = key.wire2api();
            let api_value = value.wire2api();
            move |task_callback| Ok(main_set_option(api_key, api_value))
        },
    )
}
fn wire_main_get_options_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_options",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_options()),
    )
}
fn wire_main_get_options_sync_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_options_sync",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_get_options_sync()),
    )
}
fn wire_main_set_options_impl(port_: MessagePort, json: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_set_options",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_json = json.wire2api();
            move |task_callback| Ok(main_set_options(api_json))
        },
    )
}
fn wire_main_test_if_valid_server_impl(
    port_: MessagePort,
    server: impl Wire2Api<String> + UnwindSafe,
    test_with_proxy: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_test_if_valid_server",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_server = server.wire2api();
            let api_test_with_proxy = test_with_proxy.wire2api();
            move |task_callback| Ok(main_test_if_valid_server(api_server, api_test_with_proxy))
        },
    )
}
fn wire_main_set_socks_impl(
    port_: MessagePort,
    proxy: impl Wire2Api<String> + UnwindSafe,
    username: impl Wire2Api<String> + UnwindSafe,
    password: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_set_socks",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_proxy = proxy.wire2api();
            let api_username = username.wire2api();
            let api_password = password.wire2api();
            move |task_callback| Ok(main_set_socks(api_proxy, api_username, api_password))
        },
    )
}
fn wire_main_get_proxy_status_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, bool>(
        WrapInfo {
            debug_name: "main_get_proxy_status",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_proxy_status()),
    )
}
fn wire_main_get_socks_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, Vec<String>>(
        WrapInfo {
            debug_name: "main_get_socks",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_socks()),
    )
}
fn wire_main_get_app_name_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_app_name",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_app_name()),
    )
}
fn wire_main_get_app_name_sync_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_app_name_sync",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_get_app_name_sync()),
    )
}
fn wire_main_uri_prefix_sync_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_uri_prefix_sync",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_uri_prefix_sync()),
    )
}
fn wire_main_get_license_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_license",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_license()),
    )
}
fn wire_main_get_version_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_version",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_version()),
    )
}
fn wire_main_get_fav_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, Vec<String>>(
        WrapInfo {
            debug_name: "main_get_fav",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_fav()),
    )
}
fn wire_main_store_fav_impl(port_: MessagePort, favs: impl Wire2Api<Vec<String>> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_store_fav",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_favs = favs.wire2api();
            move |task_callback| Ok(main_store_fav(api_favs))
        },
    )
}
fn wire_main_get_peer_sync_impl(id: impl Wire2Api<String> + UnwindSafe) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_peer_sync",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_id = id.wire2api();
            Ok(main_get_peer_sync(api_id))
        },
    )
}
fn wire_main_get_lan_peers_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_lan_peers",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_lan_peers()),
    )
}
fn wire_main_get_connect_status_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_connect_status",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_connect_status()),
    )
}
fn wire_main_check_connect_status_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_check_connect_status",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_check_connect_status()),
    )
}
fn wire_main_is_using_public_server_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, bool>(
        WrapInfo {
            debug_name: "main_is_using_public_server",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_is_using_public_server()),
    )
}
fn wire_main_discover_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_discover",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_discover()),
    )
}
fn wire_main_get_api_server_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_api_server",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_api_server()),
    )
}
fn wire_main_http_request_impl(
    port_: MessagePort,
    url: impl Wire2Api<String> + UnwindSafe,
    method: impl Wire2Api<String> + UnwindSafe,
    body: impl Wire2Api<Option<String>> + UnwindSafe,
    header: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_http_request",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_url = url.wire2api();
            let api_method = method.wire2api();
            let api_body = body.wire2api();
            let api_header = header.wire2api();
            move |task_callback| Ok(main_http_request(api_url, api_method, api_body, api_header))
        },
    )
}
fn wire_main_get_local_option_impl(
    key: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_local_option",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_key = key.wire2api();
            Ok(main_get_local_option(api_key))
        },
    )
}
fn wire_main_get_use_texture_render_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_use_texture_render",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_get_use_texture_render()),
    )
}
fn wire_main_get_env_impl(key: impl Wire2Api<String> + UnwindSafe) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_env",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_key = key.wire2api();
            Ok(main_get_env(api_key))
        },
    )
}
fn wire_main_set_local_option_impl(
    port_: MessagePort,
    key: impl Wire2Api<String> + UnwindSafe,
    value: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_set_local_option",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_key = key.wire2api();
            let api_value = value.wire2api();
            move |task_callback| Ok(main_set_local_option(api_key, api_value))
        },
    )
}
fn wire_main_handle_wayland_screencast_restore_token_impl(
    port_: MessagePort,
    _key: impl Wire2Api<String> + UnwindSafe,
    _value: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_handle_wayland_screencast_restore_token",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api__key = _key.wire2api();
            let api__value = _value.wire2api();
            move |task_callback| {
                Ok(main_handle_wayland_screencast_restore_token(
                    api__key, api__value,
                ))
            }
        },
    )
}
fn wire_main_get_input_source_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_input_source",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_get_input_source()),
    )
}
fn wire_main_set_input_source_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    value: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_set_input_source",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_value = value.wire2api();
            move |task_callback| Ok(main_set_input_source(api_session_id, api_value))
        },
    )
}
fn wire_main_get_my_id_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_my_id",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_my_id()),
    )
}
fn wire_main_get_uuid_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_uuid",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_uuid()),
    )
}
fn wire_main_get_peer_option_impl(
    port_: MessagePort,
    id: impl Wire2Api<String> + UnwindSafe,
    key: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_peer_option",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_id = id.wire2api();
            let api_key = key.wire2api();
            move |task_callback| Ok(main_get_peer_option(api_id, api_key))
        },
    )
}
fn wire_main_get_peer_option_sync_impl(
    id: impl Wire2Api<String> + UnwindSafe,
    key: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_peer_option_sync",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_id = id.wire2api();
            let api_key = key.wire2api();
            Ok(main_get_peer_option_sync(api_id, api_key))
        },
    )
}
fn wire_main_get_peer_flutter_option_sync_impl(
    id: impl Wire2Api<String> + UnwindSafe,
    k: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_peer_flutter_option_sync",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_id = id.wire2api();
            let api_k = k.wire2api();
            Ok(main_get_peer_flutter_option_sync(api_id, api_k))
        },
    )
}
fn wire_main_set_peer_flutter_option_sync_impl(
    id: impl Wire2Api<String> + UnwindSafe,
    k: impl Wire2Api<String> + UnwindSafe,
    v: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_set_peer_flutter_option_sync",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_id = id.wire2api();
            let api_k = k.wire2api();
            let api_v = v.wire2api();
            Ok(main_set_peer_flutter_option_sync(api_id, api_k, api_v))
        },
    )
}
fn wire_main_set_peer_option_impl(
    port_: MessagePort,
    id: impl Wire2Api<String> + UnwindSafe,
    key: impl Wire2Api<String> + UnwindSafe,
    value: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_set_peer_option",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_id = id.wire2api();
            let api_key = key.wire2api();
            let api_value = value.wire2api();
            move |task_callback| Ok(main_set_peer_option(api_id, api_key, api_value))
        },
    )
}
fn wire_main_set_peer_option_sync_impl(
    id: impl Wire2Api<String> + UnwindSafe,
    key: impl Wire2Api<String> + UnwindSafe,
    value: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_set_peer_option_sync",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_id = id.wire2api();
            let api_key = key.wire2api();
            let api_value = value.wire2api();
            Ok(main_set_peer_option_sync(api_id, api_key, api_value))
        },
    )
}
fn wire_main_set_peer_alias_impl(
    port_: MessagePort,
    id: impl Wire2Api<String> + UnwindSafe,
    alias: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_set_peer_alias",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_id = id.wire2api();
            let api_alias = alias.wire2api();
            move |task_callback| Ok(main_set_peer_alias(api_id, api_alias))
        },
    )
}
fn wire_main_get_new_stored_peers_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_new_stored_peers",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_new_stored_peers()),
    )
}
fn wire_main_forget_password_impl(port_: MessagePort, id: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_forget_password",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_id = id.wire2api();
            move |task_callback| Ok(main_forget_password(api_id))
        },
    )
}
fn wire_main_peer_has_password_impl(port_: MessagePort, id: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, bool>(
        WrapInfo {
            debug_name: "main_peer_has_password",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_id = id.wire2api();
            move |task_callback| Ok(main_peer_has_password(api_id))
        },
    )
}
fn wire_main_peer_exists_impl(port_: MessagePort, id: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, bool>(
        WrapInfo {
            debug_name: "main_peer_exists",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_id = id.wire2api();
            move |task_callback| Ok(main_peer_exists(api_id))
        },
    )
}
fn wire_main_load_recent_peers_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_load_recent_peers",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_load_recent_peers()),
    )
}
fn wire_main_load_recent_peers_for_ab_impl(
    port_: MessagePort,
    filter: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_load_recent_peers_for_ab",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_filter = filter.wire2api();
            move |task_callback| Ok(main_load_recent_peers_for_ab(api_filter))
        },
    )
}
fn wire_main_load_fav_peers_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_load_fav_peers",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_load_fav_peers()),
    )
}
fn wire_main_load_lan_peers_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_load_lan_peers",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_load_lan_peers()),
    )
}
fn wire_main_remove_discovered_impl(port_: MessagePort, id: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_remove_discovered",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_id = id.wire2api();
            move |task_callback| Ok(main_remove_discovered(api_id))
        },
    )
}
fn wire_main_change_theme_impl(port_: MessagePort, dark: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_change_theme",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_dark = dark.wire2api();
            move |task_callback| Ok(main_change_theme(api_dark))
        },
    )
}
fn wire_main_change_language_impl(port_: MessagePort, lang: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_change_language",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_lang = lang.wire2api();
            move |task_callback| Ok(main_change_language(api_lang))
        },
    )
}
fn wire_main_video_save_directory_impl(
    root: impl Wire2Api<bool> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_video_save_directory",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_root = root.wire2api();
            Ok(main_video_save_directory(api_root))
        },
    )
}
fn wire_main_set_user_default_option_impl(
    port_: MessagePort,
    key: impl Wire2Api<String> + UnwindSafe,
    value: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_set_user_default_option",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_key = key.wire2api();
            let api_value = value.wire2api();
            move |task_callback| Ok(main_set_user_default_option(api_key, api_value))
        },
    )
}
fn wire_main_get_user_default_option_impl(
    key: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_user_default_option",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_key = key.wire2api();
            Ok(main_get_user_default_option(api_key))
        },
    )
}
fn wire_main_handle_relay_id_impl(port_: MessagePort, id: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_handle_relay_id",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_id = id.wire2api();
            move |task_callback| Ok(main_handle_relay_id(api_id))
        },
    )
}
fn wire_main_is_option_fixed_impl(
    key: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_is_option_fixed",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_key = key.wire2api();
            Ok(main_is_option_fixed(api_key))
        },
    )
}
fn wire_main_get_main_display_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_main_display",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_get_main_display()),
    )
}
fn wire_main_get_displays_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_displays",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_get_displays()),
    )
}
fn wire_session_add_port_forward_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    local_port: impl Wire2Api<i32> + UnwindSafe,
    remote_host: impl Wire2Api<String> + UnwindSafe,
    remote_port: impl Wire2Api<i32> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_add_port_forward",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_local_port = local_port.wire2api();
            let api_remote_host = remote_host.wire2api();
            let api_remote_port = remote_port.wire2api();
            move |task_callback| {
                Ok(session_add_port_forward(
                    api_session_id,
                    api_local_port,
                    api_remote_host,
                    api_remote_port,
                ))
            }
        },
    )
}
fn wire_session_remove_port_forward_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    local_port: impl Wire2Api<i32> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_remove_port_forward",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_local_port = local_port.wire2api();
            move |task_callback| Ok(session_remove_port_forward(api_session_id, api_local_port))
        },
    )
}
fn wire_session_new_rdp_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_new_rdp",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(session_new_rdp(api_session_id))
        },
    )
}
fn wire_session_request_voice_call_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_request_voice_call",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(session_request_voice_call(api_session_id))
        },
    )
}
fn wire_session_close_voice_call_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_close_voice_call",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(session_close_voice_call(api_session_id))
        },
    )
}
fn wire_session_get_conn_token_impl(
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "session_get_conn_token",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_session_id = session_id.wire2api();
            Ok(session_get_conn_token(api_session_id))
        },
    )
}
fn wire_cm_handle_incoming_voice_call_impl(
    port_: MessagePort,
    id: impl Wire2Api<i32> + UnwindSafe,
    accept: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "cm_handle_incoming_voice_call",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_id = id.wire2api();
            let api_accept = accept.wire2api();
            move |task_callback| Ok(cm_handle_incoming_voice_call(api_id, api_accept))
        },
    )
}
fn wire_cm_close_voice_call_impl(port_: MessagePort, id: impl Wire2Api<i32> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "cm_close_voice_call",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_id = id.wire2api();
            move |task_callback| Ok(cm_close_voice_call(api_id))
        },
    )
}
fn wire_set_voice_call_input_device_impl(
    port_: MessagePort,
    _is_cm: impl Wire2Api<bool> + UnwindSafe,
    _device: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "set_voice_call_input_device",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api__is_cm = _is_cm.wire2api();
            let api__device = _device.wire2api();
            move |task_callback| Ok(set_voice_call_input_device(api__is_cm, api__device))
        },
    )
}
fn wire_get_voice_call_input_device_impl(
    port_: MessagePort,
    _is_cm: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "get_voice_call_input_device",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api__is_cm = _is_cm.wire2api();
            move |task_callback| Ok(get_voice_call_input_device(api__is_cm))
        },
    )
}
fn wire_main_get_last_remote_id_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_last_remote_id",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_last_remote_id()),
    )
}
fn wire_main_get_software_update_url_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_get_software_update_url",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_software_update_url()),
    )
}
fn wire_main_get_home_dir_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_home_dir",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_home_dir()),
    )
}
fn wire_main_get_langs_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_langs",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_langs()),
    )
}
fn wire_main_get_temporary_password_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_temporary_password",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_temporary_password()),
    )
}
fn wire_main_get_permanent_password_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_permanent_password",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_permanent_password()),
    )
}
fn wire_main_get_fingerprint_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_fingerprint",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_fingerprint()),
    )
}
fn wire_cm_get_clients_state_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "cm_get_clients_state",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(cm_get_clients_state()),
    )
}
fn wire_cm_check_clients_length_impl(
    port_: MessagePort,
    length: impl Wire2Api<usize> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, Option<String>>(
        WrapInfo {
            debug_name: "cm_check_clients_length",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_length = length.wire2api();
            move |task_callback| Ok(cm_check_clients_length(api_length))
        },
    )
}
fn wire_cm_get_clients_length_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, usize>(
        WrapInfo {
            debug_name: "cm_get_clients_length",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(cm_get_clients_length()),
    )
}
fn wire_main_init_impl(
    port_: MessagePort,
    app_dir: impl Wire2Api<String> + UnwindSafe,
    custom_client_config: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_init",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_app_dir = app_dir.wire2api();
            let api_custom_client_config = custom_client_config.wire2api();
            move |task_callback| Ok(main_init(api_app_dir, api_custom_client_config))
        },
    )
}
fn wire_main_device_id_impl(port_: MessagePort, id: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_device_id",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_id = id.wire2api();
            move |task_callback| Ok(main_device_id(api_id))
        },
    )
}
fn wire_main_device_name_impl(port_: MessagePort, name: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_device_name",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_name = name.wire2api();
            move |task_callback| Ok(main_device_name(api_name))
        },
    )
}
fn wire_main_remove_peer_impl(port_: MessagePort, id: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_remove_peer",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_id = id.wire2api();
            move |task_callback| Ok(main_remove_peer(api_id))
        },
    )
}
fn wire_main_has_hwcodec_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_has_hwcodec",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_has_hwcodec()),
    )
}
fn wire_main_has_vram_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_has_vram",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_has_vram()),
    )
}
fn wire_main_supported_hwdecodings_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_supported_hwdecodings",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_supported_hwdecodings()),
    )
}
fn wire_main_is_root_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, bool>(
        WrapInfo {
            debug_name: "main_is_root",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_is_root()),
    )
}
fn wire_get_double_click_time_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "get_double_click_time",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(get_double_click_time()),
    )
}
fn wire_main_start_dbus_server_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_start_dbus_server",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_start_dbus_server()),
    )
}
fn wire_main_save_ab_impl(port_: MessagePort, json: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_save_ab",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_json = json.wire2api();
            move |task_callback| Ok(main_save_ab(api_json))
        },
    )
}
fn wire_main_clear_ab_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_clear_ab",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_clear_ab()),
    )
}
fn wire_main_load_ab_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_load_ab",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_load_ab()),
    )
}
fn wire_main_save_group_impl(port_: MessagePort, json: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_save_group",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_json = json.wire2api();
            move |task_callback| Ok(main_save_group(api_json))
        },
    )
}
fn wire_main_clear_group_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_clear_group",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_clear_group()),
    )
}
fn wire_main_load_group_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_load_group",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_load_group()),
    )
}
fn wire_session_send_pointer_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    msg: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_send_pointer",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_msg = msg.wire2api();
            move |task_callback| Ok(session_send_pointer(api_session_id, api_msg))
        },
    )
}
fn wire_session_send_mouse_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    msg: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_send_mouse",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_msg = msg.wire2api();
            move |task_callback| Ok(session_send_mouse(api_session_id, api_msg))
        },
    )
}
fn wire_session_restart_remote_device_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_restart_remote_device",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(session_restart_remote_device(api_session_id))
        },
    )
}
fn wire_session_get_audit_server_sync_impl(
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    typ: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "session_get_audit_server_sync",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_typ = typ.wire2api();
            Ok(session_get_audit_server_sync(api_session_id, api_typ))
        },
    )
}
fn wire_session_send_note_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    note: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_send_note",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_note = note.wire2api();
            move |task_callback| Ok(session_send_note(api_session_id, api_note))
        },
    )
}
fn wire_session_alternative_codecs_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "session_alternative_codecs",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(session_alternative_codecs(api_session_id))
        },
    )
}
fn wire_session_change_prefer_codec_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_change_prefer_codec",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(session_change_prefer_codec(api_session_id))
        },
    )
}
fn wire_session_on_waiting_for_image_dialog_show_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_on_waiting_for_image_dialog_show",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(session_on_waiting_for_image_dialog_show(api_session_id))
        },
    )
}
fn wire_session_toggle_virtual_display_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    index: impl Wire2Api<i32> + UnwindSafe,
    on: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_toggle_virtual_display",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_index = index.wire2api();
            let api_on = on.wire2api();
            move |task_callback| {
                Ok(session_toggle_virtual_display(
                    api_session_id,
                    api_index,
                    api_on,
                ))
            }
        },
    )
}
fn wire_session_printer_response_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    id: impl Wire2Api<i32> + UnwindSafe,
    path: impl Wire2Api<String> + UnwindSafe,
    printer_name: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_printer_response",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_id = id.wire2api();
            let api_path = path.wire2api();
            let api_printer_name = printer_name.wire2api();
            move |task_callback| {
                Ok(session_printer_response(
                    api_session_id,
                    api_id,
                    api_path,
                    api_printer_name,
                ))
            }
        },
    )
}
fn wire_main_set_home_dir_impl(port_: MessagePort, _home: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_set_home_dir",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api__home = _home.wire2api();
            move |task_callback| Ok(main_set_home_dir(api__home))
        },
    )
}
fn wire_main_get_data_dir_ios_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_data_dir_ios",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_get_data_dir_ios()),
    )
}
fn wire_main_stop_service_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_stop_service",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_stop_service()),
    )
}
fn wire_main_start_service_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_start_service",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_start_service()),
    )
}
fn wire_main_update_temporary_password_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_update_temporary_password",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_update_temporary_password()),
    )
}
fn wire_main_set_permanent_password_impl(
    port_: MessagePort,
    password: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_set_permanent_password",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_password = password.wire2api();
            move |task_callback| Ok(main_set_permanent_password(api_password))
        },
    )
}
fn wire_main_check_super_user_permission_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, bool>(
        WrapInfo {
            debug_name: "main_check_super_user_permission",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_check_super_user_permission()),
    )
}
fn wire_main_get_unlock_pin_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_unlock_pin",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_get_unlock_pin()),
    )
}
fn wire_main_set_unlock_pin_impl(
    pin: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_set_unlock_pin",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_pin = pin.wire2api();
            Ok(main_set_unlock_pin(api_pin))
        },
    )
}
fn wire_main_check_mouse_time_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_check_mouse_time",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_check_mouse_time()),
    )
}
fn wire_main_get_mouse_time_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, f64>(
        WrapInfo {
            debug_name: "main_get_mouse_time",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_mouse_time()),
    )
}
fn wire_main_wol_impl(port_: MessagePort, id: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_wol",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_id = id.wire2api();
            move |task_callback| Ok(main_wol(api_id))
        },
    )
}
fn wire_main_create_shortcut_impl(port_: MessagePort, _id: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_create_shortcut",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api__id = _id.wire2api();
            move |task_callback| Ok(main_create_shortcut(api__id))
        },
    )
}
fn wire_cm_send_chat_impl(
    port_: MessagePort,
    conn_id: impl Wire2Api<i32> + UnwindSafe,
    msg: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "cm_send_chat",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_conn_id = conn_id.wire2api();
            let api_msg = msg.wire2api();
            move |task_callback| Ok(cm_send_chat(api_conn_id, api_msg))
        },
    )
}
fn wire_cm_login_res_impl(
    port_: MessagePort,
    conn_id: impl Wire2Api<i32> + UnwindSafe,
    res: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "cm_login_res",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_conn_id = conn_id.wire2api();
            let api_res = res.wire2api();
            move |task_callback| Ok(cm_login_res(api_conn_id, api_res))
        },
    )
}
fn wire_cm_close_connection_impl(port_: MessagePort, conn_id: impl Wire2Api<i32> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "cm_close_connection",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_conn_id = conn_id.wire2api();
            move |task_callback| Ok(cm_close_connection(api_conn_id))
        },
    )
}
fn wire_cm_remove_disconnected_connection_impl(
    port_: MessagePort,
    conn_id: impl Wire2Api<i32> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "cm_remove_disconnected_connection",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_conn_id = conn_id.wire2api();
            move |task_callback| Ok(cm_remove_disconnected_connection(api_conn_id))
        },
    )
}
fn wire_cm_check_click_time_impl(port_: MessagePort, conn_id: impl Wire2Api<i32> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "cm_check_click_time",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_conn_id = conn_id.wire2api();
            move |task_callback| Ok(cm_check_click_time(api_conn_id))
        },
    )
}
fn wire_cm_get_click_time_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, f64>(
        WrapInfo {
            debug_name: "cm_get_click_time",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(cm_get_click_time()),
    )
}
fn wire_cm_switch_permission_impl(
    port_: MessagePort,
    conn_id: impl Wire2Api<i32> + UnwindSafe,
    name: impl Wire2Api<String> + UnwindSafe,
    enabled: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "cm_switch_permission",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_conn_id = conn_id.wire2api();
            let api_name = name.wire2api();
            let api_enabled = enabled.wire2api();
            move |task_callback| Ok(cm_switch_permission(api_conn_id, api_name, api_enabled))
        },
    )
}
fn wire_cm_can_elevate_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "cm_can_elevate",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(cm_can_elevate()),
    )
}
fn wire_cm_elevate_portable_impl(port_: MessagePort, conn_id: impl Wire2Api<i32> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "cm_elevate_portable",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_conn_id = conn_id.wire2api();
            move |task_callback| Ok(cm_elevate_portable(api_conn_id))
        },
    )
}
fn wire_cm_switch_back_impl(port_: MessagePort, conn_id: impl Wire2Api<i32> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "cm_switch_back",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_conn_id = conn_id.wire2api();
            move |task_callback| Ok(cm_switch_back(api_conn_id))
        },
    )
}
fn wire_cm_get_config_impl(port_: MessagePort, name: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "cm_get_config",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_name = name.wire2api();
            move |task_callback| Ok(cm_get_config(api_name))
        },
    )
}
fn wire_main_get_build_date_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_build_date",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_build_date()),
    )
}
fn wire_translate_impl(
    name: impl Wire2Api<String> + UnwindSafe,
    locale: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "translate",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_name = name.wire2api();
            let api_locale = locale.wire2api();
            Ok(translate(api_name, api_locale))
        },
    )
}
fn wire_session_get_rgba_size_impl(
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    display: impl Wire2Api<usize> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "session_get_rgba_size",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_display = display.wire2api();
            Ok(session_get_rgba_size(api_session_id, api_display))
        },
    )
}
fn wire_session_next_rgba_impl(
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    display: impl Wire2Api<usize> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "session_next_rgba",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_display = display.wire2api();
            Ok(session_next_rgba(api_session_id, api_display))
        },
    )
}
fn wire_session_register_pixelbuffer_texture_impl(
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    display: impl Wire2Api<usize> + UnwindSafe,
    ptr: impl Wire2Api<usize> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "session_register_pixelbuffer_texture",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_display = display.wire2api();
            let api_ptr = ptr.wire2api();
            Ok(session_register_pixelbuffer_texture(
                api_session_id,
                api_display,
                api_ptr,
            ))
        },
    )
}
fn wire_session_register_gpu_texture_impl(
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    display: impl Wire2Api<usize> + UnwindSafe,
    ptr: impl Wire2Api<usize> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "session_register_gpu_texture",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_display = display.wire2api();
            let api_ptr = ptr.wire2api();
            Ok(session_register_gpu_texture(
                api_session_id,
                api_display,
                api_ptr,
            ))
        },
    )
}
fn wire_query_onlines_impl(port_: MessagePort, ids: impl Wire2Api<Vec<String>> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "query_onlines",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_ids = ids.wire2api();
            move |task_callback| Ok(query_onlines(api_ids))
        },
    )
}
fn wire_version_to_number_impl(v: impl Wire2Api<String> + UnwindSafe) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "version_to_number",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_v = v.wire2api();
            Ok(version_to_number(api_v))
        },
    )
}
fn wire_option_synced_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, bool>(
        WrapInfo {
            debug_name: "option_synced",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(option_synced()),
    )
}
fn wire_main_is_installed_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_is_installed",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_is_installed()),
    )
}
fn wire_main_init_input_source_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_init_input_source",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_init_input_source()),
    )
}
fn wire_main_is_installed_lower_version_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_is_installed_lower_version",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_is_installed_lower_version()),
    )
}
fn wire_main_is_installed_daemon_impl(
    prompt: impl Wire2Api<bool> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_is_installed_daemon",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_prompt = prompt.wire2api();
            Ok(main_is_installed_daemon(api_prompt))
        },
    )
}
fn wire_main_is_process_trusted_impl(
    prompt: impl Wire2Api<bool> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_is_process_trusted",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_prompt = prompt.wire2api();
            Ok(main_is_process_trusted(api_prompt))
        },
    )
}
fn wire_main_is_can_screen_recording_impl(
    prompt: impl Wire2Api<bool> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_is_can_screen_recording",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_prompt = prompt.wire2api();
            Ok(main_is_can_screen_recording(api_prompt))
        },
    )
}
fn wire_main_is_can_input_monitoring_impl(
    prompt: impl Wire2Api<bool> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_is_can_input_monitoring",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_prompt = prompt.wire2api();
            Ok(main_is_can_input_monitoring(api_prompt))
        },
    )
}
fn wire_main_is_share_rdp_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_is_share_rdp",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_is_share_rdp()),
    )
}
fn wire_main_set_share_rdp_impl(port_: MessagePort, enable: impl Wire2Api<bool> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_set_share_rdp",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_enable = enable.wire2api();
            move |task_callback| Ok(main_set_share_rdp(api_enable))
        },
    )
}
fn wire_main_goto_install_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_goto_install",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_goto_install()),
    )
}
fn wire_main_get_new_version_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_new_version",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_get_new_version()),
    )
}
fn wire_main_update_me_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_update_me",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_update_me()),
    )
}
fn wire_set_cur_session_id_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "set_cur_session_id",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            move |task_callback| Ok(set_cur_session_id(api_session_id))
        },
    )
}
fn wire_install_show_run_without_install_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "install_show_run_without_install",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(install_show_run_without_install()),
    )
}
fn wire_install_run_without_install_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "install_run_without_install",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(install_run_without_install()),
    )
}
fn wire_install_install_me_impl(
    port_: MessagePort,
    options: impl Wire2Api<String> + UnwindSafe,
    path: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "install_install_me",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_options = options.wire2api();
            let api_path = path.wire2api();
            move |task_callback| Ok(install_install_me(api_options, api_path))
        },
    )
}
fn wire_install_install_path_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "install_install_path",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(install_install_path()),
    )
}
fn wire_install_install_options_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "install_install_options",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(install_install_options()),
    )
}
fn wire_main_account_auth_impl(
    port_: MessagePort,
    op: impl Wire2Api<String> + UnwindSafe,
    remember_me: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_account_auth",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_op = op.wire2api();
            let api_remember_me = remember_me.wire2api();
            move |task_callback| Ok(main_account_auth(api_op, api_remember_me))
        },
    )
}
fn wire_main_account_auth_cancel_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_account_auth_cancel",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_account_auth_cancel()),
    )
}
fn wire_main_account_auth_result_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_account_auth_result",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_account_auth_result()),
    )
}
fn wire_main_on_main_window_close_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_on_main_window_close",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_on_main_window_close()),
    )
}
fn wire_main_current_is_wayland_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_current_is_wayland",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_current_is_wayland()),
    )
}
fn wire_main_is_login_wayland_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_is_login_wayland",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_is_login_wayland()),
    )
}
fn wire_main_hide_dock_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_hide_dock",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_hide_dock()),
    )
}
fn wire_main_has_file_clipboard_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_has_file_clipboard",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_has_file_clipboard()),
    )
}
fn wire_main_has_gpu_texture_render_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_has_gpu_texture_render",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_has_gpu_texture_render()),
    )
}
fn wire_cm_init_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "cm_init",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(cm_init()),
    )
}
fn wire_main_start_ipc_url_server_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_start_ipc_url_server",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_start_ipc_url_server()),
    )
}
fn wire_main_test_wallpaper_impl(port_: MessagePort, _second: impl Wire2Api<u64> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_test_wallpaper",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api__second = _second.wire2api();
            move |task_callback| Ok(main_test_wallpaper(api__second))
        },
    )
}
fn wire_main_support_remove_wallpaper_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, bool>(
        WrapInfo {
            debug_name: "main_support_remove_wallpaper",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_support_remove_wallpaper()),
    )
}
fn wire_is_incoming_only_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "is_incoming_only",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(is_incoming_only()),
    )
}
fn wire_is_outgoing_only_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "is_outgoing_only",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(is_outgoing_only()),
    )
}
fn wire_is_custom_client_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "is_custom_client",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(is_custom_client()),
    )
}
fn wire_is_disable_settings_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "is_disable_settings",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(is_disable_settings()),
    )
}
fn wire_is_disable_ab_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "is_disable_ab",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(is_disable_ab()),
    )
}
fn wire_is_disable_account_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "is_disable_account",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(is_disable_account()),
    )
}
fn wire_is_disable_group_panel_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "is_disable_group_panel",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(is_disable_group_panel()),
    )
}
fn wire_is_disable_installation_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "is_disable_installation",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(is_disable_installation()),
    )
}
fn wire_is_preset_password_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, bool>(
        WrapInfo {
            debug_name: "is_preset_password",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(is_preset_password()),
    )
}
fn wire_is_preset_password_mobile_only_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "is_preset_password_mobile_only",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(is_preset_password_mobile_only()),
    )
}
fn wire_send_url_scheme_impl(port_: MessagePort, _url: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "send_url_scheme",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api__url = _url.wire2api();
            move |task_callback| Ok(send_url_scheme(api__url))
        },
    )
}
fn wire_plugin_event_impl(
    port_: MessagePort,
    _id: impl Wire2Api<String> + UnwindSafe,
    _peer: impl Wire2Api<String> + UnwindSafe,
    _event: impl Wire2Api<Vec<u8>> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "plugin_event",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api__id = _id.wire2api();
            let api__peer = _peer.wire2api();
            let api__event = _event.wire2api();
            move |task_callback| Ok(plugin_event(api__id, api__peer, api__event))
        },
    )
}
fn wire_plugin_register_event_stream_impl(
    port_: MessagePort,
    _id: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "plugin_register_event_stream",
            port: Some(port_),
            mode: FfiCallMode::Stream,
        },
        move || {
            let api__id = _id.wire2api();
            move |task_callback| {
                Ok(plugin_register_event_stream(
                    api__id,
                    task_callback.stream_sink::<_, EventToUI>(),
                ))
            }
        },
    )
}
fn wire_plugin_get_session_option_impl(
    _id: impl Wire2Api<String> + UnwindSafe,
    _peer: impl Wire2Api<String> + UnwindSafe,
    _key: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "plugin_get_session_option",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api__id = _id.wire2api();
            let api__peer = _peer.wire2api();
            let api__key = _key.wire2api();
            Ok(plugin_get_session_option(api__id, api__peer, api__key))
        },
    )
}
fn wire_plugin_set_session_option_impl(
    port_: MessagePort,
    _id: impl Wire2Api<String> + UnwindSafe,
    _peer: impl Wire2Api<String> + UnwindSafe,
    _key: impl Wire2Api<String> + UnwindSafe,
    _value: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "plugin_set_session_option",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api__id = _id.wire2api();
            let api__peer = _peer.wire2api();
            let api__key = _key.wire2api();
            let api__value = _value.wire2api();
            move |task_callback| {
                Ok(plugin_set_session_option(
                    api__id, api__peer, api__key, api__value,
                ))
            }
        },
    )
}
fn wire_plugin_get_shared_option_impl(
    _id: impl Wire2Api<String> + UnwindSafe,
    _key: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "plugin_get_shared_option",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api__id = _id.wire2api();
            let api__key = _key.wire2api();
            Ok(plugin_get_shared_option(api__id, api__key))
        },
    )
}
fn wire_plugin_set_shared_option_impl(
    port_: MessagePort,
    _id: impl Wire2Api<String> + UnwindSafe,
    _key: impl Wire2Api<String> + UnwindSafe,
    _value: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "plugin_set_shared_option",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api__id = _id.wire2api();
            let api__key = _key.wire2api();
            let api__value = _value.wire2api();
            move |task_callback| Ok(plugin_set_shared_option(api__id, api__key, api__value))
        },
    )
}
fn wire_plugin_reload_impl(port_: MessagePort, _id: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "plugin_reload",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api__id = _id.wire2api();
            move |task_callback| Ok(plugin_reload(api__id))
        },
    )
}
fn wire_plugin_enable_impl(
    _id: impl Wire2Api<String> + UnwindSafe,
    _v: impl Wire2Api<bool> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "plugin_enable",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api__id = _id.wire2api();
            let api__v = _v.wire2api();
            Ok(plugin_enable(api__id, api__v))
        },
    )
}
fn wire_plugin_is_enabled_impl(_id: impl Wire2Api<String> + UnwindSafe) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "plugin_is_enabled",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api__id = _id.wire2api();
            Ok(plugin_is_enabled(api__id))
        },
    )
}
fn wire_plugin_feature_is_enabled_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "plugin_feature_is_enabled",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(plugin_feature_is_enabled()),
    )
}
fn wire_plugin_sync_ui_impl(port_: MessagePort, _sync_to: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "plugin_sync_ui",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api__sync_to = _sync_to.wire2api();
            move |task_callback| Ok(plugin_sync_ui(api__sync_to))
        },
    )
}
fn wire_plugin_list_reload_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "plugin_list_reload",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(plugin_list_reload()),
    )
}
fn wire_plugin_install_impl(
    port_: MessagePort,
    _id: impl Wire2Api<String> + UnwindSafe,
    _b: impl Wire2Api<bool> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "plugin_install",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api__id = _id.wire2api();
            let api__b = _b.wire2api();
            move |task_callback| Ok(plugin_install(api__id, api__b))
        },
    )
}
fn wire_is_support_multi_ui_session_impl(
    version: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "is_support_multi_ui_session",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_version = version.wire2api();
            Ok(is_support_multi_ui_session(api_version))
        },
    )
}
fn wire_is_selinux_enforcing_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "is_selinux_enforcing",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(is_selinux_enforcing()),
    )
}
fn wire_main_default_privacy_mode_impl_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_default_privacy_mode_impl",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_default_privacy_mode_impl()),
    )
}
fn wire_main_supported_privacy_mode_impls_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_supported_privacy_mode_impls",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_supported_privacy_mode_impls()),
    )
}
fn wire_main_supported_input_source_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_supported_input_source",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_supported_input_source()),
    )
}
fn wire_main_generate2fa_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_generate2fa",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_generate2fa()),
    )
}
fn wire_main_verify2fa_impl(port_: MessagePort, code: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, bool>(
        WrapInfo {
            debug_name: "main_verify2fa",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_code = code.wire2api();
            move |task_callback| Ok(main_verify2fa(api_code))
        },
    )
}
fn wire_main_has_valid_2fa_sync_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_has_valid_2fa_sync",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_has_valid_2fa_sync()),
    )
}
fn wire_main_verify_bot_impl(port_: MessagePort, token: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_verify_bot",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_token = token.wire2api();
            move |task_callback| Ok(main_verify_bot(api_token))
        },
    )
}
fn wire_main_has_valid_bot_sync_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_has_valid_bot_sync",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_has_valid_bot_sync()),
    )
}
fn wire_main_get_hard_option_impl(
    key: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_hard_option",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_key = key.wire2api();
            Ok(main_get_hard_option(api_key))
        },
    )
}
fn wire_main_get_buildin_option_impl(
    key: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_buildin_option",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_key = key.wire2api();
            Ok(main_get_buildin_option(api_key))
        },
    )
}
fn wire_main_check_hwcodec_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_check_hwcodec",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_check_hwcodec()),
    )
}
fn wire_main_get_trusted_devices_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_trusted_devices",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_get_trusted_devices()),
    )
}
fn wire_main_remove_trusted_devices_impl(
    port_: MessagePort,
    json: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_remove_trusted_devices",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_json = json.wire2api();
            move |task_callback| Ok(main_remove_trusted_devices(api_json))
        },
    )
}
fn wire_main_clear_trusted_devices_impl(port_: MessagePort) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_clear_trusted_devices",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || move |task_callback| Ok(main_clear_trusted_devices()),
    )
}
fn wire_main_max_encrypt_len_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_max_encrypt_len",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_max_encrypt_len()),
    )
}
fn wire_session_request_new_display_init_msgs_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    display: impl Wire2Api<usize> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "session_request_new_display_init_msgs",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_display = display.wire2api();
            move |task_callback| {
                Ok(session_request_new_display_init_msgs(
                    api_session_id,
                    api_display,
                ))
            }
        },
    )
}
fn wire_main_audio_support_loopback_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_audio_support_loopback",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_audio_support_loopback()),
    )
}
fn wire_main_get_printer_names_impl() -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_printer_names",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || Ok(main_get_printer_names()),
    )
}
fn wire_main_get_common_impl(port_: MessagePort, key: impl Wire2Api<String> + UnwindSafe) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, String>(
        WrapInfo {
            debug_name: "main_get_common",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_key = key.wire2api();
            move |task_callback| Ok(main_get_common(api_key))
        },
    )
}
fn wire_main_get_common_sync_impl(
    key: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "main_get_common_sync",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_key = key.wire2api();
            Ok(main_get_common_sync(api_key))
        },
    )
}
fn wire_main_set_common_impl(
    port_: MessagePort,
    _key: impl Wire2Api<String> + UnwindSafe,
    _value: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, ()>(
        WrapInfo {
            debug_name: "main_set_common",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api__key = _key.wire2api();
            let api__value = _value.wire2api();
            move |task_callback| Ok(main_set_common(api__key, api__value))
        },
    )
}
fn wire_session_get_common_sync_impl(
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    key: impl Wire2Api<String> + UnwindSafe,
    param: impl Wire2Api<String> + UnwindSafe,
) -> support::WireSyncReturn {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap_sync(
        WrapInfo {
            debug_name: "session_get_common_sync",
            port: None,
            mode: FfiCallMode::Sync,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_key = key.wire2api();
            let api_param = param.wire2api();
            Ok(session_get_common_sync(api_session_id, api_key, api_param))
        },
    )
}
fn wire_session_get_common_impl(
    port_: MessagePort,
    session_id: impl Wire2Api<uuid::Uuid> + UnwindSafe,
    key: impl Wire2Api<String> + UnwindSafe,
    param: impl Wire2Api<String> + UnwindSafe,
) {
    FLUTTER_RUST_BRIDGE_HANDLER.wrap::<_, _, _, Option<String>>(
        WrapInfo {
            debug_name: "session_get_common",
            port: Some(port_),
            mode: FfiCallMode::Normal,
        },
        move || {
            let api_session_id = session_id.wire2api();
            let api_key = key.wire2api();
            let api_param = param.wire2api();
            move |task_callback| Ok(session_get_common(api_session_id, api_key, api_param))
        },
    )
}
// Section: wrapper structs

// Section: static checks

// Section: allocate functions

// Section: related functions

// Section: impl Wire2Api

pub trait Wire2Api<T> {
    fn wire2api(self) -> T;
}

impl<T, S> Wire2Api<Option<T>> for *mut S
where
    *mut S: Wire2Api<T>,
{
    fn wire2api(self) -> Option<T> {
        (!self.is_null()).then(|| self.wire2api())
    }
}

impl Wire2Api<bool> for bool {
    fn wire2api(self) -> bool {
        self
    }
}
impl Wire2Api<i32> for i32 {
    fn wire2api(self) -> i32 {
        self
    }
}

impl Wire2Api<u64> for u64 {
    fn wire2api(self) -> u64 {
        self
    }
}
impl Wire2Api<u8> for u8 {
    fn wire2api(self) -> u8 {
        self
    }
}

impl Wire2Api<usize> for usize {
    fn wire2api(self) -> usize {
        self
    }
}
// Section: impl IntoDart

impl support::IntoDart for EventToUI {
    fn into_dart(self) -> support::DartAbi {
        match self {
            Self::Event(field0) => vec![0.into_dart(), field0.into_into_dart().into_dart()],
            Self::Rgba(field0) => vec![1.into_dart(), field0.into_into_dart().into_dart()],
            Self::Texture(field0, field1) => vec![
                2.into_dart(),
                field0.into_into_dart().into_dart(),
                field1.into_into_dart().into_dart(),
            ],
        }
        .into_dart()
    }
}
impl support::IntoDartExceptPrimitive for EventToUI {}
impl rust2dart::IntoIntoDart<EventToUI> for EventToUI {
    fn into_into_dart(self) -> Self {
        self
    }
}

// Section: executor

support::lazy_static! {
    pub static ref FLUTTER_RUST_BRIDGE_HANDLER: support::DefaultHandler = Default::default();
}

#[cfg(not(target_family = "wasm"))]
#[path = "bridge_generated.io.rs"]
mod io;
#[cfg(not(target_family = "wasm"))]
pub use io::*;
