# Contributing to RustDesk

RustDesk welcomes contribution from everyone. Here are the guidelines if you are
thinking of helping us:

## Contributions

Contributions to RustDesk or its dependencies should be made in the form of GitHub
pull requests. Each pull request will be reviewed by a core contributor
(someone with permission to land patches) and either landed in the main tree or
given feedback for changes that would be required. All contributions should
follow this format, even those from core contributors.

Should you wish to work on an issue, please claim it first by commenting on
the GitHub issue that you want to work on it. This is to prevent duplicated
efforts from contributors on the same issue.

## Pull Request Checklist

- Branch from the master branch and, if needed, rebase to the current master
  branch before submitting your pull request. If it doesn't merge cleanly with
  master you may be asked to rebase your changes.

- Commits should be as small as possible, while ensuring that each commit is
  correct independently (i.e., each commit should compile and pass tests).

- Commits should be accompanied by a Developer Certificate of Origin
  (http://developercertificate.org) sign-off, which indicates that you (and
  your employer if applicable) agree to be bound by the terms of the
  [project license](../LICENCE). In git, this is the `-s` option to `git commit`

- If your patch is not getting reviewed or you need a specific person to review
  it, you can @-reply a reviewer asking for a review in the pull request or a
  comment, or you can ask for a review via [email](mailto:info@rustdesk.com).

- Add tests relevant to the fixed bug or new feature.

For specific git instructions, see [GitHub workflow 101](https://github.com/servo/servo/wiki/GitHub-workflow).

## Conduct

https://github.com/rustdesk/rustdesk/blob/master/docs/CODE_OF_CONDUCT.md

## Communication

RustDesk contributors frequent the [Discord](https://discord.gg/nDceKgxnkV).
