# Вклад в RustDesk

RustDesk приветствует вклад каждого. 
Ниже приведены рекомендации, если вы собираетесь помочь нам:

## Вклад в развитие

Вклады в развитие RustDesk или его зависимости должны быть
сделаны в виде `pull request` на GitHub. Каждый такой 
`pull request` будет рассмотрен основным участником 
(кем-то, у кого есть разрешение на влив исправлений) 
и либо помещен в основное дерево, либо Вам будет дан отзыв
о необходимых правках. Все материалы должны соответствовать 
этому формату, даже те, которые поступают от основных авторов. 

Если вы хотите поработать над какой-либо проблемой, то пожалуйста, 
сначала напишите об этом, создав тикет на GitHub, и описав, 
над чем вы хотите поработать. Это делается для того, чтобы 
предотвратить дублирование усилий участников по одному и тому же вопросу.

## Контрольный список для Ваших `pull request`

- Ответвляйтесь от главной ветки и, при необходимости, делайте `rebase` в текущую `master`
  ветку перед отправкой `pull request`. При наличии конфликтов слияния вам будет
  предложено их устранить, возможно при помощи того же `rebase`.

- Коммиты должны быть, по возможности, небольшим, при этом гарантируя, что каждаый
  коммит является независимо правильным (т.е., каждый коммит должен компилироваться и проходить тесты).

- Коммиты должны сопровождаться `Developer Certificate of Origin`
  (http://developercertificate.org) подписью, которая укажет на то, что вы (и
  ваш работодатель, если это применимо) согласны соблюдать условия
  [лицензии проекта](../LICENCE). В `git` это флаг `-s` при использовании `git commit`

- Если ваш патч не проходит рецензирование или вам нужно, 
  чтобы его проверил конкретный человек, Вы можете ответить рецензенту через `@`,
  в обсуждениях вашего `pull request` или Вы можете запросить рецензию через[email](mailto:info@rustdesk.com).

- Добавьте тесты, относящиеся к исправленной ошибке или новой функции.

Для получения конкретных инструкций `git` см. [GitHub workflow 101](https://github.com/servo/servo/wiki/Github-workflow).

## Кодекс поведения участников и вкладчиков

Нормы поведения внутри сообщества подробно описаны [здесь](CODE_OF_CONDUCT-RU.md).

## Общение

RustDesk контрибьюторы могут посетить [Discord](https://discord.gg/nDceKgxnkV).
