// SPDX-License-Identifier: GPL-3.0-or-later
// Copyright (C) 2019-2025 The Sanmill developers (see AUTHORS file)

// ui_colors.dart

import 'package:flutter/material.dart';

/// Color Palate
///
/// Gathered from:
/// https://www.htmlcsscolor.com
/// https://colors.artyclick.com/color-name-finder/
///
/// 100% — FF
/// 95% — F2
/// 90% — E6
/// 85% — D9
/// 80% — CC
/// 75% — BF
/// 70% — B3
/// 65% — A6
/// 60% — 99
/// 55% — 8C
/// 50% — 80
/// 45% — 73
/// 40% — 66
/// 35% — 59
/// 30% — 4D
/// 25% — 40
/// 20% — 33
/// 15% — 26
/// 10% — 1A
/// 5% — 0D
/// 0% — 00

class UIColors {
  const UIColors._();

  static const Color burlyWood = Color(0xFFDEB887);

  static const Color burntSienna = Color(0xFFA15B48);

  static const Color butterflyBlue = Color(0xFF38ACEC);

  static const Color citrus = Color(0xFFA1C50A);

  static const Color cocoaBean = Color(0xFF481C1C);
  static const Color cocoaBean60 = Color(0x99481C1C);

  static const Color darkJungleGreen = Color(0xFF1A2421);

  static const Color darkRoyalBlue = Color(0xFF02066F);

  static const Color floralWhite = Color(0xFFFFFAF0);

  static const Color gondola = Color(0xFF261414);

  static const Color highlighterGreen = Color(0xFF1BFC06);
  static const Color highlighterGreen20 = Color(0x331BFC06);

  static const Color mediumJungleGreen = Color(0xFF1C352D);

  static const Color osloGrey = Color(0xFF878D91);

  static const Color papayaWhip = Color(0xFFFFEFD5);

  static const Color riverBed = Color(0xFF434C59);
  static const Color riverBed60 = Color(0x99434C59);

  static const Color rosewood = Color(0xFF65000B);
  static const Color rosewood20 = Color(0x3365000B);
  static const Color rosewood50 = Color(0x8065000B);

  static const Color seashell = Color(0xFFF1F1F1);
  static const Color seashell50 = Color(0x80F1F1F1);

  static const Color semiTransparentBlack = Color(0x4D000000);

  static const Color spruce = Color(0xFF0A5F38);

  static const Color starDust = Color(0xFF9F9F9C);
  static const Color starDust10 = Color(0x1A9F9F9C);

  static const Color tahitiGold = Color(0xFFE97C07);
  static const Color tahitiGold60 = Color(0x99E97C07);
}
