// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Zulu (`zu`).
class SZu extends S {
  SZu([String locale = 'zu']) : super(locale);

  @override
  String get appName => 'Umlabalaba';

  @override
  String get welcome => 'Siyakwamukela';

  @override
  String get yes => 'Yebo';

  @override
  String get no => 'Cha';

  @override
  String get game => 'Umdlalo';

  @override
  String get humanVsAi => 'Umuntu Vs. I-AI';

  @override
  String get humanVsHuman => 'Umuntu Vs. Umuntu';

  @override
  String get aiVsAi => 'I-AI vs. I-AI';

  @override
  String get humanVsCloud => 'Umuntu Vs. Ifu';

  @override
  String get humanVsLAN => 'Umuntu Vs. I-LAN';

  @override
  String get testViaLAN => 'Hlola Nge-LAN';

  @override
  String get move => 'Hambisa';

  @override
  String get showMoveList => 'Hambisa uhlu';

  @override
  String get moveList => 'Hambisa uhlu';

  @override
  String get noGameRecord => 'Alikho irekhodi';

  @override
  String get ok => 'KULUNGILE';

  @override
  String get confirm => 'Qinisekisa';

  @override
  String get cancel => 'Khansela';

  @override
  String get tipSelectWrong => 'Khetha ucezu olungalungile.';

  @override
  String get tipPlace => 'Beka izingcezu zakho.';

  @override
  String get tipBanPlace => 'Awukwazi ukuyibeka lapha.';

  @override
  String get tipPlaced => 'Ubeke.';

  @override
  String get tipRemove => 'Susa ucezu.';

  @override
  String get tipBanRemove => 'Awukwazi ukukususa.';

  @override
  String get tipRemoved => 'Ususile.';

  @override
  String get tipMove => 'Hambisa ucezu.';

  @override
  String get tipCannotPlace => 'Awukwazi ukubeka ucezu lwakho lapha.';

  @override
  String get tipCannotMove => 'Awukwazi ukuhambisa ucezu lwakho lapha.';

  @override
  String get tipMill => 'Isigayo! Thatha ucezu lombangi wakho.';

  @override
  String get tipContinueMill => 'Qhubeka nokuthatha ucezu lombangi wakho.';

  @override
  String get tipSelectOpponentsPiece =>
      'Khetha ingxenye eyodwa kwezimbangi zakho.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Awukwazi ukususa ucezu emshinini wokugaya.';

  @override
  String get tipCanMoveOnePoint =>
      'Isiqephu singanyakazisa iphoyinti elingu-1.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Awukwazi ukuhambisa izingcezu zomphikisi wakho.';

  @override
  String get tipSelectPieceToMove => 'Khetha ucezu lwakho ukuze uhambise.';

  @override
  String get tipHaveThreePiecesLeft => 'Unezingcezu ezintathu ezisele.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Ungathuthela kunoma yiliphi iphuzu olithandayo.';

  @override
  String tipToMove(Object player) {
    return '$player ukuhambisa.';
  }

  @override
  String get whiteWin => 'Umdlali ongu-1 uyawina!';

  @override
  String get blackWin => 'Umdlali 2 uyawina!';

  @override
  String get won => 'Iwinile';

  @override
  String get lost => 'Ilahlekile';

  @override
  String get thinking => 'Iyacabanga…';

  @override
  String get newGame => 'Umdlalo omusha';

  @override
  String get importGame => 'Ngenisa umdlalo';

  @override
  String get exportGame => 'Thekelisa umdlalo';

  @override
  String get gameImported => 'Umdlalo ungenisiwe.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Ayikwazi ukungenisa $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Ukunyakaza nemithetho akufani.';

  @override
  String get pleaseWait => 'Ngicela ulinde.';

  @override
  String get restartGame => 'Qala kabusha igeyimu yamanje?';

  @override
  String get restart => 'Qala kabusha';

  @override
  String get gameStarted => 'Umdlalo uqalile, sicela ubeke.';

  @override
  String get analyzing => 'Iyahlaziya…';

  @override
  String error(Object message) {
    return 'Iphutha: $message';
  }

  @override
  String get winRate => 'Win Rate';

  @override
  String get score => 'Umphumela:';

  @override
  String get white => 'Umdlali 1';

  @override
  String get black => 'Umdlali 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player isibalo socezu singaphansi kokuthathu.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player ushiye phansi umsebenzi.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player ayinayo indlela yokuhamba.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Ibhodi ligcwele, futhi i-$player ayinayo indlela yokuhamba.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Isikhathi siphelile, i-$player ilahlekile.';
  }

  @override
  String get drawReasonRule50 =>
      'Esigabeni esinyakazayo, akukho siqeshana esisusiwe enanini elithile lokugcina leminyakazo.';

  @override
  String get drawReasonBoardIsFull => 'Kuyi-Draw ngoba ibhodi ligcwele.';

  @override
  String get drawReasonThreefoldRepetition =>
      'I-Draw ngenxa yokuphindaphinda okuphindwe kathathu.';

  @override
  String get gameOverUnknownReason => 'Umdlalo uphelile! Isizathu esingaziwa.';

  @override
  String get gameOver => 'Umdlalo uphelile';

  @override
  String get youWin => 'Uwinile! Siyakuhalalisela!';

  @override
  String challengeHarderLevel(int level) {
    return 'Inselele ileveli enzima? Ileveli entsha izoba ileveli $level!';
  }

  @override
  String get youLose => 'Uyehlulwa!';

  @override
  String get analyze => 'Hlaziya';

  @override
  String get about => 'Mayelana';

  @override
  String version(Object versionNumber) {
    return 'Inguqulo: $versionNumber';
  }

  @override
  String get thanks => 'Ngiyabonga';

  @override
  String get settings => 'Izilungiselelo';

  @override
  String get options => 'Izinketho';

  @override
  String get generalSettings => 'Amasethingi';

  @override
  String get skillLevel => 'Izinga lobunzima';

  @override
  String get moveTime => 'Isikhathi sokucabanga se-AI';

  @override
  String get difficulty => 'Ubunzima';

  @override
  String get playSounds => 'Imiphumela yomsindo';

  @override
  String get playSoundsInTheGame => 'Dlala imisindo emdlalweni';

  @override
  String get keepMuteWhenTakingBack => 'Gcina uthule uma ubuyisela emuva';

  @override
  String get tone => 'Ithoni';

  @override
  String get whoMovesFirst => 'Umnyakazo wokuqala';

  @override
  String get human => 'Umuntu';

  @override
  String get ai => 'I-AI';

  @override
  String get alternate => 'Okunye';

  @override
  String get isAutoRestart =>
      'Qala kabusha ngokuzenzakalelayo umdlalo lapho umdlalo usuphelile';

  @override
  String get isAutoChangeFirstMove =>
      'Shintsha Okuzenzakalelayo Ukuhambisa Kokuqala';

  @override
  String get shufflingEnabled => 'Hambisa ngokungahleliwe';

  @override
  String get misc => 'Okunhlobonhlobo';

  @override
  String get rules => 'Imithetho';

  @override
  String get piecesCount => 'Inombolo yezingcezu umdlali ngamunye anazo';

  @override
  String get piecesCount_Detail => 'Umdlali ngamunye unezingcezu ezingaki?';

  @override
  String get flyPieceCount => 'Inombolo yesiqephu esindizayo';

  @override
  String get flyPieceCount_Detail =>
      'Uma i-Flying inikwe amandla, uma umdlali encishiselwa esibalweni sesiqephu esithile, izingcezu zakhe zikhululekile ukuya kunoma iyiphi indawo engahlali muntu esikhundleni sokukhawulelwa kumaphoyinti aseduze njengakuyo yonke igeyimu.';

  @override
  String get piecesAtLeastCount => 'Izingcezu Okungenani';

  @override
  String get hasDiagonalLines => 'Imigqa ediagonal';

  @override
  String get hasDiagonalLines_Detail =>
      'Faka imigqa emine edayagonali ebhodini.';

  @override
  String get isDefenderMoveFirst => 'Umdlali wesibili uhamba phambili';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Umdlali ohamba okwesibili esigabeni sokubeka uhamba kuqala esigabeni esinyakazayo.';

  @override
  String get mayRemoveMultiple => 'Ukukhipha okuningi';

  @override
  String get mayRemoveMultiple_Detail =>
      'Uma umdlali evala izigayo ezingaphezu kwesisodwa ngesikhathi esisodwa, uzosusa inombolo yezigayo azivalile.';

  @override
  String get mayRemoveFromMillsAlways => 'Bhubhisa izigayo';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Ngokuzenzakalelayo, abadlali kufanele basuse noma yiziphi ezinye izingcezu kuqala ngaphambi kokukhipha ucezu emshinini wokugaya owenziwe. Nika amandla le nketho ukuze ukhubaze umkhawulo.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Umdlali wesibili uyalahlekelwa uma ibhodi seligcwele';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Lapho ibhodi ligcwele ekupheleni kwesigaba sokubeka, uhlangothi olubeka kuqala lulahlekelwa umdlalo. Uma kungenjalo, umdlalo uwukudonsa.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Lahleka uma kungekho mnyakazo wezomthetho';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Umdlali uzolahlekelwa uma imbangi yakhe iwavimba ukuze anganyakaziswa. Shintsha uhlangothi ukuze uhambise uma le nketho ikhutshaziwe.';

  @override
  String get mayFly => 'Ukundiza';

  @override
  String get mayFly_Detail =>
      'Uma umdlali enezingcezu ezintathu noma ezine kuphela (ezilungisekayo) ezisele, angasusa ucezu aluyise kunoma iyiphi indawo yamahhala.';

  @override
  String get nMoveRule => 'Umthetho wokuhambisa uN';

  @override
  String get nMoveRule_Detail =>
      'Umdlalo uyadwetshwa uma kungazange kube khona ukususwa enanini elithile lokunyakaza.';

  @override
  String get rollback => 'I-Rollback';

  @override
  String get pleaseSelect => 'Sicela ukhethe';

  @override
  String get copy => 'Kopisha';

  @override
  String get moveHistoryCopied =>
      'Hambisa umlando okopishwe ebhodini lokunamathisela.';

  @override
  String get help => 'Usizo';

  @override
  String get feedback => 'Impendulo';

  @override
  String get exit => 'Phuma';

  @override
  String get ruleSettings => 'Imithetho';

  @override
  String get color => 'Umbala';

  @override
  String get boardColor => 'Umbala webhodi';

  @override
  String get pieceColor => 'Umbala wocezu';

  @override
  String get backgroundColor => 'Umbala wangemuva';

  @override
  String get lineColor => 'Umbala womugqa webhodi';

  @override
  String get whitePieceColor => 'Umbala wocezu olu-1 lomdlali';

  @override
  String get blackPieceColor => 'Umdlali 2 ucezu umbala';

  @override
  String get messageColor => 'Umbala womlayezo';

  @override
  String get isPieceCountInHandShown =>
      'Bonisa inani lezingcezu ezingabekwanga';

  @override
  String get isNotationsShown => 'Bonisa amanothi ebhodini';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Bonisa ibha yamathuluzi yokuzula yomlando';

  @override
  String get display => 'Bonisa';

  @override
  String get boardBorderLineWidth => 'Ububanzi bomngcele webhodi';

  @override
  String get boardInnerLineWidth => 'Ububanzi bomugqa wangaphakathi webhodi';

  @override
  String get pieceWidth => 'Ububanzi besiqephu';

  @override
  String get fontSize => 'Usayizi wefonti';

  @override
  String get standardNotation => 'Isaziso se-WMD';

  @override
  String get restore => 'Buyisela';

  @override
  String get restoreDefaultSettings =>
      'Buyisela izilungiselelo ezizenzakalelayo';

  @override
  String pick(Object element) {
    return 'Khetha $element';
  }

  @override
  String get info => 'Ulwazi';

  @override
  String get hint => 'Ukusikisela';

  @override
  String get player => 'umdlali';

  @override
  String get player1 => 'Umdlali 1';

  @override
  String get player2 => 'Umdlali 2';

  @override
  String get howToPlay => 'Idlalwa kanjani';

  @override
  String get toPlacePiece =>
      'Thepha kunoma iyiphi indawo etholakalayo ukuze ubeke ucezu.';

  @override
  String get toSelectPiece => 'Thepha ucezu ukuze ulususe.';

  @override
  String get toMovePiece =>
      'Thepha ephuzwini elixhunywe esiqeshaneni ukuze usihambise.';

  @override
  String get toRemovePiece => 'Thepha ucezu olulodwa lombangi ukuze ulususe.';

  @override
  String get needToCreateMillFirst =>
      'Udinga ukudala umshini wokugaya kuqala ngaphambi kokuthi ususe ucezu.';

  @override
  String get needToPlayWithOwnPieces => 'Udinga ukudlala ngezicucu zakho.';

  @override
  String get statistics => 'Izibalo';

  @override
  String get totalGames => 'Imidlalo ephelele';

  @override
  String get results => 'Imiphumela';

  @override
  String get left => 'kwesokunxele';

  @override
  String get privacyPolicy => 'Inqubomgomo yobumfihlo';

  @override
  String get privacyPolicy_Detail_1 =>
      'Sicela ufunde ngokucophelela futhi uqinisekise ukuthi uyaqonda ngokugcwele futhi uyavumelana nalokhu ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Uma ungavumelani nale Nqubomgomo, sicela ungasebenzisi lolu hlelo lokusebenza. Ukusebenzisa uhlelo lokusebenza kusho ukuthi uyayamukela le migomo.';

  @override
  String get and => ' futhi ';

  @override
  String get accept => 'Yamukela';

  @override
  String get takeBack => 'Thatha ubuyisele';

  @override
  String get takingBack => 'Ibuyisela emuva…';

  @override
  String get waiting => 'Ilindile…';

  @override
  String get stepForward => 'Hamba uye phambili';

  @override
  String get takeBackAll => 'Buyisela konke';

  @override
  String get stepForwardAll => 'Hambani phambili nonke';

  @override
  String get moveNow => 'Hambisa manje';

  @override
  String get done => 'Kwenziwe.';

  @override
  String get crackMill => 'Umshini wokugaya';

  @override
  String get crackMill_Detail =>
      'Uma umdlali enezicucu kuphela ezigayweni, izingcezu ezigayweni ngeke zikhiye ukuze zisuswe.';

  @override
  String get animationDuration => 'Ubude besikhathi sokugqwayiza';

  @override
  String get none => 'Lutho';

  @override
  String get theme => 'Itimu';

  @override
  String get helpContent =>
      'Umdlalo uhlose ukushiya isitha sinezinkomo ezingaphansi kwezintathu noma kungekho mnyakazo osemthethweni.\n\nUmdlalo uqhubeka ngezigaba ezintathu:\n\nIsigaba 1:\n\nNgamunye umdlali uqala ngezinkomo ezingu-12 ezibizwa ngokuthi \"cows\".\n\nUmdlalo uqala ngebhodi elicacile, lapho umdlali ngamunye efaka inkomo eyodwa ngasikhathi esisodwa esigabeni esibizwa ngokuthi \"junction\" (circle). Inhloso ukwakha imigqa emithathu emi nkqo, ema-diagonal, noma emi mpo. Izinkomo zingabekwa kuphela emagabeni angahlali muntu.\n\nUma umdlali ethola imigqa emithathu efanayo, angasusa (adubule) enye yenkomo yomphikisi. Umdlali akakwazi ukudubula izinkomo zomphikisi ezisesimweni semigqa emithathu uma kusasele ezinye izinkomo eziningi ebhodini.\n\nUmdlali angadubula inkomo eyodwa yomphikisi ngesikhathi esisodwa, ngisho noma imigqa emibili noma ngaphezulu yemigqa emithathu ifezwa ngesinye isinyathelo.\n\nUma inkomo idutshulwa, ayisayisebenzi futhi emdlalweni.\n\nIsigaba 2:\n\nUma zonke izinkomo eziyishumi nambili zomdlali ngamunye sezifakwe ebhodini, izinkomo zingahamba zisuke esigabeni esisodwa ziye kwesinye. Ukunyakaza kuhilela ukuthutha inkomo esuka esigabeni esisodwa siye kwesinye esingahlali muntu futhi esihlobene ngokuqondile nesigaba sokuqala.\n\nAbadlali bangaphula imigqa yabo yemithathu ukuze bakhe emisha, noma balungise izikhundla zezinkomo zabo.\n\nIzinkomo zingahamba zibuyele emuva naphambili emagabeni amabili afanayo kaninginingi. Umugqa wemithathu ungakhiwa, uphulwe, futhi wakhiwe futhi kaninginingi.\n\nNaphezu komthetho othi imigqa ingaphulwa futhi yakhiwe kabusha kaningi, uma umdlali ephula umugqa ukuze adale omusha wemithathu \"cows\" ngokushesha, lo mdlali akakwazi ukubuyisela leyo nkomo esigabeni sayo sokuqala ngohambo lwakhe olulandelayo uma lokho kudala umugqa omusha.\n\nNjalo uma umugqa wemithathu usungulwa kabusha, inkomo yomphikisi kumele idutshulwe.\n\nIsigaba 3:\n\nUma umdlali esele ngezinkomo ezintathu kuphela, umdlali angahambisa inkomo kunoma yisiphi isigaba esingenamuntu ebhodini ngakunye unyakazo.\n\nUkunqoba umdlalo:\n\nUmdlalo unqotshwa uma umphikisi engasakwazi ukuhambisa noma yiziphi izinkomo: noma uma umphikisi esele ngezinkomo ezimbili kuphela.\n\nUma umdlali esele ngezinkomo ezintathu, futhi akekho umdlali okwazi ukudubula inkomo yomphikisi phakathi kwezinyathelo eziyishumi, umdlalo uthathwa njengodlule ngokulingana.\n';

  @override
  String get versionInfo => 'Ulwazi lwenguqulo';

  @override
  String get eula => 'I-EULA';

  @override
  String get license => 'Ilayisensi';

  @override
  String get sourceCode => 'Ikhodi yomthombo';

  @override
  String get appVersion => 'Inguqulo yohlelo lokusebenza';

  @override
  String get general => 'Okujwayelekile';

  @override
  String get advanced => 'Okuthuthukile';

  @override
  String get placing => 'Ukubeka';

  @override
  String get moving => 'Iyahamba';

  @override
  String get removing => 'Iyasusa';

  @override
  String get gameOverCondition => 'Umdlalo phezu kwesimo';

  @override
  String get aisPlayStyle => 'Indlela yokudlala ye-AI';

  @override
  String get passive => 'Ungenzi lutho';

  @override
  String get timeout => 'Isikhathi siphelile';

  @override
  String get appearance => 'Ukubukeka';

  @override
  String get drawOnHumanExperience => 'Dweba kokuhlangenwe nakho komuntu';

  @override
  String get considerMobility => 'Cabangela ukuhamba kwezingcezu';

  @override
  String get pieceCount => 'Isibalo seziqephu:';

  @override
  String inHand(Object player, int count) {
    return '$player esandleni: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player ebhodini: $count';
  }

  @override
  String get boardTop => 'I-offset yebhodi ukusuka phezulu';

  @override
  String get notAIsTurn => 'Akulona ithuba le-AI.';

  @override
  String get aiIsNotThinking => 'I-AI ayicabangi.';

  @override
  String get atEnd => 'Usekupheleni kohlu lokuhambisa.';

  @override
  String get tapBackAgainToLeave => 'Thepha futhi ukuze uhambe.';

  @override
  String get more => 'Okuningi';

  @override
  String get experimental => 'Kuyisici sokuhlola.';

  @override
  String get experiments => 'Izivivinyo';

  @override
  String get ossLicenses => 'Amalayisense omthombo ovulekile';

  @override
  String get language => 'Ulimi';

  @override
  String get defaultLanguage => 'Ulimi oluzenzakalelayo';

  @override
  String get mayMoveInPlacingPhase => 'Izingcezu zingahamba esigabeni sokubeka';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Azikho izigaba ezihlukile zokubeka nezinyakazayo, okungukuthi, abadlali banganquma kukho konke umnyakazo ukuthi bafuna ukubeka ucezu ebhodini noma bahambise esinye sezingcezu zabo (inqobo nje uma benezicucu ezisele ukuze bazibeke).';

  @override
  String get drawerColor => 'Umbala wemenyu';

  @override
  String get drawerTextColor => 'Umbala wombhalo wemenyu';

  @override
  String get drawerHighlightItemColor => 'Umbala wento egqanyisiwe yemenyu';

  @override
  String get mainToolbarBackgroundColor =>
      'Umbala wangemuva webha yamathuluzi eyinhloko';

  @override
  String get mainToolbarIconColor =>
      'Umbala wesithonjana sebha yamathuluzi eyinhloko';

  @override
  String get navigationToolbarBackgroundColor =>
      'Umbala wangemuva webha yamathuluzi yokuzulazula';

  @override
  String get navigationToolbarIconColor =>
      'Umbala wesithonjana sebha yamathuluzi yokuzulazula';

  @override
  String get autoHideToolbar => 'Fihla ibha yamathuluzi ngokuzenzakalelayo';

  @override
  String get toolbarLocationOnScreen => 'Indawo yebha yamathuluzi esikrinini';

  @override
  String get top => 'Phezulu';

  @override
  String get bottom => 'Phansi';

  @override
  String get center => 'Isikhungo';

  @override
  String get solidColor => 'Umbala oqinile';

  @override
  String get picture => 'Isithombe';

  @override
  String get chooseYourPicture => 'Khetha isithombe sakho';

  @override
  String get light => 'Ukukhanya';

  @override
  String get dark => 'Kumnyama';

  @override
  String get themes => 'Izindikimba';

  @override
  String get currentTheme => 'Itimu yamanje';

  @override
  String get saveTheme => 'Londoloza itimu';

  @override
  String get showAnalysisGraph => 'Bonisa igrafu yokuhlaziya';

  @override
  String get analysis => 'Ukuhlaziya';

  @override
  String get saveGame => 'Londoloza umdlalo';

  @override
  String get loadGame => 'Layisha umdlalo';

  @override
  String get setupPosition => 'Setha indawo';

  @override
  String get showLegalMoves => 'Bonisa iminyakazo esemthethweni';

  @override
  String get showLastMove => 'Bonisa umnyakazo wokugcina';

  @override
  String get showArrows => 'Bonisa imicibisholo';

  @override
  String get pieces => 'Izingcezu';

  @override
  String get showAnalysis => 'Bonisa ukuhlaziywa';

  @override
  String get threads => 'Imicu';

  @override
  String get getInvolved => 'Bandakanya';

  @override
  String get helpImproveTranslate => 'Siza ukuthuthukisa ukuhumusha';

  @override
  String get tutorial => 'Okokufundisa';

  @override
  String get classicMill => 'Isigayo Sakudala';

  @override
  String get mixedMill => 'I-Mixed Mill';

  @override
  String get ceylonMill => 'I-Ceylon Mill';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Isigayo singaphulwa futhi senziwe kabusha ngokuphindaphindiwe';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Uma umdlali ephula isigayo ukuze akhe isigayo esisha ngokushesha, umdlali onjalo angakwazi ukubuyisela ucezu olunjalo endaweni yokuhlangana yasekuqaleni ekuhambeni kwakhe okulandelayo uma enza isigayo esisha.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Umdlalo udwetshwa uma umdlali enezingcezu ezintathu futhi emva kweminyaka eyishumi akekho umdlali osusa izingcezu zomdlali ophikisana naye';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Uma umdlali ehle waba yizicucu ezintathu, futhi kungekho mdlali ongasusa ucezu lombangi phakathi nomnyakazo oyishumi, umdlalo uwumdwebo.';

  @override
  String get close => 'Vala';

  @override
  String get whitePiece => 'Isiqephu esimhlophe';

  @override
  String get blackPiece => 'Isiqephu esimnyama';

  @override
  String get emptyPoint => 'Iphuzu elingenalutho';

  @override
  String get noPoint => 'Akukho phuzu';

  @override
  String get placingPhase => 'Ukubeka isigaba';

  @override
  String get movingPhase => 'Isigaba esinyakazayo';

  @override
  String get flyingPhase => 'Isigaba sokundiza';

  @override
  String sideToMove(Object player) {
    return 'Uhlangothi oluzosuswa: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Umnyakazo wokugcina: $move';
  }

  @override
  String get selected => 'Ikhethiwe';

  @override
  String get accessibility => 'Ukufinyeleleka';

  @override
  String get screenReaderSupport => 'Usekelo lwesifundi sesikrini';

  @override
  String get isDraw => 'I-Draw!';

  @override
  String get draw => 'Dweba';

  @override
  String get pieceHighlightColor => 'Umbala wokugqamisa ucezu';

  @override
  String get algorithm => 'I-algorithm';

  @override
  String get endgameNMoveRule => 'Ukuphela komdlalo umthetho we-N-Move';

  @override
  String get endgameNMoveRule_Detail =>
      'Umdlalo udwetshwa uma omunye umdlali enezingcezu ezintathu kuphela futhi akekho umdlali osusa ucezu phakathi nokunyakaza okuthile.';

  @override
  String get drawReasonEndgameRule50 =>
      'Noma yimuphi umdlali unezicucu ezintathu kuphela, futhi akekho umdlali osusa ucezu phakathi nokunyakaza okuthile.';

  @override
  String get threefoldRepetitionRule => 'Umthetho wokuphindaphinda okuthathu';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Umdlalo udwetshwa uma indawo yenzeka okwesithathu.';

  @override
  String get continueToMakeMove => 'Isigayo! Qhubeka nokwenza umnyakazo.';

  @override
  String get pointStyle => 'Isitayela sephoyinti';

  @override
  String get pointWidth => 'Ububanzi bephoyinti';

  @override
  String get solid => 'Okuqinile';

  @override
  String get hollow => 'Okungenalutho';

  @override
  String get languageName => 'isiZulu';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Ukuhamba',
      one: '$count Hambisa',
      zero: 'Move',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Ukulayisha kwehlulekile.';

  @override
  String get filename => 'Igama lefayela';

  @override
  String get browse => 'Phequlula…';

  @override
  String get gameFiles => 'Amafayela wegeyimu';

  @override
  String get gameSavedTo => 'Umdlalo ulondolozwe ku';

  @override
  String get empty => 'Akunalutho';

  @override
  String get noMove => 'Akukho umnyakazo.';

  @override
  String get restoredPosition => 'Kubuyiselwe indawo yokuqala.';

  @override
  String get clean => 'Hlanza';

  @override
  String get cleanedUp => 'Kuhlanzwe.';

  @override
  String get remove => 'Susa';

  @override
  String get noPiecesCanBeRemoved => 'Azikho izingcezu ezingasuswa.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count izingcezu',
      one: '$count ucezu',
      zero: 'Piece',
    );
    return '$_temp0 kudingeka zisuswe.';
  }

  @override
  String placedCount(int count) {
    return 'Kubekwe ($count)';
  }

  @override
  String get placedPieceCount =>
      'Isibalo sezingcezu esibekwe esigabeni sokubeka.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Umdlali wamanje ubeke $count izingcezu.';
  }

  @override
  String get notPlacingPhase => 'Ayibeki isigaba, ayikwazi ukusishintsha.';

  @override
  String get paste => 'Namathisela';

  @override
  String get pasteDone => 'Ukunamathisela kwenziwe.';

  @override
  String get cannotPaste => 'Ayikwazi ukunamathisela.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Bonisa izingcezu ezingabekwanga nezisusiwe';

  @override
  String get fullScreen => 'Iskrini esigcwele';

  @override
  String get reopenToTakeEffect =>
      'Phuma futhi uvule kabusha uhlelo lokusebenza ukuze izilungiselelo zisebenze.';

  @override
  String get forest => 'Ihlathi';

  @override
  String get desktopImage => 'Isithombe sedeskithophu';

  @override
  String get invalidPosition => 'Indawo engavumelekile.';

  @override
  String get shareGIF => 'Yabelana nge-GIF';

  @override
  String get pixelRatio => 'Isilinganiso sephikseli';

  @override
  String get duration => 'Ubude besikhathi';

  @override
  String get gameScreenRecorder => 'Irekhoda yesikrini segeyimu';

  @override
  String get previous => 'Ngaphambilini';

  @override
  String get next => 'Olandelayo';

  @override
  String get skip => 'Yeqa';

  @override
  String get gotIt => 'Ngiyitholile';

  @override
  String get youCanModifyRules =>
      'Ungashintsha imithetho yomdlalo kuzilungiselelo zokubusa.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Ungasebenzisa isondo legundane ukuze ushintshe inani kusikhi.';

  @override
  String get noTimeLimitForThinking =>
      'Isikhathi sokucabanga se-AI sibekwe ku-0 sisho ukuthi asikho isikhathi sokucabanga.';

  @override
  String get whatIsMtdf =>
      'I-MTD(f) iwuhlobo olulungisiwe lwe-alpha-beta yokusesha i-algorithm ehlose ukuthuthukisa ukusebenza kahle ngokusebenzisa kabusha imiphumela yosesho emaphakathi nokusebenzisa ukuqagela kokuqala okuhle ukuze unciphise isikhala sosesho.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Sicela uqaphele ukuthi ukulungiswa kwesikhathi sokucabanga kwe-AI kungase kungabi nembayo ngokuphelele. Isikhathi sangempela sokucabanga singase sibe sifushane lapho ileveli yobunzima isethelwe kunani eliphansi futhi ingaba yinde uma i-AI imaphakathi nomcabango lapho isikhathi siphela.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Uma usetha izinga lobunzima phezulu kodwa ungakhulisi isikhathi sokucabanga se-AI, izinga lobunzima langempela lingase likhawulelwe kunani eliphansi ngenxa yesithiyo sesikhathi sokucabanga. Inani langempela lingahluka ngokusekelwe ekusebenzeni komshini.';

  @override
  String get whatIsPvs =>
      'I-PVS (I-Principal Variation Search) iyi-algorithm yokusesha yokuthola umnyakazo ongcono kakhulu endaweni ethile. Kuwukuthuthukiswa kwe-algorithm ye-alpha-beta futhi kusebenzisa ukusesha kwewindi okungenalutho noma okuyiziro ukuze kuqinisekiswe ukuthi ukuthutha kubi noma akukubi kakhulu kunomphumela osuvele uphephile kusukela kokuhluka okuyinhloko. I-PVS igxile ekunyakazeni okuthembisa kakhulu futhi igwema ukusesha okungadingekile kwamagatsha angaphansi, okusiza ukuthuthukisa ukusebenza kahle kosesho.';

  @override
  String get whatIsAlphaBeta =>
      'I-alpha-beta algorithm iyi-algorithm yokusesha ukuze uthole umnyakazo ohamba phambili. Isebenzisa isimiso se-minimax namanani amabili, i-alpha ne-beta, ukuthena isihlahla sokusesha nokwandisa ukusebenza kahle. I-Alpha imele amaphuzu amancane ikhompuyutha eqinisekile ukuthi ingawathola, kuyilapho i-beta imele amaphuzu aphezulu angatholwa isitha sayo. I-algorithm isiza ikhompuyutha ukwenza izinqumo ezihlakaniphile, ezisebenzayo emdlalweni.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Ngokusho kokuhlangenwe nakho kwabantu, uma uzama ukunqoba, uzolahlekelwa. Esikhundleni salokho, hlose ukudweba njengomgomo wakho futhi ugweme ukulahlekelwa umdlalo. Bheka umphikisi wakho futhi umyenge ngobumnene endaweni lapho engenza khona amaphutha. Lapho bebonisa ubuthakathaka, bamba ithuba bese ucindezela ngobumnene ukunqoba. Ngale ndlela, ungakwazi ukunqoba umdlalo.';

  @override
  String get firstMoveDetail =>
      'Kulo mdlalo kulula ukuthi umdlali wesibili awine uma kuqhathaniswa nowokuqala.';

  @override
  String get passiveDetail =>
      'Ukunika amandla inketho ye-Passive kuzobangela i-AI ukuthi ikhululeke uma inenzuzo endaweni, kunokuzama ukuwina ngokushesha okukhulu.';

  @override
  String get moveRandomlyDetail =>
      'Ukunika amandla le nketho kukhulisa ukungahleleki nobumnandi begeyimu ngenkathi uyikhubaza kungasiza izindlela zokufunda zokushaya i-AI.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Uma i-AI icabangela ukuhamba kwezingcezu zayo, ngeke nje ihlose ukuthwebula izingcezu zombangi ngokushesha okukhulu, kodwa futhi icabange ukuvimba umnyakazo wesitha nokubavimbela ekwenzeni okufanayo.';

  @override
  String get whenBoardIsFull => 'Lapho ibhodi ligcwele';

  @override
  String get whenBoardIsFull_Detail =>
      'Ekupheleni kwesigaba sokubeka, ngaphambi kokuba isigaba esinyakazayo siqale, isenzo silandela uma ibhodi ligcwele izingcezu.';

  @override
  String get sideToMoveRemovePiece =>
      'Umdlali ohamba kuqala esigabeni esinyakazayo ususa ingxenye eyodwa kwezimbangi.';

  @override
  String get agreeToDraw => 'Zombili izinhlangothi zivumelana ngokulingana.';

  @override
  String get takeOpponentsPiece => 'Thatha enye yezingcezu zombangi wakho.';

  @override
  String get firstPlayerLose => 'Umdlali wokuqala uhlulwa umdlalo.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Umdlali wokuqala nowesibili basusa izingcezu zesitha.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Umdlali wesibili nowokuqala basusa izingcezu zesitha.';

  @override
  String get enteredFlyingPhase =>
      'Manje sekungene isigaba sokundiza, izingcezu zomphikisi zingagxumela kunoma iyiphi indawo engenalutho ebhodini. Ungakwazi ukuvala umthetho endizayo kokuthi \"Izilungiselelo Zomthetho\".';

  @override
  String get whenStalemate => 'Lapho i-stalemate';

  @override
  String get whenStalemate_Detail =>
      'Isiphi isenzo esilandelayo lapho ucezu lungasuswa?';

  @override
  String get endWithStalemateLoss =>
      'Phelisa ngokulahlekelwa okumile ohlangothini oluvinjiwe.';

  @override
  String get changeSideToMove => 'Shintsha uhlangothi ukuze uhambise.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Susa eyodwa yezingcezu zombangi bese wenza umnyakazo olandelayo.';

  @override
  String get endWithStalemateDraw => 'Qeda ngokulingana okumile.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Susa eyodwa yezingcezu zombangi bese ushintsha uhlangothi ukuze uhambise.';

  @override
  String get aiResponseDelayTime =>
      'Isikhathi sokulibaziseka kwempendulo ye-AI';

  @override
  String get aiIsDelaying =>
      'I-AI okwamanje isesigabeni sokuphendula esibambezelekile. Sicela ulinde isikhashana ngaphambi kokuthi uqhubeke.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Awukwazi ukususa ucezu olungasondelene.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Uma kumile, izingcezu zombangi ezincikene nezakho zingasuswa, kungakhathaliseki ukuthi ukwakheka kwesigayo.';

  @override
  String get whatIsMcts =>
      'I-MCTS iyi-algorithm elungele abaqalayo eyenza izinqumo ngokuhlola nokuhlola ukunyakaza okuhlukile ngokulingisa.';

  @override
  String get goldenJade => 'I-Golden Jade';

  @override
  String get forestWood => 'Ihlathi Lezinkuni';

  @override
  String get darkMystery => 'Imfihlakalo Emnyama';

  @override
  String get midnightBlue => 'Ubusuku obuluhlaza';

  @override
  String get greenForest => 'Ihlathi Eliluhlaza';

  @override
  String get greenMeadow => 'I-Green Meadow';

  @override
  String get stonyPath => 'I-Stony Path';

  @override
  String get pastelPink => 'I-Pastel Pink';

  @override
  String get turquoiseSea => 'I-Turquoise Sea';

  @override
  String get violetDream => 'Iphupho le-Violet';

  @override
  String get mintChocolate => 'I-Mint Chocolate';

  @override
  String get skyBlue => 'Isibhakabhaka Esiluhlaza';

  @override
  String get playfulGarden => 'Ingadi Edlalwayo';

  @override
  String get whatIsRetrogradeAnalysis =>
      'I-algorithm ye-Retrograde Analysis isebenzisa ukuhlaziya okunenani eliningi lokubuyisela emuva ukuze kwakhiwe isizindalwazi somdlalo wokugcina kusuka ezindaweni ezihlukene zokuqala, bese isebenzisa le sizindalwazi ukuze kulungiselelwe ukudlala umdlalo. Le ndlela ingena ngaphansi kwesigaba sezixazululo ze-Ultra-Strong.';

  @override
  String get viewAlgorithmGuide =>
      'Ungathanda ukubuka umhlahlandlela womsebenzisi wale algorithm?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Bonisa inkomba yenzuzo yendawo';

  @override
  String get usePerfectDatabase => 'Sebenzisa i-database ephelele';

  @override
  String get perfectDatabaseDescription =>
      'Nika amandla le nketho ukuze usebenzise isizindalwazi segeyimu esingenasici esikhiqizwe ngama-algorithms asezingeni eliphezulu. Lesi sici sihlanganisa kokubili amasu okuvula nawokuqeda ukuphakamisa umnyakazo olungile. Lokhu ukukhetha okuncanyelwayo kwabadlali abafuna ileveli ephezulu yokunemba ekudlalweni kwegeyimu. Idalwe ngamasu ekhompyutha ahlakaniphile, isizindalwazi siklanyelwe ukunikeza izixazululo zegeyimu ezicishe ziphelele.\n\nQaphela: Uma i-AI ihluleka ukufinyelela kusizindalwazi, izophendukela kuma-algorithms avamile ezinqumweni zokudlala umdlalo. Uma isizindalwazi sitholakala, \'Izinga Lobunzima\' licishe lingehluleki, futhi \'Isikhathi Sokucabanga Se-AI\' sithola ukuncipha okukhulu. Izilungiselelo eziningi ezingaphakathi kwezinketho ze-\'AI\'s play style\' zizokhishwa, njengoba imiphumela yesizindalwazi ibambe phezulu kakhulu.\n\nUkuze uthole umhlahlandlela wokuthi ungayisebenzisa kanjani ngokugcwele le database engenasici, chofoza lapha.';

  @override
  String get backgroundImage => 'Isithombe semva';

  @override
  String get whatIsRandom =>
      'Uma inketho ethi \'Sebenzisa isizindalwazi esiphelele\' ingavunyelwe, ukulungiselelwa \'okungahleliwe\' kubangela i-AI ukuthi ihambise izingcezu ngokungahleliwe ngaphandle kokusebenzisa noma yimaphi ama-algorithms ekukhetheni ukunyakaza. Lokhu ngokuvamile kuholela ekudlalweni kwegeyimu okubuthakathaka kakhulu. Ngokuphambene, lapho \'Sebenzisa idatha egciniwe ephelele\' inikwe amandla, i-AI incike ngokukhethekile \'Kusizindalwazi Esiphelele\' ukuze senze izinqumo, esikhundleni sokuyihlanganisa nama-algorithms endabuko e-AI. Kule modi, ukunyakaza kwe-AI kusekelwe ngokuphelele kokuqukethwe kusizindalwazi, kugwenywa ukuthembela ekubaleni kwesikhathi sangempela noma ama-algorithm okusesha.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Susa ingcezu (izingcezu) zomphikisi esandleni sakhe; bese kuba yithuba lomphikisi lokubeka.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Lapho wakha ama-mills ngesikhathi sokubeka';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Susa ingcezu (izingcezu) zomphikisi ebhodini.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Susa ingcezu (izingcezu) zomphikisi ebhodini; bese kuba yithuba lomphikisi lokubeka.';

  @override
  String get opponentRemovesOwnPiece =>
      'Umphikisi ususa ingcezu yakhe (izingcezu) ebhodini.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Esikhundleni sokuba nguwe othatha isinyathelo, umphikisi ukhetha futhi asuse ingcezu yakhe (izingcezu) ebhodini, ngaleyo kwalokho enza isenzo esilimazayo kuye.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Susa ingcezu  (izingcezu) zomphikisi esandleni sakhe; bese kuba lithuba lakho lokuhamba.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Susa ingcezu (izingcezu) esandleni somphikisi. Uma, ngokuvumelana nokusetha kokususwa okuningi, izinhlayiya eziningi kufanele zisuswe futhi umphikisi engasekho nezingcezu esandleni, qhubeka ususa izingcezu zomphikisi ebhodini. Khona-ke, yithuba lakho lokuhamba. Uma uqhubeka wakha ama-mill, ungaqhubeka ususa izingcezu zomphikisi.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Susa ingcezu (izingcezu) esandleni somphikisi. Uma, ngokuvumelana nokusetha kokususwa okuningi, izinhlayiya eziningi kufanele zisuswe futhi umphikisi engasekho nezingcezu esandleni, qhubeka ususa izingcezu zomphikisi ebhodini. Khona-ke, kuba yithuba lomphikisi.';

  @override
  String get markAndDelayRemovingPieces =>
      'Maka bese unqanda ukususa izingcezu.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Ngesikhathi sokubeka, izingcezu ezizosuswa ziyophawulwa, futhi kokubili abadlali, akukho zingcezu ezintsha ezingabekwa kula maphuzu. Lapho ungena esigabeni sokuhambisa, lezi zingcezu ezimakiwe ziyasuswa ngokuphelele, futhi abadlali bangakwazi ukuhambisa izingcezu zabo kula maphuzu manje angenalutho.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Izinyathelo ezingathathwa lapho kwenziwa amakhaya ngesikhathi sesigaba sokubeka.';

  @override
  String get marked => 'Uphawulwe';

  @override
  String get menu => 'Imenyu';

  @override
  String get monochrome => 'I-Monochrome';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Ungavula ukusekelwa kwesikrini esifundi ku-General Settings kuzilungiselelo zokufinyelela.';

  @override
  String get showNumbersOnPieces => 'Khombisa izinombolo kumaphuzu';

  @override
  String get saveImage => 'Hlela Isithombe';

  @override
  String get isAnalysisToolbarShown => 'Khombisa iziqu zokusekela ukuhlaziywa';

  @override
  String get analysisToolbarBackgroundColor =>
      'Umbala wesikali sesibhakabhakhi seziqu zokusekela ukuhlaziywa';

  @override
  String get analysisToolbarIconColor =>
      'Umbala wesithonjana seziqu zokusekela ukuhlaziywa';

  @override
  String get transformed => 'Ihlanganiswe.';

  @override
  String get cannotTransform => 'Ngikwazi ukungahlukaniswa.';

  @override
  String get rotate => 'Hlela';

  @override
  String get horizontalFlip => 'H Ibhlophu';

  @override
  String get verticalFlip => 'V Ibhlophu';

  @override
  String get innerOuterFlip => 'IO Ibhlophu';

  @override
  String get transparentCanvas => 'I-Canvas Esobala';

  @override
  String get restrictRepeatedMillsFormation =>
      'Khawulela Ukwakheka Kabusha Kwezimbokodo';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Ucezu oluhambile kusukela kolunye usimende ukuya kolunye alukwazi ukubuyela ngokushesha endaweni yoqobo kujike elilandelayo ukwakha usimende futhi. Kuqala kudingeka enye inyakazo.';

  @override
  String get oneTimeUseMill => 'Isigayo sokusetshenziswa kanye';

  @override
  String get oneTimeUseMill_Detail =>
      'Isigayo ngasinye singasusa isiqeshana somphikisi kanye kuphela. Ungasiphinda futhi, kodwa ngeke usisebenzisele ukususa okwengeziwe.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Imithetho yamanje osuyimiselile ayinayo i-database ephelele ehambisanayo. Ukuthola imininingwane engaphezulu mayelana ne-database ephelele, sicela uchofoze lapha.';

  @override
  String get focusOnBlockingPaths => 'Gxila ekuvinjweni kwemizila';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Nikeza phambili ekuphazamiseni ukuhamba kwesitha kunezindleko zokwakha amamili. Esikhundleni sokugxila ekuqedeni izingcezu ngokugcwalisa amamili, i-AI ihlose ukuheha isitha, ukwenza bahluleke ukunyakaza kanye nokuqinisekisa ukunqoba ngokusebenzisa ukufaka engcupheni kunokudlala ngonya. Leli su alivaleli amamili esitha ngendlela ephambili.';

  @override
  String get pieceImage => 'Isithombe somkhandi';

  @override
  String get importColorSettings => 'Ngenisa izilungiselelo zombala';

  @override
  String get exportColorSettings => 'Thumela izilungiselelo zombala';

  @override
  String get import => 'Ngenisa';

  @override
  String get export => 'Thumela';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Sicela ukopishe izilungiselelo zefomethi ye-JSON ku-clipboard kuqala.';

  @override
  String get copiedToClipboard => 'Ikhopishwe ku-clipboard.';

  @override
  String get imported => 'Kungenisiwe.';

  @override
  String get boardImage => 'Isithombe sebhodi';

  @override
  String get autumnLeaves => 'Amacembe Ekwindla';

  @override
  String get legendaryLand => 'Izwe Elidumile';

  @override
  String get vignetteEffect => 'Umphumela we-vignette';

  @override
  String get promptMakeToolbarTransparent =>
      'Ungathanda ukwenza ibha yamathuluzi ifanekane ngokuphelele uma isithombe sangemuva sebhodi sisethwe?';

  @override
  String get vibration => 'Vumela ukuzamazama emdlalweni';

  @override
  String get soundTheme => 'Itimu yomculo';

  @override
  String get ball => 'Ibhola';

  @override
  String get liquid => 'Uchwepheshe';

  @override
  String get wood => 'Izinkuni';

  @override
  String get placeEffectAnimation => 'Umphumela we-animation wokubeka ucezu';

  @override
  String get removeEffectAnimation => 'Umphumela we-animation wokususa ucezu';

  @override
  String get isToolbarAtBottom => 'Khombisa ibha yamathuluzi ezansi';

  @override
  String get boardCornerRadius => 'Iradiusi yekona yebhodi';

  @override
  String get useOpeningBook => 'Sebenzisa incwadi yokuvula';

  @override
  String get currentRule => 'Okwamanje';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Isethi yemithetho';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Vumela i-AI ukuthi isebenzise ukuvula amanyathelo ajwayele ukusetshenziswa ngabadlali abaqeqeshiwe abantu ekuqaleni komdlalo. Qaphela: Lesi sici sitholakala okwamanje kumasethi womthetho athize kuphela.';

  @override
  String get showAdvantageGraph => 'Khombisa ishadi lezinzuzo';

  @override
  String get advantageGraphHint =>
      'Ishadi lezinzuzo lizodwetshwa kuphela emva kokuthi i-AI yenze umnyakazo. Alizukudwetshwa uma umdlali womuntu enza umnyakazo.';

  @override
  String get removalBasedOnMillCounts =>
      'Misa ukususwa kuze kufakwe wonke amaphinikhodi. Abadlali basusa amaphinikhodi ngokuya ngenani lama-Umlabalaba.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Misa ukususwa kuze kufakwe wonke amaphinikhodi. Abadlali basusa amaphinikhodi ngokuya ngenani lama-Umlabalaba: uma elilinganayo, bobabili basusa inani elifanayo lamaphinikhodi; uma omunye eningi, ususa elilodwa elengeziwe, egcina umehluko owodwa. Uma oyedwa enza i-Umlabalaba, ususa amaphinikhodi amabili, omunye asuse elilodwa. Uma bengakwenzi kokubili i-Umlabalaba, bobabili basusa elilodwa.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Khetha esinye sezicezu zakho.';

  @override
  String get notYourTurn => 'Akulona ithuba lakho.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Umbala wengemuva yethulbha yezichasiselo';

  @override
  String get annotationToolbarIconColor =>
      'Umbala we-icon yethulbha yezichasiselo';

  @override
  String get isAnnotationToolbarShown => 'Khombisa ithulbha yezichasiselo';

  @override
  String get enterAnnotationMode => 'Ngena kumodi yezichasiselo';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Uqinisekile ukuthi ufuna ukusula zonke izichasiselo?';

  @override
  String get llmPromptCopiedToClipboard =>
      'Isikhuthazo se-LLM sikopishiwe ekubhodini lokunamathisela.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Ukuxhumana kunqatshelwe, isiphakeli kungenzeka siphansi.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Ukuthola kuphumelele, kulindelwe ukuxhumana...';

  @override
  String get noLanConnection => 'Akukho ukuxhumana kwe-LAN';

  @override
  String get takeScreenshot => 'Thatha isithombe-skrini';

  @override
  String get disconnectedFromOpponent => 'Unqanyuliwe kumbangi.';

  @override
  String get takeBackRequest => 'Isicelo Sokubuyisela Emuva';

  @override
  String get nothingToShow => 'Akukho okumele kuboniswe.';

  @override
  String get stopHosting => 'Yeka ukubamba';

  @override
  String get connectionResetByPeer => 'Ukuxhumana kuqalwe kabusha ngontanga.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Ukuxhumana kulahlekile ngenxa yesikhathi sokushaya kwenhliziyo siphelile. Sicela uxhumane kabusha.';

  @override
  String get startHosting => 'Qala ukubamba';

  @override
  String get restartRequestRejected => 'Isicelo sokuqala kabusha sinqatshelwe.';

  @override
  String get notConnectedToLanOpponent => 'Akuxhunyiwe kumbangi we-LAN.';

  @override
  String get llmPrompt => 'Isikhuthazo se-LLM';

  @override
  String get gameRestarted => 'Umdlalo uqalwe kabusha.';

  @override
  String get takeBackRejected => 'Ukubuyisela emuva kunqatshelwe.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Uqinisekile ukuthi ufuna ukuyeka lo mdlalo?';

  @override
  String get opponentResignedYouWin => 'Umbangi uyekile. Uwine!';

  @override
  String get clearAllAnnotations => 'Sula zonke izichasiselo';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Uxhunyiwe, ulindele umnyakazo wombangi...';

  @override
  String get networkStatusDisconnected => 'Isimo senethiwekhi: Unqanyuliwe';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Isicelo sokubuyisela emuva sithunyelwe kumbangi.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Umbangi kungenzeka ushiye umdlalo';

  @override
  String get connectedToHostSuccessfully => 'Uxhunyiwe kumbambi ngempumelelo.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Ukuxhumana kulahlekile: isikhathi sokushaya kwenhliziyo siphelile';

  @override
  String get noHostDiscovered => 'Akukho mbambi otholiwe.';

  @override
  String get confirmResignation => 'Qinisekisa ukuyeka';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Iqale ukubamba umdlalo, ilindele abadlali ukuthi bajoyine...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Ukuxhumana kuphelelwe yisikhathi, ukuxhumana kwenethiwekhi akuzinzile.';

  @override
  String get noLlmPromptAvailable =>
      'Asikho isikhuthazo se-LLM esitholakalayo.';

  @override
  String get youResignedGameOver => 'Uyekile. Umdlalo uphelile.';

  @override
  String get serverIp => 'IP yesiphakeli';

  @override
  String get confirmClear => 'Qinisekisa ukusula';

  @override
  String get opponentSTurn => 'Ithuba lombangi.';

  @override
  String get waitingAClientConnection => 'Ilindele ukuxhumana kweklayenti...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Isicelo sokubuyisela emuva sinqatshelwe noma sihlulekile.';

  @override
  String get addText => 'Nezela umbhalo';

  @override
  String get exitAnnotationMode => 'Phuma kumodi yezichasiselo';

  @override
  String get typeYourAnnotation => 'Thayipha isichasiselo sakho';

  @override
  String get attemptingToReconnect => 'Izama ukuxhuma kabusha...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Isicelo sokuqala kabusha sithunyelwe. Ilindele impendulo yombangi...';

  @override
  String get serverIsStopped => 'Isiphakeli simisiwe.';

  @override
  String get restartRequest => 'Isicelo sokuqala kabusha';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Awukwazi ukucela ukubuyisela emuva uma kungesona ithuba lakho.';

  @override
  String get takeBackAccepted => 'Ukubuyisela emuva kwamukelwe.';

  @override
  String get localNetworkSettings => 'Izilungiselelo zenethiwekhi yendawo';

  @override
  String get reconnectedSuccessfully => 'Uxhunyiwe kabusha ngempumelelo!';

  @override
  String get failedToSaveImageToGallery =>
      'Kuhlulekile ukugcina isithombe kugalari.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Umbangi ucele ukuqala kabusha umdlalo. Uyamukela?';

  @override
  String get yourTurn => 'Ithuba lakho.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Akukwazeki ukuxhuma kabusha, sicela uqale kabusha umdlalo.';

  @override
  String get host => 'Umbambi';

  @override
  String get join => 'Joyina';

  @override
  String get port => 'Ichweba';

  @override
  String get invalidIpAddress => 'Ikheli le-IP elingavumelekile.';

  @override
  String get invalidPort => 'Ichweba elingavumelekile.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Ukuxhuma: Umzamo $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Kuhlulekile ukuxhuma: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Kuhlulekile ukuqala ukubamba: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Umbambi utholiwe: $ip:$port';
  }

  @override
  String get stop => 'Yeka';

  @override
  String get discover => 'Thola';

  @override
  String get connect => 'Xhuma';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Iklayenti lixhunyiwe: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Ukuthola: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Ukuxhuma kabusha ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Uxhunyiwe';

  @override
  String get delete => 'Susa';

  @override
  String get ancientEgypt => 'I-Egypt Yasendulo';

  @override
  String get gothicIce => 'Iqhwa le-Gothic';

  @override
  String get riceField => 'Insimu Yelayisi';

  @override
  String get chinesePorcelain => 'I-Porcelain YaseShayina';

  @override
  String get desertDusk => 'Ukuhwalala Kwasogwadule';

  @override
  String get precisionCraft => 'Umsebenzi Wokucophelela';

  @override
  String get folkEmbroidery => 'Ukufekethiswa Kwesintu';

  @override
  String get carpathianHeritage => 'Ifa LaseCarpathian';

  @override
  String get imperialGrandeur => 'Ubukhazikhazi Bombuso';

  @override
  String get bohemianCrystal => 'I-Bohemian Crystal';

  @override
  String get savannaSunrise => 'Ukuphuma Kwelanga eSavanna';

  @override
  String get harmonyBalance => 'Ukuvumelana Nokulinganisela';

  @override
  String get cinnamonSpice => 'Isinongo Sesinamoni';

  @override
  String get anatolianMosaic => 'I-Mosaic Yase-Anatolian';

  @override
  String get carnivalSpirit => 'Umoya Womkhosi';

  @override
  String get custom => 'Isiko';

  @override
  String get spiceMarket => 'Imakethe yezinongo';

  @override
  String get swipeToRevealTheDrawer => 'Swipe ukuze uveze iDrawer';

  @override
  String get showGameInfoOnScreenshots =>
      'Bonisa imininingwane yomdlalo ezithombeni zesikrini';

  @override
  String get humanMoveTime => 'Umkhawulo wesikhathi somuntu';

  @override
  String get noTimeLimitForHumanMoves =>
      'Awukho umkhawulo wesikhathi ekunyakazeni komuntu';

  @override
  String get timeoutLoseWillBeApplied =>
      'Ukulahlekelwa ngenxa yokuphelelwa isikhathi kuzosetshenziswa kumdlali ongumuntu';

  @override
  String get identifyingBoard => 'Kutholwa ibhodi lomdlalo...';

  @override
  String get youCanEnterAnyModelName => 'Ungafaka noma yiliphi igama lemodeli.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Isikhundla sebhodi lomdlalo sisebenzisiwe. FEN ikhophiwe ebhodini lokunamathisela.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Isiphakamiso: zama ukuthatha isithombe esicacile sebhodi lomdlalo.';

  @override
  String get llmPromptTemplate => 'Ithemplethi ye-prompt ye-LLM';

  @override
  String get noValidBoardDetected =>
      'Akukho bhodi elivumelekileyo elitholakele.';

  @override
  String get selectingImageFromAlbum => 'Kukhethwa isithombe ku-albhamu...';

  @override
  String get configurePromptTemplate => 'Lungisa ithemplethi ye-prompt';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Hlela ithemplethi ye-prompt yokuhlaziywa kwe-LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Kwehlulekile ukukhiqiza i-FEN ebhodini elitholiwe.';

  @override
  String get outputInCurrentLanguage => 'Khipha ngolimi lwamanje';

  @override
  String get commonBaseUrls => 'Ama-Base URL ajwayelekile';

  @override
  String get viewCommonModels => 'Buka amamodeli ajwayelekile';

  @override
  String get recognitionParametersUpdated =>
      'Amapharamitha wokuhlonza abuyekezwe.';

  @override
  String get whiteSMove => 'Ukuhamba komhlophe';

  @override
  String get resetToDefaults => 'Setha kabusha kuzilungiselelo ezenzakalelayo';

  @override
  String get photoShoot => 'Ukuthatha izithombe';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Kwehlulekile ukusebenzisa isikhundla sebhodi elimaziwe.';

  @override
  String get llmPromptContent => 'Okuqukethwe kwe-prompt ye-LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'I-LLM ayikalungiswa. Sicela uhlole izilungiselelo zakho.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Setha umphakeli, imodeli, API Key, ne-Base URL';

  @override
  String get llmConfiguration => 'Ukulungiselelwa kwe-LLM';

  @override
  String get configureLlmProvider => 'Lungisa umphakeli we-LLM';

  @override
  String get llmPromptTemplateHeader =>
      'Isihloko sethemplethi ye-prompt ye-LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Akukho maqhekeza womdlalo atholakele esithombeni. Sicela uzame futhi.';

  @override
  String get recognizeBoardFromImage => 'Hlonza ibhodi lomdlalo esithombeni';

  @override
  String get viewTips => 'Buka amathiphu';

  @override
  String get applyToBoard => 'Faka ebhodini lomdlalo';

  @override
  String get adjustBoardArea => 'Lungisa indawo yebhodi lomdlalo';

  @override
  String get viewCommonUrls => 'Buka ama-URL ajwayelekile';

  @override
  String get colorAnalysisFailed => 'Ukuhlaziya imibala kwehlulekile!';

  @override
  String get analyzingGameBoardImage =>
      'Kuhlaziywa isithombe sebhodi lomdlalo...';

  @override
  String get selectFromAlbum => 'Khetha ku-albhamu';

  @override
  String get noBoardPointDetected => 'Akukho iphuzu lebhodi elitholakele!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Uma kushiywe kungagcwaliswanga, ithemplethi ezenzakalelayo izosetshenziswa';

  @override
  String get llmConfig => 'Ukulungiselelwa kwe-LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Uqinisekile ukuthi ufuna ukusetha kabusha amathempulethi we-prompt kwamanani ezenzakalelayo?';

  @override
  String get llmPromptTemplateFooter =>
      'Isiphetho sethemplethi ye-prompt ye-LLM';

  @override
  String get loadingResponse => 'Kulayishwa impendulo...';

  @override
  String get applyThisResultToBoard => 'Faka le miphumela ebhodini lomdlalo';

  @override
  String get takingPicture => 'Kuthathwa isithombe...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Sicela ukhethe isithombe sebhodi lomdlalo ukuze lihlonzwe';

  @override
  String get identificationResults => 'Imiphumela yokuhlonza';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Hlaziya izinyathelo bese unikeza ukuqonda.';

  @override
  String get getApiKey => 'Thola i-API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Yonke inqubo yokuhlonza yehlulekile ukuqeda.';

  @override
  String get boardRecognitionResult => 'Umphumela wokuhlonza ibhodi';

  @override
  String get askLlm => 'Buza i-LLM';

  @override
  String get boardDetectionFailed => 'Ukutholwa kwebhodi kwehlulekile!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Akukho iphuzu lebhodi litholakale, awukwazi ukuhlonza iqhekeza!';

  @override
  String get copyFen => 'Kopisha i-FEN';

  @override
  String get commonlyUsedModels => 'Amamodeli asetshenziswa kakhulu';

  @override
  String get apiKeyOptional => 'API Key (uyazikhethela)';

  @override
  String get noImageSelected => 'Akukho isithombe esikhethiwe';

  @override
  String get blackSMove => 'Ukuhamba komnyama';

  @override
  String get llm => 'Imodeli Yolimi Enkulu';

  @override
  String get llmProvider => 'Umhlinzeki';

  @override
  String get baseUrl => 'I-URL Eyisisekelo';

  @override
  String get model => 'Imodeli';

  @override
  String get temperature => 'Izinga lokushisa';

  @override
  String get llmCommandReceivedProcessing =>
      'Umyalo utholiwe! AI iyacubungula...';

  @override
  String get llmDeepThinkingWait =>
      'Ukucabanga okujulile kuqhubeka, sicela ulinde...';

  @override
  String get llmPresentingSoon => 'Kuzokwethulwa maduze...';

  @override
  String get recognitionParameters => 'Amapharamitha okuqashelwa';

  @override
  String get adjustParamsDesc =>
      'Lungisa amapharamitha ukuze uthuthukise ukunemba kokuqashelwa';

  @override
  String get saveParameters => 'Gcina amapharamitha';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Ayikwazanga ukuqala ukuqashelwa kwesithombe: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Ukuqashelwa kwesithombe kwehlulekile: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Isimo esisetshenzisiwe sinezingcezu ezimhlophe ezingu-$whiteCount nezimnyama ezingu-$blackCount';
  }

  @override
  String get fenCopiedToClipboard => '(FEN ikopishiwe ebhodi lokunamathisela)';

  @override
  String recognitionFailed(String error) {
    return 'Ukuqashelwa kwehlulekile: $error';
  }

  @override
  String get myRating => 'Isilinganiso sami';

  @override
  String get gamesPlayed => 'Imidlalo edlaliwe';

  @override
  String get wins => 'Ukunqoba';

  @override
  String get losses => 'Ukwehlulwa';

  @override
  String get draws => 'Ukudonsa';

  @override
  String get lastUpdated => 'Kubuyekezwe okokugcina';

  @override
  String get format => 'Ifomethi:';

  @override
  String get resetStatistics => 'Setha kabusha izibalo';

  @override
  String get drawRate => 'Izinga lokudonsa';

  @override
  String get lossRate => 'Izinga lokulahlekelwa';

  @override
  String get aiStatistics => 'Izibalo ze-AI';

  @override
  String get enableStatistics => 'Nika amandla izibalo';

  @override
  String get enableStatistics_Detail =>
      'Uma kunikwe amandla, imiphumela yomdlalo izorekhodwa ezibalweni. Nokho, imidlalo ehilela ukubuyisela emuva ngeke irekhodwe. Uma kukhutshaziwe, ukuqoqwa kwezibalo kuyamiswa.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Lokhu kuzosetha kabusha zonke izibalo zomdlalo. Lesi senzo asinakuhlehliswa.';

  @override
  String get boardInnerRingSize => 'Usayizi wendandatho yangaphakathi yebhodi';

  @override
  String get boardShadowEnabled => 'Umthunzi webhodi';

  @override
  String get trapAwareness => 'Ukuqaphela ugibe';

  @override
  String get trapAwarenessDescription =>
      'Gqamisa ukuhamba kogibe ngama-siyingi aminyene nemicibisholo ngesikhathi sokuhlaziywa.';

  @override
  String trapExists(String trapMoves) {
    return 'Kukhona ugibe. Ukuhamba kogibe: $trapMoves';
  }

  @override
  String get custodianCapture => 'Ukubanjwa kwe-Flanking';

  @override
  String get custodianCaptureDescription =>
      'Faka ingxenye eyodwa yezingcezu zomphikisi wakho phakathi kwayo ezimbili zakho emugqeni oqondile ukuze uzithwebule.';

  @override
  String get custodianCaptureEnable => 'Vumela ukuthathwa kwe-Flanking';

  @override
  String get interventionCapture => 'Ukungenelela kokungenelela';

  @override
  String get interventionCaptureDescription =>
      'Hambisa endaweni engenalutho phakathi kwezingcezu zabaphikisi zakho ukuze ubabambe bobabili.';

  @override
  String get interventionCaptureEnable => 'Vumela ukungenelela kokungenela';

  @override
  String get leapCapture => 'Eqanjwa';

  @override
  String get leapCaptureDescription =>
      'Capture ngokugxuma ngaphezulu kwesiqeshana somphikisi oseduze kube yindawo engenalutho.';

  @override
  String get leapCaptureEnable => 'Vumela Ukuqanjwa Kwe-TUSH';

  @override
  String get captureApplicableLines => 'Imigqa esebenzayo';

  @override
  String get captureSquareEdges => 'Ngasemiphethweni yesikwele';

  @override
  String get captureCrossLines => 'Emigqeni ye-orthogonal ewela isikwele';

  @override
  String get captureDiagonalLines => 'Emigqeni ye-diagonal ewela isikwele';

  @override
  String get captureExecutionPhases => 'Izigaba Zokubulawa';

  @override
  String get capturePiecesCondition =>
      'Ukutholakala ngesikhathi sesigaba esihambayo esekwe izingcezu ezisele';

  @override
  String get capturePiecesConditionUnlimited => 'Akukho mkhawulo';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Kuyatholakala lapho unezingcezu ezintathu noma ezimbalwa';
}
