// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Chinese (`zh`).
class SZh extends S {
  SZh([String locale = 'zh']) : super(locale);

  @override
  String get appName => '直棋';

  @override
  String get welcome => '欢迎使用';

  @override
  String get yes => '是';

  @override
  String get no => '否';

  @override
  String get game => '游戏';

  @override
  String get humanVsAi => '人机对战';

  @override
  String get humanVsHuman => '双人对战';

  @override
  String get aiVsAi => '机器对战';

  @override
  String get humanVsCloud => '挑战云端';

  @override
  String get humanVsLAN => '联网对战';

  @override
  String get testViaLAN => '联网测试';

  @override
  String get move => '着法';

  @override
  String get showMoveList => '显示棋谱';

  @override
  String get moveList => '棋谱';

  @override
  String get noGameRecord => '暂无记录';

  @override
  String get ok => '好的';

  @override
  String get confirm => '确认';

  @override
  String get cancel => '取消';

  @override
  String get tipSelectWrong => '选择的子不对';

  @override
  String get tipPlace => '请落子';

  @override
  String get tipBanPlace => '不能落在此处';

  @override
  String get tipPlaced => '已落子';

  @override
  String get tipRemove => '请吃子';

  @override
  String get tipBanRemove => '不能吃这颗子';

  @override
  String get tipRemoved => '已吃子';

  @override
  String get tipMove => '请走子';

  @override
  String get tipCannotPlace => '不可在此处落子';

  @override
  String get tipCannotMove => '不可移到此处';

  @override
  String get tipMill => '三子连珠 请吃子';

  @override
  String get tipContinueMill => '请继续吃子';

  @override
  String get tipSelectOpponentsPiece => '请选择对方的棋子';

  @override
  String get tipCannotRemovePieceFromMill => '不能吃三连中的棋子';

  @override
  String get tipCanMoveOnePoint => '请走到相邻空位';

  @override
  String get tipCannotMoveOpponentsPieces => '不能移动对方的棋子';

  @override
  String get tipSelectPieceToMove => '请选择要移动的己方棋子';

  @override
  String get tipHaveThreePiecesLeft => '只剩下3颗棋子了';

  @override
  String get tipCanMoveToAnyPoint => '可飞子到任意空位';

  @override
  String tipToMove(Object player) {
    return '轮到$player行棋';
  }

  @override
  String get whiteWin => '先手方胜！';

  @override
  String get blackWin => '后手方胜！';

  @override
  String get won => '胜';

  @override
  String get lost => '负';

  @override
  String get thinking => '思考中…';

  @override
  String get newGame => '开始新局';

  @override
  String get importGame => '导入棋局';

  @override
  String get exportGame => '导出棋局';

  @override
  String get gameImported => '棋谱已导入';

  @override
  String cannotImport(Object invalidMove) {
    return '无法导入$invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => '着法和棋规不匹配';

  @override
  String get pleaseWait => '请稍候...';

  @override
  String get restartGame => '重新开局？';

  @override
  String get restart => '重开局';

  @override
  String get gameStarted => '游戏开始 请落子';

  @override
  String get analyzing => '正在分析局面…';

  @override
  String error(Object message) {
    return '错误：$message';
  }

  @override
  String get winRate => '赢棋率';

  @override
  String get score => '比分：';

  @override
  String get white => '先手方';

  @override
  String get black => '后手方';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player的剩余棋子少于3枚。';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player认输了。';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player无路可走。';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return '$player因棋盘摆满而无路可走。';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return '$player超时判负。';
  }

  @override
  String get drawReasonRule50 => '走子阶段连续多步在规则指定的步数内未吃子，判和。';

  @override
  String get drawReasonBoardIsFull => '棋盘摆满，无路可走，判和。';

  @override
  String get drawReasonThreefoldRepetition => '三次重复局面和。';

  @override
  String get gameOverUnknownReason => '游戏结束！原因未知。';

  @override
  String get gameOver => '游戏结束';

  @override
  String get youWin => '恭喜你赢了！';

  @override
  String challengeHarderLevel(int level) {
    return '后续提升难度吗？提升后的难度等级将为$level级！';
  }

  @override
  String get youLose => '你输了！';

  @override
  String get analyze => '分析';

  @override
  String get about => '关于';

  @override
  String version(Object versionNumber) {
    return '版本：$versionNumber';
  }

  @override
  String get thanks => '致谢';

  @override
  String get settings => '游戏设置';

  @override
  String get options => '选项';

  @override
  String get generalSettings => '常规设置';

  @override
  String get skillLevel => '难度等级';

  @override
  String get moveTime => 'AI 思考时间';

  @override
  String get difficulty => '游戏难度';

  @override
  String get playSounds => '声音';

  @override
  String get playSoundsInTheGame => '行棋时播放声音';

  @override
  String get keepMuteWhenTakingBack => '悔棋时保持静音';

  @override
  String get tone => '提示音效';

  @override
  String get whoMovesFirst => '先手';

  @override
  String get human => '人类';

  @override
  String get ai => 'AI';

  @override
  String get alternate => '交替';

  @override
  String get isAutoRestart => '棋局结束时自动重新开局';

  @override
  String get isAutoChangeFirstMove => '开局时自动交换先后手';

  @override
  String get shufflingEnabled => 'AI 随机走子';

  @override
  String get misc => '其他';

  @override
  String get rules => '棋规';

  @override
  String get piecesCount => '棋子数';

  @override
  String get piecesCount_Detail => '对弈双方分别拥有的棋子数为？';

  @override
  String get flyPieceCount => '剩余多少子可飞子';

  @override
  String get flyPieceCount_Detail => '如允许飞子，则当一方剩余多少枚棋子时可以飞棋。';

  @override
  String get piecesAtLeastCount => '少于几个子则输棋';

  @override
  String get hasDiagonalLines => '斜线';

  @override
  String get hasDiagonalLines_Detail => '在棋盘上增加四条斜线。';

  @override
  String get isDefenderMoveFirst => '后摆子的先走子';

  @override
  String get isDefenderMoveFirst_Detail => '在摆子阶段后摆子的一方，在走子阶段先走子。';

  @override
  String get mayRemoveMultiple => '吃多子';

  @override
  String get mayRemoveMultiple_Detail => '若同时形成多个三连，则形成几个三连就能吃对方几个子。';

  @override
  String get mayRemoveFromMillsAlways => '允许吃三连中的子';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      '默认情况下，不能吃三连中的子，除非对方所有子都在三连中。打开此选项可解除此限制。';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull => '当棋盘摆满时先摆子的输棋';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      '对于十二子棋，在摆子阶段的最后，若棋盘摆满而双方均未吃子，则先手方输棋，而非和棋。';

  @override
  String get isLoseButNotChangeSideWhenNoWay => '当无路可走时输棋';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      '走子阶段，当无路可走时输棋，而非转为由对方继续走子。';

  @override
  String get mayFly => '飞子';

  @override
  String get mayFly_Detail => '当一方剩余三或四枚(可配置)棋子时，此方可将棋子移动到棋盘任意空位上。';

  @override
  String get nMoveRule => 'N步规则';

  @override
  String get nMoveRule_Detail => '指定当连续多少步中没有吃子时判为和局。';

  @override
  String get rollback => '回滚';

  @override
  String get pleaseSelect => '请选择';

  @override
  String get copy => '复制';

  @override
  String get moveHistoryCopied => '棋谱已复制到剪贴板。';

  @override
  String get help => '帮助中心';

  @override
  String get feedback => '问题反馈';

  @override
  String get exit => '退出游戏';

  @override
  String get ruleSettings => '规则设置';

  @override
  String get color => '颜色';

  @override
  String get boardColor => '棋盘颜色';

  @override
  String get pieceColor => '棋子颜色';

  @override
  String get backgroundColor => '背景颜色';

  @override
  String get lineColor => '线条颜色';

  @override
  String get whitePieceColor => '先手方棋子颜色';

  @override
  String get blackPieceColor => '后手方棋子颜色';

  @override
  String get messageColor => '提示信息颜色';

  @override
  String get isPieceCountInHandShown => '显示手中剩余棋子数';

  @override
  String get isNotationsShown => '棋盘边缘显示坐标';

  @override
  String get isHistoryNavigationToolbarShown => '显示着法导航工具栏';

  @override
  String get display => '显示';

  @override
  String get boardBorderLineWidth => '棋盘外框线宽';

  @override
  String get boardInnerLineWidth => '棋盘内部线宽';

  @override
  String get pieceWidth => '棋子大小';

  @override
  String get fontSize => '字体大小';

  @override
  String get standardNotation => '标准棋谱格式';

  @override
  String get restore => '重置';

  @override
  String get restoreDefaultSettings => '恢复默认设置';

  @override
  String pick(Object element) {
    return '选择$element';
  }

  @override
  String get info => '信息';

  @override
  String get hint => '提示';

  @override
  String get player => '玩家';

  @override
  String get player1 => '先手方';

  @override
  String get player2 => '后手方';

  @override
  String get howToPlay => '玩法说明';

  @override
  String get toPlacePiece => '点击棋盘上的交叉点放置棋子。';

  @override
  String get toSelectPiece => '请选择自己要移动的棋子。';

  @override
  String get toMovePiece => '点击和此棋子相邻的点以移动棋子。';

  @override
  String get toRemovePiece => '点击对方的一颗棋子以吃子。';

  @override
  String get needToCreateMillFirst => '您需要先形成三连，才能吃掉对方的棋子。';

  @override
  String get needToPlayWithOwnPieces => '您需要走自己的棋子。';

  @override
  String get statistics => '统计数据';

  @override
  String get totalGames => '盘数';

  @override
  String get results => '结果';

  @override
  String get left => '剩余';

  @override
  String get privacyPolicy => '隐私政策';

  @override
  String get privacyPolicy_Detail_1 =>
      '请您务必审慎阅读、充分理解《用户协议》和《隐私政策》各条款，包括但不限于：\n为了改善我们向您提供的服务，基于您的明示授权，我们可能会获取您的设备型号、诊断数据、电子邮件地址等信息，您有权拒绝或取消授权。我们将在每次请求发送诊断数据前，通过弹窗形式征得您的明示同意。\n您可阅读《';

  @override
  String get privacyPolicy_Detail_2 => '》了解详细信息。如您同意，请点击“同意”开始接受我们的服务。';

  @override
  String get and => '》和《';

  @override
  String get accept => '同意';

  @override
  String get takeBack => '回退一步';

  @override
  String get takingBack => '回退中…';

  @override
  String get waiting => '请稍等…';

  @override
  String get stepForward => '前进一步';

  @override
  String get takeBackAll => '回退到底';

  @override
  String get stepForwardAll => '前进到底';

  @override
  String get moveNow => '立即行棋';

  @override
  String get done => '完成';

  @override
  String get crackMill => '可从三连中吃子';

  @override
  String get crackMill_Detail => '若对方所有的子都在三连中，仍可吃子。';

  @override
  String get animationDuration => '动画持续时长';

  @override
  String get none => '无';

  @override
  String get theme => '主题';

  @override
  String get helpContent =>
      '直棋是一个非常古老的智力游戏，现已流传到中国各地，演变出“棋三”、“三棋”、“三三棋”、“打三棋”、“成三棋”、“下连”等多个变种。\n\n游戏目标为让对手被吃得仅剩不到三枚棋子。\n\n三次重复局面，或连续百步（可配置）内无吃子，则和棋。 \n\n游戏分三阶段：\n\n1. 在空位上摆子；\n2. 将棋子移动到相邻空位；\n3. 当只剩三枚棋子时，可“飞子”（可选）。\n\n摆子阶段\n\n棋盘上有二十四个空点。玩家交替在空位上落子，直至手中无子。若一方将自己的三枚棋子排成一排，则称为形成一个“三连”，便可吃掉对方的棋子，然后继续行棋。\n\n某些规则变体规定，只能吃掉对方不在“三连”中的子，除非对方所有的子都在“三连”之中。\n\n还有些规则变体规定，在摆子阶段，被吃掉的子所在的空位，双方都不能再在上面摆子。 \n\n当双方手中的棋子都摆完后，则进入走子阶段。\n\n走子阶段\n\n玩家将自己的棋子移动到相邻的点上。若无子可走，则判负。和摆子阶段类似，形成“三连”时便可吃掉对方的棋子。当一方的棋子仅剩两枚，则败局已定，判负。若棋盘上多于三枚棋子，但无子可走，也会被判负。\n\n飞子阶段\n\n某些规则变体中，一旦一方剩三枚棋子时，便可“飞”到任意空位上，无论该空位是否邻接。\n';

  @override
  String get versionInfo => '版本信息';

  @override
  String get eula => '用户协议';

  @override
  String get license => '许可证';

  @override
  String get sourceCode => '源代码';

  @override
  String get appVersion => '应用版本';

  @override
  String get general => '常规';

  @override
  String get advanced => '高级';

  @override
  String get placing => '摆子';

  @override
  String get moving => '走子';

  @override
  String get removing => '吃子';

  @override
  String get gameOverCondition => '终局条件';

  @override
  String get aisPlayStyle => 'AI 的棋风';

  @override
  String get passive => '消极被动';

  @override
  String get timeout => '超时';

  @override
  String get appearance => '外观设置';

  @override
  String get drawOnHumanExperience => '借鉴人类经验';

  @override
  String get considerMobility => '增强棋子活动能力';

  @override
  String get pieceCount => '棋子数';

  @override
  String inHand(Object player, int count) {
    return '$player手上：$count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player棋盘上：$count';
  }

  @override
  String get boardTop => '棋盘和上边缘的间距';

  @override
  String get notAIsTurn => '现在不是轮到 AI 行棋';

  @override
  String get aiIsNotThinking => 'AI 并非正在思考中';

  @override
  String get atEnd => '已经到底了';

  @override
  String get tapBackAgainToLeave => '再次按返回键退出应用';

  @override
  String get more => '更多';

  @override
  String get experimental => '此仍属实验性功能。';

  @override
  String get experiments => '实验性功能';

  @override
  String get ossLicenses => '开放源代码许可';

  @override
  String get language => '显示语言';

  @override
  String get defaultLanguage => '默认语言';

  @override
  String get mayMoveInPlacingPhase => '可以在摆子阶段走子';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      '摆子阶段和走子阶段无严格界限。即，玩家可以在每一步棋中决定是要摆子还是走子 (只要还有剩余的棋子可以摆子)。';

  @override
  String get drawerColor => '菜单颜色';

  @override
  String get drawerTextColor => '菜单文字颜色';

  @override
  String get drawerHighlightItemColor => '菜单高亮条目背景色';

  @override
  String get mainToolbarBackgroundColor => '主工具栏背景色';

  @override
  String get mainToolbarIconColor => '主工具栏图标色';

  @override
  String get navigationToolbarBackgroundColor => '导航工具栏背景色';

  @override
  String get navigationToolbarIconColor => '导航工具栏图标色';

  @override
  String get autoHideToolbar => '自动隐藏工具栏';

  @override
  String get toolbarLocationOnScreen => '工具栏在屏幕上的位置';

  @override
  String get top => '顶部';

  @override
  String get bottom => '底部';

  @override
  String get center => '中部';

  @override
  String get solidColor => '纯色';

  @override
  String get picture => '图片';

  @override
  String get chooseYourPicture => '选择图片';

  @override
  String get light => '明亮';

  @override
  String get dark => '暗黑';

  @override
  String get themes => '主题';

  @override
  String get currentTheme => '当前主题';

  @override
  String get saveTheme => '保存主题';

  @override
  String get showAnalysisGraph => '显示分析图';

  @override
  String get analysis => '分析';

  @override
  String get saveGame => '保存游戏';

  @override
  String get loadGame => '加载游戏';

  @override
  String get setupPosition => '设置局面';

  @override
  String get showLegalMoves => '显示合法着法';

  @override
  String get showLastMove => '显示最后一着';

  @override
  String get showArrows => '显示箭头';

  @override
  String get pieces => '棋子';

  @override
  String get showAnalysis => '显示分析';

  @override
  String get threads => '线程数';

  @override
  String get getInvolved => '参与项目';

  @override
  String get helpImproveTranslate => '帮助翻译';

  @override
  String get tutorial => '教程';

  @override
  String get classicMill => '经典磨坊';

  @override
  String get mixedMill => '混合磨坊';

  @override
  String get ceylonMill => '锡兰磨坊';

  @override
  String get mayBreakAndRemakeMillRepeatedly => '允许反复连续形成三连';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      '如果一方在一着中解除了一个三连并同时形成了一个新的三连，那么允许其在下一步棋把这个棋子再移回前一着的位置，从而反复连续形成三连。';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      '一方剩下三个棋子并十步内双方均未吃子则和棋';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      '当一方只剩下三颗棋子时，而双方都不能在接下来十步之内吃掉对方的棋子，则判为和棋。';

  @override
  String get close => '关闭';

  @override
  String get whitePiece => '白棋';

  @override
  String get blackPiece => '黑棋';

  @override
  String get emptyPoint => '空点';

  @override
  String get noPoint => '无点';

  @override
  String get placingPhase => '摆子阶段';

  @override
  String get movingPhase => '走子阶段';

  @override
  String get flyingPhase => '飞子阶段';

  @override
  String sideToMove(Object player) {
    return '轮到$player行棋';
  }

  @override
  String lastMove(Object move) {
    return '最后一着：$move';
  }

  @override
  String get selected => '已选中';

  @override
  String get accessibility => '无障碍';

  @override
  String get screenReaderSupport => '支持屏幕阅读器';

  @override
  String get isDraw => '和棋';

  @override
  String get draw => '和棋';

  @override
  String get pieceHighlightColor => '棋子高亮颜色';

  @override
  String get algorithm => '算法';

  @override
  String get endgameNMoveRule => '终盘N步规则';

  @override
  String get endgameNMoveRule_Detail => '指定当至少一方只剩下三枚棋子时，双方连续多少步均未吃子时，判为和局。';

  @override
  String get drawReasonEndgameRule50 => '至少有一方只剩下三枚棋子，且双方连续多步均未吃子。';

  @override
  String get threefoldRepetitionRule => '三次重复局面和';

  @override
  String get threefoldRepetitionRule_Detail => '在对局时，同一局面连续或间断出现三次，则判为和局。';

  @override
  String get continueToMakeMove => '三子连珠 请继续行棋';

  @override
  String get pointStyle => '棋盘交叉点的样式';

  @override
  String get pointWidth => '棋盘交叉点的大小';

  @override
  String get solid => '实心圆';

  @override
  String get hollow => '空心圆';

  @override
  String get languageName => '简体中文';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 步',
      one: '$count 步',
      zero: '步',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => '加载失败';

  @override
  String get filename => '文件名';

  @override
  String get browse => '浏览…';

  @override
  String get gameFiles => '游戏文件';

  @override
  String get gameSavedTo => '游戏已保存至';

  @override
  String get empty => '空点';

  @override
  String get noMove => '暂无着法';

  @override
  String get restoredPosition => '已还原至初始局面';

  @override
  String get clean => '清盘';

  @override
  String get cleanedUp => '已清盘';

  @override
  String get remove => '将吃几子';

  @override
  String get noPiecesCanBeRemoved => '无子可吃';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 枚子',
      one: '$count 枚子',
      zero: 'Piece',
    );
    return '$_temp0将被吃';
  }

  @override
  String placedCount(int count) {
    return '已摆$count子';
  }

  @override
  String get placedPieceCount => '设置当前行棋方，在摆子阶段，已摆的棋子数量';

  @override
  String hasPlacedPieceCount(int count) {
    return '当前轮到的行棋方被设置为已摆了 $count 枚棋子';
  }

  @override
  String get notPlacingPhase => '非摆子阶段，不能设置此值';

  @override
  String get paste => '粘贴';

  @override
  String get pasteDone => '已粘贴';

  @override
  String get cannotPaste => '粘贴不成功';

  @override
  String get isUnplacedAndRemovedPiecesShown => '显示未摆和已吃的子';

  @override
  String get fullScreen => '全屏显示';

  @override
  String get reopenToTakeEffect => '您需要退出并重新打开本应用才能生效。';

  @override
  String get forest => '原野森林';

  @override
  String get desktopImage => '桌面图片';

  @override
  String get invalidPosition => '局面是不合法的';

  @override
  String get shareGIF => '动图分享';

  @override
  String get pixelRatio => '像素比';

  @override
  String get duration => '持续时间';

  @override
  String get gameScreenRecorder => '游戏录屏';

  @override
  String get previous => '以前的';

  @override
  String get next => '下一个';

  @override
  String get skip => '跳过';

  @override
  String get gotIt => '知道了';

  @override
  String get youCanModifyRules => '您可以在规则设置中修改游戏规则。';

  @override
  String get youCanUseMouseWheelInPicker => '您可以使用鼠标滚轮来选择值。';

  @override
  String get noTimeLimitForThinking => 'AI 思考时间设置为 0 则表示没有思考时间的限制。';

  @override
  String get whatIsMtdf =>
      'MTD(f) 是 Alpha-Beta 搜索算法的一种改进算法，旨在通过重用中间搜索结果和使用良好的初始猜测来缩小搜索空间来提高效率。';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      '请注意，AI 思考时间的调整可能并不精确。当难度等级设置为较低值时，实际思考时间可能会更短，而当时间耗尽时 AI 还在思考时，则实际思考时间可能会更长。';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      '如果将难度设置得很高，但未增加 AI 的思考时间，实际难度可能会因为思考时间的限制而被压缩在较低的水平。实际的难度水平会因 AI 性能而异。';

  @override
  String get whatIsPvs =>
      'PVS 是一种搜索算法，用于在给定局面找到最佳着法。它是对 Alpha-Beta 算法的增强，并使用空或零窗口搜索来确认着法是否比主要变例的安全分数更差或不差。 PVS 关注最有前途的着法，避免不必要的次优分支搜索，有助于提高搜索效率。';

  @override
  String get whatIsAlphaBeta =>
      'Alpha-beta 算法是一种寻找最佳着法的搜索算法。它使用 minimax 原则和两个值 alpha 和 beta 来修剪搜索树并提高效率。 alpha 代表计算机确定能得到的最低分数，而 beta 代表它的对手能得到的最大分数。该算法帮助计算机在游戏中做出明智、高效的决策。';

  @override
  String get drawOnTheHumanExperienceDetail =>
      '孙子曰：昔之善战者，先为不可胜，以待敌之可胜。不可胜在己，可胜在敌。故善战者，能为不可胜，不能使敌之必可胜。故曰：胜可知，而不可为。如开启这一选项，将使得 AI 在开局阶段不会猛烈进攻，而是用缓着静待时机到来。';

  @override
  String get firstMoveDetail => '在这个游戏中，后手方比先手方更容易取胜。';

  @override
  String get passiveDetail => '启用“消极被动”选项将使得 AI 在占据主动时有所放松，手下留情，而不是力争尽快取胜。';

  @override
  String get moveRandomlyDetail => '启用此选项可增加游戏的随机性和趣味性，而禁用此选项可有助于探索击败 AI 之道。';

  @override
  String get considerMobilityOfPiecesDetail =>
      '如若 AI 考虑到自己棋子的机动性，那么它不仅会以最快的速度吃掉对方的棋子为目标，还会考虑封堵对方的路线，让对方无路可走，并力图避免对方以其人之道还治其人之身。';

  @override
  String get whenBoardIsFull => '当棋盘摆满时';

  @override
  String get whenBoardIsFull_Detail => '在摆子阶段结束时，在走子阶段开始前，如棋盘已摆满，则接下来的动作为？';

  @override
  String get sideToMoveRemovePiece => '进入走子阶段前，先行方先移除对手的一枚棋子。';

  @override
  String get agreeToDraw => '双方和棋。';

  @override
  String get takeOpponentsPiece => '请抽掉对方的一枚棋子';

  @override
  String get firstPlayerLose => '先手方负。';

  @override
  String get firstAndSecondPlayerRemovePiece => '先手方和后手方先后移除对方的一枚棋子。';

  @override
  String get secondAndFirstPlayerRemovePiece => '后手方和先手方先后移除对方的一枚棋子。';

  @override
  String get enteredFlyingPhase =>
      '现已进入“飞行阶段”，对方棋子可跳到棋盘上的任意空点。您可以在“规则设置”中关闭飞子规则。';

  @override
  String get whenStalemate => '当无子可走时';

  @override
  String get whenStalemate_Detail => '当无子可走时，接下来的动作为？';

  @override
  String get endWithStalemateLoss => '因无子可走而判负。';

  @override
  String get changeSideToMove => '改由对手继续走棋。';

  @override
  String get removeOpponentsPieceAndMakeNextMove => '移除对手的一枚棋子然后自己继续走棋。';

  @override
  String get endWithStalemateDraw => '因无子可走而判和。';

  @override
  String get removeOpponentsPieceAndChangeSideToMove => '移除对手的一枚棋子然后由对方继续走棋。';

  @override
  String get aiResponseDelayTime => 'AI 响应延迟时间';

  @override
  String get aiIsDelaying => 'AI 目前处于延迟响应阶段。请稍等片刻再继续。';

  @override
  String get tipCanNotRemoveNonadjacent => '只能移除和自己棋子相邻的棋子';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      '在无路可走的情况下，只要对方的子和自己的子相邻，则无论这些子是否在三连中，都可以被移除。';

  @override
  String get whatIsMcts => 'MCTS 是一种对初学者友好的算法，它通过模拟探索和评估不同的着法来做出决策。';

  @override
  String get goldenJade => '金玉';

  @override
  String get forestWood => '林木';

  @override
  String get darkMystery => '暗谜';

  @override
  String get midnightBlue => '夜蓝';

  @override
  String get greenForest => '翠林';

  @override
  String get greenMeadow => '绿草';

  @override
  String get stonyPath => '石径';

  @override
  String get pastelPink => '粉彩';

  @override
  String get turquoiseSea => '碧海';

  @override
  String get violetDream => '紫梦';

  @override
  String get mintChocolate => '荷巧';

  @override
  String get skyBlue => '蓝天';

  @override
  String get playfulGarden => '花园';

  @override
  String get whatIsRetrogradeAnalysis =>
      '逆行分析算法使用多值逆行分析从不同的开始局面构建残局数据库，然后应用此数据库优化游戏玩法。这种方法属于超强解决方案的范畴。';

  @override
  String get viewAlgorithmGuide => '您想查看此算法的用户指南吗？';

  @override
  String get showPositionalAdvantageIndicator => '显示局面优劣指示器';

  @override
  String get usePerfectDatabase => '使用完美数据库';

  @override
  String get perfectDatabaseDescription =>
      '开启此选项以使用由尖端算法生成的完美游戏数据库。该功能集成了开局和残局策略以推荐最佳着法，是寻求游戏中最高精确度的玩家的首选。数据库通过精密的计算技术创建，旨在提供接近完美的游戏解决方案。\n\n注意：如果 AI 无法访问数据库，那么将转向传统算法进行游戏决策。当数据库可用时，“难度等级”实际上变得极高，而“AI 思考时间”将大幅缩短。“AI 的棋风”选项中的许多设置也将被覆盖，因为数据库结果具有最高优先级。\n\n如需了解如何使用该完美数据库，请点击这里。';

  @override
  String get backgroundImage => '背景图片';

  @override
  String get whatIsRandom =>
      '当“使用完美数据库”选项未启用时，“随机”设置会导致 AI 在不使用任何移动选择算法的情况下随机移动棋子。这通常会导致游戏性明显较弱。相反，当启用“使用完美数据库”时，人工智能完全依赖“完美数据库”进行决策，而不是将其与传统的人工智能算法混合。在这种模式下，人工智能的动作完全基于数据库的内容，避免了对实时计算或搜索算法的依赖。';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      '吃掉对方手中的棋子；然后轮到对方摆子。';

  @override
  String get whenFormingMillsDuringPlacingPhase => '在摆子阶段形成三连时';

  @override
  String get removeOpponentsPieceFromBoard => '吃掉棋盘上对方的棋子。';

  @override
  String get removeOpponentsPieceFromBoard_Detail => '吃掉棋盘上对方的棋子；然后轮到对方摆子。';

  @override
  String get opponentRemovesOwnPiece => '由对方自己来吃自己的棋子。';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      '不是由己方来吃子，而是由对方从棋盘上选择并移除自己的棋子，实际上对方是在采取不利于自己的行动。';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn => '移除对方手中的棋子；然后轮到己方行棋。';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      '移除对方手中的棋子。如果根据“吃多子”设置需要移除多个棋子，而对方手中已经没有棋子了，则继续从棋盘上吃掉对方的棋子。然后，轮到己方行棋。如果己方继续形成三连，己方可以继续移除对方的棋子。';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      '移除对方手中的棋子。如果根据“吃多子”设置需要移除多个棋子，而对方手中已经没有棋子了，则继续从棋盘上吃掉对方的棋子。然后，轮到对方行棋。';

  @override
  String get markAndDelayRemovingPieces => '标记并延迟移除棋子。';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      '在摆子阶段，要吃掉的棋子被标记起来，双方都不能在这些点上摆新子。进入走子阶段后，这些被标记的子会一起被移除，接下来双方便可将自己的棋子走到这些点上。';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail => '在摆子阶段形成三连时，可以采取的行动。';

  @override
  String get marked => '标记';

  @override
  String get menu => '菜单';

  @override
  String get monochrome => '黑白';

  @override
  String get youCanEnableScreenReaderSupport =>
      '您可以在“常规设置”中的“辅助功能”配置中打开“屏幕阅读器支持”开关。';

  @override
  String get showNumbersOnPieces => '在棋子上显示数字';

  @override
  String get saveImage => '保存图像';

  @override
  String get isAnalysisToolbarShown => '显示分析工具栏';

  @override
  String get analysisToolbarBackgroundColor => '分析工具栏背景色';

  @override
  String get analysisToolbarIconColor => '分析工具栏图标颜色';

  @override
  String get transformed => '已转换';

  @override
  String get cannotTransform => '无法转换';

  @override
  String get rotate => '旋转';

  @override
  String get horizontalFlip => '左右';

  @override
  String get verticalFlip => '上下';

  @override
  String get innerOuterFlip => '内外';

  @override
  String get transparentCanvas => '透明';

  @override
  String get restrictRepeatedMillsFormation => '限制重复形成三连';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      '从一个三连移动到另一个三连的棋子不能在下一回合立即返回原点再次形成三连。需要先走其他着法。';

  @override
  String get oneTimeUseMill => '一次性三连';

  @override
  String get oneTimeUseMill_Detail => '每个三连只能吃掉一次对手的棋子。您可以再次重组它，但不能用于额外的吃子。';

  @override
  String get currentRulesNoPerfectDatabase =>
      '您设置的当前规则没有相应的完美数据库。有关完美数据库的更多信息，请点击此处。';

  @override
  String get focusOnBlockingPaths => '专注于封堵路径';

  @override
  String get focusOnBlockingPaths_Detail =>
      '在游戏的特定阶段中，优先阻碍对手走棋，而不是形成三连。在这些阶段中，AI 不会专注于通过形成三连来吃掉对方的棋子，而是旨在困住对方，使对方的棋子无法移动，并通过消耗战而不是积极进攻来争取胜利。这种针对特定阶段的策略不会主动阻止对方形成三连。';

  @override
  String get pieceImage => '棋子图片';

  @override
  String get importColorSettings => '导入颜色设置';

  @override
  String get exportColorSettings => '导出颜色设置';

  @override
  String get import => '导入';

  @override
  String get export => '导出';

  @override
  String get pleaseCopyJsonToClipboard => '请先将 JSON 格式的配置复制到剪贴板。';

  @override
  String get copiedToClipboard => '已复制到剪贴板。';

  @override
  String get imported => '已导入。';

  @override
  String get boardImage => '棋盘图片';

  @override
  String get autumnLeaves => '秋叶';

  @override
  String get legendaryLand => '青绿';

  @override
  String get vignetteEffect => '暗角效果';

  @override
  String get promptMakeToolbarTransparent => '当设置了棋盘背景图片时，您是否希望工具栏完全透明？';

  @override
  String get vibration => '游戏中启用振动';

  @override
  String get soundTheme => '声音主题';

  @override
  String get ball => '球';

  @override
  String get liquid => '水';

  @override
  String get wood => '木';

  @override
  String get placeEffectAnimation => '摆子的动画效果';

  @override
  String get removeEffectAnimation => '吃子的动画效果';

  @override
  String get isToolbarAtBottom => '工具栏显示在底部';

  @override
  String get boardCornerRadius => '棋盘圆角半径';

  @override
  String get useOpeningBook => '使用开局库';

  @override
  String get currentRule => '当前的';

  @override
  String get nineMensMorris => '莫里斯九子棋';

  @override
  String get twelveMensMorris => '莫里斯十二子棋';

  @override
  String get morabaraba => '莫拉巴拉巴';

  @override
  String get dooz => '波斯多茲';

  @override
  String get chamGonu => '参古努';

  @override
  String get zhiQi => '直棋';

  @override
  String get chengSanQi => '成三棋';

  @override
  String get mulMulan => '木兰棋';

  @override
  String get nerenchi => '锡兰直棋';

  @override
  String get ruleSet => '规则集';

  @override
  String get laskerMorris => '拉斯克风车棋';

  @override
  String get oneTimeMill => '俄罗斯直棋';

  @override
  String get daSanQi => '打三棋';

  @override
  String get useOpeningBook_Detail =>
      '让 AI 在开局阶段采用人类专业棋手惯用的着法。注意：此功能目前仅适用于特定棋规。';

  @override
  String get showAdvantageGraph => '显示优势图';

  @override
  String get advantageGraphHint => '仅当 AI 行棋后，优势图才会绘制。人类棋手行棋时则不会绘制。';

  @override
  String get removalBasedOnMillCounts => '在所有棋子摆完之前，不能吃掉对方棋子。摆完后，根据三连数量来吃子。';

  @override
  String get removalBasedOnMillCounts_Detail =>
      '在双方所有棋子摆完之前，不能吃掉对方棋子。双方都摆完后，双方根据己方形成的三连数量来吃掉对方的棋子：如果三连数量相同，则双方吃掉对方相同数量的棋子；如果一方的三连更多，则最多只比对方多吃掉一枚棋子。如果只有一方形成三连，则该方吃掉两枚棋子，另一方吃掉一枚。如果双方都没有形成三连，则双方各移除己方一枚棋子。';

  @override
  String get elfilja => '阿拉伯帐篷';

  @override
  String get tipSelectOwnPiece => '请选择自己的棋子';

  @override
  String get notYourTurn => '还没轮到你行棋';

  @override
  String get annotationToolbarBackgroundColor => '标注工具栏背景颜色';

  @override
  String get annotationToolbarIconColor => '标注工具栏图标颜色';

  @override
  String get isAnnotationToolbarShown => '显示标注工具栏';

  @override
  String get enterAnnotationMode => '进入标注模式';

  @override
  String get areYouSureYouWantToClearAllAnnotations => '您确定要清除所有标注吗？';

  @override
  String get llmPromptCopiedToClipboard => '大模型提示词已复制到剪贴板。';

  @override
  String get connectionRefusedTheServerMayBeDown => '连接被拒绝，服务器可能已宕机';

  @override
  String get discoverySuccessfulAwaitingConnection => '发现成功，等待连接...';

  @override
  String get noLanConnection => '无局域网连接';

  @override
  String get takeScreenshot => '截图';

  @override
  String get disconnectedFromOpponent => '已与对手断开连接。';

  @override
  String get takeBackRequest => '悔棋请求';

  @override
  String get nothingToShow => '无可显示内容。';

  @override
  String get stopHosting => '停止服务';

  @override
  String get connectionResetByPeer => '连接被对方重置';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      '由于心跳超时，连接丢失。请重新连接。';

  @override
  String get startHosting => '开始服务';

  @override
  String get restartRequestRejected => '重启请求被拒绝。';

  @override
  String get notConnectedToLanOpponent => '未连接到局域网对手。';

  @override
  String get llmPrompt => '大模型提示词';

  @override
  String get gameRestarted => '游戏已重启';

  @override
  String get takeBackRejected => '悔棋请求被拒绝';

  @override
  String get areYouSureYouWantToResignThisGame => '您确定要认输吗？';

  @override
  String get opponentResignedYouWin => '对手认输。你赢了！';

  @override
  String get clearAllAnnotations => '清除所有标注';

  @override
  String get connectedWaitingForOpponentSMove => '已连接，等待对手走棋...';

  @override
  String get networkStatusDisconnected => '网络状态：断开';

  @override
  String get takeBackRequestSentToTheOpponent => '已向对手发送悔棋请求。';

  @override
  String get theOpponentMayHaveLeftTheGame => '对手可能已离开游戏';

  @override
  String get connectedToHostSuccessfully => '已成功连接到主机';

  @override
  String get connectionLostHeartbeatTimeout => '连接丢失：心跳超时';

  @override
  String get noHostDiscovered => '未发现主机。';

  @override
  String get confirmResignation => '确认认输';

  @override
  String get startedHostingGameWaitingForPlayersToJoin => '已开始服务，等待玩家加入...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable => '连接超时，网络连接不稳定';

  @override
  String get noLlmPromptAvailable => '无可用的大模型提示词';

  @override
  String get youResignedGameOver => '你已认输。游戏结束';

  @override
  String get serverIp => '服务器 IP';

  @override
  String get confirmClear => '确认清除';

  @override
  String get opponentSTurn => '轮到对方行棋';

  @override
  String get waitingAClientConnection => '等待客户端连接...';

  @override
  String get takeBackRequestWasRejectedOrFailed => '悔棋请求被拒绝或失败。';

  @override
  String get addText => '添加文本';

  @override
  String get exitAnnotationMode => '退出标注模式';

  @override
  String get typeYourAnnotation => '输入您的标注';

  @override
  String get attemptingToReconnect => '尝试重新连接...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      '重新开始游戏的请求已发送，等待对手回复...';

  @override
  String get serverIsStopped => '服务器已停止';

  @override
  String get restartRequest => '重启请求';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn => '并非轮到你行棋，故无法请求悔棋。';

  @override
  String get takeBackAccepted => '悔棋请求已被接受';

  @override
  String get localNetworkSettings => '本地网络设置';

  @override
  String get reconnectedSuccessfully => '重新连接成功！';

  @override
  String get failedToSaveImageToGallery => '保存图片到图库失败。';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept => '对手请求重启游戏。你同意吗？';

  @override
  String get yourTurn => '轮到你了';

  @override
  String get unableToReconnectPleaseRestartTheGame => '无法重新连接，请重启游戏';

  @override
  String get host => '主机';

  @override
  String get join => '加入';

  @override
  String get port => '端口';

  @override
  String get invalidIpAddress => '无效的 IP 地址。';

  @override
  String get invalidPort => '无效的端口。';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return '正在连接：尝试 $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return '连接失败：$error';
  }

  @override
  String failedToStartHosting(Object error) {
    return '启动服务失败：$error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return '发现主机：$ip:$port';
  }

  @override
  String get stop => '停止';

  @override
  String get discover => '发现';

  @override
  String get connect => '连接';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return '客户端已连接：$clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return '正在发现：$seconds 秒';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return '重连 ($attempt/$maxAttempts)';
  }

  @override
  String get connected => '已连接';

  @override
  String get delete => '删除';

  @override
  String get ancientEgypt => '敦煌';

  @override
  String get gothicIce => '凛珥';

  @override
  String get riceField => '禾溟';

  @override
  String get chinesePorcelain => '瓷蕴';

  @override
  String get desertDusk => '沙焃';

  @override
  String get precisionCraft => '微錾';

  @override
  String get folkEmbroidery => '乡绮';

  @override
  String get carpathianHeritage => '喀琛';

  @override
  String get imperialGrandeur => '冕赫';

  @override
  String get bohemianCrystal => '波璨';

  @override
  String get savannaSunrise => '莽熹';

  @override
  String get harmonyBalance => '和衡';

  @override
  String get cinnamonSpice => '桂辛';

  @override
  String get anatolianMosaic => '瑰瑍';

  @override
  String get carnivalSpirit => '欢猋';

  @override
  String get custom => '自定义';

  @override
  String get spiceMarket => '辛墟';

  @override
  String get swipeToRevealTheDrawer => '滑动页面可打开抽屉';

  @override
  String get showGameInfoOnScreenshots => '在截图上显示棋局信息';

  @override
  String get humanMoveTime => '人类思考时间限制';

  @override
  String get noTimeLimitForHumanMoves => '人类思考时间无限制';

  @override
  String get timeoutLoseWillBeApplied => '对于人类而言，超时将被判负';

  @override
  String get identifyingBoard => '正在识别棋盘…';

  @override
  String get youCanEnterAnyModelName => '您可以输入任意模型名称';

  @override
  String get boardPositionAppliedFenCopiedToClipboard => '棋盘位置已应用，FEN 已复制到剪贴板。';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard => '建议：尝试拍摄更清晰的棋盘照片';

  @override
  String get llmPromptTemplate => '大模型提示词模板';

  @override
  String get noValidBoardDetected => '未检测到有效的棋盘';

  @override
  String get selectingImageFromAlbum => '正在从相册中选择图片…';

  @override
  String get configurePromptTemplate => '配置提示词模板';

  @override
  String get editPromptTemplateForLlmAnalysis => '编辑提示词模板以用于大模型分析';

  @override
  String get failedToGenerateFenFromRecognizedBoard => '无法从识别到的棋盘生成 FEN';

  @override
  String get outputInCurrentLanguage => '以当前语言输出';

  @override
  String get commonBaseUrls => '常用 Base URL';

  @override
  String get viewCommonModels => '查看常用模型';

  @override
  String get recognitionParametersUpdated => '识别参数已更新';

  @override
  String get whiteSMove => '白方走子';

  @override
  String get resetToDefaults => '重置为默认值';

  @override
  String get photoShoot => '拍照';

  @override
  String get failedToApplyRecognizedBoardPosition => '应用识别到的棋盘位置失败';

  @override
  String get llmPromptContent => '大模型提示词内容';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings => '大模型未配置，请检查设置。';

  @override
  String get setProviderModelApiKeyAndBaseUrl => '设置提供商、模型、API Key 和 Base URL';

  @override
  String get llmConfiguration => '大模型配置';

  @override
  String get configureLlmProvider => '配置大模型提供商';

  @override
  String get llmPromptTemplateHeader => '大模型提示模板头部';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      '未在图像中识别到棋子，请重试。';

  @override
  String get recognizeBoardFromImage => '从图片识别棋盘';

  @override
  String get viewTips => '查看提示';

  @override
  String get applyToBoard => '应用到棋盘';

  @override
  String get adjustBoardArea => '调整棋盘区域';

  @override
  String get viewCommonUrls => '查看常用 URL';

  @override
  String get colorAnalysisFailed => '颜色分析失败！';

  @override
  String get analyzingGameBoardImage => '正在分析棋盘图像…';

  @override
  String get selectFromAlbum => '从相册选择';

  @override
  String get noBoardPointDetected => '未检测到棋盘点！';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed => '如留空，将使用默认模板';

  @override
  String get llmConfig => '大模型配置';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      '确定要将提示模板重置为默认值吗？';

  @override
  String get llmPromptTemplateFooter => '大模型提示词模板尾部';

  @override
  String get loadingResponse => '正在加载响应…';

  @override
  String get applyThisResultToBoard => '将此结果应用到棋盘';

  @override
  String get takingPicture => '正在拍照…';

  @override
  String get pleaseSelectAGameBoardImageToIdentify => '请选择一张棋盘图像进行识别';

  @override
  String get identificationResults => '识别结果';

  @override
  String get analyzeTheMovesAndProvideInsights => '分析走子并提供见解。';

  @override
  String get getApiKey => '获取 API Key';

  @override
  String get entireRecognitionProcessFailedToComplete => '整个识别过程未能完成';

  @override
  String get boardRecognitionResult => '棋盘识别结果';

  @override
  String get askLlm => '询问大模型';

  @override
  String get boardDetectionFailed => '检测棋盘失败！';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece => '未检测到棋盘点，无法识别棋子！';

  @override
  String get copyFen => '复制 FEN';

  @override
  String get commonlyUsedModels => '常用模型';

  @override
  String get apiKeyOptional => 'API Key（可选）';

  @override
  String get noImageSelected => '未选择图片';

  @override
  String get blackSMove => '黑方走子';

  @override
  String get llm => '大语言模型';

  @override
  String get llmProvider => '提供商';

  @override
  String get baseUrl => '基地址';

  @override
  String get model => '模型';

  @override
  String get temperature => '温度';

  @override
  String get llmCommandReceivedProcessing => '收到指令，AI 正在处理...';

  @override
  String get llmDeepThinkingWait => '深度思考中，请稍候...';

  @override
  String get llmPresentingSoon => '即将呈现...';

  @override
  String get recognitionParameters => '识别参数';

  @override
  String get adjustParamsDesc => '调整参数以提高识别准确率';

  @override
  String get saveParameters => '保存参数';

  @override
  String unableToStartImageRecognition(String error) {
    return '无法启动图像识别：$error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return '图像识别失败：$error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return '已应用棋局：白方 $whiteCount 枚子，黑方 $blackCount 枚子';
  }

  @override
  String get fenCopiedToClipboard => '（FEN 已复制到剪贴板）';

  @override
  String recognitionFailed(String error) {
    return '识别失败：$error';
  }

  @override
  String get myRating => '我的等级分';

  @override
  String get gamesPlayed => '已下盘数';

  @override
  String get wins => '胜';

  @override
  String get losses => '负';

  @override
  String get draws => '和';

  @override
  String get lastUpdated => '上次更新';

  @override
  String get format => '格式：';

  @override
  String get resetStatistics => '重置统计数据';

  @override
  String get drawRate => '和棋率';

  @override
  String get lossRate => '输棋率';

  @override
  String get aiStatistics => 'AI 统计数据';

  @override
  String get enableStatistics => '启用统计';

  @override
  String get enableStatistics_Detail =>
      '启用后，对局结果将记录到统计数据中。但是，有悔棋的对局结果除外。如禁用，统计数据收集将暂停。';

  @override
  String get thisWillResetAllGameStatistics => '将重置游戏所有统计数据。此操作无法撤销。';

  @override
  String get boardInnerRingSize => '棋盘内圈大小';

  @override
  String get boardShadowEnabled => '棋盘阴影';

  @override
  String get trapAwareness => '陷阱感知';

  @override
  String get trapAwarenessDescription => '在分析过程中用粗圆圈和箭头高亮陷阱着法。';

  @override
  String trapExists(String trapMoves) {
    return '存在陷阱。陷阱着法: $trapMoves';
  }

  @override
  String get custodianCapture => '二夹一';

  @override
  String get custodianCaptureDescription => '沿着同一条线用己方两枚棋子夹住对方棋子即可吃掉对方棋子。';

  @override
  String get custodianCaptureEnable => '允许二夹一吃子';

  @override
  String get interventionCapture => '一挑二';

  @override
  String get interventionCaptureDescription => '移动到对方两枚棋子之间的空点，可同时吃掉这两枚棋子。';

  @override
  String get interventionCaptureEnable => '允许一挑二吃子';

  @override
  String get leapCapture => '跳吃';

  @override
  String get leapCaptureDescription => '跳过相邻的对方棋子并落到其后的空点以吃掉该棋子。';

  @override
  String get leapCaptureEnable => '允许跳吃';

  @override
  String get captureApplicableLines => '适用线段';

  @override
  String get captureSquareEdges => '正方形边线上';

  @override
  String get captureCrossLines => '穿过正方形边线的水平和垂直线上';

  @override
  String get captureDiagonalLines => '穿过正方形边线的斜线上';

  @override
  String get captureExecutionPhases => '执行阶段';

  @override
  String get capturePiecesCondition => '走子阶段按剩余棋子数量决定适用性';

  @override
  String get capturePiecesConditionUnlimited => '无限制';

  @override
  String get capturePiecesConditionSelfLeqThree => '己方剩余棋子≤3枚时可用';
}

/// The translations for Chinese, using the Han script (`zh_Hant`).
class SZhHant extends SZh {
  SZhHant() : super('zh_Hant');

  @override
  String get appName => '直棋';

  @override
  String get welcome => '歡迎使用';

  @override
  String get yes => '是';

  @override
  String get no => '否';

  @override
  String get game => '遊戲';

  @override
  String get humanVsAi => '人機對戰';

  @override
  String get humanVsHuman => '雙人對戰';

  @override
  String get aiVsAi => '機器對戰';

  @override
  String get humanVsCloud => '挑戰雲端';

  @override
  String get humanVsLAN => '聯網對戰';

  @override
  String get testViaLAN => '聯網測試';

  @override
  String get move => '著法';

  @override
  String get showMoveList => '顯示棋譜';

  @override
  String get moveList => '棋譜';

  @override
  String get noGameRecord => '暫無著法';

  @override
  String get ok => '好的';

  @override
  String get confirm => '確認';

  @override
  String get cancel => '取消';

  @override
  String get tipSelectWrong => '選擇的子不對';

  @override
  String get tipPlace => '放置你的棋子';

  @override
  String get tipBanPlace => '不能把它放在這裏';

  @override
  String get tipPlaced => '已落子';

  @override
  String get tipRemove => '請吃子';

  @override
  String get tipBanRemove => '不能吃這顆子';

  @override
  String get tipRemoved => '已移除';

  @override
  String get tipMove => '移動一個棋子';

  @override
  String get tipCannotPlace => '不可在此處落子';

  @override
  String get tipCannotMove => '不可移到此處';

  @override
  String get tipMill => '三子連珠 請吃子';

  @override
  String get tipContinueMill => '請繼續吃子';

  @override
  String get tipSelectOpponentsPiece => '請選擇對方的棋子';

  @override
  String get tipCannotRemovePieceFromMill => '不能吃三連中的棋子';

  @override
  String get tipCanMoveOnePoint => '請走到相鄰空位';

  @override
  String get tipCannotMoveOpponentsPieces => '不能移動對方的棋子';

  @override
  String get tipSelectPieceToMove => '請選擇要移動的己方棋子';

  @override
  String get tipHaveThreePiecesLeft => '只剩下3顆棋子了';

  @override
  String get tipCanMoveToAnyPoint => '可飛子到任意空位';

  @override
  String tipToMove(Object player) {
    return '輪到$player移動';
  }

  @override
  String get whiteWin => '先手方勝！';

  @override
  String get blackWin => '後手方勝！';

  @override
  String get won => '勝';

  @override
  String get lost => '負';

  @override
  String get thinking => '思考中…';

  @override
  String get newGame => '開始新局';

  @override
  String get importGame => '導入棋局';

  @override
  String get exportGame => '匯出棋局';

  @override
  String get gameImported => '遊戲已匯入';

  @override
  String cannotImport(Object invalidMove) {
    return '無法導入$invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => '著法和棋規不匹配';

  @override
  String get pleaseWait => '請稍候...';

  @override
  String get restartGame => '重新開局？';

  @override
  String get restart => '重開局';

  @override
  String get gameStarted => '遊戲開始 請落子';

  @override
  String get analyzing => '正在分析局面…';

  @override
  String error(Object message) {
    return '錯誤：$message';
  }

  @override
  String get winRate => '勝率';

  @override
  String get score => '比分：';

  @override
  String get white => '先手方';

  @override
  String get black => '後手方';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player的剩餘棋子少於3枚。';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player認輸了。';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player無路可走。';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return '$player因棋盤擺滿而無路可走。';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return '$player超時判負。';
  }

  @override
  String get drawReasonRule50 => '走子階段連續多步在規則指定的步數內未吃子，判和。';

  @override
  String get drawReasonBoardIsFull => '棋盤擺滿，無路可走，判和。';

  @override
  String get drawReasonThreefoldRepetition => '三次重複局面和。';

  @override
  String get gameOverUnknownReason => '遊戲結束！原因未知。';

  @override
  String get gameOver => '遊戲結束';

  @override
  String get youWin => '恭喜你贏了！';

  @override
  String challengeHarderLevel(int level) {
    return '後續提升難度嗎？提升後的難度等級將為$level級！';
  }

  @override
  String get youLose => '你輸了！';

  @override
  String get analyze => '分析';

  @override
  String get about => '關於';

  @override
  String version(Object versionNumber) {
    return '版本：$versionNumber';
  }

  @override
  String get thanks => '致謝';

  @override
  String get settings => '個人設定';

  @override
  String get options => '選項';

  @override
  String get generalSettings => '常規設定';

  @override
  String get skillLevel => '難度等級';

  @override
  String get moveTime => '機器思考時間';

  @override
  String get difficulty => '遊戲難度';

  @override
  String get playSounds => '聲音';

  @override
  String get playSoundsInTheGame => '行棋時播放聲音';

  @override
  String get keepMuteWhenTakingBack => '悔棋時保持靜音';

  @override
  String get tone => '提示音效';

  @override
  String get whoMovesFirst => '先手';

  @override
  String get human => '人類';

  @override
  String get ai => '機器';

  @override
  String get alternate => '交替';

  @override
  String get isAutoRestart => '棋局結束時自動重新開局';

  @override
  String get isAutoChangeFirstMove => '開局時自動交換先後手';

  @override
  String get shufflingEnabled => '機器隨機走子';

  @override
  String get misc => '其他';

  @override
  String get rules => '棋規';

  @override
  String get piecesCount => '棋子數';

  @override
  String get piecesCount_Detail => '對弈雙方分別擁有的棋子數為？';

  @override
  String get flyPieceCount => '剩餘多少子可飛子';

  @override
  String get flyPieceCount_Detail => '如允許飛子，則當一方剩餘多少枚棋子時可以飛棋。';

  @override
  String get piecesAtLeastCount => '少於幾個子則輸棋';

  @override
  String get hasDiagonalLines => '斜線';

  @override
  String get hasDiagonalLines_Detail => '在棋盤上增加四條斜線。';

  @override
  String get isDefenderMoveFirst => '後擺子的先走子';

  @override
  String get isDefenderMoveFirst_Detail => '在擺子階段後擺子的一方，在走子階段先走子。';

  @override
  String get mayRemoveMultiple => '吃多子';

  @override
  String get mayRemoveMultiple_Detail => '若同時形成多個三連，則形成幾個三連就能吃對方幾個子。';

  @override
  String get mayRemoveFromMillsAlways => '允許吃三連中的子';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      '預設情況下，不能吃三連中的子，除非對方所有子都在三連中。打開此選項可解除此限制。';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull => '當棋盤擺滿時先擺子的輸棋';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      '對於十二子棋，在擺子階段的最後，若棋盤擺滿而雙方均未吃子，則先手方輸棋，而非和棋。';

  @override
  String get isLoseButNotChangeSideWhenNoWay => '當無路可走時輸棋';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      '走子階段，當無路可走時輸棋，而非轉為由對方繼續走子。';

  @override
  String get mayFly => '飛子';

  @override
  String get mayFly_Detail => '當一方剩餘三或四枚(可配置)棋子時，此方可將棋子移動到棋盤任意空位上。';

  @override
  String get nMoveRule => 'N步規則';

  @override
  String get nMoveRule_Detail => '指定當連續多少步中沒有吃子時判為和局。';

  @override
  String get rollback => '回滚';

  @override
  String get pleaseSelect => '請選擇';

  @override
  String get copy => '複製';

  @override
  String get moveHistoryCopied => '棋譜已複製到剪貼簿。';

  @override
  String get help => '幫助中心';

  @override
  String get feedback => '問題回饋';

  @override
  String get exit => '退出遊戲';

  @override
  String get ruleSettings => '規則設定';

  @override
  String get color => '顏色';

  @override
  String get boardColor => '棋盤顏色';

  @override
  String get pieceColor => '棋子顏色';

  @override
  String get backgroundColor => '背景顏色';

  @override
  String get lineColor => '線條顏色';

  @override
  String get whitePieceColor => '先手方棋子顏色';

  @override
  String get blackPieceColor => '後手方棋子顏色';

  @override
  String get messageColor => '提示訊息顏色';

  @override
  String get isPieceCountInHandShown => '顯示手中剩餘棋子數';

  @override
  String get isNotationsShown => '棋盤邊緣顯示座標';

  @override
  String get isHistoryNavigationToolbarShown => '顯示著法導航工具列';

  @override
  String get display => '顯示';

  @override
  String get boardBorderLineWidth => '棋盤外框線寬';

  @override
  String get boardInnerLineWidth => '棋盤內部線寬';

  @override
  String get pieceWidth => '棋子大小';

  @override
  String get fontSize => '字體大小';

  @override
  String get standardNotation => '標準棋譜格式';

  @override
  String get restore => '重設';

  @override
  String get restoreDefaultSettings => '恢復默認設定';

  @override
  String pick(Object element) {
    return '選擇$element';
  }

  @override
  String get info => '訊息';

  @override
  String get hint => '提示';

  @override
  String get player => '玩家';

  @override
  String get player1 => '先手方';

  @override
  String get player2 => '後手方';

  @override
  String get howToPlay => '玩法說明';

  @override
  String get toPlacePiece => '點擊棋盤上的交叉點放置棋子。';

  @override
  String get toSelectPiece => '請選擇自己要移動的棋子。';

  @override
  String get toMovePiece => '點擊和此棋子相鄰的點以移動棋子。';

  @override
  String get toRemovePiece => '點擊對方的一顆棋子以吃子。';

  @override
  String get needToCreateMillFirst => '您需要先形成三連，才能吃掉對方的棋子。';

  @override
  String get needToPlayWithOwnPieces => '您需要走自己的棋子。';

  @override
  String get statistics => '統計資料';

  @override
  String get totalGames => '盤數';

  @override
  String get results => '結果';

  @override
  String get left => '剩餘';

  @override
  String get privacyPolicy => '隱私政策';

  @override
  String get privacyPolicy_Detail_1 =>
      '請您務必審慎閱讀、充分理解《使用者協議》和《隱私政策》各條款，包括但不限於：\n為了改善我們向您提供的服務，基於您的明示授權，我們可能會獲取您的設備型號、診斷資料、電子郵寄地址等資訊，您有權拒絕或取消授權。我們將在每次請求發送診斷資料前，通過彈窗形式征得您的明示同意。\n您可閱讀《';

  @override
  String get privacyPolicy_Detail_2 => '》瞭解詳細資訊。如您同意，請點擊「同意」開始接受我們的服務。';

  @override
  String get and => ' 》和《 ';

  @override
  String get accept => '同意';

  @override
  String get takeBack => '回退一步';

  @override
  String get takingBack => '回退中…';

  @override
  String get waiting => '請稍等…';

  @override
  String get stepForward => '前進一步';

  @override
  String get takeBackAll => '回退到底';

  @override
  String get stepForwardAll => '前進到底';

  @override
  String get moveNow => '立即行棋';

  @override
  String get done => '完成';

  @override
  String get crackMill => '可從三連中吃子';

  @override
  String get crackMill_Detail => '若對方所有的子都在三連中，仍可吃子。';

  @override
  String get animationDuration => '動畫持續時長';

  @override
  String get none => '無';

  @override
  String get theme => '主題';

  @override
  String get helpContent =>
      '直棋是一個非常古老的智力遊戲，現已流傳到中國各地，演變出「棋三」、「三棋」、「三三棋」、「打三棋」、「成三棋」、「下連」等多個變種。\n\n遊戲目標為讓對手被吃得僅剩不到三枚棋子。\n\n三次重複局面，或連續百步（可配置）內無吃子，則和棋。 \n\n遊戲分三階段：\n\n1. 在空位上擺子；\n2. 將棋子移動到相鄰空位；\n3. 當只剩三枚棋子時，可「飛子」（可選）。\n\n擺子階段\n\n棋盤上有二十四個空點。玩家交替在空位上落子，直至手中無子。若一方將自己的三枚棋子排成一排，則稱為形成一個「三連」，便可吃掉對方的棋子，然後繼續行棋。\n\n某些規則變體規定，只能吃掉對方不在「三連」中的子，除非對方所有的子都在「三連」之中。\n\n還有些規則變體規定，在擺子階段，被吃掉的子所在的空位，雙方都不能再在上面擺子。 \n\n當雙方手中的棋子都擺完後，則進入走子階段。\n\n走子階段\n\n玩家將自己的棋子移動到相鄰的點上。若無子可走，則判負。和擺子階段類似，形成「三連」時便可吃掉對方的棋子。當一方的棋子僅剩兩枚，則敗局已定，判負。若棋盤上多於三枚棋子，但無子可走，也會被判負。\n\n飛子階段\n\n某些規則變體中，一旦一方剩三枚棋子時，便可「飛」到任意空位上，無論該空位是否鄰接。\n';

  @override
  String get versionInfo => '版本資訊';

  @override
  String get eula => '使用者協定';

  @override
  String get license => '許可證';

  @override
  String get sourceCode => '原始程式碼';

  @override
  String get appVersion => '應用版本';

  @override
  String get general => '常規';

  @override
  String get advanced => '高級';

  @override
  String get placing => '擺子';

  @override
  String get moving => '走子';

  @override
  String get removing => '吃子';

  @override
  String get gameOverCondition => '終局條件';

  @override
  String get aisPlayStyle => '機器的棋風';

  @override
  String get passive => '消極被動';

  @override
  String get timeout => '超時';

  @override
  String get appearance => '外觀設定';

  @override
  String get drawOnHumanExperience => '借鑒人類經驗';

  @override
  String get considerMobility => '增強棋子活動能力';

  @override
  String get pieceCount => '棋子數';

  @override
  String inHand(Object player, int count) {
    return '$player手上：$count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player棋盤上：$count';
  }

  @override
  String get boardTop => '棋盤和上邊緣的間距';

  @override
  String get notAIsTurn => '現在不是輪到電腦行棋';

  @override
  String get aiIsNotThinking => '電腦並非正在思考中';

  @override
  String get atEnd => '已經到底了';

  @override
  String get tapBackAgainToLeave => '再次按 Back 鍵退出';

  @override
  String get more => '更多';

  @override
  String get experimental => '此仍屬實驗性功能。';

  @override
  String get experiments => '實驗性功能';

  @override
  String get ossLicenses => '開放原始程式碼許可';

  @override
  String get language => '顯示語言';

  @override
  String get defaultLanguage => '預設語言';

  @override
  String get mayMoveInPlacingPhase => '可以在擺子階段走子';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      '擺子階段和走子階段無嚴格界限。即，玩家可以在每一步棋中決定是要擺子還是走子 (只要還有剩餘的棋子可以擺子)。';

  @override
  String get drawerColor => '菜單顏色';

  @override
  String get drawerTextColor => '菜單文字顏色';

  @override
  String get drawerHighlightItemColor => '菜單高亮條目背景色';

  @override
  String get mainToolbarBackgroundColor => '主工具欄背景色';

  @override
  String get mainToolbarIconColor => '主工具欄圖標色';

  @override
  String get navigationToolbarBackgroundColor => '導航工具欄背景色';

  @override
  String get navigationToolbarIconColor => '導航工具欄圖標色';

  @override
  String get autoHideToolbar => '自動隱藏工具欄';

  @override
  String get toolbarLocationOnScreen => '工具欄在屏幕上的位置';

  @override
  String get top => '頂部';

  @override
  String get bottom => '底部';

  @override
  String get center => '中部';

  @override
  String get solidColor => '純色';

  @override
  String get picture => '圖片';

  @override
  String get chooseYourPicture => '選擇圖片';

  @override
  String get light => '明亮';

  @override
  String get dark => '暗黑';

  @override
  String get themes => '主題';

  @override
  String get currentTheme => '當前主題';

  @override
  String get saveTheme => '保存主題';

  @override
  String get showAnalysisGraph => '顯示分析圖';

  @override
  String get analysis => '分析';

  @override
  String get saveGame => '保存遊戲';

  @override
  String get loadGame => '加載遊戲';

  @override
  String get setupPosition => '設定局面';

  @override
  String get showLegalMoves => '顯示合法著法';

  @override
  String get showLastMove => '顯示最後一著';

  @override
  String get showArrows => '顯示箭頭';

  @override
  String get pieces => '棋子';

  @override
  String get showAnalysis => '顯示分析';

  @override
  String get threads => '線程數';

  @override
  String get getInvolved => '參與項目';

  @override
  String get helpImproveTranslate => '幫助翻譯';

  @override
  String get tutorial => '教程';

  @override
  String get classicMill => '經典磨坊';

  @override
  String get mixedMill => '混合磨坊';

  @override
  String get ceylonMill => '錫蘭磨坊';

  @override
  String get mayBreakAndRemakeMillRepeatedly => '允許反复連續形成三連';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      '如果一方在一著中解除了一個三連並同時形成了一個新的三連，那麼允許其在下一步棋把這個棋子再移回前一著的位置，從而反复連續形成三連。';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      '一方剩下三個棋子並十步內雙方均未吃子則和棋';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      '當一方只剩下三顆棋子時，而雙方都不能在接下來十步之內吃掉對方的棋子，則判為和棋。';

  @override
  String get close => '關閉';

  @override
  String get whitePiece => '白棋';

  @override
  String get blackPiece => '黑棋';

  @override
  String get emptyPoint => '空點';

  @override
  String get noPoint => '無點';

  @override
  String get placingPhase => '擺子階段';

  @override
  String get movingPhase => '走子階段';

  @override
  String get flyingPhase => '飛子階段';

  @override
  String sideToMove(Object player) {
    return '輪到$player行棋';
  }

  @override
  String lastMove(Object move) {
    return '最後一著：$move';
  }

  @override
  String get selected => '已選中';

  @override
  String get accessibility => '無障礙';

  @override
  String get screenReaderSupport => '屏幕閱讀器支援';

  @override
  String get isDraw => '和棋';

  @override
  String get draw => '和棋';

  @override
  String get pieceHighlightColor => '棋子高亮顏色';

  @override
  String get algorithm => '算法';

  @override
  String get endgameNMoveRule => '終盤N步規則';

  @override
  String get endgameNMoveRule_Detail => '指定當至少一方只剩下三枚棋子時，雙方連續多少步均未吃子時，判為和局。';

  @override
  String get drawReasonEndgameRule50 => '至少有一方只剩下三枚棋子，且雙方連續多步均未吃子。';

  @override
  String get threefoldRepetitionRule => '三次重複局面和';

  @override
  String get threefoldRepetitionRule_Detail => '在對局時，同一局面連續或間斷出現三次，則判為和局。';

  @override
  String get continueToMakeMove => '三子連珠 請繼續行棋';

  @override
  String get pointStyle => '棋盤交叉點的樣式';

  @override
  String get pointWidth => '棋盤交叉點的大小';

  @override
  String get solid => '實心圓';

  @override
  String get hollow => '空心圓';

  @override
  String get languageName => '繁體中文';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 步',
      one: '$count 步',
      zero: '步',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => '載入失敗';

  @override
  String get filename => '檔名';

  @override
  String get browse => '瀏覽…';

  @override
  String get gameFiles => '遊戲檔';

  @override
  String get gameSavedTo => '遊戲已保存到';

  @override
  String get empty => '空點';

  @override
  String get noMove => '暫無著法';

  @override
  String get restoredPosition => '已還原至初始局面';

  @override
  String get clean => '清盤';

  @override
  String get cleanedUp => '已清盤';

  @override
  String get remove => '將吃幾子';

  @override
  String get noPiecesCanBeRemoved => '無子可吃';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count 枚子',
      one: '$count 枚子',
      zero: 'Piece',
    );
    return '$_temp0將被吃';
  }

  @override
  String placedCount(int count) {
    return '已摆$count子';
  }

  @override
  String get placedPieceCount => '設置當前行棋方，在擺子階段，已擺的棋子數量';

  @override
  String hasPlacedPieceCount(int count) {
    return '當前輪到的行棋方被設置為已擺了 $count 枚棋子';
  }

  @override
  String get notPlacingPhase => '非擺子階段，不能設定此值';

  @override
  String get paste => '粘貼';

  @override
  String get pasteDone => '已粘貼';

  @override
  String get cannotPaste => '無法貼上';

  @override
  String get isUnplacedAndRemovedPiecesShown => '顯示未擺和已吃的子';

  @override
  String get fullScreen => '全屏顯示';

  @override
  String get reopenToTakeEffect => '退出並重新打開應用程序以使設置生效。';

  @override
  String get forest => '原野森林';

  @override
  String get desktopImage => '桌面圖片';

  @override
  String get invalidPosition => '無效的棋局';

  @override
  String get shareGIF => '動圖分享';

  @override
  String get pixelRatio => '像素比';

  @override
  String get duration => '持續時間';

  @override
  String get gameScreenRecorder => '遊戲錄屏';

  @override
  String get previous => '以前的';

  @override
  String get next => '下一個';

  @override
  String get skip => '跳過';

  @override
  String get gotIt => '知道了';

  @override
  String get youCanModifyRules => '您可以在規則設置中修改遊戲規則。';

  @override
  String get youCanUseMouseWheelInPicker => '您可以使用鼠標滾輪來選擇值。';

  @override
  String get noTimeLimitForThinking => '機器思考時間設置為 0 則表示沒有思考時間的限制。';

  @override
  String get whatIsMtdf =>
      'MTD(f) 是 alpha-beta 搜索算法的一種改進形式，旨在通過重用中間搜索結果和使用良好的初始猜測來縮小搜索空間來提高效率。';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      '請注意，機器思考時間的調整可能並不精確。當難度等級設置為較低值時，實際思考時間可能會更短，而當時間耗盡時 AI 還在思考時，則實際思考時間可能會更長。';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      '如果將難度設置得很高，但未增加 AI 的思考時間，實際難度可能會因為思考時間的限製而被壓縮在較低的水平。實際的難度水平會因機器性能而異。';

  @override
  String get whatIsPvs =>
      'PVS 是一種搜索算法，用於在給定局面找到最佳著法。它是對 Alpha-Beta 算法的增強，並使用空或零窗口搜索來確認著法是否比主要變例的安全分數更差或不差。 PVS 關注最有前途的著法，避免不必要的次優分支搜索，有助於提高搜索效率。';

  @override
  String get whatIsAlphaBeta =>
      'alpha-beta 算法是一種尋找最佳著法的搜索算法。它使用 minimax 原則和兩個值 alpha 和 beta 來修剪搜索樹並提高效率。 Alpha 代表計算機確定能得到的最低分數，而 beta 代表它的對手能得到的最大分數。該算法幫助計算機在遊戲中做出明智、高效的決策。';

  @override
  String get drawOnTheHumanExperienceDetail =>
      '孫子曰：昔之善戰者，先為不可勝，以待敵之可勝。不可勝在己，可勝在敵。故善戰者，能為不可勝，不能使敵之必可勝。故曰：勝可知，而不可為。如啟用這一選項，將使得 AI 在開局階段不會猛烈進攻，而是用緩着靜待時機到來。';

  @override
  String get firstMoveDetail => '在這個遊戲中，後手方比先手方更容易取勝。';

  @override
  String get passiveDetail => '啟用「消極被動」選項將使得 AI 在佔據主動時有所放鬆，手下留情，而不是力爭盡快取勝。';

  @override
  String get moveRandomlyDetail => '啟用此選項可增加遊戲的隨機性和趣味性，而禁用此選項可有助於研究打敗 AI 之道。';

  @override
  String get considerMobilityOfPiecesDetail =>
      '若 AI 考量到自己棋子的機動性，那麼它不僅會以最快的速度吃掉對方的棋子為目標，還會考量封堵對方的路線，讓對方無路可走，並力圖避免對方以其人之道還治其人之身。';

  @override
  String get whenBoardIsFull => '當棋盤擺滿時';

  @override
  String get whenBoardIsFull_Detail => '在擺子階段結束時，在走子階段開始前，如棋盤已擺滿，則接下來的動作為？';

  @override
  String get sideToMoveRemovePiece => '進入走子階段前，先行方先移除對手的一枚棋子。';

  @override
  String get agreeToDraw => '雙方和棋。';

  @override
  String get takeOpponentsPiece => '請抽掉對方的一枚棋子';

  @override
  String get firstPlayerLose => '先手方負。';

  @override
  String get firstAndSecondPlayerRemovePiece => '先手方和後手方先後移除對方的一枚棋子。';

  @override
  String get secondAndFirstPlayerRemovePiece => '後手方和先手方先後移除對方的一枚棋子。';

  @override
  String get enteredFlyingPhase =>
      '現已進入「飛行階段」，對方棋子可跳到棋盤上的任意空點。您可以在「規則設置」中關閉飛子規則。';

  @override
  String get whenStalemate => '當無子可走時';

  @override
  String get whenStalemate_Detail => '當無子可走時，接下來的動作為？';

  @override
  String get endWithStalemateLoss => '因無子可走而判負。';

  @override
  String get changeSideToMove => '改由對手繼續走棋。';

  @override
  String get removeOpponentsPieceAndMakeNextMove => '移除對手的一枚棋子然後自己繼續走棋。';

  @override
  String get endWithStalemateDraw => '因無子可走而判和。';

  @override
  String get removeOpponentsPieceAndChangeSideToMove => '移除對手的一枚棋子然後由對方繼續走棋。';

  @override
  String get aiResponseDelayTime => 'AI 響應延遲時間';

  @override
  String get aiIsDelaying => 'AI 目前處於延遲響應階段。請稍等片刻再繼續。';

  @override
  String get tipCanNotRemoveNonadjacent => '只能移除和自己棋子相鄰的棋子';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      '在無路可走的情況下，只要對方的子和自己的子相鄰，則無論這些子是否在三連中，都可以被移除。';

  @override
  String get whatIsMcts => 'MCTS 是一種對初學者友好的算法，它通過模擬探索和評估不同的著法來做出決策。';

  @override
  String get goldenJade => '金玉';

  @override
  String get forestWood => '林木';

  @override
  String get darkMystery => '暗谜';

  @override
  String get midnightBlue => '夜藍';

  @override
  String get greenForest => '翠林';

  @override
  String get greenMeadow => '綠草';

  @override
  String get stonyPath => '石徑';

  @override
  String get pastelPink => '粉彩';

  @override
  String get turquoiseSea => '碧海';

  @override
  String get violetDream => '紫夢';

  @override
  String get mintChocolate => '荷巧';

  @override
  String get skyBlue => '藍天';

  @override
  String get playfulGarden => '花園';

  @override
  String get whatIsRetrogradeAnalysis =>
      '逆行分析算法使用多值逆行分析從不同的開始局面構建殘局數據庫，然後應用此數據庫優化遊戲玩法。這種方法屬於超強解決方案的範疇。';

  @override
  String get viewAlgorithmGuide => '您想查看此算法的用戶指南嗎？';

  @override
  String get showPositionalAdvantageIndicator => '顯示棋勢優劣指示器';

  @override
  String get usePerfectDatabase => '使用完美資料庫';

  @override
  String get perfectDatabaseDescription =>
      '開啟此選項以使用由先進演算法所生成的完美遊戲資料庫。此功能整合了開局與殘局策略，以推薦最優著法，是追求遊戲中極高準確度的玩家的首選。資料庫透過細緻的計算技術建立，目的在於提供幾乎完美的遊戲解法。\n\n注意：若機器無法存取資料庫，則會改用傳統演算法作遊戲決策。當資料庫可用時，「難度等級」實際上將變得極為挑戰性，而「機器思考時間」將大幅縮減。在「機器的棋風」的設定選項中，多數設定也會被覆蓋，因為資料庫結果擁有最高優先性。\n\n如需瞭解如何善用這個完美資料庫，請點此。';

  @override
  String get backgroundImage => '背景圖片';

  @override
  String get whatIsRandom =>
      '當「使用完美資料庫」選項未啟用時，「隨機」設置會使機器在不採用任何移動選擇算法的情況下隨機移動棋子。這通常會導致遊戲性顯著較弱。相反地，啟用「使用完美資料庫」時，人工智慧完全依賴「完美資料庫」進行決策，而不是將其與傳統的人工智慧算法結合。在這種模式下，人工智慧的動作完全基於資料庫的內容，避免了依賴即時計算或搜尋算法。';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      '吃掉對方手中的棋子；然後輪到對方擺子。';

  @override
  String get whenFormingMillsDuringPlacingPhase => '在擺子階段形成三連時';

  @override
  String get removeOpponentsPieceFromBoard => '吃掉棋盤上對方的棋子。';

  @override
  String get removeOpponentsPieceFromBoard_Detail => '吃掉棋盤上對方的棋子；然後輪到對方擺子。';

  @override
  String get opponentRemovesOwnPiece => '由對方自己來吃自己的棋子。';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      '不是由己方來吃子，而是由對方從棋盤上選擇並移除自己的棋子，實際上對方是在採取不利於自己的行動。';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn => '移除對方手中的棋子；然後輪到己方行棋。';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      '移除對方手中的棋子。如果根據「吃多子」設定需要移除多個棋子，而對方手中已經沒有棋子了，則繼續從棋盤上吃掉對方的棋子。然後，輪到己方行棋。如果己方繼續形成三連，己方可以繼續移除對方的棋子。';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      '移除對方手中的棋子。如果根據「吃多子」設定需要移除多個棋子，而對方手中已經沒有棋子了，則繼續從棋盤上吃掉對方的棋子。然後，輪到對方行棋。';

  @override
  String get markAndDelayRemovingPieces => '標記並延遲移除棋子。';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      '在擺子階段，要吃掉的棋子被標記起來，雙方都不能在這些點上擺新子。進入走子階段後，這些被標記的子會一起被移除，接下來雙方便可將自己的棋子走到這些點上。';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail => '在擺子階段形成三連時，可以採取的行動。';

  @override
  String get marked => '標記';

  @override
  String get menu => '菜單';

  @override
  String get monochrome => '黑白';

  @override
  String get youCanEnableScreenReaderSupport =>
      '您可以在「常規設定」中的「輔助功能」配置中打開「螢幕閱讀器支持」開關。';

  @override
  String get showNumbersOnPieces => '在棋子上顯示數字';

  @override
  String get saveImage => '儲存圖片';

  @override
  String get isAnalysisToolbarShown => '顯示分析工具列';

  @override
  String get analysisToolbarBackgroundColor => '分析工具列背景顏色';

  @override
  String get analysisToolbarIconColor => '分析工具列圖示顏色';

  @override
  String get transformed => '已轉換';

  @override
  String get cannotTransform => '無法轉換';

  @override
  String get rotate => '旋轉';

  @override
  String get horizontalFlip => '左右';

  @override
  String get verticalFlip => '上下';

  @override
  String get innerOuterFlip => '内外';

  @override
  String get transparentCanvas => '透明';

  @override
  String get restrictRepeatedMillsFormation => '限制重複形成三連';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      '從一個三連移動到另一個三連的棋子不能在下一回合立即返回原點再次形成三連。首先需要另一種移動。';

  @override
  String get oneTimeUseMill => '一次性三連';

  @override
  String get oneTimeUseMill_Detail => '每個三連只能吃掉一次對手的棋子。您可以再次重組它，但不能用於額外的吃子。';

  @override
  String get currentRulesNoPerfectDatabase =>
      '您設定的當前規則沒有相應的完美數據庫。 有關完美數據庫的更多信息，請點擊此處。';

  @override
  String get focusOnBlockingPaths => '專注於封堵路徑';

  @override
  String get focusOnBlockingPaths_Detail =>
      '在游戏的特定阶段中，優先阻礙對手走棋，而不是形成三連。在這些階段中，AI 不會專注於通過形成三連來吃掉對方的棋子，而是旨在困住對方，使對方的棋子無法移動，並通過消耗戰而不是積極進攻來爭取勝利。這種針對特定階段的策略不會主動阻止對方形成三連。';

  @override
  String get pieceImage => '棋子圖片';

  @override
  String get importColorSettings => '導入顏色設置';

  @override
  String get exportColorSettings => '導出顏色設置';

  @override
  String get import => '導入';

  @override
  String get export => '導出';

  @override
  String get pleaseCopyJsonToClipboard => '請先將 JSON 格式的設置複製到剪貼板。';

  @override
  String get copiedToClipboard => '已複製到剪貼板。';

  @override
  String get imported => '已導入。';

  @override
  String get boardImage => '棋盤圖片';

  @override
  String get autumnLeaves => '秋葉';

  @override
  String get legendaryLand => '青綠';

  @override
  String get vignetteEffect => '暗角效果';

  @override
  String get promptMakeToolbarTransparent => '當設置了棋盤背景圖片時，您是否希望工具欄完全透明？';

  @override
  String get vibration => '遊戲中啟用振動';

  @override
  String get soundTheme => '聲音主題';

  @override
  String get ball => '球';

  @override
  String get liquid => '水';

  @override
  String get wood => '木';

  @override
  String get placeEffectAnimation => '擺子的動畫效果';

  @override
  String get removeEffectAnimation => '吃子的動畫效果';

  @override
  String get isToolbarAtBottom => '工具列顯示在底部';

  @override
  String get boardCornerRadius => '棋盤圓角半徑';

  @override
  String get useOpeningBook => '使用開局庫';

  @override
  String get currentRule => '當前的';

  @override
  String get nineMensMorris => '九子直棋';

  @override
  String get twelveMensMorris => '十二子直棋';

  @override
  String get morabaraba => '南非直棋';

  @override
  String get dooz => '波斯多茲';

  @override
  String get chamGonu => '韓國直棋';

  @override
  String get zhiQi => '直棋';

  @override
  String get chengSanQi => '成三棋';

  @override
  String get mulMulan => '爪哇直棋';

  @override
  String get nerenchi => '錫蘭直棋';

  @override
  String get ruleSet => '規則集';

  @override
  String get laskerMorris => '拉斯卡直棋';

  @override
  String get oneTimeMill => '俄羅斯直棋';

  @override
  String get daSanQi => '打三棋';

  @override
  String get useOpeningBook_Detail =>
      '讓 AI 在開局階段採用人類專業棋手慣用的著法。注意：此功能目前僅適用於特定棋規。';

  @override
  String get showAdvantageGraph => '顯示優勢圖';

  @override
  String get advantageGraphHint => '僅當 AI 下子後，優勢圖才會繪製。當人類玩家下子時則不會繪製。';

  @override
  String get removalBasedOnMillCounts => '在所有棋子擺完之前，不能吃掉對方棋子。擺完後，依照三連數量來吃子。';

  @override
  String get removalBasedOnMillCounts_Detail =>
      '在雙方所有棋子擺完之前，不能吃掉對方棋子。雙方都擺完後，雙方根據己方形成的三連數量來吃掉對方的棋子：如果三連數量相同，則雙方吃掉對方相同數量的棋子；如果一方的三連更多，則最多只比對方多吃掉一枚棋子。如果只有一方形成三連，則該方吃掉兩枚棋子，另一方吃掉一枚。如果雙方都沒有形成三連，則雙方各移除己方一枚棋子。';

  @override
  String get elfilja => '北非直棋';

  @override
  String get tipSelectOwnPiece => '請選擇自己的棋子';

  @override
  String get notYourTurn => '還沒輪到你行棋';

  @override
  String get annotationToolbarBackgroundColor => '標註工具欄背景顏色';

  @override
  String get annotationToolbarIconColor => '標註工具欄圖示顏色';

  @override
  String get isAnnotationToolbarShown => '顯示標註工具欄';

  @override
  String get enterAnnotationMode => '進入標註模式';

  @override
  String get areYouSureYouWantToClearAllAnnotations => '您確定要清除所有標註嗎？';

  @override
  String get llmPromptCopiedToClipboard => '大模型提示詞已複製到剪貼板。';

  @override
  String get connectionRefusedTheServerMayBeDown => '連線被拒絕，伺服器可能已當機';

  @override
  String get discoverySuccessfulAwaitingConnection => '發現成功，等待連線...';

  @override
  String get noLanConnection => '無局域網連線';

  @override
  String get takeScreenshot => '截圖';

  @override
  String get disconnectedFromOpponent => '已與對手斷開連線。';

  @override
  String get takeBackRequest => '悔棋請求';

  @override
  String get nothingToShow => '無可顯示內容。';

  @override
  String get stopHosting => '停止服務';

  @override
  String get connectionResetByPeer => '連線被對方重置';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      '由於心跳超時，連線丟失。請重新連線。';

  @override
  String get startHosting => '開始服務';

  @override
  String get restartRequestRejected => '重啟請求被拒絕。';

  @override
  String get notConnectedToLanOpponent => '未連接到局域網對手。';

  @override
  String get llmPrompt => '大模型提示詞';

  @override
  String get gameRestarted => '遊戲已重啟';

  @override
  String get takeBackRejected => '悔棋請求被拒絕';

  @override
  String get areYouSureYouWantToResignThisGame => '您確定要認輸嗎？';

  @override
  String get opponentResignedYouWin => '對手認輸。你贏了！';

  @override
  String get clearAllAnnotations => '清除所有標註';

  @override
  String get connectedWaitingForOpponentSMove => '已連線，等待對手走棋...';

  @override
  String get networkStatusDisconnected => '網路狀態：斷開';

  @override
  String get takeBackRequestSentToTheOpponent => '已向對手發送悔棋請求。';

  @override
  String get theOpponentMayHaveLeftTheGame => '對手可能已離開遊戲';

  @override
  String get connectedToHostSuccessfully => '已成功連接到主機';

  @override
  String get connectionLostHeartbeatTimeout => '連線丟失：心跳超時';

  @override
  String get noHostDiscovered => '未發現主機。';

  @override
  String get confirmResignation => '確認認輸';

  @override
  String get startedHostingGameWaitingForPlayersToJoin => '已開始服務，等待玩家加入...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable => '連線超時，網路連線不穩定';

  @override
  String get noLlmPromptAvailable => '無可用的大模型提示詞';

  @override
  String get youResignedGameOver => '你已認輸。遊戲結束';

  @override
  String get serverIp => '伺服器 IP';

  @override
  String get confirmClear => '確認清除';

  @override
  String get opponentSTurn => '輪到對方行棋';

  @override
  String get waitingAClientConnection => '等待客戶端連線...';

  @override
  String get takeBackRequestWasRejectedOrFailed => '悔棋請求被拒絕或失敗。';

  @override
  String get addText => '新增文字';

  @override
  String get exitAnnotationMode => '退出標註模式';

  @override
  String get typeYourAnnotation => '輸入您的標註';

  @override
  String get attemptingToReconnect => '嘗試重新連線...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      '重新開始遊戲的請求已發送，等待對手回覆...';

  @override
  String get serverIsStopped => '伺服器已停止';

  @override
  String get restartRequest => '重啟請求';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn => '並非輪到你行棋，故無法請求悔棋。';

  @override
  String get takeBackAccepted => '悔棋請求已被接受';

  @override
  String get localNetworkSettings => '本地網路設定';

  @override
  String get reconnectedSuccessfully => '重新連線成功！';

  @override
  String get failedToSaveImageToGallery => '儲存圖片到圖庫失敗。';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept => '對手請求重啟遊戲。你同意嗎？';

  @override
  String get yourTurn => '輪到你了';

  @override
  String get unableToReconnectPleaseRestartTheGame => '無法重新連線，請重啟遊戲';

  @override
  String get host => '主機';

  @override
  String get join => '加入';

  @override
  String get port => '端口';

  @override
  String get invalidIpAddress => '無效的 IP 地址。';

  @override
  String get invalidPort => '無效的端口。';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return '正在連線：嘗試 $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return '連線失敗：$error';
  }

  @override
  String failedToStartHosting(Object error) {
    return '啟動服務失敗：$error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return '發現主機：$ip:$port';
  }

  @override
  String get stop => '停止';

  @override
  String get discover => '發現';

  @override
  String get connect => '連線';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return '客戶端已連線：$clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return '正在發現：$seconds 秒';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return '重連 ($attempt/$maxAttempts)';
  }

  @override
  String get connected => '已連線';

  @override
  String get delete => '刪除';

  @override
  String get ancientEgypt => '敦煌';

  @override
  String get gothicIce => '凜珥';

  @override
  String get riceField => '禾溟';

  @override
  String get chinesePorcelain => '瓷蘊';

  @override
  String get desertDusk => '沙焃';

  @override
  String get precisionCraft => '微鏨';

  @override
  String get folkEmbroidery => '鄉綺';

  @override
  String get carpathianHeritage => '喀琛';

  @override
  String get imperialGrandeur => '冕赫';

  @override
  String get bohemianCrystal => '波璨';

  @override
  String get savannaSunrise => '莽熹';

  @override
  String get harmonyBalance => '和衡';

  @override
  String get cinnamonSpice => '桂辛';

  @override
  String get anatolianMosaic => '瑰瑍';

  @override
  String get carnivalSpirit => '歡猋';

  @override
  String get custom => '自訂';

  @override
  String get spiceMarket => '辛墟';

  @override
  String get swipeToRevealTheDrawer => '滑動以顯示抽屜';

  @override
  String get showGameInfoOnScreenshots => '在截圖上顯示棋局資訊';

  @override
  String get humanMoveTime => '人類思考時間限制';

  @override
  String get noTimeLimitForHumanMoves => '人類思考時間無限制';

  @override
  String get timeoutLoseWillBeApplied => '對於人類而言，超時將被判負';

  @override
  String get identifyingBoard => '正在辨識棋盤…';

  @override
  String get youCanEnterAnyModelName => '您可以輸入任何模型名稱。';

  @override
  String get boardPositionAppliedFenCopiedToClipboard => '棋盤佈局已套用，FEN 已複製到剪貼簿。';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      '建議：請嘗試拍攝更清晰的棋盤照片。';

  @override
  String get llmPromptTemplate => 'LLM 提示詞範本';

  @override
  String get noValidBoardDetected => '未偵測到有效的棋盤。';

  @override
  String get selectingImageFromAlbum => '從相簿選取影像中…';

  @override
  String get configurePromptTemplate => '設定 LLM 提示詞範本';

  @override
  String get editPromptTemplateForLlmAnalysis => '編輯 LLM 分析提示提示詞範本';

  @override
  String get failedToGenerateFenFromRecognizedBoard => '無法從辨識的棋盤生成 FEN。';

  @override
  String get outputInCurrentLanguage => '以當前語言輸出';

  @override
  String get commonBaseUrls => '常用 Base URL';

  @override
  String get viewCommonModels => '查看常用模型';

  @override
  String get recognitionParametersUpdated => '辨識參數已更新。';

  @override
  String get whiteSMove => '白方走棋';

  @override
  String get resetToDefaults => '重設為預設值';

  @override
  String get photoShoot => '拍照';

  @override
  String get failedToApplyRecognizedBoardPosition => '無法套用辨識到的棋盤佈局。';

  @override
  String get llmPromptContent => 'LLM 提示詞內容';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings => '尚未設定LLM，請檢查您的設定。';

  @override
  String get setProviderModelApiKeyAndBaseUrl => '設定提供者、模型、API Key 與 Base URL';

  @override
  String get llmConfiguration => 'LLM 設定';

  @override
  String get configureLlmProvider => '設定 LLM 提供者';

  @override
  String get llmPromptTemplateHeader => 'LLM 提示詞範本標頭';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      '影像中未辨識到任何棋子，請再試一次。';

  @override
  String get recognizeBoardFromImage => '從影像辨識棋盤';

  @override
  String get viewTips => '查看提示';

  @override
  String get applyToBoard => '套用到棋盤';

  @override
  String get adjustBoardArea => '調整棋盤區域';

  @override
  String get viewCommonUrls => '查看常用 URL';

  @override
  String get colorAnalysisFailed => '顏色分析失敗！';

  @override
  String get analyzingGameBoardImage => '正在分析棋盤影像…';

  @override
  String get selectFromAlbum => '從相簿選取';

  @override
  String get noBoardPointDetected => '未偵測到棋盤點位！';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed => '如留空則使用預設範本';

  @override
  String get llmConfig => 'LLM 設定';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      '您確定要將提示範本重置為預設值嗎？';

  @override
  String get llmPromptTemplateFooter => 'LLM 提示詞範本頁尾';

  @override
  String get loadingResponse => '載入回應中…';

  @override
  String get applyThisResultToBoard => '將此結果套用到棋盤';

  @override
  String get takingPicture => '拍攝中…';

  @override
  String get pleaseSelectAGameBoardImageToIdentify => '請選擇一張棋盤影像進行辨識';

  @override
  String get identificationResults => '辨識結果';

  @override
  String get analyzeTheMovesAndProvideInsights => '分析走法並提供洞見。';

  @override
  String get getApiKey => '取得 API Key';

  @override
  String get entireRecognitionProcessFailedToComplete => '整個辨識流程未能完成。';

  @override
  String get boardRecognitionResult => '棋盤辨識結果';

  @override
  String get askLlm => '詢問 LLM';

  @override
  String get boardDetectionFailed => '棋盤偵測失敗！';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece => '未偵測到棋盤點位，無法辨識棋子！';

  @override
  String get copyFen => '複製 FEN';

  @override
  String get commonlyUsedModels => '常用模型';

  @override
  String get apiKeyOptional => 'API Key（選填）';

  @override
  String get noImageSelected => '尚未選擇影像';

  @override
  String get blackSMove => '黑方走棋';

  @override
  String get llm => '大型語言模型';

  @override
  String get llmProvider => '提供者';

  @override
  String get baseUrl => '基底 URL';

  @override
  String get model => '模型';

  @override
  String get temperature => '溫度';

  @override
  String get llmCommandReceivedProcessing => '已收到指令！AI 正在處理...';

  @override
  String get llmDeepThinkingWait => '深度思考進行中，請稍候...';

  @override
  String get llmPresentingSoon => '即將呈現...';

  @override
  String get recognitionParameters => '識別參數';

  @override
  String get adjustParamsDesc => '調整參數以提高識別準確率';

  @override
  String get saveParameters => '保存參數';

  @override
  String unableToStartImageRecognition(String error) {
    return '無法啟動圖像識別：$error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return '圖像識別失敗：$error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return '已套用棋局：白方 $whiteCount 枚子，黑方 $blackCount 枚子';
  }

  @override
  String get fenCopiedToClipboard => '（FEN 已複製到剪貼簿）';

  @override
  String recognitionFailed(String error) {
    return '識別失敗：$error';
  }

  @override
  String get myRating => '我的積分';

  @override
  String get gamesPlayed => '已玩遊戲數';

  @override
  String get wins => '勝';

  @override
  String get losses => '負';

  @override
  String get draws => '和';

  @override
  String get lastUpdated => '上次更新';

  @override
  String get format => '格式：';

  @override
  String get resetStatistics => '重設統計資料';

  @override
  String get drawRate => '和局率';

  @override
  String get lossRate => '敗局率';

  @override
  String get aiStatistics => 'AI 統計資料';

  @override
  String get enableStatistics => '啟用統計';

  @override
  String get enableStatistics_Detail =>
      '啟用後，遊戲結果將記錄至統計資料中。然而，涉及悔棋的遊戲將不會被記錄。停用後，統計資料收集將暫停。';

  @override
  String get thisWillResetAllGameStatistics => '這將重設所有遊戲統計資料。此動作無法復原。';

  @override
  String get boardInnerRingSize => '棋盤內圈大小';

  @override
  String get boardShadowEnabled => '棋盤陰影';

  @override
  String get trapAwareness => '陷阱偵測';

  @override
  String get trapAwarenessDescription => '在分析過程中以粗圓圈和箭頭突顯陷阱著法。';

  @override
  String trapExists(String trapMoves) {
    return '存在陷阱。陷阱著法：$trapMoves';
  }

  @override
  String get custodianCapture => '槓';

  @override
  String get custodianCaptureDescription => '沿著同一條線，用己方兩枚棋子夾住對方棋子即可吃掉對方該枚棋子。';

  @override
  String get custodianCaptureEnable => '啟用槓吃';

  @override
  String get interventionCapture => '擔';

  @override
  String get interventionCaptureDescription => '移動至對方兩枚棋子之間的空點，可同時吃掉這兩枚棋子。';

  @override
  String get interventionCaptureEnable => '啟用擔吃';

  @override
  String get leapCapture => '跳吃';

  @override
  String get leapCaptureDescription => '跳過相鄰的對方棋子並落於其後空點，即可吃掉該棋子。';

  @override
  String get leapCaptureEnable => '啟用跳吃';

  @override
  String get captureApplicableLines => '適用線段';

  @override
  String get captureSquareEdges => '正方形邊線上';

  @override
  String get captureCrossLines => '穿過正方形邊界的水平與垂直線';

  @override
  String get captureDiagonalLines => '穿過正方形邊界的斜向線';

  @override
  String get captureExecutionPhases => '執行階段';

  @override
  String get capturePiecesCondition => '行棋階段按剩餘棋子數決定適用性';

  @override
  String get capturePiecesConditionUnlimited => '無限制';

  @override
  String get capturePiecesConditionSelfLeqThree => '己方剩餘棋子≤3枚時可用';
}
