// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Vietnamese (`vi`).
class SVi extends S {
  SVi([String locale = 'vi']) : super(locale);

  @override
  String get appName => 'Cối xay';

  @override
  String get welcome => 'Chào mừng';

  @override
  String get yes => 'Có';

  @override
  String get no => 'Không';

  @override
  String get game => 'Trò chơi';

  @override
  String get humanVsAi => 'Người vs AI';

  @override
  String get humanVsHuman => 'Người vs Người';

  @override
  String get aiVsAi => 'AI vs AI';

  @override
  String get humanVsCloud => 'Con người vs. Đám mây';

  @override
  String get humanVsLAN => 'Con người vs. mạng LAN';

  @override
  String get testViaLAN => 'Kiểm tra qua mạng LAN';

  @override
  String get move => 'Di chuyển';

  @override
  String get showMoveList => 'Di chuyển danh sách';

  @override
  String get moveList => 'Di chuyển danh sách';

  @override
  String get noGameRecord => 'Không có hồ sơ';

  @override
  String get ok => 'Ok';

  @override
  String get confirm => 'Xác nhận';

  @override
  String get cancel => 'Hủy bỏ';

  @override
  String get tipSelectWrong => 'Bạn đã chọn sai quân cờ.';

  @override
  String get tipPlace => 'Hãy đặt quân cờ của bạn.';

  @override
  String get tipBanPlace => 'Bạn không thể đặt quân cờ ở đây.';

  @override
  String get tipPlaced => 'Đã đặt quân cờ.';

  @override
  String get tipRemove => 'Loại bỏ một quân cờ.';

  @override
  String get tipBanRemove => 'Bạn không thể loại bỏ quân cờ này.';

  @override
  String get tipRemoved => 'Đã loại bỏ quân cờ.';

  @override
  String get tipMove => 'Di chuyển một quân cờ.';

  @override
  String get tipCannotPlace => 'Bạn không thể đặt mảnh của bạn ở đây.';

  @override
  String get tipCannotMove => 'Bạn không thể di chuyển quân cờ của mình ở đây.';

  @override
  String get tipMill => 'Cối xay! Loại bỏ một quân cờ của đối thủ.';

  @override
  String get tipContinueMill => 'Tiếp tục loại bỏ quân cờ của đối thủ.';

  @override
  String get tipSelectOpponentsPiece => 'Chọn một quân cờ của đối thủ.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Bạn không thể loại bỏ quân cờ từ cối xay.';

  @override
  String get tipCanMoveOnePoint => 'Một mảnh có thể di chuyển 1 điểm.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Bạn không thể di chuyển quân cờ của đối thủ.';

  @override
  String get tipSelectPieceToMove => 'Chọn quân cờ của bạn để di chuyển.';

  @override
  String get tipHaveThreePiecesLeft => 'Bạn còn ba quân cờ.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Bạn có thể di chuyển đến bất kỳ điểm nào bạn thích.';

  @override
  String tipToMove(Object player) {
    return '$player để di chuyển.';
  }

  @override
  String get whiteWin => 'Người chơi 1 thắng!';

  @override
  String get blackWin => 'Người chơi 2 thắng!';

  @override
  String get won => 'Thắng';

  @override
  String get lost => 'Thua';

  @override
  String get thinking => 'Suy nghĩ…';

  @override
  String get newGame => 'Trò chơi mới';

  @override
  String get importGame => 'Nhập trò chơi';

  @override
  String get exportGame => 'Xuất trò chơi';

  @override
  String get gameImported => 'Trò chơi được nhập khẩu.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Không thể nhập $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Di chuyển và các quy tắc không phù hợp.';

  @override
  String get pleaseWait => 'Vui lòng chờ.';

  @override
  String get restartGame => 'Khởi động lại trò chơi hiện tại?';

  @override
  String get restart => 'Khởi động lại';

  @override
  String get gameStarted => 'Trò chơi bắt đầu, xin vui lòng đặt.';

  @override
  String get analyzing => 'Đang phân tích…';

  @override
  String error(Object message) {
    return 'Lỗi: $message';
  }

  @override
  String get winRate => 'Tỉ lệ chiến thắng';

  @override
  String get score => 'Điểm:';

  @override
  String get white => 'Người chơi 1';

  @override
  String get black => 'Người chơi 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player số mảnh ít hơn ba.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player từ chức.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player không còn cách nào để đi.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Bảng đã đầy và $player không còn cách nào để tiếp tục.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Thời gian đã hết, $player đã mất.';
  }

  @override
  String get drawReasonRule50 =>
      'Trong giai đoạn di chuyển, không có quân cờ nào bị loại bỏ trong số lần di chuyển cụ thể cuối cùng.';

  @override
  String get drawReasonBoardIsFull => 'Đó là một trận Hòa vì bàn cờ đã đầy.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Đó là một trận hòa vì lặp lại ba lần.';

  @override
  String get gameOverUnknownReason => 'Trò chơi kết thúc! Lý do không rõ.';

  @override
  String get gameOver => 'trò chơi kết thúc';

  @override
  String get youWin => 'Bạn thắng! Chúc mừng!';

  @override
  String challengeHarderLevel(int level) {
    return 'Thử thách cấp độ khó hơn? Cấp độ mới sẽ là cấp độ $level!';
  }

  @override
  String get youLose => 'Bạn đã thua!';

  @override
  String get analyze => 'phân tích';

  @override
  String get about => 'Về';

  @override
  String version(Object versionNumber) {
    return 'Phiên bản: $versionNumber';
  }

  @override
  String get thanks => 'Cảm ơn';

  @override
  String get settings => 'Cài đặt';

  @override
  String get options => 'Tùy chọn';

  @override
  String get generalSettings => 'Cài đặt chung';

  @override
  String get skillLevel => 'Cấp độ khó';

  @override
  String get moveTime => 'thời gian suy nghĩ của AI';

  @override
  String get difficulty => 'Khó khăn';

  @override
  String get playSounds => 'Hiệu ứng âm thanh';

  @override
  String get playSoundsInTheGame => 'Phát âm thanh trong trò chơi';

  @override
  String get keepMuteWhenTakingBack => 'Giữ im lặng khi lấy lại';

  @override
  String get tone => 'Tấn';

  @override
  String get whoMovesFirst => 'Bước đi đầu tiên';

  @override
  String get human => 'Nhân loại';

  @override
  String get ai => 'trí tuệ nhân tạo';

  @override
  String get alternate => 'Luân phiên';

  @override
  String get isAutoRestart => 'Tự khởi động lại trò chơi khi trò chơi kết thúc';

  @override
  String get isAutoChangeFirstMove => 'Tự động thay đổi nước đi đầu tiên';

  @override
  String get shufflingEnabled => 'Di chuyển ngẫu nhiên';

  @override
  String get misc => 'Điều khoản khác';

  @override
  String get rules => 'Quy tắc';

  @override
  String get piecesCount => 'Số quân cờ mỗi người chơi có';

  @override
  String get piecesCount_Detail => 'Mỗi người chơi có bao nhiêu quân cờ?';

  @override
  String get flyPieceCount => 'Số mảnh bay';

  @override
  String get flyPieceCount_Detail =>
      'Nếu Bay được bật, khi một người chơi bị giảm số lượng quân cờ cụ thể, quân cờ của cô ấy có thể tự do di chuyển đến bất kỳ điểm trống nào thay vì bị giới hạn ở các điểm liền kề như trong phần còn lại của trò chơi.';

  @override
  String get piecesAtLeastCount => 'miếng ít nhất';

  @override
  String get hasDiagonalLines => 'đường chéo';

  @override
  String get hasDiagonalLines_Detail => 'Thêm bốn đường chéo vào bảng.';

  @override
  String get isDefenderMoveFirst => 'Người chơi thứ hai di chuyển đầu tiên';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Người chơi đi thứ hai trong giai đoạn đặt sẽ đi trước trong giai đoạn di chuyển.';

  @override
  String get mayRemoveMultiple => 'loại bỏ nhiều lần';

  @override
  String get mayRemoveMultiple_Detail =>
      'Nếu một người chơi đóng nhiều nhà máy cùng một lúc, cô ấy sẽ xóa số nhà máy mà mình đã đóng.';

  @override
  String get mayRemoveFromMillsAlways => 'Phá hủy các nhà máy';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Theo mặc định, người chơi phải loại bỏ bất kỳ mảnh nào khác trước khi loại bỏ một mảnh khỏi cối xay đã hình thành. Bật tùy chọn này để tắt giới hạn.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Người chơi thứ hai thua khi bàn đầy';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Khi bàn cờ đầy vào cuối giai đoạn đặt, bên nào đặt trước sẽ thua trò chơi. Nếu không, trò chơi là một trận hòa.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Thua khi không có nước đi hợp pháp';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Người chơi sẽ thua nếu đối thủ của anh ta chặn chúng để chúng không thể di chuyển được. Đổi bên để di chuyển nếu tùy chọn này bị tắt.';

  @override
  String get mayFly => 'bay';

  @override
  String get mayFly_Detail =>
      'Nếu một người chơi chỉ còn lại ba hoặc bốn quân cờ (có thể định cấu hình), cô ấy có thể di chuyển quân cờ đó đến bất kỳ điểm trống nào.';

  @override
  String get nMoveRule => 'Quy tắc di chuyển N';

  @override
  String get nMoveRule_Detail =>
      'Trò chơi được hòa nếu không có sự loại bỏ nào trong một số nước đi cụ thể.';

  @override
  String get rollback => 'phục hồi';

  @override
  String get pleaseSelect => 'Vui lòng chọn';

  @override
  String get copy => 'Sao chép';

  @override
  String get moveHistoryCopied =>
      'Đã sao chép lịch sử di chuyển vào khay nhớ tạm.';

  @override
  String get help => 'Giúp đỡ';

  @override
  String get feedback => 'Nhận xét';

  @override
  String get exit => 'Thoát';

  @override
  String get ruleSettings => 'Cài đặt quy tắc';

  @override
  String get color => 'Màu sắc';

  @override
  String get boardColor => 'Màu bàn cờ';

  @override
  String get pieceColor => 'Màu quân cờ';

  @override
  String get backgroundColor => 'Màu nền';

  @override
  String get lineColor => 'Màu đường kẻ bảng';

  @override
  String get whitePieceColor => 'Người chơi 1 mảnh màu';

  @override
  String get blackPieceColor => 'Người chơi 2 mảnh màu';

  @override
  String get messageColor => 'màu tin nhắn';

  @override
  String get isPieceCountInHandShown => 'Hiển thị số lượng mảnh chưa được đặt';

  @override
  String get isNotationsShown => 'Hiển thị các ký hiệu trên tàu';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Hiển thị thanh công cụ điều hướng lịch sử';

  @override
  String get display => 'Trưng bày';

  @override
  String get boardBorderLineWidth => 'Chiều rộng đường viền bảng';

  @override
  String get boardInnerLineWidth => 'Chiều rộng đường bên trong bảng';

  @override
  String get pieceWidth => 'chiều rộng mảnh';

  @override
  String get fontSize => 'Cỡ chữ';

  @override
  String get standardNotation => 'ký hiệu WMD';

  @override
  String get restore => 'Khôi phục';

  @override
  String get restoreDefaultSettings => 'Khôi phục lại các thiết lập mặc định';

  @override
  String pick(Object element) {
    return 'Chọn $element';
  }

  @override
  String get info => 'Thông tin';

  @override
  String get hint => 'Gợi ý';

  @override
  String get player => 'người chơi';

  @override
  String get player1 => 'Người chơi 1';

  @override
  String get player2 => 'Người chơi 2';

  @override
  String get howToPlay => 'Cách chơi';

  @override
  String get toPlacePiece => 'Chạm vào bất kỳ điểm trống nào để đặt quân cờ.';

  @override
  String get toSelectPiece => 'Chạm vào một mảnh để di chuyển nó.';

  @override
  String get toMovePiece =>
      'Chạm vào một điểm được kết nối với một mảnh để di chuyển nó.';

  @override
  String get toRemovePiece => 'Chạm vào một mảnh của đối thủ để loại bỏ.';

  @override
  String get needToCreateMillFirst =>
      'Trước tiên, bạn cần tạo một cối xay trước khi có thể loại bỏ một mảnh.';

  @override
  String get needToPlayWithOwnPieces =>
      'Bạn cần chơi với các quân cờ của mình.';

  @override
  String get statistics => 'Số liệu thống kê';

  @override
  String get totalGames => 'Tổng số trò chơi';

  @override
  String get results => 'Kết quả';

  @override
  String get left => 'bên trái';

  @override
  String get privacyPolicy => 'Chính sách bảo mật';

  @override
  String get privacyPolicy_Detail_1 =>
      'Vui lòng đọc kỹ và đảm bảo rằng bạn hoàn toàn hiểu và đồng ý với điều này ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Nếu bạn không đồng ý với Chính sách này, vui lòng không sử dụng ứng dụng này. Việc sử dụng ứng dụng ngụ ý rằng bạn chấp nhận các điều khoản này.';

  @override
  String get and => ' Và ';

  @override
  String get accept => 'Chấp nhận';

  @override
  String get takeBack => 'Lấy lại';

  @override
  String get takingBack => 'Lấy lại…';

  @override
  String get waiting => 'Chờ…';

  @override
  String get stepForward => 'bước về phía trước';

  @override
  String get takeBackAll => 'Lấy lại tất cả';

  @override
  String get stepForwardAll => 'Tiến lên tất cả';

  @override
  String get moveNow => 'Di chuyển ngay bây giờ';

  @override
  String get done => 'Xong.';

  @override
  String get crackMill => 'crack-xay';

  @override
  String get crackMill_Detail =>
      'Nếu người chơi chỉ có quân cờ trong cối xay, quân cờ trong cối xay sẽ không khóa để lấy ra.';

  @override
  String get animationDuration => 'Thời lượng hoạt ảnh';

  @override
  String get none => 'Không có';

  @override
  String get theme => 'chủ đề';

  @override
  String get helpContent =>
      'Trò chơi nhằm mục đích khiến đối thủ có ít hơn ba quân cờ hoặc không có nước đi hợp pháp.\n\nTrò chơi sẽ tự động rút nếu một vị trí xuất hiện lần thứ ba hoặc không bị loại bỏ trong 100 nước đi (có thể định cấu hình) cuối cùng.\n\nTrò chơi tiến hành theo ba giai đoạn:\n\n1. Đặt quân cờ vào điểm trống\n2. Di chuyển các quân cờ đến các điểm liền kề\n3. (giai đoạn tùy chọn) Di chuyển các quân cờ đến bất kỳ điểm trống nào khi giảm người chơi xuống còn ba quân cờ\n\nđặt\n\nTrò chơi bắt đầu với một bàn trống, bao gồm một lưới có hai mươi bốn điểm. Người chơi thay phiên nhau đặt các quân cờ của mình vào các điểm trống cho đến khi mỗi người chơi đặt xong tất cả các quân cờ trên bàn cờ. Nếu một người chơi có thể đặt thẳng ba quân cờ của mình, anh ta có một \"cối xay\" và có thể loại bỏ một trong các quân cờ của đối thủ khỏi bàn cờ.\n\nTrong một số quy tắc, người chơi phải loại bỏ bất kỳ quân cờ nào khác trước khi loại bỏ một quân cờ khỏi cối xay đã hình thành.\n\nBạn không thể đặt lại các quân cờ vào điểm của các quân cờ đã bị loại bỏ trong giai đoạn đặt theo một số quy tắc.\n\nSau khi sử dụng hết quân cờ, người chơi thay phiên nhau di chuyển.\n\nDi chuyển\n\nĐể di chuyển, người chơi di chuyển một trong các quân cờ của mình dọc theo một đường bàn cờ đến một điểm trống liền kề. Nếu anh ta không thể làm như vậy, anh ta đã thua trò chơi. Một người chơi sắp xếp ba quân của mình trên một đường bàn cờ có một cối xay và có thể loại bỏ một trong các quân của đối thủ của mình như trong giai đoạn đặt. Bất kỳ người chơi nào bị giảm xuống còn hai quân cờ, không có tùy chọn để tạo thành các nhà máy mới và do đó sẽ thua trò chơi. Một người chơi cũng có thể thua khi có nhiều hơn ba quân cờ nếu đối thủ của anh ta chặn họ di chuyển.\n\nbay\n\nTrong một số biến thể của quy tắc, một khi người chơi chỉ còn ba quân, quân của anh ta có thể bay, nhảy hoặc nhảy đến bất kỳ điểm trống nào, không chỉ các điểm liền kề.\n';

  @override
  String get versionInfo => 'Thông tin phiên bản';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Giấy phép';

  @override
  String get sourceCode => 'Mã nguồn';

  @override
  String get appVersion => 'Phiên bản ứng dụng';

  @override
  String get general => 'Tổng quan';

  @override
  String get advanced => 'Trình độ cao';

  @override
  String get placing => 'đặt';

  @override
  String get moving => 'Di chuyển';

  @override
  String get removing => 'Loại bỏ';

  @override
  String get gameOverCondition => 'Trò chơi kết thúc điều kiện';

  @override
  String get aisPlayStyle => 'lối chơi của AI';

  @override
  String get passive => 'Thụ động';

  @override
  String get timeout => 'Hết giờ';

  @override
  String get appearance => 'Vẻ bề ngoài';

  @override
  String get drawOnHumanExperience => 'Rút ra kinh nghiệm của con người';

  @override
  String get considerMobility => 'Xem xét tính di động của các quân cờ';

  @override
  String get pieceCount => 'Số mảnh:';

  @override
  String inHand(Object player, int count) {
    return '$player trong tay: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player trên tàu: $count';
  }

  @override
  String get boardTop => 'Bảng bù đắp từ trên xuống';

  @override
  String get notAIsTurn => 'Đó không phải là lượt của AI.';

  @override
  String get aiIsNotThinking => 'AI không suy nghĩ.';

  @override
  String get atEnd => 'Bạn đang ở cuối danh sách di chuyển.';

  @override
  String get tapBackAgainToLeave => 'Nhấn lại một lần nữa để rời đi.';

  @override
  String get more => 'Hơn';

  @override
  String get experimental => 'Nó là một tính năng thử nghiệm.';

  @override
  String get experiments => 'thí nghiệm';

  @override
  String get ossLicenses => 'Giấy phép nguồn mở';

  @override
  String get language => 'Ngôn ngữ';

  @override
  String get defaultLanguage => 'Ngôn ngữ mặc định';

  @override
  String get mayMoveInPlacingPhase =>
      'Các quân cờ có thể di chuyển trong giai đoạn đặt';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Không có các giai đoạn đặt và di chuyển riêng biệt, tức là, người chơi có thể quyết định ở mọi nước đi xem họ muốn đặt một quân cờ trên bàn cờ hay di chuyển một trong các quân cờ của họ (miễn là họ còn quân cờ để đặt).';

  @override
  String get drawerColor => 'màu thực đơn';

  @override
  String get drawerTextColor => 'Màu văn bản menu';

  @override
  String get drawerHighlightItemColor => 'Menu làm nổi bật màu mục';

  @override
  String get mainToolbarBackgroundColor => 'Màu nền thanh công cụ chính';

  @override
  String get mainToolbarIconColor => 'Màu biểu tượng thanh công cụ chính';

  @override
  String get navigationToolbarBackgroundColor =>
      'Màu nền của thanh công cụ điều hướng';

  @override
  String get navigationToolbarIconColor =>
      'Màu biểu tượng thanh công cụ điều hướng';

  @override
  String get autoHideToolbar => 'Tự động ẩn thanh công cụ';

  @override
  String get toolbarLocationOnScreen => 'Vị trí thanh công cụ trên màn hình';

  @override
  String get top => 'Phía trên';

  @override
  String get bottom => 'Phía dưới';

  @override
  String get center => 'Trung tâm';

  @override
  String get solidColor => 'màu đặc';

  @override
  String get picture => 'Hình ảnh';

  @override
  String get chooseYourPicture => 'Chọn ảnh của bạn';

  @override
  String get light => 'Sáng';

  @override
  String get dark => 'Tối';

  @override
  String get themes => 'chủ đề';

  @override
  String get currentTheme => 'Chủ đề hiện tại';

  @override
  String get saveTheme => 'Lưu chủ đề';

  @override
  String get showAnalysisGraph => 'Hiển thị biểu đồ phân tích';

  @override
  String get analysis => 'Phân tích';

  @override
  String get saveGame => 'Lưu trò chơi';

  @override
  String get loadGame => 'Tải trò chơi';

  @override
  String get setupPosition => 'Vị trí thiết lập';

  @override
  String get showLegalMoves => 'Thể hiện các động thái hợp pháp';

  @override
  String get showLastMove => 'Hiển thị di chuyển cuối cùng';

  @override
  String get showArrows => 'Hiển thị mũi tên';

  @override
  String get pieces => 'Miếng';

  @override
  String get showAnalysis => 'Hiển thị phân tích';

  @override
  String get threads => 'chủ đề';

  @override
  String get getInvolved => 'Tham gia';

  @override
  String get helpImproveTranslate => 'Giúp cải thiện bản dịch';

  @override
  String get tutorial => 'hướng dẫn';

  @override
  String get classicMill => 'Nhà máy cổ điển';

  @override
  String get mixedMill => 'nhà máy hỗn hợp';

  @override
  String get ceylonMill => 'Nhà máy Ceylon';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Cối xay có thể bị hỏng và làm lại nhiều lần';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Nếu một người chơi phá vỡ một cối xay để tạo một cối xay mới ngay lập tức, thì người chơi đó có thể di chuyển quân cờ đó trở lại đường giao nhau ban đầu trong nước đi tiếp theo của mình nếu nó tạo ra một cối xay mới.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Ván cờ hòa nếu một đấu thủ có ba quân và sau mười nước đi không đấu thủ nào lấy được quân của đối phương';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Khi một người chơi còn ba quân và không người chơi nào có thể lấy quân của đối phương trong vòng mười nước đi, trò chơi sẽ hòa.';

  @override
  String get close => 'Đóng';

  @override
  String get whitePiece => 'mảnh trắng';

  @override
  String get blackPiece => 'mảnh màu đen';

  @override
  String get emptyPoint => 'điểm trống';

  @override
  String get noPoint => 'Không có điểm';

  @override
  String get placingPhase => 'giai đoạn đặt';

  @override
  String get movingPhase => 'giai đoạn di chuyển';

  @override
  String get flyingPhase => 'giai đoạn bay';

  @override
  String sideToMove(Object player) {
    return 'Bên để di chuyển: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Chiêu cuối: $move';
  }

  @override
  String get selected => 'Đã chọn';

  @override
  String get accessibility => 'khả năng tiếp cận';

  @override
  String get screenReaderSupport => 'Hỗ trợ trình đọc màn hình';

  @override
  String get isDraw => 'Đó là một trận hòa!';

  @override
  String get draw => 'Vẽ tranh';

  @override
  String get pieceHighlightColor => 'Màu nổi bật của mảnh';

  @override
  String get algorithm => 'thuật toán';

  @override
  String get endgameNMoveRule => 'Quy tắc N-Move của Endgame';

  @override
  String get endgameNMoveRule_Detail =>
      'Trò chơi được hòa nếu một trong hai người chơi chỉ có ba quân và không người chơi nào bỏ quân trong các nước đi cụ thể.';

  @override
  String get drawReasonEndgameRule50 =>
      'Một trong hai người chơi chỉ có ba quân cờ và không người chơi nào loại bỏ quân cờ trong các nước đi cụ thể.';

  @override
  String get threefoldRepetitionRule => 'Quy tắc lặp lại ba lần';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Trò chơi được hòa nếu một vị trí xuất hiện lần thứ ba.';

  @override
  String get continueToMakeMove => 'Cối xay! Tiếp tục di chuyển.';

  @override
  String get pointStyle => 'phong cách điểm';

  @override
  String get pointWidth => 'chiều rộng điểm';

  @override
  String get solid => 'Chất rắn';

  @override
  String get hollow => 'Rỗng';

  @override
  String get languageName => 'Tiếng Việt';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Di chuyển',
      one: '$count Di chuyển',
      zero: 'Di chuyển',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Tải không thành công.';

  @override
  String get filename => 'tên tệp';

  @override
  String get browse => 'Duyệt…';

  @override
  String get gameFiles => 'tập tin trò chơi';

  @override
  String get gameSavedTo => 'Trò chơi được lưu vào';

  @override
  String get empty => 'Trống';

  @override
  String get noMove => 'Không di chuyển.';

  @override
  String get restoredPosition => 'Đã khôi phục vị trí ban đầu.';

  @override
  String get clean => 'Lau dọn';

  @override
  String get cleanedUp => 'Làm sạch.';

  @override
  String get remove => 'Di dời';

  @override
  String get noPiecesCanBeRemoved => 'Không có mảnh nào có thể được gỡ bỏ.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count mảnh',
      one: '$count mảnh',
      zero: 'Piece',
    );
    return '$_temp0 cần xóa.';
  }

  @override
  String placedCount(int count) {
    return 'Đã đặt ($count)';
  }

  @override
  String get placedPieceCount => 'Số mảnh được đặt trong giai đoạn đặt.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Người chơi hiện tại đã đặt quân cờ $count.';
  }

  @override
  String get notPlacingPhase => 'Không đặt pha, không thể thay đổi nó.';

  @override
  String get paste => 'Dán';

  @override
  String get pasteDone => 'Việc dán được thực hiện.';

  @override
  String get cannotPaste => 'Không thể dán.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Hiển thị các phần chưa được đặt và đã xóa';

  @override
  String get fullScreen => 'Toàn màn hình';

  @override
  String get reopenToTakeEffect =>
      'Thoát và mở lại ứng dụng để cài đặt có hiệu lực.';

  @override
  String get forest => 'Rừng';

  @override
  String get desktopImage => 'Hình ảnh máy tính để bàn';

  @override
  String get invalidPosition => 'Vị trí không hợp lệ.';

  @override
  String get shareGIF => 'Chia sẻ ảnh GIF';

  @override
  String get pixelRatio => 'Tỷ lệ pixel';

  @override
  String get duration => 'Khoảng thời gian';

  @override
  String get gameScreenRecorder => 'Trình ghi màn hình trò chơi';

  @override
  String get previous => 'Trước';

  @override
  String get next => 'Kế tiếp';

  @override
  String get skip => 'Nhảy';

  @override
  String get gotIt => 'Hiểu rồi';

  @override
  String get youCanModifyRules =>
      'Bạn có thể sửa đổi các quy tắc của trò chơi trong cài đặt quy tắc.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Bạn có thể sử dụng con lăn chuột để thay đổi giá trị trong bộ chọn.';

  @override
  String get noTimeLimitForThinking =>
      'Thời gian suy nghĩ AI được đặt thành 0 có nghĩa là không có giới hạn thời gian suy nghĩ.';

  @override
  String get whatIsMtdf =>
      'MTD(f) là một dạng đã sửa đổi của thuật toán tìm kiếm alpha-beta nhằm nâng cao hiệu quả bằng cách sử dụng lại các kết quả tìm kiếm trung gian và sử dụng dự đoán ban đầu tốt để thu hẹp không gian tìm kiếm.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Xin lưu ý rằng việc điều chỉnh thời gian suy nghĩ của AI có thể không hoàn toàn chính xác. Thời gian suy nghĩ thực tế có thể ngắn hơn khi mức độ khó được đặt ở giá trị thấp hơn và có thể dài hơn khi AI đang suy nghĩ giữa chừng khi hết thời gian.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Nếu bạn đặt độ khó cao nhưng không tăng thời gian suy nghĩ của AI, thì độ khó thực tế có thể bị giới hạn ở giá trị thấp hơn do hạn chế về thời gian suy nghĩ. Giá trị thực tế có thể thay đổi dựa trên hiệu suất của máy.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) là một thuật toán tìm kiếm để tìm ra nước đi tốt nhất ở một vị trí nhất định. Nó là một cải tiến của thuật toán alpha-beta và sử dụng các tìm kiếm cửa sổ null hoặc zero để xác nhận rằng một nước đi tệ hơn hoặc không tệ hơn một điểm đã an toàn từ biến thể chính. PVS tập trung vào các động thái hứa hẹn nhất và tránh các tìm kiếm không cần thiết của các nhánh dưới mức tối ưu, giúp cải thiện hiệu quả của việc tìm kiếm.';

  @override
  String get whatIsAlphaBeta =>
      'Thuật toán alpha-beta là thuật toán tìm kiếm để tìm nước đi tốt nhất. Nó sử dụng nguyên tắc minimax và hai giá trị, alpha và beta, để cắt bớt cây tìm kiếm và tăng hiệu quả. Alpha đại diện cho số điểm tối thiểu mà máy tính chắc chắn có thể đạt được, trong khi beta đại diện cho số điểm tối đa mà đối thủ của nó có thể đạt được. Thuật toán giúp máy tính đưa ra quyết định thông minh, hiệu quả trong trò chơi.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Theo kinh nghiệm của loài người, nếu bạn cố gắng giành chiến thắng, bạn sẽ thua. Thay vào đó, hãy nhắm đến một trận hòa làm mục tiêu của bạn và tránh thua trò chơi. Quan sát đối thủ của bạn và nhẹ nhàng dụ họ vào vị trí mà họ có thể phạm sai lầm. Khi họ tỏ ra yếu kém, hãy nắm bắt cơ hội và nhẹ nhàng thúc đẩy để giành chiến thắng. Bằng cách này, bạn có thể giành chiến thắng trong trò chơi.';

  @override
  String get firstMoveDetail =>
      'Trong trò chơi này, người chơi thứ hai sẽ dễ thắng hơn người chơi thứ nhất.';

  @override
  String get passiveDetail =>
      'Kích hoạt tùy chọn Bị động sẽ khiến AI thư giãn khi có lợi thế ở vị trí đó, thay vì tích cực cố gắng giành chiến thắng càng nhanh càng tốt.';

  @override
  String get moveRandomlyDetail =>
      'Kích hoạt tùy chọn này làm tăng tính ngẫu nhiên và thú vị của trò chơi trong khi tắt tùy chọn này có thể giúp nghiên cứu các cách đánh bại AI.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Nếu AI xem xét tính cơ động của các quân cờ của mình, nó sẽ không chỉ nhằm mục đích bắt quân của đối thủ càng nhanh càng tốt mà còn xem xét việc chặn các chuyển động của đối thủ và ngăn họ làm điều tương tự.';

  @override
  String get whenBoardIsFull => 'Khi bảng đầy';

  @override
  String get whenBoardIsFull_Detail =>
      'Khi kết thúc giai đoạn đặt, trước khi giai đoạn di chuyển bắt đầu, hành động sẽ tiếp theo nếu bàn cờ đầy quân cờ.';

  @override
  String get sideToMoveRemovePiece =>
      'Người chơi đi trước trong giai đoạn di chuyển sẽ loại bỏ một trong các quân của đối phương.';

  @override
  String get agreeToDraw => 'Cả hai bên đồng ý hòa.';

  @override
  String get takeOpponentsPiece =>
      'Lấy một trong những mảnh của đối thủ của bạn.';

  @override
  String get firstPlayerLose => 'Người chơi đầu tiên thua trò chơi.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Người chơi thứ nhất và thứ hai loại bỏ một trong các quân cờ của đối phương.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Người chơi thứ hai và thứ nhất loại bỏ một trong các quân cờ của đối phương.';

  @override
  String get enteredFlyingPhase =>
      'Bây giờ đã bước vào giai đoạn bay, các quân cờ của đối phương có thể nhảy đến bất kỳ điểm trống nào trên bàn cờ. Bạn có thể tắt quy tắc bay trong \"Cài đặt quy tắc\".';

  @override
  String get whenStalemate => 'Khi bế tắc';

  @override
  String get whenStalemate_Detail =>
      'Hành động nào tiếp theo khi không thể di chuyển quân nào?';

  @override
  String get endWithStalemateLoss =>
      'Kết thúc với một trận thua bế tắc cho bên bị chặn.';

  @override
  String get changeSideToMove => 'Thay đổi bên để di chuyển.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Loại bỏ một trong các quân cờ của đối thủ và thực hiện nước đi tiếp theo.';

  @override
  String get endWithStalemateDraw => 'Kết thúc với một trận hòa bế tắc.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Loại bỏ một trong các quân cờ của đối thủ và đổi bên để di chuyển.';

  @override
  String get aiResponseDelayTime => 'Thời gian trễ phản hồi AI';

  @override
  String get aiIsDelaying =>
      'AI hiện đang trong giai đoạn phản hồi chậm. Vui lòng đợi một lúc trước khi tiếp tục.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Bạn không thể loại bỏ một phần không liền kề.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Nếu bế tắc, các quân của đối thủ liền kề với quân của bạn có thể bị loại bỏ, bất kể đội hình của nhà máy.';

  @override
  String get whatIsMcts =>
      'MCTS là một thuật toán thân thiện với người mới bắt đầu đưa ra quyết định bằng cách khám phá và đánh giá các nước đi khác nhau thông qua mô phỏng.';

  @override
  String get goldenJade => 'Ngọc vàng';

  @override
  String get forestWood => 'Gỗ rừng';

  @override
  String get darkMystery => 'bí ẩn đen tối';

  @override
  String get midnightBlue => 'Màu xanh nửa đêm';

  @override
  String get greenForest => 'rừng xanh';

  @override
  String get greenMeadow => 'Đồng cỏ xanh';

  @override
  String get stonyPath => 'con đường đá';

  @override
  String get pastelPink => 'Màu hồng nhạt';

  @override
  String get turquoiseSea => 'biển xanh ngọc';

  @override
  String get violetDream => 'Giấc mơ màu tím';

  @override
  String get mintChocolate => 'Sôcôla bạc hà';

  @override
  String get skyBlue => 'Trời xanh';

  @override
  String get playfulGarden => 'Khu vườn vui tươi';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Thuật toán Phân tích ngược dòng sử dụng phân tích ngược dòng đa giá trị để xây dựng cơ sở dữ liệu kết thúc trò chơi từ các vị trí bắt đầu khác nhau, sau đó áp dụng cơ sở dữ liệu này để tối ưu hóa lối chơi. Cách tiếp cận này thuộc danh mục Giải pháp siêu mạnh.';

  @override
  String get viewAlgorithmGuide =>
      'Bạn có muốn xem hướng dẫn sử dụng thuật toán này không?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Hiển thị chỉ báo lợi thế vị trí';

  @override
  String get usePerfectDatabase => 'Sử dụng cơ sở dữ liệu hoàn hảo';

  @override
  String get perfectDatabaseDescription =>
      'Kích hoạt tùy chọn này để sử dụng cơ sở dữ liệu trò chơi không có khuyết điểm, được tạo ra thông qua các thuật toán tiên tiến. Tính năng này kết hợp cả chiến lược mở đầu và kết thúc trò chơi để đề xuất các bước đi tối ưu. Đây là lựa chọn ưa thích cho những người chơi muốn đạt độ chính xác cao nhất trong trò chơi. Được tạo ra thông qua các kỹ thuật tính toán tỉ mỉ, cơ sở dữ liệu được thiết kế để cung cấp các giải pháp trò chơi gần như hoàn hảo.\n\nLưu ý: Nếu AI không thể truy cập cơ sở dữ liệu, nó sẽ chuyển sang các thuật toán truyền thống để ra quyết định trong trò chơi. Khi cơ sở dữ liệu có sẵn, \"Mức độ khó\" trở nên hầu như không thể đánh bại, và \"Thời gian suy nghĩ của AI\" sẽ giảm mạnh. Nhiều cài đặt trong tùy chọn \'Phong cách chơi của AI\' cũng sẽ bị ghi đè, vì kết quả từ cơ sở dữ liệu có ưu tiên cao nhất.\n\nĐể được hướng dẫn về cách tận dụng tối đa cơ sở dữ liệu hoàn hảo này, vui lòng nhấp vào đây.';

  @override
  String get backgroundImage => 'Hình nền';

  @override
  String get whatIsRandom =>
      'Khi tùy chọn \'Sử dụng cơ sở dữ liệu hoàn hảo\' không được kích hoạt, thiết lập \'Ngẫu nhiên\' khiến AI di chuyển các quân cờ một cách ngẫu nhiên mà không sử dụng bất kỳ thuật toán nào để lựa chọn nước đi. Điều này thường dẫn đến lối chơi yếu hơn đáng kể. Ngược lại, khi kích hoạt \'Sử dụng cơ sở dữ liệu hoàn hảo\', AI hoàn toàn dựa vào \'Cơ sở dữ liệu hoàn hảo\' để đưa ra quyết định, thay vì kết hợp nó với các thuật toán AI truyền thống. Trong chế độ này, các nước đi của AI hoàn toàn dựa vào nội dung của cơ sở dữ liệu, tránh phụ thuộc vào các phép tính thời gian thực hoặc thuật toán tìm kiếm.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Loại bỏ quân cờ của đối thủ khỏi tay họ; sau đó đến lượt đối thủ đặt quân.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Khi tạo cối xay gió trong giai đoạn đặt quân';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Loại bỏ quân cờ của đối thủ khỏi bàn cờ.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Loại bỏ quân cờ của đối thủ khỏi bàn cờ; sau đó đến lượt đối thủ đặt quân.';

  @override
  String get opponentRemovesOwnPiece =>
      'Đối thủ loại bỏ quân cờ của chính họ khỏi bàn cờ.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Thay vì bạn thực hiện hành động, đối thủ sẽ chọn và loại bỏ quân cờ của chính họ khỏi bàn cờ, thực hiện một hành động có hại cho chính họ.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Loại bỏ quân cờ của đối thủ khỏi tay họ; sau đó đến lượt bạn di chuyển.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Loại bỏ (các) quân cờ khỏi tay đối thủ. Nếu theo cài đặt loại bỏ nhiều quân, nhiều quân cờ sẽ bị loại bỏ và đối thủ không còn quân cờ trên tay, hãy tiếp tục loại bỏ các quân cờ của đối thủ khỏi bàn cờ. Sau đó, đến lượt bạn di chuyển. Nếu bạn tiếp tục tạo cối xay gió, bạn có thể tiếp tục loại bỏ các quân cờ của đối thủ.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Loại bỏ (các) quân cờ khỏi tay đối thủ. Nếu theo cài đặt loại bỏ nhiều quân, nhiều quân cờ sẽ bị loại bỏ và đối thủ không còn quân cờ trên tay, hãy tiếp tục loại bỏ các quân cờ của đối thủ khỏi bàn cờ. Sau đó, đến lượt đối thủ di chuyển.';

  @override
  String get markAndDelayRemovingPieces =>
      'Đánh dấu và trì hoãn việc loại bỏ các quân cờ.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Trong giai đoạn đặt quân, các quân cờ sẽ được loại bỏ sẽ được đánh dấu và cả hai người chơi không thể đặt các quân cờ mới vào các điểm này. Sau khi bước vào giai đoạn di chuyển, các quân cờ được đánh dấu này sẽ bị loại bỏ hoàn toàn và người chơi có thể di chuyển các quân cờ của họ đến các điểm hiện đang trống này.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Các hành động có thể thực hiện khi hình thành cối xay trong giai đoạn đặt cược.';

  @override
  String get marked => 'Đã đánh dấu';

  @override
  String get menu => 'Menu';

  @override
  String get monochrome => 'Đen và trắng';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Bạn có thể bật hỗ trợ đọc màn hình trong cài đặt Trợ năng trong Cài đặt chung.';

  @override
  String get showNumbersOnPieces => 'Hiển thị số trên các quân cờ';

  @override
  String get saveImage => 'Lưu hình ảnh';

  @override
  String get isAnalysisToolbarShown => 'Hiển thị thanh công cụ phân tích';

  @override
  String get analysisToolbarBackgroundColor =>
      'Màu nền của thanh công cụ phân tích';

  @override
  String get analysisToolbarIconColor =>
      'Màu biểu tượng của thanh công cụ phân tích';

  @override
  String get transformed => 'Đã biến đổi.';

  @override
  String get cannotTransform => 'Không thể biến đổi.';

  @override
  String get rotate => 'Xoay';

  @override
  String get horizontalFlip => 'H Lật';

  @override
  String get verticalFlip => 'V Lật';

  @override
  String get innerOuterFlip => 'IO Lật';

  @override
  String get transparentCanvas => 'Vải Trong Suốt';

  @override
  String get restrictRepeatedMillsFormation => 'Hạn Chế Tạo Lại Cối Xay';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Một quân cờ được di chuyển từ cối xay này sang cối xay khác không thể trở lại điểm ban đầu ngay lượt tiếp theo để hình thành một cối xay mới. Đầu tiên cần một nước đi khác.';

  @override
  String get oneTimeUseMill => 'Cối xay sử dụng một lần';

  @override
  String get oneTimeUseMill_Detail =>
      'Mỗi cối xay có thể loại bỏ một mảnh của đối thủ chỉ một lần. Bạn có thể tái tạo nó, nhưng không thể sử dụng để loại bỏ bổ sung.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Các quy tắc hiện tại bạn đã đặt không có cơ sở dữ liệu hoàn hảo tương ứng. Để biết thêm thông tin về cơ sở dữ liệu hoàn hảo, vui lòng nhấp vào đây.';

  @override
  String get focusOnBlockingPaths => 'Tập trung vào việc chặn đường';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Ưu tiên cản trở di chuyển của đối thủ thay vì tạo thành cối xay. Thay vì tập trung vào việc loại bỏ các quân cờ bằng cách hoàn thành cối xay, AI nhằm bẫy đối thủ, khiến họ không thể di chuyển và đảm bảo chiến thắng thông qua sự kiệt sức thay vì lối chơi hung hăng. Chiến lược này không chủ động chặn các cối xay của đối thủ.';

  @override
  String get pieceImage => 'Hình ảnh của quân cờ';

  @override
  String get importColorSettings => 'Nhập cài đặt màu';

  @override
  String get exportColorSettings => 'Xuất cài đặt màu';

  @override
  String get import => 'Nhập khẩu';

  @override
  String get export => 'Xuất khẩu';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Vui lòng sao chép các cài đặt định dạng JSON vào bảng tạm trước.';

  @override
  String get copiedToClipboard => 'Đã sao chép vào bảng tạm.';

  @override
  String get imported => 'Đã nhập.';

  @override
  String get boardImage => 'Hình ảnh bảng';

  @override
  String get autumnLeaves => 'Lá mùa thu';

  @override
  String get legendaryLand => 'Vùng Đất Huyền Thoại';

  @override
  String get vignetteEffect => 'Hiệu ứng tối góc';

  @override
  String get promptMakeToolbarTransparent =>
      'Bạn có muốn làm cho thanh công cụ hoàn toàn trong suốt khi hình nền bảng được thiết lập không?';

  @override
  String get vibration => 'Bật rung trong trò chơi';

  @override
  String get soundTheme => 'Chủ đề âm thanh';

  @override
  String get ball => 'Bóng';

  @override
  String get liquid => 'Chất lỏng';

  @override
  String get wood => 'Gỗ';

  @override
  String get placeEffectAnimation => 'Hiệu ứng hoạt hình đặt quân cờ';

  @override
  String get removeEffectAnimation => 'Hiệu ứng hoạt hình loại bỏ quân cờ';

  @override
  String get isToolbarAtBottom => 'Hiển thị thanh công cụ ở phía dưới';

  @override
  String get boardCornerRadius => 'Bán kính góc bảng';

  @override
  String get useOpeningBook => 'Sử dụng sách mở đầu';

  @override
  String get currentRule => 'Hiện tại';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Duz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Trực Kỳ';

  @override
  String get chengSanQi => 'Thành Tam Kỳ';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Bộ quy tắc';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'Cối xay một lần';

  @override
  String get daSanQi => 'Đả Tam Kỳ';

  @override
  String get useOpeningBook_Detail =>
      'Cho phép AI sử dụng các nước đi mở đầu thường được sử dụng bởi các cầu thủ chuyên nghiệp trong giai đoạn đầu của trò chơi. Lưu ý: Tính năng này hiện chỉ có sẵn cho các bộ quy tắc cụ thể.';

  @override
  String get showAdvantageGraph => 'Hiển thị biểu đồ lợi thế';

  @override
  String get advantageGraphHint =>
      'Biểu đồ lợi thế sẽ chỉ được vẽ sau khi AI thực hiện một nước đi. Nó sẽ không được vẽ khi người chơi là con người thực hiện nước đi.';

  @override
  String get removalBasedOnMillCounts =>
      'Vô hiệu hóa việc loại bỏ cho đến khi tất cả các quân cờ được đặt xuống. Người chơi loại bỏ quân cờ dựa trên số lượng cối xay họ hình thành.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Vô hiệu hóa việc loại bỏ cho đến khi tất cả các quân cờ được đặt xuống. Người chơi loại bỏ quân cờ dựa trên số lượng cối xay: nếu bằng nhau, cả hai đều loại bỏ cùng một số lượng quân; nếu một người có nhiều hơn, người đó loại bỏ thêm một quân, giữ chênh lệch ở mức một quân. Nếu chỉ một người tạo được cối xay, người đó loại bỏ hai quân và người còn lại loại bỏ một. Nếu không ai tạo được cối xay, cả hai đều loại bỏ một quân.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Chọn một trong các quân cờ của bạn.';

  @override
  String get notYourTurn => 'Đến lượt của đối thủ.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Màu nền của thanh công cụ chú thích';

  @override
  String get annotationToolbarIconColor =>
      'Màu biểu tượng của thanh công cụ chú thích';

  @override
  String get isAnnotationToolbarShown => 'Hiển thị thanh công cụ chú thích';

  @override
  String get enterAnnotationMode => 'Vào chế độ chú thích';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Bạn có chắc chắn muốn xóa tất cả chú thích không?';

  @override
  String get llmPromptCopiedToClipboard =>
      'Đã sao chép lời nhắc LLM vào bảng tạm.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Kết nối bị từ chối, máy chủ có thể đang ngừng hoạt động.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Khám phá thành công, đang chờ kết nối...';

  @override
  String get noLanConnection => 'Không có kết nối LAN';

  @override
  String get takeScreenshot => 'Chụp ảnh màn hình';

  @override
  String get disconnectedFromOpponent => 'Đã ngắt kết nối với đối thủ.';

  @override
  String get takeBackRequest => 'Yêu cầu hoàn tác';

  @override
  String get nothingToShow => 'Không có gì để hiển thị.';

  @override
  String get stopHosting => 'Dừng lưu trữ';

  @override
  String get connectionResetByPeer => 'Kết nối bị đặt lại bởi bên kia.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Mất kết nối do hết thời gian heartbeat. Vui lòng kết nối lại.';

  @override
  String get startHosting => 'Bắt đầu lưu trữ';

  @override
  String get restartRequestRejected => 'Yêu cầu khởi động lại bị từ chối.';

  @override
  String get notConnectedToLanOpponent => 'Không kết nối với đối thủ LAN.';

  @override
  String get llmPrompt => 'Lời nhắc LLM';

  @override
  String get gameRestarted => 'Trò chơi đã được khởi động lại.';

  @override
  String get takeBackRejected => 'Hoàn tác bị từ chối.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Bạn có chắc chắn muốn từ bỏ trò chơi này không?';

  @override
  String get opponentResignedYouWin => 'Đối thủ đã từ bỏ. Bạn thắng!';

  @override
  String get clearAllAnnotations => 'Xóa tất cả chú thích';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Đã kết nối, đang chờ nước đi của đối thủ...';

  @override
  String get networkStatusDisconnected => 'Trạng thái mạng: Đã ngắt kết nối';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Yêu cầu hoàn tác đã được gửi đến đối thủ.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Đối thủ có thể đã rời khỏi trò chơi';

  @override
  String get connectedToHostSuccessfully =>
      'Đã kết nối với máy chủ thành công.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Mất kết nối: hết thời gian heartbeat';

  @override
  String get noHostDiscovered => 'Không tìm thấy máy chủ.';

  @override
  String get confirmResignation => 'Xác nhận từ bỏ';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Đã bắt đầu lưu trữ trò chơi, đang chờ người chơi tham gia...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Kết nối hết thời gian, kết nối mạng không ổn định.';

  @override
  String get noLlmPromptAvailable => 'Không có lời nhắc LLM nào.';

  @override
  String get youResignedGameOver => 'Bạn đã từ bỏ. Trò chơi kết thúc.';

  @override
  String get serverIp => 'IP máy chủ';

  @override
  String get confirmClear => 'Xác nhận xóa';

  @override
  String get opponentSTurn => 'Lượt của đối thủ.';

  @override
  String get waitingAClientConnection => 'Đang chờ kết nối từ máy khách...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Yêu cầu hoàn tác đã bị từ chối hoặc thất bại.';

  @override
  String get addText => 'Thêm văn bản';

  @override
  String get exitAnnotationMode => 'Thoát chế độ chú thích';

  @override
  String get typeYourAnnotation => 'Nhập chú thích của bạn';

  @override
  String get attemptingToReconnect => 'Đang cố gắng kết nối lại...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Yêu cầu khởi động lại đã được gửi. Đang chờ phản hồi từ đối thủ...';

  @override
  String get serverIsStopped => 'Máy chủ đã dừng.';

  @override
  String get restartRequest => 'Yêu cầu khởi động lại';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Không thể yêu cầu hoàn tác khi không phải lượt của bạn.';

  @override
  String get takeBackAccepted => 'Hoàn tác được chấp nhận.';

  @override
  String get localNetworkSettings => 'Cài đặt mạng cục bộ';

  @override
  String get reconnectedSuccessfully => 'Đã kết nối lại thành công!';

  @override
  String get failedToSaveImageToGallery =>
      'Không thể lưu hình ảnh vào Thư viện.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Đối thủ yêu cầu khởi động lại trò chơi. Bạn có chấp nhận không?';

  @override
  String get yourTurn => 'Lượt của bạn.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Không thể kết nối lại, vui lòng khởi động lại trò chơi.';

  @override
  String get host => 'Máy chủ';

  @override
  String get join => 'Tham gia';

  @override
  String get port => 'Cổng';

  @override
  String get invalidIpAddress => 'Địa chỉ IP không hợp lệ.';

  @override
  String get invalidPort => 'Cổng không hợp lệ.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Đang kết nối: Lần thử $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Kết nối thất bại: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Không thể bắt đầu lưu trữ: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Đã tìm thấy máy chủ: $ip:$port';
  }

  @override
  String get stop => 'Dừng';

  @override
  String get discover => 'Khám phá';

  @override
  String get connect => 'Kết nối';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Máy khách đã kết nối: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Đang khám phá: $seconds giây';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Đang kết nối lại ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Đã kết nối';

  @override
  String get delete => 'Xóa';

  @override
  String get ancientEgypt => 'Ai Cập Cổ Đại';

  @override
  String get gothicIce => 'Băng Gothic';

  @override
  String get riceField => 'Ruộng Lúa';

  @override
  String get chinesePorcelain => 'Đồ Sứ Trung Quốc';

  @override
  String get desertDusk => 'Hoàng Hôn Sa Mạc';

  @override
  String get precisionCraft => 'Thủ Công Chính Xác';

  @override
  String get folkEmbroidery => 'Thêu Dân Gian';

  @override
  String get carpathianHeritage => 'Di Sản Carpathian';

  @override
  String get imperialGrandeur => 'Sự Vĩ Đại Đế Quốc';

  @override
  String get bohemianCrystal => 'Pha Lê Bohemian';

  @override
  String get savannaSunrise => 'Bình Minh Savanna';

  @override
  String get harmonyBalance => 'Hòa Hợp và Cân Bằng';

  @override
  String get cinnamonSpice => 'Gia Vị Quế';

  @override
  String get anatolianMosaic => 'Khảm Anatolian';

  @override
  String get carnivalSpirit => 'Tinh Thần Lễ Hội';

  @override
  String get custom => 'Tùy chỉnh';

  @override
  String get spiceMarket => 'Chợ gia vị';

  @override
  String get swipeToRevealTheDrawer => 'Vuốt để hiển thị ngăn kéo';

  @override
  String get showGameInfoOnScreenshots =>
      'Hiển thị thông tin trò chơi trên ảnh chụp màn hình';

  @override
  String get humanMoveTime => 'Giới hạn thời gian của con người';

  @override
  String get noTimeLimitForHumanMoves =>
      'Không giới hạn thời gian cho nước đi của con người';

  @override
  String get timeoutLoseWillBeApplied =>
      'Thua do hết giờ sẽ được áp dụng cho người chơi';

  @override
  String get identifyingBoard => 'Đang xác định bàn cờ...';

  @override
  String get youCanEnterAnyModelName =>
      'Bạn có thể nhập bất kỳ tên mô hình nào.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Vị trí bàn cờ đã được áp dụng. FEN đã được sao chép vào khay nhớ tạm.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Gợi ý: thử chụp hình bàn cờ rõ nét hơn.';

  @override
  String get llmPromptTemplate => 'Mẫu prompt LLM';

  @override
  String get noValidBoardDetected => 'Không tìm thấy bàn cờ hợp lệ.';

  @override
  String get selectingImageFromAlbum => 'Đang chọn hình từ album...';

  @override
  String get configurePromptTemplate => 'Cấu hình mẫu prompt';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Chỉnh sửa mẫu prompt cho phân tích LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Không thể tạo FEN từ bàn cờ đã nhận diện.';

  @override
  String get outputInCurrentLanguage => 'Kết quả bằng ngôn ngữ hiện tại';

  @override
  String get commonBaseUrls => 'Các Base URL thường dùng';

  @override
  String get viewCommonModels => 'Xem các mô hình thường dùng';

  @override
  String get recognitionParametersUpdated =>
      'Tham số nhận diện đã được cập nhật.';

  @override
  String get whiteSMove => 'Nước đi của trắng';

  @override
  String get resetToDefaults => 'Đặt lại về mặc định';

  @override
  String get photoShoot => 'Chụp ảnh';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Không thể áp dụng vị trí bàn cờ đã nhận diện.';

  @override
  String get llmPromptContent => 'Nội dung prompt LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'Chưa cấu hình LLM. Vui lòng kiểm tra cài đặt.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Đặt nhà cung cấp, mô hình, API Key và Base URL';

  @override
  String get llmConfiguration => 'Cấu hình LLM';

  @override
  String get configureLlmProvider => 'Cấu hình nhà cung cấp LLM';

  @override
  String get llmPromptTemplateHeader => 'Tiêu đề mẫu prompt LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Không có quân cờ nào được nhận diện trong ảnh. Vui lòng thử lại.';

  @override
  String get recognizeBoardFromImage => 'Nhận diện bàn cờ từ ảnh';

  @override
  String get viewTips => 'Xem mẹo';

  @override
  String get applyToBoard => 'Áp dụng lên bàn cờ';

  @override
  String get adjustBoardArea => 'Chỉnh vùng bàn cờ';

  @override
  String get viewCommonUrls => 'Xem các URL thường dùng';

  @override
  String get colorAnalysisFailed => 'Phân tích màu thất bại!';

  @override
  String get analyzingGameBoardImage => 'Đang phân tích hình ảnh bàn cờ...';

  @override
  String get selectFromAlbum => 'Chọn từ album';

  @override
  String get noBoardPointDetected => 'Không tìm thấy điểm bàn cờ!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Nếu để trống, mẫu mặc định sẽ được sử dụng';

  @override
  String get llmConfig => 'Cấu hình LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Bạn có chắc muốn đặt lại các mẫu prompt về giá trị mặc định không?';

  @override
  String get llmPromptTemplateFooter => 'Chân trang mẫu prompt LLM';

  @override
  String get loadingResponse => 'Đang tải phản hồi...';

  @override
  String get applyThisResultToBoard => 'Áp dụng kết quả này lên bàn cờ';

  @override
  String get takingPicture => 'Đang chụp ảnh...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Vui lòng chọn một ảnh bàn cờ để nhận diện';

  @override
  String get identificationResults => 'Kết quả nhận diện';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Phân tích các nước đi và cung cấp nhận định.';

  @override
  String get getApiKey => 'Lấy API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Quá trình nhận diện hoàn chỉnh không thể thực hiện.';

  @override
  String get boardRecognitionResult => 'Kết quả nhận diện bàn cờ';

  @override
  String get askLlm => 'Hỏi LLM';

  @override
  String get boardDetectionFailed => 'Phát hiện bàn cờ thất bại!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Không tìm thấy điểm bàn cờ, không thể nhận diện quân cờ!';

  @override
  String get copyFen => 'Sao chép FEN';

  @override
  String get commonlyUsedModels => 'Các mô hình thường dùng';

  @override
  String get apiKeyOptional => 'API Key (tùy chọn)';

  @override
  String get noImageSelected => 'Chưa chọn hình ảnh nào';

  @override
  String get blackSMove => 'Nước đi của đen';

  @override
  String get llm => 'Mô hình Ngôn ngữ Lớn';

  @override
  String get llmProvider => 'Nhà cung cấp';

  @override
  String get baseUrl => 'URL Cơ sở';

  @override
  String get model => 'Mô hình';

  @override
  String get temperature => 'Nhiệt độ';

  @override
  String get llmCommandReceivedProcessing => 'Lệnh đã nhận! AI đang xử lý...';

  @override
  String get llmDeepThinkingWait => 'Đang suy nghĩ sâu, vui lòng chờ...';

  @override
  String get llmPresentingSoon => 'Sẽ trình bày sớm...';

  @override
  String get recognitionParameters => 'Tham số nhận dạng';

  @override
  String get adjustParamsDesc =>
      'Điều chỉnh tham số để nâng cao độ chính xác nhận dạng';

  @override
  String get saveParameters => 'Lưu tham số';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Không thể bắt đầu nhận dạng hình ảnh: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Nhận dạng hình ảnh thất bại: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Đã áp dụng thế cờ với $whiteCount quân trắng và $blackCount quân đen';
  }

  @override
  String get fenCopiedToClipboard => '(FEN đã sao chép vào bảng tạm)';

  @override
  String recognitionFailed(String error) {
    return 'Nhận dạng thất bại: $error';
  }

  @override
  String get myRating => 'Xếp hạng của tôi';

  @override
  String get gamesPlayed => 'Số trận đã chơi';

  @override
  String get wins => 'Thắng';

  @override
  String get losses => 'Thua';

  @override
  String get draws => 'Hòa';

  @override
  String get lastUpdated => 'Cập nhật lần cuối';

  @override
  String get format => 'Định dạng:';

  @override
  String get resetStatistics => 'Đặt lại thống kê';

  @override
  String get drawRate => 'Tỷ lệ hòa';

  @override
  String get lossRate => 'Tỷ lệ thua';

  @override
  String get aiStatistics => 'Thống kê AI';

  @override
  String get enableStatistics => 'Bật thống kê';

  @override
  String get enableStatistics_Detail =>
      'Khi được bật, kết quả trò chơi sẽ được ghi lại trong thống kê. Tuy nhiên, các trò chơi liên quan đến việc đi lại nước cờ sẽ không được ghi lại. Khi bị tắt, việc thu thập thống kê sẽ bị tạm dừng.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Thao tác này sẽ đặt lại tất cả thống kê trò chơi. Không thể hoàn tác thao tác này.';

  @override
  String get boardInnerRingSize => 'Kích thước vòng trong của bàn cờ';

  @override
  String get boardShadowEnabled => 'Bóng của bàn cờ';

  @override
  String get trapAwareness => 'Nhận diện bẫy';

  @override
  String get trapAwarenessDescription =>
      'Làm nổi bật các nước đi bẫy bằng vòng tròn và mũi tên đậm trong quá trình phân tích.';

  @override
  String trapExists(String trapMoves) {
    return 'Có bẫy. Nước đi bẫy: $trapMoves';
  }

  @override
  String get custodianCapture => 'Chụp sườn';

  @override
  String get custodianCaptureDescription =>
      'Bao quanh một trong những mảnh của đối thủ giữa hai bạn theo một đường thẳng để nắm bắt nó.';

  @override
  String get custodianCaptureEnable => 'Cho phép chụp sườn';

  @override
  String get interventionCapture => 'Bắt giữ can thiệp';

  @override
  String get interventionCaptureDescription =>
      'Di chuyển vào điểm trống giữa hai mảnh của đối thủ của bạn để bắt cả hai.';

  @override
  String get interventionCaptureEnable => 'Cho phép bắt giữ can thiệp';

  @override
  String get leapCapture => 'Nhảy bắt';

  @override
  String get leapCaptureDescription =>
      'Nắm bắt bằng cách nhảy qua mảnh đối thủ liền kề vào điểm trống bên kia.';

  @override
  String get leapCaptureEnable => 'Cho phép bắt giữ';

  @override
  String get captureApplicableLines => 'Dòng áp dụng';

  @override
  String get captureSquareEdges => 'Dọc theo các cạnh của quảng trường';

  @override
  String get captureCrossLines =>
      'Dọc theo các đường trực giao băng qua quảng trường';

  @override
  String get captureDiagonalLines =>
      'Dọc theo các đường chéo băng qua quảng trường';

  @override
  String get captureExecutionPhases => 'Giai đoạn thực thi';

  @override
  String get capturePiecesCondition =>
      'Tính khả dụng trong giai đoạn di chuyển dựa trên các phần còn lại';

  @override
  String get capturePiecesConditionUnlimited => 'Không hạn chế';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Có sẵn khi bạn có ba hoặc ít hơn';
}
