// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Uzbek (`uz`).
class SUz extends S {
  SUz([String locale = 'uz']) : super(locale);

  @override
  String get appName => 'Tegirmon';

  @override
  String get welcome => 'Xush kelibsiz';

  @override
  String get yes => 'Ha';

  @override
  String get no => 'Yo\'q';

  @override
  String get game => 'O\'yin';

  @override
  String get humanVsAi => 'Inson va boshqalar A.I';

  @override
  String get humanVsHuman => 'Inson va boshqalar Inson';

  @override
  String get aiVsAi => 'AI va boshqalar. AI';

  @override
  String get humanVsCloud => 'Inson va boshqalar Bulut';

  @override
  String get humanVsLAN => 'Inson va boshqalar LAN';

  @override
  String get testViaLAN => 'LAN orqali sinab ko\'ring';

  @override
  String get move => 'Ko\'chirish';

  @override
  String get showMoveList => 'Ro\'yxatni ko\'chirish';

  @override
  String get moveList => 'Ro\'yxatni ko\'chirish';

  @override
  String get noGameRecord => 'Yozuv yo\'q';

  @override
  String get ok => 'OK';

  @override
  String get confirm => 'Tasdiqlang';

  @override
  String get cancel => 'Bekor qilish';

  @override
  String get tipSelectWrong => 'Noto\'g\'ri qismni tanlang.';

  @override
  String get tipPlace => 'Parchalaringizni joylashtiring.';

  @override
  String get tipBanPlace => 'Siz uni bu erga joylashtirolmaysiz.';

  @override
  String get tipPlaced => 'Siz joylashtirdingiz.';

  @override
  String get tipRemove => 'Bir qismni olib tashlang.';

  @override
  String get tipBanRemove => 'Siz uni olib tashlay olmaysiz.';

  @override
  String get tipRemoved => 'Siz olib tashladingiz.';

  @override
  String get tipMove => 'Bir qismni siljiting.';

  @override
  String get tipCannotPlace =>
      'Siz o\'zingizning buyumingizni bu erda joylashtirolmaysiz.';

  @override
  String get tipCannotMove => 'Siz asaringizni bu erda ko\'chira olmaysiz.';

  @override
  String get tipMill => 'Tegirmon! Raqibingizning qismini oling.';

  @override
  String get tipContinueMill => 'Raqibingizning qismini olishga davom eting.';

  @override
  String get tipSelectOpponentsPiece =>
      'Raqibingizning qismlaridan birini tanlang.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Siz tegirmondan biron bir qismni olib tashlay olmaysiz.';

  @override
  String get tipCanMoveOnePoint => 'Bir parcha 1 nuqtani siljitishi mumkin.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Siz raqibingizning qismlarini siljita olmaysiz.';

  @override
  String get tipSelectPieceToMove => 'Ko\'chirish uchun qismingizni tanlang.';

  @override
  String get tipHaveThreePiecesLeft => 'Sizda uchta dona qoldi.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Siz xohlagan nuqtaga o\'tishingiz mumkin.';

  @override
  String tipToMove(Object player) {
    return 'harakat qilish uchun $player.';
  }

  @override
  String get whiteWin => '1-o\'yinchi g\'alaba qozonadi!';

  @override
  String get blackWin => '2-o\'yinchi g\'alaba qozondi!';

  @override
  String get won => 'Yutuq';

  @override
  String get lost => 'Yo\'qotilgan';

  @override
  String get thinking => 'Fikrlash…';

  @override
  String get newGame => 'Yangi o\'yin';

  @override
  String get importGame => 'Import o\'yin';

  @override
  String get exportGame => 'Eksport o\'yini';

  @override
  String get gameImported => 'O\'yin import qilingan.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Import qilib boʻlmadi $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Harakatlar va qoidalar mos kelmaydi.';

  @override
  String get pleaseWait => 'Iltimos kuting.';

  @override
  String get restartGame => 'Joriy o\'yinni qayta boshlaysizmi?';

  @override
  String get restart => 'Qayta ishga tushirish';

  @override
  String get gameStarted => 'O\'yin boshlandi, iltimos joylashtiring.';

  @override
  String get analyzing => 'Tahlil qilinmoqda…';

  @override
  String error(Object message) {
    return 'Xato: $message';
  }

  @override
  String get winRate => 'G\'oliblik darajasi';

  @override
  String get score => 'Xol:';

  @override
  String get white => '1-o\'yinchi';

  @override
  String get black => '2-o\'yinchi';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player parchalar soni uchtadan kam.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player iste\'foga chiqish.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player uchun hech qanday yo\'l yo\'q.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Doska to‘lgan va $player ning borishga imkoni yo‘q.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Vaqt tugadi, $player yutqazdi.';
  }

  @override
  String get drawReasonRule50 =>
      'Harakatlanuvchi bosqichda, so\'nggi aniq sonli harakatlarda biron bir qism olib tashlanmagan.';

  @override
  String get drawReasonBoardIsFull => 'Bu Draw, chunki taxta to\'la.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Bu uch marta takrorlanganligi sababli chizilgan.';

  @override
  String get gameOverUnknownReason => 'O\'yin tugadi! Noma\'lum sabab.';

  @override
  String get gameOver => 'O\'yin tugadi';

  @override
  String get youWin => 'Siz yutdingiz! Tabriklaymiz!';

  @override
  String challengeHarderLevel(int level) {
    return 'Qattiqroq darajaga duch kelasizmi? Yangi daraja $level darajasida bo\'ladi!';
  }

  @override
  String get youLose => 'Yutqazdingiz!';

  @override
  String get analyze => 'Tahlil qiling';

  @override
  String get about => 'Haqida';

  @override
  String version(Object versionNumber) {
    return 'Versiya: $versionNumber';
  }

  @override
  String get thanks => 'Rahmat';

  @override
  String get settings => 'Sozlamalar';

  @override
  String get options => 'Variantlar';

  @override
  String get generalSettings => 'Umumiy sozlamalar';

  @override
  String get skillLevel => 'Qiyinchilik darajasi';

  @override
  String get moveTime => 'AI fikrlash vaqti';

  @override
  String get difficulty => 'Qiyinchilik';

  @override
  String get playSounds => 'Ovoz effektlari';

  @override
  String get playSoundsInTheGame => 'O\'yindagi tovushlarni ijro eting';

  @override
  String get keepMuteWhenTakingBack => 'Orqaga olayotganda sukut saqlang';

  @override
  String get tone => 'Ohang';

  @override
  String get whoMovesFirst => 'Birinchi harakat';

  @override
  String get human => 'Inson';

  @override
  String get ai => 'A.I.';

  @override
  String get alternate => 'Muqobil';

  @override
  String get isAutoRestart =>
      'O\'yin tugashi bilan o\'yinni avtomatik ravishda qayta boshlash';

  @override
  String get isAutoChangeFirstMove =>
      'Avtomatik o\'zgartirish birinchi harakat';

  @override
  String get shufflingEnabled => 'Tasodifiy harakatlaning';

  @override
  String get misc => 'Turli xil';

  @override
  String get rules => 'Qoidalar';

  @override
  String get piecesCount => 'Har bir o\'yinchining soni';

  @override
  String get piecesCount_Detail => 'Har bir o\'yinchi nechta donadan iborat?';

  @override
  String get flyPieceCount => 'Uchib ketadigan parcha soni';

  @override
  String get flyPieceCount_Detail =>
      'Agar \"Uchish\" funksiyasi yoqilgan bo\'lsa, o\'yinchi ma\'lum bir qism soniga kamaytirilganda, uning qismlari o\'yinning qolgan qismidagi kabi qo\'shni nuqtalarda cheklanish o\'rniga har qanday bo\'sh joyga ko\'chib o\'tishlari mumkin.';

  @override
  String get piecesAtLeastCount => 'Kamida bo\'laklar';

  @override
  String get hasDiagonalLines => 'Diagonal chiziqlar';

  @override
  String get hasDiagonalLines_Detail =>
      'Taxtaga to\'rtta diagonal chiziq qo\'shing.';

  @override
  String get isDefenderMoveFirst =>
      'Ikkinchi o\'yinchi birinchi bo\'lib harakat qiladi';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Joylashtirish bosqichida ikkinchi harakat qilgan o\'yinchi harakatlanayotgan bosqichda birinchi bo\'lib harakat qiladi.';

  @override
  String get mayRemoveMultiple => 'Ko\'p o\'chirish';

  @override
  String get mayRemoveMultiple_Detail =>
      'Agar o\'yinchi bir vaqtning o\'zida bir nechta tegirmonni yopsa, u yopilgan tegirmonlar sonini olib tashlaydi.';

  @override
  String get mayRemoveFromMillsAlways => 'Tegirmonlarni yo\'q qiling';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Odatiy bo\'lib, o\'yinchilar shakllangan tegirmondan biron bir qismni olib tashlashdan oldin, boshqa qismlarni olib tashlashlari kerak. Cheklovni o\'chirish uchun ushbu parametrni yoqing.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Ikkinchi o\'yinchi taxta to\'ldirilganda yutqazadi';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Joylashtirish bosqichi oxirida taxta to\'ldirilganda, birinchi bo\'lib joylashadigan tomon o\'yinni yo\'qotadi. Aks holda, o\'yin durang.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Hech qanday qonuniy harakatlar bo\'lmaganida yo\'qotish';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Raqibi ularni harakatga keltirmaslik uchun to\'sib qo\'ysa, o\'yinchi yutqazadi. Ushbu parametr o\'chirilgan bo\'lsa, harakatlanish uchun yon tomonni o\'zgartiring.';

  @override
  String get mayFly => 'Uchish';

  @override
  String get mayFly_Detail =>
      'Agar o\'yinchida faqat uchta yoki to\'rtta (sozlanishi) qism qolsa, u buyumni istalgan bo\'sh nuqtaga ko\'chirishi mumkin.';

  @override
  String get nMoveRule => 'N-harakat qoidasi';

  @override
  String get nMoveRule_Detail =>
      'O\'yin, ma\'lum miqdordagi harakatlarda olib tashlanmagan bo\'lsa, chiziladi.';

  @override
  String get rollback => 'Orqaga qaytarish';

  @override
  String get pleaseSelect => 'Iltimos tanlang';

  @override
  String get copy => 'Nusxalash';

  @override
  String get moveHistoryCopied => 'Buferga ko\'chirilgan tarixni ko\'chirish.';

  @override
  String get help => 'Yordam bering';

  @override
  String get feedback => 'Fikr-mulohaza';

  @override
  String get exit => 'Chiqish';

  @override
  String get ruleSettings => 'Qoidalar';

  @override
  String get color => 'Rang';

  @override
  String get boardColor => 'Kengash rangi';

  @override
  String get pieceColor => 'Parcha rangi';

  @override
  String get backgroundColor => 'Fon rangi';

  @override
  String get lineColor => 'Kengash chizig\'i rangi';

  @override
  String get whitePieceColor => 'Aktyor 1 dona rang';

  @override
  String get blackPieceColor => 'Aktyor 2 dona rang';

  @override
  String get messageColor => 'Xabar rangi';

  @override
  String get isPieceCountInHandShown => 'Qo\'ldagi buyumlar sonini ko\'rsating';

  @override
  String get isNotationsShown => 'Bortdagi yozuvlarni ko\'rsatish';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Tarix navigatsiyasi asboblar panelini ko\'rsatish';

  @override
  String get display => 'Displey';

  @override
  String get boardBorderLineWidth => 'Kengashning chegara kengligi';

  @override
  String get boardInnerLineWidth => 'Kengashning ichki chizig\'i kengligi';

  @override
  String get pieceWidth => 'Parcha kengligi';

  @override
  String get fontSize => 'Shrift hajmi';

  @override
  String get standardNotation => 'WMD belgisi';

  @override
  String get restore => 'Qayta tiklash';

  @override
  String get restoreDefaultSettings => 'Standart sozlamalarni tiklang';

  @override
  String pick(Object element) {
    return '$element ni tanlang';
  }

  @override
  String get info => 'Ma\'lumot';

  @override
  String get hint => 'Maslahat';

  @override
  String get player => 'o\'yinchi';

  @override
  String get player1 => '1-o\'yinchi';

  @override
  String get player2 => '2-o\'yinchi';

  @override
  String get howToPlay => 'Qanday o\'ynash kerak';

  @override
  String get toPlacePiece =>
      'Parchani joylashtirish uchun mavjud nuqtani bosing.';

  @override
  String get toSelectPiece => 'Uni siljitish uchun biron joyga teging.';

  @override
  String get toMovePiece =>
      'Parchani siljitish uchun unga ulangan nuqtani bosing.';

  @override
  String get toRemovePiece =>
      'Olib tashlash uchun raqibning bitta qismiga teging.';

  @override
  String get needToCreateMillFirst =>
      'Parchani olib tashlashdan oldin avval siz tegirmonni yaratishingiz kerak.';

  @override
  String get needToPlayWithOwnPieces =>
      'Sizning qismlaringiz bilan o\'ynashingiz kerak.';

  @override
  String get statistics => 'Statistika';

  @override
  String get totalGames => 'Jami o\'yinlar';

  @override
  String get results => 'Natijalar';

  @override
  String get left => 'chap';

  @override
  String get privacyPolicy => 'Maxfiylik siyosati';

  @override
  String get privacyPolicy_Detail_1 =>
      'Iltimos, diqqat bilan o\'qing va buni to\'liq tushunganingizga va rozi ekanligingizga ishonch hosil qiling ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Agar siz ushbu Siyosatga rozi bo\'lmasangiz, iltimos, ushbu ilovadan foydalanmang. Ilovadan foydalanish ushbu shartlarni qabul qilishingizni anglatadi.';

  @override
  String get and => ' va ';

  @override
  String get accept => 'Qabul qiling';

  @override
  String get takeBack => 'Qaytarib ol';

  @override
  String get takingBack => 'Orqaga…';

  @override
  String get waiting => 'Kutilmoqda…';

  @override
  String get stepForward => 'Oldinga qadam';

  @override
  String get takeBackAll => 'Barchasini qaytarib oling';

  @override
  String get stepForwardAll => 'Barchasini oldinga qadam qo\'ying';

  @override
  String get moveNow => 'Hozir harakatlaning';

  @override
  String get done => 'Bajarildi.';

  @override
  String get crackMill => 'Yoriq tegirmoni';

  @override
  String get crackMill_Detail =>
      'Agar o\'yinchi tegirmonda faqat bitta bo\'lakka ega bo\'lsa, tegirmondagi qismlarni olib tashlash uchun qulflanmaydi.';

  @override
  String get animationDuration => 'Animatsiya davomiyligi';

  @override
  String get none => 'Yo\'q';

  @override
  String get theme => 'Mavzu';

  @override
  String get helpContent =>
      'O\'yin raqibni uchta bo\'lakdan kam yoki qonuniy harakatlarsiz qoldirishga qaratilgan.\n\nAgar pozitsiya uchinchi marta sodir bo\'lsa yoki so\'nggi 100 ta harakatni olib tashlamasa, o\'yin avtomatik ravishda tortiladi.\n\nO\'yin uch bosqichda davom etadi:\n\n1. Bo\'sh joylarga qismlarni joylashtirish\n2. Parchalarni qo\'shni nuqtalarga ko\'chirish\n3. (ixtiyoriy bosqich) Pleyerni uch qismga qisqartirganda qismlarni istalgan bo\'sh joyga ko\'chirish\n\nJoylashtirish\n\nO\'yin bo\'sh taxta bilan boshlanadi, u yigirma to\'rt ochko to\'plangan panjaradan iborat. Aktyorlar har bir o\'yinchi barcha qismlarni taxtaga qo\'yguncha navbat bilan o\'z qismlarini bo\'sh joylarga qo\'yishadi. Agar o\'yinchi uchta qismini to\'g\'ri qo\'yishi mumkin bo\'lsa, unda \"tegirmon\" bor va u raqibining bitta qismini taxtadan olib tashlashi mumkin.\n\nBa\'zi bir qoidalarda, o\'yinchilar shakllangan tegirmondan biron bir qismni olib tashlashdan oldin boshqa qismlarni olib tashlashlari kerak.\n\nSiz ba\'zi qoidalarda joylashtirish bosqichida qismlarni olib tashlangan qismlarga yana joylashtirolmaysiz.\n\nBarcha qismlardan foydalangandan so\'ng, o\'yinchilar navbat bilan harakat qilishadi.\n\nKo\'chirish\n\nKo\'chirish uchun o\'yinchi o\'z qismlaridan birini taxta chizig\'i bo\'ylab bo\'sh qo\'shni nuqtaga olib boradi. Agar u buni qila olmasa, u o\'yinni yutqazgan. Uchta bo\'lagini taxta chizig\'iga tekislagan o\'yinchi tegirmonga ega va joylashtirish bosqichidagi kabi raqibining birini olib tashlashi mumkin. Har qanday o\'yinchi ikki qismga qisqartiradi, yangi tegirmonlarni yaratish imkoniyati yo\'q va shu bilan o\'yinni yo\'qotadi. Raqib ularni harakatlanishiga to\'sqinlik qilsa, o\'yinchi uchta bo\'lakdan ko\'proq yutqazishi mumkin.\n\nUchish\n\nQoidalarning ba\'zi bir variantlarida, agar o\'yinchida faqat uchta bo\'lak qolsa, uning qismlari uchib ketishi, sakrashi yoki faqat qo\'shni bo\'lgan joylarga emas, balki har qanday bo\'sh joyga sakrashi mumkin.';

  @override
  String get versionInfo => 'Versiya haqida ma\'lumot';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Litsenziya';

  @override
  String get sourceCode => 'Manba kodi';

  @override
  String get appVersion => 'Ilova versiyasi';

  @override
  String get general => 'Umumiy';

  @override
  String get advanced => 'Ilg\'or';

  @override
  String get placing => 'Joylashtirish';

  @override
  String get moving => 'Ko\'chirish';

  @override
  String get removing => 'Olib tashlash';

  @override
  String get gameOverCondition => 'O\'yin tugadi';

  @override
  String get aisPlayStyle => 'AI ning o\'yin uslubi';

  @override
  String get passive => 'Passiv';

  @override
  String get timeout => 'Taym-aut; turib qolish; tanaffus';

  @override
  String get appearance => 'Tashqi ko\'rinish';

  @override
  String get drawOnHumanExperience => 'Inson tajribasidan foydalaning';

  @override
  String get considerMobility =>
      'Parchalarning harakatchanligini ko\'rib chiqing';

  @override
  String get pieceCount => 'Parcha soni:';

  @override
  String inHand(Object player, int count) {
    return '$player qo\'lda: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player bortda: $count';
  }

  @override
  String get boardTop => 'Kengash tepadan ofset';

  @override
  String get notAIsTurn => 'Bu navbat AI emas.';

  @override
  String get aiIsNotThinking => 'AI o\'ylamaydi.';

  @override
  String get atEnd => 'Siz ko\'chirish ro\'yxatining oxiridasiz.';

  @override
  String get tapBackAgainToLeave => 'Ketish uchun yana bir marta bosing.';

  @override
  String get more => 'Ko\'proq';

  @override
  String get experimental => 'Bu eksperimental xususiyat.';

  @override
  String get experiments => 'Tajribalar';

  @override
  String get ossLicenses => 'Ochiq manbali litsenziyalar';

  @override
  String get language => 'Til';

  @override
  String get defaultLanguage => 'Standart til';

  @override
  String get mayMoveInPlacingPhase =>
      'Parchalar joylashtirish bosqichida harakatlanishi mumkin';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Alohida joylashtirish va harakatlanish bosqichlari mavjud emas, ya\'ni o\'yinchilar har bir harakatda taxtaga biror qism qo\'yishni xohlaydilarmi yoki ularning qismlaridan birini ko\'chirishni xohlaydilarmi (agar ular joylashtiriladigan qoldiqlari bo\'lsa).';

  @override
  String get drawerColor => 'Menyu rangi';

  @override
  String get drawerTextColor => 'Menyu matni rangi';

  @override
  String get drawerHighlightItemColor =>
      'Menyu element rangini ajratib ko\'rsatish';

  @override
  String get mainToolbarBackgroundColor => 'Asosiy asboblar paneli fon rangi';

  @override
  String get mainToolbarIconColor => 'Asosiy asboblar paneli piktogramma rangi';

  @override
  String get navigationToolbarBackgroundColor =>
      'Navigatsiya asboblar panelining fon rangi';

  @override
  String get navigationToolbarIconColor =>
      'Navigatsiya asboblar paneli piktogramma rangi';

  @override
  String get autoHideToolbar =>
      'Asboblar panelini avtomatik ravishda yashirish';

  @override
  String get toolbarLocationOnScreen =>
      'Asboblar panelining ekrandagi joylashuvi';

  @override
  String get top => 'Yuqori';

  @override
  String get bottom => 'Pastki';

  @override
  String get center => 'Markaz';

  @override
  String get solidColor => 'Qattiq rang';

  @override
  String get picture => 'Rasm';

  @override
  String get chooseYourPicture => 'Rasmingizni tanlang';

  @override
  String get light => 'Engil';

  @override
  String get dark => 'To\'q';

  @override
  String get themes => 'Mavzular';

  @override
  String get currentTheme => 'Joriy mavzu';

  @override
  String get saveTheme => 'Mavzuni saqlash';

  @override
  String get showAnalysisGraph => 'Tahlil grafikasini ko\'rsatish';

  @override
  String get analysis => 'Tahlil';

  @override
  String get saveGame => 'O\'yinni saqlang';

  @override
  String get loadGame => 'O\'yinni yuklang';

  @override
  String get setupPosition => 'O\'rnatish pozitsiyasi';

  @override
  String get showLegalMoves => 'Qonuniy harakatlarni ko\'rsating';

  @override
  String get showLastMove => 'Oxirgi harakatni ko\'rsating';

  @override
  String get showArrows => 'Oklarni ko\'rsatish';

  @override
  String get pieces => 'Parchalar';

  @override
  String get showAnalysis => 'Tahlilni ko\'rsatish';

  @override
  String get threads => 'Iplar';

  @override
  String get getInvolved => 'Qo\'shilmoq';

  @override
  String get helpImproveTranslate => 'Tarjimani yaxshilashga yordam bering';

  @override
  String get tutorial => 'Qo\'llanma';

  @override
  String get classicMill => 'Klassik tegirmon';

  @override
  String get mixedMill => 'Aralash tegirmon';

  @override
  String get ceylonMill => 'Seylon tegirmoni';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Tegirmon buzilib, qayta tiklanishi mumkin';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Agar o\'yinchi darhol yangi tegirmon yaratish uchun tegirmonni sindirib tashlasa, bunday o\'yinchi yangi tegirmon qilsa, keyingi harakatida bunday buyumni asl bog\'lanish joyiga qaytarishi mumkin.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Agar o\'yinchi uchta bo\'lakka ega bo\'lsa va o\'nta harakatdan so\'ng ikkala o\'yinchi ham raqib qismlarini olib tashlamasa, o\'yin o\'tkaziladi';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Agar o\'yinchi uchta bo\'lakka tushib qolsa va hech bir o\'yinchi raqibning qismini o\'nta harakat davomida olib tashlay olmasa, o\'yin durang bo\'ladi.';

  @override
  String get close => 'Yopish';

  @override
  String get whitePiece => 'Oq bo\'lak';

  @override
  String get blackPiece => 'Qora parcha';

  @override
  String get emptyPoint => 'Bo\'sh nuqta';

  @override
  String get noPoint => 'Gap yo\'q';

  @override
  String get placingPhase => 'Joylashtirish bosqichi';

  @override
  String get movingPhase => 'Harakatlanish bosqichi';

  @override
  String get flyingPhase => 'Uchish bosqichi';

  @override
  String sideToMove(Object player) {
    return 'Ko\'chish uchun tomon: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Oxirgi harakat: $move';
  }

  @override
  String get selected => 'Tanlangan';

  @override
  String get accessibility => 'Maxsus imkoniyatlar';

  @override
  String get screenReaderSupport => 'Ekranni o\'quvchini qo\'llab -quvvatlash';

  @override
  String get isDraw => 'Bu durang!';

  @override
  String get draw => 'Chizma';

  @override
  String get pieceHighlightColor => 'Rangni ajratib ko\'rsatish';

  @override
  String get algorithm => 'Algoritm';

  @override
  String get endgameNMoveRule => 'Endgame N-Move qoidasi';

  @override
  String get endgameNMoveRule_Detail =>
      'Agar har bir o\'yinchi faqat uchta bo\'lakka ega bo\'lsa va hech bir o\'yinchi biron bir harakatni olib tashlamasa, o\'yin chiziladi.';

  @override
  String get drawReasonEndgameRule50 =>
      'Ikkala o\'yinchi ham faqat uchta bo\'lakka ega va hech bir o\'yinchi ma\'lum bir harakatda bo\'lakni olib tashlamaydi.';

  @override
  String get threefoldRepetitionRule => 'Uch marta takrorlash qoidasi';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Agar pozitsiya uchinchi marta sodir bo\'lsa, o\'yin durang o\'ynaydi.';

  @override
  String get continueToMakeMove => 'Tegirmon! Harakat qilishni davom ettiring.';

  @override
  String get pointStyle => 'Nuqtalar uslubi';

  @override
  String get pointWidth => 'Nuqta kengligi';

  @override
  String get solid => 'Qattiq';

  @override
  String get hollow => 'Ichi bo\'sh';

  @override
  String get languageName => 'Oʻzbekcha';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Ko\'chirish',
      one: '$count Ko\'chirish',
      zero: 'Ko\'chirish',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Yuklanmadi.';

  @override
  String get filename => 'Fayl nomi';

  @override
  String get browse => 'Ko‘rib chiqish…';

  @override
  String get gameFiles => 'O\'yin fayllar';

  @override
  String get gameSavedTo => 'Oʻyin saqlab qolindi';

  @override
  String get empty => 'Bo\'sh';

  @override
  String get noMove => 'Harakat yo\'q.';

  @override
  String get restoredPosition => 'Dastlabki pozitsiyasi tiklandi.';

  @override
  String get clean => 'Toza';

  @override
  String get cleanedUp => 'Tozalangan.';

  @override
  String get remove => 'O\'chirish';

  @override
  String get noPiecesCanBeRemoved =>
      'Hech qanday bo\'lakni olib tashlab bo\'lmaydi.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count dona',
      one: '$count dona',
      zero: 'Piece',
    );
    return '$_temp0 olib tashlash kerak.';
  }

  @override
  String placedCount(int count) {
    return 'Joylasht. ($count)';
  }

  @override
  String get placedPieceCount =>
      'Joylashtirish bosqichida joylashtirilgan qismlar soni.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Joriy o\'yinchi $count qismlarini joylashtirdi.';
  }

  @override
  String get notPlacingPhase =>
      'Fazani joylashtirmaslik, uni o\'zgartirish mumkin emas.';

  @override
  String get paste => 'joylashtirish';

  @override
  String get pasteDone => 'Pasta tayyor.';

  @override
  String get cannotPaste => 'Qo‘yib bo‘lmadi.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Joylanmagan va olib tashlangan qismlarni ko\'rsating';

  @override
  String get fullScreen => 'To\'liq ekran';

  @override
  String get reopenToTakeEffect =>
      'Sozlamalar kuchga kirishi uchun ilovadan chiqing va qayta oching.';

  @override
  String get forest => 'O\'rmon';

  @override
  String get desktopImage => 'Ish stoli tasviri';

  @override
  String get invalidPosition => 'Yaroqsiz pozitsiya.';

  @override
  String get shareGIF => 'GIF-ni ulashing';

  @override
  String get pixelRatio => 'Piksel nisbati';

  @override
  String get duration => 'Davomiyligi';

  @override
  String get gameScreenRecorder => 'O\'yin ekran yozuvchisi';

  @override
  String get previous => 'Oldingi';

  @override
  String get next => 'Keyingisi';

  @override
  String get skip => 'Oʻtkazib yuborish';

  @override
  String get gotIt => 'Tushundim';

  @override
  String get youCanModifyRules =>
      'Siz o\'yin qoidalarini qoida sozlamalarida o\'zgartirishingiz mumkin.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Tanlagichdagi qiymatni o\'zgartirish uchun sichqoncha g\'ildiragidan foydalanishingiz mumkin.';

  @override
  String get noTimeLimitForThinking =>
      'AI Fikrlash vaqti 0 ga o‘rnatilgani fikrlash uchun vaqt chegarasi yo‘qligini anglatadi.';

  @override
  String get whatIsMtdf =>
      'MTD(f) alfa-beta qidiruv algoritmining o\'zgartirilgan shakli bo\'lib, qidiruv natijalarini qayta ishlatish va qidiruv maydonini toraytirish uchun yaxshi dastlabki taxminni qo\'llash orqali samaradorlikni oshirishga qaratilgan.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Shuni yodda tutingki, AI fikrlash vaqtini sozlash to\'liq aniq bo\'lmasligi mumkin. Haqiqiy fikrlash vaqti qiyinchilik darajasi pastroq qiymatga o\'rnatilganda qisqaroq bo\'lishi mumkin va vaqt tugashi bilan AI o\'rtada bo\'lganda uzoqroq bo\'lishi mumkin.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Agar siz qiyinchilik darajasini yuqori o\'rnatsangiz, lekin AI fikrlash vaqtini oshirmasangiz, fikrlash vaqti cheklanganligi sababli haqiqiy qiyinchilik darajasi pastroq qiymat bilan cheklanishi mumkin. Haqiqiy qiymat mashinaning ishlashiga qarab farq qilishi mumkin.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) - bu ma\'lum bir pozitsiyada eng yaxshi harakatni topish uchun qidiruv algoritmi. Bu alfa-beta algoritmining takomillashtirilgani bo\'lib, harakatning asosiy o\'zgarishlardan allaqachon xavfsiz balldan yomonroq yoki yomonroq emasligini tasdiqlash uchun null yoki nol oyna qidiruvlaridan foydalanadi. PVS eng istiqbolli harakatlarga e\'tibor qaratadi va suboptimal filiallarni keraksiz qidirishdan qochadi, bu esa qidiruv samaradorligini oshirishga yordam beradi.';

  @override
  String get whatIsAlphaBeta =>
      'Alfa-beta algoritmi eng yaxshi harakatni topish uchun qidiruv algoritmidir. Qidiruv daraxtini kesish va samaradorlikni oshirish uchun u minimax printsipidan va ikkita qiymatdan, alfa va betadan foydalanadi. Alpha kompyuter olishi mumkin bo\'lgan minimal ballni, beta esa raqib olishi mumkin bo\'lgan maksimal ballni ifodalaydi. Algoritm kompyuterga o\'yinda oqilona va samarali qarorlar qabul qilishga yordam beradi.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Insoniyat tajribasiga ko\'ra, g\'alaba qozonishga harakat qilsangiz, yutqazasiz. Buning o\'rniga durangni maqsad qilib oling va o\'yinni yutqazmang. Raqibingizni kuzatib boring va ularni xato qilishlari mumkin bo\'lgan joyga muloyimlik bilan jalb qiling. Ular kuchsizligini ko\'rsatsa, imkoniyatdan foydalaning va g\'alaba uchun muloyimlik bilan turting. Shu tarzda siz o\'yinda g\'alaba qozonishingiz mumkin.';

  @override
  String get firstMoveDetail =>
      'Bu o\'yinda birinchi o\'yinchiga nisbatan ikkinchi o\'yinchining g\'alaba qozonishi osonroq.';

  @override
  String get passiveDetail =>
      'Passiv opsiyani yoqish AIni imkon qadar tezroq g\'alaba qozonishga agressiv harakat qilishdan ko\'ra, pozitsiyada ustunlikka ega bo\'lganda bo\'shashishiga olib keladi.';

  @override
  String get moveRandomlyDetail =>
      'Ushbu parametrni yoqish oʻyinning tasodifiyligi va qiziqarliligini oshiradi, uni oʻchirib qoʻyish esa AIni engish yoʻllarini oʻrganishga yordam beradi.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Agar sun\'iy intellekt o\'z donalarining harakatchanligini hisobga olsa, u nafaqat raqibning donalarini imkon qadar tezroq qo\'lga kiritishni maqsad qilib qo\'ymaydi, balki raqibning harakatlarini to\'sib qo\'yish va ularni xuddi shunday qilishiga yo\'l qo\'ymaslik haqida ham o\'ylaydi.';

  @override
  String get whenBoardIsFull => 'Doska to\'lganida';

  @override
  String get whenBoardIsFull_Detail =>
      'Joylashtirish bosqichining oxirida, harakatlanish bosqichi boshlanishidan oldin, taxta bo\'laklarga to\'la bo\'lsa, harakat quyidagicha bo\'ladi.';

  @override
  String get sideToMoveRemovePiece =>
      'Harakat bosqichida birinchi bo\'lib harakat qilgan o\'yinchi raqibning donalaridan birini olib tashlaydi.';

  @override
  String get agreeToDraw => 'Har ikki tomon durangga rozi.';

  @override
  String get takeOpponentsPiece => 'Raqibingizning donalaridan birini oling.';

  @override
  String get firstPlayerLose => 'Birinchi o\'yinchi o\'yinni yo\'qotadi.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Birinchi va ikkinchi o\'yinchilar raqibning donalaridan birini olib tashlashadi.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Ikkinchi va birinchi o\'yinchilar raqibning donalaridan birini olib tashlashadi.';

  @override
  String get enteredFlyingPhase =>
      'Endi uchish bosqichiga kirdi, raqibning donalari doskadagi istalgan bo\'sh nuqtaga sakrashi mumkin. \"Qoida sozlamalari\" da uchish qoidasini o\'chirib qo\'yishingiz mumkin.';

  @override
  String get whenStalemate => 'Turg\'unlashganda';

  @override
  String get whenStalemate_Detail =>
      'Hech qanday bo\'lakni ko\'chirish mumkin bo\'lmasa, qanday harakat bajariladi?';

  @override
  String get endWithStalemateLoss => 'Turg\'un yo\'qotish bilan yakunlang.';

  @override
  String get changeSideToMove => 'Harakat qilish uchun tomonni o\'zgartiring.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Raqibning donalaridan birini olib tashlang va keyingi harakatni bajaring.';

  @override
  String get endWithStalemateDraw => 'Durang durang bilan yakunlang.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Raqibning donalaridan birini olib tashlang va harakat qilish uchun tomonni o\'zgartiring.';

  @override
  String get aiResponseDelayTime => 'AI javobni kechiktirish vaqti';

  @override
  String get aiIsDelaying =>
      'AI hozirda kechiktirilgan javob bosqichida. Davom etishdan oldin biroz kuting.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Siz qo\'shni bo\'lmagan qismni olib tashlay olmaysiz.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Agar turg\'un bo\'lsa, tegirmon shakllanishidan qat\'i nazar, raqibning sizning yoningizda joylashgan donalarini olib tashlash mumkin.';

  @override
  String get whatIsMcts =>
      'MCTS - bu yangi boshlanuvchilar uchun qulay algoritm bo\'lib, u simulyatsiyalar orqali turli harakatlarni o\'rganish va baholash orqali qaror qabul qiladi.';

  @override
  String get goldenJade => 'Oltin Jade';

  @override
  String get forestWood => 'O\'rmon yog\'ochi';

  @override
  String get darkMystery => 'Qorong\'u sir';

  @override
  String get midnightBlue => 'Yarim tun moviy';

  @override
  String get greenForest => 'Yashil o\'rmon';

  @override
  String get greenMeadow => 'Yashil o\'tloq';

  @override
  String get stonyPath => 'Toshli yo\'l';

  @override
  String get pastelPink => 'Pastel pushti';

  @override
  String get turquoiseSea => 'Turkuaz dengiz';

  @override
  String get violetDream => 'Binafsha tush';

  @override
  String get mintChocolate => 'Yalpizli shokolad';

  @override
  String get skyBlue => 'Moviy osmon';

  @override
  String get playfulGarden => 'O\'yin bog\'i';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Retrograd tahlil algoritmi turli boshlang\'ich pozitsiyalardan o\'yin oxiri ma\'lumotlar bazasini yaratish uchun ko\'p qiymatli retrograd tahlildan foydalanadi, so\'ngra o\'yinni optimallashtirish uchun ushbu ma\'lumotlar bazasini qo\'llaydi. Ushbu yondashuv Ultra-kuchli yechimlar toifasiga kiradi.';

  @override
  String get viewAlgorithmGuide =>
      'Ushbu algoritm uchun foydalanuvchi qo\'llanmasini ko\'rishni xohlaysizmi?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Pozitsiyaviy ustunlik ko\'rsatkichini ko\'rsatish';

  @override
  String get usePerfectDatabase =>
      'Mukammal ma\'lumotlar bazasidan foydalaning';

  @override
  String get perfectDatabaseDescription =>
      'Eng zamonaviy algoritmlar orqali yaratilgan benuqson oʻyin maʼlumotlar bazasidan foydalanish uchun ushbu parametrni yoqing. Bu xususiyat optimal harakatlarni taklif qilish uchun ochilish va yakuniy strategiyalarni birlashtiradi. Bu o\'yinda eng yuqori darajadagi aniqlikka intiladigan o\'yinchilar uchun afzal qilingan tanlovdir. Puxta hisoblash texnikasi orqali yaratilgan ma\'lumotlar bazasi deyarli mukammal o\'yin echimlarini taklif qilish uchun mo\'ljallangan.\n\nEslatma: Agar AI ma\'lumotlar bazasiga kira olmasa, u o\'yin qarorlari uchun an\'anaviy algoritmlarga murojaat qiladi. Ma\'lumotlar bazasi mavjud bo\'lganda, \"Qiyinchilik darajasi\" deyarli engib bo\'lmaydigan bo\'lib qoladi va \"AI fikrlash vaqti\" keskin qisqaradi. \"AI\'s play style\" opsiyalaridagi ko\'plab sozlamalar bekor qilinadi, chunki ma\'lumotlar bazasi natijalari eng yuqori ustuvorlikka ega.\n\nUshbu mukammal ma\'lumotlar bazasidan qanday foydalanish bo\'yicha ko\'rsatmalar uchun bu yerni bosing.';

  @override
  String get backgroundImage => 'Orqa fon rasmi';

  @override
  String get whatIsRandom =>
      '\"Mukammal ma\'lumotlar bazasidan foydalanish\" opsiyasi yoqilmagan bo\'lsa, \"Tasodifiy\" sozlamasi sun\'iy intellektni harakatni tanlash uchun hech qanday algoritmdan foydalanmasdan qismlarni tasodifiy ko\'chirishga olib keladi. Bu, odatda, sezilarli darajada zaif o\'yinga olib keladi. Aksincha, “Mukammal ma’lumotlar bazasidan foydalanish” yoqilganda, sun’iy intellekt qarorlar qabul qilish uchun uni an’anaviy AI algoritmlari bilan birlashtirish o‘rniga faqat “Mukammal ma’lumotlar bazasi”ga tayanadi. Ushbu rejimda sun\'iy intellektning harakatlari real vaqtda hisob-kitoblar yoki qidiruv algoritmlariga tayanishdan qochib, to\'liq ma\'lumotlar bazasi tarkibiga asoslanadi.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Raqibning donasini(donalarini) qo\'lidan olib tashlang; keyin navbat raqibga donani joylash uchun beriladi.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Joylashtirish fazasida tegirmonlarni shakllantirishda';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Raqibning donasini(donalarini) taxtadan olib tashlang.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Raqibning donasini(donalarini) taxtadan olib tashlang; keyin navbat raqibga donani joylash uchun beriladi.';

  @override
  String get opponentRemovesOwnPiece =>
      'Raqib o\'z donasini (donalarini) taxtadan olib tashlaydi.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Siz harakat qilish o\'rniga, raqib o\'z donasini (donalarini) taxtadan tanlaydi va olib tashlaydi, bu o\'ziga zarar yetkazuvchi harakat.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Raqibning donasini(donalarini) qo\'lidan olib tashlang; keyin navbat sizga harakatni amalga oshirish uchun beriladi.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Raqibning qo\'lidan dona(donalar)ni olib tashlang. Agar ko\'p dona olib tashlash sozlamasiga ko\'ra, bir nechta dona olib tashlanishi kerak bo\'lsa va raqibning qo\'lida dona qolmasa, raqibning donalarini taxtadan olib tashlashni davom ettiring. Keyin, harakat qilish navbati sizga beriladi. Agar siz tegirmonlarni hosil qilishni davom ettirsangiz, raqibning donalarini olib tashlashingiz mumkin.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Raqibning qo\'lidan dona(donalar)ni olib tashlang. Agar ko\'p dona olib tashlash sozlamasiga ko\'ra, bir nechta dona olib tashlanishi kerak bo\'lsa va raqibning qo\'lida dona qolmasa, raqibning donalarini taxtadan olib tashlashni davom ettiring. Keyin, navbat raqibga harakatni amalga oshirish uchun beriladi.';

  @override
  String get markAndDelayRemovingPieces =>
      'Donalarni olib tashlashni belgilang va kechiktiring.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Joylashtirish bosqichida olib tashlanadigan donalar belgilanadi va ikkala o\'yinchi uchun ham ushbu nuqtalarga yangi donalarni joylashtirish mumkin emas. Harakatlanish bosqichiga kirgandan so\'ng, bu belgilangan donalar butunlay olib tashlanadi va o\'yinchilar o\'z donalarini bu bo\'sh joylarga ko\'chira oladilar.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Joylashtirish bosqichida tegirmonlar shakllantirilganda amalga oshirilishi mumkin bo‘lgan harakatlar.';

  @override
  String get marked => 'Белгиланган';

  @override
  String get menu => 'Menyu';

  @override
  String get monochrome => 'Monoxrom';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Siz Umumiy sozlamalar ichidagi Yordamchi vositalar sozlamalarida ekran o\'quvchisi yordamini yoqishingiz mumkin.';

  @override
  String get showNumbersOnPieces => 'Dasturxonlarda raqamlarni ko\'rsatish';

  @override
  String get saveImage => 'Rasmni saqlash';

  @override
  String get isAnalysisToolbarShown => 'Tahlil vositasi panelini ko\'rsating';

  @override
  String get analysisToolbarBackgroundColor =>
      'Tahlil vositasi panelining orqa fon rangi';

  @override
  String get analysisToolbarIconColor =>
      'Tahlil vositasi panelining ikon rangi';

  @override
  String get transformed => 'O\'zgartirildi.';

  @override
  String get cannotTransform => 'O\'zgartirib bo\'lmaydi.';

  @override
  String get rotate => 'Aylantirish';

  @override
  String get horizontalFlip => 'Gor. ayl.';

  @override
  String get verticalFlip => 'Tik ayl.';

  @override
  String get innerOuterFlip => 'I/T Ayl.';

  @override
  String get transparentCanvas => 'Shaffof Kanvas';

  @override
  String get restrictRepeatedMillsFormation =>
      'Qayta-qayta Tegirmon Shakllanishini Cheklash';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Bir tegirmondan boshqasiga ko\'chirilgan dona navbatdagi navbatda darhol asl nuqtasiga qaytib, yana tegirmon hosil qila olmaydi. Avval boshqa harakat talab etiladi.';

  @override
  String get oneTimeUseMill => 'Bir martalik ishlatiladigan tegirmon';

  @override
  String get oneTimeUseMill_Detail =>
      'Har bir tegirmon raqibning qismini faqat bir marta olib tashlashi mumkin. Siz uni qayta yaratishingiz mumkin, lekin qo\'shimcha olib tashlashlar uchun foydalanish mumkin emas.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Siz o\'rnatgan joriy qoidalar mos keladigan mukammal ma\'lumotlar bazasiga ega emas. Mukammal ma\'lumotlar bazasi haqida ko\'proq ma\'lumot olish uchun bu yerni bosing.';

  @override
  String get focusOnBlockingPaths =>
      'To\'siq yo\'llarni bloklashga e\'tibor qarating';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Tegirmonlarni shakllantirish o\'rniga raqibning harakatlarini to\'sishga ustunlik bering. Tegirmonlarni to\'ldirish orqali bo\'laklarni olib tashlashga e\'tibor qaratish o\'rniga, AI raqibni tuzoqqa tushirishga, ularni harakatsiz qilishga va tajovuzkor o\'yin o\'rniga charchash orqali g\'alabani ta\'minlashga harakat qiladi. Ushbu strategiya raqibning tegirmonlarini faol ravishda bloklamaydi.';

  @override
  String get pieceImage => 'Shaxmat rasmi';

  @override
  String get importColorSettings => 'Rang sozlamalarini import qilish';

  @override
  String get exportColorSettings => 'Rang sozlamalarini eksport qilish';

  @override
  String get import => 'Import qilish';

  @override
  String get export => 'Eksport qilish';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Iltimos, birinchi navbatda JSON formatidagi sozlamalarni buferga nusxalab oling.';

  @override
  String get copiedToClipboard => 'Buferga nusxalandi.';

  @override
  String get imported => 'Import qilindi.';

  @override
  String get boardImage => 'Taxta tasviri';

  @override
  String get autumnLeaves => 'Kuz yaproqlari';

  @override
  String get legendaryLand => 'Afsonaviy Mamlakat';

  @override
  String get vignetteEffect => 'Vinyet effekti';

  @override
  String get promptMakeToolbarTransparent =>
      'Taxta fon rasmi belgilanganida asboblar panelini butunlay shaffof qilishni xohlaysizmi?';

  @override
  String get vibration => 'O\'yinda vibratsiyani yoqing';

  @override
  String get soundTheme => 'Ovoz mavzusi';

  @override
  String get ball => 'To\'p';

  @override
  String get liquid => 'Suyuqlik';

  @override
  String get wood => 'Yog\'och';

  @override
  String get placeEffectAnimation =>
      'Figurani joylashtirish animatsion effekti';

  @override
  String get removeEffectAnimation =>
      'Figurani olib tashlash animatsion effekti';

  @override
  String get isToolbarAtBottom => 'Asboblar panelini pastda ko\'rsatish';

  @override
  String get boardCornerRadius => 'Taxta burchak radiusi';

  @override
  String get useOpeningBook => 'Ochiq kitobdan foydalaning';

  @override
  String get currentRule => 'Hozirgi';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Qoidalar to\'plami';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'AI-dan o\'yinning dastlabki bosqichida professional inson o\'yinchilari tomonidan tez-tez ishlatiladigan ochish harakatlaridan foydalanishiga ruxsat bering. Eslatma: Ushbu xususiyat hozircha faqat ma\'lum qoida to\'plamlari uchun mavjud.';

  @override
  String get showAdvantageGraph => 'Afzallik grafikini ko‘rsatish';

  @override
  String get advantageGraphHint =>
      'Afzallik grafigi faqat sun’iy intellekt yurish qilgandan keyin chiziladi. Inson o‘yinchisi yurish qilganda chizilmaydi.';

  @override
  String get removalBasedOnMillCounts =>
      'Barcha toshlar joylashtirilgunga qadar olib tashlashni oʻchirib qoʻying. Oʻyinchilar tegirmonlar soniga qarab toshlarni olib tashlaydilar.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Barcha toshlar joylashtirilgunga qadar olib tashlashni oʻchirib qoʻying. Oʻyinchilar tegirmonlar soniga qarab toshlarni olib tashlaydilar: agar teng bo‘lsa, har ikkisi ham bir xil miqdorda tosh olib tashlaydi; agar bittada ko‘proq bo‘lsa, u bitta qo‘shimcha tosh olib tashlab, bitta tosh farqini saqlab turadi. Agar faqat bitta oʻyinchi tegirmon tuzsa, u ikki toshni olib tashlaydi, ikkinchisi esa bitta toshni olib tashlaydi. Agar hech kim tegirmon tuzmasa, har ikkisi bitta toshdan olib tashlaydi.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Doskadagi figuralaringizdan birini tanlang.';

  @override
  String get notYourTurn => 'Sizning navbingiz emas.';

  @override
  String get annotationToolbarBackgroundColor => 'Izoh panelining fon rangi';

  @override
  String get annotationToolbarIconColor => 'Izoh panelining ikon rangi';

  @override
  String get isAnnotationToolbarShown => 'Izoh panelini ko\'rsatish';

  @override
  String get enterAnnotationMode => 'Izoh rejimiga o\'tish';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Barcha izohlarni o\'chirishni xohlaysizmi?';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM so\'rovi clipbordga nusxalandi.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Ulanish rad etildi, server ishlamayapti bo\'lishi mumkin.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Qidiruv muvaffaqiyatli yakunlandi, ulanishingizni kutmoqda...';

  @override
  String get noLanConnection => 'LAN ulanishi mavjud emas.';

  @override
  String get takeScreenshot => 'Skrinshot oling';

  @override
  String get disconnectedFromOpponent => 'Raqib bilan aloqa uzildi.';

  @override
  String get takeBackRequest => 'Orqaga qaytarish so\'rovi';

  @override
  String get nothingToShow => 'Ko\'rsatish uchun hech narsa yo\'q.';

  @override
  String get stopHosting => 'Xostingni to\'xtatish';

  @override
  String get connectionResetByPeer =>
      'Ulanish qarshi tomon tomonidan qayta o\'rnatildi.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Heartbeat muddati tugashi sababli aloqa uzildi. Iltimos, qayta ulang.';

  @override
  String get startHosting => 'Xostingni boshlash';

  @override
  String get restartRequestRejected =>
      'Qayta ishga tushirish so\'rovi rad etildi.';

  @override
  String get notConnectedToLanOpponent => 'LAN raqibi bilan ulanmagan.';

  @override
  String get llmPrompt => 'LLM so\'rovi';

  @override
  String get gameRestarted => 'O\'yin qayta boshlandi.';

  @override
  String get takeBackRejected => 'Qaytarish rad etildi.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Ushbu o\'yindan chekinishni xohlaysizmi?';

  @override
  String get opponentResignedYouWin =>
      'Raqib chekinib ketdi. Siz g\'alaba qozondingiz!';

  @override
  String get clearAllAnnotations => 'Barcha izohlarni o\'chirish';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Ulandi, raqib harakatini kutmoqda...';

  @override
  String get networkStatusDisconnected => 'Tarmoq holati: Ulanmagan';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Qaytarish so\'rovi raqibga yuborildi.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Raqib o\'yindan chiqib ketgan bo\'lishi mumkin.';

  @override
  String get connectedToHostSuccessfully => 'Xostga muvaffaqiyatli ulandi.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Aloqa uzildi: heartbeat muddati tugadi.';

  @override
  String get noHostDiscovered => 'Xost topilmadi.';

  @override
  String get confirmResignation => 'Chekinishni tasdiqlang';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'O\'yin xost qilinmoqda, o\'yinchilar qo\'shilishini kutmoqda...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Ulanish muddati tugadi, tarmoq ulanishi barqaror emas.';

  @override
  String get noLlmPromptAvailable => 'LLM so\'rovi mavjud emas.';

  @override
  String get youResignedGameOver => 'Siz chekinib ketdingiz. O\'yin tugadi.';

  @override
  String get serverIp => 'Server IP';

  @override
  String get confirmClear => 'Tozalashni tasdiqlang';

  @override
  String get opponentSTurn => 'Raqibning navbasi.';

  @override
  String get waitingAClientConnection => 'Klient ulanishini kutmoqda...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Qaytarish so\'rovi rad etildi yoki muvaffaqiyatsiz tugadi.';

  @override
  String get addText => 'Matn qo\'shish';

  @override
  String get exitAnnotationMode => 'Izoh rejimidan chiqish';

  @override
  String get typeYourAnnotation => 'Izohingizni yozing';

  @override
  String get attemptingToReconnect => 'Qayta ulanishga harakat qilinmoqda...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Qayta ishga tushirish so\'rovi yuborildi. Raqib javobini kutmoqda...';

  @override
  String get serverIsStopped => 'Server to\'xtatildi.';

  @override
  String get restartRequest => 'Qayta ishga tushirish so\'rovi';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Sizning navbingiz bo\'lmaganda qaytarish so\'rovini yuborib bo\'lmaydi.';

  @override
  String get takeBackAccepted => 'Qaytarish qabul qilindi.';

  @override
  String get localNetworkSettings => 'Mahalliy tarmoq sozlamalari';

  @override
  String get reconnectedSuccessfully =>
      'Qayta ulanish muvaffaqiyatli amalga oshirildi!';

  @override
  String get failedToSaveImageToGallery => 'Rasm galereyaga saqlanmadi.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Raqib o\'yinni qayta boshlashni so\'radi. Qabul qilasizmi?';

  @override
  String get yourTurn => 'Sizning navbingiz.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Qayta ulanib bo\'lmadi, iltimos, o\'yinni qayta boshlang.';

  @override
  String get host => 'Xost';

  @override
  String get join => 'Qo\'shilish';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'Noto\'g\'ri IP manzili.';

  @override
  String get invalidPort => 'Noto\'g\'ri port.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Ulanish: $attempt/$maxAttempt urinish';
  }

  @override
  String failedToConnect(Object error) {
    return 'Ulanish amalga oshmadi: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Xostingni boshlash muvaffaqiyatsiz tugadi: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Xost topildi: $ip:$port';
  }

  @override
  String get stop => 'To\'xtatish';

  @override
  String get discover => 'Aniqlash';

  @override
  String get connect => 'Ulanish';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Klient ulandi: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Aniqlanmoqda: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Qayta ulanmoqda ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Ulandi';

  @override
  String get delete => 'O\'chirish';

  @override
  String get ancientEgypt => 'Qadimgi Misr';

  @override
  String get gothicIce => 'Gotik Muz';

  @override
  String get riceField => 'Sholi Dalasi';

  @override
  String get chinesePorcelain => 'Xitoy Porcelani';

  @override
  String get desertDusk => 'Cho\'l Tonggi';

  @override
  String get precisionCraft => 'Aniq Hunarmandchilik';

  @override
  String get folkEmbroidery => 'Xalq Kashtachilik';

  @override
  String get carpathianHeritage => 'Karpat Merosi';

  @override
  String get imperialGrandeur => 'Imperatorlik Ulug\'vorlik';

  @override
  String get bohemianCrystal => 'Bohem Kristali';

  @override
  String get savannaSunrise => 'Savanna Quyosh Chiqishi';

  @override
  String get harmonyBalance => 'Garmoniya va Muvozanat';

  @override
  String get cinnamonSpice => 'Dolchin Ziravori';

  @override
  String get anatolianMosaic => 'Anatoliya Mozaikasi';

  @override
  String get carnivalSpirit => 'Karnaval Ruhi';

  @override
  String get custom => 'Odat';

  @override
  String get spiceMarket => 'Ziravorlar bozori';

  @override
  String get swipeToRevealTheDrawer => 'Tortmani ko‘rsatish uchun suring';

  @override
  String get showGameInfoOnScreenshots =>
      'O‘yin ma\'lumotlarini skrinshotlarda ko‘rsatish';

  @override
  String get humanMoveTime => 'Inson uchun vaqt chegarasi';

  @override
  String get noTimeLimitForHumanMoves =>
      'Inson harakatlari uchun vaqt chegarasi yo\'q';

  @override
  String get timeoutLoseWillBeApplied =>
      'Inson o\'yinchi uchun vaqt tugashi sababli mag\'lubiyat qo\'llaniladi';

  @override
  String get identifyingBoard => 'O\'yin taxtasi aniqlanmoqda...';

  @override
  String get youCanEnterAnyModelName =>
      'Istalgan model nomini kiritishingiz mumkin.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Taxta holati qo\'llandi. FEN clipboard-ga nusxalandi.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Tavsiya: taxtaning aniqroq suratini olishga harakat qiling.';

  @override
  String get llmPromptTemplate => 'LLM prompt shabloni';

  @override
  String get noValidBoardDetected => 'Hech qanday yaroqli taxta aniqlanmadi.';

  @override
  String get selectingImageFromAlbum => 'Albumdan rasm tanlanmoqda...';

  @override
  String get configurePromptTemplate => 'Prompt shablonini sozlash';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'LLM tahlili uchun prompt shablonini tahrirlash';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Aniqlangan taxtadan FEN hosil qilish amalga oshmadi.';

  @override
  String get outputInCurrentLanguage => 'Joriy tilga chiqish';

  @override
  String get commonBaseUrls => 'Ommabop Base URL-lar';

  @override
  String get viewCommonModels => 'Ommabop modellarga qarash';

  @override
  String get recognitionParametersUpdated => 'Aniqlash parametrlar yangilandi.';

  @override
  String get whiteSMove => 'Oq yurishi';

  @override
  String get resetToDefaults => 'Standart sozlamalarga qaytarish';

  @override
  String get photoShoot => 'Rasm olish';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Aniqlangan taxta holatini qo\'llash muvaffaqiyatsiz tugadi.';

  @override
  String get llmPromptContent => 'LLM prompt mazmuni';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM sozlanmagan. Iltimos, sozlamalarni tekshiring.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Provider, model, API Key va Base URL ni o\'rnating';

  @override
  String get llmConfiguration => 'LLM sozlamalari';

  @override
  String get configureLlmProvider => 'LLM provayderini sozlash';

  @override
  String get llmPromptTemplateHeader => 'LLM prompt shabloni sarlavhasi';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Rasmda hech qanday figuralar aniqlanmadi. Iltimos, qayta urinib ko\'ring.';

  @override
  String get recognizeBoardFromImage => 'Rasmdan taxtani aniqlash';

  @override
  String get viewTips => 'Maslahatlarni ko\'rish';

  @override
  String get applyToBoard => 'Taxtaga qo\'llash';

  @override
  String get adjustBoardArea => 'Taxta hududini sozlash';

  @override
  String get viewCommonUrls => 'Ommabop URL-larni ko\'rish';

  @override
  String get colorAnalysisFailed => 'Rang tahlili muvaffaqiyatsiz tugadi!';

  @override
  String get analyzingGameBoardImage =>
      'O\'yin taxtasi rasmini tahlil qilish...';

  @override
  String get selectFromAlbum => 'Albumdan tanlash';

  @override
  String get noBoardPointDetected => 'Hech qanday taxta nuqtasi aniqlanmadi!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Bo\'sh qoldirilsa, standart shablon ishlatiladi';

  @override
  String get llmConfig => 'LLM sozlamalari';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Siz prompt shablonlarini standart qiymatlarga qaytarishni istaysizmi?';

  @override
  String get llmPromptTemplateFooter => 'LLM prompt shabloni pastki qismi';

  @override
  String get loadingResponse => 'Javob yuklanmoqda...';

  @override
  String get applyThisResultToBoard => 'Ushbu natijani taxtaga qo\'llash';

  @override
  String get takingPicture => 'Rasm olinmoqda...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Iltimos, aniqlash uchun o\'yin taxtasi rasmini tanlang';

  @override
  String get identificationResults => 'Aniqlash natijalari';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Yurishlarni tahlil qiling va mulohazalar bering.';

  @override
  String get getApiKey => 'API Key olish';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Butun aniqlash jarayoni muvaffaqiyatsiz yakunlandi.';

  @override
  String get boardRecognitionResult => 'Taxta aniqlash natijasi';

  @override
  String get askLlm => 'LLM ga so\'rang';

  @override
  String get boardDetectionFailed => 'Taxta aniqlash muvaffaqiyatsiz!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Hech qanday taxta nuqtasi aniqlanmadi, figuralarni aniqlab bo\'lmadi!';

  @override
  String get copyFen => 'FEN ni nusxalash';

  @override
  String get commonlyUsedModels => 'Ko\'p ishlatiladigan modellar';

  @override
  String get apiKeyOptional => 'API Key (ixtiyoriy)';

  @override
  String get noImageSelected => 'Hech qanday rasm tanlanmadi';

  @override
  String get blackSMove => 'Qora yurishi';

  @override
  String get llm => 'Katta Til Modeli';

  @override
  String get llmProvider => 'Provayder';

  @override
  String get baseUrl => 'Asosiy URL';

  @override
  String get model => 'Model';

  @override
  String get temperature => 'Harorat';

  @override
  String get llmCommandReceivedProcessing =>
      'Buyruq qabul qilindi! AI qayta ishlamoqda...';

  @override
  String get llmDeepThinkingWait =>
      'Chuqur o\'ylash jarayonda, iltimos kuting...';

  @override
  String get llmPresentingSoon => 'Tez orada taqdim etiladi...';

  @override
  String get recognitionParameters => 'Taniqlik parametrlari';

  @override
  String get adjustParamsDesc =>
      'Aniqlikni oshirish uchun parametrlarga tuzatish kiriting';

  @override
  String get saveParameters => 'Parametrlarni saqlash';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Rasmni aniqlashni boshlab boʻlmadi: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Rasmni aniqlash muvaffaqiyatsiz: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Qoʻllanilgan holat: oq $whiteCount ta va qora $blackCount ta tosh';
  }

  @override
  String get fenCopiedToClipboard => '(FEN buferga nusxa olindi)';

  @override
  String recognitionFailed(String error) {
    return 'Tanish muvaffaqiyatsiz: $error';
  }

  @override
  String get myRating => 'Mening reytingim';

  @override
  String get gamesPlayed => 'O\'ynalgan o\'yinlar';

  @override
  String get wins => 'G\'alabalar';

  @override
  String get losses => 'Mag\'lubiyatlar';

  @override
  String get draws => 'Duranglar';

  @override
  String get lastUpdated => 'Oxirgi yangilanish';

  @override
  String get format => 'Format:';

  @override
  String get resetStatistics => 'Statistikani tiklash';

  @override
  String get drawRate => 'Duranglar nisbati';

  @override
  String get lossRate => 'Mag\'lubiyatlar nisbati';

  @override
  String get aiStatistics => 'Sun\'iy intellekt statistikasi';

  @override
  String get enableStatistics => 'Statistikani yoqish';

  @override
  String get enableStatistics_Detail =>
      'Yoqilganda, o\'yin natijalari statistikada qayd etiladi. Biroq, orqaga qaytarishlar bilan bog\'liq o\'yinlar qayd etilmaydi. O\'chirilganda, statistika yig\'ish to\'xtatiladi.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Bu barcha o\'yin statistikasini tiklaydi. Bu amalni bekor qilib bo\'lmaydi.';

  @override
  String get boardInnerRingSize => 'Taxtaning ichki halqa o\'lchami';

  @override
  String get boardShadowEnabled => 'Taxta soyasi';

  @override
  String get trapAwareness => 'Tuzoqni aniqlash';

  @override
  String get trapAwarenessDescription =>
      'Tahlil vaqtida tuzoq yurishlarini qalin doiralar va o‘qlar bilan ajratib ko‘rsating.';

  @override
  String trapExists(String trapMoves) {
    return 'Tuzoq mavjud. Tuzoq yurishlari: $trapMoves';
  }

  @override
  String get custodianCapture => 'Qanotli ushlash';

  @override
  String get custodianCaptureDescription =>
      'Raqibning ikkitasi orasidagi bittasini to\'g\'ri chiziqda ushlang.';

  @override
  String get custodianCaptureEnable => 'Flankingga ruxsat bering';

  @override
  String get interventionCapture => 'Aralashish';

  @override
  String get interventionCaptureDescription =>
      'Ikkala raqibingizning ikkitasi orasidagi bo\'sh joyga o\'ting.';

  @override
  String get interventionCaptureEnable => 'Aralashuvni ushlashga ruxsat berish';

  @override
  String get leapCapture => 'Sakrash';

  @override
  String get leapCaptureDescription =>
      'Qo\'shni raqibning parchasini bo\'sh joyga sakrash orqali ushlang.';

  @override
  String get leapCaptureEnable => 'Sakrashga ruxsat berish';

  @override
  String get captureApplicableLines => 'Qo\'llaniladigan chiziqlar';

  @override
  String get captureSquareEdges => 'Maydon qirralari bo\'ylab';

  @override
  String get captureCrossLines =>
      'Maydonni kesib o\'tish ortogonal chiziqlari bo\'ylab';

  @override
  String get captureDiagonalLines =>
      'Diagonal chiziqlar maydonni kesib o\'tish';

  @override
  String get captureExecutionPhases => 'Bajarish bosqichlari';

  @override
  String get capturePiecesCondition =>
      'Qolgan bo\'laklarga asoslangan harakatlanayotgan davrda mavjudlik';

  @override
  String get capturePiecesConditionUnlimited => 'Hech qanday cheklov yo\'q';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Uch yoki undan kam bo\'lganda mavjud';
}
