// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Urdu (`ur`).
class SUr extends S {
  SUr([String locale = 'ur']) : super(locale);

  @override
  String get appName => 'نو گوٹی';

  @override
  String get welcome => 'خوش آمدید';

  @override
  String get yes => 'جی ہاں';

  @override
  String get no => 'نہیں';

  @override
  String get game => 'کھیل';

  @override
  String get humanVsAi => 'انسانی بمقابلہ اے آئی';

  @override
  String get humanVsHuman => 'انسانی بمقابلہ انسان';

  @override
  String get aiVsAi => 'اے آئی بمقابلہ اے آئی';

  @override
  String get humanVsCloud => 'انسانی بمقابلہ بادل';

  @override
  String get humanVsLAN => 'انسانی بمقابلہ LAN';

  @override
  String get testViaLAN => 'LAN کے ذریعے ٹیسٹ کریں۔';

  @override
  String get move => 'اقدام';

  @override
  String get showMoveList => 'فہرست منتقل کریں۔';

  @override
  String get moveList => 'فہرست منتقل کریں۔';

  @override
  String get noGameRecord => 'کوئی ریکارڈ نہیں';

  @override
  String get ok => 'ٹھیک ہے';

  @override
  String get confirm => 'تصدیق کریں۔';

  @override
  String get cancel => 'منسوخ کریں۔';

  @override
  String get tipSelectWrong => 'غلط ٹکڑا منتخب کریں۔';

  @override
  String get tipPlace => 'اپنے ٹکڑے رکھیں۔';

  @override
  String get tipBanPlace => 'آپ اسے یہاں نہیں رکھ سکتے۔';

  @override
  String get tipPlaced => 'آپ نے رکھا۔';

  @override
  String get tipRemove => 'ایک ٹکڑا ہٹا دیں۔';

  @override
  String get tipBanRemove => 'آپ اسے ہٹا نہیں سکتے۔';

  @override
  String get tipRemoved => 'آپ نے ہٹا دیا۔';

  @override
  String get tipMove => 'ایک ٹکڑا منتقل کریں۔';

  @override
  String get tipCannotPlace => 'آپ اپنا ٹکڑا یہاں نہیں رکھ سکتے۔';

  @override
  String get tipCannotMove => 'آپ اپنا ٹکڑا یہاں منتقل نہیں کر سکتے۔';

  @override
  String get tipMill => 'چکی! اپنے مخالف کا ٹکڑا لے لو۔';

  @override
  String get tipContinueMill => 'اپنے مخالف کا ٹکڑا لینا جاری رکھیں۔';

  @override
  String get tipSelectOpponentsPiece =>
      'اپنے مخالف کے ٹکڑوں میں سے ایک کو منتخب کریں۔';

  @override
  String get tipCannotRemovePieceFromMill =>
      'آپ مل سے ایک ٹکڑا نہیں نکال سکتے۔';

  @override
  String get tipCanMoveOnePoint => 'ایک ٹکڑا 1 پوائنٹ منتقل کر سکتا ہے۔';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'آپ اپنے مخالف کے ٹکڑے نہیں ہلا سکتے۔';

  @override
  String get tipSelectPieceToMove => 'منتقل کرنے کے لیے اپنا ٹکڑا منتخب کریں۔';

  @override
  String get tipHaveThreePiecesLeft => 'آپ کے پاس تین ٹکڑے باقی ہیں۔';

  @override
  String get tipCanMoveToAnyPoint =>
      'آپ اپنی پسند کے کسی بھی مقام پر جا سکتے ہیں۔';

  @override
  String tipToMove(Object player) {
    return 'منتقل کرنے کے لیے $player۔';
  }

  @override
  String get whiteWin => 'پلیئر 1 جیت گیا!';

  @override
  String get blackWin => 'پلیئر 2 جیت گیا!';

  @override
  String get won => 'جیت گیا۔';

  @override
  String get lost => 'کھو دیا';

  @override
  String get thinking => 'سوچنا…';

  @override
  String get newGame => 'نیا کھیل';

  @override
  String get importGame => 'کھیل درآمد کریں۔';

  @override
  String get exportGame => 'کھیل برآمد کریں۔';

  @override
  String get gameImported => 'گیم امپورٹڈ۔';

  @override
  String cannotImport(Object invalidMove) {
    return 'درآمد نہیں کیا جا سکتا $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'چالیں اور اصول آپس میں نہیں ملتے۔';

  @override
  String get pleaseWait => 'برائے مہربانی انتظار کریں.';

  @override
  String get restartGame => 'موجودہ گیم کو دوبارہ شروع کریں؟';

  @override
  String get restart => 'دوبارہ شروع کریں';

  @override
  String get gameStarted => 'کھیل شروع ہو گیا، پلیز لگائیں۔';

  @override
  String get analyzing => 'تجزیہ کیا جا رہا ہے…';

  @override
  String error(Object message) {
    return 'خرابی: $message';
  }

  @override
  String get winRate => 'جیت کی شرح';

  @override
  String get score => 'سکور:';

  @override
  String get white => 'کھلاڑی 1';

  @override
  String get black => 'کھلاڑی 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player ٹکڑوں کی تعداد تین سے کم ہے۔';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player نے استعفیٰ دے دیا۔';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player جانے کا کوئی راستہ نہیں ہے۔';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'بورڈ بھرا ہوا ہے، اور $player جانے کا کوئی راستہ نہیں ہے۔';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'وقت ختم ہو گیا، $player کھو گیا۔';
  }

  @override
  String get drawReasonRule50 =>
      'متحرک مرحلے میں، آخری مخصوص تعداد میں چالوں میں کوئی ٹکڑا نہیں ہٹایا گیا ہے۔';

  @override
  String get drawReasonBoardIsFull => 'یہ ڈرا ہے کیونکہ بورڈ بھرا ہوا ہے۔';

  @override
  String get drawReasonThreefoldRepetition =>
      'یہ تین گنا تکرار کی وجہ سے ڈرا ہے۔';

  @override
  String get gameOverUnknownReason => 'کھیل ختم! نامعلوم وجہ۔';

  @override
  String get gameOver => 'کھیل ختم';

  @override
  String get youWin => 'تم جیت گئے! مبارک ہو!';

  @override
  String challengeHarderLevel(int level) {
    return 'کیا مشکل سطح کا مقابلہ کریں؟ نیا سطح $level ہو گا!';
  }

  @override
  String get youLose => 'آپ ہار گئے!';

  @override
  String get analyze => 'تجزیہ کریں۔';

  @override
  String get about => 'کے بارے میں';

  @override
  String version(Object versionNumber) {
    return 'ورژن: $versionNumber';
  }

  @override
  String get thanks => 'شکریہ';

  @override
  String get settings => 'ترتیبات';

  @override
  String get options => 'اختیارات';

  @override
  String get generalSettings => 'عام ترتیبات';

  @override
  String get skillLevel => 'مشکل کی سطح';

  @override
  String get moveTime => 'AI سوچنے کا وقت';

  @override
  String get difficulty => 'مشکل';

  @override
  String get playSounds => 'صوتی اثرات';

  @override
  String get playSoundsInTheGame => 'کھیل میں آوازیں چلائیں۔';

  @override
  String get keepMuteWhenTakingBack => 'واپس لیتے وقت خاموش رہیں';

  @override
  String get tone => 'لہجہ';

  @override
  String get whoMovesFirst => 'پہلا اقدام';

  @override
  String get human => 'انسان';

  @override
  String get ai => 'اے آئی';

  @override
  String get alternate => 'متبادل';

  @override
  String get isAutoRestart => 'گیم ختم ہونے پر گیم کو آٹو ری اسٹارٹ کریں۔';

  @override
  String get isAutoChangeFirstMove => 'آٹو تبدیلی پہلی حرکت';

  @override
  String get shufflingEnabled => 'بے ترتیب حرکت کریں۔';

  @override
  String get misc => 'متفرق';

  @override
  String get rules => 'قواعد';

  @override
  String get piecesCount => 'ہر کھلاڑی کے پاس ٹکڑوں کی تعداد';

  @override
  String get piecesCount_Detail => 'ہر کھلاڑی کے پاس کتنے ٹکڑے ہوتے ہیں؟';

  @override
  String get flyPieceCount => 'اڑنے والے ٹکڑے کی تعداد';

  @override
  String get flyPieceCount_Detail =>
      'اگر فلائنگ کو فعال کیا جاتا ہے، جب کسی کھلاڑی کو مخصوص ٹکڑوں کی گنتی تک کم کر دیا جاتا ہے، تو اس کے ٹکڑے باقی کھیل کی طرح ملحقہ پوائنٹس تک محدود رہنے کے بجائے کسی بھی غیر مقبوضہ مقام پر جانے کے لیے آزاد ہوتے ہیں۔';

  @override
  String get piecesAtLeastCount => 'کم از کم ٹکڑے';

  @override
  String get hasDiagonalLines => 'ترچھی لکیریں۔';

  @override
  String get hasDiagonalLines_Detail => 'بورڈ میں چار ترچھی لائنیں شامل کریں۔';

  @override
  String get isDefenderMoveFirst => 'دوسرا کھلاڑی پہلے چلتا ہے۔';

  @override
  String get isDefenderMoveFirst_Detail =>
      'پلیسنگ فیز میں دوسرے نمبر پر آنے والا کھلاڑی موونگ فیز میں پہلے آتا ہے۔';

  @override
  String get mayRemoveMultiple => 'کثیر ہٹانا';

  @override
  String get mayRemoveMultiple_Detail =>
      'اگر کوئی کھلاڑی ایک ساتھ ایک سے زیادہ ملوں کو بند کرتا ہے، تو وہ اپنی بند ہونے والی ملوں کی تعداد کو ہٹا دے گی۔';

  @override
  String get mayRemoveFromMillsAlways => 'ملوں کو تباہ کرنا';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'پہلے سے طے شدہ طور پر، کھلاڑیوں کو بنی چکی سے کسی ٹکڑے کو ہٹانے سے پہلے پہلے کسی دوسرے ٹکڑے کو ہٹانا چاہیے۔ حد کو غیر فعال کرنے کے لیے اس اختیار کو فعال کریں۔';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'دوسرا کھلاڑی ہار جاتا ہے جب بورڈ بھر جاتا ہے۔';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'جب پلیٹنگ کے مرحلے کے اختتام پر بورڈ بھر جاتا ہے، تو وہ طرف جو پہلے رکھتا ہے گیم ہار جاتا ہے۔ دوسری صورت میں، کھیل ایک ڈرا ہے.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'جب کوئی قانونی اقدام نہیں ہوتا تو ہار جاتے ہیں۔';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'کھلاڑی ہار جائے گا اگر اس کا مخالف انہیں روکتا ہے تاکہ وہ منتقل نہ ہوسکیں۔ اگر یہ اختیار غیر فعال ہے تو منتقل کرنے کے لیے سائیڈ کو تبدیل کریں۔';

  @override
  String get mayFly => 'پرواز';

  @override
  String get mayFly_Detail =>
      'اگر کسی کھلاڑی کے پاس صرف تین یا چار (کنفیگر کرنے کے قابل) ٹکڑے باقی ہیں، تو وہ اس ٹکڑے کو کسی بھی فری پوائنٹ پر لے جا سکتی ہے۔';

  @override
  String get nMoveRule => 'N- اقدام کا قاعدہ';

  @override
  String get nMoveRule_Detail =>
      'کھیل کو ڈرا کیا جاتا ہے اگر کسی مخصوص تعداد میں چالوں کو ہٹانا نہیں ہے۔';

  @override
  String get rollback => 'رول بیک';

  @override
  String get pleaseSelect => 'براہ مہربانی منتخب کریں';

  @override
  String get copy => 'کاپی';

  @override
  String get moveHistoryCopied => 'نقل کی گئی تاریخ کو کلپ بورڈ پر منتقل کریں۔';

  @override
  String get help => 'مدد';

  @override
  String get feedback => 'تاثرات';

  @override
  String get exit => 'باہر نکلیں';

  @override
  String get ruleSettings => 'اصول کی ترتیبات';

  @override
  String get color => 'رنگ';

  @override
  String get boardColor => 'بورڈ کا رنگ';

  @override
  String get pieceColor => 'ٹکڑا رنگ';

  @override
  String get backgroundColor => 'پس منظر کا رنگ';

  @override
  String get lineColor => 'بورڈ لائن کا رنگ';

  @override
  String get whitePieceColor => 'پلیئر 1 ٹکڑا رنگ';

  @override
  String get blackPieceColor => 'پلیئر 2 ٹکڑا رنگ';

  @override
  String get messageColor => 'پیغام کا رنگ';

  @override
  String get isPieceCountInHandShown => 'بغیر جگہ کے ٹکڑوں کی گنتی دکھائیں۔';

  @override
  String get isNotationsShown => 'بورڈ پر اشارے دکھائیں۔';

  @override
  String get isHistoryNavigationToolbarShown =>
      'ہسٹری نیویگیشن ٹول بار دکھائیں۔';

  @override
  String get display => 'ڈسپلے';

  @override
  String get boardBorderLineWidth => 'بورڈ بارڈر لائن کی چوڑائی';

  @override
  String get boardInnerLineWidth => 'بورڈ کی اندرونی لائن کی چوڑائی';

  @override
  String get pieceWidth => 'ٹکڑا چوڑائی';

  @override
  String get fontSize => 'حرف کا سائز';

  @override
  String get standardNotation => 'ڈبلیو ایم ڈی نوٹیشن';

  @override
  String get restore => 'بحال کریں۔';

  @override
  String get restoreDefaultSettings => 'پرانی ترتیب بحال کریں';

  @override
  String pick(Object element) {
    return 'چنیں $element';
  }

  @override
  String get info => 'معلومات';

  @override
  String get hint => 'اشارہ';

  @override
  String get player => 'کھلاڑی';

  @override
  String get player1 => 'کھلاڑی 1';

  @override
  String get player2 => 'کھلاڑی 2';

  @override
  String get howToPlay => 'کیسے کھیلنا ہے';

  @override
  String get toPlacePiece =>
      'ٹکڑا رکھنے کے لیے کسی بھی دستیاب پوائنٹ پر ٹیپ کریں۔';

  @override
  String get toSelectPiece => 'کسی ٹکڑے کو منتقل کرنے کے لیے اسے تھپتھپائیں۔';

  @override
  String get toMovePiece =>
      'اسے منتقل کرنے کے لیے کسی ٹکڑے سے جڑے ہوئے پوائنٹ پر ٹیپ کریں۔';

  @override
  String get toRemovePiece => 'ہٹانے کے لیے مخالف کے ایک ٹکڑے پر ٹیپ کریں۔';

  @override
  String get needToCreateMillFirst =>
      'کسی ٹکڑے کو ہٹانے سے پہلے آپ کو پہلے مل بنانے کی ضرورت ہے۔';

  @override
  String get needToPlayWithOwnPieces =>
      'آپ کو اپنے ٹکڑوں کے ساتھ کھیلنے کی ضرورت ہے۔';

  @override
  String get statistics => 'شماریات';

  @override
  String get totalGames => 'کل گیمز';

  @override
  String get results => 'نتائج';

  @override
  String get left => 'بائیں';

  @override
  String get privacyPolicy => 'رازداری کی پالیسی';

  @override
  String get privacyPolicy_Detail_1 =>
      'براہ کرم غور سے پڑھیں اور یقینی بنائیں کہ آپ اس کو پوری طرح سمجھتے اور اس سے متفق ہیں۔ ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. اگر آپ اس پالیسی سے اتفاق نہیں کرتے ہیں تو براہ کرم اس ایپ کو استعمال نہ کریں۔ ایپ کو استعمال کرنے کا مطلب ہے کہ آپ ان شرائط کو قبول کرتے ہیں۔';

  @override
  String get and => ' اور ';

  @override
  String get accept => 'قبول کریں۔';

  @override
  String get takeBack => 'واپس لینا';

  @override
  String get takingBack => 'واپس لے جا رہا ہے…';

  @override
  String get waiting => 'انتظار کر رہا ہے…';

  @override
  String get stepForward => 'آگے بڑھیں۔';

  @override
  String get takeBackAll => 'سب واپس لے لو';

  @override
  String get stepForwardAll => 'سب آگے بڑھیں۔';

  @override
  String get moveNow => 'اب چلو';

  @override
  String get done => 'ہو گیا';

  @override
  String get crackMill => 'کریک مل';

  @override
  String get crackMill_Detail =>
      'اگر کسی کھلاڑی کے پاس ملوں میں صرف ٹکڑے ہیں، تو ملوں میں موجود ٹکڑے ہٹانے کے لیے تالا نہیں لگائیں گے۔';

  @override
  String get animationDuration => 'حرکت پذیری کا دورانیہ';

  @override
  String get none => 'کوئی نہیں۔';

  @override
  String get theme => 'خیالیہ';

  @override
  String get helpContent =>
      'گیم کا مقصد حریف کو تین سے کم ٹکڑوں کے ساتھ چھوڑنا ہے یا کوئی قانونی چال نہیں ہے۔\n\nاگر تیسری بار کوئی پوزیشن آتی ہے یا آخری 100 (کنفیگر ایبل) چالوں میں کوئی ہٹانے نہیں دیتا ہے تو گیم خود بخود ڈرا ہوجاتا ہے۔\n\nکھیل تین مراحل میں آگے بڑھتا ہے:\n\n1. خالی جگہوں پر ٹکڑے رکھنا\n2. ٹکڑوں کو ملحقہ مقامات پر منتقل کرنا\n3. (اختیاری مرحلہ) کسی بھی خالی جگہ پر ٹکڑوں کو منتقل کرنا جب کھلاڑی کو تین ٹکڑوں تک کم کرنا\n\nرکھنا\n\nکھیل ایک خالی بورڈ سے شروع ہوتا ہے، جو چوبیس پوائنٹس کے ساتھ ایک گرڈ پر مشتمل ہوتا ہے۔ کھلاڑی باری باری اپنے ٹکڑوں کو خالی پوائنٹس پر رکھتے ہیں یہاں تک کہ ہر کھلاڑی بورڈ پر تمام ٹکڑوں کو رکھ دیتا ہے۔ اگر کوئی کھلاڑی اپنے تین ٹکڑوں کو سیدھا رکھ سکتا ہے، تو اس کے پاس ایک \"مل\" ہے اور وہ اپنے مخالف کے ایک ٹکڑے کو بورڈ سے ہٹا سکتا ہے۔\n\nکچھ اصولوں میں، کھلاڑیوں کو بنی چکی سے کسی ٹکڑے کو ہٹانے سے پہلے پہلے کسی دوسرے ٹکڑے کو ہٹانا چاہیے۔\n\nآپ ٹکڑوں کو ہٹائے گئے ٹکڑوں کے پوائنٹس پر دوبارہ رکھنے کے مرحلے میں کچھ اصولوں میں نہیں رکھ سکتے ہیں۔\n\nایک بار تمام ٹکڑوں کو استعمال کرنے کے بعد، کھلاڑی باری باری حرکت کرتے ہیں۔\n\nحرکت پذیر\n\nمنتقل کرنے کے لیے، ایک کھلاڑی بورڈ لائن کے ساتھ اپنے ایک ٹکڑے کو خالی ملحقہ پوائنٹ پر لے جاتا ہے۔ اگر وہ ایسا نہیں کر سکتا تو وہ گیم ہار چکا ہے۔ ایک کھلاڑی جو بورڈ لائن پر اپنے تین ٹکڑوں کو سیدھ میں کرتا ہے اس کے پاس ایک چکی ہوتی ہے اور وہ اپنے حریف کے ٹکڑوں میں سے ایک کو ہٹا سکتا ہے جیسا کہ رکھنے کے مرحلے میں ہے۔ کوئی بھی کھلاڑی دو ٹکڑے کر دیتا ہے، اس کے پاس نئی ملز بنانے کا کوئی آپشن نہیں ہوتا، اور اس طرح کھیل ہار جاتا ہے۔ ایک کھلاڑی اس وقت بھی ہار سکتا ہے جب تین سے زیادہ ٹکڑے ہو جائیں اگر اس کا حریف اسے چلنے سے روکتا ہے۔\n\nپرواز\n\nقواعد کی کچھ مختلف حالتوں میں، ایک بار جب کسی کھلاڑی کے پاس صرف تین ٹکڑے رہ جاتے ہیں، تو اس کے ٹکڑے اڑ سکتے ہیں، چھلانگ لگا سکتے ہیں یا کسی بھی خالی جگہ پر چھلانگ لگا سکتے ہیں، نہ صرف ملحقہ۔\n';

  @override
  String get versionInfo => 'ورژن کی معلومات';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'لائسنس';

  @override
  String get sourceCode => 'سورس کوڈ';

  @override
  String get appVersion => 'ایپ ورژن';

  @override
  String get general => 'جنرل';

  @override
  String get advanced => 'اعلی درجے کی';

  @override
  String get placing => 'رکھنا';

  @override
  String get moving => 'حرکت پذیر';

  @override
  String get removing => 'ہٹانا';

  @override
  String get gameOverCondition => 'گیم اوور کنڈیشن';

  @override
  String get aisPlayStyle => 'AI کا پلے اسٹائل';

  @override
  String get passive => 'غیر فعال';

  @override
  String get timeout => 'وقت ختم';

  @override
  String get appearance => 'ظہور';

  @override
  String get drawOnHumanExperience => 'انسانی تجربے کو کھینچیں۔';

  @override
  String get considerMobility => 'ٹکڑوں کی نقل و حرکت پر غور کریں۔';

  @override
  String get pieceCount => 'ٹکڑوں کی تعداد:';

  @override
  String inHand(Object player, int count) {
    return '$player ہاتھ میں: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return 'بورڈ پر $player: $count';
  }

  @override
  String get boardTop => 'بورڈ اوپر سے آفسیٹ';

  @override
  String get notAIsTurn => 'یہ AI کی باری نہیں ہے۔';

  @override
  String get aiIsNotThinking => 'AI نہیں سوچ رہا ہے۔';

  @override
  String get atEnd => 'آپ منتقلی کی فہرست کے آخر میں ہیں۔';

  @override
  String get tapBackAgainToLeave => 'چھوڑنے کے لیے دوبارہ تھپتھپائیں۔';

  @override
  String get more => 'مزید';

  @override
  String get experimental => 'یہ ایک تجرباتی خصوصیت ہے۔';

  @override
  String get experiments => 'تجربات';

  @override
  String get ossLicenses => 'اوپن سورس لائسنس';

  @override
  String get language => 'زبان';

  @override
  String get defaultLanguage => 'پہلے سے طے شدہ زبان';

  @override
  String get mayMoveInPlacingPhase =>
      'ٹکڑے ٹکڑے کرنے کے مرحلے میں منتقل کر سکتے ہیں';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'کوئی الگ الگ جگہ اور منتقلی کے مراحل نہیں ہیں، یعنی کھلاڑی ہر حرکت پر یہ فیصلہ کر سکتے ہیں کہ آیا وہ بورڈ پر کوئی ٹکڑا رکھنا چاہتے ہیں یا اپنے کسی ٹکڑے کو منتقل کرنا چاہتے ہیں (جب تک کہ ان کے پاس باقی ٹکڑے ہیں)۔';

  @override
  String get drawerColor => 'مینو کا رنگ';

  @override
  String get drawerTextColor => 'مینو متن کا رنگ';

  @override
  String get drawerHighlightItemColor => 'مینو آئٹم کا رنگ نمایاں کریں۔';

  @override
  String get mainToolbarBackgroundColor => 'مین ٹول بار کے پس منظر کا رنگ';

  @override
  String get mainToolbarIconColor => 'مین ٹول بار آئیکن کا رنگ';

  @override
  String get navigationToolbarBackgroundColor =>
      'نیویگیشن ٹول بار کے پس منظر کا رنگ';

  @override
  String get navigationToolbarIconColor => 'نیویگیشن ٹول بار کے آئیکن کا رنگ';

  @override
  String get autoHideToolbar => 'ٹول بار کو خود بخود چھپائیں۔';

  @override
  String get toolbarLocationOnScreen => 'اسکرین پر ٹول بار کا مقام';

  @override
  String get top => 'اوپر';

  @override
  String get bottom => 'نیچے';

  @override
  String get center => 'مرکز';

  @override
  String get solidColor => 'ٹھوس رنگ';

  @override
  String get picture => 'تصویر';

  @override
  String get chooseYourPicture => 'اپنی تصویر کا انتخاب کریں۔';

  @override
  String get light => 'روشنی';

  @override
  String get dark => 'اندھیرا';

  @override
  String get themes => 'تھیمز';

  @override
  String get currentTheme => 'موجودہ تھیم';

  @override
  String get saveTheme => 'تھیم محفوظ کریں۔';

  @override
  String get showAnalysisGraph => 'تجزیہ گراف دکھائیں۔';

  @override
  String get analysis => 'تجزیہ';

  @override
  String get saveGame => 'کھیل کو محفوظ کریں۔';

  @override
  String get loadGame => 'لوڈ گیم';

  @override
  String get setupPosition => 'سیٹ اپ پوزیشن';

  @override
  String get showLegalMoves => 'قانونی چالیں دکھائیں۔';

  @override
  String get showLastMove => 'آخری حرکت دکھائیں۔';

  @override
  String get showArrows => 'تیر دکھائیں۔';

  @override
  String get pieces => 'ٹکڑے';

  @override
  String get showAnalysis => 'تجزیہ دکھائیں۔';

  @override
  String get threads => 'دھاگے';

  @override
  String get getInvolved => 'شامل ہونا';

  @override
  String get helpImproveTranslate => 'ترجمہ کو بہتر بنانے میں مدد کریں۔';

  @override
  String get tutorial => 'ٹیوٹوریل';

  @override
  String get classicMill => 'کلاسیکی مل';

  @override
  String get mixedMill => 'مخلوط مل';

  @override
  String get ceylonMill => 'سیلون مل';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'مل کو بار بار ٹوٹا اور دوبارہ بنایا جا سکتا ہے۔';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'اگر کوئی کھلاڑی فوری طور پر ایک نئی مل بنانے کے لیے مل کو توڑتا ہے، تو ایسا کھلاڑی اپنی اگلی چال میں اس ٹکڑے کو واپس اصل جنکشن پر منتقل کر سکتا ہے اگر وہ نئی مل بناتا ہے۔';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'کھیل ڈرا ہوتا ہے اگر کسی کھلاڑی کے پاس تین ٹکڑے ہوں اور دس چالوں کے بعد کوئی بھی کھلاڑی حریف کے ٹکڑوں کو نہیں ہٹاتا ہے۔';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'جب کوئی کھلاڑی تین ٹکڑوں تک نیچے ہوتا ہے، اور کوئی بھی کھلاڑی دس چالوں کے اندر حریف کے ٹکڑے کو نہیں ہٹا سکتا، تو کھیل ڈرا ہوتا ہے۔';

  @override
  String get close => 'بند کریں';

  @override
  String get whitePiece => 'سفید ٹکڑا';

  @override
  String get blackPiece => 'کالا ٹکڑا';

  @override
  String get emptyPoint => 'خالی نقطہ';

  @override
  String get noPoint => 'کوئی فائدہ نہیں';

  @override
  String get placingPhase => 'لگانے کا مرحلہ';

  @override
  String get movingPhase => 'متحرک مرحلہ';

  @override
  String get flyingPhase => 'پرواز کا مرحلہ';

  @override
  String sideToMove(Object player) {
    return 'منتقل کرنے کے لیے سائیڈ: $player';
  }

  @override
  String lastMove(Object move) {
    return 'آخری اقدام: $move';
  }

  @override
  String get selected => 'منتخب شدہ';

  @override
  String get accessibility => 'رسائی';

  @override
  String get screenReaderSupport => 'اسکرین ریڈر سپورٹ';

  @override
  String get isDraw => 'یہ ایک ڈرا ہے!';

  @override
  String get draw => 'ڈرا';

  @override
  String get pieceHighlightColor => 'ٹکڑا نمایاں رنگ';

  @override
  String get algorithm => 'الگورتھم';

  @override
  String get endgameNMoveRule => 'اینڈگیم N-Move کا اصول';

  @override
  String get endgameNMoveRule_Detail =>
      'گیم ڈرا کیا جاتا ہے اگر کسی بھی کھلاڑی کے پاس صرف تین ٹکڑے ہوں اور کوئی بھی کھلاڑی مخصوص چالوں کے اندر کسی ٹکڑے کو نہیں ہٹاتا ہے۔';

  @override
  String get drawReasonEndgameRule50 =>
      'کسی بھی کھلاڑی کے پاس صرف تین ٹکڑے ہوتے ہیں، اور کوئی بھی کھلاڑی مخصوص چالوں کے اندر کسی ٹکڑے کو نہیں ہٹاتا ہے۔';

  @override
  String get threefoldRepetitionRule => 'تین گنا تکرار کا اصول';

  @override
  String get threefoldRepetitionRule_Detail =>
      'تیسری بار پوزیشن ہونے پر گیم ڈرا ہو جاتا ہے۔';

  @override
  String get continueToMakeMove => 'چکی! ایک حرکت کرنا جاری رکھیں۔';

  @override
  String get pointStyle => 'پوائنٹ اسٹائل';

  @override
  String get pointWidth => 'پوائنٹ کی چوڑائی';

  @override
  String get solid => 'ٹھوس';

  @override
  String get hollow => 'کھوکھلی';

  @override
  String get languageName => 'اردو';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Moves',
      one: '$count Move',
      zero: 'Move',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'لوڈ ناکام ہو گیا۔';

  @override
  String get filename => 'فائل کا نام';

  @override
  String get browse => 'براؤز کریں…';

  @override
  String get gameFiles => 'گیم فائلز';

  @override
  String get gameSavedTo => 'گیم کو محفوظ کیا جاتا ہے۔';

  @override
  String get empty => 'خالی';

  @override
  String get noMove => 'کوئی حرکت نہیں۔';

  @override
  String get restoredPosition => 'ابتدائی پوزیشن بحال کر دی گئی۔';

  @override
  String get clean => 'صاف';

  @override
  String get cleanedUp => 'صاف ہو چکا.';

  @override
  String get remove => 'دور';

  @override
  String get noPiecesCanBeRemoved => 'کوئی ٹکڑا ہٹایا نہیں جا سکتا.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pieces',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 ہٹانے کی ضرورت ہے۔';
  }

  @override
  String placedCount(int count) {
    return 'رکھا گیا ($count)';
  }

  @override
  String get placedPieceCount => 'رکھنے کے مرحلے میں رکھ دیا گیا ٹکڑا شمار۔';

  @override
  String hasPlacedPieceCount(int count) {
    return 'موجودہ کھلاڑی نے $count ٹکڑے رکھے ہیں۔';
  }

  @override
  String get notPlacingPhase => 'مرحلہ نہیں رکھ رہا، اسے تبدیل نہیں کر سکتا۔';

  @override
  String get paste => 'چسپاں کریں۔';

  @override
  String get pasteDone => 'پیسٹ ہو گیا ہے۔';

  @override
  String get cannotPaste => 'پیسٹ نہیں کیا جا سکتا۔';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'ہٹائے گئے اور ہٹائے گئے ٹکڑے دکھائیں۔';

  @override
  String get fullScreen => 'مکمل اسکرین یا بڑی اسکرین';

  @override
  String get reopenToTakeEffect =>
      'ترتیبات کے اثر میں آنے کے لیے ایپ سے باہر نکلیں اور دوبارہ کھولیں۔';

  @override
  String get forest => 'جنگل';

  @override
  String get desktopImage => 'ڈیسک ٹاپ امیج';

  @override
  String get invalidPosition => 'غلط پوزیشن۔';

  @override
  String get shareGIF => 'GIF شیئر کریں۔';

  @override
  String get pixelRatio => 'پکسل کا تناسب';

  @override
  String get duration => 'دورانیہ';

  @override
  String get gameScreenRecorder => 'گیم اسکرین ریکارڈر';

  @override
  String get previous => 'پچھلا';

  @override
  String get next => 'اگلے';

  @override
  String get skip => 'چھوڑ دو';

  @override
  String get gotIt => 'یہ مل گیا';

  @override
  String get youCanModifyRules =>
      'آپ اصول کی ترتیبات میں گیم کے اصولوں میں ترمیم کر سکتے ہیں۔';

  @override
  String get youCanUseMouseWheelInPicker =>
      'آپ ماؤس وہیل کو چننے والے میں قدر تبدیل کرنے کے لیے استعمال کر سکتے ہیں۔';

  @override
  String get noTimeLimitForThinking =>
      'AI سوچنے کا وقت 0 پر سیٹ ہونے کا مطلب ہے کہ سوچنے کے لیے کوئی وقت کی حد نہیں ہے۔';

  @override
  String get whatIsMtdf =>
      'MTD(f) الفا-بیٹا سرچ الگورتھم کی ایک ترمیم شدہ شکل ہے جس کا مقصد انٹرمیڈیٹ تلاش کے نتائج کو دوبارہ استعمال کرکے اور تلاش کی جگہ کو کم کرنے کے لیے ایک اچھا ابتدائی اندازہ استعمال کرکے کارکردگی کو بہتر بنانا ہے۔';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'براہ کرم آگاہ رہیں کہ AI سوچ کے وقت کی ایڈجسٹمنٹ پوری طرح سے درست نہیں ہوسکتی ہے۔ اصل سوچ کا وقت اس وقت کم ہو سکتا ہے جب مشکل کی سطح کو کم قیمت پر سیٹ کیا جاتا ہے اور جب وقت ختم ہو جاتا ہے تو AI درمیانی سوچ کے وقت زیادہ ہو سکتا ہے۔';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'اگر آپ مشکل کی سطح کو بلند کرتے ہیں لیکن AI سوچنے کے وقت میں اضافہ نہیں کرتے ہیں، تو سوچنے کے وقت کی پابندی کی وجہ سے مشکل کی اصل سطح کم قیمت تک محدود ہو سکتی ہے۔ مشین کی کارکردگی کی بنیاد پر اصل قیمت مختلف ہو سکتی ہے۔';

  @override
  String get whatIsPvs =>
      'PVS (پرنسپل ویری ایشن سرچ) ایک دی گئی پوزیشن میں بہترین اقدام تلاش کرنے کے لیے تلاش کا الگورتھم ہے۔ یہ الفا-بیٹا الگورتھم کا ایک اضافہ ہے اور اس بات کی تصدیق کرنے کے لیے صفر یا صفر ونڈو تلاش کا استعمال کرتا ہے کہ کوئی اقدام بنیادی تغیر سے پہلے سے محفوظ اسکور سے بدتر ہے یا بدتر نہیں ہے۔ PVS سب سے زیادہ امید افزا چالوں پر توجہ مرکوز کرتا ہے اور ذیلی شاخوں کی غیر ضروری تلاشوں سے گریز کرتا ہے، جس سے تلاش کی کارکردگی کو بہتر بنانے میں مدد ملتی ہے۔';

  @override
  String get whatIsAlphaBeta =>
      'الفا بیٹا الگورتھم بہترین اقدام تلاش کرنے کے لیے ایک سرچ الگورتھم ہے۔ یہ سرچ ٹری کی کٹائی اور کارکردگی بڑھانے کے لیے minimax اصول اور دو قدروں، الفا اور بیٹا کا استعمال کرتا ہے۔ الفا اس کم سے کم سکور کی نمائندگی کرتا ہے جس کا یقین ہے کہ وہ کمپیوٹر حاصل کر سکتا ہے، جبکہ بیٹا زیادہ سے زیادہ اسکور کی نمائندگی کرتا ہے جو اس کے مخالف کو حاصل ہو سکتا ہے۔ الگورتھم کمپیوٹر کو گیم میں ہوشیار، موثر فیصلے کرنے میں مدد کرتا ہے۔';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'انسانی تجربے کے مطابق اگر آپ جیتنے کی کوشش کریں گے تو آپ ہار جائیں گے۔ اس کے بجائے، اپنے مقصد کے طور پر ڈرا کا مقصد بنائیں اور گیم ہارنے سے بچیں۔ اپنے حریف کا مشاہدہ کریں اور انہیں نرمی سے ایسی پوزیشن میں راغب کریں جہاں وہ غلطیاں کر سکیں۔ جب وہ کمزوری دکھاتے ہیں، موقع سے فائدہ اٹھائیں اور جیت کے لیے نرمی سے زور دیں۔ اس طرح آپ گیم جیت سکتے ہیں۔';

  @override
  String get firstMoveDetail =>
      'اس کھیل میں، دوسرے کھلاڑی کے لیے پہلے کھلاڑی کے مقابلے جیتنا آسان ہے۔';

  @override
  String get passiveDetail =>
      'Passive آپشن کو فعال کرنے سے AI کو اس وقت آرام ملے گا جب اسے پوزیشن میں فائدہ ہو، بجائے اس کے کہ جارحانہ انداز میں جلد سے جلد جیتنے کی کوشش کرے۔';

  @override
  String get moveRandomlyDetail =>
      'اس اختیار کو فعال کرنے سے گیم کی بے ترتیب پن اور تفریح میں اضافہ ہوتا ہے جبکہ اسے غیر فعال کرنے سے AI کو شکست دینے کے طریقوں کا مطالعہ کرنے میں مدد مل سکتی ہے۔';

  @override
  String get considerMobilityOfPiecesDetail =>
      'اگر AI اپنے ٹکڑوں کی نقل و حرکت پر غور کرتا ہے، تو اس کا مقصد نہ صرف مخالف کے ٹکڑوں کو جلد از جلد پکڑنا ہوگا، بلکہ مخالف کی نقل و حرکت کو روکنے اور انہیں ایسا کرنے سے روکنے پر بھی غور ہوگا۔';

  @override
  String get whenBoardIsFull => 'جب بورڈ بھر جاتا ہے۔';

  @override
  String get whenBoardIsFull_Detail =>
      'رکھنے کے مرحلے کے اختتام پر، حرکت کا مرحلہ شروع ہونے سے پہلے، اگر بورڈ ٹکڑوں سے بھرا ہوا ہو تو کارروائی کی جائے گی۔';

  @override
  String get sideToMoveRemovePiece =>
      'جو کھلاڑی چلتے ہوئے مرحلے میں پہلے حرکت کرتا ہے وہ مخالف کے ٹکڑوں میں سے ایک کو ہٹاتا ہے۔';

  @override
  String get agreeToDraw => 'دونوں فریق قرعہ اندازی پر متفق ہیں۔';

  @override
  String get takeOpponentsPiece => 'اپنے مخالف کا ایک ٹکڑا لے لو۔';

  @override
  String get firstPlayerLose => 'پہلا کھلاڑی کھیل ہار جاتا ہے۔';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'پہلے اور دوسرے کھلاڑی مخالف کے ٹکڑوں میں سے ایک کو ہٹاتے ہیں۔';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'دوسرے اور پہلے کھلاڑی حریف کے ٹکڑوں میں سے ایک کو ہٹاتے ہیں۔';

  @override
  String get enteredFlyingPhase =>
      'اب پرواز کے مرحلے میں داخل ہو چکے ہیں، مخالف کے ٹکڑے بورڈ پر کسی بھی خالی جگہ پر جا سکتے ہیں۔ آپ فلائنگ رول کو \"قواعد کی ترتیبات\" میں بند کر سکتے ہیں۔';

  @override
  String get whenStalemate => 'جب تعطل';

  @override
  String get whenStalemate_Detail =>
      'جب کوئی ٹکڑا منتقل نہیں کیا جا سکتا تو کیا عمل ہوتا ہے؟';

  @override
  String get endWithStalemateLoss =>
      'جس طرف مسدود ہے اس کے لیے تعطل کے نقصان کے ساتھ اختتام کریں۔';

  @override
  String get changeSideToMove => 'حرکت کرنے کے لیے سائیڈ کو تبدیل کریں۔';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'مخالف کے ٹکڑوں میں سے ایک کو ہٹا دیں اور اگلی حرکت کریں۔';

  @override
  String get endWithStalemateDraw => 'ایک تعطل ڈرا کے ساتھ ختم کریں۔';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'مخالف کے ٹکڑوں میں سے ایک کو ہٹا دیں اور حرکت کرنے کے لیے سائیڈ کو تبدیل کریں۔';

  @override
  String get aiResponseDelayTime => 'AI جواب میں تاخیر کا وقت';

  @override
  String get aiIsDelaying =>
      'AI فی الحال تاخیر سے ردعمل کے مرحلے میں ہے۔ براہ کرم آگے بڑھنے سے پہلے تھوڑی دیر انتظار کریں۔';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'آپ غیر ملحقہ ٹکڑے کو نہیں ہٹا سکتے ہیں۔';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'اگر تعطل پیدا ہوتا ہے تو، آپ سے ملحق مخالف کے ٹکڑے ہٹائے جا سکتے ہیں، قطع نظر مل کی تشکیل کے۔';

  @override
  String get whatIsMcts =>
      'MCTS ایک ابتدائی دوستانہ الگورتھم ہے جو مختلف حرکات کو دریافت کرنے اور ان کا اندازہ لگا کر سمیلیشنز کے ذریعے فیصلے کرتا ہے۔';

  @override
  String get goldenJade => 'گولڈن جیڈ';

  @override
  String get forestWood => 'جنگل کی لکڑی';

  @override
  String get darkMystery => 'گہرا اسرار';

  @override
  String get midnightBlue => 'آدھی رات نیلے';

  @override
  String get greenForest => 'سبز جنگل';

  @override
  String get greenMeadow => 'سبز گھاس کا میدان';

  @override
  String get stonyPath => 'سنگلاخ راستہ';

  @override
  String get pastelPink => 'پیسٹل پنک';

  @override
  String get turquoiseSea => 'فیروزی سمندر';

  @override
  String get violetDream => 'وایلیٹ ڈریم';

  @override
  String get mintChocolate => 'پودینہ چاکلیٹ';

  @override
  String get skyBlue => 'آسمانی رنگ';

  @override
  String get playfulGarden => 'زندہ دل باغ';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Retrograde Analysis الگورتھم مختلف ابتدائی پوزیشنوں سے اینڈگیم ڈیٹا بیس بنانے کے لیے کثیر قدر والے ریٹروگریڈ تجزیہ کا استعمال کرتا ہے، پھر گیم پلے کو بہتر بنانے کے لیے اس ڈیٹا بیس کو لاگو کرتا ہے۔ یہ نقطہ نظر انتہائی مضبوط حل کے زمرے میں آتا ہے۔';

  @override
  String get viewAlgorithmGuide =>
      'کیا آپ اس الگورتھم کے لیے صارف گائیڈ دیکھنا چاہیں گے؟';

  @override
  String get showPositionalAdvantageIndicator =>
      'پوزیشنی فائدہ کا اشارہ دکھائیں۔';

  @override
  String get usePerfectDatabase => 'کامل ڈیٹا بیس کا استعمال کریں۔';

  @override
  String get perfectDatabaseDescription =>
      'جدید الگورتھم کے ذریعے تیار کردہ بے عیب گیم ڈیٹا بیس کو استعمال کرنے کے لیے اس اختیار کو فعال کریں۔ یہ خصوصیت زیادہ سے زیادہ چالوں کی تجویز کرنے کے لیے ابتدائی اور اختتامی گیم دونوں حکمت عملیوں کو مربوط کرتی ہے۔ یہ ان کھلاڑیوں کے لیے ترجیحی انتخاب ہے جو گیم پلے میں اعلیٰ سطح کی درستگی کے خواہاں ہیں۔ پیچیدہ کمپیوٹیشنل تکنیکوں کے ذریعے تخلیق کیا گیا، ڈیٹا بیس کو قریب ترین گیم حل پیش کرنے کے لیے ڈیزائن کیا گیا ہے۔\n\nنوٹ: اگر AI ڈیٹا بیس تک رسائی حاصل کرنے میں ناکام رہتا ہے، تو یہ گیم پلے کے فیصلوں کے لیے روایتی الگورتھم کی طرف رجوع کرے گا۔ جب ڈیٹا بیس دستیاب ہوتا ہے، \'مشکلیت کی سطح\' عملی طور پر ناقابل شکست ہو جاتی ہے، اور \'AI تھنکنگ ٹائم\' میں زبردست کمی واقع ہوتی ہے۔ \'AI کے پلے اسٹائل\' کے اختیارات میں بہت سی ترتیبات کو اوور رائیڈ کر دیا جائے گا، کیونکہ ڈیٹا بیس کے نتائج سب سے زیادہ ترجیح رکھتے ہیں۔\n\nاس بے عیب ڈیٹا بیس سے زیادہ سے زیادہ فائدہ اٹھانے کے بارے میں رہنمائی کے لیے، یہاں کلک کریں۔';

  @override
  String get backgroundImage => 'پس منظر کی تصویر';

  @override
  String get whatIsRandom =>
      'جب \'پرفیکٹ ڈیٹا بیس کا استعمال کریں\' کا آپشن فعال نہیں ہوتا ہے، تو \'رینڈم\' سیٹنگ AI کو ٹکڑوں کو تصادفی طور پر منتقل کرنے کا سبب بنتی ہے، منتقلی کے انتخاب کے لیے کوئی الگورتھم استعمال کیے بغیر۔ یہ عام طور پر نمایاں طور پر کمزور گیم پلے کے نتیجے میں ہوتا ہے۔ اس کے برعکس، جب \'پرفیکٹ ڈیٹا بیس استعمال کریں\' کو فعال کیا جاتا ہے، تو AI روایتی AI الگورتھم کے ساتھ ملاوٹ کرنے کے بجائے، فیصلے کرنے کے لیے \'پرفیکٹ ڈیٹا بیس\' پر انحصار کرتا ہے۔ اس موڈ میں، AI کی چالیں مکمل طور پر ڈیٹا بیس کے مواد پر مبنی ہوتی ہیں، ریئل ٹائم کیلکولیشنز یا سرچ الگورتھم پر انحصار کو چھوڑ کر۔';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'مخالف کے مہرے (مہروں) کو ان کے ہاتھ سے ہٹا دیں؛ پھر مخالف کی باری ہے کہ وہ مہرہ رکھے۔';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'جب پلانگ کے مرحلے کے دوران ملیں بناتے ہیں۔';

  @override
  String get removeOpponentsPieceFromBoard =>
      'مخالف کے مہرے (مہرے) بورڈ سے ہٹا دیں۔';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'مخالف کے مہرے (مہرے) بورڈ سے ہٹا دیں؛ پھر مخالف کی باری ہے کہ وہ مہرہ رکھے۔';

  @override
  String get opponentRemovesOwnPiece =>
      'مخالف خود اپنے مہرے کو بورڈ سے ہٹاتا ہے۔';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'آپ کے بجائے مخالف اپنا مہرہ (مہرے) بورڈ سے منتخب کرتا ہے اور ہٹاتا ہے ، اس طرح ایک ایسا عمل کرتا ہے جو خود اس کے لیے نقصان دہ ہے۔';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'مخالف کے مہرے کو ان کے ہاتھ سے ہٹا دیں؛ پھر آپ کی باری ہے۔';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'مخالف کے ہاتھ سے حصہ (حصے) ہٹا دیں۔ اگر ملٹی ریمو سیٹنگ کے مطابق ، متعدد ٹکڑوں کو ہٹانا ہے اور مخالف کے ہاتھ میں کوئی ٹکڑا باقی نہیں ہے تو ، مخالف کے ٹکڑوں کو بورڈ سے ہٹانا جاری رکھیں۔ پھر ، یہ حرکت کرنے کی آپ کی باری ہے۔ اگر آپ ملیں بنانا جاری رکھتے ہیں تو ، آپ مخالف کے ٹکڑے ہٹا سکتے ہیں۔';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'مخالف کے ہاتھ سے حصہ (حصے) ہٹا دیں۔ اگر ملٹی ریمو سیٹنگ کے مطابق ، متعدد ٹکڑوں کو ہٹانا ہے اور مخالف کے ہاتھ میں کوئی ٹکڑا باقی نہیں ہے تو ، مخالف کے ٹکڑوں کو بورڈ سے ہٹانا جاری رکھیں۔ پھر ، مخالف کی باری ہے۔';

  @override
  String get markAndDelayRemovingPieces =>
      'ٹکڑوں کو ہٹانے کو نشان زد کریں اور تاخیر کریں۔';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'پلانگ کے مرحلے کے دوران ، ہٹائے جانے والے ٹکڑوں کو نشان زد کیا جاتا ہے ، اور دونوں کھلاڑیوں کے لیے ، ان نکات پر کوئی نیا ٹکڑا نہیں رکھا جا سکتا۔ حرکت کے مرحلے میں داخل ہونے پر ، ان نشان زدہ ٹکڑوں کو بالکل ہٹا دیا جاتا ہے ، اور کھلاڑی اب اپنے ٹکڑوں کو ان اب خالی مقامات پر منتقل کر سکتے ہیں۔';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'جب پلیسنگ مرحلے کے دوران چکیاں بنائی جاتی ہیں تو کی جانے والی کارروائیاں۔';

  @override
  String get marked => 'نشان زدہ';

  @override
  String get menu => 'مینو';

  @override
  String get monochrome => 'مونوکروم';

  @override
  String get youCanEnableScreenReaderSupport =>
      'آپ عمومی ترتیبات میں معذوری کی سہولت ترتیبات میں اسکرین ریڈر سپورٹ کو آن کر سکتے ہیں۔';

  @override
  String get showNumbersOnPieces => 'مہروں پر نمبر دکھائیں';

  @override
  String get saveImage => 'تصویر محفوظ کریں';

  @override
  String get isAnalysisToolbarShown => 'تجزیہ ٹولبار دکھائیں';

  @override
  String get analysisToolbarBackgroundColor => 'تجزیہ ٹولبار کا پس منظر رنگ';

  @override
  String get analysisToolbarIconColor => 'تجزیہ ٹولبار آئکن کا رنگ';

  @override
  String get transformed => 'تبدیل شدہ۔';

  @override
  String get cannotTransform => 'تبدیل نہیں کر سکتا۔';

  @override
  String get rotate => 'گھومیں';

  @override
  String get horizontalFlip => 'H فلپ';

  @override
  String get verticalFlip => 'V فلپ';

  @override
  String get innerOuterFlip => 'IO فلپ';

  @override
  String get transparentCanvas => 'شفاف کینوس';

  @override
  String get restrictRepeatedMillsFormation =>
      'بار بار مل تشکیل دینے پر پابندی';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'ایک پیس جو ایک مل سے دوسرے میں منتقل ہوا ہے وہ اگلی باری میں فوری طور پر اصلی نقطہ پر واپس نہیں جا سکتا تاکہ دوبارہ مل بنا سکے۔ پہلے مختلف حرکت کی ضرورت ہے۔';

  @override
  String get oneTimeUseMill => 'ایک وقتی استعمال مل';

  @override
  String get oneTimeUseMill_Detail =>
      'ہر مل صرف ایک بار مخالف کا حصہ ہٹا سکتا ہے۔ آپ اسے دوبارہ تشکیل دے سکتے ہیں، لیکن اسے اضافی ہٹانے کے لئے استعمال نہیں کیا جا سکتا ہے۔';

  @override
  String get currentRulesNoPerfectDatabase =>
      'آپ کے طے کردہ موجودہ قواعد کے مطابق کوئی کامل ڈیٹا بیس نہیں ہے۔ کامل ڈیٹا بیس کے بارے میں مزید معلومات کے لیے، براہ کرم یہاں کلک کریں۔';

  @override
  String get focusOnBlockingPaths =>
      'رکاوٹیں پیدا کرنے والے راستوں پر توجہ دیں';

  @override
  String get focusOnBlockingPaths_Detail =>
      'ملز بنانے کے بجائے مخالف کی حرکات کو روکنے کو ترجیح دیں۔ ملز مکمل کرنے سے ٹکڑوں کو ہٹانے پر توجہ دینے کے بجائے، AI کا مقصد مخالف کو پھنسانا ہے، انہیں حرکت کرنے سے قاصر بنانا اور جارحانہ کھیل کے بجائے گراوٹ کے ذریعے فتح کو یقینی بنانا ہے۔ یہ حکمت عملی مخالف کی ملز کو فعال طور پر نہیں روکتی ہے۔';

  @override
  String get pieceImage => 'شطرنج کا تصویر';

  @override
  String get importColorSettings => 'رنگ کی ترتیبات درآمد کریں';

  @override
  String get exportColorSettings => 'رنگ کی ترتیبات برآمد کریں';

  @override
  String get import => 'درآمد کریں';

  @override
  String get export => 'برآمد کریں';

  @override
  String get pleaseCopyJsonToClipboard =>
      'براہ کرم پہلے JSON فارمیٹ کی ترتیبات کو کلپ بورڈ پر کاپی کریں۔';

  @override
  String get copiedToClipboard => 'کلپ بورڈ پر کاپی کر دیا گیا۔';

  @override
  String get imported => 'درآمد کیا گیا۔';

  @override
  String get boardImage => 'بورڈ کی تصویر';

  @override
  String get autumnLeaves => 'خزاں کے پتے';

  @override
  String get legendaryLand => 'افسانوی زمین';

  @override
  String get vignetteEffect => 'وینیٹ اثر';

  @override
  String get promptMakeToolbarTransparent =>
      'کیا آپ بورڈ کے پس منظر کی تصویر سیٹ کرنے پر ٹول بار کو مکمل طور پر شفاف بنانا چاہیں گے؟';

  @override
  String get vibration => 'گیم میں وائبریشن کو فعال کریں';

  @override
  String get soundTheme => 'آواز تھیم';

  @override
  String get ball => 'گیند';

  @override
  String get liquid => 'سیال';

  @override
  String get wood => 'لکڑی';

  @override
  String get placeEffectAnimation => 'مہرا رکھنے کا متحرک اثر';

  @override
  String get removeEffectAnimation => 'مہرا ہٹانے کا متحرک اثر';

  @override
  String get isToolbarAtBottom => 'ٹول بار کو نیچے دکھائیں';

  @override
  String get boardCornerRadius => 'تختہ کے کونے کا رداس';

  @override
  String get useOpeningBook => 'افتتاحی کتاب استعمال کریں';

  @override
  String get currentRule => 'موجودہ';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'مورابارابا';

  @override
  String get dooz => 'دوز';

  @override
  String get chamGonu => 'چمگونو';

  @override
  String get zhiQi => 'زھیچی';

  @override
  String get chengSanQi => 'چنگسانچی';

  @override
  String get mulMulan => 'مل-ملان';

  @override
  String get nerenchi => 'نیرنچی';

  @override
  String get ruleSet => 'قاعدہ مجموعہ';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'ایک بار کا مل';

  @override
  String get daSanQi => 'دا سانچی';

  @override
  String get useOpeningBook_Detail =>
      'کھیل کے ابتدائی مرحلے میں پیشہ ورانہ انسانی کھلاڑیوں کی طرف سے عام طور پر استعمال ہونے والی افتتاحی چالوں کا استعمال کرنے دیں۔ نوٹ: یہ خصوصیت فی الحال صرف مخصوص قواعد کے سیٹوں کے لئے دستیاب ہے۔';

  @override
  String get showAdvantageGraph => 'فائدے کا گراف دکھائیں';

  @override
  String get advantageGraphHint =>
      'ایڈوانٹیج گراف صرف اس وقت بنایا جائے گا جب اے آئی حرکت کرے گی۔ جب انسانی کھلاڑی حرکت کرے گا تو یہ نہیں بنایا جائے گا۔';

  @override
  String get removalBasedOnMillCounts =>
      'اس وقت تک ہٹانے کو غیر فعال کریں جب تک کہ تمام مہروں کو رکھ نہ دیا جائے۔ کھلاڑی اپنی ملوں کی تعداد کی بنیاد پر مہروں کو ہٹاتے ہیں۔';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'اس وقت تک ہٹانے کو غیر فعال رکھیں جب تک کہ تمام مہروں کو رکھ نہ دیا جائے۔ کھلاڑی اپنی ملوں کی تعداد کی بنیاد پر مہروں کو ہٹاتے ہیں: اگر تعداد برابر ہو تو دونوں کھلاڑی ایک ہی تعداد میں مہرے ہٹاتے ہیں؛ اگر ایک کے پاس زیادہ ہوں تو وہ ایک اضافی مہرہ ہٹاتے ہوئے فرق کو ایک مہرے تک محدود رکھتا ہے۔ اگر صرف ایک کھلاڑی مل تشکیل دیتا ہے تو وہ دو مہرے ہٹا دے گا جبکہ دوسرا ایک مہرہ ہٹائے گا۔ اگر کوئی بھی مل تشکیل نہ دے سکے تو دونوں ایک ایک مہرہ ہٹا دیتے ہیں۔';

  @override
  String get elfilja => 'الفلجة';

  @override
  String get tipSelectOwnPiece => 'اپنے مہرے میں سے ایک کا انتخاب کریں۔';

  @override
  String get notYourTurn => 'آپ کی باری نہیں ہے۔';

  @override
  String get annotationToolbarBackgroundColor =>
      'تشریح ٹول بار کا پس منظر کا رنگ';

  @override
  String get annotationToolbarIconColor => 'تشریح ٹول بار کے آئیکن کا رنگ';

  @override
  String get isAnnotationToolbarShown => 'تشریح ٹول بار دکھائیں';

  @override
  String get enterAnnotationMode => 'تشریح موڈ میں داخل ہوں';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'کیا آپ واقعی تمام تشریحات صاف کرنا چاہتے ہیں؟';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM پرامپٹ کلپ بورڈ پر کاپی کر دیا گیا۔';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'کنکشن رد کر دیا گیا، سرور بند ہو سکتا ہے۔';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'دریافت کامیاب، کنکشن کا انتظار ہے...';

  @override
  String get noLanConnection => 'کوئی LAN کنکشن نہیں';

  @override
  String get takeScreenshot => 'اسکرین شاٹ لیں';

  @override
  String get disconnectedFromOpponent => 'مخالف سے رابطہ منقطع ہو گیا۔';

  @override
  String get takeBackRequest => 'واپسی کی درخواست';

  @override
  String get nothingToShow => 'دکھانے کے لیے کچھ نہیں ہے۔';

  @override
  String get stopHosting => 'ہوسٹنگ بند کریں';

  @override
  String get connectionResetByPeer => 'کنکشن کو ساتھی نے ری سیٹ کر دیا۔';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'کنکشن ہارٹ بیٹ ٹائم آؤٹ کی وجہ سے منقطع ہو گیا ہے۔ براہ کرم دوبارہ کنیکٹ کریں۔';

  @override
  String get startHosting => 'ہوسٹنگ شروع کریں';

  @override
  String get restartRequestRejected => 'ری اسٹارٹ کی درخواست مسترد کر دی گئی۔';

  @override
  String get notConnectedToLanOpponent => 'LAN مخالف سے کنکشن قائم نہیں ہے۔';

  @override
  String get llmPrompt => 'LLM پرامپٹ';

  @override
  String get gameRestarted => 'کھیل دوبارہ شروع ہو گیا۔';

  @override
  String get takeBackRejected => 'واپسی کی درخواست مسترد کر دی گئی۔';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'کیا آپ واقعی اس کھیل سے دستبردار ہونا چاہتے ہیں؟';

  @override
  String get opponentResignedYouWin =>
      'مخالف نے دستبرداری اختیار کر لی۔ آپ جیت گئے!';

  @override
  String get clearAllAnnotations => 'تمام تشریحات صاف کریں';

  @override
  String get connectedWaitingForOpponentSMove =>
      'متصل، مخالف کی باری کا انتظار ہے...';

  @override
  String get networkStatusDisconnected => 'نیٹ ورک کی حالت: منقطع';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'واپسی کی درخواست مخالف کو بھیج دی گئی۔';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'ممکن ہے کہ مخالف کھیل چھوڑ چکا ہو۔';

  @override
  String get connectedToHostSuccessfully =>
      'میزبان سے کامیابی کے ساتھ کنیکٹ ہو گیا۔';

  @override
  String get connectionLostHeartbeatTimeout =>
      'کنکشن منقطع ہو گیا: ہارٹ بیٹ ٹائم آؤٹ';

  @override
  String get noHostDiscovered => 'کوئی میزبان دریافت نہیں ہوا۔';

  @override
  String get confirmResignation => 'دستبرداری کی تصدیق کریں';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'کھیل کی میزبانی شروع ہو گئی، کھلاڑیوں کے شامل ہونے کا انتظار ہے...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'کنکشن ٹائم آؤٹ ہو گیا، نیٹ ورک کنکشن غیر مستحکم ہے۔';

  @override
  String get noLlmPromptAvailable => 'کوئی LLM پرامپٹ دستیاب نہیں ہے۔';

  @override
  String get youResignedGameOver => 'آپ نے دستبرداری اختیار کر لی۔ کھیل ختم۔';

  @override
  String get serverIp => 'سرور IP';

  @override
  String get confirmClear => 'صاف کرنے کی تصدیق کریں';

  @override
  String get opponentSTurn => 'مخالف کی باری۔';

  @override
  String get waitingAClientConnection => 'کلائنٹ کنکشن کا انتظار ہے...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'واپسی کی درخواست مسترد کر دی گئی یا ناکام ہو گئی۔';

  @override
  String get addText => 'متن شامل کریں';

  @override
  String get exitAnnotationMode => 'تشریح موڈ سے باہر نکلیں';

  @override
  String get typeYourAnnotation => 'اپنی تشریح ٹائپ کریں';

  @override
  String get attemptingToReconnect => 'دوبارہ کنیکٹ کرنے کی کوشش کر رہے ہیں...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'ری اسٹارٹ کی درخواست بھیج دی گئی۔ مخالف کے جواب کا انتظار ہے...';

  @override
  String get serverIsStopped => 'سرور بند ہے۔';

  @override
  String get restartRequest => 'ری اسٹارٹ کی درخواست';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'جب آپ کی باری نہ ہو تو واپسی کی درخواست نہیں کی جا سکتی۔';

  @override
  String get takeBackAccepted => 'واپسی قبول کر لی گئی۔';

  @override
  String get localNetworkSettings => 'مقامی نیٹ ورک کی ترتیبات';

  @override
  String get reconnectedSuccessfully => 'کامیابی کے ساتھ دوبارہ کنیکٹ ہو گیا!';

  @override
  String get failedToSaveImageToGallery =>
      'گیلری میں تصویر محفوظ کرنے میں ناکام۔';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'مخالف نے کھیل کو دوبارہ شروع کرنے کی درخواست کی ہے۔ کیا آپ قبول کرتے ہیں؟';

  @override
  String get yourTurn => 'آپ کی باری۔';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'دوبارہ کنیکٹ کرنے میں ناکام، براہ کرم کھیل دوبارہ شروع کریں۔';

  @override
  String get host => 'میزبان';

  @override
  String get join => 'شامل ہوں';

  @override
  String get port => 'پورٹ';

  @override
  String get invalidIpAddress => 'غلط IP ایڈریس۔';

  @override
  String get invalidPort => 'غلط پورٹ۔';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'کنیکٹ ہو رہا ہے: کوشش $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'کنیکٹ کرنے میں ناکام: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'ہوسٹنگ شروع کرنے میں ناکام: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'میزبان دریافت ہوا: $ip:$port';
  }

  @override
  String get stop => 'بند کریں';

  @override
  String get discover => 'دریافت کریں';

  @override
  String get connect => 'کنیکٹ کریں';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'کلائنٹ کنیکٹ ہو گیا: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'دریافت کر رہا ہے: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'دوبارہ کنیکٹ ہو رہا ہے ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'کنیکٹ ہو گیا';

  @override
  String get delete => 'حذف کریں';

  @override
  String get ancientEgypt => 'قدیم مصر';

  @override
  String get gothicIce => 'گوتھک برف';

  @override
  String get riceField => 'چاول کا کھیت';

  @override
  String get chinesePorcelain => 'چینی چینی مٹی کا برتن';

  @override
  String get desertDusk => 'صحرا کی شام';

  @override
  String get precisionCraft => 'درست دستکاری';

  @override
  String get folkEmbroidery => 'لوک کڑھائی';

  @override
  String get carpathianHeritage => 'کارپیتھین ورثہ';

  @override
  String get imperialGrandeur => 'شاہی عظمت';

  @override
  String get bohemianCrystal => 'بوہیمین کرسٹل';

  @override
  String get savannaSunrise => 'سوانا طلوع آفتاب';

  @override
  String get harmonyBalance => 'ہم آہنگی اور توازن';

  @override
  String get cinnamonSpice => 'دارچینی مصالحہ';

  @override
  String get anatolianMosaic => 'اناطولیائی موزیک';

  @override
  String get carnivalSpirit => 'کارنیوال روح';

  @override
  String get custom => 'رواج';

  @override
  String get spiceMarket => 'مصالحہ بازار';

  @override
  String get swipeToRevealTheDrawer => 'درج کو ظاہر کرنے کے لیے سوائپ کریں';

  @override
  String get showGameInfoOnScreenshots =>
      'اسکرین شاٹس پر گیم کی معلومات دکھائیں';

  @override
  String get humanMoveTime => 'انسانی وقت کی حد';

  @override
  String get noTimeLimitForHumanMoves =>
      'انسانی چالوں کے لیے وقت کی کوئی حد نہیں';

  @override
  String get timeoutLoseWillBeApplied =>
      'انسانی کھلاڑی کے لیے ٹائم آؤٹ ہار کا اطلاق ہوگا';

  @override
  String get identifyingBoard => 'گیم بورڈ کی شناخت ہو رہی ہے...';

  @override
  String get youCanEnterAnyModelName =>
      'آپ کسی بھی ماڈل کا نام درج کر سکتے ہیں۔';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'گیم بورڈ کی پوزیشن لاگو کر دی گئی۔ FEN کلپ بورڈ پر کاپی ہو گیا۔';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'تجویز: گیم بورڈ کی ایک صاف تصویر لینے کی کوشش کریں۔';

  @override
  String get llmPromptTemplate => 'LLM پرامپٹ ٹیمپلیٹ';

  @override
  String get noValidBoardDetected => 'کوئی درست گیم بورڈ نہیں ملا۔';

  @override
  String get selectingImageFromAlbum => 'البم سے تصویر منتخب کی جا رہی ہے...';

  @override
  String get configurePromptTemplate => 'پرامپٹ ٹیمپلیٹ ترتیب دیں';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'LLM تجزیہ کے لیے پرامپٹ ٹیمپلیٹ ترمیم کریں';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'پہچانے گئے بورڈ سے FEN بنانے میں ناکامی۔';

  @override
  String get outputInCurrentLanguage => 'موجودہ زبان میں آؤٹ پٹ';

  @override
  String get commonBaseUrls => 'عام Base URLs';

  @override
  String get viewCommonModels => 'عام ماڈلز دیکھیں';

  @override
  String get recognitionParametersUpdated =>
      'پہچان کے پیرامیٹرز اپ ڈیٹ ہو گئے۔';

  @override
  String get whiteSMove => 'سفید کا قدم';

  @override
  String get resetToDefaults => 'ڈیفالٹ ترتیبات پر ری سیٹ کریں';

  @override
  String get photoShoot => 'تصویر کھینچنا';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'پہچانے گئے بورڈ کی پوزیشن لاگو کرنے میں ناکامی۔';

  @override
  String get llmPromptContent => 'LLM پرامپٹ مواد';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM تشکیل نہیں ہے۔ براہ کرم اپنی ترتیبات چیک کریں۔';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'فراہم کنندہ، ماڈل، API Key، اور Base URL سیٹ کریں';

  @override
  String get llmConfiguration => 'LLM کنفیگریشن';

  @override
  String get configureLlmProvider => 'LLM فراہم کنندہ کو ترتیب دیں';

  @override
  String get llmPromptTemplateHeader => 'LLM پرامپٹ ٹیمپلیٹ ہیڈر';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'تصویر میں کوئی مہرے پہچانے نہیں گئے۔ براہ کرم دوبارہ کوشش کریں۔';

  @override
  String get recognizeBoardFromImage => 'تصویر سے گیم بورڈ پہچانیں';

  @override
  String get viewTips => 'مشورے دیکھیں';

  @override
  String get applyToBoard => 'بورڈ پر لاگو کریں';

  @override
  String get adjustBoardArea => 'بورڈ کے علاقے کو ایڈجسٹ کریں';

  @override
  String get viewCommonUrls => 'عام URLs دیکھیں';

  @override
  String get colorAnalysisFailed => 'رنگ کا تجزیہ ناکام ہو گیا!';

  @override
  String get analyzingGameBoardImage =>
      'گیم بورڈ کی تصویر کا تجزیہ کیا جا رہا ہے...';

  @override
  String get selectFromAlbum => 'البم سے منتخب کریں';

  @override
  String get noBoardPointDetected => 'کوئی بورڈ پوائنٹ نہیں ملا!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'اگر خالی چھوڑا گیا تو ڈیفالٹ ٹیمپلیٹ استعمال کیا جائے گا۔';

  @override
  String get llmConfig => 'LLM کنفیگریشن';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'کیا آپ واقعی پرامپٹ ٹیمپلیٹس کو ڈیفالٹ اقدار پر ری سیٹ کرنا چاہتے ہیں؟';

  @override
  String get llmPromptTemplateFooter => 'LLM پرامپٹ ٹیمپلیٹ فوٹر';

  @override
  String get loadingResponse => 'جواب لوڈ ہو رہا ہے...';

  @override
  String get applyThisResultToBoard => 'اس نتیجے کو بورڈ پر لاگو کریں';

  @override
  String get takingPicture => 'تصویر لی جا رہی ہے...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'براہ کرم شناخت کے لیے گیم بورڈ کی تصویر منتخب کریں';

  @override
  String get identificationResults => 'شناخت کے نتائج';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'حرکات کا تجزیہ کریں اور بصیرت فراہم کریں۔';

  @override
  String get getApiKey => 'API Key حاصل کریں';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'پوری پہچان کا عمل مکمل کرنے میں ناکامی۔';

  @override
  String get boardRecognitionResult => 'بورڈ پہچان کا نتیجہ';

  @override
  String get askLlm => 'LLM سے پوچھیں';

  @override
  String get boardDetectionFailed => 'بورڈ کی تلاش ناکام ہو گئی!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'کوئی بورڈ پوائنٹ نہیں ملا، مہرے کی شناخت نہیں ہو سکتی!';

  @override
  String get copyFen => 'FEN کاپی کریں';

  @override
  String get commonlyUsedModels => 'عام طور پر استعمال ہونے والے ماڈلز';

  @override
  String get apiKeyOptional => 'API Key (اختیاری)';

  @override
  String get noImageSelected => 'کوئی تصویر منتخب نہیں کی گئی';

  @override
  String get blackSMove => 'کالے کا قدم';

  @override
  String get llm => 'بڑا لسانی ماڈل';

  @override
  String get llmProvider => 'فراہم کنندہ';

  @override
  String get baseUrl => 'بنیادی URL';

  @override
  String get model => 'ماڈل';

  @override
  String get temperature => 'درجہ حرارت';

  @override
  String get llmCommandReceivedProcessing =>
      'حکم موصول! اے آئی پروسیسنگ کر رہی ہے...';

  @override
  String get llmDeepThinkingWait => 'گہری سوچ جاری ہے، براہ کرم انتظار کریں...';

  @override
  String get llmPresentingSoon => 'جلد پیش کیا جائے گا...';

  @override
  String get recognitionParameters => 'پہچان کے پیرامیٹرز';

  @override
  String get adjustParamsDesc =>
      'پہچان کی درستگی بہتر بنانے کے لیے پیرامیٹرز کو ایڈجسٹ کریں';

  @override
  String get saveParameters => 'پیرامیٹرز محفوظ کریں';

  @override
  String unableToStartImageRecognition(String error) {
    return 'امیج ریکگنیشن شروع نہیں ہو سکی: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'امیج ریکگنیشن ناکام ہوئی: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return '$whiteCount سفید اور $blackCount سیاہ مہروں کے ساتھ پوزیشن لاگو کی گئی';
  }

  @override
  String get fenCopiedToClipboard => '(FEN کلپ بورڈ میں کاپی ہو گیا ہے)';

  @override
  String recognitionFailed(String error) {
    return 'پہچان ناکام ہوئی: $error';
  }

  @override
  String get myRating => 'میری درجہ بندی';

  @override
  String get gamesPlayed => 'کھیلے گئے گیمز';

  @override
  String get wins => 'جیت';

  @override
  String get losses => 'ہار';

  @override
  String get draws => 'برابر';

  @override
  String get lastUpdated => 'آخری بار اپ ڈیٹ کیا گیا';

  @override
  String get format => 'فارمیٹ:';

  @override
  String get resetStatistics => 'شماریات کو ری سیٹ کریں';

  @override
  String get drawRate => 'برابری کی شرح';

  @override
  String get lossRate => 'ہار کی شرح';

  @override
  String get aiStatistics => 'AI شماریات';

  @override
  String get enableStatistics => 'شماریات کو فعال کریں';

  @override
  String get enableStatistics_Detail =>
      'فعال ہونے پر، گیم کے نتائج شماریات میں ریکارڈ کیے جائیں گے۔ تاہم، ٹیک بیکس پر مشتمل گیمز ریکارڈ نہیں کیے جائیں گے۔ غیر فعال ہونے پر، شماریات جمع کرنا روک دیا جاتا ہے۔';

  @override
  String get thisWillResetAllGameStatistics =>
      'یہ گیم کے تمام شماریات کو ری سیٹ کر دے گا۔ اس کارروائی کو کالعدم نہیں کیا جا سکتا۔';

  @override
  String get boardInnerRingSize => 'بورڈ کی اندرونی انگوٹھی کا سائز';

  @override
  String get boardShadowEnabled => 'بورڈ کا سایہ';

  @override
  String get trapAwareness => 'جال کی شناخت';

  @override
  String get trapAwarenessDescription =>
      'تجزیے کے دوران موٹے دائروں اور تیروں کے ساتھ جال کی چالوں کو نمایاں کریں.';

  @override
  String trapExists(String trapMoves) {
    return 'جال موجود ہے۔ جال کی چالیں: $trapMoves';
  }

  @override
  String get custodianCapture => 'فلانکنگ کیپچر';

  @override
  String get custodianCaptureDescription =>
      'اپنے حریف کے ایک ٹکڑوں کو اپنے دو کے درمیان سیدھے لکیر میں منسلک کریں۔';

  @override
  String get custodianCaptureEnable => 'فلانکنگ کی گرفتاری کی اجازت دیں';

  @override
  String get interventionCapture => 'مداخلت کی گرفتاری';

  @override
  String get interventionCaptureDescription =>
      'اپنے حریف کے دو ٹکڑوں کے درمیان خالی نقطہ میں جائیں تاکہ ان دونوں کو پکڑ سکے۔';

  @override
  String get interventionCaptureEnable => 'مداخلت کی گرفتاری کی اجازت دیں';

  @override
  String get leapCapture => 'جمپ کیپچر';

  @override
  String get leapCaptureDescription =>
      'ملحقہ حریف کے ٹکڑے کو چھلانگ لگا کر اس سے باہر خالی نقطہ پر گرفت کریں۔';

  @override
  String get leapCaptureEnable => 'چھلانگ کی گرفتاری کی اجازت دیں';

  @override
  String get captureApplicableLines => 'قابل اطلاق لائنیں';

  @override
  String get captureSquareEdges => 'مربع کے کناروں کے ساتھ';

  @override
  String get captureCrossLines =>
      'مربع کو عبور کرنے والے آرتھوگونل لائنوں کے ساتھ';

  @override
  String get captureDiagonalLines => 'مربع عبور کرنے والے اخترن لائنوں کے ساتھ';

  @override
  String get captureExecutionPhases => 'پھانسی کے مراحل';

  @override
  String get capturePiecesCondition =>
      'باقی ٹکڑوں کی بنیاد پر چلنے والے مرحلے کے دوران دستیابی';

  @override
  String get capturePiecesConditionUnlimited => 'کوئی پابندی نہیں';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'جب آپ کے پاس تین یا کم ٹکڑے ہوں تو دستیاب ہے';
}
