// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Ukrainian (`uk`).
class SUk extends S {
  SUk([String locale = 'uk']) : super(locale);

  @override
  String get appName => 'Млин';

  @override
  String get welcome => 'Ласкаво просимо';

  @override
  String get yes => 'Так';

  @override
  String get no => 'Ні';

  @override
  String get game => 'Гра';

  @override
  String get humanVsAi => 'Людина проти ШІ';

  @override
  String get humanVsHuman => 'Людина проти Людський';

  @override
  String get aiVsAi => 'ШІ проти ШІ';

  @override
  String get humanVsCloud => 'Людина проти Хмара';

  @override
  String get humanVsLAN => 'Людина проти LAN';

  @override
  String get testViaLAN => 'Тест через локальну мережу';

  @override
  String get move => 'Рухатися';

  @override
  String get showMoveList => 'Показати список ходів';

  @override
  String get moveList => 'Перемістити список';

  @override
  String get noGameRecord => 'Немає запису';

  @override
  String get ok => 'гаразд';

  @override
  String get confirm => 'Підтвердити';

  @override
  String get cancel => 'Скасувати';

  @override
  String get tipSelectWrong => 'Ви обрали неправильну фішку.';

  @override
  String get tipPlace => 'Розмістіть свої фішки.';

  @override
  String get tipBanPlace => 'Ви не можете розмістити його тут.';

  @override
  String get tipPlaced => 'Частина розміщена.';

  @override
  String get tipRemove => 'Видаліть шматочок.';

  @override
  String get tipBanRemove => 'Ви не можете видалити його.';

  @override
  String get tipRemoved => 'Частину вилучено.';

  @override
  String get tipMove => 'Перемістіть фігуру.';

  @override
  String get tipCannotPlace => 'Ви не можете помістити свій шматок тут.';

  @override
  String get tipCannotMove => 'Ви не можете перемістити свій шматок сюди.';

  @override
  String get tipMill => 'Млин! Візьміть фігуру суперника.';

  @override
  String get tipContinueMill => 'Продовжуйте забирати фігуру суперника.';

  @override
  String get tipSelectOpponentsPiece => 'Виберіть одну з фігур противника.';

  @override
  String get tipCannotRemovePieceFromMill => 'Не можна зняти шматок з млина.';

  @override
  String get tipCanMoveOnePoint => 'Фішка може переміститися на 1 очко.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Ви не можете переміщати фігури суперника.';

  @override
  String get tipSelectPieceToMove => 'Виберіть свій фрагмент для переміщення.';

  @override
  String get tipHaveThreePiecesLeft => 'У вас залишилося три фішки.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Ви можете рухатися в будь-яку точку, яка вам подобається.';

  @override
  String tipToMove(Object player) {
    return '$player для переміщення.';
  }

  @override
  String get whiteWin => 'Гравець 1 перемагає!';

  @override
  String get blackWin => 'Гравець 2 перемагає!';

  @override
  String get won => 'Виграв';

  @override
  String get lost => 'Програл';

  @override
  String get thinking => 'Думаючи…';

  @override
  String get newGame => 'Нова гра';

  @override
  String get importGame => 'Імпортна гра';

  @override
  String get exportGame => 'Експортна гра';

  @override
  String get gameImported => 'Гра імпортована.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Не вдається імпортувати $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Ходи і правила не збігаються.';

  @override
  String get pleaseWait => 'Будь ласка, зачекайте.';

  @override
  String get restartGame => 'Перезапустити поточну гру?';

  @override
  String get restart => 'Перезапустіть';

  @override
  String get gameStarted => 'Гра розпочалася, будь ласка, місце.';

  @override
  String get analyzing => 'Аналізуючи…';

  @override
  String error(Object message) {
    return 'Помилка: $message';
  }

  @override
  String get winRate => 'Рейтинг перемог';

  @override
  String get score => 'Оцінка:';

  @override
  String get white => 'Гравець 1';

  @override
  String get black => 'Гравець 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player кількість штук менше трьох.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player подав у відставку.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player не має шляху.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Плата заповнена, і $player не має можливості піти.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Час закінчився, $player втрачено.';
  }

  @override
  String get drawReasonRule50 =>
      'У фазі переміщення жодна фігура не була вилучена за останню певну кількість ходів.';

  @override
  String get drawReasonBoardIsFull => 'Це нічия, тому що дошка заповнена.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Це нічия через триразове повторення.';

  @override
  String get gameOverUnknownReason => 'Кінець гри! Невідома причина.';

  @override
  String get gameOver => 'Кінець гри';

  @override
  String get youWin => 'Ти виграв! Вітаю!';

  @override
  String challengeHarderLevel(int level) {
    return 'Кинути виклик на більш складний рівень? Новим рівнем буде рівень $level!';
  }

  @override
  String get youLose => 'Ти програв!';

  @override
  String get analyze => 'Аналізуйте';

  @override
  String get about => 'Про';

  @override
  String version(Object versionNumber) {
    return 'Версія: $versionNumber';
  }

  @override
  String get thanks => 'Дякую';

  @override
  String get settings => 'Налаштування';

  @override
  String get options => 'Опції';

  @override
  String get generalSettings => 'Загальні налаштування';

  @override
  String get skillLevel => 'Рівень складності';

  @override
  String get moveTime => 'Час мислення AI';

  @override
  String get difficulty => 'Труднощі';

  @override
  String get playSounds => 'Звукові ефекти';

  @override
  String get playSoundsInTheGame => 'Відтворюйте звуки в грі';

  @override
  String get keepMuteWhenTakingBack => 'Зберігайте мовчання, коли повертаєте';

  @override
  String get tone => 'Тон';

  @override
  String get whoMovesFirst => 'Перший хід';

  @override
  String get human => 'Людський';

  @override
  String get ai => 'ШІ';

  @override
  String get alternate => 'Черговий';

  @override
  String get isAutoRestart =>
      'Автоматичний перезапуск гри після завершення гри';

  @override
  String get isAutoChangeFirstMove => 'Автоматична зміна першого ходу';

  @override
  String get shufflingEnabled => 'Рухайтеся довільно';

  @override
  String get misc => 'Різне';

  @override
  String get rules => 'правила';

  @override
  String get piecesCount => 'Кількість фігур у кожного гравця';

  @override
  String get piecesCount_Detail => 'Скільки фігур у кожного гравця?';

  @override
  String get flyPieceCount => 'Номер літаючого шматка';

  @override
  String get flyPieceCount_Detail =>
      'Якщо політ увімкнено, коли кількість фігур гравця падає нижче певного порогу, його фігури можуть вільно переміщатися на будь-яку незайняту точку, а не обмежуватися сусідніми точками, як у решті гри.';

  @override
  String get piecesAtLeastCount => 'Принаймні шматочки';

  @override
  String get hasDiagonalLines => 'Діагональні лінії';

  @override
  String get hasDiagonalLines_Detail =>
      'Додайте чотири діагональні лінії на дошку.';

  @override
  String get isDefenderMoveFirst => 'Другий гравець рухається першим';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Гравець, який йде другим у фазі розміщення, переходить першим у фазі переміщення.';

  @override
  String get mayRemoveMultiple => 'Багаторазове видалення';

  @override
  String get mayRemoveMultiple_Detail =>
      'Якщо гравець закриває більше одного млина одночасно, він видаляє кількість закритих млинів.';

  @override
  String get mayRemoveFromMillsAlways => 'Знищити млини';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'За замовчуванням гравці повинні спочатку видалити будь-які інші шматки, перш ніж витягти шматок зі сформованого млина. Увімкніть цей параметр, щоб вимкнути обмеження.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Другий гравець програє, коли дошка заповнена';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Коли дошка заповнена наприкінці фази розміщення, сторона, яка займає першою, програє. Інакше гра – нічия.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Програйте, коли немає жодних законних кроків';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Гравець програє, якщо його супротивник заблокує їх, щоб їх не можна було перемістити. Змініть сторону, щоб перемістити, якщо ця опція вимкнена.';

  @override
  String get mayFly => 'Політ';

  @override
  String get mayFly_Detail =>
      'Якщо у гравця залишилося лише три або чотири (конфігуровані) фігури, він може перемістити фігуру на будь-яку вільну точку.';

  @override
  String get nMoveRule => 'Правило N-переміщення';

  @override
  String get nMoveRule_Detail =>
      'Гра вважається нічиєю, якщо за певну кількість ходів не було видалення.';

  @override
  String get rollback => 'Відкат';

  @override
  String get pleaseSelect => 'Виберіть будь ласка';

  @override
  String get copy => 'Копія';

  @override
  String get moveHistoryCopied =>
      'Історію переміщення скопійовано в буфер обміну.';

  @override
  String get help => 'Допоможіть';

  @override
  String get feedback => 'Зворотній зв\'язок';

  @override
  String get exit => 'Вихід';

  @override
  String get ruleSettings => 'Налаштування правила';

  @override
  String get color => 'Колір';

  @override
  String get boardColor => 'Колір дошки';

  @override
  String get pieceColor => 'Колір шматка';

  @override
  String get backgroundColor => 'Колір фону';

  @override
  String get lineColor => 'Колір лінії дошки';

  @override
  String get whitePieceColor => 'Гравець 1 шт. колір';

  @override
  String get blackPieceColor => 'Колір гравця 2 шт';

  @override
  String get messageColor => 'Колір повідомлення';

  @override
  String get isPieceCountInHandShown =>
      'Показати кількість нерозставлених фігур';

  @override
  String get isNotationsShown => 'Показати позначення на борту';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Показати панель інструментів навігації історії';

  @override
  String get display => 'Дисплей';

  @override
  String get boardBorderLineWidth => 'Ширина кордону дошки';

  @override
  String get boardInnerLineWidth => 'Ширина внутрішньої лінії дошки';

  @override
  String get pieceWidth => 'Ширина шматка';

  @override
  String get fontSize => 'Розмір шрифту';

  @override
  String get standardNotation => 'Позначення ЗМЗ';

  @override
  String get restore => 'Відновлювати';

  @override
  String get restoreDefaultSettings =>
      'Відновити налаштування за замовчуванням';

  @override
  String pick(Object element) {
    return 'Виберіть $element';
  }

  @override
  String get info => 'Інф.';

  @override
  String get hint => 'Підказка';

  @override
  String get player => 'гравець';

  @override
  String get player1 => 'Гравець 1';

  @override
  String get player2 => 'Гравець 2';

  @override
  String get howToPlay => 'Як грати';

  @override
  String get toPlacePiece =>
      'Торкніться будь-якої доступної точки, щоб розмістити шматок.';

  @override
  String get toSelectPiece => 'Натисніть на шматок, щоб перемістити його.';

  @override
  String get toMovePiece =>
      'Торкніться точки, пов’язаної з фрагментом, щоб перемістити його.';

  @override
  String get toRemovePiece =>
      'Торкніться однієї з фігур супротивника, щоб видалити її.';

  @override
  String get needToCreateMillFirst =>
      'Перш ніж видалити шматок, вам потрібно створити млин.';

  @override
  String get needToPlayWithOwnPieces =>
      'Вам потрібно грати зі своїми фігурами.';

  @override
  String get statistics => 'Статистика';

  @override
  String get totalGames => 'Всього ігор';

  @override
  String get results => 'Результати';

  @override
  String get left => 'ліворуч';

  @override
  String get privacyPolicy => 'Політика конфіденційності';

  @override
  String get privacyPolicy_Detail_1 =>
      'Будь ласка, прочитайте уважно і переконайтеся, що ви повністю розумієте та погоджуєтеся з цим ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Якщо ви не згодні з цією Політикою, не використовуйте цю програму. Використання програми означає, що ви приймаєте ці умови.';

  @override
  String get and => ' і ';

  @override
  String get accept => 'Прийняти';

  @override
  String get takeBack => 'Повертати';

  @override
  String get takingBack => 'Повернення…';

  @override
  String get waiting => 'Очікування…';

  @override
  String get stepForward => 'Крок вперед';

  @override
  String get takeBackAll => 'Забери все назад';

  @override
  String get stepForwardAll => 'Всі кроки вперед';

  @override
  String get moveNow => 'Рухайтеся зараз';

  @override
  String get done => 'Готово.';

  @override
  String get crackMill => 'Крік-млин';

  @override
  String get crackMill_Detail =>
      'Якщо гравець має лише фігури в млинах, фігури в млинах не блокуються, щоб видалити.';

  @override
  String get animationDuration => 'Тривалість анімації';

  @override
  String get none => 'Жодного';

  @override
  String get theme => 'Тема';

  @override
  String get helpContent =>
      'Мета гри – залишити супернику менше трьох фігур або залишити жодного допустимого ходу. \n\nГра автоматично завершує нічию, якщо позиція виникає втретє або не відбувається жодного видалення протягом останніх 100 (настроюваних) ходів. \n\nГра проходить у три етапи: \n\n1. Розміщення фігур на вільних точках \n2. Переміщення фігур на сусідні точки \n3. (додаткова фаза) Переміщення фігур у будь-яку вільну точку, коли гравець зменшується до трьох фігур \n\nРозміщення \n\nГра починається з порожнього поля, яке складається з сітки з двадцятьма чотирма точками. Гравці по черзі розміщують свої фігури на вільних точках, поки кожен гравець не розмістить усі фігури на дошці. Якщо гравець може поставити три свої фігури прямо, він має «млин» і може видалити одну з фігур свого суперника з дошки. \n\nУ деяких наборах правил гравці повинні спочатку видалити будь-які інші частини, перш ніж витягти частину зі сформованого млина. \n\nЗгідно з певними правилами, ви не можете знову розміщувати фігури на точках, з яких фігури були видалені. \n\nКоли всі фігури розставлені, гравці по черзі пересувають їх. \n\nПереїзд \n\nДля переміщення гравець переміщує одну зі своїх фігур уздовж лінії дошки до вільної сусідньої точки. Якщо він не може, він програє гру. Гравець, який вирівнює три свої фігури на лінії дошки, має млин і може видалити одну з фігур свого суперника, як у фазі розміщення. Якщо гравець зменшується до двох частин, він не має можливості створити нові млини, і, отже, програє гру. Гравець також може програти, коли більше трьох фігур, якщо його суперник блокує їх рух. \n\nполіт \n\nУ деяких варіантах правил, якщо у гравця залишилося лише три фігури, їхні фігури можуть літати, стрибати або стрибати на будь-які вільні точки, а не лише на сусідні.\n';

  @override
  String get versionInfo => 'Інформація про версію';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Ліцензія';

  @override
  String get sourceCode => 'Вихідний код';

  @override
  String get appVersion => 'Версія програми';

  @override
  String get general => 'Генеральний';

  @override
  String get advanced => 'Розширений';

  @override
  String get placing => 'Розміщення';

  @override
  String get moving => 'Переїзд';

  @override
  String get removing => 'Видалення';

  @override
  String get gameOverCondition => 'Умова гри закінчена';

  @override
  String get aisPlayStyle => 'Стиль гри ШІ';

  @override
  String get passive => 'Пасивний';

  @override
  String get timeout => 'Час вийшов';

  @override
  String get appearance => 'Зовнішній вигляд';

  @override
  String get drawOnHumanExperience => 'Спирайтеся на людський досвід';

  @override
  String get considerMobility => 'Враховуйте рухливість частин';

  @override
  String get pieceCount => 'Кількість штук:';

  @override
  String inHand(Object player, int count) {
    return '$player у руці: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player на борту: $count';
  }

  @override
  String get boardTop => 'Зміщення дошки від верху';

  @override
  String get notAIsTurn => 'Настала черга ШІ.';

  @override
  String get aiIsNotThinking => 'ШІ не думає.';

  @override
  String get atEnd => 'Ви в кінці списку переміщень.';

  @override
  String get tapBackAgainToLeave => 'Знову торкніться Назад, щоб вийти.';

  @override
  String get more => 'Більше';

  @override
  String get experimental => 'Це експериментальна функція.';

  @override
  String get experiments => 'Експерименти';

  @override
  String get ossLicenses => 'Ліцензії з відкритим кодом';

  @override
  String get language => 'Мову';

  @override
  String get defaultLanguage => 'Мова за замовчуванням';

  @override
  String get mayMoveInPlacingPhase =>
      'Фрагменти можуть рухатися на етапі розміщення';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Немає чітких фаз розміщення та переміщення, тобто гравці можуть при кожному ході вирішувати, чи хочуть вони розмістити фігуру на дошці, чи перемістити одну зі своїх фігур (за умови, що у них залишилися фігури).';

  @override
  String get drawerColor => 'Колір меню';

  @override
  String get drawerTextColor => 'Колір тексту меню';

  @override
  String get drawerHighlightItemColor => 'Колір виділення пункту меню';

  @override
  String get mainToolbarBackgroundColor =>
      'Колір фону основної панелі інструментів';

  @override
  String get mainToolbarIconColor =>
      'Колір значка головної панелі інструментів';

  @override
  String get navigationToolbarBackgroundColor =>
      'Колір фону панелі інструментів навігації';

  @override
  String get navigationToolbarIconColor =>
      'Колір значка панелі інструментів навігації';

  @override
  String get autoHideToolbar => 'Автоматично приховати панель інструментів';

  @override
  String get toolbarLocationOnScreen =>
      'Розташування панелі інструментів на екрані';

  @override
  String get top => 'Топ';

  @override
  String get bottom => 'Нижня частина';

  @override
  String get center => 'Центр';

  @override
  String get solidColor => 'Суцільний колір';

  @override
  String get picture => 'Картина';

  @override
  String get chooseYourPicture => 'Виберіть своє зображення';

  @override
  String get light => 'Світло';

  @override
  String get dark => 'Темний';

  @override
  String get themes => 'Теми';

  @override
  String get currentTheme => 'Актуальна тема';

  @override
  String get saveTheme => 'Зберегти тему';

  @override
  String get showAnalysisGraph => 'Показати графік аналізу';

  @override
  String get analysis => 'Аналіз';

  @override
  String get saveGame => 'Зберегти гру';

  @override
  String get loadGame => 'Завантажити гру';

  @override
  String get setupPosition => 'Позиція налаштування';

  @override
  String get showLegalMoves => 'Покажіть законні ходи';

  @override
  String get showLastMove => 'Показати останній хід';

  @override
  String get showArrows => 'Показати стрілки';

  @override
  String get pieces => 'шматочки';

  @override
  String get showAnalysis => 'Показати аналіз';

  @override
  String get threads => 'Нитки';

  @override
  String get getInvolved => 'Бути втягнутим';

  @override
  String get helpImproveTranslate => 'Допоможіть покращити переклад';

  @override
  String get tutorial => 'Підручник';

  @override
  String get classicMill => 'Класичний млин';

  @override
  String get mixedMill => 'Змішаний млин';

  @override
  String get ceylonMill => 'Цейлонський млин';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Млин може неодноразово ламатися і перероблятися';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Якщо гравець розбиває млин, щоб негайно сформувати новий, він може перемістити цю фігуру назад у початкову точку своїм наступним ходом, якщо вона утворює нову млин.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Гра вважається нічиєю, якщо гравець має три фігури і після десяти ходів жоден із гравців не знімає фігури суперника';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Коли гравець має три фігури, і жоден гравець не може зняти фігуру суперника протягом десяти ходів, гра вважається нічиєю.';

  @override
  String get close => 'Закрити';

  @override
  String get whitePiece => 'Білий шматок';

  @override
  String get blackPiece => 'Чорний шматок';

  @override
  String get emptyPoint => 'Порожня точка';

  @override
  String get noPoint => 'Немає сенсу';

  @override
  String get placingPhase => 'Фаза розміщення';

  @override
  String get movingPhase => 'Фаза руху';

  @override
  String get flyingPhase => 'Фаза польоту';

  @override
  String sideToMove(Object player) {
    return 'Сторона для переміщення: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Останній хід: $move';
  }

  @override
  String get selected => 'Вибрано';

  @override
  String get accessibility => 'Доступність';

  @override
  String get screenReaderSupport => 'Підтримка програми зчитування з екрана';

  @override
  String get isDraw => 'Це нічия!';

  @override
  String get draw => 'Нічия';

  @override
  String get pieceHighlightColor => 'Колір виділення шматка';

  @override
  String get algorithm => 'Алгоритм';

  @override
  String get endgameNMoveRule => 'Правило N-Move в кінці гри';

  @override
  String get endgameNMoveRule_Detail =>
      'Гра вважається нічиєю, якщо будь-який гравець має лише три фігури і жоден гравець не знімає жодної фігури протягом певних ходів.';

  @override
  String get drawReasonEndgameRule50 =>
      'Кожен із гравців має лише три фігури, і жоден гравець не знімає жодної фігури протягом певних ходів.';

  @override
  String get threefoldRepetitionRule => 'Правило триразового повторення';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Гра вважається нічиєю, якщо позиція виявляється втретє.';

  @override
  String get continueToMakeMove => 'Млин! Продовжуйте робити рух.';

  @override
  String get pointStyle => 'Точковий стиль';

  @override
  String get pointWidth => 'Ширина точки';

  @override
  String get solid => 'Тверда';

  @override
  String get hollow => 'Порожнистий';

  @override
  String get languageName => 'Українська';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Рухає',
      one: '$count Переїхати',
      zero: 'Переїхати',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Не вдалося завантажити.';

  @override
  String get filename => 'Ім\'я файлу';

  @override
  String get browse => 'Перегляд…';

  @override
  String get gameFiles => 'Файли гри';

  @override
  String get gameSavedTo => 'Гра збережена в';

  @override
  String get empty => 'Порожній';

  @override
  String get noMove => 'Жодного руху.';

  @override
  String get restoredPosition => 'Відновлено початкове положення.';

  @override
  String get clean => 'чистий';

  @override
  String get cleanedUp => 'Прибраний.';

  @override
  String get remove => 'видалити';

  @override
  String get noPiecesCanBeRemoved => 'Жоден фрагмент не можна видалити.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count piece',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 потрібно видалити.';
  }

  @override
  String placedCount(int count) {
    return 'Розм. ($count)';
  }

  @override
  String get placedPieceCount =>
      'Підрахунок розміщених фігур на етапі розміщення.';

  @override
  String hasPlacedPieceCount(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Поточний гравець розмістив $count фішок.',
      one: 'Поточний гравець розмістив одну фішку.',
      zero: 'Поточний гравець не розмістив жодної фігури.',
    );
    return '$_temp0';
  }

  @override
  String get notPlacingPhase => 'Не розміщуючи фазу, не можна її змінити.';

  @override
  String get paste => 'Вставити';

  @override
  String get pasteDone => 'Паста готова.';

  @override
  String get cannotPaste => 'Неможливо вставити.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Показати нерозставлені та видалені частини';

  @override
  String get fullScreen => 'Повноекранний';

  @override
  String get reopenToTakeEffect =>
      'Вийдіть і знову відкрийте програму, щоб налаштування вступили в силу.';

  @override
  String get forest => 'Ліс';

  @override
  String get desktopImage => 'Зображення робочого столу';

  @override
  String get invalidPosition => 'Недійсна позиція.';

  @override
  String get shareGIF => 'Поділіться GIF';

  @override
  String get pixelRatio => 'Співвідношення пікселів';

  @override
  String get duration => 'Тривалість';

  @override
  String get gameScreenRecorder => 'Диктофон ігрового екрану';

  @override
  String get previous => 'Попередній';

  @override
  String get next => 'Далі';

  @override
  String get skip => 'Пропустити';

  @override
  String get gotIt => 'Зрозумів';

  @override
  String get youCanModifyRules =>
      'Ви можете змінити правила гри в налаштуваннях правил.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Ви можете використовувати коліщатко миші, щоб налаштувати значення в панелі вибору.';

  @override
  String get noTimeLimitForThinking =>
      'Час мислення штучного інтелекту, встановлений на 0, означає відсутність обмеження часу на мислення.';

  @override
  String get whatIsMtdf =>
      'MTD(f) — це модифікована форма альфа-бета-алгоритму пошуку, спрямована на підвищення ефективності шляхом повторного використання проміжних результатів пошуку та використання правильного початкового припущення для звуження простору пошуку.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Майте на увазі, що налаштування часу мислення ШІ може бути не зовсім точним. Фактичний час на обдумування може бути коротшим, якщо рівень складності встановлено на нижче значення, і може бути довшим, коли штучний інтелект знаходиться на середині обдумування, коли час закінчується.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Якщо встановити високий рівень складності, але не збільшити час на обдумування ШІ, фактичний рівень складності може бути обмежений нижчим значенням через обмеження часу на обдумування. Фактичне значення може відрізнятися залежно від продуктивності машини.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) — це алгоритм пошуку для пошуку найкращого ходу в даній позиції. Це покращення альфа-бета-алгоритму та використовує нульовий або нульовий пошук у вікні, щоб підтвердити, що хід є гіршим або не гіршим, ніж уже безпечний результат основного варіанту. PVS фокусується на найбільш перспективних рухах і уникає непотрібних пошуків неоптимальних гілок, що сприяє підвищенню ефективності пошуку.';

  @override
  String get whatIsAlphaBeta =>
      'Альфа-бета-алгоритм — це алгоритм пошуку для пошуку найкращого ходу. Він використовує мінімаксний принцип і два значення, альфа і бета, для скорочення дерева пошуку та підвищення ефективності. Альфа представляє мінімальний бал, який комп’ютер впевнений, що може отримати, тоді як бета представляє максимальний бал, який може отримати його опонент. Алгоритм допомагає комп’ютеру приймати розумні ефективні рішення в грі.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Згідно з людським досвідом, намагаючись виграти, ви програєте. Натомість поставте собі за мету нічию та уникайте програшу. Спостерігайте за своїм суперником і обережно заманюйте його в позицію, де він може зробити помилку. Коли вони виявляють слабкість, скористайтеся нагодою і обережно домагайтеся перемоги. Таким чином ви можете виграти гру.';

  @override
  String get firstMoveDetail =>
      'У цій грі другому гравцеві легше виграти, ніж першому.';

  @override
  String get passiveDetail =>
      'Увімкнення параметра Passive змусить ШІ розслабитися, коли він має перевагу в позиції, а не агресивно намагатися виграти якомога швидше.';

  @override
  String get moveRandomlyDetail =>
      'Увімкнення цієї опції збільшує випадковість і задоволення від гри, а вимкнення може допомогти вивчити способи перемогти ШІ.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Якщо штучний інтелект враховує рухливість своїх фігур, він не лише намагатиметься захопити фігури супротивника якомога швидше, але також розглядатиме можливість блокування рухів супротивника та запобігання йому робити те ж саме.';

  @override
  String get whenBoardIsFull => 'Коли дошка повна';

  @override
  String get whenBoardIsFull_Detail =>
      'Наприкінці фази розміщення, перед початком фази переміщення, дія починається, якщо дошка заповнена фігурами.';

  @override
  String get sideToMoveRemovePiece =>
      'Гравець, який йде першим у фазі руху, знімає одну з фігур суперника.';

  @override
  String get agreeToDraw => 'Обидві сторони погоджуються на нічию.';

  @override
  String get takeOpponentsPiece => 'Візьміть одну з фігур суперника.';

  @override
  String get firstPlayerLose => 'Перший гравець програє гру.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Перший і другий гравці знімають одну з фігур суперника.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Другий і перший гравці знімають одну з фігур суперника.';

  @override
  String get enteredFlyingPhase =>
      'Тепер у фазі польоту фігури супротивника можуть стрибати на будь-яку порожню точку на дошці. Ви можете вимкнути правило польоту в «Налаштуваннях правил».';

  @override
  String get whenStalemate => 'Коли пат';

  @override
  String get whenStalemate_Detail =>
      'Яка дія виконується, якщо жодну фігуру не можна перемістити?';

  @override
  String get endWithStalemateLoss =>
      'Закінчується програшем у глухий кут для заблокованої сторони.';

  @override
  String get changeSideToMove => 'Змініть сторону для руху.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Видаліть одну з фігур супротивника і зробіть наступний хід.';

  @override
  String get endWithStalemateDraw => 'Закінчиться нічиєю.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Видаліть одну з фігур супротивника та змініть бік руху.';

  @override
  String get aiResponseDelayTime => 'Час затримки відповіді ШІ';

  @override
  String get aiIsDelaying =>
      'Наразі штучний інтелект перебуває у фазі відкладеної реакції. Зачекайте деякий час, перш ніж продовжити.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Ви не можете видалити несусідний фрагмент.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'У безвихідній ситуації ви можете видалити фігури супротивника поруч із вашими, незважаючи на форму млинів.';

  @override
  String get whatIsMcts =>
      'MCTS — це зручний для початківців алгоритм, який приймає рішення, досліджуючи та оцінюючи різні рухи за допомогою моделювання.';

  @override
  String get goldenJade => 'Золотий нефрит';

  @override
  String get forestWood => 'лісовий ліс';

  @override
  String get darkMystery => 'Темна таємниця';

  @override
  String get midnightBlue => 'Синій опівночі';

  @override
  String get greenForest => 'Зелений ліс';

  @override
  String get greenMeadow => 'Зелений Луг';

  @override
  String get stonyPath => 'Кам\'яний шлях';

  @override
  String get pastelPink => 'Пастельно-рожевий';

  @override
  String get turquoiseSea => 'Бірюзове море';

  @override
  String get violetDream => 'Фіолетовий сон';

  @override
  String get mintChocolate => 'М\'ятний шоколад';

  @override
  String get skyBlue => 'Блакитне небо';

  @override
  String get playfulGarden => 'Грайливий сад';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Алгоритм ретроградного аналізу використовує багатозначний ретроградний аналіз для створення бази даних ендшпілю з різних початкових позицій, а потім застосовує цю базу даних для оптимізації ігрового процесу. Цей підхід відноситься до категорії надміцних рішень.';

  @override
  String get viewAlgorithmGuide =>
      'Бажаєте переглянути посібник користувача для цього алгоритму?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Показати індикатор позиційної переваги';

  @override
  String get usePerfectDatabase => 'Використовуйте ідеальну базу даних';

  @override
  String get perfectDatabaseDescription =>
      'Увімкніть цей параметр, щоб використовувати бездоганну базу даних ігор, згенеровану за допомогою передових алгоритмів. Ця функція об’єднує стратегії відкриття та завершення гри, щоб пропонувати оптимальні ходи. Це кращий вибір для гравців, які прагнуть найвищого рівня точності в ігровому процесі. Створена за допомогою ретельної обчислювальної техніки, база даних розроблена, щоб запропонувати майже ідеальні ігрові рішення. \n\nПримітка: якщо штучному інтелекту не вдається отримати доступ до бази даних, він звернеться до звичайних алгоритмів для прийняття ігрових рішень. Коли база даних доступна, «Рівень складності» стає практично неперевершеним, а «Час на роздуми ШІ» різко скорочується. Багато налаштувань у параметрах «Стилю гри ШІ» буде замінено, оскільки результати бази даних мають найвищий пріоритет. \n\nЩоб отримати вказівки щодо того, як максимально використати цю бездоганну базу даних, натисніть тут.';

  @override
  String get backgroundImage => 'Фонове зображення';

  @override
  String get whatIsRandom =>
      'Якщо параметр «Використовувати ідеальну базу даних» не ввімкнуто, параметр «Випадковий» змушує ШІ переміщати фігури випадковим чином без використання будь-яких алгоритмів для вибору ходу. Це зазвичай призводить до значно слабшого ігрового процесу. І навпаки, коли ввімкнуто «Використовувати ідеальну базу даних», ШІ покладається виключно на «Ідеальну базу даних» для прийняття рішень, замість того, щоб поєднувати її з традиційними алгоритмами ШІ. У цьому режимі дії штучного інтелекту повністю базуються на вмісті бази даних, уникаючи покладення на обчислення в реальному часі або алгоритми пошуку.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Видаліть фішку(-и) суперника з його руки; потім хід суперника.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'При формуванні млинів під час фази розстановки';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Видаліть фішку(-и) суперника з дошки.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Видаліть фішку(-и) суперника з дошки; потім хід суперника.';

  @override
  String get opponentRemovesOwnPiece =>
      'Суперник видаляє власну(-і) фішку(-и) з дошки.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Замість вашої дії, суперник сам обирає і видаляє власну(-і) фішку(-и) з дошки, фактично здійснюючи дію, що шкодить йому самому.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Видаліть фішку(-и) суперника з його руки; потім ваш хід.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Видаліть фішку(-и) з руки суперника. Якщо згідно з налаштуванням Multi-remove потрібно видалити декілька фішок, а в суперника не залишилося фішок в руці, продовжуйте видаляти фішки суперника з дошки. Потім ваш хід. Якщо ви продовжуєте формувати млини, ви можете продовжувати видаляти фішки суперника.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Видаліть фішку(-и) з руки суперника. Якщо згідно з налаштуванням Multi-remove потрібно видалити декілька фішок, а в суперника не залишилося фішок в руці, продовжуйте видаляти фішки суперника з дошки. Потім хід суперника.';

  @override
  String get markAndDelayRemovingPieces =>
      'Позначте і відкладіть видалення фішок.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Під час фази розстановки фішки, які потрібно видалити, позначаються, і обидва гравці не можуть ставити нові фішки на ці позиції. При переході у фазу переміщення ці позначені фішки видаляються разом, і гравці можуть переміщувати свої фішки на ці тепер порожні позиції.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Дії, які можна виконати під час формування млинів у фазі розміщення.';

  @override
  String get marked => 'Позначено';

  @override
  String get menu => 'Меню';

  @override
  String get monochrome => 'Монохром';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Ви можете увімкнути підтримку зчитувача екрану в налаштуваннях загальних налаштувань в розділі Доступність.';

  @override
  String get showNumbersOnPieces => 'Показати номери на фігурах';

  @override
  String get saveImage => 'Зберегти зображення';

  @override
  String get isAnalysisToolbarShown => 'Показати панель інструментів аналізу';

  @override
  String get analysisToolbarBackgroundColor =>
      'Колір фону панелі інструментів аналізу';

  @override
  String get analysisToolbarIconColor =>
      'Колір піктограми панелі інструментів аналізу';

  @override
  String get transformed => 'Трансформовано.';

  @override
  String get cannotTransform => 'Не можна трансформувати.';

  @override
  String get rotate => 'Обертати';

  @override
  String get horizontalFlip => 'ГП';

  @override
  String get verticalFlip => 'ВП';

  @override
  String get innerOuterFlip => 'В/ЗП';

  @override
  String get transparentCanvas => 'Прозоре Полотно';

  @override
  String get restrictRepeatedMillsFormation =>
      'Обмежити повторне формування млинів';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Фігура, переміщена з одного млина для створення іншого, не може відразу повернутися на початкову позицію у наступному ході, щоб знову утворити млин. Спочатку потрібен інший хід.';

  @override
  String get oneTimeUseMill => 'Одноразове використання млина';

  @override
  String get oneTimeUseMill_Detail =>
      'Кожен млин може видалити лише одну частину суперника. Ви можете переформувати його знову, але не можна використовувати для додаткових видалень.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Поточні правила, які ви встановили, не мають відповідної ідеальної бази даних. Для отримання додаткової інформації про ідеальну базу даних натисніть тут.';

  @override
  String get focusOnBlockingPaths => 'Зосередьтеся на блокуванні шляхів';

  @override
  String get focusOnBlockingPaths_Detail =>
      'У певних фазах гри віддається пріоритет блокуванню руху супротивника, а не формуванню млинів. Замість того, щоб зосереджуватися на видаленні фігурок, завершуючи млини, ШІ прагне зловити супротивника в пастку саме під час цих фаз, позбавити його можливості рухатися і забезпечити перемогу через виснаження, а не агресивну гру. Ця стратегія, характерна для певних фаз, не активно блокує млини супротивника.';

  @override
  String get pieceImage => 'Зображення фігури';

  @override
  String get importColorSettings => 'Імпортувати налаштування кольорів';

  @override
  String get exportColorSettings => 'Експортувати налаштування кольорів';

  @override
  String get import => 'Імпортувати';

  @override
  String get export => 'Експортувати';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Будь ласка, спочатку скопіюйте налаштування формату JSON до буфера обміну.';

  @override
  String get copiedToClipboard => 'Скопійовано в буфер обміну.';

  @override
  String get imported => 'Імпортовано.';

  @override
  String get boardImage => 'Зображення дошки';

  @override
  String get autumnLeaves => 'Осіннє Листя';

  @override
  String get legendaryLand => 'Легендарна Земля';

  @override
  String get vignetteEffect => 'Ефект віньєтки';

  @override
  String get promptMakeToolbarTransparent =>
      'Ви хочете зробити панель інструментів повністю прозорою, коли встановлено фонове зображення дошки?';

  @override
  String get vibration => 'Увімкнути вібрацію в грі';

  @override
  String get soundTheme => 'Тема звуку';

  @override
  String get ball => 'М\'яч';

  @override
  String get liquid => 'Рідина';

  @override
  String get wood => 'Дерево';

  @override
  String get placeEffectAnimation => 'Анімаційний ефект розміщення фігури';

  @override
  String get removeEffectAnimation => 'Анімаційний ефект видалення фігури';

  @override
  String get isToolbarAtBottom => 'Показати панель інструментів внизу';

  @override
  String get boardCornerRadius => 'Радіус кута дошки';

  @override
  String get useOpeningBook => 'Використовуйте книгу для відкриття';

  @override
  String get currentRule => 'Поточний';

  @override
  String get nineMensMorris => 'Морріс дев’яти чоловік';

  @override
  String get twelveMensMorris => 'Морріс дванадцяти чоловік';

  @override
  String get morabaraba => 'Морабараба';

  @override
  String get dooz => 'Дуз';

  @override
  String get chamGonu => 'Чхамгону';

  @override
  String get zhiQi => 'Чжичі';

  @override
  String get chengSanQi => 'Ченсанчі';

  @override
  String get mulMulan => 'Мул-Мулан';

  @override
  String get nerenchi => 'Неренчі';

  @override
  String get ruleSet => 'Набір правил';

  @override
  String get laskerMorris => 'Ласкер Морріс';

  @override
  String get oneTimeMill => 'Одноразовий млин';

  @override
  String get daSanQi => 'Да-Саньці';

  @override
  String get useOpeningBook_Detail =>
      'Дозвольте ШІ використовувати початкові ходи, які часто використовуються професійними людськими гравцями на ранньому етапі гри. Примітка: Ця функція наразі доступна лише для певних наборів правил.';

  @override
  String get showAdvantageGraph => 'Показати графік переваг';

  @override
  String get advantageGraphHint =>
      'Графік переваг буде намальовано лише після того, як ШІ зробить хід. Він не буде намальований, коли хід робить людський гравець.';

  @override
  String get removalBasedOnMillCounts =>
      'Вимкніть видалення, доки не буде розміщено всі частини, а потім видаліть частини на основі підрахунків млинів.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Вимкніть видалення, доки не буде розміщено всі частини, а потім видаліть частини на основі підрахунків млинів: якщо вони однакові, обидві видаляють однакову кількість; якщо один має більше, вони видаляють один зайвий, зберігаючи цільну різницю. Якщо тільки один утворює млини, вони знімають два шматки, а інший - один. Якщо жоден не утворює млини, обидва видаляють одну зі своїх частин.';

  @override
  String get elfilja => 'Ель Фільджа';

  @override
  String get tipSelectOwnPiece => 'Виберіть одну зі своїх частин.';

  @override
  String get notYourTurn => 'Зараз не ваш хід.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Колір фону панелі інструментів анотацій';

  @override
  String get annotationToolbarIconColor =>
      'Колір іконок панелі інструментів анотацій';

  @override
  String get isAnnotationToolbarShown =>
      'Показати панель інструментів анотацій';

  @override
  String get enterAnnotationMode => 'Увійдіть у режим анотації';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Ви впевнені, що бажаєте очистити всі анотації?';

  @override
  String get llmPromptCopiedToClipboard =>
      'Підказку LLM скопійовано в буфер обміну.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Підключення відмовлено, можливо, сервер не працює.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Виявлення успішне, очікується з\'єднання...';

  @override
  String get noLanConnection => 'Немає підключення до локальної мережі';

  @override
  String get takeScreenshot => 'Зробіть знімок екрана';

  @override
  String get disconnectedFromOpponent => 'Відключений від опонента.';

  @override
  String get takeBackRequest => 'Запит на повернення';

  @override
  String get nothingToShow => 'Нічого показати.';

  @override
  String get stopHosting => 'Зупинити хостинг';

  @override
  String get connectionResetByPeer => 'З’єднання скинуто одноранговим вузлом.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'З’єднання втрачено через час очікування. Підключіться повторно.';

  @override
  String get startHosting => 'Розпочати хостинг';

  @override
  String get restartRequestRejected => 'Запит на перезапуск відхилено.';

  @override
  String get notConnectedToLanOpponent =>
      'Не підключений до суперника локальної мережі.';

  @override
  String get llmPrompt => 'LLM підказка';

  @override
  String get gameRestarted => 'Гру перезапущено.';

  @override
  String get takeBackRejected => 'Забрати назад відхилено.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Ви впевнені, що хочете здатися в цій грі?';

  @override
  String get opponentResignedYouWin => 'Опонент здався. Ви перемогли!';

  @override
  String get clearAllAnnotations => 'Очистити всі анотації';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Підключений, чекає на хід суперника...';

  @override
  String get networkStatusDisconnected => 'Стан мережі: відключено';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Запит на повернення ходу надіслано опоненту.';

  @override
  String get theOpponentMayHaveLeftTheGame => 'Можливо, суперник вийшов з гри';

  @override
  String get connectedToHostSuccessfully => 'Успішно підключено до хосту.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'З’єднання втрачено: тайм-аут серцебиття';

  @override
  String get noHostDiscovered => 'Хост не знайдено.';

  @override
  String get confirmResignation => 'Підтвердити здачу';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Розпочато розміщення гри, очікується приєднання гравців...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Час очікування з’єднання минув, з’єднання з мережею нестабільне.';

  @override
  String get noLlmPromptAvailable => 'Підказка LLM недоступна.';

  @override
  String get youResignedGameOver => 'Ви здалися. Гра завершена.';

  @override
  String get serverIp => 'IP сервера';

  @override
  String get confirmClear => 'Підтвердити очищення';

  @override
  String get opponentSTurn => 'Хід суперника.';

  @override
  String get waitingAClientConnection => 'Очікування підключення клієнта...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Запит на повернення було відхилено або не вдалося.';

  @override
  String get addText => 'Додайте текст';

  @override
  String get exitAnnotationMode => 'Вийти з режиму анотації';

  @override
  String get typeYourAnnotation => 'Введіть свою анотацію';

  @override
  String get attemptingToReconnect => 'Спроба повторного підключення...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Запит на перезапуск надіслано. Чекаю на відповідь опонента...';

  @override
  String get serverIsStopped => 'Сервер зупинено.';

  @override
  String get restartRequest => 'Запит на перезапуск';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Не можна подати запит на повернення, коли не ваша черга.';

  @override
  String get takeBackAccepted => 'Забрати назад прийнято.';

  @override
  String get localNetworkSettings => 'Налаштування локальної мережі';

  @override
  String get reconnectedSuccessfully => 'Повторне підключення успішно!';

  @override
  String get failedToSaveImageToGallery =>
      'Не вдалося зберегти зображення в галерею.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Суперник попросив перезапустити гру. Ви приймаєте?';

  @override
  String get yourTurn => 'Ваша черга.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Не вдалося повторно підключитися, перезапустіть гру.';

  @override
  String get host => 'Хост';

  @override
  String get join => 'Приєднуйтесь';

  @override
  String get port => 'Порт';

  @override
  String get invalidIpAddress => 'Недійсна IP-адреса.';

  @override
  String get invalidPort => 'Недійсний порт.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Підключення: Спроба $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Не вдалося підключитися: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Не вдалося запустити хостинг: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Хост виявлено: $ip:$port';
  }

  @override
  String get stop => 'Зупинити';

  @override
  String get discover => 'Відкрийте для себе';

  @override
  String get connect => 'Підключитися';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Клієнт підключений: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Відкриття: $seconds с';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Повторне підключення ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Підключено';

  @override
  String get delete => 'Видалити';

  @override
  String get ancientEgypt => 'Стародавній Єгипет';

  @override
  String get gothicIce => 'Готичний лід';

  @override
  String get riceField => 'Рисове поле';

  @override
  String get chinesePorcelain => 'Китайська порцеляна';

  @override
  String get desertDusk => 'Пустельні сутінки';

  @override
  String get precisionCraft => 'Точне ремесло';

  @override
  String get folkEmbroidery => 'Народна вишивка';

  @override
  String get carpathianHeritage => 'Карпатська спадщина';

  @override
  String get imperialGrandeur => 'Імператорська велич';

  @override
  String get bohemianCrystal => 'Богемський кристал';

  @override
  String get savannaSunrise => 'Саванна Схід сонця';

  @override
  String get harmonyBalance => 'Гармонія Баланс';

  @override
  String get cinnamonSpice => 'Пряність з корицею';

  @override
  String get anatolianMosaic => 'Анатолійська мозаїка';

  @override
  String get carnivalSpirit => 'Дух карнавалу';

  @override
  String get custom => 'Спеціальні';

  @override
  String get spiceMarket => 'Ринок спецій';

  @override
  String get swipeToRevealTheDrawer => 'Проведіть пальцем, щоб відкрити ящик';

  @override
  String get showGameInfoOnScreenshots =>
      'Показувати інформацію про гру на скріншотах';

  @override
  String get humanMoveTime => 'Ліміт часу людини';

  @override
  String get noTimeLimitForHumanMoves =>
      'Немає обмежень за часом для ходів людини';

  @override
  String get timeoutLoseWillBeApplied =>
      'Для гравця-людини буде застосовано програш за тайм-ауту';

  @override
  String get identifyingBoard => 'Визначення ігрового поля...';

  @override
  String get youCanEnterAnyModelName =>
      'Ви можете ввести будь-яку назву моделі.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Позиція поля застосована. FEN скопійовано в буфер обміну.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Порада: спробуйте зробити більш чітке зображення дошки.';

  @override
  String get llmPromptTemplate => 'Шаблон підказки LLM';

  @override
  String get noValidBoardDetected => 'Не виявлено дійсного ігрового поля.';

  @override
  String get selectingImageFromAlbum => 'Вибір зображення з альбому...';

  @override
  String get configurePromptTemplate => 'Налаштувати шаблон підказки';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Редагувати шаблон підказки для аналізу LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Не вдалося згенерувати FEN із розпізнаного поля.';

  @override
  String get outputInCurrentLanguage => 'Вивід поточною мовою';

  @override
  String get commonBaseUrls => 'Поширені Base URL';

  @override
  String get viewCommonModels => 'Переглянути поширені моделі';

  @override
  String get recognitionParametersUpdated =>
      'Параметри розпізнавання оновлено.';

  @override
  String get whiteSMove => 'Хід білих';

  @override
  String get resetToDefaults => 'Скинути до значень за замовчуванням';

  @override
  String get photoShoot => 'Фотозйомка';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Не вдалося застосувати розпізнану позицію поля.';

  @override
  String get llmPromptContent => 'Підказковий вміст LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM не налаштовано. Будь ласка, перевірте налаштування.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Встановіть постачальника, модель, ключ API та базову URL-адресу';

  @override
  String get llmConfiguration => 'Конфігурація LLM';

  @override
  String get configureLlmProvider => 'Налаштувати постачальника LLM';

  @override
  String get llmPromptTemplateHeader => 'Заголовок шаблону підказки LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'На зображенні не розпізнано жодної фішки. Будь ласка, спробуйте ще раз.';

  @override
  String get recognizeBoardFromImage => 'Розпізнати поле із зображення';

  @override
  String get viewTips => 'Переглянути поради';

  @override
  String get applyToBoard => 'Застосувати до поля';

  @override
  String get adjustBoardArea => 'Налаштувати область поля';

  @override
  String get viewCommonUrls => 'Переглянути поширені URL';

  @override
  String get colorAnalysisFailed => 'Аналіз кольорів не вдався!';

  @override
  String get analyzingGameBoardImage => 'Аналіз зображення ігрового поля...';

  @override
  String get selectFromAlbum => 'Вибрати з альбому';

  @override
  String get noBoardPointDetected => 'Точку поля не виявлено!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Якщо залишити порожнім, буде використано шаблон за замовчуванням';

  @override
  String get llmConfig => 'Конфігурація LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Ви впевнені, що бажаєте скинути шаблони підказок до значень за замовчуванням?';

  @override
  String get llmPromptTemplateFooter =>
      'Нижній колонтитул шаблону підказки LLM';

  @override
  String get loadingResponse => 'Завантаження відповіді...';

  @override
  String get applyThisResultToBoard => 'Застосувати цей результат до поля';

  @override
  String get takingPicture => 'Зйомка зображення...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Будь ласка, виберіть зображення ігрового поля для розпізнавання';

  @override
  String get identificationResults => 'Результати розпізнавання';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Проаналізуйте ходи та надайте інформацію.';

  @override
  String get getApiKey => 'Отримати API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Не вдалося завершити весь процес розпізнавання.';

  @override
  String get boardRecognitionResult => 'Результат розпізнавання поля';

  @override
  String get askLlm => 'Запитати LLM';

  @override
  String get boardDetectionFailed => 'Виявлення поля не вдалося!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Не виявлено точки на дошці, не вдається ідентифікувати фігуру!';

  @override
  String get copyFen => 'Скопіювати FEN';

  @override
  String get commonlyUsedModels => 'Популярні моделі';

  @override
  String get apiKeyOptional => 'API Key (необов\'язково)';

  @override
  String get noImageSelected => 'Зображення не вибрано';

  @override
  String get blackSMove => 'Хід чорних';

  @override
  String get llm => 'Велика мовна модель';

  @override
  String get llmProvider => 'Постачальник';

  @override
  String get baseUrl => 'Базовий URL';

  @override
  String get model => 'Модель';

  @override
  String get temperature => 'Температура';

  @override
  String get llmCommandReceivedProcessing => 'Команду отримано! ШІ обробляє...';

  @override
  String get llmDeepThinkingWait =>
      'Триває глибоке мислення, будь ласка, зачекайте...';

  @override
  String get llmPresentingSoon => 'Скоро буде представлено...';

  @override
  String get recognitionParameters => 'Параметри розпізнавання';

  @override
  String get adjustParamsDesc =>
      'Налаштуйте параметри, щоб покращити точність розпізнавання';

  @override
  String get saveParameters => 'Зберегти параметри';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Не вдалося запустити розпізнавання зображення: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Розпізнавання зображення не вдалося: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Застосована позиція з $whiteCount білими та $blackCount чорними фігурами';
  }

  @override
  String get fenCopiedToClipboard => '(FEN скопійовано в буфер обміну)';

  @override
  String recognitionFailed(String error) {
    return 'Розпізнавання не вдалося: $error';
  }

  @override
  String get myRating => 'Мій рейтинг';

  @override
  String get gamesPlayed => 'Зіграні ігри';

  @override
  String get wins => 'Перемоги';

  @override
  String get losses => 'Поразки';

  @override
  String get draws => 'Нічиї';

  @override
  String get lastUpdated => 'Останнє оновлення';

  @override
  String get format => 'Формат:';

  @override
  String get resetStatistics => 'Скинути статистику';

  @override
  String get drawRate => 'Відсоток нічиїх';

  @override
  String get lossRate => 'Відсоток поразок';

  @override
  String get aiStatistics => 'Статистика ШІ';

  @override
  String get enableStatistics => 'Увімкнути статистику';

  @override
  String get enableStatistics_Detail =>
      'Якщо ввімкнено, результати ігор записуватимуться в статистику. Однак ігри, що передбачають повернення ходів, не записуватимуться. Якщо вимкнено, збір статистики призупиняється.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Це скине всю статистику гри. Цю дію неможливо скасувати.';

  @override
  String get boardInnerRingSize => 'Розмір внутрішнього кільця дошки';

  @override
  String get boardShadowEnabled => 'Тінь дошки';

  @override
  String get trapAwareness => 'Виявлення пасток';

  @override
  String get trapAwarenessDescription =>
      'Підсвічуйте ходи-пастки під час аналізу жирними колами та стрілками.';

  @override
  String trapExists(String trapMoves) {
    return 'Є пастка. Ходи-пастки: $trapMoves';
  }

  @override
  String get custodianCapture => 'Флангові захоплення';

  @override
  String get custodianCaptureDescription =>
      'Укладайте один із творів вашого опонента між двома у прямій лінії, щоб зафіксувати його.';

  @override
  String get custodianCaptureEnable => 'Дозвольте фланговому захопленню';

  @override
  String get interventionCapture => 'Захоплення втручання';

  @override
  String get interventionCaptureDescription =>
      'Перейдіть у порожню точку між двома творами опонента, щоб захопити їх обох.';

  @override
  String get interventionCaptureEnable => 'Дозволити захоплення втручання';

  @override
  String get leapCapture => 'Захоплення стрибків';

  @override
  String get leapCaptureDescription =>
      'Захоплення, перестрибуючи над частиною сусіднього суперника в порожню точку за її межами.';

  @override
  String get leapCaptureEnable => 'Дозвольте захопити стрибок';

  @override
  String get captureApplicableLines => 'Застосовувані лінії';

  @override
  String get captureSquareEdges => 'Вздовж країв квадрата';

  @override
  String get captureCrossLines =>
      'Вздовж ортогональних ліній, що перетинають квадрат';

  @override
  String get captureDiagonalLines =>
      'Вздовж діагональних ліній, що перетинають квадрат';

  @override
  String get captureExecutionPhases => 'Фази виконання';

  @override
  String get capturePiecesCondition =>
      'Наявність під час рухомого фази на основі решти шматочків';

  @override
  String get capturePiecesConditionUnlimited => 'Немає обмежень';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Доступно, коли у вас три або менше штук';
}
