// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Turkish (`tr`).
class STr extends S {
  STr([String locale = 'tr']) : super(locale);

  @override
  String get appName => '9-12 Taş';

  @override
  String get welcome => 'Hoşgeldiniz';

  @override
  String get yes => 'Evet';

  @override
  String get no => 'Hayır';

  @override
  String get game => 'Oyun';

  @override
  String get humanVsAi => 'İnsana Karşı Yapay Zeka';

  @override
  String get humanVsHuman => 'İnsana Karşı İnsan';

  @override
  String get aiVsAi => 'AI vs AI';

  @override
  String get humanVsCloud => 'İnsana Karşı Bulut';

  @override
  String get humanVsLAN => 'İnsana Karşı LAN';

  @override
  String get testViaLAN => 'LAN Üzerinden Test Et';

  @override
  String get move => 'Hamle';

  @override
  String get showMoveList => 'Hamle Listesi';

  @override
  String get moveList => 'Hamle listesi';

  @override
  String get noGameRecord => 'Kayıt yok';

  @override
  String get ok => 'TAMAM';

  @override
  String get confirm => 'Onayla';

  @override
  String get cancel => 'İptal';

  @override
  String get tipSelectWrong => 'Yanlış bir parça seçtiniz.';

  @override
  String get tipPlace => 'Taşlarınızı yerleştirin.';

  @override
  String get tipBanPlace => 'Buraya yerleştiremezsiniz.';

  @override
  String get tipPlaced => 'Yerleştirildi.';

  @override
  String get tipRemove => 'Bir taşı çıkarın.';

  @override
  String get tipBanRemove => 'Kaldırılamıyor.';

  @override
  String get tipRemoved => 'Kaldırıldı.';

  @override
  String get tipMove => 'Bir parçayı hareket ettirin.';

  @override
  String get tipCannotPlace => 'Buraya taşını koyamazsın.';

  @override
  String get tipCannotMove => 'Buraya taşını taşıyamazsın.';

  @override
  String get tipMill => 'Değirmen! Rakibin taşını çıkar.';

  @override
  String get tipContinueMill => 'Rakibin taşını çıkarmaya devam et.';

  @override
  String get tipSelectOpponentsPiece => 'Rakibinizin taşlarından birini seçin.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Değirmendeki bir taşı çıkaramazsınız.';

  @override
  String get tipCanMoveOnePoint =>
      'Bir taş sadece bitişik bir noktaya hareket edebilir.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Rakibinizin taşlarını hareket ettiremezsiniz.';

  @override
  String get tipSelectPieceToMove => 'Taşınacak parçanızı seçin.';

  @override
  String get tipHaveThreePiecesLeft => '3 parçanız kaldı.';

  @override
  String get tipCanMoveToAnyPoint =>
      'İstediğiniz noktaya hareket edebilirsiniz.';

  @override
  String tipToMove(Object player) {
    return '$player hareket ettirin.';
  }

  @override
  String get whiteWin => 'Oyuncu 1 kazanır!';

  @override
  String get blackWin => '2. oyuncu kazanır!';

  @override
  String get won => 'Kazanan';

  @override
  String get lost => 'Kaybeden';

  @override
  String get thinking => 'Düşünüyor...';

  @override
  String get newGame => 'Yeni oyun';

  @override
  String get importGame => 'Oyunu içe aktar';

  @override
  String get exportGame => 'Oyunu dışa aktar';

  @override
  String get gameImported => 'Oyun içe aktarıldı.';

  @override
  String cannotImport(Object invalidMove) {
    return '$invalidMove içe aktarılamıyor';
  }

  @override
  String get movesAndRulesNotMatch => 'Hareketler ve kurallar uyuşmuyor.';

  @override
  String get pleaseWait => 'Lütfen bekle...';

  @override
  String get restartGame => 'Mevcut oyun yeniden başlatılsın mı?';

  @override
  String get restart => 'Tekrar başlat';

  @override
  String get gameStarted => 'Oyun başladı lütfen yer verin.';

  @override
  String get analyzing => 'Analiz…';

  @override
  String error(Object message) {
    return 'Hata: $message';
  }

  @override
  String get winRate => 'Kazanma oranı';

  @override
  String get score => 'Puan:';

  @override
  String get white => 'Oyuncu 1';

  @override
  String get black => 'Oyuncu 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player parça sayısı üçten az.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player istifa etti.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player\'in gidecek yolu yok.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Pano dolu ve $player\'in gidecek yolu yok.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Zaman bitti, $player kayıp.';
  }

  @override
  String get drawReasonRule50 =>
      'Hareket etme aşamasında, son belirli sayıda hamlede hiçbir parça kaldırılmadı.';

  @override
  String get drawReasonBoardIsFull => 'Tahta dolu olduğu için Beraberliktir.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Üç katlı tekrardan dolayı Beraberliktir.';

  @override
  String get gameOverUnknownReason => 'Oyun bitti! Bilinmeyen sebep.';

  @override
  String get gameOver => 'Oyun bitti';

  @override
  String get youWin => 'Sen kazandın! Tebrikler!';

  @override
  String challengeHarderLevel(int level) {
    return 'Daha zor bir seviyeye meydan okumak istiyor musun? Yeni seviye $level olacak.';
  }

  @override
  String get youLose => 'Kaybettin!';

  @override
  String get analyze => 'analiz et';

  @override
  String get about => 'hakkında';

  @override
  String version(Object versionNumber) {
    return 'Sürüm: $versionNumber';
  }

  @override
  String get thanks => 'Teşekkürler';

  @override
  String get settings => 'Ayarlar';

  @override
  String get options => 'Seç.';

  @override
  String get generalSettings => 'Genel Ayarlar';

  @override
  String get skillLevel => 'Zorluk seviyesi';

  @override
  String get moveTime => 'AI düşünme zamanı';

  @override
  String get difficulty => 'Zorluk';

  @override
  String get playSounds => 'Ses efektleri';

  @override
  String get playSoundsInTheGame => 'Oyunda sesleri çal';

  @override
  String get keepMuteWhenTakingBack => 'Geri alırken sessize alın';

  @override
  String get tone => 'ton';

  @override
  String get whoMovesFirst => 'İlk hamle';

  @override
  String get human => 'İnsan';

  @override
  String get ai => 'yapay zeka';

  @override
  String get alternate => 'Alternatif';

  @override
  String get isAutoRestart =>
      'Oyun bittiğinde oyunu otomatik olarak yeniden başlat';

  @override
  String get isAutoChangeFirstMove => 'İlk Hamleyi Otomatik Değiştir';

  @override
  String get shufflingEnabled => 'Rastgele Hamle';

  @override
  String get misc => 'Çeşitli';

  @override
  String get rules => 'Kurallar';

  @override
  String get piecesCount => 'Her oyuncunun sahip olduğu parça sayısı';

  @override
  String get piecesCount_Detail => 'Her oyuncunun kaç taşı vardır?';

  @override
  String get flyPieceCount => 'Uçan parçanın numarası';

  @override
  String get flyPieceCount_Detail =>
      'Uçma etkinleştirilirse, bir oyuncu belirli bir parça sayısına düştüğünde, taşları oyunun geri kalanında olduğu gibi bitişik noktalarla sınırlı olmak yerine boş herhangi bir noktaya hareket etmekte serbesttir.';

  @override
  String get piecesAtLeastCount => 'En Az Adet';

  @override
  String get hasDiagonalLines => 'çapraz çizgiler';

  @override
  String get hasDiagonalLines_Detail => 'Tahtaya dört çapraz çizgi ekleyin.';

  @override
  String get isDefenderMoveFirst => 'İkinci oyuncu önce hareket eder';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Yerleştirme aşamasında ikinci olan oyuncu, hareket aşamasında ilk hamleyi yapar.';

  @override
  String get mayRemoveMultiple => 'çoklu kaldır';

  @override
  String get mayRemoveMultiple_Detail =>
      'Bir oyuncu aynı anda birden fazla değirmeni kapatırsa, kapattığı değirmen sayısını kaldırabilecektir.';

  @override
  String get mayRemoveFromMillsAlways => 'Değirmenleri yok et';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Varsayılan olarak, bir değirmeni oluşturan taşlar kaldırılmadan önce diğer tüm taşlar kaldırılmalıdır. Bu kısıtlamayı kaldırmak için bu seçeneği etkinleştirin.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Tahta dolduğunda ikinci oyuncu kaybeder';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Yerleştirme aşamasının sonunda, eğer tahta dolarsa, ilk taşları yerleştiren taraf kaybeder; aksi halde oyun beraberlikle sonuçlanır.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Yasal hamle olmadığında kaybet';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Eğer bir oyuncu rakibini hareket edemez hale getirirse, o oyuncu kaybeder. Bu seçenek kapalıysa, hamle yapabilen taraf değişir.';

  @override
  String get mayFly => 'Uçan';

  @override
  String get mayFly_Detail =>
      'Bir oyuncunun yalnızca üç veya dört (yapılandırılabilir) taşı kalmışsa, taşı herhangi bir boş noktaya taşıyabilir.';

  @override
  String get nMoveRule => 'N-hareket kuralı';

  @override
  String get nMoveRule_Detail =>
      'Her oyuncu tarafından belirli sayıda hamlede herhangi bir çıkarma yapılmamışsa oyun berabere biter.';

  @override
  String get rollback => 'geri alma';

  @override
  String get pleaseSelect => 'Lütfen seçin';

  @override
  String get copy => 'kopyala';

  @override
  String get moveHistoryCopied => 'Kopyalanan geçmişi panoya taşı.';

  @override
  String get help => 'Yardım';

  @override
  String get feedback => 'geri bildirim';

  @override
  String get exit => 'çıkış';

  @override
  String get ruleSettings => 'Kural Ayarları';

  @override
  String get color => 'Renk';

  @override
  String get boardColor => 'Tahta rengi';

  @override
  String get pieceColor => 'parça rengi';

  @override
  String get backgroundColor => 'Arka plan rengi';

  @override
  String get lineColor => 'Tahta çizgi rengi';

  @override
  String get whitePieceColor => 'Oyuncu 1\'in parça rengi';

  @override
  String get blackPieceColor => 'Oyuncu 2\'nin parça rengi';

  @override
  String get messageColor => 'Mesaj rengi';

  @override
  String get isPieceCountInHandShown => 'Eldeki parça sayısını göster';

  @override
  String get isNotationsShown => 'Notları tahtada göster';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Geçmiş gezinme araç çubuğunu göster';

  @override
  String get display => 'Görüntüle';

  @override
  String get boardBorderLineWidth => 'Tahta sınır çizgisi kalınlığı';

  @override
  String get boardInnerLineWidth => 'Pano iç çizgi genişliği';

  @override
  String get pieceWidth => 'Parça genişliği';

  @override
  String get fontSize => 'Yazı Boyutu';

  @override
  String get standardNotation => 'WMD gösterimi';

  @override
  String get restore => 'Geri Yükle';

  @override
  String get restoreDefaultSettings => 'Varsayılan Ayarlara Geri Dön';

  @override
  String pick(Object element) {
    return '$element\'i seçin';
  }

  @override
  String get info => 'Bilgi';

  @override
  String get hint => 'İpucu';

  @override
  String get player => 'oyuncu';

  @override
  String get player1 => 'oyuncu 1';

  @override
  String get player2 => 'oyuncu 2';

  @override
  String get howToPlay => 'Nasıl oynanır';

  @override
  String get toPlacePiece =>
      'Parçayı yerleştirmek için uygun bir noktaya dokunun.';

  @override
  String get toSelectPiece => 'Taşımak için bir parçaya dokunun.';

  @override
  String get toMovePiece => 'Taşımak için parçaya bağlı noktaya dokunun.';

  @override
  String get toRemovePiece => 'Kaldırmak için rakibin tek parçasına dokunun.';

  @override
  String get needToCreateMillFirst =>
      'Bir parçayı çıkarmadan önce bir değirmen oluşturmanız gerekir.';

  @override
  String get needToPlayWithOwnPieces => 'Taşlarınla oynaman gerekiyor.';

  @override
  String get statistics => 'İstatistik';

  @override
  String get totalGames => 'Toplam oyunlar';

  @override
  String get results => 'Sonuçlar';

  @override
  String get left => 'ayrıldı';

  @override
  String get privacyPolicy => 'Gizlilik Politikası';

  @override
  String get privacyPolicy_Detail_1 =>
      'Lütfen dikkatlice okuyun ve bunu tam olarak anladığınızdan ve kabul ettiğinizden emin olun. ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Bu Politikayı kabul etmiyorsanız, lütfen bu Uygulamayı kullanmayın. Uygulamayı kullanmak, bu şartları kabul ettiğiniz anlamına gelir.';

  @override
  String get and => ' ve ';

  @override
  String get accept => 'Kabul etmek';

  @override
  String get takeBack => 'Geri al';

  @override
  String get takingBack => 'Geri almak…';

  @override
  String get waiting => 'Bekleniyor…';

  @override
  String get stepForward => 'Öne çık';

  @override
  String get takeBackAll => 'Tümünü Geri Al';

  @override
  String get stepForwardAll => 'Tümünü İleri Taşı';

  @override
  String get moveNow => 'Şimdi hareket et';

  @override
  String get done => 'Bitti.';

  @override
  String get crackMill => 'çatlak değirmeni';

  @override
  String get crackMill_Detail =>
      'Eğer bir oyuncunun tüm taşları değirmenlerdeyse, bu taşlar çıkartılmak üzere kilitlenmez.';

  @override
  String get animationDuration => 'Animasyon süresi';

  @override
  String get none => 'Yok';

  @override
  String get theme => 'Tema';

  @override
  String get helpContent =>
      'Oyun, rakibi üçten az taşla veya yasal hamle yapamayacak şekilde etkisiz hale getirmeyi amaçlar.\n\nÜçüncü kez aynı pozisyon oluşursa veya son 100 (yapılandırılabilir) hamlede hiçbir taş çıkarılmamışsa, oyun otomatik olarak sona erer.\n\nOyun üç aşamada ilerler:\n\n1. Boş noktalara taş yerleştirme\n2. Taşları bitişik noktalara taşıma\n3. (isteğe bağlı aşama) Oyuncu üç parçaya indirildiğinde taşları herhangi bir boş noktaya taşıyabilir\n\nYerleştirme\n\nOyun, yirmi dört noktalık bir ızgaradan oluşan boş bir tahta ile başlar. Oyuncular sırayla taşlarını boş noktalara yerleştirir, tüm taşlar yerleştirilene kadar. Bir oyuncu üç taşını düz bir çizgiye getirebilirse, bir \'değirmen\' oluşturmuş olur ve rakibinin taşlarından birini tahtadan çıkarabilir.\n\nBazı kural varyasyonlarında, oyuncular şekillendirilmiş bir değirmeni bozmadan önce diğer taşları çıkarmalıdır.\n\nBazı kural varyasyonlarında, çıkarılan taşlar yerleştirme aşamasında tekrar konumlandırılmayabilir.\n\nTüm parçalar yerleştirildikten sonra, oyuncular sırayla hareket ederler.\n\nHareketli\n\nHareket etmek için, bir oyuncu taşlarından birini boş bir bitişik noktaya boyunca bir tahta çizgisi üzerinde taşır. Bunu yapamazsa, oyunu kaybetmiş olur. Yerleştirme aşamasında olduğu gibi, üç taşını bir tahta çizgisine getiren bir oyuncunun bir değirmeni vardır ve rakibinin taşlarından birini çıkarabilir. Eğer herhangi bir oyuncu iki parçaya düşerse ve yeni değirmenler oluşturamıyorsa, bu durumda oyunu kaybetmiş olur. Eğer rakibi onları hareket edemeyecek şekilde bloke ederse, bir oyuncu üçten fazla taşla da kaybedebilir.\n\nUçan\n\nKuralların bazı varyantlarında, eğer bir oyuncunun yalnızca üç taşı kalmışsa, taşlarını sadece bitişik noktalara değil, herhangi bir boş noktaya da \'uçabilir\', \'zıplayabilir\' veya \'gezebilir\'.';

  @override
  String get versionInfo => 'Sürüm bilgisi';

  @override
  String get eula => 'SKLA';

  @override
  String get license => 'Lisans';

  @override
  String get sourceCode => 'Kaynak kodu';

  @override
  String get appVersion => 'Uygulama sürümü';

  @override
  String get general => 'Genel';

  @override
  String get advanced => 'ileri';

  @override
  String get placing => 'Yrlş.';

  @override
  String get moving => 'Hareket';

  @override
  String get removing => 'Kaldırma';

  @override
  String get gameOverCondition => 'Oyun bitti durumu';

  @override
  String get aisPlayStyle => 'AI\'nın oyun stili';

  @override
  String get passive => 'Pasif';

  @override
  String get timeout => 'Zaman aşımı';

  @override
  String get appearance => 'Görünüm';

  @override
  String get drawOnHumanExperience => 'İnsan deneyiminden yararlanın';

  @override
  String get considerMobility => 'Parçaların hareketliliğini düşünün';

  @override
  String get pieceCount => 'Parça sayısı:';

  @override
  String inHand(Object player, int count) {
    return '$player elinde: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return 'tahtada $player: $count';
  }

  @override
  String get boardTop => 'Üstten tahta ofseti';

  @override
  String get notAIsTurn => 'AI\'nın sırası değil.';

  @override
  String get aiIsNotThinking => 'AI düşünmüyor.';

  @override
  String get atEnd => 'Hareket listesinin sonunda.';

  @override
  String get tapBackAgainToLeave => 'Ayrılmak için tekrar geri dokunun.';

  @override
  String get more => 'Daha';

  @override
  String get experimental => 'Bu deneysel bir özelliktir.';

  @override
  String get experiments => 'Deneysel Özellikler';

  @override
  String get ossLicenses => 'Açık kaynak lisansları';

  @override
  String get language => 'Dil';

  @override
  String get defaultLanguage => 'Varsayılan dil';

  @override
  String get mayMoveInPlacingPhase =>
      'Parçalar yerleştirme aşamasında hareket edebilir';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Ayrı yerleştirme ve hareket etme aşamaları yoktur; yani oyuncular her turda bir taş yerleştirmeyi veya mevcut bir taşı hareket ettirmeyi (yerleştirmeleri gereken taşlar kaldığı sürece) seçebilirler.';

  @override
  String get drawerColor => 'Menü rengi';

  @override
  String get drawerTextColor => 'Menü metin rengi';

  @override
  String get drawerHighlightItemColor => 'Menüdeki vurgulanmış öğe rengi';

  @override
  String get mainToolbarBackgroundColor => 'Ana araç çubuğu arka plan rengi';

  @override
  String get mainToolbarIconColor => 'Ana araç çubuğu simge rengi';

  @override
  String get navigationToolbarBackgroundColor =>
      'Gezinme araç çubuğu arka plan rengi';

  @override
  String get navigationToolbarIconColor => 'Gezinme araç çubuğu simge rengi';

  @override
  String get autoHideToolbar => 'Araç çubuğunu otomatik olarak gizle';

  @override
  String get toolbarLocationOnScreen => 'Ekrandaki araç çubuğunun konumu';

  @override
  String get top => 'Üst';

  @override
  String get bottom => 'Alt';

  @override
  String get center => 'Merkez';

  @override
  String get solidColor => 'Düz Renk';

  @override
  String get picture => 'Resim';

  @override
  String get chooseYourPicture => 'Resminizi seçin';

  @override
  String get light => 'Işık';

  @override
  String get dark => 'Karanlık';

  @override
  String get themes => 'Temalar';

  @override
  String get currentTheme => 'Mevcut tema';

  @override
  String get saveTheme => 'Temayı kaydet';

  @override
  String get showAnalysisGraph => 'Analiz grafiğini göster';

  @override
  String get analysis => 'analiz';

  @override
  String get saveGame => 'Oyunu kaydet';

  @override
  String get loadGame => 'Oyunu yükle';

  @override
  String get setupPosition => 'Kurulum konumu';

  @override
  String get showLegalMoves => 'Yasal hamleleri göster';

  @override
  String get showLastMove => 'Son hareketi göster';

  @override
  String get showArrows => 'Okları göster';

  @override
  String get pieces => 'Taşlar';

  @override
  String get showAnalysis => 'Analizi göster';

  @override
  String get threads => 'İş Parçacıkları';

  @override
  String get getInvolved => 'Katılın';

  @override
  String get helpImproveTranslate => 'Çeviri İyileştirmeye Yardımcı Ol';

  @override
  String get tutorial => 'öğretici';

  @override
  String get classicMill => 'Klasik Değirmen';

  @override
  String get mixedMill => 'karışık değirmen';

  @override
  String get ceylonMill => 'Seylan Değirmeni';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Değirmen kırılabilir ve tekrar tekrar üretilebilir';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Bir oyuncu hemen yeni bir değirmen oluşturmak için bir değirmeni kırarsa, bu oyuncu yeni bir değirmen yaparsa bir sonraki hamlesinde bu parçayı orijinal bağlantı noktasına geri taşıyabilir.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Bir oyuncunun üç taşı varsa ve on hamleden sonra hiçbir oyuncu rakibin taşlarını kaldırmazsa oyun berabere biter';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Bir oyuncu üç parçaya düştüğünde ve hiçbir oyuncu on hamle içinde rakibinin taşını çıkaramazsa, oyun berabere olur.';

  @override
  String get close => 'Kapat';

  @override
  String get whitePiece => 'Beyaz parça';

  @override
  String get blackPiece => 'Siyah parça';

  @override
  String get emptyPoint => 'boş nokta';

  @override
  String get noPoint => 'Anlamı yok';

  @override
  String get placingPhase => 'yerleştirme aşaması';

  @override
  String get movingPhase => 'Hareketli aşama';

  @override
  String get flyingPhase => 'Uçma aşaması';

  @override
  String sideToMove(Object player) {
    return 'Taşınacak taraf: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Son hareket: $move';
  }

  @override
  String get selected => 'Seçildi';

  @override
  String get accessibility => 'Ulaşılabilirlik';

  @override
  String get screenReaderSupport => 'Ekran okuyucu desteği';

  @override
  String get isDraw => 'Bu bir Beraberlik!';

  @override
  String get draw => 'Berabere';

  @override
  String get pieceHighlightColor => 'Parça vurgu rengi';

  @override
  String get algorithm => 'Algoritma';

  @override
  String get endgameNMoveRule => 'Endgame N-Move kuralı';

  @override
  String get endgameNMoveRule_Detail =>
      'Her iki oyuncunun da sadece üç taşı varsa ve hiçbir oyuncu belirli bir hamlede bir taşı kaldırmazsa, oyun berabere biter.';

  @override
  String get drawReasonEndgameRule50 =>
      'Her iki oyuncunun da sadece üç taşı vardır ve hiçbir oyuncu belirli bir hamlede bir taşı kaldırmaz.';

  @override
  String get threefoldRepetitionRule => 'Üçlü tekrar kuralı';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Bir pozisyon üçüncü kez oluşursa oyun berabere biter.';

  @override
  String get continueToMakeMove => 'Değirmen! Hareket etmeye devam edin.';

  @override
  String get pointStyle => 'Nokta stili';

  @override
  String get pointWidth => 'Nokta genişliği';

  @override
  String get solid => 'Sağlam';

  @override
  String get hollow => 'Oyuk';

  @override
  String get languageName => 'Türkçe';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Hamle',
      one: '$count Hamle',
      zero: 'Hamle Yok',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Yükleme başarısız.';

  @override
  String get filename => 'Dosya adı';

  @override
  String get browse => 'Araştır…';

  @override
  String get gameFiles => 'Oyun dosyaları';

  @override
  String get gameSavedTo => 'Oyun şuraya kaydedilir';

  @override
  String get empty => 'Boş';

  @override
  String get noMove => 'Hamle yok.';

  @override
  String get restoredPosition => 'İlk konumu geri yüklendi.';

  @override
  String get clean => 'Temiz';

  @override
  String get cleanedUp => 'Temizledik.';

  @override
  String get remove => 'Kaldırmak';

  @override
  String get noPiecesCanBeRemoved => 'Hiçbir parça çıkarılamaz.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count parça',
      one: '$count parça',
      zero: 'Parça',
    );
    return '$_temp0 kaldırmanız gerekiyor.';
  }

  @override
  String placedCount(int count) {
    return 'Yrl. ($count)';
  }

  @override
  String get placedPieceCount =>
      'Yerleştirme aşamasında yerleştirilen parça sayısı.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Mevcut oyuncu $count adet taşı yerleştirdi.';
  }

  @override
  String get notPlacingPhase => 'Yerleştirme aşaması değil, değiştirilemez.';

  @override
  String get paste => 'Ypş.';

  @override
  String get pasteDone => 'Yapıştırma tamamlandı.';

  @override
  String get cannotPaste => 'Yapıştırılamıyor.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Yerleştirilmemiş ve çıkarılmış parçaları göster';

  @override
  String get fullScreen => 'Tam ekran';

  @override
  String get reopenToTakeEffect =>
      'Ayarların etkili olabilmesi için uygulamayı kapatıp yeniden açın.';

  @override
  String get forest => 'Orman';

  @override
  String get desktopImage => 'Masaüstü Resmi';

  @override
  String get invalidPosition => 'Geçersiz pozisyon.';

  @override
  String get shareGIF => 'GIF paylaş';

  @override
  String get pixelRatio => 'piksel oranı';

  @override
  String get duration => 'Süre';

  @override
  String get gameScreenRecorder => 'Oyun ekran kaydedici';

  @override
  String get previous => 'Öncesi';

  @override
  String get next => 'Sonraki';

  @override
  String get skip => 'Atlamak';

  @override
  String get gotIt => 'Anladım';

  @override
  String get youCanModifyRules =>
      'Oyunun kurallarını kural ayarlarından değiştirebilirsiniz.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Seçicideki değeri değiştirmek için fare tekerleğini kullanabilirsiniz.';

  @override
  String get noTimeLimitForThinking =>
      'AI Düşünme süresinin 0 olarak ayarlanması, düşünmek için herhangi bir zaman sınırı olmadığı anlamına gelir.';

  @override
  String get whatIsMtdf =>
      'MTD(f), ara arama sonuçlarını yeniden kullanarak ve arama alanını daraltmak için iyi bir ilk tahmin kullanarak verimliliği artırmayı amaçlayan alfa-beta arama algoritmasının değiştirilmiş bir biçimidir.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Lütfen AI düşünme süresi ayarının tam olarak kesin olmayabileceğini unutmayın. Gerçek düşünme süresi, zorluk seviyesi daha düşük bir değere ayarlandığında daha kısa olabilir ve süre dolduğunda yapay zeka orta düşüncede olduğunda daha uzun olabilir.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Zorluk seviyesini yüksek seçerseniz fakat AI\'nin düşünme süresini artırmazsanız, gerçek zorluk seviyesi düşünme süresi kısıtlamaları nedeniyle daha düşük olabilir. Bu durum makinenin performansına bağlı olarak değişiklik gösterebilir.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search), belirli bir konumdaki en iyi hareketi bulmak için bir arama algoritmasıdır. Bu, alfa-beta algoritmasının bir geliştirmesidir ve bir hareketin ana varyasyondan zaten güvenli bir puandan daha kötü olduğunu veya daha kötü olmadığını doğrulamak için boş veya sıfır pencere aramaları kullanır. PVS, en umut verici hareketlere odaklanır ve yetersiz dallarda gereksiz arama yapılmasını önler, bu da aramanın verimliliğini artırmaya yardımcı olur.';

  @override
  String get whatIsAlphaBeta =>
      'Alfa-beta algoritması, en iyi hamleyi bulmak için bir arama algoritmasıdır. Arama ağacını budamak ve verimliliği artırmak için minimax ilkesini ve alfa ve beta olmak üzere iki değeri kullanır. Alfa, bilgisayarın alabileceğinden emin olduğu en düşük puanı, beta ise rakibinin alabileceği en yüksek puanı temsil eder. Algoritma, bilgisayarın bir oyunda akıllı ve verimli kararlar almasına yardımcı olur.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'İnsan deneyimine göre, kazanmaya çalışırsan kaybedersin. Bunun yerine, hedefiniz olarak beraberliği hedefleyin ve oyunu kaybetmekten kaçının. Rakibinizi gözlemleyin ve onu hata yapabilecekleri bir konuma nazikçe çekin. Zayıflık gösterdiklerinde, fırsatı değerlendirin ve kazanmak için nazikçe bastırın. Bu sayede oyunu kazanabilirsiniz.';

  @override
  String get firstMoveDetail =>
      'Bu oyunda ikinci oyuncunun kazanması birinci oyuncuya göre daha kolaydır.';

  @override
  String get passiveDetail =>
      'Pasif seçeneğinin etkinleştirilmesi, AI\'nın pozisyonda bir avantaja sahip olduğunda agresif bir şekilde mümkün olan en kısa sürede kazanmaya çalışmak yerine rahatlamasına neden olacaktır.';

  @override
  String get moveRandomlyDetail =>
      'Bu seçeneği etkinleştirmek, oyunun rastgeleliğini ve eğlencesini artırırken devre dışı bırakmak, yapay zekayı yenmenin yollarını araştırmaya yardımcı olabilir.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Yapay zeka, taşlarının hareketliliğini dikkate alırsa, yalnızca rakibin taşlarını olabildiğince çabuk ele geçirmeyi amaçlamaz, aynı zamanda rakibin hareketlerini bloke etmeyi ve onların da aynısını yapmasını engellemeyi düşünür.';

  @override
  String get whenBoardIsFull => 'Tahta dolduğunda';

  @override
  String get whenBoardIsFull_Detail =>
      'Yerleştirme aşamasının sonunda, hareket aşaması başlamadan önce, tahta taşlarla doluysa eylem takip eder.';

  @override
  String get sideToMoveRemovePiece =>
      'Hareket aşamasında ilk hamleyi yapan oyuncu, rakibinin taşlarından birini alır.';

  @override
  String get agreeToDraw => 'Her iki taraf da berabere kalmayı kabul eder.';

  @override
  String get takeOpponentsPiece => 'Rakibinizin taşlarından birini alın.';

  @override
  String get firstPlayerLose => 'İlk oyuncu oyunu kaybeder.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Birinci ve ikinci oyuncular rakibin taşlarından birini alır.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'İkinci ve birinci oyuncular rakibin taşlarından birini alır.';

  @override
  String get enteredFlyingPhase =>
      'Artık \'Uçma Aşaması\'na geçildi, rakip taşlar tahtadaki herhangi bir boş yere atlayabilir. \'Kural Ayarları\'ndan uçuş kuralını devre dışı bırakabilirsiniz.';

  @override
  String get whenStalemate => 'Çıkmaza girildiğinde';

  @override
  String get whenStalemate_Detail =>
      'Hiçbir taş hareket ettirilemiyorsa hangi aksiyon alınır?';

  @override
  String get endWithStalemateLoss => 'Çıkmaz kaybıyla bitirin.';

  @override
  String get changeSideToMove => 'Hareket etmek için tarafı değiştirin.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Rakibin taşlarından birini çıkarın ve bir sonraki hamleyi yapın.';

  @override
  String get endWithStalemateDraw => 'Çıkmaz beraberliği ile bitirin.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Rakibin taşlarından birini çıkarın ve hareket etmek için tarafı değiştirin.';

  @override
  String get aiResponseDelayTime => 'AI yanıt gecikme süresi';

  @override
  String get aiIsDelaying =>
      'AI şu anda gecikmeli bir yanıt aşamasındadır. Devam etmeden önce lütfen bir süre bekleyin.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Bitişik olmayan bir parçayı kaldıramazsınız.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Çıkmaz durumunda, rakibin size bitişik taşları, değirmen oluşumundan bağımsız olarak kaldırılabilir.';

  @override
  String get whatIsMcts =>
      'MCTS, simülasyonlar aracılığıyla farklı hareketleri keşfederek ve değerlendirerek kararlar veren yeni başlayanlar için uygun bir algoritmadır.';

  @override
  String get goldenJade => 'altın yeşim';

  @override
  String get forestWood => 'Orman Ağacı';

  @override
  String get darkMystery => 'Karanlık Gizem';

  @override
  String get midnightBlue => 'Gece yarısı mavisi';

  @override
  String get greenForest => 'Yeşil orman';

  @override
  String get greenMeadow => 'yeşil çayır';

  @override
  String get stonyPath => 'taşlı yol';

  @override
  String get pastelPink => 'pastel pembe';

  @override
  String get turquoiseSea => 'Turkuaz Deniz';

  @override
  String get violetDream => 'Menekşe Rüyası';

  @override
  String get mintChocolate => 'Naneli çikolata';

  @override
  String get skyBlue => 'Gökyüzü mavisi';

  @override
  String get playfulGarden => 'eğlenceli bahçe';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Geriye Dönük Analiz algoritması, farklı başlangıç konumlarından bir oyunsonu veritabanı oluşturmak için çok değerli geriye dönük analizi kullanır ve ardından oyunu optimize etmek için bu veritabanını uygular. Bu yaklaşım, ultra güçlü çözüm kategorisine girer.';

  @override
  String get viewAlgorithmGuide =>
      'Bu algoritmanın kullanım kılavuzunu görüntülemek ister misiniz?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Konumsal avantaj göstergesini göster';

  @override
  String get usePerfectDatabase => 'Mükemmel Veritabanını Kullanın';

  @override
  String get perfectDatabaseDescription =>
      'Bu seçeneği etkinleştirerek, keskin algoritmalar aracılığıyla üretilen kusursuz bir oyun veritabanı kullanın. Bu özellik, hem açılış hem de oyun sonu stratejilerini bütünleştirerek en uygun hamleleri önerir. Bu, oyun içinde en yüksek düzeyde hassasiyet arayan oyuncular için tercih edilen seçimdir. Titiz hesaplama teknikleri kullanılarak oluşturulan bu veritabanı, neredeyse kusursuz oyun çözümleri sunmayı hedefler.\n\nNot: Eğer yapay zeka veritabanına erişemiyorsa, oyun kararları için geleneksel algoritmalara başvuracaktır. Veritabanı mevcut olduğunda, \'Zorluk Seviyesi\' neredeyse yenilmez hale gelir ve \'Yapay Zeka Düşünme Süresi\' büyük ölçüde azalır. \'Yapay Zeka\'nın Oyun Tarzı\' seçeneklerindeki birçok ayar, veritabanı sonuçlarının en yüksek önceliğe sahip olması nedeniyle geçersiz kılınacaktır.\n\nBu kusursuz veritabanından en iyi şekilde nasıl yararlanabileceğiniz konusunda rehberlik için buraya tıklayın.';

  @override
  String get backgroundImage => 'Arka plan resmi';

  @override
  String get whatIsRandom =>
      'Kullan \'mükemmel veritabanı\' seçeneği etkinleştirilmediğinde, \'Rasgele\' ayarı, AI\'nin herhangi bir hamle seçimi algoritması kullanmadan parçaları rasgele hareket ettirmesine neden olur. Bu, genellikle önemli ölçüde daha zayıf oyun deneyimiyle sonuçlanır. Buna karşılık, \'Mükemmel veritabanını kullan\' etkinleştirildiğinde, AI kararlarını verirken yalnızca \'Mükemmel Veritabanı\'na güvenir ve geleneksel AI algoritmalarıyla birleştirmek yerine ona bağlı kalır. Bu modda, AI\'nin hamleleri tamamen veritabanının içeriğine dayanır, gerçek zamanlı hesaplamalara veya arama algoritmalarına bağımlılıktan kaçınır.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Rakibin parça(lar)ını elinden çıkarın; ardından sıra rakibin parça yerleştirmesine gelir.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Yerleştirme aşamasında değirmenler oluşturulurken';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Tahtadan rakibin parça(lar)ını çıkarın.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Tahtadan rakibin parça(lar)ını çıkarın; ardından sıra rakibin parça yerleştirmesine gelir.';

  @override
  String get opponentRemovesOwnPiece =>
      'Rakip kendi parça(lar)ını tahtadan çıkarır.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Sizin bir eylem yapmanız yerine, rakip kendi parça(lar)ını tahtadan seçer ve çıkarır, kendisine zararlı olan bir eylemi etkin bir şekilde gerçekleştirir.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Rakibin parça(lar)ını elinden çıkarın; ardından sıra sizin parça hareket ettirmenize gelir.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Rakibin elinden parça(lar)ı çıkarın. Çoklu-çıkarma ayarına göre birden fazla parça çıkarılacaksa ve rakibin elinde hiç parça kalmadıysa, rakibin tahtadaki parçalarını çıkarmaya devam edin. Ardından sıra sizin parça hareket ettirmenize gelir. Değirmenler oluşturmaya devam ederseniz, rakibin parçalarını çıkarmaya devam edebilirsiniz.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Rakibin elinden parça(lar)ı çıkarın. Çoklu-çıkarma ayarına göre birden fazla parça çıkarılacaksa ve rakibin elinde hiç parça kalmadıysa, rakibin tahtadaki parçalarını çıkarmaya devam edin. Ardından sıra rakibin parça hareket ettirmesine gelir.';

  @override
  String get markAndDelayRemovingPieces =>
      'Parçaları işaretle ve çıkarmayı geciktir.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Yerleştirme aşamasında çıkarılacak parçalar işaretlenir ve her iki oyuncu için de bu noktalara yeni parçalar yerleştirilemez. Hareket aşamasına girildiğinde, bu işaretli parçalar tamamen çıkarılır ve oyuncular ardından parçalarını şimdi boş olan bu noktalara taşıyabilirler.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Yerleştirme aşamasında değirmenler oluşturulurken yapılabilecek eylemler.';

  @override
  String get marked => 'İşaretli';

  @override
  String get menu => 'Menü';

  @override
  String get monochrome => 'Monokrom';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Ekran okuyucu desteğini Genel Ayarlar\'daki Erişilebilirlik yapılandırmasında açabilirsiniz.';

  @override
  String get showNumbersOnPieces => 'Taşlarda numaraları göster';

  @override
  String get saveImage => 'Resmi kaydet';

  @override
  String get isAnalysisToolbarShown => 'Analiz araç çubuğunu göster';

  @override
  String get analysisToolbarBackgroundColor =>
      'Analiz araç çubuğu arka plan rengi';

  @override
  String get analysisToolbarIconColor => 'Analiz araç çubuğu simge rengi';

  @override
  String get transformed => 'Dönüştürüldü.';

  @override
  String get cannotTransform => 'Dönüştürülemez.';

  @override
  String get rotate => 'Döndür';

  @override
  String get horizontalFlip => 'H Çevir';

  @override
  String get verticalFlip => 'V Çevir';

  @override
  String get innerOuterFlip => 'İç Dış';

  @override
  String get transparentCanvas => 'Şeffaf Tuval';

  @override
  String get restrictRepeatedMillsFormation =>
      'Tekrarlanan Değirmen Oluşumunu Kısıtla';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Bir değirmenden alınıp başka bir değirmen oluşturmak için taşınan bir parça, bir sonraki turda hemen orijinal noktaya dönüp yeniden değirmen oluşturamaz. Önce farklı bir hamle gereklidir.';

  @override
  String get oneTimeUseMill => 'Tek kullanımlık değirmen';

  @override
  String get oneTimeUseMill_Detail =>
      'Her değirmen sadece bir kez rakibin parçasını çıkarabilir. Tekrar oluşturabilirsiniz, ancak ek çıkarmalar için kullanılamaz.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Belirlediğiniz mevcut kuralların karşılık gelen mükemmel bir veritabanı yoktur. Mükemmel veritabanı hakkında daha fazla bilgi için lütfen buraya tıklayın.';

  @override
  String get focusOnBlockingPaths => 'Engelleyici yollar üzerinde yoğunlaşın';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Oyunun belirli aşamalarında, değirmenler oluşturmanın önüne rakibin hareketlerini engellemeyi koyun. Parçaları değirmenleri tamamlayarak kaldırmaya odaklanmak yerine, AI bu aşamalar sırasında rakibi tuzağa düşürmeyi, hareket edemez hale getirmeyi ve agresif oyun yerine yıpratma yoluyla zaferi sağlamayı hedefler. Bu aşama özel stratejisi, rakibin değirmenlerini aktif olarak engellemez.';

  @override
  String get pieceImage => 'Satranç parçası resmi';

  @override
  String get importColorSettings => 'Renk ayarlarını içe aktar';

  @override
  String get exportColorSettings => 'Renk ayarlarını dışa aktar';

  @override
  String get import => 'İçe aktar';

  @override
  String get export => 'Dışa aktar';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Lütfen önce JSON biçim ayarlarını panoya kopyalayın.';

  @override
  String get copiedToClipboard => 'Panoya kopyalandı.';

  @override
  String get imported => 'İçe aktarıldı.';

  @override
  String get boardImage => 'Tahta görüntüsü';

  @override
  String get autumnLeaves => 'Sonbahar Yaprakları';

  @override
  String get legendaryLand => 'Efsanevi Diyar';

  @override
  String get vignetteEffect => 'Vinyet efekti';

  @override
  String get promptMakeToolbarTransparent =>
      'Tahta arka plan resmi ayarlandığında araç çubuğunu tamamen şeffaf yapmak ister misiniz?';

  @override
  String get vibration => 'Oyunda titreşimi etkinleştir';

  @override
  String get soundTheme => 'Ses teması';

  @override
  String get ball => 'Top';

  @override
  String get liquid => 'Sıvı';

  @override
  String get wood => 'Odun';

  @override
  String get placeEffectAnimation => 'Taş yerleştirme animasyon efekti';

  @override
  String get removeEffectAnimation => 'Taş kaldırma animasyon efekti';

  @override
  String get isToolbarAtBottom => 'Araç çubuğunu altta göster';

  @override
  String get boardCornerRadius => 'Pano köşe yarıçapı';

  @override
  String get useOpeningBook => 'Açılış kitabını kullanın';

  @override
  String get currentRule => 'Mevcut';

  @override
  String get nineMensMorris => 'Dokuz taş';

  @override
  String get twelveMensMorris => 'On iki taş';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Kural seti';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Yapay zekanın, oyunun erken aşamalarında profesyonel insan oyuncular tarafından sıkça kullanılan açılış hamlelerini kullanmasına izin verin. Not: Bu özellik şu anda yalnızca belirli kurallar setleri için mevcuttur.';

  @override
  String get showAdvantageGraph => 'Avantaj grafiğini göster';

  @override
  String get advantageGraphHint =>
      'Avantaj grafiği yalnızca Yapay Zeka bir hamle yaptıktan sonra çizilecektir. İnsan oyuncu hamle yaptığında çizilmeyecektir.';

  @override
  String get removalBasedOnMillCounts =>
      'Tüm taşlar yerleştirilene kadar taşları kaldırma işlemini devre dışı bırak, ardından değirmen sayısına göre taşları kaldır.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Tüm taşlar yerleştirilene kadar taşları kaldırma işlemini devre dışı bırak, ardından değirmen sayısına göre taşları kaldır: eşitse her iki taraf da aynı sayıda taş kaldırır; bir tarafın sayısı fazlaysa, aradaki farkın bir taş olarak kalması için bir taş fazladan kaldırır. Yalnız bir taraf değirmen oluşturduysa, o taraf iki taş kaldırır, diğeri bir taş kaldırır. Hiç değirmen oluşmazsa, her iki taraf da birer taş kaldırır.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Taşlarından birini seç.';

  @override
  String get notYourTurn => 'Sıra sende değil.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Ek açıklama araç çubuğu arka plan rengi';

  @override
  String get annotationToolbarIconColor =>
      'Ek açıklama araç çubuğu simge rengi';

  @override
  String get isAnnotationToolbarShown => 'Ek açıklama araç çubuğunu göster';

  @override
  String get enterAnnotationMode => 'Ek açıklama moduna gir';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Tüm ek açıklamaları temizlemek istediğine emin misin?';

  @override
  String get llmPromptCopiedToClipboard => 'LLM istemi panoya kopyalandı.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Bağlantı reddedildi, sunucu kapalı olabilir.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Keşif başarılı, bağlantı bekleniyor...';

  @override
  String get noLanConnection => 'LAN bağlantısı yok';

  @override
  String get takeScreenshot => 'Ekran görüntüsü al';

  @override
  String get disconnectedFromOpponent => 'Rakiple bağlantı kesildi.';

  @override
  String get takeBackRequest => 'Geri Alma İsteği';

  @override
  String get nothingToShow => 'Gösterilecek bir şey yok.';

  @override
  String get stopHosting => 'Sunuculuğu Durdur';

  @override
  String get connectionResetByPeer => 'Bağlantı eş tarafından sıfırlandı.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Heartbeat zaman aşımından dolayı bağlantı kaybedildi. Lütfen yeniden bağlanın.';

  @override
  String get startHosting => 'Sunuculuğu Başlat';

  @override
  String get restartRequestRejected => 'Yeniden başlatma isteği reddedildi.';

  @override
  String get notConnectedToLanOpponent => 'LAN rakibine bağlı değil.';

  @override
  String get llmPrompt => 'LLM istemi';

  @override
  String get gameRestarted => 'Oyun yeniden başlatıldı.';

  @override
  String get takeBackRejected => 'Geri alma reddedildi.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Bu oyundan vazgeçmek istediğine emin misin?';

  @override
  String get opponentResignedYouWin => 'Rakip vazgeçti. Kazandın!';

  @override
  String get clearAllAnnotations => 'Tüm ek açıklamaları temizle';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Bağlandı, rakibin hamlesi bekleniyor...';

  @override
  String get networkStatusDisconnected => 'Ağ durumu: Bağlı değil';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Geri alma isteği rakibe gönderildi.';

  @override
  String get theOpponentMayHaveLeftTheGame => 'Rakip oyundan ayrılmış olabilir';

  @override
  String get connectedToHostSuccessfully => 'Sunucuya başarıyla bağlanıldı.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Bağlantı kaybedildi: heartbeat zaman aşımı';

  @override
  String get noHostDiscovered => 'Hiçbir sunucu keşfedilmedi.';

  @override
  String get confirmResignation => 'Vazgeçmeyi onayla';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Oyun sunuculuğu başlatıldı, oyuncuların katılması bekleniyor...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Bağlantı zaman aşımına uğradı, ağ bağlantısı kararsız.';

  @override
  String get noLlmPromptAvailable => 'Kullanılabilir bir LLM istemi yok.';

  @override
  String get youResignedGameOver => 'Vazgeçtin. Oyun bitti.';

  @override
  String get serverIp => 'Sunucu IP';

  @override
  String get confirmClear => 'Temizlemeyi onayla';

  @override
  String get opponentSTurn => 'Rakibin sırası.';

  @override
  String get waitingAClientConnection => 'Bir istemci bağlantısı bekleniyor...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Geri alma isteği reddedildi veya başarısız oldu.';

  @override
  String get addText => 'Metin ekle';

  @override
  String get exitAnnotationMode => 'Ek açıklama modundan çık';

  @override
  String get typeYourAnnotation => 'Ek açıklamanızı yazın';

  @override
  String get attemptingToReconnect => 'Yeniden bağlanmaya çalışılıyor...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Yeniden başlatma isteği gönderildi. Rakibin yanıtı bekleniyor...';

  @override
  String get serverIsStopped => 'Sunucu durduruldu.';

  @override
  String get restartRequest => 'Yeniden başlatma isteği';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Sıra sende değilken geri alma isteğinde bulunamazsın.';

  @override
  String get takeBackAccepted => 'Geri alma kabul edildi.';

  @override
  String get localNetworkSettings => 'Yerel ağ ayarları';

  @override
  String get reconnectedSuccessfully => 'Başarıyla yeniden bağlanıldı!';

  @override
  String get failedToSaveImageToGallery => 'Görüntü Galeriye kaydedilemedi.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Rakip oyunu yeniden başlatmayı istedi. Kabul ediyor musun?';

  @override
  String get yourTurn => 'Senin sıran.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Yeniden bağlanılamıyor, lütfen oyunu yeniden başlat.';

  @override
  String get host => 'Sunucu';

  @override
  String get join => 'Katıl';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'Geçersiz IP adresi.';

  @override
  String get invalidPort => 'Geçersiz port.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Bağlanılıyor: Deneme $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Bağlanma başarısız: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Sunuculuğu başlatma başarısız: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Sunucu bulundu: $ip:$port';
  }

  @override
  String get stop => 'Durdur';

  @override
  String get discover => 'Keşfet';

  @override
  String get connect => 'Bağlan';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'İstemci bağlandı: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Keşfediliyor: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Yeniden bağlanılıyor ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Bağlandı';

  @override
  String get delete => 'Sil';

  @override
  String get ancientEgypt => 'Antik Mısır';

  @override
  String get gothicIce => 'Gotik Buz';

  @override
  String get riceField => 'Pirinç Tarlası';

  @override
  String get chinesePorcelain => 'Çin Porseleni';

  @override
  String get desertDusk => 'Çöldeki Alacakaranlık';

  @override
  String get precisionCraft => 'Hassas El Sanatları';

  @override
  String get folkEmbroidery => 'Halk Nakışı';

  @override
  String get carpathianHeritage => 'Karpat Mirası';

  @override
  String get imperialGrandeur => 'İmparatorluk İhtişamı';

  @override
  String get bohemianCrystal => 'Bohem Kristali';

  @override
  String get savannaSunrise => 'Savanna Gündoğumu';

  @override
  String get harmonyBalance => 'Uyum ve Denge';

  @override
  String get cinnamonSpice => 'Tarçın Baharatı';

  @override
  String get anatolianMosaic => 'Anadolu Mozaiği';

  @override
  String get carnivalSpirit => 'Karnaval Ruhu';

  @override
  String get custom => 'Özel';

  @override
  String get spiceMarket => 'Baharat Pazarı';

  @override
  String get swipeToRevealTheDrawer => 'Çekmeceyi açmak için kaydırın';

  @override
  String get showGameInfoOnScreenshots =>
      'Ekran görüntülerinde oyun bilgilerini göster';

  @override
  String get humanMoveTime => 'İnsan zaman sınırı';

  @override
  String get noTimeLimitForHumanMoves =>
      'İnsan hamleleri için zaman sınırı yok';

  @override
  String get timeoutLoseWillBeApplied =>
      'İnsan oyuncu için zaman aşımı kaybı uygulanacaktır';

  @override
  String get identifyingBoard => 'Oyun tahtası tanımlanıyor...';

  @override
  String get youCanEnterAnyModelName =>
      'Herhangi bir model adını girebilirsiniz.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Tahta konumu uygulandı. FEN panoya kopyalandı.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Öneri: Tahtanın daha net bir fotoğrafını çekmeyi deneyin.';

  @override
  String get llmPromptTemplate => 'LLM istem şablonu';

  @override
  String get noValidBoardDetected => 'Geçerli tahta tespit edilemedi.';

  @override
  String get selectingImageFromAlbum => 'Albümden görüntü seçiliyor...';

  @override
  String get configurePromptTemplate => 'İstem şablonunu yapılandır';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'LLM analizi için istem şablonunu düzenle';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Tanınan tahtadan FEN oluşturulamadı.';

  @override
  String get outputInCurrentLanguage => 'Geçerli dilde çıktı';

  @override
  String get commonBaseUrls => 'Yaygın Base URL\'ler';

  @override
  String get viewCommonModels => 'Yaygın modelleri görüntüle';

  @override
  String get recognitionParametersUpdated =>
      'Tanıma parametreleri güncellendi.';

  @override
  String get whiteSMove => 'Beyazın hamlesi';

  @override
  String get resetToDefaults => 'Varsayılana sıfırla';

  @override
  String get photoShoot => 'Fotoğraf çekimi';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Tanınan tahta pozisyonu uygulanamadı.';

  @override
  String get llmPromptContent => 'LLM istem içeriği';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM yapılandırılmadı. Lütfen ayarlarınızı kontrol edin.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Sağlayıcıyı, modeli, API Key ve Base URL\'i belirle';

  @override
  String get llmConfiguration => 'LLM yapılandırması';

  @override
  String get configureLlmProvider => 'LLM sağlayıcısını yapılandır';

  @override
  String get llmPromptTemplateHeader => 'LLM istem şablonu başlığı';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Görüntüde hiçbir taş tanınmadı. Lütfen tekrar deneyin.';

  @override
  String get recognizeBoardFromImage => 'Görüntüden tahtayı tanı';

  @override
  String get viewTips => 'İpuçlarını görüntüle';

  @override
  String get applyToBoard => 'Tahtaya uygula';

  @override
  String get adjustBoardArea => 'Tahta alanını ayarla';

  @override
  String get viewCommonUrls => 'Yaygın URL\'leri görüntüle';

  @override
  String get colorAnalysisFailed => 'Renk analizi başarısız oldu!';

  @override
  String get analyzingGameBoardImage =>
      'Oyun tahtası görüntüsü analiz ediliyor...';

  @override
  String get selectFromAlbum => 'Albümden seç';

  @override
  String get noBoardPointDetected => 'Tahta noktası algılanamadı!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Boş bırakılırsa varsayılan şablon kullanılacak';

  @override
  String get llmConfig => 'LLM yapılandırması';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'İstem şablonlarını varsayılan değerlere sıfırlamak istediğinizden emin misiniz?';

  @override
  String get llmPromptTemplateFooter => 'LLM istem şablonu altbilgisi';

  @override
  String get loadingResponse => 'Yanıt yükleniyor...';

  @override
  String get applyThisResultToBoard => 'Bu sonucu tahtaya uygula';

  @override
  String get takingPicture => 'Fotoğraf çekiliyor...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Tanımlamak için lütfen bir oyun tahtası resmi seçin';

  @override
  String get identificationResults => 'Tanıma sonuçları';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Hamleleri analiz et ve içgörü sağla';

  @override
  String get getApiKey => 'API Key al';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Tüm tanıma işlemi tamamlanamadı.';

  @override
  String get boardRecognitionResult => 'Tahta tanıma sonucu';

  @override
  String get askLlm => 'LLM\'e sor';

  @override
  String get boardDetectionFailed => 'Tahta algılama başarısız oldu!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Tahta noktası algılanamadı, bu yüzden taş tanımlanamaz!';

  @override
  String get copyFen => 'FEN\'i kopyala';

  @override
  String get commonlyUsedModels => 'Sık kullanılan modeller';

  @override
  String get apiKeyOptional => 'API Key (isteğe bağlı)';

  @override
  String get noImageSelected => 'Görüntü seçilmedi';

  @override
  String get blackSMove => 'Siyahın hamlesi';

  @override
  String get llm => 'Büyük Dil Modeli';

  @override
  String get llmProvider => 'Sağlayıcı';

  @override
  String get baseUrl => 'Temel URL';

  @override
  String get model => 'Model';

  @override
  String get temperature => 'Sıcaklık';

  @override
  String get llmCommandReceivedProcessing =>
      'Komut alındı! Yapay zeka işliyor...';

  @override
  String get llmDeepThinkingWait => 'Derin düşünme sürüyor, lütfen bekleyin...';

  @override
  String get llmPresentingSoon => 'Yakında sunulacak...';

  @override
  String get recognitionParameters => 'Tanıma parametreleri';

  @override
  String get adjustParamsDesc =>
      'Tanıma doğruluğunu artırmak için parametreleri ayarlayın';

  @override
  String get saveParameters => 'Parametreleri kaydet';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Görüntü tanıma başlatılamadı: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Görüntü tanıma başarısız: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return '$whiteCount beyaz ve $blackCount siyah taşlı konum uygulandı';
  }

  @override
  String get fenCopiedToClipboard => '(FEN panoya kopyalandı)';

  @override
  String recognitionFailed(String error) {
    return 'Tanıma başarısız: $error';
  }

  @override
  String get myRating => 'Derecelendirmem';

  @override
  String get gamesPlayed => 'Oynanan oyunlar';

  @override
  String get wins => 'Galibiyet';

  @override
  String get losses => 'Mağlubiyet';

  @override
  String get draws => 'Beraberlik';

  @override
  String get lastUpdated => 'Son güncelleme';

  @override
  String get format => 'Biçim:';

  @override
  String get resetStatistics => 'İstatistikleri sıfırla';

  @override
  String get drawRate => 'Beraberlik oranı';

  @override
  String get lossRate => 'Mağlubiyet oranı';

  @override
  String get aiStatistics => 'Yapay zeka istatistikleri';

  @override
  String get enableStatistics => 'İstatistikleri etkinleştir';

  @override
  String get enableStatistics_Detail =>
      'Etkinleştirildiğinde, oyun sonuçları istatistiklere kaydedilecektir. Ancak, geri alma içeren oyunlar kaydedilmeyecektir. Devre dışı bırakıldığında, istatistik toplama duraklatılır.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Bu, tüm oyun istatistiklerini sıfırlayacaktır. Bu işlem geri alınamaz.';

  @override
  String get boardInnerRingSize => 'Tahtanın iç halka boyutu';

  @override
  String get boardShadowEnabled => 'Tahta gölgesi';

  @override
  String get trapAwareness => 'Tuzak tespiti';

  @override
  String get trapAwarenessDescription =>
      'Analiz sırasında tuzak hamlelerini kalın daireler ve oklarla vurgula.';

  @override
  String trapExists(String trapMoves) {
    return 'Tuzak var. Tuzak hamleleri: $trapMoves';
  }

  @override
  String get custodianCapture => 'Kuşatma yakalama';

  @override
  String get custodianCaptureDescription =>
      'Rakibinizin parçalarından birini ikiniz arasındaki parçalarından yakalamak için düz bir çizgide ekleyin.';

  @override
  String get custodianCaptureEnable => 'Kuşatma yakalamasına izin ver';

  @override
  String get interventionCapture => 'Müdahale yakalama';

  @override
  String get interventionCaptureDescription =>
      'Her ikisini de yakalamak için rakibinizin iki parçasından ikisi arasındaki boş noktaya geçin.';

  @override
  String get interventionCaptureEnable => 'Müdahale yakalamasına izin ver';

  @override
  String get leapCapture => 'Atlama yakalama';

  @override
  String get leapCaptureDescription =>
      'Bitişik bir rakibin parçasının üzerinden boş noktaya atlayarak yakalayın.';

  @override
  String get leapCaptureEnable => 'Atlama yakalamasına izin ver';

  @override
  String get captureApplicableLines => 'Uygulanabilir çizgiler';

  @override
  String get captureSquareEdges => 'Meydanın kenarları boyunca';

  @override
  String get captureCrossLines => 'Meydanı geçen dikey çizgiler boyunca';

  @override
  String get captureDiagonalLines => 'Meydanı geçen çapraz çizgiler boyunca';

  @override
  String get captureExecutionPhases => 'Yürütme aşamaları';

  @override
  String get capturePiecesCondition =>
      'Kalan parçalara dayalı olarak hareketli aşamada kullanılabilirlik';

  @override
  String get capturePiecesConditionUnlimited => 'Kısıtlama Yok';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Üç veya daha az parçanız olduğunda mevcuttur';
}
