// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Thai (`th`).
class STh extends S {
  STh([String locale = 'th']) : super(locale);

  @override
  String get appName => 'โรงสี';

  @override
  String get welcome => 'ยินดีต้อนรับ';

  @override
  String get yes => 'ใช่';

  @override
  String get no => 'ไม่';

  @override
  String get game => 'เกม';

  @override
  String get humanVsAi => 'มนุษย์กับ AI';

  @override
  String get humanVsHuman => 'มนุษย์กับ มนุษย์';

  @override
  String get aiVsAi => 'AI เทียบกับ AI';

  @override
  String get humanVsCloud => 'มนุษย์กับ เมฆ';

  @override
  String get humanVsLAN => 'มนุษย์กับ LAN';

  @override
  String get testViaLAN => 'ทดสอบผ่าน LAN';

  @override
  String get move => 'ย้าย';

  @override
  String get showMoveList => 'ย้ายรายการ';

  @override
  String get moveList => 'ย้ายรายการ';

  @override
  String get noGameRecord => 'ไม่มีบันทึก';

  @override
  String get ok => 'ตกลง';

  @override
  String get confirm => 'ยืนยัน';

  @override
  String get cancel => 'ยกเลิก';

  @override
  String get tipSelectWrong => 'คุณเลือกหมากผิดตัว';

  @override
  String get tipPlace => 'วางหมากของคุณ';

  @override
  String get tipBanPlace => 'คุณไม่สามารถวางหมากตรงนี้ได้';

  @override
  String get tipPlaced => 'คุณวางหมากแล้ว';

  @override
  String get tipRemove => 'นำหมากออก';

  @override
  String get tipBanRemove => 'คุณไม่สามารถนำออกได้';

  @override
  String get tipRemoved => 'คุณนำหมากออกแล้ว';

  @override
  String get tipMove => 'ย้ายหมาก';

  @override
  String get tipCannotPlace => 'คุณไม่สามารถวางหมากของคุณที่นี่ได้';

  @override
  String get tipCannotMove => 'คุณไม่สามารถย้ายชิ้นส่วนของคุณที่นี่';

  @override
  String get tipMill => 'มิลล์! หยิบหมากของฝ่ายตรงข้ามออก';

  @override
  String get tipContinueMill => 'ทำต่อเพื่อหยิบหมากฝ่ายตรงข้ามออก';

  @override
  String get tipSelectOpponentsPiece => 'เลือกหมากของฝ่ายตรงข้าม';

  @override
  String get tipCannotRemovePieceFromMill => 'คุณไม่สามารถนำหมากออกจากมิลล์ได้';

  @override
  String get tipCanMoveOnePoint => 'หมากหนึ่งตัวสามารถเคลื่อนไปได้ 1 จุด';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'คุณไม่สามารถขยับหมากของฝ่ายตรงข้ามได้';

  @override
  String get tipSelectPieceToMove => 'เลือกหมากของคุณเพื่อย้าย';

  @override
  String get tipHaveThreePiecesLeft => 'คุณเหลือหมากสามตัว';

  @override
  String get tipCanMoveToAnyPoint =>
      'คุณสามารถย้ายหมากไปยังจุดใดก็ได้ที่ต้องการ';

  @override
  String tipToMove(Object player) {
    return '$player เพื่อย้าย';
  }

  @override
  String get whiteWin => 'ผู้เล่น 1 ชนะ!';

  @override
  String get blackWin => 'ผู้เล่น 2 ชนะ!';

  @override
  String get won => 'วอน';

  @override
  String get lost => 'สูญหาย';

  @override
  String get thinking => 'กำลังคิด…';

  @override
  String get newGame => 'เกมส์ใหม่';

  @override
  String get importGame => 'นำเข้าเกม';

  @override
  String get exportGame => 'ส่งออกเกม';

  @override
  String get gameImported => 'นำเข้าเกมแล้ว';

  @override
  String cannotImport(Object invalidMove) {
    return 'ไม่สามารถนำเข้า $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'การเคลื่อนไหวและกฎไม่ตรงกัน';

  @override
  String get pleaseWait => 'โปรดรอ.';

  @override
  String get restartGame => 'เริ่มเกมปัจจุบันใหม่หรือไม่?';

  @override
  String get restart => 'เริ่มต้นใหม่';

  @override
  String get gameStarted => 'เกมเริ่มแล้ว โปรดวาง.';

  @override
  String get analyzing => 'กำลังวิเคราะห์…';

  @override
  String error(Object message) {
    return 'ผิดพลาด: $message';
  }

  @override
  String get winRate => 'อัตราการชนะ';

  @override
  String get score => 'คะแนน:';

  @override
  String get white => 'ผู้เล่น 1';

  @override
  String get black => 'ผู้เล่น2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player จำนวนชิ้นน้อยกว่าสาม';
  }

  @override
  String loseReasonResign(Object player) {
    return '$playerลาออก';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player ไม่มีทางไป';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'กระดานเต็มและ $player ไม่มีทางไป';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'เวลาหมดลง $player หายไป';
  }

  @override
  String get drawReasonRule50 =>
      'ในระยะเคลื่อนที่ ไม่มีชิ้นส่วนใดถูกลบออกในจำนวนการเคลื่อนไหวเฉพาะครั้งล่าสุด';

  @override
  String get drawReasonBoardIsFull => 'เสมอกันเพราะกระดานเต็ม';

  @override
  String get drawReasonThreefoldRepetition =>
      'มันเป็นการเสมอกันเพราะการทำซ้ำสามเท่า';

  @override
  String get gameOverUnknownReason => 'จบเกม! ไม่ทราบสาเหตุ';

  @override
  String get gameOver => 'จบเกม';

  @override
  String get youWin => 'คุณชนะ! ขอแสดงความยินดี!';

  @override
  String challengeHarderLevel(int level) {
    return 'ท้าทายระดับที่ยากขึ้น? ระดับใหม่จะเป็นระดับ $level!';
  }

  @override
  String get youLose => 'คุณแพ้!';

  @override
  String get analyze => 'วิเคราะห์';

  @override
  String get about => 'เกี่ยวกับ';

  @override
  String version(Object versionNumber) {
    return 'รุ่น: $versionNumber';
  }

  @override
  String get thanks => 'ขอบคุณ';

  @override
  String get settings => 'การตั้งค่า';

  @override
  String get options => 'ตัวเลือก';

  @override
  String get generalSettings => 'การตั้งค่าทั่วไป';

  @override
  String get skillLevel => 'ระดับความยาก';

  @override
  String get moveTime => 'AI เวลาคิด';

  @override
  String get difficulty => 'ความยาก';

  @override
  String get playSounds => 'เสียงประกอบ';

  @override
  String get playSoundsInTheGame => 'เล่นเสียงในเกม';

  @override
  String get keepMuteWhenTakingBack => 'ปิดเสียงเมื่อทำการย้อนกลับ';

  @override
  String get tone => 'โทน';

  @override
  String get whoMovesFirst => 'ก้าวแรก';

  @override
  String get human => 'มนุษย์';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'ทางเลือก';

  @override
  String get isAutoRestart => 'รีสตาร์ทเกมอัตโนมัติเมื่อจบเกม';

  @override
  String get isAutoChangeFirstMove => 'เปลี่ยนอัตโนมัติก่อนย้าย';

  @override
  String get shufflingEnabled => 'สุ่มย้าย';

  @override
  String get misc => 'เบ็ดเตล็ด';

  @override
  String get rules => 'กฎ';

  @override
  String get piecesCount => 'จำนวนชิ้นที่ผู้เล่นแต่ละคนมี';

  @override
  String get piecesCount_Detail => 'ผู้เล่นแต่ละคนมีกี่ชิ้น?';

  @override
  String get flyPieceCount => 'จำนวนชิ้นบิน';

  @override
  String get flyPieceCount_Detail =>
      'หากเปิดใช้งานการบิน เมื่อผู้เล่นถูกลดจำนวนเป็นจำนวนชิ้นที่กำหนด ชิ้นส่วนของเธอสามารถย้ายไปยังจุดที่ว่างได้ แทนที่จะถูกจำกัดให้อยู่ที่จุดที่อยู่ติดกันเหมือนกับในส่วนที่เหลือของเกม';

  @override
  String get piecesAtLeastCount => 'ชิ้นอย่างน้อย';

  @override
  String get hasDiagonalLines => 'เส้นทแยงมุม';

  @override
  String get hasDiagonalLines_Detail => 'เพิ่มเส้นทแยงมุมสี่เส้นเข้ากับกระดาน';

  @override
  String get isDefenderMoveFirst => 'ผู้เล่นคนที่สองย้ายก่อน';

  @override
  String get isDefenderMoveFirst_Detail =>
      'ผู้เล่นที่ขยับตัวที่สองในระยะการวางจะเคลื่อนที่ก่อนในระยะที่เคลื่อนที่';

  @override
  String get mayRemoveMultiple => 'มัลติลบ';

  @override
  String get mayRemoveMultiple_Detail =>
      'หากผู้เล่นปิดโรงสีมากกว่าหนึ่งครั้ง เธอจะลบจำนวนโรงสีที่เธอปิด';

  @override
  String get mayRemoveFromMillsAlways => 'ทำลายโรงสี';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'โดยค่าเริ่มต้น ผู้เล่นจะต้องถอดชิ้นส่วนอื่น ๆ ออกก่อนที่จะนำชิ้นส่วนออกจากโรงสีที่ขึ้นรูป เปิดใช้งานตัวเลือกนี้เพื่อปิดใช้งานข้อจำกัด';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'ผู้เล่นคนที่สองแพ้เมื่อกระดานเต็ม';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'เมื่อกระดานเต็มเมื่อสิ้นสุดระยะการวาง ฝ่ายที่วางก่อนจะเป็นฝ่ายแพ้ในเกม มิฉะนั้นเกมจะเสมอกัน';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'แพ้เมื่อไม่มีการเคลื่อนไหวทางกฎหมาย';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'ผู้เล่นจะแพ้หากคู่ต่อสู้บล็อกพวกเขาเพื่อไม่ให้เคลื่อนที่ เปลี่ยนด้านเพื่อย้ายหากตัวเลือกนี้ถูกปิดใช้งาน';

  @override
  String get mayFly => 'บิน';

  @override
  String get mayFly_Detail =>
      'หากผู้เล่นเหลือเพียงสามหรือสี่ชิ้น (กำหนดได้) เธอสามารถย้ายชิ้นส่วนนั้นไปยังจุดว่างใดก็ได้';

  @override
  String get nMoveRule => 'กฎ N-move';

  @override
  String get nMoveRule_Detail =>
      'เกมจะถูกสุ่มขึ้นมาหากไม่มีการลบในจำนวนการเคลื่อนไหวที่ระบุ';

  @override
  String get rollback => 'ย้อนกลับ';

  @override
  String get pleaseSelect => 'โปรดเลือก';

  @override
  String get copy => 'สำเนา';

  @override
  String get moveHistoryCopied => 'คัดลอกประวัติการย้ายไปยังคลิปบอร์ดแล้ว.';

  @override
  String get help => 'ช่วยด้วย';

  @override
  String get feedback => 'คำติชม';

  @override
  String get exit => 'ทางออก';

  @override
  String get ruleSettings => 'การตั้งค่ากฎ';

  @override
  String get color => 'สี';

  @override
  String get boardColor => 'สีกระดาน Board';

  @override
  String get pieceColor => 'ชิ้นสี';

  @override
  String get backgroundColor => 'สีพื้นหลัง';

  @override
  String get lineColor => 'สีเส้นกระดาน';

  @override
  String get whitePieceColor => 'เครื่องเล่น 1 ชิ้น สี';

  @override
  String get blackPieceColor => 'เครื่องเล่น 2 ชิ้น สี';

  @override
  String get messageColor => 'สีข้อความ';

  @override
  String get isPieceCountInHandShown => 'แสดงจำนวนชิ้นในมือ';

  @override
  String get isNotationsShown => 'แสดงสัญลักษณ์บนกระดาน';

  @override
  String get isHistoryNavigationToolbarShown => 'แสดงแถบเครื่องมือนำทางประวัติ';

  @override
  String get display => 'แสดง';

  @override
  String get boardBorderLineWidth => 'ความกว้างของเส้นขอบกระดาน Board';

  @override
  String get boardInnerLineWidth => 'ความกว้างของเส้นด้านในของบอร์ด';

  @override
  String get pieceWidth => 'ความกว้างของชิ้น';

  @override
  String get fontSize => 'ขนาดตัวอักษร';

  @override
  String get standardNotation => 'สัญกรณ์ WMD';

  @override
  String get restore => 'คืนค่า';

  @override
  String get restoreDefaultSettings => 'เรียกคืนการตั้งค่าเริ่มต้น';

  @override
  String pick(Object element) {
    return 'เลือก $element';
  }

  @override
  String get info => 'ข้อมูล';

  @override
  String get hint => 'คำใบ้';

  @override
  String get player => 'ผู้เล่น';

  @override
  String get player1 => 'ผู้เล่น 1';

  @override
  String get player2 => 'ผู้เล่น2';

  @override
  String get howToPlay => 'วิธีการเล่น';

  @override
  String get toPlacePiece => 'แตะที่จุดใดก็ได้เพื่อวางชิ้นส่วน';

  @override
  String get toSelectPiece => 'แตะที่ชิ้นส่วนเพื่อย้าย';

  @override
  String get toMovePiece => 'แตะที่จุดที่เชื่อมต่อกับชิ้นส่วนเพื่อย้าย';

  @override
  String get toRemovePiece => 'แตะที่ชิ้นหนึ่งของฝ่ายตรงข้ามเพื่อลบ';

  @override
  String get needToCreateMillFirst =>
      'คุณต้องสร้างโรงสีก่อนจึงจะสามารถถอดชิ้นส่วนได้';

  @override
  String get needToPlayWithOwnPieces => 'คุณต้องเล่นกับชิ้นส่วนของคุณ';

  @override
  String get statistics => 'สถิติ';

  @override
  String get totalGames => 'เกมทั้งหมด';

  @override
  String get results => 'ผล';

  @override
  String get left => 'ซ้าย';

  @override
  String get privacyPolicy => 'นโยบายความเป็นส่วนตัว';

  @override
  String get privacyPolicy_Detail_1 =>
      'โปรดอ่านอย่างถี่ถ้วนและให้แน่ใจว่าคุณเข้าใจและเห็นด้วยกับสิ่งนี้อย่างถ่องแท้ ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. หากคุณไม่เห็นด้วยกับนโยบายนี้ โปรดอย่าใช้แอปนี้ การใช้แอพหมายความว่าคุณยอมรับข้อกำหนดเหล่านี้';

  @override
  String get and => ' และ ';

  @override
  String get accept => 'ยอมรับ';

  @override
  String get takeBack => 'เอาคืนไป';

  @override
  String get takingBack => 'รับคืน…';

  @override
  String get waiting => 'ที่รอ…';

  @override
  String get stepForward => 'ก้าวไปข้างหน้า';

  @override
  String get takeBackAll => 'เอาคืนทั้งหมด';

  @override
  String get stepForwardAll => 'ก้าวไปข้างหน้าทั้งหมด';

  @override
  String get moveNow => 'ย้ายเดี๋ยวนี้';

  @override
  String get done => 'เสร็จแล้ว';

  @override
  String get crackMill => 'แคร็ก-มิลล์';

  @override
  String get crackMill_Detail =>
      'หากผู้เล่นมีเพียงชิ้นในโรงสี ชิ้นส่วนในโรงสีจะไม่ล็อคเพื่อเอาออก';

  @override
  String get animationDuration => 'ระยะเวลาของภาพเคลื่อนไหว';

  @override
  String get none => 'ไม่มี';

  @override
  String get theme => 'ธีม';

  @override
  String get helpContent =>
      'เกมนี้มีจุดมุ่งหมายเพื่อให้ฝ่ายตรงข้ามมีการเคลื่อนไหวน้อยกว่าสามชิ้นหรือไม่มีการเคลื่อนไหวทางกฎหมาย\n\nเกมจะดึงออกมาโดยอัตโนมัติหากตำแหน่งเกิดขึ้นเป็นครั้งที่สามหรือไม่มีการเอาออกในการเคลื่อนไหว 100 ครั้งล่าสุด (กำหนดได้)\n\nเกมดำเนินไปในสามขั้นตอน:\n\n1. วางชิ้นบนจุดที่ว่าง\n2. ย้ายชิ้นส่วนไปยังจุดที่อยู่ติดกัน\n3. (เฟสเสริม) ย้ายชิ้นส่วนไปยังจุดที่ว่างเมื่อลดผู้เล่นลงเหลือสามชิ้น three\n\nการวาง\n\nเกมเริ่มต้นด้วยกระดานเปล่าซึ่งประกอบด้วยตารางที่มีคะแนนยี่สิบสี่ ผู้เล่นผลัดกันวางชิ้นส่วนของตนบนจุดที่ว่างจนกว่าผู้เล่นแต่ละคนจะวางชิ้นส่วนทั้งหมดไว้บนกระดาน หากผู้เล่นสามารถวางหมากของเขาได้สามชิ้น เขาจะมี \"โรงโม่\" และอาจนำชิ้นส่วนของฝ่ายตรงข้ามหนึ่งชิ้นออกจากกระดานได้\n\nในบางกฎ ผู้เล่นต้องถอดชิ้นส่วนอื่นออกก่อนที่จะนำชิ้นส่วนออกจากโรงสีที่ขึ้นรูป\n\nคุณไม่สามารถวางชิ้นส่วนไปยังจุดของชิ้นส่วนที่ถูกถอดออกอีกครั้งในขั้นตอนการวางกฎเกณฑ์บางประการ\n\nเมื่อใช้ชิ้นส่วนทั้งหมด ผู้เล่นผลัดกันเคลื่อนที่\n\nขนย้าย\n\nในการย้ายผู้เล่นจะย้ายชิ้นส่วนของเขาไปตามเส้นกระดานไปยังจุดที่ว่างอยู่ติดกัน ถ้าเขาทำไม่ได้ เขาแพ้เกม ผู้เล่นที่จัดตำแหน่งสามชิ้นของเขาบนเส้นกระดานมีโรงสีและอาจถอดชิ้นส่วนของฝ่ายตรงข้ามหนึ่งชิ้นในขณะที่วาง ผู้เล่นคนใดลดเหลือสองชิ้น ไม่มีตัวเลือกในการสร้างโรงสีใหม่ และทำให้แพ้ในเกม ผู้เล่นยังสามารถสูญเสียเมื่อมากกว่าสามชิ้นถ้าคู่ต่อสู้ของเขาบล็อกไม่ให้เคลื่อนที่\n\nบิน\n\nในบางรูปแบบของกฎ เมื่อผู้เล่นเหลือเพียงสามชิ้น ชิ้นส่วนของเขาสามารถบิน กระโดด หรือกระโดดไปยังจุดที่ว่างได้ ไม่เพียงแต่ชิ้นที่อยู่ติดกัน\n';

  @override
  String get versionInfo => 'ข้อมูลเวอร์ชัน';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'ใบอนุญาต';

  @override
  String get sourceCode => 'รหัสแหล่งที่มา';

  @override
  String get appVersion => 'เวอร์ชันแอป App';

  @override
  String get general => 'ทั่วไป';

  @override
  String get advanced => 'ขั้นสูง';

  @override
  String get placing => 'การวาง';

  @override
  String get moving => 'ขนย้าย';

  @override
  String get removing => 'การถอด';

  @override
  String get gameOverCondition => 'เงื่อนไขเกมโอเวอร์';

  @override
  String get aisPlayStyle => 'สไตล์การเล่นของ AI';

  @override
  String get passive => 'เฉื่อย';

  @override
  String get timeout => 'หมดเวลา';

  @override
  String get appearance => 'รูปร่าง';

  @override
  String get drawOnHumanExperience => 'วาดบนประสบการณ์ของมนุษย์';

  @override
  String get considerMobility => 'พิจารณาความคล่องตัวของชิ้น';

  @override
  String get pieceCount => 'จำนวนชิ้น:';

  @override
  String inHand(Object player, int count) {
    return '$player ในมือ: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player บนเรือ: $count';
  }

  @override
  String get boardTop => 'คณะกรรมการชดเชยจากด้านบน';

  @override
  String get notAIsTurn => 'มันไม่ใช่ตาของ AI';

  @override
  String get aiIsNotThinking => 'AI ไม่ได้คิด';

  @override
  String get atEnd => 'คุณอยู่ที่ส่วนท้ายของรายการย้าย';

  @override
  String get tapBackAgainToLeave => 'แตะกลับอีกครั้งเพื่อออก';

  @override
  String get more => 'มากกว่า';

  @override
  String get experimental => 'เป็นคุณลักษณะทดลอง';

  @override
  String get experiments => 'การทดลอง';

  @override
  String get ossLicenses => 'ใบอนุญาตโอเพ่นซอร์ส';

  @override
  String get language => 'ภาษา';

  @override
  String get defaultLanguage => 'ภาษาเริ่มต้น';

  @override
  String get mayMoveInPlacingPhase => 'ชิ้นส่วนสามารถเคลื่อนที่ได้ในระยะการวาง';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'ไม่มีขั้นตอนการวางและการย้ายที่ชัดเจน กล่าวคือ ผู้เล่นสามารถตัดสินใจได้ทุกการเคลื่อนไหวว่าต้องการวางชิ้นส่วนบนกระดานหรือย้ายชิ้นส่วนของตนชิ้นใดชิ้นหนึ่ง (ตราบใดที่ยังมีชิ้นส่วนที่เหลือให้วาง)';

  @override
  String get drawerColor => 'สีเมนู';

  @override
  String get drawerTextColor => 'สีข้อความเมนู';

  @override
  String get drawerHighlightItemColor => 'สีของรายการไฮไลท์เมนู';

  @override
  String get mainToolbarBackgroundColor => 'สีพื้นหลังของแถบเครื่องมือหลัก';

  @override
  String get mainToolbarIconColor => 'สีไอคอนแถบเครื่องมือหลัก';

  @override
  String get navigationToolbarBackgroundColor =>
      'สีพื้นหลังของแถบเครื่องมือนำทาง';

  @override
  String get navigationToolbarIconColor => 'สีไอคอนแถบเครื่องมือนำทาง';

  @override
  String get autoHideToolbar => 'ซ่อนแถบเครื่องมือโดยอัตโนมัติ';

  @override
  String get toolbarLocationOnScreen => 'ตำแหน่งแถบเครื่องมือบนหน้าจอ';

  @override
  String get top => 'ท็อป';

  @override
  String get bottom => 'ด้านล่าง';

  @override
  String get center => 'ศูนย์';

  @override
  String get solidColor => 'สีทึบ';

  @override
  String get picture => 'ภาพ';

  @override
  String get chooseYourPicture => 'เลือกรูปภาพของคุณ';

  @override
  String get light => 'เบา';

  @override
  String get dark => 'มืด';

  @override
  String get themes => 'ธีม';

  @override
  String get currentTheme => 'ธีมปัจจุบัน';

  @override
  String get saveTheme => 'บันทึกธีม';

  @override
  String get showAnalysisGraph => 'แสดงกราฟการวิเคราะห์';

  @override
  String get analysis => 'บทวิเคราะห์';

  @override
  String get saveGame => 'บันทึกเกม';

  @override
  String get loadGame => 'โหลดเกมส์';

  @override
  String get setupPosition => 'ตำแหน่งการติดตั้ง';

  @override
  String get showLegalMoves => 'แสดงการเคลื่อนไหวทางกฎหมาย';

  @override
  String get showLastMove => 'แสดงการเคลื่อนไหวล่าสุด';

  @override
  String get showArrows => 'แสดงลูกศร';

  @override
  String get pieces => 'ชิ้น';

  @override
  String get showAnalysis => 'แสดงบทวิเคราะห์';

  @override
  String get threads => 'กระทู้';

  @override
  String get getInvolved => 'มีส่วนเกี่ยวข้อง';

  @override
  String get helpImproveTranslate => 'ช่วยปรับปรุงการแปล';

  @override
  String get tutorial => 'กวดวิชา';

  @override
  String get classicMill => 'โรงสีคลาสสิค';

  @override
  String get mixedMill => 'โรงสีผสม';

  @override
  String get ceylonMill => 'ซีลอนมิลล์';

  @override
  String get mayBreakAndRemakeMillRepeatedly => 'โรงสีอาจหักแล้วทำใหม่ซ้ำๆ';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'หากผู้เล่นทำลายโรงโม่เพื่อสร้างโรงสีใหม่ทันที ผู้เล่นดังกล่าวสามารถย้ายชิ้นส่วนดังกล่าวกลับไปที่ทางแยกเดิมในการย้ายครั้งต่อไปหากสร้างโรงสีใหม่';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'เกมจะถูกสุ่มขึ้นถ้าผู้เล่นมีสามชิ้นและหลังจากผ่านไปสิบกระบวนแล้วผู้เล่นจะไม่ถอดชิ้นส่วนของฝ่ายตรงข้าม';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'เมื่อผู้เล่นลดลงเหลือสามชิ้น และผู้เล่นไม่สามารถถอดชิ้นส่วนของฝ่ายตรงข้ามได้ภายในสิบกระบวนท่า เกมจะเสมอกัน';

  @override
  String get close => 'ปิด I';

  @override
  String get whitePiece => 'ชิ้นสีขาว';

  @override
  String get blackPiece => 'ชิ้นสีดำ';

  @override
  String get emptyPoint => 'จุดที่ว่างเปล่า';

  @override
  String get noPoint => 'ไม่มีสาระ';

  @override
  String get placingPhase => 'วางเฟส';

  @override
  String get movingPhase => 'ย้ายเฟส';

  @override
  String get flyingPhase => 'เฟสบิน';

  @override
  String sideToMove(Object player) {
    return 'ด้านที่จะย้าย: $player';
  }

  @override
  String lastMove(Object move) {
    return 'ย้ายล่าสุด: $move';
  }

  @override
  String get selected => 'เลือกแล้ว';

  @override
  String get accessibility => 'การเข้าถึง';

  @override
  String get screenReaderSupport => 'รองรับโปรแกรมอ่านหน้าจอ';

  @override
  String get isDraw => 'มันคือการจับสลาก!';

  @override
  String get draw => 'วาด';

  @override
  String get pieceHighlightColor => 'ชิ้นไฮไลท์สี';

  @override
  String get algorithm => 'อัลกอริทึม';

  @override
  String get endgameNMoveRule => 'กฎ Endgame N-Move';

  @override
  String get endgameNMoveRule_Detail =>
      'ถ้าผู้เล่นคนใดคนหนึ่งมีเพียงสามชิ้นและไม่มีผู้เล่นถอดชิ้นส่วนภายในการเคลื่อนไหวเฉพาะ เกมจะถูกสุ่มจับ';

  @override
  String get drawReasonEndgameRule50 =>
      'ผู้เล่นคนใดคนหนึ่งมีเพียงสามชิ้นและไม่มีใครถอดชิ้นส่วนภายในการเคลื่อนไหวเฉพาะ';

  @override
  String get threefoldRepetitionRule => 'กฎการทำซ้ำสามเท่า';

  @override
  String get threefoldRepetitionRule_Detail =>
      'เกมจะถูกจับสลากหากตำแหน่งเกิดขึ้นเป็นครั้งที่สาม';

  @override
  String get continueToMakeMove => 'มิลล์! ดำเนินการต่อไป';

  @override
  String get pointStyle => 'รูปแบบจุด';

  @override
  String get pointWidth => 'ความกว้างของจุด';

  @override
  String get solid => 'แข็ง';

  @override
  String get hollow => 'กลวง';

  @override
  String get languageName => 'ภาษาไทย';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ย้าย',
      one: '$count Move',
      zero: 'Move',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'โหลดไม่สำเร็จ';

  @override
  String get filename => 'ชื่อไฟล์';

  @override
  String get browse => 'เรียกดู…';

  @override
  String get gameFiles => 'ไฟล์เกม';

  @override
  String get gameSavedTo => 'เกมถูกบันทึกไว้ใน';

  @override
  String get empty => 'ว่างเปล่า';

  @override
  String get noMove => 'ไม่มีการเคลื่อนไหว';

  @override
  String get restoredPosition => 'เรียกคืนตำแหน่งเริ่มต้น';

  @override
  String get clean => 'ทำความสะอาด';

  @override
  String get cleanedUp => 'ทำความสะอาด.';

  @override
  String get remove => 'ลบ';

  @override
  String get noPiecesCanBeRemoved => 'ไม่สามารถถอดชิ้นส่วนได้';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ชิ้น',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 จําเป็นต้องเอาออก';
  }

  @override
  String placedCount(int count) {
    return 'วาง ($count)';
  }

  @override
  String get placedPieceCount => 'วางนับชิ้นในขั้นตอนการวาง';

  @override
  String hasPlacedPieceCount(int count) {
    return 'ผู้เล่นปัจจุบันได้วาง $count ชิ้น';
  }

  @override
  String get notPlacingPhase => 'ไม่วางเฟสเปลี่ยนไม่ได้';

  @override
  String get paste => 'แปะ';

  @override
  String get pasteDone => 'วางเสร็จแล้ว';

  @override
  String get cannotPaste => 'วางไม่ได้';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'แสดงชิ้นส่วนที่ไม่ได้วางและถอดออก';

  @override
  String get fullScreen => 'เต็มจอ';

  @override
  String get reopenToTakeEffect =>
      'ออกและเปิดแอปอีกครั้งเพื่อให้การตั้งค่ามีผล';

  @override
  String get forest => 'ป่า';

  @override
  String get desktopImage => 'รูปภาพเดสก์ท็อป';

  @override
  String get invalidPosition => 'ตำแหน่งไม่ถูกต้อง';

  @override
  String get shareGIF => 'แบ่งปัน GIF';

  @override
  String get pixelRatio => 'อัตราส่วนพิกเซล';

  @override
  String get duration => 'ระยะเวลา';

  @override
  String get gameScreenRecorder => 'เครื่องบันทึกหน้าจอเกม';

  @override
  String get previous => 'ก่อนหน้า';

  @override
  String get next => 'ต่อไป';

  @override
  String get skip => 'ข้าม';

  @override
  String get gotIt => 'เข้าใจแล้ว';

  @override
  String get youCanModifyRules => 'คุณสามารถแก้ไขกฎของเกมได้ในการตั้งค่ากฎ';

  @override
  String get youCanUseMouseWheelInPicker =>
      'คุณสามารถใช้วงล้อของเมาส์เพื่อเปลี่ยนค่าในตัวเลือก';

  @override
  String get noTimeLimitForThinking =>
      'AI ตั้งค่าเวลาคิดเป็น 0 หมายความว่าไม่มีเวลาจำกัดสำหรับการคิด';

  @override
  String get whatIsMtdf =>
      'MTD(f) เป็นรูปแบบที่แก้ไขแล้วของอัลกอริทึมการค้นหาอัลฟ่าเบต้า ซึ่งมีจุดมุ่งหมายเพื่อปรับปรุงประสิทธิภาพโดยการใช้ผลการค้นหาระดับกลางซ้ำ และใช้การคาดเดาเริ่มต้นที่ดีเพื่อจำกัดพื้นที่การค้นหาให้แคบลง';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'โปรดทราบว่าการปรับเวลาคิดของ AI อาจไม่แม่นยำทั้งหมด เวลาในการคิดจริงอาจสั้นลงเมื่อระดับความยากถูกตั้งค่าให้ต่ำลง และอาจนานขึ้นเมื่อ AI อยู่ระหว่างกลางเมื่อหมดเวลา';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'หากคุณตั้งระดับความยากไว้สูงแต่ไม่ได้เพิ่มเวลาคิดของ AI ระดับความยากจริงอาจถูกจำกัดให้มีค่าน้อยลงเนื่องจากข้อจำกัดของเวลาในการคิด ค่าจริงอาจแตกต่างกันไปตามประสิทธิภาพของเครื่อง';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) เป็นอัลกอริธึมการค้นหาเพื่อค้นหาการเคลื่อนไหวที่ดีที่สุดในตำแหน่งที่กำหนด เป็นการปรับปรุงอัลกอริทึมอัลฟาเบต้าและใช้การค้นหาหน้าต่าง null หรือศูนย์เพื่อยืนยันว่าการย้ายนั้นแย่กว่าหรือไม่แย่กว่าคะแนนที่ปลอดภัยอยู่แล้วจากรูปแบบหลัก PVS มุ่งเน้นไปที่การเคลื่อนไหวที่มีแนวโน้มมากที่สุดและหลีกเลี่ยงการค้นหาสาขาที่ไม่เหมาะสมโดยไม่จำเป็น ซึ่งช่วยปรับปรุงประสิทธิภาพของการค้นหา';

  @override
  String get whatIsAlphaBeta =>
      'อัลกอริทึมอัลฟ่าเบต้าเป็นอัลกอริทึมการค้นหาเพื่อค้นหาการเคลื่อนไหวที่ดีที่สุด ใช้หลักการ minimax และค่าสองค่าคือ alpha และ beta เพื่อตัดแผนผังการค้นหาและเพิ่มประสิทธิภาพ อัลฟ่าแสดงถึงคะแนนขั้นต่ำที่คอมพิวเตอร์มั่นใจว่าจะได้ ในขณะที่เบต้าแสดงถึงคะแนนสูงสุดที่ฝ่ายตรงข้ามทำได้ อัลกอริทึมช่วยให้คอมพิวเตอร์ตัดสินใจอย่างชาญฉลาดและมีประสิทธิภาพในเกม';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'ตามประสบการณ์ของมนุษย์ ถ้าคุณพยายามที่จะชนะ คุณจะแพ้ ให้มุ่งไปที่ผลเสมอเป็นเป้าหมายของคุณและหลีกเลี่ยงการแพ้ในเกม สังเกตคู่ต่อสู้ของคุณและค่อย ๆ หลอกล่อพวกเขาไปยังตำแหน่งที่พวกเขาอาจทำผิดพลาดได้ เมื่อพวกเขาแสดงความอ่อนแอ ให้ฉวยโอกาสและผลักดันอย่างนุ่มนวลเพื่อชัยชนะ ด้วยวิธีนี้คุณสามารถชนะเกมได้';

  @override
  String get firstMoveDetail =>
      'ในเกมนี้ผู้เล่นคนที่สองจะชนะได้ง่ายกว่าเมื่อเทียบกับผู้เล่นคนแรก';

  @override
  String get passiveDetail =>
      'การเปิดใช้งานตัวเลือกแบบพาสซีฟจะทำให้ AI ผ่อนคลายเมื่อมีข้อได้เปรียบในตำแหน่ง แทนที่จะพยายามอย่างแข็งขันเพื่อเอาชนะให้เร็วที่สุด';

  @override
  String get moveRandomlyDetail =>
      'การเปิดใช้งานตัวเลือกนี้จะเพิ่มความสุ่มและความสนุกของเกม ในขณะที่การปิดใช้งานจะช่วยให้ศึกษาวิธีเอาชนะ AI ได้';

  @override
  String get considerMobilityOfPiecesDetail =>
      'หาก AI คำนึงถึงความคล่องตัวของชิ้นส่วน มันจะไม่เพียงมุ่งจับชิ้นส่วนของฝ่ายตรงข้ามโดยเร็วที่สุด แต่ยังพิจารณาปิดกั้นการเคลื่อนไหวของฝ่ายตรงข้ามและป้องกันไม่ให้พวกเขาทำเช่นเดียวกัน';

  @override
  String get whenBoardIsFull => 'เมื่อกระดานเต็ม';

  @override
  String get whenBoardIsFull_Detail =>
      'ในตอนท้ายของขั้นตอนการวาง ก่อนที่ขั้นตอนการเคลื่อนไหวจะเริ่มต้นขึ้น การดำเนินการจะตามมาหากกระดานเต็มไปด้วยชิ้นส่วน';

  @override
  String get sideToMoveRemovePiece =>
      'ผู้เล่นที่เคลื่อนไหวก่อนในระยะเคลื่อนที่จะถอดชิ้นส่วนของฝ่ายตรงข้ามออกหนึ่งชิ้น';

  @override
  String get agreeToDraw => 'ทั้งสองฝ่ายตกลงที่จะเสมอกัน';

  @override
  String get takeOpponentsPiece => 'รับชิ้นส่วนของฝ่ายตรงข้ามหนึ่งชิ้น';

  @override
  String get firstPlayerLose => 'ผู้เล่นคนแรกแพ้ในเกม';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'ผู้เล่นคนแรกและคนที่สองถอดชิ้นส่วนของฝ่ายตรงข้ามออก';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'ผู้เล่นคนที่สองและคนแรกถอดชิ้นส่วนของฝ่ายตรงข้ามออก';

  @override
  String get enteredFlyingPhase =>
      'ตอนนี้เข้าสู่ช่วงการบิน ชิ้นส่วนของฝ่ายตรงข้ามสามารถข้ามไปยังจุดที่ว่างบนกระดานได้ คุณสามารถปิดกฎการบินได้ใน \"การตั้งค่ากฎ\"';

  @override
  String get whenStalemate => 'เมื่อจนมุม';

  @override
  String get whenStalemate_Detail =>
      'การดำเนินการใดที่ตามมาเมื่อไม่สามารถเคลื่อนย้ายชิ้นส่วนได้';

  @override
  String get endWithStalemateLoss => 'จบลงด้วยการสูญเสียทางตัน';

  @override
  String get changeSideToMove => 'เปลี่ยนด้านที่จะย้าย';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'นำชิ้นส่วนของคู่ต่อสู้ออกหนึ่งชิ้นแล้วทำการเคลื่อนไหวต่อไป';

  @override
  String get endWithStalemateDraw => 'จบลงด้วยการเสมอกัน';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'นำชิ้นส่วนของฝ่ายตรงข้ามออกหนึ่งชิ้นและเปลี่ยนด้านที่จะย้าย';

  @override
  String get aiResponseDelayTime => 'เวลาตอบสนองของ AI ล่าช้า';

  @override
  String get aiIsDelaying =>
      'ขณะนี้ AI อยู่ในช่วงการตอบสนองที่ล่าช้า โปรดรอสักครู่ก่อนดำเนินการต่อ';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'คุณไม่สามารถลบชิ้นส่วนที่ไม่ติดกันได้';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'หากจนมุม ชิ้นส่วนของฝ่ายตรงข้ามที่อยู่ติดกับคุณจะถูกลบออกได้ โดยไม่คำนึงถึงรูปแบบโรงสี';

  @override
  String get whatIsMcts =>
      'MCTS เป็นอัลกอริทึมที่เป็นมิตรกับผู้เริ่มต้นซึ่งทำการตัดสินใจโดยการสำรวจและประเมินการเคลื่อนไหวต่างๆ ผ่านการจำลองสถานการณ์';

  @override
  String get goldenJade => 'หยกทองคำ';

  @override
  String get forestWood => 'ไม้ป่า';

  @override
  String get darkMystery => 'ความลึกลับดำมืด';

  @override
  String get midnightBlue => 'มิดไนท์บลู';

  @override
  String get greenForest => 'ป่าเขียว';

  @override
  String get greenMeadow => 'ทุ่งหญ้าสีเขียว';

  @override
  String get stonyPath => 'เส้นทางหิน';

  @override
  String get pastelPink => 'สีชมพูพาสเทล';

  @override
  String get turquoiseSea => 'ทะเลสีฟ้าคราม';

  @override
  String get violetDream => 'ไวโอเล็ตดรีม';

  @override
  String get mintChocolate => 'มิ้นท์ชอคโกแลต';

  @override
  String get skyBlue => 'ท้องฟ้าสีคราม';

  @override
  String get playfulGarden => 'สวนขี้เล่น';

  @override
  String get whatIsRetrogradeAnalysis =>
      'อัลกอริธึมการวิเคราะห์ถอยหลังเข้าคลองใช้การวิเคราะห์ถอยหลังเข้าคลองแบบหลายค่าเพื่อสร้างฐานข้อมูลตอนจบเกมจากตำแหน่งเริ่มต้นที่แตกต่างกัน จากนั้นใช้ฐานข้อมูลนี้เพื่อเพิ่มประสิทธิภาพการเล่นเกม วิธีการนี้จัดอยู่ในประเภทของโซลูชันที่แข็งแกร่งเป็นพิเศษ';

  @override
  String get viewAlgorithmGuide =>
      'คุณต้องการดูคู่มือผู้ใช้สำหรับอัลกอริทึมนี้หรือไม่?';

  @override
  String get showPositionalAdvantageIndicator =>
      'แสดงตัวบ่งชี้ความได้เปรียบเชิงตำแหน่ง';

  @override
  String get usePerfectDatabase => 'ใช้ฐานข้อมูลที่สมบูรณ์แบบ';

  @override
  String get perfectDatabaseDescription =>
      'เปิดใช้งานตัวเลือกนี้เพื่อใช้ฐานข้อมูลเกมที่สมบูรณ์แบบซึ่งสร้างผ่านอัลกอริธึมที่ล้ำสมัย ฟีเจอร์นี้ผสมผสานทั้งกลยุทธ์การเปิดและจบเกมเพื่อแนะนำการเคลื่อนไหวที่เหมาะสมที่สุด นี่คือตัวเลือกที่ดีสำหรับผู้เล่นที่แสวงหาความแม่นยำสูงสุดในการเล่นเกม ฐานข้อมูลถูกสร้างขึ้นด้วยเทคนิคการคำนวณที่พิถีพิถัน ออกแบบมาเพื่อนำเสนอโซลูชั่นเกมที่เกือบจะสมบูรณ์แบบ\n\nหมายเหตุ: หาก AI ไม่สามารถเข้าถึงฐานข้อมูล AI จะหันไปใช้อัลกอริธึมแบบเดิมในการตัดสินใจในการเล่นเกม เมื่อฐานข้อมูลพร้อมใช้งาน \'ระดับความยาก\' แทบจะไม่มีใครเทียบได้ และ \'เวลาในการคิดของ AI\' จะลดลงอย่างมาก การตั้งค่าหลายอย่างภายในตัวเลือก \'สไตล์การเล่นของ AI\' จะถูกแทนที่ เนื่องจากผลลัพธ์ของฐานข้อมูลมีความสำคัญสูงสุด\n\nหากต้องการคำแนะนำในการใช้ประโยชน์สูงสุดจากฐานข้อมูลอันไร้ที่ตินี้ คลิกที่นี่';

  @override
  String get backgroundImage => 'ภาพพื้นหลัง';

  @override
  String get whatIsRandom =>
      'เมื่อไม่ได้เปิดใช้งานตัวเลือก \'ใช้ฐานข้อมูลที่สมบูรณ์แบบ\' การตั้งค่า \'สุ่ม\' จะทำให้ AI ย้ายชิ้นส่วนแบบสุ่มโดยไม่ต้องใช้อัลกอริธึมใด ๆ ในการเลือกการเคลื่อนไหว โดยทั่วไปแล้วจะส่งผลให้การเล่นเกมอ่อนแอลงอย่างมาก ในทางกลับกัน เมื่อเปิดใช้งาน \'ใช้ฐานข้อมูลที่สมบูรณ์แบบ\' AI จะใช้ \'ฐานข้อมูลที่สมบูรณ์แบบ\' ในการตัดสินใจโดยเฉพาะ แทนที่จะผสมกับอัลกอริธึม AI แบบดั้งเดิม ในโหมดนี้ การเคลื่อนไหวของ AI จะขึ้นอยู่กับเนื้อหาของฐานข้อมูลทั้งหมด โดยหลีกเลี่ยงการพึ่งพาการคำนวณแบบเรียลไทม์หรืออัลกอริธึมการค้นหา';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'นำชิ้นส่วนของคู่ต่อสู้ออกจากมือของพวกเขา จากนั้นถึงตาของฝ่ายตรงข้ามในการวาง';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'เมื่อสร้างโรงสี (mills) ระหว่างเฟสการวาง';

  @override
  String get removeOpponentsPieceFromBoard =>
      'นำชิ้นส่วนของคู่ต่อสู้ออกจากกระดาน';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'นำชิ้นส่วนของคู่ต่อสู้ออกจากกระดาน จากนั้นถึงตาของฝ่ายตรงข้ามในการวาง';

  @override
  String get opponentRemovesOwnPiece =>
      'คู่ต่อสู้เอาชิ้นส่วนของตัวเองออกจากกระดาน';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'แทนที่คุณจะดำเนินการ ฝ่ายตรงข้ามจะเลือกและนำชิ้นส่วนของตนเองออกจากกระดาน ซึ่งเป็นการกระทำที่เป็นอันตรายต่อตัวพวกเขาเอง';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'นำชิ้นส่วนของคู่ต่อสู้ออกจากมือของพวกเขา จากนั้นตาของคุณที่จะเคลื่อนไหว';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'นำชิ้นส่วนออกจากมือของคู่ต่อสู้ หากตามการตั้งค่าการนำออกหลายๆ ชิ้น มีการนำชิ้นส่วนหลายชิ้นออก และฝ่ายตรงข้ามไม่มีชิ้นส่วนเหลืออยู่ในมือ ให้นำชิ้นส่วนของฝ่ายตรงข้ามออกจากกระดานต่อไป จากนั้นจะถึงตาของคุณเคลื่อนที่ หากคุณยังคงสร้างโรงสีต่อไป คุณอาจลบชิ้นส่วนของคู่ต่อสู้ต่อไปได้';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'นำชิ้นส่วนออกจากมือของคู่ต่อสู้ หากตามการตั้งค่าการนำออกหลายชิ้น มีการนำชิ้นส่วนหลายชิ้นออก และฝ่ายตรงข้ามไม่มีชิ้นส่วนเหลืออยู่ในมือ ให้นำชิ้นส่วนของฝ่ายตรงข้ามออกจากกระดานต่อไป จากนั้นจะถึงตาคู่ต่อสู้ในการเคลื่อนที่';

  @override
  String get markAndDelayRemovingPieces =>
      'ทำเครื่องหมายและหน่วงการนำชิ้นส่วนออก';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'ในระหว่างขั้นตอนการวาง ชิ้นส่วนที่จะลบออกจะถูกทำเครื่องหมาย และสำหรับผู้เล่นทั้งสอง จะไม่มีการวางชิ้นส่วนใหม่ในจุดเหล่านี้ เมื่อเข้าสู่เฟสการเคลื่อนที่ ชิ้นส่วนที่ทำเครื่องหมายไว้เหล่านี้จะถูกลบออกทั้งหมด และผู้เล่นสามารถย้ายชิ้นส่วนของตนไปยังจุดที่ว่างเหล่านี้ได้';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'การกระทำที่สามารถทำได้เมื่อกำลังจัดวางโรงสีในช่วงขั้นตอนการวาง.';

  @override
  String get marked => 'ทำเครื่องหมาย';

  @override
  String get menu => 'เมนู';

  @override
  String get monochrome => 'โมโนโครม';

  @override
  String get youCanEnableScreenReaderSupport =>
      'คุณสามารถเปิดใช้งานการสนับสนุนตัวอ่านหน้าจอในการตั้งค่าการเข้าถึงในการตั้งค่าทั่วไป。';

  @override
  String get showNumbersOnPieces => 'แสดงตัวเลขบนชิ้นส่วน';

  @override
  String get saveImage => 'บันทึกภาพ';

  @override
  String get isAnalysisToolbarShown => 'แสดงแถบเครื่องมือการวิเคราะห์';

  @override
  String get analysisToolbarBackgroundColor =>
      'สีพื้นหลังของแถบเครื่องมือการวิเคราะห์';

  @override
  String get analysisToolbarIconColor => 'สีไอคอนของแถบเครื่องมือการวิเคราะห์';

  @override
  String get transformed => 'ผ่านการแปลง';

  @override
  String get cannotTransform => 'ไม่สามารถแปลง';

  @override
  String get rotate => 'หมุน';

  @override
  String get horizontalFlip => 'พล.นอ.';

  @override
  String get verticalFlip => 'พล.ต.';

  @override
  String get innerOuterFlip => 'IO พลิก';

  @override
  String get transparentCanvas => 'ผืนผ้าใส';

  @override
  String get restrictRepeatedMillsFormation => 'จำกัดการสร้างโรงสีซ้ำ';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'ชิ้นส่วนที่ถูกย้ายจากโรงสีหนึ่งไปอีกโรงสีหนึ่งไม่สามารถกลับไปยังจุดเดิมทันทีในตาถัดไปเพื่อสร้างโรงสีอีกครั้งได้ จำเป็นต้องมีการเคลื่อนไหวที่แตกต่างกันก่อน.';

  @override
  String get oneTimeUseMill => 'โรงสีใช้ครั้งเดียว';

  @override
  String get oneTimeUseMill_Detail =>
      'โรงสีแต่ละแห่งสามารถลบชิ้นส่วนของฝ่ายตรงข้ามได้เพียงครั้งเดียวเท่านั้น คุณสามารถสร้างมันขึ้นมาใหม่ได้ แต่ไม่สามารถใช้สำหรับการลบเพิ่มเติมได้';

  @override
  String get currentRulesNoPerfectDatabase =>
      'กฎปัจจุบันที่คุณตั้งไว้ไม่มีฐานข้อมูลที่สมบูรณ์แบบที่เกี่ยวข้อง สำหรับข้อมูลเพิ่มเติมเกี่ยวกับฐานข้อมูลที่สมบูรณ์แบบโปรดคลิกที่นี่';

  @override
  String get focusOnBlockingPaths => 'โฟกัสที่การบล็อกเส้นทาง';

  @override
  String get focusOnBlockingPaths_Detail =>
      'ให้ความสำคัญกับการขัดขวางการเคลื่อนไหวของฝ่ายตรงข้ามมากกว่าการสร้างมิลล์ แทนที่จะมุ่งเน้นไปที่การลบชิ้นส่วนด้วยการทำมิลล์ให้สมบูรณ์ AI ตั้งใจที่จะดักฝ่ายตรงข้าม ทำให้พวกเขาไม่สามารถเคลื่อนไหวได้และรักษาชัยชนะผ่านการสึกหรอมากกว่าการเล่นอย่างดุเดือด กลยุทธ์นี้ไม่ได้ขัดขวางมิลล์ของฝ่ายตรงข้ามอย่างแข็งขัน';

  @override
  String get pieceImage => 'รูปหมาก';

  @override
  String get importColorSettings => 'นำเข้าการตั้งค่าสี';

  @override
  String get exportColorSettings => 'ส่งออกการตั้งค่าสี';

  @override
  String get import => 'นำเข้า';

  @override
  String get export => 'ส่งออก';

  @override
  String get pleaseCopyJsonToClipboard =>
      'โปรดคัดลอกการตั้งค่ารูปแบบ JSON ไปยังคลิปบอร์ดก่อน';

  @override
  String get copiedToClipboard => 'คัดลอกไปยังคลิปบอร์ดแล้ว';

  @override
  String get imported => 'นำเข้าแล้ว';

  @override
  String get boardImage => 'ภาพกระดาน';

  @override
  String get autumnLeaves => 'ใบไม้ร่วง';

  @override
  String get legendaryLand => 'ดินแดนในตำนาน';

  @override
  String get vignetteEffect => 'เอฟเฟกต์ขอบมืด';

  @override
  String get promptMakeToolbarTransparent =>
      'คุณต้องการให้แถบเครื่องมือโปร่งใสเต็มที่เมื่อกำหนดภาพพื้นหลังของกระดานแล้วหรือไม่?';

  @override
  String get vibration => 'เปิดใช้งานการสั่นในเกม';

  @override
  String get soundTheme => 'ธีมเสียง';

  @override
  String get ball => 'ลูกบอล';

  @override
  String get liquid => 'ของเหลว';

  @override
  String get wood => 'ไม้';

  @override
  String get placeEffectAnimation => 'เอฟเฟกต์แอนิเมชันการวางตัวหมาก';

  @override
  String get removeEffectAnimation => 'เอฟเฟกต์แอนิเมชันการลบตัวหมาก';

  @override
  String get isToolbarAtBottom => 'แสดงแถบเครื่องมือที่ด้านล่าง';

  @override
  String get boardCornerRadius => 'รัศมีมุมของบอร์ด';

  @override
  String get useOpeningBook => 'ใช้หนังสือเปิด';

  @override
  String get currentRule => 'ปัจจุบัน';

  @override
  String get nineMensMorris => 'เกมมอริสเก้าช่อง';

  @override
  String get twelveMensMorris => 'เกมมอริสสิบสองช่อง';

  @override
  String get morabaraba => 'โมราบาราบา';

  @override
  String get dooz => 'ดูซ';

  @override
  String get chamGonu => 'ชัมโกนู';

  @override
  String get zhiQi => 'จื๋อฉี';

  @override
  String get chengSanQi => 'เฉิงซานฉี';

  @override
  String get mulMulan => 'มูล-มูลัน';

  @override
  String get nerenchi => 'เนเรนจิ';

  @override
  String get ruleSet => 'ชุดกฎ';

  @override
  String get laskerMorris => 'ลาสเกอร์ มอริส';

  @override
  String get oneTimeMill => 'เมลนิตซา';

  @override
  String get daSanQi => 'ต้าซานฉี';

  @override
  String get useOpeningBook_Detail =>
      'ให้ AI ใช้การเดินเปิดที่มักถูกใช้โดยนักเล่นมืออาชีพในช่วงต้นเกม หมายเหตุ: คุณสมบัตินี้มีให้บริการในปัจจุบันสำหรับชุดกฎเฉพาะเท่านั้น';

  @override
  String get showAdvantageGraph => 'แสดงกราฟความได้เปรียบ';

  @override
  String get advantageGraphHint =>
      'กราฟแสดงความได้เปรียบจะถูกวาดเฉพาะหลังจากที่ AI เดินหมากเท่านั้น จะไม่ถูกวาดเมื่อผู้เล่นมนุษย์เดินหมาก';

  @override
  String get removalBasedOnMillCounts =>
      'ปิดใช้งานการนำออกจนกว่าจะวางหมากทั้งหมด ผู้เล่นจะนำหมากออกตามจำนวนมิลล์ที่สร้างได้';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'ปิดใช้งานการนำออกจนกว่าจะวางหมากทั้งหมด ผู้เล่นจะนำหมากออกตามจำนวนมิลล์: ถ้าจำนวนเท่ากัน ผู้เล่นทั้งสองฝ่ายจะนำหมากออกในจำนวนเท่ากัน หากฝ่ายใดมีมากกว่า จะนำหมากออกเพิ่มอีกหนึ่งตัวเพื่อคงความต่างไว้ที่หนึ่งตัว หากมีเพียงฝ่ายเดียวที่สร้างมิลล์ เขาจะนำหมากออกสองตัว ส่วนอีกฝ่ายนำออกหนึ่งตัว หากไม่มีใครสร้างมิลล์ ผู้เล่นทั้งสองจะนำออกคนละหนึ่งตัว';

  @override
  String get elfilja => 'เอล ฟิลจะ';

  @override
  String get tipSelectOwnPiece => 'เลือกตัวหมากของคุณ 1 ตัว';

  @override
  String get notYourTurn => 'ยังไม่ถึงตาคุณ';

  @override
  String get annotationToolbarBackgroundColor =>
      'สีพื้นหลังแถบเครื่องมือหมายเหตุ';

  @override
  String get annotationToolbarIconColor => 'สีไอคอนแถบเครื่องมือหมายเหตุ';

  @override
  String get isAnnotationToolbarShown => 'แสดงแถบเครื่องมือหมายเหตุ';

  @override
  String get enterAnnotationMode => 'เข้าสู่โหมดหมายเหตุ';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'คุณแน่ใจหรือไม่ว่าต้องการลบหมายเหตุทั้งหมด?';

  @override
  String get llmPromptCopiedToClipboard =>
      'คัดลอกข้อความ LLM ไปยังคลิปบอร์ดแล้ว';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'การเชื่อมต่อถูกปฏิเสธ เซิร์ฟเวอร์อาจหยุดทำงาน';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'ค้นพบสำเร็จ กำลังรอการเชื่อมต่อ...';

  @override
  String get noLanConnection => 'ไม่มีการเชื่อมต่อ LAN';

  @override
  String get takeScreenshot => 'ถ่ายภาพหน้าจอ';

  @override
  String get disconnectedFromOpponent => 'ตัดการเชื่อมต่อจากคู่ต่อสู้แล้ว';

  @override
  String get takeBackRequest => 'คำขอถอยกลับ';

  @override
  String get nothingToShow => 'ไม่มีข้อมูลแสดง';

  @override
  String get stopHosting => 'หยุดโฮสต์';

  @override
  String get connectionResetByPeer => 'การเชื่อมต่อถูกรีเซ็ตโดยอีกฝ่าย';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'การเชื่อมต่อขาดเนื่องจากหมดเวลา กรุณาเชื่อมต่อใหม่';

  @override
  String get startHosting => 'เริ่มโฮสต์';

  @override
  String get restartRequestRejected => 'ปฏิเสธคำขอเริ่มเกมใหม่';

  @override
  String get notConnectedToLanOpponent => 'ไม่ได้เชื่อมต่อกับคู่ต่อสู้ผ่าน LAN';

  @override
  String get llmPrompt => 'ข้อความ LLM';

  @override
  String get gameRestarted => 'เริ่มเกมใหม่แล้ว';

  @override
  String get takeBackRejected => 'ปฏิเสธการถอยกลับ';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'คุณแน่ใจหรือไม่ว่าต้องการยอมแพ้เกมนี้?';

  @override
  String get opponentResignedYouWin => 'คู่ต่อสู้ยอมแพ้ คุณชนะ!';

  @override
  String get clearAllAnnotations => 'ล้างหมายเหตุทั้งหมด';

  @override
  String get connectedWaitingForOpponentSMove =>
      'เชื่อมต่อแล้ว กำลังรอการเคลื่อนของคู่ต่อสู้...';

  @override
  String get networkStatusDisconnected => 'สถานะเครือข่าย: ถูกตัดการเชื่อมต่อ';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'ส่งคำขอถอยกลับไปยังคู่ต่อสู้แล้ว';

  @override
  String get theOpponentMayHaveLeftTheGame => 'คู่ต่อสู้อาจออกจากเกมแล้ว';

  @override
  String get connectedToHostSuccessfully => 'เชื่อมต่อกับโฮสต์สำเร็จ';

  @override
  String get connectionLostHeartbeatTimeout => 'การเชื่อมต่อขาด: หมดเวลา';

  @override
  String get noHostDiscovered => 'ไม่พบโฮสต์';

  @override
  String get confirmResignation => 'ยืนยันการยอมแพ้';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'เริ่มโฮสต์เกมแล้ว กำลังรอผู้เล่นเข้าร่วม...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'การเชื่อมต่อหมดเวลา สัญญาณเครือข่ายไม่เสถียร';

  @override
  String get noLlmPromptAvailable => 'ไม่มีข้อความ LLM';

  @override
  String get youResignedGameOver => 'คุณยอมแพ้ เกมจบแล้ว';

  @override
  String get serverIp => 'ไอพีเซิร์ฟเวอร์';

  @override
  String get confirmClear => 'ยืนยันการล้าง';

  @override
  String get opponentSTurn => 'ตาของคู่ต่อสู้';

  @override
  String get waitingAClientConnection => 'กำลังรอการเชื่อมต่อจากไคลเอ็นต์...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'คำขอถอยกลับถูกปฏิเสธหรือล้มเหลว';

  @override
  String get addText => 'เพิ่มข้อความ';

  @override
  String get exitAnnotationMode => 'ออกจากโหมดหมายเหตุ';

  @override
  String get typeYourAnnotation => 'พิมพ์หมายเหตุของคุณ';

  @override
  String get attemptingToReconnect => 'กำลังพยายามเชื่อมต่อใหม่...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'ส่งคำขอเริ่มเกมใหม่แล้ว กำลังรอคำตอบจากคู่ต่อสู้...';

  @override
  String get serverIsStopped => 'เซิร์ฟเวอร์หยุดทำงานแล้ว';

  @override
  String get restartRequest => 'คำขอเริ่มเกมใหม่';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'ไม่สามารถขอถอยกลับเมื่อไม่ใช่ตาคุณ';

  @override
  String get takeBackAccepted => 'รับคำขอถอยกลับแล้ว';

  @override
  String get localNetworkSettings => 'การตั้งค่าเครือข่ายท้องถิ่น';

  @override
  String get reconnectedSuccessfully => 'เชื่อมต่อใหม่สำเร็จ!';

  @override
  String get failedToSaveImageToGallery => 'บันทึกรูปภาพไม่สำเร็จ';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'คู่ต่อสู้ขอเริ่มเกมใหม่ คุณยอมรับหรือไม่?';

  @override
  String get yourTurn => 'ตาคุณแล้ว';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'เชื่อมต่อใหม่ไม่สำเร็จ กรุณาเริ่มเกมใหม่';

  @override
  String get host => 'โฮสต์';

  @override
  String get join => 'เข้าร่วม';

  @override
  String get port => 'พอร์ต';

  @override
  String get invalidIpAddress => 'ที่อยู่ไอพีไม่ถูกต้อง';

  @override
  String get invalidPort => 'พอร์ตไม่ถูกต้อง';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'กำลังเชื่อมต่อ: ความพยายามที่ $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'เชื่อมต่อล้มเหลว: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'เริ่มโฮสต์ล้มเหลว: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'พบโฮสต์: $ip:$port';
  }

  @override
  String get stop => 'หยุด';

  @override
  String get discover => 'ค้นหา';

  @override
  String get connect => 'เชื่อมต่อ';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'เชื่อมต่อไคลเอ็นต์: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'กำลังค้นหา: $seconds วินาที';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'กำลังเชื่อมต่อใหม่ ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'เชื่อมต่อแล้ว';

  @override
  String get delete => 'ลบ';

  @override
  String get ancientEgypt => 'อียิปต์โบราณ';

  @override
  String get gothicIce => 'น้ำแข็งโกธิก';

  @override
  String get riceField => 'นาข้าว';

  @override
  String get chinesePorcelain => 'เครื่องเคลือบจีน';

  @override
  String get desertDusk => 'ค่ำคืนในทะเลทราย';

  @override
  String get precisionCraft => 'งานฝีมือที่แม่นยำ';

  @override
  String get folkEmbroidery => 'งานปักผ้าพื้นบ้าน';

  @override
  String get carpathianHeritage => 'มรดกคาร์พาเทียน';

  @override
  String get imperialGrandeur => 'ความยิ่งใหญ่แห่งจักรวรรดิ';

  @override
  String get bohemianCrystal => 'คริสตัลโบฮีเมียน';

  @override
  String get savannaSunrise => 'พระอาทิตย์ขึ้นในสะวันนา';

  @override
  String get harmonyBalance => 'ความกลมกลืนและสมดุล';

  @override
  String get cinnamonSpice => 'เครื่องเทศอบเชย';

  @override
  String get anatolianMosaic => 'โมเสกอนาโตเลียน';

  @override
  String get carnivalSpirit => 'จิตวิญญาณแห่งคาร์นิวัล';

  @override
  String get custom => 'กำหนดเอง';

  @override
  String get spiceMarket => 'ตลาดเครื่องเทศ';

  @override
  String get swipeToRevealTheDrawer => 'ปัดเพื่อเปิดลิ้นชัก';

  @override
  String get showGameInfoOnScreenshots => 'แสดงข้อมูลเกมบนภาพหน้าจอ';

  @override
  String get humanMoveTime => 'จำกัดเวลาของมนุษย์';

  @override
  String get noTimeLimitForHumanMoves =>
      'ไม่มีการจำกัดเวลาสำหรับการเคลื่อนไหวของมนุษย์';

  @override
  String get timeoutLoseWillBeApplied =>
      'การแพ้เนื่องจากหมดเวลาจะถูกนำไปใช้กับผู้เล่นที่เป็นมนุษย์';

  @override
  String get identifyingBoard => 'กำลังระบุกระดานเกม...';

  @override
  String get youCanEnterAnyModelName => 'คุณสามารถใส่ชื่อโมเดลใดก็ได้.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'ตำแหน่งกระดานถูกนำไปใช้แล้ว FEN ถูกคัดลอกไปยังคลิปบอร์ด.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'คำแนะนำ: ลองถ่ายภาพกระดานให้ชัดขึ้น.';

  @override
  String get llmPromptTemplate => 'เทมเพลตพรอมต์ LLM';

  @override
  String get noValidBoardDetected => 'ไม่พบกระดานเกมที่ถูกต้อง.';

  @override
  String get selectingImageFromAlbum => 'กำลังเลือกภาพจากอัลบั้ม...';

  @override
  String get configurePromptTemplate => 'ตั้งค่าเทมเพลตพรอมต์';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'แก้ไขเทมเพลตพรอมต์สำหรับการวิเคราะห์ LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'ไม่สามารถสร้าง FEN จากกระดานที่ตรวจจับได้.';

  @override
  String get outputInCurrentLanguage => 'ผลลัพธ์ในภาษาปัจจุบัน';

  @override
  String get commonBaseUrls => 'URL พื้นฐานทั่วไป';

  @override
  String get viewCommonModels => 'ดูโมเดลทั่วไป';

  @override
  String get recognitionParametersUpdated => 'อัปเดตพารามิเตอร์การจดจำแล้ว.';

  @override
  String get whiteSMove => 'ตาของขาว';

  @override
  String get resetToDefaults => 'รีเซ็ตไปที่ค่าเริ่มต้น';

  @override
  String get photoShoot => 'ถ่ายภาพ';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'ไม่สามารถใช้ตำแหน่งกระดานที่ตรวจจับได้.';

  @override
  String get llmPromptContent => 'เนื้อหาพรอมต์ LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'ยังไม่ได้ตั้งค่า LLM โปรดตรวจสอบการตั้งค่าของคุณ.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'ตั้งค่าผู้ให้บริการ, โมเดล, API Key และ Base URL';

  @override
  String get llmConfiguration => 'การกำหนดค่า LLM';

  @override
  String get configureLlmProvider => 'ตั้งค่า LLM provider';

  @override
  String get llmPromptTemplateHeader => 'ส่วนหัวเทมเพลตพรอมต์ LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'ไม่พบชิ้นส่วนใดๆ ในภาพ โปรดลองอีกครั้ง.';

  @override
  String get recognizeBoardFromImage => 'จดจำกระดานจากภาพ';

  @override
  String get viewTips => 'ดูเคล็ดลับ';

  @override
  String get applyToBoard => 'นำไปใช้กับกระดาน';

  @override
  String get adjustBoardArea => 'ปรับพื้นที่กระดาน';

  @override
  String get viewCommonUrls => 'ดู URL ทั่วไป';

  @override
  String get colorAnalysisFailed => 'การวิเคราะห์สีล้มเหลว!';

  @override
  String get analyzingGameBoardImage => 'กำลังวิเคราะห์ภาพกระดานเกม...';

  @override
  String get selectFromAlbum => 'เลือกจากอัลบั้ม';

  @override
  String get noBoardPointDetected => 'ไม่พบจุดบนกระดาน!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'หากปล่อยว่าง จะใช้เทมเพลตเริ่มต้น';

  @override
  String get llmConfig => 'การกำหนดค่า LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'คุณแน่ใจหรือไม่ว่าต้องการรีเซ็ตเทมเพลตพรอมต์กลับเป็นค่าเริ่มต้น?';

  @override
  String get llmPromptTemplateFooter => 'ท้ายเทมเพลตพรอมต์ LLM';

  @override
  String get loadingResponse => 'กำลังโหลดการตอบกลับ...';

  @override
  String get applyThisResultToBoard => 'ใช้ผลลัพธ์นี้กับกระดาน';

  @override
  String get takingPicture => 'กำลังถ่ายภาพ...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'โปรดเลือกภาพกระดานเกมสำหรับการระบุ';

  @override
  String get identificationResults => 'ผลลัพธ์การระบุ';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'วิเคราะห์การเดินและให้ข้อมูลเชิงลึก';

  @override
  String get getApiKey => 'รับ API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'กระบวนการจดจำทั้งหมดไม่สำเร็จ.';

  @override
  String get boardRecognitionResult => 'ผลการจดจำกระดานเกม';

  @override
  String get askLlm => 'ถาม LLM';

  @override
  String get boardDetectionFailed => 'ตรวจจับกระดานล้มเหลว!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'ไม่พบจุดบนกระดาน จึงไม่สามารถระบุชิ้นได้!';

  @override
  String get copyFen => 'คัดลอก FEN';

  @override
  String get commonlyUsedModels => 'โมเดลที่ใช้งานบ่อย';

  @override
  String get apiKeyOptional => 'API Key (ไม่บังคับ)';

  @override
  String get noImageSelected => 'ยังไม่ได้เลือกรูปภาพ';

  @override
  String get blackSMove => 'ตาของดำ';

  @override
  String get llm => 'โมเดลภาษาใหญ่';

  @override
  String get llmProvider => 'ผู้ให้บริการ';

  @override
  String get baseUrl => 'URL ฐาน';

  @override
  String get model => 'โมเดล';

  @override
  String get temperature => 'อุณหภูมิ';

  @override
  String get llmCommandReceivedProcessing =>
      'ได้รับคำสั่งแล้ว! AI กำลังประมวลผล...';

  @override
  String get llmDeepThinkingWait => 'กำลังคิดอย่างลึกซึ้ง โปรดรอ...';

  @override
  String get llmPresentingSoon => 'กำลังจะแสดงในไม่ช้า...';

  @override
  String get recognitionParameters => 'พารามิเตอร์การจดจำ';

  @override
  String get adjustParamsDesc => 'ปรับพารามิเตอร์เพื่อเพิ่มความแม่นยำในการจดจำ';

  @override
  String get saveParameters => 'บันทึกพารามิเตอร์';

  @override
  String unableToStartImageRecognition(String error) {
    return 'ไม่สามารถเริ่มการจดจำภาพได้: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'การจดจำภาพล้มเหลว: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'ใช้ตำแหน่งโดยมีตัวหมากขาว $whiteCount ตัว และดำ $blackCount ตัว';
  }

  @override
  String get fenCopiedToClipboard => '(คัดลอก FEN ไปยังคลิปบอร์ดแล้ว)';

  @override
  String recognitionFailed(String error) {
    return 'การจดจำล้มเหลว: $error';
  }

  @override
  String get myRating => 'อันดับของฉัน';

  @override
  String get gamesPlayed => 'เกมที่เล่น';

  @override
  String get wins => 'ชนะ';

  @override
  String get losses => 'แพ้';

  @override
  String get draws => 'เสมอ';

  @override
  String get lastUpdated => 'อัปเดตล่าสุด';

  @override
  String get format => 'รูปแบบ:';

  @override
  String get resetStatistics => 'รีเซ็ตสถิติ';

  @override
  String get drawRate => 'อัตราเสมอ';

  @override
  String get lossRate => 'อัตราแพ้';

  @override
  String get aiStatistics => 'สถิติ AI';

  @override
  String get enableStatistics => 'เปิดใช้งานสถิติ';

  @override
  String get enableStatistics_Detail =>
      'เมื่อเปิดใช้งาน ผลการแข่งขันจะถูกบันทึกในสถิติ อย่างไรก็ตาม เกมที่เกี่ยวข้องกับการย้อนกลับจะไม่ถูกบันทึก เมื่อปิดใช้งาน การเก็บสถิติจะหยุดชั่วคราว';

  @override
  String get thisWillResetAllGameStatistics =>
      'การดำเนินการนี้จะรีเซ็ตสถิติเกมทั้งหมด การดำเนินการนี้ไม่สามารถยกเลิกได้';

  @override
  String get boardInnerRingSize => 'ขนาดวงแหวนด้านในของกระดาน';

  @override
  String get boardShadowEnabled => 'เงาของกระดาน';

  @override
  String get trapAwareness => 'การตรวจจับกับดัก';

  @override
  String get trapAwarenessDescription =>
      'ไฮไลต์หมากกับดักด้วยวงกลมและลูกศรหนาระหว่างการวิเคราะห์.';

  @override
  String trapExists(String trapMoves) {
    return 'มีกับดักอยู่ การเดินหมากกับดัก: $trapMoves';
  }

  @override
  String get custodianCapture => 'การจับขนาบ';

  @override
  String get custodianCaptureDescription =>
      'แนบชิ้นส่วนหนึ่งของคู่ต่อสู้ระหว่างสองของคุณเป็นเส้นตรงเพื่อจับมัน';

  @override
  String get custodianCaptureEnable => 'อนุญาตให้จับขนาบ';

  @override
  String get interventionCapture => 'การจับภาพการแทรกแซง';

  @override
  String get interventionCaptureDescription =>
      'ย้ายเข้าไปในจุดว่างระหว่างสองชิ้นของคู่ต่อสู้ของคุณเพื่อจับพวกมันทั้งคู่';

  @override
  String get interventionCaptureEnable => 'อนุญาตให้จับภาพการแทรกแซง';

  @override
  String get leapCapture => 'กระโดดจับ';

  @override
  String get leapCaptureDescription =>
      'จับภาพด้วยการกระโดดข้ามชิ้นส่วนของคู่ต่อสู้ที่อยู่ติดกันเข้าไปในจุดว่างที่อยู่ไกลออกไป';

  @override
  String get leapCaptureEnable => 'อนุญาตให้กระโดดกระโดด';

  @override
  String get captureApplicableLines => 'สายที่ใช้งานได้';

  @override
  String get captureSquareEdges => 'ตามขอบของจัตุรัส';

  @override
  String get captureCrossLines => 'ตามแนว orthogonal ข้ามสี่เหลี่ยมจัตุรัส';

  @override
  String get captureDiagonalLines => 'ตามแนวเส้นทแยงมุมข้ามสี่เหลี่ยมจัตุรัส';

  @override
  String get captureExecutionPhases => 'ขั้นตอนการดำเนินการ';

  @override
  String get capturePiecesCondition =>
      'ความพร้อมใช้งานในระหว่างขั้นตอนการเคลื่อนไหวตามชิ้นส่วนที่เหลืออยู่';

  @override
  String get capturePiecesConditionUnlimited => 'ไม่มีข้อ จำกัด';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'มีให้เมื่อคุณมีสามชิ้นหรือน้อยกว่า';
}
