// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Telugu (`te`).
class STe extends S {
  STe([String locale = 'te']) : super(locale);

  @override
  String get appName => 'దాడి';

  @override
  String get welcome => 'స్వాగతం';

  @override
  String get yes => 'అవును';

  @override
  String get no => 'లేదు';

  @override
  String get game => 'గేమ్';

  @override
  String get humanVsAi => 'మానవ Vs. AI';

  @override
  String get humanVsHuman => 'మానవ Vs. మానవ';

  @override
  String get aiVsAi => 'AI Vs. AI';

  @override
  String get humanVsCloud => 'మానవ Vs. మేఘం';

  @override
  String get humanVsLAN => 'మానవ Vs. LAN';

  @override
  String get testViaLAN => 'LAN ద్వారా పరీక్షించండి';

  @override
  String get move => 'కదలిక';

  @override
  String get showMoveList => 'జాబితాను తరలించండి';

  @override
  String get moveList => 'జాబితాను తరలించండి';

  @override
  String get noGameRecord => 'రికార్డ్ లేదు';

  @override
  String get ok => 'అలాగే';

  @override
  String get confirm => 'నిర్ధారించండి';

  @override
  String get cancel => 'రద్దు చేయండి';

  @override
  String get tipSelectWrong => 'తప్పు భాగాన్ని ఎంచుకోండి.';

  @override
  String get tipPlace => 'మీ ముక్కలు ఉంచండి.';

  @override
  String get tipBanPlace => 'మీరు దీన్ని ఇక్కడ ఉంచలేరు.';

  @override
  String get tipPlaced => 'మీరు ఉంచారు.';

  @override
  String get tipRemove => 'ఒక ముక్క తొలగించండి.';

  @override
  String get tipBanRemove => 'మీరు దాన్ని తీసివేయలేరు.';

  @override
  String get tipRemoved => 'మీరు తీసివేశారు.';

  @override
  String get tipMove => 'ఒక భాగాన్ని తరలించండి.';

  @override
  String get tipCannotPlace => 'మీరు మీ భాగాన్ని ఇక్కడ ఉంచలేరు.';

  @override
  String get tipCannotMove => 'మీరు మీ భాగాన్ని ఇక్కడకు తరలించలేరు.';

  @override
  String get tipMill => 'మిల్లు! మీ ప్రత్యర్థి భాగాన్ని తీసుకోండి.';

  @override
  String get tipContinueMill =>
      'మీ ప్రత్యర్థి భాగాన్ని తీసుకోవడం కొనసాగించండి.';

  @override
  String get tipSelectOpponentsPiece =>
      'మీ ప్రత్యర్థి ముక్కలలో ఒకదాన్ని ఎంచుకోండి.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'మీరు మిల్లు నుండి ఒక భాగాన్ని తీసివేయలేరు.';

  @override
  String get tipCanMoveOnePoint => 'ఒక ముక్క 1 పాయింట్‌ను కదిలించగలదు.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'మీరు మీ ప్రత్యర్థి ముక్కలను తరలించలేరు.';

  @override
  String get tipSelectPieceToMove => 'తరలించడానికి మీ భాగాన్ని ఎంచుకోండి.';

  @override
  String get tipHaveThreePiecesLeft => 'మీకు మూడు ముక్కలు మిగిలి ఉన్నాయి.';

  @override
  String get tipCanMoveToAnyPoint => 'మీకు నచ్చిన ఏ పాయింట్‌కైనా వెళ్లవచ్చు.';

  @override
  String tipToMove(Object player) {
    return '$player తరలించడానికి.';
  }

  @override
  String get whiteWin => 'ప్లేయర్ 1 విజయాలు!';

  @override
  String get blackWin => 'ప్లేయర్ 2 విజయాలు!';

  @override
  String get won => 'గెలిచింది';

  @override
  String get lost => 'కోల్పోయిన';

  @override
  String get thinking => 'ఆలోచిస్తూ…';

  @override
  String get newGame => 'కొత్త ఆట';

  @override
  String get importGame => 'ఆట దిగుమతి';

  @override
  String get exportGame => 'ఎగుమతి ఆట';

  @override
  String get gameImported => 'గేమ్ దిగుమతి చేయబడింది.';

  @override
  String cannotImport(Object invalidMove) {
    return 'దిగుమతి చేయడం సాధ్యపడదు $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'కదలికలు మరియు నియమాలు సరిపోలడం లేదు.';

  @override
  String get pleaseWait => 'దయచేసి వేచి ఉండండి.';

  @override
  String get restartGame => 'ప్రస్తుత ఆటను పున art ప్రారంభించాలా?';

  @override
  String get restart => 'పున art ప్రారంభించండి';

  @override
  String get gameStarted => 'ఆట ప్రారంభమైంది, దయచేసి ఉంచండి.';

  @override
  String get analyzing => 'విశ్లేషిస్తోంది…';

  @override
  String error(Object message) {
    return 'లోపం: $message';
  }

  @override
  String get winRate => 'విన్ రేట్';

  @override
  String get score => 'స్కోరు:';

  @override
  String get white => 'ప్లేయర్ 1';

  @override
  String get black => 'ప్లేయర్ 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player ముక్కల సంఖ్య మూడు కంటే తక్కువ.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player రాజీనామా.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player వెళ్ళడానికి మార్గం లేదు.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'బోర్డు నిండింది మరియు $player వెళ్ళడానికి మార్గం లేదు.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'సమయం ముగిసింది, $player కోల్పోయింది.';
  }

  @override
  String get drawReasonRule50 =>
      'కదిలే దశలో, చివరి నిర్దిష్ట సంఖ్యలో కదలికలలో ఏ భాగాన్ని తొలగించలేదు.';

  @override
  String get drawReasonBoardIsFull => 'బోర్డు నిండినందున ఇది డ్రా.';

  @override
  String get drawReasonThreefoldRepetition =>
      'మూడు రెట్లు పునరావృతం కావడం వల్ల ఇది డ్రా.';

  @override
  String get gameOverUnknownReason => 'ఆట సమాప్తం! తెలియని కారణం.';

  @override
  String get gameOver => 'ఆట సమాప్తం';

  @override
  String get youWin => 'నువ్వు గెలిచావు! అభినందనలు!';

  @override
  String challengeHarderLevel(int level) {
    return 'కఠినమైన స్థాయిని సవాలు చేయాలా? కొత్త స్థాయి స్థాయి $level ఉంటుంది!';
  }

  @override
  String get youLose => 'మీరు కోల్పోతారు!';

  @override
  String get analyze => 'విశ్లేషించడానికి';

  @override
  String get about => 'గురించి';

  @override
  String version(Object versionNumber) {
    return 'వెర్షన్: $versionNumber';
  }

  @override
  String get thanks => 'ధన్యవాదాలు';

  @override
  String get settings => 'సెట్టింగులు';

  @override
  String get options => 'ఎంపికలు';

  @override
  String get generalSettings => 'సాధారణ అమర్పులు';

  @override
  String get skillLevel => 'కఠినత స్థాయి';

  @override
  String get moveTime => 'AI ఆలోచించే సమయం';

  @override
  String get difficulty => 'కఠినత';

  @override
  String get playSounds => 'ధ్వని ప్రభావాలు';

  @override
  String get playSoundsInTheGame => 'ఆటలో శబ్దాలు ఆడండి';

  @override
  String get keepMuteWhenTakingBack => 'తిరిగి తీసుకునేటప్పుడు మ్యూట్ చేయండి';

  @override
  String get tone => 'టోన్';

  @override
  String get whoMovesFirst => 'మొదటి కదలిక';

  @override
  String get human => 'మానవ';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'ప్రత్యామ్నాయం';

  @override
  String get isAutoRestart => 'ఆట ముగిసినప్పుడు ఆటను పున art ప్రారంభించండి';

  @override
  String get isAutoChangeFirstMove => 'ఆటో చేంజ్ ఫస్ట్ మూవ్';

  @override
  String get shufflingEnabled => 'యాదృచ్ఛిక కదలిక';

  @override
  String get misc => 'ఇతరాలు';

  @override
  String get rules => 'నియమాలు';

  @override
  String get piecesCount => 'ప్రతి క్రీడాకారుడు కలిగి ఉన్న ముక్కల సంఖ్య';

  @override
  String get piecesCount_Detail =>
      'ప్రతి క్రీడాకారుడికి ఎన్ని ముక్కలు ఉన్నాయి?';

  @override
  String get flyPieceCount => 'ఎగిరే ముక్క సంఖ్య';

  @override
  String get flyPieceCount_Detail =>
      'ఫ్లయింగ్ ప్రారంభించబడితే, ఒక క్రీడాకారుడు ఒక నిర్దిష్ట ముక్కల సంఖ్యకు తగ్గించబడినప్పుడు, ఆమె ముక్కలు మిగిలిన ఆటల మాదిరిగానే ప్రక్కనే ఉన్న పాయింట్లకు పరిమితం కాకుండా ఏదైనా ఖాళీ చేయని బిందువుకు వెళ్లడానికి ఉచితం.';

  @override
  String get piecesAtLeastCount => 'ముక్కలు తక్కువ';

  @override
  String get hasDiagonalLines => 'వికర్ణ రేఖలు';

  @override
  String get hasDiagonalLines_Detail =>
      'బోర్డుకు నాలుగు వికర్ణ రేఖలను జోడించండి.';

  @override
  String get isDefenderMoveFirst => 'రెండవ ఆటగాడు మొదట కదులుతాడు';

  @override
  String get isDefenderMoveFirst_Detail =>
      'ఉంచే దశలో రెండవ స్థానంలో ఉన్న ఆటగాడు కదిలే దశలో మొదట కదులుతాడు.';

  @override
  String get mayRemoveMultiple => 'బహుళ-తీసివేయి';

  @override
  String get mayRemoveMultiple_Detail =>
      'ఒక క్రీడాకారుడు ఒకేసారి ఒకటి కంటే ఎక్కువ మిల్లులను మూసివేస్తే, ఆమె మూసివేసిన మిల్లుల సంఖ్యను ఆమె తొలగిస్తుంది.';

  @override
  String get mayRemoveFromMillsAlways => 'మిల్లులను నాశనం చేయండి';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'అప్రమేయంగా, ఏర్పడిన మిల్లు నుండి ఒక భాగాన్ని తొలగించే ముందు ఆటగాళ్ళు మొదట ఇతర ముక్కలను తొలగించాలి. పరిమితిని నిలిపివేయడానికి ఈ ఎంపికను ప్రారంభించండి.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'బోర్డు నిండినప్పుడు రెండవ ఆటగాడు ఓడిపోతాడు';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'ఉంచే దశ చివరిలో బోర్డు నిండినప్పుడు, మొదట ఉంచే వైపు ఆటను కోల్పోతుంది. లేకపోతే, ఆట డ్రా.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'చట్టపరమైన కదలికలు లేనప్పుడు కోల్పోతారు';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'తన ప్రత్యర్థి వారిని తరలించకుండా అడ్డుకుంటే ఆటగాడు కోల్పోతాడు. ఈ ఎంపిక నిలిపివేయబడితే తరలించడానికి వైపు మార్చండి.';

  @override
  String get mayFly => 'ఎగురుతూ';

  @override
  String get mayFly_Detail =>
      'ఒక ఆటగాడికి మూడు లేదా నాలుగు (కాన్ఫిగర్ చేయదగిన) ముక్కలు మాత్రమే మిగిలి ఉంటే, ఆమె ఆ భాగాన్ని ఏదైనా ఉచిత బిందువుకు తరలించవచ్చు.';

  @override
  String get nMoveRule => 'ఎన్-మూవ్ రూల్';

  @override
  String get nMoveRule_Detail =>
      'నిర్దిష్ట సంఖ్యలో కదలికలలో తొలగింపు లేనట్లయితే ఆట డ్రా అవుతుంది.';

  @override
  String get rollback => 'రోల్‌బ్యాక్';

  @override
  String get pleaseSelect => 'దయచేసి ఎంచుకోండి';

  @override
  String get copy => 'కాపీ';

  @override
  String get moveHistoryCopied =>
      'క్లిప్‌బోర్డ్‌కు కాపీ చేసిన చరిత్రను తరలించండి.';

  @override
  String get help => 'సహాయం';

  @override
  String get feedback => 'అభిప్రాయం';

  @override
  String get exit => 'బయటకి దారి';

  @override
  String get ruleSettings => 'రూల్ సెట్టింగులు';

  @override
  String get color => 'రంగు';

  @override
  String get boardColor => 'బోర్డు రంగు';

  @override
  String get pieceColor => 'పీస్ రంగు';

  @override
  String get backgroundColor => 'నేపథ్య రంగు';

  @override
  String get lineColor => 'బోర్డు లైన్ రంగు';

  @override
  String get whitePieceColor => 'ప్లేయర్ 1 ముక్క రంగు';

  @override
  String get blackPieceColor => 'ప్లేయర్ 2 ముక్క రంగు';

  @override
  String get messageColor => 'సందేశ రంగు';

  @override
  String get isPieceCountInHandShown => 'చేతిలో ఉన్న ముక్కల సంఖ్యను చూపించు';

  @override
  String get isNotationsShown => 'బోర్డులో సంకేతాలను చూపించు';

  @override
  String get isHistoryNavigationToolbarShown =>
      'చరిత్ర నావిగేషన్ టూల్ బార్ చూపించు';

  @override
  String get display => 'ప్రదర్శన';

  @override
  String get boardBorderLineWidth => 'బోర్డు సరిహద్దు వెడల్పు';

  @override
  String get boardInnerLineWidth => 'బోర్డు లోపలి పంక్తి వెడల్పు';

  @override
  String get pieceWidth => 'పీస్ వెడల్పు';

  @override
  String get fontSize => 'ఫాంట్ పరిమాణం';

  @override
  String get standardNotation => 'WMD సంజ్ఞామానం';

  @override
  String get restore => 'పునరుద్ధరించు';

  @override
  String get restoreDefaultSettings => 'డిఫాల్ట్ సెట్టింగ్లను పునరుద్ధరించండి';

  @override
  String pick(Object element) {
    return '$element ఎంచుకోండి';
  }

  @override
  String get info => 'సమ';

  @override
  String get hint => 'సూచన';

  @override
  String get player => 'ప్లేయర్';

  @override
  String get player1 => 'ప్లేయర్ 1';

  @override
  String get player2 => 'ప్లేయర్ 2';

  @override
  String get howToPlay => 'ఎలా ఆడాలి';

  @override
  String get toPlacePiece =>
      'భాగాన్ని ఉంచడానికి అందుబాటులో ఉన్న ఏదైనా పాయింట్‌పై నొక్కండి.';

  @override
  String get toSelectPiece => 'దానిని తరలించడానికి భాగాన్ని నొక్కండి.';

  @override
  String get toMovePiece =>
      'ముక్కను తరలించడానికి కనెక్ట్ చేసిన పాయింట్‌పై నొక్కండి.';

  @override
  String get toRemovePiece =>
      'తొలగించడానికి ప్రత్యర్థి యొక్క ఒక భాగాన్ని నొక్కండి.';

  @override
  String get needToCreateMillFirst =>
      'మీరు ఒక భాగాన్ని తొలగించే ముందు మీరు మొదట ఒక మిల్లును సృష్టించాలి.';

  @override
  String get needToPlayWithOwnPieces => 'మీరు మీ ముక్కలతో ఆడాలి.';

  @override
  String get statistics => 'గణాంకాలు';

  @override
  String get totalGames => 'మొత్తం ఆటలు';

  @override
  String get results => 'ఫలితాలు';

  @override
  String get left => 'ఎడమ';

  @override
  String get privacyPolicy => 'గోప్యతా విధానం';

  @override
  String get privacyPolicy_Detail_1 =>
      'దయచేసి జాగ్రత్తగా చదవండి మరియు మీరు దీన్ని పూర్తిగా అర్థం చేసుకున్నారని మరియు అంగీకరిస్తున్నారని నిర్ధారించుకోండి ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. మీరు ఈ విధానాన్ని అంగీకరించకపోతే, దయచేసి ఈ అనువర్తనాన్ని ఉపయోగించవద్దు. అనువర్తనాన్ని ఉపయోగించడం మీరు ఈ నిబంధనలను అంగీకరించినట్లు సూచిస్తుంది.';

  @override
  String get and => ' మరియు ';

  @override
  String get accept => 'అంగీకరించు';

  @override
  String get takeBack => 'వెనక్కి తీసుకో';

  @override
  String get takingBack => 'తిరిగి తీసుకొని…';

  @override
  String get waiting => 'వేచి ఉంది…';

  @override
  String get stepForward => 'అడుగు ముందుకు వేయండి';

  @override
  String get takeBackAll => 'అన్నీ వెనక్కి తీసుకోండి';

  @override
  String get stepForwardAll => 'అన్ని ముందుకు';

  @override
  String get moveNow => 'ఇప్పుడే తరలించండి';

  @override
  String get done => 'పూర్తి.';

  @override
  String get crackMill => 'క్రాక్-మిల్లు';

  @override
  String get crackMill_Detail =>
      'ఒక ఆటగాడికి మిల్లుల్లో ముక్కలు మాత్రమే ఉంటే, మిల్లుల్లోని ముక్కలు తొలగించడానికి లాక్ చేయబడవు.';

  @override
  String get animationDuration => 'యానిమేషన్ వ్యవధి';

  @override
  String get none => 'ఏదీ లేదు';

  @override
  String get theme => 'థీమ్';

  @override
  String get helpContent =>
      'ఆట ప్రత్యర్థిని మూడు ముక్కల కన్నా తక్కువ లేదా చట్టపరమైన కదలికలతో వదిలివేయాలని లక్ష్యంగా పెట్టుకుంది.\n\nమూడవ సారి స్థానం సంభవిస్తే లేదా చివరి 100 (కాన్ఫిగర్ చేయదగిన) కదలికలలో తీసివేయకపోతే ఆట స్వయంచాలకంగా డ్రా అవుతుంది.\n\nఆట మూడు దశల్లో కొనసాగుతుంది:\n\n1. ఖాళీ పాయింట్లపై ముక్కలు ఉంచడం\n2. ముక్కలను ప్రక్కనే ఉన్న బిందువులకు తరలించడం\n3. (ఐచ్ఛిక దశ) ఆటగాడిని మూడు ముక్కలుగా తగ్గించేటప్పుడు ఏదైనా ఖాళీ స్థానానికి ముక్కలు తరలించడం\n\nఉంచడం\n\nఆట ఖాళీ బోర్డుతో ప్రారంభమవుతుంది, దీనిలో ఇరవై నాలుగు పాయింట్లతో గ్రిడ్ ఉంటుంది. ప్రతి క్రీడాకారుడు అన్ని ముక్కలను బోర్డులో ఉంచే వరకు ఆటగాళ్ళు తమ ముక్కలను ఖాళీ పాయింట్లపై ఉంచే మలుపులు తీసుకుంటారు. ఒక ఆటగాడు తన మూడు ముక్కలను సూటిగా ఉంచగలిగితే, అతనికి \"మిల్లు\" ఉంది మరియు అతని ప్రత్యర్థి ముక్కలలో ఒకదాన్ని బోర్డు నుండి తొలగించవచ్చు.\n\nకొన్ని నియమాలలో, ఏర్పడిన మిల్లు నుండి ఒక భాగాన్ని తొలగించే ముందు ఆటగాళ్ళు మొదట ఇతర ముక్కలను తొలగించాలి.\n\nమీరు తొలగించిన ముక్కల బిందువులకు కొన్ని నియమాలలో ఉంచే దశలో ఉంచలేరు.\n\nఅన్ని ముక్కలను ఉపయోగించిన తర్వాత, ఆటగాళ్ళు కదిలే మలుపులు తీసుకుంటారు.\n\nకదులుతోంది\n\nతరలించడానికి, ఒక ఆటగాడు తన ముక్కలలో ఒకదాన్ని బోర్డు రేఖ వెంట ఖాళీగా ఉన్న ప్రక్కన ఉన్న స్థానానికి తరలిస్తాడు. అతను అలా చేయలేకపోతే, అతను ఆటను కోల్పోయాడు. బోర్డు లైన్‌లో తన మూడు ముక్కలను సమలేఖనం చేసే ఆటగాడికి ఒక మిల్లు ఉంటుంది మరియు ఉంచే దశలో ఉన్నట్లుగా తన ప్రత్యర్థి ముక్కలలో ఒకదాన్ని తీసివేయవచ్చు. ఏదైనా ఆటగాడు రెండు ముక్కలుగా తగ్గిస్తాడు, కొత్త మిల్లులను ఏర్పరుచుకునే అవకాశం లేదు, తద్వారా ఆటను కోల్పోతాడు. ఒక ఆటగాడు తన ప్రత్యర్థి వాటిని కదలకుండా అడ్డుకుంటే మూడు ముక్కలకు పైగా ఉన్నప్పుడు కూడా కోల్పోవచ్చు.\n\nఎగురుతూ\n\nనిబంధనల యొక్క కొన్ని వైవిధ్యాలలో, ఒక ఆటగాడికి మూడు ముక్కలు మాత్రమే మిగిలి ఉంటే, అతని ముక్కలు ప్రక్కనే ఉన్న వాటికి మాత్రమే కాకుండా, ఖాళీగా ఉన్న పాయింట్లకు ఎగరవచ్చు, హాప్ చేయవచ్చు లేదా దూకవచ్చు.\n';

  @override
  String get versionInfo => 'సంస్కరణ సమాచారం';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'లైసెన్స్';

  @override
  String get sourceCode => 'మూల కోడ్';

  @override
  String get appVersion => 'అనువర్తన సంస్కరణ';

  @override
  String get general => 'జనరల్';

  @override
  String get advanced => 'ఆధునిక';

  @override
  String get placing => 'ఉంచడం';

  @override
  String get moving => 'కదులుతోంది';

  @override
  String get removing => 'తొలగిస్తోంది';

  @override
  String get gameOverCondition => 'గేమ్ ఓవర్ కండిషన్';

  @override
  String get aisPlayStyle => 'AI యొక్క ప్లేస్టైల్';

  @override
  String get passive => 'నిష్క్రియాత్మ';

  @override
  String get timeout => 'సమయం ముగిసినది';

  @override
  String get appearance => 'స్వరూపం';

  @override
  String get drawOnHumanExperience => 'మానవ అనుభవాన్ని గీయండి';

  @override
  String get considerMobility => 'ముక్కల కదలికను పరిగణించండి';

  @override
  String get pieceCount => 'పీస్ కౌంట్:';

  @override
  String inHand(Object player, int count) {
    return 'చేతిలో $player: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player బోర్డులో: $count';
  }

  @override
  String get boardTop => 'ఎగువ నుండి బోర్డు ఆఫ్‌సెట్';

  @override
  String get notAIsTurn => 'ఇది AI యొక్క మలుపు కాదు.';

  @override
  String get aiIsNotThinking => 'AI ఆలోచించడం లేదు.';

  @override
  String get atEnd => 'మీరు కదలిక జాబితా చివరిలో ఉన్నారు.';

  @override
  String get tapBackAgainToLeave => 'బయలుదేరడానికి మళ్ళీ నొక్కండి.';

  @override
  String get more => 'మరింత';

  @override
  String get experimental => 'ఇది ప్రయోగాత్మక లక్షణం.';

  @override
  String get experiments => 'ప్రయోగాలు';

  @override
  String get ossLicenses => 'ఓపెన్ సోర్స్ లైసెన్సులు';

  @override
  String get language => 'భాష';

  @override
  String get defaultLanguage => 'డిఫాల్ట్ భాష';

  @override
  String get mayMoveInPlacingPhase => 'ముక్కలు ఉంచే దశలో కదలవచ్చు';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'ప్రత్యేకమైన ఉంచడం మరియు కదిలే దశలు లేవు, అనగా, ఆటగాళ్ళు ప్రతి కదలికలో బోర్డు మీద ఒక భాగాన్ని ఉంచాలనుకుంటున్నారా లేదా వారి ముక్కలలో ఒకదాన్ని తరలించాలా అని నిర్ణయించుకోవచ్చు (వారు ఉంచడానికి మిగిలిన ముక్కలు ఉన్నంత వరకు).';

  @override
  String get drawerColor => 'మెనూ రంగు';

  @override
  String get drawerTextColor => 'మెనూ టెక్స్ట్ రంగు';

  @override
  String get drawerHighlightItemColor => 'మెను అంశం రంగును హైలైట్ చేస్తుంది';

  @override
  String get mainToolbarBackgroundColor => 'ప్రధాన ఉపకరణపట్టీ నేపథ్య రంగు';

  @override
  String get mainToolbarIconColor => 'ప్రధాన ఉపకరణపట్టీ చిహ్నం రంగు';

  @override
  String get navigationToolbarBackgroundColor =>
      'నావిగేషన్ టూల్ బార్ నేపథ్య రంగు';

  @override
  String get navigationToolbarIconColor => 'నావిగేషన్ టూల్ బార్ చిహ్నం రంగు';

  @override
  String get autoHideToolbar => 'ఉపకరణపట్టీని స్వయంచాలకంగా దాచండి';

  @override
  String get toolbarLocationOnScreen => 'తెరపై ఉపకరణపట్టీ స్థానం';

  @override
  String get top => 'టాప్';

  @override
  String get bottom => 'దిగువ';

  @override
  String get center => 'కేంద్రం';

  @override
  String get solidColor => 'ఘన రంగు';

  @override
  String get picture => 'చిత్రం';

  @override
  String get chooseYourPicture => 'మీ చిత్రాన్ని ఎంచుకోండి';

  @override
  String get light => 'కాంతి';

  @override
  String get dark => 'చీకటి';

  @override
  String get themes => 'థీమ్స్';

  @override
  String get currentTheme => 'ప్రస్తుత థీమ్';

  @override
  String get saveTheme => 'థీమ్‌ను సేవ్ చేయండి';

  @override
  String get showAnalysisGraph => 'విశ్లేషణ గ్రాఫ్ చూపించు';

  @override
  String get analysis => 'విశ్లేషణ';

  @override
  String get saveGame => 'ఆటను సేవ్ చేయండి';

  @override
  String get loadGame => 'ఆట లోడ్';

  @override
  String get setupPosition => 'సెటప్ స్థానం';

  @override
  String get showLegalMoves => 'చట్టపరమైన కదలికలను చూపించు';

  @override
  String get showLastMove => 'చివరి కదలికను చూపించు';

  @override
  String get showArrows => 'బాణాలు చూపించు';

  @override
  String get pieces => 'ముక్కలు';

  @override
  String get showAnalysis => 'విశ్లేషణ చూపించు';

  @override
  String get threads => 'థ్రెడ్లు';

  @override
  String get getInvolved => 'చేరి చేసుకోగా';

  @override
  String get helpImproveTranslate => 'అనువాదాన్ని మెరుగుపరచడంలో సహాయపడండి';

  @override
  String get tutorial => 'ట్యుటోరియల్';

  @override
  String get classicMill => 'క్లాసిక్ మిల్';

  @override
  String get mixedMill => 'మిశ్రమ మిల్లు';

  @override
  String get ceylonMill => 'సిలోన్ మిల్';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'మిల్లు విచ్ఛిన్నమై పదేపదే రీమేక్ చేయవచ్చు';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'ఒక కొత్త మిల్లును సృష్టించడానికి ఒక ఆటగాడు ఒక మిల్లును విచ్ఛిన్నం చేస్తే, అలాంటి ఆటగాడు కొత్త మిల్లును తయారు చేస్తే, ఆ ముక్కను తన తదుపరి కదలికలో అసలు జంక్షన్‌కు తిరిగి తరలించవచ్చు.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'ఒక ఆటగాడికి మూడు ముక్కలు ఉంటే ఆట డ్రా అవుతుంది మరియు పది కదలికల తరువాత ఆటగాడు ప్రత్యర్థి ముక్కలను తొలగించడు';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'ఒక ఆటగాడు మూడు ముక్కలుగా ఉన్నప్పుడు, మరియు ఏ ఆటగాడు పది కదలికలలో ప్రత్యర్థి భాగాన్ని తీసివేయలేడు, ఆట డ్రా.';

  @override
  String get close => 'దగ్గరగా';

  @override
  String get whitePiece => 'తెల్ల ముక్క';

  @override
  String get blackPiece => 'నల్ల ముక్క';

  @override
  String get emptyPoint => 'ఖాళీ పాయింట్';

  @override
  String get noPoint => 'ప్రయోజనం లేదు';

  @override
  String get placingPhase => 'ఉంచడం దశ';

  @override
  String get movingPhase => 'కదిలే దశ';

  @override
  String get flyingPhase => 'ఎగిరే దశ';

  @override
  String sideToMove(Object player) {
    return 'తరలించడానికి వైపు: $player';
  }

  @override
  String lastMove(Object move) {
    return 'చివరి తరలింపు: $move';
  }

  @override
  String get selected => 'ఎంపిక చేయబడింది';

  @override
  String get accessibility => 'సౌలభ్యాన్ని';

  @override
  String get screenReaderSupport => 'స్క్రీన్ రీడర్ మద్దతు';

  @override
  String get isDraw => 'ఇది డ్రా!';

  @override
  String get draw => 'గీయండి';

  @override
  String get pieceHighlightColor => 'పీస్ హైలైట్ రంగు';

  @override
  String get algorithm => 'అల్గోరిథం';

  @override
  String get endgameNMoveRule => 'ఎండ్ గేమ్ N- మూవ్ నియమం';

  @override
  String get endgameNMoveRule_Detail =>
      'ఒక ఆటగాడికి మూడు ముక్కలు మాత్రమే ఉంటే మరియు నిర్దిష్ట కదలికల లోపల ఆటగాడు ఒక భాగాన్ని తీసివేయకపోతే, గేమ్ డ్రా అవుతుంది.';

  @override
  String get drawReasonEndgameRule50 =>
      'ఏ ఆటగాడికైనా మూడు ముక్కలు మాత్రమే ఉంటాయి మరియు నిర్దిష్ట కదలికలలో ఏ ఆటగాడు ఒక భాగాన్ని తీసివేయడు.';

  @override
  String get threefoldRepetitionRule => 'మూడు రెట్లు పునరావృత నియమం';

  @override
  String get threefoldRepetitionRule_Detail =>
      'ఒక స్థానం మూడవసారి సంభవించినట్లయితే గేమ్ డ్రా అవుతుంది.';

  @override
  String get continueToMakeMove => 'మిల్! ఒక కదలికను కొనసాగించండి.';

  @override
  String get pointStyle => 'పాయింట్ శైలి';

  @override
  String get pointWidth => 'పాయింట్ వెడల్పు';

  @override
  String get solid => 'ఘన';

  @override
  String get hollow => 'బోలు';

  @override
  String get languageName => 'తెలుగు';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count కదలికలు',
      one: '$count Move',
      zero: 'Move',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'లోడ్ విఫలమైంది.';

  @override
  String get filename => 'ఫైల్ పేరు';

  @override
  String get browse => 'బ్రౌజ్ చేయండి…';

  @override
  String get gameFiles => 'గేమ్ ఫైళ్లు';

  @override
  String get gameSavedTo => 'గేమ్ సేవ్ చేయబడింది';

  @override
  String get empty => 'ఖాళీ';

  @override
  String get noMove => 'కదలిక లేదు.';

  @override
  String get restoredPosition => 'ప్రారంభ స్థానం పునరుద్ధరించబడింది.';

  @override
  String get clean => 'శుభ్రంగా';

  @override
  String get cleanedUp => 'శుభ్రం చేశారు.';

  @override
  String get remove => 'తొలగించు';

  @override
  String get noPiecesCanBeRemoved => 'ముక్కలు తీసివేయబడవు.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ముక్కలు',
      one: '$count ముక్క',
      zero: 'Piece',
    );
    return '$_temp0 తీసివేయాలి.';
  }

  @override
  String placedCount(int count) {
    return 'ఉంచబ. ($count)';
  }

  @override
  String get placedPieceCount => 'ఉంచే దశలో ముక్కల సంఖ్యను ఉంచారు.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'ప్రస్తుత ఆటగాడు $count ముక్కలను ఉంచాడు.';
  }

  @override
  String get notPlacingPhase => 'దశను ఉంచడం లేదు, దానిని మార్చలేరు.';

  @override
  String get paste => 'అతికించండి';

  @override
  String get pasteDone => 'పేస్ట్ పూర్తయింది.';

  @override
  String get cannotPaste => 'అతికించలేరు.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'ఉంచని మరియు తీసివేయబడిన ముక్కలను చూపించు';

  @override
  String get fullScreen => 'పూర్తి స్క్రీన్';

  @override
  String get reopenToTakeEffect =>
      'సెట్టింగ్‌లు అమలులోకి రావడానికి యాప్ నుండి నిష్క్రమించి, మళ్లీ తెరవండి.';

  @override
  String get forest => 'అడవి';

  @override
  String get desktopImage => 'డెస్క్‌టాప్ చిత్రం';

  @override
  String get invalidPosition => 'చెల్లని స్థానం.';

  @override
  String get shareGIF => 'GIFని షేర్ చేయండి';

  @override
  String get pixelRatio => 'పిక్సెల్ నిష్పత్తి';

  @override
  String get duration => 'వ్యవధి';

  @override
  String get gameScreenRecorder => 'గేమ్ స్క్రీన్ రికార్డర్';

  @override
  String get previous => 'మునుపటి';

  @override
  String get next => 'తరువాత';

  @override
  String get skip => 'దాటవేయి';

  @override
  String get gotIt => 'దొరికింది';

  @override
  String get youCanModifyRules =>
      'మీరు రూల్ సెట్టింగ్‌లలో గేమ్ నియమాలను సవరించవచ్చు.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'పికర్‌లో విలువను మార్చడానికి మీరు మౌస్ వీల్‌ని ఉపయోగించవచ్చు.';

  @override
  String get noTimeLimitForThinking =>
      'AI ఆలోచించే సమయం 0కి సెట్ చేయబడింది అంటే ఆలోచించడానికి సమయ పరిమితి లేదు.';

  @override
  String get whatIsMtdf =>
      'MTD(f) అనేది ఆల్ఫా-బీటా శోధన అల్గోరిథం యొక్క సవరించిన రూపం, ఇది ఇంటర్మీడియట్ శోధన ఫలితాలను తిరిగి ఉపయోగించడం ద్వారా మరియు శోధన స్థలాన్ని తగ్గించడానికి మంచి ప్రారంభ అంచనాను ఉపయోగించడం ద్వారా సామర్థ్యాన్ని మెరుగుపరచడం లక్ష్యంగా పెట్టుకుంది.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'AI థింకింగ్ టైమ్ అడ్జస్ట్‌మెంట్ పూర్తిగా ఖచ్చితంగా ఉండకపోవచ్చని దయచేసి గుర్తుంచుకోండి. క్లిష్టత స్థాయిని తక్కువ విలువకు సెట్ చేసినప్పుడు వాస్తవ ఆలోచనా సమయం తక్కువగా ఉండవచ్చు మరియు సమయం ముగిసినప్పుడు AI మధ్యలో ఆలోచించినప్పుడు ఎక్కువ సమయం ఉండవచ్చు.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'మీరు క్లిష్టత స్థాయిని ఎక్కువగా సెట్ చేసి, AI ఆలోచించే సమయాన్ని పెంచకపోతే, ఆలోచన సమయ పరిమితి కారణంగా అసలు కష్ట స్థాయి తక్కువ విలువకు పరిమితం కావచ్చు. యంత్రం యొక్క పనితీరు ఆధారంగా వాస్తవ విలువ మారవచ్చు.';

  @override
  String get whatIsPvs =>
      'PVS (ప్రిన్సిపల్ వేరియేషన్ సెర్చ్) అనేది ఇచ్చిన స్థానంలో అత్యుత్తమ కదలికను కనుగొనే శోధన అల్గారిథమ్. ఇది ఆల్ఫా-బీటా అల్గోరిథం యొక్క మెరుగుదల మరియు ప్రధాన వైవిధ్యం నుండి ఇప్పటికే సురక్షితమైన స్కోర్ కంటే కదలిక అధ్వాన్నంగా లేదా అధ్వాన్నంగా ఉందని నిర్ధారించడానికి శూన్య లేదా సున్నా విండో శోధనలను ఉపయోగిస్తుంది. PVS అత్యంత ఆశాజనకమైన కదలికలపై దృష్టి పెడుతుంది మరియు సబ్‌ప్టిమల్ శాఖల యొక్క అనవసర శోధనలను నివారిస్తుంది, ఇది శోధన సామర్థ్యాన్ని మెరుగుపరచడంలో సహాయపడుతుంది.';

  @override
  String get whatIsAlphaBeta =>
      'ఆల్ఫా-బీటా అల్గోరిథం అనేది ఉత్తమ కదలికను కనుగొనడానికి ఒక శోధన అల్గారిథమ్. శోధన చెట్టును కత్తిరించడానికి మరియు సామర్థ్యాన్ని పెంచడానికి ఇది మినిమాక్స్ సూత్రాన్ని మరియు ఆల్ఫా మరియు బీటా అనే రెండు విలువలను ఉపయోగిస్తుంది. ఆల్ఫా అనేది కంప్యూటర్ ఖచ్చితంగా పొందగల కనీస స్కోర్‌ను సూచిస్తుంది, అయితే బీటా దాని ప్రత్యర్థి పొందగలిగే గరిష్ట స్కోర్‌ను సూచిస్తుంది. గేమ్‌లో స్మార్ట్, సమర్థవంతమైన నిర్ణయాలు తీసుకోవడంలో అల్గోరిథం కంప్యూటర్‌కు సహాయపడుతుంది.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'మానవ అనుభవం ప్రకారం, మీరు గెలవాలని ప్రయత్నిస్తే, మీరు ఓడిపోతారు. బదులుగా, మీ లక్ష్యం డ్రాగా లక్ష్యంగా చేసుకోండి మరియు గేమ్‌ను కోల్పోకుండా ఉండండి. మీ ప్రత్యర్థిని గమనించండి మరియు వారు తప్పులు చేసే స్థితికి సున్నితంగా వారిని ఆకర్షించండి. వారు బలహీనతను చూపినప్పుడు, అవకాశాన్ని ఉపయోగించుకోండి మరియు విజయం కోసం సున్నితంగా ముందుకు సాగండి. ఈ విధంగా, మీరు గేమ్ గెలవవచ్చు.';

  @override
  String get firstMoveDetail =>
      'ఈ గేమ్‌లో, మొదటి ఆటగాడితో పోలిస్తే రెండవ ఆటగాడు గెలవడం సులభం.';

  @override
  String get passiveDetail =>
      'నిష్క్రియ ఎంపికను ప్రారంభించడం వలన AIకి వీలైనంత త్వరగా గెలవడానికి దూకుడుగా ప్రయత్నించడం కంటే, ఆ స్థానంలో ప్రయోజనం ఉన్నప్పుడు విశ్రాంతిని పొందుతుంది.';

  @override
  String get moveRandomlyDetail =>
      'ఈ ఎంపికను ప్రారంభించడం వలన ఆట యొక్క యాదృచ్ఛికత మరియు వినోదం పెరుగుతుంది, అయితే దానిని నిలిపివేయడం AIని అధిగమించే మార్గాలను అధ్యయనం చేయడంలో సహాయపడుతుంది.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'AI దాని ముక్కల చలనశీలతను పరిగణనలోకి తీసుకుంటే, అది ప్రత్యర్థి ముక్కలను వీలైనంత త్వరగా పట్టుకోవడమే కాకుండా, ప్రత్యర్థి కదలికలను అడ్డుకోవడం మరియు అదే పని చేయకుండా నిరోధించడాన్ని కూడా పరిగణలోకి తీసుకుంటుంది.';

  @override
  String get whenBoardIsFull => 'బోర్డు నిండినప్పుడు';

  @override
  String get whenBoardIsFull_Detail =>
      'ప్లేసింగ్ దశ ముగింపులో, కదిలే దశ ప్రారంభమయ్యే ముందు, బోర్డు పూర్తిగా ముక్కలతో ఉంటే చర్య అనుసరిస్తుంది.';

  @override
  String get sideToMoveRemovePiece =>
      'కదిలే దశలో ముందుగా కదిలే ఆటగాడు ప్రత్యర్థి పావుల్లో ఒకదాన్ని తొలగిస్తాడు.';

  @override
  String get agreeToDraw => 'ఇరుపక్షాలు డ్రాకు అంగీకరించాయి.';

  @override
  String get takeOpponentsPiece =>
      'మీ ప్రత్యర్థి ముక్కల్లో ఒకదాన్ని తీసుకోండి.';

  @override
  String get firstPlayerLose => 'మొదటి ఆటగాడు ఆటను కోల్పోతాడు.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'మొదటి మరియు రెండవ ఆటగాళ్ళు ప్రత్యర్థి ముక్కల్లో ఒకదాన్ని తీసివేస్తారు.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'రెండవ మరియు మొదటి ఆటగాళ్ళు ప్రత్యర్థి ముక్కలలో ఒకదాన్ని తీసివేస్తారు.';

  @override
  String get enteredFlyingPhase =>
      'ఇప్పుడు ఎగిరే దశలోకి ప్రవేశించింది, ప్రత్యర్థి పావులు బోర్డ్‌లోని ఏదైనా ఖాళీ పాయింట్‌కి వెళ్లవచ్చు. మీరు \"రూల్ సెట్టింగ్‌లు\"లో ఫ్లయింగ్ నియమాన్ని ఆఫ్ చేయవచ్చు.';

  @override
  String get whenStalemate => 'ప్రతిష్టంభన ఏర్పడినప్పుడు';

  @override
  String get whenStalemate_Detail =>
      'ఏ భాగాన్ని తరలించలేనప్పుడు ఏ చర్య అనుసరిస్తుంది?';

  @override
  String get endWithStalemateLoss => 'ప్రతిష్టంభన నష్టంతో ముగించండి.';

  @override
  String get changeSideToMove => 'తరలించడానికి వైపు మార్చండి.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'ప్రత్యర్థి ముక్కల్లో ఒకదాన్ని తీసివేసి, తదుపరి కదలికను చేయండి.';

  @override
  String get endWithStalemateDraw => 'ప్రతిష్టంభన డ్రాతో ముగించండి.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'ప్రత్యర్థి ముక్కల్లో ఒకదాన్ని తీసివేసి, తరలించడానికి వైపు మార్చండి.';

  @override
  String get aiResponseDelayTime => 'AI ప్రతిస్పందన ఆలస్యం సమయం';

  @override
  String get aiIsDelaying =>
      'AI ప్రస్తుతం ఆలస్యం ప్రతిస్పందన దశలో ఉంది. దయచేసి కొనసాగడానికి ముందు కొంతసేపు వేచి ఉండండి.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'మీరు పక్కనే లేని భాగాన్ని తీసివేయలేరు.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'ప్రతిష్టంభన ఏర్పడితే, మిల్లు నిర్మాణంతో సంబంధం లేకుండా మీ పక్కనే ఉన్న ప్రత్యర్థి ముక్కలను తీసివేయవచ్చు.';

  @override
  String get whatIsMcts =>
      'MCTS అనేది అనుభవశూన్యుడు-స్నేహపూర్వక అల్గోరిథం, ఇది అనుకరణల ద్వారా విభిన్న కదలికలను విశ్లేషించడం మరియు మూల్యాంకనం చేయడం ద్వారా నిర్ణయాలు తీసుకుంటుంది.';

  @override
  String get goldenJade => 'గోల్డెన్ జేడ్';

  @override
  String get forestWood => 'ఫారెస్ట్ వుడ్';

  @override
  String get darkMystery => 'డార్క్ మిస్టరీ';

  @override
  String get midnightBlue => 'మిడ్నైట్ బ్లూ';

  @override
  String get greenForest => 'గ్రీన్ ఫారెస్ట్';

  @override
  String get greenMeadow => 'గ్రీన్ మేడో';

  @override
  String get stonyPath => 'రాతి మార్గం';

  @override
  String get pastelPink => 'పాస్టెల్ పింక్';

  @override
  String get turquoiseSea => 'టర్కోయిస్ సముద్రం';

  @override
  String get violetDream => 'వైలెట్ డ్రీం';

  @override
  String get mintChocolate => 'మింట్ చాక్లెట్';

  @override
  String get skyBlue => 'లేత నీలి రంగు';

  @override
  String get playfulGarden => 'ఉల్లాసభరితమైన గార్డెన్';

  @override
  String get whatIsRetrogradeAnalysis =>
      'వివిధ ప్రారంభ స్థానాల నుండి ముగింపు గేమ్ డేటాబేస్‌ను రూపొందించడానికి రెట్రోగ్రేడ్ విశ్లేషణ అల్గోరిథం బహుళ-విలువైన రెట్రోగ్రేడ్ విశ్లేషణను ఉపయోగిస్తుంది, ఆపై గేమ్‌ప్లేను ఆప్టిమైజ్ చేయడానికి ఈ డేటాబేస్‌ను వర్తింపజేస్తుంది. ఈ విధానం అల్ట్రా-స్ట్రాంగ్ సొల్యూషన్స్ విభాగంలోకి వస్తుంది.';

  @override
  String get viewAlgorithmGuide =>
      'మీరు ఈ అల్గారిథమ్ కోసం యూజర్ గైడ్‌ని వీక్షించాలనుకుంటున్నారా?';

  @override
  String get showPositionalAdvantageIndicator => 'స్థాన ప్రయోజన సూచికను చూపు';

  @override
  String get usePerfectDatabase => 'ఖచ్చితమైన డేటాబేస్ ఉపయోగించండి';

  @override
  String get perfectDatabaseDescription =>
      'అత్యాధునిక అల్గారిథమ్‌ల ద్వారా రూపొందించబడిన దోషరహిత గేమ్ డేటాబేస్‌ను ఉపయోగించడానికి ఈ ఎంపికను ప్రారంభించండి. ఈ ఫీచర్ సరైన కదలికలను సూచించడానికి ప్రారంభ మరియు ముగింపు గేమ్ వ్యూహాలను రెండింటినీ అనుసంధానిస్తుంది. గేమ్‌ప్లేలో అత్యున్నత స్థాయి ఖచ్చితత్వాన్ని కోరుకునే ఆటగాళ్లకు ఇది ప్రాధాన్య ఎంపిక. ఖచ్చితమైన గణన పద్ధతుల ద్వారా సృష్టించబడిన, డేటాబేస్ దాదాపు ఖచ్చితమైన గేమ్ పరిష్కారాలను అందించడానికి రూపొందించబడింది.\n\nగమనిక: డేటాబేస్‌ను యాక్సెస్ చేయడంలో AI విఫలమైతే, గేమ్‌ప్లే నిర్ణయాల కోసం ఇది సంప్రదాయ అల్గారిథమ్‌లను ఆశ్రయిస్తుంది. డేటాబేస్ అందుబాటులో ఉన్నప్పుడు, \'డిఫికల్టీ లెవెల్\' అనేది వాస్తవంగా అజేయంగా మారుతుంది మరియు \'AI థింకింగ్ టైమ్\' తీవ్ర తగ్గింపును అనుభవిస్తుంది. డేటాబేస్ ఫలితాలకు అత్యధిక ప్రాధాన్యత ఉన్నందున \'AI\'స్ ప్లేస్టైల్\' ఎంపికలలోని అనేక సెట్టింగ్‌లు భర్తీ చేయబడతాయి.\n\nఈ దోషరహిత డేటాబేస్‌ను ఎలా ఉపయోగించాలో మార్గదర్శకత్వం కోసం, ఇక్కడ క్లిక్ చేయండి.';

  @override
  String get backgroundImage => 'నేపథ్య చిత్రం';

  @override
  String get whatIsRandom =>
      '\'పర్ఫెక్ట్ డేటాబేస్ ఉపయోగించండి\' ఎంపిక ప్రారంభించబడనప్పుడు, \'ర్యాండమ్\' సెట్టింగ్ తరలింపు ఎంపిక కోసం ఎటువంటి అల్గారిథమ్‌లను ఉపయోగించకుండా AI యాదృచ్ఛికంగా ముక్కలను తరలించేలా చేస్తుంది. ఇది సాధారణంగా గణనీయంగా బలహీనమైన గేమ్‌ప్లేకు దారి తీస్తుంది. దీనికి విరుద్ధంగా, \'పర్ఫెక్ట్ డేటాబేస్‌ని ఉపయోగించండి\' ప్రారంభించబడినప్పుడు, AI సంప్రదాయ AI అల్గారిథమ్‌లతో కలపడానికి బదులుగా నిర్ణయాలు తీసుకోవడానికి \'పర్ఫెక్ట్ డేటాబేస్\'పై ప్రత్యేకంగా ఆధారపడుతుంది. ఈ మోడ్‌లో, AI యొక్క కదలికలు పూర్తిగా డేటాబేస్ కంటెంట్‌పై ఆధారపడి ఉంటాయి, నిజ-సమయ గణనలు లేదా శోధన అల్గారిథమ్‌లపై ఆధారపడకుండా ఉంటాయి.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'ప్రత్యర్థి పావు(ల)ను వారి చేతి నుండి తొలగించండి; అప్పుడు పావును ఉంచడం ప్రత్యర్థి వంతు.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'ప్లేసింగ్ దశలో మిల్లులను రూపొందించేటప్పుడు';

  @override
  String get removeOpponentsPieceFromBoard =>
      'ప్రత్యర్థి పావు(ల)ను బోర్డు నుండి తీసివేయండి.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'ప్రత్యర్థి పావు(ల)ను బోర్డు నుండి తీసివేయండి; అప్పుడు పావును ఉంచడం ప్రత్యర్థి వంతు.';

  @override
  String get opponentRemovesOwnPiece =>
      'ప్రత్యర్థి తన సొంత పావు(ల)ను బోర్డు నుండి తొలగిస్తాడు.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'మీరు చర్య తీసుకునే బదులు, ప్రత్యర్థి తన సొంత పావు(ల)ను బోర్డ్ నుండి ఎంచుకుని తొలగిస్తాడు, ఇది వారికి హానికరమైన చర్యను సమర్థవంతంగా తీసుకుంటుంది.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'ప్రత్యర్థి పావు(ల)ను వారి చేతి నుండి తొలగించండి; అప్పుడు మీరు కదిలే వంతు.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'ప్రత్యర్థి చేతి నుండి పావు(లు) తొలగించండి. మల్టీ-రిమూవ్ సెట్టింగ్ ప్రకారం, బహుళ పావులను తీసివేయాలంటే, ప్రత్యర్థి దగ్గర చేతిలో పావులు లేకపోతే, బోర్డు నుండి ప్రత్యర్థి పావులను తొలగించడం కొనసాగించండి. అప్పుడు, ఇది మీరు కదిలే వంతు. మీరు మిల్లులను ఏర్పరచడం కొనసాగిస్తే, మీరు ప్రత్యర్థి పావులను తొలగించడం కొనసాగించవచ్చు.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'ప్రత్యర్థి చేతి నుండి పావు(లు) తొలగించండి. మల్టీ-రిమూవ్ సెట్టింగ్ ప్రకారం, బహుళ పావులను తీసివేయాలంటే మరియు ప్రత్యర్థికి చేతిలో పావులు లేకపోతే, బోర్డు నుండి ప్రత్యర్థి పావులను తీసివేయడం కొనసాగించండి. అప్పుడు, ప్రత్యర్థి కదిలే వంతు.';

  @override
  String get markAndDelayRemovingPieces =>
      'పావులను తొలగించడాన్ని గుర్తించండి మరియు ఆలస్యం చేయండి.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'ప్లేసింగ్ దశలో, తొలగించాల్సిన పావులను గుర్తించబడతాయి మరియు ఇద్దరు ఆటగాళ్ల కోసం, ఈ పాయింట్లలో కొత్త పావులను ఉంచలేరు. కదిలే దశలోకి ప్రవేశించిన తర్వాత, ఈ గుర్తించబడిన పావులు పూర్తిగా తీసివేయబడతాయి మరియు ఆటగాళ్ళు తమ పావులను ఈ ఖాళీ పాయింట్లకు తరలించవచ్చు.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'ప్లేసింగ్ దశలో ఆటగాళ్ళు మిల్లులను ఏర్పరిచినప్పుడు చేపట్టగల చర్యలు.';

  @override
  String get marked => 'గుర్తించబడింది';

  @override
  String get menu => 'మెనూ';

  @override
  String get monochrome => 'మోనోక్రోమ్';

  @override
  String get youCanEnableScreenReaderSupport =>
      'మీరు జనరల్ సెట్టింగ్స్‌లో యాక్సెసిబిలిటీ కాన్ఫిగరేషన్‌లో స్క్రీన్ రీడర్ సపోర్ట్ స్విచ్‌ను ఆన్ చేయవచ్చు.';

  @override
  String get showNumbersOnPieces => 'ముక్కలపై సంఖ్యలను చూపించు';

  @override
  String get saveImage => 'చిత్రాన్ని భద్రపరచండి';

  @override
  String get isAnalysisToolbarShown => 'విశ్లేషణ టూల్‌బార్ ప్రదర్శించు';

  @override
  String get analysisToolbarBackgroundColor =>
      'విశ్లేషణ టూల్‌బార్ నేపథ్యం రంగు';

  @override
  String get analysisToolbarIconColor => 'విశ్లేషణ టూల్‌బార్ చిహ్నం రంగు';

  @override
  String get transformed => 'పరివర్తితం.';

  @override
  String get cannotTransform => 'పరివర్తన చేయలేము.';

  @override
  String get rotate => 'పరిసరాలను తిరిగించు';

  @override
  String get horizontalFlip => 'H Flip';

  @override
  String get verticalFlip => 'V Flip';

  @override
  String get innerOuterFlip => 'IO Flip';

  @override
  String get transparentCanvas => 'పారదర్శక క్యాన్వాస్';

  @override
  String get restrictRepeatedMillsFormation =>
      'పునరావృత మిల్లుల ఏర్పాటును నిషేధించండి';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'ఒక గిరాటం నుండి మరొకటిని ఏర్పరచడానికి తరలించబడిన ముక్క తదుపరి వంతున వెంటనే అసలు పాయింట్ కు తిరిగి మరలా గిరాటం ఏర్పరచలేదు. ముందుగా వేరొక కదలిక అవసరం.';

  @override
  String get oneTimeUseMill => 'ఒకసారి ఉపయోగించే మిల్';

  @override
  String get oneTimeUseMill_Detail =>
      'ప్రతి మిల్ ఒక సారి మాత్రమే ప్రత్యర్థి ముక్కను తొలగిస్తుంది. మీరు దాన్ని మళ్ళీ రూపకల్పన చేయవచ్చు, కానీ అదనపు తొలగింపులకు ఉపయోగించబడదు.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'మీరు సెట్ చేసిన ప్రస్తుత నిబంధనలకు అనుగుణంగా ఖచ్చితమైన డేటాబేస్ లేదు. ఖచ్చితమైన డేటాబేస్ గురించి మరింత సమాచారం కోసం ఇక్కడ క్లిక్ చేయండి.';

  @override
  String get focusOnBlockingPaths => 'అడ్డంకుల మార్గాలపై దృష్టి పెట్టండి';

  @override
  String get focusOnBlockingPaths_Detail =>
      'మిల్లులు ఏర్పరచడం కంటే ప్రత్యర్థి యొక్క కదలికలను అడ్డుకోవడానికి ప్రాధాన్యత ఇవ్వండి. మిల్లులు పూర్తి చేయడం ద్వారా ముక్కలను తొలగించడం మీద దృష్టి పెట్టడం బదులు, AI ప్రత్యర్థిని ఉంచడానికి ప్రయత్నిస్తుంది, వారిని కదలకుండా చేసి, ఆగ్రహపు ఆటకు బదులుగా క్షీణత ద్వారా విజయం సాధించడానికి లక్ష్యం చేస్తుంది. ఈ వ్యూహం ప్రత్యర్థి యొక్క మిల్లులను చురుకుగా అడ్డుకోదు.';

  @override
  String get pieceImage => 'చదరంగపు ముక్క చిత్రం';

  @override
  String get importColorSettings => 'రంగు సెట్టింగ్‌లను దిగుమతి చేయండి';

  @override
  String get exportColorSettings => 'రంగు సెట్టింగ్‌లను ఎగుమతి చేయండి';

  @override
  String get import => 'దిగుమతి';

  @override
  String get export => 'ఎగుమతి';

  @override
  String get pleaseCopyJsonToClipboard =>
      'దయచేసి ముందుగా JSON ఫార్మాట్ సెట్టింగ్‌లను క్లిప్‌బోర్డ్‌కి కాపీ చేయండి.';

  @override
  String get copiedToClipboard => 'క్లిప్‌బోర్డ్‌కి కాపీ చేయబడింది.';

  @override
  String get imported => 'ఆయాతించబడింది.';

  @override
  String get boardImage => 'బోర్డ్ చిత్రం';

  @override
  String get autumnLeaves => 'శరదృతువు ఆకులు';

  @override
  String get legendaryLand => 'పౌరాణిక భూమి';

  @override
  String get vignetteEffect => 'వినియట్ ప్రభావం';

  @override
  String get promptMakeToolbarTransparent =>
      'బోర్డు నేపథ్య చిత్రాన్ని సెట్ చేసినప్పుడు టూల్‌బార్‌ను పూర్తిగా పారదర్శకంగా చేయాలనుకుంటున్నారా?';

  @override
  String get vibration => 'గేమ్‌లో వైబ్రేషన్‌ని ప్రారంభించండి';

  @override
  String get soundTheme => 'శబ్ద థీమ్';

  @override
  String get ball => 'బంతి';

  @override
  String get liquid => 'ద్రవం';

  @override
  String get wood => 'మొక్క';

  @override
  String get placeEffectAnimation => 'గేమ్ భాగాన్ని ఉంచే యానిమేషన్ ప్రభావం';

  @override
  String get removeEffectAnimation =>
      'గేమ్ భాగాన్ని తొలగించే యానిమేషన్ ప్రభావం';

  @override
  String get isToolbarAtBottom => 'క్రింద టూల్‌బార్ చూపించు';

  @override
  String get boardCornerRadius => 'బోర్డు మూల వ్యాసార్ధం';

  @override
  String get useOpeningBook => 'ఓపెనింగ్ బుక్ వాడండి';

  @override
  String get currentRule => 'ప్రస్తుత';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'నియమాల సెట్';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'ప్రారంభ ఆటలో వృత్తిపరమైన మానవ ఆటగాళ్లు సాధారణంగా ఉపయోగించే ఓపెనింగ్ మూవ్స్‌ను AI వాడనివ్వండి. గమనిక: ఈ ఫీచర్ ప్రస్తుతం కొన్ని నియమాల సెట్ల కోసం మాత్రమే అందుబాటులో ఉంది.';

  @override
  String get showAdvantageGraph => 'ఆధిక్యత గ్రాఫ్‌ను చూపించు';

  @override
  String get advantageGraphHint =>
      'AI పోన్ చేసిన తర్వాత మాత్రమే ప్రయోజన గ్రాఫ్ వేయబడుతుంది. మానవ ఆటగాడు పోన్ చేసినప్పుడు ఇది వేయబడదు.';

  @override
  String get removalBasedOnMillCounts =>
      'అన్నీ ఏర్పాటు అయ్యే వరకు తీసివేతను నిలిపివుంచండి. ఆటగాళ్లు మిల్ ల సంఖ్య ఆధారంగా ముక్కలను తీసివేస్తారు.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'అన్నీ ఏర్పాటు అయ్యే వరకు తీసివేతను నిలిపివుంచండి. ఆటగాళ్లు మిల్ ల సంఖ్య ఆధారంగా ముక్కలను తీసివేస్తారు: సమానంగా ఉంటే, ఇద్దరూ ఒకే సంఖ్యలో ముక్కలను తీసివేస్తారు; ఒకరి దగ్గర ఎక్కువ ఉంటే, అతను ఒక అదనపు ముక్కను తీసివేసి ఒక్క ముక్క తేడాను కొనసాగిస్తాడు. ఒక ఆటగాడు మాత్రమే మిల్ ను రూపొందిస్తే, అతను రెండు ముక్కలను తీసివేస్తాడు, మరోవాడు ఒక ముక్కను తీసివేస్తాడు. ఇద్దరూ మిల్ ను రూపొందించలేకపోతే, ఇద్దరూ ఒక్క ముక్కను తీసివేస్తారు.';

  @override
  String get elfilja => 'ఎల్ ఫిల్జా';

  @override
  String get tipSelectOwnPiece => 'నీ వర్గాల్లో ఒకటిని ఎంచుకో.';

  @override
  String get notYourTurn => 'మీ సారి కాదు.';

  @override
  String get annotationToolbarBackgroundColor =>
      'వ్యాఖ్యాన టూల్‌బార్ నేపథ్య రంగు';

  @override
  String get annotationToolbarIconColor => 'వ్యాఖ్యాన టూల్‌బార్ చిహ్నం రంగు';

  @override
  String get isAnnotationToolbarShown => 'వ్యాఖ్యాన టూల్‌బార్ చూపించు';

  @override
  String get enterAnnotationMode => 'వ్యాఖ్యాన మోడ్‌లో ప్రవేశించండి';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'మీరు అన్ని వ్యాఖ్యానాలను తొలగించాలని ఖచ్చితంగా అనుకుంటున్నారా?';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM ప్రాంప్ట్ క్లిప్‌బోర్డ్‌కు కాపీ చేయబడింది.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'కనెక్షన్ నిరాకరించబడింది, సర్వర్ డౌన్‌లో ఉండవచ్చు.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'అన్వేషణ విజయవంతం, కనెక్షన్ కోసం ఎదురు చూస్తోంది...';

  @override
  String get noLanConnection => 'LAN కనెక్షన్ లేదు';

  @override
  String get takeScreenshot => 'స్క్రీన్‌షాట్ తీసుకోండి';

  @override
  String get disconnectedFromOpponent =>
      'ప్రతిస్పర్థి నుండి డిస్‌కనెక్ట్ అయింది.';

  @override
  String get takeBackRequest => 'చలనం రద్దు అభ్యర్థన';

  @override
  String get nothingToShow => 'చూపించడానికి ఏమీ లేదు.';

  @override
  String get stopHosting => 'హోస్టింగ్ ఆపండి';

  @override
  String get connectionResetByPeer => 'కనెక్షన్ పియర్ ద్వారా రీసెట్ చేయబడింది.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'హార్ట్‌బీట్ టైమౌట్ కారణంగా కనెక్షన్ కోల్పోయింది. దయచేసి మళ్లీ కనెక్ట్ అవ్వండి.';

  @override
  String get startHosting => 'హోస్టింగ్ ప్రారంభించండి';

  @override
  String get restartRequestRejected => 'రీస్టార్ట్ అభ్యర్థన నిరాకరించబడింది.';

  @override
  String get notConnectedToLanOpponent => 'LAN ప్రత్యర్థితో కనెక్ట్ కాలేదు.';

  @override
  String get llmPrompt => 'LLM ప్రాంప్ట్';

  @override
  String get gameRestarted => 'గేమ్ మళ్లీ ప్రారంభించబడింది.';

  @override
  String get takeBackRejected => 'చలనం రద్దు నిరాకరించబడింది.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'మీరు ఈ గేమ్ నుండి రాజీనామా చేయాలని నిజంగా అనుకుంటున్నారా?';

  @override
  String get opponentResignedYouWin =>
      'ప్రతిస్పర్థి రాజీనామా చేసాడు. మీరు గెలిచారు!';

  @override
  String get clearAllAnnotations => 'అన్ని వ్యాఖ్యానాలను తొలగించండి';

  @override
  String get connectedWaitingForOpponentSMove =>
      'కనెక్ట్ అయింది, ప్రత్యర్థి యొక్క చలనం కోసం ఎదురు చూస్తోంది...';

  @override
  String get networkStatusDisconnected => 'నెట్‌వర్క్ స్థితి: కనెక్ట్ కాలేదు.';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'ప్రతిస్పర్థికి చలనం రద్దు అభ్యర్థన పంపబడింది.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'ప్రతిస్పర్థి గేమ్ నుండి బయలుదేరి ఉండవచ్చు.';

  @override
  String get connectedToHostSuccessfully =>
      'హోస్ట్‌తో విజయవంతంగా కనెక్ట్ అయింది.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'కనెక్షన్ కోల్పోయింది: హార్ట్‌బీట్ టైమౌట్';

  @override
  String get noHostDiscovered => 'ఎలాంటి హోస్ట్ కనుగొనబడలేదు.';

  @override
  String get confirmResignation => 'రాజీనామాను నిర్ధారించండి';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'గేమ్ హోస్ట్ చేయడం ప్రారంభించబడింది, ఆటగాళ్లు చేరుకోవడం కోసం ఎదురు చూస్తోంది...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'కనెక్షన్ టైమౌట్ అయింది, నెట్‌వర్క్ స్థిరంగా లేదు.';

  @override
  String get noLlmPromptAvailable => 'LLM ప్రాంప్ట్ అందుబాటులో లేదు.';

  @override
  String get youResignedGameOver => 'మీరు రాజీనామా చేసారు. గేమ్ ముగిసింది.';

  @override
  String get serverIp => 'సర్వర్ IP';

  @override
  String get confirmClear => 'తొలగింపును నిర్ధారించండి';

  @override
  String get opponentSTurn => 'ప్రతిస్పర్థి సారి.';

  @override
  String get waitingAClientConnection =>
      'క్లయింట్ కనెక్షన్ కోసం ఎదురు చూస్తోంది...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'చలనం రద్దు అభ్యర్థన నిరాకరించబడింది లేదా విఫలమైంది.';

  @override
  String get addText => 'టెక్స్ట్ జోడించండి';

  @override
  String get exitAnnotationMode => 'వ్యాఖ్యాన మోడ్ నుండి బయటకు రండి';

  @override
  String get typeYourAnnotation => 'మీ వ్యాఖ్యానాన్ని టైప్ చేయండి';

  @override
  String get attemptingToReconnect =>
      'మళ్లీ కనెక్ట్ అవ్వడానికి ప్రయత్నిస్తోంది...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'రీస్టార్ట్ అభ్యర్థన పంపబడింది. ప్రత్యర్థి యొక్క ప్రతిస్పందన కోసం ఎదురు చూస్తోంది...';

  @override
  String get serverIsStopped => 'సర్వర్ ఆపబడింది.';

  @override
  String get restartRequest => 'రీస్టార్ట్ అభ్యర్థన';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'మీ సారి కానప్పుడు చలనం రద్దు అభ్యర్థన చేయలేరు.';

  @override
  String get takeBackAccepted => 'చలనం రద్దు ఆమోదించబడింది.';

  @override
  String get localNetworkSettings => 'స్థానిక నెట్‌వర్క్ సెట్టింగ్స్';

  @override
  String get reconnectedSuccessfully => 'విజయవంతంగా మళ్లీ కనెక్ట్ అయ్యారు!';

  @override
  String get failedToSaveImageToGallery =>
      'గ్యాలరీకి చిత్రం సేవ్ చేయడంలో విఫలమైంది.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'ప్రతిస్పర్థి గేమ్ మళ్లీ ప్రారంభించాలనే అభ్యర్థన చేశాడు. మీరు అంగీకరిస్తారా?';

  @override
  String get yourTurn => 'మీ సారి.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'మళ్లీ కనెక్ట్ కావడం సాధ్యపడలేదు, దయచేసి గేమ్‌ను మళ్లీ ప్రారంభించండి.';

  @override
  String get host => 'హోస్ట్';

  @override
  String get join => 'చేరండి';

  @override
  String get port => 'పోర్ట్';

  @override
  String get invalidIpAddress => 'చెల్లని IP చిరునామా.';

  @override
  String get invalidPort => 'చెల్లని పోర్ట్.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'కనెక్ట్ అవుతున్నది: ప్రయత్నం $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'కనెక్ట్ అవడంలో విఫలమైంది: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'హోస్టింగ్ ప్రారంభించడంలో విఫలమైంది: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'హోస్ట్ కనుగొనబడింది: $ip:$port';
  }

  @override
  String get stop => 'ఆపు';

  @override
  String get discover => 'కనుగొనండి';

  @override
  String get connect => 'కనెక్ట్ అవ్వండి';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'క్లయింట్ కనెక్ట్ అయింది: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'కనుగొనడం: $seconds సెకన్లు';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'మళ్లీ కనెక్ట్ అవుతోంది ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'కనెక్ట్ అయింది.';

  @override
  String get delete => 'తొలగించండి';

  @override
  String get ancientEgypt => 'పురాతన ఈజిప్ట్';

  @override
  String get gothicIce => 'గోతిక్ ఐస్';

  @override
  String get riceField => 'వరి పొలం';

  @override
  String get chinesePorcelain => 'చైనీస్ పోర్సెలిన్';

  @override
  String get desertDusk => 'ఎడారి సంధ్య';

  @override
  String get precisionCraft => 'నిఖార్సైన హస్తకళ';

  @override
  String get folkEmbroidery => 'సాంప్రదాయ ఎంబ్రాయిడరీ';

  @override
  String get carpathianHeritage => 'కార్పాతియన్ వారసత్వం';

  @override
  String get imperialGrandeur => 'సామ్రాజ్య వైభవం';

  @override
  String get bohemianCrystal => 'బోహీమియన్ క్రిస్టల్';

  @override
  String get savannaSunrise => 'సవన్నా సూర్యోదయం';

  @override
  String get harmonyBalance => 'సామరస్య సమతుల్యత';

  @override
  String get cinnamonSpice => 'దాల్చిన చెక్క మసాలా';

  @override
  String get anatolianMosaic => 'అనాటోలియన్ మొజాయిక్';

  @override
  String get carnivalSpirit => 'కార్నివల్ స్ఫూర్తి';

  @override
  String get custom => 'ఆచారం';

  @override
  String get spiceMarket => 'మసాలా మార్కెట్';

  @override
  String get swipeToRevealTheDrawer => 'డ్రాయర్ చూపించడానికి స్వైప్ చేయండి';

  @override
  String get showGameInfoOnScreenshots =>
      'స్క్రీన్‌షాట్‌లలో గేమ్ సమాచారం చూపించు';

  @override
  String get humanMoveTime => 'మానవ సమయ పరిమితి';

  @override
  String get noTimeLimitForHumanMoves => 'మానవ కదలికలకు సమయ పరిమితి లేదు';

  @override
  String get timeoutLoseWillBeApplied =>
      'మానవ ఆటగాడికి సమయం ముగిసిపోతే ఓటమి వర్తిస్తుంది';

  @override
  String get identifyingBoard => 'బోర్డును గుర్తిస్తోంది...';

  @override
  String get youCanEnterAnyModelName =>
      'మీరు ఏదైనా మోడల్ పేరును నమోదు చేయవచ్చు.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'బోర్డు స్థానం వర్తించబడింది. FEN క్లిప్‌బోర్డ్‌కు కాపీ చేయబడింది.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'సూచన: బోర్డు యొక్క స్పష్టమైన చిత్రం తీసుకోవడానికి ప్రయత్నించండి.';

  @override
  String get llmPromptTemplate => 'LLM ప్రాంప్ట్ నమూనా';

  @override
  String get noValidBoardDetected => 'చెల్లుబాటు అయ్యే బోర్డు కనుగొనబడలేదు.';

  @override
  String get selectingImageFromAlbum => 'అల్బమ్ నుండి చిత్రం ఎంచుకుంటోంది...';

  @override
  String get configurePromptTemplate => 'ప్రాంప్ట్ నమూనాను సెట్ చేయండి';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'LLM విశ్లేషణ కోసం ప్రాంప్ట్ నమూనాను సవరించండి';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'గుర్తించిన బోర్డు నుంచి FEN సృష్టించడంలో విఫలం.';

  @override
  String get outputInCurrentLanguage => 'ప్రస్తుత భాషలో అవుట్పుట్';

  @override
  String get commonBaseUrls => 'సాధారణ Base URLలు';

  @override
  String get viewCommonModels => 'సాధారణ మోడళ్లను చూడండి';

  @override
  String get recognitionParametersUpdated =>
      'గుర్తింపు పరామితులు నవీకరించబడ్డాయి.';

  @override
  String get whiteSMove => 'తెల్లవారి బారి';

  @override
  String get resetToDefaults => 'డిఫాల్ట్‌లను పునఃస్థాపించండి';

  @override
  String get photoShoot => 'ఫోటో షూట్';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'గుర్తించిన బోర్డు స్థానాన్ని వర్తింపజేయడంలో విఫలం.';

  @override
  String get llmPromptContent => 'LLM ప్రాంప్ట్ విషయము';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM కాన్ఫిగర్ చేయబడలేదు. దయచేసి మీ సెట్టింగులను తనిఖీ చేయండి.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'ప్రొవైడర్, మోడల్, API Key, మరియు Base URL సెట్ చేయండి.';

  @override
  String get llmConfiguration => 'LLM కాన్ఫిగరేషన్';

  @override
  String get configureLlmProvider => 'LLM provider ను కాన్ఫిగర్ చేయండి';

  @override
  String get llmPromptTemplateHeader => 'LLM ప్రాంప్ట్ టెంప్లేట్ శీర్షిక';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'చిత్రంలో ఏ భాగాలు గుర్తించబడలేదు. దయచేసి మళ్లీ ప్రయత్నించండి.';

  @override
  String get recognizeBoardFromImage => 'చిత్రం నుండి బోర్డును గుర్తించండి';

  @override
  String get viewTips => 'సలహాలు చూడండి';

  @override
  String get applyToBoard => 'బోర్డు పై వర్తించండి';

  @override
  String get adjustBoardArea => 'బోర్డు ప్రాంతాన్ని సర్దుబాటు చేయండి';

  @override
  String get viewCommonUrls => 'సాధారణ URLలు చూడండి';

  @override
  String get colorAnalysisFailed => 'రంగుల విశ్లేషణ విఫలమైంది!';

  @override
  String get analyzingGameBoardImage =>
      'ఆట బోర్డు చిత్రాన్ని విశ్లేషిస్తోంది...';

  @override
  String get selectFromAlbum => 'అల్బమ్ నుంచి ఎంచుకోండి';

  @override
  String get noBoardPointDetected => 'బోర్డు బిందువు కనుగొనబడలేదు!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'ఖాళీగా వదిలివేస్తే, డిఫాల్ట్ నమూనా ఉపయోగించబడుతుంది';

  @override
  String get llmConfig => 'LLM కాన్ఫిగరేషన్';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'మీరు నిజంగా ప్రాంప్ట్ నమూనాలను డిఫాల్ట్ విలువలకు రీసెట్ చేయాలనుకుంటున్నారా?';

  @override
  String get llmPromptTemplateFooter => 'LLM ప్రాంప్ట్ టెంప్లేట్ ఫుటర్';

  @override
  String get loadingResponse => 'సమాధానం లోడ్ అవుతోంది...';

  @override
  String get applyThisResultToBoard => 'ఈ ఫలితాన్ని బోర్డుకు వర్తించండి';

  @override
  String get takingPicture => 'చిత్రం తీసుకుంటోంది...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'దయచేసి గుర్తించడానికి ఆట బోర్డు చిత్రాన్ని ఎంచుకోండి';

  @override
  String get identificationResults => 'గుర్తింపు ఫలితాలు';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'చలనాలను విశ్లేషించి, అవగాహన అందించండి.';

  @override
  String get getApiKey => 'API Key పొందండి';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'మొత్తం గుర్తింపు ప్రక్రియ పూర్తి కాలేదు.';

  @override
  String get boardRecognitionResult => 'బోర్డు గుర్తింపు ఫలితం';

  @override
  String get askLlm => 'LLMను అడగండి';

  @override
  String get boardDetectionFailed => 'బోర్డు గుర్తింపు విఫలమైంది!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'బోర్డు బిందువు కనుగొనబడలేదు, కాబట్టి ముక్కను గుర్తించలేము!';

  @override
  String get copyFen => 'FENను కాపీ చేయండి';

  @override
  String get commonlyUsedModels => 'సాధారణంగా ఉపయోగించే మోడళ్లు';

  @override
  String get apiKeyOptional => 'API Key (ఐచ్చిక)';

  @override
  String get noImageSelected => 'ఏ చిత్రం ఎంచుకోబడలేదు';

  @override
  String get blackSMove => 'నలుపువారి బారి';

  @override
  String get llm => 'పెద్ద భాషా మోడల్';

  @override
  String get llmProvider => 'సరఫరాదారు';

  @override
  String get baseUrl => 'బేస్ URL';

  @override
  String get model => 'మోడల్';

  @override
  String get temperature => 'ఉష్ణోగ్రత';

  @override
  String get llmCommandReceivedProcessing =>
      'ఆదేశం స్వీకరించబడింది! AI ప్రాసెస్ అవుతోంది...';

  @override
  String get llmDeepThinkingWait =>
      'లోతైన ఆలోచన జరుగుతోంది, దయచేసి వేచి ఉండండి...';

  @override
  String get llmPresentingSoon => 'త్వరిగా ప్రదర్శించబడుతుంది...';

  @override
  String get recognitionParameters => 'గుర్తింపు పరామితులు';

  @override
  String get adjustParamsDesc =>
      'గుర్తింపు ఖచ్చితత్వాన్ని మెరుగుపర్చేందుకు పరామితులను సర్దుబాటు చేయండి';

  @override
  String get saveParameters => 'పరామితులను సేవ్ చేయండి';

  @override
  String unableToStartImageRecognition(String error) {
    return 'చిత్ర గుర్తింపును ప్రారంభించలేకపోయాం: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'చిత్ర గుర్తింపు విఫలమైంది: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return '$whiteCount తెల్ల మరియు $blackCount నలుపు ముక్కలతో దరఖాస్తు చేసిన స్థానం';
  }

  @override
  String get fenCopiedToClipboard => '(FEN క్లిప్‌బోర్డుకు కాపీ చేయబడింది)';

  @override
  String recognitionFailed(String error) {
    return 'గుర్తింపు విఫలమైంది: $error';
  }

  @override
  String get myRating => 'నా రేటింగ్';

  @override
  String get gamesPlayed => 'ఆడిన ఆటలు';

  @override
  String get wins => 'గెలుపులు';

  @override
  String get losses => 'ఓటములు';

  @override
  String get draws => 'డ్రాలు';

  @override
  String get lastUpdated => 'చివరిగా నవీకరించబడింది';

  @override
  String get format => 'ఫార్మాట్:';

  @override
  String get resetStatistics => 'గణాంకాలను రీసెట్ చేయండి';

  @override
  String get drawRate => 'డ్రా రేటు';

  @override
  String get lossRate => 'ఓటమి రేటు';

  @override
  String get aiStatistics => 'AI గణాంకాలు';

  @override
  String get enableStatistics => 'గణాంకాలను ప్రారంభించండి';

  @override
  String get enableStatistics_Detail =>
      'ప్రారంభించినప్పుడు, ఆట ఫలితాలు గణాంకాలలో రికార్డ్ చేయబడతాయి. అయితే, టేక్-బ్యాక్‌లను కలిగి ఉన్న ఆటలు రికార్డ్ చేయబడవు. నిలిపివేసినప్పుడు, గణాంకాల సేకరణ పాజ్ చేయబడుతుంది.';

  @override
  String get thisWillResetAllGameStatistics =>
      'ఇది అన్ని ఆట గణాంకాలను రీసెట్ చేస్తుంది. ఈ చర్యను రద్దు చేయడం సాధ్యం కాదు.';

  @override
  String get boardInnerRingSize => 'బోర్డు లోపలి రింగ్ పరిమాణం';

  @override
  String get boardShadowEnabled => 'బోర్డు నీడ';

  @override
  String get trapAwareness => 'ఉచ్చు గుర్తింపు';

  @override
  String get trapAwarenessDescription =>
      'విశ్లేషణ సమయంలో మందమైన వృత్తాలు మరియు బాణాలతో ఉచ్చు కదలికలను హైలైట్ చేయండి.';

  @override
  String trapExists(String trapMoves) {
    return 'ఉచ్చు ఉంది. ఉచ్చు కదలికలు: $trapMoves';
  }

  @override
  String get custodianCapture => 'లాంకింగ్ క్యాప్చర్';

  @override
  String get custodianCaptureDescription =>
      'మీ ప్రత్యర్థి ముక్కలలో ఒకదాన్ని మీ రెండింటి మధ్య సరళ రేఖలో పట్టుకోవటానికి ఒకదాన్ని నొక్కిచెప్పండి.';

  @override
  String get custodianCaptureEnable => 'పార్శ్వ సంగ్రహాన్ని అనుమతించండి';

  @override
  String get interventionCapture => 'ఇంటర్వెన్షన్ క్యాప్చర్';

  @override
  String get interventionCaptureDescription =>
      'మీ ప్రత్యర్థి రెండు ముక్కల మధ్య ఖాళీ బిందువులోకి వెళ్లండి.';

  @override
  String get interventionCaptureEnable => 'జోక్యం సంగ్రహాన్ని అనుమతించండి';

  @override
  String get leapCapture => 'జంప్ క్యాప్చర్';

  @override
  String get leapCaptureDescription =>
      'ప్రక్కనే ఉన్న ప్రత్యర్థి ముక్కను మించిన ఖాళీ బిందువులోకి దూకడం ద్వారా పట్టుకోండి.';

  @override
  String get leapCaptureEnable => 'జంప్ క్యాప్చర్ అనుమతించండి';

  @override
  String get captureApplicableLines => 'వర్తించే పంక్తులు';

  @override
  String get captureSquareEdges => 'చదరపు అంచుల వెంట';

  @override
  String get captureCrossLines => 'చదరపు దాటి ఆర్తోగోనల్ మార్గాల్లో';

  @override
  String get captureDiagonalLines => 'వికర్ణ రేఖల వెంట చదరపు దాటుతుంది';

  @override
  String get captureExecutionPhases => 'అమలు దశలు';

  @override
  String get capturePiecesCondition =>
      'మిగిలిన ముక్కల ఆధారంగా కదిలే దశలో లభ్యత';

  @override
  String get capturePiecesConditionUnlimited => 'పరిమితి లేదు';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'మీకు మూడు లేదా అంతకంటే తక్కువ ముక్కలు ఉన్నప్పుడు లభిస్తుంది';
}
