// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Tamil (`ta`).
class STa extends S {
  STa([String locale = 'ta']) : super(locale);

  @override
  String get appName => 'மில்';

  @override
  String get welcome => 'நல்வரவு';

  @override
  String get yes => 'ஆம்';

  @override
  String get no => 'இல்லை';

  @override
  String get game => 'விளையாட்டு';

  @override
  String get humanVsAi => 'மனிதன் எதிர் செஅ';

  @override
  String get humanVsHuman => 'மனிதன் எதிர் மனிதன்';

  @override
  String get aiVsAi => 'செஅ எதிர் செஅ';

  @override
  String get humanVsCloud => 'மனித எதிர் முகில்';

  @override
  String get humanVsLAN => 'மனித எதிர் லேன்';

  @override
  String get testViaLAN => 'லேன் வழியாக சோதனை';

  @override
  String get move => 'நகர்த்து';

  @override
  String get showMoveList => 'பட்டியலை நகர்த்து';

  @override
  String get moveList => 'பட்டியலை நகர்த்து';

  @override
  String get noGameRecord => 'பதிவு இல்லை';

  @override
  String get ok => 'சரி';

  @override
  String get confirm => 'உறுதிப்படுத்து';

  @override
  String get cancel => 'ரத்துசெய்';

  @override
  String get tipSelectWrong => 'தவறான துண்டை தேர்ந்தெடு.';

  @override
  String get tipPlace => 'உங்கள் துண்டுகளை வை.';

  @override
  String get tipBanPlace => 'நீங்கள் அதை இங்கே வைக்க முடியாது.';

  @override
  String get tipPlaced => 'துண்டு வைக்கப்பட்டது.';

  @override
  String get tipRemove => 'ஒரு துண்டு அகற்று.';

  @override
  String get tipBanRemove => 'நீங்கள் அதை அகற்ற முடியாது.';

  @override
  String get tipRemoved => 'துண்டு அகற்றப்பட்டது.';

  @override
  String get tipMove => 'ஒரு துண்டு நகர்த்து.';

  @override
  String get tipCannotPlace => 'உங்கள் பகுதியை இங்கே வைக்க முடியாது.';

  @override
  String get tipCannotMove => 'உங்கள் பகுதியை இங்கே நகர்த்த முடியாது.';

  @override
  String get tipMill => 'மில்! உங்கள் எதிரியின் பகுதியை எடுத்துக் கொள்.';

  @override
  String get tipContinueMill =>
      'உங்கள் எதிரியின் பகுதியை தொடர்ந்து எடுத்துக் கொள்.';

  @override
  String get tipSelectOpponentsPiece =>
      'உங்கள் எதிரியின் துண்டுகளில் ஒன்றைத் தேர்ந்தெடு.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'நீங்கள் ஒரு மில்லிலிருந்து ஒரு பகுதியை அகற்ற முடியாது.';

  @override
  String get tipCanMoveOnePoint => 'ஒரு துண்டு 1 புள்ளியை நகர்த்த முடியும்.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'உங்கள் எதிரியின் துண்டுகளை நகர்த்த முடியாது.';

  @override
  String get tipSelectPieceToMove => 'நகர்த்த உங்கள் பகுதியைத் தேர்ந்தெடு.';

  @override
  String get tipHaveThreePiecesLeft => 'உங்களிடம் மூன்று துண்டுகள் உள்ளன.';

  @override
  String get tipCanMoveToAnyPoint =>
      'நீங்கள் விரும்பும் எந்த இடத்திற்கும் செல்லலாம்.';

  @override
  String tipToMove(Object player) {
    return '$player நகர்த்த.';
  }

  @override
  String get whiteWin => 'வீரன் 1 வெற்றி!';

  @override
  String get blackWin => 'வீரன் 2 வெற்றி!';

  @override
  String get won => 'வெற்றிபெற்றது';

  @override
  String get lost => 'இழந்தது';

  @override
  String get thinking => 'சிந்தனை…';

  @override
  String get newGame => 'புதிய விளையாட்டு';

  @override
  String get importGame => 'விளையாட்டு இறக்குமதி';

  @override
  String get exportGame => 'விளையாட்டு ஏற்றுமதி';

  @override
  String get gameImported => 'இறக்குமதி செய்யப்பட்ட விளையாட்டு.';

  @override
  String cannotImport(Object invalidMove) {
    return '$invalidMoveஐ இறக்குமதி செய்யமுடியாது';
  }

  @override
  String get movesAndRulesNotMatch =>
      'நகர்வுகள் மற்றும் விதிகள் பொருந்தவில்லை.';

  @override
  String get pleaseWait => 'தயவுசெய்து காத்திருங்கள்.';

  @override
  String get restartGame => 'தற்போதைய விளையாட்டை மறுதொடக்கம் செய்யவா?';

  @override
  String get restart => 'மறுதொடக்கம்';

  @override
  String get gameStarted => 'விளையாட்டு தொடங்கியது, தயவுசெய்து வை.';

  @override
  String get analyzing => 'பகுப்பாய்வு…';

  @override
  String error(Object message) {
    return 'பிழை: $message';
  }

  @override
  String get winRate => 'வெற்றி விகிதம்';

  @override
  String get score => 'மதிப்பு:';

  @override
  String get white => 'வீரன் 1';

  @override
  String get black => 'வீரன் 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player துண்டு எண்ணிக்கை மூன்றுக்கும் குறைவானது.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player விலகினார்.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player செல்ல வழி இல்லை.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'பலகை நிரம்பியுள்ளது, மற்றும் $player க்கு செல்ல வழி இல்லை.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'நேரம் முடிந்துவிட்டது, $player இழந்தார்.';
  }

  @override
  String get drawReasonRule50 =>
      'நகரும் கட்டத்தில், கடைசி குறிப்பிட்ட எண்ணிக்கையிலான நகர்வுகளில் எந்த பகுதியும் அகற்றப்படவில்லை.';

  @override
  String get drawReasonBoardIsFull => 'பலகை நிரம்பியிருப்பதால் இது ஒரு சமநிலை.';

  @override
  String get drawReasonThreefoldRepetition =>
      'மூன்று மடங்கு மறுபடியும் நிகழ்வதால் இது ஒரு சமநிலை.';

  @override
  String get gameOverUnknownReason => 'விளையாட்டு முடிந்தது! தெரியாத காரணம்.';

  @override
  String get gameOver => 'விளையாட்டு முடிந்தது';

  @override
  String get youWin => 'நீங்கள் வென்றீர்கள்! வாழ்த்துக்கள்!';

  @override
  String challengeHarderLevel(int level) {
    return 'கடினமான நிலையை அறைகூவல் செய்யவா? புதிய நிலை $level நிலையாக இருக்கும்!';
  }

  @override
  String get youLose => 'நீங்கள் இழக்கிறீர்கள்!';

  @override
  String get analyze => 'பகுப்பாய்வு செய்';

  @override
  String get about => 'பற்றி';

  @override
  String version(Object versionNumber) {
    return 'பதிப்பு: $versionNumber';
  }

  @override
  String get thanks => 'நன்றி';

  @override
  String get settings => 'அமைப்புகள்';

  @override
  String get options => 'விருப்பங்கள்';

  @override
  String get generalSettings => 'பொது அமைப்புகள்';

  @override
  String get skillLevel => 'தொல்லை நிலை';

  @override
  String get moveTime => 'செஅ சிந்தனை நேரம்';

  @override
  String get difficulty => 'தொல்லை';

  @override
  String get playSounds => 'ஒலி விளைவுகள்';

  @override
  String get playSoundsInTheGame => 'விளையாட்டில் ஒலிகள்';

  @override
  String get keepMuteWhenTakingBack =>
      'திரும்பப் பெறும்போது ஊமையாக வைத்திருங்கள்';

  @override
  String get tone => 'தொனி';

  @override
  String get whoMovesFirst => 'முதல் நகர்வு';

  @override
  String get human => 'மனிதன்';

  @override
  String get ai => 'செஅ';

  @override
  String get alternate => 'மாற்று';

  @override
  String get isAutoRestart =>
      'விளையாட்டு முடிந்ததும் தானி-மறுதொடக்கம் விளையாட்டு';

  @override
  String get isAutoChangeFirstMove => 'தானி மாற்றம் முதல் நகர்வு';

  @override
  String get shufflingEnabled => 'தோராயமாக நகர்த்து';

  @override
  String get misc => 'மற்றவை';

  @override
  String get rules => 'விதிகள்';

  @override
  String get piecesCount =>
      'ஒவ்வொரு வீரருக்கும் இருக்கும் துண்டுகளின் எண்ணிக்கை';

  @override
  String get piecesCount_Detail =>
      'ஒவ்வொரு வீரருக்கும் எத்தனை துண்டுகள் உள்ளன?';

  @override
  String get flyPieceCount => 'பறக்கும் துண்டின் எண்ணிக்கை';

  @override
  String get flyPieceCount_Detail =>
      'பறப்பது இயக்கப்பட்டிருந்தால், ஒரு வீரரின் துண்டு எண்ணிக்கை ஒரு குறிப்பிட்ட வாசலுக்குக் கீழே விழும்போது, அவற்றின் துண்டுகள் எந்த விளையாட்டைப் போலவே அருகில் உள்ள புள்ளிகளுக்கும் கட்டுப்படுத்தப்படுவதற்குப் பதிலாக எந்தவொரு காலாவதியான இடத்திற்கும் செல்ல இலவசம்.';

  @override
  String get piecesAtLeastCount => 'குறைந்தபட்சம் துண்டுகள்';

  @override
  String get hasDiagonalLines => 'மூலைவிட்ட கோடுகள்';

  @override
  String get hasDiagonalLines_Detail =>
      'பலகையில் நான்கு மூலைவிட்ட கோடுகளைச் சேர்.';

  @override
  String get isDefenderMoveFirst => 'இரண்டாவது வீரர் முதலில் நகர்கிறார்';

  @override
  String get isDefenderMoveFirst_Detail =>
      'இடும் கட்டத்தில் இரண்டாவது இடத்தைப் பிடித்த வீரர் நகரும் கட்டத்தில் முதலில் நகர்கிறார்.';

  @override
  String get mayRemoveMultiple => 'பல-நீக்கு';

  @override
  String get mayRemoveMultiple_Detail =>
      'ஒரு வீரர் ஒரே நேரத்தில் ஒரு ஆலைக்கு மேல் மூடினால், அவள் மூடிய ஆலைகளின் எண்ணிக்கையை அகற்றுவாள்.';

  @override
  String get mayRemoveFromMillsAlways => 'ஆலைகளை அழிக்கவும்';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'இயல்பாக, உருவாக்கப்பட்ட ஆலையிலிருந்து ஒரு பகுதியை அகற்றுவதற்கு முன் வீரர்கள் வேறு எந்த துண்டுகளையும் முதலில் அகற்ற வேண்டும். வரம்பை முடக்க இந்த விருப்பத்தை இயக்கவும்.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'பலகை நிரம்பும்போது இரண்டாவது வீரர் இழக்கிறார்';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'வைக்கும் கட்டத்தின் முடிவில் பலகை நிரம்பியிருக்கும் போது, முதலில் இடும் பக்கம் விளையாட்டை இழக்கிறது. இல்லையெனில், விளையாட்டு ஒரு சமநிலை.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'சட்டப்பூர்வ நகர்வுகள் இல்லாதபோது இழக்கவும்';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'தனது எதிர்ப்பாளர் அவர்களைத் தடுத்தால் வீரர் இழப்பார், அதனால் அவற்றை நகர்த்த முடியாது. இந்த விருப்பம் முடக்கப்பட்டிருந்தால், இழப்பை அறிவிப்பதற்குப் பதிலாக நகர்த்த பக்கத்தை மாற்றவும்.';

  @override
  String get mayFly => 'பறக்கும்';

  @override
  String get mayFly_Detail =>
      'ஒரு வீரருக்கு மூன்று அல்லது நான்கு (உள்ளமைக்கக்கூடிய) துண்டுகள் மட்டுமே எஞ்சியிருந்தால், அவள் எந்த இலவச புள்ளிக்கும் அந்த துண்டுகளை நகர்த்த முடியும்.';

  @override
  String get nMoveRule => 'N- நகரும் விதி';

  @override
  String get nMoveRule_Detail =>
      'ஒரு குறிப்பிட்ட எண்ணிக்கையிலான நகர்வுகளில் அகற்றப்படாவிட்டால் விளையாட்டு வரையப்படுகிறது.';

  @override
  String get rollback => 'மறுசீரமைப்பு';

  @override
  String get pleaseSelect => 'தயவுசெய்து தேர்ந்தெடு';

  @override
  String get copy => 'நகலெடு';

  @override
  String get moveHistoryCopied =>
      'இடைநிலைப்பலகைக்கு நகலெடுக்கப்பட்ட வரலாற்றை நகர்த்தவும்.';

  @override
  String get help => 'உதவி';

  @override
  String get feedback => 'கருத்து';

  @override
  String get exit => 'வெளியேறு';

  @override
  String get ruleSettings => 'விதி அமைப்புகள்';

  @override
  String get color => 'நிறம்';

  @override
  String get boardColor => 'போர்டு நிறம்';

  @override
  String get pieceColor => 'துண்டு நிறம்';

  @override
  String get backgroundColor => 'பின்னணி நிறம்';

  @override
  String get lineColor => 'Board வரி color';

  @override
  String get whitePieceColor => 'வீரன் 1 துண்டு வண்ணம்';

  @override
  String get blackPieceColor => 'வீரன் 2 துண்டு நிறம்';

  @override
  String get messageColor => 'செய்தி நிறம்';

  @override
  String get isPieceCountInHandShown =>
      'இடமில்லாத துண்டுகளின் எண்ணிக்கையைக் காட்டு';

  @override
  String get isNotationsShown => 'போர்டில் குறிப்புகளைக் காட்டுங்கள்';

  @override
  String get isHistoryNavigationToolbarShown =>
      'வரலாற்று வழிசெலுத்தல் கருவிப்பட்டியைக் காட்டு';

  @override
  String get display => 'காட்சி';

  @override
  String get boardBorderLineWidth => 'போர்டு பார்டர்லைன் அகலம்';

  @override
  String get boardInnerLineWidth => 'போர்டு உள் வரி அகலம்';

  @override
  String get pieceWidth => 'துண்டு அகலம்';

  @override
  String get fontSize => 'எழுத்துரு அளவு';

  @override
  String get standardNotation => 'WMD குறியீடு';

  @override
  String get restore => 'மீட்டமை';

  @override
  String get restoreDefaultSettings => 'இயல்புநிலை அமைப்புகளை மீட்டெடுக்கவும்';

  @override
  String pick(Object element) {
    return '$element ஐத் தேர்ந்தெடுங்கள்';
  }

  @override
  String get info => 'தகவல்';

  @override
  String get hint => 'குறிப்பு';

  @override
  String get player => 'வீரர்';

  @override
  String get player1 => 'வீரன் 1';

  @override
  String get player2 => 'வீரன் 2';

  @override
  String get howToPlay => 'எப்படி விளையாடுவது';

  @override
  String get toPlacePiece =>
      'துண்டு வைக்க கிடைக்கக்கூடிய எந்த புள்ளியையும் தட்டவும்.';

  @override
  String get toSelectPiece => 'அதை நகர்த்த ஒரு துண்டைத் தட்டவும்.';

  @override
  String get toMovePiece =>
      'அதை நகர்த்த ஒரு துண்டுடன் இணைக்கப்பட்ட ஒரு புள்ளியைத் தட்டவும்.';

  @override
  String get toRemovePiece =>
      'அதை அகற்ற எதிராளியின் துண்டுகளில் ஒன்றைத் தட்டவும்.';

  @override
  String get needToCreateMillFirst =>
      'நீங்கள் ஒரு பகுதியை அகற்றுவதற்கு முன்பு முதலில் ஒரு ஆலை உருவாக்க வேண்டும்.';

  @override
  String get needToPlayWithOwnPieces =>
      'உங்கள் துண்டுகளுடன் நீங்கள் விளையாட வேண்டும்.';

  @override
  String get statistics => 'புள்ளிவிவரங்கள்';

  @override
  String get totalGames => 'மொத்த விளையாட்டுகள்';

  @override
  String get results => 'முடிவுகள்';

  @override
  String get left => 'இடது';

  @override
  String get privacyPolicy => 'தனியுரிமைக் கொள்கை';

  @override
  String get privacyPolicy_Detail_1 =>
      'தயவுசெய்து கவனமாகப் படித்து, இதை நீங்கள் முழுமையாக புரிந்துகொண்டு உடன்படுகிறீர்கள் என்பதை உறுதிப்படுத்திக் கொள்ளுங்கள் ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. இந்தக் கொள்கையில் நீங்கள் உடன்படவில்லை என்றால், தயவுசெய்து இந்த பயன்பாட்டைப் பயன்படுத்த வேண்டாம். பயன்பாட்டைப் பயன்படுத்துவது இந்த விதிமுறைகளை நீங்கள் ஏற்றுக்கொள்கிறீர்கள் என்பதைக் குறிக்கிறது.';

  @override
  String get and => ' மற்றும் ';

  @override
  String get accept => 'ஏற்றுக்கொள்';

  @override
  String get takeBack => 'திரும்ப எடுத்துக் கொள்ளுங்கள்';

  @override
  String get takingBack => 'திரும்பிச் செல்வது…';

  @override
  String get waiting => 'காத்திருக்கிறது…';

  @override
  String get stepForward => 'முன்னேறவும்';

  @override
  String get takeBackAll => 'அனைத்தையும் திரும்பப் பெறுங்கள்';

  @override
  String get stepForwardAll => 'அனைத்தையும் முன்னெடுத்துச் செல்லுங்கள்';

  @override
  String get moveNow => 'இப்போது நகர்த்தவும்';

  @override
  String get done => 'முடிந்தது.';

  @override
  String get crackMill => 'கிராக் ஆலை';

  @override
  String get crackMill_Detail =>
      'ஒரு வீரருக்கு ஆலைகளில் துண்டுகள் மட்டுமே இருந்தால், ஆலைகளில் உள்ள துண்டுகள் அகற்ற பூட்டாது.';

  @override
  String get animationDuration => 'அனிமேசன் காலம்';

  @override
  String get none => 'எதுவுமில்லை';

  @override
  String get theme => 'கருப்பொருள்';

  @override
  String get helpContent =>
      'இந்த விளையாட்டு எதிராளியை மூன்று துண்டுகளுக்கும் குறைவான அல்லது சட்டப்பூர்வ நகர்வுகளுடன் விட்டுச் செல்வதை நோக்கமாகக் கொண்டுள்ளது.\n\n மூன்றாவது முறையாக ஒரு நிலை ஏற்பட்டால் அல்லது கடைசி 100 (கட்டமைக்கக்கூடிய) நகர்வுகளில் அகற்றப்படாவிட்டால் விளையாட்டு தானாகவே ஈர்க்கிறது.\n\n விளையாட்டு மூன்று கட்டங்களாக தொடர்கிறது:\n\n 1. காலியாக உள்ள புள்ளிகளில் துண்டுகளை வைப்பது\n 2. துண்டுகளை அருகிலுள்ள புள்ளிகளுக்கு நகர்த்துவது\n 3. (விருப்ப கட்டம்) வீரரை மூன்று துண்டுகளாகக் குறைக்கும்போது எந்த காலியாக உள்ள புள்ளிகளுக்கும் துண்டுகளை நகர்த்துவது\n\n வைப்பது\n\n விளையாட்டு ஒரு வெற்று பலகையுடன் தொடங்குகிறது, இது இருபத்தி நான்கு புள்ளிகளைக் கொண்ட ஒரு கட்டத்தைக் கொண்டுள்ளது. ஒவ்வொரு வீரரும் அனைத்து துண்டுகளையும் பலகையில் வைக்கும் வரை வீரர்கள் தங்கள் துண்டுகளை காலியாக உள்ள புள்ளிகளில் வைப்பார்கள். ஒரு வீரர் தனது மூன்று துண்டுகளை நேராக வைக்க முடிந்தால், அவர் ஒரு \"ஆலை\" வைத்திருக்கிறார், மேலும் தனது எதிரியின் துண்டுகளில் ஒன்றை பலகையில் இருந்து அகற்றலாம்.\n\n சில விதிமுறைகளில், உருவாக்கப்பட்ட ஆலையிலிருந்து ஒரு பகுதியை அகற்றுவதற்கு முன் வீரர்கள் வேறு எந்த துண்டுகளையும் முதலில் அகற்ற வேண்டும்.\n\n சில விதிகளின் கீழ், துண்டுகள் அகற்றப்பட்ட புள்ளிகளில் நீங்கள் மீண்டும் துண்டுகளை வைக்க முடியாது.\n\n அனைத்து துண்டுகளும் வைக்கப்பட்டவுடன், வீரர்கள் அவற்றை நகர்த்தும் திருப்பங்களை எடுத்துக்கொள்கிறார்கள்.\n\n நகரும்\n\n நகர்த்த, ஒரு வீரர் தனது துண்டுகளில் ஒன்றை ஒரு போர்டு வரியுடன் காலியாக உள்ள அருகிலுள்ள இடத்திற்கு நகர்த்துகிறார். அவரால் முடியாவிட்டால், அவர் விளையாட்டை இழக்கிறார். ஒரு போர்டு வரிசையில் தனது மூன்று துண்டுகளை சீரமைக்கும் ஒரு வீரர் ஒரு ஆலை வைத்திருக்கிறார், மேலும் தனது எதிரியின் துண்டுகளில் ஒன்றை வைக்கும் கட்டத்தைப் போலவே அகற்றலாம். ஒரு வீரர் இரண்டு துண்டுகளாகக் குறைக்கப்பட்டால், புதிய ஆலைகளை உருவாக்க விருப்பமில்லை, இதனால் விளையாட்டை இழக்கிறது. ஒரு வீரர் தனது எதிர்ப்பாளர் நகர்வதைத் தடுத்தால் மூன்று துண்டுகளுக்கு மேல் இருக்கும்போது இழக்க நேரிடும்.\n\n பறக்கும்\n\n விதிகளின் சில வகைகளில், ஒரு வீரருக்கு மூன்று துண்டுகள் மட்டுமே எஞ்சியதும், அவற்றின் துண்டுகள் பறக்கலாம், ஆப் அல்லது காலியாக உள்ள எந்த புள்ளிகளுக்கும் செல்லலாம், அருகிலுள்ளவை மட்டுமல்ல.\n';

  @override
  String get versionInfo => 'பதிப்பு செய்தி';

  @override
  String get eula => 'யூலா';

  @override
  String get license => 'உரிமம்';

  @override
  String get sourceCode => 'மூலக் குறியீடு';

  @override
  String get appVersion => 'பயன்பாட்டு பதிப்பு';

  @override
  String get general => 'பொது';

  @override
  String get advanced => 'மேம்பட்ட';

  @override
  String get placing => 'வைப்பது';

  @override
  String get moving => 'நகரும்';

  @override
  String get removing => 'நீக்குதல்';

  @override
  String get gameOverCondition => 'நிலை மீது விளையாட்டு';

  @override
  String get aisPlayStyle => 'AI இன் விளையாட்டு நடை';

  @override
  String get passive => 'செயலற்ற';

  @override
  String get timeout => 'நேரம் முடிந்தது';

  @override
  String get appearance => 'தோற்றம்';

  @override
  String get drawOnHumanExperience => 'மனித அனுபவத்தை வரையவும்';

  @override
  String get considerMobility => 'துண்டுகளின் இயக்கம் கவனியுங்கள்';

  @override
  String get pieceCount => 'துண்டு எண்ணிக்கை:';

  @override
  String inHand(Object player, int count) {
    return '$player கையில்: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player போர்டில்: $count';
  }

  @override
  String get boardTop => 'போர்டு மேலே இருந்து ஆஃப்செட்';

  @override
  String get notAIsTurn => 'இது செஅ இன் முறை அல்ல.';

  @override
  String get aiIsNotThinking => 'செஅ யோசிக்கவில்லை.';

  @override
  String get atEnd => 'நீங்கள் நகரும் பட்டியலின் முடிவில் இருக்கிறீர்கள்.';

  @override
  String get tapBackAgainToLeave => 'வெளியேற மீண்டும் தட்டவும்.';

  @override
  String get more => 'மேலும்';

  @override
  String get experimental => 'இது ஒரு சோதனை நற்பொருத்தம்.';

  @override
  String get experiments => 'சோதனைகள்';

  @override
  String get ossLicenses => 'திறந்த மூல உரிமங்கள்';

  @override
  String get language => 'மொழி';

  @override
  String get defaultLanguage => 'இயல்புநிலை மொழி';

  @override
  String get mayMoveInPlacingPhase => 'துண்டுகள் வைக்கும் கட்டத்தில் நகரலாம்';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'தனித்துவமான இடம் மற்றும் நகரும் கட்டங்கள் எதுவும் இல்லை, அதாவது, வீரர்கள் ஒவ்வொரு அசைவிலும் ஒரு பகுதியை பலகையில் வைக்க விரும்புகிறார்களா அல்லது அவர்களின் துண்டுகளில் ஒன்றை நகர்த்த விரும்புகிறீர்களா என்பதை தீர்மானிக்க முடியும் (அவர்கள் மீதமுள்ள துண்டுகள் இருக்கும் வரை).';

  @override
  String get drawerColor => 'பட்டி நிறம்';

  @override
  String get drawerTextColor => 'பட்டியல் உரை நிறம்';

  @override
  String get drawerHighlightItemColor =>
      'பட்டியல் சிறப்பம்சமாக உருப்படி வண்ணம்';

  @override
  String get mainToolbarBackgroundColor => 'முக்கிய கருவிப்பட்டி பின்னணி நிறம்';

  @override
  String get mainToolbarIconColor => 'முதன்மையான கருவிப்பட்டி படவுரு நிறம்';

  @override
  String get navigationToolbarBackgroundColor =>
      'வழிசெலுத்தல் கருவிப்பட்டி பின்னணி நிறம்';

  @override
  String get navigationToolbarIconColor =>
      'வழிசெலுத்தல் கருவிப்பட்டி படவுரு நிறம்';

  @override
  String get autoHideToolbar => 'கருவிப்பட்டியை தானாக மறைக்கவும்';

  @override
  String get toolbarLocationOnScreen => 'திரையில் கருவிப்பட்டி இருப்பிடம்';

  @override
  String get top => 'மேலே';

  @override
  String get bottom => 'கீழே';

  @override
  String get center => 'நடுவண்';

  @override
  String get solidColor => 'திட நிறம்';

  @override
  String get picture => 'படம்';

  @override
  String get chooseYourPicture => 'உங்கள் படத்தைத் தேர்வுசெய்க';

  @override
  String get light => 'ஒளி';

  @override
  String get dark => 'இருண்ட';

  @override
  String get themes => 'கருப்பொருள்கள்';

  @override
  String get currentTheme => 'தற்போதைய கருப்பொருள்';

  @override
  String get saveTheme => 'கருப்பொருள் சேமிக்கவும்';

  @override
  String get showAnalysisGraph => 'பகுப்பாய்வு வரைபடத்தைக் காட்டு';

  @override
  String get analysis => 'பகுப்பாய்வு';

  @override
  String get saveGame => 'விளையாட்டைச் சேமிக்கவும்';

  @override
  String get loadGame => 'விளையாட்டு சுமை';

  @override
  String get setupPosition => 'அமைவு நிலை';

  @override
  String get showLegalMoves => 'சட்ட நகர்வுகளைக் காட்டு';

  @override
  String get showLastMove => 'கடைசி நகர்வைக் காட்டு';

  @override
  String get showArrows => 'அம்புகளைக் காட்டு';

  @override
  String get pieces => 'துண்டுகள்';

  @override
  String get showAnalysis => 'பகுப்பாய்வைக் காட்டு';

  @override
  String get threads => 'நூல்கள்';

  @override
  String get getInvolved => 'ஈடுபடுங்கள்';

  @override
  String get helpImproveTranslate => 'மொழிபெயர்ப்பை மேம்படுத்த உதவுங்கள்';

  @override
  String get tutorial => 'பயிற்சி';

  @override
  String get classicMill => 'கிளாசிக் ஆலை';

  @override
  String get mixedMill => 'கலப்பு ஆலை';

  @override
  String get ceylonMill => 'சிலோன் மில்';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'ஆலை உடைக்கப்பட்டு மீண்டும் செய்யப்படலாம்';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'ஒரு புதிய ஆலை உடனடியாக உருவாக்க ஒரு வீரர் ஒரு ஆலை உடைத்து உடனடியாக ஒரு புதிய ஆலை உருவாக்கினால், அந்த பகுதியை அவர்களின் அடுத்த நகர்வின் அசல் புள்ளிக்கு நகர்த்த முடியும்.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'ஒரு வீரருக்கு மூன்று துண்டுகள் இருந்தால் விளையாட்டு வரையப்படுகிறது மற்றும் பத்து நகர்வுகளுக்குப் பிறகு எந்த வீரரும் எதிராளியின் துண்டுகளை அகற்றவில்லை';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'ஒரு வீரர் மூன்று துண்டுகளாக இருக்கும்போது, எந்த வீரரும் பத்து நகர்வுகளுக்குள் எதிராளியின் பகுதியை அகற்ற முடியாது, விளையாட்டு ஒரு சமநிலை.';

  @override
  String get close => 'மூடு';

  @override
  String get whitePiece => 'வெள்ளை துண்டு';

  @override
  String get blackPiece => 'கருப்பு துண்டு';

  @override
  String get emptyPoint => 'வெற்று புள்ளி';

  @override
  String get noPoint => 'எந்தப் புள்ளியும் இல்லை';

  @override
  String get placingPhase => 'கட்டம்';

  @override
  String get movingPhase => 'நகரும் கட்டம்';

  @override
  String get flyingPhase => 'பறக்கும் கட்டம்';

  @override
  String sideToMove(Object player) {
    return 'நகர்த்த வேண்டிய பக்க: $player';
  }

  @override
  String lastMove(Object move) {
    return 'கடைசி நடவடிக்கை: $move';
  }

  @override
  String get selected => 'தேர்ந்தெடுக்கப்பட்டது';

  @override
  String get accessibility => 'அணுகல்';

  @override
  String get screenReaderSupport => 'திரை வாசகர் உதவி';

  @override
  String get isDraw => 'இது ஒரு சமநிலை!';

  @override
  String get draw => 'டிரா';

  @override
  String get pieceHighlightColor => 'துண்டு சிறப்பம்சமாக வண்ணம்';

  @override
  String get algorithm => 'படிமுறை';

  @override
  String get endgameNMoveRule => 'எண்ட்கேம் என்-மூவ் விதி';

  @override
  String get endgameNMoveRule_Detail =>
      'எந்தவொரு வீரருக்கும் மூன்று துண்டுகள் மட்டுமே இருந்தால், எந்த வீரரும் குறிப்பிட்ட நகர்வுகளுக்குள் ஒரு பகுதியை அகற்றவில்லை என்றால் விளையாட்டு வரையப்படுகிறது.';

  @override
  String get drawReasonEndgameRule50 =>
      'எந்தவொரு வீரருக்கும் மூன்று துண்டுகள் மட்டுமே உள்ளன, மேலும் எந்த வீரரும் குறிப்பிட்ட நகர்வுகளுக்குள் ஒரு பகுதியை அகற்றுவதில்லை.';

  @override
  String get threefoldRepetitionRule => 'மூன்று மடங்கு மறுபடியும் விதி';

  @override
  String get threefoldRepetitionRule_Detail =>
      'மூன்றாவது முறையாக ஒரு நிலை ஏற்பட்டால் விளையாட்டு வரையப்படுகிறது.';

  @override
  String get continueToMakeMove => 'மில்! தொடர்ந்து ஒரு நகர்வு.';

  @override
  String get pointStyle => 'புள்ளி நடை';

  @override
  String get pointWidth => 'புள்ளி அகலம்';

  @override
  String get solid => 'திடமான';

  @override
  String get hollow => 'வெற்று';

  @override
  String get languageName => 'தமிழ்';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count நகர்வுகள்',
      one: '$count நகர்த்து',
      zero: 'Move',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'சுமை தோல்வியடைந்தது.';

  @override
  String get filename => 'கோப்பு பெயர்';

  @override
  String get browse => 'உலாவுக…';

  @override
  String get gameFiles => 'விளையாட்டு கோப்புகள்';

  @override
  String get gameSavedTo => 'விளையாட்டு சேமிக்கப்படுகிறது';

  @override
  String get empty => 'காலி';

  @override
  String get noMove => 'எந்த நடவடிக்கையும் இல்லை.';

  @override
  String get restoredPosition => 'ஆரம்ப நிலை மீட்டெடுக்கப்பட்டது.';

  @override
  String get clean => 'தூய்மையான';

  @override
  String get cleanedUp => 'தூய்மை செய்யப்பட்டது.';

  @override
  String get remove => 'அகற்று';

  @override
  String get noPiecesCanBeRemoved => 'எந்த துண்டுகளையும் அகற்ற முடியாது.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count துண்டுகள்',
      one: '$count துண்டு',
      zero: 'Piece',
    );
    return '$_temp0 அகற்ற வேண்டும்.';
  }

  @override
  String placedCount(int count) {
    return 'வைக்கப்பட்டது ($count)';
  }

  @override
  String get placedPieceCount => 'வைக்கப்பட்ட கட்டத்தில் துண்டு எண்ணிக்கை.';

  @override
  String hasPlacedPieceCount(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'தற்போதைய வீரர் $count துண்டுகளை வைத்துள்ளார்.',
      one: 'தற்போதைய வீரர் ஒரு துண்டை வைத்துள்ளார்.',
      zero: 'தற்போதைய வீரர் எந்தத் துண்டுகளையும் வைக்கவில்லை.',
    );
    return '$_temp0';
  }

  @override
  String get notPlacingPhase => 'கட்டத்தை வைக்காமல், அதை மாற்ற முடியாது.';

  @override
  String get paste => 'ஒட்டு';

  @override
  String get pasteDone => 'பேச்ட் செய்யப்படுகிறது.';

  @override
  String get cannotPaste => 'ஒட்ட முடியாது.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'இடம்பெயர்ந்த மற்றும் அகற்றப்பட்ட துண்டுகளை காட்டு';

  @override
  String get fullScreen => 'முழுத் திரை';

  @override
  String get reopenToTakeEffect =>
      'அமைப்புகள் நடைமுறைக்கு வருவதற்கான பயன்பாட்டிலிருந்து வெளியேறவும் மீண்டும் திறக்கவும்.';

  @override
  String get forest => 'காடு';

  @override
  String get desktopImage => 'டெச்க்டாப் படம்';

  @override
  String get invalidPosition => 'தவறான நிலை.';

  @override
  String get shareGIF => 'பகிர்வு gif';

  @override
  String get pixelRatio => 'படப்புள்ளி விகிதம்';

  @override
  String get duration => 'காலம்';

  @override
  String get gameScreenRecorder => 'கேம் திரை ரெக்கார்டர்';

  @override
  String get previous => 'முந்தைய';

  @override
  String get next => 'அடுத்தது';

  @override
  String get skip => 'தவிர்';

  @override
  String get gotIt => 'கிடைத்தது';

  @override
  String get youCanModifyRules =>
      'விதி அமைப்புகளில் விளையாட்டின் விதிகளை நீங்கள் மாற்றலாம்.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'பிக்கரில் உள்ள மதிப்பை சரிசெய்ய நீங்கள் சுட்டி சக்கரத்தைப் பயன்படுத்தலாம்.';

  @override
  String get noTimeLimitForThinking =>
      'AI சிந்தனை நேரம் 0 என அமைக்கப்பட்டால், சிந்திக்க நேர வரம்பு இல்லை.';

  @override
  String get whatIsMtdf =>
      'எம்டிடி (எஃப்) என்பது ஆல்பா-பீட்டா தேடல் வழிமுறையின் மாற்றியமைக்கப்பட்ட வடிவமாகும், இது இடைநிலை தேடல் முடிவுகளை மீண்டும் பயன்படுத்துவதன் மூலமும், தேடல் இடத்தை குறைக்க ஒரு நல்ல ஆரம்ப யூகத்தைப் பயன்படுத்துவதன் மூலமும் செயல்திறனை மேம்படுத்துவதை நோக்கமாகக் கொண்டுள்ளது.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'AI சிந்தனை நேர சரிசெய்தல் முற்றிலும் துல்லியமாக இருக்காது என்பதை நினைவில் கொள்க. சிரம நிலை குறைந்த மதிப்புக்கு அமைக்கப்படும்போது உண்மையான சிந்தனை நேரம் குறுகியதாக இருக்கலாம், மேலும் நேரம் முடிந்ததும் AI நடுப்பகுதியில் சிந்திக்கும்போது நீண்டதாக இருக்கலாம்.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'நீங்கள் சிரம நிலையை அதிகமாக அமைத்தால், ஆனால் AI சிந்தனை நேரத்தை அதிகரிக்கவில்லை என்றால், உண்மையான சிரம நிலை சிந்தனை நேரக் கட்டுப்பாடு காரணமாக குறைந்த மதிப்புக்கு மட்டுப்படுத்தப்படலாம். இயந்திரத்தின் செயல்திறனின் அடிப்படையில் உண்மையான மதிப்பு மாறுபடலாம்.';

  @override
  String get whatIsPvs =>
      'பி.வி.எச் (முதன்மை மாறுபாடு தேடல்) என்பது கொடுக்கப்பட்ட நிலையில் சிறந்த நகர்வைக் கண்டறிய ஒரு தேடல் வழிமுறையாகும். இது ஆல்பா-பீட்டா வழிமுறையின் விரிவாக்கமாகும், மேலும் ஒரு நடவடிக்கை மோசமானது அல்லது முதன்மை மாறுபாட்டிலிருந்து ஏற்கனவே பாதுகாப்பான மதிப்பெண்ணை விட மோசமானது அல்ல என்பதை உறுதிப்படுத்த சுழிய அல்லது சுழிய சாளர தேடல்களைப் பயன்படுத்துகிறது. பி.வி.எச் மிகவும் நம்பிக்கைக்குரிய நகர்வுகளில் கவனம் செலுத்துகிறது மற்றும் சப்டோப்டிமல் கிளைகளின் தேவையற்ற தேடல்களைத் தவிர்க்கிறது, இது தேடலின் செயல்திறனை மேம்படுத்த உதவுகிறது.';

  @override
  String get whatIsAlphaBeta =>
      'ஆல்பா-பீட்டா வழிமுறை சிறந்த நகர்வைக் கண்டறிய ஒரு தேடல் வழிமுறையாகும். தேடல் மரத்தைக் கத்தரிக்கவும் செயல்திறனை அதிகரிக்கவும் இது மினிமேக்ச் கொள்கை மற்றும் ஆல்பா மற்றும் பீட்டா இரண்டு மதிப்புகளைப் பயன்படுத்துகிறது. ஆல்பா என்பது கணினி பெற முடியும் என்பதில் உறுதியாக இருக்கும் குறைந்தபட்ச மதிப்பெண்ணைக் குறிக்கிறது, அதே நேரத்தில் பீட்டா அதன் எதிரி பெறக்கூடிய அதிகபட்ச மதிப்பெண்ணைக் குறிக்கிறது. ஒரு விளையாட்டில் அறிவுள்ள, திறமையான முடிவுகளை எடுக்கக் கணினி உதவுகிறது.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'மனித அனுபவத்தின்படி, நீங்கள் வெல்ல முயற்சித்தால், நீங்கள் இழப்பீர்கள். அதற்கு பதிலாக, உங்கள் இலக்காக ஒரு டிராவை நோக்கமாகக் கொண்டு, விளையாட்டை இழப்பதைத் தவிர்க்கவும். உங்கள் எதிரியைக் கவனித்து, அவர்கள் தவறுகளைச் செய்யக்கூடிய ஒரு நிலைக்கு மெதுவாக கவர்ந்திழுக்கவும். அவர்கள் பலவீனத்தைக் காட்டும்போது, வாய்ப்பைக் கைப்பற்றி, வெற்றிக்கு மெதுவாகத் தள்ளுங்கள். இந்த வழியில், நீங்கள் விளையாட்டை வெல்லலாம்.';

  @override
  String get firstMoveDetail =>
      'இந்த விளையாட்டில், முதல் வீரருடன் ஒப்பிடும்போது இரண்டாவது வீரர் செய் பெறுவது எளிது.';

  @override
  String get passiveDetail =>
      'செயலற்ற விருப்பத்தை செயல்படுத்துவது, ஆக்ரோசமாக வெல்ல முயற்சிப்பதை விட, நிலையில் ஒரு நன்மை இருக்கும்போது AI ஓய்வெடுக்க வழிவகுக்கும்.';

  @override
  String get moveRandomlyDetail =>
      'இந்த விருப்பத்தை இயக்குவது விளையாட்டின் சீரற்ற தன்மையையும் வேடிக்கையையும் அதிகரிக்கிறது, அதே நேரத்தில் அதை முடக்குவது AI ஐ வெல்ல வழிகளை ஆய்வு செய்ய உதவும்.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'AI அதன் துண்டுகளின் இயக்கத்தை கருத்தில் கொண்டால், அது எதிராளியின் துண்டுகளை விரைவாகப் பிடிப்பதை நோக்கமாகக் கொண்டது மட்டுமல்லாமல், எதிரியின் இயக்கங்களைத் தடுப்பதையும், அவ்வாறே செய்வதிலிருந்து அவற்றைத் தடுப்பதையும் கருத்தில் கொள்ளுங்கள்.';

  @override
  String get whenBoardIsFull => 'பலகை நிரம்பும்போது';

  @override
  String get whenBoardIsFull_Detail =>
      'வைக்கும் கட்டத்தின் முடிவில், நகரும் கட்டம் தொடங்குவதற்கு முன்பு, பலகை துண்டுகள் நிறைந்திருந்தால் நடவடிக்கை பின்வருமாறு.';

  @override
  String get sideToMoveRemovePiece =>
      'நகரும் கட்டத்தில் முதலில் நகரும் வீரர் எதிராளியின் துண்டுகளில் ஒன்றை நீக்குகிறார்.';

  @override
  String get agreeToDraw =>
      'இரு தரப்பினரும் ஒரு சமநிலைக்கு ஒப்புக்கொள்கிறார்கள்.';

  @override
  String get takeOpponentsPiece =>
      'உங்கள் எதிரியின் துண்டுகளில் ஒன்றை எடுத்துக் கொள்ளுங்கள்.';

  @override
  String get firstPlayerLose => 'முதல் வீரர் விளையாட்டை இழக்கிறார்.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'முதல் மற்றும் இரண்டாவது வீரர்கள் எதிராளியின் துண்டுகளில் ஒன்றை நீக்குகிறார்கள்.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'இரண்டாவது மற்றும் முதல் வீரர்கள் எதிராளியின் துண்டுகளில் ஒன்றை அகற்றுகிறார்கள்.';

  @override
  String get enteredFlyingPhase =>
      'இப்போது பறக்கும் கட்டத்தில் நுழைந்தது, எதிரியின் துண்டுகள் பலகையில் உள்ள எந்த வெற்று இடத்திற்கும் செல்லலாம். \"விதி அமைப்புகள்\" இல் பறக்கும் விதியை நீங்கள் அணைக்கலாம்.';

  @override
  String get whenStalemate => 'முட்டுக்கட்டை போது';

  @override
  String get whenStalemate_Detail =>
      'எந்தவொரு பகுதியையும் நகர்த்த முடியாதபோது என்ன நடவடிக்கை பின்வருமாறு?';

  @override
  String get endWithStalemateLoss =>
      'தடுக்கப்பட்ட பக்கத்திற்கு ஒரு முட்டுக்கட்டை இழப்புடன் முடிக்கவும்.';

  @override
  String get changeSideToMove => 'நகர்த்த பக்கத்தை மாற்றவும்.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'எதிராளியின் துண்டுகளில் ஒன்றை அகற்றி அடுத்த நகர்வை மேற்கொள்ளுங்கள்.';

  @override
  String get endWithStalemateDraw => 'ஒரு முட்டுக்கட்டை டிராவுடன் முடிக்கவும்.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'எதிராளியின் துண்டுகளில் ஒன்றை அகற்றி, நகர்த்த பக்கத்தை மாற்றவும்.';

  @override
  String get aiResponseDelayTime => 'AI மறுமொழி தாமத நேரம்';

  @override
  String get aiIsDelaying =>
      'AI தற்போது தாமதமான மறுமொழி கட்டத்தில் உள்ளது. தொடர்வதற்கு முன் சிறிது நேரம் காத்திருங்கள்.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'நீங்கள் அருகிலுள்ள அல்லாத துண்டுகளை அகற்ற முடியாது.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'ஒரு முட்டுக்கட்டைக்கு, ஆலை உருவாவதைப் பொருட்படுத்தாமல், உங்களுடைய அருகிலுள்ள எதிரியின் துண்டுகளை அகற்றலாம்.';

  @override
  String get whatIsMcts =>
      'MCTS என்பது ஒரு தொடக்க-நட்பு வழிமுறையாகும், இது உருவகப்படுத்துதல்கள் மூலம் வெவ்வேறு நகர்வுகளை ஆராய்ந்து மதிப்பீடு செய்வதன் மூலம் முடிவுகளை எடுக்கும்.';

  @override
  String get goldenJade => 'கோல்டன் சேட்';

  @override
  String get forestWood => 'வன மரம்';

  @override
  String get darkMystery => 'இருண்ட மர்மம்';

  @override
  String get midnightBlue => 'நள்ளிரவு நீலம்';

  @override
  String get greenForest => 'பசுமை காடு';

  @override
  String get greenMeadow => 'பச்சை புல்வெளி';

  @override
  String get stonyPath => 'ச்டோனி பாதை';

  @override
  String get pastelPink => 'வெளிர் இளஞ்சிவப்பு';

  @override
  String get turquoiseSea => 'டர்க்கைச் கடல்';

  @override
  String get violetDream => 'வயலட் கனவு';

  @override
  String get mintChocolate => 'புதினா சாக்லேட்';

  @override
  String get skyBlue => 'வானம் நீலம்';

  @override
  String get playfulGarden => 'விளையாட்டுத்தனமான தோட்டம்';

  @override
  String get whatIsRetrogradeAnalysis =>
      'ரெட்ரோகிரேட் பகுப்பாய்வு வழிமுறை வெவ்வேறு தொடக்க நிலைகளிலிருந்து ஒரு எண்ட்கேம் தரவுத்தளத்தை உருவாக்க பல மதிப்புள்ள பிற்போக்கு பகுப்பாய்வைப் பயன்படுத்துகிறது, பின்னர் விளையாட்டை மேம்படுத்த இந்த தரவுத்தளத்தைப் பயன்படுத்துகிறது. இந்த அணுகுமுறை அல்ட்ரா-ச்ட்ராங் தீர்வுகள் வகையின் கீழ் வருகிறது.';

  @override
  String get viewAlgorithmGuide =>
      'இந்த வழிமுறைக்கான பயனர் வழிகாட்டியைக் காண விரும்புகிறீர்களா?';

  @override
  String get showPositionalAdvantageIndicator =>
      'நிலை நன்மை குறிகாட்டியைக் காட்டு';

  @override
  String get usePerfectDatabase => 'சரியான தரவுத்தளத்தைப் பயன்படுத்தவும்';

  @override
  String get perfectDatabaseDescription =>
      'அதிநவீன வழிமுறைகள் மூலம் உருவாக்கப்படும் குறைபாடற்ற விளையாட்டு தரவுத்தளத்தைப் பயன்படுத்த இந்த விருப்பத்தை இயக்கவும். இந்த நற்பொருத்தம் உகந்த நகர்வுகளை பரிந்துரைக்க திறப்பு மற்றும் எண்ட்கேம் உத்திகள் இரண்டையும் ஒருங்கிணைக்கிறது. விளையாட்டில் மிக உயர்ந்த அளவிலான துல்லியத்தை நாடும் வீரர்களுக்கு இது விருப்பமான தேர்வாகும். துல்லியமான கணக்கீட்டு நுட்பங்கள் மூலம் உருவாக்கப்பட்டது, தரவுத்தளம் சரியான விளையாட்டு தீர்வுகளை வழங்க வடிவமைக்கப்பட்டுள்ளது.\n\n குறிப்பு: AI தரவுத்தளத்தை அணுகத் தவறினால், அது விளையாட்டு முடிவுகளுக்கான வழக்கமான வழிமுறைகளுக்கு மாறும். தரவுத்தளம் கிடைக்கும்போது, \'சிரம நிலை\' கிட்டத்தட்ட வெல்ல முடியாததாகிவிடும், மேலும் \'AI சிந்தனை நேரம்\' கடுமையான குறைப்பை அனுபவிக்கிறது. தரவுத்தள முடிவுகள் மிக உயர்ந்த முன்னுரிமையைக் கொண்டிருப்பதால், \'AI இன் பிளே பாணி\' விருப்பங்களுக்குள் உள்ள பல அமைப்புகள் மீறப்படும்.\n\n இந்த குறைபாடற்ற தரவுத்தளத்தை எவ்வாறு அதிகம் பயன்படுத்துவது என்பதற்கான வழிகாட்டுதலுக்கு, இங்கே சொடுக்கு செய்க.';

  @override
  String get backgroundImage => 'பின்னணி படம்';

  @override
  String get whatIsRandom =>
      '\'சரியான தரவுத்தளத்தைப் பயன்படுத்துங்கள்\' விருப்பம் இயக்கப்படாதபோது, \'சீரற்ற\' அமைப்பு AI ஐ நகர்த்துவதற்கு எந்த வழிமுறைகளையும் பயன்படுத்தாமல் தோராயமாக நகர்த்துவதற்கு காரணமாகிறது. இது பொதுவாக கணிசமாக பலவீனமான விளையாட்டில் விளைகிறது. மாறாக, \'சரியான தரவுத்தளத்தைப் பயன்படுத்துங்கள்\' இயக்கப்பட்டால், AI பாரம்பரிய AI வழிமுறைகளுடன் கலப்பதற்கு பதிலாக, முடிவுகளை எடுப்பதற்கான \'சரியான தரவுத்தளத்தை\' பிரத்தியேகமாக நம்பியுள்ளது. இந்த பயன்முறையில், AI இன் நகர்வுகள் முற்றிலும் தரவுத்தளத்தின் உள்ளடக்கத்தை அடிப்படையாகக் கொண்டவை, நிகழ்நேர கணக்கீடுகள் அல்லது தேடல் வழிமுறைகளை நம்பியிருப்பதைத் தவிர்க்கிறது.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'எதிரியின் துண்டு (களை) அவர்களின் கையில் இருந்து அகற்றவும்; பின்னர் அது எதிராளியின் இடத்திற்கு திரும்புவது.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'இடும் கட்டத்தின் போது ஆலை உருவாக்கும் போது';

  @override
  String get removeOpponentsPieceFromBoard =>
      'போர்டில் இருந்து எதிராளியின் துண்டு (களை) அகற்றவும்.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'குழுவிலிருந்து எதிரியின் துண்டு (களை) அகற்றவும்; பின்னர் அது எதிராளியின் இடத்திற்கு திரும்புவது.';

  @override
  String get opponentRemovesOwnPiece =>
      'எதிர்ப்பாளர் தங்கள் சொந்த துண்டு (களை) குழுவிலிருந்து நீக்குகிறார்.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'நீங்கள் நடவடிக்கை எடுப்பதற்குப் பதிலாக, எதிர்ப்பாளர் தங்கள் சொந்த பகுதியை (களை) வாரியத்திலிருந்து தேர்ந்தெடுத்து நீக்குகிறார், தங்களுக்கு தீங்கு விளைவிக்கும் ஒரு நடவடிக்கையை திறம்பட எடுத்துக்கொள்கிறார்.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'எதிராளியின் துண்டு (களை) அவர்களின் கையில் இருந்து அகற்றவும், பின்னர் அது நகர்வது உங்கள் முறை.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'எதிரியின் கையிலிருந்து துண்டு (களை) அகற்றவும். மல்டி-ரெமோவ் அமைப்பின் படி, பல துண்டுகள் அகற்றப்பட வேண்டும் மற்றும் எதிராளிக்கு கையில் எந்த துண்டுகளும் இல்லை என்றால், எதிரியின் துண்டுகளை பலகையில் இருந்து அகற்றவும். பின்னர், நகர்த்துவதற்கான உங்கள் முறை. நீங்கள் தொடர்ந்து ஆலைகளை உருவாக்கினால், எதிராளியின் துண்டுகளை அகற்றலாம்.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'எதிரியின் கையிலிருந்து துண்டு (களை) அகற்றவும். மல்டி-ரெமோவ் அமைப்பின் படி, பல துண்டுகள் அகற்றப்பட வேண்டும் மற்றும் எதிராளிக்கு கையில் எந்த துண்டுகளும் இல்லை என்றால், எதிரியின் துண்டுகளை பலகையில் இருந்து அகற்றவும். பின்னர், அது நகர்த்துவதற்கான எதிரியின் முறை.';

  @override
  String get markAndDelayRemovingPieces =>
      'துண்டுகளை அகற்றுவதில் குறிக்கவும் நேரந்தவறுகை.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'வைக்கும் கட்டத்தின் போது, அகற்றப்பட வேண்டிய துண்டுகள் குறிக்கப்பட்டுள்ளன, மேலும் இரு வீரர்களுக்கும், இந்த புள்ளிகளில் புதிய துண்டுகள் எதுவும் வைக்க முடியாது. நகரும் கட்டத்தில் நுழைந்ததும், இந்த குறிக்கப்பட்ட துண்டுகள் முழுவதுமாக அகற்றப்படுகின்றன, மேலும் வீரர்கள் தங்கள் துண்டுகளை இப்போது காலியாக உள்ள இந்த புள்ளிகளுக்கு நகர்த்தலாம்.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'இடும் கட்டத்தின் போது ஆலை உருவாக்கும் போது எடுக்கக்கூடிய நடவடிக்கைகள்.';

  @override
  String get marked => 'குறிக்கப்பட்டுள்ளது';

  @override
  String get menu => 'பட்டியல்';

  @override
  String get monochrome => 'ஒரே வண்ணமுடைய';

  @override
  String get youCanEnableScreenReaderSupport =>
      'பொது அமைப்புகளில் அணுகல் உள்ளமைவில் திரை ரீடர் உதவி சுவிட்சை நீங்கள் இயக்கலாம்.';

  @override
  String get showNumbersOnPieces => 'துண்டுகளில் எண்களைக் காட்டு';

  @override
  String get saveImage => 'படத்தை சேமிக்கவும்';

  @override
  String get isAnalysisToolbarShown => 'பகுப்பாய்வு கருவிப்பட்டியைக் காட்டு';

  @override
  String get analysisToolbarBackgroundColor =>
      'பகுப்பாய்வு கருவிப்பட்டி பின்னணி நிறம்';

  @override
  String get analysisToolbarIconColor =>
      'பகுப்பாய்வு கருவிப்பட்டி படவுரு நிறம்';

  @override
  String get transformed => 'மாற்றப்பட்டது.';

  @override
  String get cannotTransform => 'மாற்ற முடியாது.';

  @override
  String get rotate => 'சுழற்றுங்கள்';

  @override
  String get horizontalFlip => 'எச் ஃபிளிப்';

  @override
  String get verticalFlip => 'திருப்பத்தில்';

  @override
  String get innerOuterFlip => 'நான் புரட்டுகிறேன்';

  @override
  String get transparentCanvas => 'வெளிப்படையான கேன்வாச்';

  @override
  String get restrictRepeatedMillsFormation =>
      'மீண்டும் நிகழும் ஆலைகள் உருவாவதைக் கட்டுப்படுத்துங்கள்';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'ஒரு ஆலையில் இருந்து ஒரு துண்டு இன்னொரு ஆலையை உருவாக்கியது, அடுத்த திருப்பத்தில் அசல் புள்ளிக்கு மீண்டும் ஒரு ஆலை மீண்டும் உருவாக முடியாது. முதலில் வேறுபட்ட நடவடிக்கை தேவை.';

  @override
  String get oneTimeUseMill => 'ஒரு முறை பயன்பாட்டு ஆலை';

  @override
  String get oneTimeUseMill_Detail =>
      'ஒவ்வொரு ஆலை ஒரு எதிரியின் பகுதியை ஒரு முறை மட்டுமே அகற்ற முடியும். நீங்கள் அதை மீண்டும் சீர்திருத்தலாம், ஆனால் கூடுதல் நீக்குதல்களுக்கு இதைப் பயன்படுத்த முடியாது.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'நீங்கள் அமைத்த தற்போதைய விதிகள் தொடர்புடைய சரியான தரவுத்தளத்தைக் கொண்டிருக்கவில்லை. சரியான தரவுத்தளத்தைப் பற்றிய கூடுதல் தகவலுக்கு, இங்கே சொடுக்கு செய்க.';

  @override
  String get focusOnBlockingPaths => 'பாதைகளைத் தடுப்பதில் கவனம் செலுத்துங்கள்';

  @override
  String get focusOnBlockingPaths_Detail =>
      'விளையாட்டின் குறிப்பிட்ட கட்டங்களின் போது, ஆலைகளை உருவாக்குவதில் எதிராளியின் இயக்கத்தைத் தடுக்கிறது. ஆலைகளை முடிப்பதன் மூலம் துண்டுகளை அகற்றுவதில் கவனம் செலுத்துவதற்குப் பதிலாக, இந்த கட்டங்களின் போது எதிராளியை சிக்க வைப்பதை AI நோக்கமாகக் கொண்டுள்ளது, மேலும் அவற்றை நகர்த்த முடியாமல், வன்கவர்வு விளையாட்டைக் காட்டிலும் ஒரு வெற்றியைப் பெறுகிறது. இந்த கட்ட-குறிப்பிட்ட மூலோபாயம் எதிராளியின் ஆலைகளை தீவிரமாகத் தடுக்காது.';

  @override
  String get pieceImage => 'துண்டு படம்';

  @override
  String get importColorSettings => 'வண்ண அமைப்புகளை இறக்குமதி செய்யுங்கள்';

  @override
  String get exportColorSettings => 'வண்ண அமைப்புகளை ஏற்றுமதி செய்யுங்கள்';

  @override
  String get import => 'இறக்குமதி';

  @override
  String get export => 'ஏற்றுமதி';

  @override
  String get pleaseCopyJsonToClipboard =>
      'முதலில் சாதொபொகு வடிவமைப்பு அமைப்புகளை இடைநிலைப்பலகைக்கு நகலெடுக்கவும்.';

  @override
  String get copiedToClipboard => 'இடைநிலைப்பலகைக்கு நகலெடுக்கப்பட்டது.';

  @override
  String get imported => 'இறக்குமதி செய்யப்பட்டது.';

  @override
  String get boardImage => 'போர்டு படம்';

  @override
  String get autumnLeaves => 'இலையுதிர் கால இலைகள்';

  @override
  String get legendaryLand => 'புகழ்பெற்ற நிலம்';

  @override
  String get vignetteEffect => 'விக்னெட் விளைவு';

  @override
  String get promptMakeToolbarTransparent =>
      'பலகை பின்னணி படம் அமைக்கப்படும்போது கருவிப்பட்டியை முழுமையாக வெளிப்படையானதாக மாற்ற விரும்புகிறீர்களா?';

  @override
  String get vibration => 'விளையாட்டில் அதிர்வுகளை இயக்கவும்';

  @override
  String get soundTheme => 'ஒலி கருப்பொருள்';

  @override
  String get ball => 'பந்து';

  @override
  String get liquid => 'திரவ';

  @override
  String get wood => 'மரம்';

  @override
  String get placeEffectAnimation => 'துண்டு வைக்கும் அனிமேசன் விளைவு';

  @override
  String get removeEffectAnimation => 'துண்டு அகற்றும் அனிமேசன் விளைவு';

  @override
  String get isToolbarAtBottom => 'கருவிப்பட்டியை கீழே காட்டு';

  @override
  String get boardCornerRadius => 'போர்டு கார்னர் ஆரம்';

  @override
  String get useOpeningBook => 'தொடக்க புத்தகத்தைப் பயன்படுத்தவும்';

  @override
  String get currentRule => 'மின்னோட்ட்ம், ஓட்டம்';

  @override
  String get nineMensMorris => 'ஒன்பது ஆண்கள் மோரிச்';

  @override
  String get twelveMensMorris => 'பன்னிரண்டு ஆண்கள் மோரிச்';

  @override
  String get morabaraba => 'நகர்வு';

  @override
  String get dooz => 'டுச்';

  @override
  String get chamGonu => 'சாம்';

  @override
  String get zhiQi => 'zh';

  @override
  String get chengSanQi => 'செங் சான் கே';

  @override
  String get mulMulan => 'முல்-முலன்';

  @override
  String get nerenchi => 'நெரென்ச்';

  @override
  String get ruleSet => 'விதி தொகுப்பு';

  @override
  String get laskerMorris => 'லாச்கர் மோரிச்';

  @override
  String get oneTimeMill => 'ஒரு முறை ஆலை';

  @override
  String get daSanQi => 'டா சான் கி';

  @override
  String get useOpeningBook_Detail =>
      'ஆரம்ப ஆட்டத்தின் போது தொழில்முறை மனித வீரர்களால் பொதுவாகப் பயன்படுத்தப்படும் திறப்பு நகர்வுகளை AI பயன்படுத்தட்டும். குறிப்பு: இந்த நற்பொருத்தம் தற்போது குறிப்பிட்ட விதி தொகுப்புகளுக்கு மட்டுமே கிடைக்கிறது.';

  @override
  String get showAdvantageGraph => 'நன்மை வரைபடத்தைக் காட்டு';

  @override
  String get advantageGraphHint =>
      'AI ஒரு நகர்வு செய்த பின்னரே நன்மை வரைபடம் வரையப்படும். மனித வீரர் ஒரு நகர்வை மேற்கொள்ளும்போது அது வரையப்படாது.';

  @override
  String get removalBasedOnMillCounts =>
      'அனைத்து துண்டுகளும் வைக்கப்படும் வரை அகற்றுவதை முடக்கு, பின்னர் ஆலை எண்ணிக்கையின் அடிப்படையில் துண்டுகளை அகற்றவும்.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'அனைத்து துண்டுகளும் வைக்கப்படும் வரை அகற்றுவதை முடக்கு, பின்னர் ஆலை எண்ணிக்கையின் அடிப்படையில் துண்டுகளை அகற்றவும்: அவை சமமாக இருந்தால், இரண்டும் ஒரே எண்ணை அகற்றவும்; ஒருவருக்கு இன்னும் அதிகமாக இருந்தால், அவை ஒரு கூடுதல் வித்தியாசத்தை வைத்திருக்கின்றன. ஒரு ஆலைகளை மட்டுமே உருவாக்கினால், அவை இரண்டு துண்டுகளை அகற்றி, மற்றொன்று ஒன்றை நீக்குகிறது. எந்தவொரு ஆலைகளையும் உருவாக்கவில்லை என்றால், இரண்டும் அவற்றின் சொந்த துண்டுகளில் ஒன்றை அகற்றுகின்றன.';

  @override
  String get elfilja => 'எல் ஃபில்சா';

  @override
  String get tipSelectOwnPiece => 'உங்கள் துண்டுகளில் ஒன்றைத் தேர்ந்தெடு.';

  @override
  String get notYourTurn => 'இது உங்கள் முறை அல்ல.';

  @override
  String get annotationToolbarBackgroundColor =>
      'குறிப்புரை கருவிப்பட்டையின் பின்னணி வண்ணம்';

  @override
  String get annotationToolbarIconColor =>
      'குறிப்புரை கருவிப்பட்டை ஐகான் வண்ணம்';

  @override
  String get isAnnotationToolbarShown => 'சிறுகுறிப்பு கருவிப்பட்டியைக் காட்டு';

  @override
  String get enterAnnotationMode => 'குறிப்புரை பயன்முறைக்கு செல்';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'அனைத்துக் குறிப்புரைகளையும் நீக்க விரும்புகிறீர்களா?';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM கோரிக்கை கிளிப்போர்டுக்கு நகலெடுக்கப்பட்டது.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'இணைப்பு மறுக்கப்பட்டது. சர்வர் செயலிழந்திருக்கலாம்.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'தேடுதல் வெற்றிகரமாக முடிந்தது, இணைப்புக்காகக் காத்திருக்கிறது...';

  @override
  String get noLanConnection => 'இயற்று வலை இணைப்பு இல்லை';

  @override
  String get takeScreenshot => 'படக்காட்சி எடு';

  @override
  String get disconnectedFromOpponent =>
      'எதிரணியுடன் இணைப்பு துண்டிக்கப்பட்டது.';

  @override
  String get takeBackRequest => 'மீள எடுத்துக்கொள்ளும் கோரிக்கை';

  @override
  String get nothingToShow => 'காண்பிக்க எதுவும் இல்லை.';

  @override
  String get stopHosting => 'பகிர்வை நிறுத்து';

  @override
  String get connectionResetByPeer =>
      'இணைப்பு எதிரணி மூலம் மீட்டமைக்கப்பட்டது.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'ஹார்ட்பீட் நேரக் கோப்பு மீறப்பட்டதால் இணைப்பு இழக்கப்பட்டது. தயவுசெய்து மீண்டும் இணைக்கவும்.';

  @override
  String get startHosting => 'பகிர்வை துவங்கு';

  @override
  String get restartRequestRejected =>
      'மீண்டும் துவக்க கோரிக்கை நிராகரிக்கப்பட்டது.';

  @override
  String get notConnectedToLanOpponent => 'LAN எதிரனுடன் இணைக்கப்படவில்லை.';

  @override
  String get llmPrompt => 'LLM கோரிக்கை';

  @override
  String get gameRestarted => 'விளையாட்டு மீண்டும் துவங்கப்பட்டது.';

  @override
  String get takeBackRejected =>
      'மீள எடுத்துக்கொள்ளும் கோரிக்கை நிராகரிக்கப்பட்டது.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'இந்த விளையாட்டில் இருந்து விலக விரும்புகிறீர்களா?';

  @override
  String get opponentResignedYouWin =>
      'எதிரணி விலகிவிட்டார். நீங்கள் வெற்றியடைந்துள்ளீர்கள்!';

  @override
  String get clearAllAnnotations => 'அனைத்துக் குறிப்புரைகளையும் நீக்கு';

  @override
  String get connectedWaitingForOpponentSMove =>
      'இணைக்கப்பட்டது, எதிரணியின் அடுத்த இயக்கத்திற்காக காத்திருக்கிறது...';

  @override
  String get networkStatusDisconnected =>
      'வலையமைப்பின் நிலை: துண்டிக்கப்பட்டது';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'மீள எடுத்துக்கொள்ளும் கோரிக்கை எதிரணிக்கு அனுப்பப்பட்டது.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'எதிரணி விளையாட்டை விட்டு வெளியேறியிருக்கலாம்';

  @override
  String get connectedToHostSuccessfully =>
      'ஹோஸ்டுடன் வெற்றிகரமாக இணைக்கப்பட்டது.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'இணைப்பு இழப்பு: ஹார்ட்பீட் நேரக்கோள் மீறப்பட்டது';

  @override
  String get noHostDiscovered => 'ஓர் ஹோஸ்ட் கண்டுபிடிக்கப்படவில்லை.';

  @override
  String get confirmResignation => 'விலகலை உறுதிப்படுத்து';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'விளையாட்டை ஹோஸ்ட் செய்கிறது, அணுகுவோருக்காக காத்திருக்கிறது...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'இணைப்பு காலாவதியாகியது. வலை இணைப்பு நிலையற்றது.';

  @override
  String get noLlmPromptAvailable => 'LLM கோரிக்கை எதுவும் இல்லை.';

  @override
  String get youResignedGameOver =>
      'நீங்கள் விலகிவிட்டீர்கள். விளையாட்டு முடிந்தது.';

  @override
  String get serverIp => 'சர்வர் IP';

  @override
  String get confirmClear => 'நீக்கத்தை உறுதிப்படுத்து';

  @override
  String get opponentSTurn => 'எதிரணியின் முறை.';

  @override
  String get waitingAClientConnection =>
      'வாடிக்கையாளர் இணைப்புக்காக காத்திருக்கிறது...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'மீள எடுத்துக்கொள்ளும் கோரிக்கை நிராகரிக்கப்பட்டது அல்லது தோல்வியடைந்தது.';

  @override
  String get addText => 'உரை சேர்க்கவும்';

  @override
  String get exitAnnotationMode => 'குறிப்புரை பயன்முறையிலிருந்து வெளியேறவும்';

  @override
  String get typeYourAnnotation => 'உங்கள் குறிப்புரையை உள்ளிடவும்';

  @override
  String get attemptingToReconnect => 'மீண்டும் இணைக்க முயற்சிக்கிறது...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'மீண்டும் துவக்க கோரிக்கை அனுப்பப்பட்டது. எதிரணியின் பதிலுக்காக காத்திருக்கிறது...';

  @override
  String get serverIsStopped => 'சர்வர் நிறுத்தப்பட்டுவிட்டது.';

  @override
  String get restartRequest => 'மீண்டும் துவக்க கோரிக்கை';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'அது உங்கள் முறை அல்லாதபோது மீள எடுத்துக்கொள்ளும் கோரிக்கையை செய்ய முடியாது.';

  @override
  String get takeBackAccepted =>
      'மீள எடுத்துக்கொள்ளும் கோரிக்கை ஏற்றுக்கொள்ளப்பட்டது.';

  @override
  String get localNetworkSettings => 'உள்ளூர் வலையமைப்பு அமைப்புகள்';

  @override
  String get reconnectedSuccessfully => 'வெற்றிகரமாக மீண்டும் இணைக்கப்பட்டது!';

  @override
  String get failedToSaveImageToGallery =>
      'படத்தை கேலரியில் சேமிக்க இயலவில்லை.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'எதிரணி விளையாட்டை மீண்டும் துவங்க கோரினார். நீங்கள் ஏற்றுக்கொள்கிறீர்களா?';

  @override
  String get yourTurn => 'உங்கள் முறை.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'மீண்டும் இணைக்க முடியவில்லை, தயவுசெய்து விளையாட்டை மீண்டும் துவங்கவும்.';

  @override
  String get host => 'ஹோஸ்ட்';

  @override
  String get join => 'இணைவது';

  @override
  String get port => 'போர்்ட்';

  @override
  String get invalidIpAddress => 'பின்செயல் அற்ற IP முகவரி.';

  @override
  String get invalidPort => 'பின்செயல் அற்ற போர்்ட்.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'இணைகிறது: முயற்சி $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'இணைப்பில் தோல்வி: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'பகிர்வை தொடங்குவதில் தோல்வி: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'ஹோஸ்ட் கண்டுபிடிக்கப்பட்டது: $ip:$port';
  }

  @override
  String get stop => 'நிறுத்து';

  @override
  String get discover => 'தேடு';

  @override
  String get connect => 'இணை';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'வாடிக்கையாளர் இணைக்கப்பட்டார்: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'தேடுகிறது: $seconds வினாடிகள்';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'மீண்டும் இணைவது ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'இணைக்கப்பட்டது';

  @override
  String get delete => 'அழி';

  @override
  String get ancientEgypt => 'பழங்கால எகிப்து';

  @override
  String get gothicIce => 'கோதிக் பனி';

  @override
  String get riceField => 'நெல் வயல்';

  @override
  String get chinesePorcelain => 'சீன பீங்கான்';

  @override
  String get desertDusk => 'பாலைவன மாலை';

  @override
  String get precisionCraft => 'துல்லிய கைவினை';

  @override
  String get folkEmbroidery => 'பாரம்பரிய தையல்';

  @override
  String get carpathianHeritage => 'கார்பாத்திய பாரம்பரியம்';

  @override
  String get imperialGrandeur => 'பேரரசு பிரமாண்டம்';

  @override
  String get bohemianCrystal => 'போஹிமியன் படிகம்';

  @override
  String get savannaSunrise => 'சவன்னா சூரிய உதயம்';

  @override
  String get harmonyBalance => 'நல்லிணக்க சமநிலை';

  @override
  String get cinnamonSpice => 'இலவங்கப்பட்டை மசாலா';

  @override
  String get anatolianMosaic => 'அனடோலியன் மொசைக்';

  @override
  String get carnivalSpirit => 'கார்னிவல் ஆவி';

  @override
  String get custom => 'சான்றிதழ்';

  @override
  String get spiceMarket => 'மஸாலா சந்தை';

  @override
  String get swipeToRevealTheDrawer => 'டிராயரை வெளிக்காட்ட ஸ்வைப் செய்யவும்';

  @override
  String get showGameInfoOnScreenshots =>
      'திரைப்பிடிப்புகளில் விளையாட்டு தகவலைக் காண்பி';

  @override
  String get humanMoveTime => 'மனித நேர வரம்பு';

  @override
  String get noTimeLimitForHumanMoves => 'மனித நகர்வுகளுக்கு நேர வரம்பு இல்லை';

  @override
  String get timeoutLoseWillBeApplied =>
      'மனித வீரருக்கு நேரம் முடிந்து தோற்கடிக்கப்படும்';

  @override
  String get identifyingBoard => 'பலகையை அடையாளம் காண்கிறது...';

  @override
  String get youCanEnterAnyModelName =>
      'எந்த மாடல் பெயரையும் நீங்கள் சேர்க்கலாம்.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'பலகை நிலை பயன்படுத்தப்பட்டது. FEN கிளிப்போர்டுக்கு நகலெடுக்கப்பட்டது.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'பரிந்துரை: பலகையின் தெளிவான புகைப்படத்தை எடுக்க முயற்சி செய்யவும்.';

  @override
  String get llmPromptTemplate => 'LLM உந்துதல் வார்ப்புரு';

  @override
  String get noValidBoardDetected => 'செல்லுபடியாக் பலகை கண்டறியப்படவில்லை.';

  @override
  String get selectingImageFromAlbum =>
      'ஆல்பமில் இருந்து படத்தை தேர்வு செய்கிறது...';

  @override
  String get configurePromptTemplate => 'உந்துதல் வார்ப்புருவை அமைக்கவும்';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'LLM பகுப்பாய்விற்கு உந்துதல் வார்ப்புருவை தொகுக்கவும்';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'கண்டறியப்பட்ட பலகையிலிருந்து FEN உற்பத்தி தோல்வியடைந்தது.';

  @override
  String get outputInCurrentLanguage => 'தற்போதைய மொழியில் வெளியீடு';

  @override
  String get commonBaseUrls => 'பொது Base URLகள்';

  @override
  String get viewCommonModels => 'பொதுவான மாடல்களைப் பார்வையிட';

  @override
  String get recognitionParametersUpdated =>
      'அறிதல் அளவுருக்கள் புதுப்பிக்கப்பட்டன.';

  @override
  String get whiteSMove => 'வெள்ளையின் அடி';

  @override
  String get resetToDefaults => 'இயல்புவிதிகளுக்கு மீட்டமை';

  @override
  String get photoShoot => 'புகைப்பட எடுதல்';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'கண்டறியப்பட்ட பலகை நிலையை செயல்படுத்த தோல்வியடைந்தது.';

  @override
  String get llmPromptContent => 'LLM உந்துதல் உள்ளடக்கம்';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM கட்டமைக்கப்படவில்லை. உங்கள் அமைப்புகளை சரிபார்க்கவும்.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'வழங்குபவர், மாடல், API Key மற்றும் Base URL ஐ அமைக்கவும்';

  @override
  String get llmConfiguration => 'LLM கட்டமைப்பு';

  @override
  String get configureLlmProvider => 'LLM வழங்குபவரை அமைக்கவும்';

  @override
  String get llmPromptTemplateHeader => 'LLM உந்துதல் வார்ப்புரு தலைப்பு';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'படத்தில் எந்த துண்டுகளும் அடையாளமிடப்படவில்லை. மீண்டும் முயற்சிக்கவும்.';

  @override
  String get recognizeBoardFromImage => 'படத்திலிருந்து பலகையை அடையாளம் காண்க';

  @override
  String get viewTips => 'குறிப்புகளைப் பார்வையிட';

  @override
  String get applyToBoard => 'பலகைக்கு பயன்படுத்தவும்';

  @override
  String get adjustBoardArea => 'பலகை பகுதியை சரிசெய்யவும்';

  @override
  String get viewCommonUrls => 'பொதுவான URLகளைப் பார்வையிட';

  @override
  String get colorAnalysisFailed => 'நிறம் பகுப்பாய்வு தோல்வியடைந்தது!';

  @override
  String get analyzingGameBoardImage =>
      'விளையாட்டு பலகை படத்தை பகுப்பாய்வு செய்கிறது...';

  @override
  String get selectFromAlbum => 'ஆல்பமிலிருந்து தேர்வு செய்யவும்';

  @override
  String get noBoardPointDetected => 'பலகை முனை கண்டறியப்படவில்லை!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'காலியாக விட்டால் இயல்புநிலை வார்ப்புரு பயன்படுத்தப்படும்';

  @override
  String get llmConfig => 'LLM கட்டமைப்பு';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'உங்கள் உந்துதல் வார்ப்புருகளை இயல்புநிலை மதிப்புகளுக்கு மீட்டமைக்க விரும்புகிறீர்களா?';

  @override
  String get llmPromptTemplateFooter => 'LLM உந்துதல் வார்ப்புரு காலடிக் பகுதி';

  @override
  String get loadingResponse => 'பதில் ஏற்றப்படுகிறது...';

  @override
  String get applyThisResultToBoard => 'இந்த முடிவை பலகைக்கு பயன்படுத்தவும்';

  @override
  String get takingPicture => 'படம் எடுக்கப்படுகிறது...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'அடையாளம் காண விளையாட்டு பலகை படத்தைத் தேர்ந்தெடுக்கவும்';

  @override
  String get identificationResults => 'அடையாளம் கண்டறிதல் முடிவுகள்';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'நடத்துக்களை பகுப்பாய்வு செய்து ஆழமான பார்வைகள் வழங்கவும்.';

  @override
  String get getApiKey => 'API Key பெற';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'முழு அறிதல் செயல்முறை நிறைவு பெற முடியவில்லை.';

  @override
  String get boardRecognitionResult => 'பலகை அறிதல் முடிவு';

  @override
  String get askLlm => 'LLM ஐ கேளுங்கள்';

  @override
  String get boardDetectionFailed => 'பலகை கண்டறிதல் தோல்வியடைந்தது!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'பலகை முனை கண்டறியப்படவில்லை, துண்டை அடையாளம் காண முடியாது!';

  @override
  String get copyFen => 'FEN ஐ நகலெடுக்கவும்';

  @override
  String get commonlyUsedModels => 'வழக்கமாக பயன்படுத்தப்படும் மாதிரிகள்';

  @override
  String get apiKeyOptional => 'API Key (விருப்ப)';

  @override
  String get noImageSelected => 'படம் தேர்வு செய்யப்படவில்லை';

  @override
  String get blackSMove => 'கருப்பு வீரரின் அடி';

  @override
  String get llm => 'பெரிய மொழி மாதிரி';

  @override
  String get llmProvider => 'வழங்குநர்';

  @override
  String get baseUrl => 'அடிப்படை URL';

  @override
  String get model => 'மாதிரி';

  @override
  String get temperature => 'வெப்பநிலை';

  @override
  String get llmCommandReceivedProcessing =>
      'கட்டளை பெறப்பட்டது! AI செயலாக்குகிறது...';

  @override
  String get llmDeepThinkingWait =>
      'ஆழமான சிந்தனை நடைபெற்று வருகிறது, தயவு செய்து காத்திருக்கவும்...';

  @override
  String get llmPresentingSoon => 'சமீபத்தில் வழங்கப்படுகிறது...';

  @override
  String get recognitionParameters => 'அறிதல் அளவுருக்கள்';

  @override
  String get adjustParamsDesc =>
      'அறிதல் துல்லியத்தை மேம்படுத்த அளவுருக்களை சரிசெய்க';

  @override
  String get saveParameters => 'அளவுருக்களை சேமிக்கவும்';

  @override
  String unableToStartImageRecognition(String error) {
    return 'பட அடையாளமாக்கலைத் தொடங்க முடியவில்லை: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'பட அடையாளமாக்கல் தோல்வியுற்றது: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return '$whiteCount வெள்ளை மற்றும் $blackCount கருப்பு கற்கள் கொண்ட நிலை பயன்படுத்தப்பட்டது';
  }

  @override
  String get fenCopiedToClipboard => '(FEN கிளிப்போர்டுக்கு நகலெடுக்கப்பட்டது)';

  @override
  String recognitionFailed(String error) {
    return 'அறிதல் தோல்வியுற்றது: $error';
  }

  @override
  String get myRating => 'எனது மதிப்பீடு';

  @override
  String get gamesPlayed => 'விளையாடிய விளையாட்டுகள்';

  @override
  String get wins => 'வெற்றிகள்';

  @override
  String get losses => 'தோல்விகள்';

  @override
  String get draws => 'சமன்நிலைகள்';

  @override
  String get lastUpdated => 'கடைசியாகப் புதுப்பிக்கப்பட்டது';

  @override
  String get format => 'வடிவம்:';

  @override
  String get resetStatistics => 'புள்ளிவிவரங்களை மீட்டமை';

  @override
  String get drawRate => 'சமன்நிலை விகிதம்';

  @override
  String get lossRate => 'தோல்வி விகிதம்';

  @override
  String get aiStatistics => 'AI புள்ளிவிவரங்கள்';

  @override
  String get enableStatistics => 'புள்ளிவிவரங்களை இயக்கு';

  @override
  String get enableStatistics_Detail =>
      'இயக்கப்பட்டால், விளையாட்டு முடிவுகள் புள்ளிவிவரங்களில் பதிவு செய்யப்படும். இருப்பினும், பின்வாங்கல்களை உள்ளடக்கிய விளையாட்டுகள் பதிவு செய்யப்படாது. முடக்கப்பட்டால், புள்ளிவிவர சேகரிப்பு இடைநிறுத்தப்படும்.';

  @override
  String get thisWillResetAllGameStatistics =>
      'இது அனைத்து விளையாட்டு புள்ளிவிவரங்களையும் மீட்டமைக்கும். இந்தச் செயலைச் செயல்தவிர்க்க முடியாது.';

  @override
  String get boardInnerRingSize => 'பலகையின் உள் வளையத்தின் அளவு';

  @override
  String get boardShadowEnabled => 'பலகை நிழல்';

  @override
  String get trapAwareness => 'வலை கண்டறிதல்';

  @override
  String get trapAwarenessDescription =>
      'பகுப்பாய்வின் போது தடிமனான வட்டங்கள் மற்றும் அம்புகளால் வலையின் நகர்வுகளை வெளிப்படுத்து.';

  @override
  String trapExists(String trapMoves) {
    return 'வலை உள்ளது. வலை நகர்வுகள்: $trapMoves';
  }

  @override
  String get custodianCapture => 'ஒளிரும் பிடிப்பு';

  @override
  String get custodianCaptureDescription =>
      'உங்கள் எதிரியின் துண்டுகளில் ஒன்றை உங்களுடைய இரண்டு இடையே ஒரு நேர் கோட்டில் இணைக்கவும்.';

  @override
  String get custodianCaptureEnable => 'பக்கவாட்டு பிடிப்பை அனுமதிக்கவும்';

  @override
  String get interventionCapture => 'தலையீட்டு பிடிப்பு';

  @override
  String get interventionCaptureDescription =>
      'இரண்டையும் பிடிக்க உங்கள் எதிரியின் இரண்டு துண்டுகளுக்கு இடையில் வெற்று புள்ளியில் செல்லுங்கள்.';

  @override
  String get interventionCaptureEnable => 'தலையீடு பிடிப்பை அனுமதிக்கவும்';

  @override
  String get leapCapture => 'ஜம்ப் கேப்சர்';

  @override
  String get leapCaptureDescription =>
      'அருகிலுள்ள எதிராளியின் துண்டுக்கு அப்பால் வெற்று புள்ளியில் குதித்து பிடிக்கவும்.';

  @override
  String get leapCaptureEnable => 'ஜம்ப் பிடிப்பை அனுமதிக்கவும்';

  @override
  String get captureApplicableLines => 'பொருந்தக்கூடிய கோடுகள்';

  @override
  String get captureSquareEdges => 'சதுக்கத்தின் விளிம்புகளுடன்';

  @override
  String get captureCrossLines => 'சதுரத்தைக் கடக்கும் ஆர்த்தோகனல் கோடுகளுடன்';

  @override
  String get captureDiagonalLines => 'சதுரத்தைக் கடக்கும் மூலைவிட்ட கோடுகளுடன்';

  @override
  String get captureExecutionPhases => 'மரணதண்டனை கட்டங்கள்';

  @override
  String get capturePiecesCondition =>
      'மீதமுள்ள துண்டுகளின் அடிப்படையில் நகரும் கட்டத்தின் போது கிடைக்கும்';

  @override
  String get capturePiecesConditionUnlimited => 'கட்டுப்பாடு இல்லை';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'உங்களிடம் மூன்று அல்லது குறைவான துண்டுகள் இருக்கும்போது கிடைக்கும்';
}
