// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Swahili (`sw`).
class SSw extends S {
  SSw([String locale = 'sw']) : super(locale);

  @override
  String get appName => 'Kinu';

  @override
  String get welcome => 'Karibu';

  @override
  String get yes => 'Ndiyo';

  @override
  String get no => 'Hapana';

  @override
  String get game => 'Mchezo';

  @override
  String get humanVsAi => 'Binadamu Vs. AI';

  @override
  String get humanVsHuman => 'Binadamu Vs. Binadamu';

  @override
  String get aiVsAi => 'AI Vs. AI';

  @override
  String get humanVsCloud => 'Binadamu Vs. Wingu';

  @override
  String get humanVsLAN => 'Binadamu Vs. LAN';

  @override
  String get testViaLAN => 'Jaribio Kupitia LAN';

  @override
  String get move => 'Sogeza';

  @override
  String get showMoveList => 'Hamisha orodha';

  @override
  String get moveList => 'Hamisha orodha';

  @override
  String get noGameRecord => 'Hakuna rekodi';

  @override
  String get ok => 'sawa';

  @override
  String get confirm => 'Thibitisha';

  @override
  String get cancel => 'Ghairi';

  @override
  String get tipSelectWrong => 'Chagua kipande kibaya.';

  @override
  String get tipPlace => 'Weka vipande vyako.';

  @override
  String get tipBanPlace => 'Huwezi kuiweka hapa.';

  @override
  String get tipPlaced => 'Umeweka.';

  @override
  String get tipRemove => 'Ondoa kipande.';

  @override
  String get tipBanRemove => 'Huwezi kuiondoa.';

  @override
  String get tipRemoved => 'Umeondoa.';

  @override
  String get tipMove => 'Hoja kipande.';

  @override
  String get tipCannotPlace => 'Huwezi kuweka kipande chako hapa.';

  @override
  String get tipCannotMove => 'Huwezi kuhamisha kipande chako hapa.';

  @override
  String get tipMill => 'Kinu! Chukua kipande cha mpinzani wako.';

  @override
  String get tipContinueMill => 'Endelea kuchukua kipande cha mpinzani wako.';

  @override
  String get tipSelectOpponentsPiece =>
      'Chagua moja ya vipande vya mpinzani wako.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Huwezi kuondoa kipande kutoka kwa kinu.';

  @override
  String get tipCanMoveOnePoint => 'Kipande kinaweza kusonga pointi 1.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Huwezi kusonga vipande vya mpinzani wako.';

  @override
  String get tipSelectPieceToMove => 'Chagua kipande chako ili kusonga.';

  @override
  String get tipHaveThreePiecesLeft => 'Umebakisha vipande vitatu.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Unaweza kusonga kwa hatua yoyote unayopenda.';

  @override
  String tipToMove(Object player) {
    return '$player ili kusonga.';
  }

  @override
  String get whiteWin => 'Mchezaji 1 ameshinda!';

  @override
  String get blackWin => 'Mchezaji 2 ameshinda!';

  @override
  String get won => 'Ameshinda';

  @override
  String get lost => 'Potea';

  @override
  String get thinking => 'Kufikiri…';

  @override
  String get newGame => 'Mchezo mpya';

  @override
  String get importGame => 'Ingiza mchezo';

  @override
  String get exportGame => 'Hamisha mchezo';

  @override
  String get gameImported => 'Mchezo umeingizwa.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Haiwezi kuleta $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Hatua na sheria hazilingani.';

  @override
  String get pleaseWait => 'Tafadhali subiri.';

  @override
  String get restartGame => 'Ungependa kuanzisha upya mchezo wa sasa?';

  @override
  String get restart => 'Anzisha tena';

  @override
  String get gameStarted => 'Mchezo umeanza, tafadhali weka.';

  @override
  String get analyzing => 'Inachanganua…';

  @override
  String error(Object message) {
    return 'Hitilafu: $message';
  }

  @override
  String get winRate => 'Kiwango cha Ushindi';

  @override
  String get score => 'Alama:';

  @override
  String get white => 'Mchezaji 1';

  @override
  String get black => 'Mchezaji 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player idadi ya vipande ni chini ya tatu.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player amejiuzulu.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player hana njia ya kwenda.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Ubao umejaa, na $player haina njia ya kwenda.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Muda umekwisha, $player imepotea.';
  }

  @override
  String get drawReasonRule50 =>
      'Katika awamu ya kusonga, hakuna kipande kilichoondolewa katika idadi maalum ya mwisho ya hatua.';

  @override
  String get drawReasonBoardIsFull => 'Ni Droo kwa sababu ubao umejaa.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Ni Droo kwa sababu ya kurudiwa mara tatu.';

  @override
  String get gameOverUnknownReason =>
      'Shindano limekwisha! Sababu isiyojulikana.';

  @override
  String get gameOver => 'Shindano limekwisha';

  @override
  String get youWin => 'Umeshinda! Hongera!';

  @override
  String challengeHarderLevel(int level) {
    return 'Changamoto ngazi ngumu zaidi? Kiwango kipya kitakuwa kiwango $level!';
  }

  @override
  String get youLose => 'Umepoteza!';

  @override
  String get analyze => 'Chambua';

  @override
  String get about => 'Kuhusu';

  @override
  String version(Object versionNumber) {
    return 'Toleo: $versionNumber';
  }

  @override
  String get thanks => 'Asante';

  @override
  String get settings => 'Mipangilio';

  @override
  String get options => 'Chaguo';

  @override
  String get generalSettings => 'Mipangilio ya Jumla';

  @override
  String get skillLevel => 'Kiwango cha ugumu';

  @override
  String get moveTime => 'Wakati wa kufikiria wa AI';

  @override
  String get difficulty => 'Ugumu';

  @override
  String get playSounds => 'Athari za sauti';

  @override
  String get playSoundsInTheGame => 'Cheza sauti kwenye mchezo';

  @override
  String get keepMuteWhenTakingBack => 'Nyamaza unaporudisha';

  @override
  String get tone => 'Toni';

  @override
  String get whoMovesFirst => 'Kwanza hoja';

  @override
  String get human => 'Binadamu';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Mbadala';

  @override
  String get isAutoRestart =>
      'Anzisha tena mchezo kiotomatiki mchezo unapokwisha';

  @override
  String get isAutoChangeFirstMove => 'Badilisha Otomatiki Hoja ya Kwanza';

  @override
  String get shufflingEnabled => 'Sogeza nasibu';

  @override
  String get misc => 'Mbalimbali';

  @override
  String get rules => 'Kanuni';

  @override
  String get piecesCount => 'Idadi ya vipande kila mchezaji anayo';

  @override
  String get piecesCount_Detail => 'Je, kila mchezaji ana vipande vingapi?';

  @override
  String get flyPieceCount => 'Idadi ya kipande cha kuruka';

  @override
  String get flyPieceCount_Detail =>
      'Ikiwa Kipengele cha Kuruka kimewashwa, mchezaji anapopunguzwa hadi idadi mahususi ya vipande, vipande vyake viko huru kusogea hadi sehemu yoyote isiyokaliwa badala ya kuwekewa vikwazo kwa pointi zilizo karibu kama ilivyokuwa katika mchezo uliosalia.';

  @override
  String get piecesAtLeastCount => 'Vipande Angalau';

  @override
  String get hasDiagonalLines => 'Mistari ya diagonal';

  @override
  String get hasDiagonalLines_Detail =>
      'Ongeza mistari minne ya diagonal kwenye ubao.';

  @override
  String get isDefenderMoveFirst => 'Mchezaji wa pili anasonga kwanza';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Mchezaji ambaye anasonga pili katika awamu ya kuweka anasonga kwanza katika awamu ya kusonga.';

  @override
  String get mayRemoveMultiple => 'Kuondoa nyingi';

  @override
  String get mayRemoveMultiple_Detail =>
      'Ikiwa mchezaji atafunga zaidi ya kinu kimoja mara moja, ataondoa idadi ya vinu alizofunga.';

  @override
  String get mayRemoveFromMillsAlways => 'Kuharibu mill';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Kwa chaguo-msingi, wachezaji lazima waondoe vipande vingine kwanza kabla ya kuondoa kipande kutoka kwa kinu kilichoundwa. Washa chaguo hili ili kuzima kizuizi.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Mchezaji wa pili hupoteza wakati ubao umejaa';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Wakati ubao umejaa mwishoni mwa awamu ya kuweka, upande unaoweka kwanza hupoteza mchezo. Vinginevyo, mchezo ni sare.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Kupoteza wakati hakuna hatua za kisheria';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Mchezaji atapoteza ikiwa mpinzani wake atawazuia ili wasiweze kuhamishwa. Badilisha upande ili kusogeza ikiwa chaguo hili limezimwa.';

  @override
  String get mayFly => 'Kuruka';

  @override
  String get mayFly_Detail =>
      'Ikiwa mchezaji ana vipande vitatu au vinne tu (vinavyoweza kusanidiwa) vilivyosalia, anaweza kusogeza kipande hicho hadi sehemu yoyote ya bure.';

  @override
  String get nMoveRule => 'Sheria ya N-hamisha';

  @override
  String get nMoveRule_Detail =>
      'Mchezo huchorwa ikiwa hakuna kuondolewa katika idadi mahususi ya hatua.';

  @override
  String get rollback => 'Rudisha nyuma';

  @override
  String get pleaseSelect => 'Tafadhali chagua';

  @override
  String get copy => 'Nakili';

  @override
  String get moveHistoryCopied =>
      'Hamisha historia iliyonakiliwa kwenye ubao wa kunakili.';

  @override
  String get help => 'Msaada';

  @override
  String get feedback => 'Maoni';

  @override
  String get exit => 'Utgång';

  @override
  String get ruleSettings => 'Kanuni';

  @override
  String get color => 'Rangi';

  @override
  String get boardColor => 'Rangi ya bodi';

  @override
  String get pieceColor => 'Rangi ya kipande';

  @override
  String get backgroundColor => 'Rangi ya usuli';

  @override
  String get lineColor => 'Rangi ya mstari wa bodi';

  @override
  String get whitePieceColor => 'Mchezaji kipande 1 cha rangi';

  @override
  String get blackPieceColor => 'Mchezaji 2 kipande rangi';

  @override
  String get messageColor => 'Rangi ya ujumbe';

  @override
  String get isPieceCountInHandShown => 'Onyesha idadi ya vipande visivyowekwa';

  @override
  String get isNotationsShown => 'Onyesha vidokezo kwenye ubao';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Onyesha upau wa vidhibiti wa urambazaji wa historia';

  @override
  String get display => 'Onyesho';

  @override
  String get boardBorderLineWidth => 'Upana wa mpaka wa bodi';

  @override
  String get boardInnerLineWidth => 'Upana wa mstari wa ndani wa bodi';

  @override
  String get pieceWidth => 'Upana wa kipande';

  @override
  String get fontSize => 'Ukubwa wa herufi';

  @override
  String get standardNotation => 'Nukuu ya WMD';

  @override
  String get restore => 'Rejesha';

  @override
  String get restoreDefaultSettings => 'Rejesha mipangilio chaguo-msingi';

  @override
  String pick(Object element) {
    return 'Chagua $element';
  }

  @override
  String get info => 'Habari';

  @override
  String get hint => 'Kidokezo';

  @override
  String get player => 'mchezaji';

  @override
  String get player1 => 'Mchezaji 1';

  @override
  String get player2 => 'Mchezaji 2';

  @override
  String get howToPlay => 'Jinsi ya kucheza';

  @override
  String get toPlacePiece =>
      'Gonga kwenye sehemu yoyote inayopatikana ili kuweka kipande.';

  @override
  String get toSelectPiece => 'Gonga kwenye kipande ili kuisogeza.';

  @override
  String get toMovePiece =>
      'Gonga kwenye sehemu iliyounganishwa na kipande ili kuisogeza.';

  @override
  String get toRemovePiece =>
      'Gonga kwenye kipande kimoja cha mpinzani ili kuondoa.';

  @override
  String get needToCreateMillFirst =>
      'Unahitaji kuunda kinu kwanza kabla ya kuondoa kipande.';

  @override
  String get needToPlayWithOwnPieces => 'Unahitaji kucheza na vipande vyako.';

  @override
  String get statistics => 'Takwimu';

  @override
  String get totalGames => 'Jumla ya michezo';

  @override
  String get results => 'Matokeo';

  @override
  String get left => 'kushoto';

  @override
  String get privacyPolicy => 'Sera ya Faragha';

  @override
  String get privacyPolicy_Detail_1 =>
      'Tafadhali soma kwa makini na uhakikishe kuwa unaelewa kikamilifu na kukubaliana na hili ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Ikiwa hukubaliani na Sera hii, tafadhali usitumie programu hii. Kutumia programu kunamaanisha kuwa unakubali sheria na masharti haya.';

  @override
  String get and => ' na ';

  @override
  String get accept => 'Kubali';

  @override
  String get takeBack => 'Rudisha';

  @override
  String get takingBack => 'Inarejesha…';

  @override
  String get waiting => 'Inasubiri…';

  @override
  String get stepForward => 'Piga hatua mbele';

  @override
  String get takeBackAll => 'Rudisha yote';

  @override
  String get stepForwardAll => 'Songa mbele wote';

  @override
  String get moveNow => 'Sogeza sasa';

  @override
  String get done => 'Imekamilika.';

  @override
  String get crackMill => 'Kinu cha ufa';

  @override
  String get crackMill_Detail =>
      'Ikiwa mchezaji ana vipande tu kwenye vinu, vipande kwenye vinu havitafungwa ili kuondoa.';

  @override
  String get animationDuration => 'Muda wa uhuishaji';

  @override
  String get none => 'Hakuna';

  @override
  String get theme => 'Mada';

  @override
  String get helpContent =>
      'Mchezo unalenga kumwacha mpinzani na vipande vichache vya tatu au bila hatua za kisheria.\n\nMchezo huchorwa kiotomatiki ikiwa nafasi itatokea kwa mara ya tatu au haitoi kuondolewa katika hatua 100 za mwisho (zinazoweza kusanidiwa).\n\nMchezo unaendelea katika awamu tatu:\n\n1. Kuweka vipande kwenye pointi zilizo wazi\n2. Vipande vya kusonga kwa pointi za karibu\n3. (awamu ya hiari) Kusogeza vipande hadi sehemu yoyote iliyo wazi wakati wa kupunguza mchezaji hadi vipande vitatu\n\nKuweka\n\nMchezo huanza na bodi tupu, ambayo ina gridi ya taifa yenye pointi ishirini na nne. Wachezaji hubadilishana kuweka vipande vyao kwenye pointi zilizo wazi hadi kila mchezaji aweke vipande vyote ubaoni. Ikiwa mchezaji anaweza kuweka vipande vyake vitatu sawa, ana \"kinu\" na anaweza kuondoa moja ya vipande vya mpinzani wake kwenye ubao.\n\nKatika sheria zingine, wachezaji lazima waondoe vipande vingine kwanza kabla ya kuondoa kipande kutoka kwa kinu kilichoundwa.\n\nHuwezi kuweka vipande kwa pointi za vipande vilivyoondolewa tena katika awamu ya kuweka katika baadhi ya sheria.\n\nMara baada ya kutumia vipande vyote, wachezaji huchukua zamu kusonga.\n\nKusonga\n\nIli kusogea, mchezaji husogeza kipande chake kimoja kwenye mstari wa ubao hadi sehemu iliyo wazi karibu. Ikiwa hawezi kufanya hivyo, amepoteza mchezo. Mchezaji anayepanga vipande vyake vitatu kwenye mstari wa ubao ana kinu na anaweza kuondoa kipande kimoja cha mpinzani wake kama katika awamu ya kuweka. Mchezaji yeyote hupunguza vipande viwili, hana chaguo kuunda mills mpya, na hivyo kupoteza mchezo. Mchezaji pia anaweza kupoteza zaidi ya vipande vitatu ikiwa mpinzani wake atavizuia kusonga mbele.\n\nKuruka\n\nKatika baadhi ya vipengele vya sheria, mara mchezaji anapobakisha vipande vitatu pekee, vipande vyake vinaweza kuruka, kurukaruka, au kuruka hadi pointi zozote zilizo wazi, si zile zilizo karibu pekee.\n';

  @override
  String get versionInfo => 'Maelezo ya toleo';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Leseni';

  @override
  String get sourceCode => 'Msimbo wa chanzo';

  @override
  String get appVersion => 'Toleo la Programu';

  @override
  String get general => 'Mkuu';

  @override
  String get advanced => 'Iliyoendelea';

  @override
  String get placing => 'Kuweka';

  @override
  String get moving => 'Kusonga';

  @override
  String get removing => 'Inaondoa';

  @override
  String get gameOverCondition => 'Mchezo juu ya hali';

  @override
  String get aisPlayStyle => 'Mtindo wa kucheza wa AI';

  @override
  String get passive => 'Pasipo';

  @override
  String get timeout => 'Muda umeisha';

  @override
  String get appearance => 'Mwonekano';

  @override
  String get drawOnHumanExperience => 'Chora uzoefu wa mwanadamu';

  @override
  String get considerMobility => 'Fikiria uhamaji wa vipande';

  @override
  String get pieceCount => 'Idadi ya vipande:';

  @override
  String inHand(Object player, int count) {
    return '$player mkononi: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player kwenye bodi: $count';
  }

  @override
  String get boardTop => 'Uwekaji wa bodi kutoka juu';

  @override
  String get notAIsTurn => 'Sio zamu ya AI.';

  @override
  String get aiIsNotThinking => 'AI haifikirii.';

  @override
  String get atEnd => 'Uko mwisho wa orodha ya hoja.';

  @override
  String get tapBackAgainToLeave => 'Gusa tena ili kuondoka.';

  @override
  String get more => 'Zaidi';

  @override
  String get experimental => 'Ni kipengele cha majaribio.';

  @override
  String get experiments => 'Majaribio';

  @override
  String get ossLicenses => 'Leseni za chanzo huria';

  @override
  String get language => 'Lugha';

  @override
  String get defaultLanguage => 'Lugha chaguomsingi';

  @override
  String get mayMoveInPlacingPhase =>
      'Vipande vinaweza kusonga katika awamu ya kuweka';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Hakuna awamu tofauti za kuweka na kusongesha, yaani, wachezaji wanaweza kuamua katika kila hatua ikiwa wanataka kuweka kipande kwenye ubao au kusogeza kipande chao kimoja (ilimradi wana vipande vilivyobaki mahali).';

  @override
  String get drawerColor => 'Rangi ya menyu';

  @override
  String get drawerTextColor => 'Rangi ya maandishi ya menyu';

  @override
  String get drawerHighlightItemColor =>
      'Rangi ya kipengee cha kuangazia kwenye menyu';

  @override
  String get mainToolbarBackgroundColor =>
      'Rangi ya mandharinyuma ya upau wa vidhibiti';

  @override
  String get mainToolbarIconColor => 'Rangi ya ikoni ya upau wa vidhibiti kuu';

  @override
  String get navigationToolbarBackgroundColor =>
      'Rangi ya mandharinyuma ya upau wa vidhibiti wa kusogeza';

  @override
  String get navigationToolbarIconColor =>
      'Rangi ya ikoni ya upau wa vidhibiti wa kusogeza';

  @override
  String get autoHideToolbar => 'Ficha upau wa vidhibiti kiotomatiki';

  @override
  String get toolbarLocationOnScreen =>
      'Mahali pa upau wa vidhibiti kwenye skrini';

  @override
  String get top => 'Juu';

  @override
  String get bottom => 'Chini';

  @override
  String get center => 'Kituo';

  @override
  String get solidColor => 'Rangi imara';

  @override
  String get picture => 'Picha';

  @override
  String get chooseYourPicture => 'Chagua picha yako';

  @override
  String get light => 'Mwanga';

  @override
  String get dark => 'Giza';

  @override
  String get themes => 'Mada';

  @override
  String get currentTheme => 'Mandhari ya sasa';

  @override
  String get saveTheme => 'Hifadhi mandhari';

  @override
  String get showAnalysisGraph => 'Onyesha grafu ya uchanganuzi';

  @override
  String get analysis => 'Uchambuzi';

  @override
  String get saveGame => 'Hifadhi mchezo';

  @override
  String get loadGame => 'Pakia mchezo';

  @override
  String get setupPosition => 'Weka Nafasi';

  @override
  String get showLegalMoves => 'Onyesha hatua za kisheria';

  @override
  String get showLastMove => 'Onyesha hatua ya mwisho';

  @override
  String get showArrows => 'Onyesha mishale';

  @override
  String get pieces => 'Vipande';

  @override
  String get showAnalysis => 'Onyesha uchanganuzi';

  @override
  String get threads => 'Mizizi';

  @override
  String get getInvolved => 'Jihusishe';

  @override
  String get helpImproveTranslate => 'Saidia kuboresha utafsiri';

  @override
  String get tutorial => 'Mafunzo';

  @override
  String get classicMill => 'Classic Mill';

  @override
  String get mixedMill => 'Kinu Mchanganyiko';

  @override
  String get ceylonMill => 'Kinu cha Ceylon';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Kinu kinaweza kuvunjika na kufanywa upya mara kwa mara';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Mchezaji akivunja kinu ili kuunda kinu kipya mara moja, mchezaji kama huyo anaweza kurudisha kipande hicho kwenye makutano ya awali katika hatua yake inayofuata ikiwa atafanya kinu kipya.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Mchezo huchorwa ikiwa mchezaji ana vipande vitatu na baada ya hatua kumi hakuna mchezaji anayeondoa vipande vya mpinzani';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Wakati mchezaji yuko chini ya vipande vitatu, na hakuna mchezaji anayeweza kuondoa kipande cha mpinzani ndani ya hatua kumi, mchezo ni sare.';

  @override
  String get close => 'Funga';

  @override
  String get whitePiece => 'Kipande nyeupe';

  @override
  String get blackPiece => 'Kipande nyeusi';

  @override
  String get emptyPoint => 'Pointi tupu';

  @override
  String get noPoint => 'Hakuna maana';

  @override
  String get placingPhase => 'Kuweka awamu';

  @override
  String get movingPhase => 'Awamu ya kusonga';

  @override
  String get flyingPhase => 'Awamu ya kuruka';

  @override
  String sideToMove(Object player) {
    return 'Upande wa kusonga: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Hatua ya mwisho: $move';
  }

  @override
  String get selected => 'Imechaguliwa';

  @override
  String get accessibility => 'Ufikivu';

  @override
  String get screenReaderSupport => 'Usaidizi wa kisomaji skrini';

  @override
  String get isDraw => 'Ni Droo!';

  @override
  String get draw => 'Chora';

  @override
  String get pieceHighlightColor => 'Rangi ya kuangazia kipande';

  @override
  String get algorithm => 'Algorithmi';

  @override
  String get endgameNMoveRule => 'Mwisho wa mchezo sheria ya N-Move';

  @override
  String get endgameNMoveRule_Detail =>
      'Mchezo utachorwa ikiwa mchezaji yeyote ana vipande vitatu pekee na hakuna mchezaji anayeondoa kipande ndani ya miondoko mahususi.';

  @override
  String get drawReasonEndgameRule50 =>
      'Mchezaji yeyote ana vipande vitatu pekee, na hakuna mchezaji anayeondoa kipande ndani ya hatua maalum.';

  @override
  String get threefoldRepetitionRule => 'Kanuni ya kurudia mara tatu';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Mchezo hutolewa ikiwa nafasi itatokea kwa mara ya tatu.';

  @override
  String get continueToMakeMove => 'Kinu! Endelea kupiga hatua.';

  @override
  String get pointStyle => 'Mtindo wa uhakika';

  @override
  String get pointWidth => 'Upana wa pointi';

  @override
  String get solid => 'Imara';

  @override
  String get hollow => 'Utupu';

  @override
  String get languageName => 'Kiswahili';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Moves',
      one: '$count Sogeza',
      zero: 'Move',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Imeshindwa kupakia.';

  @override
  String get filename => 'Jina la faili';

  @override
  String get browse => 'Vinjari…';

  @override
  String get gameFiles => 'Faili za mchezo';

  @override
  String get gameSavedTo => 'Mchezo umehifadhiwa kwa';

  @override
  String get empty => 'Tupu';

  @override
  String get noMove => 'Hakuna hoja.';

  @override
  String get restoredPosition => 'Nafasi ya awali iliyorejeshwa.';

  @override
  String get clean => 'Safi';

  @override
  String get cleanedUp => 'Imesafishwa.';

  @override
  String get remove => 'Ondoa';

  @override
  String get noPiecesCanBeRemoved => 'Hakuna vipande vinaweza kuondolewa.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count vipande',
      one: '$count kipande',
      zero: 'Kipande',
    );
    return '$_temp0 vinahitaji kuondolewa.';
  }

  @override
  String placedCount(int count) {
    return 'Iliyow. ($count)';
  }

  @override
  String get placedPieceCount =>
      'Imewekwa kuhesabu kipande katika awamu ya kuweka.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Mchezaji wa sasa ameweka vipande vya $count.';
  }

  @override
  String get notPlacingPhase => 'Sio kuweka awamu, haiwezi kuibadilisha.';

  @override
  String get paste => 'Bandika';

  @override
  String get pasteDone => 'Kuweka ni kufanyika.';

  @override
  String get cannotPaste => 'Haiwezi kubandika.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Onyesha vipande visivyowekwa na vilivyoondolewa';

  @override
  String get fullScreen => 'Skrini nzima';

  @override
  String get reopenToTakeEffect =>
      'Ondoka na ufungue tena programu ili mipangilio ianze kutumika.';

  @override
  String get forest => 'Msitu';

  @override
  String get desktopImage => 'Picha ya Eneo-kazi';

  @override
  String get invalidPosition => 'Nafasi batili.';

  @override
  String get shareGIF => 'Shiriki GIF';

  @override
  String get pixelRatio => 'Uwiano wa pixel';

  @override
  String get duration => 'Muda';

  @override
  String get gameScreenRecorder => 'Kinasa skrini cha mchezo';

  @override
  String get previous => 'Iliyotangulia';

  @override
  String get next => 'Inayofuata';

  @override
  String get skip => 'Ruka';

  @override
  String get gotIt => 'Nimeelewa';

  @override
  String get youCanModifyRules =>
      'Unaweza kurekebisha sheria za mchezo katika mipangilio ya sheria.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Unaweza kutumia gurudumu la kipanya kubadilisha thamani katika kiteuzi.';

  @override
  String get noTimeLimitForThinking =>
      'Muda wa Kufikiri wa AI umewekwa kuwa 0 inamaanisha hakuna kikomo cha muda cha kufikiria.';

  @override
  String get whatIsMtdf =>
      'MTD(f) ni aina iliyorekebishwa ya algoriti ya utafutaji ya alpha-beta ambayo inalenga kuboresha ufanisi kwa kutumia tena matokeo ya kati ya utafutaji na kutumia ubashiri mzuri wa awali ili kupunguza nafasi ya utafutaji.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Tafadhali kumbuka kuwa marekebisho ya muda wa kufikiria ya AI huenda sio sahihi kabisa. Muda halisi wa kufikiria unaweza kuwa mfupi zaidi wakati kiwango cha ugumu kimepunguzwa na kinaweza kuwa kirefu zaidi wakati AI iko katikati ya mawazo wakati muda unakwisha.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Ukiweka kiwango cha ugumu juu lakini usiongeze muda wa kufikiri wa AI, kiwango cha ugumu halisi kinaweza kuwa mdogo kwa thamani ya chini kutokana na kikwazo cha muda wa kufikiri. Thamani halisi inaweza kutofautiana kulingana na utendaji wa mashine.';

  @override
  String get whatIsPvs =>
      'PVS (Utafutaji wa Tofauti kuu) ni algorithm ya utafutaji ili kupata hoja bora katika nafasi fulani. Ni uboreshaji wa algoriti ya alpha-beta na hutumia utafutaji wa dirisha tupu au sufuri kuthibitisha kuwa hatua ni mbaya zaidi au si mbaya zaidi kuliko alama salama tayari kutoka kwa tofauti kuu. PVS inazingatia hatua za kuahidi zaidi na huepuka utafutaji usio wa lazima wa matawi ya chini, ambayo husaidia kuboresha ufanisi wa utafutaji.';

  @override
  String get whatIsAlphaBeta =>
      'Alpha-beta algoriti ni kanuni ya utafutaji ili kupata hatua bora zaidi. Inatumia kanuni ya kiwango cha chini na maadili mawili, alfa na beta, kukata mti wa utafutaji na kuongeza ufanisi. Alpha inawakilisha alama ya chini ambayo kompyuta ina uhakika inaweza kupata, wakati beta inawakilisha alama ya juu ambayo mpinzani wake anaweza kupata. Kanuni husaidia kompyuta kufanya maamuzi mahiri na yenye ufanisi katika mchezo.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Kulingana na uzoefu wa kibinadamu, ukijaribu kushinda, utapoteza. Badala yake, lenga sare kama lengo lako na uepuke kupoteza mchezo. Angalia mpinzani wako na uwarubuni kwa upole katika nafasi ambayo wanaweza kufanya makosa. Wanapoonyesha udhaifu, chukua fursa hiyo na ushinike kwa upole ushindi. Kwa njia hii, unaweza kushinda mchezo.';

  @override
  String get firstMoveDetail =>
      'Katika mchezo huu, ni rahisi kwa mchezaji wa pili kushinda ikilinganishwa na mchezaji wa kwanza.';

  @override
  String get passiveDetail =>
      'Kuwezesha chaguo la Passive kutasababisha AI kupumzika wakati ina faida katika nafasi, badala ya kujaribu kwa ukali kushinda haraka iwezekanavyo.';

  @override
  String get moveRandomlyDetail =>
      'Kuwasha chaguo hili huongeza unasibu na furaha ya mchezo huku ukizima kunaweza kusaidia kujifunza njia za kushinda AI.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Ikiwa AI inazingatia uhamaji wa vipande vyake, haitalenga tu kukamata vipande vya mpinzani haraka iwezekanavyo, lakini pia kuzingatia kuzuia harakati za mpinzani na kuwazuia kufanya hivyo.';

  @override
  String get whenBoardIsFull => 'Wakati bodi imejaa';

  @override
  String get whenBoardIsFull_Detail =>
      'Mwishoni mwa awamu ya kuweka, kabla ya awamu ya kusonga huanza, hatua inafuata ikiwa bodi imejaa vipande.';

  @override
  String get sideToMoveRemovePiece =>
      'Mchezaji anayesonga kwanza katika hatua ya kusonga huondoa moja ya vipande vya mpinzani.';

  @override
  String get agreeToDraw => 'Pande zote mbili zinakubali kutoka sare.';

  @override
  String get takeOpponentsPiece => 'Chukua moja ya vipande vya mpinzani wako.';

  @override
  String get firstPlayerLose => 'Mchezaji wa kwanza anapoteza mchezo.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Wachezaji wa kwanza na wa pili huondoa moja ya vipande vya mpinzani.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Wachezaji wa pili na wa kwanza huondoa moja ya vipande vya mpinzani.';

  @override
  String get enteredFlyingPhase =>
      'Sasa imeingia kwenye awamu ya kuruka, vipande vya mpinzani vinaweza kuruka kwenye sehemu yoyote tupu kwenye ubao. Unaweza kuzima utawala wa kuruka katika \"Mipangilio ya Kanuni\".';

  @override
  String get whenStalemate => 'Wakati mkwamo';

  @override
  String get whenStalemate_Detail =>
      'Ni hatua gani hufuata wakati hakuna kipande kinachoweza kusongeshwa?';

  @override
  String get endWithStalemateLoss =>
      'Maliza kwa hasara iliyosimama kwa upande ambao umezuiwa.';

  @override
  String get changeSideToMove => 'Badilisha upande ili kusonga.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Ondoa moja ya vipande vya mpinzani na ufanye hatua inayofuata.';

  @override
  String get endWithStalemateDraw => 'Malizia kwa sare ya bila kufungana.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Ondoa moja ya vipande vya mpinzani na ubadilishe upande wa kusonga.';

  @override
  String get aiResponseDelayTime => 'Wakati wa kuchelewa kwa majibu ya AI';

  @override
  String get aiIsDelaying =>
      'AI kwa sasa iko katika awamu ya majibu iliyochelewa. Tafadhali subiri kwa muda kabla ya kuendelea.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Huwezi kuondoa kipande kisicho karibu.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Ikiwa kukwama, vipande vya mpinzani karibu na yako vinaweza kuondolewa, bila kujali uundaji wa kinu.';

  @override
  String get whatIsMcts =>
      'MCTS ni algoriti ambayo ni rahisi kuanza ambayo hufanya maamuzi kwa kuchunguza na kutathmini hatua mbalimbali kupitia uigaji.';

  @override
  String get goldenJade => 'Jade ya dhahabu';

  @override
  String get forestWood => 'Msitu wa Miti';

  @override
  String get darkMystery => 'Siri ya Giza';

  @override
  String get midnightBlue => 'Usiku wa manane Bluu';

  @override
  String get greenForest => 'Msitu wa Kijani';

  @override
  String get greenMeadow => 'Green Meadow';

  @override
  String get stonyPath => 'Njia ya Mawe';

  @override
  String get pastelPink => 'Rangi ya Pastel';

  @override
  String get turquoiseSea => 'Bahari ya Turquoise';

  @override
  String get violetDream => 'Ndoto ya Violet';

  @override
  String get mintChocolate => 'Chokoleti ya Mint';

  @override
  String get skyBlue => 'Bluu ya Anga';

  @override
  String get playfulGarden => 'Bustani ya kucheza';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Kanuni ya Uchanganuzi wa Retrograde hutumia uchanganuzi wa urejeshaji wa thamani nyingi ili kuunda hifadhidata ya mchezo wa mwisho kutoka nafasi tofauti za kuanza, kisha hutumia hifadhidata hii ili kuboresha uchezaji wa mchezo. Mbinu hii iko chini ya kategoria ya Suluhu zenye Nguvu Zaidi.';

  @override
  String get viewAlgorithmGuide =>
      'Je, ungependa kuona mwongozo wa mtumiaji wa kanuni hii?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Onyesha kiashiria cha faida ya nafasi';

  @override
  String get usePerfectDatabase => 'Tumia hifadhidata kamili';

  @override
  String get perfectDatabaseDescription =>
      'Washa chaguo hili ili kutumia hifadhidata isiyo na dosari ya mchezo inayozalishwa kupitia kanuni za kisasa. Kipengele hiki huunganisha mikakati ya kufungua na ya mwisho ili kupendekeza hatua bora. Hili ndilo chaguo linalopendelewa kwa wachezaji wanaotafuta kiwango cha juu cha usahihi katika uchezaji. Imeundwa kupitia mbinu za kimakinifu za kukokotoa, hifadhidata imeundwa ili kutoa suluhu zilizo karibu kabisa za mchezo.\n\nKumbuka: Iwapo AI itashindwa kufikia hifadhidata, itageuka kuwa kanuni za kawaida za maamuzi ya uchezaji mchezo. Hifadhidata inapopatikana, \'Kiwango cha Ugumu\' huwa kisichoweza kushindwa, na \'Wakati wa Kufikiria wa AI\' hupunguzwa sana. Mipangilio mingi ndani ya chaguo za \'AI\'s play style\' itabatilishwa, kwa kuwa matokeo ya hifadhidata yana kipaumbele cha juu zaidi.\n\nKwa mwongozo wa jinsi ya kufaidika zaidi na hifadhidata hii isiyo na dosari, bofya hapa.';

  @override
  String get backgroundImage => 'Picha ya nyuma';

  @override
  String get whatIsRandom =>
      'Wakati chaguo la \'Tumia hifadhidata kamili\' halijawashwa, mpangilio wa \'Nasibu\' husababisha AI kusogeza vipande bila mpangilio bila kutumia kanuni zozote za uteuzi wa kusogeza. Hii kwa kawaida husababisha uchezaji dhaifu zaidi. Kinyume chake, \'Tumia hifadhidata kamili\' inapowezeshwa, AI hutegemea pekee \'Hifadhi Database Kamili\' kwa kufanya maamuzi, badala ya kuichanganya na algoriti za jadi za AI. Katika hali hii, hatua za AI zinategemea kabisa maudhui ya hifadhidata, ikiepuka kutegemea hesabu za wakati halisi au algoriti za utafutaji.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Ondoa kipande/vipande vya mpinzani kutoka mkononi mwake; kisha ni zamu ya mpinzani kuweka kipande.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Wakati wa kuunda vinu (mills) wakati wa awamu ya kuweka';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Ondoa kipande/vipande vya mpinzani kutoka kwenye ubao.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Ondoa kipande/vipande vya mpinzani kutoka kwenye ubao; kisha ni zamu ya mpinzani kuweka kipande.';

  @override
  String get opponentRemovesOwnPiece =>
      'Mpinzani anaondoa kipande/vipande vyake kutoka kwenye ubao.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Badala ya wewe kuchukua hatua, mpinzani anachagua na kuondoa kipande/vipande vyake kutoka kwenye ubao, kwa hivyo anachukua hatua ambayo ni mbaya kwake.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Ondoa kipande/vipande vya mpinzani kutoka mkononi mwake; kisha ni zamu yako kucheza.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Ondoa kipande/vipande kutoka mkononi mwa mpinzani. Ikiwa, kulingana na mipangilio ya kuondoa vipande vingi, vipande vingi vitaondolewa na mpinzani hana vipande vilivyosalia mkononi, endelea kuondoa vipande vya mpinzani kutoka kwenye ubao. Kisha, ni zamu yako kucheza. Ukiendelea kuunda vinu, unaweza kuendelea kuondoa vipande vya mpinzani.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Ondoa kipande/vipande kutoka mkononi mwa mpinzani. Ikiwa, kulingana na mipangilio ya kuondoa vipande vingi, vipande vingi vitaondolewa na mpinzani hana vipande vilivyosalia mkononi, endelea kuondoa vipande vya mpinzani kutoka kwenye ubao. Kisha, ni zamu ya mpinzani kucheza.';

  @override
  String get markAndDelayRemovingPieces =>
      'Weka alama na chelewesha kuondoa vipande.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Wakati wa awamu ya kuweka, vipande vya kuondolewa vinawekwa alama, na kwa wachezaji wote wawili, hakuna vipande vipya vinavyoweza kuwekwa kwenye pointi hizi. Baada ya kuingia katika awamu ya kusonga, vipande hivi vilivyo na alama huondolewa kabisa, na wachezaji wanaweza kuhamisha vipande vyao kwenye pointi hizi ambazo sasa ziko wazi.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Hatua zinazoweza kuchukuliwa wakati wa kuunda viwanda wakati wa hatua ya kuweka.';

  @override
  String get marked => 'Imewekwa alama';

  @override
  String get menu => 'Menyu';

  @override
  String get monochrome => 'Monokromu';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Unaweza kuwasha msaada wa kisomaji skrini katika mipangilio ya Ufikiaji chini ya Mipangilio ya Jumla.';

  @override
  String get showNumbersOnPieces => 'Onyesha nambari kwenye vipande';

  @override
  String get saveImage => 'Hifadhi Picha';

  @override
  String get isAnalysisToolbarShown => 'Onyesha upau wa zana za uchambuzi';

  @override
  String get analysisToolbarBackgroundColor =>
      'Rangi ya asili ya upau wa zana za uchambuzi';

  @override
  String get analysisToolbarIconColor =>
      'Rangi ya ikoni ya upau wa zana za uchambuzi';

  @override
  String get transformed => 'Imebadilishwa.';

  @override
  String get cannotTransform => 'Haiwezi kubadilishwa.';

  @override
  String get rotate => 'Pindua';

  @override
  String get horizontalFlip => 'Pind. M.';

  @override
  String get verticalFlip => 'Pind. W.';

  @override
  String get innerOuterFlip => 'Pind. N/NJE';

  @override
  String get transparentCanvas => 'Kitambaa Kipitishi';

  @override
  String get restrictRepeatedMillsFormation =>
      'Zuia uundaji wa kinu cha kusaga';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Kipande kilichohamishwa kutoka kinu kimoja kwenda kingine hakiwezi kurudi mara moja kwenye nukta ya awali katika zamu inayofuata ili kuunda kinu tena. Hatua tofauti inahitajika kwanza.';

  @override
  String get oneTimeUseMill => 'Kinu cha matumizi ya mara moja';

  @override
  String get oneTimeUseMill_Detail =>
      'Kila kinu kinaweza kuondoa kipande cha mpinzani mara moja tu. Unaweza kuunda tena, lakini hakiwezi kutumika kwa kuondolewa zaidi.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Sheria za sasa ambazo umeweka hazina hifadhidata kamilifu inayolingana. Kwa habari zaidi kuhusu hifadhidata kamilifu, tafadhali bonyeza hapa.';

  @override
  String get focusOnBlockingPaths => 'Kuzingatia kuzuia njia';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Panga kipaumbele kuzuia harakati za mpinzani badala ya kuunda mils. Badala ya kuzingatia kuondoa vipande kwa kumaliza mils, AI inalenga kumtega mpinzani, kumzuia asiweze kusonga na kuhakikisha ushindi kupitia uchovu badala ya mchezo wa fujo. Mkakati huu hauzuii mils ya mpinzani kwa nguvu.';

  @override
  String get pieceImage => 'Picha ya kipande';

  @override
  String get importColorSettings => 'Ingiza mipangilio ya rangi';

  @override
  String get exportColorSettings => 'Hamisha mipangilio ya rangi';

  @override
  String get import => 'Ingiza';

  @override
  String get export => 'Hamisha';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Tafadhali nakili mipangilio ya umbizo la JSON kwenye ubao wa kunakili kwanza.';

  @override
  String get copiedToClipboard => 'Imenakiliwa kwenye ubao wa kunakili.';

  @override
  String get imported => 'Imeingizwa.';

  @override
  String get boardImage => 'Picha ya bodi';

  @override
  String get autumnLeaves => 'Majani ya Majira ya Kuanguka';

  @override
  String get legendaryLand => 'Ardhi ya Kihistoria';

  @override
  String get vignetteEffect => 'Athari ya vignette';

  @override
  String get promptMakeToolbarTransparent =>
      'Je, ungependa kufanya ukanda wa zana kuwa wa uwazi kabisa wakati picha ya mandharinyuma ya bodi imewekwa?';

  @override
  String get vibration => 'Wezesha mtetemo kwenye mchezo';

  @override
  String get soundTheme => 'Mandhari ya sauti';

  @override
  String get ball => 'Mpira';

  @override
  String get liquid => 'Kiasi';

  @override
  String get wood => 'Mbao';

  @override
  String get placeEffectAnimation => 'Athari ya uhuishaji wa kuweka kipande';

  @override
  String get removeEffectAnimation => 'Athari ya uhuishaji wa kuondoa kipande';

  @override
  String get isToolbarAtBottom => 'Onyesha upau wa zana chini';

  @override
  String get boardCornerRadius => 'Radius ya kona ya ubao';

  @override
  String get useOpeningBook => 'Tumia kitabu cha ufunguzi';

  @override
  String get currentRule => 'Sasa';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Seti ya sheria';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Ruhusu AI kutumia hatua za ufunguzi zinazotumiwa kawaida na wachezaji wa kibinadamu wa kitaalamu katika mchezo wa mapema. Kumbuka: Kipengele hiki kwa sasa kinapatikana tu kwa seti maalum za sheria.';

  @override
  String get showAdvantageGraph => 'Onyesha grafu ya faida';

  @override
  String get advantageGraphHint =>
      'Grafu ya faida itachorwa tu baada ya AI kufanya hatua. Haitachorwa wakati mchezaji mwanadamu anafanya hatua.';

  @override
  String get removalBasedOnMillCounts =>
      'Zima uondoaji hadi vipande vyote viwekwe. Wachezaji huondoa vipande kulingana na idadi ya vinu walivyounda.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Zima uondoaji hadi vipande vyote viwekwe. Wachezaji huondoa vipande kulingana na idadi ya vinu: ikiwa ni sawa, wote huondoa idadi sawa ya vipande; ikiwa mmoja ana zaidi, anaondoa kipande kimoja cha ziada, akidumisha tofauti ya kipande kimoja. Ikiwa ni mchezaji mmoja tu anayebuni kinu, anaondoa vipande viwili huku mwingine akiondoa kimoja. Ikiwa hakuna anayebuni kinu, wote huondoa kipande kimoja.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Chagua moja ya vipande vyako.';

  @override
  String get notYourTurn => 'Sio zamu yako.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Rangi ya asili ya ubao wa maelezo';

  @override
  String get annotationToolbarIconColor => 'Rangi ya alama ya ubao wa maelezo';

  @override
  String get isAnnotationToolbarShown => 'Onyesha ubao wa maelezo';

  @override
  String get enterAnnotationMode => 'Ingia kwenye hali ya maelezo';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Una hakika unataka kufuta maelezo yote?';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM kuchochea imenakiliwa kwenye ubao wa kunakili.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Muunganisho umekataliwa, server huenda imeshuka.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Ugunduzi umefanikiwa, subiri muunganisho...';

  @override
  String get noLanConnection => 'Hakuna muunganisho wa LAN';

  @override
  String get takeScreenshot => 'Piga picha ya skrini';

  @override
  String get disconnectedFromOpponent => 'Imekatishwa na mpinzani.';

  @override
  String get takeBackRequest => 'Omba Kurudisha';

  @override
  String get nothingToShow => 'Hakuna cha kuonyesha.';

  @override
  String get stopHosting => 'Acha Kuandaa';

  @override
  String get connectionResetByPeer =>
      'Muunganisho umeanzishwa upya na mwenzio.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Muunganisho umeisha kwa muda wa moyo. Tafadhali jiunge tena.';

  @override
  String get startHosting => 'Anzisha Uandaa';

  @override
  String get restartRequestRejected => 'Ombi la kuanzisha upya limekataliwa.';

  @override
  String get notConnectedToLanOpponent => 'Haijaunganishwa na mpinzani wa LAN.';

  @override
  String get llmPrompt => 'LLM kuchochea';

  @override
  String get gameRestarted => 'Mchemo umeanzishwa upya.';

  @override
  String get takeBackRejected => 'Kurudisha kimekataliwa.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Una hakika unataka kujiuzulu mchezo huu?';

  @override
  String get opponentResignedYouWin => 'Mpinzani amejiondoa. Umeshinda!';

  @override
  String get clearAllAnnotations => 'Futa maelezo yote';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Imeunganishwa, subiri hatua ya mpinzani...';

  @override
  String get networkStatusDisconnected => 'Hali ya mtandao: Imekatishwa';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Ombi la kurudisha limepelekwa kwa mpinzani.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Mpinzani huenda ameondoka kwenye mchezo';

  @override
  String get connectedToHostSuccessfully =>
      'Imeunganishwa kwa mfanikiwa na mwenyeji.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Muunganisho umeisha: muda wa moyo umeisha';

  @override
  String get noHostDiscovered => 'Hakuna mwenyeji aliyegunduliwa.';

  @override
  String get confirmResignation => 'Thibitisha kujiuzulu';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Imeanza kuandaa mchezo, subiri wachezaji wajiunge...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Muda wa muunganisho umeisha, muunganisho wa mtandao hauna utulivu.';

  @override
  String get noLlmPromptAvailable => 'Hakuna LLM kuchochea inayopatikana.';

  @override
  String get youResignedGameOver => 'Umejiuzulu. Mchezo umekwisha.';

  @override
  String get serverIp => 'IP ya seva';

  @override
  String get confirmClear => 'Thibitisha kufuta';

  @override
  String get opponentSTurn => 'Zamu ya mpinzani.';

  @override
  String get waitingAClientConnection => 'Subiri muunganisho wa mteja...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Ombi la kurudisha limekataliwa au kushindwa.';

  @override
  String get addText => 'Ongeza maandishi';

  @override
  String get exitAnnotationMode => 'Ondoka kwenye hali ya maelezo';

  @override
  String get typeYourAnnotation => 'Chapa maelezo yako';

  @override
  String get attemptingToReconnect => 'Inajaribu kujiunga tena...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Ombi la kuanzisha upya limepelekwa. Subiri majibu ya mpinzani...';

  @override
  String get serverIsStopped => 'Seva imesimamishwa.';

  @override
  String get restartRequest => 'Ombi la kuanzisha upya';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Hauwezi kuomba kurudisha wakati sio zamu yako.';

  @override
  String get takeBackAccepted => 'Kurudisha kimekubaliwa.';

  @override
  String get localNetworkSettings => 'Mipangilio ya mtandao wa ndani';

  @override
  String get reconnectedSuccessfully => 'Imeunganishwa tena kwa mafanikio!';

  @override
  String get failedToSaveImageToGallery =>
      'Imeshindwa kuhifadhi picha kwenye Wasanii.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Mpinzani ameomba kuanzisha upya mchezo. Unakubali?';

  @override
  String get yourTurn => 'Zamu yako.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Haikuweza kujiunga tena, tafadhali anzisha upya mchezo.';

  @override
  String get host => 'Mwenyeji';

  @override
  String get join => 'Jiunge';

  @override
  String get port => 'Bandari';

  @override
  String get invalidIpAddress => 'Anwani ya IP batili.';

  @override
  String get invalidPort => 'Bandari batili.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Kuanzisha muunganisho: Jaribu $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Imeshindwa kujiunga: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Imeshindwa kuanzisha uandaa: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Mwenyeji amegunduliwa: $ip:$port';
  }

  @override
  String get stop => 'Simamisha';

  @override
  String get discover => 'Gundua';

  @override
  String get connect => 'Ungana';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Mteja ameunganishwa: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Inagundua: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Inajiunga tena ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Imeunganishwa';

  @override
  String get delete => 'Futa';

  @override
  String get ancientEgypt => 'Misri ya Kale';

  @override
  String get gothicIce => 'Barafu ya Gothic';

  @override
  String get riceField => 'Shamba la Mchele';

  @override
  String get chinesePorcelain => 'Porceleni ya Kichina';

  @override
  String get desertDusk => 'Jangwa Jioni';

  @override
  String get precisionCraft => 'Ufundi wa Usahihi';

  @override
  String get folkEmbroidery => 'Ushonaji wa Kiafrika';

  @override
  String get carpathianHeritage => 'Utamaduni wa Carpathian';

  @override
  String get imperialGrandeur => 'Ukuu wa Kifalme';

  @override
  String get bohemianCrystal => 'Kioo cha Bohemia';

  @override
  String get savannaSunrise => 'Kuchomoza kwa Jua Savanna';

  @override
  String get harmonyBalance => 'Umoja na Usawaziko';

  @override
  String get cinnamonSpice => 'Viungo vya Mdalasini';

  @override
  String get anatolianMosaic => 'Mozaiki ya Anatolia';

  @override
  String get carnivalSpirit => 'Roho ya Karnivali';

  @override
  String get custom => 'Desturi';

  @override
  String get spiceMarket => 'Soko la viungo';

  @override
  String get swipeToRevealTheDrawer => 'Swipe kufungua droo';

  @override
  String get showGameInfoOnScreenshots =>
      'Onyesha maelezo ya mchezo kwenye picha za skrini';

  @override
  String get humanMoveTime => 'Kikomo cha muda cha binadamu';

  @override
  String get noTimeLimitForHumanMoves =>
      'Hakuna kikomo cha muda kwa hatua za binadamu';

  @override
  String get timeoutLoseWillBeApplied =>
      'Kushindwa kwa muda kutatumika kwa mchezaji binadamu';

  @override
  String get identifyingBoard => 'Inatambua ubao wa mchezo...';

  @override
  String get youCanEnterAnyModelName =>
      'Unaweza kuingiza jina lolote la mfano.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Msimamo wa ubao umetumika. FEN imebandikwa kwenye ubao wa kunakili.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Pendekezo: jaribu kupiga picha wazi zaidi ya ubao.';

  @override
  String get llmPromptTemplate => 'Kiolezo cha ombi la LLM';

  @override
  String get noValidBoardDetected => 'Hakuna ubao halali uliogunduliwa.';

  @override
  String get selectingImageFromAlbum => 'Inachagua picha kutoka albamu...';

  @override
  String get configurePromptTemplate => 'Sanidi kiolezo cha ombi';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Hariri kiolezo cha ombi kwa ajili ya uchambuzi wa LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Imeshindikana kuunda FEN kutoka kwenye ubao uliotambuliwa.';

  @override
  String get outputInCurrentLanguage => 'Matokeo kwa lugha ya sasa';

  @override
  String get commonBaseUrls => 'URL za kawaida za msingi';

  @override
  String get viewCommonModels => 'Angalia mifano ya kawaida';

  @override
  String get recognitionParametersUpdated =>
      'Vigezo vya utambuzi vimeboreshwa.';

  @override
  String get whiteSMove => 'Ni zamu ya mweupe';

  @override
  String get resetToDefaults => 'Rejesha kwa mipangilio ya awali';

  @override
  String get photoShoot => 'Kupiga picha';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Imeshindikana kutumia nafasi ya ubao uliotambuliwa.';

  @override
  String get llmPromptContent => 'Yaliyomo katika ombi la LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM haijasanidiwa. Tafadhali angalia mipangilio yako.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Weka muuzaji, mfano, API Key, na Base URL';

  @override
  String get llmConfiguration => 'Usanidi wa LLM';

  @override
  String get configureLlmProvider => 'Sanidi muuzaji wa LLM';

  @override
  String get llmPromptTemplateHeader => 'Kichwa cha kiolezo cha ombi la LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Hakuna vipande vilivotambuliwa kwenye picha. Tafadhali jaribu tena.';

  @override
  String get recognizeBoardFromImage => 'Tambua ubao kutoka kwenye picha';

  @override
  String get viewTips => 'Tazama vidokezo';

  @override
  String get applyToBoard => 'Tumia kwenye ubao';

  @override
  String get adjustBoardArea => 'Rekebisha eneo la ubao';

  @override
  String get viewCommonUrls => 'Angalia URL za kawaida';

  @override
  String get colorAnalysisFailed => 'Uchanganuzi wa rangi umefeli!';

  @override
  String get analyzingGameBoardImage => 'Inachambua picha ya ubao wa mchezo...';

  @override
  String get selectFromAlbum => 'Chagua kutoka albamu';

  @override
  String get noBoardPointDetected => 'Hakuna alama za ubao zilizoonekana!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Iwapo itaachwa tupu, kiolezo cha kawaida kita tumika';

  @override
  String get llmConfig => 'Usanidi wa LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Una uhakika unataka kurejesha kiolezo cha ombi kwenye thamani za awali?';

  @override
  String get llmPromptTemplateFooter => 'Mwisho wa kiolezo cha ombi la LLM';

  @override
  String get loadingResponse => 'Inapakia majibu...';

  @override
  String get applyThisResultToBoard => 'Tumia matokeo haya kwenye ubao';

  @override
  String get takingPicture => 'Inapiga picha...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Tafadhali chagua picha ya ubao wa mchezo kutambua';

  @override
  String get identificationResults => 'Matokeo ya utambuzi';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Chambua hatua na utoe ufahamu.';

  @override
  String get getApiKey => 'Pata API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Mchakato mzima wa utambuzi haukufaulu kukamilika.';

  @override
  String get boardRecognitionResult => 'Matokeo ya utambuzi wa ubao';

  @override
  String get askLlm => 'Muulize LLM';

  @override
  String get boardDetectionFailed => 'Utambuzi wa ubao umefeli!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Hakuna alama za ubao zilizopatikana, haiwezekani kutambua kipande!';

  @override
  String get copyFen => 'Nakili FEN';

  @override
  String get commonlyUsedModels => 'Mifano inayotumika mara kwa mara';

  @override
  String get apiKeyOptional => 'API Key (hiari)';

  @override
  String get noImageSelected => 'Hakuna picha iliyochaguliwa';

  @override
  String get blackSMove => 'Ni zamu ya mweusi';

  @override
  String get llm => 'Mfano Mkubwa wa Lugha';

  @override
  String get llmProvider => 'Mtoa huduma';

  @override
  String get baseUrl => 'URL ya Msingi';

  @override
  String get model => 'Mfano';

  @override
  String get temperature => 'Joto';

  @override
  String get llmCommandReceivedProcessing =>
      'Amri imepokelewa! AI inachakata...';

  @override
  String get llmDeepThinkingWait =>
      'Kufikiri kwa kina kunaendelea, tafadhali subiri...';

  @override
  String get llmPresentingSoon => 'Itawasilishwa hivi karibuni...';

  @override
  String get recognitionParameters => 'Vigezo vya utambuzi';

  @override
  String get adjustParamsDesc =>
      'Rekebisha vigezo ili kuboresha usahihi wa utambuzi';

  @override
  String get saveParameters => 'Hifadhi vigezo';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Imeshindikana kuanzisha utambuzi wa picha: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Utambuzi wa picha umeshindikana: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Nafasi imetumika ikiwa na vipande vyeupe $whiteCount na vyeusi $blackCount';
  }

  @override
  String get fenCopiedToClipboard =>
      '(FEN imenakiliwa kwenye ubao wa kunakili)';

  @override
  String recognitionFailed(String error) {
    return 'Utambuzi umeshindikana: $error';
  }

  @override
  String get myRating => 'Ukadiriaji wangu';

  @override
  String get gamesPlayed => 'Michezo iliyochezwa';

  @override
  String get wins => 'Ushindi';

  @override
  String get losses => 'Hasara';

  @override
  String get draws => 'Sare';

  @override
  String get lastUpdated => 'Ilisasishwa mwisho';

  @override
  String get format => 'Umbizo:';

  @override
  String get resetStatistics => 'Weka upya takwimu';

  @override
  String get drawRate => 'Kiwango cha sare';

  @override
  String get lossRate => 'Kiwango cha hasara';

  @override
  String get aiStatistics => 'Takwimu za AI';

  @override
  String get enableStatistics => 'Washa takwimu';

  @override
  String get enableStatistics_Detail =>
      'Ikiwashwa, matokeo ya mchezo yatarekodiwa katika takwimu. Hata hivyo, michezo inayohusisha kurejesha nyuma haitarekodiwa. Ikiwa imezimwa, ukusanyaji wa takwimu umesitishwa.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Hii itaweka upya takwimu zote za mchezo. Kitendo hiki hakiwezi kutenduliwa.';

  @override
  String get boardInnerRingSize => 'Ukubwa wa pete ya ndani ya ubao';

  @override
  String get boardShadowEnabled => 'Kivuli cha ubao';

  @override
  String get trapAwareness => 'Utambuzi wa mtego';

  @override
  String get trapAwarenessDescription =>
      'Onyesha kwa wazi michezo ya mtego kwa miduara na mishale minene wakati wa uchanganuzi.';

  @override
  String trapExists(String trapMoves) {
    return 'Kuna mtego. Michezo ya mtego: $trapMoves';
  }

  @override
  String get custodianCapture => 'Kukamata kwa kuzunguka';

  @override
  String get custodianCaptureDescription =>
      'Zingatia moja ya vipande vya mpinzani wako kati ya mbili zako kwenye mstari wa moja kwa moja ili kuikamata.';

  @override
  String get custodianCaptureEnable => 'Ruhusu kukamata kwa kuzunguka';

  @override
  String get interventionCapture => 'Kukamata kwa uingiliaji';

  @override
  String get interventionCaptureDescription =>
      'Sogeza katika hatua tupu kati ya vipande viwili vya mpinzani wako ili kuzikamata zote mbili.';

  @override
  String get interventionCaptureEnable => 'Ruhusu kukamata kwa kuingilia kati';

  @override
  String get leapCapture => 'Kukamata kwa kuruka';

  @override
  String get leapCaptureDescription =>
      'Kukamata kwa kuruka juu ya kipande cha mpinzani wa karibu ndani ya hatua tupu zaidi.';

  @override
  String get leapCaptureEnable => 'Ruhusu kukamata kwa kuruka';

  @override
  String get captureApplicableLines => 'Mistari inayotumika';

  @override
  String get captureSquareEdges => 'Kando ya kingo za mraba';

  @override
  String get captureCrossLines =>
      'Pamoja na mistari ya orthogonal kuvuka mraba';

  @override
  String get captureDiagonalLines =>
      'Pamoja na mistari ya diagonal kuvuka mraba';

  @override
  String get captureExecutionPhases => 'Awamu za utekelezaji';

  @override
  String get capturePiecesCondition =>
      'Upatikanaji wakati wa awamu ya kusonga kulingana na vipande vilivyobaki';

  @override
  String get capturePiecesConditionUnlimited => 'Hakuna kizuizi';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Inapatikana wakati una vipande vitatu au vichache';
}
