// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Swedish (`sv`).
class SSv extends S {
  SSv([String locale = 'sv']) : super(locale);

  @override
  String get appName => 'Kvarnspel';

  @override
  String get welcome => 'Välkommen';

  @override
  String get yes => 'Ja';

  @override
  String get no => 'Nej';

  @override
  String get game => 'Spel';

  @override
  String get humanVsAi => 'Människan mot AI';

  @override
  String get humanVsHuman => 'Människa mot människa';

  @override
  String get aiVsAi => 'AI mot AI';

  @override
  String get humanVsCloud => 'Människan mot molnet';

  @override
  String get humanVsLAN => 'Människan mot LAN';

  @override
  String get testViaLAN => 'Test via LAN';

  @override
  String get move => 'Flytta';

  @override
  String get showMoveList => 'Förteckning över flyttningar';

  @override
  String get moveList => 'Förteckning över rörelser';

  @override
  String get noGameRecord => 'Ingen registrering';

  @override
  String get ok => 'OK';

  @override
  String get confirm => 'Bekräfta';

  @override
  String get cancel => 'Avbryt';

  @override
  String get tipSelectWrong => 'Du har valt fel bit.';

  @override
  String get tipPlace => 'Placera dina bitar.';

  @override
  String get tipBanPlace => 'Du kan inte placera den här.';

  @override
  String get tipPlaced => 'Du har placerat.';

  @override
  String get tipRemove => 'Ta bort en bit.';

  @override
  String get tipBanRemove => 'Du kan inte ta bort den.';

  @override
  String get tipRemoved => 'Du har tagit bort den.';

  @override
  String get tipMove => 'Flytta en pjäs.';

  @override
  String get tipCannotPlace => 'Du kan inte placera din pjäs här.';

  @override
  String get tipCannotMove => 'Du kan inte flytta din pjäs hit.';

  @override
  String get tipMill => 'Mill! Ta din motståndares pjäs.';

  @override
  String get tipContinueMill => 'Fortsätt att ta din motståndares pjäs.';

  @override
  String get tipSelectOpponentsPiece => 'Välj en av din motståndares pjäser.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Du kan inte ta bort en pjäs från en kvarn.';

  @override
  String get tipCanMoveOnePoint => 'En pjäs kan förflytta sig 1 poäng.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Du kan inte flytta din motståndares pjäser.';

  @override
  String get tipSelectPieceToMove => 'Välj din pjäs som ska flyttas.';

  @override
  String get tipHaveThreePiecesLeft => 'Du har tre bitar kvar.';

  @override
  String get tipCanMoveToAnyPoint => 'Du kan flytta till vilken punkt du vill.';

  @override
  String tipToMove(Object player) {
    return '$player för att flytta.';
  }

  @override
  String get whiteWin => 'Spelare 1 vinner!';

  @override
  String get blackWin => 'Spelare 2 vinner!';

  @override
  String get won => 'Vann';

  @override
  String get lost => 'Förlorat';

  @override
  String get thinking => 'Tänker…';

  @override
  String get newGame => 'Nytt spel';

  @override
  String get importGame => 'Importera spel';

  @override
  String get exportGame => 'Exportera spel';

  @override
  String get gameImported => 'Spelet importerat.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Det går inte att importera $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch =>
      'Flyttningar och regler stämmer inte överens.';

  @override
  String get pleaseWait => 'Vänligen vänta.';

  @override
  String get restartGame => 'Starta om det pågående spelet?';

  @override
  String get restart => 'Starta om';

  @override
  String get gameStarted => 'Spelet har startat, var god och placera.';

  @override
  String get analyzing => 'Analyserar…';

  @override
  String error(Object message) {
    return 'Fel: $message';
  }

  @override
  String get winRate => 'Vinstfrekvens';

  @override
  String get score => 'Poäng:';

  @override
  String get white => 'Spelare 1';

  @override
  String get black => 'Spelare 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return 'Antalet $player är mindre än tre.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player avgå.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player har ingen väg att gå.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Brädan är full och $player har ingen väg att gå.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Tiden är förbi, $player förlorad.';
  }

  @override
  String get drawReasonRule50 =>
      'I flyttfasen har ingen pjäs tagits bort under det senaste specifika antalet drag.';

  @override
  String get drawReasonBoardIsFull =>
      'Det är oavgjort eftersom brädet är fullt.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Det är oavgjort på grund av trefaldig upprepning.';

  @override
  String get gameOverUnknownReason => 'Spelet är slut! Okänd orsak.';

  @override
  String get gameOver => 'Spelet är slut';

  @override
  String get youWin => 'Du vinner! Grattis!';

  @override
  String challengeHarderLevel(int level) {
    return 'Utmana hårdare nivå? Den nya nivån kommer att vara nivå $level!';
  }

  @override
  String get youLose => 'Du förlorar!';

  @override
  String get analyze => 'Analysera';

  @override
  String get about => 'Om';

  @override
  String version(Object versionNumber) {
    return 'Version: $versionNumber';
  }

  @override
  String get thanks => 'Tack';

  @override
  String get settings => 'Inställningar';

  @override
  String get options => 'Alternativ';

  @override
  String get generalSettings => 'Allmänna Inställningar';

  @override
  String get skillLevel => 'Svårighetsnivå';

  @override
  String get moveTime => 'AI:s tanketid';

  @override
  String get difficulty => 'Svårighetsgrad';

  @override
  String get playSounds => 'Ljudeffekter';

  @override
  String get playSoundsInTheGame => 'Spela upp ljud i spelet';

  @override
  String get keepMuteWhenTakingBack => 'Håll tyst när du tar tillbaka';

  @override
  String get tone => 'Ton';

  @override
  String get whoMovesFirst => 'Första drag';

  @override
  String get human => 'Människan';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Alternativt';

  @override
  String get isAutoRestart => 'Automatisk omstart av spelet när spelet är slut';

  @override
  String get isAutoChangeFirstMove => 'Automatisk ändring av första drag';

  @override
  String get shufflingEnabled => 'Slumpmässigt drag';

  @override
  String get misc => 'Diverse';

  @override
  String get rules => 'Regler';

  @override
  String get piecesCount => 'Antalet pjäser som varje spelare har';

  @override
  String get piecesCount_Detail => 'Hur många pjäser har varje spelare?';

  @override
  String get flyPieceCount => 'Numret på den flygande pjäsen';

  @override
  String get flyPieceCount_Detail =>
      'Om flygande är aktiverat, när en spelare är reducerad till ett visst antal pjäser, är hennes pjäser fria att flytta sig till vilken oockuperad punkt som helst istället för att begränsas till intilliggande punkter som i resten av spelet.';

  @override
  String get piecesAtLeastCount => 'Minst antal bitar';

  @override
  String get hasDiagonalLines => 'Diagonala linjer';

  @override
  String get hasDiagonalLines_Detail =>
      'Lägg till fyra diagonala linjer på brädet.';

  @override
  String get isDefenderMoveFirst => 'Den andra spelaren flyttar först';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Den spelare som flyttar näst längst i placeringsfasen flyttar först i flyttfasen.';

  @override
  String get mayRemoveMultiple => 'Flera flyttningar';

  @override
  String get mayRemoveMultiple_Detail =>
      'Om en spelare stänger mer än en kvarn på en gång, tar hon bort det antal kvarnar hon stängt.';

  @override
  String get mayRemoveFromMillsAlways => 'Förstör kvarnar';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Som standard måste spelarna först ta bort alla andra pjäser innan de tar bort en pjäs från en bildad kvarn. Aktivera det här alternativet för att inaktivera begränsningen.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Den andra spelaren förlorar när brädet är fullt';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'När brädet är fullt i slutet av placeringsfasen förlorar den sida som placerar först spelet. I annat fall är spelet oavgjort.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Förlorar när det inte finns några lagliga drag';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Spelaren förlorar om motståndaren blockerar dem så att de inte kan flyttas. Byt sida för att flytta om det här alternativet är inaktiverat.';

  @override
  String get mayFly => 'Flygande';

  @override
  String get mayFly_Detail =>
      'Om en spelare bara har tre eller fyra (konfigurerbara) pjäser kvar kan hon flytta pjäsen till vilken fri punkt som helst.';

  @override
  String get nMoveRule => 'N-förflyttningsregeln';

  @override
  String get nMoveRule_Detail =>
      'Spelet är oavgjort om det inte har skett någon flyttning inom ett visst antal drag av varje spelare.';

  @override
  String get rollback => 'Rulla tillbaka';

  @override
  String get pleaseSelect => 'Välj';

  @override
  String get copy => 'Kopiera';

  @override
  String get moveHistoryCopied => 'Flyghistorik kopieras till urklipp.';

  @override
  String get help => 'Hjälp';

  @override
  String get feedback => 'Återkoppling';

  @override
  String get exit => 'Avsluta';

  @override
  String get ruleSettings => 'Regler';

  @override
  String get color => 'Färg';

  @override
  String get boardColor => 'Styrelsens färg';

  @override
  String get pieceColor => 'Färg på pjäsen';

  @override
  String get backgroundColor => 'Bakgrundsfärg';

  @override
  String get lineColor => 'Färg på brädans linje';

  @override
  String get whitePieceColor => 'Spelare 1 pjäsens färg';

  @override
  String get blackPieceColor => 'Spelare 2 pjäsens färg';

  @override
  String get messageColor => 'Färg på meddelandet';

  @override
  String get isPieceCountInHandShown => 'Visa antalet bitar på handen';

  @override
  String get isNotationsShown => 'Visa noteringar på brädet';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Visa navigationsverktyg för historik';

  @override
  String get display => 'Visa';

  @override
  String get boardBorderLineWidth => 'Bredd på brädans gränslinje';

  @override
  String get boardInnerLineWidth => 'Bredden på den inre linjen på brädet';

  @override
  String get pieceWidth => 'Bredd på bit';

  @override
  String get fontSize => 'Teckensnittsstorlek';

  @override
  String get standardNotation => 'WMD-notation';

  @override
  String get restore => 'Återställ';

  @override
  String get restoreDefaultSettings => 'Återställer standardinställningar';

  @override
  String pick(Object element) {
    return 'Välj $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Tips';

  @override
  String get player => 'spelare';

  @override
  String get player1 => 'Spelare 1';

  @override
  String get player2 => 'Spelare 2';

  @override
  String get howToPlay => 'Hur man spelar';

  @override
  String get toPlacePiece =>
      'Tryck på en tillgänglig punkt för att placera pjäsen.';

  @override
  String get toSelectPiece => 'Tryck på en pjäs för att flytta den.';

  @override
  String get toMovePiece =>
      'Tryck på en punkt som är kopplad till en pjäs för att flytta den.';

  @override
  String get toRemovePiece =>
      'Tryck på motståndarens en pjäs för att ta bort den.';

  @override
  String get needToCreateMillFirst =>
      'Du måste skapa en kvarn först innan du kan ta bort en pjäs.';

  @override
  String get needToPlayWithOwnPieces => 'Du måste spela med dina pjäser.';

  @override
  String get statistics => 'Statistik';

  @override
  String get totalGames => 'Totalt antal spel';

  @override
  String get results => 'Resultat';

  @override
  String get left => 'vänster';

  @override
  String get privacyPolicy => 'Integritetspolicy';

  @override
  String get privacyPolicy_Detail_1 =>
      'Läs igenom noggrant och se till att du förstår och godkänner denna helt och hållet. ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Om du inte godkänner denna policy får du inte använda denna app. Att använda appen innebär att du accepterar dessa villkor.';

  @override
  String get and => ' och ';

  @override
  String get accept => 'Acceptera';

  @override
  String get takeBack => 'Ta tillbaka';

  @override
  String get takingBack => 'Ta tillbaka…';

  @override
  String get waiting => 'Vänta…';

  @override
  String get stepForward => 'Steg framåt';

  @override
  String get takeBackAll => 'Ta tillbaka allt';

  @override
  String get stepForwardAll => 'Alla steg framåt';

  @override
  String get moveNow => 'Flytta dig nu';

  @override
  String get done => 'Klart.';

  @override
  String get crackMill => 'Sprickkvarn';

  @override
  String get crackMill_Detail =>
      'Om en spelare bara har pjäser i kvarnar, kommer pjäserna i kvarnarna inte att låsas för att tas bort.';

  @override
  String get animationDuration => 'Animationens varaktighet';

  @override
  String get none => 'Ingen';

  @override
  String get theme => 'Tema';

  @override
  String get helpContent =>
      'Målet är att motståndaren ska ha färre än tre pjäser eller inga lagliga drag kvar.\n\nSpelet är automatiskt oavgjort om en position uppträder för tredje gången eller om ingen flyttning sker under de senaste 100 (konfigurerbara) dragen.\n\nSpelet pågår i tre faser:\n\n1. Placering av pjäser på lediga punkter.\n2. Flyttning av pjäser till angränsande punkter\n3. (valfri fas) Flytta pjäser till en ledig punkt när spelaren har tre pjäser kvar.\n\nPlacering av\n\nSpelet börjar med en tom bräda som består av ett rutnät med tjugofyra punkter. Spelarna turas om att placera sina pjäser på lediga punkter tills varje spelare har placerat alla pjäser på brädet. Om en spelare kan placera tre av sina pjäser rakt har han en \"kvarn\" och får ta bort en av motståndarens pjäser från brädet.\n\nI vissa regler måste spelarna först ta bort alla andra pjäser innan de tar bort en pjäs från en bildad kvarn.\n\nI vissa regler kan man inte placera pjäserna till de borttagna pjäsernas punkter igen i placeringsfasen.\n\nNär använda alla pjäser turas spelarna om att flytta.\n\nFlyttning\n\nFör att flytta flyttar en spelare en av sina pjäser längs en brädlinje till en ledig intilliggande punkt. Om han inte kan göra det har han förlorat spelet. Precis som i placeringsfasen har en spelare som ställer in tre av sina pjäser på en brädlinje en kvarn och får ta bort en av motståndarens pjäser. En spelare som reduceras till två pjäser har ingen möjlighet att bilda nya kvarnar och förlorar därmed spelet. En spelare kan också förlora om han har fler än tre pjäser om hans motståndare hindrar dem från att röra sig.\n\nFlygande\n\nI vissa varianter av reglerna kan en spelare, när han bara har tre bitar kvar, få sina bitar att flyga, hoppa eller hoppa till alla lediga punkter, inte bara till intilliggande punkter.\n';

  @override
  String get versionInfo => 'Information om version';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Licens';

  @override
  String get sourceCode => 'Källkod';

  @override
  String get appVersion => 'Version av appen';

  @override
  String get general => 'Allmänt';

  @override
  String get advanced => 'Avancerad';

  @override
  String get placing => 'Placering av';

  @override
  String get moving => 'Flytta';

  @override
  String get removing => 'Ta bort';

  @override
  String get gameOverCondition => 'Villkor för game over';

  @override
  String get aisPlayStyle => 'AI:s spelstil';

  @override
  String get passive => 'Passiv';

  @override
  String get timeout => 'Paus';

  @override
  String get appearance => 'Utseende';

  @override
  String get drawOnHumanExperience => 'Dra nytta av den mänskliga erfarenheten';

  @override
  String get considerMobility => 'Beakta rörligheten hos delarna';

  @override
  String get pieceCount => 'Antal bitar:';

  @override
  String inHand(Object player, int count) {
    return '$player i handen: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player ombord: $count';
  }

  @override
  String get boardTop => 'Brädet är förskjutet från toppen';

  @override
  String get notAIsTurn => 'Det är inte AI:s tur.';

  @override
  String get aiIsNotThinking => 'KI tänker inte.';

  @override
  String get atEnd => 'Du är i slutet av draglistan.';

  @override
  String get tapBackAgainToLeave => 'Tryck tillbaka igen för att gå vidare.';

  @override
  String get more => 'Mer';

  @override
  String get experimental => 'Det är en experimentell funktion.';

  @override
  String get experiments => 'Experiment';

  @override
  String get ossLicenses => 'Licenser för öppen källkod';

  @override
  String get language => 'Språk';

  @override
  String get defaultLanguage => 'Standardspråk';

  @override
  String get mayMoveInPlacingPhase =>
      'Bitarna kan röra sig under placeringsfasen';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Det finns inga separata placerings- och flyttningsfaser, dvs. spelarna kan vid varje drag bestämma om de vill placera en pjäs på brädet eller flytta en av sina pjäser (så länge de har kvarvarande pjäser att placera).';

  @override
  String get drawerColor => 'Menyfärg';

  @override
  String get drawerTextColor => 'Menyens textfärg';

  @override
  String get drawerHighlightItemColor => 'Meny markera objektets färg';

  @override
  String get mainToolbarBackgroundColor => 'Huvudfärg för verktygsfältet';

  @override
  String get mainToolbarIconColor => 'Huvudverktygsfältets ikonfärg';

  @override
  String get navigationToolbarBackgroundColor =>
      'Navigationsverktygsfältets bakgrundsfärg';

  @override
  String get navigationToolbarIconColor =>
      'Navigationsverktygsfältets ikonfärg';

  @override
  String get autoHideToolbar => 'Dölj verktygsfältet automatiskt';

  @override
  String get toolbarLocationOnScreen => 'Verktygsfältets placering på skärmen';

  @override
  String get top => 'Topp';

  @override
  String get bottom => 'Botten';

  @override
  String get center => 'Centrum';

  @override
  String get solidColor => 'Enfärgade';

  @override
  String get picture => 'Bild';

  @override
  String get chooseYourPicture => 'Välj din bild';

  @override
  String get light => 'Ljus';

  @override
  String get dark => 'Mörk';

  @override
  String get themes => 'Teman';

  @override
  String get currentTheme => 'Aktuellt tema';

  @override
  String get saveTheme => 'Spara tema';

  @override
  String get showAnalysisGraph => 'Visa analysdiagram';

  @override
  String get analysis => 'Analys';

  @override
  String get saveGame => 'Spara spelet';

  @override
  String get loadGame => 'Belastnings spel';

  @override
  String get setupPosition => 'Inställningsposition';

  @override
  String get showLegalMoves => 'Visa lagliga drag';

  @override
  String get showLastMove => 'Visa sista drag';

  @override
  String get showArrows => 'Visa pilar';

  @override
  String get pieces => 'Bitar';

  @override
  String get showAnalysis => 'Visa analys';

  @override
  String get threads => 'Trådar';

  @override
  String get getInvolved => 'Bli involverad';

  @override
  String get helpImproveTranslate => 'Hjälp till att förbättra översättningen';

  @override
  String get tutorial => 'Handledning';

  @override
  String get classicMill => 'Klassisk kvarn';

  @override
  String get mixedMill => 'Blandad kvarn';

  @override
  String get ceylonMill => 'Ceylon kvarn';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Kvarnen kan brytas om och göras om upprepade gånger';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Om en spelare bryter en kvarn för att skapa en ny kvarn omedelbart, kan en sådan spelare flytta en sådan bit tillbaka till den ursprungliga korsningen i sitt nästa drag om den gör en ny kvarn.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Spelet dras om en spelare har tre delar och efter tio drag tar ingen spelare bort motståndarens bitar';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'När en spelare är nere i tre delar, och ingen spelare kan ta bort en motståndares bit inom tio drag, är spelet oavgjort.';

  @override
  String get close => 'Stänga';

  @override
  String get whitePiece => 'Vit bit';

  @override
  String get blackPiece => 'Svart bit';

  @override
  String get emptyPoint => 'Tom punkt';

  @override
  String get noPoint => 'Ingen idé';

  @override
  String get placingPhase => 'Placeringsfas';

  @override
  String get movingPhase => 'Flyttfas';

  @override
  String get flyingPhase => 'Flygande fas';

  @override
  String sideToMove(Object player) {
    return 'Sida att flytta: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Sista draget: $move';
  }

  @override
  String get selected => 'Vald';

  @override
  String get accessibility => 'Tillgänglighet';

  @override
  String get screenReaderSupport => 'Skärmläsarstöd';

  @override
  String get isDraw => 'Det är oavgjort!';

  @override
  String get draw => 'Dra';

  @override
  String get pieceHighlightColor => 'Del markera färg';

  @override
  String get algorithm => 'Algoritm';

  @override
  String get endgameNMoveRule => 'Slutspel N-Move regel';

  @override
  String get endgameNMoveRule_Detail =>
      'Om endera spelaren bara har tre bitar och ingen av spelarna tar bort en bit inom ett specifikt drag, lottas spelet.';

  @override
  String get drawReasonEndgameRule50 =>
      'Endera spelaren har bara tre delar och ingen av spelarna tar bort en bit inom ett specifikt drag.';

  @override
  String get threefoldRepetitionRule => 'Trefaldig upprepningsregel';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Spelet lottas om en position inträffar för tredje gången.';

  @override
  String get continueToMakeMove => 'Kvarn! Fortsätt att göra ett drag.';

  @override
  String get pointStyle => 'Poängstil';

  @override
  String get pointWidth => 'Punktbredd';

  @override
  String get solid => 'Fast';

  @override
  String get hollow => 'Ihålig';

  @override
  String get languageName => 'Svenska';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Rör sig',
      one: '$count Flytta',
      zero: 'Flytta',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Laddningen misslyckades.';

  @override
  String get filename => 'Filnamn';

  @override
  String get browse => 'Bläddra…';

  @override
  String get gameFiles => 'Spelfiler';

  @override
  String get gameSavedTo => 'Spelet sparas till';

  @override
  String get empty => 'Tömma';

  @override
  String get noMove => 'Ingen rörelse.';

  @override
  String get restoredPosition => 'Återställt utgångsläge.';

  @override
  String get clean => 'Rena';

  @override
  String get cleanedUp => 'Städade.';

  @override
  String get remove => 'Ta bort';

  @override
  String get noPiecesCanBeRemoved => 'Inga bitar kan tas bort.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pieces',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 måste tas bort.';
  }

  @override
  String placedCount(int count) {
    return 'Placerad ($count)';
  }

  @override
  String get placedPieceCount => 'Placerat antal styck i placeringsfasen.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Den nuvarande spelaren har placerat $count pjäser.';
  }

  @override
  String get notPlacingPhase => 'Inte placerar fasen, kan inte ändra den.';

  @override
  String get paste => 'Klistra';

  @override
  String get pasteDone => 'Pastan är klar.';

  @override
  String get cannotPaste => 'Kan inte klistra in.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Visa oplacerade och borttagna bitar';

  @override
  String get fullScreen => 'Fullskärm';

  @override
  String get reopenToTakeEffect =>
      'Avsluta och öppna appen igen för att inställningarna ska börja gälla.';

  @override
  String get forest => 'Skog';

  @override
  String get desktopImage => 'Skrivbordsbild';

  @override
  String get invalidPosition => 'Ogiltig position.';

  @override
  String get shareGIF => 'Dela GIF';

  @override
  String get pixelRatio => 'Pixelförhållande';

  @override
  String get duration => 'Varaktighet';

  @override
  String get gameScreenRecorder => 'Spelskärminspelare';

  @override
  String get previous => 'Tidigare';

  @override
  String get next => 'Nästa';

  @override
  String get skip => 'Hoppa';

  @override
  String get gotIt => 'Jag förstår';

  @override
  String get youCanModifyRules =>
      'Du kan ändra spelets regler i regelinställningarna.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Du kan använda mushjulet för att ändra värdet i väljaren.';

  @override
  String get noTimeLimitForThinking =>
      'AI Tänketid inställd på 0 betyder att det inte finns någon tidsgräns för tänkande.';

  @override
  String get whatIsMtdf =>
      'MTD(f) är en modifierad form av alfa-beta-sökalgoritmen som syftar till att förbättra effektiviteten genom att återanvända mellanliggande sökresultat och använda en bra initial gissning för att begränsa sökutrymmet.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Var medveten om att AI-tänketidsjusteringen kanske inte är helt exakt. Den faktiska tanketiden kan vara kortare när svårighetsgraden är inställd på ett lägre värde och kan vara längre när AI:n är halvtänkt när tiden går ut.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Om du ställer in svårighetsgraden högt men inte ökar AI-tänketiden, kan den faktiska svårighetsgraden begränsas till ett lägre värde på grund av tanketidsbegränsningen. Det faktiska värdet kan variera beroende på maskinens prestanda.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) är en sökalgoritm för att hitta det bästa draget i en given position. Det är en förbättring av alfa-beta-algoritmen och använder noll- eller noll-fönstersökningar för att bekräfta att ett drag är sämre eller inte sämre än en redan säker poäng från huvudvarianten. PVS fokuserar på de mest lovande dragen och undviker onödiga sökningar av suboptimala grenar, vilket hjälper till att förbättra effektiviteten i sökningen.';

  @override
  String get whatIsAlphaBeta =>
      'Alfa-beta-algoritmen är en sökalgoritm för att hitta det bästa draget. Den använder minimax-principen och två värden, alfa och beta, för att beskära sökträdet och öka effektiviteten. Alfa representerar den lägsta poäng som datorn är säker på att den kan få, medan beta representerar den maximala poäng som motståndaren kan få. Algoritmen hjälper datorn att fatta smarta, effektiva beslut i ett spel.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Enligt mänsklig erfarenhet kommer du att förlora om du försöker vinna. Sikta istället på oavgjort som ditt mål och undvik att förlora matchen. Observera din motståndare och lura dem försiktigt till en position där de kan göra misstag. När de visar svaghet, ta tillfället i akt och tryck försiktigt för vinsten. På så sätt kan du vinna spelet.';

  @override
  String get firstMoveDetail =>
      'I det här spelet är det lättare för den andra spelaren att vinna jämfört med den första spelaren.';

  @override
  String get passiveDetail =>
      'Om du aktiverar alternativet Passive kommer AI:n att slappna av när den har en fördel i positionen, snarare än att aggressivt försöka vinna så snabbt som möjligt.';

  @override
  String get moveRandomlyDetail =>
      'Om du aktiverar det här alternativet ökar spelets slumpmässighet och nöje samtidigt som du inaktiverar det kan hjälpa till att studera sätt att slå AI.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Om AI:n överväger rörligheten hos sina pjäser, kommer den inte bara att sträva efter att fånga motståndarens pjäser så snabbt som möjligt, utan också överväga att blockera motståndarens rörelser och förhindra dem från att göra detsamma.';

  @override
  String get whenBoardIsFull => 'När tavlan är full';

  @override
  String get whenBoardIsFull_Detail =>
      'I slutet av placeringsfasen, innan flyttfasen börjar, följer åtgärden om brädet är fullt av pjäser.';

  @override
  String get sideToMoveRemovePiece =>
      'Spelaren som flyttar först i flyttfasen tar bort en av motståndarens pjäser.';

  @override
  String get agreeToDraw => 'Båda sidor är överens om oavgjort.';

  @override
  String get takeOpponentsPiece => 'Ta en av din motståndares pjäser.';

  @override
  String get firstPlayerLose => 'Den första spelaren förlorar spelet.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Den första och andra spelaren tar bort en av motståndarens pjäser.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Den andra och första spelaren tar bort en av motståndarens pjäser.';

  @override
  String get enteredFlyingPhase =>
      'Nu när man kommit in i flygfasen, kan motståndarens pjäser hoppa till vilken tom punkt som helst på brädet. Du kan stänga av flygregeln i \"Regelinställningar\".';

  @override
  String get whenStalemate => 'När ett dödläge';

  @override
  String get whenStalemate_Detail =>
      'Vilken åtgärd följer när ingen pjäs kan flyttas?';

  @override
  String get endWithStalemateLoss => 'Sluta med en dödläge förlust.';

  @override
  String get changeSideToMove => 'Byt sida för att flytta.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Ta bort en av motståndarens pjäser och gör nästa drag.';

  @override
  String get endWithStalemateDraw => 'Avsluta med ett dödläge oavgjort.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Ta bort en av motståndarens pjäser och byt sida för att flytta.';

  @override
  String get aiResponseDelayTime => 'AI svarsfördröjningstid';

  @override
  String get aiIsDelaying =>
      'AI befinner sig för närvarande i en fördröjd svarsfas. Vänta ett tag innan du fortsätter.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Du kan inte ta bort en icke-intilliggande del.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Om ett dödläge, kan motståndarens pjäser intill din tas bort, oavsett kvarn formation.';

  @override
  String get whatIsMcts =>
      'MCTS är en nybörjarvänlig algoritm som fattar beslut genom att utforska och utvärdera olika rörelser genom simuleringar.';

  @override
  String get goldenJade => 'Golden Jade';

  @override
  String get forestWood => 'Skogsved';

  @override
  String get darkMystery => 'Mörkt mysterium';

  @override
  String get midnightBlue => 'Midnattsblå';

  @override
  String get greenForest => 'Grön skog';

  @override
  String get greenMeadow => 'Grön äng';

  @override
  String get stonyPath => 'Stenig väg';

  @override
  String get pastelPink => 'Pastellrosa';

  @override
  String get turquoiseSea => 'Turkos hav';

  @override
  String get violetDream => 'Violett dröm';

  @override
  String get mintChocolate => 'Mintchoklad';

  @override
  String get skyBlue => 'Himmelsblå';

  @override
  String get playfulGarden => 'Lekfull trädgård';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Algoritmen för retrograd analys använder retrograd analys med flera värden för att bygga en slutspelsdatabas från olika startpositioner, och tillämpar sedan denna databas för att optimera spelet. Detta tillvägagångssätt faller under kategorin Ultrastarka lösningar.';

  @override
  String get viewAlgorithmGuide =>
      'Vill du se användarhandboken för denna algoritm?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Visa positionsfördelsindikator';

  @override
  String get usePerfectDatabase => 'Använd perfekt databas';

  @override
  String get perfectDatabaseDescription =>
      'Aktivera det här alternativet för att använda en felfri speldatabas genererad genom banbrytande algoritmer. Denna funktion integrerar både öppnings- och slutspelsstrategier för att föreslå optimala drag. Detta är det föredragna valet för spelare som söker högsta precision i spelet. Skapat genom noggranna beräkningstekniker, är databasen designad för att erbjuda nästan perfekta spellösningar.\n\nObs: Om AI misslyckas med att komma åt databasen kommer den att vända sig till konventionella algoritmer för spelbeslut. När databasen är tillgänglig blir \'svårighetsnivån\' praktiskt taget oslagbar, och \'AI Thinking Time\' upplever en drastisk minskning. Många inställningar inom \'AI\'s play style\'-alternativ kommer att åsidosättas, eftersom databasresultaten har högsta prioritet.\n\nFör vägledning om hur du får ut det mesta av denna felfria databas, klicka här.';

  @override
  String get backgroundImage => 'Bakgrundsbild';

  @override
  String get whatIsRandom =>
      'När alternativet \"Använd perfekt databas\" inte är aktiverat, gör inställningen \"Slumpmässig\" att AI:n flyttar pjäser slumpmässigt utan att använda några algoritmer för val av drag. Detta resulterar vanligtvis i betydligt svagare spelupplägg. Omvänt, när \"Använd perfekt databas\" är aktiverat, förlitar sig AI enbart på den \"Perfekta databasen\" för att fatta beslut, istället för att blanda den med traditionella AI-algoritmer. I det här läget är AI:s rörelser helt baserade på databasens innehåll, utan att lita på realtidsberäkningar eller sökalgoritmer.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Ta bort motståndarens pjäs(er) från deras hand; sedan är det motståndarens tur att placera.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'När kvarnar formas under placeringsfasen';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Ta bort motståndarens pjäs(er) från brädet.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Ta bort motståndarens pjäs(er) från brädet; sedan är det motståndarens tur att placera.';

  @override
  String get opponentRemovesOwnPiece =>
      'Motståndaren tar bort sina egna pjäser från brädet.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Istället för att du agerar, väljer motståndaren att ta bort sina egna pjäser från brädet, vilket är en handling som är skadlig för dem själva.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Ta bort motståndarens pjäs(er) från deras hand; sedan är det din tur att flytta.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Ta bort pjäs(er) från motståndarens hand.  Om flera pjäser ska tas bort enligt inställningen “Multi-remove”, och motståndaren inte har några pjäser kvar i handen, fortsätter du att ta bort motståndarens pjäser från brädet. Sedan är det din tur att flytta. Om du fortsätter att bilda kvarnar, kan du fortsätta att ta bort motståndarens pjäser.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Ta bort pjäs(er) från motståndarens hand. Om flera pjäser ska tas bort enligt inställningen “Multi-remove”, och motståndaren inte har några pjäser kvar, fortsätter du att ta bort motståndarens pjäser från brädet. Sedan är det motståndarens tur att flytta.';

  @override
  String get markAndDelayRemovingPieces =>
      'Markera och fördröj borttagning av pjäser.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Under placeringsfasen markeras pjäserna som ska tas bort, och för båda spelarna kan inga nya pjäser placeras på dessa punkter. Vid inträde i flyttfasen tas dessa markerade pjäser bort helt och hållet, och spelare kan sedan flytta sina pjäser till dessa nu tomma punkter.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Åtgärder som kan vidtas när kvarnar bildas under placeringsfasen.';

  @override
  String get marked => 'Markant';

  @override
  String get menu => 'Meny';

  @override
  String get monochrome => 'Monokrom';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Du kan aktivera stöd för skärmläsare i tillgänglighetsinställningarna under Allmänna inställningar.';

  @override
  String get showNumbersOnPieces => 'Visa nummer på pjäserna';

  @override
  String get saveImage => 'Spara bild';

  @override
  String get isAnalysisToolbarShown => 'Visa analysverktygsfältet';

  @override
  String get analysisToolbarBackgroundColor =>
      'Bakgrundsfärg för analysverktygsfältet';

  @override
  String get analysisToolbarIconColor => 'Ikonfärg för analysverktygsfältet';

  @override
  String get transformed => 'Transformeras.';

  @override
  String get cannotTransform => 'Kan inte transformeras.';

  @override
  String get rotate => 'Rotera';

  @override
  String get horizontalFlip => 'H. vänd';

  @override
  String get verticalFlip => 'V. vänd';

  @override
  String get innerOuterFlip => 'I/U vänd';

  @override
  String get transparentCanvas => 'Genomskinlig Duk';

  @override
  String get restrictRepeatedMillsFormation =>
      'Begränsa upprepad kvarnbildning';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'En pjäs flyttad från en kvarn till en annan kan inte omedelbart återvända till den ursprungliga punkten på nästa drag för att bilda en kvarn igen. Ett annat drag krävs först.';

  @override
  String get oneTimeUseMill => 'Engångsbruk kvarn';

  @override
  String get oneTimeUseMill_Detail =>
      'Varje kvarn kan bara ta bort en motståndares bit en gång. Du kan omforma den igen, men den kan inte användas för ytterligare borttagningar.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'De aktuella reglerna som du har ställt in har ingen motsvarande perfekt databas. För mer information om den perfekta databasen, klicka här.';

  @override
  String get focusOnBlockingPaths => 'Fokusera på att blockera vägar';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Prioritera att hindra motståndarens rörelser framför att bilda kvarnar. Istället för att fokusera på att ta bort pjäser genom att fullborda kvarnar, siktar AI på att fånga motståndaren, göra dem oförmögna att röra sig och säkra en seger genom utmattning snarare än aggressivt spel. Denna strategi blockerar inte aktivt motståndarens kvarnar.';

  @override
  String get pieceImage => 'Pjäspussel';

  @override
  String get importColorSettings => 'Importera färginställningar';

  @override
  String get exportColorSettings => 'Exportera färginställningar';

  @override
  String get import => 'Importera';

  @override
  String get export => 'Exportera';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Kopiera JSON-formatinställningarna till urklipp först.';

  @override
  String get copiedToClipboard => 'Kopierat till urklipp.';

  @override
  String get imported => 'Importerad.';

  @override
  String get boardImage => 'Bräd bild';

  @override
  String get autumnLeaves => 'Höstlöv';

  @override
  String get legendaryLand => 'Legendariskt Land';

  @override
  String get vignetteEffect => 'Vinjetteringseffekt';

  @override
  String get promptMakeToolbarTransparent =>
      'Vill du göra verktygsfältet helt genomskinligt när en bakgrundsbild för brädet är inställd?';

  @override
  String get vibration => 'Aktivera vibration i spelet';

  @override
  String get soundTheme => 'Ljudtema';

  @override
  String get ball => 'Boll';

  @override
  String get liquid => 'Vätska';

  @override
  String get wood => 'Trä';

  @override
  String get placeEffectAnimation => 'Animeringseffekt vid placering av pjäs';

  @override
  String get removeEffectAnimation =>
      'Animeringseffekt vid borttagning av pjäs';

  @override
  String get isToolbarAtBottom => 'Visa verktygsfältet längst ner';

  @override
  String get boardCornerRadius => 'Hörnradie på brädan';

  @override
  String get useOpeningBook => 'Använd öppningsbok';

  @override
  String get currentRule => 'Nuvarande';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Regeluppsättning';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Låt AI använda öppningsdrag som ofta används av professionella mänskliga spelare under tidiga skeden av spelet. Obs: Denna funktion är för närvarande endast tillgänglig för specifika regeluppsättningar.';

  @override
  String get showAdvantageGraph => 'Visa fördelsgraf';

  @override
  String get advantageGraphHint =>
      'Fördelsgrafen ritas endast efter att AI:n har gjort ett drag. Den ritas inte när den mänskliga spelaren gör ett drag.';

  @override
  String get removalBasedOnMillCounts =>
      'Inaktivera borttagning tills alla pjäser är placerade. Spelarna tar bort pjäser baserat på antalet möllor de har.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Inaktivera borttagning tills alla pjäser är placerade. Spelarna tar bort pjäser baserat på antalet möllor: om antalet är lika tar båda bort samma antal pjäser; om den ena har fler tar denne bort en extra pjäs, och behåller en pjäs skillnad. Om bara en spelare bildar en mölla tar den bort två pjäser, medan den andra tar bort en. Om ingen bildar en mölla tar båda bort en pjäs.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Välj en av dina pjäser.';

  @override
  String get notYourTurn => 'Det är inte din tur.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Bakgrundsfärg för anteckningsverktygsfält';

  @override
  String get annotationToolbarIconColor =>
      'Ikonfärg för anteckningsverktygsfält';

  @override
  String get isAnnotationToolbarShown => 'Visa anteckningsverktygsfält';

  @override
  String get enterAnnotationMode => 'Gå in i anteckningsläge';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Är du säker på att du vill rensa alla anteckningar?';

  @override
  String get llmPromptCopiedToClipboard => 'LLM-prompt kopierad till urklipp.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Anslutningen nekades, servern kan vara nere.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Upptäckt lyckades, väntar på anslutning...';

  @override
  String get noLanConnection => 'Ingen LAN-anslutning';

  @override
  String get takeScreenshot => 'Ta skärmdump';

  @override
  String get disconnectedFromOpponent => 'Frånkopplad från motståndaren.';

  @override
  String get takeBackRequest => 'Begär att ta tillbaka draget';

  @override
  String get nothingToShow => 'Inget att visa.';

  @override
  String get stopHosting => 'Avsluta värdskap';

  @override
  String get connectionResetByPeer => 'Anslutningen återställdes av motparten.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Anslutningen tappades på grund av heartbeat-timeout. Vänligen anslut igen.';

  @override
  String get startHosting => 'Starta värdskapet';

  @override
  String get restartRequestRejected => 'Begäran om omstart avvisad.';

  @override
  String get notConnectedToLanOpponent =>
      'Inte ansluten till LAN-motståndaren.';

  @override
  String get llmPrompt => 'LLM-prompt';

  @override
  String get gameRestarted => 'Spelet startades om.';

  @override
  String get takeBackRejected => 'Begäran om att ta tillbaka avvisades.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Är du säker på att du vill ge upp det här spelet?';

  @override
  String get opponentResignedYouWin => 'Motståndaren gav upp. Du vinner!';

  @override
  String get clearAllAnnotations => 'Rensa alla anteckningar';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Ansluten, väntar på motståndarens drag...';

  @override
  String get networkStatusDisconnected => 'Nätverksstatus: Frånkopplad';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Begäran om att ta tillbaka draget har skickats till motståndaren.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Motståndaren kan ha lämnat spelet';

  @override
  String get connectedToHostSuccessfully => 'Anslutning till värd lyckades.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Anslutningen tappades: heartbeat-timeout';

  @override
  String get noHostDiscovered => 'Ingen värd upptäckt.';

  @override
  String get confirmResignation => 'Bekräfta att du vill ge upp spelet';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Värdskapet har startats, väntar på att spelare ska ansluta...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Anslutningen tidsgräns överskreds, nätverksanslutningen är instabil.';

  @override
  String get noLlmPromptAvailable => 'Ingen LLM-prompt tillgänglig.';

  @override
  String get youResignedGameOver => 'Du gav upp. Spelet är över.';

  @override
  String get serverIp => 'Server-IP';

  @override
  String get confirmClear => 'Bekräfta rensning';

  @override
  String get opponentSTurn => 'Motståndarens tur.';

  @override
  String get waitingAClientConnection => 'Väntar på en klientanslutning...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Begäran om att ta tillbaka draget avvisades eller misslyckades.';

  @override
  String get addText => 'Lägg till text';

  @override
  String get exitAnnotationMode => 'Avsluta anteckningsläge';

  @override
  String get typeYourAnnotation => 'Skriv din anteckning';

  @override
  String get attemptingToReconnect => 'Försöker återansluta...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Begäran om omstart har skickats. Väntar på motståndarens svar...';

  @override
  String get serverIsStopped => 'Servern är avstängd.';

  @override
  String get restartRequest => 'Begäran om omstart';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Kan inte begära att ta tillbaka draget när det inte är din tur.';

  @override
  String get takeBackAccepted => 'Begäran om att ta tillbaka godkänd.';

  @override
  String get localNetworkSettings => 'Lokala nätverksinställningar';

  @override
  String get reconnectedSuccessfully => 'Återanslutning lyckades!';

  @override
  String get failedToSaveImageToGallery =>
      'Kunde inte spara bilden till galleriet.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Motståndaren begärde att starta om spelet. Accepterar du?';

  @override
  String get yourTurn => 'Din tur.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Kunde inte återansluta, vänligen starta om spelet.';

  @override
  String get host => 'Värd';

  @override
  String get join => 'Anslut';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'Ogiltig IP-adress.';

  @override
  String get invalidPort => 'Ogiltig port.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Ansluter: Försök $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Kunde inte ansluta: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Kunde inte starta värdskap: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Värd upptäckt: $ip:$port';
  }

  @override
  String get stop => 'Stoppa';

  @override
  String get discover => 'Upptäck';

  @override
  String get connect => 'Anslut';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Klient ansluten: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Upptäcker: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Återansluter ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Ansluten';

  @override
  String get delete => 'Ta bort';

  @override
  String get ancientEgypt => 'Forntida Egypten';

  @override
  String get gothicIce => 'Gotisk Is';

  @override
  String get riceField => 'Risfält';

  @override
  String get chinesePorcelain => 'Kinesiskt Porslin';

  @override
  String get desertDusk => 'Ökensskymning';

  @override
  String get precisionCraft => 'Precisionshantverk';

  @override
  String get folkEmbroidery => 'Folkbroderi';

  @override
  String get carpathianHeritage => 'Karpatiskt Arv';

  @override
  String get imperialGrandeur => 'Kejserlig Prakt';

  @override
  String get bohemianCrystal => 'Böhmiskt Kristall';

  @override
  String get savannaSunrise => 'Savannens Soluppgång';

  @override
  String get harmonyBalance => 'Harmoni och Balans';

  @override
  String get cinnamonSpice => 'Kanelkrydda';

  @override
  String get anatolianMosaic => 'Anatolisk Mosaik';

  @override
  String get carnivalSpirit => 'Karnevalsanda';

  @override
  String get custom => 'Anpassad';

  @override
  String get spiceMarket => 'Kryddmarknad';

  @override
  String get swipeToRevealTheDrawer => 'Svep för att visa lådan';

  @override
  String get showGameInfoOnScreenshots => 'Visa spelinformation på skärmbilder';

  @override
  String get humanMoveTime => 'Mänsklig tidsgräns';

  @override
  String get noTimeLimitForHumanMoves => 'Ingen tidsgräns för mänskliga drag';

  @override
  String get timeoutLoseWillBeApplied =>
      'Timeoutförlust kommer att tillämpas för mänsklig spelare';

  @override
  String get identifyingBoard => 'Identifierar spelbrädet...';

  @override
  String get youCanEnterAnyModelName =>
      'Du kan ange vilket modellnamn som helst.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Brädposition tillämpad. FEN kopierad till Urklipp.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Förslag: försök ta en tydligare bild av spelbrädet.';

  @override
  String get llmPromptTemplate => 'LLM-promptmall';

  @override
  String get noValidBoardDetected => 'Inget giltigt bräde hittades.';

  @override
  String get selectingImageFromAlbum => 'Väljer bild från album...';

  @override
  String get configurePromptTemplate => 'Konfigurera promptmall';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Redigera promptmall för LLM-analys';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Misslyckades med att generera FEN från det igenkända brädet.';

  @override
  String get outputInCurrentLanguage => 'Utdata på aktuellt språk';

  @override
  String get commonBaseUrls => 'Vanliga Base URLs';

  @override
  String get viewCommonModels => 'Visa vanliga modeller';

  @override
  String get recognitionParametersUpdated =>
      'Parametrar för igenkänning uppdaterade.';

  @override
  String get whiteSMove => 'Vitts drag';

  @override
  String get resetToDefaults => 'Återställ till standard';

  @override
  String get photoShoot => 'Fotografering';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Misslyckades med att tillämpa den igenkända brädpositionen.';

  @override
  String get llmPromptContent => 'LLM-promptinnehåll';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM är ej konfigurerat. Kontrollera dina inställningar.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Ange leverantör, modell, API Key och Base URL';

  @override
  String get llmConfiguration => 'LLM-konfiguration';

  @override
  String get configureLlmProvider => 'Konfigurera LLM-leverantör';

  @override
  String get llmPromptTemplateHeader => 'Rubrik för LLM-promptmall';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Inga pjäser identifierades i bilden. Försök igen.';

  @override
  String get recognizeBoardFromImage => 'Identifiera bräde från bild';

  @override
  String get viewTips => 'Visa tips';

  @override
  String get applyToBoard => 'Tillämpa på brädet';

  @override
  String get adjustBoardArea => 'Justera brädområde';

  @override
  String get viewCommonUrls => 'Visa vanliga URL:er';

  @override
  String get colorAnalysisFailed => 'Färganalys misslyckades!';

  @override
  String get analyzingGameBoardImage => 'Analyserar spelbrädebild...';

  @override
  String get selectFromAlbum => 'Välj från album';

  @override
  String get noBoardPointDetected => 'Ingen brädpunkt hittades!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Om det lämnas tomt används standardmallen';

  @override
  String get llmConfig => 'LLM-konfiguration';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Är du säker på att du vill återställa promptmallarna till standardvärden?';

  @override
  String get llmPromptTemplateFooter => 'Sidfot för LLM-promptmall';

  @override
  String get loadingResponse => 'Laddar svar...';

  @override
  String get applyThisResultToBoard => 'Tillämpa detta resultat på brädet';

  @override
  String get takingPicture => 'Tar bild...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Välj en bild på spelbrädet för identifiering';

  @override
  String get identificationResults => 'Identifieringsresultat';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analysera dragen och ge insikter.';

  @override
  String get getApiKey => 'Hämta API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Hela igenkänningsprocessen slutfördes inte.';

  @override
  String get boardRecognitionResult => 'Resultat för brädigenkänning';

  @override
  String get askLlm => 'Fråga LLM';

  @override
  String get boardDetectionFailed => 'Bräddetektering misslyckades!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Ingen brädpunkt hittades, kan inte identifiera pjäs!';

  @override
  String get copyFen => 'Kopiera FEN';

  @override
  String get commonlyUsedModels => 'Vanligt använda modeller';

  @override
  String get apiKeyOptional => 'API Key (valfritt)';

  @override
  String get noImageSelected => 'Ingen bild vald';

  @override
  String get blackSMove => 'Svarts drag';

  @override
  String get llm => 'Stort språkmodell';

  @override
  String get llmProvider => 'Leverantör';

  @override
  String get baseUrl => 'Bas-URL';

  @override
  String get model => 'Modell';

  @override
  String get temperature => 'Temperatur';

  @override
  String get llmCommandReceivedProcessing =>
      'Kommando mottagen! AI bearbetar...';

  @override
  String get llmDeepThinkingWait =>
      'Djupgående tänkande pågår, vänligen vänta...';

  @override
  String get llmPresentingSoon => 'Presenteras snart...';

  @override
  String get recognitionParameters => 'Identifieringsparametrar';

  @override
  String get adjustParamsDesc =>
      'Justera parametrar för att förbättra identifieringsnoggrannheten';

  @override
  String get saveParameters => 'Spara parametrar';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Kunde inte starta bildigenkänning: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Bildigenkänningen misslyckades: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Applicerad position med $whiteCount vita och $blackCount svarta pjäser';
  }

  @override
  String get fenCopiedToClipboard => '(FEN kopierad till urklipp)';

  @override
  String recognitionFailed(String error) {
    return 'Identifieringen misslyckades: $error';
  }

  @override
  String get myRating => 'Min rankning';

  @override
  String get gamesPlayed => 'Spelade matcher';

  @override
  String get wins => 'Vinster';

  @override
  String get losses => 'Förluster';

  @override
  String get draws => 'Oavgjorda';

  @override
  String get lastUpdated => 'Senast uppdaterad';

  @override
  String get format => 'Format:';

  @override
  String get resetStatistics => 'Återställ statistik';

  @override
  String get drawRate => 'Oavgjortkvot';

  @override
  String get lossRate => 'Förlustkvot';

  @override
  String get aiStatistics => 'AI-statistik';

  @override
  String get enableStatistics => 'Aktivera statistik';

  @override
  String get enableStatistics_Detail =>
      'När detta är aktiverat sparas spelresultat i statistiken. Spel som involverar återtåg sparas dock inte. När detta är inaktiverat pausas statistikinsamlingen.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Detta återställer all spelstatistik. Denna åtgärd kan inte ångras.';

  @override
  String get boardInnerRingSize => 'Storlek på brädans inre ring';

  @override
  String get boardShadowEnabled => 'Brädskugga';

  @override
  String get trapAwareness => 'Fälligenkänning';

  @override
  String get trapAwarenessDescription =>
      'Markera fäll-drag med tjocka cirklar och pilar under analysen.';

  @override
  String trapExists(String trapMoves) {
    return 'Det finns en fälla. Fälldrag: $trapMoves';
  }

  @override
  String get custodianCapture => 'Flankering';

  @override
  String get custodianCaptureDescription =>
      'Bifoga en av dina motståndares bitar mellan två av dina i en rak linje för att fånga den.';

  @override
  String get custodianCaptureEnable => 'Tillåt flankerande fångst';

  @override
  String get interventionCapture => 'Intervention';

  @override
  String get interventionCaptureDescription =>
      'Flytta in i den tomma punkten mellan två av din motståndares bitar för att fånga dem båda.';

  @override
  String get interventionCaptureEnable => 'Tillåt interventionsfångst';

  @override
  String get leapCapture => 'Hoppupptagning';

  @override
  String get leapCaptureDescription =>
      'Fånga genom att hoppa över en angränsande motståndares stycke i den tomma punkten bortom.';

  @override
  String get leapCaptureEnable => 'Tillåt hoppfångst';

  @override
  String get captureApplicableLines => 'Tillämpliga linjer';

  @override
  String get captureSquareEdges => 'Längs torgets kanter';

  @override
  String get captureCrossLines => 'Längs ortogonala linjer som korsar torget';

  @override
  String get captureDiagonalLines => 'Längs diagonala linjer som korsar torget';

  @override
  String get captureExecutionPhases => 'Exekveringsfaser';

  @override
  String get capturePiecesCondition =>
      'Tillgänglighet under den rörliga fasen baserat på återstående bitar';

  @override
  String get capturePiecesConditionUnlimited => 'Ingen begränsning';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Tillgängligt när du har tre eller färre bitar';
}
