// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Serbian (`sr`).
class SSr extends S {
  SSr([String locale = 'sr']) : super(locale);

  @override
  String get appName => 'Мице';

  @override
  String get welcome => 'Добродошли';

  @override
  String get yes => 'Да';

  @override
  String get no => 'Не';

  @override
  String get game => 'Игра';

  @override
  String get humanVsAi => 'Човек - Рачунар';

  @override
  String get humanVsHuman => 'Човек - човек';

  @override
  String get aiVsAi => 'Рачунар - рачунар';

  @override
  String get humanVsCloud => 'Хуман Вс. Цлоуд';

  @override
  String get humanVsLAN => 'Хуман Вс. ЛАН';

  @override
  String get testViaLAN => 'Тестирајте путем ЛАН-а';

  @override
  String get move => 'Потез';

  @override
  String get showMoveList => 'Списак потеза';

  @override
  String get moveList => 'Списак потеза';

  @override
  String get noGameRecord => 'Нема записа';

  @override
  String get ok => 'У реду';

  @override
  String get confirm => 'Потврди';

  @override
  String get cancel => 'Поништи';

  @override
  String get tipSelectWrong => 'Изаберите погрешну фигуру.';

  @override
  String get tipPlace => 'Поставите своје фигуре.';

  @override
  String get tipBanPlace => 'Не можете да је ставите овде.';

  @override
  String get tipPlaced => 'Ви сте пласирали.';

  @override
  String get tipRemove => 'Уклоните комад.';

  @override
  String get tipBanRemove => 'Не можете га уклонити.';

  @override
  String get tipRemoved => 'Уклонили сте.';

  @override
  String get tipMove => 'Помери комад.';

  @override
  String get tipCannotPlace => 'Не можете овде поставити свој комад.';

  @override
  String get tipCannotMove => 'Не можете преместити свој комад овде.';

  @override
  String get tipMill => 'Милл! Узми противникову фигуру.';

  @override
  String get tipContinueMill => 'Наставите да узимате фигуру противника.';

  @override
  String get tipSelectOpponentsPiece => 'Изаберите један од противничких дела.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Не можете уклонити комад из млина.';

  @override
  String get tipCanMoveOnePoint => 'Комад може да помери 1 бод.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Не можете да померате противничке фигуре.';

  @override
  String get tipSelectPieceToMove => 'Изаберите свој комад за премештање.';

  @override
  String get tipHaveThreePiecesLeft => 'Остала су вам три комада.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Можете се преселити у било коју тачку која вам се свиђа.';

  @override
  String tipToMove(Object player) {
    return '$player за померање.';
  }

  @override
  String get whiteWin => 'Играч 1 је победио!';

  @override
  String get blackWin => 'Играч 2 је победио!';

  @override
  String get won => 'Победио';

  @override
  String get lost => 'Изгубио';

  @override
  String get thinking => 'Размишљам…';

  @override
  String get newGame => 'Нова игра';

  @override
  String get importGame => 'Увези игру';

  @override
  String get exportGame => 'Извези игру';

  @override
  String get gameImported => 'Игра увезена.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Није могуће увести $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Потези и правила се не подударају.';

  @override
  String get pleaseWait => 'Сачекајте.';

  @override
  String get restartGame => 'Поново покренути тренутну игру?';

  @override
  String get restart => 'Покрени поново';

  @override
  String get gameStarted => 'Игра је почела, поставите фигуру.';

  @override
  String get analyzing => 'Анализирање…';

  @override
  String error(Object message) {
    return 'Грешка: $message';
  }

  @override
  String get winRate => 'Стопа победа';

  @override
  String get score => 'Резултат:';

  @override
  String get white => 'Играч 1';

  @override
  String get black => 'Играч 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player има мање од 3 фигуре.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player се предао.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player не може да помери ниједну фигуру.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Табла је пуна, а $player нема где да помери фигуру.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Време је истекло, $player је изгубио.';
  }

  @override
  String get drawReasonRule50 =>
      'У фази кретања, ниједан комад није уклоњен у последњем одређеном броју потеза.';

  @override
  String get drawReasonBoardIsFull => 'То је нерешено, јер је табла пуна.';

  @override
  String get drawReasonThreefoldRepetition =>
      'То је нерешено због троструког понављања.';

  @override
  String get gameOverUnknownReason => 'Крај игре! Непознати разлог.';

  @override
  String get gameOver => 'Крај игре';

  @override
  String get youWin => 'Ти си победник! Честитам!';

  @override
  String challengeHarderLevel(int level) {
    return 'Изазовите тежи ниво? Нови ниво ће бити ниво $level!';
  }

  @override
  String get youLose => 'Ти губиш!';

  @override
  String get analyze => 'Анализирајте';

  @override
  String get about => 'О томе';

  @override
  String version(Object versionNumber) {
    return 'Верзија: $versionNumber';
  }

  @override
  String get thanks => 'Хвала';

  @override
  String get settings => 'Подешавања';

  @override
  String get options => 'Опције';

  @override
  String get generalSettings => 'Општа подешавања';

  @override
  String get skillLevel => 'Ниво тешкоће';

  @override
  String get moveTime => 'АИ време размишљања';

  @override
  String get difficulty => 'Тешкоћа';

  @override
  String get playSounds => 'Звучни ефекти';

  @override
  String get playSoundsInTheGame => 'Репродукујте звукове у игри';

  @override
  String get keepMuteWhenTakingBack => 'Останите без звука кад се враћате';

  @override
  String get tone => 'Тоне';

  @override
  String get whoMovesFirst => 'Први потез';

  @override
  String get human => 'Људски';

  @override
  String get ai => 'АИ';

  @override
  String get alternate => 'Алтернате';

  @override
  String get isAutoRestart =>
      'Аутоматско поновно покретање игре по завршетку игре';

  @override
  String get isAutoChangeFirstMove => 'Аутоматска промена првог потеза';

  @override
  String get shufflingEnabled => 'Случајан потез';

  @override
  String get misc => 'Остало';

  @override
  String get rules => 'Правила';

  @override
  String get piecesCount => 'Број комада које има сваки играч';

  @override
  String get piecesCount_Detail => 'Колико комада има сваки играч?';

  @override
  String get flyPieceCount => 'Број летећег комада';

  @override
  String get flyPieceCount_Detail =>
      'Ако је Летење омогућено, када се играч сведе на одређени број комада, њени се делови могу пребацити на било коју ненасељену тачку, уместо да буду ограничени на суседне тачке као у остатку игре.';

  @override
  String get piecesAtLeastCount => 'Најмање комади';

  @override
  String get hasDiagonalLines => 'Дијагоналне линије';

  @override
  String get hasDiagonalLines_Detail =>
      'На плочу додајте четири дијагоналне линије.';

  @override
  String get isDefenderMoveFirst => 'Први се креће други играч';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Играч који се креће други у фази постављања креће се први у фази кретања.';

  @override
  String get mayRemoveMultiple => 'Вишеструко уклањање';

  @override
  String get mayRemoveMultiple_Detail =>
      'Ако играч затвори више млинова одједном, уклониће број млинова које је затворила.';

  @override
  String get mayRemoveFromMillsAlways => 'Уништи млинове';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Подразумевано, играчи морају прво уклонити било који други комад пре него што га уклоне из формираног млина. Омогућите ову опцију да бисте онемогућили ограничење.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Други играч губи када је табла пуна';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Када је табла пуна на крају фазе постављања, она која се прво пласира губи игру. У супротном, игра је нерешена.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Изгубите кад се не повуче ниједан правни потез';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Играч ће изгубити ако их противник блокира тако да се не могу померати. Промените страну да бисте се померили ако је ова опција онемогућена.';

  @override
  String get mayFly => 'Летење';

  @override
  String get mayFly_Detail =>
      'Ако играчу преостају само три или четири (подесива) дела, она може преместити комад у било коју слободну тачку.';

  @override
  String get nMoveRule => 'Правило Н-потеза';

  @override
  String get nMoveRule_Detail =>
      'Игра се извлачи ако није било уклањања у одређеном броју потеза.';

  @override
  String get rollback => 'Поврат';

  @override
  String get pleaseSelect => 'Молимо изаберите';

  @override
  String get copy => 'Копирај';

  @override
  String get moveHistoryCopied =>
      'Преместите историју копирану у привремену меморију.';

  @override
  String get help => 'Помоћ';

  @override
  String get feedback => 'Повратна информација';

  @override
  String get exit => 'Излаз';

  @override
  String get ruleSettings => 'Правила';

  @override
  String get color => 'Боја';

  @override
  String get boardColor => 'Боја плоче';

  @override
  String get pieceColor => 'Комадна боја';

  @override
  String get backgroundColor => 'Боја позадине';

  @override
  String get lineColor => 'Боја линије плоче';

  @override
  String get whitePieceColor => 'Играч 1 комад у боји';

  @override
  String get blackPieceColor => 'Плаиер у 2 комада у боји';

  @override
  String get messageColor => 'Боја поруке';

  @override
  String get isPieceCountInHandShown => 'Покажите број комада у руци';

  @override
  String get isNotationsShown => 'Покажите ознаке на броду';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Прикажи траку са алаткама за навигацију кроз историју';

  @override
  String get display => 'Приказ';

  @override
  String get boardBorderLineWidth => 'Ширина граничне плоче';

  @override
  String get boardInnerLineWidth => 'Ширина унутрашње линије плоче';

  @override
  String get pieceWidth => 'Ширина комада';

  @override
  String get fontSize => 'Величина слова';

  @override
  String get standardNotation => 'Ознака ВМД';

  @override
  String get restore => 'Врати';

  @override
  String get restoreDefaultSettings => 'Вратити подразумеване поставке';

  @override
  String pick(Object element) {
    return 'Изаберите $element';
  }

  @override
  String get info => 'Инфо';

  @override
  String get hint => 'Наговестити';

  @override
  String get player => 'играч';

  @override
  String get player1 => 'Плаиер 1';

  @override
  String get player2 => 'Плаиер 2';

  @override
  String get howToPlay => 'Како играти';

  @override
  String get toPlacePiece =>
      'Додирните било коју доступну тачку да бисте поставили комад.';

  @override
  String get toSelectPiece => 'Додирните комад да бисте га померили.';

  @override
  String get toMovePiece =>
      'Додирните тачку повезану са делом да бисте га померили.';

  @override
  String get toRemovePiece => 'Додирните противников један комад за уклањање.';

  @override
  String get needToCreateMillFirst =>
      'Прво морате да направите млин да бисте могли да уклоните комад.';

  @override
  String get needToPlayWithOwnPieces => 'Треба се играти са својим комадима.';

  @override
  String get statistics => 'Статистика';

  @override
  String get totalGames => 'Укупно игара';

  @override
  String get results => 'Резултати';

  @override
  String get left => 'лево';

  @override
  String get privacyPolicy => 'Правила о приватности';

  @override
  String get privacyPolicy_Detail_1 =>
      'Молимо вас пажљиво прочитајте и уверите се да сте у потпуности разумели и да се слажете са овим ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Ако се не слажете са овом Политиком, немојте је користити. Коришћење апликације подразумева да прихватате ове услове.';

  @override
  String get and => ' и ';

  @override
  String get accept => 'Прихвати';

  @override
  String get takeBack => 'Вратити';

  @override
  String get takingBack => 'Узимање назад…';

  @override
  String get waiting => 'Чекање…';

  @override
  String get stepForward => 'Иступи';

  @override
  String get takeBackAll => 'Врати све';

  @override
  String get stepForwardAll => 'Корак напред';

  @override
  String get moveNow => 'Помери се сада';

  @override
  String get done => 'Готово.';

  @override
  String get crackMill => 'Млин за крекове';

  @override
  String get crackMill_Detail =>
      'Ако играч има само комаде у млиновима, делови у млиновима се неће закључати да би се уклонили.';

  @override
  String get animationDuration => 'Трајање анимације';

  @override
  String get none => 'Ниједан';

  @override
  String get theme => 'Тема';

  @override
  String get helpContent =>
      'Циљ игре је да противник остави са мање од три дела или без правних потеза.\n\nИгра аутоматски црта ако се позиција догоди по трећи пут или не изврши уклањање у последњих 100 (подесивих) потеза.\n\nИгра се одвија у три фазе:\n\n1. Постављање комада на упражњена места\n2. Премештање делова у суседне тачке\n3. (необавезна фаза) Премештање фигура на било које слободно место када се играч смањује на три дела\n\nПласирање\n\nИгра започиње празном плочом која се састоји од мреже са двадесет и четири поена. Играчи наизменично постављају своје фигуре на слободна места све док сваки играч не постави све фигуре на плочу. Ако играч може да постави три своја комада равно, он има „млин“ и може уклонити један од противничких дела са табле.\n\nУ неким правилима, играчи морају прво уклонити било који други комад пре него што га уклоне из формираног млина.\n\nУ неким правилима у фази постављања не можете поново поставити комаде на тачке уклоњених комада.\n\nЈедном када користе све фигуре, играчи се наизменично крећу.\n\nКретање\n\nДа би се кретао, играч помера један од својих делова дуж линије даске до слободног суседног места. Ако то не може, изгубио је утакмицу. Играч који поравна три своја дела на линији плоче има млин и може уклонити један од противничких делова као у фази постављања. Било који играч смањује на два дела, нема могућност да формира нове млинове и тако губи игру. Играч такође може изгубити када има више од три комада ако му га противник блокира у кретању.\n\nЛетење\n\nУ неким варијантама правила, када једном играчу остану само три дела, његови делови могу да лете, скачу или скачу до било којих празних бодова, не само суседних.';

  @override
  String get versionInfo => 'Информације о верзији';

  @override
  String get eula => 'ЕУЛА';

  @override
  String get license => 'Лиценца';

  @override
  String get sourceCode => 'Изворни код';

  @override
  String get appVersion => 'Верзија апликације';

  @override
  String get general => 'Генерал';

  @override
  String get advanced => 'Напредно';

  @override
  String get placing => 'Пласирање';

  @override
  String get moving => 'Кретање';

  @override
  String get removing => 'Уклањање';

  @override
  String get gameOverCondition => 'Игра преко стања';

  @override
  String get aisPlayStyle => 'АИ стил игре';

  @override
  String get passive => 'Пасивно';

  @override
  String get timeout => 'Пауза у утакмици';

  @override
  String get appearance => 'Изглед';

  @override
  String get drawOnHumanExperience => 'Ослоните се на људско искуство';

  @override
  String get considerMobility => 'Узмите у обзир покретљивост комада';

  @override
  String get pieceCount => 'Број комада:';

  @override
  String inHand(Object player, int count) {
    return '$player у руци: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player на броду: $count';
  }

  @override
  String get boardTop => 'Плоча помакнута од врха';

  @override
  String get notAIsTurn => 'Није ред на АИ.';

  @override
  String get aiIsNotThinking => 'АИ не размишља.';

  @override
  String get atEnd => 'На крају сте листе за премештање.';

  @override
  String get tapBackAgainToLeave => 'Додирните поново да бисте изашли.';

  @override
  String get more => 'Више';

  @override
  String get experimental => 'То је експериментална карактеристика.';

  @override
  String get experiments => 'Експерименти';

  @override
  String get ossLicenses => 'Лиценце отвореног кода';

  @override
  String get language => 'Језик';

  @override
  String get defaultLanguage => 'Подразумевани језик';

  @override
  String get mayMoveInPlacingPhase =>
      'Комади се могу померати у фази постављања';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Не постоје различите фазе постављања и померања, тј. Играчи могу при сваком потезу да одлуче да ли желе да поставе комад на плочу или да преместе један од својих делова (уколико имају преостале делове за постављање).';

  @override
  String get drawerColor => 'Боја менија';

  @override
  String get drawerTextColor => 'Боја текста менија';

  @override
  String get drawerHighlightItemColor => 'Боја ставке истицања менија';

  @override
  String get mainToolbarBackgroundColor =>
      'Боја позадине главне траке с алаткама';

  @override
  String get mainToolbarIconColor => 'боја иконе главне траке са алаткама';

  @override
  String get navigationToolbarBackgroundColor =>
      'Боја позадине траке са алаткама за навигацију';

  @override
  String get navigationToolbarIconColor =>
      'Боја иконе траке са алаткама за навигацију';

  @override
  String get autoHideToolbar => 'Аутоматски сакриј траку са алаткама';

  @override
  String get toolbarLocationOnScreen => 'Локација траке са алаткама на екрану';

  @override
  String get top => 'Врх';

  @override
  String get bottom => 'Дно';

  @override
  String get center => 'Центар';

  @override
  String get solidColor => 'Једнобојну';

  @override
  String get picture => 'Слика';

  @override
  String get chooseYourPicture => 'Изаберите своју слику';

  @override
  String get light => 'Светлост';

  @override
  String get dark => 'Тамно';

  @override
  String get themes => 'Теме';

  @override
  String get currentTheme => 'Тренутна тема';

  @override
  String get saveTheme => 'Сачувај тему';

  @override
  String get showAnalysisGraph => 'Прикажи графикон анализе';

  @override
  String get analysis => 'Анализа';

  @override
  String get saveGame => 'Сачувај игру';

  @override
  String get loadGame => 'Учитај игру';

  @override
  String get setupPosition => 'Положај за подешавање';

  @override
  String get showLegalMoves => 'Покажите легалне потезе';

  @override
  String get showLastMove => 'Прикажи последњи потез';

  @override
  String get showArrows => 'Прикажи стрелице';

  @override
  String get pieces => 'Комада';

  @override
  String get showAnalysis => 'Прикажи анализу';

  @override
  String get threads => 'Нити';

  @override
  String get getInvolved => 'Умешати се';

  @override
  String get helpImproveTranslate => 'Помозите да се побољша превод';

  @override
  String get tutorial => 'Приручник';

  @override
  String get classicMill => 'Цлассиц Милл';

  @override
  String get mixedMill => 'Мешани млин';

  @override
  String get ceylonMill => 'Цеилон Милл';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Млин се може више пута ломити и преправљати';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Ако играч разбије млин да би одмах створио нови млин, такав играч може да врати такав комад назад на првобитни спој у свом следећем потезу ако направи нови млин.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Игра се извлачи ако играч има три фигуре, а након десет потеза ниједан играч не уклања противничке фигуре';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Када играч падне на три дела, а ниједан играч не може уклонити противнички комад у року од десет потеза, игра је нерешена.';

  @override
  String get close => 'Близу';

  @override
  String get whitePiece => 'Бели комад';

  @override
  String get blackPiece => 'Црни комад';

  @override
  String get emptyPoint => 'Празна тачка';

  @override
  String get noPoint => 'Нема смисла';

  @override
  String get placingPhase => 'Фаза постављања';

  @override
  String get movingPhase => 'Фаза кретања';

  @override
  String get flyingPhase => 'Фаза летења';

  @override
  String sideToMove(Object player) {
    return 'Страна за кретање: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Последњи потез: $move';
  }

  @override
  String get selected => 'Изабрано';

  @override
  String get accessibility => 'Приступачност';

  @override
  String get screenReaderSupport => 'Подршка за читач екрана';

  @override
  String get isDraw => 'То је реми!';

  @override
  String get draw => 'Нерешено';

  @override
  String get pieceHighlightColor => 'Боја за истакнување на парче';

  @override
  String get algorithm => 'Алгоритам';

  @override
  String get endgameNMoveRule => 'Енд-гаме Н-Мове правило';

  @override
  String get endgameNMoveRule_Detail =>
      'Ако било који играч има само три фигуре и ниједан играч не уклони фигуру у одређеним потезима, игра се извлачи.';

  @override
  String get drawReasonEndgameRule50 =>
      'Било који играч има само три фигуре и ниједан играч не уклања фигуру унутар одређених потеза.';

  @override
  String get threefoldRepetitionRule => 'Правило троструког понављања';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Игра се извлачи ако се позиција појави по трећи пут.';

  @override
  String get continueToMakeMove => 'Милл! Наставите да се крећете.';

  @override
  String get pointStyle => 'Стил поена';

  @override
  String get pointWidth => 'Ширина тачке';

  @override
  String get solid => 'Чврст';

  @override
  String get hollow => 'Холлов';

  @override
  String get languageName => 'Српски';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Мовес',
      one: '$count Помери',
      zero: 'Мове',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Учитавање није успело.';

  @override
  String get filename => 'Назив документа';

  @override
  String get browse => 'Прегледај…';

  @override
  String get gameFiles => 'Фајлови игара';

  @override
  String get gameSavedTo => 'Игра је сачувана на';

  @override
  String get empty => 'Празан';

  @override
  String get noMove => 'Без покрета.';

  @override
  String get restoredPosition => 'Враћена почетна позиција.';

  @override
  String get clean => 'Чист';

  @override
  String get cleanedUp => 'Очишћено.';

  @override
  String get remove => 'Уклони';

  @override
  String get noPiecesCanBeRemoved => 'Ниједан комад се не може уклонити.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '[Кс47Кс] комади',
      one: '[Кс27Кс] комад',
      zero: 'Комад',
    );
    return '$_temp0 треба уклонити.';
  }

  @override
  String placedCount(int count) {
    return 'Пост. ($count)';
  }

  @override
  String get placedPieceCount => 'Број постављених комада у фази постављања.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Тренутни играч је поставио $count комада.';
  }

  @override
  String get notPlacingPhase => 'Фаза не постављања, не може се променити.';

  @override
  String get paste => 'Залепите';

  @override
  String get pasteDone => 'Паста је готова.';

  @override
  String get cannotPaste => 'Није могуће налепити.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Прикажи непостављене и уклоњене делове';

  @override
  String get fullScreen => 'Цео екран';

  @override
  String get reopenToTakeEffect =>
      'Изађите и поново отворите апликацију да би подешавања ступила на снагу.';

  @override
  String get forest => 'Форест';

  @override
  String get desktopImage => 'Слика радне површине';

  @override
  String get invalidPosition => 'Неважећа позиција.';

  @override
  String get shareGIF => 'Поделите ГИФ';

  @override
  String get pixelRatio => 'Однос пиксела';

  @override
  String get duration => 'Трајање';

  @override
  String get gameScreenRecorder => 'Снимач екрана игре';

  @override
  String get previous => 'Претходна';

  @override
  String get next => 'Следећи';

  @override
  String get skip => 'Скип';

  @override
  String get gotIt => 'Схватио сам';

  @override
  String get youCanModifyRules =>
      'Можете да измените правила игре у подешавањима правила.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Можете користити точкић миша да промените вредност у бирачу.';

  @override
  String get noTimeLimitForThinking =>
      'АИ време размишљања постављено на 0 значи да нема временског ограничења за размишљање.';

  @override
  String get whatIsMtdf =>
      'МТД(ф) је модификовани облик алгоритма алфа-бета претраге који има за циљ да побољша ефикасност поновним коришћењем међурезултата претраге и коришћењем доброг почетног нагађања за сужавање простора за претрагу.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Имајте на уму да подешавање времена размишљања АИ можда није сасвим прецизно. Стварно време размишљања може бити краће када је ниво тежине постављен на нижу вредност и може бити дуже када је АИ усред размишљања када време истекне.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Ако поставите висок ниво тежине, али не повећате време размишљања АИ, стварни ниво тежине може бити ограничен на нижу вредност због временског ограничења за размишљање. Стварна вредност може да варира у зависности од перформанси машине.';

  @override
  String get whatIsPvs =>
      'ПВС (Принципал Вариатион Сеарцх) је алгоритам за претрагу за проналажење најбољег потеза у датој позицији. То је побољшање алфа-бета алгоритма и користи нулту или нулту претрагу прозора да потврди да је потез гори или не гори од већ сигурног резултата из главне варијације. ПВС се фокусира на најперспективније потезе и избегава непотребне претраге субоптималних грана, што помаже у побољшању ефикасности претраге.';

  @override
  String get whatIsAlphaBeta =>
      'Алфа-бета алгоритам је алгоритам за претрагу за проналажење најбољег потеза. Користи принцип минимакса и две вредности, алфа и бета, да смањи стабло претраге и повећа ефикасност. Алфа представља минимални резултат за који је рачунар сигуран да може да добије, док бета представља максималан резултат који његов противник може да добије. Алгоритам помаже рачунару да доноси паметне, ефикасне одлуке у игри.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Према људском искуству, ако покушате да победите, изгубићете. Уместо тога, циљајте на реми као свој циљ и избегавајте да изгубите утакмицу. Посматрајте свог противника и нежно га намамите у позицију у којој може погрешити. Када покажу слабост, зграбите прилику и лагано гурајте ка победи. На овај начин можете победити у игри.';

  @override
  String get firstMoveDetail =>
      'У овој игри лакше је други играч да победи у односу на првог играча.';

  @override
  String get passiveDetail =>
      'Омогућавање пасивне опције ће узроковати да се АИ опусти када има предност у позицији, уместо да агресивно покушава да победи што је брже могуће.';

  @override
  String get moveRandomlyDetail =>
      'Омогућавање ове опције повећава случајност и забаву у игри, док њено онемогућавање може помоћи у проучавању начина да се победи вештачка интелигенција.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Ако АИ узме у обзир покретљивост својих фигура, не само да ће имати за циљ да ухвати противничке фигуре што је брже могуће, већ ће размотрити и блокирање покрета противника и спречавање њих да ураде исто.';

  @override
  String get whenBoardIsFull => 'Кад је табла пуна';

  @override
  String get whenBoardIsFull_Detail =>
      'На крају фазе постављања, пре него што почне фаза кретања, следи акција ако је табла пуна комада.';

  @override
  String get sideToMoveRemovePiece =>
      'Играч који се први помери у фази кретања уклања једну од противничких фигура.';

  @override
  String get agreeToDraw => 'Обе стране се слажу са нерешеним резултатом.';

  @override
  String get takeOpponentsPiece => 'Узми једну од противничких фигура.';

  @override
  String get firstPlayerLose => 'Први играч губи игру.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Први и други играч уклањају једну од противничких фигура.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Други и први играч уклањају једну од противничких фигура.';

  @override
  String get enteredFlyingPhase =>
      'Сада када сте ушли у фазу летења, противничке фигуре могу скочити на било коју празну тачку на табли. Можете да искључите правило летења у „Подешавања правила“.';

  @override
  String get whenStalemate => 'Када застој';

  @override
  String get whenStalemate_Detail =>
      'Која радња следи када се ниједан комад не може померити?';

  @override
  String get endWithStalemateLoss => 'Завршите са губитком.';

  @override
  String get changeSideToMove => 'Промените страну да бисте се померили.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Уклоните једну од противничких фигура и направите следећи потез.';

  @override
  String get endWithStalemateDraw => 'Завршите нерешеним резултатом.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Уклоните једну од противничких фигура и промените страну за кретање.';

  @override
  String get aiResponseDelayTime => 'Време кашњења одговора АИ';

  @override
  String get aiIsDelaying =>
      'АИ је тренутно у фази одложеног одговора. Сачекајте неко време пре него што наставите.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Не можете уклонити несуседни комад.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Ако дође до застоја, противничке фигуре које се налазе поред ваших могу бити уклоњене, без обзира на формацију млина.';

  @override
  String get whatIsMcts =>
      'МЦТС је алгоритам прилагођен почетницима који доноси одлуке истражујући и процењујући различите потезе кроз симулације.';

  @override
  String get goldenJade => 'Голден Јаде';

  @override
  String get forestWood => 'Форест Воод';

  @override
  String get darkMystery => 'Дарк Мистери';

  @override
  String get midnightBlue => 'Поноћно плава';

  @override
  String get greenForest => 'Греен Форест';

  @override
  String get greenMeadow => 'Зелена ливада';

  @override
  String get stonyPath => 'Стони Патх';

  @override
  String get pastelPink => 'Пастел Пинк';

  @override
  String get turquoiseSea => 'Тиркизно море';

  @override
  String get violetDream => 'Виолет Дреам';

  @override
  String get mintChocolate => 'Минт Цхоцолате';

  @override
  String get skyBlue => 'Небеско плаветнило';

  @override
  String get playfulGarden => 'Плаифул Гарден';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Алгоритам ретроградне анализе користи ретроградну анализу са више вредности да би направио базу података за крај игре са различитиһ почетниһ позиција, а затим примењује ову базу података да би оптимизовао игру. Овај приступ спада у категорију ултра-јакиһ решења.';

  @override
  String get viewAlgorithmGuide =>
      'Да ли желите да видите упутство за употребу за овај алгоритам?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Прикажи индикатор позиционе предности';

  @override
  String get usePerfectDatabase => 'Користите савршену базу података';

  @override
  String get perfectDatabaseDescription =>
      'Омогућите ову опцију да бисте користили беспрекорну базу података игара генерисану помоћу најсавременијих алгоритама. Ова функција интегрише стратегије отварања и завршнице како би предложила оптималне потезе. Ово је пожељан избор за играче који траже највиши ниво прецизности у игри. Креирана кроз прецизне рачунарске технике, база података је дизајнирана да понуди скоро савршена решења за игре.\n\nНапомена: Ако вештачка интелигенција не успе да приступи бази података, она ће се обратити конвенционалним алгоритмима за доношење одлука о игри. Када је база података доступна, „ниво тежине“ постаје практично непобедив, а „време размишљања АИ“ доживљава драстично смањење. Многа подешавања у оквиру опција „АИ\'с Плаистиле“ ће бити замењена, пошто резултати базе података имају највећи приоритет.\n\nЗа упутства о томе како да максимално искористите ову беспрекорну базу података, кликните овде.';

  @override
  String get backgroundImage => 'Позадинска слика';

  @override
  String get whatIsRandom =>
      'Када опција \'Користи савршену базу података\' није омогућена, поставка \'Рандом\' доводи до тога да АИ насумично помера комаде без употребе алгоритама за одабир померања. Ово обично доводи до знатно слабије игре. Насупрот томе, када је „Користи савршену базу података“ омогућено, АИ се искључиво ослања на „Савршену базу података“ за доношење одлука, уместо да је меша са традиционалним АИ алгоритмима. У овом режиму, потези АИ су у потпуности засновани на садржају базе података, избегавајући ослањање на прорачуне у реалном времену или алгоритме за претрагу.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Уклоните противничке фигуре из његове/њене руке; затим је противник на реду да постави фигуру.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Када се формирају млинови током фазе постављања';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Уклоните противничке фигуре са табле.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Уклоните противничке фигуре са табле; затим је противник на реду да постави.';

  @override
  String get opponentRemovesOwnPiece =>
      'Противник уклања своје фигуре са табле.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Уместо да ви предузмете акцију, противник бира и уклања своје фигуре са табле, ефективно предузимајући акцију која је штетна за њега самог.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Уклони противничке фигуре из његове/њене руке; затим сте ви на потезу.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Уклоните фигуру(е) из противникове руке. Ако, према подешавању вишеструког уклањања, треба уклонити више фигура, а противник нема више фигура у руци, наставите да уклањате противничке фигуре са табле. Затим сте ви на потезу. Ако наставите да формирате млинове, можете наставити да уклањате противничке фигуре.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Уклоните фигуру(е) из противникове руке. Ако, према подешавању вишеструког уклањања, треба уклонити више фигура, а противник нема више фигура у руци, наставите да уклањате противничке фигуре са табле. Затим је противник на потезу.';

  @override
  String get markAndDelayRemovingPieces =>
      'Означите и одложите уклањање фигура.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Током фазе постављања, фигуре које треба уклонити се обележавају и ни један играч не може да постави нове фигуре на ове тачке. По уласку у фазу померања, ове означене фигуре се у потпуности уклањају, а играчи тада могу да помере своје фигуре на ове сада празне тачке.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Акције које се могу предузети приликом формирања млинова у фази постављања.';

  @override
  String get marked => 'Означено';

  @override
  String get menu => 'Мени';

  @override
  String get monochrome => 'Монокром';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Možete uključiti podršku za čitač ekrana u podešavanjima pristupačnosti unutar Opštih podešavanja.';

  @override
  String get showNumbersOnPieces => 'Приказ бројева на фигурама';

  @override
  String get saveImage => 'Сачувај слику';

  @override
  String get isAnalysisToolbarShown => 'Прикажи траку алатки за анализу';

  @override
  String get analysisToolbarBackgroundColor =>
      'Боја позадине траке алатки за анализу';

  @override
  String get analysisToolbarIconColor => 'Боја иконе траке алатки за анализу';

  @override
  String get transformed => 'Трансформисано.';

  @override
  String get cannotTransform => 'Не може да се трансформише.';

  @override
  String get rotate => 'Ротација';

  @override
  String get horizontalFlip => 'Х. прев.';

  @override
  String get verticalFlip => 'В. прев.';

  @override
  String get innerOuterFlip => 'У/С прев.';

  @override
  String get transparentCanvas => 'Прозирно Платно';

  @override
  String get restrictRepeatedMillsFormation =>
      'Ограничите поновљено формирање млинова';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Фигура која је премештена из једног млина у други не може одмах да се врати на почетну тачку у следећем потезу да би поново формирала млин. Прво је потребан другачији потез.';

  @override
  String get oneTimeUseMill => 'Једнократна употреба млина';

  @override
  String get oneTimeUseMill_Detail =>
      'Сваки млин може уклонити само један део противника. Можете га поново формирати, али се не може користити за додатна уклањања.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Тренутна правила која сте поставили немају одговарајућу савршену базу података. За више информација о савршеној бази података кликните овде.';

  @override
  String get focusOnBlockingPaths => 'Фокусирајте се на блокирање путева';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Prioritet dajte ometanju kretanja protivnika umesto formiranja tri u nizu. Umesto da se fokusira na uklanjanje figura dovršavanjem tri u nizu, AI nastoji da uhvati protivnika u zamku, onemogućavajući mu kretanje i osiguravajući pobedu kroz iscrpljivanje umesto agresivne igre. Ova strategija ne blokira aktivno protivničke tri u nizu.';

  @override
  String get pieceImage => 'Слика фигуре';

  @override
  String get importColorSettings => 'Увези подешавања боја';

  @override
  String get exportColorSettings => 'Извези подешавања боја';

  @override
  String get import => 'Увези';

  @override
  String get export => 'Извези';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Молимо копирајте подешавања формата JSON у привремену меморију.';

  @override
  String get copiedToClipboard => 'Копирано у привремену меморију.';

  @override
  String get imported => 'Увезено.';

  @override
  String get boardImage => 'Слика табле';

  @override
  String get autumnLeaves => 'Јесење Листје';

  @override
  String get legendaryLand => 'Легендарна Земља';

  @override
  String get vignetteEffect => 'Ефекат винјете';

  @override
  String get promptMakeToolbarTransparent =>
      'Da li želite da alatna traka bude potpuno providna kada je postavljena pozadinska slika table?';

  @override
  String get vibration => 'Омогући вибрације у игри';

  @override
  String get soundTheme => 'Zvucna tema';

  @override
  String get ball => 'Lopta';

  @override
  String get liquid => 'Tečnost';

  @override
  String get wood => 'Drvo';

  @override
  String get placeEffectAnimation => 'Анимациони ефекат постављања фигуре';

  @override
  String get removeEffectAnimation => 'Анимациони ефекат уклањања фигуре';

  @override
  String get isToolbarAtBottom => 'Прикажи алатну траку на дну';

  @override
  String get boardCornerRadius => 'Радијус угла табле';

  @override
  String get useOpeningBook => 'Користите књигу отварања';

  @override
  String get currentRule => 'Текући';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Сет правила';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Dozvolite AI-u da koristi otvarajuće poteze koji su uobičajeni među profesionalnim ljudskim igračima u ranim fazama igre. Napomena: Ova funkcija trenutno je dostupna samo za određene skupove pravila.';

  @override
  String get showAdvantageGraph => 'Prikaži grafikon prednosti';

  @override
  String get advantageGraphHint =>
      'Grafikon prednosti će biti nacrtan samo nakon što veštačka inteligencija povuče potez. Neće biti nacrtan kada ljudski igrač povuče potez.';

  @override
  String get removalBasedOnMillCounts =>
      'Onemogućite uklanjanje dok sve figure ne budu postavljene. Igrači uklanjaju figure na osnovu broja mlinova.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Onemogućite uklanjanje dok sve figure ne budu postavljene. Igrači uklanjaju figure na osnovu broja mlinova: ako je broj jednak, oba uklanjaju isti broj figura; ako jedan ima više, uklanja dodatnu figuru da zadrži razliku od jedne figure. Ako samo jedan formira mlin, uklanja dve figure, a drugi jednu. Ako nijedan ne formira mlin, oba uklanjaju po jednu figuru.';

  @override
  String get elfilja => 'Ел Фиљџа';

  @override
  String get tipSelectOwnPiece => 'Изаберите једну од својих фигура.';

  @override
  String get notYourTurn => 'Није ваш потез.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Боја позадине алатне траке за белешке';

  @override
  String get annotationToolbarIconColor => 'Боја иконе алатне траке за белешке';

  @override
  String get isAnnotationToolbarShown => 'Прикажи алатну траку за белешке';

  @override
  String get enterAnnotationMode => 'Уђи у режим белешке';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Да ли сте сигурни да желите да обришете све белешке?';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM упит је копиран у међуспремник.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Веза је одбијена, сервер можда не ради.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Откривање успешно, чека се веза...';

  @override
  String get noLanConnection => 'Нема ЛАН везе';

  @override
  String get takeScreenshot => 'Направите снимак екрана';

  @override
  String get disconnectedFromOpponent => 'Веза са противником је прекинута.';

  @override
  String get takeBackRequest => 'Захтев за враћање потеза';

  @override
  String get nothingToShow => 'Ништа за приказ.';

  @override
  String get stopHosting => 'Прекините хостовање';

  @override
  String get connectionResetByPeer =>
      'Веза је ресетована од стране друге стране.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Веза је изгубљена због истека времена за хеартбеат. Молимо, поново се повежите.';

  @override
  String get startHosting => 'Започни хостовање';

  @override
  String get restartRequestRejected =>
      'Захтев за поновно покретање је одбијен.';

  @override
  String get notConnectedToLanOpponent => 'Нисте повезани са ЛАН противником.';

  @override
  String get llmPrompt => 'LLM упит';

  @override
  String get gameRestarted => 'Игра је поново покренута.';

  @override
  String get takeBackRejected => 'Враћање потеза је одбијено.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Да ли сте сигурни да желите да се предате у овој игри?';

  @override
  String get opponentResignedYouWin => 'Противник се предао. Побеђујете!';

  @override
  String get clearAllAnnotations => 'Обришите све белешке';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Повеzano, чека се потез противника...';

  @override
  String get networkStatusDisconnected => 'Статус мреже: Веза прекинута';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Захтев за враћање потеза послат је противнику.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Противник је можда напустио игру';

  @override
  String get connectedToHostSuccessfully => 'Успешно повезан са домаћином.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Веза изгубљена: истекао је временски рок за хеартбеат.';

  @override
  String get noHostDiscovered => 'Нема пронађених домаћина.';

  @override
  String get confirmResignation => 'Потврдите предају';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Хостовање игре је започето, чека се да се играчи придруже...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Веза је истекла, мрежна веза је нестабилна.';

  @override
  String get noLlmPromptAvailable => 'Нема доступног LLM упита.';

  @override
  String get youResignedGameOver => 'Предали сте се. Игра је завршена.';

  @override
  String get serverIp => 'IP адреса сервера';

  @override
  String get confirmClear => 'Потврдите брисање';

  @override
  String get opponentSTurn => 'Потез противника.';

  @override
  String get waitingAClientConnection => 'Чека се конекција клијента...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Захтев за враћање потеза је одбијен или није успео.';

  @override
  String get addText => 'Додај текст';

  @override
  String get exitAnnotationMode => 'Изађи из режима белешке';

  @override
  String get typeYourAnnotation => 'Унесите своју белешку';

  @override
  String get attemptingToReconnect => 'Покушава се поновно повезивање...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Захтев за поновно покретање послат је. Чека се одговор противника...';

  @override
  String get serverIsStopped => 'Сервер је заустављен.';

  @override
  String get restartRequest => 'Захтев за поновно покретање';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Не можете затражити враћање потеза када није ваш потез.';

  @override
  String get takeBackAccepted => 'Враћање потеза је прихваћено.';

  @override
  String get localNetworkSettings => 'Подешавања локалне мреже';

  @override
  String get reconnectedSuccessfully => 'Успешно сте поново повезани!';

  @override
  String get failedToSaveImageToGallery =>
      'Снимање слике у галерију није успело.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Противник је затражио поновно покретање игре. Да ли прихватате?';

  @override
  String get yourTurn => 'Ваш потез.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Није могуће поново повезивање, молимо поново покрените игру.';

  @override
  String get host => 'Домаћин';

  @override
  String get join => 'Придружи се';

  @override
  String get port => 'Порт';

  @override
  String get invalidIpAddress => 'Неважећа IP адреса.';

  @override
  String get invalidPort => 'Неважећи порт.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Повезивање: покушај $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Повезивање није успело: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Покретање хостовања није успело: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Откривен домаћин: $ip:$port';
  }

  @override
  String get stop => 'Заустави';

  @override
  String get discover => 'Откриј';

  @override
  String get connect => 'Повежи се';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Клијент се повезао: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Откривање: $seconds с';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Поновно повезивање ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Повеzano';

  @override
  String get delete => 'Избриши';

  @override
  String get ancientEgypt => 'Древни Египат';

  @override
  String get gothicIce => 'Готски Лед';

  @override
  String get riceField => 'Поље Пиринча';

  @override
  String get chinesePorcelain => 'Кинески Порцелан';

  @override
  String get desertDusk => 'Пустињски Сумрак';

  @override
  String get precisionCraft => 'Прецизни Занат';

  @override
  String get folkEmbroidery => 'Народни Вез';

  @override
  String get carpathianHeritage => 'Карпатско Наслеђе';

  @override
  String get imperialGrandeur => 'Империјална Величанственост';

  @override
  String get bohemianCrystal => 'Боемски Кристал';

  @override
  String get savannaSunrise => 'Савански Излазак Сунца';

  @override
  String get harmonyBalance => 'Хармонија и Равнотежа';

  @override
  String get cinnamonSpice => 'Цимет Зачин';

  @override
  String get anatolianMosaic => 'Анатолијски Мозаик';

  @override
  String get carnivalSpirit => 'Карневалски Дух';

  @override
  String get custom => 'Обичај';

  @override
  String get spiceMarket => 'Пијаца зачина';

  @override
  String get swipeToRevealTheDrawer => 'Повуците да откријете фиоку';

  @override
  String get showGameInfoOnScreenshots =>
      'Прикажи информације о игри на снимцима екрана';

  @override
  String get humanMoveTime => 'Временско ограничење за људски потез';

  @override
  String get noTimeLimitForHumanMoves =>
      'Нема временског ограничења за људске потезе';

  @override
  String get timeoutLoseWillBeApplied =>
      'Губитак због истека времена ће бити примењен за људског играча';

  @override
  String get identifyingBoard => 'Identifikujem tablu...';

  @override
  String get youCanEnterAnyModelName => 'Možete uneti bilo koje ime modela.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Pozicija table primenjena. FEN je kopiran u međuspremnik.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Predlog: pokušajte da uslikate jasniju fotografiju table.';

  @override
  String get llmPromptTemplate => 'LLM šablon upita';

  @override
  String get noValidBoardDetected => 'Nije detektovana validna tabla.';

  @override
  String get selectingImageFromAlbum => 'Odabir slike iz albuma...';

  @override
  String get configurePromptTemplate => 'Podesi šablon upita';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Izmeni šablon upita za LLM analizu';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Nije uspelo generisanje FEN‑a iz prepoznate table.';

  @override
  String get outputInCurrentLanguage => 'Izlaz na trenutnom jeziku';

  @override
  String get commonBaseUrls => 'Uobičajeni Base URL‑ovi';

  @override
  String get viewCommonModels => 'Pogledaj uobičajene modele';

  @override
  String get recognitionParametersUpdated =>
      'Parametri prepoznavanja ažurirani.';

  @override
  String get whiteSMove => 'Potez belog';

  @override
  String get resetToDefaults => 'Vrati na podrazumevana podešavanja';

  @override
  String get photoShoot => 'Snimanje fotografije';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Nije uspelo primenjivanje prepoznate pozicije table.';

  @override
  String get llmPromptContent => 'LLM sadržaj upita';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM nije konfigurisano. Proverite podešavanja.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Postavite provajdera, model, API Key i Base URL';

  @override
  String get llmConfiguration => 'LLM konfiguracija';

  @override
  String get configureLlmProvider => 'Podesi LLM provajdera';

  @override
  String get llmPromptTemplateHeader => 'Zaglavlje LLM šablona upita';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Niti jedna figurica nije prepoznata na slici. Pokušajte ponovo.';

  @override
  String get recognizeBoardFromImage => 'Prepoznaj tablu sa slike';

  @override
  String get viewTips => 'Pogledaj savete';

  @override
  String get applyToBoard => 'Primeni na tablu';

  @override
  String get adjustBoardArea => 'Prilagodi oblast table';

  @override
  String get viewCommonUrls => 'Pogledaj uobičajene URL‑ove';

  @override
  String get colorAnalysisFailed => 'Analiza boja nije uspela!';

  @override
  String get analyzingGameBoardImage => 'Analiziram sliku table...';

  @override
  String get selectFromAlbum => 'Izaberi iz albuma';

  @override
  String get noBoardPointDetected => 'Nije detektovana nijedna tačka table!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Ako ostane prazno, koristiće se podrazumevani šablon';

  @override
  String get llmConfig => 'LLM konfiguracija';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Da li ste sigurni da želite da vratite šablone upita na podrazumevane vrednosti?';

  @override
  String get llmPromptTemplateFooter => 'Fusnota LLM šablona upita';

  @override
  String get loadingResponse => 'Učitavam odgovor...';

  @override
  String get applyThisResultToBoard => 'Primeni ovaj rezultat na tablu';

  @override
  String get takingPicture => 'Pravim fotografiju...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Odaberite sliku table igre za prepoznavanje';

  @override
  String get identificationResults => 'Rezultati prepoznavanja';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analizirajte poteze i pružite uvide.';

  @override
  String get getApiKey => 'Preuzmi API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Cela procedura prepoznavanja nije uspela da se kompletira.';

  @override
  String get boardRecognitionResult => 'Rezultat prepoznavanja table';

  @override
  String get askLlm => 'Pitajte LLM';

  @override
  String get boardDetectionFailed => 'Detekcija table nije uspela!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Nijedna tačka table nije detektovana, ne mogu prepoznati figuricu!';

  @override
  String get copyFen => 'Kopiraj FEN';

  @override
  String get commonlyUsedModels => 'Često korišćeni modeli';

  @override
  String get apiKeyOptional => 'API Key (opciono)';

  @override
  String get noImageSelected => 'Nije odabrana nijedna slika';

  @override
  String get blackSMove => 'Potez crnog';

  @override
  String get llm => 'Veliki jezički model';

  @override
  String get llmProvider => 'Pružalac';

  @override
  String get baseUrl => 'Osnovni URL';

  @override
  String get model => 'Model';

  @override
  String get temperature => 'Temperatura';

  @override
  String get llmCommandReceivedProcessing =>
      'Naredba primljena! AI obrađuje...';

  @override
  String get llmDeepThinkingWait =>
      'U toku je duboko razmišljanje, molimo sačekajte...';

  @override
  String get llmPresentingSoon => 'Biće uskoro prikazano...';

  @override
  String get recognitionParameters => 'Parametri prepoznavanja';

  @override
  String get adjustParamsDesc =>
      'Podesite parametre radi poboljšanja tačnosti prepoznavanja';

  @override
  String get saveParameters => 'Sačuvaj parametre';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Nije moguće pokrenuti prepoznavanje slike: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Prepoznavanje slike nije uspelo: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Primljena pozicija sa $whiteCount belih i $blackCount crnih figura';
  }

  @override
  String get fenCopiedToClipboard => '(FEN je kopiran u međumemoriju)';

  @override
  String recognitionFailed(String error) {
    return 'Prepoznavanje nije uspelo: $error';
  }

  @override
  String get myRating => 'Мој рејтинг';

  @override
  String get gamesPlayed => 'Одигране игре';

  @override
  String get wins => 'Победе';

  @override
  String get losses => 'Порази';

  @override
  String get draws => 'Нерешено';

  @override
  String get lastUpdated => 'Последње ажурирање';

  @override
  String get format => 'Формат:';

  @override
  String get resetStatistics => 'Ресетуј статистику';

  @override
  String get drawRate => 'Стопа нерешених';

  @override
  String get lossRate => 'Стопа пораза';

  @override
  String get aiStatistics => 'АИ статистика';

  @override
  String get enableStatistics => 'Омогући статистику';

  @override
  String get enableStatistics_Detail =>
      'Када је омогућено, резултати игре ће бити забележени у статистици. Међутим, игре које укључују враћање потеза неће бити забележене. Када је онемогућено, прикупљање статистике је паузирано.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Ово ће ресетовати сву статистику игре. Ова радња се не може опозвати.';

  @override
  String get boardInnerRingSize => 'Величина унутрашњег прстена табле';

  @override
  String get boardShadowEnabled => 'Сенка табле';

  @override
  String get trapAwareness => 'Откривање замки';

  @override
  String get trapAwarenessDescription =>
      'Истакни потезе замке дебелим круговима и стрелицама током анализе.';

  @override
  String trapExists(String trapMoves) {
    return 'Постоји замка. Потези замке: $trapMoves';
  }

  @override
  String get custodianCapture => 'Заробљавање';

  @override
  String get custodianCaptureDescription =>
      'Приложите један од својих противничких комада између два вашег у правој линији да бисте га ухватили.';

  @override
  String get custodianCaptureEnable => 'Дозволите заробљавање бокресања';

  @override
  String get interventionCapture => 'Снимање интервенције';

  @override
  String get interventionCaptureDescription =>
      'Пређите у празну тачку између два дела вашег противника да их обоје ухвати.';

  @override
  String get interventionCaptureEnable => 'Дозволите снимање интервенција';

  @override
  String get leapCapture => 'Скок заробљавање';

  @override
  String get leapCaptureDescription =>
      'Хватање скоком преко суседног противника у празну тачку даље.';

  @override
  String get leapCaptureEnable => 'Дозволи снимање скока';

  @override
  String get captureApplicableLines => 'Применљиве линије';

  @override
  String get captureSquareEdges => 'Дуж квадратних ивица';

  @override
  String get captureCrossLines => 'Дуж ортогоналних линија прелазећи квадрат';

  @override
  String get captureDiagonalLines =>
      'Дуж дијагоналних линија прелазећи квадрат';

  @override
  String get captureExecutionPhases => 'Фазе извршења';

  @override
  String get capturePiecesCondition =>
      'Доступност током покретне фазе на основу преосталих комада';

  @override
  String get capturePiecesConditionUnlimited => 'Нема ограничења';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Доступно када имате три или мање комада';
}
