// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Albanian (`sq`).
class SSq extends S {
  SSq([String locale = 'sq']) : super(locale);

  @override
  String get appName => 'Mulli';

  @override
  String get welcome => 'Mirëseardhje';

  @override
  String get yes => 'po';

  @override
  String get no => 'Jo';

  @override
  String get game => 'Lojë';

  @override
  String get humanVsAi => 'Njeriu Vs AI';

  @override
  String get humanVsHuman => 'Njeriu Vs Njeriu';

  @override
  String get aiVsAi => 'AI Vs AI';

  @override
  String get humanVsCloud => 'Re njerëzore Vs';

  @override
  String get humanVsLAN => 'LAN i njeriut Vs';

  @override
  String get testViaLAN => 'Test përmes LAN';

  @override
  String get move => 'Lëviz';

  @override
  String get showMoveList => 'Zhvendos listën';

  @override
  String get moveList => 'Zhvendos listën';

  @override
  String get noGameRecord => 'Asnje rekord';

  @override
  String get ok => 'Ne rregull';

  @override
  String get confirm => 'Konfirmo';

  @override
  String get cancel => 'Anulo';

  @override
  String get tipSelectWrong => 'Zgjidhni pjesën e gabuar.';

  @override
  String get tipPlace => 'Vendosni pjesët tuaja.';

  @override
  String get tipBanPlace => 'Nuk mund ta vendos këtu.';

  @override
  String get tipPlaced => 'Ju vendosët një copë shahu.';

  @override
  String get tipRemove => 'Hiqni një copë.';

  @override
  String get tipBanRemove => 'Ju nuk mund ta hiqni atë.';

  @override
  String get tipRemoved => 'Ju hiqët.';

  @override
  String get tipMove => 'Lëviz një copë.';

  @override
  String get tipCannotPlace => 'Ju nuk mund ta vendosni copën tuaj këtu.';

  @override
  String get tipCannotMove => 'Ju nuk mund ta lëvizni copën tuaj këtu.';

  @override
  String get tipMill => 'Mulli! Merrni copën e kundërshtarit tuaj.';

  @override
  String get tipContinueMill =>
      'Vazhdoni të merrni pjesën e kundërshtarit tuaj.';

  @override
  String get tipSelectOpponentsPiece =>
      'Zgjidhni një nga pjesët e kundërshtarit tuaj.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Ju nuk mund të hiqni një copë nga një mulli.';

  @override
  String get tipCanMoveOnePoint => 'Një pjesë mund të lëvizë 1 pikë.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Ju nuk mund të lëvizni copat e kundërshtarit tuaj.';

  @override
  String get tipSelectPieceToMove => 'Zgjidhni pjesën tuaj për të lëvizur.';

  @override
  String get tipHaveThreePiecesLeft => 'Ju kanë mbetur 3 copë.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Ju mund të lëvizni në çdo pikë që ju pëlqen.';

  @override
  String tipToMove(Object player) {
    return '$player për të lëvizur.';
  }

  @override
  String get whiteWin => 'Lojtari 1 fiton!';

  @override
  String get blackWin => 'Lojtari 2 fiton!';

  @override
  String get won => 'Fitoi';

  @override
  String get lost => 'I humbur';

  @override
  String get thinking => 'Duke menduar…';

  @override
  String get newGame => 'Lojë e re';

  @override
  String get importGame => 'Importo lojën';

  @override
  String get exportGame => 'Lojë eksportuese';

  @override
  String get gameImported => 'Lojë e importuar.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Nuk mund të importohet $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Lëvizjet dhe rregullat nuk përputhen.';

  @override
  String get pleaseWait => 'Te lutem prit...';

  @override
  String get restartGame => 'Të riniset loja aktuale?';

  @override
  String get restart => 'Rifillo, fillo përsëri';

  @override
  String get gameStarted => 'Loja filloi, ju lutem vendosni.';

  @override
  String get analyzing => 'Duke analizuar…';

  @override
  String error(Object message) {
    return 'Gabim: $message';
  }

  @override
  String get winRate => 'Fito fitimin';

  @override
  String get score => 'Rezultati:';

  @override
  String get white => 'Lojtari 1';

  @override
  String get black => 'Lojtari 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return 'Numri i pjesëve $player është më pak se tre.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player dha dorëheqjen.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player nuk ka se si të shkojë.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Bordi është plot dhe $player nuk ka se si të shkojë.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Koha ka mbaruar, $player ka humbur.';
  }

  @override
  String get drawReasonRule50 =>
      'Në fazën e lëvizjes, asnjë pjesë nuk është hequr në numrin e fundit specifik të lëvizjeve.';

  @override
  String get drawReasonBoardIsFull =>
      'Isshtë një Vizatim sepse tabela është plot。';

  @override
  String get drawReasonThreefoldRepetition =>
      'Isshtë një barazim për shkak të përsëritjes së trefishtë.';

  @override
  String get gameOverUnknownReason => 'Loja mbaroi! Arsye e panjohur.';

  @override
  String get gameOver => 'Loja mbaroi';

  @override
  String get youWin => 'Ti fitove! Urime!';

  @override
  String challengeHarderLevel(int level) {
    return 'Sfidoni nivelin më të vështirë? Niveli i ri do të jetë niveli $level!';
  }

  @override
  String get youLose => 'Ti humbe!';

  @override
  String get analyze => 'Analizoni';

  @override
  String get about => 'Rreth';

  @override
  String version(Object versionNumber) {
    return 'Versioni: $versionNumber';
  }

  @override
  String get thanks => 'Faleminderit';

  @override
  String get settings => 'Cilësimet';

  @override
  String get options => 'Opsione';

  @override
  String get generalSettings => 'Cilësimet e përgjithshme';

  @override
  String get skillLevel => 'Niveli i vështirësisë';

  @override
  String get moveTime => 'Koha e të menduarit në AI';

  @override
  String get difficulty => 'Vështirësia';

  @override
  String get playSounds => 'Efektet e zërit';

  @override
  String get playSoundsInTheGame => 'Luaj tingujt në lojë';

  @override
  String get keepMuteWhenTakingBack => 'Mbani memec kur merrni përsëri';

  @override
  String get tone => 'Ton';

  @override
  String get whoMovesFirst => 'Lëvizja e parë';

  @override
  String get human => 'Njeriu';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Alternative';

  @override
  String get isAutoRestart => 'Rinis automatikisht lojën kur loja mbaron';

  @override
  String get isAutoChangeFirstMove => 'Ndryshimi automatik i lëvizjes së parë';

  @override
  String get shufflingEnabled => 'Lëvizje e rastësishme';

  @override
  String get misc => 'Të ndryshme';

  @override
  String get rules => 'Rregullat';

  @override
  String get piecesCount => 'Numri i pjesëve që ka secili lojtar';

  @override
  String get piecesCount_Detail => 'Sa pjesë ka secili lojtar?';

  @override
  String get flyPieceCount => 'Numri i pjesës fluturuese';

  @override
  String get flyPieceCount_Detail =>
      'Nëse Fluturimi është i aktivizuar, kur një lojtar zvogëlohet në një numër specifik të pjesëve, pjesët e saj janë të lira të lëvizin në çdo pikë të zënë në vend që të kufizohen në pikat ngjitur si në pjesën tjetër të lojës.';

  @override
  String get piecesAtLeastCount => 'Pjesë Të paktën';

  @override
  String get hasDiagonalLines => 'Vijat diagonale';

  @override
  String get hasDiagonalLines_Detail =>
      'Shtoni katër vija diagonale në tabelë.';

  @override
  String get isDefenderMoveFirst => 'Lojtari i dytë lëviz i pari';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Lojtari që lëviz i dyti në fazën e vendosjes lëviz i pari në fazën e lëvizjes.';

  @override
  String get mayRemoveMultiple => 'Shumë-hiqni';

  @override
  String get mayRemoveMultiple_Detail =>
      'Nëse një lojtar mbyll më shumë se një mulli në të njëjtën kohë, ajo do të jetë në gjendje të heq numrin e mullinjve që mbylli.';

  @override
  String get mayRemoveFromMillsAlways => 'Shkatërroni mullinjtë';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Si parazgjedhje, lojtarët duhet të heqin çdo pjesë tjetër së pari para se të heqin një copë nga një mulli i formuar. Aktivizoni këtë mundësi për të çaktivizuar kufizimin.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Lojtari i dytë humbet kur bordi është i mbushur';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Në fund të fazës së vendosjes, kur tabela është e mbushur, pala që vendoset e para humb lojën, përndryshe, loja është barazim.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Humb kur nuk ka lëvizje ligjore';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Lojtari do të humbasë nëse kundërshtari i bllokon ata në mënyrë që ata të mos lëvizen. Ndryshoni anën për të lëvizur nëse ky opsion është me aftësi të kufizuara.';

  @override
  String get mayFly => 'Fluturimi';

  @override
  String get mayFly_Detail =>
      'Nëse një lojtar i kanë mbetur vetëm tre ose katër pjesë (të rregullueshme), ajo mund ta zhvendosë pjesën në ndonjë pikë të lirë.';

  @override
  String get nMoveRule => 'Rregulli i lëvizjes N';

  @override
  String get nMoveRule_Detail =>
      'Loja është tërhequr nëse nuk ka pasur heqje në një numër të caktuar lëvizjesh nga secili lojtar.';

  @override
  String get rollback => 'Rikthim mbrapa';

  @override
  String get pleaseSelect => 'Ju lutem zgjidhni';

  @override
  String get copy => 'Kopjoni';

  @override
  String get moveHistoryCopied => 'Zhvendos historinë e kopjuar në clipboard.';

  @override
  String get help => 'Ndihmoni';

  @override
  String get feedback => 'Reagime';

  @override
  String get exit => 'Dalja';

  @override
  String get ruleSettings => 'Rregullat';

  @override
  String get color => 'Ngjyrë';

  @override
  String get boardColor => 'Ngjyra e bordit';

  @override
  String get pieceColor => 'Ngjyra e copës';

  @override
  String get backgroundColor => 'Ngjyrë e sfondit';

  @override
  String get lineColor => 'Ngjyra e vijës së bordit';

  @override
  String get whitePieceColor => 'Lojtar 1 ngjyrë copë';

  @override
  String get blackPieceColor => 'Lojtar 2 ngjyra copë';

  @override
  String get messageColor => 'Ngjyra e mesazhit';

  @override
  String get isPieceCountInHandShown => 'Trego numrin e pjesëve në dorë';

  @override
  String get isNotationsShown => 'Trego shënimet në bord';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Shfaq shiritin e mjeteve të navigimit të historisë';

  @override
  String get display => 'Ekran';

  @override
  String get boardBorderLineWidth => 'Gjerësia e kufirit të bordit';

  @override
  String get boardInnerLineWidth => 'Gjerësia e linjës së brendshme të bordit';

  @override
  String get pieceWidth => 'Gjerësia e copës';

  @override
  String get fontSize => 'Përmasa e germave';

  @override
  String get standardNotation => 'Shënimi i WMD';

  @override
  String get restore => 'Rikthe';

  @override
  String get restoreDefaultSettings => 'Rikthe cilësimet e parazgjedhura';

  @override
  String pick(Object element) {
    return 'Zgjidh $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Aluzion';

  @override
  String get player => 'lojtar';

  @override
  String get player1 => 'Lojtari 1';

  @override
  String get player2 => 'Lojtari 2';

  @override
  String get howToPlay => 'Si të luajmë';

  @override
  String get toPlacePiece =>
      'Trokitni lehtë mbi çdo pikë të disponueshme për të vendosur pjesën.';

  @override
  String get toSelectPiece => 'Trokitni lehtë mbi një pjesë për ta lëvizur.';

  @override
  String get toMovePiece =>
      'Trokitni lehtë mbi pikën e lidhur me copë për ta lëvizur.';

  @override
  String get toRemovePiece =>
      'Trokitni lehtë mbi një pjesë të kundërshtarit për ta hequr.';

  @override
  String get needToCreateMillFirst =>
      'Së pari duhet të krijoni një mulli përpara se të hiqni një copë.';

  @override
  String get needToPlayWithOwnPieces => 'Ju duhet të luani me pjesët tuaja.';

  @override
  String get statistics => 'Statistikat';

  @override
  String get totalGames => 'Lojërat totale';

  @override
  String get results => 'Rezultatet';

  @override
  String get left => 'u largua';

  @override
  String get privacyPolicy => 'Politika e privatësisë';

  @override
  String get privacyPolicy_Detail_1 =>
      'Ju lutemi lexoni me kujdes dhe sigurohuni që e kuptoni plotësisht dhe pajtoheni me këtë ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Nëse nuk jeni dakord me këtë politikë, ju lutemi mos e përdorni këtë Aplikacion. Përdorimi i Aplikacionit nënkupton që ju t\'i pranoni këto kushte.';

  @override
  String get and => ' dhe ';

  @override
  String get accept => 'Pranoj';

  @override
  String get takeBack => 'Merrni mbrapa';

  @override
  String get takingBack => 'Marrja mbrapa…';

  @override
  String get waiting => 'Ne pritje…';

  @override
  String get stepForward => 'Hap përpara';

  @override
  String get takeBackAll => 'Merrni mbrapa të gjitha';

  @override
  String get stepForwardAll => 'Hapi përpara të gjithë';

  @override
  String get moveNow => 'Lëviz tani';

  @override
  String get done => 'Bërë.';

  @override
  String get crackMill => 'Mulli plasaritje';

  @override
  String get crackMill_Detail =>
      'Nëse një lojtar ka vetëm copa në mulli, pjesët në mulli nuk do të bllokohen për t\'u hequr.';

  @override
  String get animationDuration => 'Kohëzgjatja e animacionit';

  @override
  String get none => 'Asnje';

  @override
  String get theme => 'Tema';

  @override
  String get helpContent =>
      'Loja synon ta lërë kundërshtarin me më pak se tre pjesë ose pa lëvizje ligjore.\n\nLoja tërheq automatikisht nëse një pozicion ndodh për herë të tretë ose nuk bën asnjë heqje në 100 lëvizjet e fundit (të konfigurueshme).\n\nLoja vazhdon në tre faza:\n\n1. Vendosja e pjesëve në pikat e lira\n2. Lëvizja e pjesëve në pikat ngjitur\n3. (faza opsionale) Zhvendosja e pjesëve në çdo pikë të lirë kur zvogëloni lojtarin në tre pjesë\n\nVendosja\n\nLoja fillon me një tabelë bosh, e cila përbëhet nga një rrjet me njëzet e katër pikë. Lojtarët vendosin me radhë pjesët e tyre në pikat e lira derisa secili lojtar të vendosë të gjitha pjesët në tabelë. Nëse një lojtar mund të vendosë tre nga pjesët e tij drejt, ai ka një \"mulli\" dhe mund të heqë një nga pjesët e kundërshtarit të tij nga bordi.\n\nNë disa rregulla, lojtarët duhet të heqin çdo pjesë tjetër së pari para se të heqin një copë nga një mulli i formuar.\n\nJu nuk mund t\'i vendosni copat në pikat e pjesëve të hequra përsëri në fazën e vendosjes në disa rregulla.\n\nPasi të përdorin të gjitha pjesët, lojtarët lëvizin me radhë.\n\nLëviz\n\nPër të lëvizur, një lojtar lëviz një nga pjesët e tij përgjatë një linje bordi në një pikë të zbrazët ngjitur. Nëse nuk mund ta bëjë këtë, ai e ka humbur lojën. Ashtu si në fazën e vendosjes, një lojtar që rendit tre nga pjesët e tij në një bord të bordit ka një mulli dhe mund të heqë një nga pjesët e kundërshtarit të tij. Çdo lojtar zvogëlohet në dy pjesë, nuk ka mundësi të formojë mullinj të rinj dhe kështu e humb lojën. Një lojtar gjithashtu mund të humbasë kur më shumë se tre pjesë nëse kundërshtari i tij i bllokon ata të lëvizin.\n\nFluturimi\n\nNë disa variante të rregullave, pasi një lojtar të ketë vetëm tre pjesë, pjesët e tij mund të fluturojnë, të kërcejnë ose të kërcejnë në ndonjë pikë të lirë, jo vetëm ato ngjitur.\n';

  @override
  String get versionInfo => 'Informacioni i versionit';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Liçensë';

  @override
  String get sourceCode => 'Kodi i burimit';

  @override
  String get appVersion => 'Versioni i aplikacionit';

  @override
  String get general => 'Gjeneral';

  @override
  String get advanced => 'Avancuar';

  @override
  String get placing => 'Vendosja';

  @override
  String get moving => 'Lëviz';

  @override
  String get removing => 'Po hiqet';

  @override
  String get gameOverCondition => 'Kushti mbi lojën';

  @override
  String get aisPlayStyle => 'Stili i lojës së AI';

  @override
  String get passive => 'Pasiv';

  @override
  String get timeout => 'Koha e pritjes';

  @override
  String get appearance => 'Pamja e jashtme';

  @override
  String get drawOnHumanExperience => 'Vizatoni në përvojën njerëzore';

  @override
  String get considerMobility => 'Konsideroni lëvizjen e pjesëve';

  @override
  String get pieceCount => 'Numërimi i pjesëve:';

  @override
  String inHand(Object player, int count) {
    return '$player në dorë: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player në bord: $count';
  }

  @override
  String get boardTop => 'Kompensimi i bordit nga lart';

  @override
  String get notAIsTurn => 'Nuk është radha e AI-së.';

  @override
  String get aiIsNotThinking => 'AI nuk po mendon.';

  @override
  String get atEnd => 'Në fund të listës së lëvizjeve.';

  @override
  String get tapBackAgainToLeave => 'Trokit përsëri përsëri për t\'u larguar.';

  @override
  String get more => 'Më shumë';

  @override
  String get experimental => 'Kjo është një tipar eksperimental.';

  @override
  String get experiments => 'Eksperimentet';

  @override
  String get ossLicenses => 'Licencat me burim të hapur';

  @override
  String get language => 'Gjuhe';

  @override
  String get defaultLanguage => 'Gjuha e paracaktuar';

  @override
  String get mayMoveInPlacingPhase =>
      'Pjesët mund të lëvizin në fazën e vendosjes';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Nuk ka faza të dallueshme të vendosjes dhe lëvizjes, d.m.th. lojtarët mund të vendosin në çdo lëvizje nëse duan të vendosin një copë në tabelë ose të zhvendosin një nga pjesët e tyre (për sa kohë që kanë pjesët e mbetura për t\'u vendosur).';

  @override
  String get drawerColor => 'Ngjyra e menysë';

  @override
  String get drawerTextColor => 'Ngjyra e tekstit të menusë';

  @override
  String get drawerHighlightItemColor =>
      'Ngjyrosni ngjyrën e artikullit në meny';

  @override
  String get mainToolbarBackgroundColor =>
      'Ngjyra kryesore e sfondit të shiritit të veglave';

  @override
  String get mainToolbarIconColor =>
      'Ngjyra kryesore e ikonës së shiritit të veglave';

  @override
  String get navigationToolbarBackgroundColor =>
      'Ngjyra e sfondit të shiritit të mjeteve të navigimit';

  @override
  String get navigationToolbarIconColor =>
      'Ngjyra e ikonës së shiritit të mjeteve të navigimit';

  @override
  String get autoHideToolbar => 'Fshihni automatikisht shiritin e veglave';

  @override
  String get toolbarLocationOnScreen =>
      'Vendndodhja e shiritit të mjeteve në ekran';

  @override
  String get top => 'Top';

  @override
  String get bottom => 'Fund';

  @override
  String get center => 'Qendra';

  @override
  String get solidColor => 'Ngjyra e ngurtë';

  @override
  String get picture => 'Foto';

  @override
  String get chooseYourPicture => 'Zgjidhni foton tuaj';

  @override
  String get light => 'Drita';

  @override
  String get dark => 'E errët';

  @override
  String get themes => 'Temat';

  @override
  String get currentTheme => 'Tema aktuale';

  @override
  String get saveTheme => 'Ruaj temën';

  @override
  String get showAnalysisGraph => 'Të tregojë grafikun e analizës';

  @override
  String get analysis => 'Analiza';

  @override
  String get saveGame => 'Ruaj lojën';

  @override
  String get loadGame => 'Ngarko lojën';

  @override
  String get setupPosition => 'Pozicioni i konfigurimit';

  @override
  String get showLegalMoves => 'Trego lëvizjet ligjore';

  @override
  String get showLastMove => 'Shfaq lëvizjen e fundit';

  @override
  String get showArrows => 'Trego shigjeta';

  @override
  String get pieces => 'Copëza';

  @override
  String get showAnalysis => 'Trego analizën';

  @override
  String get threads => 'Threads';

  @override
  String get getInvolved => 'Perfshihesh';

  @override
  String get helpImproveTranslate => 'Ndihmoni në përmirësimin e përkthimit';

  @override
  String get tutorial => 'Tutorial';

  @override
  String get classicMill => 'Mulli klasik';

  @override
  String get mixedMill => 'Mulli i përzier';

  @override
  String get ceylonMill => 'Mulliri i Ceilonit';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Mulli mund të thyhet dhe të ribëhet vazhdimisht';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Nëse një lojtar thyen një mulli për të krijuar menjëherë një mulli të ri, një lojtar i tillë mund ta zhvendosë pjesën e tij përsëri në kryqëzimin origjinal në lëvizjen e tij të radhës nëse bën një mulli të ri.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Loja barazohet nëse një lojtar ka tre pjesë dhe pas dhjetë lëvizjeve asnjë lojtar nuk heq pjesët e kundërshtarit';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Kur një lojtar është në tre copa, dhe asnjë lojtar nuk mund të heqë një pjesë të kundërshtarit brenda dhjetë lëvizjeve, loja është një barazim.';

  @override
  String get close => 'Mbylle';

  @override
  String get whitePiece => 'Copë e bardhë';

  @override
  String get blackPiece => 'Copë e zezë';

  @override
  String get emptyPoint => 'Pika bosh';

  @override
  String get noPoint => 'Pa pikë';

  @override
  String get placingPhase => 'Faza e vendosjes';

  @override
  String get movingPhase => 'Faza e lëvizjes';

  @override
  String get flyingPhase => 'Faza e fluturimit';

  @override
  String sideToMove(Object player) {
    return 'Ana për të lëvizur: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Lëvizja e fundit: $move';
  }

  @override
  String get selected => 'Zgjedhur';

  @override
  String get accessibility => 'Aksesueshmëria';

  @override
  String get screenReaderSupport => 'Mbështetje për lexuesin e ekranit';

  @override
  String get isDraw => 'Shtë një barazim!';

  @override
  String get draw => 'Barazim';

  @override
  String get pieceHighlightColor => 'Ngjyra e theksimit të copës';

  @override
  String get algorithm => 'Algoritmi';

  @override
  String get endgameNMoveRule => 'Rregulli i End-lojës N-Move';

  @override
  String get endgameNMoveRule_Detail =>
      'Nëse secili lojtar ka vetëm tre pjesë dhe asnjë lojtar nuk heq një pjesë brenda një lëvizjeje të caktuar, loja barazohet.';

  @override
  String get drawReasonEndgameRule50 =>
      'Secili lojtar ka vetëm tre pjesë dhe asnjë lojtar nuk heq një pjesë brenda një lëvizjeje të caktuar.';

  @override
  String get threefoldRepetitionRule => 'Rregulli i trefishtë i përsëritjes';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Loja tërhiqet nëse një pozicion ndodh për herë të tretë.';

  @override
  String get continueToMakeMove => 'Mulliri! Vazhdoni të bëni një lëvizje.';

  @override
  String get pointStyle => 'Stili i pikës';

  @override
  String get pointWidth => 'Gjerësia e pikës';

  @override
  String get solid => 'Të ngurta';

  @override
  String get hollow => 'Zgavër';

  @override
  String get languageName => 'Shqip';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Lëviz',
      one: '$count Lëviz',
      zero: 'Lëviz',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Ngarkimi dështoi.';

  @override
  String get filename => 'Emri i skedarit';

  @override
  String get browse => 'Shfleto…';

  @override
  String get gameFiles => 'Skedarët e lojës';

  @override
  String get gameSavedTo => 'Loja është ruajtur në';

  @override
  String get empty => 'Bosh';

  @override
  String get noMove => 'Asnjë lëvizje.';

  @override
  String get restoredPosition => 'Pozicioni fillestar i rivendosur.';

  @override
  String get clean => 'I pastër';

  @override
  String get cleanedUp => 'Pastruar.';

  @override
  String get remove => 'Hiq';

  @override
  String get noPiecesCanBeRemoved => 'Asnjë pjesë nuk mund të hiqet.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count copa',
      one: '$count copë',
      zero: 'Piece',
    );
    return '$_temp0 duhet të hiqen.';
  }

  @override
  String placedCount(int count) {
    return 'Vendosur ($count)';
  }

  @override
  String get placedPieceCount =>
      'Numërimi i pjesëve të vendosura në fazën e vendosjes.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Lojtari aktual ka vendosur pjesë $count.';
  }

  @override
  String get notPlacingPhase =>
      'Mos vendosja e fazës, nuk mund ta ndryshojë atë.';

  @override
  String get paste => 'Ngjit';

  @override
  String get pasteDone => 'Pasta është bërë.';

  @override
  String get cannotPaste => 'Nuk mund të ngjitet.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Trego pjesët e pavendosura dhe të hequra';

  @override
  String get fullScreen => 'Ekran i plotë';

  @override
  String get reopenToTakeEffect =>
      'Dilni dhe rihapni aplikacionin që cilësimet të hyjnë në fuqi.';

  @override
  String get forest => 'Pyll';

  @override
  String get desktopImage => 'Imazhi i desktopit';

  @override
  String get invalidPosition => 'Pozicioni i pavlefshëm.';

  @override
  String get shareGIF => 'Ndani GIF';

  @override
  String get pixelRatio => 'Raporti i pikselëve';

  @override
  String get duration => 'Kohëzgjatja';

  @override
  String get gameScreenRecorder => 'Regjistrues i ekranit të lojës';

  @override
  String get previous => 'E mëparshme';

  @override
  String get next => 'Tjetra';

  @override
  String get skip => 'Kapërce';

  @override
  String get gotIt => 'E kuptova';

  @override
  String get youCanModifyRules =>
      'Ju mund të modifikoni rregullat e lojës në cilësimet e rregullave.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Mund të përdorni rrotën e miut për të ndryshuar vlerën në zgjedhës.';

  @override
  String get noTimeLimitForThinking =>
      'Koha e të menduarit e AI e vendosur në 0 do të thotë se nuk ka kufi kohor për të menduar.';

  @override
  String get whatIsMtdf =>
      'MTD(f) është një formë e modifikuar e algoritmit alfa-beta të kërkimit që synon të përmirësojë efikasitetin duke ripërdorur rezultatet e ndërmjetme të kërkimit dhe duke përdorur një supozim të mirë fillestar për të ngushtuar hapësirën e kërkimit.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Ju lutemi, kini parasysh se rregullimi i kohës së të menduarit të AI mund të mos jetë plotësisht i saktë. Koha aktuale e të menduarit mund të jetë më e shkurtër kur niveli i vështirësisë është vendosur në një vlerë më të ulët dhe mund të jetë më e gjatë kur AI është në mes të mendimit kur koha mbaron.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Nëse e vendosni nivelin e vështirësisë të lartë, por nuk e rritni kohën e të menduarit të AI, niveli aktual i vështirësisë mund të kufizohet në një vlerë më të ulët për shkak të kufizimit të kohës së të menduarit. Vlera aktuale mund të ndryshojë në bazë të performancës së makinës.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) është një algoritëm kërkimi për të gjetur lëvizjen më të mirë në një pozicion të caktuar. Është një përmirësim i algoritmit alfa-beta dhe përdor kërkime të dritareve null ose zero për të konfirmuar se një lëvizje është më e keqe ose jo më e keqe se një rezultat tashmë i sigurt nga variacioni kryesor. PVS fokusohet në lëvizjet më premtuese dhe shmang kërkimet e panevojshme të degëve jooptimale, gjë që ndihmon në përmirësimin e efikasitetit të kërkimit.';

  @override
  String get whatIsAlphaBeta =>
      'Algoritmi alfa-beta është një algoritëm kërkimi për të gjetur lëvizjen më të mirë. Ai përdor parimin minimax dhe dy vlera, alfa dhe beta, për të krasitur pemën e kërkimit dhe për të rritur efikasitetin. Alfa përfaqëson rezultatin minimal që kompjuteri është i sigurt se mund të marrë, ndërsa beta përfaqëson rezultatin maksimal që mund të marrë kundërshtari i tij. Algoritmi ndihmon kompjuterin të marrë vendime të zgjuara dhe efikase në një lojë.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Sipas përvojës njerëzore, nëse përpiqeni të fitoni, do të humbni. Në vend të kësaj, synoni për një barazim si objektivin tuaj dhe shmangni humbjen e lojës. Vëzhgoni kundërshtarin tuaj dhe joshni butësisht në një pozicion ku ata mund të bëjnë gabime. Kur ata tregojnë dobësi, shfrytëzojeni mundësinë dhe nxitoni butësisht për fitore. Në këtë mënyrë, ju mund të fitoni lojën.';

  @override
  String get firstMoveDetail =>
      'Në këtë lojë, lojtari i dytë është më i lehtë të fitojë në krahasim me lojtarin e parë.';

  @override
  String get passiveDetail =>
      'Aktivizimi i opsionit Pasiv do të bëjë që AI të relaksohet kur ka një avantazh në pozicion, në vend që të përpiqet në mënyrë agresive të fitojë sa më shpejt që të jetë e mundur.';

  @override
  String get moveRandomlyDetail =>
      'Aktivizimi i këtij opsioni rrit rastësinë dhe argëtimin e lojës, ndërsa çaktivizimi i tij mund të ndihmojë në studimin e mënyrave për të mposhtur AI.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Nëse AI merr në konsideratë lëvizshmërinë e pjesëve të saj, ajo jo vetëm që do të synojë të kapë copat e kundërshtarit sa më shpejt që të jetë e mundur, por gjithashtu do të konsiderojë bllokimin e lëvizjeve të kundërshtarit dhe pengimin e tyre që të bëjnë të njëjtën gjë.';

  @override
  String get whenBoardIsFull => 'Kur bordi është plot';

  @override
  String get whenBoardIsFull_Detail =>
      'Në fund të fazës së vendosjes, përpara se të fillojë faza e lëvizjes, veprimi vijon nëse dërrasa është plot me copa.';

  @override
  String get sideToMoveRemovePiece =>
      'Lojtari që lëviz i pari në fazën e lëvizjes heq një nga pjesët e kundërshtarit.';

  @override
  String get agreeToDraw => 'Të dyja palët bien dakord për një barazim.';

  @override
  String get takeOpponentsPiece =>
      'Merrni një nga pjesët e kundërshtarit tuaj.';

  @override
  String get firstPlayerLose => 'Lojtari i parë humbet lojën.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Lojtari i parë dhe i dytë heqin një nga pjesët e kundërshtarit.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Lojtarët e dytë dhe të parë heqin një nga pjesët e kundërshtarit.';

  @override
  String get enteredFlyingPhase =>
      'Tani që hynë në fazën e fluturimit, pjesët e kundërshtarit mund të kërcejnë në çdo pikë boshe në tabelë. Mund ta çaktivizoni rregullin e fluturimit në \"Cilësimet e rregullave\".';

  @override
  String get whenStalemate => 'Kur në ngërç';

  @override
  String get whenStalemate_Detail =>
      'Çfarë veprimi pason kur asnjë pjesë nuk mund të zhvendoset?';

  @override
  String get endWithStalemateLoss => 'Përfundoni me një humbje në ngërç.';

  @override
  String get changeSideToMove => 'Ndryshoni anën për të lëvizur.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Hiqni një nga pjesët e kundërshtarit dhe bëni lëvizjen tjetër.';

  @override
  String get endWithStalemateDraw => 'Përfundoni me një barazim në ngërç.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Hiqni një nga pjesët e kundërshtarit dhe ndryshoni anën për të lëvizur.';

  @override
  String get aiResponseDelayTime => 'Koha e vonesës së përgjigjes së AI';

  @override
  String get aiIsDelaying =>
      'AI është aktualisht në një fazë reagimi të vonuar. Ju lutemi prisni pak përpara se të vazhdoni.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Ju nuk mund të hiqni një pjesë jo ngjitur.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Nëse ngërçi, pjesët e kundërshtarit ngjitur me tuajat mund të hiqen, pavarësisht nga formimi i mullirit.';

  @override
  String get whatIsMcts =>
      'MCTS është një algoritëm miqësor për fillestarët që merr vendime duke eksploruar dhe vlerësuar lëvizje të ndryshme përmes simulimeve.';

  @override
  String get goldenJade => 'Nefriti i Artë';

  @override
  String get forestWood => 'Druri i pyllit';

  @override
  String get darkMystery => 'Misteri i Errët';

  @override
  String get midnightBlue => 'Midnight Blue';

  @override
  String get greenForest => 'Pylli i Gjelbër';

  @override
  String get greenMeadow => 'Livadh i Gjelbër';

  @override
  String get stonyPath => 'Rruga e gurtë';

  @override
  String get pastelPink => 'Rozë pastel';

  @override
  String get turquoiseSea => 'Deti bruz';

  @override
  String get violetDream => 'Ëndrra vjollce';

  @override
  String get mintChocolate => 'Çokollatë me nenexhik';

  @override
  String get skyBlue => 'Qiell blu';

  @override
  String get playfulGarden => 'Kopsht lozonjare';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Algoritmi i Analizës Retrograde përdor analizën retrograde me shumë vlera për të ndërtuar një bazë të dhënash të fundit të lojës nga pozicione të ndryshme fillestare, më pas e aplikon këtë bazë të dhënash për të optimizuar lojën. Kjo qasje bie në kategorinë e zgjidhjeve ultra të forta.';

  @override
  String get viewAlgorithmGuide =>
      'Dëshironi të shikoni udhëzuesin e përdoruesit për këtë algoritëm?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Trego treguesin e avantazhit pozicional';

  @override
  String get usePerfectDatabase => 'Përdorni bazën e të dhënave të përsosur';

  @override
  String get perfectDatabaseDescription =>
      'Aktivizo këtë opsion për të përdorur një bazë të dhënash të përsosur lojërash të krijuar përmes algoritmeve të fundit. Kjo veçori integron si strategjinë e hapjes ashtu edhe atë të fundit të lojës për të sugjeruar lëvizje optimale. Kjo është zgjedhja e preferuar për lojtarët që kërkojnë nivelin më të lartë të saktësisë në lojë. E krijuar përmes teknikave të përpikta llogaritëse, baza e të dhënave është krijuar për të ofruar zgjidhje pothuajse perfekte të lojës.\n\nShënim: Nëse AI nuk arrin të aksesojë bazën e të dhënave, ajo do të kthehet në algoritme konvencionale për vendimet e lojës. Kur baza e të dhënave është e disponueshme, \'Niveli i Vështirësisë\' bëhet praktikisht i pamposhtur dhe \'Koha e Mendimit AI\' përjeton një reduktim drastik. Shumë cilësime brenda opsioneve të \"Stilit të luajtjes së AI\" do të anashkalohen, pasi rezultatet e bazës së të dhënave kanë përparësinë më të lartë.\n\nPër udhëzime se si të shfrytëzoni sa më shumë këtë bazë të dhënash të përsosur, klikoni këtu.';

  @override
  String get backgroundImage => 'Imazh i sfondit';

  @override
  String get whatIsRandom =>
      'Kur opsioni \"Përdor bazën e të dhënave të përsosur\" nuk është i aktivizuar, cilësimi \"Random\" bën që AI të lëvizë pjesë në mënyrë të rastësishme pa përdorur asnjë algoritëm për zgjedhjen e lëvizjes. Kjo zakonisht rezulton në një lojë shumë më të dobët. Anasjelltas, kur aktivizohet \"Përdor bazën e të dhënave të përsosur\", AI mbështetet ekskluzivisht në \"Bazën e Përsosur të të Dhënave\" për marrjen e vendimeve, në vend që ta përziejë atë me algoritmet tradicionale të AI. Në këtë mënyrë, lëvizjet e AI bazohen tërësisht në përmbajtjen e bazës së të dhënave, duke shmangur mbështetjen në llogaritjet në kohë reale ose algoritmet e kërkimit.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Hiq figurën (figurat) e kundërshtarit nga dora e tyre; pastaj është radha e kundërshtarit për të vendosur figurën.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Kur formoni mullinj gjatë fazës së vendosjes';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Hiq figurën(figurat) e kundërshtarit nga tabla.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Hiq figurën(figurat) e kundërshtarit nga tabla; pastaj është radha e kundërshtarit për të vendosur figurën.';

  @override
  String get opponentRemovesOwnPiece =>
      'Kundërshtari heq figurën (figurat) e veta nga tabla.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Në vend që ju të veproni, kundërshtari zgjedh dhe heq figurën (figurat) e tij nga tabla, duke kryer në mënyrë efektive një veprim që është i dëmshëm për veten.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Hiq figurën(figurat) e kundërshtarit nga dora e tij; pastaj është radha juaj për të lëvizur.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Hiq figurën(figurat) nga dora e kundërshtarit. Nëse, sipas cilësimit të heqjes së shumëfishtë, duhet të hiqen figura të shumta dhe kundërshtarit nuk i kanë mbetur figura në dorë, vazhdoni të hiqni figurat e kundërshtarit nga tabela. Pastaj, është radha juaj për të lëvizur. Nëse vazhdoni të formoni mullinj, mund të vazhdoni të hiqni figurat e kundërshtarit.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Hiq figurën(figurat) nga dora e kundërshtarit. Nëse, sipas cilësimit të heqjes së shumëfishtë, duhet të hiqen figura të shumta dhe kundërshtarit nuk i kanë mbetur figura në dorë, vazhdoni të hiqni figurat e kundërshtarit nga tabela. Pastaj, është radha e kundërshtarit për të lëvizur.';

  @override
  String get markAndDelayRemovingPieces =>
      'Shënoni dhe vononi heqjen e figurave.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Gjatë fazës së vendosjes, figurat që do të hiqen shënohen dhe për të dy lojtarët, asnjë figurë e re nuk mund të vendoset në këto pika. Pas hyrjes në fazën e lëvizjes, këto figura të shënuara hiqen krejtësisht dhe lojtarët pastaj mund t\'i lëvizin figurat e tyre në këto pika tani të zbrazëta.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Veprimet që mund të merren gjatë formimit të mullinjve në fazën e vendosjes.';

  @override
  String get marked => 'Shënuar';

  @override
  String get menu => 'Menu';

  @override
  String get monochrome => 'Monokrom';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Ju mund të aktivizoni mbështetjen e lexuesit të ekranit në konfigurimet e Aksesueshmërisë në Cilësimet e Përgjithshme.';

  @override
  String get showNumbersOnPieces => 'Shfaq numrat në copa';

  @override
  String get saveImage => 'Ruaj imazhin';

  @override
  String get isAnalysisToolbarShown => 'Shfaq shiritin e veglave të analizës';

  @override
  String get analysisToolbarBackgroundColor =>
      'Ngjyra e sfondit të shiritit të veglave të analizës';

  @override
  String get analysisToolbarIconColor =>
      'Ngjyra e ikonës së shiritit të veglave të analizës';

  @override
  String get transformed => 'Transformuar.';

  @override
  String get cannotTransform => 'Nuk mund të transformohet.';

  @override
  String get rotate => 'Rrotullo';

  @override
  String get horizontalFlip => 'Pas H';

  @override
  String get verticalFlip => 'Pas V';

  @override
  String get innerOuterFlip => 'Pas B/J';

  @override
  String get transparentCanvas => 'Pëlhurë Transparente';

  @override
  String get restrictRepeatedMillsFormation =>
      'Kufizo formimin e përsëritur të mullinjve';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Një copë e zhvendosur nga një mulli në tjetrin nuk mund të kthehet menjëherë në pikën fillestare në radhën tjetër për të formuar sërish një mulli. Fillimisht kërkohet një lëvizje tjetër.';

  @override
  String get oneTimeUseMill => 'Mulli për një përdorim';

  @override
  String get oneTimeUseMill_Detail =>
      'Çdo mulli mund të heqë një pjesë të kundërshtarit vetëm një herë. Mund ta formoni përsëri, por nuk mund të përdoret për heqje shtesë.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Rregullat aktuale që keni vendosur nuk kanë një bazë të dhënash të përsosur përkatëse. Për më shumë informacion rreth bazës së dhënash të përsosur, ju lutemi klikoni këtu.';

  @override
  String get focusOnBlockingPaths => 'Përqendrohuni në bllokimin e rrugëve';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Jepni përparësi bllokimit të lëvizjeve të kundërshtarit përpara formimit të mulli. Në vend që të përqendrohet në heqjen e pjesëve duke përfunduar mulli, AI synon të fusë kundërshtarin në kurth, duke e bërë të paaftë të lëvizë dhe të sigurojë një fitore përmes konsumimit sesa lojës agresive. Kjo strategji nuk bllokon në mënyrë aktive mulli të kundërshtarit.';

  @override
  String get pieceImage => 'Imazhi i copës';

  @override
  String get importColorSettings => 'Importoni cilësimet e ngjyrave';

  @override
  String get exportColorSettings => 'Eksportoni cilësimet e ngjyrave';

  @override
  String get import => 'Importoni';

  @override
  String get export => 'Eksportoni';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Ju lutemi kopjoni fillimisht cilësimet e formatit JSON në kujtesën e përkohshme.';

  @override
  String get copiedToClipboard => 'Kopjuar në kujtesën e përkohshme.';

  @override
  String get imported => 'Importuar.';

  @override
  String get boardImage => 'Imazhi i tabelës';

  @override
  String get autumnLeaves => 'Gjethet e Vjeshtës';

  @override
  String get legendaryLand => 'Toka Legjendare';

  @override
  String get vignetteEffect => 'Efekti i vinjetës';

  @override
  String get promptMakeToolbarTransparent =>
      'A dëshironi të bëni shiritin e veglave plotësisht transparent kur është caktuar një imazh sfondi për tabelën?';

  @override
  String get vibration => 'Aktivizo vibracionin në lojë';

  @override
  String get soundTheme => 'Tema e zërit';

  @override
  String get ball => 'Top';

  @override
  String get liquid => 'Lëng';

  @override
  String get wood => 'Druri';

  @override
  String get placeEffectAnimation =>
      'Efekti i animacionit të vendosjes së figurës';

  @override
  String get removeEffectAnimation =>
      'Efekti i animacionit të heqjes së figurës';

  @override
  String get isToolbarAtBottom => 'Shfaq shiritin e mjeteve në fund';

  @override
  String get boardCornerRadius => 'Rraundi i skajit të bordit';

  @override
  String get useOpeningBook => 'Përdorni librin e hapjes';

  @override
  String get currentRule => 'Aktual';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Grup rregullash';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Lejo AI të përdorë lëvizjet e hapjes që përdoren zakonisht nga lojtarët profesionistë njerëzorë në fillim të lojës. Shënim: Kjo veçori është aktualisht në dispozicion vetëm për grupe të caktuara rregullash.';

  @override
  String get showAdvantageGraph => 'Trego grafikun e avantazhit';

  @override
  String get advantageGraphHint =>
      'Grafiku i avantazhit do të vizatohet vetëm pasi IA të bëjë një lëvizje. Nuk do të vizatohet kur lojtari njerëzor bën një lëvizje.';

  @override
  String get removalBasedOnMillCounts =>
      'Çaktivizoni heqjen derisa të vendosen të gjitha figurat. Lojtarët heqin figura bazuar në numrin e mullinjve të krijuar.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Çaktivizoni heqjen derisa të vendosen të gjitha figurat. Lojtarët heqin figura bazuar në numrin e mullinjve: nëse është e barabartë, të dy heqin të njëjtin numër figurash; nëse njëri ka më shumë, ai heq një figurë shtesë, duke ruajtur një diferencë prej një figure. Nëse vetëm një formon mulli, ai heq dy figura, ndërsa tjetri heq një. Nëse asnjë nuk formon mulli, të dy heqin nga një figurë.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Zgjidh njërën prej gurëve tuaj.';

  @override
  String get notYourTurn => 'Nuk është radha juaj.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Ngjyra e sfondit të panelit të shënimeve';

  @override
  String get annotationToolbarIconColor =>
      'Ngjyra e ikonave të panelit të shënimeve';

  @override
  String get isAnnotationToolbarShown => 'Shfaq panelin e shënimeve';

  @override
  String get enterAnnotationMode => 'Hyr në modalitetin e shënimeve';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Jeni i sigurt që doni të fshini të gjitha shënimet?';

  @override
  String get llmPromptCopiedToClipboard => 'LLM prompt u kopjua në clipboard.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Lidhja u refuzua, serveri mund të jetë i poshtër.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Zbulimi u krye, duke pritur lidhje...';

  @override
  String get noLanConnection => 'Asnjë lidhje LAN';

  @override
  String get takeScreenshot => 'Kape një screenshot';

  @override
  String get disconnectedFromOpponent => 'Shkëputur nga kundërshtari.';

  @override
  String get takeBackRequest => 'Kërkesë për t\'u Kthyer';

  @override
  String get nothingToShow => 'Asgjë për të shfaqur.';

  @override
  String get stopHosting => 'Ndalo Hostimin';

  @override
  String get connectionResetByPeer => 'Lidhja u rivendos nga peer.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Lidhja u humb për shkak të timeout. Ju lutem ri-lidhuni.';

  @override
  String get startHosting => 'Fillo Hostimin';

  @override
  String get restartRequestRejected => 'Kërkesa për rinisje u refuzua.';

  @override
  String get notConnectedToLanOpponent =>
      'Nuk jeni lidhur me kundërshtarin në LAN.';

  @override
  String get llmPrompt => 'LLM prompt';

  @override
  String get gameRestarted => 'Loja u rinis.';

  @override
  String get takeBackRejected => 'Kthimi u refuzua.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Jeni i sigurt që doni të dorëzoheni?';

  @override
  String get opponentResignedYouWin => 'Kundërshtari u dorëzua. Ju fituat!';

  @override
  String get clearAllAnnotations => 'Pastro të gjitha shënimet';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Lidhur, duke pritur lëvizjen e kundërshtarit...';

  @override
  String get networkStatusDisconnected => 'Statusi i rrjetit: Shkëputur';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Kërkesa për t\'u kthyer u dërgua kundërshtarit.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Kundërshtari mund të ketë larguar nga loja';

  @override
  String get connectedToHostSuccessfully => 'U lidh me sukses me hostin.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Lidhja u humb: Kohëskadim heartbeat';

  @override
  String get noHostDiscovered => 'Asnjë host i zbuluar.';

  @override
  String get confirmResignation => 'Konfirmo dorëzimin';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Hostimi filloi, duke pritur lojtarët...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Kohëskadim lidhjeje, rrjeti i paqëndrueshëm.';

  @override
  String get noLlmPromptAvailable => 'Asnjë LLM prompt i disponueshëm.';

  @override
  String get youResignedGameOver => 'Ju dorëzuat. Loja mbaroi.';

  @override
  String get serverIp => 'IP e serverit';

  @override
  String get confirmClear => 'Konfirmo pastrimin';

  @override
  String get opponentSTurn => 'Rradha e kundërshtarit.';

  @override
  String get waitingAClientConnection => 'Duke pritur lidhje klienti...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Kërkesa për t\'u kthyer u refuzua ose dështoi.';

  @override
  String get addText => 'Shto tekst';

  @override
  String get exitAnnotationMode => 'Dil nga modaliteti i shënimeve';

  @override
  String get typeYourAnnotation => 'Shkruani shënimin tuaj';

  @override
  String get attemptingToReconnect => 'Duke u përpjekur të ri-lidhet...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Kërkesa për rinisje u dërgua. Duke pritur përgjigjen e kundërshtarit...';

  @override
  String get serverIsStopped => 'Serveri është ndalur.';

  @override
  String get restartRequest => 'Kërkesë për rinisje';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Nuk mund të kërkoni kthim kur nuk është radha juaj.';

  @override
  String get takeBackAccepted => 'Kthimi u pranua.';

  @override
  String get localNetworkSettings => 'Cilësimet e rrjetit lokal';

  @override
  String get reconnectedSuccessfully => 'U rilidh me sukses!';

  @override
  String get failedToSaveImageToGallery =>
      'Dështoi ruajtja e imazhit në Galeri.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Kundërshtari kërkoi rinisjen e lojës. E pranoni?';

  @override
  String get yourTurn => 'Rradha juaj.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Nuk mund të rilidhet, ju lutem rinisni lojën.';

  @override
  String get host => 'Host';

  @override
  String get join => 'Bashkohu';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'IP adresë e pavlefshme.';

  @override
  String get invalidPort => 'Port i pavlefshëm.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Po lidhet: Përpjekje $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Dështoi lidhja: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Dështoi fillimi i hostimit: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Host i zbuluar: $ip:$port';
  }

  @override
  String get stop => 'Ndalo';

  @override
  String get discover => 'Zbulo';

  @override
  String get connect => 'Lidhu';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Klienti u lidh: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Duke zbuluar: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Po rilidhet ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'I lidhur';

  @override
  String get delete => 'Fshi';

  @override
  String get ancientEgypt => 'Egjipti i Lashtë';

  @override
  String get gothicIce => 'Akull Gotik';

  @override
  String get riceField => 'Fushë me Oriz';

  @override
  String get chinesePorcelain => 'Porcelan Kinez';

  @override
  String get desertDusk => 'Muzgu i Shkretëtirës';

  @override
  String get precisionCraft => 'Punim Preciz';

  @override
  String get folkEmbroidery => 'Qëndisje Popullore';

  @override
  String get carpathianHeritage => 'Trashëgimia e Karpateve';

  @override
  String get imperialGrandeur => 'Madhështia Perandorake';

  @override
  String get bohemianCrystal => 'Kristal Boem';

  @override
  String get savannaSunrise => 'Lindja e Diellit në Savanë';

  @override
  String get harmonyBalance => 'Harmoni dhe Balancë';

  @override
  String get cinnamonSpice => 'Erëz Kanelle';

  @override
  String get anatolianMosaic => 'Mozaik Anatolian';

  @override
  String get carnivalSpirit => 'Shpirti i Karnavalit';

  @override
  String get custom => 'Zakon';

  @override
  String get spiceMarket => 'Tregu i erëzave';

  @override
  String get swipeToRevealTheDrawer => 'Rrëshqit për të zbuluar sirtarin';

  @override
  String get showGameInfoOnScreenshots =>
      'Shfaq informacionin e lojës në pamjet e ekranit';

  @override
  String get humanMoveTime => 'Kufiri kohor njerëzor';

  @override
  String get noTimeLimitForHumanMoves =>
      'Nuk ka kufi kohor për lëvizjet njerëzore';

  @override
  String get timeoutLoseWillBeApplied =>
      'Humbja për skadim kohe do të aplikohet për lojtarin njerëzor';

  @override
  String get identifyingBoard => 'Identifikimi i tabelës...';

  @override
  String get youCanEnterAnyModelName => 'Mund të shkruani cilindo emër model.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Pozicioni i tabelës aplikuar. FEN është kopjuar në kujtesën e përkohshme.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Sugjerim: provoni të bëni një foto më të qartë të tabelës.';

  @override
  String get llmPromptTemplate => 'Modeli i kërkesës LLM';

  @override
  String get noValidBoardDetected => 'Asnjë tabelë e vlefshme nuk u zbulua.';

  @override
  String get selectingImageFromAlbum => 'Zgjedhja e imazhit nga albumi...';

  @override
  String get configurePromptTemplate => 'Konfiguro modelin e kërkesës';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Ndrysho modelin e kërkesës për analizën LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Dështoi gjenerimi i FEN nga tabela e njohur.';

  @override
  String get outputInCurrentLanguage => 'Dalja në gjuhën aktuale';

  @override
  String get commonBaseUrls => 'URL-të bazë të zakonshme';

  @override
  String get viewCommonModels => 'Shiko modelet e zakonshme';

  @override
  String get recognitionParametersUpdated =>
      'Parametrat e njohjes u përditësuan.';

  @override
  String get whiteSMove => 'Lëvizja e të bardhëve';

  @override
  String get resetToDefaults => 'Rivendos në parazgjedhje';

  @override
  String get photoShoot => 'Fotografim';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Dështoi aplikimi i pozicionit të njohur të tabelës.';

  @override
  String get llmPromptContent => 'Përmbajtja e kërkesës LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM nuk është konfiguruar. Ju lutem kontrolloni cilësimet tuaja.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Vendos ofruesin, modelin, Çelësin API dhe URL-në bazë';

  @override
  String get llmConfiguration => 'Konfigurimi LLM';

  @override
  String get configureLlmProvider => 'Konfiguro ofruesin LLM';

  @override
  String get llmPromptTemplateHeader =>
      'Kryeparathënie e modelit të kërkesës LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Asnjë figurë nuk u njoh në imazh. Ju lutem provoni përsëri.';

  @override
  String get recognizeBoardFromImage => 'Njoh tabelën nga imazhi';

  @override
  String get viewTips => 'Shiko këshilla';

  @override
  String get applyToBoard => 'Apliko në tabelë';

  @override
  String get adjustBoardArea => 'Rregullo zonën e tabelës';

  @override
  String get viewCommonUrls => 'Shiko URL-të e zakonshme';

  @override
  String get colorAnalysisFailed => 'Analiza e ngjyrave dështoi!';

  @override
  String get analyzingGameBoardImage =>
      'Duke analizuar imazhin e tabelës së lojës...';

  @override
  String get selectFromAlbum => 'Zgjidh nga albumi';

  @override
  String get noBoardPointDetected => 'Asnjë pikë e tabelës nuk u zbulua!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Nëse lihet bosh, do të përdoret modeli parazgjedhje';

  @override
  String get llmConfig => 'Konfigurimi LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'A jeni i sigurt që dëshironi të rivendosni modelet e kërkesës në vlerat parazgjedhje?';

  @override
  String get llmPromptTemplateFooter => 'Këmbë e modelit të kërkesës LLM';

  @override
  String get loadingResponse => 'Duke ngarkuar përgjigjen...';

  @override
  String get applyThisResultToBoard => 'Apliko këtë rezultat në tabelë';

  @override
  String get takingPicture => 'Duke bërë foto...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Ju lutem zgjidhni një imazh të tabelës së lojës për njohje';

  @override
  String get identificationResults => 'Rezultatet e identifikimit';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analizoni lëvizjet dhe jepni njohuri.';

  @override
  String get getApiKey => 'Merrni Çelësin API';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Procesi i tërë i njohjes nuk u përfundua.';

  @override
  String get boardRecognitionResult => 'Rezultati i njohjes së tabelës';

  @override
  String get askLlm => 'Pyesni LLM';

  @override
  String get boardDetectionFailed => 'Zbulimi i tabelës dështoi!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Asnjë pikë e tabelës nuk u zbulua, nuk mund të identifikojmë figurën!';

  @override
  String get copyFen => 'Kopjo FEN';

  @override
  String get commonlyUsedModels => 'Modelet e përdorura zakonisht';

  @override
  String get apiKeyOptional => 'Çelësi API (opsional)';

  @override
  String get noImageSelected => 'Asnjë imazh nuk u zgjodh';

  @override
  String get blackSMove => 'Lëvizja e të zinjve';

  @override
  String get llm => 'Model i Madh Gjuhësor';

  @override
  String get llmProvider => 'Ofrues';

  @override
  String get baseUrl => 'URL Bazë';

  @override
  String get model => 'Model';

  @override
  String get temperature => 'Temperaturë';

  @override
  String get llmCommandReceivedProcessing => 'Komanda u mor! AI po përpunon...';

  @override
  String get llmDeepThinkingWait =>
      'Po zhvillohet mendim i thellë, ju lutem prisni...';

  @override
  String get llmPresentingSoon => 'Së shpejti do të prezantohet...';

  @override
  String get recognitionParameters => 'Parametrat e njohjes';

  @override
  String get adjustParamsDesc =>
      'Rregulloni parametrat për të përmirësuar saktësinë e njohjes';

  @override
  String get saveParameters => 'Ruaj parametrat';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Pamundësi për të nisur njohjen e imazhit: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Njohja e imazhit dështoi: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Pozicioni u aplikua me $whiteCount gurë të bardhë dhe $blackCount gurë të zinj';
  }

  @override
  String get fenCopiedToClipboard => '(FEN u kopjua në kujtesën e përkohshme)';

  @override
  String recognitionFailed(String error) {
    return 'Njohja dështoi: $error';
  }

  @override
  String get myRating => 'Vlerësimi im';

  @override
  String get gamesPlayed => 'Lojëra të luajtura';

  @override
  String get wins => 'Fitore';

  @override
  String get losses => 'Humbje';

  @override
  String get draws => 'Barazime';

  @override
  String get lastUpdated => 'Përditësuar së fundmi';

  @override
  String get format => 'Formati:';

  @override
  String get resetStatistics => 'Rivendos statistikat';

  @override
  String get drawRate => 'Norma e barazimeve';

  @override
  String get lossRate => 'Norma e humbjeve';

  @override
  String get aiStatistics => 'Statistikat e IA';

  @override
  String get enableStatistics => 'Aktivizo statistikat';

  @override
  String get enableStatistics_Detail =>
      'Kur aktivizohet, rezultatet e lojërave do të regjistrohen në statistika. Megjithatë, lojërat që përfshijnë kthime pas nuk do të regjistrohen. Kur çaktivizohet, mbledhja e statistikave ndërpritet.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Kjo do të rivendosë të gjitha statistikat e lojës. Ky veprim nuk mund të zhbëhet.';

  @override
  String get boardInnerRingSize => 'Madhësia e unazës së brendshme të tabelës';

  @override
  String get boardShadowEnabled => 'Hija e tabelës';

  @override
  String get trapAwareness => 'Zbulimi i kurtheve';

  @override
  String get trapAwarenessDescription =>
      'Thekso lëvizjet-kurth me rrethe dhe shigjeta të trasha gjatë analizës.';

  @override
  String trapExists(String trapMoves) {
    return 'Ekziston një kurth. Lëvizje-kurth: $trapMoves';
  }

  @override
  String get custodianCapture => 'Kapje me krahë';

  @override
  String get custodianCaptureDescription =>
      'Bashkangjitni një nga pjesët e kundërshtarit tuaj midis dy tuajave në një vijë të drejtë për ta kapur atë.';

  @override
  String get custodianCaptureEnable => 'Lejoni kapjen e krahut';

  @override
  String get interventionCapture => 'Kapja e ndërhyrjes';

  @override
  String get interventionCaptureDescription =>
      'Kaloni në pikën boshe midis dy pjesëve të kundërshtarit tuaj për t\'i kapur të dy.';

  @override
  String get interventionCaptureEnable => 'Lejoni kapjen e ndërhyrjes';

  @override
  String get leapCapture => 'Kërto Kapur';

  @override
  String get leapCaptureDescription =>
      'Kapni duke u hedhur mbi pjesën e një kundërshtari ngjitur në pikën boshe përtej.';

  @override
  String get leapCaptureEnable => 'Lejo Kërcën e Kërcave';

  @override
  String get captureApplicableLines => 'Linjat e zbatueshme';

  @override
  String get captureSquareEdges => 'Përgjatë skajeve të sheshit';

  @override
  String get captureCrossLines =>
      'Përgjatë vijave ortogonale që kalojnë sheshin';

  @override
  String get captureDiagonalLines =>
      'Përgjatë vijave diagonale që kalojnë sheshin';

  @override
  String get captureExecutionPhases => 'Fazat e ekzekutimit';

  @override
  String get capturePiecesCondition =>
      'Disponueshmëria gjatë fazës lëvizëse bazuar në pjesët e mbetura';

  @override
  String get capturePiecesConditionUnlimited => 'Asnjë kufizim';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Në dispozicion kur keni tre ose më pak pjesë';
}
