// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Slovenian (`sl`).
class SSl extends S {
  SSl([String locale = 'sl']) : super(locale);

  @override
  String get appName => 'Mlin';

  @override
  String get welcome => 'Dobrodošli';

  @override
  String get yes => 'Da';

  @override
  String get no => 'Ne';

  @override
  String get game => 'Igra';

  @override
  String get humanVsAi => 'Človek proti UI';

  @override
  String get humanVsHuman => 'Človek proti človeku';

  @override
  String get aiVsAi => 'UI proti UI';

  @override
  String get humanVsCloud => 'Človek proti oblaku';

  @override
  String get humanVsLAN => 'Človek proti lokalnemu omrežju';

  @override
  String get testViaLAN => 'Preizkus prek omrežja LAN';

  @override
  String get move => 'Premik';

  @override
  String get showMoveList => 'Seznam premikov';

  @override
  String get moveList => 'Seznam premikov';

  @override
  String get noGameRecord => 'Brez zapisa';

  @override
  String get ok => 'V REDU';

  @override
  String get confirm => 'Potrdi';

  @override
  String get cancel => 'Prekliči';

  @override
  String get tipSelectWrong => 'Izberite napačen kos.';

  @override
  String get tipPlace => 'Postavite svoje kose.';

  @override
  String get tipBanPlace => 'Tukaj ga ne morete postaviti.';

  @override
  String get tipPlaced => 'Postavili ste.';

  @override
  String get tipRemove => 'Odstranite košček.';

  @override
  String get tipBanRemove => 'Ne morete ga odstraniti.';

  @override
  String get tipRemoved => 'Odstranili ste ga.';

  @override
  String get tipMove => 'Premaknite figuro.';

  @override
  String get tipCannotPlace => 'Figurice ne morete postaviti na to mesto.';

  @override
  String get tipCannotMove => 'Figurice ne morete premakniti sem.';

  @override
  String get tipMill => 'Mlin! Vzemite nasprotnikovo figuro.';

  @override
  String get tipContinueMill => 'Nadaljujte z jemanjem nasprotnikove figure.';

  @override
  String get tipSelectOpponentsPiece => 'Izberite eno od nasprotnikovih figur.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Figurice ne morete odstraniti iz mlina.';

  @override
  String get tipCanMoveOnePoint => 'Figura se lahko premakne za 1 točko.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Nasprotnikove figure ne morete premakniti.';

  @override
  String get tipSelectPieceToMove =>
      'Izberite figuro, ki jo želite premakniti.';

  @override
  String get tipHaveThreePiecesLeft => 'Na voljo imate še tri figure.';

  @override
  String get tipCanMoveToAnyPoint => 'Premaknete se lahko na poljubno točko.';

  @override
  String tipToMove(Object player) {
    return '$player za premikanje.';
  }

  @override
  String get whiteWin => 'Igralec 1 zmaga!';

  @override
  String get blackWin => 'Igralec 2 zmaga!';

  @override
  String get won => 'Zmaga';

  @override
  String get lost => 'Izgubljeno';

  @override
  String get thinking => 'Razmišljanje…';

  @override
  String get newGame => 'Nova igra';

  @override
  String get importGame => 'Uvoz igre';

  @override
  String get exportGame => 'Izvozi igro';

  @override
  String get gameImported => 'Igra uvožena.';

  @override
  String cannotImport(Object invalidMove) {
    return '$invalidMove ni mogoče uvoziti';
  }

  @override
  String get movesAndRulesNotMatch => 'Poteze in pravila se ne ujemajo.';

  @override
  String get pleaseWait => 'Počakajte.';

  @override
  String get restartGame => 'Ponovno zaženete trenutno igro?';

  @override
  String get restart => 'Ponovno zaženite';

  @override
  String get gameStarted => 'Igra se je začela, prosimo, postavite.';

  @override
  String get analyzing => 'Analiza…';

  @override
  String error(Object message) {
    return 'Napaka: $message';
  }

  @override
  String get winRate => 'Stopnja zmage';

  @override
  String get score => 'Rezultat:';

  @override
  String get white => 'Igralec 1';

  @override
  String get black => 'Igralec 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player število kosov je manjše od treh.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player odstopi.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player nima poti.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Plošča je polna in $player nima poti.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Čas je mimo, $player izgubljen.';
  }

  @override
  String get drawReasonRule50 =>
      'V fazi premikanja v zadnjem določenem številu potez ni bila odstranjena nobena figura.';

  @override
  String get drawReasonBoardIsFull =>
      'To je remi, ker je igralna plošča polna.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Zaradi trikratnega ponavljanja je neodločen rezultat.';

  @override
  String get gameOverUnknownReason => 'Konec igre! Neznani razlog.';

  @override
  String get gameOver => 'Konec igre';

  @override
  String get youWin => 'Zmagal si! Čestitamo!';

  @override
  String challengeHarderLevel(int level) {
    return 'Izzvati težjo stopnjo? Nova raven bo raven $level!';
  }

  @override
  String get youLose => 'Izgubili ste!';

  @override
  String get analyze => 'Analizirajte';

  @override
  String get about => 'O spletni strani';

  @override
  String version(Object versionNumber) {
    return 'Različica: $versionNumber';
  }

  @override
  String get thanks => 'Hvala';

  @override
  String get settings => 'Nastavitve';

  @override
  String get options => 'Možnosti';

  @override
  String get generalSettings => 'Splošne nastavitve';

  @override
  String get skillLevel => 'Stopnja težavnosti';

  @override
  String get moveTime => 'Čas razmišljanja umetne inteligence';

  @override
  String get difficulty => 'Težavnost';

  @override
  String get playSounds => 'Zvočni učinki';

  @override
  String get playSoundsInTheGame => 'Predvajanje zvokov v igri';

  @override
  String get keepMuteWhenTakingBack => 'Pri vračanju umiri zvok';

  @override
  String get tone => 'Ton';

  @override
  String get whoMovesFirst => 'Prva poteza';

  @override
  String get human => 'Človek';

  @override
  String get ai => 'UI';

  @override
  String get alternate => 'Nadomestna';

  @override
  String get isAutoRestart =>
      'Samodejni ponovni zagon igre, ko je igra končana';

  @override
  String get isAutoChangeFirstMove => 'Samodejna sprememba prve poteze';

  @override
  String get shufflingEnabled => 'Naključna poteza';

  @override
  String get misc => 'Različne';

  @override
  String get rules => 'Pravila';

  @override
  String get piecesCount => 'Število figur, ki jih ima vsak igralec';

  @override
  String get piecesCount_Detail => 'Koliko figur ima vsak igralec?';

  @override
  String get flyPieceCount => 'Številka leteče figure';

  @override
  String get flyPieceCount_Detail =>
      'Če je omogočeno letenje, se lahko igralec, ko se število njegovih figur zmanjša na določeno število, prosto premakne na katero koli nezasedeno točko, namesto da bi bil omejen na sosednje točke kot v preostalem delu igre.';

  @override
  String get piecesAtLeastCount => 'Najmanj figur';

  @override
  String get hasDiagonalLines => 'Diagonalne črte';

  @override
  String get hasDiagonalLines_Detail =>
      'Igralni plošči dodajte štiri diagonalne črte.';

  @override
  String get isDefenderMoveFirst => 'Drugi igralec se premakne prvi';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Igralec, ki se v fazi postavljanja premakne kot drugi, se v fazi premikanja premakne prvi.';

  @override
  String get mayRemoveMultiple => 'Večkratno odstranjevanje';

  @override
  String get mayRemoveMultiple_Detail =>
      'Če igralec zapre več kot en mlin naenkrat, odstrani toliko mlinov, kolikor jih je zaprl.';

  @override
  String get mayRemoveFromMillsAlways => 'Uničenje mlinov';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Privzeto morajo igralci najprej odstraniti vse druge kose, preden odstranijo kos iz oblikovanega mlina. Če to možnost omogočite, to omejitev onemogočite.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Drugi igralec izgubi, ko je igralna plošča polna';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Ko je igralna plošča ob koncu faze postavljanja polna, izgubi stran, ki je prva postavila mlinček. V nasprotnem primeru je igra neodločena.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Izgubi, ko ni dovoljenih potez';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Igralec izgubi, če ga nasprotnik blokira, tako da ga ni mogoče premakniti. Če je ta možnost onemogočena, spremenite stran za premikanje.';

  @override
  String get mayFly => 'Leteči';

  @override
  String get mayFly_Detail =>
      'Če ima igralec na voljo le še tri ali štiri (nastavljive) figure, lahko premakne figuro na katero koli prosto točko.';

  @override
  String get nMoveRule => 'Pravilo N premikov';

  @override
  String get nMoveRule_Detail =>
      'Igra je izenačena, če vsak igralec v določenem številu potez ni odstranil nobene figure.';

  @override
  String get rollback => 'Vrnitev';

  @override
  String get pleaseSelect => 'Izberite';

  @override
  String get copy => 'Kopiraj';

  @override
  String get moveHistoryCopied => 'Zgodovina potez se kopira v odložišče.';

  @override
  String get help => 'Pomoč';

  @override
  String get feedback => 'Povratne informacije';

  @override
  String get exit => 'Izhod';

  @override
  String get ruleSettings => 'Nastavitve pravila';

  @override
  String get color => 'Barva';

  @override
  String get boardColor => 'Barva table';

  @override
  String get pieceColor => 'Barva kosa';

  @override
  String get backgroundColor => 'Barva ozadja';

  @override
  String get lineColor => 'Barva črte table';

  @override
  String get whitePieceColor => 'Barva figurice igralca 1';

  @override
  String get blackPieceColor => 'Barva kosa igralca 2';

  @override
  String get messageColor => 'Barva sporočila';

  @override
  String get isPieceCountInHandShown => 'Prikaži število kosov v roki';

  @override
  String get isNotationsShown => 'Prikaži zapise na igralni plošči';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Prikaži navigacijsko orodno vrstico za zgodovino';

  @override
  String get display => 'Prikaži';

  @override
  String get boardBorderLineWidth => 'Širina meje table';

  @override
  String get boardInnerLineWidth => 'Širina notranje črte table';

  @override
  String get pieceWidth => 'Širina kosa';

  @override
  String get fontSize => 'Velikost pisave';

  @override
  String get standardNotation => 'Zapis WMD';

  @override
  String get restore => 'Obnovitev';

  @override
  String get restoreDefaultSettings => 'Obnovi privzete nastavitve';

  @override
  String pick(Object element) {
    return 'Izberite $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Namig';

  @override
  String get player => 'igralec';

  @override
  String get player1 => 'Igralec 1';

  @override
  String get player2 => 'Igralec 2';

  @override
  String get howToPlay => 'Kako igrati';

  @override
  String get toPlacePiece =>
      'Tapnite katero koli razpoložljivo točko, da postavite figuro.';

  @override
  String get toSelectPiece => 'Tapnite figuro, da jo premaknete.';

  @override
  String get toMovePiece =>
      'Tapnite točko, ki je povezana s figuro, da jo premaknete.';

  @override
  String get toRemovePiece =>
      'Tapnite na eno nasprotnikovo figuro, da jo odstranite.';

  @override
  String get needToCreateMillFirst =>
      'Preden lahko odstranite figuro, morate najprej ustvariti mlin.';

  @override
  String get needToPlayWithOwnPieces => 'Igrati morate s svojimi figurami.';

  @override
  String get statistics => 'Statistika';

  @override
  String get totalGames => 'Skupno število iger';

  @override
  String get results => 'Rezultati';

  @override
  String get left => 'levo';

  @override
  String get privacyPolicy => 'Politika zasebnosti';

  @override
  String get privacyPolicy_Detail_1 =>
      'Pozorno preberite in se prepričajte, da jo v celoti razumete in se z njo strinjate ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Če se s tem pravilnikom ne strinjate, te aplikacije ne uporabljajte. Uporaba aplikacije pomeni, da se strinjate s temi pogoji.';

  @override
  String get and => ' in . ';

  @override
  String get accept => 'Sprejmite';

  @override
  String get takeBack => 'Vzemite nazaj';

  @override
  String get takingBack => 'Vračanje nazaj…';

  @override
  String get waiting => 'Čakanje…';

  @override
  String get stepForward => 'Korak naprej';

  @override
  String get takeBackAll => 'Vzemi vse nazaj';

  @override
  String get stepForwardAll => 'Korak naprej vsi';

  @override
  String get moveNow => 'Premaknite se zdaj';

  @override
  String get done => 'Končano.';

  @override
  String get crackMill => 'Mlin na krek';

  @override
  String get crackMill_Detail =>
      'Če ima igralec samo kose v mlinih, se kosi v mlinih ne bodo zaklenili za odstranitev.';

  @override
  String get animationDuration => 'Trajanje animacije';

  @override
  String get none => 'Ni';

  @override
  String get theme => 'Tema';

  @override
  String get helpContent =>
      'Cilj igre je, da nasprotnik ostane z manj kot tremi figurami ali brez dovoljenih potez.\n\nČe se položaj pojavi tretjič ali če v zadnjih 100 (nastavljivih) potezah ne odstrani nobene figure, se igra samodejno izenači.\n\nIgra poteka v treh fazah:\n\n1. Postavljanje figur na prosta mesta\n2. Premikanje figur na sosednje točke\n3. (neobvezna faza) Premikanje figur na katero koli prosto točko, ko se igralec zmanjša na tri figure\n\nPostavljanje\n\nIgra se začne s prazno igralno ploščo, ki jo sestavlja mreža s štiriindvajsetimi točkami. Igralci izmenično postavljajo svoje figure na proste točke, dokler vsak igralec ne postavi vseh figur na ploščo. Če lahko igralec postavi tri svoje figure naravnost, ima \"mlin\" in lahko odstrani eno nasprotnikovo figuro z deske.\n\nV nekaterih pravilih morajo igralci najprej odstraniti vse druge figure, preden odstranijo figuro iz oblikovanega mlina.\n\nV nekaterih pravilih v fazi postavljanja ni mogoče ponovno postaviti figur na točke odstranjenih figur.\n\nKo uporabite vse figure, se igralci izmenično premikajo.\n\nPremikanje\n\nZa premikanje igralec premakne eno od svojih figur vzdolž linije na plošči do proste sosednje točke. Če mu to ne uspe, je izgubil igro. Tako kot v fazi postavljanja ima igralec, ki postavi tri svoje figure na linijo deske, mlin in lahko odstrani eno od nasprotnikovih figur. Vsak igralec, ki zmanjša število figur na dve, nima možnosti oblikovanja novih mlinov in tako izgubi igro. Igralec lahko izgubi tudi, če ima več kot tri figure, če mu nasprotnik onemogoči premikanje.\n\nLeteči\n\nV nekaterih različicah pravil lahko igralec, ko ima le še tri figure, s svojimi figurami leti, skače ali skače na vse proste točke, ne le na sosednje.';

  @override
  String get versionInfo => 'Informacije o različici';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Licenca';

  @override
  String get sourceCode => 'Izvorna koda';

  @override
  String get appVersion => 'Različica aplikacije';

  @override
  String get general => 'Splošno';

  @override
  String get advanced => 'Napredno';

  @override
  String get placing => 'Nameščanje';

  @override
  String get moving => 'Premikanje';

  @override
  String get removing => 'Odstranjevanje';

  @override
  String get gameOverCondition => 'Pogoj za konec igre';

  @override
  String get aisPlayStyle => 'Igralni slog umetne inteligence';

  @override
  String get passive => 'Pasivni';

  @override
  String get timeout => 'Časovni interval';

  @override
  String get appearance => 'Videz';

  @override
  String get drawOnHumanExperience => 'Črpajte iz človeških izkušenj';

  @override
  String get considerMobility => 'Upoštevajte mobilnost delov';

  @override
  String get pieceCount => 'Število kosov:';

  @override
  String inHand(Object player, int count) {
    return '$player v roki: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player na krovu: $count';
  }

  @override
  String get boardTop => 'Odmik deske od vrha';

  @override
  String get notAIsTurn => 'Umetna inteligenca ni na potezi.';

  @override
  String get aiIsNotThinking => 'UI ne razmišlja.';

  @override
  String get atEnd => 'Ste na koncu seznama potez.';

  @override
  String get tapBackAgainToLeave =>
      'Ponovno se dotaknite nazaj, če želite oditi.';

  @override
  String get more => 'Več';

  @override
  String get experimental => 'Gre za eksperimentalno funkcijo.';

  @override
  String get experiments => 'Eksperimenti';

  @override
  String get ossLicenses => 'Odprtokodne licence';

  @override
  String get language => 'Jezik';

  @override
  String get defaultLanguage => 'Privzet jezik';

  @override
  String get mayMoveInPlacingPhase =>
      'Koščki se lahko premikajo v fazi postavljanja';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Ni ločenih faz postavljanja in premikanja, tj. igralci se lahko pri vsaki potezi odločijo, ali želijo postaviti figuro na igralno ploščo ali premakniti eno od svojih figur (če imajo še preostale figure za postavitev).';

  @override
  String get drawerColor => 'Barva menija';

  @override
  String get drawerTextColor => 'Barva besedila menija';

  @override
  String get drawerHighlightItemColor => 'Barva elementa v meniju';

  @override
  String get mainToolbarBackgroundColor => 'Barva ozadja glavne orodne vrstice';

  @override
  String get mainToolbarIconColor => 'Barva ikone glavne orodne vrstice';

  @override
  String get navigationToolbarBackgroundColor =>
      'Barva ozadja orodne vrstice za krmarjenje';

  @override
  String get navigationToolbarIconColor =>
      'Barva ikone v orodni vrstici za krmarjenje';

  @override
  String get autoHideToolbar => 'Samodejno skrij orodno vrstico';

  @override
  String get toolbarLocationOnScreen => 'Lokacija orodne vrstice na zaslonu';

  @override
  String get top => 'Na vrh';

  @override
  String get bottom => 'Spodaj';

  @override
  String get center => 'Center';

  @override
  String get solidColor => 'Enobarvna';

  @override
  String get picture => 'Slika';

  @override
  String get chooseYourPicture => 'Izberite svojo sliko';

  @override
  String get light => 'Svetloba';

  @override
  String get dark => 'Temno';

  @override
  String get themes => 'Teme';

  @override
  String get currentTheme => 'Trenutna tema';

  @override
  String get saveTheme => 'Shrani temo';

  @override
  String get showAnalysisGraph => 'Prikaži graf analize';

  @override
  String get analysis => 'Analiza';

  @override
  String get saveGame => 'Shranite igro';

  @override
  String get loadGame => 'Naloži igro';

  @override
  String get setupPosition => 'Položaj za nastavitev';

  @override
  String get showLegalMoves => 'Pokažite zakonite poteze';

  @override
  String get showLastMove => 'Pokaži zadnjo potezo';

  @override
  String get showArrows => 'Pokaži puščice';

  @override
  String get pieces => 'Kosi';

  @override
  String get showAnalysis => 'Prikaži analizo';

  @override
  String get threads => 'Niti';

  @override
  String get getInvolved => 'Sodelujte';

  @override
  String get helpImproveTranslate => 'Pomagajte izboljšati prevajanje';

  @override
  String get tutorial => 'Vadnica';

  @override
  String get classicMill => 'Klasični mlin';

  @override
  String get mixedMill => 'Mešani mlin';

  @override
  String get ceylonMill => 'Cejlonski mlin';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Mlin se lahko večkrat zlomi in predela';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Če igralec razbije mlin, da takoj ustvari nov mlin, lahko tak igralec pri naslednjem premiku tak kos premakne nazaj na prvotni spoj, če naredi nov mlin.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Igra se izžreba, če ima igralec tri figure in po desetih potezah noben igralec ne odstrani nasprotnikovih figur';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Ko je igralec na treh delih in noben igralec ne more odstraniti nasprotnikove figure v desetih potezah, je igra neodločena.';

  @override
  String get close => 'Zapri';

  @override
  String get whitePiece => 'Beli kos';

  @override
  String get blackPiece => 'Črni kos';

  @override
  String get emptyPoint => 'Prazna točka';

  @override
  String get noPoint => 'Nima smisla';

  @override
  String get placingPhase => 'Faza postavitve';

  @override
  String get movingPhase => 'Faza premikanja';

  @override
  String get flyingPhase => 'Faza letenja';

  @override
  String sideToMove(Object player) {
    return 'Stran za premikanje: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Zadnja poteza: $move';
  }

  @override
  String get selected => 'Izbrano';

  @override
  String get accessibility => 'Dostopnost';

  @override
  String get screenReaderSupport => 'Podpora za bralnik zaslona';

  @override
  String get isDraw => 'To je neodločeno!';

  @override
  String get draw => 'Žrebanje';

  @override
  String get pieceHighlightColor => 'Barva poudarka kosa';

  @override
  String get algorithm => 'Algoritem';

  @override
  String get endgameNMoveRule => 'End-game N-Move pravilo';

  @override
  String get endgameNMoveRule_Detail =>
      'Če ima kateri od igralcev le tri figure in noben od njih ne odstrani kosa v določenih potezah, je igra neodločena.';

  @override
  String get drawReasonEndgameRule50 =>
      'Vsak igralec ima samo tri figure in noben igralec ne odstrani figure v določenih potezah.';

  @override
  String get threefoldRepetitionRule => 'Pravilo trikratnega ponavljanja';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Igra se izenači, če se položaj pojavi tretjič.';

  @override
  String get continueToMakeMove => 'Mlin! Še naprej se premikajte.';

  @override
  String get pointStyle => 'Stil točke';

  @override
  String get pointWidth => 'Širina točke';

  @override
  String get solid => 'Trdno';

  @override
  String get hollow => 'Votlo';

  @override
  String get languageName => 'Slovenščina';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Premiki',
      one: '$count Premakni',
      zero: 'Premakni',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Nalaganje ni uspelo.';

  @override
  String get filename => 'Ime datoteke';

  @override
  String get browse => 'Prebrskaj …';

  @override
  String get gameFiles => 'Datoteke iger';

  @override
  String get gameSavedTo => 'Igra je shranjena v';

  @override
  String get empty => 'Prazno';

  @override
  String get noMove => 'Brez premikanja.';

  @override
  String get restoredPosition => 'Obnovljen začetni položaj.';

  @override
  String get clean => 'čisto';

  @override
  String get cleanedUp => 'Počiščeno.';

  @override
  String get remove => 'Odstrani';

  @override
  String get noPiecesCanBeRemoved => 'Nobenega kosa ni mogoče odstraniti.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count kosov',
      one: '$count kos',
      zero: 'Piece',
    );
    return '$_temp0 je treba odstraniti.';
  }

  @override
  String placedCount(int count) {
    return 'Postav. ($count)';
  }

  @override
  String get placedPieceCount =>
      'Štetje postavljenih kosov v fazi postavljanja.';

  @override
  String hasPlacedPieceCount(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Trenutni igralec je postavil $count figur.',
      few: 'Trenutni igralec je postavil $count figure.',
      two: 'Trenutni igralec je postavil dve figuri.',
      one: 'Trenutni igralec je postavil eno figuro.',
      zero: 'Trenutni igralec ni postavil nobene figure.',
    );
    return '$_temp0';
  }

  @override
  String get notPlacingPhase =>
      'Če ne postavite faze, je ne morete spremeniti.';

  @override
  String get paste => 'Prilepi';

  @override
  String get pasteDone => 'Pasta je narejena.';

  @override
  String get cannotPaste => 'Ni mogoče prilepiti.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Pokaži nepostavljene in odstranjene kose';

  @override
  String get fullScreen => 'Celozaslonski način';

  @override
  String get reopenToTakeEffect =>
      'Zaprite in znova odprite aplikacijo, da bodo nastavitve začele veljati.';

  @override
  String get forest => 'Gozd';

  @override
  String get desktopImage => 'Slika namizja';

  @override
  String get invalidPosition => 'Neveljaven položaj.';

  @override
  String get shareGIF => 'Delite GIF';

  @override
  String get pixelRatio => 'Razmerje slikovnih pik';

  @override
  String get duration => 'Trajanje';

  @override
  String get gameScreenRecorder => 'Snemalnik zaslona v igri';

  @override
  String get previous => 'Prejšnja';

  @override
  String get next => 'Naslednji';

  @override
  String get skip => 'Preskoči';

  @override
  String get gotIt => 'Razumem';

  @override
  String get youCanModifyRules =>
      'Pravila igre lahko spremenite v nastavitvah pravil.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Za spreminjanje vrednosti v izbirniku lahko uporabite kolesce miške.';

  @override
  String get noTimeLimitForThinking =>
      'Čas razmišljanja AI, nastavljen na 0, pomeni, da za razmišljanje ni časovne omejitve.';

  @override
  String get whatIsMtdf =>
      'MTD(f) je spremenjena oblika iskalnega algoritma alfa-beta, katerega namen je izboljšati učinkovitost s ponovno uporabo vmesnih rezultatov iskanja in uporabo dobrega začetnega ugibanja za zožitev iskalnega prostora.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Zavedajte se, da prilagoditev časa razmišljanja AI morda ni povsem natančna. Dejanski čas razmišljanja je lahko krajši, če je težavnostna stopnja nastavljena na nižjo vrednost, in je lahko daljši, ko je AI sredi razmišljanja, ko se čas izteče.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Če nastavite visoko težavnostno stopnjo, vendar ne povečate časa za razmišljanje AI, je lahko dejanska težavnostna stopnja omejena na nižjo vrednost zaradi časovne omejitve razmišljanja. Dejanska vrednost se lahko razlikuje glede na delovanje stroja.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) je iskalni algoritem za iskanje najboljše poteze v danem položaju. Je izboljšava algoritma alfa-beta in uporablja ničelna ali ničelna iskanja po oknu za potrditev, da je poteza slabša ali ne slabša od že varnega rezultata iz glavne različice. PVS se osredotoča na najbolj obetavne poteze in se izogiba nepotrebnemu iskanju neoptimalnih vej, kar pomaga izboljšati učinkovitost iskanja.';

  @override
  String get whatIsAlphaBeta =>
      'Algoritem alfa-beta je iskalni algoritem za iskanje najboljše poteze. Uporablja načelo minimax in dve vrednosti, alfa in beta, za zmanjšanje iskalnega drevesa in povečanje učinkovitosti. Alfa predstavlja najmanjši rezultat, za katerega je računalnik prepričan, da ga lahko dobi, medtem ko beta predstavlja največji rezultat, ki ga lahko doseže nasprotnik. Algoritem pomaga računalniku sprejemati pametne in učinkovite odločitve v igri.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Glede na človeške izkušnje, če poskušate zmagati, boste izgubili. Namesto tega si za cilj prizadevajte za remi in se izogibajte izgubi igre. Opazujte svojega nasprotnika in ga nežno zvabite v položaj, kjer lahko naredi napako. Ko pokažejo šibkost, izkoristite priložnost in nežno pritiskajte na zmago. Na ta način lahko zmagate v igri.';

  @override
  String get firstMoveDetail =>
      'V tej igri drugi igralec lažje zmaga kot prvi igralec.';

  @override
  String get passiveDetail =>
      'Če omogočite pasivno možnost, se bo AI sprostil, ko ima prednost v položaju, namesto da bi agresivno poskušal čim hitreje zmagati.';

  @override
  String get moveRandomlyDetail =>
      'Če omogočite to možnost, povečate naključnost in zabavnost igre, medtem ko jo onemogočite, lahko pomaga pri preučevanju načinov, kako premagati AI.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Če umetna inteligenca upošteva mobilnost svojih figur, si ne bo prizadeval le čim hitreje zajeti nasprotnikove figure, ampak bo razmislil tudi o blokiranju nasprotnikovih gibov in preprečitvi, da bi storil isto.';

  @override
  String get whenBoardIsFull => 'Ko je tabla polna';

  @override
  String get whenBoardIsFull_Detail =>
      'Na koncu faze postavljanja, preden se začne faza premikanja, sledi akcija, če je plošča polna kosov.';

  @override
  String get sideToMoveRemovePiece =>
      'Igralec, ki se prvi premakne v fazi premikanja, odstrani eno od nasprotnikovih figur.';

  @override
  String get agreeToDraw => 'Obe strani se strinjata z remijem.';

  @override
  String get takeOpponentsPiece => 'Vzemite eno od nasprotnikovih figur.';

  @override
  String get firstPlayerLose => 'Prvi igralec izgubi igro.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Prvi in drugi igralec odstranita eno od nasprotnikovih figur.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Drugi in prvi igralec odstranita eno od nasprotnikovih figur.';

  @override
  String get enteredFlyingPhase =>
      'Ko ste vstopili v fazo letenja, lahko nasprotnikove figure skočijo na katero koli prazno točko na plošči. Pravilo letenja lahko izklopite v \"Nastavitve pravila\".';

  @override
  String get whenStalemate => 'Ob zastoju';

  @override
  String get whenStalemate_Detail =>
      'Kakšno dejanje sledi, ko ni mogoče premakniti nobene figure?';

  @override
  String get endWithStalemateLoss => 'Končajte z izgubo na pat poziciji.';

  @override
  String get changeSideToMove => 'Za premikanje spremenite stran.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Odstranite eno od nasprotnikovih figur in naredite naslednjo potezo.';

  @override
  String get endWithStalemateDraw => 'Konec z neodločenim izidom.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Odstranite eno od nasprotnikovih figur in spremenite stran za premikanje.';

  @override
  String get aiResponseDelayTime => 'Čas zakasnitve odziva AI';

  @override
  String get aiIsDelaying =>
      'AI je trenutno v fazi zakasnjenega odziva. Počakajte nekaj časa, preden nadaljujete.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Nesosednjega kosa ne morete odstraniti.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Če je pat položaj, se lahko nasprotnikove figure, ki mejijo na vaše, odstranijo, ne glede na sestavo mlina.';

  @override
  String get whatIsMcts =>
      'MCTS je začetnikom prijazen algoritem, ki sprejema odločitve z raziskovanjem in vrednotenjem različnih potez s pomočjo simulacij.';

  @override
  String get goldenJade => 'Zlati žad';

  @override
  String get forestWood => 'Forest Wood';

  @override
  String get darkMystery => 'Temna skrivnost';

  @override
  String get midnightBlue => 'Polnočno modra';

  @override
  String get greenForest => 'Zeleni gozd';

  @override
  String get greenMeadow => 'Zeleni travnik';

  @override
  String get stonyPath => 'Kamnita pot';

  @override
  String get pastelPink => 'Pastelno roza';

  @override
  String get turquoiseSea => 'Turkizno morje';

  @override
  String get violetDream => 'Vijolične sanje';

  @override
  String get mintChocolate => 'Mint čokolada';

  @override
  String get skyBlue => 'Modro nebo';

  @override
  String get playfulGarden => 'Igrivi vrt';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Algoritem retrogradne analize uporablja večvrednostno retrogradno analizo, da iz različnih začetnih položajev zgradi zbirko podatkov o končni igri, nato pa to zbirko podatkov uporabi za optimizacijo igranja. Ta pristop spada v kategorijo ultra-močnih rešitev.';

  @override
  String get viewAlgorithmGuide =>
      'Ali si želite ogledati uporabniški priročnik za ta algoritem?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Prikaži indikator položajne prednosti';

  @override
  String get usePerfectDatabase => 'Uporabite popolno bazo podatkov';

  @override
  String get perfectDatabaseDescription =>
      'Omogočite to možnost, če želite uporabljati brezhibno zbirko podatkov o igrah, ustvarjeno z najsodobnejšimi algoritmi. Ta funkcija združuje uvodne in končne strategije za predlaganje optimalnih potez. To je najprimernejša izbira za igralce, ki iščejo najvišjo stopnjo natančnosti igranja. Baza podatkov, ustvarjena z natančnimi računalniškimi tehnikami, je zasnovana tako, da ponuja skoraj popolne rešitve za igre.\n\nOpomba: če AI ne uspe dostopati do baze podatkov, se bo za odločitve glede igranja obrnil na običajne algoritme. Ko je zbirka podatkov na voljo, postane \'Stopnja težavnosti\' praktično nepremagljiva, \'Čas za razmišljanje AI\' pa se drastično skrajša. Veliko nastavitev v možnostih \'AI\'s play style\' bo preglasenih, saj imajo rezultati baze podatkov najvišjo prednost.\n\nZa navodila o tem, kako kar najbolje izkoristiti to brezhibno bazo podatkov, kliknite tukaj.';

  @override
  String get backgroundImage => 'Ozadna slika';

  @override
  String get whatIsRandom =>
      'Ko možnost »Uporabi popolno bazo podatkov« ni omogočena, nastavitev »Naključno« povzroči, da umetna inteligenca premakne kose naključno brez uporabe algoritmov za izbiro potez. To običajno povzroči občutno šibkejše igranje. Nasprotno, ko je omogočena možnost »Uporabi popolno bazo podatkov«, se umetna inteligenca za sprejemanje odločitev zanaša izključno na »popolno bazo podatkov«, namesto da bi jo mešala s tradicionalnimi algoritmi umetne inteligence. V tem načinu poteze umetne inteligence v celoti temeljijo na vsebini baze podatkov, pri čemer se izogibajo zanašanju na izračune v realnem času ali algoritme iskanja.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Odstrani nasprotnikovo/nasprotničine figure iz roke; nato je na vrsti nasprotnik/nasprotnica, da postavi figuro.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Pri oblikovanju mlinov med fazo postavljanja';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Odstrani nasprotnikovo/nasprotničine figure s plošče.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Odstrani nasprotnikovo/nasprotničine figure s plošče; nato je na vrsti nasprotnik/nasprotnica, da postavi figuro.';

  @override
  String get opponentRemovesOwnPiece =>
      'Nasprotnik/nasprotnica odstrani lastne figure s plošče.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Namesto, da bi vi ukrepali, nasprotnik/nasprotnica izbere in odstrani svoje figure s plošče, tako da učinkovito izvede dejanje, ki je škodljivo zase.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Odstrani nasprotnikovo/nasprotničine figure iz roke; nato je tvoja poteza.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Odstrani figure iz nasprotnikove roke. Če naj bi bilo v skladu z nastavitvijo Multi-remove odstranjenih več figur, nasprotniku/nasprotnici pa v roki ni ostalo več figur, nadaljuj z odstranjevanjem nasprotnikovih figur s plošče. Nato je tvoja poteza. Če še naprej oblikuješ mline, lahko še naprej odstranjuješ nasprotnikove figure.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Odstrani figure iz nasprotnikove roke. Če naj bi bilo v skladu z nastavitvijo Multi-remove odstranjenih več figur, nasprotniku/nasprotnici pa v roki ni ostalo več figur, nadaljuj z odstranjevanjem nasprotnikovih figur s plošče. Nato je nasprotnikova poteza.';

  @override
  String get markAndDelayRemovingPieces =>
      'Označi in prestavi odstranjevanje figur.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Med fazo postavljanja se figure, ki jih je treba odstraniti, označijo, na te točke pa noben igralec ne more postaviti novih figur. Ko se začne faza premikanja, se te označene figure vse odstranijo, in igralci lahko nato svoje figure premikajo na te zdaj prazne točke.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Dejanja, ki jih je mogoče sprejeti med oblikovanjem mlinov v fazi postavljanja.';

  @override
  String get marked => 'Označeno';

  @override
  String get menu => 'Meni';

  @override
  String get monochrome => 'Monokromatsko';

  @override
  String get youCanEnableScreenReaderSupport =>
      'V splošnih nastavitvah lahko v nastavitvah dostopnosti omogočite podporo za bralnik zaslona.';

  @override
  String get showNumbersOnPieces => 'Prikaži številke na figurah';

  @override
  String get saveImage => 'Shrani sliko';

  @override
  String get isAnalysisToolbarShown => 'Prikaži orodno vrstico za analizo';

  @override
  String get analysisToolbarBackgroundColor =>
      'Barva ozadja orodne vrstice za analizo';

  @override
  String get analysisToolbarIconColor =>
      'Barva ikone orodne vrstice za analizo';

  @override
  String get transformed => 'Pretvorjeno.';

  @override
  String get cannotTransform => 'Ni mogoče pretvoriti.';

  @override
  String get rotate => 'Zavrti';

  @override
  String get horizontalFlip => 'H. Obr.';

  @override
  String get verticalFlip => 'V. Obr.';

  @override
  String get innerOuterFlip => 'N/Z Obr.';

  @override
  String get transparentCanvas => 'Prosojno Platno';

  @override
  String get restrictRepeatedMillsFormation =>
      'Omeji ponavljajoče se oblikovanje mlinov';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Figura, premaknjena iz enega mlina v drugega, se ne more takoj vrniti na izhodiščno točko v naslednjem potezu, da bi znova oblikovala mlin. Najprej je potrebna druga poteza.';

  @override
  String get oneTimeUseMill => 'Mlin za enkratno uporabo';

  @override
  String get oneTimeUseMill_Detail =>
      'Vsak mlin lahko odstrani nasprotnikovo figuro samo enkrat. Lahko jo znova spremenite, vendar je ni mogoče uporabiti za dodatne odstranitve.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Trenutna pravila, ki ste jih nastavili, nimajo ustrezne popolne zbirke podatkov. Za več informacij o popolni zbirki podatkov kliknite tukaj.';

  @override
  String get focusOnBlockingPaths => 'Osredotočite se na blokiranje poti';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Dajte prednost blokiranju premikov nasprotnika pred oblikovanjem mlinov. Namesto da bi se osredotočili na odstranjevanje figur z dokončanjem mlinov, AI poskuša nasprotnika ujeti v past, ga narediti nesposobnega za premikanje in zagotoviti zmago z izčrpanjem namesto z agresivno igro. Ta strategija ne blokira aktivno nasprotnikovih mlinov.';

  @override
  String get pieceImage => 'Slika figure';

  @override
  String get importColorSettings => 'Uvozi nastavitve barv';

  @override
  String get exportColorSettings => 'Izvozi nastavitve barv';

  @override
  String get import => 'Uvozi';

  @override
  String get export => 'Izvozi';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Najprej kopirajte nastavitve formata JSON v odložišče.';

  @override
  String get copiedToClipboard => 'Kopirano v odložišče.';

  @override
  String get imported => 'Uvoženo.';

  @override
  String get boardImage => 'Slika plošče';

  @override
  String get autumnLeaves => 'Jesensko Listje';

  @override
  String get legendaryLand => 'Legendarna Zemlja';

  @override
  String get vignetteEffect => 'Učinek vinjete';

  @override
  String get promptMakeToolbarTransparent =>
      'Ali želite, da je orodni vrstica popolnoma prosojna, ko je nastavljena slika ozadja plošče?';

  @override
  String get vibration => 'Omogoči vibracije v igri';

  @override
  String get soundTheme => 'Zvočna tema';

  @override
  String get ball => 'Krogla';

  @override
  String get liquid => 'Tekočina';

  @override
  String get wood => 'Les';

  @override
  String get placeEffectAnimation => 'Animacijski učinek pri postavitvi figure';

  @override
  String get removeEffectAnimation =>
      'Animacijski učinek pri odstranitvi figure';

  @override
  String get isToolbarAtBottom => 'Pokaži orodno vrstico na dnu';

  @override
  String get boardCornerRadius => 'Polmer vogala plošče';

  @override
  String get useOpeningBook => 'Uporabite knjigo odpiranja';

  @override
  String get currentRule => 'Trenutni';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Pravilnik';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Dovolite AI, da uporablja odpiralne poteze, ki jih pogosto uporabljajo profesionalni človeški igralci v zgodnji fazi igre. Opomba: Ta funkcija je trenutno na voljo samo za določene komplete pravil.';

  @override
  String get showAdvantageGraph => 'Prikaži graf prednosti';

  @override
  String get advantageGraphHint =>
      'Graf prednosti bo narisan le po tem, ko bo AI naredil potezo. Ne bo narisan, ko potezo naredi človeški igralec.';

  @override
  String get removalBasedOnMillCounts =>
      'Onemogočite odstranjevanje, dokler niso vse figure postavljene. Igralci odstranjujejo figure glede na število mlinov.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Onemogočite odstranjevanje, dokler niso vse figure postavljene. Igralci odstranjujejo figure glede na število mlinov: če je število enako, oba odstranita enako število figur; če ima eden več, odstrani eno figuro več in ohrani razliko ene figure. Če mlin ustvari samo eden, ta odstrani dve figuri, drugi pa eno. Če nihče ne ustvari mlina, oba odstranita po eno figuro.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Izberi eno od svojih figur.';

  @override
  String get notYourTurn => 'Ni tvoja poteza.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Barva ozadja orodne vrstice za opombe';

  @override
  String get annotationToolbarIconColor =>
      'Barva ikon orodne vrstice za opombe';

  @override
  String get isAnnotationToolbarShown => 'Prikaži orodno vrstico za opombe';

  @override
  String get enterAnnotationMode => 'Vstopi v način opomb';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Ali si prepričan, da želiš počistiti vse opombe?';

  @override
  String get llmPromptCopiedToClipboard => 'LLM poziv je kopiran v odložišče.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Povezava zavrnjena, strežnik je morda izklopljen.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Odkritje uspešno, čakam na povezavo...';

  @override
  String get noLanConnection => 'Ni LAN povezave';

  @override
  String get takeScreenshot => 'Posnemi zaslonsko sliko';

  @override
  String get disconnectedFromOpponent => 'Prekinjena povezava z nasprotnikom.';

  @override
  String get takeBackRequest => 'Zahteva za preklic poteze';

  @override
  String get nothingToShow => 'Ni ničesar za prikaz.';

  @override
  String get stopHosting => 'Ustavi gostovanje';

  @override
  String get connectionResetByPeer =>
      'Povezava je bila ponastavljena s strani nasprotnika.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Povezava izgubljena zaradi prekinitve srčnega utripa. Prosimo, ponovno se poveži.';

  @override
  String get startHosting => 'Začni gostovanje';

  @override
  String get restartRequestRejected => 'Zahteva za ponovni zagon zavrnjena.';

  @override
  String get notConnectedToLanOpponent =>
      'Ni povezave z nasprotnikom prek LAN-a.';

  @override
  String get llmPrompt => 'LLM poziv';

  @override
  String get gameRestarted => 'Igra je bila ponastavljena.';

  @override
  String get takeBackRejected => 'Zahteva za preklic poteze je zavrnjena.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Ali si prepričan, da želiš odstopiti od te igre?';

  @override
  String get opponentResignedYouWin => 'Nasprotnik je odstopil. Zmagal si!';

  @override
  String get clearAllAnnotations => 'Počisti vse opombe';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Povezano, čakam na potezo nasprotnika...';

  @override
  String get networkStatusDisconnected => 'Stanje omrežja: Prekinjeno';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Zahteva za preklic poteze je poslana nasprotniku.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Nasprotnik je morda zapustil igro';

  @override
  String get connectedToHostSuccessfully =>
      'Uspešno si se povezal z gostiteljem.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Povezava izgubljena: prekoračen čas srčnega utripa';

  @override
  String get noHostDiscovered => 'Gostitelj ni bil odkrit.';

  @override
  String get confirmResignation => 'Potrdi odstop';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Začel si gostovanje igre, čakam, da se igralci pridružijo...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Časovna omejitev povezave, omrežna povezava je nestabilna.';

  @override
  String get noLlmPromptAvailable => 'Ni na voljo LLM poziva.';

  @override
  String get youResignedGameOver => 'Odstopil si. Igra je končana.';

  @override
  String get serverIp => 'IP strežnika';

  @override
  String get confirmClear => 'Potrdi čiščenje';

  @override
  String get opponentSTurn => 'Poteza nasprotnika.';

  @override
  String get waitingAClientConnection => 'Čakam na povezavo odjemalca...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Zahteva za preklic poteze je bila zavrnjena ali ni uspela.';

  @override
  String get addText => 'Dodaj besedilo';

  @override
  String get exitAnnotationMode => 'Izhod iz načina opomb';

  @override
  String get typeYourAnnotation => 'Vnesi svojo opombo';

  @override
  String get attemptingToReconnect => 'Poskušam se ponovno povezati...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Zahteva za ponovni zagon je poslana. Čakam na odgovor nasprotnika...';

  @override
  String get serverIsStopped => 'Strežnik je ustavljen.';

  @override
  String get restartRequest => 'Zahteva za ponovni zagon';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Ne moreš zahtevati preklica poteze, ko ni tvoja poteza.';

  @override
  String get takeBackAccepted => 'Zahteva za preklic poteze sprejeta.';

  @override
  String get localNetworkSettings => 'Nastavitve lokalnega omrežja';

  @override
  String get reconnectedSuccessfully => 'Uspešno si se ponovno povezal!';

  @override
  String get failedToSaveImageToGallery =>
      'Slike ni bilo mogoče shraniti v galerijo.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Nasprotnik je zahteval ponovni zagon igre. Ali sprejemaš?';

  @override
  String get yourTurn => 'Tvoja poteza.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Ni uspelo ponovno povezati, prosim, ponovno zaženi igro.';

  @override
  String get host => 'Gostitelj';

  @override
  String get join => 'Pridruži se';

  @override
  String get port => 'Vrata';

  @override
  String get invalidIpAddress => 'Neveljaven IP naslov.';

  @override
  String get invalidPort => 'Neveljavna vrata.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Povezujem: Poskus $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Povezovanje ni uspelo: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Gostovanje ni uspelo: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Gostitelj odkrit: $ip:$port';
  }

  @override
  String get stop => 'Ustavi';

  @override
  String get discover => 'Odkrij';

  @override
  String get connect => 'Poveži';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Odjemalec povezan: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Odkrij: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Ponovno povezovanje ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Povezan';

  @override
  String get delete => 'Izbriši';

  @override
  String get ancientEgypt => 'Stari Egipt';

  @override
  String get gothicIce => 'Gotski Led';

  @override
  String get riceField => 'Riževo Polje';

  @override
  String get chinesePorcelain => 'Kitajski Porcelan';

  @override
  String get desertDusk => 'Puščavski Somrak';

  @override
  String get precisionCraft => 'Natančno Obrtništvo';

  @override
  String get folkEmbroidery => 'Ljudsko Vezenje';

  @override
  String get carpathianHeritage => 'Karpatska Dediščina';

  @override
  String get imperialGrandeur => 'Cesarska Veličastnost';

  @override
  String get bohemianCrystal => 'Češki Kristal';

  @override
  String get savannaSunrise => 'Savanski Sončni Vzhod';

  @override
  String get harmonyBalance => 'Harmonija in Ravnovesje';

  @override
  String get cinnamonSpice => 'Cimetova Začimba';

  @override
  String get anatolianMosaic => 'Anatolski Mozaik';

  @override
  String get carnivalSpirit => 'Karnevalski Duh';

  @override
  String get custom => 'Po meri';

  @override
  String get spiceMarket => 'Tržnica začimb';

  @override
  String get swipeToRevealTheDrawer => 'Podrsajte, da prikažete predal';

  @override
  String get showGameInfoOnScreenshots =>
      'Prikaži informacije o igri na posnetkih zaslona';

  @override
  String get humanMoveTime => 'Časovna omejitev za človeka';

  @override
  String get noTimeLimitForHumanMoves =>
      'Brez časovne omejitve za človeške poteze';

  @override
  String get timeoutLoseWillBeApplied =>
      'Izguba zaradi časovne omejitve bo uporabljena za človeškega igralca';

  @override
  String get identifyingBoard => 'Prepoznava igralne plošče...';

  @override
  String get youCanEnterAnyModelName => 'Lahko vnesete poljubno ime modela.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Položaj plošče je bil uporabljen. FEN je kopiran v odložišče.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Predlog: poskusite posneti bolj jasno sliko plošče.';

  @override
  String get llmPromptTemplate => 'Predloga poziva LLM';

  @override
  String get noValidBoardDetected => 'Ni bilo zaznane nobene veljavne plošče.';

  @override
  String get selectingImageFromAlbum => 'Izbira slike iz albuma...';

  @override
  String get configurePromptTemplate => 'Konfiguriraj predlogo poziva';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Uredi predlogo poziva za analizo LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Ni uspelo ustvariti FEN iz prepoznane plošče.';

  @override
  String get outputInCurrentLanguage => 'Izhod v trenutnem jeziku';

  @override
  String get commonBaseUrls => 'Pogoste osnovne URL-je';

  @override
  String get viewCommonModels => 'Ogled pogostih modelov';

  @override
  String get recognitionParametersUpdated =>
      'Parametri prepoznavanja posodobljeni.';

  @override
  String get whiteSMove => 'Poteza belih';

  @override
  String get resetToDefaults => 'Ponastavi na privzete nastavitve';

  @override
  String get photoShoot => 'Fotografiranje';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Ni uspelo uporabiti prepoznanega položaja plošče.';

  @override
  String get llmPromptContent => 'Vsebina poziva LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM ni konfiguriran. Prosimo, preverite nastavitve.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Nastavite ponudnika, model, API ključ in osnovni URL';

  @override
  String get llmConfiguration => 'Konfiguracija LLM';

  @override
  String get configureLlmProvider => 'Konfiguriraj ponudnika LLM';

  @override
  String get llmPromptTemplateHeader => 'Glava predloge poziva LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Na sliki niso bile prepoznane nobene figure. Poskusite znova.';

  @override
  String get recognizeBoardFromImage => 'Prepoznaj ploščo iz slike';

  @override
  String get viewTips => 'Ogled nasvetov';

  @override
  String get applyToBoard => 'Uporabi na ploščo';

  @override
  String get adjustBoardArea => 'Prilagodi območje plošče';

  @override
  String get viewCommonUrls => 'Ogled pogostih URL-jev';

  @override
  String get colorAnalysisFailed => 'Analiza barv ni uspela!';

  @override
  String get analyzingGameBoardImage => 'Analiza slike igralne plošče...';

  @override
  String get selectFromAlbum => 'Izberi iz albuma';

  @override
  String get noBoardPointDetected => 'Ni zaznane nobene točke plošče!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Če pustite prazno, bo uporabljena privzeta predloga';

  @override
  String get llmConfig => 'Konfiguracija LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Ali ste prepričani, da želite ponastaviti predloge pozivov na privzete vrednosti?';

  @override
  String get llmPromptTemplateFooter => 'Noga predloge poziva LLM';

  @override
  String get loadingResponse => 'Nalaganje odziva...';

  @override
  String get applyThisResultToBoard => 'Uporabi ta rezultat na ploščo';

  @override
  String get takingPicture => 'Slikanje...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Prosimo, izberite sliko igralne plošče za prepoznavo';

  @override
  String get identificationResults => 'Rezultati prepoznavanja';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analizirajte poteze in podajte vpoglede.';

  @override
  String get getApiKey => 'Pridobi API ključ';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Celoten postopek prepoznavanja se ni uspel dokončati.';

  @override
  String get boardRecognitionResult => 'Rezultat prepoznavanja plošče';

  @override
  String get askLlm => 'Vprašajte LLM';

  @override
  String get boardDetectionFailed => 'Zaznavanje plošče ni uspelo!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Ni zaznane nobene točke plošče, ni mogoče prepoznati figure!';

  @override
  String get copyFen => 'Kopiraj FEN';

  @override
  String get commonlyUsedModels => 'Pogosto uporabljeni modeli';

  @override
  String get apiKeyOptional => 'API ključ (neobvezno)';

  @override
  String get noImageSelected => 'Nobena slika ni izbrana';

  @override
  String get blackSMove => 'Poteza črnih';

  @override
  String get llm => 'Velik jezikovni model';

  @override
  String get llmProvider => 'Ponudnik';

  @override
  String get baseUrl => 'Osnovni URL';

  @override
  String get model => 'Model';

  @override
  String get temperature => 'Temperatura';

  @override
  String get llmCommandReceivedProcessing => 'Ukaz prejet! UI obdeluje...';

  @override
  String get llmDeepThinkingWait =>
      'Poteka globoko razmišljanje, prosimo počakajte...';

  @override
  String get llmPresentingSoon => 'Kmalu bo predstavljeno...';

  @override
  String get recognitionParameters => 'Parametri prepoznavanja';

  @override
  String get adjustParamsDesc =>
      'Prilagodite parametre za izboljšanje natančnosti prepoznavanja';

  @override
  String get saveParameters => 'Shrani parametre';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Ni mogoče zagnati prepoznavanja slike: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Prepoznavanje slike ni uspelo: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Uporabljen položaj z $whiteCount belimi in $blackCount črnimi figurami';
  }

  @override
  String get fenCopiedToClipboard => '(FEN kopiran v odložišče)';

  @override
  String recognitionFailed(String error) {
    return 'Prepoznavanje ni uspelo: $error';
  }

  @override
  String get myRating => 'Moja ocena';

  @override
  String get gamesPlayed => 'Odigrane igre';

  @override
  String get wins => 'Zmage';

  @override
  String get losses => 'Porazi';

  @override
  String get draws => 'Neodločeno';

  @override
  String get lastUpdated => 'Nazadnje posodobljeno';

  @override
  String get format => 'Format:';

  @override
  String get resetStatistics => 'Ponastavi statistiko';

  @override
  String get drawRate => 'Stopnja neodločenih izidov';

  @override
  String get lossRate => 'Stopnja porazov';

  @override
  String get aiStatistics => 'Statistika UI';

  @override
  String get enableStatistics => 'Omogoči statistiko';

  @override
  String get enableStatistics_Detail =>
      'Ko je omogočeno, se bodo rezultati iger beležili v statistiki. Vendar pa se igre, ki vključujejo vračanje potez, ne bodo beležile. Ko je onemogočeno, je zbiranje statistike začasno ustavljeno.';

  @override
  String get thisWillResetAllGameStatistics =>
      'S tem boste ponastavili vso statistiko igre. Tega dejanja ni mogoče razveljaviti.';

  @override
  String get boardInnerRingSize => 'Velikost notranjega obroča deske';

  @override
  String get boardShadowEnabled => 'Senca plošče';

  @override
  String get trapAwareness => 'Zaznavanje pasti';

  @override
  String get trapAwarenessDescription =>
      'Med analizo poudari poteze pasti z odebeljenimi krogi in puščicami.';

  @override
  String trapExists(String trapMoves) {
    return 'Past obstaja. Poteze pasti: $trapMoves';
  }

  @override
  String get custodianCapture => 'Zajemanje boka';

  @override
  String get custodianCaptureDescription =>
      'Eden od nasprotnikovih kosov med dvema od vaših priložite v ravni črti, da jo zajamete.';

  @override
  String get custodianCaptureEnable => 'Dovoli zajemanje boka';

  @override
  String get interventionCapture => 'Zajem intervencije';

  @override
  String get interventionCaptureDescription =>
      'Premaknite se v prazno točko med dvema nasprotnikovim kosom, da ju zajamete oba.';

  @override
  String get interventionCaptureEnable => 'Dovoli zajem intervencije';

  @override
  String get leapCapture => 'Zajem skoka';

  @override
  String get leapCaptureDescription =>
      'Ujemite tako, da skočite čez sosednji nasprotnikov kos v prazno točko onkraj.';

  @override
  String get leapCaptureEnable => 'Dovoli zajem skoka';

  @override
  String get captureApplicableLines => 'Veljavne vrstice';

  @override
  String get captureSquareEdges => 'Ob robovih trga';

  @override
  String get captureCrossLines =>
      'Vzdolž ortogonalnih linij, ki prečkajo kvadrat';

  @override
  String get captureDiagonalLines =>
      'Vzdolž diagonalnih linij, ki prečkajo kvadrat';

  @override
  String get captureExecutionPhases => 'Faze izvajanja';

  @override
  String get capturePiecesCondition =>
      'Razpoložljivost v fazi gibanja na podlagi preostalih kosov';

  @override
  String get capturePiecesConditionUnlimited => 'Brez omejitve';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Na voljo, ko imate tri ali manj kosov';
}
