// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Slovak (`sk`).
class SSk extends S {
  SSk([String locale = 'sk']) : super(locale);

  @override
  String get appName => 'Mlyn';

  @override
  String get welcome => 'Vitajte na';

  @override
  String get yes => 'Áno';

  @override
  String get no => 'Nie';

  @override
  String get game => 'Hra';

  @override
  String get humanVsAi => 'Človek proti UI';

  @override
  String get humanVsHuman => 'Človek proti človeku';

  @override
  String get aiVsAi => 'AI proti AI';

  @override
  String get humanVsCloud => 'Človek proti oblaku';

  @override
  String get humanVsLAN => 'Človek proti LAN';

  @override
  String get testViaLAN => 'Test cez LAN';

  @override
  String get move => 'Presun';

  @override
  String get showMoveList => 'Zoznam presunov';

  @override
  String get moveList => 'Zoznam ťahov';

  @override
  String get noGameRecord => 'Žiadny záznam';

  @override
  String get ok => 'OK';

  @override
  String get confirm => 'Potvrdiť';

  @override
  String get cancel => 'Zrušiť';

  @override
  String get tipSelectWrong => 'Vybrali ste nesprávnu figúrku.';

  @override
  String get tipPlace => 'Umiestnite svoje figúrky.';

  @override
  String get tipBanPlace => 'Sem ju nemôžete umiestniť.';

  @override
  String get tipPlaced => 'Umiestnili ste figúrku.';

  @override
  String get tipRemove => 'Odstráňte figúrku.';

  @override
  String get tipBanRemove => 'Nemôžete ju odstrániť.';

  @override
  String get tipRemoved => 'Odstránili ste figúrku.';

  @override
  String get tipMove => 'Presuňte figúrku.';

  @override
  String get tipCannotPlace => 'Nemôžete sem umiestniť figúrku.';

  @override
  String get tipCannotMove => 'Nemôžete sem presunúť svoju figúrku.';

  @override
  String get tipMill => 'Mlyn! Odstráňte súperovu figúrku.';

  @override
  String get tipContinueMill => 'Pokračujte v odstraňovaní súperových figúrok.';

  @override
  String get tipSelectOpponentsPiece =>
      'Vyberte si jednu zo súperových figúrok.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Z mlyna nemôžete odstrániť figúrku.';

  @override
  String get tipCanMoveOnePoint => 'Figúrka sa môže presunúť o 1 pole.';

  @override
  String get tipCannotMoveOpponentsPieces => 'Nemôžete pohnúť figúrkou súpera.';

  @override
  String get tipSelectPieceToMove =>
      'Vyberte si figúrku, ktorou sa budete pohybovať.';

  @override
  String get tipHaveThreePiecesLeft => 'Zostávajú vám tri figúrky.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Môžete presunúť figúrku na ľubovoľné pole.';

  @override
  String tipToMove(Object player) {
    return '$player pre pohyb.';
  }

  @override
  String get whiteWin => 'Hráč 1 vyhráva!';

  @override
  String get blackWin => 'Hráč 2 vyhráva!';

  @override
  String get won => 'Vyhral';

  @override
  String get lost => 'Prehral';

  @override
  String get thinking => 'Premýšľam…';

  @override
  String get newGame => 'Nová hra';

  @override
  String get importGame => 'Import hry';

  @override
  String get exportGame => 'Export hry';

  @override
  String get gameImported => 'Hra bola importovaná.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Nie je možné importovať $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Pohyby a pravidlá sa nezhodujú.';

  @override
  String get pleaseWait => 'Počkajte, prosím.';

  @override
  String get restartGame => 'Reštartovať aktuálnu hru?';

  @override
  String get restart => 'Reštartovať';

  @override
  String get gameStarted => 'Hra sa spustila, prosím, umiestnite.';

  @override
  String get analyzing => 'Analýza…';

  @override
  String error(Object message) {
    return 'Chyba: $message';
  }

  @override
  String get winRate => 'Miera výhry';

  @override
  String get score => 'Skóre:';

  @override
  String get white => 'Hráč 1';

  @override
  String get black => 'Hráč 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player počet kusov je menší ako tri.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player rezignovať.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player nemá kam ísť.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Doska je plná a $player nemá kam ísť.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Čas sa skončil, $player stratený.';
  }

  @override
  String get drawReasonRule50 =>
      'Vo fáze pohybu nebola v poslednom určenom počte ťahov odstránená žiadna figúrka.';

  @override
  String get drawReasonBoardIsFull =>
      'Je to remíza, pretože šachovnica je plná.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Je to remíza, pretože sa trikrát opakuje.';

  @override
  String get gameOverUnknownReason => 'Hra skončila! Neznámy dôvod.';

  @override
  String get gameOver => 'Koniec hry';

  @override
  String get youWin => 'Vyhrali ste! Gratulujeme!';

  @override
  String challengeHarderLevel(int level) {
    return 'Vyzvite ťažšiu úroveň? Nová úroveň bude úroveň $level!';
  }

  @override
  String get youLose => 'Prehrali ste!';

  @override
  String get analyze => 'Analyzujte';

  @override
  String get about => 'O stránke';

  @override
  String version(Object versionNumber) {
    return 'Verzia: $versionNumber';
  }

  @override
  String get thanks => 'Vďaka';

  @override
  String get settings => 'Nastavenia';

  @override
  String get options => 'Možnosti';

  @override
  String get generalSettings => 'Všeobecné nastavenia';

  @override
  String get skillLevel => 'Úroveň obtiažnosti';

  @override
  String get moveTime => 'Čas myslenia AI';

  @override
  String get difficulty => 'Obtiažnosť';

  @override
  String get playSounds => 'Zvukové efekty';

  @override
  String get playSoundsInTheGame => 'Prehrávanie zvukov v hre';

  @override
  String get keepMuteWhenTakingBack => 'Zachovať stlmenie pri návrate';

  @override
  String get tone => 'Tón';

  @override
  String get whoMovesFirst => 'Prvý ťah';

  @override
  String get human => 'Ľudský';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Alternatívny';

  @override
  String get isAutoRestart => 'Automatický reštart hry po skončení hry';

  @override
  String get isAutoChangeFirstMove => 'Automatická zmena prvého ťahu';

  @override
  String get shufflingEnabled => 'Náhodný ťah';

  @override
  String get misc => 'Rôzne';

  @override
  String get rules => 'Pravidlá';

  @override
  String get piecesCount => 'Počet figúrok, ktoré má každý hráč';

  @override
  String get piecesCount_Detail => 'Koľko figúrok má každý hráč?';

  @override
  String get flyPieceCount => 'Počet letiacich figúrok';

  @override
  String get flyPieceCount_Detail =>
      'Ak je zapnutá funkcia Lietanie, keď sa počet figúrok hráča zníži na určitý počet, jeho figúrky sa môžu voľne presunúť na ľubovoľný neobsadený bod namiesto toho, aby boli obmedzené na susedné body ako vo zvyšku hry.';

  @override
  String get piecesAtLeastCount => 'Najmenej figúrok';

  @override
  String get hasDiagonalLines => 'Diagonálne línie';

  @override
  String get hasDiagonalLines_Detail =>
      'Pridajte na hraciu plochu štyri diagonálne čiary.';

  @override
  String get isDefenderMoveFirst => 'Druhý hráč sa pohybuje ako prvý';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Hráč, ktorý sa vo fáze umiestňovania pohybuje ako druhý, sa vo fáze pohybu pohybuje ako prvý.';

  @override
  String get mayRemoveMultiple => 'Viacnásobné premiestňovanie';

  @override
  String get mayRemoveMultiple_Detail =>
      'Ak hráč uzavrie viac ako jeden mlyn naraz, odstráni toľko mlynov, koľko ich uzavrel.';

  @override
  String get mayRemoveFromMillsAlways => 'Zničte mlyny';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'V predvolenom nastavení musia hráči pred odstránením figúrky z vytvoreného mlyna najprv odstrániť všetky ostatné figúrky. Zapnutím tejto možnosti toto obmedzenie vypnete.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Druhý hráč prehráva, keď je hracia plocha plná';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Keď je na konci umiestňovacej fázy hracia plocha plná, strana, ktorá umiestni prvú figúrku, prehráva hru. V opačnom prípade je hra remízová.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Prehrať, keď nie sú žiadne legálne ťahy';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Hráč prehrá, ak ho súper zablokuje tak, že sa nemôže pohnúť. Zmena strany na ťah, ak je táto možnosť vypnutá.';

  @override
  String get mayFly => 'Lietanie';

  @override
  String get mayFly_Detail =>
      'Ak hráčovi zostanú len tri alebo štyri (konfigurovateľné) figúrky, môže figúrku presunúť na ľubovoľný voľný bod.';

  @override
  String get nMoveRule => 'Pravidlo N ťahov';

  @override
  String get nMoveRule_Detail =>
      'Hra je remízová, ak v určitom počte ťahov nedošlo k odstráneniu figúrky každým hráčom.';

  @override
  String get rollback => 'Vrátenie späť';

  @override
  String get pleaseSelect => 'Vyberte si';

  @override
  String get copy => 'Kopírovať';

  @override
  String get moveHistoryCopied => 'História ťahov sa skopíruje do schránky.';

  @override
  String get help => 'Pomoc';

  @override
  String get feedback => 'Spätná väzba';

  @override
  String get exit => 'Ukončenie';

  @override
  String get ruleSettings => 'Nastavenia pravidiel';

  @override
  String get color => 'Farba';

  @override
  String get boardColor => 'Farba tabule';

  @override
  String get pieceColor => 'Farba figúrky';

  @override
  String get backgroundColor => 'Farba pozadia';

  @override
  String get lineColor => 'Farba línie dosky';

  @override
  String get whitePieceColor => 'Farba figúrky hráča 1';

  @override
  String get blackPieceColor => 'Farba figúrky hráča 2';

  @override
  String get messageColor => 'Farba správy';

  @override
  String get isPieceCountInHandShown => 'Zobrazenie počtu dielikov v ruke';

  @override
  String get isNotationsShown => 'Zobrazenie poznámok na hracej ploche';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Zobraziť navigačný panel s históriou';

  @override
  String get display => 'Zobraziť';

  @override
  String get boardBorderLineWidth => 'Šírka okraja šachovnice';

  @override
  String get boardInnerLineWidth => 'Šírka vnútornej línie šachovnice';

  @override
  String get pieceWidth => 'Šírka dielu';

  @override
  String get fontSize => 'Veľkosť písma';

  @override
  String get standardNotation => 'Zápis WMD';

  @override
  String get restore => 'Obnoviť';

  @override
  String get restoreDefaultSettings => 'Obnovenie predvolených nastavení';

  @override
  String pick(Object element) {
    return 'Vyberte $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Nápoveda';

  @override
  String get player => 'hráč';

  @override
  String get player1 => 'Hráč 1';

  @override
  String get player2 => 'Hráč 2';

  @override
  String get howToPlay => 'Ako hrať';

  @override
  String get toPlacePiece =>
      'Ťuknutím na ľubovoľný dostupný bod umiestnite figúrku.';

  @override
  String get toSelectPiece => 'Ťuknutím na figúrku ju presuniete.';

  @override
  String get toMovePiece =>
      'Klepnutím na bod pripojený k figúrke ju presuniete.';

  @override
  String get toRemovePiece =>
      'Ťuknutím na jednu súperovu figúrku ju odstránite.';

  @override
  String get needToCreateMillFirst =>
      'Pred odstránením figúrky musíte najprv vytvoriť mlyn.';

  @override
  String get needToPlayWithOwnPieces => 'Musíte hrať so svojimi figúrkami.';

  @override
  String get statistics => 'Štatistiky';

  @override
  String get totalGames => 'Celkový počet hier';

  @override
  String get results => 'Výsledky';

  @override
  String get left => 'vľavo';

  @override
  String get privacyPolicy => 'Zásady ochrany osobných údajov';

  @override
  String get privacyPolicy_Detail_1 =>
      'Pozorne si ju prečítajte a uistite sa, že jej plne rozumiete a súhlasíte s ňou ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Ak s týmito zásadami nesúhlasíte, nepoužívajte túto aplikáciu. Používanie aplikácie znamená, že súhlasíte s týmito podmienkami.';

  @override
  String get and => ' a . ';

  @override
  String get accept => 'Prijímam';

  @override
  String get takeBack => 'Vrátiť späť';

  @override
  String get takingBack => 'Vrátenie späť…';

  @override
  String get waiting => 'Čakanie…';

  @override
  String get stepForward => 'Krok vpred';

  @override
  String get takeBackAll => 'Vziať späť všetko';

  @override
  String get stepForwardAll => 'Krok vpred všetky';

  @override
  String get moveNow => 'Pohybovať sa teraz';

  @override
  String get done => 'Hotovo.';

  @override
  String get crackMill => 'Trhací mlyn';

  @override
  String get crackMill_Detail =>
      'Ak má hráč iba figúrky v mlynoch, figúrky v mlynoch sa nezablokujú na odstránenie.';

  @override
  String get animationDuration => 'Trvanie animácie';

  @override
  String get none => 'Žiadne';

  @override
  String get theme => 'Téma';

  @override
  String get helpContent =>
      'Cieľom hry je nechať súpera s menej ako tromi figúrkami alebo bez legálnych ťahov.\n\nHra automaticky remizuje, ak sa pozícia vyskytne tretíkrát alebo sa v posledných 100 (konfigurovateľných) ťahoch neodstráni.\n\nHra prebieha v troch fázach:\n\n1. Umiestnenie figúrok na voľné body\n2. Presun figúrok na susedné body\n3. (voliteľná fáza) Presun figúrok na ľubovoľný voľný bod pri znížení počtu figúrok hráča na tri\n\nUmiestnenie\n\nHra sa začína s prázdnou hracou plochou, ktorú tvorí mriežka s dvadsiatimi štyrmi bodmi. Hráči sa striedajú v umiestňovaní svojich figúrok na voľné body, kým každý hráč neumiestni všetky figúrky na hraciu plochu. Ak hráč dokáže umiestniť tri svoje figúrky rovno, má \"mlyn\" a môže odstrániť jednu zo súperových figúrok z hracej plochy.\n\nV niektorých pravidlách musia hráči pred odstránením figúrky z vytvoreného mlyna najprv odstrániť všetky ostatné figúrky.\n\nV niektorých pravidlách nie je možné vo fáze umiestňovania figúrky opäť umiestniť na miesta odstránených figúrok.\n\nPo použití všetkých figúrok sa hráči striedajú v pohybe.\n\nPresun\n\nNa presun hráč posunie jednu zo svojich figúrok po línii hracej plochy na voľný susedný bod. Ak tak nemôže urobiť, prehral hru. Rovnako ako vo fáze umiestňovania, hráč, ktorý postaví tri svoje figúrky na líniu hracej plochy, má mlyn a môže odstrániť jednu zo súperových figúrok. Ktorýkoľvek hráč zníži počet figúrok na dve, nemá možnosť vytvoriť nové mlyny, a tým prehráva hru. Hráč môže prehrať aj vtedy, keď má viac ako tri figúrky, ak mu súper blokuje pohyb.\n\nLietajúce\n\nV niektorých variantoch pravidiel platí, že akonáhle hráčovi zostanú len tri figúrky, môžu jeho figúrky lietať, skákať alebo preskakovať na ľubovoľné voľné body, nielen na susedné.\n';

  @override
  String get versionInfo => 'Informácie o verzii';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Licencia';

  @override
  String get sourceCode => 'Zdrojový kód';

  @override
  String get appVersion => 'Verzia aplikácie';

  @override
  String get general => 'Všeobecné';

  @override
  String get advanced => 'Rozšírené';

  @override
  String get placing => 'Umiestnenie stránky';

  @override
  String get moving => 'Presúvanie';

  @override
  String get removing => 'Odstránenie';

  @override
  String get gameOverCondition => 'Podmienka ukončenia hry';

  @override
  String get aisPlayStyle => 'Herný štýl umelej inteligencie';

  @override
  String get passive => 'Pasívne';

  @override
  String get timeout => 'Časový limit';

  @override
  String get appearance => 'Vzhľad';

  @override
  String get drawOnHumanExperience => 'Čerpanie z ľudskej skúsenosti';

  @override
  String get considerMobility => 'Zohľadnite mobilitu častí';

  @override
  String get pieceCount => 'Počet kusov:';

  @override
  String inHand(Object player, int count) {
    return '$player v ruke: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player na palube: $count';
  }

  @override
  String get boardTop => 'Doska posunutá zhora';

  @override
  String get notAIsTurn => 'Umelá inteligencia nie je na ťahu.';

  @override
  String get aiIsNotThinking => 'AI nemyslí.';

  @override
  String get atEnd => 'Ste na konci zoznamu ťahov.';

  @override
  String get tapBackAgainToLeave => 'Ťuknutím na tlačidlo späť znova odíďte.';

  @override
  String get more => 'Viac na';

  @override
  String get experimental => 'Ide o experimentálnu funkciu.';

  @override
  String get experiments => 'Experimenty';

  @override
  String get ossLicenses => 'Licencie s otvoreným zdrojovým kódom';

  @override
  String get language => 'Jazyk';

  @override
  String get defaultLanguage => 'Predvolený jazyk';

  @override
  String get mayMoveInPlacingPhase =>
      'Figúrky sa môžu pohybovať vo fáze umiestňovania';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Neexistujú žiadne odlišné fázy umiestňovania a presunu, t. j. hráči sa môžu pri každom ťahu rozhodnúť, či chcú umiestniť figúrku na hraciu plochu, alebo presunúť jednu zo svojich figúrok (pokiaľ im zostávajú figúrky na umiestnenie).';

  @override
  String get drawerColor => 'Farba ponuky';

  @override
  String get drawerTextColor => 'Farba textu ponuky';

  @override
  String get drawerHighlightItemColor => 'Farba položky zvýraznenia ponuky';

  @override
  String get mainToolbarBackgroundColor =>
      'Farba pozadia hlavného panela nástrojov';

  @override
  String get mainToolbarIconColor => 'Farba ikony hlavného panela nástrojov';

  @override
  String get navigationToolbarBackgroundColor =>
      'Farba pozadia panela navigácie';

  @override
  String get navigationToolbarIconColor => 'Farba ikony panela navigácie';

  @override
  String get autoHideToolbar => 'Automaticky skryť panel s nástrojmi';

  @override
  String get toolbarLocationOnScreen =>
      'Umiestnenie panela s nástrojmi na obrazovke';

  @override
  String get top => 'Top';

  @override
  String get bottom => 'Dole';

  @override
  String get center => 'Stred';

  @override
  String get solidColor => 'Jednofarebná';

  @override
  String get picture => 'Obrázok';

  @override
  String get chooseYourPicture => 'Vyberte si obrázok';

  @override
  String get light => 'Svetlo';

  @override
  String get dark => 'Tma';

  @override
  String get themes => 'Témy';

  @override
  String get currentTheme => 'Aktuálna téma';

  @override
  String get saveTheme => 'Uložiť tému';

  @override
  String get showAnalysisGraph => 'Zobraziť graf analýzy';

  @override
  String get analysis => 'Analýza';

  @override
  String get saveGame => 'Uložiť hru';

  @override
  String get loadGame => 'Načítať hru';

  @override
  String get setupPosition => 'Poloha nastavenia';

  @override
  String get showLegalMoves => 'Ukážte legálne pohyby';

  @override
  String get showLastMove => 'Zobraziť posledný ťah';

  @override
  String get showArrows => 'Zobraziť šípky';

  @override
  String get pieces => 'Kusy';

  @override
  String get showAnalysis => 'Zobraziť analýzu';

  @override
  String get threads => 'Nite';

  @override
  String get getInvolved => 'Zapojte sa';

  @override
  String get helpImproveTranslate => 'Pomôžte nám vylepšiť preklad';

  @override
  String get tutorial => 'Výukový program';

  @override
  String get classicMill => 'Klasický mlyn';

  @override
  String get mixedMill => 'Zmiešaný mlyn';

  @override
  String get ceylonMill => 'Cejlónsky mlyn';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Mlyn môže byť opakovane rozbitý a prerobený';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Ak hráč rozbije mlyn a vytvorí nový mlyn okamžite, môže tento hráč pri ďalšom ťahu presunúť taký kúsok späť na pôvodné spojenie, ak urobí nový mlyn.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Hra má remízu, ak má hráč tri figúrky a po desiatich ťahoch ani jeden hráč súperove figúrky neodstráni';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Ak je počet hráčov na tri figúrky a žiadny hráč nedokáže odstrániť súperovu figúrku do desiatich ťahov, hra sa končí remízou.';

  @override
  String get close => 'Zavrieť';

  @override
  String get whitePiece => 'Biely kus';

  @override
  String get blackPiece => 'Čierny kúsok';

  @override
  String get emptyPoint => 'Prázdny bod';

  @override
  String get noPoint => 'Nemá to cenu';

  @override
  String get placingPhase => 'Fáza umiestnenia';

  @override
  String get movingPhase => 'Pohyblivá fáza';

  @override
  String get flyingPhase => 'Lietajúca fáza';

  @override
  String sideToMove(Object player) {
    return 'Strana na pohyb: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Posledný ťah: $move';
  }

  @override
  String get selected => 'Vybraný';

  @override
  String get accessibility => 'Prístupnosť';

  @override
  String get screenReaderSupport => 'Podpora čítačky obrazovky';

  @override
  String get isDraw => 'Jedná sa o remízu!';

  @override
  String get draw => 'Nakreslite';

  @override
  String get pieceHighlightColor => 'Farba zvýraznenia kusu';

  @override
  String get algorithm => 'Algoritmus';

  @override
  String get endgameNMoveRule => 'Pravidlo N-Move koncovej hry';

  @override
  String get endgameNMoveRule_Detail =>
      'Ak má jeden z hráčov iba tri figúrky a ani jeden z nich neodstráni figúrku v rámci konkrétnych ťahov, hra sa nerozhodne.';

  @override
  String get drawReasonEndgameRule50 =>
      'Každý hráč má iba tri figúrky a žiadny z hráčov neodstráni figúrku v rámci konkrétnych ťahov.';

  @override
  String get threefoldRepetitionRule => 'Pravidlo trojitého opakovania';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Hra sa žrebuje, ak sa pozícia vyskytne tretíkrát.';

  @override
  String get continueToMakeMove => 'Mlyn! Pokračujte v pohybe.';

  @override
  String get pointStyle => 'Bodový štýl';

  @override
  String get pointWidth => 'Šírka bodu';

  @override
  String get solid => 'Pevný';

  @override
  String get hollow => 'Dutý';

  @override
  String get languageName => 'Slovenčina';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Pohyby',
      one: '$count Pohybujte sa',
      zero: 'Pohybujte sa',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Načítanie zlyhalo.';

  @override
  String get filename => 'Názov súboru';

  @override
  String get browse => 'Prehliadať…';

  @override
  String get gameFiles => 'Herné súbory';

  @override
  String get gameSavedTo => 'Hra sa uloží do';

  @override
  String get empty => 'Prázdny';

  @override
  String get noMove => 'Žiadny pohyb.';

  @override
  String get restoredPosition => 'Obnovená počiatočná poloha.';

  @override
  String get clean => 'Čistý';

  @override
  String get cleanedUp => 'Uprataný.';

  @override
  String get remove => 'Odstrániť';

  @override
  String get noPiecesCanBeRemoved => 'Nedajú sa odstrániť žiadne kusy.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count kusy',
      one: '$count kus',
      zero: 'Piece',
    );
    return '$_temp0 je potrebné odstrániť.';
  }

  @override
  String placedCount(int count) {
    return 'Umiest. ($count)';
  }

  @override
  String get placedPieceCount =>
      'Počet umiestnených kusov vo fáze umiestňovania.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Aktuálny hráč umiestnil $count figúrok.';
  }

  @override
  String get notPlacingPhase => 'Fáza umiestňovania sa nedá zmeniť.';

  @override
  String get paste => 'Prilepiť';

  @override
  String get pasteDone => 'Pasta je hotová.';

  @override
  String get cannotPaste => 'Nedá sa prilepiť.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Zobraziť neumiestnené a odstránené kusy';

  @override
  String get fullScreen => 'Celá obrazovka';

  @override
  String get reopenToTakeEffect =>
      'Ukončite a znova otvorte aplikáciu, aby sa nastavenia prejavili.';

  @override
  String get forest => 'les';

  @override
  String get desktopImage => 'Obrázok pracovnej plochy';

  @override
  String get invalidPosition => 'Neplatná pozícia.';

  @override
  String get shareGIF => 'Zdieľať GIF';

  @override
  String get pixelRatio => 'Pomer pixelov';

  @override
  String get duration => 'Trvanie';

  @override
  String get gameScreenRecorder => 'Záznamník hernej obrazovky';

  @override
  String get previous => 'Predchádzajúce';

  @override
  String get next => 'Ďalšie';

  @override
  String get skip => 'Preskočiť';

  @override
  String get gotIt => 'Mám to';

  @override
  String get youCanModifyRules =>
      'Pravidlá hry môžete upraviť v nastaveniach pravidiel.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Pomocou kolieska myši môžete zmeniť hodnotu vo výbere.';

  @override
  String get noTimeLimitForThinking =>
      'Čas myslenia AI nastavený na 0 znamená, že neexistuje žiadny časový limit na premýšľanie.';

  @override
  String get whatIsMtdf =>
      'MTD(f) je upravená forma vyhľadávacieho algoritmu alfa-beta, ktorého cieľom je zlepšiť efektivitu opätovným použitím medzivýsledkov vyhľadávania a použitím dobrého počiatočného odhadu na zúženie priestoru vyhľadávania.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Upozorňujeme, že úprava času myslenia AI nemusí byť úplne presná. Skutočný čas na premýšľanie môže byť kratší, keď je úroveň obtiažnosti nastavená na nižšiu hodnotu, a môže byť dlhší, keď je AI v strede myslenia, keď vyprší čas.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Ak nastavíte vysokú úroveň obtiažnosti, ale nepredĺžite čas myslenia AI, skutočná úroveň obtiažnosti môže byť obmedzená na nižšiu hodnotu z dôvodu časového obmedzenia. Skutočná hodnota sa môže líšiť v závislosti od výkonu stroja.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) je vyhľadávací algoritmus na nájdenie najlepšieho pohybu na danej pozícii. Ide o vylepšenie alfa-beta algoritmu a využíva vyhľadávanie nulového alebo nulového okna na potvrdenie, že pohyb je horší alebo nie horší ako už bezpečné skóre z hlavnej variácie. PVS sa zameriava na najsľubnejšie ťahy a vyhýba sa zbytočnému prehľadávaniu suboptimálnych vetiev, čo pomáha zlepšiť efektivitu vyhľadávania.';

  @override
  String get whatIsAlphaBeta =>
      'Algoritmus alfa-beta je vyhľadávací algoritmus na nájdenie najlepšieho ťahu. Používa princíp minimax a dve hodnoty, alfa a beta, na orezanie stromu vyhľadávania a zvýšenie efektivity. Alfa predstavuje minimálne skóre, ktoré môže počítač získať, zatiaľ čo beta predstavuje maximálne skóre, ktoré môže získať jeho súper. Algoritmus pomáha počítaču robiť inteligentné a efektívne rozhodnutia v hre.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Podľa ľudských skúseností, ak sa pokúsite vyhrať, prehráte. Namiesto toho sa zamerajte na remízu a vyhnite sa strate hry. Pozorujte svojho súpera a jemne ho nalákajte do pozície, kde môže robiť chyby. Keď ukážu slabosť, chopte sa príležitosti a jemne zatlačte na víťazstvo. Týmto spôsobom môžete vyhrať hru.';

  @override
  String get firstMoveDetail =>
      'V tejto hre je pre druhého hráča jednoduchšie vyhrať v porovnaní s prvým hráčom.';

  @override
  String get passiveDetail =>
      'Povolenie možnosti Passive spôsobí, že AI sa uvoľní, keď má v pozícii výhodu, namiesto toho, aby sa agresívne snažila vyhrať čo najrýchlejšie.';

  @override
  String get moveRandomlyDetail =>
      'Povolenie tejto možnosti zvyšuje náhodnosť a zábavu hry, zatiaľ čo jej zakázanie môže pomôcť pri štúdiu spôsobov, ako poraziť AI.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Ak AI zváži mobilitu svojich figúrok, nezameria sa len na to, aby čo najrýchlejšie zajali súperove figúrky, ale zváži aj blokovanie súperových pohybov a zabránenie im v tom, aby urobili to isté.';

  @override
  String get whenBoardIsFull => 'Keď je tabuľa plná';

  @override
  String get whenBoardIsFull_Detail =>
      'Na konci fázy umiestňovania, pred začiatkom fázy pohybu, nasleduje akcia, ak je hracia plocha plná figúrok.';

  @override
  String get sideToMoveRemovePiece =>
      'Hráč, ktorý sa vo fáze pohybu pohne ako prvý, odstráni jednu zo súperových figúrok.';

  @override
  String get agreeToDraw => 'Obe strany súhlasia s remízou.';

  @override
  String get takeOpponentsPiece => 'Vezmite jednu zo súperových figúrok.';

  @override
  String get firstPlayerLose => 'Prvý hráč prehráva hru.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Prvý a druhý hráč odstráni jednu zo súperových figúrok.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Druhý a prvý hráč odstráni jednu zo súperových figúrok.';

  @override
  String get enteredFlyingPhase =>
      'Teraz vstúpil do fázy lietania, súperove figúrky môžu skákať na ľubovoľný prázdny bod na šachovnici. Pravidlo lietania môžete vypnúť v časti „Nastavenia pravidiel“.';

  @override
  String get whenStalemate => 'Pri patovej situácii';

  @override
  String get whenStalemate_Detail =>
      'Aká akcia nasleduje, keď nie je možné pohnúť žiadnou figúrkou?';

  @override
  String get endWithStalemateLoss => 'Koniec patovou prehrou.';

  @override
  String get changeSideToMove => 'Zmeňte stranu na pohyb.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Odstráňte jednu zo súperových figúrok a urobte ďalší ťah.';

  @override
  String get endWithStalemateDraw => 'Koniec nerozhodným výsledkom.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Odstráňte jednu zo súperových figúrok a zmeňte stranu na pohyb.';

  @override
  String get aiResponseDelayTime => 'Čas oneskorenia odozvy AI';

  @override
  String get aiIsDelaying =>
      'AI je momentálne vo fáze oneskorenej odozvy. Pred pokračovaním chvíľu počkajte.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Nesusediaci kus nemôžete odstrániť.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Ak ste v patovej situácii, súperove figúrky susediace s vašimi môžu byť odstránené bez ohľadu na formáciu mlyna.';

  @override
  String get whatIsMcts =>
      'MCTS je algoritmus vhodný pre začiatočníkov, ktorý robí rozhodnutia skúmaním a vyhodnocovaním rôznych pohybov prostredníctvom simulácií.';

  @override
  String get goldenJade => 'Zlatý jadeit';

  @override
  String get forestWood => 'Lesné drevo';

  @override
  String get darkMystery => 'Temná záhada';

  @override
  String get midnightBlue => 'Polnočná modrá';

  @override
  String get greenForest => 'Zelený les';

  @override
  String get greenMeadow => 'Zelená lúka';

  @override
  String get stonyPath => 'Kamenistá cesta';

  @override
  String get pastelPink => 'Pastelovo ružová';

  @override
  String get turquoiseSea => 'Tyrkysové more';

  @override
  String get violetDream => 'Fialový sen';

  @override
  String get mintChocolate => 'Mätová čokoláda';

  @override
  String get skyBlue => 'Modrá obloha';

  @override
  String get playfulGarden => 'Hravá záhrada';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Algoritmus retrográdnej analýzy využíva retrográdnu analýzu s viacerými hodnotami na zostavenie databázy konca hry z rôznych počiatočných pozícií a potom túto databázu použije na optimalizáciu hry. Tento prístup patrí do kategórie ultrasilných riešení.';

  @override
  String get viewAlgorithmGuide =>
      'Chcete si pozrieť používateľskú príručku pre tento algoritmus?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Zobraziť indikátor pozičnej výhody';

  @override
  String get usePerfectDatabase => 'Použite perfektnú databázu';

  @override
  String get perfectDatabaseDescription =>
      'Povoľte túto možnosť, ak chcete používať bezchybnú databázu hier vygenerovanú pomocou špičkových algoritmov. Táto funkcia integruje stratégie otvárania a konca hry, aby navrhla optimálne ťahy. Toto je preferovaná voľba pre hráčov, ktorí hľadajú najvyššiu úroveň presnosti v hre. Databáza vytvorená pomocou precíznych výpočtových techník je navrhnutá tak, aby ponúkala takmer dokonalé herné riešenia.\n\nPoznámka: Ak sa AI nepodarí získať prístup k databáze, pri rozhodovaní o hre sa obráti na konvenčné algoritmy. Keď je databáza dostupná, „úroveň obtiažnosti“ sa stáva prakticky neprekonateľnou a „doba myslenia AI“ zažije drastické zníženie. Mnohé nastavenia v rámci možností „AI\'s play style“ budú prepísané, pretože výsledky databázy majú najvyššiu prioritu.\n\nPre návod, ako čo najlepšie využiť túto bezchybnú databázu, kliknite sem.';

  @override
  String get backgroundImage => 'Pozadie obrazu';

  @override
  String get whatIsRandom =>
      'Keď nie je povolená možnosť „Použiť dokonalú databázu“, nastavenie „Náhodné“ spôsobí, že AI bude pohybovať figúrkami náhodne bez použitia akýchkoľvek algoritmov na výber pohybu. To zvyčajne vedie k výrazne slabšej hrateľnosti. Naopak, keď je povolená možnosť „Použiť perfektnú databázu“, AI sa pri rozhodovaní spolieha výlučne na „Perfektnú databázu“ namiesto toho, aby ju spájala s tradičnými algoritmami AI. V tomto režime sú pohyby AI úplne založené na obsahu databázy, čím sa vyhýbajú spoliehaniu sa na výpočty v reálnom čase alebo vyhľadávacie algoritmy.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Odstráňte súperove figúrky z ruky; potom je na ťahu súperper, aby figúrku umiestnil.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Pri vytvávaní mlynov počas fázy rozmiestňovania';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Odstráňte súperove figúrky z hracej plochy.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Odstráňte súperove figúrky z hracej plochy; potom je na ťahu súper, aby figúrku umiestnil.';

  @override
  String get opponentRemovesOwnPiece =>
      'Súper si odstráni svoje vlastné figúrky z hracej plochy.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Namiesto toho, aby ste konali vy, si súper vyberie a odstráni svoje vlastné figúrky z hracej plochy, čím účinne vykoná akciu, ktorá je pre neho škodlivá.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Odstráňte súperove figúrky z jeho ruky; potom ste na ťahu vy.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Odstráňte figúrky z ruky súpera. Ak je v súlade s nastavením viacnásobného odstránenia potrebné odstrániť viacero figúrok a súper nezostali v ruke žiadne figúrky, pokračujte v odstraňovaní súperových figúrok z hracej plochy. Potom ste na rade vy. Ak budete pokrač vytvá mills, môžete pokračovať v odstraňovaní súperových figúrok.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Odstráňte figúrky z ruky súpera. Ak je v súlade s nastavením viacnásobného odstránenia potrebné odstrániť viacero figúrok a súper nezostali v ruke žiadne figúrky, pokračujte v odstraňovaní súperových figúrok z hracej plochy. Potom je súper na ťahu.';

  @override
  String get markAndDelayRemovingPieces =>
      'Označte a odložte odstraňovanie figúrok.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Počas fázy rozmiestňovania sú figúrky, ktoré sa majú odstrániť, označené a ani jeden hráč nemôže na tieto body umiestňovať nové figúrky. Po vstupe do fázy ťahu sa tieto označené figúrky úplne odstránia a hráči potom môžu presunúť svoje figúrky na tieto teraz prázdne body.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Akcie, ktoré možno vykonať pri tvorbe mlynov počas fázy umiestňovania.';

  @override
  String get marked => 'Označené';

  @override
  String get menu => 'Ponuka';

  @override
  String get monochrome => 'Monochromatický';

  @override
  String get youCanEnableScreenReaderSupport =>
      'V časti Všeobecné nastavenia v nastaveniach Prístupnosť môžete zapnúť podporu čítačky obrazovky.';

  @override
  String get showNumbersOnPieces => 'Zobraziť čísla na figúrkach';

  @override
  String get saveImage => 'Uložiť obrázok';

  @override
  String get isAnalysisToolbarShown => 'Zobraziť panel nástrojov analýzy';

  @override
  String get analysisToolbarBackgroundColor =>
      'Farba pozadia panela nástrojov analýzy';

  @override
  String get analysisToolbarIconColor => 'Farba ikony panela nástrojov analýzy';

  @override
  String get transformed => 'Transformované.';

  @override
  String get cannotTransform => 'Nedá sa transformovať.';

  @override
  String get rotate => 'Rotovať';

  @override
  String get horizontalFlip => 'H. prev.';

  @override
  String get verticalFlip => 'V. prev.';

  @override
  String get innerOuterFlip => 'Prev. V/V';

  @override
  String get transparentCanvas => 'Priehľadné Plátno';

  @override
  String get restrictRepeatedMillsFormation =>
      'Obmedziť opakované formovanie mlynov';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Figúrka presunutá z jedného mlyna do druhého nemôže okamžite vrátiť na pôvodný bod v ďalšom ťahu, aby znova vytvorila mlyn. Najprv je potrebný iný ťah.';

  @override
  String get oneTimeUseMill => 'Jednorazové použitie mlyna';

  @override
  String get oneTimeUseMill_Detail =>
      'Každý mlyn môže odstrániť iba jednu časť súpera. Môžete ho znovu reformovať, ale nemôže byť použitý na ďalšie odstránenia.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Aktuálne pravidlá, ktoré ste nastavili, nemajú zodpovedajúcu dokonalú databázu. Pre viac informácií o dokonalej databáze kliknite sem.';

  @override
  String get focusOnBlockingPaths => 'Zamerajte sa na blokovanie ciest';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Uprednostnite blokovanie pohybu súpera pred tvorbou mlynov. Namiesto zamerania sa na odstraňovanie figúr dokončovaním mlynov sa AI snaží chytiť súpera do pasce, znemožniť mu pohyb a zabezpečiť víťazstvo prostredníctvom opotrebenia, nie agresívnej hry. Táto stratégia aktívne neblokuje mlyny súpera.';

  @override
  String get pieceImage => 'Obraz figúry';

  @override
  String get importColorSettings => 'Importovať nastavenia farieb';

  @override
  String get exportColorSettings => 'Exportovať nastavenia farieb';

  @override
  String get import => 'Importovať';

  @override
  String get export => 'Exportovať';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Najprv skopírujte nastavenia formátu JSON do schránky.';

  @override
  String get copiedToClipboard => 'Skopírované do schránky.';

  @override
  String get imported => 'Importované.';

  @override
  String get boardImage => 'Obrázok dosky';

  @override
  String get autumnLeaves => 'Jesenné lístie';

  @override
  String get legendaryLand => 'Legendárna Krajina';

  @override
  String get vignetteEffect => 'Efekt vinety';

  @override
  String get promptMakeToolbarTransparent =>
      'Chcete, aby bola panel nástrojov úplne priehľadná, keď je nastavený obrázok pozadia dosky?';

  @override
  String get vibration => 'Povoliť vibrácie v hre';

  @override
  String get soundTheme => 'Zvukové téma';

  @override
  String get ball => 'Lopta';

  @override
  String get liquid => 'Tekutina';

  @override
  String get wood => 'Drevo';

  @override
  String get placeEffectAnimation => 'Animovaný efekt pri umiestnení figúrky';

  @override
  String get removeEffectAnimation => 'Animovaný efekt pri odstránení figúrky';

  @override
  String get isToolbarAtBottom => 'Zobraziť panel nástrojov dole';

  @override
  String get boardCornerRadius => 'Polomer rohu dosky';

  @override
  String get useOpeningBook => 'Použite otváraciu knihu';

  @override
  String get currentRule => 'Aktuálny';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Čhamgonu';

  @override
  String get zhiQi => 'Č’-čchi';

  @override
  String get chengSanQi => 'Čcheng-san-čchi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenči';

  @override
  String get ruleSet => 'Sada pravidiel';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'Jednorazový Mlyn';

  @override
  String get daSanQi => 'Ta-san-čchi';

  @override
  String get useOpeningBook_Detail =>
      'Dovoľte AI používať otváracie ťahy, ktoré sú bežne používané profesionálnymi ľudskými hráčmi na začiatku hry. Poznámka: Táto funkcia je momentálne dostupná len pre špecifické sady pravidiel.';

  @override
  String get showAdvantageGraph => 'Zobraziť graf výhody';

  @override
  String get advantageGraphHint =>
      'Graf výhody sa nakreslí až po tom, ako urobí ťah AI. Nebude sa kresliť, keď ťah urobí ľudský hráč.';

  @override
  String get removalBasedOnMillCounts =>
      'Zakážte odstránenie, kým nebudú všetky kamene umiestnené. Hráči odstraňujú kamene na základe počtu mlynov.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Zakážte odstránenie, kým nebudú všetky kamene umiestnené. Hráči odstraňujú kamene na základe počtu mlynov: ak je počet rovnaký, obaja odstránia rovnaký počet kameňov; ak jeden má viac, odstráni o jeden kameň viac, čím udržiava rozdiel jedného kameňa. Ak mlyn vytvorí len jeden hráč, odstráni dva kamene a druhý jeden. Ak mlyn nevytvorí ani jeden, obaja odstránia po jednom kameni.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Vyberte si jednu zo svojich figúrok.';

  @override
  String get notYourTurn => 'Nie si na ťahu.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Farba pozadia panela s anotáciami';

  @override
  String get annotationToolbarIconColor => 'Farba ikon panela s anotáciami';

  @override
  String get isAnnotationToolbarShown => 'Zobraziť panel s anotáciami';

  @override
  String get enterAnnotationMode => 'Vstúpiť do režimu anotácie';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Ste si istí, že chcete vymazať všetky anotácie?';

  @override
  String get llmPromptCopiedToClipboard => 'LLM výzva skopírovaná do schránky.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Pripojenie odmietnuté, server môže byť nefunkčný.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Vyhľadávanie bolo úspešné, čaká sa na pripojenie...';

  @override
  String get noLanConnection => 'Žiadne LAN pripojenie';

  @override
  String get takeScreenshot => 'Urobiť snímku obrazovky';

  @override
  String get disconnectedFromOpponent => 'Odpojené od súpera.';

  @override
  String get takeBackRequest => 'Žiadosť o vrátenie ťahu';

  @override
  String get nothingToShow => 'Nič na zobrazenie.';

  @override
  String get stopHosting => 'Zastaviť hosťovanie';

  @override
  String get connectionResetByPeer => 'Pripojenie bolo zrušené partnerom.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Pripojenie bolo stratené z dôvodu vypršania časového limitu heartbeat. Prosím, pripojte sa znova.';

  @override
  String get startHosting => 'Spustiť hosťovanie';

  @override
  String get restartRequestRejected => 'Žiadosť o reštart zamietnutá.';

  @override
  String get notConnectedToLanOpponent => 'Nie je pripojené k súperovi v LAN.';

  @override
  String get llmPrompt => 'LLM výzva';

  @override
  String get gameRestarted => 'Hra bola reštartovaná.';

  @override
  String get takeBackRejected => 'Žiadosť o vrátenie ťahu zamietnutá.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Ste si istí, že chcete vzdať túto hru?';

  @override
  String get opponentResignedYouWin => 'Súper to vzdal. Vyhrali ste!';

  @override
  String get clearAllAnnotations => 'Vymazať všetky anotácie';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Pripojené, čaká sa na ťah súpera...';

  @override
  String get networkStatusDisconnected => 'Stav siete: Odpojené';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Žiadosť o vrátenie ťahu bola odoslaná súperovi.';

  @override
  String get theOpponentMayHaveLeftTheGame => 'Súper mohol opustiť hru';

  @override
  String get connectedToHostSuccessfully =>
      'Pripojenie k hostiteľovi bolo úspešné.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Pripojenie stratené: vypršal čas heartbeat';

  @override
  String get noHostDiscovered => 'Žiadny hostiteľ nebol nájdený.';

  @override
  String get confirmResignation => 'Potvrdiť vzdanie sa';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Začalo sa hosťovanie hry, čaká sa na pripojenie hráčov...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Vypršal čas pripojenia, nestabilné sieťové pripojenie.';

  @override
  String get noLlmPromptAvailable => 'Žiadna LLM výzva nie je k dispozícii.';

  @override
  String get youResignedGameOver => 'Vzdali ste sa. Hra skončila.';

  @override
  String get serverIp => 'IP servera';

  @override
  String get confirmClear => 'Potvrdiť vymazanie';

  @override
  String get opponentSTurn => 'Ťah súpera.';

  @override
  String get waitingAClientConnection => 'Čaká sa na pripojenie klienta...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Žiadosť o vrátenie ťahu bola zamietnutá alebo zlyhala.';

  @override
  String get addText => 'Pridať text';

  @override
  String get exitAnnotationMode => 'Ukončiť režim anotácie';

  @override
  String get typeYourAnnotation => 'Napíšte svoju anotáciu';

  @override
  String get attemptingToReconnect => 'Pokúšame sa o opätovné pripojenie...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Žiadosť o reštart bola odoslaná. Čaká sa na odpoveď súpera...';

  @override
  String get serverIsStopped => 'Server je zastavený.';

  @override
  String get restartRequest => 'Žiadosť o reštart';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Nemôžete požiadať o vrátenie ťahu, keď nie ste na ťahu.';

  @override
  String get takeBackAccepted => 'Vrátenie ťahu bolo akceptované.';

  @override
  String get localNetworkSettings => 'Nastavenia lokálnej siete';

  @override
  String get reconnectedSuccessfully => 'Opätovné pripojenie bolo úspešné!';

  @override
  String get failedToSaveImageToGallery =>
      'Nepodarilo sa uložiť obrázok do galérie.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Súper požiadal o reštart hry. Súhlasíte?';

  @override
  String get yourTurn => 'Si na ťahu.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Nie je možné opätovne sa pripojiť, prosím reštartujte hru.';

  @override
  String get host => 'Hostiteľ';

  @override
  String get join => 'Pripojiť sa';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'Neplatná IP adresa.';

  @override
  String get invalidPort => 'Neplatný port.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Pripájame sa: pokus $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Nepodarilo sa pripojiť: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Nepodarilo sa spustiť hosťovanie: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Nájdený hostiteľ: $ip:$port';
  }

  @override
  String get stop => 'Zastaviť';

  @override
  String get discover => 'Vyhľadať';

  @override
  String get connect => 'Pripojiť';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Klient pripojený: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Vyhľadávanie: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Opätovné pripojenie ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Pripojené';

  @override
  String get delete => 'Odstrániť';

  @override
  String get ancientEgypt => 'Staroveký Egypt';

  @override
  String get gothicIce => 'Gotický Ľad';

  @override
  String get riceField => 'Ryžové Pole';

  @override
  String get chinesePorcelain => 'Čínsky Porcelán';

  @override
  String get desertDusk => 'Púštny Súmrak';

  @override
  String get precisionCraft => 'Precízne Remeslo';

  @override
  String get folkEmbroidery => 'Ľudová Výšivka';

  @override
  String get carpathianHeritage => 'Karpatské Dedičstvo';

  @override
  String get imperialGrandeur => 'Cisárska Nádhera';

  @override
  String get bohemianCrystal => 'Český Krištáľ';

  @override
  String get savannaSunrise => 'Savanský Východ Slnka';

  @override
  String get harmonyBalance => 'Harmónia a Rovnováha';

  @override
  String get cinnamonSpice => 'Škoricové Korenie';

  @override
  String get anatolianMosaic => 'Anatolská Mozaika';

  @override
  String get carnivalSpirit => 'Karnevalový Duch';

  @override
  String get custom => 'Zvykom';

  @override
  String get spiceMarket => 'Trh s koreninami';

  @override
  String get swipeToRevealTheDrawer => 'Potiahnutím zobrazíte zásuvku';

  @override
  String get showGameInfoOnScreenshots =>
      'Zobraziť informácie o hre na snímkach obrazovky';

  @override
  String get humanMoveTime => 'Časový limit pre človeka';

  @override
  String get noTimeLimitForHumanMoves => 'Žiadny časový limit pre ľudské ťahy';

  @override
  String get timeoutLoseWillBeApplied =>
      'Pre ľudského hráča bude uplatnená prehra z časového limitu';

  @override
  String get identifyingBoard => 'Identifikácia hernej dosky...';

  @override
  String get youCanEnterAnyModelName => 'Môžete zadať ľubovoľný názov modelu.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Pozícia na doske bola použitá. FEN bol skopírovaný do schránky.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Odporúčanie: skúste urobiť jasnejšiu fotografiu hernej dosky.';

  @override
  String get llmPromptTemplate => 'Šablóna výzvy LLM';

  @override
  String get noValidBoardDetected => 'Nenašla sa žiadna platná herná doska.';

  @override
  String get selectingImageFromAlbum => 'Výber obrázka z albumu...';

  @override
  String get configurePromptTemplate => 'Nastaviť šablónu výzvy';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Upraviť šablónu výzvy pre analýzu LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Nepodarilo sa vygenerovať FEN z rozpoznanej dosky.';

  @override
  String get outputInCurrentLanguage => 'Výstup v aktuálnom jazyku';

  @override
  String get commonBaseUrls => 'Bežne používané Base URL';

  @override
  String get viewCommonModels => 'Zobraziť bežné modely';

  @override
  String get recognitionParametersUpdated =>
      'Parametre rozpoznávania boli aktualizované.';

  @override
  String get whiteSMove => 'Ťah bielych';

  @override
  String get resetToDefaults => 'Obnoviť predvolené nastavenia';

  @override
  String get photoShoot => 'Fotografovanie';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Nepodarilo sa použiť rozpoznanú pozíciu na doske.';

  @override
  String get llmPromptContent => 'Obsah výzvy LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM nie je nakonfigurované. Skontrolujte nastavenia.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Nastaviť poskytovateľa, model, API Key a Base URL';

  @override
  String get llmConfiguration => 'Konfigurácia LLM';

  @override
  String get configureLlmProvider => 'Nastaviť poskytovateľa LLM';

  @override
  String get llmPromptTemplateHeader => 'Záhlavie šablóny výzvy LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Na obrázku neboli rozpoznané žiadne figúrky. Skúste to znova.';

  @override
  String get recognizeBoardFromImage => 'Rozpoznať dosku z obrázka';

  @override
  String get viewTips => 'Zobraziť tipy';

  @override
  String get applyToBoard => 'Použiť na dosku';

  @override
  String get adjustBoardArea => 'Upraviť oblasť dosky';

  @override
  String get viewCommonUrls => 'Zobraziť bežné URL';

  @override
  String get colorAnalysisFailed => 'Analýza farieb zlyhala!';

  @override
  String get analyzingGameBoardImage => 'Analyzujem obrázok hernej dosky...';

  @override
  String get selectFromAlbum => 'Vybrať z albumu';

  @override
  String get noBoardPointDetected => 'Nebolo zistené žiadne pole na doske!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Ak zostane prázdne, bude použitá predvolená šablóna';

  @override
  String get llmConfig => 'Konfigurácia LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Naozaj chcete obnoviť šablóny výziev na predvolené hodnoty?';

  @override
  String get llmPromptTemplateFooter => 'Pätička šablóny výzvy LLM';

  @override
  String get loadingResponse => 'Načítavam odpoveď...';

  @override
  String get applyThisResultToBoard => 'Použiť tento výsledok na dosku';

  @override
  String get takingPicture => 'Fotím...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Prosím, vyberte obrázok hernej dosky na rozpoznanie.';

  @override
  String get identificationResults => 'Výsledky identifikácie';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analyzujte ťahy a poskytnite postrehy.';

  @override
  String get getApiKey => 'Získať API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Nepodarilo sa dokončiť celý proces rozpoznávania.';

  @override
  String get boardRecognitionResult => 'Výsledok rozpoznávania dosky';

  @override
  String get askLlm => 'Opýtať sa LLM';

  @override
  String get boardDetectionFailed => 'Detekcia dosky zlyhala!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Nebolo zistené žiadne pole na doske, nemožno identifikovať figúrku!';

  @override
  String get copyFen => 'Kopírovať FEN';

  @override
  String get commonlyUsedModels => 'Často používané modely';

  @override
  String get apiKeyOptional => 'API Key (voliteľné)';

  @override
  String get noImageSelected => 'Nie je vybraný žiadny obrázok.';

  @override
  String get blackSMove => 'Ťah čiernych';

  @override
  String get llm => 'Veľký jazykový model';

  @override
  String get llmProvider => 'Poskytovateľ';

  @override
  String get baseUrl => 'Základná URL';

  @override
  String get model => 'Model';

  @override
  String get temperature => 'Teplota';

  @override
  String get llmCommandReceivedProcessing => 'Príkaz prijatý! AI spracúva...';

  @override
  String get llmDeepThinkingWait =>
      'Prebieha hlboké rozmýšľanie, prosím čakajte...';

  @override
  String get llmPresentingSoon => 'Onedlho bude prezentované...';

  @override
  String get recognitionParameters => 'Parametre rozpoznávania';

  @override
  String get adjustParamsDesc =>
      'Upravte parametre na zlepšenie presnosti rozpoznávania';

  @override
  String get saveParameters => 'Uložiť parametre';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Nemožno spustiť rozpoznávanie obrazu: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Rozpoznávanie obrazu zlyhalo: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Aplikovaná pozícia s $whiteCount bielymi a $blackCount čiernymi kameňmi';
  }

  @override
  String get fenCopiedToClipboard => '(FEN skopírovaný do schránky)';

  @override
  String recognitionFailed(String error) {
    return 'Rozpoznávanie zlyhalo: $error';
  }

  @override
  String get myRating => 'Moje hodnotenie';

  @override
  String get gamesPlayed => 'Odohrané hry';

  @override
  String get wins => 'Výhry';

  @override
  String get losses => 'Prehry';

  @override
  String get draws => 'Remízy';

  @override
  String get lastUpdated => 'Posledná aktualizácia';

  @override
  String get format => 'Formát:';

  @override
  String get resetStatistics => 'Resetovať štatistiky';

  @override
  String get drawRate => 'Miera remíz';

  @override
  String get lossRate => 'Miera prehier';

  @override
  String get aiStatistics => 'Štatistiky UI';

  @override
  String get enableStatistics => 'Povoliť štatistiky';

  @override
  String get enableStatistics_Detail =>
      'Ak je povolené, výsledky hier sa budú zaznamenávať do štatistík. Hry zahŕňajúce vrátenie ťahu sa však nebudú zaznamenávať. Ak je zakázané, zhromažďovanie štatistík je pozastavené.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Týmto sa resetujú všetky herné štatistiky. Túto akciu nie je možné vrátiť späť.';

  @override
  String get boardInnerRingSize => 'Veľkosť vnútorného prstenca dosky';

  @override
  String get boardShadowEnabled => 'Tieň dosky';

  @override
  String get trapAwareness => 'Detekcia pascí';

  @override
  String get trapAwarenessDescription =>
      'Zvýrazňuj ťahy-pasce hrubými kruhmi a šípkami počas analýzy.';

  @override
  String trapExists(String trapMoves) {
    return 'Existuje pasca. Ťahy-pasce: $trapMoves';
  }

  @override
  String get custodianCapture => 'Zachytenie';

  @override
  String get custodianCaptureDescription =>
      'Priložte jeden z kusov súpera medzi dve vaše v priamke, aby ste ho zachytili.';

  @override
  String get custodianCaptureEnable => 'Povoliť zachytenie';

  @override
  String get interventionCapture => 'Zachytenie zásahu';

  @override
  String get interventionCaptureDescription =>
      'Prejdite do prázdneho bodu medzi dvoma kúskami súpera, aby ste ich zachytili.';

  @override
  String get interventionCaptureEnable => 'Povoliť zachytenie zásahu';

  @override
  String get leapCapture => 'Zachytenie';

  @override
  String get leapCaptureDescription =>
      'Zachyťte skokom cez susedného súpera do prázdneho bodu ďalej.';

  @override
  String get leapCaptureEnable => 'Povoliť zachytenie skoku';

  @override
  String get captureApplicableLines => 'Uplatniteľné riadky';

  @override
  String get captureSquareEdges => 'Pozdĺž hrán štvorcových';

  @override
  String get captureCrossLines =>
      'Pozdĺž ortogonálnych línií prechádzajúcich na štvorec';

  @override
  String get captureDiagonalLines =>
      'Pozdĺž diagonálnych čiar prechádzajúcich cez štvorec';

  @override
  String get captureExecutionPhases => 'Fáza vykonávania';

  @override
  String get capturePiecesCondition =>
      'Dostupnosť počas pohyblivej fázy na základe zvyšných kusov';

  @override
  String get capturePiecesConditionUnlimited => 'Žiadne obmedzenie';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'K dispozícii, keď máte tri alebo menej kusov';
}
