// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Sinhala Sinhalese (`si`).
class SSi extends S {
  SSi([String locale = 'si']) : super(locale);

  @override
  String get appName => 'නෙරෙන්චි';

  @override
  String get welcome => 'ආයුබෝවන්';

  @override
  String get yes => 'ඔව්';

  @override
  String get no => 'නැත';

  @override
  String get game => 'ක්‍රීඩාව';

  @override
  String get humanVsAi => 'මමිනිස් විරුද්ධ AI';

  @override
  String get humanVsHuman => 'මිනිස්සු එරෙහිව මිනිස්සු';

  @override
  String get aiVsAi => 'AI විරුද්ධ AI';

  @override
  String get humanVsCloud => 'මිනිස්සු එරෙහිව ක්ලවුඩ්';

  @override
  String get humanVsLAN => 'මිනිස්සු එරෙහිව LAN';

  @override
  String get testViaLAN => 'LAN හරහා පරීක්ෂණය';

  @override
  String get move => 'චලනය';

  @override
  String get showMoveList => 'චලන ලැයිස්තුව';

  @override
  String get moveList => 'චලන ලැයිස්තුව';

  @override
  String get noGameRecord => 'වාර්තාවක් නැත';

  @override
  String get ok => 'හරි';

  @override
  String get confirm => 'ස්ථීර කරන්න';

  @override
  String get cancel => 'අවලංගු';

  @override
  String get tipSelectWrong => 'වැරදි කෑල්ල තෝරන්න.';

  @override
  String get tipPlace => 'ඔබේ කැබලි තැබීම.';

  @override
  String get tipBanPlace => 'ඔබට මෙහි තැබීමට නොහැක.';

  @override
  String get tipPlaced => 'ඔබ තැබුවා.';

  @override
  String get tipRemove => 'කෑල්ලක් ඉවත් කරන්න.';

  @override
  String get tipBanRemove => 'ඔබට එය ඉවත් කළ නොහැක.';

  @override
  String get tipRemoved => 'ඔබ ඉවත් කළා.';

  @override
  String get tipMove => 'කෑල්ලක් චලනය කරන්න.';

  @override
  String get tipCannotPlace => 'ඔබට මෙහි ඔබේ කෑල්ල තැබීමට නොහැක.';

  @override
  String get tipCannotMove => 'ඔබට මෙහි ඔබේ කෑල්ල චලනය කළ නොහැක.';

  @override
  String get tipMill => 'මිල්! ඔබේ ප්‍රතිඵලයේ කෑල්ල ගන්න.';

  @override
  String get tipContinueMill => 'ඔබේ ප්‍රතිඵලයේ කෑල්ල ගැනීම ඉදිරියටත් කරන්න.';

  @override
  String get tipSelectOpponentsPiece => 'ඔබේ ප්‍රතිඵලයේ කෑල්ලක් තෝරන්න.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'ඔබට ගල්ලෙන් කැටයමක් ඉවත් කළ නොහැක.';

  @override
  String get tipCanMoveOnePoint => 'කැටයමක් කඩයක් හරවා ගත හැක.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'ඔබට ප්‍රතියෝගීන්ගේ කැටයම් හරවා ගත නොහැක.';

  @override
  String get tipSelectPieceToMove => 'ඔබගේ කැටයම තෝරා ගන්න.';

  @override
  String get tipHaveThreePiecesLeft => 'ඔබට කැටයම් තුනක් තිබේ.';

  @override
  String get tipCanMoveToAnyPoint => 'ඔබට කැමති ඕනෑම කඩයකට ගලවා ගත හැක.';

  @override
  String tipToMove(Object player) {
    return '$player හරවා ගන්න.';
  }

  @override
  String get whiteWin => 'ක්‍රීඩක 1 ජය ගනී!';

  @override
  String get blackWin => 'ක්‍රීඩක 2 ජය ගනී!';

  @override
  String get won => 'ජයගත්තා';

  @override
  String get lost => 'පරාජය විය';

  @override
  String get thinking => 'සිතීම…';

  @override
  String get newGame => 'නව ක්‍රීඩාව';

  @override
  String get importGame => 'ක්‍රීඩාව ආයාත කරන්න';

  @override
  String get exportGame => 'ක්‍රීඩාව අපනයනය කරන්න';

  @override
  String get gameImported => 'ක්‍රීඩාව ආනයනය කරන ලදී.';

  @override
  String cannotImport(Object invalidMove) {
    return '$invalidMove ආයාත කළ නොහැක';
  }

  @override
  String get movesAndRulesNotMatch => 'චලන සහ නීති ගැලපෙන්නේ නැත.';

  @override
  String get pleaseWait => 'කරුණාකර ඉන්න.';

  @override
  String get restartGame => 'වත්මන් ක්‍රීඩාව නැවත ආරම්භ කරනවාද?';

  @override
  String get restart => 'නැවත ආරම්භ කරන්න';

  @override
  String get gameStarted => 'ක්‍රීඩාව අරඹා ඇත, කරුණාකර තැන් පිටත් කරන්න.';

  @override
  String get analyzing => 'විශ්ලේෂණය කරමින්…';

  @override
  String error(Object message) {
    return 'දෝෂයකි: $message';
  }

  @override
  String get winRate => 'ජයග්‍රහණ අනුපාතය';

  @override
  String get score => 'ලකුණු:';

  @override
  String get white => 'ක්‍රීඩක 1';

  @override
  String get black => 'ක්‍රීඩක 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player ගේ කැස් සංඛ්‍යාව තුන්කට අඩුය.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player ඉල්ලා අස් විය.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player යාමට ක්‍රමයක් නැත.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'පුවරුව පිරී ඇත, සහ $player යාමට ක්‍රමයක් නැත.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'කාලය අවසන්, $player පරාජය විය.';
  }

  @override
  String get drawReasonRule50 =>
      'චලන අවධියේදී, අවසාන විශේෂිත චලන සංඛ්‍යාවේදී කැස් ඉවත් කර නැත.';

  @override
  String get drawReasonBoardIsFull => 'පුවරුව පිරී ඇති නිසා එය මුලික වේ.';

  @override
  String get drawReasonThreefoldRepetition =>
      'ත්‍රිත්ව නැවතුම් නිසා එය මුලික වේ.';

  @override
  String get gameOverUnknownReason => 'ක්‍රීඩාව අවසන්! නොදන්නා හේතුවක්.';

  @override
  String get gameOver => 'ක්‍රීඩාව අවසන්';

  @override
  String get youWin => 'ඔබ ජයගත්තා! සුබ පැතුම්!';

  @override
  String challengeHarderLevel(int level) {
    return 'දුෂ්කර මට්ටමකට අභියෝග කිරීමටද? නව මට්ටම මට්ටම $level වේවි!';
  }

  @override
  String get youLose => 'ඔබ පරාජය විය!';

  @override
  String get analyze => 'විශ්ලේෂණය කරන්න';

  @override
  String get about => 'ගැන';

  @override
  String version(Object versionNumber) {
    return 'අනුවාදය: $versionNumber';
  }

  @override
  String get thanks => 'ස්තුතියි';

  @override
  String get settings => 'සැකසුම්';

  @override
  String get options => 'විකල්ප';

  @override
  String get generalSettings => 'පොදු සැකසුම්';

  @override
  String get skillLevel => 'අභියෝගාත්මක මට්ටම';

  @override
  String get moveTime => 'AI සිතීමේ කාලය';

  @override
  String get difficulty => 'අභියෝගතාව';

  @override
  String get playSounds => 'ශබ්ද ප්‍රතිඵල';

  @override
  String get playSoundsInTheGame => 'ක්‍රීඩාවේ දී ශබ්ද වාදනය කරන්න';

  @override
  String get keepMuteWhenTakingBack => 'නැවත ගත් විට නිහඬ කර තබන්න';

  @override
  String get tone => 'ස්වරය';

  @override
  String get whoMovesFirst => 'පළමු චලනය';

  @override
  String get human => 'මානව';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'විකල්පනය';

  @override
  String get isAutoRestart => 'ක්‍රීඩාව අවසන් වූ විට ස්වයංක්‍රීයව නැවත අරඹන්න';

  @override
  String get isAutoChangeFirstMove => 'ස්වයංක්‍රීයව පළමු චලනය වෙනස් කරන්න';

  @override
  String get shufflingEnabled => 'හසුරවන්න';

  @override
  String get misc => 'විවිධ';

  @override
  String get rules => 'නීති';

  @override
  String get piecesCount => 'එක් එක් ක්‍රීඩකයාට ඇති කැස් සංඛ්‍යාව';

  @override
  String get piecesCount_Detail => 'එක් එක් ක්‍රීඩකයාට කැස් කීයක් ඇත්ද?';

  @override
  String get flyPieceCount => 'පියාසර කැස් සංඛ්‍යාව';

  @override
  String get flyPieceCount_Detail =>
      'පියාසර කිරීම සක්‍රීය වූ විට, ක්‍රීඩකයාගේ කැස් සංඛ්‍යාවකට අඩු වූ විට, ඇයගේ කැස් ක්‍රීඩාවේ අනෙකුත් කොටස්වලදී ආසන්න ලක්‍ෂ්‍යයන්ට සීමා කර නොගෙන ඕනෑම අනාරක්‍ෂිත ලක්‍ෂ්‍යයකට චලනය කළ හැකිය.';

  @override
  String get piecesAtLeastCount => 'කැස් අවම';

  @override
  String get hasDiagonalLines => 'වක්‍ර රේඛා';

  @override
  String get hasDiagonalLines_Detail => 'පුවරුවට සමාන්තර රේඛා හතරක් එක් කරන්න.';

  @override
  String get isDefenderMoveFirst => 'දෙවන ක්‍රීඩකයා පළමුව චලනය කරයි';

  @override
  String get isDefenderMoveFirst_Detail =>
      'තැන්පත් කිරීමේ අවධියේ දෙවනුව චලනය කරන ක්‍රීඩකයා, චලන අවධියේ පළමුව චලනය කරයි.';

  @override
  String get mayRemoveMultiple => 'බහු-ඉවත් කිරීම';

  @override
  String get mayRemoveMultiple_Detail =>
      'ක්‍රීඩකයෙක් එකවර වැඩියෙන් මිල් වසා දමන්නේ නම්, ඇය වසා දැමූ මිල් ගණන ඉවත් කරනු ඇත.';

  @override
  String get mayRemoveFromMillsAlways => 'මිල්ලයන් විනාශ කරන්න';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'සාමාන්‍යයෙන්, ක්‍රීඩකයන් සෑදුනු මිල්ලකින් කැබලියක් ඉවත් කිරීමට පෙර වෙනත් කැබලි ඉවත් කල යුතුයි. මෙම සීමාව අක්‍රීය කිරීමට මෙම විකල්පය සක්‍රීය කරන්න.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'පුවරුව පිරෙන විට දෙවන ක්‍රීඩකයා පරාජය වේ';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'තැන්පත් කිරීමේ අවසානයේ පුවරුව පිරෙන විට, පළමුව තැන්පත් කරන පැත්ත ක්‍රීඩාව පරාජය වේ. එලෙස නොවේ නම්, ක්‍රීඩාව දීප්තියක් වේ.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'නීතිසම්මත චලන නැති විට පරාජය වේ';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'ප්‍රතිපක්ෂය තමන්ව අවහිර කරන ලෙස චලනය කළ නොහැකි විට ක්‍රීඩකයා පරාජය වේ. මෙම විකල්පය අක්‍රීය කරන ලද්දේ නම්, චලනය සඳහා පැත්ත වෙනස් කරන්න.';

  @override
  String get mayFly => 'පියාසර';

  @override
  String get mayFly_Detail =>
      'ක්‍රීඩකයෙකුට කැබලි තුනක් හෝ හතරක් (වින්‍යාස කළ හැකි) පමණක් ඉතිරි වී තිබේ නම්, ඇයට කැබලිය කිසිදු නිදහස් ලකුණකට චලනය කළ හැකිය.';

  @override
  String get nMoveRule => 'එන්-චලන නීතිය';

  @override
  String get nMoveRule_Detail =>
      'නිශ්චිත චලන ගණනක් තුළ කැබලි ඉවත් කිරීමක් නොවී තිබේ නම් ක්‍රීඩාව සම වේ.';

  @override
  String get rollback => 'ආපසු රෝල් කරන්න';

  @override
  String get pleaseSelect => 'කරුණාකර තෝරන්න';

  @override
  String get copy => 'පිටපත්';

  @override
  String get moveHistoryCopied => 'චලන ඉතිහාසය ක්ලිප්බෝඩ් ට පිටපත් කර ඇත.';

  @override
  String get help => 'උදව්';

  @override
  String get feedback => 'ප්‍රතිපෝෂණය';

  @override
  String get exit => 'පිටවීම';

  @override
  String get ruleSettings => 'නීති සැකසුම්';

  @override
  String get color => 'වර්ණ';

  @override
  String get boardColor => 'පුවරුවේ වර්ණය';

  @override
  String get pieceColor => 'කැබලි වර්ණය';

  @override
  String get backgroundColor => 'පසුබිම් වර්ණය';

  @override
  String get lineColor => 'පුවරු රේඛා වර්ණය';

  @override
  String get whitePieceColor => 'ක්‍රීඩක 1 කැබලි වර්ණය';

  @override
  String get blackPieceColor => 'ක්‍රීඩක 2 කැබලි වර්ණය';

  @override
  String get messageColor => 'පණිවුඩ වර්ණය';

  @override
  String get isPieceCountInHandShown => 'තැන්පත් නොකළ කැබලි ගණන පෙන්වන්න';

  @override
  String get isNotationsShown => 'පුවරුව මත ලකුණු පෙන්වන්න';

  @override
  String get isHistoryNavigationToolbarShown =>
      'ඉතිහාස ගමනාන්ත මෙවලම් තීරුව පෙන්වන්න';

  @override
  String get display => 'ප්‍රදර්ශනය';

  @override
  String get boardBorderLineWidth => 'පුවරු මායිම් පළල';

  @override
  String get boardInnerLineWidth => 'පුවරු අභ්‍යන්තර රේඛා පළල';

  @override
  String get pieceWidth => 'කැබලි පළල';

  @override
  String get fontSize => 'අකුරු ප්‍රමාණය';

  @override
  String get standardNotation => 'WMD සටහන් කිරීම';

  @override
  String get restore => 'ප්‍රතිස්ථාපනය';

  @override
  String get restoreDefaultSettings => 'සාමාන්‍ය සැකසුම් ප්‍රතිස්ථාපනය කරන්න';

  @override
  String pick(Object element) {
    return '$element තෝරන්න';
  }

  @override
  String get info => 'තොරතුරු';

  @override
  String get hint => 'හෝඩුවාව';

  @override
  String get player => 'ක්‍රීඩකයා';

  @override
  String get player1 => 'ක්‍රීඩක 1';

  @override
  String get player2 => 'ක්‍රීඩක 2';

  @override
  String get howToPlay => 'ක්‍රීඩා කරන ආකාරය';

  @override
  String get toPlacePiece =>
      'කැබලි තැන්පත් කිරීමට ඕනෑම ලබාගත හැකි ලකුණක් හඹා යන්න.';

  @override
  String get toSelectPiece => 'කැබලියක් චලනය කිරීමට එය හඹා යන්න.';

  @override
  String get toMovePiece => 'කැබලියක් සම්බන්ධ ලකුණක් මත හඹා එය චලනය කරන්න.';

  @override
  String get toRemovePiece => 'ප්‍රතිපක්ෂයේ කැබලියක් ඉවත් කිරීමට එය හඹා යන්න.';

  @override
  String get needToCreateMillFirst =>
      'කැබලියක් ඉවත් කිරීමට පළමුව මිල්ලක් සෑදිය යුතුය.';

  @override
  String get needToPlayWithOwnPieces => 'ඔබට ඔබේ කැබලි සමඟ ක්‍රීඩා කළ යුතුය.';

  @override
  String get statistics => 'සංඛ්‍යානය';

  @override
  String get totalGames => 'සමස්ත ක්‍රීඩා';

  @override
  String get results => 'ප්‍රතිඵල';

  @override
  String get left => 'වම';

  @override
  String get privacyPolicy => 'පෞද්ගලිකත්ව ප්‍රතිපත්තිය';

  @override
  String get privacyPolicy_Detail_1 =>
      'කරුණාකර සවිස්තරයෙන් කියවා, මෙම සමඟ ඔබ එකඟ බවට හා එය සම්පූර්ණයෙන්ම ඔබ තේරුම් ගන්නා බවට වහාම තහවුරු කරන්න ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. මෙම ප්‍රතිපත්තියට ඔබ එකඟ නොවේ නම්, කරුණාකර මෙම යෙදුම භාවිතා නොකරන්න. යෙදුම භාවිතා කිරීම ඔබට මේ කොන්දේසි පිළිගන්නා බවට යෙදීමි.';

  @override
  String get and => ' සහ ';

  @override
  String get accept => 'එකඟ වෙන්න';

  @override
  String get takeBack => 'ආපසු ගන්න';

  @override
  String get takingBack => 'ආපසු ගෙන එමින්…';

  @override
  String get waiting => 'බලා සිටීම…';

  @override
  String get stepForward => 'ඉදිරියට පියවර ගන්න';

  @override
  String get takeBackAll => 'සියල්ල ආපසු ගන්න';

  @override
  String get stepForwardAll => 'සියලුම පියවර ඉදිරියට ගන්න';

  @override
  String get moveNow => 'දැන් චලනය කරන්න';

  @override
  String get done => 'අවසන්.';

  @override
  String get crackMill => 'මිල්ල බිඳ දමන්න';

  @override
  String get crackMill_Detail =>
      'ක්‍රීඩකයෙකුට මිල්ලවල පමණක් කැබලි තිබේ නම්, මිල්ලවල කැබලි ඉවත් කිරීමට අගුළු දැමීමට නොවේ.';

  @override
  String get animationDuration => 'සජීවීකරණ කාලය';

  @override
  String get none => 'කිසිවක් නැත';

  @override
  String get theme => 'තේමාව';

  @override
  String get helpContent =>
      'මෙම ක්‍රීඩාව ඉලක්කය වන්නේ ප්‍රතිපක්ෂයට තුනට වඩා අඩු කෑලි ඉතිරි කිරීම හෝ නීතිවිරෝධී චලන නොමැති කිරීමයි.\n\nක්‍රීඩාව තීරණාත්මක තත්වයක් තුන් වරක් සිදුවේ නම් හෝ අවසාන 100 (වින්‍යාස කළ හැකි) චලනවලින් කෑලි ඉවත් නොකරන නම් ක්‍රීඩාව ස්වයංක්‍රීයව මුදාහැරේ.\n\nක්‍රීඩාව තුන් අදියරවලින් ඉදිරියට යයි:\n\n1. හිස් ලක්ෂ්‍ය තැන්වල කෑලි තැබීම\n2. කෑලි ආසන්න ලක්ෂ්‍ය තැන් වෙත ගමන් කිරීම\n3. (විකල්ප අදියර) ක්‍රීඩකයාට කෑලි තුනකට හැරවූ විට ඕනෑම හිස් ලක්ෂ්‍යයකට කෑලි ගමන් කිරීම\n\nතැබීම\n\nක්‍රීඩාව හිස් පුවරුවක් සමඟ ආරම්භ වේ, එය විසිහතර ලක්ෂ්‍ය සහිත ජාලකයකි. ක්‍රීඩකයෝ තමන්ගේ කෑලි හිස් ලක්ෂ්‍යයන් මත තැබීමට පාරිභෝග\n\nිකයෝ වෙත මාරු වේ, එක් එක් ක්‍රීඩකයා සියලු කෑලි පුවරුව මත තැබීමට තැබීමට තැබේ. ක්‍රීඩකයෙකු තම කෑලි තුනක් සෘජුවම තබන විට, ඔහුට \"මිල්\" ඇති වේ සහ ප්‍රතිපක්ෂයේ කෑලි එකක් පුවරුවෙන් ඉවත් කළ හැකිය.\n\nසමහර නීතිවල, ක්‍රීඩකයෝ සෑදුණු මිල් එකකින් කෑලි එකක් ඉවත් කිරීමට පෙර වෙනත් කෑලි ඉවත් කළ යුතුය.\n\nතැබීමේ අදියරේදී ඉවත් කළ කෑලි ලක්ෂ්‍යන්ට නැවත කෑලි තැබීමට නොහැකිය සමහර නීතිවල.\n\nසියලු කෑලි භාවිතා කර ගත් පසු, ක්‍රීඩකයෝ මාරුවෙති.\n\nගමන් කිරීම\n\nගමන් කිරීමට, ක්‍රීඩකයෙකු තමන්ගේ කෑලි එකක් පුවරුවේ රේඛාවක් ඔස්සේ හිස් ආසන්න ලක්ෂ්‍යයකට ගමන් කරයි. ඔහු එසේ කළ නොහැකි නම්, ඔහු ක්‍රීඩාව පරාජය කර ඇත. ක්‍රීඩකයෙකු තමන\n\n්ගේ කෑලි තුනක් පුවරුවේ රේඛාවක ගෙන යන විට, ඔහුට මිල් ඇති වේ සහ තැබීමේ අදියරේදී වාගේ ප්‍රතිපක්ෂයේ කෑලි එකක් ඉවත් කළ හැකිය. කෑලි දෙකකට අඩුවූ කිසිදු ක්‍රීඩකයෙකුට නව මිල් සාදන්නේ නැත, එසේම ඔහු ක්‍රීඩාව පරාජය කර ඇත. ක්‍රීඩකයෙකු තමන්ගේ කෑලි තුනට වඩා වැඩියේදී ද ප්‍රතිපක්ෂය ඔහුගේ චලන වාරණය කරන විට ඔහු පරාජය කරයි.\n\nඉගිලීම\n\nසමහර නීති විකල්පයන්හි, ක්‍රීඩකයෙකුට කෑලි තුනක් ඉතිරි වූ විට, ඔහුගේ කෑලි ඉගිලීමට, හපන්නට හෝ පැන යාමට හැකිය, එනම් ආසන්න ලක්ෂ්‍යයන්ට පමණක් නොව ඕනෑම හිස් ලක්ෂ්‍යයකටය.\n';

  @override
  String get versionInfo => 'අනුවාදන තොරතුරු';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'බලපත්‍රය';

  @override
  String get sourceCode => 'මූලාශ්‍ර කේතය';

  @override
  String get appVersion => 'යෙදුම් අනුවාදය';

  @override
  String get general => 'සාමාන්‍ය';

  @override
  String get advanced => 'උසස්';

  @override
  String get placing => 'තැන්පත්';

  @override
  String get moving => 'චලනය';

  @override
  String get removing => 'ඉවත් කිරීම';

  @override
  String get gameOverCondition => 'ක්‍රීඩාව අවසන් තත්වය';

  @override
  String get aisPlayStyle => 'යන්ත්‍ර මානසිකත්වය';

  @override
  String get passive => 'උදාසීන';

  @override
  String get timeout => 'කාල සීමාව';

  @override
  String get appearance => 'පෙනුම';

  @override
  String get drawOnHumanExperience => 'මානව අත්දැකීම් මත පාදක කිරීම';

  @override
  String get considerMobility => 'කැබලි සංචලනය සලකා බලන්න';

  @override
  String get pieceCount => 'කැබලි ගණන:';

  @override
  String inHand(Object player, int count) {
    return '$player අතේ: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player පුවරුව මත: $count';
  }

  @override
  String get boardTop => 'පුවරුව ඉහළ සිට අනුරූපිතය';

  @override
  String get notAIsTurn => 'යන්ත්‍රයේ වරයක් නොවේ.';

  @override
  String get aiIsNotThinking => 'යන්ත්‍රය සිතන්නේ නැත.';

  @override
  String get atEnd => 'ඔබ චලන ලැයිස්තුවේ අවසානයේ සිටී.';

  @override
  String get tapBackAgainToLeave => 'නික්මීමට යළිත් පසුපසට තට්ටු කරන්න.';

  @override
  String get more => 'වැඩි විස්තර';

  @override
  String get experimental => 'එය පරීක්ෂණාත්මක විශේෂාංගයකි.';

  @override
  String get experiments => 'පරීක්ෂණ';

  @override
  String get ossLicenses => 'විවෘත-මූලාශ්‍ර බලපත්‍ර';

  @override
  String get language => 'භාෂාව';

  @override
  String get defaultLanguage => 'පෙරනිමි භාෂාව';

  @override
  String get mayMoveInPlacingPhase =>
      'කැබලි තැන්පත් කිරීමේ අවධියේදී චලනය කළ හැකිය';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'වෙන් කළ තැන්පත් කිරීමේ හා චලන කිරීමේ අවධියන් නොමැත, එනම්, ක්‍රීඩකයාට ඔවුන්ගේ කැබලි පුවරුව මත තැන්පත් කිරීමට හෝ තැන්පත් කළ කැබලි අතරින් එකක් චලනය කිරීමට එක් එක් චලනයකදී තීරණය කළ හැකිය (තැන්පත් කිරීමට ඉතිරි කැබලි තිබෙන තාක්).';

  @override
  String get drawerColor => 'මෙනුවේ වර්ණය';

  @override
  String get drawerTextColor => 'මෙනුවේ පෙළ වර්ණය';

  @override
  String get drawerHighlightItemColor => 'මෙනුවේ අගවන ලකුණු වර්ණය';

  @override
  String get mainToolbarBackgroundColor =>
      'ප්‍රධාන මෙවලම් තීරුවේ පසුබිම් වර්ණය';

  @override
  String get mainToolbarIconColor => 'ප්‍රධාන මෙවලම් තීරුවේ නිරූපක වර්ණය';

  @override
  String get navigationToolbarBackgroundColor =>
      'නැවුම් මෙවලම් තීරුවේ පසුබිම් වර්ණය';

  @override
  String get navigationToolbarIconColor => 'නැවුම් මෙවලම් තීරුවේ නිරූපක වර්ණය';

  @override
  String get autoHideToolbar => 'මෙවලම් තීරුව ස්වයංක්‍රීයව සඟවන්න';

  @override
  String get toolbarLocationOnScreen => 'මෙවලම් තීරුවේ තිර පිහිටුම';

  @override
  String get top => 'ඉහළ';

  @override
  String get bottom => 'පහළ';

  @override
  String get center => 'මැද';

  @override
  String get solidColor => 'ඝන වර්ණය';

  @override
  String get picture => 'පින්තූරය';

  @override
  String get chooseYourPicture => 'ඔබේ පින්තූරය තෝරන්න';

  @override
  String get light => 'සැහැල්ලු';

  @override
  String get dark => 'අඳුරු';

  @override
  String get themes => 'තේමා';

  @override
  String get currentTheme => 'වත්මන් තේමාව';

  @override
  String get saveTheme => 'තේමාව සුරකින්න';

  @override
  String get showAnalysisGraph => 'විශ්ලේෂණ සටහන පෙන්වන්න';

  @override
  String get analysis => 'විශ්ලේෂණය';

  @override
  String get saveGame => 'ක්‍රීඩාව සුරකින්න';

  @override
  String get loadGame => 'ක්‍රීඩාව පූරණය කරන්න';

  @override
  String get setupPosition => 'පිහිටුම සැකසීම';

  @override
  String get showLegalMoves => 'නීතිසම්මත චලන පෙන්වන්න';

  @override
  String get showLastMove => 'අවසාන චලනය පෙන්වන්න';

  @override
  String get showArrows => 'ඊතල පෙන්වන්න';

  @override
  String get pieces => 'කැබලි';

  @override
  String get showAnalysis => 'විශ්ලේෂණය පෙන්වන්න';

  @override
  String get threads => 'නූල්';

  @override
  String get getInvolved => 'දායක වන්න';

  @override
  String get helpImproveTranslate => 'පරිවර්තනය ප්‍රවර්ධනය කිරීමට උදව් කරන්න';

  @override
  String get tutorial => 'පාඩම';

  @override
  String get classicMill => 'සම්භාව්‍ය මිල්ල';

  @override
  String get mixedMill => 'මිශ්‍ර මිල්ල';

  @override
  String get ceylonMill => 'සිලෝන් මිල්ල';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'මිල්ල කැඩීම සහ නැවත නැවත සෑදීම සිදුවිය හැකිය';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'ක්‍රීඩකයෙකු මිල්ලක් කඩා වහාම නව මිල්ලක් සාදනවා නම්, ඔහුට එම කැබලිය ඊලඟ චලනයේදී මුල් සන්ධිස්ථානයට ගෙන යාමට නව මිල්ලක් සාදනවා නම් එය හැකිය.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'ක්‍රීඩකයෙකුට කැබලි තුනක් තිබෙන අවස්ථාවක දස චාලක පසුව කිසිදු ක්‍රීඩකයෙකු ප්‍රතිපක්ෂයේ කැබලි ඉවත් නොකරන විට තරඟය ඇදීමක් වේ';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'ක්‍රීඩකයෙකුට කැබලි තුනක් පමණක් තිබෙන විට, හා කිසිදු ක්‍රීඩකයෙකුට චලන දහයක් තුළ ප්‍රතිපක්ෂයේ කැබලියක් ඉවත් කළ නොහැකි විට, ක්‍රීඩාව සම වේ.';

  @override
  String get close => 'වසන්න';

  @override
  String get whitePiece => 'සුදු කැබලිය';

  @override
  String get blackPiece => 'කළු කැබලිය';

  @override
  String get emptyPoint => 'හිස් ලකුණ';

  @override
  String get noPoint => 'ලකුණක් නැත';

  @override
  String get placingPhase => 'තැන්පත් කිරීමේ අවධිය';

  @override
  String get movingPhase => 'චලන අවධිය';

  @override
  String get flyingPhase => 'පියාසර අවධිය';

  @override
  String sideToMove(Object player) {
    return 'චලනය කිරීමට පැත්ත: $player';
  }

  @override
  String lastMove(Object move) {
    return 'අවසාන චලනය: $move';
  }

  @override
  String get selected => 'තෝරාගත්';

  @override
  String get accessibility => 'ප්‍රවේශය';

  @override
  String get screenReaderSupport => 'තිර කියවන සහාය';

  @override
  String get isDraw => 'එය සම වේ!';

  @override
  String get draw => 'සම';

  @override
  String get pieceHighlightColor => 'කැබලි අලංකාර වර්ණය';

  @override
  String get algorithm => 'අල්ගොරිතම';

  @override
  String get endgameNMoveRule => 'අවසාන ක්‍රීඩා එන්-චලන නීතිය';

  @override
  String get endgameNMoveRule_Detail =>
      'කිසිදු ක්‍රීඩකයෙකුට කැබලි තුනක් පමණක් තිබෙනවා නම්, හා නියමිත චලන තුළ කිසිදු ක්‍රීඩකයෙකු කැබලියක් ඉවත් නොකරන විට ක්‍රීඩාව සම වේ.';

  @override
  String get drawReasonEndgameRule50 =>
      'එක් එක් ක්‍රීඩකයෙකුට කැබලි තුනක් පමණක් තිබෙනවා, හා නියමිත චලන තුළ කිසිදු ක්‍රීඩකයෙකු කැබලියක් ඉවත් නොකරන විට ක්‍රීඩාව සම වේ.';

  @override
  String get threefoldRepetitionRule => 'තුන් ගුණ නැවත නැවතීමේ නීතිය';

  @override
  String get threefoldRepetitionRule_Detail =>
      'තත්වයක් තුන්වන වතාවට ඇති වීමේදී ක්‍රීඩාව සම වේ.';

  @override
  String get continueToMakeMove => 'මිල්ල! චලනය ඉදිරියට ගෙන යන්න.';

  @override
  String get pointStyle => 'ලකුණු ශෛලිය';

  @override
  String get pointWidth => 'ලකුණු පළල';

  @override
  String get solid => 'ඝන';

  @override
  String get hollow => 'හිස්';

  @override
  String get languageName => 'සිංහල';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count චලන',
      one: '$count චලනය',
      zero: 'චලනය',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'පූරණය කිරීම අසාර්ථකයි.';

  @override
  String get filename => 'ගොනු නාමය';

  @override
  String get browse => 'බ්‍රවුස් කරන්න…';

  @override
  String get gameFiles => 'ක්‍රීඩා ගොනු';

  @override
  String get gameSavedTo => 'ක්‍රීඩාව සුරැකුණු තැන';

  @override
  String get empty => 'හිස්';

  @override
  String get noMove => 'චලනයක් නැත.';

  @override
  String get restoredPosition => 'ප්‍රාරම්භක තත්වය නැවත ස්ථාපිත කරන ලදී.';

  @override
  String get clean => 'පිරිසිදු';

  @override
  String get cleanedUp => 'පිරිසිදු කරන ලදී.';

  @override
  String get remove => 'ඉවත්';

  @override
  String get noPiecesCanBeRemoved => 'කැබලි කිසිවක් ඉවත් කළ නොහැක.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count කැබලි',
      one: '$count කැබලිය',
      zero: 'කැබලි නැත',
    );
    return '$_temp0 ඉවත් කල යුතුය.';
  }

  @override
  String placedCount(int count) {
    return 'තැබූ ($count)';
  }

  @override
  String get placedPieceCount => 'තැබීමේ අවධියේදී තැබූ කැබලි ගණන.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'වර්තමාන ක්‍රීඩකයා කැබලි $count ක් තැබීමට සමත් විය.';
  }

  @override
  String get notPlacingPhase => 'තැබීමේ අවධියක් නොවේ, එය වෙනස් කළ නොහැක.';

  @override
  String get paste => 'අලවන්න';

  @override
  String get pasteDone => 'අලවා අවසන්.';

  @override
  String get cannotPaste => 'අලවිය නොහැක.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'තැබීමට නොලැබුණු සහ ඉවත් කරන ලද කැබලි පෙන්වන්න';

  @override
  String get fullScreen => 'පුර්ණ තිරය';

  @override
  String get reopenToTakeEffect =>
      'සැකසුම් සක්‍රීය කරන ලදී, යෙදුම වහාම සහ නැවත විවෘත කරන්න.';

  @override
  String get forest => 'වනය';

  @override
  String get desktopImage => 'ඩෙස්ක්ටොප් රූපය';

  @override
  String get invalidPosition => 'වලංගු නොවන තත්වයකි.';

  @override
  String get shareGIF => 'GIF බෙදාගන්න';

  @override
  String get pixelRatio => 'පික්සල අනුපාතය';

  @override
  String get duration => 'කාලය';

  @override
  String get gameScreenRecorder => 'ක්‍රීඩා තිර රෙකෝඩරය';

  @override
  String get previous => 'පෙර';

  @override
  String get next => 'ඊළඟ';

  @override
  String get skip => 'මග හරින්න';

  @override
  String get gotIt => 'ගත්තා';

  @override
  String get youCanModifyRules =>
      'ඔබට නීති සැකසුම්වලින් ක්‍රීඩාවේ නීති වෙනස් කළ හැකිය.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'ඔබට පිකර්වල අගය වෙනස් කිරීමට මවුස් රෝදය භාවිතා කළ හැක.';

  @override
  String get noTimeLimitForThinking =>
      'AI සිතුවිලි කාලය 0 ක් ලෙස සකසා ඇති අතර එය සිතුවිලි සඳහා කාල සීමාවක් නොවේ.';

  @override
  String get whatIsMtdf =>
      'MTD(f) යනු අතරමැදි සෙවුම් ප්‍රතිඵල යළි යොදාගෙන හා හොඳ ප්‍රාරම්භක අනුමානයක් යොදා සෙවුම් ප්‍රදේශය සීමා කිරීමේ අරමුණු සහිත ඇල්ෆා-බීටා සෙවුම් රීතියේ වෙනස් කළ ආකෘතියකි.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'කරුණාකර දැන ගන්න, AI සිතුවිලි කාල සීමාව සකස් කිරීම පූර්ණයෙන්ම නිරවුල් නොවිය හැක. අභියෝගතා මට්ටම අඩු අගයකට තැබූ විට සැබෑ සිතුවිලි කාලය කෙටි විය හැකිය හා AI සිතුවිලි මැද සිටින විට කාලය අවසන් වන විට දිගු විය හැකිය.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'ඔබ දුෂ්කරතා මට්ටම ඉහළට සකසා නමුත් AI සිතීමේ කාලය වැඩි නොකරන්නේ නම්, සිතීමේ කාල සීමාව හේතුවෙන් සැබෑ දුෂ්කරතා මට්ටම අඩු අගයකට සීමා විය හැකිය. යන්ත්‍රයේ ක්‍රියාකාරීත්වය මත පදනම්ව සත්‍ය අගය වෙනස් විය හැක.';

  @override
  String get whatIsPvs =>
      'PVS (ප්‍රධාන විචල්‍ය සෙවීම) යනු ලබා දී ඇති ස්ථානයක හොඳම චලනය සොයා ගැනීමට සෙවුම් ඇල්ගොරිතමයකි. එය ඇල්ෆා-බීටා ඇල්ගොරිතමයේ වැඩි දියුණු කිරීමක් වන අතර ප්‍රධාන විචලනයෙන් දැනටමත් ආරක්ෂිත ලකුණු වලට වඩා පියවරක් නරක හෝ නරක නොවන බව තහවුරු කිරීමට ශුන්‍ය හෝ ශුන්‍ය කවුළු සෙවීම් භාවිතා කරයි. PVS වඩාත් බලාපොරොත්තු සහගත චලනයන් කෙරෙහි අවධානය යොමු කරන අතර සෙවුමේ කාර්යක්ෂමතාව වැඩි දියුණු කිරීමට උපකාරී වන උපප්‍රශස්ත ශාඛා පිළිබඳ අනවශ්‍ය සෙවීම් වළක්වයි.';

  @override
  String get whatIsAlphaBeta =>
      'ඇල්ෆා-බීටා ඇල්ගොරිතම යනු හොඳම චලනය සොයා ගැනීමට සෙවුම් ඇල්ගොරිතමයකි. සෙවුම් ගස කප්පාදු කිරීමට සහ කාර්යක්ෂමතාව වැඩි කිරීමට එය minimax මූලධර්මය සහ ඇල්ෆා සහ බීටා යන අගයන් දෙකක් භාවිතා කරයි. ඇල්ෆා පරිගණකයට ලබාගත හැකි අවම ලකුණු නියෝජනය කරන අතර බීටා නියෝජනය කරන්නේ එහි ප්‍රතිවාදියාට ලබාගත හැකි උපරිම ලකුණු සංඛ්‍යාවයි. ක්‍රීඩාවකදී බුද්ධිමත්, කාර්යක්ෂම තීරණ ගැනීමට ඇල්ගොරිතම පරිගණකයට උපකාර කරයි.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'මිනිස් අත්දැකීමට අනුව දිනන්න ගියොත් පරදිනවා. ඒ වෙනුවට, ඔබේ ඉලක්කය ලෙස දිනුම් ඇදීමක් ඉලක්ක කර ක්රීඩාව පරාජය වීමෙන් වළකින්න. ඔබේ ප්‍රතිවාදියා නිරීක්ෂණය කර ඔවුන් වැරදි කළ හැකි ස්ථානයකට මෘදු ලෙස ආකර්ෂණය කරන්න. ඔවුන් දුර්වල බව පෙන්වන විට, අවස්ථාව ප්‍රයෝජනයට ගෙන ජයග්‍රහණය සඳහා මෘදු ලෙස තල්ලු කරන්න. මේ ආකාරයෙන්, ඔබට ක්රීඩාව ජය ගත හැකිය.';

  @override
  String get firstMoveDetail =>
      'මෙම ක්‍රීඩාවේ දෙවන ක්‍රීඩකයාට පළමු ක්‍රීඩකයාට වඩා ජයග්‍රහණය කිරීම පහසුය.';

  @override
  String get passiveDetail =>
      'පැසිව් විකල්පය සක්‍රීය කිරීමෙන් AIට තමන්ගේ තත්වයේ වාසිය ඇති විට නිස්ක්‍රියව සිටීමට ඉඩ ලැබේ, ඉක්මනින් තරඟය ජයග්‍රහණය කිරීමට ආක්‍රමණශීලීව උත්සහ කිරීමට වඩා.';

  @override
  String get moveRandomlyDetail =>
      'මෙම විකල්පය සක්‍රීය කිරීමෙන් ක්‍රීඩාවේ අහඹු බව සහ විනෝදය වැඩි වේ, එය අක්‍රීය කිරීමෙන් AI පරාජය කිරීමට පාඩම් කිරීමට උපකාරී වේ.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'AI එහි කැබලින් චලිතතාවය සලකා බැලුවේ නම්, එය ප්‍රතිපක්ෂයේ කැබලි ඉක්මනින් අල්ලා ගැනීමට පමණක් ඉලක්ක කර ගැනීමක් නොවේ, එය ප්‍රතිපක්ෂයේ චලනයන් වැලැක්වීම සහ එයින් තමන් තමන්ගේ චලනය වැළැක්වීම ද සලකා බැලේ.';

  @override
  String get whenBoardIsFull => 'පුවරුව පිරී ඇති විට';

  @override
  String get whenBoardIsFull_Detail =>
      'තැබීමේ අවධිය අවසානයේදී, චලන අවධිය ආරම්භ වීමට පෙර, පුවරුව කැබලි පිරී ඇත්තේ නම් එවිට ක්‍රියාව සිදුවේ.';

  @override
  String get sideToMoveRemovePiece =>
      'චලන අවධියේදී පළමුව චලනය කරන ක්‍රීඩකයා ප්‍රතිපක්ෂයේ කැබලියක් ඉවත් කරයි.';

  @override
  String get agreeToDraw => 'දෙපැත්තක්ම ඔවුන්ගේ තරඟය ඇනවුම් කරයි.';

  @override
  String get takeOpponentsPiece => 'ඔබේ ප්‍රතිපක්ෂයේ කැබලියක් ගන්න.';

  @override
  String get firstPlayerLose => 'පළමු ක්‍රීඩකයා තරඟය පරාජය වේ.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'පළමු සහ දෙවන ක්‍රීඩකයින් ප්‍රතිපක්ෂයේ කැබලියක් ඉවත් කරයි.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'දෙවන සහ පළමු ක්‍රීඩකයින් ප්‍රතිපක්ෂයේ කැබලියක් ඉවත් කරයි.';

  @override
  String get enteredFlyingPhase =>
      'දැන් පියාසර අවධියට ප්‍රවේශ විය, ප්‍රතිපක්ෂයේ කැබලි සමහරවිට පුවරුවේ හිස් ස්ථානයකට පියාසර කළ හැකිය. \"නීති සැකසුම්\" හි පියාසර නීතිය අක්‍රීය කළ හැකිය.';

  @override
  String get whenStalemate => 'ජරාවක් වූ විට';

  @override
  String get whenStalemate_Detail =>
      'කැබලියක් චලනය කළ නොහැකි විට පසුවන ක්‍රියාව කුමක්ද?';

  @override
  String get endWithStalemateLoss =>
      'අවහිර කරන ලද පැත්ත සඳහා ජරාවක් පරාජයක් ලෙස අවසන් කරන්න.';

  @override
  String get changeSideToMove => 'චලනය කිරීම සඳහා පැත්ත වෙනස් කරන්න.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'ප්‍රතිපක්ෂයේ කැබලියක් ඉවත් කර ඊළඟ චලනය කරන්න.';

  @override
  String get endWithStalemateDraw => 'ජරාවක් රේඛීය අවසානයක් සමඟ අවසන් කරන්න.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'ප්‍රතිපක්ෂයේ කැබලියක් ඉවත් කර චලනය කිරීම සඳහා පැත්ත වෙනස් කරන්න.';

  @override
  String get aiResponseDelayTime => 'AI ප්‍රතිචාර පරතර කාලය';

  @override
  String get aiIsDelaying =>
      'AI දැන් පරතර ප්‍රතිචාර අවධියක සිටී. ඉදිරියට යාමට පෙර කල් ඉන්න.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'ඔබට අසමීපිත කැබලියක් ඉවත් කළ නොහැක.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'ජරාවක් තිබේ නම්, ඔබේ ආසන්නයේ ප්‍රතිපක්ෂයේ කැබලි ඉවත් කළ හැක, ගල් යන්ත්‍රයේ සැකසුමක් තිබුණද වුවද.';

  @override
  String get whatIsMcts =>
      'MCTS යනු නව ක්‍රීඩකයින්ට පහසු අල්ගොරිතමකි, එය අනුකරණයන් හරහා විවිධ චලන ගවේෂණය කරමින් සහ ඇගයීම් කරමින් තීරණ ගනී.';

  @override
  String get goldenJade => 'ස්වර්ණ මැණික්';

  @override
  String get forestWood => 'වන ලී';

  @override
  String get darkMystery => 'අඳුරු අබිරහස';

  @override
  String get midnightBlue => 'මැදියමේ නිල්';

  @override
  String get greenForest => 'කොළ වනය';

  @override
  String get greenMeadow => 'කොළ ගොමරුව';

  @override
  String get stonyPath => 'ගල් මග';

  @override
  String get pastelPink => 'පැස්ටල් රෝස';

  @override
  String get turquoiseSea => 'තර්කුවාස් සාගරය';

  @override
  String get violetDream => 'වයලට් සිහිනය';

  @override
  String get mintChocolate => 'මින්ට් චොක්ලට්';

  @override
  String get skyBlue => 'අහස් නිල්';

  @override
  String get playfulGarden => 'විනෝද උයන';

  @override
  String get whatIsRetrogradeAnalysis =>
      'රිට්‍රෝග්‍රේඩ් විශ්ලේෂණ අල්ගොරිතමය බහු-අගය රිට්‍රෝග්‍රේඩ් විශ්ලේෂණය භාවිතා කර විවිධ ආරම්භක තත්වයන්ගෙන් අන්තිම ක්‍රීඩා දත්ත ගබඩාවක් ගොඩනගා, එවිට මෙම දත්ත ගබඩාව ක්‍රීඩා ප්‍රවාහය ප්‍රවර්ධනය කිරීමට අයදුම් කරයි. මෙම ප්‍රවේශය අති-ශක්තිමත් විසඳුම් ප්‍රවර්ගයට අයත් වේ.';

  @override
  String get viewAlgorithmGuide =>
      'ඔබට මෙම අල්ගොරිතමය සඳහා පරිශීලක අත්පොත බලන්න කැමතිද?';

  @override
  String get showPositionalAdvantageIndicator => 'තත්ව වාසි දර්ශකය පෙන්වන්න';

  @override
  String get usePerfectDatabase => 'පරිපූර්ණ දත්ත ගබඩාව භාවිතා කරන්න';

  @override
  String get perfectDatabaseDescription =>
      'අල්ලා නොලැබෙන ගේම් දත්ත ගබඩාවක් භාවිතා කිරීමට මෙම විකල්පය සක්‍රීය කරන්න. මෙම අංගය ආරම්භක හා අවසාන ක්‍රීඩා උපායන් දෙකම එක්කර අනුකූල චලන යෝජනා කරයි. ක්‍රීඩා ප්‍රවාහයේ උපරිම නිරවද්‍යතාවය සොයන ක්‍රීඩකයන්ට මෙය වඩාත් කැමති තේරීමකි. සුක්ෂ්ම ගණිතමය ක්‍රමවේදයන් හරහා සාදා ඇති දත්ත ගබඩාව ප්‍රායෝගිකත්වයේ නිමැවුම් සමීප ගේම් විසඳුම් ලබා දීමට නිර්මාණය කර ඇත.\n\nසටහන: AIට දත්ත ගබඩාවට ප්‍රවේශ වීමට නොහැකි වූවා නම්, එය ක්‍රීඩා තීරණ සඳහා සාමාන්‍ය අල්ගොරිතමවලට යොමු වේ. දත්ත ගබඩාව පවතින විට \'ක්‍රීඩා අභියෝගතා මට්ටම\' අභිබවා යා නොහැකි වේ, සහ \'AI සිතුවිලි කාලය\' දැඩි ලෙස අඩු වේ. \'AI ස්ටයිල් ප්ලේ\' තේරීම්වල බොහෝ සැකසුම් දත්ත ගබඩා ප්‍රතිඵල ඉහළම ප්‍රමුඛතාව ගනු ලබන නිසා අභිබවා යනු ඇත.\n\nමෙම නිර්දෝෂ දත්ත ගබඩාවෙන් හොඳම ප්‍රතිලාභය ලබා ගැනීමට උපදෙස් සඳහා, මෙතන ක්ලික් කරන්න.';

  @override
  String get backgroundImage => 'පසුබිම් රූපය';

  @override
  String get whatIsRandom =>
      'පරිපූර්ණ දත්ත ගබඩාව භාවිතා කරන්න\' විකල්පය සක්‍රීය නොකළ විට, \'අහඹු\' සැකසුම නිසා AIට චලන කැබලි අහඹුවෙන් චලනය කරන්නේ මෙවීම් තේරීම සඳහා කිසිදු අල්ගොරිතමයක් භාවිතා නොකරයි. මෙය සාමාන්‍යයෙන් අඩු ශක්තිමත් ක්‍රීඩා ප්‍රවාහයක් ගෙන එයි. අනෙක් අතට, \'පරිපූර්ණ දත්ත ගබඩාව භාවිතා කරන්න\' විකල්පය සක්‍රීය කළ විට, AI තීරණ ගැනීමේ සඳහා \'පරිපූර්ණ දත්ත ගබඩාව\' පමණක් යොදා ගනී, එය සාමාන්‍ය AI අල්ගොරිතමයන් සමඟ මිශ්‍ර නොකර. මෙම ප්‍රකාරයේදී, AIගේ චලන සම්පූර්ණයෙන්ම දත්ත ගබඩාවේ අන්තර්ගතය මත පදනම් වේ, වාස්තවික කාලීන ගණනයන් හෝ සෙවුම් අල්ගොරිතමයන් මත පැතිර නොවීමට යයි.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'ප්‍රතිවාදීන්ගේ කැබලි(ය) ඔවුන්ගේ අතින් ඉවත් කරන්න; ඉන්පසු එය ප්‍රතිවාදීන්ගේ තැබීමේ වරයි.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'තැබීමේ අවධියේදී නෙරෙන්චි නිර්මාණය කිරීමේදී';

  @override
  String get removeOpponentsPieceFromBoard =>
      'ප්‍රතිවාදීන්ගේ කැබලි(ය) පුවරුවෙන් ඉවත් කරන්න.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'ප්‍රතිවාදීන්ගේ කැබලි(ය) පුවරුවෙන් ඉවත් කරන්න; ඉන්පසු එය ප්‍රතිවාදීන්ගේ තැබීමේ වරයි.';

  @override
  String get opponentRemovesOwnPiece =>
      'ප්‍රතිවාදීන් තමන්ගේම කැබලි(ය) පුවරුවෙන් ඉවත් කරගනී.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'ඔබ ක්‍රියා කිරීමට වෙනුවට, ප්‍රතිවාදීන් තමන්ගේම කැබලි(ය) තෝරාගෙන පුවරුවෙන් ඉවත් කරගනී, තමන්ටම හානිකර ක්‍රියාවක් ගෙන එයි.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'ප්‍රතිවාදීන්ගේ කැබලි(ය) ඔවුන්ගේ අතින් ඉවත් කරන්න; ඉන්පසු ඔබේ වාරය ඔබ චලනය කිරීමට.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'ප්‍රතිවාදීන්ගේ අතින් කැබලි(ය) ඉවත් කරන්න. Multi-remove සැකසුම අනුව, කැබලි කීපයක් ඉවත් කළ යුතු නම් සහ ප්‍රතිවාදීන්ගේ අතේ කැබලි නොමැති වී ඇත්නම්, ප්‍රතිවාදීන්ගේ කැබලි පුවරුවෙන් ඉවත් කිරීම ඉදිරියට ගන්න. ඉන්පසු, ඔබේ වාරය ඔබ චලනය කිරීමට. ඔබ නෙරෙන්චි නිර්මාණය කිරීම ඉදිරියටත් ඉවත් කරන්නේ නම්, ඔබට ප්‍රතිවාදීන්ගේ කැබලි ඉවත් කිරීම තවදුරටත් කල හැකිය.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'ප්‍රතිවාදීන්ගේ අතින් කැබලි(ය) ඉවත් කරන්න. Multi-remove සැකසුම අනුව, කැබලි කීපයක් ඉවත් කළ යුතු නම් සහ ප්‍රතිවාදීන්ගේ අතේ කැබලි නොමැති වී ඇත්නම්, ප්‍රතිවාදීන්ගේ කැබලි පුවරුවෙන් ඉවත් කිරීම ඉදිරියට ගන්න. ඉන්පසු, ප්‍රතිවාදීන්ගේ වාරය ඔවුන් චලනය කිරීමට.';

  @override
  String get markAndDelayRemovingPieces =>
      'කැබලි ලකුණු කර ඉවත් කිරීම පමා කරන්න.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'තැබීමේ අවධියේදී, ඉවත් කිරීමට නියමිත කැබලි ලකුණු කරන ලදී, සහ දෙපාර්ශවයම මෙම ලකුණු කරන ලද ලක්ෂ්‍යයන් මත නව කැබලි තැබීමට නොහැකියි. චලන අවධියට ප්‍රවේශ වීමේදී, මෙම ලකුණු කරන ලද කැබලි සම්පූර්ණයෙන්ම ඉවත් කරන ලදී, එවිට ක්‍රීඩකයෝ දැන් හිස් වූ ලක්ෂ්‍යයන්ට තමන්ගේ කැබලි චලනය කළ හැකිය.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'තැනීමේ අවධියේදී නෙරෙන්චි සාදන විට කළ හැකි ක්‍රියාකාරකම්.';

  @override
  String get marked => 'සලකුණු කර ඇත';

  @override
  String get menu => 'මෙනුව';

  @override
  String get monochrome => 'එකාබද්ධ';

  @override
  String get youCanEnableScreenReaderSupport =>
      'ඔබට පොදු සැකසුම් වල ප්‍රවේශය සැකසුම් තුළ තිර කියවන සහය ස්විචය සක්‍රීය කළ හැකිය.';

  @override
  String get showNumbersOnPieces => 'කැබලි මත අංක පෙන්වන්න';

  @override
  String get saveImage => 'පින්තූරය සුරකින්න';

  @override
  String get isAnalysisToolbarShown => 'ප්‍රාදේශීය විද්‍යා තීරුව පෙන්වන්න';

  @override
  String get analysisToolbarBackgroundColor =>
      'ප්‍රාදේශීය විද්‍යා තීරුවේ පසුබිම් වර්ණය';

  @override
  String get analysisToolbarIconColor =>
      'ප්‍රාදේශීය විද්‍යා තීරුවේ අයිකන් වර්ණය';

  @override
  String get transformed => 'පරිවර්තනය කරන ලදි.';

  @override
  String get cannotTransform => 'පරිවර්තනය කළ නොහැකි.';

  @override
  String get rotate => 'කරත්තුව';

  @override
  String get horizontalFlip => 'H වක්‍රීයක්';

  @override
  String get verticalFlip => 'V වක්‍රීයක්';

  @override
  String get innerOuterFlip => 'IO වක්‍රීයක්';

  @override
  String get transparentCanvas => 'විනිවිද තිරය';

  @override
  String get restrictRepeatedMillsFormation =>
      'නෙරෙන්චි නැවත නැවත සාදන්නේන් වළක්වන්න';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'එක් නෙරෙන්චියකින් වෙනත් නෙරෙන්චියක් සාදන්නට හැරවූ කොටසක් ඊළඟ වරට මුල් ලක්ෂ්‍යයට වහාම ආපසු නොඑන්න. පළමුව වෙනත් චාලකයක් අවශ්‍යයි.';

  @override
  String get oneTimeUseMill => 'එක් වාරයක් භාවිතා කළ හැකි නෙරෙන්චි';

  @override
  String get oneTimeUseMill_Detail =>
      'සෑම නෙරෙන්චියක්ම ප්‍රතිවාදී කොටසක් එක් වරක් ඉවත් කරයි. ඔබට එය නැවත සංවිධානය කළ හැකිය, නමුත් අතිරේක ඉවත් කිරීම් සඳහා භාවිතා කළ නොහැක.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'ඔබ සකසා ඇති වර්තමාන නීති සඳහා ගැලපෙන පරිපූර්ණ දත්ත ගබඩාවක් නොමැත. පරිපූර්ණ දත්ත ගබඩාව ගැන වැඩි විස්තර සඳහා, කරුණාකර මෙහි ක්ලික් කරන්න.';

  @override
  String get focusOnBlockingPaths => 'අවහිර කිරීමේ මාර්ග වලට අවධානය යොමු කරන්න';

  @override
  String get focusOnBlockingPaths_Detail =>
      'තොරාගන්නා එක තුනක් හදන්නට වඩා ප්‍රතිවාදියන්ගේ චලන වලට බාධා එල්ල කිරීමට. තොරාගන්නා එක තුනක් සම්පූර්ණ කිරීමෙන් කොටස් ඉවත් කිරීම සඳහා අවධානය යොමු කිරීම වෙනුවට, AI ප්‍රතිවාදියා හසු කිරීමට, ඔවුන්ට චලනය කළ නොහැකි වන අතර ආක‍්‍රමණාකාරී ක්‍රීඩාවක් මඟින් නොව ප‍්‍රතිස්ථාමී යුද්ධයකින් ජයග්‍රහණය සපයයි. මෙම මූලාකෘතිය ප්‍රතිවාදියන්ගේ එකතු තුරන් තදම වැඩි ක්‍රියාවෙන් නතර කරන්නේ නැත.';

  @override
  String get pieceImage => 'තීරු රූපය';

  @override
  String get importColorSettings => 'වර්ණ සැකසුම් ආනයන කරන්න';

  @override
  String get exportColorSettings => 'වර්ණ සැකසුම් අපනයනය කරන්න';

  @override
  String get import => 'ආනයන';

  @override
  String get export => 'අපනයන';

  @override
  String get pleaseCopyJsonToClipboard =>
      'කරුණාකර පළමුව JSON ආකෘති සැකසුම් පසුරුපුවරුවට පිටපත් කරන්න.';

  @override
  String get copiedToClipboard => 'පසුරුපුවරුවට පිටපත් කෙරුණා.';

  @override
  String get imported => 'ආනයනය කරන ලදි.';

  @override
  String get boardImage => 'පුවරුවේ රූපය';

  @override
  String get autumnLeaves => 'ශරත් පත්';

  @override
  String get legendaryLand => 'පුරාණය භූමිය';

  @override
  String get vignetteEffect => 'වින්යට් අත්පත් ඇඳීම';

  @override
  String get promptMakeToolbarTransparent =>
      'පුවරුවේ පසුබැසීම් රූපය සකස් කරන විට මෙවලම් තීරුව සම්පූර්ණයෙන්ම පැහැදිලි කිරීමට අවශ්‍යද?';

  @override
  String get vibration => 'ක්‍රීඩාවේ විබ්‍රේෂන් සක්‍රීය කරන්න';

  @override
  String get soundTheme => 'ශබ්ද තේමා';

  @override
  String get ball => 'පෙරට';

  @override
  String get liquid => 'ද්‍රවය';

  @override
  String get wood => 'මුද';

  @override
  String get placeEffectAnimation => 'කිවිය තබා ඇති ඇනිමේෂන් බලපෑම';

  @override
  String get removeEffectAnimation => 'කිවිය ඉවත් කිරීමේ ඇනිමේෂන් බලපෑම';

  @override
  String get isToolbarAtBottom => 'මෙහෙයුම් තීරුව පහළින් පෙන්වන්න';

  @override
  String get boardCornerRadius => 'මන්දලාකාර තැටියේ අන්තයේ අරය';

  @override
  String get useOpeningBook => 'ආරම්භක පොත භාවිතය';

  @override
  String get currentRule => 'වත්මන්';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'දුස්';

  @override
  String get chamGonu => 'චාම්ගෝනු';

  @override
  String get zhiQi => 'චිජුකි';

  @override
  String get chengSanQi => 'චේංසැන්චි';

  @override
  String get mulMulan => 'මුල්-මුලාන්';

  @override
  String get nerenchi => 'නෙරෙන්චි';

  @override
  String get ruleSet => 'නීති කට්ටලය';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'මෙල්නිට්සා';

  @override
  String get daSanQi => 'දාසාන්චි';

  @override
  String get useOpeningBook_Detail =>
      'ආරම්භක ක්‍රීඩා කාලයේ ප්‍රවීණ මානව ක්‍රීඩකයන් විසින් නිතිපතා භාවිතා කරන විවෘත හැරවුම් AI භාවිතා කරන්න. සටහන: මෙම විශේෂාංගය දැනට විශේෂිත නියම කට්ටලයක් සඳහා පමණක් ලබා ඇත.';

  @override
  String get showAdvantageGraph => 'වාසිය ග්‍රැෆය පෙන්වන්න';

  @override
  String get advantageGraphHint =>
      'වගා අතිරේක රූප සනය AI ක්‍රියාත්මක වූ පසුව පමණක් අඳිනු ලැබේ. මිනිස් ක්‍රීඩකයා ක්‍රියාත්මක වන විට එය අඳිනු නොලැබේ.';

  @override
  String get removalBasedOnMillCounts =>
      'සියල්ල පත් කර අවසන් වන තෙක් ඉවත් කිරීම අක්‍රිය කරන්න. ක්‍රිඩාකාරীরা නෙරෙන්චි ගණන මත පදනම්ව ගැටලු ඉවත් කරති.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'සියලුම ගැටලු පත් කර අවසන්වන තෙක් ඉවත් කිරීම අක්‍රිය කරන්න. ක්‍රිඩාකාරীরা නෙරෙන්චි ගණන අනුව ගැටලු ඉවත් කරති: එය සමානයේ නම්, දෙදෙනාම එකම ප්‍රමාණයේ ගැටලු ඉවත් කරති; එක් අයකුට වැඩි නම්, ඔහු එක ගැටලුව වැඩිව ඉවත් කරන්නේ එක් ගැටලු වෙනස තබා ගන්නා අයුරුය. එක් අයෙකු විතරයි නෙරෙන්චි නිර්මාණය කළහොත්, ඔහු ගැටලු දෙකක් ඉවත් කරයි, අනෙක් අයෙකු එකක් ඉවත් කරයි. දෙදෙනාම නෙරෙන්චි නොනිර්මාණයすれば (නොකරනවා නම්), දෙදෙනාම එකක් බැගින් ඉවත් කරති.';

  @override
  String get elfilja => 'එල් ෆිල්ජා';

  @override
  String get tipSelectOwnPiece => 'ඔබගේ කොටස් අතරින් එකක් තෝරන්න.';

  @override
  String get notYourTurn => 'ඔබගේ වාරය නොවේ.';

  @override
  String get annotationToolbarBackgroundColor =>
      'සටහන් මෙවලම් තීරුවේ පසුබැසීමේ වර්ණය';

  @override
  String get annotationToolbarIconColor => 'සටහන් මෙවලම් තීරුවේ ආයිකන වර්ණය';

  @override
  String get isAnnotationToolbarShown => 'සටහන් මෙවලම් තීරුව පෙන්වන්න';

  @override
  String get enterAnnotationMode => 'සටහන් කිරීමේ මාදිලියට පිවිසෙන්න';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'ඔබට සියලු සටහන් මකන්න අවශ්‍ය බවට ඔබ විශ්වාස කරනවාද?';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM ප්‍රොම්ප්ට් clipboard එකට පිටපත් කර ඇත.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'සම්බන්ධතාවය ප්‍රතික්ෂේප කරන ලදී, සේවාදායකය අක්‍රීය විය හැක.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'හෙළිදරව් කිරීම සාර්ථකයි, සම්බන්ධතාවය සඳහා බලා සිටී...';

  @override
  String get noLanConnection => 'LAN සම්බන්ධතාවයක් නොමැත';

  @override
  String get takeScreenshot => 'ස්ක්‍රීන් ෂොට් ගන්න';

  @override
  String get disconnectedFromOpponent =>
      'ප්‍රතිසපර්ධකයාගෙන් සම්බන්ධතාවය බිඳ ගිය ඇත.';

  @override
  String get takeBackRequest => 'ආපසු ගැනීමේ ඉල්ලීම';

  @override
  String get nothingToShow => 'පෙන්වීමට කිසිවක් නැත.';

  @override
  String get stopHosting => 'හෝස්ට් කිරීම නවතා දමන්න';

  @override
  String get connectionResetByPeer =>
      'සම්බන්ධතාවය, ප්‍රතිසපර්ධකයා විසින් නැවත සකස් කරන ලදී.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'හෘදස්පන්දන කාලසීමාව නිසා සම්බන්ධතාවය බිඳ ගිය ඇත. කරුණාකර නැවත සම්බන්ධ වන්න.';

  @override
  String get startHosting => 'හෝස්ට් කිරීම ආරම්භ කරන්න';

  @override
  String get restartRequestRejected =>
      'නැවත ආරම්භ කිරීමේ ඉල්ලීම ප්‍රතික්ෂේප කරන ලදී.';

  @override
  String get notConnectedToLanOpponent =>
      'LAN ප්‍රතිසපර්ධකයා සමඟ සම්බන්ධ නොවී ඇත.';

  @override
  String get llmPrompt => 'LLM ප්‍රොම්ප්ට්';

  @override
  String get gameRestarted => 'ක්‍රීඩාව නැවත ආරම්භ කරන ලදී.';

  @override
  String get takeBackRejected => 'ආපසු ගැනීම ප්‍රතික්ෂේප කරන ලදී.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'ඔබට මෙම ක්‍රීඩාවෙන් ඉවත්වීමට අවශ්‍ය බවට විශ්වාසද?';

  @override
  String get opponentResignedYouWin => 'ප්‍රතිසපර්ධකයා ඉවත ලදී. ඔබ ජය ගෙන ඇත!';

  @override
  String get clearAllAnnotations => 'සියලු සටහන් මකන්න';

  @override
  String get connectedWaitingForOpponentSMove =>
      'සම්බන්ධ වී ඇත, ප්‍රතිසපර්ධකයාගේ වාරය බලා සිටී...';

  @override
  String get networkStatusDisconnected => 'ජාලය: සම්බන්ධ නැත';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'ආපසු ගැනීමේ ඉල්ලීම ප්‍රතිසපර්ධකයාට එවා ඇත.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'ප්‍රතිසපර්ධකයා ක්‍රීඩාවෙන් ඉවත්වී ඇතිවිය හැක.';

  @override
  String get connectedToHostSuccessfully => 'හොස්ට් සමඟ සාර්ථකව සම්බන්ධ විය.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'සම්බන්ධතාවය බිඳ ගිය: හෘදස්පන්දන කාලසීමාව නිසා';

  @override
  String get noHostDiscovered => 'හොස්ට් එකක් හමු නොවීය.';

  @override
  String get confirmResignation => 'ඉවත්වීම තහවුරු කරන්න';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'ක්‍රීඩාව හෝස්ට් කිරීම ආරම්භ කරන ලදී, ක්‍රීඩකයන් එකතු වීමට බලා සිටී...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'සම්බන්ධතාවය කල් ඉකුත් විය, ජාල සම්බන්ධතාවය අස්ථිරයි.';

  @override
  String get noLlmPromptAvailable => 'LLM ප්‍රොම්ප්ට් එකක් නොමැත.';

  @override
  String get youResignedGameOver => 'ඔබ ඉවත ලදී. ක්‍රීඩාව අවසන්.';

  @override
  String get serverIp => 'සේවාදායක IP';

  @override
  String get confirmClear => 'මකීම තහවුරු කරන්න';

  @override
  String get opponentSTurn => 'ප්‍රතිසපර්ධකයාගේ වාරය.';

  @override
  String get waitingAClientConnection => 'සේවාදායක සම්බන්ධතාවයක් බලා සිටී...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'ආපසු ගැනීමේ ඉල්ලීම ප්‍රතික්ෂේප කරන ලදී හෝ අසාර්ථක විය.';

  @override
  String get addText => 'පෙළ එකතු කරන්න';

  @override
  String get exitAnnotationMode => 'සටහන් කිරීමේ මාදිලියෙන් පිටවන්න';

  @override
  String get typeYourAnnotation => 'ඔබගේ සටහන් ටයිප් කරන්න';

  @override
  String get attemptingToReconnect => 'නැවත සම්බන්ධ වීමට උත්සාහ කරමින්...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'නැවත ආරම්භ කිරීමේ ඉල්ලීම එවූයේය. ප්‍රතිසපර්ධකයාගේ ප්‍රතිචාරය බලා සිටී...';

  @override
  String get serverIsStopped => 'සේවාදායකය නවතා දමා ඇත.';

  @override
  String get restartRequest => 'නැවත ආරම්භ කිරීමේ ඉල්ලීම';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'ඔබගේ වාරය නොවේ නම්, ආපසු ගැනීමේ ඉල්ලීම ඉල්ලීමට නොහැක.';

  @override
  String get takeBackAccepted => 'ආපසු ගැනීම පිළිගත්තා.';

  @override
  String get localNetworkSettings => 'දේශීය ජාල සැකසුම්';

  @override
  String get reconnectedSuccessfully => 'සාර්ථකව නැවත සම්බන්ධ විය!';

  @override
  String get failedToSaveImageToGallery =>
      'පින්තූරය ගැලරි වෙත සුරැකුම් කිරීම අසාර්ථක විය.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'ප්‍රතිසපර්ධකයා ක්‍රීඩාව නැවත ආරම්භ කිරීමට ඉල්ලූවා. ඔබ පිළිගන්නවද?';

  @override
  String get yourTurn => 'ඔබගේ වාරය.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'නැවත සම්බන්ධ වීමට නොහැකි විය, කරුණාකර ක්‍රීඩාව නැවත ආරම්භ කරන්න.';

  @override
  String get host => 'හොස්ට්';

  @override
  String get join => 'එක්වන්න';

  @override
  String get port => 'පොර්ට්';

  @override
  String get invalidIpAddress => 'අවලංගු IP ලිපිනය.';

  @override
  String get invalidPort => 'අවලංගු පොර්ට්.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'සම්බන්ධ වෙමින්: උත්සාහය $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'සම්බන්ධ වීමට අසාර්ථක විය: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'හෝස්ට් කිරීම ආරම්භ කිරීමට අසාර්ථක විය: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'හොස්ට් හෙළිදරව් විය: $ip:$port';
  }

  @override
  String get stop => 'නවතා දමන්න';

  @override
  String get discover => 'හෙළිදරව් කරන්න';

  @override
  String get connect => 'සම්බන්ධ වන්න';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'සේවාදායක සම්බන්ධ විය: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'හෙළිදරව් කිරීම: $seconds තත්පර';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'නැවත සම්බන්ධ වීම ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'සම්බන්ධ වී ඇත';

  @override
  String get delete => 'මකන්න';

  @override
  String get ancientEgypt => 'පුරාණ ඊජිප්තුව';

  @override
  String get gothicIce => 'ගොතික් අයිස්';

  @override
  String get riceField => 'සහල් කෙත';

  @override
  String get chinesePorcelain => 'චීන පෝසිලේන්';

  @override
  String get desertDusk => 'කාන්තාර සන්ධ්‍යාව';

  @override
  String get precisionCraft => 'නිවැරදි ශිල්පය';

  @override
  String get folkEmbroidery => 'ජන කාශ්මීර';

  @override
  String get carpathianHeritage => 'කාපැතියන් උරුමය';

  @override
  String get imperialGrandeur => 'අධිරාජ්‍ය මහිමය';

  @override
  String get bohemianCrystal => 'බෝහිමියන් ස්ඵටික';

  @override
  String get savannaSunrise => 'සවානා හිරු උදාව';

  @override
  String get harmonyBalance => 'සමගිය සහ සමතුලිතතාව';

  @override
  String get cinnamonSpice => 'කුරුඳු කුළුබඩු';

  @override
  String get anatolianMosaic => 'අනතෝලියන් මෝසෙයික්';

  @override
  String get carnivalSpirit => 'කානිවල් ආත්මය';

  @override
  String get custom => 'චාරිත්‍රය';

  @override
  String get spiceMarket => 'සුගන්ධ ද්‍රව්‍ය වෙළඳපොල';

  @override
  String get swipeToRevealTheDrawer => 'drawer එක දිස්වීමට ස්вайප් කරන්න';

  @override
  String get showGameInfoOnScreenshots => 'තිරපතයන්හි ක්‍රීඩා තොරතුරු පෙන්වන්න';

  @override
  String get humanMoveTime => 'මානව කාල සීමාව';

  @override
  String get noTimeLimitForHumanMoves => 'මානව චලනයන් සඳහා කාල සීමාවක් නොමැත';

  @override
  String get timeoutLoseWillBeApplied =>
      'මානව ක්‍රීඩකයා සඳහා කල් ඉකුත්වීමේ පරාජය යෙදෙනු ඇත';

  @override
  String get identifyingBoard => 'ක්‍රීඩා පුවරුව හඳුනා ගැනීම...';

  @override
  String get youCanEnterAnyModelName => 'ඔබට ඕනෑම මාදිලියේ නාමය ඇතුළත් කළ හැක.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'ක්‍රීඩා පුවරු ස්ථානය යෙදුනු අතර FEN ක්ලිප්බෝර්ඩයට පිටපත් කරන ලදි.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'උපදෙස්: ක්‍රීඩා පුවරුව පැහැදිලිව පෙන්වන ඡායාරූපයක් ගන්න උත්සාහ කරන්න.';

  @override
  String get llmPromptTemplate => 'LLM ප්‍රෝම්ප්ට් සැකිල්ල';

  @override
  String get noValidBoardDetected => 'වලංගු ක්‍රීඩා පුවරුව හමුවී නැත.';

  @override
  String get selectingImageFromAlbum => 'ඇල්බමයෙන් රූපය තෝමින්...';

  @override
  String get configurePromptTemplate => 'ප්‍රෝම්ප්ට් සැකිල්ල වින්‍යාස කරන්න';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'LLM විශ්ලේෂණය සඳහා ප්‍රෝම්ප්ට් සැකිල්ල සංස්කරණය කරන්න';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'හඳුනාගත් පුවරුවෙන් FEN ජනනය කිරීම අසමත් විය.';

  @override
  String get outputInCurrentLanguage => 'වත්මාන භාෂාවෙන් ප්‍රතිදානය';

  @override
  String get commonBaseUrls => 'සාමාන්‍ය මූලික URL';

  @override
  String get viewCommonModels => 'සාමාන්‍යව භාවිතා කරන මාදිලි බලන්න';

  @override
  String get recognitionParametersUpdated =>
      'හඳුනාගැනීමේ පරාමිතීන් යාවත්කාලීන කරන ලදි.';

  @override
  String get whiteSMove => 'සුදුගේ සෙල්ලම';

  @override
  String get resetToDefaults => 'පෙරනිමි සැකසුම් වෙත යළි පිහිටුවන්න';

  @override
  String get photoShoot => 'ඡායාරූප ග්‍රහණය';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'හඳුනාගත් පුවරු ස්ථානය යෙදීම අසමත් විය.';

  @override
  String get llmPromptContent => 'LLM ප්‍රෝම්ප්ට් අන්තර්ගතය';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM වින්‍යාස කර නොමැත. කරුණාකර ඔබගේ සැකසුම් පරීක්ෂා කරන්න.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'සැපයුම්කරු, මාදිලිය, API Key සහ Base URL සකසන්න';

  @override
  String get llmConfiguration => 'LLM වින්‍යාසය';

  @override
  String get configureLlmProvider => 'LLM සැපයුම්කරු වින්‍යාස කරන්න';

  @override
  String get llmPromptTemplateHeader => 'LLM ප්‍රෝම්ප්ට් සැකිල්ල ශීර්ෂය';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'රූපයේ කොටස් කිසිවක් හඳුනාගත නොවීය. කරුණාකර නැවත උත්සාහ කරන්න.';

  @override
  String get recognizeBoardFromImage => 'රූපයෙන් ක්‍රීඩා පුවරුව හඳුනාගන්න';

  @override
  String get viewTips => 'උදව් උපදෙස් බලන්න';

  @override
  String get applyToBoard => 'පුවරුවට යෙදවන්න';

  @override
  String get adjustBoardArea => 'පුවරු ප්‍රදේශය සකසන්න';

  @override
  String get viewCommonUrls => 'සාමාන්‍ය URL බලන්න';

  @override
  String get colorAnalysisFailed => 'වර්ණ විශ්ලේෂණය අසමත් විය!';

  @override
  String get analyzingGameBoardImage =>
      'ක්‍රීඩා පුවරු රූපය විශ්ලේෂණය වෙමින්...';

  @override
  String get selectFromAlbum => 'ඇල්බමයෙන් තෝරන්න';

  @override
  String get noBoardPointDetected => 'පුවරු ලක්ෂ්‍යය හමුවී නැත!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'අහල අත් හැරුණහොත්, පෙරනිමි සැකිල්ල භාවිතා කරනු ලැබේ';

  @override
  String get llmConfig => 'LLM වින්‍යාසය';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'ප්‍රෝම්ප්ට් සැකිල්ල පෙරනිමි අගයන් වෙත යළි පිහිටුවීමට ඔබට විශ්වාසද?';

  @override
  String get llmPromptTemplateFooter => 'LLM ප්‍රෝම්ප්ට් සැකිල්ල පාදකය';

  @override
  String get loadingResponse => 'ප්‍රතිචාරය බාගත වෙමින්...';

  @override
  String get applyThisResultToBoard => 'මෙම ප්‍රතිඵලය පුවරුවට යෙදවන්න';

  @override
  String get takingPicture => 'ඡායාරූපගැන්වීම...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'හඳුනා ගැනීමට ක්‍රීඩා පුවරු රූපයක් තෝරන්න';

  @override
  String get identificationResults => 'හඳුනා ගැනීමේ ප්‍රතිඵල';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'සිල්ලම් විශ්ලේෂණය කර අවබෝධ දක්වන්න.';

  @override
  String get getApiKey => 'API Key ලබා ගන්න';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'සම්පූර්ණ හඳුනාගැනීමේ ප්‍රවාහය නිම කිරීමට අසමත් විය.';

  @override
  String get boardRecognitionResult => 'පුවරු හඳුනා ගැනීමේ ප්‍රතිඵලය';

  @override
  String get askLlm => 'LLM වෙත විමසන්න';

  @override
  String get boardDetectionFailed => 'පුවරු හඳුනා ගැනීම අසමත් විය!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'පුවරු ලක්ෂ්‍යය හමුවී නැත, කොටස හඳුනා ගැනීමට නොහැක!';

  @override
  String get copyFen => 'FEN පිටපත් කරන්න';

  @override
  String get commonlyUsedModels => 'සාමාන්‍යයෙන් භාවිතා වන මාදිලි';

  @override
  String get apiKeyOptional => 'API Key (විකල්ප)';

  @override
  String get noImageSelected => 'රූපයක් තෝරා නැත';

  @override
  String get blackSMove => 'කළුගේ සෙල්ලම';

  @override
  String get llm => 'විශාල භාෂා මෝඩලය';

  @override
  String get llmProvider => 'සැපයුම්කරු';

  @override
  String get baseUrl => 'මූලික URL';

  @override
  String get model => 'මෝඩලය';

  @override
  String get temperature => 'උෂ්ණත්වය';

  @override
  String get llmCommandReceivedProcessing => 'කමාන්ඩ් හිමිවිය! AI සැකසමින්...';

  @override
  String get llmDeepThinkingWait =>
      'ගැඹුරු සිතුවිල්ල සිදුවෙමින් පවතී, කරුණාකර රැදී සිටින්න...';

  @override
  String get llmPresentingSoon => 'ඉක්මනින් ඉදිරිපත් කෙරේ...';

  @override
  String get recognitionParameters => 'හඳුනාගැනීම් පරාමිතීන්';

  @override
  String get adjustParamsDesc =>
      'හඳුනාගැනීම් නිවැරදිතාව වැඩිදියුණු කිරීමට පරාමිතීන් සකසන්න';

  @override
  String get saveParameters => 'පරාමිතීන් සුරකින්න';

  @override
  String unableToStartImageRecognition(String error) {
    return 'රූප හඳුනාගැනීම ආරම්භ කළ නොහැක: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'රූප හඳුනාගැනීම අසාර්ථක විය: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return '$whiteCount සුදු හා $blackCount කළු මැටි සහිත තත්ත්වය යෙදින ලදී';
  }

  @override
  String get fenCopiedToClipboard => '(FEN පසුරුපුවරුවට පිටපත් කර ඇත)';

  @override
  String recognitionFailed(String error) {
    return 'හඳුනාගැනීම අසාර්ථක විය: $error';
  }

  @override
  String get myRating => 'මගේ ශ්‍රේණිගත කිරීම';

  @override
  String get gamesPlayed => 'ක්‍රීඩා කළ තරග';

  @override
  String get wins => 'ජයග්‍රහණ';

  @override
  String get losses => 'පැරදුම්';

  @override
  String get draws => 'ජය පැරදුමෙන් තොර';

  @override
  String get lastUpdated => 'අවසන් වරට යාවත්කාලීන කරන ලදී';

  @override
  String get format => 'ආකෘතිය:';

  @override
  String get resetStatistics => 'සංඛ්‍යාලේඛන නැවත සකසන්න';

  @override
  String get drawRate => 'ජය පැරදුමෙන් තොර වීමේ අනුපාතය';

  @override
  String get lossRate => 'පැරදුම් අනුපාතය';

  @override
  String get aiStatistics => 'AI සංඛ්‍යාලේඛන';

  @override
  String get enableStatistics => 'සංඛ්‍යාලේඛන සබල කරන්න';

  @override
  String get enableStatistics_Detail =>
      'සබල කළ විට, ක්‍රීඩා ප්‍රතිඵල සංඛ්‍යාලේඛනවල සටහන් වනු ඇත. කෙසේ වෙතත්, ආපසු ගැනීම් ඇතුළත් ක්‍රීඩා සටහන් නොවනු ඇත. අබල කළ විට, සංඛ්‍යාලේඛන එකතු කිරීම විරාම කරනු ලැබේ.';

  @override
  String get thisWillResetAllGameStatistics =>
      'මෙය සියලුම ක්‍රීඩා සංඛ්‍යාලේඛන නැවත සකසනු ඇත. මෙම ක්‍රියාව අහෝසි කළ නොහැක.';

  @override
  String get boardInnerRingSize => 'පුවරුවේ අභ්‍යන්තර වළල්ලේ ප්‍රමාණය';

  @override
  String get boardShadowEnabled => 'පුවරුවේ හෙවනැල්ල';

  @override
  String get trapAwareness => 'Trap awareness';

  @override
  String get trapAwarenessDescription =>
      'Highlight trap moves with bold circles and arrows during analysis.';

  @override
  String trapExists(String trapMoves) {
    return 'Trap exists. Trap moves: $trapMoves';
  }

  @override
  String get custodianCapture => 'ග්රහණය කර ගැනීම';

  @override
  String get custodianCaptureDescription =>
      'එය අල්ලා ගැනීම සඳහා ඔබේ විරුද්ධවාදියෙකුගේ කොටසක් ඔබේ දෙකක් අතර සරල රේඛාවක් තුළට ඇතුළත් කරන්න.';

  @override
  String get custodianCaptureEnable => 'ග්රහණය කර බැලීමට ඉඩ දෙන්න';

  @override
  String get interventionCapture => 'මැදිහත්වීම් ග්රහණය';

  @override
  String get interventionCaptureDescription =>
      'ඔවුන් දෙදෙනාම ග්රහණය කර ගැනීම සඳහා ඔබේ ප්රතිවාදියාගේ කෑලි දෙකක් අතර හිස් ලක්ෂ්යයට යන්න.';

  @override
  String get interventionCaptureEnable => 'මැදිහත්වීමේ ග්රහණයට ඉඩ දෙන්න';

  @override
  String get leapCapture => 'පැනීම අල්ලා ගැනීම';

  @override
  String get leapCaptureDescription =>
      'යාබද විරුද්ධවාදියෙකුගේ කැබැල්ලක් හරහා ඔබ්බට ගිය හිස් ලක්ෂ්යයක් තුළට පැනීම.';

  @override
  String get leapCaptureEnable => 'පැනීම අල්ලා ගැනීමට ඉඩ දෙන්න';

  @override
  String get captureApplicableLines => 'අදාළ රේඛා';

  @override
  String get captureSquareEdges => 'චතුරස්රයේ දාර දිගේ';

  @override
  String get captureCrossLines => 'චතුරස්රය තරණය කරන විකලාංග රේඛා ඔස්සේ';

  @override
  String get captureDiagonalLines => 'චතුරස්රය තරණය කරන විකාර රේඛා ඔස්සේ';

  @override
  String get captureExecutionPhases => 'ක්රියාත්මක කිරීමේ අදියර';

  @override
  String get capturePiecesCondition =>
      'ඉතිරි කොටස් මත පදනම්ව චලනය වන අදියර තුළ ලබා ගත හැකිය';

  @override
  String get capturePiecesConditionUnlimited => 'සීමාවක් නැත';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'ඔබට කෑලි තුනක් හෝ ඊට අඩු වූ විට ලබා ගත හැකිය';
}
