// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Russian (`ru`).
class SRu extends S {
  SRu([String locale = 'ru']) : super(locale);

  @override
  String get appName => 'Мельница';

  @override
  String get welcome => 'Добро пожаловать';

  @override
  String get yes => 'Да';

  @override
  String get no => 'Нет';

  @override
  String get game => 'Игра';

  @override
  String get humanVsAi => 'Человек против ИИ';

  @override
  String get humanVsHuman => 'Человек против человека';

  @override
  String get aiVsAi => 'ИИ против ИИ';

  @override
  String get humanVsCloud => 'Человек против облачного ИИ';

  @override
  String get humanVsLAN => 'Человек против локальной сети';

  @override
  String get testViaLAN => 'Тестирование через локальную сеть';

  @override
  String get move => 'Ходы';

  @override
  String get showMoveList => 'Список ходов';

  @override
  String get moveList => 'Список ходов';

  @override
  String get noGameRecord => 'Нет записей';

  @override
  String get ok => 'ОК';

  @override
  String get confirm => 'Подтвердить';

  @override
  String get cancel => 'Отмена';

  @override
  String get tipSelectWrong => 'Выберите неверную фигуру.';

  @override
  String get tipPlace => 'Разместите свои фигуры.';

  @override
  String get tipBanPlace => 'Невозможно разместить здесь.';

  @override
  String get tipPlaced => 'Размещено.';

  @override
  String get tipRemove => 'Удалите фигуру.';

  @override
  String get tipBanRemove => 'Вы не можете удалить его.';

  @override
  String get tipRemoved => 'Фигура удалена.';

  @override
  String get tipMove => 'Переместите фигуру.';

  @override
  String get tipCannotPlace => 'Вы не можете разместить здесь фигуру.';

  @override
  String get tipCannotMove => 'Вы не можете передвинуть свою фигуру сюда.';

  @override
  String get tipMill => 'Мельница! Захватите фигуру противника.';

  @override
  String get tipContinueMill => 'Продолжайте захватывать фигуры противника.';

  @override
  String get tipSelectOpponentsPiece => 'Выберите одну из фигур противника.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Вы не можете убрать фигуру с мельницы.';

  @override
  String get tipCanMoveOnePoint => 'Фигура может переместиться на 1 очко.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Вы не можете передвигать фигуры противника.';

  @override
  String get tipSelectPieceToMove => 'Выберите свою фигуру для перемещения.';

  @override
  String get tipHaveThreePiecesLeft => 'У вас осталось 3 фигуры.';

  @override
  String get tipCanMoveToAnyPoint => 'Вы можете переместиться в любую точку.';

  @override
  String tipToMove(Object player) {
    return 'Ход $player.';
  }

  @override
  String get whiteWin => 'Игрок 1 победил!';

  @override
  String get blackWin => 'Игрок 2 победил!';

  @override
  String get won => 'Выиграл';

  @override
  String get lost => 'Проиграл';

  @override
  String get thinking => 'Думает…';

  @override
  String get newGame => 'Новая игра';

  @override
  String get importGame => 'Импортировать игру';

  @override
  String get exportGame => 'Экспортировать игру';

  @override
  String get gameImported => 'Игра импортирована.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Не удалось открыть $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Движения и правила не совпадают.';

  @override
  String get pleaseWait => 'Пожалуйста, подождите...';

  @override
  String get restartGame => 'Перезапустить текущую игру?';

  @override
  String get restart => 'Перезапустить';

  @override
  String get gameStarted => 'Игра началась, пожалуйста, поместите.';

  @override
  String get analyzing => 'Анализ…';

  @override
  String error(Object message) {
    return 'Ошибка: $message';
  }

  @override
  String get winRate => 'Частота побед';

  @override
  String get score => 'Очки:';

  @override
  String get white => 'Игрок 1';

  @override
  String get black => 'Игрок 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player количество фигур меньше трех.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player сдался.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player некуда ходить.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Доска заполнена, $player не может никуда сходить.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Время вышло, $player проиграл.';
  }

  @override
  String get drawReasonRule50 =>
      'В фазе перемещения ни одна фигура не была удалена за последнее определенное кол-во ходов.';

  @override
  String get drawReasonBoardIsFull =>
      'Это ничья, потому что доска переполнена.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Ничья из-за трехкратного повторения.';

  @override
  String get gameOverUnknownReason => 'Игра окончена! Причина неизвестна.';

  @override
  String get gameOver => 'Игра окончена';

  @override
  String get youWin => 'Вы выиграли! Поздравляем!';

  @override
  String challengeHarderLevel(int level) {
    return 'Сыграем на более сложном уровне? Новый уровень будет $level!';
  }

  @override
  String get youLose => 'Вы проиграли!';

  @override
  String get analyze => 'Анализируйте';

  @override
  String get about => 'О программе';

  @override
  String version(Object versionNumber) {
    return 'Версия: $versionNumber';
  }

  @override
  String get thanks => 'Спасибо';

  @override
  String get settings => 'Настройки';

  @override
  String get options => 'Опции';

  @override
  String get generalSettings => 'Общие настройки';

  @override
  String get skillLevel => 'Уровень сложности';

  @override
  String get moveTime => 'Время размышления ИИ';

  @override
  String get difficulty => 'Сложность';

  @override
  String get playSounds => 'Звуковые эффекты';

  @override
  String get playSoundsInTheGame => 'Звуки в игре';

  @override
  String get keepMuteWhenTakingBack => 'Тихий откат хода';

  @override
  String get tone => 'Тон';

  @override
  String get whoMovesFirst => 'Первый ход';

  @override
  String get human => 'Человек';

  @override
  String get ai => 'ИИ';

  @override
  String get alternate => 'Альтернативный';

  @override
  String get isAutoRestart => 'Начинать новую игру автоматически';

  @override
  String get isAutoChangeFirstMove => 'Автоматическая смена первого хода';

  @override
  String get shufflingEnabled => 'Случайный ход';

  @override
  String get misc => 'Прочее';

  @override
  String get rules => 'Правила';

  @override
  String get piecesCount => 'Количество фигур у каждого игрока';

  @override
  String get piecesCount_Detail => 'Сколько фигур у каждого игрока?';

  @override
  String get flyPieceCount => 'Номер летающей фигуры';

  @override
  String get flyPieceCount_Detail =>
      'Если функция \"Полет\" включена, когда игрок уменьшает количество фигур до определенного значения, его фигуры могут свободно перемещаться в любую незанятую точку, а не ограничиваться соседними точками, как в остальной части игры.';

  @override
  String get piecesAtLeastCount => 'Наименьшее количество фигур';

  @override
  String get hasDiagonalLines => 'Диагональные линии';

  @override
  String get hasDiagonalLines_Detail =>
      'Добавить на доску четыре диагональные линии.';

  @override
  String get isDefenderMoveFirst => 'Второй игрок ходит первым';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Игрок, который ходит вторым в фазе расстановки, ходит первым в фазе перемещения.';

  @override
  String get mayRemoveMultiple => 'Мульти-перемещение';

  @override
  String get mayRemoveMultiple_Detail =>
      'Если игрок закрывает более одной мельницы одновременно, он может удалить то количество мельниц, которое он закрыл.';

  @override
  String get mayRemoveFromMillsAlways => 'Уничтожить мельницы';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'По умолчанию игроки должны сначала удалить все другие фигуры, прежде чем удалить фигуру из сформированной мельницы. Включите эту опцию, чтобы отключить ограничение.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Второй игрок проигрывает, когда доска заполнена';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'В конце фазы расстановки, когда доска заполнена, сторона, которая расставляет первой, проигрывает игру, в противном случае - ничья.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Проигрыш при отсутствии законных ходов';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Игрок проиграет, если его противник заблокирует его так, что его нельзя будет передвинуть. Смените сторону для хода, если эта опция отключена.';

  @override
  String get mayFly => 'Летающий';

  @override
  String get mayFly_Detail =>
      'Если у игрока осталось только три или четыре (настраиваемые) фигуры, он может переместить фигуру в любую свободную точку.';

  @override
  String get nMoveRule => 'Правило N ходов';

  @override
  String get nMoveRule_Detail =>
      'Партия сводится к ничьей, если за определенное количество ходов каждый игрок не сделал ни одного удаления.';

  @override
  String get rollback => 'Откат';

  @override
  String get pleaseSelect => 'Пожалуйста, выберите';

  @override
  String get copy => 'Копир.';

  @override
  String get moveHistoryCopied => 'История ходов скопирована в буфер обмена.';

  @override
  String get help => 'Помощь';

  @override
  String get feedback => 'Обратная связь';

  @override
  String get exit => 'Выход';

  @override
  String get ruleSettings => 'Правила';

  @override
  String get color => 'Цвет';

  @override
  String get boardColor => 'Цвет доски';

  @override
  String get pieceColor => 'Цвет фигур';

  @override
  String get backgroundColor => 'Цвет фона';

  @override
  String get lineColor => 'Цвет линий на доске';

  @override
  String get whitePieceColor => 'Цвет фигур игрока 1';

  @override
  String get blackPieceColor => 'Цвет фигур игрока 2';

  @override
  String get messageColor => 'Цвет сообщений';

  @override
  String get isPieceCountInHandShown => 'Показать количество фигур в руке';

  @override
  String get isNotationsShown => 'Показать обозначения на доске';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Показать панель навигации по истории';

  @override
  String get display => 'Отображать';

  @override
  String get boardBorderLineWidth => 'Ширина границ доски';

  @override
  String get boardInnerLineWidth => 'Ширина внутренних линий доски';

  @override
  String get pieceWidth => 'Ширина фигуры';

  @override
  String get fontSize => 'Размер шрифта';

  @override
  String get standardNotation => 'Условные обозначения WMD';

  @override
  String get restore => 'Восстановить';

  @override
  String get restoreDefaultSettings => 'Восстановить настройки по умолчанию';

  @override
  String pick(Object element) {
    return 'Выберите $element';
  }

  @override
  String get info => 'Инфо';

  @override
  String get hint => 'Подсказка';

  @override
  String get player => 'игрок';

  @override
  String get player1 => 'Игрок 1';

  @override
  String get player2 => 'Игрок 2';

  @override
  String get howToPlay => 'Как играть';

  @override
  String get toPlacePiece =>
      'Нажмите на любую доступную точку, чтобы разместить фигуру.';

  @override
  String get toSelectPiece => 'Нажмите на фигуру, чтобы переместить ее.';

  @override
  String get toMovePiece =>
      'Нажмите на точку, связанную с фигурой, чтобы переместить ее.';

  @override
  String get toRemovePiece => 'Нажмите на фигуру противника, чтобы удалить ее.';

  @override
  String get needToCreateMillFirst =>
      'Прежде чем убрать фигуру, необходимо создать мельницу.';

  @override
  String get needToPlayWithOwnPieces => 'Вам нужно играть своими фигурами.';

  @override
  String get statistics => 'Статистика';

  @override
  String get totalGames => 'Всего игр';

  @override
  String get results => 'Результаты';

  @override
  String get left => 'слева';

  @override
  String get privacyPolicy => 'Политика конфиденциальности';

  @override
  String get privacyPolicy_Detail_1 =>
      'Пожалуйста, прочитайте внимательно и убедитесь, что вы полностью понимаете и согласны с этим ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Если вы не согласны с данной Политикой, пожалуйста, не используйте данное Приложение. Использование Приложения подразумевает, что вы принимаете эти условия.';

  @override
  String get and => ' и ';

  @override
  String get accept => 'Принять';

  @override
  String get takeBack => 'Откатить ход';

  @override
  String get takingBack => 'Откат хода…';

  @override
  String get waiting => 'Ожидание…';

  @override
  String get stepForward => 'Возвратить ход';

  @override
  String get takeBackAll => 'Откатиться к началу';

  @override
  String get stepForwardAll => 'Возвратить все откаченные';

  @override
  String get moveNow => 'Двигайся сейчас';

  @override
  String get done => 'Готово.';

  @override
  String get crackMill => 'Крек-мельница';

  @override
  String get crackMill_Detail =>
      'Если у игрока есть только фигуры в мельницах, фигуры в мельницах не будут блокироваться для удаления.';

  @override
  String get animationDuration => 'Длительность анимации';

  @override
  String get none => 'Нет';

  @override
  String get theme => 'Тема';

  @override
  String get helpContent =>
      'Цель игры — оставить у соперника менее трех фигур или лишить его возможности делать законные ходы.\n\nИгра автоматически заканчивается вничью, если позиция повторяется в третий раз или если за последние 100 (настраиваемых) ходов не было сделано ни одного хода.\n\nИгра проходит в три этапа:\n\n1. Размещение фигур на свободных полях.\n2. Перемещение фигур на соседние поля.\n3. (дополнительный этап) Перемещение фигур на любое свободное поле при уменьшении количества фигур игрока до трех.\n\nРазмещение\n\nИгра начинается с пустой доски, состоящей из сетки с двадцатью четырьмя полями. Игроки по очереди размещают свои фигуры на свободных полях, пока каждый игрок не разместит все свои фигуры на доске. Если игрок может поставить три своих фигуры в линию, у него появляется «мельница» и он может удалить одну из фигур соперника с доски.\n\nВ некоторых наборах правил игроки должны сначала удалить все другие фигуры, прежде чем удалять фигуру из сформированной мельницы.\n\nПо некоторым правилам нельзя снова размещать фигуры на полях, с которых были удалены фигуры.\n\nПосле того, как все фигуры размещены, игроки по очереди перемещают их.\n\nПеремещение\n\nДля перемещения игрок перемещает одну из своих фигур по линии доски на свободное соседнее поле. Если он не может этого сделать, он проигрывает игру. Игрок, который выстроил три своих фигуры в линию на доске, имеет «мельницу» и может удалить одну из фигур соперника, как и на этапе размещения. Если у игрока осталось только две фигуры, он не имеет возможности сформировать новые мельницы и, следовательно, проигрывает игру. Игрок также может проиграть, если у него осталось более трех фигур, но соперник блокирует их движение.\n\nПрыжки\n\nВ некоторых вариантах правил, когда у игрока остается только три фигуры, они могут прыгать, скакать или перемещаться на любые свободные точки, а не только на соседние.\n';

  @override
  String get versionInfo => 'Информация о версии';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Лицензия';

  @override
  String get sourceCode => 'Исходный код';

  @override
  String get appVersion => 'Версия приложения';

  @override
  String get general => 'Общие';

  @override
  String get advanced => 'Дополнительно';

  @override
  String get placing => 'Размещение';

  @override
  String get moving => 'Перемещение';

  @override
  String get removing => 'Удаление';

  @override
  String get gameOverCondition => 'Условие завершения игры';

  @override
  String get aisPlayStyle => 'Игровой стиль ИИ';

  @override
  String get passive => 'Пассивный';

  @override
  String get timeout => 'Таймаут';

  @override
  String get appearance => 'Внешний вид';

  @override
  String get drawOnHumanExperience => 'Опираться на человеческий опыт';

  @override
  String get considerMobility => 'Учитывать мобильность фигур';

  @override
  String get pieceCount => 'Количество фигур:';

  @override
  String inHand(Object player, int count) {
    return '$player в руке: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player на доске: $count';
  }

  @override
  String get boardTop => 'Смещение доски сверху';

  @override
  String get notAIsTurn => 'Сейчас не ход ИИ.';

  @override
  String get aiIsNotThinking => 'ИИ не думает.';

  @override
  String get atEnd => 'В конце списка ходов.';

  @override
  String get tapBackAgainToLeave => 'Нажмите назад еще раз, чтобы выйти.';

  @override
  String get more => 'Больше';

  @override
  String get experimental => 'Это экспериментальная функция.';

  @override
  String get experiments => 'Эксперименты';

  @override
  String get ossLicenses => 'Лицензии с открытым исходным кодом';

  @override
  String get language => 'Язык';

  @override
  String get defaultLanguage => 'Язык по умолчанию';

  @override
  String get mayMoveInPlacingPhase =>
      'Фигуры могут перемещаться в фазе размещения';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Не существует отдельных фаз размещения и перемещения, т.е. игроки могут решать на каждом ходу, хотят ли они разместить фигуру на доске или переместить одну из своих фигур (пока у них есть оставшиеся фигуры для размещения).';

  @override
  String get drawerColor => 'Цвет меню';

  @override
  String get drawerTextColor => 'Цвет текста меню';

  @override
  String get drawerHighlightItemColor => 'Цвет выделенного пункта меню';

  @override
  String get mainToolbarBackgroundColor => 'Цвет фона панели инструментов';

  @override
  String get mainToolbarIconColor => 'Цвет значка панели инструментов';

  @override
  String get navigationToolbarBackgroundColor => 'Цвет фона панели навигации';

  @override
  String get navigationToolbarIconColor => 'Цвет значка панели навигации';

  @override
  String get autoHideToolbar => 'Автоматически скрывать панель инструментов';

  @override
  String get toolbarLocationOnScreen =>
      'Расположение панели инструментов на экране';

  @override
  String get top => 'Сверху';

  @override
  String get bottom => 'Снизу';

  @override
  String get center => 'По центру';

  @override
  String get solidColor => 'Сплошной цвет';

  @override
  String get picture => 'Картинка';

  @override
  String get chooseYourPicture => 'Выберите свою картинку';

  @override
  String get light => 'Светлая';

  @override
  String get dark => 'Тёмная';

  @override
  String get themes => 'Темы';

  @override
  String get currentTheme => 'Текущая тема';

  @override
  String get saveTheme => 'Сохранить тему';

  @override
  String get showAnalysisGraph => 'Показать график анализа';

  @override
  String get analysis => 'Анализ';

  @override
  String get saveGame => 'Сохранить игру';

  @override
  String get loadGame => 'Загрузить игру';

  @override
  String get setupPosition => 'Положение установки';

  @override
  String get showLegalMoves => 'Показать возможные ходы';

  @override
  String get showLastMove => 'Показать последний ход';

  @override
  String get showArrows => 'Показать стрелки';

  @override
  String get pieces => 'Фигуры';

  @override
  String get showAnalysis => 'Показать анализ';

  @override
  String get threads => 'Потоки';

  @override
  String get getInvolved => 'Принять участие в разработке';

  @override
  String get helpImproveTranslate => 'Помогите улучшить перевод';

  @override
  String get tutorial => 'Руководство';

  @override
  String get classicMill => 'Классическая мельница';

  @override
  String get mixedMill => 'Смешанная мельница';

  @override
  String get ceylonMill => 'Цейлонская мельница';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Мельница может быть многократно сломана и переделана';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Если игрок ломает мельницу, чтобы немедленно создать новую мельницу, такой игрок может переместить такой кусок обратно к исходному соединению своим следующим ходом, если он сделает новую мельницу.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Игра считается ничьей, если у игрока есть три фишки и после десяти ходов ни один из игроков не убирает фишки соперника';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Когда у игрока осталось три фишки, и ни один из игроков не может убрать фишку соперника в течение десяти ходов, игра считается ничьей.';

  @override
  String get close => 'Закрыть';

  @override
  String get whitePiece => 'Белая фигура';

  @override
  String get blackPiece => 'Черная фигура';

  @override
  String get emptyPoint => 'Пустая точка';

  @override
  String get noPoint => 'Нет смысла';

  @override
  String get placingPhase => 'Фаза размещения';

  @override
  String get movingPhase => 'Фаза передвижения';

  @override
  String get flyingPhase => 'Фаза полета';

  @override
  String sideToMove(Object player) {
    return 'Ходит $player';
  }

  @override
  String lastMove(Object move) {
    return 'Последний ход: $move';
  }

  @override
  String get selected => 'Выбрано';

  @override
  String get accessibility => 'Доступность';

  @override
  String get screenReaderSupport => 'Поддержка программ чтения с экрана';

  @override
  String get isDraw => 'Это розыгрыш!';

  @override
  String get draw => 'Рисовать';

  @override
  String get pieceHighlightColor => 'Цвет выделенной фигуры';

  @override
  String get algorithm => 'Алгоритм';

  @override
  String get endgameNMoveRule => 'Эндшпиль N-Move правило';

  @override
  String get endgameNMoveRule_Detail =>
      'Если у любого из игроков есть только три фишки, и ни один из игроков не убирает фишку за определенный ход, игра заканчивается вничью.';

  @override
  String get drawReasonEndgameRule50 =>
      'У любого игрока есть только три фишки, и ни один из игроков не убирает фишку за определенный ход.';

  @override
  String get threefoldRepetitionRule => 'Правило тройного повторения';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Игра считается ничьей, если позиция выпадает в третий раз.';

  @override
  String get continueToMakeMove => 'Мельница! Продолжайте двигаться.';

  @override
  String get pointStyle => 'Стиль точки';

  @override
  String get pointWidth => 'Ширина точки';

  @override
  String get solid => 'Твердый';

  @override
  String get hollow => 'Пустой';

  @override
  String get languageName => 'Pусский';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Хода',
      one: '$count Ход',
      zero: 'Ходов',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Загрузка не удалась.';

  @override
  String get filename => 'Имя файла';

  @override
  String get browse => 'Просматривать…';

  @override
  String get gameFiles => 'Файлы игры';

  @override
  String get gameSavedTo => 'Игра сохраняется в';

  @override
  String get empty => 'Пустой';

  @override
  String get noMove => 'Нет движения.';

  @override
  String get restoredPosition => 'Восстановлено исходное положение.';

  @override
  String get clean => 'Чистый';

  @override
  String get cleanedUp => 'Убрано.';

  @override
  String get remove => 'Удалять';

  @override
  String get noPiecesCanBeRemoved => 'Никакие фрагменты не могут быть удалены.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Нужно удалить $count фигур.',
      many: 'Нужно удалить $count фигур.',
      few: 'Нужно удалить $count фигуры.',
      one: 'Нужно удалить $count фигуру.',
      zero: 'Нужно удалить фигуру.',
    );
    return '$_temp0';
  }

  @override
  String placedCount(int count) {
    return 'Разм. ($count)';
  }

  @override
  String get placedPieceCount =>
      'Подсчет размещенных фигур на этапе размещения.';

  @override
  String hasPlacedPieceCount(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Текущий игрок разместил $count фишки.',
      many: 'Текущий игрок разместил $count фишек.',
      few: 'Текущий игрок разместил $count фишки.',
      one: 'Текущий игрок разместил одну фишку.',
      zero: 'Текущий игрок не разместил ни одной фишки.',
    );
    return '$_temp0';
  }

  @override
  String get notPlacingPhase => 'Не размещая фазу, не может ее изменить.';

  @override
  String get paste => 'Вставить';

  @override
  String get pasteDone => 'Паста готова.';

  @override
  String get cannotPaste => 'Не могу вставить.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Показать неразмещенные и удаленные фрагменты';

  @override
  String get fullScreen => 'Полноэкранный';

  @override
  String get reopenToTakeEffect =>
      'Выйдите и снова откройте приложение, чтобы настройки вступили в силу.';

  @override
  String get forest => 'Лес';

  @override
  String get desktopImage => 'Изображение рабочего стола';

  @override
  String get invalidPosition => 'Неверная позиция.';

  @override
  String get shareGIF => 'Поделись гифкой';

  @override
  String get pixelRatio => 'Соотношение пикселей';

  @override
  String get duration => 'Продолжительность';

  @override
  String get gameScreenRecorder => 'Запись игрового экрана';

  @override
  String get previous => 'Предыдущий';

  @override
  String get next => 'Следующий';

  @override
  String get skip => 'Пропускать';

  @override
  String get gotIt => 'Понятно';

  @override
  String get youCanModifyRules =>
      'Вы можете изменить правила игры в настройках правил.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Вы можете использовать колесо мыши, чтобы изменить значение в средстве выбора.';

  @override
  String get noTimeLimitForThinking =>
      'Время обдумывания ИИ, установленное на 0, означает, что время обдумывания не ограничено.';

  @override
  String get whatIsMtdf =>
      'MTD(f) — это модифицированная форма алгоритма альфа-бета-поиска, целью которого является повышение эффективности за счет повторного использования промежуточных результатов поиска и использования хорошего начального предположения для сужения пространства поиска.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Имейте в виду, что корректировка времени обдумывания ИИ может быть не совсем точной. Фактическое время обдумывания может быть короче, если уровень сложности установлен на более низкое значение, и может быть больше, когда ИИ находится в середине размышлений, когда время истекает.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Если вы установите высокий уровень сложности, но не увеличите время обдумывания ИИ, фактический уровень сложности может быть ограничен более низким значением из-за ограничения времени обдумывания. Фактическое значение может варьироваться в зависимости от производительности машины.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) — алгоритм поиска лучшего хода в заданной позиции. Это усовершенствование альфа-бета-алгоритма, в котором используется нулевой или нулевой поиск в окне, чтобы подтвердить, что ход хуже или не хуже, чем уже безопасный результат основного варианта. PVS фокусируется на наиболее перспективных ходах и избегает ненужных поисков неоптимальных ветвей, что помогает повысить эффективность поиска.';

  @override
  String get whatIsAlphaBeta =>
      'Алгоритм альфа-бета — это поисковый алгоритм для нахождения наилучшего хода. Он использует принцип минимакса и два значения, альфа и бета, для обрезки дерева поиска и повышения эффективности. Альфа представляет собой минимальное количество очков, которое компьютер может получить, а бета представляет собой максимальное количество очков, которое может получить его противник. Алгоритм помогает компьютеру принимать разумные и эффективные решения в игре.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Согласно человеческому опыту, если вы попытаетесь выиграть, вы проиграете. Вместо этого стремитесь к ничьей в качестве своей цели и избегайте проигрыша в игре. Наблюдайте за противником и мягко заманивайте его в положение, в котором он может совершить ошибку. Когда они проявляют слабость, воспользуйтесь возможностью и осторожно подтолкните к победе. Таким образом, вы можете выиграть игру.';

  @override
  String get firstMoveDetail =>
      'В этой игре второму игроку легче выиграть, чем первому.';

  @override
  String get passiveDetail =>
      'Включение пассивной опции заставит ИИ расслабиться, когда у него есть преимущество в позиции, а не агрессивно пытаться выиграть как можно быстрее.';

  @override
  String get moveRandomlyDetail =>
      'Включение этой опции увеличивает случайность и удовольствие от игры, а ее отключение может помочь изучить способы победить ИИ.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Если ИИ учитывает подвижность своих фигур, он не только будет стремиться как можно быстрее захватить фигуры противника, но также рассмотрит возможность блокирования движений противника и предотвращения того, чтобы он делал то же самое.';

  @override
  String get whenBoardIsFull => 'Когда доска заполнена';

  @override
  String get whenBoardIsFull_Detail =>
      'В конце фазы размещения, до начала фазы перемещения, действие следует, если доска заполнена фигурами.';

  @override
  String get sideToMoveRemovePiece =>
      'Игрок, который ходит первым в фазе движения, убирает одну из фигур противника.';

  @override
  String get agreeToDraw => 'Обе стороны соглашаются на ничью.';

  @override
  String get takeOpponentsPiece => 'Возьмите одну из фигур противника.';

  @override
  String get firstPlayerLose => 'Первый игрок проигрывает.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Первый и второй игроки убирают одну из фигур соперника.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Второй и первый игроки убирают по одной из фигур соперника.';

  @override
  String get enteredFlyingPhase =>
      'Теперь наступила фаза полета, фигуры противника могут прыгнуть в любую свободную точку на доске. Вы можете отключить правило полета в «Настройках правила».';

  @override
  String get whenStalemate => 'Когда тупик';

  @override
  String get whenStalemate_Detail =>
      'Какое действие следует, если ни одна фигура не может быть перемещена?';

  @override
  String get endWithStalemateLoss =>
      'Конец с патовой потерей для стороны, которая заблокирована.';

  @override
  String get changeSideToMove => 'Меняйте сторону, чтобы двигаться.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Уберите одну из фигур соперника и сделайте следующий ход.';

  @override
  String get endWithStalemateDraw => 'Закончим патовой ничьей.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Уберите одну из фигур противника и поменяйте сторону хода.';

  @override
  String get aiResponseDelayTime => 'Время задержки ответа ИИ';

  @override
  String get aiIsDelaying =>
      'ИИ в настоящее время находится в фазе отложенного ответа. Пожалуйста, подождите некоторое время, прежде чем продолжить.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Вы не можете удалить несмежную часть.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'В случае пата фигуры противника, соседние с вашими, могут быть удалены, независимо от формации мельницы.';

  @override
  String get whatIsMcts =>
      'MCTS — это удобный для начинающих алгоритм, который принимает решения, исследуя и оценивая различные ходы с помощью симуляций.';

  @override
  String get goldenJade => 'Золотой нефрит';

  @override
  String get forestWood => 'Лесная древесина';

  @override
  String get darkMystery => 'Темная тайна';

  @override
  String get midnightBlue => 'Темно-синий';

  @override
  String get greenForest => 'Зеленый лес';

  @override
  String get greenMeadow => 'Зеленый луг';

  @override
  String get stonyPath => 'Каменистая тропа';

  @override
  String get pastelPink => 'Пастельно-розовый';

  @override
  String get turquoiseSea => 'Бирюзовое море';

  @override
  String get violetDream => 'фиолетовый сон';

  @override
  String get mintChocolate => 'Мятный шоколад';

  @override
  String get skyBlue => 'Голубое небо';

  @override
  String get playfulGarden => 'Игривый сад';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Алгоритм ретроградного анализа использует многозначный ретроградный анализ для создания базы данных эндшпиля с разных начальных позиций, а затем применяет эту базу данных для оптимизации игрового процесса. Этот подход относится к категории сверхсильных решений.';

  @override
  String get viewAlgorithmGuide =>
      'Хотите просмотреть руководство пользователя для этого алгоритма?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Показать индикатор позиционного преимущества';

  @override
  String get usePerfectDatabase => 'Использование идеальной базы данных';

  @override
  String get perfectDatabaseDescription =>
      'Включите эту опцию, чтобы использовать безупречную базу данных игр, созданную с помощью передовых алгоритмов. Эта функция интегрирует стратегии начала игры и финальной стадии для предложения оптимальных ходов. Это предпочтительный выбор для игроков, которые ищут максимальную точность в игре. База данных разработана с помощью тщательных вычислительных методов и предназначена для предложения почти идеальных игровых решений.\n\nПримечание: Если искусственному интеллекту не удастся получить доступ к базе данных, он переключится на традиционные алгоритмы для принятия игровых решений. Когда база данных доступна, уровень сложности становится практически непобедимым, а время на \"Размышления AI\" существенно сокращается. Многие настройки в опциях \"Стиль игры AI\" будут переопределены, так как результаты базы данных имеют наивысший приоритет.\n\nДля рекомендаций по максимально эффективному использованию этой безупречной базы данных нажмите сюда.';

  @override
  String get backgroundImage => 'Фоновое изображение';

  @override
  String get whatIsRandom =>
      'Когда опция \"Использовать идеальную базу данных\" не активирована, настройка \"Случайность\" заставляет ИИ перемещать фигуры случайным образом, не используя никаких алгоритмов для выбора ходов. Это обычно приводит к значительно слабой игре. Напротив, когда активирована опция \"Использовать идеальную базу данных\", ИИ полностью опирается на \"Идеальную базу данных\" для принятия решений, а не смешивает её с традиционными алгоритмами ИИ. В этом режиме все действия ИИ полностью основаны на содержании базы данных, избегая зависимости от реальных расчетов или поисковых алгоритмов.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Уберите фигуру(ы) противника из его руки; затем наступает очередь противника разместить фигуру.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'При формировании мельниц в фазе размещения';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Уберите фигуру(ы) противника с доски.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Уберите фигуру(ы) противника с доски; затем наступает очередь противника разместить фигуру.';

  @override
  String get opponentRemovesOwnPiece =>
      'Противник убирает свою фигуру(ы) с доски.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Вместо вашего действия, противник выбирает и убирает свою фигуру(ы) с доски, эффективно совершая действие, вредное для себя.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Уберите фигуру(ы) противника из его руки; затем ваш ход.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Уберите фигуру(ы) из руки противника. Если согласно настройке Multi-remove должно быть убрано несколько фигур и у противника не осталось фигур в руке, продолжайте убирать фигуры противника с доски. Затем ваш ход. Если вы продолжаете формировать мельницы, вы можете продолжать убирать фигуры противника.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Уберите фигуру(ы) из руки противника. Если согласно настройке Multi-remove должно быть убрано несколько фигур и у противника не осталось фигур в руке, продолжайте убирать фигуры противника с доски. Затем ход противника.';

  @override
  String get markAndDelayRemovingPieces =>
      'Отметьте и задержите удаление фигур.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Во время фазы размещения фигуры, которые должны быть убраны, отмечаются, и оба игрока не могут размещать новые фигуры на этих точках. При входе в фазу перемещения эти отмеченные фигуры убираются полностью, и игроки могут затем перемещать свои фигуры на эти теперь пустые точки.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Действия, которые можно предпринять во время формирования мельниц на этапе размещения.';

  @override
  String get marked => 'Отмечено';

  @override
  String get menu => 'Меню';

  @override
  String get monochrome => 'Монохром';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Вы можете включить поддержку экранного диктора в настройках доступности в общих настройках.';

  @override
  String get showNumbersOnPieces => 'Показать номера на фигурах';

  @override
  String get saveImage => 'Сохранить изображение';

  @override
  String get isAnalysisToolbarShown => 'Показать панель инструментов анализа';

  @override
  String get analysisToolbarBackgroundColor =>
      'Цвет фона панели инструментов анализа';

  @override
  String get analysisToolbarIconColor =>
      'Цвет иконки панели инструментов анализа';

  @override
  String get transformed => 'Трансформировано.';

  @override
  String get cannotTransform => 'Невозможно трансформировать.';

  @override
  String get rotate => 'Повернуть';

  @override
  String get horizontalFlip => 'H Перев';

  @override
  String get verticalFlip => 'V Перев';

  @override
  String get innerOuterFlip => 'IO Перев';

  @override
  String get transparentCanvas => 'Прозрачное Полотно';

  @override
  String get restrictRepeatedMillsFormation =>
      'Ограничить повторное образование мельниц';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Фигура, перемещённая с одной мельницы на другую, не может сразу вернуться в исходную точку на следующем ходу, чтобы снова сформировать мельницу. Сначала требуется другой ход.';

  @override
  String get oneTimeUseMill => 'Одноразовая мельница';

  @override
  String get oneTimeUseMill_Detail =>
      'Каждая мельница может удалить только одну часть соперника. Вы можете реформировать его снова, но его нельзя использовать для дополнительных удалений.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Текущие правила, которые вы установили, не имеют соответствующей идеальной базы данных. Для получения дополнительной информации об идеальной базе данных нажмите здесь.';

  @override
  String get focusOnBlockingPaths => 'Сосредоточьтесь на блокировке путей';

  @override
  String get focusOnBlockingPaths_Detail =>
      'В определенные фазы игры отдавайте приоритет препятствию движению противника, а не созданию мельниц. Вместо того чтобы сосредотачиваться на удалении фигурок, завершая мельницы, ИИ стремится поймать противника в ловушку во время этих фаз, лишая его возможности двигаться и обеспечивая победу путем изнурения, а не агрессивной игры. Эта стратегия, специфическая для определенных фаз, не активно блокирует мельницы противника.';

  @override
  String get pieceImage => 'Изображение фигуры';

  @override
  String get importColorSettings => 'Импорт настроек цвета';

  @override
  String get exportColorSettings => 'Экспорт настроек цвета';

  @override
  String get import => 'Импорт';

  @override
  String get export => 'Экспорт';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Пожалуйста, сначала скопируйте настройки формата JSON в буфер обмена.';

  @override
  String get copiedToClipboard => 'Скопировано в буфер обмена.';

  @override
  String get imported => 'Импортировано.';

  @override
  String get boardImage => 'Изображение доски';

  @override
  String get autumnLeaves => 'Осенние Листья';

  @override
  String get legendaryLand => 'Легендарная Земля';

  @override
  String get vignetteEffect => 'Эффект виньетки';

  @override
  String get promptMakeToolbarTransparent =>
      'Вы хотите сделать панель инструментов полностью прозрачной, когда установлено фоновое изображение доски?';

  @override
  String get vibration => 'Включить вибрацию в игре';

  @override
  String get soundTheme => 'Тема звука';

  @override
  String get ball => 'Мяч';

  @override
  String get liquid => 'Жидкость';

  @override
  String get wood => 'Дерево';

  @override
  String get placeEffectAnimation =>
      'Анимационный эффект при размещении фигуры';

  @override
  String get removeEffectAnimation => 'Анимационный эффект при удалении фигуры';

  @override
  String get isToolbarAtBottom => 'Показать панель инструментов внизу';

  @override
  String get boardCornerRadius => 'Радиус угла доски';

  @override
  String get useOpeningBook => 'Использовать книгу открытий';

  @override
  String get currentRule => 'Текущий';

  @override
  String get nineMensMorris => 'Девять мужчин Моррис';

  @override
  String get twelveMensMorris => 'Двенадцать мужчин Моррис';

  @override
  String get morabaraba => 'Морабараба';

  @override
  String get dooz => 'Доз';

  @override
  String get chamGonu => 'Чамгону';

  @override
  String get zhiQi => 'Чжици';

  @override
  String get chengSanQi => 'Чэнсанци';

  @override
  String get mulMulan => 'Мул-Мулан';

  @override
  String get nerenchi => 'Неренчи';

  @override
  String get ruleSet => 'Набор правил';

  @override
  String get laskerMorris => 'Ласкер Моррис';

  @override
  String get oneTimeMill => 'Мельница';

  @override
  String get daSanQi => 'Дацци';

  @override
  String get useOpeningBook_Detail =>
      'Позвольте ИИ использовать начальные ходы, которые часто применяются профессиональными человеческими игроками на раннем этапе игры. Примечание: Эта функция в настоящее время доступна только для определенных наборов правил.';

  @override
  String get showAdvantageGraph => 'Показать график преимущества';

  @override
  String get advantageGraphHint =>
      'График преимущества будет нарисован только после того, как ИИ сделает ход. Он не будет нарисован, когда ход сделает человек-игрок.';

  @override
  String get removalBasedOnMillCounts =>
      'Отключите удаление, пока все фишки не будут размещены, затем удаляйте фишки в соответствии с количеством построенных мельниц.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Отключите удаление, пока все фишки не будут размещены, затем удаляйте фишки в соответствии с количеством построенных мельниц: если количество совпадает, оба игрока удаляют одинаковое число фишек; если у одного больше, он удаляет на одну фишку больше, сохраняя разницу в одну. Если мельницы образует только один, он убирает две фишки, а другой одну. Если никто не образует мельниц, оба убирают по одной фишке.';

  @override
  String get elfilja => 'Эль Фильджа';

  @override
  String get tipSelectOwnPiece => 'Выберите одну из своих фигур.';

  @override
  String get notYourTurn => 'Сейчас не ваш ход.';

  @override
  String get annotationToolbarBackgroundColor => 'Цвет фона панели аннотаций';

  @override
  String get annotationToolbarIconColor => 'Цвет иконок панели аннотаций';

  @override
  String get isAnnotationToolbarShown => 'Показать панель аннотаций';

  @override
  String get enterAnnotationMode => 'Войти в режим аннотаций';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Вы уверены, что хотите удалить все аннотации?';

  @override
  String get llmPromptCopiedToClipboard =>
      'Подсказка LLM скопирована в буфер обмена.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Соединение отклонено, сервер может быть недоступен.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Обнаружение успешно, ожидание соединения...';

  @override
  String get noLanConnection => 'Нет подключения к локальной сети';

  @override
  String get takeScreenshot => 'Сделать скриншот';

  @override
  String get disconnectedFromOpponent => 'Отключено от противника.';

  @override
  String get takeBackRequest => 'Запрос на возврат хода';

  @override
  String get nothingToShow => 'Нечего показывать.';

  @override
  String get stopHosting => 'Остановить хостинг';

  @override
  String get connectionResetByPeer => 'Соединение сброшено пиром.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Соединение потеряно из-за таймаута heartbeat. Пожалуйста, переподключитесь.';

  @override
  String get startHosting => 'Начать хостинг';

  @override
  String get restartRequestRejected => 'Запрос на перезапуск отклонен.';

  @override
  String get notConnectedToLanOpponent =>
      'Не подключено к противнику в локальной сети.';

  @override
  String get llmPrompt => 'Подсказка LLM';

  @override
  String get gameRestarted => 'Игра перезапущена.';

  @override
  String get takeBackRejected => 'Возврат хода отклонен.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Вы уверены, что хотите сдаться в этой игре?';

  @override
  String get opponentResignedYouWin => 'Противник сдался. Вы выиграли!';

  @override
  String get clearAllAnnotations => 'Удалить все аннотации';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Подключено, ожидание хода противника...';

  @override
  String get networkStatusDisconnected => 'Статус сети: Отключено';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Запрос на возврат хода отправлен противнику.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Противник, возможно, покинул игру';

  @override
  String get connectedToHostSuccessfully => 'Успешно подключено к хосту.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Соединение потеряно: таймаут heartbeat';

  @override
  String get noHostDiscovered => 'Хост не обнаружен.';

  @override
  String get confirmResignation => 'Подтвердить сдачу';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Начало хостинга игры, ожидание присоединения игроков...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Соединение истекло, сетевое соединение нестабильно.';

  @override
  String get noLlmPromptAvailable => 'Подсказка LLM недоступна.';

  @override
  String get youResignedGameOver => 'Вы сдались. Игра окончена.';

  @override
  String get serverIp => 'IP сервера';

  @override
  String get confirmClear => 'Подтвердить очистку';

  @override
  String get opponentSTurn => 'Ход противника.';

  @override
  String get waitingAClientConnection => 'Ожидание подключения клиента...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Запрос на возврат хода был отклонен или не удался.';

  @override
  String get addText => 'Добавить текст';

  @override
  String get exitAnnotationMode => 'Выйти из режима аннотаций';

  @override
  String get typeYourAnnotation => 'Введите вашу аннотацию';

  @override
  String get attemptingToReconnect => 'Попытка переподключения...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Запрос на перезапуск отправлен. Ожидание ответа противника...';

  @override
  String get serverIsStopped => 'Сервер остановлен.';

  @override
  String get restartRequest => 'Запрос на перезапуск';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Нельзя запросить возврат хода, когда не ваш ход.';

  @override
  String get takeBackAccepted => 'Возврат хода принят.';

  @override
  String get localNetworkSettings => 'Настройки локальной сети';

  @override
  String get reconnectedSuccessfully => 'Успешно переподключено!';

  @override
  String get failedToSaveImageToGallery =>
      'Не удалось сохранить изображение в галерею.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Противник запросил перезапуск игры. Вы принимаете?';

  @override
  String get yourTurn => 'Ваш ход.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Невозможно переподключиться, пожалуйста, перезапустите игру.';

  @override
  String get host => 'Хост';

  @override
  String get join => 'Присоединиться';

  @override
  String get port => 'Порт';

  @override
  String get invalidIpAddress => 'Неверный IP-адрес.';

  @override
  String get invalidPort => 'Неверный порт.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Попытка подключения: $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Не удалось подключиться: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Не удалось начать хостинг: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Хост обнаружен: $ip:$port';
  }

  @override
  String get stop => 'Остановить';

  @override
  String get discover => 'Обнаружить';

  @override
  String get connect => 'Подключиться';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Клиент подключен: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Обнаружение: $seconds с';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Переподключение ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Подключено';

  @override
  String get delete => 'Удалить';

  @override
  String get ancientEgypt => 'Древний Египет';

  @override
  String get gothicIce => 'Готический Лёд';

  @override
  String get riceField => 'Рисовое Поле';

  @override
  String get chinesePorcelain => 'Китайский Фарфор';

  @override
  String get desertDusk => 'Пустынные Сумерки';

  @override
  String get precisionCraft => 'Точное Ремесло';

  @override
  String get folkEmbroidery => 'Народная Вышивка';

  @override
  String get carpathianHeritage => 'Карпатское Наследие';

  @override
  String get imperialGrandeur => 'Имперское Величие';

  @override
  String get bohemianCrystal => 'Богемский Хрусталь';

  @override
  String get savannaSunrise => 'Саванный Рассвет';

  @override
  String get harmonyBalance => 'Гармония и Баланс';

  @override
  String get cinnamonSpice => 'Коричная Специя';

  @override
  String get anatolianMosaic => 'Анатолийская Мозаика';

  @override
  String get carnivalSpirit => 'Карнавальный Дух';

  @override
  String get custom => 'Обычай';

  @override
  String get spiceMarket => 'Рынок специй';

  @override
  String get swipeToRevealTheDrawer => 'Проведите, чтобы открыть ящик';

  @override
  String get showGameInfoOnScreenshots =>
      'Показывать информацию об игре на скриншотах';

  @override
  String get humanMoveTime => 'Лимит времени для человека';

  @override
  String get noTimeLimitForHumanMoves =>
      'Нет лимита времени для ходов человека';

  @override
  String get timeoutLoseWillBeApplied =>
      'Для игрока-человека будет применено поражение по таймауту';

  @override
  String get identifyingBoard => 'Идентификация игровой доски...';

  @override
  String get youCanEnterAnyModelName =>
      'Вы можете ввести любое название модели.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Позиция доски применена. FEN скопирован в буфер обмена.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Совет: попробуйте сделать более чёткое фото доски.';

  @override
  String get llmPromptTemplate => 'Шаблон запроса LLM';

  @override
  String get noValidBoardDetected => 'Не обнаружена корректная доска.';

  @override
  String get selectingImageFromAlbum => 'Выбор изображения из альбома...';

  @override
  String get configurePromptTemplate => 'Настроить шаблон запроса';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Редактировать шаблон запроса для анализа LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Не удалось сгенерировать FEN из распознанной доски.';

  @override
  String get outputInCurrentLanguage => 'Вывод на текущем языке';

  @override
  String get commonBaseUrls => 'Общие Base URL';

  @override
  String get viewCommonModels => 'Просмотреть общие модели';

  @override
  String get recognitionParametersUpdated =>
      'Параметры распознавания обновлены.';

  @override
  String get whiteSMove => 'Ход белых';

  @override
  String get resetToDefaults => 'Сбросить к значениям по умолчанию';

  @override
  String get photoShoot => 'Фотосъемка';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Не удалось применить распознанную позицию доски.';

  @override
  String get llmPromptContent => 'Содержимое запроса LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM не настроен. Проверьте настройки.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Указать поставщика, модель, API Key и Base URL';

  @override
  String get llmConfiguration => 'Конфигурация LLM';

  @override
  String get configureLlmProvider => 'Настроить поставщика LLM';

  @override
  String get llmPromptTemplateHeader => 'Заголовок шаблона запроса LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Ни одной фигуры не распознано на изображении. Попробуйте снова.';

  @override
  String get recognizeBoardFromImage => 'Распознать доску с изображения';

  @override
  String get viewTips => 'Просмотреть советы';

  @override
  String get applyToBoard => 'Применить к доске';

  @override
  String get adjustBoardArea => 'Настроить область доски';

  @override
  String get viewCommonUrls => 'Просмотреть общие URL';

  @override
  String get colorAnalysisFailed => 'Анализ цвета не удался!';

  @override
  String get analyzingGameBoardImage => 'Анализ изображения игровой доски...';

  @override
  String get selectFromAlbum => 'Выбрать из альбома';

  @override
  String get noBoardPointDetected => 'Точка на доске не обнаружена!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Если оставить пустым, будет использован шаблон по умолчанию';

  @override
  String get llmConfig => 'Конфигурация LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Вы уверены, что хотите сбросить шаблоны запросов до значений по умолчанию?';

  @override
  String get llmPromptTemplateFooter => 'Нижний колонтитул шаблона запроса LLM';

  @override
  String get loadingResponse => 'Загрузка ответа...';

  @override
  String get applyThisResultToBoard => 'Применить этот результат к доске';

  @override
  String get takingPicture => 'Съемка фото...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Пожалуйста, выберите изображение игровой доски для распознавания';

  @override
  String get identificationResults => 'Результаты идентификации';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Проанализируйте ходы и предоставьте информацию.';

  @override
  String get getApiKey => 'Получить API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Весь процесс распознавания не был завершен.';

  @override
  String get boardRecognitionResult => 'Результат распознавания доски';

  @override
  String get askLlm => 'Спросить LLM';

  @override
  String get boardDetectionFailed => 'Обнаружение доски не удалось!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Точка на доске не обнаружена, невозможно распознать фигуру!';

  @override
  String get copyFen => 'Скопировать FEN';

  @override
  String get commonlyUsedModels => 'Часто используемые модели';

  @override
  String get apiKeyOptional => 'API Key (необязательно)';

  @override
  String get noImageSelected => 'Изображение не выбрано';

  @override
  String get blackSMove => 'Ход черных';

  @override
  String get llm => 'Большая языковая модель';

  @override
  String get llmProvider => 'Поставщик';

  @override
  String get baseUrl => 'Базовый URL';

  @override
  String get model => 'Модель';

  @override
  String get temperature => 'Температура';

  @override
  String get llmCommandReceivedProcessing =>
      'Команда получена! ИИ обрабатывает...';

  @override
  String get llmDeepThinkingWait =>
      'Идёт глубокое мышление, пожалуйста, подождите...';

  @override
  String get llmPresentingSoon => 'Скоро будет представлено...';

  @override
  String get recognitionParameters => 'Параметры распознавания';

  @override
  String get adjustParamsDesc =>
      'Настройте параметры для повышения точности распознавания';

  @override
  String get saveParameters => 'Сохранить параметры';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Не удалось запустить распознавание изображения: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Сбой распознавания изображения: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Применена позиция с $whiteCount белыми и $blackCount черными фишками';
  }

  @override
  String get fenCopiedToClipboard => '(FEN скопирован в буфер обмена)';

  @override
  String recognitionFailed(String error) {
    return 'Ошибка распознавания: $error';
  }

  @override
  String get myRating => 'Мой рейтинг';

  @override
  String get gamesPlayed => 'Сыграно игр';

  @override
  String get wins => 'Победы';

  @override
  String get losses => 'Поражения';

  @override
  String get draws => 'Ничьи';

  @override
  String get lastUpdated => 'Последнее обновление';

  @override
  String get format => 'Формат:';

  @override
  String get resetStatistics => 'Сбросить статистику';

  @override
  String get drawRate => 'Процент ничьих';

  @override
  String get lossRate => 'Процент поражений';

  @override
  String get aiStatistics => 'Статистика ИИ';

  @override
  String get enableStatistics => 'Включить статистику';

  @override
  String get enableStatistics_Detail =>
      'Если включено, результаты игр будут записываться в статистику. Однако игры, включающие возвраты ходов, записываться не будут. Если отключено, сбор статистики приостанавливается.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Это сбросит всю статистику игры. Это действие нельзя отменить.';

  @override
  String get boardInnerRingSize => 'Размер внутреннего кольца доски';

  @override
  String get boardShadowEnabled => 'Тень доски';

  @override
  String get trapAwareness => 'Обнаружение ловушек';

  @override
  String get trapAwarenessDescription =>
      'Выделяйте ходы-ловушки жирными кругами и стрелками во время анализа.';

  @override
  String trapExists(String trapMoves) {
    return 'Есть ловушка. Ходы-ловушки: $trapMoves';
  }

  @override
  String get custodianCapture => 'Фланговый захват';

  @override
  String get custodianCaptureDescription =>
      'Поместите одну из фигур соперника между двумя своими по прямой линии, чтобы снять её.';

  @override
  String get custodianCaptureEnable => 'Разрешить фланговый захват';

  @override
  String get interventionCapture => 'Захват вмешиванием';

  @override
  String get interventionCaptureDescription =>
      'Перейдите на пустую точку между двумя фигурами соперника, чтобы снять их обе.';

  @override
  String get interventionCaptureEnable => 'Разрешить захват вмешиванием';

  @override
  String get leapCapture => 'Прыжковый захват';

  @override
  String get leapCaptureDescription =>
      'Перепрыгните через соседнюю фигуру соперника на пустую точку за ней, чтобы снять её.';

  @override
  String get leapCaptureEnable => 'Разрешить прыжковый захват';

  @override
  String get captureApplicableLines => 'Применимые линии';

  @override
  String get captureSquareEdges => 'Вдоль краев квадрата';

  @override
  String get captureCrossLines =>
      'Вдоль ортогональных линий, пересекающих квадрат';

  @override
  String get captureDiagonalLines =>
      'Вдоль диагональных линий, пересекающих квадрат';

  @override
  String get captureExecutionPhases => 'Фазы исполнения';

  @override
  String get capturePiecesCondition =>
      'Доступность в фазе перемещения в зависимости от числа оставшихся фигур';

  @override
  String get capturePiecesConditionUnlimited => 'Без ограничений';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Доступно, если у вас осталось три или меньше фигур';
}
