// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Romanian Moldavian Moldovan (`ro`).
class SRo extends S {
  SRo([String locale = 'ro']) : super(locale);

  @override
  String get appName => 'Moară';

  @override
  String get welcome => 'Bun venit';

  @override
  String get yes => 'da';

  @override
  String get no => 'Nu';

  @override
  String get game => 'Joc';

  @override
  String get humanVsAi => 'Uman Vs. AI';

  @override
  String get humanVsHuman => 'Uman Vs. Uman';

  @override
  String get aiVsAi => 'AI Vs. AI';

  @override
  String get humanVsCloud => 'Uman Vs. Cloud';

  @override
  String get humanVsLAN => 'Uman Vs. LAN';

  @override
  String get testViaLAN => 'Testați prin LAN';

  @override
  String get move => 'Mutare';

  @override
  String get showMoveList => 'Vezi lista de mutări';

  @override
  String get moveList => 'Lista de mutări';

  @override
  String get noGameRecord => 'Nicio înregistrare';

  @override
  String get ok => 'OK';

  @override
  String get confirm => 'Confirmare';

  @override
  String get cancel => 'Anulare';

  @override
  String get tipSelectWrong => 'Selectați piesa greșită.';

  @override
  String get tipPlace => 'Așează-ți piesele.';

  @override
  String get tipBanPlace => 'Nu o poți plasa aici.';

  @override
  String get tipPlaced => 'Plasat.';

  @override
  String get tipRemove => 'Îndepărtează o piesă.';

  @override
  String get tipBanRemove => 'Nu poate fi îndepărtată.';

  @override
  String get tipRemoved => 'Îndepărtată.';

  @override
  String get tipMove => 'Mută o piesă.';

  @override
  String get tipCannotPlace => 'Nu-ți poți așeza piesa aici.';

  @override
  String get tipCannotMove => 'Nu-ți poți muta piesa aici.';

  @override
  String get tipMill => 'Moară! Îndepărtează una dintre piesele adversarului.';

  @override
  String get tipContinueMill => 'Continuă să îndepărtezi piesa adversarului.';

  @override
  String get tipSelectOpponentsPiece =>
      'Selectează una dintre piesele adversarului.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Nu poți îndepărta o piesă dintr-o moară.';

  @override
  String get tipCanMoveOnePoint =>
      'O piesă poate fi mișcată doar pe punctul imediat învecinat.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Piesele adversarului nu pot fi mișcate.';

  @override
  String get tipSelectPieceToMove => 'Selectează piesa de mutat.';

  @override
  String get tipHaveThreePiecesLeft => 'Mai ai 3 piese.';

  @override
  String get tipCanMoveToAnyPoint => 'Poți sări pe orice punct liber.';

  @override
  String tipToMove(Object player) {
    return '$player pentru a muta.';
  }

  @override
  String get whiteWin => 'Jucătorul 1 câștigă!';

  @override
  String get blackWin => 'Jucătorul 2 câștigă!';

  @override
  String get won => 'Câștigă';

  @override
  String get lost => 'Pierde';

  @override
  String get thinking => 'Cugetare…';

  @override
  String get newGame => 'Joc nou';

  @override
  String get importGame => 'Importare joc';

  @override
  String get exportGame => 'Exportare joc';

  @override
  String get gameImported => 'Joc importat.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Nu se poate importa $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Mișcările și regulile nu se potrivesc.';

  @override
  String get pleaseWait => 'Te rog asteaptă...';

  @override
  String get restartGame => 'Repornești jocul curent?';

  @override
  String get restart => 'Repornire';

  @override
  String get gameStarted => 'Jocul a început, te rog așează piesă.';

  @override
  String get analyzing => 'Analizare…';

  @override
  String error(Object message) {
    return 'Eroare: $message';
  }

  @override
  String get winRate => 'Rata de câștig';

  @override
  String get score => 'Scor:';

  @override
  String get white => 'Jucătorul 1';

  @override
  String get black => 'Jucătorul 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player numărul de piese este mai mic de trei.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player a demisionat.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player nu are cum să meargă.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Placa este plină și $player nu are nicio cale de rezolvat.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Timpul a trecut, $player pierdut.';
  }

  @override
  String get drawReasonRule50 =>
      'În timpul ultimelor N mișcări nicio piesă nu a fost înlăturată.';

  @override
  String get drawReasonBoardIsFull => 'Este remiză, tabla fiind plină.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Este remiză, mutare repetată de trei ori.';

  @override
  String get gameOverUnknownReason => 'Joc încheiat! Motiv necunoscut.';

  @override
  String get gameOver => 'Joc încheiat';

  @override
  String get youWin => 'Ai castigat! Felicitări!';

  @override
  String challengeHarderLevel(int level) {
    return 'Provocare la nivel mai greu? Noul nivel va fi nivelul $level!';
  }

  @override
  String get youLose => 'Ai pierdut!';

  @override
  String get analyze => 'Analiză';

  @override
  String get about => 'Despre aplicație';

  @override
  String version(Object versionNumber) {
    return 'Versiune: $versionNumber';
  }

  @override
  String get thanks => 'Mulțumiri';

  @override
  String get settings => 'Setări';

  @override
  String get options => 'Opțiuni';

  @override
  String get generalSettings => 'Setări generale';

  @override
  String get skillLevel => 'Nivel de dificultate';

  @override
  String get moveTime => 'Timpul de gândire al lui AI';

  @override
  String get difficulty => 'Dificultate';

  @override
  String get playSounds => 'Efecte sonore';

  @override
  String get playSoundsInTheGame => 'Redare sunete în joc';

  @override
  String get keepMuteWhenTakingBack => 'Menține sunetul oprit la revenire';

  @override
  String get tone => 'Ton';

  @override
  String get whoMovesFirst => 'Prima mișcare';

  @override
  String get human => 'Uman';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Alternare';

  @override
  String get isAutoRestart =>
      'Reporniți automat jocul la finalizarea jocului actual';

  @override
  String get isAutoChangeFirstMove =>
      'Schimbă automat primul jucător la sfârșitul jocului';

  @override
  String get shufflingEnabled => 'Miscare aleatorie';

  @override
  String get misc => 'Diverse';

  @override
  String get rules => 'Reguli';

  @override
  String get piecesCount => 'Număr de piese pe jucător';

  @override
  String get piecesCount_Detail => 'Câte piese are fiecare jucător?';

  @override
  String get flyPieceCount => 'Numărul pieselor (flying) cu drum liber';

  @override
  String get flyPieceCount_Detail =>
      'La Flying activat, și când jucătorul are un număr redus prestabilit de piese, acestea sunt libere să se deplaseze în orice punct neocupat.';

  @override
  String get piecesAtLeastCount => 'Număr minim de piese';

  @override
  String get hasDiagonalLines => 'Liniile diagonale';

  @override
  String get hasDiagonalLines_Detail =>
      'Adăugați patru linii diagonale pe tablă - unind colțurile celor trei patrulatere concentrice.';

  @override
  String get isDefenderMoveFirst => 'Al doilea jucător mută primul';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Jucătorul care este al doilea în plasare, devine primul în faza de mutare.';

  @override
  String get mayRemoveMultiple => 'Morișcă (moară dublă)';

  @override
  String get mayRemoveMultiple_Detail =>
      'Dacă un jucător cu aceeași piesă închide mai mult de o moară simultan, poate elimina de la adversar atâtea piese, câte mori a realizat.';

  @override
  String get mayRemoveFromMillsAlways => 'Distruge mori';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'În mod implicit, jucătorii trebuie mai întâi să elimine orice alte piese înainte de a îndepărta o piesă dintr-o moară formată. Activați această opțiune pentru a dezactiva această limitare.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Al doilea jucător pierde când tabla este plină';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Dacă la sfârșitul fazei de plasare, se umple tabla, jucătorul care a plasat primul pierde jocul (neavând posibilitate de mișcare), altfel ar fi remiză.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Pierde atunci când nu se mișcă legal';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Jucătorul va pierde dacă adversarul său îi blochează în așa fel încât să nu poată muta (neavând câmp liber). Schimbă, dacă obțiunea este dezactivată.';

  @override
  String get mayFly => 'Sărituri';

  @override
  String get mayFly_Detail =>
      'Dacă un jucător mai are doar trei sau patru piese (configurabile), poate sări cu acestea în orice punct liber.';

  @override
  String get nMoveRule => 'Regula N-move';

  @override
  String get nMoveRule_Detail =>
      'Jocul este extras dacă nu a existat nicio eliminare într-un anumit număr de mișcări de către fiecare jucător.';

  @override
  String get rollback => 'Revenire';

  @override
  String get pleaseSelect => 'Te rog selecteaza';

  @override
  String get copy => 'Copie';

  @override
  String get moveHistoryCopied => 'Istoricul mutărilor copiat în clipboard.';

  @override
  String get help => 'Ajutor';

  @override
  String get feedback => 'Feedback';

  @override
  String get exit => 'Ieșire';

  @override
  String get ruleSettings => 'Setări reguli';

  @override
  String get color => 'Culoare';

  @override
  String get boardColor => 'Culoarea plăcii';

  @override
  String get pieceColor => 'Culoarea piesei';

  @override
  String get backgroundColor => 'Culoare de fundal';

  @override
  String get lineColor => 'Culoarea liniilor tablei de joc';

  @override
  String get whitePieceColor => 'Culoare piesă Jucător 1';

  @override
  String get blackPieceColor => 'Culoare piesă Jucător 2';

  @override
  String get messageColor => 'Culoarea mesajului';

  @override
  String get isPieceCountInHandShown =>
      'Afișați numărul de piese din mână (neplasate)';

  @override
  String get isNotationsShown => 'Afișați notațiile pe bord';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Afișați istoricul navigației pe bara de instrumente';

  @override
  String get display => 'Afişaj';

  @override
  String get boardBorderLineWidth => 'Lățimea marginii tablei de joc';

  @override
  String get boardInnerLineWidth => 'Lățimea liniilor interioare';

  @override
  String get pieceWidth => 'Lățimea piesei';

  @override
  String get fontSize => 'Mărimea literei';

  @override
  String get standardNotation => 'Notare WMD';

  @override
  String get restore => 'Revenire';

  @override
  String get restoreDefaultSettings => 'Restabilește setările implicite';

  @override
  String pick(Object element) {
    return 'Alege $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Aluzie';

  @override
  String get player => 'jucător';

  @override
  String get player1 => 'Jucătorul 1';

  @override
  String get player2 => 'Jucătorul 2';

  @override
  String get howToPlay => 'Mersul jocului';

  @override
  String get toPlacePiece =>
      'Atinge orice punct disponibil pentru a plasa o piesă.';

  @override
  String get toSelectPiece => 'Atinge piesa pe care vrei s-o muți.';

  @override
  String get toMovePiece => 'Atinge punctul pe care vrei să plasezi piesa.';

  @override
  String get toRemovePiece =>
      'Atinge o piesă a adversarului pentru a o elimina.';

  @override
  String get needToCreateMillFirst =>
      'Numai după o moară creată poți îndepărta o piesă.';

  @override
  String get needToPlayWithOwnPieces => 'Doar cu pieseletale poți juca.';

  @override
  String get statistics => 'Statistici';

  @override
  String get totalGames => 'Total jocuri';

  @override
  String get results => 'Rezultate';

  @override
  String get left => 'stânga';

  @override
  String get privacyPolicy => 'Politica de Confidențialitate';

  @override
  String get privacyPolicy_Detail_1 =>
      'Citiți cu atenție și asigurați-vă că înțelegeți și sunteți de acord cu acest lucru ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Dacă nu sunteți de acord cu această politică, vă rugăm să nu utilizați această aplicație. Utilizarea aplicației implică acceptarea acestor termeni.';

  @override
  String get and => ' și ';

  @override
  String get accept => 'Acceptare';

  @override
  String get takeBack => 'Ia înapoi';

  @override
  String get takingBack => 'Luând înapoi…';

  @override
  String get waiting => 'Aşteptare…';

  @override
  String get stepForward => 'Pasul înainte';

  @override
  String get takeBackAll => 'Ia înapoi toate';

  @override
  String get stepForwardAll => 'Fă un pas înaintea tuturor';

  @override
  String get moveNow => 'Mută acum';

  @override
  String get done => 'Terminat.';

  @override
  String get crackMill => 'Moară deschisă';

  @override
  String get crackMill_Detail =>
      'Dacă un jucător are doar piese în mori, acestea nu sunt exceptate de le eliminare.';

  @override
  String get animationDuration => 'Durata animației';

  @override
  String get none => 'Nici unul';

  @override
  String get theme => 'Temă';

  @override
  String get helpContent =>
      'Jocul își propune să lase adversarul cu mai puțin de trei piese sau fără posibilitatea de mutări legale.\n\nJocul este automat suspendat dacă o mutare se repetă de trei ori, sau dacă pe parcursul a 100 de mutări consecutive nu se îndepărtează nici o piesă, adică nu se realizează moară.\n\nJocul se desfășoară în trei faze:\n\n1. Așezarea pieselor pe punctele libere\n2. Mutarea pieselor în punctele adiacente\n3. (fază opțională) Mutarea pieselor în orice punct liber când jucătorul a fost redus la trei piese\n\nPlasarea\n\nJocul începe cu o tablă goală, care constă dintr-o grilă cu douăzeci și patru de puncte. Jucătorii își așează pe rând piesele pe punctele libere până când fiecare jucător a plasat toate piesele pe tablă. Dacă un jucător poate plasa trei dintre piesele sale în linie dreaptă, el are o „moară” și poate scoate una din piesele adversarului său de pe tablă.\n\nÎn unele variante de reguli, jucătorii trebuie să elimine mai întâi orice alte piese înainte de a scoate o piesă dintr-o moară formată.\n\nÎn unele variante de reguli, toate punctele pieselor îndepărtate pot să nu fie plasate din nou în fraza de plasare.\n\nOdată ce toate piesele au fost folosite, jucătorii se deplasează pe rând.\n\nIn miscare\n\nPentru a muta, un jucător mută una dintre piesele sale de-a lungul unei linii de bord până la un punct adiacent vacant. Dacă nu poate face acest lucru, a pierdut jocul. Ca și în faza de plasare, un jucător care își aliniază trei dintre piesele sale pe o linie de bord are o moară și poate elimina una dintre piesele adversarului său. Orice jucător se reduce la două piese și nu are opțiunea de a forma noi mori, pierzând astfel jocul. Un jucător poate pierde și cu mai mult de trei piese dacă adversarul său le blochează astfel încât să nu poată fi mutate.\n\nZbor\n\nÎn unele variante ale regulilor, odată ce unui jucător i-au rămas doar trei piese, piesele sale pot „zbura”, „sări” sau „sări” în orice punct vacant, nu numai în cele adiacente.\n\n';

  @override
  String get versionInfo => 'Informații despre versiune';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Licență';

  @override
  String get sourceCode => 'Sursă cod';

  @override
  String get appVersion => 'Versiunea aplicației';

  @override
  String get general => 'General';

  @override
  String get advanced => 'Avansat';

  @override
  String get placing => 'Plasare';

  @override
  String get moving => 'Mutare';

  @override
  String get removing => 'Eliminare';

  @override
  String get gameOverCondition => 'Condiția de sfârșit a jocului';

  @override
  String get aisPlayStyle => 'Stilul de joc al AI';

  @override
  String get passive => 'Pasiv';

  @override
  String get timeout => 'Pauză';

  @override
  String get appearance => 'Aspect';

  @override
  String get drawOnHumanExperience => 'Apelare la experiența umană';

  @override
  String get considerMobility => 'Ia în calcul mobilitatea pieselor';

  @override
  String get pieceCount => 'Numărul de piese:';

  @override
  String inHand(Object player, int count) {
    return '$player în mână: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player la bord: $count';
  }

  @override
  String get boardTop => 'Tablă compensată de sus';

  @override
  String get notAIsTurn => 'Nu este rândul lui AI.';

  @override
  String get aiIsNotThinking => 'AI nu gândește.';

  @override
  String get atEnd => 'La sfârșitul listei de mutări.';

  @override
  String get tapBackAgainToLeave =>
      'Atingeți butonul Înapoi încă o dată pentru a ieși.';

  @override
  String get more => 'Mai mult';

  @override
  String get experimental => 'Aceasta este o caracteristică experimentală.';

  @override
  String get experiments => 'Experimente';

  @override
  String get ossLicenses => 'Licențe open source';

  @override
  String get language => 'Limba';

  @override
  String get defaultLanguage => 'Limba implicita';

  @override
  String get mayMoveInPlacingPhase =>
      'Piesele se pot deplasa în faza de plasare';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Nu există faze distincte de plasare și de mutare, adică jucătorii pot decide la fiecare mutare dacă doresc să plaseze o piesă pe tablă sau să mute una dintre piesele lor (atâta timp cât mai au piese de plasat).';

  @override
  String get drawerColor => 'Culoarea meniului';

  @override
  String get drawerTextColor => 'Culoarea textului meniului';

  @override
  String get drawerHighlightItemColor =>
      'Culoarea elementului de evidențiere a meniului';

  @override
  String get mainToolbarBackgroundColor =>
      'Culoarea de fundal a barei de instrumente principale';

  @override
  String get mainToolbarIconColor =>
      'Culoarea pictogramei barei de instrumente principale';

  @override
  String get navigationToolbarBackgroundColor =>
      'Culoarea fundalului barei de instrumente de navigare';

  @override
  String get navigationToolbarIconColor =>
      'Culoarea pictogramei barei de instrumente de navigare';

  @override
  String get autoHideToolbar => 'Ascundeți automat bara de instrumente';

  @override
  String get toolbarLocationOnScreen => 'Locația barei de instrumente pe ecran';

  @override
  String get top => 'Top';

  @override
  String get bottom => 'Fund';

  @override
  String get center => 'Centru';

  @override
  String get solidColor => 'Culoare solida';

  @override
  String get picture => 'Imagine';

  @override
  String get chooseYourPicture => 'Alege poza ta';

  @override
  String get light => 'Ușoară';

  @override
  String get dark => 'Întuneric';

  @override
  String get themes => 'Teme';

  @override
  String get currentTheme => 'Tema actuală';

  @override
  String get saveTheme => 'Salvați tema';

  @override
  String get showAnalysisGraph => 'Afișați graficul de analiză';

  @override
  String get analysis => 'Analiză';

  @override
  String get saveGame => 'Salveaza jocul';

  @override
  String get loadGame => 'Incarca jocul';

  @override
  String get setupPosition => 'Poziția de configurare';

  @override
  String get showLegalMoves => 'Afișați mișcări legale';

  @override
  String get showLastMove => 'Afișează ultima mișcare';

  @override
  String get showArrows => 'Arată săgețile';

  @override
  String get pieces => 'Piese';

  @override
  String get showAnalysis => 'Afișați analiza';

  @override
  String get threads => 'Fire';

  @override
  String get getInvolved => 'A se implica';

  @override
  String get helpImproveTranslate => 'Ajutați la îmbunătățirea traducerii';

  @override
  String get tutorial => 'Tutorial';

  @override
  String get classicMill => 'Moara clasică';

  @override
  String get mixedMill => 'Moară mixtă';

  @override
  String get ceylonMill => 'Moara din Ceylon';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Moara poate fi spartă și refăcută în mod repetat';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Dacă un jucător sparge o moară pentru a crea imediat o moară nouă, un astfel de jucător poate muta o astfel de piesă înapoi la joncțiunea originală în următoarea sa mutare, dacă face o moară nouă.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Jocul este extras dacă un jucător are trei piese și după zece mutări niciunul dintre jucători nu elimină piesele adversarului';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Când un jucător are până la trei piese și niciunul dintre jucători nu poate elimina piesa adversarului în decurs de zece mutări, jocul este egal.';

  @override
  String get close => 'Închide';

  @override
  String get whitePiece => 'Piesa alba';

  @override
  String get blackPiece => 'Piesa neagră';

  @override
  String get emptyPoint => 'Punct gol';

  @override
  String get noPoint => 'Nici un punct';

  @override
  String get placingPhase => 'Faza de plasare';

  @override
  String get movingPhase => 'Faza în mișcare';

  @override
  String get flyingPhase => 'Faza de zbor';

  @override
  String sideToMove(Object player) {
    return 'Partea de mișcare: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Ultima mișcare: $move';
  }

  @override
  String get selected => 'Selectat';

  @override
  String get accessibility => 'Accesibilitate';

  @override
  String get screenReaderSupport => 'Suport pentru cititor de ecran';

  @override
  String get isDraw => 'Este o remiză!';

  @override
  String get draw => 'A desena';

  @override
  String get pieceHighlightColor => 'Culoarea de evidențiere a piesei';

  @override
  String get algorithm => 'Algoritm';

  @override
  String get endgameNMoveRule => 'Regula N-Move Endgame';

  @override
  String get endgameNMoveRule_Detail =>
      'Dacă oricare dintre jucători are doar trei piese și niciunul dintre jucători nu elimină o piesă în cadrul anumitor mișcări, jocul este extras.';

  @override
  String get drawReasonEndgameRule50 =>
      'Oricare dintre jucători are doar trei piese și niciunul dintre jucători nu elimină o piesă într-o anumită mișcare.';

  @override
  String get threefoldRepetitionRule => 'Regula de repetare triplă';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Jocul este extras dacă apare o poziție pentru a treia oară.';

  @override
  String get continueToMakeMove => 'Moară! Continuați să faceți o mișcare.';

  @override
  String get pointStyle => 'Stil punct';

  @override
  String get pointWidth => 'Lățimea punctului';

  @override
  String get solid => 'Solid';

  @override
  String get hollow => 'Gol';

  @override
  String get languageName => 'Română';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Mișcări',
      one: '$count Mișcare',
      zero: 'Mișcare',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Încărcarea nu a reușit.';

  @override
  String get filename => 'Nume de fișier';

  @override
  String get browse => 'Naviga…';

  @override
  String get gameFiles => 'Fișiere de joc';

  @override
  String get gameSavedTo => 'Jocul este salvat în';

  @override
  String get empty => 'Gol';

  @override
  String get noMove => 'Nicio mișcare.';

  @override
  String get restoredPosition => 'Poziția inițială restabilită.';

  @override
  String get clean => 'Curat';

  @override
  String get cleanedUp => 'Curatat.';

  @override
  String get remove => 'Elimina';

  @override
  String get noPiecesCanBeRemoved => 'Nicio bucată nu poate fi îndepărtată.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count piese',
      one: '$count piesă',
      zero: 'Piece',
    );
    return '$_temp0 trebuie eliminate.';
  }

  @override
  String placedCount(int count) {
    return 'Plasat ($count)';
  }

  @override
  String get placedPieceCount => 'Număr de piese plasate în faza de plasare.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Jucătorul actual a plasat piese $count.';
  }

  @override
  String get notPlacingPhase => 'Faza nu se plasează, nu o pot schimba.';

  @override
  String get paste => 'Pastă';

  @override
  String get pasteDone => 'Pasta este gata.';

  @override
  String get cannotPaste => 'Nu se poate lipi.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Afișați piesele neașezate și îndepărtate';

  @override
  String get fullScreen => 'Ecran complet';

  @override
  String get reopenToTakeEffect =>
      'Ieșiți și redeschideți aplicația pentru ca setările să intre în vigoare.';

  @override
  String get forest => 'pădure';

  @override
  String get desktopImage => 'Imagine de pe desktop';

  @override
  String get invalidPosition => 'Poziție nevalidă.';

  @override
  String get shareGIF => 'Distribuie GIF';

  @override
  String get pixelRatio => 'Raportul pixelilor';

  @override
  String get duration => 'Durată';

  @override
  String get gameScreenRecorder => 'Recorder ecran joc';

  @override
  String get previous => 'Anterior';

  @override
  String get next => 'Următorul';

  @override
  String get skip => 'Ocolire';

  @override
  String get gotIt => 'Am înţeles';

  @override
  String get youCanModifyRules =>
      'Puteți modifica regulile jocului în setările regulilor.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Puteți folosi rotița mouse-ului pentru a modifica valoarea din selector.';

  @override
  String get noTimeLimitForThinking =>
      'Timpul de gândire AI setat la 0 înseamnă că nu există limită de timp pentru gândire.';

  @override
  String get whatIsMtdf =>
      'MTD(f) este o formă modificată a algoritmului de căutare alfa-beta care urmărește să îmbunătățească eficiența prin reutilizarea rezultatelor de căutare intermediare și folosind o estimare inițială bună pentru a restrânge spațiul de căutare.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Vă rugăm să rețineți că ajustarea timpului de gândire AI poate să nu fie complet precisă. Timpul real de gândire poate fi mai scurt atunci când nivelul de dificultate este setat la o valoare mai mică și poate fi mai lung atunci când IA este la mijlocul gândirii când timpul expiră.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Dacă setați nivelul de dificultate ridicat, dar nu creșteți timpul de gândire AI, nivelul de dificultate real poate fi limitat la o valoare mai mică din cauza constrângerii timpului de gândire. Valoarea reală poate varia în funcție de performanța mașinii.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) este un algoritm de căutare pentru a găsi cea mai bună mișcare într-o anumită poziție. Este o îmbunătățire a algoritmului alfa-beta și utilizează căutări în fereastră nulă sau zero pentru a confirma că o mișcare este mai proastă sau nu mai proastă decât un scor deja sigur din variația principală. PVS se concentrează pe cele mai promițătoare mișcări și evită căutările inutile ale filialelor suboptime, ceea ce ajută la îmbunătățirea eficienței căutării.';

  @override
  String get whatIsAlphaBeta =>
      'Algoritmul alfa-beta este un algoritm de căutare pentru a găsi cea mai bună mișcare. Utilizează principiul minimax și două valori, alfa și beta, pentru a tăia arborele de căutare și a crește eficiența. Alpha reprezintă scorul minim pe care computerul este sigur că îl poate obține, în timp ce beta reprezintă scorul maxim pe care îl poate obține adversarul său. Algoritmul ajută computerul să ia decizii inteligente și eficiente într-un joc.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Conform experienței umane, dacă încerci să câștigi, vei pierde. În schimb, ținește ca obiectiv o egalitate și evită pierderea jocului. Observați-vă adversarul și atrageți-l ușor într-o poziție în care ar putea face greșeli. Când arată slăbiciune, profită de ocazie și împinge ușor pentru victorie. În acest fel, poți câștiga jocul.';

  @override
  String get firstMoveDetail =>
      'În acest joc, este mai ușor pentru al doilea jucător să câștige în comparație cu primul jucător.';

  @override
  String get passiveDetail =>
      'Activarea opțiunii pasive va determina AI să se relaxeze atunci când are un avantaj în poziție, mai degrabă decât să încerce agresiv să câștige cât mai repede posibil.';

  @override
  String get moveRandomlyDetail =>
      'Activarea acestei opțiuni crește aleatorietatea și distracția jocului, în timp ce dezactivarea acestuia poate ajuta la studiul modalităților de a învinge AI.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Dacă AI ia în considerare mobilitatea pieselor sale, nu va urmări doar să captureze piesele adversarului cât mai repede posibil, ci va lua în considerare și blocarea mișcărilor adversarului și împiedicarea acestuia să facă același lucru.';

  @override
  String get whenBoardIsFull => 'Când tabla este plină';

  @override
  String get whenBoardIsFull_Detail =>
      'La sfârșitul fazei de plasare, înainte de începerea fazei de mișcare, urmează acțiunea dacă tabla este plină de piese.';

  @override
  String get sideToMoveRemovePiece =>
      'Jucătorul care se mișcă primul în faza de mișcare îndepărtează una dintre piesele adversarului.';

  @override
  String get agreeToDraw => 'Ambele părți sunt de acord cu o remiză.';

  @override
  String get takeOpponentsPiece => 'Luați una dintre piesele adversarului dvs.';

  @override
  String get firstPlayerLose => 'Primul jucător pierde jocul.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Primul și al doilea jucător scot una dintre piesele adversarului.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Al doilea și primul jucător scot una dintre piesele adversarului.';

  @override
  String get enteredFlyingPhase =>
      'Intrate acum în faza de zbor, piesele adversarului pot sări în orice punct gol de pe tablă. Puteți dezactiva regula de zbor în „Setări reguli”.';

  @override
  String get whenStalemate => 'Când în impas';

  @override
  String get whenStalemate_Detail =>
      'Ce acțiune urmează când nicio piesă nu poate fi mutată?';

  @override
  String get endWithStalemateLoss =>
      'Încheiați cu o pierdere în impas pentru partea care este blocată.';

  @override
  String get changeSideToMove => 'Schimbați partea pentru a muta.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Scoateți una dintre piesele adversarului și faceți următoarea mișcare.';

  @override
  String get endWithStalemateDraw => 'Încheiați cu o remiză în impas.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Scoateți una dintre piesele adversarului și schimbați partea pentru a muta.';

  @override
  String get aiResponseDelayTime => 'Timp de întârziere a răspunsului AI';

  @override
  String get aiIsDelaying =>
      'AI se află în prezent într-o fază de răspuns întârziat. Vă rugăm să așteptați puțin înainte de a continua.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Nu puteți elimina o piesă neadiacentă.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Dacă sunt în impas, piesele adversarului adiacente ale tale pot fi eliminate, indiferent de formarea morii.';

  @override
  String get whatIsMcts =>
      'MCTS este un algoritm prietenos pentru începători care ia decizii prin explorarea și evaluarea diferitelor mișcări prin simulări.';

  @override
  String get goldenJade => 'Jad auriu';

  @override
  String get forestWood => 'Wood Wood';

  @override
  String get darkMystery => 'Mister întunecat';

  @override
  String get midnightBlue => 'Albastru miez de noapte';

  @override
  String get greenForest => 'Pădure verde';

  @override
  String get greenMeadow => 'Lunca Verde';

  @override
  String get stonyPath => 'Calea pietroasă';

  @override
  String get pastelPink => 'Roz pastel';

  @override
  String get turquoiseSea => 'Marea Turcoaz';

  @override
  String get violetDream => 'Violet Vis';

  @override
  String get mintChocolate => 'Ciocolata cu menta';

  @override
  String get skyBlue => 'Cer albastru';

  @override
  String get playfulGarden => 'Grădina jucăușă';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Algoritmul de analiză retrogradă utilizează analiza retrogradă cu mai multe valori pentru a construi o bază de date finală din diferite poziții de început, apoi aplică această bază de date pentru a optimiza jocul. Această abordare se încadrează în categoria soluțiilor Ultra-Strong.';

  @override
  String get viewAlgorithmGuide =>
      'Doriți să vedeți ghidul utilizatorului pentru acest algoritm?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Afișați indicatorul de avantaj pozițional';

  @override
  String get usePerfectDatabase => 'Utilizați baza de date perfectă';

  @override
  String get perfectDatabaseDescription =>
      'Activați această opțiune pentru a folosi o bază de date de joc fără cusur, generată prin algoritmi de ultimă generație. Această funcție integrează atât strategiile de deschidere, cât și cele de final pentru a sugera mutări optime. Este alegerea preferată pentru jucătorii care caută cel mai înalt nivel de precizie în joc. Creată prin tehnici de calcul meticuloase, baza de date este concepută pentru a oferi soluții de joc aproape perfecte.\n\nNotă: Dacă inteligența artificială nu poate accesa baza de date, va recurge la algoritmi convenționali pentru deciziile de joc. Când baza de date este disponibilă, \'Nivelul de dificultate\' devine practic de neînvins, iar \'Timpul de gândire al AI\' experimentează o reducere drastică. Multe setări în opțiunile \'Stilul de joc al AI\' vor fi suprascrise, deoarece rezultatele bazei de date au cea mai mare prioritate.\n\nPentru îndrumări despre cum să beneficiați la maximum de această bază de date fără cusur, faceți clic aici.';

  @override
  String get backgroundImage => 'Imagine de fundal';

  @override
  String get whatIsRandom =>
      'Când opțiunea \'Folosirea bazei de date perfecte\' nu este activată, setarea \'Aleator\' determină AI-ul să mute piesele în mod aleatoriu fără a utiliza algoritmi pentru selecția mișcărilor. Acest lucru duce, de obicei, la un joc semnificativ mai slab. În schimb, când este activată \'Folosirea bazei de date perfecte\', AI-ul se bazează exclusiv pe \'Baza de Date Perfectă\' pentru a lua decizii, în loc să o combine cu algoritmii tradiționali AI. În acest mod, mișcările AI-ului sunt bazate în întregime pe conținutul bazei de date, evitând dependența de calculele în timp real sau algoritmii de căutare.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Eliminați piesa(ele) adversarului din mâna acestuia; apoi este rândul adversarului să plaseze.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Când se formează mori în faza de plasare';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Eliminați piesa(ele) adversarului de pe tablă.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Eliminați piesa(ele) adversarului de pe tablă; apoi este rândul adversarului să plaseze.';

  @override
  String get opponentRemovesOwnPiece =>
      'Adversarul își elimină propria piesă(ele) de pe tablă.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'În loc să acționați dumneavoastră, adversarul alege și elimină propria piesă(ele) de pe tablă, luând efectiv o acțiune care îi este dăunătoare.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Eliminați piesa(ele) adversarului din mâna acestuia; apoi este rândul dumneavoastră să vă mutați.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Eliminați piesa(ele) din mâna adversarului. Dacă, conform setării de Eliminare Multiplă, trebuie eliminate mai multe piese și adversarul nu are piese rămase în mână, continuați să eliminați piesele adversarului de pe tablă. Apoi, este rândul dumneavoastră să vă mutați. Dacă continuați să formați mori, puteți continua să eliminați piesele adversarului.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Eliminați piesa(ele) din mâna adversarului. Dacă, conform setării de Eliminare Multiplă, trebuie eliminate mai multe piese și adversarul nu are piese rămase în mână, continuați să eliminați piesele adversarului de pe tablă. Apoi, este rândul adversarului să se mute.';

  @override
  String get markAndDelayRemovingPieces =>
      'Marcați și întârziați eliminarea pieselor.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'În faza de plasare, piesele ce urmează să fie eliminate sunt marcate, și pentru ambii jucători, nu se pot plasa piese noi pe aceste puncte. La intrarea în faza de mișcare, aceste piese marcate sunt eliminate în totalitate, și jucătorii pot apoi să-și mute piesele pe aceste puncte acum goale.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Acțiunile care pot fi luate în timpul formării morilor în faza de plasare.';

  @override
  String get marked => 'Marcat';

  @override
  String get menu => 'Meniu';

  @override
  String get monochrome => 'Monocrom';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Puteți activa suportul pentru cititorul de ecran în configurațiile de accesibilitate din Setările generale.';

  @override
  String get showNumbersOnPieces => 'Afișează numerele pe piese';

  @override
  String get saveImage => 'Salvați imaginea';

  @override
  String get isAnalysisToolbarShown =>
      'Afișează bara de instrumente de analiză';

  @override
  String get analysisToolbarBackgroundColor =>
      'Culoarea de fundal a barei de instrumente de analiză';

  @override
  String get analysisToolbarIconColor =>
      'Culoarea pictogramei barei de instrumente de analiză';

  @override
  String get transformed => 'Transformed.';

  @override
  String get cannotTransform => 'Nu se poate transforma.';

  @override
  String get rotate => 'Rotire';

  @override
  String get horizontalFlip => 'Oglin. O';

  @override
  String get verticalFlip => 'Oglin. V';

  @override
  String get innerOuterFlip => 'Oglin. I/E';

  @override
  String get transparentCanvas => 'Pânză Transparentă';

  @override
  String get restrictRepeatedMillsFormation =>
      'Restricționează formarea repetată a morilor';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'O piesă mutată de la un moară la alta nu poate reveni imediat la punctul original în următoarea tură pentru a forma din nou o moară. Mai întâi este necesară o mutare diferită.';

  @override
  String get oneTimeUseMill => 'Moară de unică folosință';

  @override
  String get oneTimeUseMill_Detail =>
      'Fiecare moară poate elimina o piesă a adversarului o singură dată. O poți reforma din nou, dar nu poate fi folosită pentru eliminări suplimentare.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Regulile actuale pe care le-ați setat nu au o bază de date perfectă corespunzătoare. Pentru mai multe informații despre baza de date perfectă, faceți clic aici.';

  @override
  String get focusOnBlockingPaths => 'Concentrează-te pe blocarea căilor';

  @override
  String get focusOnBlockingPaths_Detail =>
      'În anumite faze ale jocului, prioritizează blocarea mișcării adversarului în detrimentul formării de moare. În loc să se concentreze pe eliminarea pieselor prin completarea de moare, AI-ul își propune să-l prindă pe adversar în aceste faze, făcându-l incapabil să se miște și asigurând o victorie prin epuizare, mai degrabă decât prin joc agresiv. Această strategie specifică fazei nu blochează activ moarele adversarului.';

  @override
  String get pieceImage => 'Imagine piesă';

  @override
  String get importColorSettings => 'Importați setările de culoare';

  @override
  String get exportColorSettings => 'Exportați setările de culoare';

  @override
  String get import => 'Importați';

  @override
  String get export => 'Exportați';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Vă rugăm să copiați mai întâi setările formatului JSON în clipboard.';

  @override
  String get copiedToClipboard => 'Copiat în clipboard.';

  @override
  String get imported => 'Importat.';

  @override
  String get boardImage => 'Imagine tablă';

  @override
  String get autumnLeaves => 'Frunzele de Toamnă';

  @override
  String get legendaryLand => 'Tărâm Legendar';

  @override
  String get vignetteEffect => 'Efect de vinietă';

  @override
  String get promptMakeToolbarTransparent =>
      'Ați dori să faceți bara de instrumente complet transparentă când este setată o imagine de fundal pentru tablă?';

  @override
  String get vibration => 'Activează vibrația în joc';

  @override
  String get soundTheme => 'Tema sunetului';

  @override
  String get ball => 'Bila';

  @override
  String get liquid => 'Lichid';

  @override
  String get wood => 'Lemn';

  @override
  String get placeEffectAnimation => 'Efect de animație la plasarea piesei';

  @override
  String get removeEffectAnimation => 'Efect de animație la eliminarea piesei';

  @override
  String get isToolbarAtBottom =>
      'Afișează bara de instrumente în partea de jos';

  @override
  String get boardCornerRadius => 'Raza colțului tablei';

  @override
  String get useOpeningBook => 'Utilizați cartea de deschidere';

  @override
  String get currentRule => 'Curent';

  @override
  String get nineMensMorris => 'Țintar';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Set de reguli';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'Moara de o singură dată';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Permiteți IA să utilizeze mișcările de deschidere utilizate frecvent de jucătorii umani profesioniști în timpul jocului timpuriu. Notă: Această funcție este disponibilă în prezent doar pentru seturi de reguli specifice.';

  @override
  String get showAdvantageGraph => 'Afișează graficul avantajului';

  @override
  String get advantageGraphHint =>
      'Graficul de avantaj va fi desenat doar după ce IA face o mutare. Nu va fi desenat când jucătorul uman face o mutare.';

  @override
  String get removalBasedOnMillCounts =>
      'Dezactivați îndepărtarea până când toate piesele sunt plasate. Jucătorii îndepărtează piesele pe baza numărului de mori formate.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Dezactivați îndepărtarea până când toate piesele sunt plasate. Jucătorii îndepărtează piesele pe baza numărului de mori: dacă este egal, ambii îndepărtează același număr de piese; dacă unul are mai multe, îndepărtează o piesă în plus, menținând o diferență de o piesă. Dacă doar unul formează o moară, acesta îndepărtează două piese, iar celălalt îndepărtează una. Dacă niciunul nu formează o moară, ambii îndepărtează câte o piesă.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Selectează una dintre piesele tale.';

  @override
  String get notYourTurn => 'Nu este rândul tău.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Culoarea de fundal pentru bara de instrumente de adnotare';

  @override
  String get annotationToolbarIconColor =>
      'Culoarea pictogramei din bara de instrumente de adnotare';

  @override
  String get isAnnotationToolbarShown =>
      'Afișează bara de instrumente de adnotare';

  @override
  String get enterAnnotationMode => 'Intră în modul de adnotare';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Ești sigur că vrei să ștergi toate adnotările?';

  @override
  String get llmPromptCopiedToClipboard => 'Prompt LLM copiat în clipboard.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Conexiune refuzată, serverul poate fi oprit.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Descoperire reușită, așteptând conexiunea...';

  @override
  String get noLanConnection => 'Nicio conexiune LAN';

  @override
  String get takeScreenshot => 'Fă o captură de ecran';

  @override
  String get disconnectedFromOpponent => 'Deconectat de la adversar.';

  @override
  String get takeBackRequest => 'Cerere de anulare a mutării';

  @override
  String get nothingToShow => 'Nimic de afișat.';

  @override
  String get stopHosting => 'Oprește găzduirea';

  @override
  String get connectionResetByPeer =>
      'Conexiunea a fost resetată de partea opusă.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Conexiunea s-a pierdut din cauza expirării semnalului. Vă rugăm să vă reconectați.';

  @override
  String get startHosting => 'Începe găzduirea';

  @override
  String get restartRequestRejected => 'Cererea de repornire a fost respinsă.';

  @override
  String get notConnectedToLanOpponent =>
      'Nu ești conectat la un adversar LAN.';

  @override
  String get llmPrompt => 'Prompt LLM';

  @override
  String get gameRestarted => 'Jocul a fost repornit.';

  @override
  String get takeBackRejected =>
      'Cererea de anulare a mutării a fost respinsă.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Ești sigur că vrei să renunți la acest joc?';

  @override
  String get opponentResignedYouWin => 'Adversarul a renunțat. Ai câștigat!';

  @override
  String get clearAllAnnotations => 'Șterge toate adnotările';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Conectat, așteaptă mutarea adversarului...';

  @override
  String get networkStatusDisconnected => 'Stare rețea: Deconectată';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Cerere de anulare a mutării trimisă adversarului.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Este posibil ca adversarul să fi părăsit jocul';

  @override
  String get connectedToHostSuccessfully => 'Conectat cu succes la gazdă.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Conexiune pierdută: timp de așteptare pentru semnal depășit';

  @override
  String get noHostDiscovered => 'Nicio gazdă descoperită.';

  @override
  String get confirmResignation => 'Confirmă renunțarea';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Joc găzduit, așteptăm jucători să se alăture...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Conexiunea a expirat, conexiunea de rețea este instabilă.';

  @override
  String get noLlmPromptAvailable => 'Nu există niciun prompt LLM disponibil.';

  @override
  String get youResignedGameOver => 'Ai renunțat. Joc încheiat.';

  @override
  String get serverIp => 'IP Server';

  @override
  String get confirmClear => 'Confirmă ștergerea';

  @override
  String get opponentSTurn => 'Este rândul adversarului.';

  @override
  String get waitingAClientConnection =>
      'Se așteaptă o conexiune de la client...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Cererea de anulare a mutării a fost respinsă sau a eșuat.';

  @override
  String get addText => 'Adaugă text';

  @override
  String get exitAnnotationMode => 'Ieși din modul de adnotare';

  @override
  String get typeYourAnnotation => 'Tastați adnotarea dvs.';

  @override
  String get attemptingToReconnect => 'Se încearcă reconectarea...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Cerere de repornire trimisă. Se așteaptă răspunsul adversarului...';

  @override
  String get serverIsStopped => 'Serverul este oprit.';

  @override
  String get restartRequest => 'Cerere de repornire';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Nu poți solicita anularea mutării când nu e rândul tău.';

  @override
  String get takeBackAccepted => 'Cererea de anulare a fost acceptată.';

  @override
  String get localNetworkSettings => 'Setări rețea locală';

  @override
  String get reconnectedSuccessfully => 'Reconectare reușită!';

  @override
  String get failedToSaveImageToGallery =>
      'Nu s-a reușit salvarea imaginii în Galerie.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Adversarul a cerut repornirea jocului. Accepți?';

  @override
  String get yourTurn => 'Este rândul tău.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Nu se poate reconecta, vă rugăm să reporniți jocul.';

  @override
  String get host => 'Gazdă';

  @override
  String get join => 'Alătură-te';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'Adresă IP invalidă.';

  @override
  String get invalidPort => 'Port invalid.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Se conectează: Încercarea $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Nu s-a reușit conectarea: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Nu s-a reușit pornirea găzduirii: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Gazdă descoperită: $ip:$port';
  }

  @override
  String get stop => 'Oprește';

  @override
  String get discover => 'Descoperă';

  @override
  String get connect => 'Conectează';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Client conectat: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Se descoperă: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Se reconectează ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Conectat';

  @override
  String get delete => 'Șterge';

  @override
  String get ancientEgypt => 'Egiptul Antic';

  @override
  String get gothicIce => 'Gheață Gotică';

  @override
  String get riceField => 'Câmp de Orez';

  @override
  String get chinesePorcelain => 'Porțelan Chinezesc';

  @override
  String get desertDusk => 'Amurgul Deșertului';

  @override
  String get precisionCraft => 'Meșteșug de Precizie';

  @override
  String get folkEmbroidery => 'Broderie Populară';

  @override
  String get carpathianHeritage => 'Moștenirea Carpaților';

  @override
  String get imperialGrandeur => 'Grandoare Imperială';

  @override
  String get bohemianCrystal => 'Cristal Bohemian';

  @override
  String get savannaSunrise => 'Răsăritul Savanei';

  @override
  String get harmonyBalance => 'Armonie și Echilibru';

  @override
  String get cinnamonSpice => 'Condiment de Scorțișoară';

  @override
  String get anatolianMosaic => 'Mozaic Anatolian';

  @override
  String get carnivalSpirit => 'Spiritul Carnavalului';

  @override
  String get custom => 'Personalizat';

  @override
  String get spiceMarket => 'Piața de condimente';

  @override
  String get swipeToRevealTheDrawer => 'Glisează pentru a dezvălui sertarul';

  @override
  String get showGameInfoOnScreenshots =>
      'Afișează informații despre joc în capturile de ecran';

  @override
  String get humanMoveTime => 'Limită de timp umană';

  @override
  String get noTimeLimitForHumanMoves =>
      'Fără limită de timp pentru mișcările umane';

  @override
  String get timeoutLoseWillBeApplied =>
      'Pierderea prin expirarea timpului va fi aplicată jucătorului uman';

  @override
  String get identifyingBoard => 'Identificând tabla de joc...';

  @override
  String get youCanEnterAnyModelName => 'Poți introduce orice nume de model.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Poziția tablei aplicată. FEN copiat în clipboard.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Sugestie: încearcă să faci o fotografie mai clară a tablei.';

  @override
  String get llmPromptTemplate => 'Șablon de prompt LLM';

  @override
  String get noValidBoardDetected => 'Nu a fost detectată nicio tablă validă.';

  @override
  String get selectingImageFromAlbum => 'Selectare imagine din album...';

  @override
  String get configurePromptTemplate => 'Configurează șablonul de prompt';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Editează șablonul de prompt pentru analiza LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Nu s-a putut genera FEN din tabla recunoscută.';

  @override
  String get outputInCurrentLanguage => 'Ieșire în limba curentă';

  @override
  String get commonBaseUrls => 'URL-uri Base comune';

  @override
  String get viewCommonModels => 'Vezi modelele comune';

  @override
  String get recognitionParametersUpdated =>
      'Parametrii de recunoaștere au fost actualizați.';

  @override
  String get whiteSMove => 'Mutarea albului';

  @override
  String get resetToDefaults => 'Resetează la valorile implicite';

  @override
  String get photoShoot => 'Ședință foto';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Nu s-a putut aplica poziția recunoscută a tablei.';

  @override
  String get llmPromptContent => 'Conținutul promptului LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM nu este configurat. Verifică setările.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Setează furnizorul, modelul, API Key și Base URL';

  @override
  String get llmConfiguration => 'Configurare LLM';

  @override
  String get configureLlmProvider => 'Configurează furnizorul LLM';

  @override
  String get llmPromptTemplateHeader => 'Antet șablon prompt LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Nicio piesă nu a fost recunoscută în imagine. Încearcă din nou.';

  @override
  String get recognizeBoardFromImage => 'Recunoaște tabla din imagine';

  @override
  String get viewTips => 'Vezi sfaturi';

  @override
  String get applyToBoard => 'Aplică pe tablă';

  @override
  String get adjustBoardArea => 'Ajustează zona tablei';

  @override
  String get viewCommonUrls => 'Vezi URL-uri comune';

  @override
  String get colorAnalysisFailed => 'Analiza culorilor a eșuat!';

  @override
  String get analyzingGameBoardImage => 'Se analizează imaginea tablei...';

  @override
  String get selectFromAlbum => 'Selectează din album';

  @override
  String get noBoardPointDetected => 'Niciun punct pe tablă detectat!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Dacă este lăsat gol, se va folosi șablonul implicit';

  @override
  String get llmConfig => 'Configurare LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Ești sigur că vrei să resetezi șabloanele de prompt la valorile implicite?';

  @override
  String get llmPromptTemplateFooter => 'Subsol șablon prompt LLM';

  @override
  String get loadingResponse => 'Se încarcă răspunsul...';

  @override
  String get applyThisResultToBoard => 'Aplică acest rezultat pe tablă';

  @override
  String get takingPicture => 'Se face fotografia...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Te rugăm să selectezi o imagine a tablei de joc pentru identificare';

  @override
  String get identificationResults => 'Rezultatele identificării';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analizează mutările și oferă perspective.';

  @override
  String get getApiKey => 'Obține API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Întregul proces de recunoaștere nu s-a putut finaliza.';

  @override
  String get boardRecognitionResult => 'Rezultatul recunoașterii tablei';

  @override
  String get askLlm => 'Întreabă LLM';

  @override
  String get boardDetectionFailed => 'Detecția tablei a eșuat!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Niciun punct pe tablă detectat, nu se poate identifica piesa!';

  @override
  String get copyFen => 'Copiază FEN';

  @override
  String get commonlyUsedModels => 'Modele utilizate frecvent';

  @override
  String get apiKeyOptional => 'API Key (opțional)';

  @override
  String get noImageSelected => 'Nicio imagine selectată';

  @override
  String get blackSMove => 'Mutarea negrului';

  @override
  String get llm => 'Model lingvistic mare';

  @override
  String get llmProvider => 'Furnizor';

  @override
  String get baseUrl => 'URL de bază';

  @override
  String get model => 'Model';

  @override
  String get temperature => 'Temperatură';

  @override
  String get llmCommandReceivedProcessing =>
      'Comanda primită! IA procesează...';

  @override
  String get llmDeepThinkingWait =>
      'Se desfășoară gândire profundă, vă rugăm să așteptați...';

  @override
  String get llmPresentingSoon => 'Va fi prezentat în curând...';

  @override
  String get recognitionParameters => 'Parametri de recunoaștere';

  @override
  String get adjustParamsDesc =>
      'Ajustați parametrii pentru a îmbunătăți acuratețea recunoașterii';

  @override
  String get saveParameters => 'Salvează parametrii';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Nu se poate porni recunoașterea imaginii: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Recunoașterea imaginii a eșuat: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Poziție aplicată cu $whiteCount piese albe și $blackCount piese negre';
  }

  @override
  String get fenCopiedToClipboard => '(FEN copiat în clipboard)';

  @override
  String recognitionFailed(String error) {
    return 'Recunoașterea a eșuat: $error';
  }

  @override
  String get myRating => 'Ratingul meu';

  @override
  String get gamesPlayed => 'Jocuri jucate';

  @override
  String get wins => 'Victorii';

  @override
  String get losses => 'Înfrângeri';

  @override
  String get draws => 'Remize';

  @override
  String get lastUpdated => 'Ultima actualizare';

  @override
  String get format => 'Format:';

  @override
  String get resetStatistics => 'Resetați statisticile';

  @override
  String get drawRate => 'Rată remize';

  @override
  String get lossRate => 'Rată înfrângeri';

  @override
  String get aiStatistics => 'Statistici IA';

  @override
  String get enableStatistics => 'Activați statisticile';

  @override
  String get enableStatistics_Detail =>
      'Când este activat, rezultatele jocurilor vor fi înregistrate în statistici. Cu toate acestea, jocurile care implică retrageri de mutări nu vor fi înregistrate. Când este dezactivat, colectarea statisticilor este întreruptă.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Aceasta va reseta toate statisticile jocului. Această acțiune nu poate fi anulată.';

  @override
  String get boardInnerRingSize => 'Dimensiunea inelului interior al tablei';

  @override
  String get boardShadowEnabled => 'Umbra tablei';

  @override
  String get trapAwareness => 'Detectare capcane';

  @override
  String get trapAwarenessDescription =>
      'Evidențiază mutările-capcană cu cercuri și săgeți îngroșate în timpul analizei.';

  @override
  String trapExists(String trapMoves) {
    return 'Există o capcană. Mutări-capcană: $trapMoves';
  }

  @override
  String get custodianCapture => 'Captura flancând';

  @override
  String get custodianCaptureDescription =>
      'Închideți una dintre piesele adversarului între două dintre ale voastre într -o linie dreaptă pentru a o captura.';

  @override
  String get custodianCaptureEnable => 'Permiteți captarea flancare';

  @override
  String get interventionCapture => 'Captura de intervenție';

  @override
  String get interventionCaptureDescription =>
      'Mutați -vă în punctul gol dintre două dintre piesele adversarului dvs. pentru a le surprinde pe amândouă.';

  @override
  String get interventionCaptureEnable => 'Permiteți captarea intervenției';

  @override
  String get leapCapture => 'Salt Capture';

  @override
  String get leapCaptureDescription =>
      'Capturați sărind peste piesa adversarului adiacent în punctul gol de dincolo.';

  @override
  String get leapCaptureEnable => 'Permiteți captarea saltului';

  @override
  String get captureApplicableLines => 'Linii aplicabile';

  @override
  String get captureSquareEdges => 'De -a lungul marginilor pieței';

  @override
  String get captureCrossLines =>
      'De -a lungul liniilor ortogonale care traversează piața';

  @override
  String get captureDiagonalLines =>
      'De -a lungul liniilor diagonale care traversează pătratul';

  @override
  String get captureExecutionPhases => 'Faze de execuție';

  @override
  String get capturePiecesCondition =>
      'Disponibilitate în faza de mișcare pe baza pieselor rămase';

  @override
  String get capturePiecesConditionUnlimited => 'Fără restricție';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Disponibil când aveți trei sau mai puține piese';
}
