// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Portuguese (`pt`).
class SPt extends S {
  SPt([String locale = 'pt']) : super(locale);

  @override
  String get appName => 'Moinho';

  @override
  String get welcome => 'Bem-vindo';

  @override
  String get yes => 'Sim';

  @override
  String get no => 'Não';

  @override
  String get game => 'Jogo';

  @override
  String get humanVsAi => 'Humano vs. IA';

  @override
  String get humanVsHuman => 'Humano vs. Humano';

  @override
  String get aiVsAi => 'IA vs. IA';

  @override
  String get humanVsCloud => 'Humano vs. Nuvem';

  @override
  String get humanVsLAN => 'Humanos vs. LAN';

  @override
  String get testViaLAN => 'Teste através de LAN';

  @override
  String get move => 'Mov.';

  @override
  String get showMoveList => 'Lista de movimentos';

  @override
  String get moveList => 'Lista de movimentos';

  @override
  String get noGameRecord => 'Sem registro';

  @override
  String get ok => 'OK';

  @override
  String get confirm => 'Confirmar';

  @override
  String get cancel => 'Cancelar';

  @override
  String get tipSelectWrong => 'Selecione a peça errada.';

  @override
  String get tipPlace => 'Coloque suas peças.';

  @override
  String get tipBanPlace => 'Não se pode colocar aqui.';

  @override
  String get tipPlaced => 'Peça colocada.';

  @override
  String get tipRemove => 'Remover uma peça.';

  @override
  String get tipBanRemove => 'Não é possível remover.';

  @override
  String get tipRemoved => 'Peça removida.';

  @override
  String get tipMove => 'Mova uma peça.';

  @override
  String get tipCannotPlace => 'Você não pode colocar sua peça aqui.';

  @override
  String get tipCannotMove => 'Você não pode mover sua peça aqui.';

  @override
  String get tipMill => 'Moinho! Pegue a peça de seu oponente.';

  @override
  String get tipContinueMill => 'Continue pegando a peça de seu oponente.';

  @override
  String get tipSelectOpponentsPiece =>
      'Selecione uma das peças de seu oponente.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Você não pode remover uma peça de um moinho.';

  @override
  String get tipCanMoveOnePoint => 'Uma peça pode mover 1 ponto.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Você não pode mover as peças de seu oponente.';

  @override
  String get tipSelectPieceToMove => 'Selecione sua peça para movê-la.';

  @override
  String get tipHaveThreePiecesLeft => 'Você tem três peças restantes.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Você pode ir para qualquer ponto que quiser.';

  @override
  String tipToMove(Object player) {
    return 'Vez de $player.';
  }

  @override
  String get whiteWin => 'O jogador 1 ganhou!';

  @override
  String get blackWin => 'O jogador 2 ganhou!';

  @override
  String get won => 'Vitória';

  @override
  String get lost => 'Derrota';

  @override
  String get thinking => 'Pensando…';

  @override
  String get newGame => 'Novo jogo';

  @override
  String get importGame => 'Importar jogo';

  @override
  String get exportGame => 'Exportar jogo';

  @override
  String get gameImported => 'Jogo importado.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Não é possível importar $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Os movimentos e as regras não combinam.';

  @override
  String get pleaseWait => 'Por favor, aguarde.';

  @override
  String get restartGame => 'Reiniciar o jogo atual?';

  @override
  String get restart => 'Reiniciar';

  @override
  String get gameStarted => 'Jogo iniciado. Coloque as peças.';

  @override
  String get analyzing => 'Analisando…';

  @override
  String error(Object message) {
    return 'Erro: $message';
  }

  @override
  String get winRate => 'Taxa de vitória';

  @override
  String get score => 'Pontuação:';

  @override
  String get white => 'Jogador 1';

  @override
  String get black => 'Jogador 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return 'O número de peças do $player é inferior a três.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player desistiu.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player não tem movimentos possíveis.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'O tabuleiro está cheio, e $player não tem movimentos possíveis.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'O tempo acabou, $player perdeu.';
  }

  @override
  String get drawReasonRule50 =>
      'Na fase de movimento, nenhuma peça foi removida no último número especificado de movimentos.';

  @override
  String get drawReasonBoardIsFull =>
      'O jogo empatou porque o tabuleiro está cheio.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Empate por causa da tripla repetição.';

  @override
  String get gameOverUnknownReason => 'Fim do jogo! Motivo desconhecido.';

  @override
  String get gameOver => 'Fim de jogo';

  @override
  String get youWin => 'Você ganhou! Parabéns!';

  @override
  String challengeHarderLevel(int level) {
    return 'Desafie o nível mais difícil? O novo nível será nível $level!';
  }

  @override
  String get youLose => 'Você perdeu!';

  @override
  String get analyze => 'Analisar';

  @override
  String get about => 'Sobre';

  @override
  String version(Object versionNumber) {
    return 'Versão: $versionNumber';
  }

  @override
  String get thanks => 'Agradecimentos';

  @override
  String get settings => 'Configurações';

  @override
  String get options => 'Opções';

  @override
  String get generalSettings => 'Configurações Gerais';

  @override
  String get skillLevel => 'Nível de dificuldade';

  @override
  String get moveTime => 'Tempo de raciocínio da IA';

  @override
  String get difficulty => 'Dificuldade';

  @override
  String get playSounds => 'Efeitos sonoros';

  @override
  String get playSoundsInTheGame => 'Tocar sons no jogo';

  @override
  String get keepMuteWhenTakingBack => 'Manter mudo ao desfazer jogada.';

  @override
  String get tone => 'Tom';

  @override
  String get whoMovesFirst => 'Primeira jogada';

  @override
  String get human => 'Humano';

  @override
  String get ai => 'IA';

  @override
  String get alternate => 'Alternar';

  @override
  String get isAutoRestart => 'Reinício automático do jogo no final do jogo';

  @override
  String get isAutoChangeFirstMove =>
      'Alternar automaticamente a primeira jogada';

  @override
  String get shufflingEnabled => 'Movimento aleatório';

  @override
  String get misc => 'Diversos';

  @override
  String get rules => 'Regras';

  @override
  String get piecesCount => 'O número de peças que cada jogador tem';

  @override
  String get piecesCount_Detail => 'Quantas peças cada jogador tem?';

  @override
  String get flyPieceCount => 'O número da peça voadora';

  @override
  String get flyPieceCount_Detail =>
      'Se a opção de vôo for ativada, quando um jogador está reduzido a um número específico de peças, suas peças são livres para se mover para qualquer ponto desocupado, ao invés de serem restritas a pontos adjacentes como no resto do jogo.';

  @override
  String get piecesAtLeastCount => 'Mínimo de peças';

  @override
  String get hasDiagonalLines => 'Linhas diagonais';

  @override
  String get hasDiagonalLines_Detail =>
      'Acrescentar quatro linhas diagonais ao tabuleiro.';

  @override
  String get isDefenderMoveFirst => 'O segundo jogador se move primeiro';

  @override
  String get isDefenderMoveFirst_Detail =>
      'O jogador que se move em segundo lugar na fase de colocação se move primeiro na fase de movimentação.';

  @override
  String get mayRemoveMultiple => 'Remoção múltipla';

  @override
  String get mayRemoveMultiple_Detail =>
      'Se um jogador fechar mais de um moinho de uma vez, ele removerá o número de moinhos que fechou.';

  @override
  String get mayRemoveFromMillsAlways => 'Remover de moinhos sempre';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Por padrão, os jogadores devem primeiro remover quaisquer outras peças antes de remover uma peça de um moinho formado. Habilite esta opção para desabilitar a limitação.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'O segundo jogador perde quando o tabuleiro está cheio';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'No final da fase de colocação, quando o tabuleiro está cheio, o lado que coloca primeiro perde o jogo, caso contrário, o jogo empata.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Perder por falta de movimentos';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'O jogador perde se o oponente o bloquear impedindo qualquer movimento. Se esta opção estiver desativada, troca-se o jogador da vez em vez de declarar derrota.';

  @override
  String get mayFly => 'Vôo';

  @override
  String get mayFly_Detail =>
      'Se um jogador tem apenas três ou quatro peças restantes (configuráveis), ele pode mover a peça para qualquer ponto livre.';

  @override
  String get nMoveRule => 'Regra dos N movimentos';

  @override
  String get nMoveRule_Detail =>
      'O jogo é declarado empate se não houver remoção de peças por N movimentos.';

  @override
  String get rollback => 'Retrocesso';

  @override
  String get pleaseSelect => 'Selecionar';

  @override
  String get copy => 'Copiar';

  @override
  String get moveHistoryCopied =>
      'Histórico de movimentos copiado para a área de transferência.';

  @override
  String get help => 'Ajuda';

  @override
  String get feedback => 'Comentários';

  @override
  String get exit => 'Sair';

  @override
  String get ruleSettings => 'Regras';

  @override
  String get color => 'Cor';

  @override
  String get boardColor => 'Cor do tabuleiro';

  @override
  String get pieceColor => 'Cor da peça';

  @override
  String get backgroundColor => 'Cor de fundo';

  @override
  String get lineColor => 'Cor da linha do tabuleiro';

  @override
  String get whitePieceColor => 'Cor da peça do jogador 1';

  @override
  String get blackPieceColor => 'Cor das peças do jogador 2';

  @override
  String get messageColor => 'Cor da mensagem';

  @override
  String get isPieceCountInHandShown => 'Mostrar o número de peças em mãos';

  @override
  String get isNotationsShown => 'Mostrar anotações no tabuleiro';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Mostrar barra de navegação do histórico';

  @override
  String get display => 'Mostrar';

  @override
  String get boardBorderLineWidth => 'Largura da borda do tabuleiro';

  @override
  String get boardInnerLineWidth => 'Largura da linha interna do tabuleiro';

  @override
  String get pieceWidth => 'Largura da peça';

  @override
  String get fontSize => 'Tamanho de letra';

  @override
  String get standardNotation => 'Notação WMD';

  @override
  String get restore => 'Restaurar';

  @override
  String get restoreDefaultSettings => 'Restaurar as configurações padrão';

  @override
  String pick(Object element) {
    return 'Escolher $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Dica';

  @override
  String get player => 'jogador';

  @override
  String get player1 => 'Jogador 1';

  @override
  String get player2 => 'Jogador 2';

  @override
  String get howToPlay => 'Como jogar';

  @override
  String get toPlacePiece =>
      'Toque em qualquer ponto disponível para colocar a peça.';

  @override
  String get toSelectPiece => 'Toque em uma peça para movê-la.';

  @override
  String get toMovePiece =>
      'Toque em um ponto conectado a uma peça para movê-la.';

  @override
  String get toRemovePiece => 'Toque na peça de um oponente para removê-la.';

  @override
  String get needToCreateMillFirst =>
      'Para remover uma peça, é necessário criar um moinho.';

  @override
  String get needToPlayWithOwnPieces => 'Você tem que brincar com suas peças.';

  @override
  String get statistics => 'Estatísticas';

  @override
  String get totalGames => 'Total de jogos';

  @override
  String get results => 'Resultados';

  @override
  String get left => 'esquerda';

  @override
  String get privacyPolicy => 'Política de Privacidade';

  @override
  String get privacyPolicy_Detail_1 =>
      'Por favor, leia com atenção e certifique-se de que entende e concorda com isto ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Se você não concordar com esta Política, por favor, não utilize este aplicativo. Ao utilizar o aplicativo, você concorda com estes termos.';

  @override
  String get and => ' e ';

  @override
  String get accept => 'Aceitar';

  @override
  String get takeBack => 'Voltar';

  @override
  String get takingBack => 'Desfazendo…';

  @override
  String get waiting => 'Espere…';

  @override
  String get stepForward => 'Avançar';

  @override
  String get takeBackAll => 'Rebobinar tudo';

  @override
  String get stepForwardAll => 'Enviar todos';

  @override
  String get moveNow => 'Mexa-se agora';

  @override
  String get done => 'Feito.';

  @override
  String get crackMill => 'Moinho de Crack';

  @override
  String get crackMill_Detail =>
      'Se um jogador só tiver peças em moinhos, as peças em moinhos não serão bloqueadas para remoção.';

  @override
  String get animationDuration => 'Duração da animação';

  @override
  String get none => 'Nenhum';

  @override
  String get theme => 'Tema';

  @override
  String get helpContent =>
      'O objetivo do jogo é deixar o adversário com menos de três peças ou sem movimentos possíveis.\n\nO jogo é declarado empate se uma mesma posição ocorrer pela terceira vez ou se não houver remoção de peças nas últimas 100 jogadas (configurável).\n\nO jogo se desenvolve em três fases:\n\n1. Colocação: os jogadores alternam-se colocando suas peças em pontos vazios do tabuleiro;\n2. Movimento: os jogadores movem suas peças para pontos adjacentes;\n3. (Fase opcional) Vôo: quando um jogador fica com apenas três peças, ele pode mover suas peças para qualquer ponto vazio.\n\nColocação\n\nO jogo começa com um tabuleiro vazio, composto por uma grade com vinte e quatro pontos. Os jogadores se revezam para colocar suas peças nos pontos vazios até que todas as peças estejam no tabuleiro. Se um jogador conseguir alinhar três de suas peças em linha, ele forma um \"moinho\" e pode remover uma peça do adversário.\n\nEm algumas variações, os jogadores devem remover outras peças antes de remover uma peça de um moinho formado.\n\nEm certas regras, não é permitido recolocar peças nos pontos de onde elas foram removidas.\n\nApós todas as peças serem colocadas, os jogadores se revezam para mover as peças.\n\nMovimento\n\nPara mover, um jogador desloca uma de suas peças ao longo de uma linha do tabuleiro para um ponto adjacente vazio. Se não for possível realizar um movimento, o jogador perde o jogo. Ao alinhar três peças em linha, o jogador forma um moinho e pode remover uma peça do adversário. Um jogador que ficar com apenas duas peças perde o jogo; além disso, se um jogador tiver mais de três peças e não conseguir se mover, também perde.\n\nVôo\n\nEm algumas variantes, quando um jogador fica com apenas três peças, suas peças podem \"voar\", \"pular\" ou \"saltar\" para qualquer ponto vazio, não apenas para os adjacentes.';

  @override
  String get versionInfo => 'Informações sobre a versão';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Licença';

  @override
  String get sourceCode => 'Código fonte';

  @override
  String get appVersion => 'Versão de aplicação';

  @override
  String get general => 'Geral';

  @override
  String get advanced => 'Avançado';

  @override
  String get placing => 'Coloc.';

  @override
  String get moving => 'Mov.';

  @override
  String get removing => 'Remoção';

  @override
  String get gameOverCondition => 'Condição de fim de jogo';

  @override
  String get aisPlayStyle => 'Estilo de jogo da IA';

  @override
  String get passive => 'Passivo';

  @override
  String get timeout => 'Desconto de tempo';

  @override
  String get appearance => 'Aparência';

  @override
  String get drawOnHumanExperience => 'Com base na experiência humana';

  @override
  String get considerMobility => 'Considerar mobilidade das peças';

  @override
  String get pieceCount => 'Contagem de peças:';

  @override
  String inHand(Object player, int count) {
    return '$player em mãos: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player no tabuleiro: $count';
  }

  @override
  String get boardTop => 'Deslocamento do tabuleiro do topo';

  @override
  String get notAIsTurn => 'Não é a vez da IA.';

  @override
  String get aiIsNotThinking => 'A IA não está pensando.';

  @override
  String get atEnd => 'No final da lista de mudanças.';

  @override
  String get tapBackAgainToLeave => 'Toque novamente para sair.';

  @override
  String get more => 'Mais';

  @override
  String get experimental => 'Esta é uma função experimental.';

  @override
  String get experiments => 'Experimentos';

  @override
  String get ossLicenses => 'Licenças de fonte aberta';

  @override
  String get language => 'Idioma';

  @override
  String get defaultLanguage => 'Idioma padrão';

  @override
  String get mayMoveInPlacingPhase =>
      'As peças podem ser movimentadas na fase de colocação';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Não há fases separadas de colocação e movimento, ou seja, os jogadores podem decidir a cada jogada se querem colocar uma peça no tabuleiro ou mover uma de suas peças (desde que tenham peças para colocar).';

  @override
  String get drawerColor => 'Cor do menu';

  @override
  String get drawerTextColor => 'Cor do texto do menu';

  @override
  String get drawerHighlightItemColor => 'Cor do item destacado do menu';

  @override
  String get mainToolbarBackgroundColor =>
      'Cor de fundo da barra de ferramentas principal';

  @override
  String get mainToolbarIconColor =>
      'Cor do ícone principal da barra de ferramentas';

  @override
  String get navigationToolbarBackgroundColor =>
      'Cor de fundo da barra de ferramentas de navegação';

  @override
  String get navigationToolbarIconColor =>
      'Cor do ícone da barra de ferramentas de navegação';

  @override
  String get autoHideToolbar =>
      'Esconder automaticamente a barra de ferramentas';

  @override
  String get toolbarLocationOnScreen =>
      'Localização da barra de ferramentas na tela';

  @override
  String get top => 'Top';

  @override
  String get bottom => 'Inferior';

  @override
  String get center => 'Centro';

  @override
  String get solidColor => 'Cor sólida';

  @override
  String get picture => 'Imagem';

  @override
  String get chooseYourPicture => 'Escolha sua foto';

  @override
  String get light => 'Luz';

  @override
  String get dark => 'Escuro';

  @override
  String get themes => 'Temas';

  @override
  String get currentTheme => 'Tema atual';

  @override
  String get saveTheme => 'Salvar tema';

  @override
  String get showAnalysisGraph => 'Mostrar gráfico de análise';

  @override
  String get analysis => 'Análise';

  @override
  String get saveGame => 'Salvar o jogo';

  @override
  String get loadGame => 'Jogo de carga';

  @override
  String get setupPosition => 'Configurar posicionamento';

  @override
  String get showLegalMoves => 'Mostrar movimentos legais';

  @override
  String get showLastMove => 'Mostrar última jogada';

  @override
  String get showArrows => 'Mostrar setas';

  @override
  String get pieces => 'Peças';

  @override
  String get showAnalysis => 'Mostrar análise';

  @override
  String get threads => 'Tópicos';

  @override
  String get getInvolved => 'Envolva-se';

  @override
  String get helpImproveTranslate => 'Ajude a melhorar a tradução';

  @override
  String get tutorial => 'Tutorial';

  @override
  String get classicMill => 'Moinho clássico';

  @override
  String get mixedMill => 'Moinho misto';

  @override
  String get ceylonMill => 'Moinho do Ceilão';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'O moinho pode ser quebrado e refeito repetidamente';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Se um jogador quebra um moinho para criar um novo moinho imediatamente, esse jogador pode mover essa peça de volta para o ponto original em sua próxima jogada se ela formar um novo moinho.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'O jogo é empatado se um jogador tiver três peças e depois de dez jogadas nenhum dos jogadores remover as peças do adversário';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Quando um jogador tem três peças e nenhum dos jogadores pode remover uma peça do adversário em dez jogadas, o jogo é um empate.';

  @override
  String get close => 'Fechar';

  @override
  String get whitePiece => 'Peça branca';

  @override
  String get blackPiece => 'Peça preta';

  @override
  String get emptyPoint => 'Ponto vazio';

  @override
  String get noPoint => 'Nenhum ponto';

  @override
  String get placingPhase => 'Fase de colocação';

  @override
  String get movingPhase => 'Fase móvel';

  @override
  String get flyingPhase => 'Fase de vôo';

  @override
  String sideToMove(Object player) {
    return 'Lado para mover: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Última jogada: $move';
  }

  @override
  String get selected => 'Selecionado';

  @override
  String get accessibility => 'Acessibilidade';

  @override
  String get screenReaderSupport => 'Suporte para leitor de tela';

  @override
  String get isDraw => 'É um empate!';

  @override
  String get draw => 'Empate';

  @override
  String get pieceHighlightColor => 'Cor de destaque da peça';

  @override
  String get algorithm => 'Algoritmo';

  @override
  String get endgameNMoveRule => 'Regra dos N movimentos';

  @override
  String get endgameNMoveRule_Detail =>
      'Se um dos jogadores tiver apenas três peças e nenhum dos jogadores remover uma peça dentro de um movimento específico, o jogo é declarado empate.';

  @override
  String get drawReasonEndgameRule50 =>
      'Cada jogador tem apenas três peças e nenhum jogador remove uma peça dentro de um movimento específico.';

  @override
  String get threefoldRepetitionRule => 'Regra de repetição tripla';

  @override
  String get threefoldRepetitionRule_Detail =>
      'O jogo empata se ocorrer uma posição pela terceira vez.';

  @override
  String get continueToMakeMove => 'Moinho! Continue a fazer um movimento.';

  @override
  String get pointStyle => 'Estilo do ponto';

  @override
  String get pointWidth => 'Largura do ponto';

  @override
  String get solid => 'Sólido';

  @override
  String get hollow => 'Oco';

  @override
  String get languageName => 'Português';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count jogadas',
      one: '$count jogada',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Erro de carregamento.';

  @override
  String get filename => 'Nome do arquivo';

  @override
  String get browse => 'Navegar…';

  @override
  String get gameFiles => 'Arquivos do jogo';

  @override
  String get gameSavedTo => 'O jogo é salvo em';

  @override
  String get empty => 'Vazio';

  @override
  String get noMove => 'Nenhum movimento.';

  @override
  String get restoredPosition => 'Posição inicial restaurada.';

  @override
  String get clean => 'Limpar';

  @override
  String get cleanedUp => 'Limpo.';

  @override
  String get remove => 'Remover';

  @override
  String get noPiecesCanBeRemoved => 'Nenhuma peça pode ser removida.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pieces',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 precisam ser removidos.';
  }

  @override
  String placedCount(int count) {
    return 'Coloc. ($count)';
  }

  @override
  String get placedPieceCount =>
      'Contagem de peças colocadas na fase de colocação.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'O jogador atual colocou peças $count.';
  }

  @override
  String get notPlacingPhase => 'Não colocar fase, não pode alterá-la.';

  @override
  String get paste => 'Colar';

  @override
  String get pasteDone => 'A pasta está pronta.';

  @override
  String get cannotPaste => 'Não é possível colar.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Mostrar peças não colocadas e removidas';

  @override
  String get fullScreen => 'Tela cheia';

  @override
  String get reopenToTakeEffect =>
      'Saia e reabra o aplicativo para que as configurações entrem em vigor.';

  @override
  String get forest => 'Floresta';

  @override
  String get desktopImage => 'Imagem da área de trabalho';

  @override
  String get invalidPosition => 'Posição inválida';

  @override
  String get shareGIF => 'Compartilhar um GIF';

  @override
  String get pixelRatio => 'Proporção de pixels';

  @override
  String get duration => 'Duração';

  @override
  String get gameScreenRecorder => 'Gravador de tela para jogos';

  @override
  String get previous => 'Anterior';

  @override
  String get next => 'Próximo';

  @override
  String get skip => 'Pular';

  @override
  String get gotIt => 'Entendi';

  @override
  String get youCanModifyRules =>
      'Você pode modificar as regras do jogo nas configurações de regras.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Você pode usar a roda do mouse para alterar o valor no seletor.';

  @override
  String get noTimeLimitForThinking =>
      'Tempo de raciocínio da IA definido como 0 significa que não há limite de tempo para pensar.';

  @override
  String get whatIsMtdf =>
      'MTD(f) é uma forma modificada do algoritmo de busca alfa-beta que visa melhorar a eficiência, reutilizando os resultados intermediários da busca e usando uma boa estimativa inicial para reduzir o tempo de busca.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Por favor, note que o ajuste do tempo de raciocínio da IA pode não ser totalmente preciso. O tempo real de raciocínio pode ser mais curto se a dificuldade for definida como um valor mais baixo, e pode ser mais longo se a IA estiver pensando quando o tempo acabar.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Se você definir a dificuldade alta, mas não aumentar o tempo de raciocínio da IA, o nível de dificuldade real pode ser limitado a um valor mais baixo devido à limitação do tempo de raciocínio. O valor real pode variar dependendo do desempenho da máquina.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) é um algoritmo de busca para encontrar o melhor movimento em uma determinada posição. É um aprimoramento do algoritmo alfa-beta e usa pesquisas de janela nula ou zero para confirmar se um movimento é pior ou não pior do que uma pontuação já segura da variação principal. O PVS se concentra nos movimentos mais promissores e evita buscas desnecessárias de ramificações abaixo do ideal, o que ajuda a melhorar a eficiência da busca.';

  @override
  String get whatIsAlphaBeta =>
      'O algoritmo alfa-beta é um algoritmo de busca para encontrar o melhor lance. Utiliza o princípio minimax e dois valores, alfa e beta, para reduzir o espectro de buscas e aumentar a eficiência. Alfa representa a pontuação mínima que o computador está seguro de obter, enquanto beta representa a pontuação máxima que o oponente pode obter. O algoritmo ajuda o computador a tomar decisões inteligentes e eficientes durante uma partida.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'De acordo com a experiência humana, se você tentar ganhar, perderá. Em vez disso, busque o empate como objetivo e evite perder a partida. Observe seu oponente e conduza-o suavemente a uma posição em que possa cometer erros. Quando mostrar fraqueza, aproveite a oportunidade e pressione suavemente para vencer. Dessa forma, você poderá ganhar a partida.';

  @override
  String get firstMoveDetail =>
      'Neste jogo, é mais fácil para o segundo jogador vencer em comparação com o primeiro jogador.';

  @override
  String get passiveDetail =>
      'Ativar a opção Passivo fará com que a IA relaxe quando tiver vantagem na posição, em vez de tentar ganhar agressivamente o mais rápido possível.';

  @override
  String get moveRandomlyDetail =>
      'Ativar essa opção aumenta a aleatoriedade e a diversão do jogo, enquanto desativá-la pode ajudar a estudar formas de vencer a IA.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Se a IA levar em conta a mobilidade de suas peças, ela não só tentará capturar as peças do oponente o mais rápido possível, mas também bloqueará os movimentos do adversário e evitará que ele faça o mesmo.';

  @override
  String get whenBoardIsFull => 'Quando o tabuleiro está cheio';

  @override
  String get whenBoardIsFull_Detail =>
      'No final da fase de colocação, antes do início da fase de movimento, a ação segue se o tabuleiro estiver cheio de peças.';

  @override
  String get sideToMoveRemovePiece =>
      'O jogador que se move primeiro na fase de movimento remove uma das peças do adversário.';

  @override
  String get agreeToDraw => 'Ambos os lados concordam com um empate.';

  @override
  String get takeOpponentsPiece => 'Pegue uma das peças do seu oponente.';

  @override
  String get firstPlayerLose => 'O primeiro jogador perde o jogo.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'O primeiro e o segundo jogadores removem uma das peças do adversário.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'O segundo e o primeiro jogadores removem uma das peças do adversário.';

  @override
  String get enteredFlyingPhase =>
      'Agora que entrou na fase de vôo, as peças do adversário podem pular para qualquer ponto vazio do tabuleiro. Você pode desativar a regra de vôo nas \"Configurações de regras\".';

  @override
  String get whenStalemate => 'Quando o impasse';

  @override
  String get whenStalemate_Detail =>
      'Que ação se segue quando nenhuma peça pode ser movida?';

  @override
  String get endWithStalemateLoss => 'Terminar com uma perda por impasse.';

  @override
  String get changeSideToMove => 'Mude o lado para mover.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Remova uma das peças do adversário e faça o próximo movimento.';

  @override
  String get endWithStalemateDraw => 'Terminar com um empate por impasse.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Remova uma das peças do adversário e mude o lado para mover.';

  @override
  String get aiResponseDelayTime => 'Tempo de atraso de resposta de IA';

  @override
  String get aiIsDelaying =>
      'A IA está atualmente em uma fase de resposta atrasada. Aguarde um pouco antes de prosseguir.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Você não pode remover uma peça não adjacente.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Em caso de impasse, as peças do adversário adjacentes às suas podem ser removidas, independentemente da formação do moinho.';

  @override
  String get whatIsMcts =>
      'O MCTS é um algoritmo amigável para iniciantes que toma decisões explorando e avaliando diferentes movimentos por meio de simulações.';

  @override
  String get goldenJade => 'Jade dourado';

  @override
  String get forestWood => 'Madeira da floresta';

  @override
  String get darkMystery => 'Mistério escuro';

  @override
  String get midnightBlue => 'Azul meia-noite';

  @override
  String get greenForest => 'Floresta verde';

  @override
  String get greenMeadow => 'Prado verde';

  @override
  String get stonyPath => 'Caminho de pedra';

  @override
  String get pastelPink => 'Rosa pastel';

  @override
  String get turquoiseSea => 'Água do mar turquesa';

  @override
  String get violetDream => 'Sonho violeta';

  @override
  String get mintChocolate => 'Chocolate com menta';

  @override
  String get skyBlue => 'Céu azul';

  @override
  String get playfulGarden => 'Jardim lúdico';

  @override
  String get whatIsRetrogradeAnalysis =>
      'O algoritmo de análise retrógrada utiliza uma análise retrógrada de múltiplos valores para criar uma base de dados de finais a partir de diferentes posições iniciais e depois aplica essa base para otimizar o jogo. Esta abordagem está incluída na categoria de soluções ultrafortes.';

  @override
  String get viewAlgorithmGuide =>
      'Deseja consultar o guia do usuário deste algoritmo?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Visualização do indicador de vantagem posicional';

  @override
  String get usePerfectDatabase => 'Usar uma base de dados perfeita';

  @override
  String get perfectDatabaseDescription =>
      'Ative esta opção para usar uma base de dados de partidas impecável gerada por algoritmos de última geração. Esta função integra estratégias de abertura e finais para sugerir jogadas ótimas. É a opção preferida pelos jogadores que buscam o mais alto nível de precisão no jogo. Criada através de técnicas computacionais meticulosas, a base de dados é projetada para fornecer soluções de jogo quase perfeitas.\n\nNota: Se a IA não conseguir acessar a base de dados, recorrerá aos algoritmos convencionais para tomar decisões de jogo. Quando a base de dados está disponível, o \'Nível de Dificuldade\' se torna virtualmente imbatível e o \'Tempo de Pensamento da IA\' experimenta uma redução drástica. Muitas configurações das opções de \'Estilo de jogo da IA\' serão anuladas, pois os resultados da base de dados têm a máxima prioridade.\n\nPara saber como tirar o máximo proveito desta base de dados impecável, clique aqui.';

  @override
  String get backgroundImage => 'Imagem de fundo';

  @override
  String get whatIsRandom =>
      'Quando a opção \'Usar base de dados perfeita\' não está ativada, o ajuste \'Aleatório\' faz com que a IA mova as peças aleatoriamente, sem usar nenhum algoritmo para seleção de movimentos. O resultado é geralmente um jogo muito mais fraco. Por outro lado, quando a opção \'Usar base de dados perfeita\' está ativada, a IA depende exclusivamente da \'Base de Dados Perfeita\' para tomar decisões, em vez de combiná-la com algoritmos tradicionais de IA. Neste modo, os movimentos da IA são baseados completamente no conteúdo da base de dados, evitando cálculos em tempo real ou algoritmos de busca.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Remova a(s) peça(s) do oponente da mão dele; depois é a vez do oponente de colocar.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Ao formar moinhos durante a fase de colocação';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Remova a(s) peça(s) do oponente do tabuleiro.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Remova a(s) peça(s) do oponente do tabuleiro; depois é a vez do oponente de colocar.';

  @override
  String get opponentRemovesOwnPiece =>
      'O oponente remove sua(s) própria(s) peça(s) do tabuleiro.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Em vez de você tomar uma ação, o oponente escolhe e remove sua(s) própria(s) peça(s) do tabuleiro, efetivamente tomando uma ação que é prejudicial a si mesmo.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Remova a(s) peça(s) do oponente da mão dele; depois é a sua vez de mover.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Remova a(s) peça(s) da mão do oponente. Se, de acordo com a configuração de Remoção Múltipla, múltiplas peças devem ser removidas e o oponente não tiver mais peças na mão, continue removendo as peças do oponente do tabuleiro. Então, é a sua vez de mover. Se você continuar formando moinhos, pode continuar removendo as peças do oponente.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Remova a(s) peça(s) da mão do oponente. Se, de acordo com a configuração de Remoção Múltipla, múltiplas peças devem ser removidas e o oponente não tiver mais peças na mão, continue removendo as peças do oponente do tabuleiro. Então, é a vez do oponente de mover.';

  @override
  String get markAndDelayRemovingPieces =>
      'Marque e atrase a remoção de peças.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Durante a fase de colocação, as peças a serem removidas são marcadas, e para ambos os jogadores, novas peças não podem ser colocadas nesses pontos. Ao entrar na fase de movimento, essas peças marcadas são removidas juntas, e os jogadores podem então mover suas peças para esses pontos agora vazios.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'As ações que podem ser tomadas ao formar moinhos durante a fase de colocação.';

  @override
  String get marked => 'Marcado';

  @override
  String get menu => 'Menu';

  @override
  String get monochrome => 'Monocromático';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Você pode ativar o suporte para leitor de tela nas configurações de Acessibilidade em Configurações Gerais.';

  @override
  String get showNumbersOnPieces => 'Mostrar números nas peças';

  @override
  String get saveImage => 'Guardar imagem';

  @override
  String get isAnalysisToolbarShown =>
      'Mostrar barra de ferramentas de análise';

  @override
  String get analysisToolbarBackgroundColor =>
      'Cor de fundo da barra de ferramentas de análise';

  @override
  String get analysisToolbarIconColor =>
      'Cor do ícone da barra de ferramentas de análise';

  @override
  String get transformed => 'Transformado.';

  @override
  String get cannotTransform => 'Não é possível transformar.';

  @override
  String get rotate => 'Girar';

  @override
  String get horizontalFlip => 'Inv. H.';

  @override
  String get verticalFlip => 'Inv. V.';

  @override
  String get innerOuterFlip => 'Inv. I/E';

  @override
  String get transparentCanvas => 'Tela Transparente';

  @override
  String get restrictRepeatedMillsFormation =>
      'Restringir a formação repetida de moinhos';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Uma peça movida de um moinho para formar outro não pode retornar imediatamente ao ponto original na próxima jogada para formar um moinho novamente. Primeiro, é necessário um movimento diferente.';

  @override
  String get oneTimeUseMill => 'Moinho de uso único';

  @override
  String get oneTimeUseMill_Detail =>
      'Cada moinho pode remover uma peça do adversário apenas uma vez. Você pode reformá-lo novamente, mas não pode ser usado para remoções adicionais.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'As regras atuais que você definiu não têm um banco de dados perfeito correspondente. Para mais informações sobre o banco de dados perfeito, clique aqui.';

  @override
  String get focusOnBlockingPaths => 'Concentre-se em bloquear caminhos';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Durante fases específicas do jogo, priorize obstruir o movimento do oponente em vez de formar moinhos. Em vez de focar em remover peças completando moinhos, a IA visa aprisionar o adversário durante essas fases, incapacitando-o de se mover e garantindo a vitória por desgaste em vez de jogo agressivo.';

  @override
  String get pieceImage => 'Imagem da peça';

  @override
  String get importColorSettings => 'Importar configurações de cor';

  @override
  String get exportColorSettings => 'Exportar configurações de cor';

  @override
  String get import => 'Importar';

  @override
  String get export => 'Exportar';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Por favor, copie as configurações do formato JSON para a área de transferência primeiro.';

  @override
  String get copiedToClipboard => 'Copiado para a área de transferência.';

  @override
  String get imported => 'Importado.';

  @override
  String get boardImage => 'Imagem do tabuleiro';

  @override
  String get autumnLeaves => 'Folhas de Outono';

  @override
  String get legendaryLand => 'Terra Lendária';

  @override
  String get vignetteEffect => 'Efeito vinheta';

  @override
  String get promptMakeToolbarTransparent =>
      'Gostaria de tornar a barra de ferramentas totalmente transparente quando uma imagem de fundo do tabuleiro estiver definida?';

  @override
  String get vibration => 'Ativar vibração no jogo';

  @override
  String get soundTheme => 'Tema de som';

  @override
  String get ball => 'Bola';

  @override
  String get liquid => 'Líquido';

  @override
  String get wood => 'Madeira';

  @override
  String get placeEffectAnimation => 'Efeito de animação ao colocar peça';

  @override
  String get removeEffectAnimation => 'Efeito de animação ao remover peça';

  @override
  String get isToolbarAtBottom =>
      'Mostrar a barra de ferramentas na parte inferior';

  @override
  String get boardCornerRadius => 'Raio do canto do tabuleiro';

  @override
  String get useOpeningBook => 'Usar livro de abertura';

  @override
  String get currentRule => 'Atual';

  @override
  String get nineMensMorris => 'Trilha';

  @override
  String get twelveMensMorris => 'Trilha de Doze Homens';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Duz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Conjunto de regras';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'Moinho único';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Permita que a IA utilize movimentos de abertura comumente empregados por jogadores humanos profissionais durante o início do jogo. Nota: Esta funcionalidade está atualmente disponível apenas para conjuntos de regras específicos.';

  @override
  String get showAdvantageGraph => 'Mostrar gráfico de vantagem';

  @override
  String get advantageGraphHint =>
      'O gráfico de vantagem só será desenhado depois que a IA fizer uma jogada. Não será desenhado quando o jogador humano fizer uma jogada.';

  @override
  String get removalBasedOnMillCounts =>
      'Desative a remoção até que todas as peças tenham sido colocadas. Em seguida, remova as peças com base na contagem de moinhos.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Desative a remoção até que todas as peças tenham sido colocadas. Em seguida, remova as peças com base na contagem de moinhos: se forem iguais, ambos removem a mesma quantidade; se um tiver mais, remove uma peça extra, mantendo a diferença de apenas uma peça. Se apenas um formar moinhos, ele remove duas peças e o outro remove uma. Se nenhum formar moinhos, ambos removem uma de suas próprias peças.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Selecione uma das suas peças.';

  @override
  String get notYourTurn => 'Não é a sua vez.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Cor de fundo da barra de ferramentas de anotações';

  @override
  String get annotationToolbarIconColor =>
      'Cor dos ícones da barra de ferramentas de anotações';

  @override
  String get isAnnotationToolbarShown =>
      'Mostrar barra de ferramentas de anotações';

  @override
  String get enterAnnotationMode => 'Entrar no modo de anotação';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Tem certeza de que deseja limpar todas as anotações?';

  @override
  String get llmPromptCopiedToClipboard =>
      'Prompt LLM copiado para a área de transferência.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Conexão recusada, o servidor pode estar fora do ar.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Descoberta bem-sucedida, aguardando conexão...';

  @override
  String get noLanConnection => 'Sem conexão LAN';

  @override
  String get takeScreenshot => 'Capturar tela';

  @override
  String get disconnectedFromOpponent => 'Desconectado do oponente.';

  @override
  String get takeBackRequest => 'Pedido de desfazer jogada';

  @override
  String get nothingToShow => 'Nada para mostrar.';

  @override
  String get stopHosting => 'Parar de hospedar';

  @override
  String get connectionResetByPeer => 'Conexão reiniciada pelo par.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Conexão perdida devido ao tempo limite do heartbeat. Por favor, reconecte-se.';

  @override
  String get startHosting => 'Iniciar hospedagem';

  @override
  String get restartRequestRejected => 'Pedido de reinício rejeitado.';

  @override
  String get notConnectedToLanOpponent => 'Não conectado ao oponente LAN.';

  @override
  String get llmPrompt => 'Prompt LLM';

  @override
  String get gameRestarted => 'Jogo reiniciado.';

  @override
  String get takeBackRejected => 'Desfazer jogada rejeitado.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Tem certeza de que deseja desistir deste jogo?';

  @override
  String get opponentResignedYouWin => 'O oponente desistiu. Você venceu!';

  @override
  String get clearAllAnnotations => 'Limpar todas as anotações';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Conectado, aguardando a jogada do oponente...';

  @override
  String get networkStatusDisconnected => 'Status da rede: Desconectado';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Pedido de desfazer jogada enviado ao oponente.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'O oponente pode ter saído do jogo';

  @override
  String get connectedToHostSuccessfully => 'Conectado ao host com sucesso.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Conexão perdida: tempo limite do heartbeat';

  @override
  String get noHostDiscovered => 'Nenhum host encontrado.';

  @override
  String get confirmResignation => 'Confirmar desistência';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Iniciou a hospedagem do jogo, aguardando jogadores para entrar...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Tempo de conexão esgotado, conexão de rede instável.';

  @override
  String get noLlmPromptAvailable => 'Nenhum prompt LLM disponível.';

  @override
  String get youResignedGameOver => 'Você desistiu. Fim de jogo.';

  @override
  String get serverIp => 'IP do servidor';

  @override
  String get confirmClear => 'Confirmar limpeza';

  @override
  String get opponentSTurn => 'Vez do oponente.';

  @override
  String get waitingAClientConnection => 'Aguardando conexão de um cliente...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Pedido de desfazer jogada foi rejeitado ou falhou.';

  @override
  String get addText => 'Adicionar texto';

  @override
  String get exitAnnotationMode => 'Sair do modo de anotação';

  @override
  String get typeYourAnnotation => 'Digite sua anotação';

  @override
  String get attemptingToReconnect => 'Tentando reconectar...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Pedido de reinício enviado. Aguardando resposta do oponente...';

  @override
  String get serverIsStopped => 'Servidor parado.';

  @override
  String get restartRequest => 'Pedido de reinício';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Não é possível solicitar desfazer jogada quando não é a sua vez.';

  @override
  String get takeBackAccepted => 'Pedido de desfazer jogada aceito.';

  @override
  String get localNetworkSettings => 'Configurações de rede local';

  @override
  String get reconnectedSuccessfully => 'Reconectado com sucesso!';

  @override
  String get failedToSaveImageToGallery =>
      'Falha ao salvar a imagem na Galeria.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'O oponente solicitou reiniciar o jogo. Você aceita?';

  @override
  String get yourTurn => 'Sua vez.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Não foi possível reconectar, por favor reinicie o jogo.';

  @override
  String get host => 'Host';

  @override
  String get join => 'Entrar';

  @override
  String get port => 'Porta';

  @override
  String get invalidIpAddress => 'Endereço IP inválido.';

  @override
  String get invalidPort => 'Porta inválida.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Conectando: Tentativa $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Falha ao conectar: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Falha ao iniciar a hospedagem: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Host descoberto: $ip:$port';
  }

  @override
  String get stop => 'Parar';

  @override
  String get discover => 'Descobrir';

  @override
  String get connect => 'Conectar';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Cliente conectado: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Descobrindo: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Reconectando ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Conectado';

  @override
  String get delete => 'Excluir';

  @override
  String get ancientEgypt => 'Herança Marajoara';

  @override
  String get gothicIce => 'Neve da Serra Gaúcha';

  @override
  String get riceField => 'Arrozais do Pantanal';

  @override
  String get chinesePorcelain => 'Faiança das Caldas';

  @override
  String get desertDusk => 'Crepúsculo Sertanejo';

  @override
  String get precisionCraft => 'Artesanato de Precisão';

  @override
  String get folkEmbroidery => 'Bordado de Viana';

  @override
  String get carpathianHeritage => 'Herança de Minas';

  @override
  String get imperialGrandeur => 'Suntuosidade Imperial';

  @override
  String get bohemianCrystal => 'Cristal Lusitano';

  @override
  String get savannaSunrise => 'Sol do Cerrado';

  @override
  String get harmonyBalance => 'Harmonia Tropical';

  @override
  String get cinnamonSpice => 'Aroma de Canela';

  @override
  String get anatolianMosaic => 'Copacabana';

  @override
  String get carnivalSpirit => 'Alegria de Carnaval';

  @override
  String get custom => 'Sob Medida';

  @override
  String get spiceMarket => 'Mercado Ver-o-Peso';

  @override
  String get swipeToRevealTheDrawer => 'Deslize para revelar a gaveta';

  @override
  String get showGameInfoOnScreenshots =>
      'Mostrar informações do jogo nas capturas de tela';

  @override
  String get humanMoveTime => 'Limite de tempo humano';

  @override
  String get noTimeLimitForHumanMoves =>
      'Sem limite de tempo para movimentos humanos';

  @override
  String get timeoutLoseWillBeApplied =>
      'A perda por tempo limite será aplicada ao jogador humano';

  @override
  String get identifyingBoard => 'Identificando o tabuleiro...';

  @override
  String get youCanEnterAnyModelName =>
      'Você pode inserir qualquer nome de modelo.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Posição do tabuleiro aplicada. FEN copiado para a área de transferência.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Sugestão: tente tirar uma foto mais nítida do tabuleiro.';

  @override
  String get llmPromptTemplate => 'Template de prompt do LLM';

  @override
  String get noValidBoardDetected => 'Nenhum tabuleiro válido detectado.';

  @override
  String get selectingImageFromAlbum => 'Selecionando imagem do álbum...';

  @override
  String get configurePromptTemplate => 'Configurar template de prompt';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Editar template de prompt para análise do LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Falha ao gerar FEN a partir do tabuleiro reconhecido.';

  @override
  String get outputInCurrentLanguage => 'Saída no idioma atual';

  @override
  String get commonBaseUrls => 'URLs Base comuns';

  @override
  String get viewCommonModels => 'Ver modelos comuns';

  @override
  String get recognitionParametersUpdated =>
      'Parâmetros de reconhecimento atualizados.';

  @override
  String get whiteSMove => 'Vez das brancas';

  @override
  String get resetToDefaults => 'Restaurar padrões';

  @override
  String get photoShoot => 'Sessão de fotos';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Falha ao aplicar posição do tabuleiro reconhecido.';

  @override
  String get llmPromptContent => 'Conteúdo do prompt do LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM não configurado. Verifique suas configurações.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Definir provedor, modelo, API Key e Base URL';

  @override
  String get llmConfiguration => 'Configuração do LLM';

  @override
  String get configureLlmProvider => 'Configurar provedor do LLM';

  @override
  String get llmPromptTemplateHeader =>
      'Cabeçalho do template de prompt do LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Nenhuma peça foi reconhecida na imagem. Tente novamente.';

  @override
  String get recognizeBoardFromImage => 'Reconhecer tabuleiro na imagem';

  @override
  String get viewTips => 'Ver dicas';

  @override
  String get applyToBoard => 'Aplicar ao tabuleiro';

  @override
  String get adjustBoardArea => 'Ajustar área do tabuleiro';

  @override
  String get viewCommonUrls => 'Ver URLs comuns';

  @override
  String get colorAnalysisFailed => 'Falha na análise de cores!';

  @override
  String get analyzingGameBoardImage => 'Analisando imagem do tabuleiro...';

  @override
  String get selectFromAlbum => 'Selecionar do álbum';

  @override
  String get noBoardPointDetected => 'Nenhum ponto no tabuleiro detectado!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Se ficar vazio, o template padrão será usado';

  @override
  String get llmConfig => 'Configuração do LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Tem certeza de que deseja restaurar os templates de prompt para os valores padrão?';

  @override
  String get llmPromptTemplateFooter => 'Rodapé do template de prompt do LLM';

  @override
  String get loadingResponse => 'Carregando resposta...';

  @override
  String get applyThisResultToBoard => 'Aplicar este resultado ao tabuleiro';

  @override
  String get takingPicture => 'Tirando foto...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Por favor, selecione uma imagem do tabuleiro para identificar';

  @override
  String get identificationResults => 'Resultados da identificação';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analise as jogadas e forneça insights.';

  @override
  String get getApiKey => 'Obter API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Não foi possível concluir todo o processo de reconhecimento.';

  @override
  String get boardRecognitionResult =>
      'Resultado do reconhecimento do tabuleiro';

  @override
  String get askLlm => 'Perguntar ao LLM';

  @override
  String get boardDetectionFailed => 'Falha na detecção do tabuleiro!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Nenhum ponto no tabuleiro detectado, não é possível identificar a peça!';

  @override
  String get copyFen => 'Copiar FEN';

  @override
  String get commonlyUsedModels => 'Modelos mais usados';

  @override
  String get apiKeyOptional => 'API Key (opcional)';

  @override
  String get noImageSelected => 'Nenhuma imagem selecionada';

  @override
  String get blackSMove => 'Vez das pretas';

  @override
  String get llm => 'Grande Modelo de Linguagem';

  @override
  String get llmProvider => 'Fornecedor';

  @override
  String get baseUrl => 'URL base';

  @override
  String get model => 'Modelo';

  @override
  String get temperature => 'Temperatura';

  @override
  String get llmCommandReceivedProcessing =>
      'Comando recebido! A IA está processando...';

  @override
  String get llmDeepThinkingWait =>
      'Pensamento profundo em andamento, aguarde...';

  @override
  String get llmPresentingSoon => 'Será apresentado em breve...';

  @override
  String get recognitionParameters => 'Parâmetros de reconhecimento';

  @override
  String get adjustParamsDesc =>
      'Ajuste os parâmetros para melhorar a precisão do reconhecimento';

  @override
  String get saveParameters => 'Salvar parâmetros';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Não foi possível iniciar o reconhecimento de imagem: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Falha no reconhecimento de imagem: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Posição aplicada com $whiteCount peças brancas e $blackCount peças pretas';
  }

  @override
  String get fenCopiedToClipboard =>
      '(FEN copiado para a área de transferência)';

  @override
  String recognitionFailed(String error) {
    return 'Falha no reconhecimento: $error';
  }

  @override
  String get myRating => 'Minha classificação';

  @override
  String get gamesPlayed => 'Jogos disputados';

  @override
  String get wins => 'Vitórias';

  @override
  String get losses => 'Derrotas';

  @override
  String get draws => 'Empates';

  @override
  String get lastUpdated => 'Última atualização';

  @override
  String get format => 'Formato:';

  @override
  String get resetStatistics => 'Redefinir estatísticas';

  @override
  String get drawRate => 'Taxa de empate';

  @override
  String get lossRate => 'Taxa de derrota';

  @override
  String get aiStatistics => 'Estatísticas de IA';

  @override
  String get enableStatistics => 'Ativar estatísticas';

  @override
  String get enableStatistics_Detail =>
      'Quando ativado, os resultados dos jogos serão registrados nas estatísticas. No entanto, jogos envolvendo retrocessos não serão registrados. Quando desativado, a coleta de estatísticas é pausada.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Isso redefinirá todas as estatísticas do jogo. Esta ação não pode ser desfeita.';

  @override
  String get boardInnerRingSize => 'Tamanho do anel interno do tabuleiro';

  @override
  String get boardShadowEnabled => 'Sombra do tabuleiro';

  @override
  String get trapAwareness => 'Detecção de armadilhas';

  @override
  String get trapAwarenessDescription =>
      'Realce os movimentos de armadilha com círculos e setas em negrito durante a análise.';

  @override
  String trapExists(String trapMoves) {
    return 'Há uma armadilha. Movimentos de armadilha: $trapMoves';
  }

  @override
  String get custodianCapture => 'Captura de flanqueamento';

  @override
  String get custodianCaptureDescription =>
      'Coloque uma das peças do seu oponente entre duas delas em uma linha reta para capturá -la.';

  @override
  String get custodianCaptureEnable => 'Permitir captura de flanqueamento';

  @override
  String get interventionCapture => 'Captura de intervenção';

  @override
  String get interventionCaptureDescription =>
      'Mova -se para o ponto vazio entre duas das peças do seu oponente para capturar os dois.';

  @override
  String get interventionCaptureEnable => 'Permitir captura de intervenção';

  @override
  String get leapCapture => 'Captura de salto';

  @override
  String get leapCaptureDescription =>
      'Capture pulando sobre a peça de um oponente adjacente no ponto vazio além.';

  @override
  String get leapCaptureEnable => 'Permita captura de salto';

  @override
  String get captureApplicableLines => 'Linhas aplicáveis';

  @override
  String get captureSquareEdges => 'Ao longo das bordas da praça';

  @override
  String get captureCrossLines =>
      'Ao longo das linhas ortogonais cruzando o quadrado';

  @override
  String get captureDiagonalLines =>
      'Ao longo das linhas diagonais cruzando o quadrado';

  @override
  String get captureExecutionPhases => 'Fases de execução';

  @override
  String get capturePiecesCondition =>
      'Disponibilidade durante a fase móvel com base nas peças restantes';

  @override
  String get capturePiecesConditionUnlimited => 'Sem restrição';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Disponível quando você tem três ou menos peças';
}
