// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Polish (`pl`).
class SPl extends S {
  SPl([String locale = 'pl']) : super(locale);

  @override
  String get appName => 'Młynek';

  @override
  String get welcome => 'Witaj';

  @override
  String get yes => 'Tak';

  @override
  String get no => 'Nie';

  @override
  String get game => 'Gra';

  @override
  String get humanVsAi => 'Człowiek kontra SI';

  @override
  String get humanVsHuman => 'Człowiek kontra człowiek';

  @override
  String get aiVsAi => 'AI kontra AI';

  @override
  String get humanVsCloud => 'Człowiek kontra chmura';

  @override
  String get humanVsLAN => 'Człowiek kontra sieć LAN';

  @override
  String get testViaLAN => 'Testy przez sieć LAN';

  @override
  String get move => 'Przesuń';

  @override
  String get showMoveList => 'Lista ruchów';

  @override
  String get moveList => 'Lista ruchów';

  @override
  String get noGameRecord => 'Brak zapisu';

  @override
  String get ok => 'OK';

  @override
  String get confirm => 'Potwierdź';

  @override
  String get cancel => 'Anuluj';

  @override
  String get tipSelectWrong => 'Wybrałeś niewłaściwy pionek.';

  @override
  String get tipPlace => 'Umieść swoje elementy.';

  @override
  String get tipBanPlace => 'Nie można go tu umieścić.';

  @override
  String get tipPlaced => 'Umieszczone.';

  @override
  String get tipRemove => 'Usuń element.';

  @override
  String get tipBanRemove => 'Nie można usunąć.';

  @override
  String get tipRemoved => 'Usunięty.';

  @override
  String get tipMove => 'Przesuń element.';

  @override
  String get tipCannotPlace => 'Nie możesz umieścić swojego kawałka tutaj.';

  @override
  String get tipCannotMove => 'Nie możesz przesunąć swojego kawałka tutaj.';

  @override
  String get tipMill => 'Młyn! Usuń pionek przeciwnika.';

  @override
  String get tipContinueMill => 'Kontynuuj usuwanie pionka przeciwnika.';

  @override
  String get tipSelectOpponentsPiece => 'Wybierz jeden z pionków przeciwnika.';

  @override
  String get tipCannotRemovePieceFromMill => 'Nie można usunąć pionka z młyna.';

  @override
  String get tipCanMoveOnePoint => 'Kawałek może poruszyć się o 1 punkt.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Nie możesz poruszyć kawałków przeciwnika.';

  @override
  String get tipSelectPieceToMove =>
      'Wybierz swoją figurkę, którą chcesz poruszyć.';

  @override
  String get tipHaveThreePiecesLeft => 'Zostały Ci 3 pionki.';

  @override
  String get tipCanMoveToAnyPoint => 'Możesz poruszyć się do dowolnego punktu.';

  @override
  String tipToMove(Object player) {
    return '$player, aby się przenieść.';
  }

  @override
  String get whiteWin => 'Gracz 1 wygrywa!';

  @override
  String get blackWin => 'Gracz 2 wygrywa!';

  @override
  String get won => 'Wygrana';

  @override
  String get lost => 'Przegrany';

  @override
  String get thinking => 'Myśląc…';

  @override
  String get newGame => 'Nowa gra';

  @override
  String get importGame => 'Importuj grę';

  @override
  String get exportGame => 'Eksportuj grę';

  @override
  String get gameImported => 'Gra zaimportowana.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Nie można importować $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Ruchy i zasady nie pasują do siebie.';

  @override
  String get pleaseWait => 'Proszę czekać...';

  @override
  String get restartGame => 'Zrestartować bieżącą grę?';

  @override
  String get restart => 'Uruchom ponownie';

  @override
  String get gameStarted => 'Gra rozpoczęta, proszę umieścić.';

  @override
  String get analyzing => 'Analizuję…';

  @override
  String error(Object message) {
    return 'Błąd: $message';
  }

  @override
  String get winRate => 'Wskaźnik zwycięstwa';

  @override
  String get score => 'Wynik:';

  @override
  String get white => 'Gracz 1';

  @override
  String get black => 'Gracz 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player liczba sztuk jest mniejsza niż trzy.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player zrezygnował.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player nie może wykonać ruchu.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Plansza jest pełna i $player nie ma dokąd pójść.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Czas się skończył, $player przegrał.';
  }

  @override
  String get drawReasonRule50 =>
      'W fazie ruchu, żaden element nie został usunięty w ciągu ostatniej określonej liczby ruchów.';

  @override
  String get drawReasonBoardIsFull =>
      'Jest to remis, ponieważ plansza jest pełna.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Jest to Remis z powodu potrójnego powtórzenia.';

  @override
  String get gameOverUnknownReason => 'Koniec gry! Nieznany powód.';

  @override
  String get gameOver => 'Koniec gry';

  @override
  String get youWin => 'Wygrałeś! Gratulacje!';

  @override
  String challengeHarderLevel(int level) {
    return 'Zmierz się z trudniejszym poziomem? Nowy poziom będzie poziomem $level!';
  }

  @override
  String get youLose => 'Przegrałeś!';

  @override
  String get analyze => 'Przeanalizuj';

  @override
  String get about => 'Informacje o';

  @override
  String version(Object versionNumber) {
    return 'Wersja: $versionNumber';
  }

  @override
  String get thanks => 'Dzięki';

  @override
  String get settings => 'Ustawienia';

  @override
  String get options => 'Opcje';

  @override
  String get generalSettings => 'Ustawienia główne';

  @override
  String get skillLevel => 'Poziom trudności';

  @override
  String get moveTime => 'Czas myślenia AI';

  @override
  String get difficulty => 'Trudność';

  @override
  String get playSounds => 'Efekty dźwiękowe';

  @override
  String get playSoundsInTheGame => 'Odtwarzaj dźwięki w grze';

  @override
  String get keepMuteWhenTakingBack => 'Wyciszenie podczas odbierania';

  @override
  String get tone => 'Dźwięk';

  @override
  String get whoMovesFirst => 'Pierwszy ruch';

  @override
  String get human => 'Człowiek';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Alternatywna strona';

  @override
  String get isAutoRestart => 'Automatyczny restart gry po zakończeniu gry';

  @override
  String get isAutoChangeFirstMove => 'Automatyczna zmiana pierwszego ruchu';

  @override
  String get shufflingEnabled => 'Losowy ruch';

  @override
  String get misc => 'Różne';

  @override
  String get rules => 'Zasady';

  @override
  String get piecesCount => 'Liczba pionów, które ma każdy gracz';

  @override
  String get piecesCount_Detail => 'Ile pionów ma każdy z graczy?';

  @override
  String get flyPieceCount => 'Numer latającego pionka';

  @override
  String get flyPieceCount_Detail =>
      'Jeśli latanie jest włączone, to gdy gracz jest zredukowany do określonej liczby elementów, jego elementy mogą poruszać się do dowolnego niezajętego punktu, zamiast być ograniczone do sąsiednich punktów, jak w pozostałej części gry.';

  @override
  String get piecesAtLeastCount => 'Minimalna liczba pionków';

  @override
  String get hasDiagonalLines => 'Linie ukośne';

  @override
  String get hasDiagonalLines_Detail => 'Dodaj cztery linie ukośne do planszy.';

  @override
  String get isDefenderMoveFirst => 'Drugi gracz porusza się jako pierwszy';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Gracz, który porusza się jako drugi w fazie układania, porusza się jako pierwszy w fazie ruchu.';

  @override
  String get mayRemoveMultiple => 'Wielokrotne usuwanie';

  @override
  String get mayRemoveMultiple_Detail =>
      'Jeśli gracz zamknie więcej niż jeden młyn na raz, będzie mógł usunąć tyle młynów, ile zamknął.';

  @override
  String get mayRemoveFromMillsAlways => 'Niszczenie młynów';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Domyślnie, gracze muszą najpierw usunąć wszystkie inne elementy, zanim usuną element z uformowanego młyna. Włącz tę opcję, aby wyłączyć to ograniczenie.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Drugi gracz przegrywa, gdy plansza jest pełna';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Na koniec fazy układania, gdy plansza jest pełna, strona, która ułożyła planszę jako pierwsza, przegrywa grę, w przeciwnym razie gra jest remisowa.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Przegrana, gdy nie ma legalnych ruchów';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Gracz przegra, jeśli jego przeciwnik zablokuje go tak, że nie będzie mógł go ruszyć. Zmień stronę na ruch, jeśli ta opcja jest wyłączona.';

  @override
  String get mayFly => 'Latający';

  @override
  String get mayFly_Detail =>
      'Jeśli graczowi pozostały tylko trzy lub cztery (konfigurowalne) figury, może je przenieść do dowolnego wolnego punktu.';

  @override
  String get nMoveRule => 'Zasada N ruchów';

  @override
  String get nMoveRule_Detail =>
      'Gra jest remisowana, jeśli w określonej liczbie ruchów każdy z graczy nie wykonał żadnego ruchu.';

  @override
  String get rollback => 'Wycofanie';

  @override
  String get pleaseSelect => 'Proszę wybrać';

  @override
  String get copy => 'Kopiuj';

  @override
  String get moveHistoryCopied => 'Historia ruchów skopiowana do schowka.';

  @override
  String get help => 'Pomoc';

  @override
  String get feedback => 'Opinie';

  @override
  String get exit => 'Wyjdź';

  @override
  String get ruleSettings => 'Ustawienia reguł';

  @override
  String get color => 'Kolor';

  @override
  String get boardColor => 'Kolor planszy';

  @override
  String get pieceColor => 'Kolor elementów';

  @override
  String get backgroundColor => 'Kolor tła';

  @override
  String get lineColor => 'Kolor linii planszy';

  @override
  String get whitePieceColor => 'Kolor elementu gracza 1';

  @override
  String get blackPieceColor => 'Kolor elementu gracza 2';

  @override
  String get messageColor => 'Kolor wiadomości';

  @override
  String get isPieceCountInHandShown => 'Pokazanie liczby sztuk w ręku';

  @override
  String get isNotationsShown => 'Pokaż notacje na planszy';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Pokaż pasek nawigacyjny historii';

  @override
  String get display => 'Wyświetl';

  @override
  String get boardBorderLineWidth => 'Szerokość linii granicznej planszy';

  @override
  String get boardInnerLineWidth => 'Szerokość wewnętrznej linii planszy';

  @override
  String get pieceWidth => 'Szerokość elementu';

  @override
  String get fontSize => 'Rozmiar czcionki';

  @override
  String get standardNotation => 'Notacja WMD';

  @override
  String get restore => 'Przywróć';

  @override
  String get restoreDefaultSettings => 'Przywróć ustawienia domyślne';

  @override
  String pick(Object element) {
    return 'Wybierz $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Wskazówka';

  @override
  String get player => 'gracz';

  @override
  String get player1 => 'Gracz 1';

  @override
  String get player2 => 'Gracz 2';

  @override
  String get howToPlay => 'Jak grać';

  @override
  String get toPlacePiece =>
      'Stuknij w dowolny dostępny punkt, aby umieścić kawałek.';

  @override
  String get toSelectPiece => 'Naciśnij na element, aby go przesunąć.';

  @override
  String get toMovePiece =>
      'Stuknij w punkt połączony z elementem, aby go przesunąć.';

  @override
  String get toRemovePiece =>
      'Stuknij w jeden z elementów przeciwnika, aby go usunąć.';

  @override
  String get needToCreateMillFirst =>
      'Musisz najpierw stworzyć młyn, zanim będziesz mógł usunąć kawałek.';

  @override
  String get needToPlayWithOwnPieces => 'Musisz grać swoimi kawałkami.';

  @override
  String get statistics => 'Statystyki';

  @override
  String get totalGames => 'Łączna liczba gier';

  @override
  String get results => 'Wyniki';

  @override
  String get left => 'w lewo';

  @override
  String get privacyPolicy => 'Polityka Prywatności';

  @override
  String get privacyPolicy_Detail_1 =>
      'Proszę przeczytać uważnie i upewnić się, że w pełni rozumiesz i zgadzasz się z tym ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Jeśli nie zgadzasz się z niniejszą Polityką, prosimy nie korzystać z Aplikacji. Korzystanie z Aplikacji oznacza, że akceptujecie Państwo te warunki.';

  @override
  String get and => ' oraz . ';

  @override
  String get accept => 'Zaakceptuj';

  @override
  String get takeBack => 'Cofnij';

  @override
  String get takingBack => 'Cofnij…';

  @override
  String get waiting => 'Czekanie…';

  @override
  String get stepForward => 'Krok do przodu';

  @override
  String get takeBackAll => 'Cofnij wszystko';

  @override
  String get stepForwardAll => 'Krok do przodu wszyscy';

  @override
  String get moveNow => 'Rusz się teraz';

  @override
  String get done => 'Gotowe.';

  @override
  String get crackMill => 'Pęknięty młyn';

  @override
  String get crackMill_Detail =>
      'Jeśli gracz ma tylko elementy w młynach, elementy w młynach nie będą blokowane do usunięcia.';

  @override
  String get animationDuration => 'Czas trwania animacji';

  @override
  String get none => 'Brak';

  @override
  String get theme => 'Temat';

  @override
  String get helpContent =>
      'Celem gry jest pozostawienie przeciwnika z mniej niż trzema pionami lub bez legalnego ruchu.\n\nGra jest automatycznie remisowana, jeśli pozycja pojawia się po raz trzeci lub jeśli w ciągu ostatnich 100 (konfigurowalnych) ruchów nie został wykonany żaden ruch.\n\nGra przebiega w trzech fazach:\n\n1. Umieszczanie pionków na wolnych punktach\n2. Przesunięcie pionków na sąsiednie punkty\n3. (faza opcjonalna) Przenoszenie pionów na dowolny wolny punkt, gdy gracz został zredukowany do trzech pionów\n\nUmieszczanie\n\nGra rozpoczyna się od pustej planszy, która składa się z siatki z dwudziestoma czterema punktami. Gracze na zmianę umieszczają swoje kamienie na wolnych punktach, aż każdy z nich umieści wszystkie kamienie na planszy. Jeśli gracz umieści trzy swoje elementy w linii prostej, ma \"młyn\" i może usunąć jeden z elementów przeciwnika z planszy.\n\nW niektórych wariantach zasad, gracze muszą najpierw usunąć wszystkie inne elementy, zanim usuną element z uformowanego młyna.\n\nW niektórych wariantach zasad, wszystkie punkty z usuniętych elementów nie mogą być ponownie umieszczone w fazie umieszczania.\n\nGdy wszystkie elementy zostaną wykorzystane, gracze poruszają się na zmianę.\n\nPoruszanie się\n\nAby się poruszyć, gracz przesuwa jedną ze swoich figur wzdłuż linii planszy do wolnego sąsiedniego punktu. Jeśli nie może tego zrobić, przegrywa grę. Podobnie jak w fazie układania, gracz, który ustawi trzy swoje figurki na linii planszy, ma młyn i może usunąć jedną figurkę przeciwnika. Gracz, który zredukuje się do dwóch sztuk i nie ma możliwości utworzenia nowych młynów, przegrywa grę. Gracz może również przegrać z więcej niż trzema elementami, jeśli jego przeciwnik zablokuje je tak, że nie będzie mógł ich ruszyć.\n\nFlying\n\nW niektórych wariantach zasad, gdy graczowi pozostaną tylko trzy pionki, jego pionki mogą \"latać\", \"skakać\" lub \"przeskakiwać\" na dowolne wolne punkty, nie tylko sąsiednie.\n';

  @override
  String get versionInfo => 'Informacje o wersji';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Licencja';

  @override
  String get sourceCode => 'Kod źródłowy';

  @override
  String get appVersion => 'Wersja aplikacji';

  @override
  String get general => 'Ogólne';

  @override
  String get advanced => 'Zaawansowane';

  @override
  String get placing => 'Umieszczanie';

  @override
  String get moving => 'Przenoszenie';

  @override
  String get removing => 'Usuwanie';

  @override
  String get gameOverCondition => 'Warunek zakończenia gry';

  @override
  String get aisPlayStyle => 'Styl gry AI';

  @override
  String get passive => 'Pasywne';

  @override
  String get timeout => 'Koniec czasu';

  @override
  String get appearance => 'Wygląd';

  @override
  String get drawOnHumanExperience => 'Czerpanie z ludzkiego doświadczenia';

  @override
  String get considerMobility => 'Uwzględnij mobilność elementów';

  @override
  String get pieceCount => 'Liczba elementów:';

  @override
  String inHand(Object player, int count) {
    return '$player w ręku: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player na pokładzie: $count';
  }

  @override
  String get boardTop => 'Przesunięcie planszy od góry';

  @override
  String get notAIsTurn => 'To nie jest kolej SI.';

  @override
  String get aiIsNotThinking => 'SI nie myśli.';

  @override
  String get atEnd => 'Na końcu listy ruchów.';

  @override
  String get tapBackAgainToLeave => 'Stuknij ponownie w tył, aby wyjść.';

  @override
  String get more => 'Więcej';

  @override
  String get experimental => 'Jest to funkcja eksperymentalna.';

  @override
  String get experiments => 'Eksperymenty';

  @override
  String get ossLicenses => 'Licencje open source';

  @override
  String get language => 'Język';

  @override
  String get defaultLanguage => 'Domyślny język';

  @override
  String get mayMoveInPlacingPhase =>
      'Figurki mogą się poruszać w fazie umieszczania';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Nie ma oddzielnych faz umieszczania i poruszania, tzn. gracze mogą w każdym ruchu zdecydować, czy chcą umieścić element na planszy, czy poruszyć jeden ze swoich elementów (tak długo, jak długo mają pozostałe elementy do umieszczenia).';

  @override
  String get drawerColor => 'Kolor menu';

  @override
  String get drawerTextColor => 'Kolor tekstu menu Menu';

  @override
  String get drawerHighlightItemColor => 'Kolor elementu podświetlenia menu';

  @override
  String get mainToolbarBackgroundColor => 'Kolor tła głównego paska narzędzi';

  @override
  String get mainToolbarIconColor => 'Kolor ikony głównego paska narzędzi';

  @override
  String get navigationToolbarBackgroundColor =>
      'Kolor tła paska nawigacyjnego';

  @override
  String get navigationToolbarIconColor => 'Kolor ikony paska nawigacyjnego';

  @override
  String get autoHideToolbar => 'Automatycznie ukryj pasek narzędzi';

  @override
  String get toolbarLocationOnScreen => 'Lokalizacja paska narzędzi na ekranie';

  @override
  String get top => 'Top';

  @override
  String get bottom => 'Dolny';

  @override
  String get center => 'Środek';

  @override
  String get solidColor => 'Jednolity kolor';

  @override
  String get picture => 'Obrazek';

  @override
  String get chooseYourPicture => 'Wybierz swoje zdjęcie';

  @override
  String get light => 'Lekki';

  @override
  String get dark => 'Ciemny';

  @override
  String get themes => 'Motywy';

  @override
  String get currentTheme => 'Aktualny motyw';

  @override
  String get saveTheme => 'Zapisz motyw';

  @override
  String get showAnalysisGraph => 'Pokaż wykres analizy';

  @override
  String get analysis => 'Analiza';

  @override
  String get saveGame => 'Zapisz grę';

  @override
  String get loadGame => 'Wczytaj grę';

  @override
  String get setupPosition => 'Pozycja ustawienia';

  @override
  String get showLegalMoves => 'Pokaż legalne ruchy';

  @override
  String get showLastMove => 'Pokaż ostatni ruch';

  @override
  String get showArrows => 'Pokaż strzałki';

  @override
  String get pieces => 'Kawałki';

  @override
  String get showAnalysis => 'Pokaż analizę';

  @override
  String get threads => 'Wątki';

  @override
  String get getInvolved => 'Zaangażować się';

  @override
  String get helpImproveTranslate => 'Pomóż ulepszyć tłumaczenie';

  @override
  String get tutorial => 'Instruktaż';

  @override
  String get classicMill => 'Klasyczny młyn';

  @override
  String get mixedMill => 'Młyn mieszany';

  @override
  String get ceylonMill => 'Cejloński młyn';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Młyn może być zepsuty i wielokrotnie przerabiany';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Jeśli gracz rozbije młyn, aby natychmiast stworzyć nowy młyn, taki gracz może przesunąć taki element z powrotem do pierwotnego skrzyżowania w swoim następnym ruchu, jeśli zrobi nowy młyn.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Gra jest remisowana, jeśli gracz ma trzy pionki i po dziesięciu ruchach żaden z graczy nie usuwa pionów przeciwnika';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Kiedy gracz ma do trzech pionów i żaden z graczy nie może usunąć pionka przeciwnika w ciągu dziesięciu ruchów, gra kończy się remisem.';

  @override
  String get close => 'Blisko';

  @override
  String get whitePiece => 'Biały kawałek';

  @override
  String get blackPiece => 'Czarny kawałek';

  @override
  String get emptyPoint => 'Pusty punkt';

  @override
  String get noPoint => 'Bez sensu';

  @override
  String get placingPhase => 'Faza rozmieszczania';

  @override
  String get movingPhase => 'Faza ruchu';

  @override
  String get flyingPhase => 'Faza latania';

  @override
  String sideToMove(Object player) {
    return 'Strona do przesunięcia: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Ostatni ruch: $move';
  }

  @override
  String get selected => 'Wybrany';

  @override
  String get accessibility => 'Dostępność';

  @override
  String get screenReaderSupport => 'Obsługa czytników ekranu';

  @override
  String get isDraw => 'To jest remis!';

  @override
  String get draw => 'Remis';

  @override
  String get pieceHighlightColor => 'Kolor podświetlenia kawałka';

  @override
  String get algorithm => 'Algorytm';

  @override
  String get endgameNMoveRule => 'Endgame zasada N-Move';

  @override
  String get endgameNMoveRule_Detail =>
      'Jeśli któryś z graczy ma tylko trzy pionki i żaden z nich nie usunie pionka w ramach określonych ruchów, gra jest remisowana.';

  @override
  String get drawReasonEndgameRule50 =>
      'Każdy z graczy ma tylko trzy pionki i żaden z graczy nie usuwa pionka w ramach określonych ruchów.';

  @override
  String get threefoldRepetitionRule => 'Zasada potrójnej powtarzalności';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Gra jest remisowana, jeśli pozycja wystąpi po raz trzeci.';

  @override
  String get continueToMakeMove => 'Młyn! Kontynuuj ruch.';

  @override
  String get pointStyle => 'Styl punktowy';

  @override
  String get pointWidth => 'Szerokość punktu';

  @override
  String get solid => 'Solidny';

  @override
  String get hollow => 'Dziurawy';

  @override
  String get languageName => 'Polski';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ruch',
      one: '$count ruch',
      zero: 'ruch',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Ładowanie nie powiodło się.';

  @override
  String get filename => 'Nazwa pliku';

  @override
  String get browse => 'Przeglądaj…';

  @override
  String get gameFiles => 'Pliki gry';

  @override
  String get gameSavedTo => 'Gra została zapisana do';

  @override
  String get empty => 'Pusty';

  @override
  String get noMove => 'Bez ruchu.';

  @override
  String get restoredPosition => 'Przywrócona pozycja początkowa.';

  @override
  String get clean => 'Czysty';

  @override
  String get cleanedUp => 'Oczyszczone.';

  @override
  String get remove => 'Usunąć';

  @override
  String get noPiecesCanBeRemoved => 'Nie można usunąć żadnych kawałków.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count sztuki',
      one: '$count sztuka',
      zero: 'sztuka',
    );
    return '$_temp0 należy usunąć.';
  }

  @override
  String placedCount(int count) {
    return 'Umiesz. ($count)';
  }

  @override
  String get placedPieceCount =>
      'Liczenie umieszczonych sztuk w fazie umieszczania.';

  @override
  String hasPlacedPieceCount(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: 'Obecny gracz umieścił $count pionka.',
      many: 'Obecny gracz umieścił $count pionków.',
      few: 'Obecny gracz umieścił $count pionki.',
      one: 'Obecny gracz umieścił jeden pionek.',
      zero: 'Obecny gracz nie umieścił żadnych pionków.',
    );
    return '$_temp0';
  }

  @override
  String get notPlacingPhase => 'Faza nie umieszczania, nie można jej zmienić.';

  @override
  String get paste => 'Pasta';

  @override
  String get pasteDone => 'Wklejanie zakończone.';

  @override
  String get cannotPaste => 'Nie można wkleić.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Pokaż nieumieszczone i usunięte elementy';

  @override
  String get fullScreen => 'Pełny ekran';

  @override
  String get reopenToTakeEffect =>
      'Wyjdź i ponownie otwórz aplikację, aby ustawienia zaczęły obowiązywać.';

  @override
  String get forest => 'Las';

  @override
  String get desktopImage => 'Obraz pulpitu';

  @override
  String get invalidPosition => 'Nieprawidłowa pozycja.';

  @override
  String get shareGIF => 'Udostępnij GIF';

  @override
  String get pixelRatio => 'Stosunek pikseli';

  @override
  String get duration => 'Czas trwania';

  @override
  String get gameScreenRecorder => 'Rejestrator ekranu gry';

  @override
  String get previous => 'Poprzedni';

  @override
  String get next => 'Następny';

  @override
  String get skip => 'Pomijać';

  @override
  String get gotIt => 'Rozumiem';

  @override
  String get youCanModifyRules =>
      'Możesz modyfikować zasady gry w ustawieniach reguł.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Możesz użyć kółka myszy, aby zmienić wartość w selektorze.';

  @override
  String get noTimeLimitForThinking =>
      'Czas myślenia AI ustawiony na 0 oznacza, że nie ma limitu czasu na myślenie.';

  @override
  String get whatIsMtdf =>
      'MTD(f) to zmodyfikowana forma algorytmu wyszukiwania alfa-beta, której celem jest poprawa wydajności poprzez ponowne wykorzystanie pośrednich wyników wyszukiwania i użycie dobrego wstępnego przypuszczenia w celu zawężenia przestrzeni wyszukiwania.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Należy pamiętać, że dostosowanie czasu myślenia AI może nie być całkowicie precyzyjne. Rzeczywisty czas myślenia może być krótszy, gdy poziom trudności jest ustawiony na niższą wartość, i może być dłuższy, gdy sztuczna inteligencja jest w połowie myślenia, gdy skończy się czas.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Jeśli ustawisz wysoki poziom trudności, ale nie zwiększysz czasu myślenia AI, rzeczywisty poziom trudności może zostać ograniczony do niższej wartości ze względu na ograniczenie czasu myślenia. Rzeczywista wartość może się różnić w zależności od wydajności urządzenia.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) to algorytm wyszukiwania w celu znalezienia najlepszego ruchu na danej pozycji. Jest to ulepszenie algorytmu alfa-beta i wykorzystuje przeszukiwanie okna zerowego lub zerowego, aby potwierdzić, że ruch jest gorszy lub nie gorszy niż już bezpieczny wynik z głównej zmiany. PVS koncentruje się na najbardziej obiecujących ruchach i unika niepotrzebnych poszukiwań nieoptymalnych gałęzi, co pomaga poprawić efektywność wyszukiwania.';

  @override
  String get whatIsAlphaBeta =>
      'Algorytm alfa-beta to algorytm wyszukiwania w celu znalezienia najlepszego ruchu. Wykorzystuje zasadę minimax i dwie wartości, alfa i beta, aby przyciąć drzewo wyszukiwania i zwiększyć wydajność. Alfa reprezentuje minimalny wynik, jaki komputer jest pewien, że może uzyskać, podczas gdy beta reprezentuje maksymalny wynik, jaki może uzyskać jego przeciwnik. Algorytm pomaga komputerowi podejmować mądre i efektywne decyzje w grze.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Zgodnie z ludzkim doświadczeniem, jeśli spróbujesz wygrać, przegrasz. Zamiast tego celuj w remis i unikaj przegranej. Obserwuj swojego przeciwnika i delikatnie zwab go w miejsce, w którym może popełnić błąd. Kiedy okazują słabość, wykorzystaj okazję i delikatnie naciskaj, by wygrać. W ten sposób możesz wygrać grę.';

  @override
  String get firstMoveDetail =>
      'W tej grze drugiemu graczowi łatwiej jest wygrać niż pierwszemu graczowi.';

  @override
  String get passiveDetail =>
      'Włączenie opcji pasywnej spowoduje, że sztuczna inteligencja rozluźni się, gdy będzie miała przewagę na pozycji, zamiast agresywnie próbować wygrać tak szybko, jak to możliwe.';

  @override
  String get moveRandomlyDetail =>
      'Włączenie tej opcji zwiększa losowość i frajdę z gry, a jej wyłączenie może pomóc w badaniu sposobów na pokonanie sztucznej inteligencji.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Jeśli sztuczna inteligencja bierze pod uwagę mobilność swoich pionków, będzie dążyć nie tylko do jak najszybszego zbicia pionków przeciwnika, ale także rozważy blokowanie ruchów przeciwnika i uniemożliwienie mu zrobienia tego samego.';

  @override
  String get whenBoardIsFull => 'Gdy tablica jest pełna';

  @override
  String get whenBoardIsFull_Detail =>
      'Pod koniec fazy umieszczania, przed rozpoczęciem fazy ruchu, akcja następuje, jeśli plansza jest pełna pionków.';

  @override
  String get sideToMoveRemovePiece =>
      'Gracz, który porusza się jako pierwszy w fazie ruchu, usuwa jeden z pionków przeciwnika.';

  @override
  String get agreeToDraw => 'Obie strony zgadzają się na remis.';

  @override
  String get takeOpponentsPiece => 'Weź jeden z pionków przeciwnika.';

  @override
  String get firstPlayerLose => 'Pierwszy gracz przegrywa grę.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Pierwszy i drugi gracz usuwają jeden z pionków przeciwnika.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Drugi i pierwszy gracz usuwają jeden z pionków przeciwnika.';

  @override
  String get enteredFlyingPhase =>
      'Po wejściu w fazę latania pionki przeciwnika mogą przeskoczyć do dowolnego pustego miejsca na planszy. Regułę latania można wyłączyć w „Ustawieniach reguł”.';

  @override
  String get whenStalemate => 'Kiedy impas';

  @override
  String get whenStalemate_Detail =>
      'Jaka akcja następuje, gdy nie można poruszyć żadnej figury?';

  @override
  String get endWithStalemateLoss => 'Koniec z impasową porażką.';

  @override
  String get changeSideToMove => 'Zmień stronę, aby się poruszać.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Usuń jeden z pionków przeciwnika i wykonaj następny ruch.';

  @override
  String get endWithStalemateDraw => 'Koniec z remisem impasowym.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Usuń jeden z pionków przeciwnika i zmień stronę, aby się poruszyć.';

  @override
  String get aiResponseDelayTime => 'Czas opóźnienia odpowiedzi AI';

  @override
  String get aiIsDelaying =>
      'Sztuczna inteligencja znajduje się obecnie w fazie opóźnionej reakcji. Odczekaj chwilę, zanim przejdziesz dalej.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Nie możesz usunąć nieprzylegającego elementu.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'W przypadku impasu piony przeciwnika sąsiadujące z twoimi mogą zostać usunięte, niezależnie od formacji młyna.';

  @override
  String get whatIsMcts =>
      'MCTS to przyjazny dla początkujących algorytm, który podejmuje decyzje, badając i oceniając różne ruchy za pomocą symulacji.';

  @override
  String get goldenJade => 'Złoty Jadeit';

  @override
  String get forestWood => 'Drewno leśne';

  @override
  String get darkMystery => 'Mroczna tajemnica';

  @override
  String get midnightBlue => 'Niebieska północ';

  @override
  String get greenForest => 'Zielony las';

  @override
  String get greenMeadow => 'Zielona Łąka';

  @override
  String get stonyPath => 'Kamienista Ścieżka';

  @override
  String get pastelPink => 'pastelowy róż';

  @override
  String get turquoiseSea => 'Turkusowe morze';

  @override
  String get violetDream => 'Fioletowy sen';

  @override
  String get mintChocolate => 'Miętowa czekolada';

  @override
  String get skyBlue => 'Niebieskie niebo';

  @override
  String get playfulGarden => 'figlarny ogród';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Algorytm analizy wstecznej wykorzystuje wielowartościową analizę wsteczną do zbudowania bazy danych gier końcowych z różnych pozycji początkowych, a następnie stosuje tę bazę danych w celu optymalizacji rozgrywki. Takie podejście należy do kategorii rozwiązań Ultra-Strong.';

  @override
  String get viewAlgorithmGuide =>
      'Czy chcesz zobaczyć instrukcję obsługi tego algorytmu?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Pokaż wskaźnik przewagi pozycyjnej';

  @override
  String get usePerfectDatabase => 'Użyj doskonałej bazy danych';

  @override
  String get perfectDatabaseDescription =>
      'Włącz tę opcję, aby korzystać z bezbłędnej bazy danych gier generowanej za pomocą najnowocześniejszych algorytmów. Ta funkcja integruje strategie początkowe i końcowe, aby sugerować optymalne ruchy. Jest to preferowany wybór dla graczy, którzy poszukują najwyższego poziomu precyzji rozgrywki. Baza danych, utworzona dzięki skrupulatnym technikom obliczeniowym, została zaprojektowana tak, aby oferować niemal doskonałe rozwiązania w zakresie gier.\n\nUwaga: jeśli sztuczna inteligencja nie uzyska dostępu do bazy danych, przy podejmowaniu decyzji dotyczących rozgrywki zwróci się do konwencjonalnych algorytmów. Gdy baza danych jest dostępna, „Poziom trudności” staje się praktycznie nie do pobicia, a „Czas myślenia AI” ulega drastycznemu skróceniu. Wiele ustawień w opcjach „Styl gry AI” zostanie zastąpionych, ponieważ wyniki z bazy danych mają najwyższy priorytet.\n\nAby uzyskać wskazówki, jak najlepiej wykorzystać tę nieskazitelną bazę danych, kliknij tutaj.';

  @override
  String get backgroundImage => 'Obraz tła';

  @override
  String get whatIsRandom =>
      'Gdy opcja „Użyj doskonałej bazy danych” nie jest włączona, ustawienie „Losowe” powoduje, że sztuczna inteligencja losowo przenosi elementy bez użycia jakichkolwiek algorytmów do wyboru ruchu. Zwykle skutkuje to znacznie słabszą rozgrywką. I odwrotnie, gdy włączona jest opcja „Użyj doskonałej bazy danych”, sztuczna inteligencja przy podejmowaniu decyzji opiera się wyłącznie na „Doskonałej bazie danych”, zamiast łączyć ją z tradycyjnymi algorytmami sztucznej inteligencji. W tym trybie ruchy sztucznej inteligencji opierają się całkowicie na zawartości bazy danych, unikając polegania na obliczeniach w czasie rzeczywistym lub algorytmach wyszukiwania.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Usuń pionek (pionki) przeciwnika z jego ręki; następnie jest tura przeciwnika, aby umieścić pionek.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Podczas formowania młynów w fazie umieszczania';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Usuń pionek (pionki) przeciwnika z planszy.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Usuń pionek (pionki) przeciwnika z planszy; następnie jest tura przeciwnika, aby umieścić pionek.';

  @override
  String get opponentRemovesOwnPiece =>
      'Przeciwnik usuwa swój własny pionek (pionki) z planszy.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Zamiast ciebie podejmującego działanie, przeciwnik wybiera i usuwa swój własny pionek (pionki) z planszy, skutecznie podejmując działanie szkodliwe dla niego samego.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Usuń pionek (pionki) przeciwnika z jego ręki; następnie jest twoja tura, aby się poruszyć.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Usuń pionek (pionki) z ręki przeciwnika. Jeśli zgodnie z ustawieniem wielokrotnego usuwania należy usunąć wiele pionków, a przeciwnik nie ma już żadnych pionków w ręku, kontynuuj usuwanie pionków przeciwnika z planszy. Następnie jest twoja kolej, aby się poruszyć. Jeśli nadal tworzysz młyny, możesz kontynuować usuwanie pionków przeciwnika.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Usuń pionek (pionki) z ręki przeciwnika. Jeśli zgodnie z ustawieniem wielokrotnego usuwania należy usunąć wiele pionków, a przeciwnik nie ma już żadnych pionków w ręku, kontynuuj usuwanie pionków przeciwnika z planszy. Następnie jest tura przeciwnika, aby się poruszyć.';

  @override
  String get markAndDelayRemovingPieces =>
      'Zaznacz i opóźnij usuwanie pionków.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'W fazie umieszczania pionki do usunięcia są zaznaczane i obaj gracze nie mogą umieszczać nowych pionków na tych polach. Po wejściu w fazę ruchu te zaznaczone pionki są całkowicie usuwane, a gracze mogą następnie przenieść swoje pionki na te teraz puste pola.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Działania, które można podjąć podczas formowania młynów w fazie umieszczania.';

  @override
  String get marked => 'Oznaczone';

  @override
  String get menu => 'Menu';

  @override
  String get monochrome => 'Monochromatyczny';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Możesz włączyć wsparcie dla czytnika ekranu w ustawieniach dostępności w Ustawieniach ogólnych.';

  @override
  String get showNumbersOnPieces => 'Pokaż numery na pionkach';

  @override
  String get saveImage => 'Zapisz obraz';

  @override
  String get isAnalysisToolbarShown => 'Pokaż pasek narzędzi analizy';

  @override
  String get analysisToolbarBackgroundColor =>
      'Kolor tła paska narzędzi analizy';

  @override
  String get analysisToolbarIconColor => 'Kolor ikony paska narzędzi analizy';

  @override
  String get transformed => 'Przekształcone.';

  @override
  String get cannotTransform => 'Nie można przekształcić.';

  @override
  String get rotate => 'Obróć';

  @override
  String get horizontalFlip => 'Poz.';

  @override
  String get verticalFlip => 'Pion.';

  @override
  String get innerOuterFlip => 'W/Z';

  @override
  String get transparentCanvas => 'Przezroczyste Płótno';

  @override
  String get restrictRepeatedMillsFormation =>
      'Ogranicz powtarzające się formacje młynów';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Pionek przeniesiony z jednego młyna do drugiego nie może natychmiast wrócić na oryginalne miejsce w następnej turze, aby ponownie utworzyć młyn. Najpierw wymagany jest inny ruch.';

  @override
  String get oneTimeUseMill => 'Młyn jednorazowego użytku';

  @override
  String get oneTimeUseMill_Detail =>
      'Każdy młyn może usunąć tylko jedną część przeciwnika. Możesz go ponownie utworzyć, ale nie można go użyć do dodatkowego usuwania.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Ustawione przez ciebie aktualne zasady nie mają odpowiedniej idealnej bazy danych. Aby uzyskać więcej informacji o idealnej bazie danych, kliknij tutaj.';

  @override
  String get focusOnBlockingPaths => 'Skoncentruj się na blokowaniu dróg';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Priorytetem jest utrudnianie ruchów przeciwnika, a nie tworzenie młynów. Zamiast skupiać się na usuwaniu pionów poprzez ukończenie młynów, SI dąży do unieruchomienia przeciwnika, uniemożliwiając mu poruszanie się i zapewniając zwycięstwo poprzez wyczerpanie, a nie agresywną grę. Ta strategia nie blokuje aktywnie młynów przeciwnika.';

  @override
  String get pieceImage => 'Obrazek figury';

  @override
  String get importColorSettings => 'Importuj ustawienia kolorów';

  @override
  String get exportColorSettings => 'Eksportuj ustawienia kolorów';

  @override
  String get import => 'Importuj';

  @override
  String get export => 'Eksportuj';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Najpierw skopiuj ustawienia formatu JSON do schowka.';

  @override
  String get copiedToClipboard => 'Skopiowano do schowka.';

  @override
  String get imported => 'Zaimportowano.';

  @override
  String get boardImage => 'Obraz tablicy';

  @override
  String get autumnLeaves => 'Jesienne Liście';

  @override
  String get legendaryLand => 'Legendarna Ziemia';

  @override
  String get vignetteEffect => 'Efekt winiety';

  @override
  String get promptMakeToolbarTransparent =>
      'Czy chcesz, aby pasek narzędzi był całkowicie przezroczysty, gdy ustawiony jest obraz tła planszy?';

  @override
  String get vibration => 'Włącz wibracje w grze';

  @override
  String get soundTheme => 'Motyw dźwięku';

  @override
  String get ball => 'Piłka';

  @override
  String get liquid => 'Płyn';

  @override
  String get wood => 'Drewno';

  @override
  String get placeEffectAnimation => 'Efekt animacji przy stawianiu pionka';

  @override
  String get removeEffectAnimation => 'Efekt animacji przy usuwaniu pionka';

  @override
  String get isToolbarAtBottom => 'Pokaż pasek narzędzi na dole';

  @override
  String get boardCornerRadius => 'Promień narożnika tablicy';

  @override
  String get useOpeningBook => 'Użyj książki otwierającej';

  @override
  String get currentRule => 'Bieżący';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Zestaw zasad';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Pozwól SI korzystać z ruchów otwarcia, które są powszechnie stosowane przez profesjonalnych ludzkich graczy na wczesnym etapie gry. Uwaga: Ta funkcja jest obecnie dostępna tylko dla określonych zestawów zasad.';

  @override
  String get showAdvantageGraph => 'Pokaż wykres przewagi';

  @override
  String get advantageGraphHint =>
      'Wykres przewagi zostanie narysowany tylko po wykonaniu ruchu przez SI. Nie zostanie narysowany, gdy ruch wykona gracz ludzki.';

  @override
  String get removalBasedOnMillCounts =>
      'Wyłącz usuwanie do czasu umieszczenia wszystkich pionków. Gracze usuwają pionki na podstawie liczby młynków.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Wyłącz usuwanie do czasu umieszczenia wszystkich pionków. Gracze usuwają pionki na podstawie liczby młynków: jeśli liczba jest równa, obaj gracze usuwają tę samą liczbę pionków; jeśli jeden ma więcej, usuwa dodatkowego pionka, zachowując różnicę jednego pionka. Jeśli tylko jeden utworzy młyn, usuwa dwa pionki, a drugi usuwa jeden. Jeśli żaden nie utworzy młyna, obaj usuwają po jednym pionku.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Wybierz jedną ze swoich figur.';

  @override
  String get notYourTurn => 'To nie twoja tura.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Kolor tła paska narzędzi adnotacji';

  @override
  String get annotationToolbarIconColor =>
      'Kolor ikony paska narzędzi adnotacji';

  @override
  String get isAnnotationToolbarShown => 'Pokaż pasek narzędzi adnotacji';

  @override
  String get enterAnnotationMode => 'Wejdź w tryb adnotacji';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Czy na pewno chcesz wyczyścić wszystkie adnotacje?';

  @override
  String get llmPromptCopiedToClipboard =>
      'Podpowiedź LLM skopiowana do schowka.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Odmowa połączenia, serwer może być wyłączony.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Odkrycie zakończone sukcesem, oczekiwanie na połączenie...';

  @override
  String get noLanConnection => 'Brak połączenia LAN';

  @override
  String get takeScreenshot => 'Zrób zrzut ekranu';

  @override
  String get disconnectedFromOpponent => 'Rozłączono z przeciwnikiem.';

  @override
  String get takeBackRequest => 'Żądanie cofnięcia ruchu';

  @override
  String get nothingToShow => 'Nic do pokazania.';

  @override
  String get stopHosting => 'Zatrzymaj hostowanie';

  @override
  String get connectionResetByPeer => 'Połączenie zresetowane przez peer.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Utracono połączenie z powodu przekroczenia czasu bicia serca. Proszę ponownie się połączyć.';

  @override
  String get startHosting => 'Rozpocznij hostowanie';

  @override
  String get restartRequestRejected => 'Żądanie restartu odrzucone.';

  @override
  String get notConnectedToLanOpponent => 'Nie połączono z przeciwnikiem LAN.';

  @override
  String get llmPrompt => 'Podpowiedź LLM';

  @override
  String get gameRestarted => 'Gra zrestartowana.';

  @override
  String get takeBackRejected => 'Cofnięcie ruchu odrzucone.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Czy na pewno chcesz poddać tę grę?';

  @override
  String get opponentResignedYouWin => 'Przeciwnik poddał się. Wygrywasz!';

  @override
  String get clearAllAnnotations => 'Wyczyść wszystkie adnotacje';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Połączono, oczekiwanie na ruch przeciwnika...';

  @override
  String get networkStatusDisconnected => 'Status sieci: Rozłączono';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Żądanie cofnięcia ruchu wysłane do przeciwnika.';

  @override
  String get theOpponentMayHaveLeftTheGame => 'Przeciwnik mógł opuścić grę';

  @override
  String get connectedToHostSuccessfully => 'Połączono z hostem pomyślnie.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Utracono połączenie: przekroczenie czasu bicia serca';

  @override
  String get noHostDiscovered => 'Nie odkryto hosta.';

  @override
  String get confirmResignation => 'Potwierdź poddanie się';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Rozpoczęto hostowanie gry, oczekiwanie na dołączenie graczy...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Przekroczono czas połączenia, połączenie sieciowe niestabilne.';

  @override
  String get noLlmPromptAvailable => 'Brak dostępnej podpowiedzi LLM.';

  @override
  String get youResignedGameOver => 'Podałeś się. Koniec gry.';

  @override
  String get serverIp => 'IP serwera';

  @override
  String get confirmClear => 'Potwierdź wyczyszczenie';

  @override
  String get opponentSTurn => 'Tura przeciwnika.';

  @override
  String get waitingAClientConnection => 'Oczekiwanie na połączenie klienta...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Żądanie cofnięcia ruchu zostało odrzucone lub nie powiodło się.';

  @override
  String get addText => 'Dodaj tekst';

  @override
  String get exitAnnotationMode => 'Wyjdź z trybu adnotacji';

  @override
  String get typeYourAnnotation => 'Wpisz swoją adnotację';

  @override
  String get attemptingToReconnect => 'Próba ponownego połączenia...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Wysłano żądanie restartu. Oczekiwanie na odpowiedź przeciwnika...';

  @override
  String get serverIsStopped => 'Serwer jest zatrzymany.';

  @override
  String get restartRequest => 'Żądanie restartu';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Nie można zażądać cofnięcia ruchu, gdy nie jest twoja tura.';

  @override
  String get takeBackAccepted => 'Cofnięcie ruchu zaakceptowane.';

  @override
  String get localNetworkSettings => 'Ustawienia sieci lokalnej';

  @override
  String get reconnectedSuccessfully => 'Ponowne połączenie pomyślne!';

  @override
  String get failedToSaveImageToGallery =>
      'Nie udało się zapisać obrazu do Galerii.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Przeciwnik zażądał restartu gry. Czy akceptujesz?';

  @override
  String get yourTurn => 'Twoja tura.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Nie można ponownie się połączyć, proszę zrestartować grę.';

  @override
  String get host => 'Host';

  @override
  String get join => 'Dołącz';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'Nieprawidłowy adres IP.';

  @override
  String get invalidPort => 'Nieprawidłowy port.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Łączenie: Próba $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Nie udało się połączyć: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Nie udało się rozpocząć hostowania: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Odkryto hosta: $ip:$port';
  }

  @override
  String get stop => 'Zatrzymaj';

  @override
  String get discover => 'Odkryj';

  @override
  String get connect => 'Połącz';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Klient połączony: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Odkrywanie: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Ponowne łączenie ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Połączono';

  @override
  String get delete => 'Usuń';

  @override
  String get ancientEgypt => 'Starożytny Egipt';

  @override
  String get gothicIce => 'Gotyk Lód';

  @override
  String get riceField => 'Pole Ryżowe';

  @override
  String get chinesePorcelain => 'Chińska Porcelana';

  @override
  String get desertDusk => 'Pustynny Zmierzch';

  @override
  String get precisionCraft => 'Precyzyjne Rzemiosło';

  @override
  String get folkEmbroidery => 'Haft Ludowy';

  @override
  String get carpathianHeritage => 'Dziedzictwo Karpackie';

  @override
  String get imperialGrandeur => 'Imperialna Wspaniałość';

  @override
  String get bohemianCrystal => 'Czeski Kryształ';

  @override
  String get savannaSunrise => 'Sawanna Wschód Słońca';

  @override
  String get harmonyBalance => 'Harmonia i Równowaga';

  @override
  String get cinnamonSpice => 'Przyprawa Cynamonowa';

  @override
  String get anatolianMosaic => 'Mozaika Anatolijska';

  @override
  String get carnivalSpirit => 'Duch Karnawału';

  @override
  String get custom => 'Zwyczaj';

  @override
  String get spiceMarket => 'Targ przypraw';

  @override
  String get swipeToRevealTheDrawer => 'Przeciągnij, aby odsłonić szufladę';

  @override
  String get showGameInfoOnScreenshots =>
      'Pokaż informacje o grze na zrzutach ekranu';

  @override
  String get humanMoveTime => 'Limit czasu dla człowieka';

  @override
  String get noTimeLimitForHumanMoves =>
      'Brak limitu czasu dla ruchów człowieka';

  @override
  String get timeoutLoseWillBeApplied =>
      'Przegrana przez przekroczenie czasu zostanie zastosowana dla gracza ludzkiego';

  @override
  String get identifyingBoard => 'Rozpoznawanie planszy...';

  @override
  String get youCanEnterAnyModelName =>
      'Możesz wprowadzić dowolną nazwę modelu.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Pozycja planszy zastosowana. FEN skopiowany do schowka.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Sugestia: spróbuj zrobić wyraźniejsze zdjęcie planszy.';

  @override
  String get llmPromptTemplate => 'Szablon polecenia LLM';

  @override
  String get noValidBoardDetected => 'Nie wykryto poprawnej planszy.';

  @override
  String get selectingImageFromAlbum => 'Wybieranie obrazu z albumu...';

  @override
  String get configurePromptTemplate => 'Skonfiguruj szablon polecenia';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Edytuj szablon polecenia do analizy przez LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Nie udało się wygenerować FEN z rozpoznanej planszy.';

  @override
  String get outputInCurrentLanguage => 'Wyjście w bieżącym języku';

  @override
  String get commonBaseUrls => 'Typowe adresy Base URL';

  @override
  String get viewCommonModels => 'Zobacz popularne modele';

  @override
  String get recognitionParametersUpdated =>
      'Parametry rozpoznawania zaktualizowane.';

  @override
  String get whiteSMove => 'Ruch białych';

  @override
  String get resetToDefaults => 'Przywróć ustawienia domyślne';

  @override
  String get photoShoot => 'Sesja zdjęciowa';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Nie udało się zastosować rozpoznanej pozycji planszy.';

  @override
  String get llmPromptContent => 'Zawartość polecenia LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM nie jest skonfigurowane. Sprawdź ustawienia.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Ustaw dostawcę, model, API Key i Base URL';

  @override
  String get llmConfiguration => 'Konfiguracja LLM';

  @override
  String get configureLlmProvider => 'Skonfiguruj dostawcę LLM';

  @override
  String get llmPromptTemplateHeader => 'Nagłówek szablonu polecenia LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Żadne pionki nie zostały rozpoznane na obrazie. Spróbuj ponownie.';

  @override
  String get recognizeBoardFromImage => 'Rozpoznaj planszę z obrazu';

  @override
  String get viewTips => 'Zobacz wskazówki';

  @override
  String get applyToBoard => 'Zastosuj do planszy';

  @override
  String get adjustBoardArea => 'Dopasuj obszar planszy';

  @override
  String get viewCommonUrls => 'Zobacz popularne URL-e';

  @override
  String get colorAnalysisFailed => 'Analiza kolorów nie powiodła się!';

  @override
  String get analyzingGameBoardImage => 'Analizowanie obrazu planszy...';

  @override
  String get selectFromAlbum => 'Wybierz z albumu';

  @override
  String get noBoardPointDetected => 'Nie wykryto punktu na planszy!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Jeśli pozostawione puste, zostanie użyty szablon domyślny';

  @override
  String get llmConfig => 'Konfiguracja LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Czy na pewno chcesz przywrócić szablony poleceń do wartości domyślnych?';

  @override
  String get llmPromptTemplateFooter => 'Stopka szablonu polecenia LLM';

  @override
  String get loadingResponse => 'Ładowanie odpowiedzi...';

  @override
  String get applyThisResultToBoard => 'Zastosuj ten wynik do planszy';

  @override
  String get takingPicture => 'Robienie zdjęcia...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Wybierz obraz planszy do rozpoznania';

  @override
  String get identificationResults => 'Wyniki rozpoznawania';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analizuj ruchy i udziel wnikliwych informacji.';

  @override
  String get getApiKey => 'Pobierz API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Cały proces rozpoznawania nie został ukończony.';

  @override
  String get boardRecognitionResult => 'Wynik rozpoznania planszy';

  @override
  String get askLlm => 'Zapytaj LLM';

  @override
  String get boardDetectionFailed => 'Wykrywanie planszy nie powiodło się!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Nie wykryto punktu na planszy, nie można rozpoznać pionka!';

  @override
  String get copyFen => 'Kopiuj FEN';

  @override
  String get commonlyUsedModels => 'Popularne modele';

  @override
  String get apiKeyOptional => 'API Key (opcjonalnie)';

  @override
  String get noImageSelected => 'Nie wybrano obrazu';

  @override
  String get blackSMove => 'Ruch czarnych';

  @override
  String get llm => 'Duży model językowy';

  @override
  String get llmProvider => 'Dostawca';

  @override
  String get baseUrl => 'Podstawowy URL';

  @override
  String get model => 'Model';

  @override
  String get temperature => 'Temperatura';

  @override
  String get llmCommandReceivedProcessing =>
      'Polecenie odebrane! SI przetwarza...';

  @override
  String get llmDeepThinkingWait => 'Trwa głębokie myślenie, proszę czekać...';

  @override
  String get llmPresentingSoon => 'Wkrótce zostanie zaprezentowane...';

  @override
  String get recognitionParameters => 'Parametry rozpoznawania';

  @override
  String get adjustParamsDesc =>
      'Dostosuj parametry, aby poprawić dokładność rozpoznawania';

  @override
  String get saveParameters => 'Zapisz parametry';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Nie można uruchomić rozpoznawania obrazu: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Rozpoznawanie obrazu nie powiodło się: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Zastosowano pozycję z $whiteCount białymi i $blackCount czarnymi pionkami';
  }

  @override
  String get fenCopiedToClipboard => '(FEN skopiowano do schowka)';

  @override
  String recognitionFailed(String error) {
    return 'Rozpoznawanie nie powiodło się: $error';
  }

  @override
  String get myRating => 'Moja ocena';

  @override
  String get gamesPlayed => 'Rozegrane gry';

  @override
  String get wins => 'Wygrane';

  @override
  String get losses => 'Przegrane';

  @override
  String get draws => 'Remisy';

  @override
  String get lastUpdated => 'Ostatnia aktualizacja';

  @override
  String get format => 'Format:';

  @override
  String get resetStatistics => 'Resetuj statystyki';

  @override
  String get drawRate => 'Współczynnik remisów';

  @override
  String get lossRate => 'Współczynnik przegranych';

  @override
  String get aiStatistics => 'Statystyki SI';

  @override
  String get enableStatistics => 'Włącz statystyki';

  @override
  String get enableStatistics_Detail =>
      'Gdy włączone, wyniki gier będą zapisywane w statystykach. Jednak gry obejmujące cofanie ruchów nie będą zapisywane. Gdy wyłączone, zbieranie statystyk jest wstrzymane.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Spowoduje to zresetowanie wszystkich statystyk gry. Tej czynności nie można cofnąć.';

  @override
  String get boardInnerRingSize => 'Rozmiar wewnętrznego pierścienia planszy';

  @override
  String get boardShadowEnabled => 'Cień planszy';

  @override
  String get trapAwareness => 'Wykrywanie pułapek';

  @override
  String get trapAwarenessDescription =>
      'Podświetlaj ruchy-pułapki grubymi okręgami i strzałkami podczas analizy.';

  @override
  String trapExists(String trapMoves) {
    return 'Istnieje pułapka. Ruchy-pułapki: $trapMoves';
  }

  @override
  String get custodianCapture => 'Uchwycenie flankujące';

  @override
  String get custodianCaptureDescription =>
      'Załóż jeden z elementów przeciwnika między dwoma w linii prostej, aby go uchwycić.';

  @override
  String get custodianCaptureEnable => 'Pozwól, aby wychwytywać flanking';

  @override
  String get interventionCapture => 'Przechwytywanie interwencji';

  @override
  String get interventionCaptureDescription =>
      'Przejdź do pustego punktu między dwoma elementami przeciwnika, aby uchwycić je oba.';

  @override
  String get interventionCaptureEnable =>
      'Pozwól na przechwytywanie interwencji';

  @override
  String get leapCapture => 'SKUPU SKUPU';

  @override
  String get leapCaptureDescription =>
      'Uchwyć, przeskakując przez sąsiedniego elementu przeciwnika w pusty punkt za nią.';

  @override
  String get leapCaptureEnable => 'Pozwól schwytać skok';

  @override
  String get captureApplicableLines => 'Odpowiednie linie';

  @override
  String get captureSquareEdges => 'Wzdłuż krawędzi kwadratu';

  @override
  String get captureCrossLines =>
      'Wzdłuż linii ortogonalnych przecinających kwadrat';

  @override
  String get captureDiagonalLines =>
      'Wzdłuż linii ukośnych przecinających kwadrat';

  @override
  String get captureExecutionPhases => 'Fazy wykonania';

  @override
  String get capturePiecesCondition =>
      'Dostępność podczas fazy ruchu na podstawie pozostałych elementów';

  @override
  String get capturePiecesConditionUnlimited => 'Bez ograniczeń';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Dostępne, gdy masz trzy lub mniej elementów';
}
