// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Dutch Flemish (`nl`).
class SNl extends S {
  SNl([String locale = 'nl']) : super(locale);

  @override
  String get appName => 'Molenspel';

  @override
  String get welcome => 'Welkom';

  @override
  String get yes => 'Ja';

  @override
  String get no => 'Nee';

  @override
  String get game => 'Spel';

  @override
  String get humanVsAi => 'Mens tegen AI';

  @override
  String get humanVsHuman => 'Mens tegen Mens';

  @override
  String get aiVsAi => 'AI tegen AI';

  @override
  String get humanVsCloud => 'Mens tegen Cloud';

  @override
  String get humanVsLAN => 'Mens tegen LAN';

  @override
  String get testViaLAN => 'Test via LAN';

  @override
  String get move => 'Bewegen';

  @override
  String get showMoveList => 'Zetlijst';

  @override
  String get moveList => 'Zetlijst';

  @override
  String get noGameRecord => 'Geen record';

  @override
  String get ok => 'OK';

  @override
  String get confirm => 'Bevestigen';

  @override
  String get cancel => 'Annuleren';

  @override
  String get tipSelectWrong => 'Selecteer het verkeerde stuk.';

  @override
  String get tipPlace => 'Plaats uw stukken.';

  @override
  String get tipBanPlace => 'Kan het hier niet plaatsen.';

  @override
  String get tipPlaced => 'Geplaatst.';

  @override
  String get tipRemove => 'Verwijder een stuk.';

  @override
  String get tipBanRemove => 'U kunt het niet verwijderen.';

  @override
  String get tipRemoved => 'Je hebt verwijderd.';

  @override
  String get tipMove => 'Verplaats een stuk.';

  @override
  String get tipCannotPlace => 'Je kunt je speelstuk niet hier plaatsen.';

  @override
  String get tipCannotMove => 'Je kunt je stuk niet hierheen verplaatsen.';

  @override
  String get tipMill => 'Molen! Neem het stuk van je tegenstander.';

  @override
  String get tipContinueMill =>
      'Ga door met het slaan van het stuk van je tegenstander.';

  @override
  String get tipSelectOpponentsPiece =>
      'Kies één van de stukken van je tegenstander.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Je kunt geen stuk uit een molen verwijderen.';

  @override
  String get tipCanMoveOnePoint => 'Een stuk kan 1 punt bewegen.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Je kunt de stukken van je tegenstander niet verplaatsen.';

  @override
  String get tipSelectPieceToMove => 'Selecteer je stuk om te verplaatsen.';

  @override
  String get tipHaveThreePiecesLeft => 'Je hebt nog 3 stukken over.';

  @override
  String get tipCanMoveToAnyPoint => 'Je kunt naar elk punt gaan dat je wilt.';

  @override
  String tipToMove(Object player) {
    return '$player om te verplaatsen.';
  }

  @override
  String get whiteWin => 'Speler 1 wint!';

  @override
  String get blackWin => 'Speler 2 wint!';

  @override
  String get won => 'Gewonnen';

  @override
  String get lost => 'Verloren';

  @override
  String get thinking => 'Ik denk…';

  @override
  String get newGame => 'Nieuw spel';

  @override
  String get importGame => 'Spel importeren';

  @override
  String get exportGame => 'Spel exporteren';

  @override
  String get gameImported => 'Spel geïmporteerd.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Kan $invalidMove niet importeren';
  }

  @override
  String get movesAndRulesNotMatch =>
      'Bewegingen en regels komen niet overeen.';

  @override
  String get pleaseWait => 'Even wachten...';

  @override
  String get restartGame => 'Huidig spel opnieuw starten?';

  @override
  String get restart => 'Herstart';

  @override
  String get gameStarted => 'Spel gestart, gelieve te plaatsen.';

  @override
  String get analyzing => 'Analyseren…';

  @override
  String error(Object message) {
    return 'Fout: $message';
  }

  @override
  String get winRate => 'Winstpercentage';

  @override
  String get score => 'Score:';

  @override
  String get white => 'Speler 1';

  @override
  String get black => 'Speler 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player aantal stuks is minder dan drie.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player heeft opgegeven.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player kan niet bewegen.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Het bord is vol en $player heeft geen weg meer te gaan.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'De tijd is om, $player heeft verloren.';
  }

  @override
  String get drawReasonRule50 =>
      'In de bewegende fase is er geen stuk verwijderd in het laatste specifieke aantal zetten.';

  @override
  String get drawReasonBoardIsFull => 'Het is remise omdat het bord vol is.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Het is remise vanwege drievoudige herhaling.';

  @override
  String get gameOverUnknownReason => 'Het spel is uit! Onbekende reden.';

  @override
  String get gameOver => 'Spel is over';

  @override
  String get youWin => 'Je hebt gewonnen! Gefeliciteerd!';

  @override
  String challengeHarderLevel(int level) {
    return 'Uitdaging moeilijker niveau? Het nieuwe niveau zal niveau $level zijn!';
  }

  @override
  String get youLose => 'Je verliest!';

  @override
  String get analyze => 'Analyseren';

  @override
  String get about => 'Over';

  @override
  String version(Object versionNumber) {
    return 'Versie: $versionNumber';
  }

  @override
  String get thanks => 'Bedankt';

  @override
  String get settings => 'Instellingen';

  @override
  String get options => 'Opties';

  @override
  String get generalSettings => 'Algemene instellingen';

  @override
  String get skillLevel => 'Moeilijkheidsgraad';

  @override
  String get moveTime => 'AI denk tijd';

  @override
  String get difficulty => 'Moeilijkheid';

  @override
  String get playSounds => 'Geluidseffecten';

  @override
  String get playSoundsInTheGame => 'Geluiden afspelen in het spel';

  @override
  String get keepMuteWhenTakingBack => 'Mute houden bij het terugnemen';

  @override
  String get tone => 'Toon';

  @override
  String get whoMovesFirst => 'Eerste zet';

  @override
  String get human => 'Mens';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Alternatief';

  @override
  String get isAutoRestart => 'Auto-herstart spel wanneer spel voorbij';

  @override
  String get isAutoChangeFirstMove => 'Auto Verander Eerste Zet';

  @override
  String get shufflingEnabled => 'Willekeurige zet';

  @override
  String get misc => 'Diversen';

  @override
  String get rules => 'Regels';

  @override
  String get piecesCount => 'Het aantal stukken dat elke speler heeft';

  @override
  String get piecesCount_Detail => 'Hoeveel stukken heeft elke speler?';

  @override
  String get flyPieceCount => 'Het nummer van het vliegende stuk';

  @override
  String get flyPieceCount_Detail =>
      'Als Vliegen is ingeschakeld, dan zijn de stukken van een speler die tot een bepaald aantal stukken is gereduceerd, vrij om naar elk onbezet punt te gaan in plaats van naar aangrenzende punten zoals in de rest van het spel.';

  @override
  String get piecesAtLeastCount => 'Minstens Stukken';

  @override
  String get hasDiagonalLines => 'Diagonale lijnen';

  @override
  String get hasDiagonalLines_Detail =>
      'Voeg vier diagonale lijnen toe aan het bord.';

  @override
  String get isDefenderMoveFirst => 'De tweede speler beweegt eerst';

  @override
  String get isDefenderMoveFirst_Detail =>
      'De speler die als tweede beweegt in de plaatsingsfase beweegt als eerste in de verplaatsingsfase.';

  @override
  String get mayRemoveMultiple => 'Meervoudig verwijderen';

  @override
  String get mayRemoveMultiple_Detail =>
      'Als een speler meer dan één molen tegelijk sluit, kan hij het aantal molens dat hij gesloten heeft verwijderen.';

  @override
  String get mayRemoveFromMillsAlways => 'Molens vernietigen';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Standaard moeten spelers eerst alle andere stenen verwijderen voordat ze een steen van een gevormde molen kunnen verwijderen. Activeer deze optie om deze beperking uit te schakelen.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'De tweede speler verliest als het bord vol is';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Aan het eind van de plaatsingsfase, als het bord vol is, verliest de partij die als eerste plaatst, anders is het een gelijkspel.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Verliezen als er geen reglementaire zetten zijn';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'De speler verliest als zijn tegenstander hem blokkeert zodat hij niet kan worden verplaatst. Verander van kant als deze optie is uitgeschakeld.';

  @override
  String get mayFly => 'Vliegen';

  @override
  String get mayFly_Detail =>
      'Als een speler nog maar drie of vier (instelbare) stukken over heeft, kan hij het stuk naar elk vrij punt verplaatsen.';

  @override
  String get nMoveRule => 'N-zet regel';

  @override
  String get nMoveRule_Detail =>
      'De partij is remise als er in een bepaald aantal zetten door geen van de spelers een stuk is verplaatst.';

  @override
  String get rollback => 'Terugspelen';

  @override
  String get pleaseSelect => 'Selecteer';

  @override
  String get copy => 'Kopieer';

  @override
  String get moveHistoryCopied =>
      'Bewegingsgeschiedenis gekopieerd naar klembord.';

  @override
  String get help => 'Help';

  @override
  String get feedback => 'Terugkoppeling';

  @override
  String get exit => 'Afsluiten';

  @override
  String get ruleSettings => 'Regel Instellingen';

  @override
  String get color => 'Kleur';

  @override
  String get boardColor => 'Kleur bord';

  @override
  String get pieceColor => 'Kleur stuk';

  @override
  String get backgroundColor => 'Kleur achtergrond';

  @override
  String get lineColor => 'Bord lijn kleur';

  @override
  String get whitePieceColor => 'Speler 1 stuk kleur';

  @override
  String get blackPieceColor => 'Kleur speelstuk 2';

  @override
  String get messageColor => 'Kleur bericht';

  @override
  String get isPieceCountInHandShown => 'Toon telling van stukken in hand';

  @override
  String get isNotationsShown => 'Toon notaties op bord';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Toon geschiedenis navigatie werkbalk';

  @override
  String get display => 'Toon';

  @override
  String get boardBorderLineWidth => 'Breedte van de bordgrenzen';

  @override
  String get boardInnerLineWidth => 'Breedte binnenlijn';

  @override
  String get pieceWidth => 'Stuk breedte';

  @override
  String get fontSize => 'Lettergrootte';

  @override
  String get standardNotation => 'WMD notatie';

  @override
  String get restore => 'Herstel';

  @override
  String get restoreDefaultSettings => 'Standaard instellingen herstellen';

  @override
  String pick(Object element) {
    return 'Kies $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Tip';

  @override
  String get player => 'speler';

  @override
  String get player1 => 'Speler 1';

  @override
  String get player2 => 'Speler 2';

  @override
  String get howToPlay => 'Hoe te spelen';

  @override
  String get toPlacePiece =>
      'Tik op een beschikbaar punt om het stuk te plaatsen.';

  @override
  String get toSelectPiece => 'Tik op een stuk om het te verplaatsen.';

  @override
  String get toMovePiece =>
      'Tik op een punt verbonden met een speelstuk om het te verplaatsen.';

  @override
  String get toRemovePiece =>
      'Tik op een stuk van de tegenstander om het te verwijderen.';

  @override
  String get needToCreateMillFirst =>
      'Je moet eerst een molen maken voordat je een stuk kunt verwijderen.';

  @override
  String get needToPlayWithOwnPieces => 'Je moet met je stukken spelen.';

  @override
  String get statistics => 'Statistieken';

  @override
  String get totalGames => 'Totaal aantal spellen';

  @override
  String get results => 'Resultaten';

  @override
  String get left => 'links';

  @override
  String get privacyPolicy => 'Privacybeleid';

  @override
  String get privacyPolicy_Detail_1 =>
      'Gelieve aandachtig te lezen en zorg ervoor dat u dit volledig begrijpt en ermee akkoord gaat ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Indien u niet akkoord gaat met dit beleid, verzoeken wij u deze App niet te gebruiken. Gebruik van de App houdt in dat u deze voorwaarden accepteert.';

  @override
  String get and => ' en ';

  @override
  String get accept => 'Accepteren';

  @override
  String get takeBack => 'Terugnemen';

  @override
  String get takingBack => 'Terugnemen…';

  @override
  String get waiting => 'Wachten…';

  @override
  String get stepForward => 'Stap vooruit';

  @override
  String get takeBackAll => 'Alles terugnemen';

  @override
  String get stepForwardAll => 'Stap voorwaarts allemaal';

  @override
  String get moveNow => 'Nu bewegen';

  @override
  String get done => 'Gereed.';

  @override
  String get crackMill => 'Kraak-molen';

  @override
  String get crackMill_Detail =>
      'Als een speler alleen stukken in molens heeft, zullen de stukken in de molens niet vergrendelen om te verwijderen.';

  @override
  String get animationDuration => 'Animatie duur';

  @override
  String get none => 'Geen';

  @override
  String get theme => 'Thema';

  @override
  String get helpContent =>
      'Het spel is erop gericht de tegenstander met minder dan drie stukken of zonder legale zetten achter te laten.\n\nHet spel wordt automatisch remise als een stelling voor de derde keer voorkomt of in de laatste 100 (instelbare) zetten niet wordt verwijderd.\n\nHet spel verloopt in drie fasen:\n\n1. Het plaatsen van stukken op vrijgekomen punten\n2. Verplaatsen van stukken naar aangrenzende punten\n3. (optionele fase) Verplaatsen van speelstukken naar een vrij punt wanneer de speler tot drie stukken is gereduceerd\n\nHet plaatsen van\n\nHet spel begint met een leeg bord, dat bestaat uit een raster met vierentwintig punten. De spelers plaatsen om beurten hun stukken op de lege punten totdat elke speler alle stukken op het bord heeft geplaatst. Als een speler drie van zijn stukken recht kan zetten, heeft hij een \"molen\" en mag hij één van de stukken van zijn tegenstander van het bord verwijderen.\n\nIn sommige regels moeten spelers eerst alle andere stukken verwijderen voordat ze een stuk van een gevormde molen verwijderen.\n\nIn sommige regels kun je in de plaatsingsfase de stukken niet opnieuw plaatsen op de punten van verwijderde stukken.\n\nZodra alle stukken zijn gebruikt, bewegen de spelers om beurten.\n\nVerplaatsen\n\nOm te bewegen verplaatst een speler een van zijn speelstukken langs een bordlijn naar een vrij aangrenzend punt. Als hij dit niet kan doen, heeft hij het spel verloren. Net als in de plaatsingsfase heeft een speler die drie van zijn stukken op een bordlijn zet een molen en mag hij een stuk van zijn tegenstander verwijderen. Een speler die nog maar twee stukken heeft, heeft geen mogelijkheid om nieuwe molens te vormen, en verliest dus het spel. Een speler kan ook verliezen als hij meer dan drie stukken heeft, als zijn tegenstander hem belet te bewegen.\n\nVliegend\n\nIn sommige varianten van de regels kunnen, zodra een speler nog maar drie stukken over heeft, zijn stukken naar alle vrije punten vliegen, springen of wippen, niet alleen naar aangrenzende punten.';

  @override
  String get versionInfo => 'Versie-info';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Licentie';

  @override
  String get sourceCode => 'Broncode';

  @override
  String get appVersion => 'App-versie';

  @override
  String get general => 'Algemeen';

  @override
  String get advanced => 'Geavanceerd';

  @override
  String get placing => 'Plaatsen';

  @override
  String get moving => 'verplaatsen';

  @override
  String get removing => 'Verwijderen';

  @override
  String get gameOverCondition => 'Spel over conditie';

  @override
  String get aisPlayStyle => 'AI\'s speelstijl';

  @override
  String get passive => 'Passief';

  @override
  String get timeout => 'Time-out';

  @override
  String get appearance => 'Verschijning';

  @override
  String get drawOnHumanExperience => 'Maak gebruik van de menselijke ervaring';

  @override
  String get considerMobility => 'Overweeg mobiliteit van stukken';

  @override
  String get pieceCount => 'Stukken tellen:';

  @override
  String inHand(Object player, int count) {
    return '$player in de hand: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player aan boord: $count';
  }

  @override
  String get boardTop => 'Bord verschoven van de top';

  @override
  String get notAIsTurn => 'De AI is niet aan de beurt.';

  @override
  String get aiIsNotThinking => 'AI denkt niet na.';

  @override
  String get atEnd => 'Aan het eind van de zettenlijst.';

  @override
  String get tapBackAgainToLeave => 'Tik opnieuw om te vertrekken.';

  @override
  String get more => 'Meer';

  @override
  String get experimental => 'Dit is een experimentele functie.';

  @override
  String get experiments => 'Experimenten';

  @override
  String get ossLicenses => 'Open bron licenties';

  @override
  String get language => 'Taal';

  @override
  String get defaultLanguage => 'Standaard taal';

  @override
  String get mayMoveInPlacingPhase =>
      'De stukken kunnen bewegen in de plaatsingsfase';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Er zijn geen verschillende plaatsings- en beweegfases, d.w.z. de spelers kunnen bij elke zet beslissen of ze een stuk op het bord willen plaatsen of een van hun stukken willen verplaatsen (zolang ze nog stukken over hebben om te plaatsen).';

  @override
  String get drawerColor => 'Menukleur';

  @override
  String get drawerTextColor => 'Kleur menutekst';

  @override
  String get drawerHighlightItemColor => 'Kleur van menumarkeringen';

  @override
  String get mainToolbarBackgroundColor => 'Achtergrondkleur hoofdwerkbalk';

  @override
  String get mainToolbarIconColor => 'Kleur van hoofdwerkbalkpictogram';

  @override
  String get navigationToolbarBackgroundColor =>
      'Achtergrondkleur van navigatiewerkbalk';

  @override
  String get navigationToolbarIconColor => 'Pictogramkleur navigatiewerkbalk';

  @override
  String get autoHideToolbar => 'De werkbalk automatisch verbergen';

  @override
  String get toolbarLocationOnScreen => 'Locatie van werkbalk op scherm';

  @override
  String get top => 'Top';

  @override
  String get bottom => 'Bodem';

  @override
  String get center => 'Centrum';

  @override
  String get solidColor => 'Effen kleur';

  @override
  String get picture => 'Afbeelding';

  @override
  String get chooseYourPicture => 'Kies je foto';

  @override
  String get light => 'Licht';

  @override
  String get dark => 'Donker';

  @override
  String get themes => 'Thema\'s';

  @override
  String get currentTheme => 'Huidig thema';

  @override
  String get saveTheme => 'Thema opslaan';

  @override
  String get showAnalysisGraph => 'Analysegrafiek weergeven';

  @override
  String get analysis => 'Analyse';

  @override
  String get saveGame => 'Spel opslaan';

  @override
  String get loadGame => 'Spel laden';

  @override
  String get setupPosition => 'Instelpositie';

  @override
  String get showLegalMoves => 'Laat legale zetten zien';

  @override
  String get showLastMove => 'Laatste zet tonen';

  @override
  String get showArrows => 'Pijlen tonen';

  @override
  String get pieces => 'Stukken';

  @override
  String get showAnalysis => 'Toon analyse';

  @override
  String get threads => 'Draden';

  @override
  String get getInvolved => 'Raak betrokken';

  @override
  String get helpImproveTranslate => 'Help de vertaling te verbeteren';

  @override
  String get tutorial => 'zelfstudie';

  @override
  String get classicMill => 'Klassieke molen';

  @override
  String get mixedMill => 'Gemengde Molen';

  @override
  String get ceylonMill => 'Ceylon molen';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'De molen kan herhaaldelijk worden gebroken en opnieuw gemaakt';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Als een speler een molen breekt om onmiddellijk een nieuwe molen te maken, kan zo\'n speler zo\'n stuk terug verplaatsen naar de oorspronkelijke kruising in zijn volgende zet als hij een nieuwe molen maakt.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Het spel is remise als een speler drie stukken heeft en na tien zetten geen van beide spelers de stukken van de tegenstander verwijdert';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Wanneer een speler nog maar drie stukken heeft en geen van beide spelers kan het stuk van een tegenstander binnen tien zetten verwijderen, is het spel gelijkspel.';

  @override
  String get close => 'Dichtbij';

  @override
  String get whitePiece => 'Wit stuk';

  @override
  String get blackPiece => 'Zwart stuk';

  @override
  String get emptyPoint => 'Leeg punt';

  @override
  String get noPoint => 'Geen punt';

  @override
  String get placingPhase => 'Plaatsingsfase';

  @override
  String get movingPhase => 'Bewegende fase';

  @override
  String get flyingPhase => 'Vliegende fase';

  @override
  String sideToMove(Object player) {
    return 'Kant om te bewegen: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Laatste zet: $move';
  }

  @override
  String get selected => 'Geselecteerd';

  @override
  String get accessibility => 'Toegankelijkheid';

  @override
  String get screenReaderSupport => 'Ondersteuning voor schermlezers';

  @override
  String get isDraw => 'Het is een gelijkspel!';

  @override
  String get draw => 'Tekenen';

  @override
  String get pieceHighlightColor => 'Stuk markeerkleur';

  @override
  String get algorithm => 'Algoritme';

  @override
  String get endgameNMoveRule => 'Eindspel N-Move regel';

  @override
  String get endgameNMoveRule_Detail =>
      'Als een van beide spelers slechts drie stukken heeft en geen van beide spelers een stuk binnen een bepaalde zet verwijdert, is het spel gelijkspel.';

  @override
  String get drawReasonEndgameRule50 =>
      'Elke speler heeft slechts drie stukken en geen van beide spelers verwijdert een stuk binnen een bepaalde zet.';

  @override
  String get threefoldRepetitionRule => 'Drievoudige herhalingsregel';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Het spel is remise als een stelling voor de derde keer voorkomt.';

  @override
  String get continueToMakeMove => 'Molen! Ga door met het maken van een zet.';

  @override
  String get pointStyle => 'Punt stijl';

  @override
  String get pointWidth => 'Puntbreedte';

  @override
  String get solid => 'Stevig';

  @override
  String get hollow => 'Hol';

  @override
  String get languageName => 'Nederlands';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count beweegt',
      one: '$count Beweging',
      zero: 'Beweging',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Laden mislukt.';

  @override
  String get filename => 'Bestandsnaam';

  @override
  String get browse => 'Bladeren…';

  @override
  String get gameFiles => 'Spelbestanden';

  @override
  String get gameSavedTo => 'Het spel is opgeslagen op';

  @override
  String get empty => 'Leeg';

  @override
  String get noMove => 'Geen zet.';

  @override
  String get restoredPosition => 'Herstelde beginpositie.';

  @override
  String get clean => 'Schoon';

  @override
  String get cleanedUp => 'Schoongemaakt.';

  @override
  String get remove => 'Verwijderen';

  @override
  String get noPiecesCanBeRemoved =>
      'Er kunnen geen stukken worden verwijderd.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pieces',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 moet worden verwijderd.';
  }

  @override
  String placedCount(int count) {
    return 'Geplaatst ($count)';
  }

  @override
  String get placedPieceCount =>
      'Aantal geplaatste stukken in de plaatsingsfase.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'De huidige speler heeft $count stukken geplaatst.';
  }

  @override
  String get notPlacingPhase => 'Fase niet plaatsen, kan deze niet veranderen.';

  @override
  String get paste => 'Plakken';

  @override
  String get pasteDone => 'Plakken voltooid.';

  @override
  String get cannotPaste => 'Kan niet plakken.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Niet-geplaatste en verwijderde stukken weergeven';

  @override
  String get fullScreen => 'Volledig scherm';

  @override
  String get reopenToTakeEffect =>
      'Sluit de app en open deze opnieuw om de instellingen van kracht te laten worden.';

  @override
  String get forest => 'Woud';

  @override
  String get desktopImage => 'Bureaubladafbeelding';

  @override
  String get invalidPosition => 'Ongeldige positie.';

  @override
  String get shareGIF => 'Deel GIF';

  @override
  String get pixelRatio => 'Pixelverhouding';

  @override
  String get duration => 'Looptijd';

  @override
  String get gameScreenRecorder => 'Spelschermrecorder';

  @override
  String get previous => 'Vorig';

  @override
  String get next => 'Volgende';

  @override
  String get skip => 'Overslaan';

  @override
  String get gotIt => 'Ik snap het';

  @override
  String get youCanModifyRules =>
      'U kunt de spelregels wijzigen in de regelinstellingen.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'U kunt het muiswiel gebruiken om de waarde in de kiezer te wijzigen.';

  @override
  String get noTimeLimitForThinking =>
      'AI Denktijd ingesteld op 0 betekent dat er geen tijdslimiet is om na te denken.';

  @override
  String get whatIsMtdf =>
      'MTD(f) is een gewijzigde vorm van het alfa-bèta-zoekalgoritme dat tot doel heeft de efficiëntie te verbeteren door tussentijdse zoekresultaten te hergebruiken en een goede initiële schatting te gebruiken om de zoekruimte te verkleinen.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Houd er rekening mee dat de aanpassing van de denktijd van de AI mogelijk niet helemaal nauwkeurig is. De daadwerkelijke denktijd kan korter zijn als de moeilijkheidsgraad op een lagere waarde is ingesteld en kan langer zijn als de AI halverwege nadenkt als de tijd om is.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Als u de moeilijkheidsgraad hoog instelt maar de AI-denktijd niet verlengt, kan de werkelijke moeilijkheidsgraad worden beperkt tot een lagere waarde vanwege de beperking van de denktijd. De werkelijke waarde kan variëren op basis van de prestaties van de machine.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) is een zoekalgoritme om de beste zet in een bepaalde stelling te vinden. Het is een verbetering van het alfa-bèta-algoritme en gebruikt nul- of nulvensterzoekopdrachten om te bevestigen dat een zet slechter of niet slechter is dan een reeds veilige score van de hoofdvariatie. PVS richt zich op de meest veelbelovende zetten en vermijdt onnodig zoeken in suboptimale branches, wat de efficiëntie van het zoeken helpt verbeteren.';

  @override
  String get whatIsAlphaBeta =>
      'Het alfa-bèta-algoritme is een zoekalgoritme om de beste zet te vinden. Het gebruikt het minimax-principe en twee waarden, alfa en bèta, om de zoekboom te snoeien en de efficiëntie te verhogen. Alfa staat voor de minimale score die de computer zeker kan behalen, terwijl bèta de maximale score vertegenwoordigt die de tegenstander kan behalen. Het algoritme helpt de computer om slimme, efficiënte beslissingen te nemen in een game.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Volgens menselijke ervaring verlies je als je probeert te winnen. Streef in plaats daarvan naar een gelijkspel als je doel en voorkom dat je de wedstrijd verliest. Observeer je tegenstander en lok hem voorzichtig naar een positie waar hij fouten kan maken. Als ze zwakte tonen, grijp dan de kans en duw voorzichtig naar de overwinning. Op deze manier kun je het spel winnen.';

  @override
  String get firstMoveDetail =>
      'In dit spel is het gemakkelijker voor de tweede speler om te winnen in vergelijking met de eerste speler.';

  @override
  String get passiveDetail =>
      'Als je de passieve optie inschakelt, ontspant de AI wanneer hij een voordeel heeft in de positie, in plaats van agressief te proberen zo snel mogelijk te winnen.';

  @override
  String get moveRandomlyDetail =>
      'Door deze optie in te schakelen, wordt de willekeur en het plezier van het spel vergroot, terwijl het uitschakelen kan helpen bij het bestuderen van manieren om de AI te verslaan.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Als de AI rekening houdt met de beweeglijkheid van zijn stukken, zal hij niet alleen proberen de stukken van de tegenstander zo snel mogelijk te slaan, maar ook overwegen om de bewegingen van de tegenstander te blokkeren en te voorkomen dat hij hetzelfde doet.';

  @override
  String get whenBoardIsFull => 'Als het bord vol is';

  @override
  String get whenBoardIsFull_Detail =>
      'Aan het einde van de plaatsingsfase, voordat de verplaatsingsfase begint, volgt de actie als het bord vol met stukken is.';

  @override
  String get sideToMoveRemovePiece =>
      'De speler die als eerste beweegt in de verplaatsingsfase, verwijdert een van de stukken van de tegenstander.';

  @override
  String get agreeToDraw => 'Beide partijen gaan akkoord met een gelijkspel.';

  @override
  String get takeOpponentsPiece => 'Pak een stuk van je tegenstander.';

  @override
  String get firstPlayerLose => 'De eerste speler verliest het spel.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'De eerste en tweede speler verwijderen een stuk van de tegenstander.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'De tweede en eerste speler verwijderen een stuk van de tegenstander.';

  @override
  String get enteredFlyingPhase =>
      'Nu de vliegende fase is ingegaan, kunnen de stukken van de tegenstander naar elk leeg punt op het bord springen. U kunt de vliegregel uitschakelen in de \"Regelinstellingen\".';

  @override
  String get whenStalemate => 'Bij patstelling';

  @override
  String get whenStalemate_Detail =>
      'Welke actie volgt als er geen stuk kan worden verplaatst?';

  @override
  String get endWithStalemateLoss => 'Eindig met verlies door patstelling.';

  @override
  String get changeSideToMove => 'Verander de kant om te bewegen.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Verwijder een van de stukken van de tegenstander en doe de volgende zet.';

  @override
  String get endWithStalemateDraw => 'Eindig met remise door patstelling.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Verwijder een van de stukken van de tegenstander en verander de kant om te bewegen.';

  @override
  String get aiResponseDelayTime => 'AI reactievertragingstijd';

  @override
  String get aiIsDelaying =>
      'AI bevindt zich momenteel in een vertraagde reactiefase. Wacht even voordat u verder gaat.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'U kunt een niet-aangrenzend stuk niet verwijderen.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Als er een patstelling is, kunnen de stukken van de tegenstander naast die van jou worden verwijderd, ongeacht de opstelling van de molen.';

  @override
  String get whatIsMcts =>
      'MCTS is een beginnersvriendelijk algoritme dat beslissingen neemt door verschillende bewegingen te verkennen en te evalueren door middel van simulaties.';

  @override
  String get goldenJade => 'Gouden jade';

  @override
  String get forestWood => 'Bos Hout';

  @override
  String get darkMystery => 'Duister Mysterie';

  @override
  String get midnightBlue => 'Middernacht blauw';

  @override
  String get greenForest => 'Groen bos';

  @override
  String get greenMeadow => 'Groene Weide';

  @override
  String get stonyPath => 'Steenachtig pad';

  @override
  String get pastelPink => 'Pastelroze';

  @override
  String get turquoiseSea => 'Turquoise Zee';

  @override
  String get violetDream => 'Violette droom';

  @override
  String get mintChocolate => 'Munt Chocolade';

  @override
  String get skyBlue => 'Hemelsblauw';

  @override
  String get playfulGarden => 'Speelsetuin';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Het algoritme voor retrograde-analyse maakt gebruik van meerwaardige retrograde-analyse om een eindspel-database op te bouwen vanuit verschillende startposities en past deze database vervolgens toe om de gameplay te optimaliseren. Deze aanpak valt onder de categorie Ultrasterke oplossingen.';

  @override
  String get viewAlgorithmGuide =>
      'Wilt u de gebruikershandleiding van dit algoritme bekijken?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Toon positionele voordeelindicator';

  @override
  String get usePerfectDatabase => 'Gebruik een perfecte database';

  @override
  String get perfectDatabaseDescription =>
      'Schakel deze optie in om een onberispelijke gamedatabase te gebruiken die is gegenereerd door middel van geavanceerde algoritmen. Deze functie integreert zowel openings- als eindspelstrategieën om optimale zetten voor te stellen. Dit is de voorkeurskeuze voor spelers die op zoek zijn naar het hoogste niveau van precisie in de gameplay. De database is gemaakt met nauwgezette computertechnieken en is ontworpen om bijna perfecte speloplossingen te bieden.\n\nOpmerking: mocht de AI er niet in slagen toegang te krijgen tot de database, dan zal hij zich tot conventionele algoritmen wenden voor gameplay-beslissingen. Wanneer de database beschikbaar is, wordt de \'Moeilijkheidsgraad\' vrijwel onverslaanbaar en ervaart de \'AI Thinking Time\' een drastische vermindering. Veel instellingen binnen de \'AI\'s speelstijl\'-opties worden overschreven, omdat de databaseresultaten de hoogste prioriteit hebben.\n\nVoor richtlijnen over hoe u het beste uit deze onberispelijke database kunt halen, klik hier.';

  @override
  String get backgroundImage => 'Achtergrondafbeelding';

  @override
  String get whatIsRandom =>
      'Wanneer de optie \'Gebruik perfecte database\' niet is ingeschakeld, zorgt de instelling \'Random\' ervoor dat de AI willekeurig stukken verplaatst zonder gebruik te maken van algoritmen voor zetselectie. Dit resulteert doorgaans in aanzienlijk zwakkere gameplay. Omgekeerd, wanneer ‘Gebruik perfecte database’ is ingeschakeld, vertrouwt de AI uitsluitend op de ‘Perfecte Database’ voor het nemen van beslissingen, in plaats van deze te combineren met traditionele AI-algoritmen. In deze modus zijn de bewegingen van de AI volledig gebaseerd op de inhoud van de database, waarbij de afhankelijkheid van realtime berekeningen of zoekalgoritmen wordt vermeden.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Verwijder de stuk(ken) van de tegenstander uit zijn/haar hand; dan is het de beurt van de tegenstander om te plaatsen.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Bij het vormen van molens tijdens de plaatsingsfase';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Verwijder de stuk(ken) van de tegenstander van het bord.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Verwijder de stuk(ken) van de tegenstander van het bord; dan is het de beurt van de tegenstander om te plaatsen.';

  @override
  String get opponentRemovesOwnPiece =>
      'De tegenstander verwijdert zijn/haar eigen stuk(ken) van het bord.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'In plaats van dat jij actie onderneemt, kiest en verwijdert de tegenstander zijn/haar eigen stuk(ken) van het bord, waarmee hij/zij een actie onderneemt die schadelijk is voor zichzelf.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Verwijder de stuk(ken) van de tegenstander uit zijn/haar hand; dan is het jouw beurt om te verplaatsen.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Verwijder stuk(ken) uit de hand van de tegenstander. Als, volgens de instelling \'Meervoudig verwijderen\', meerdere stukken moeten worden verwijderd en de tegenstander geen stukken meer in de hand heeft, ga je door met het verwijderen van de stukken van de tegenstander van het bord. Dan is het jouw beurt om te verplaatsen. Als je blijft molens vormen, kun je doorgaan met het verwijderen van de stukken van de tegenstander.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Verwijder stuk(ken) uit de hand van de tegenstander. Als, volgens de instelling \'Meervoudig verwijderen\', meerdere stukken moeten worden verwijderd en de tegenstander geen stukken meer in de hand heeft, ga je door met het verwijderen van de stukken van de tegenstander van het bord. Daarna is het de beurt van de tegenstander om te verplaatsen.';

  @override
  String get markAndDelayRemovingPieces =>
      'Markeer en vertraag het verwijderen van stukken.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Tijdens de plaatsingsfase worden de te verwijderen stukken gemarkeerd en kunnen beide spelers geen nieuwe stukken op deze punten plaatsen. Bij het ingaan van de bewegingsfase worden deze gemarkeerde stukken volledig verwijderd en kunnen spelers hun stukken naar deze nu lege punten verplaatsen.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'De acties die ondernomen kunnen worden bij het vormen van molens tijdens de plaatsingsfase.';

  @override
  String get marked => 'Gemarkeerd';

  @override
  String get menu => 'Menu';

  @override
  String get monochrome => 'Monochroom';

  @override
  String get youCanEnableScreenReaderSupport =>
      'U kunt ondersteuning voor schermlezers inschakelen in de toegankelijkheidsinstellingen onder Algemene instellingen.';

  @override
  String get showNumbersOnPieces => 'Toon nummers op stukken';

  @override
  String get saveImage => 'Afbeelding opslaan';

  @override
  String get isAnalysisToolbarShown => 'Toon analysetoolbalk';

  @override
  String get analysisToolbarBackgroundColor =>
      'Achtergrondkleur van analysetoolbalk';

  @override
  String get analysisToolbarIconColor => 'Pictogramkleur van analysetoolbalk';

  @override
  String get transformed => 'Getransformeerd.';

  @override
  String get cannotTransform => 'Kan niet transformeren.';

  @override
  String get rotate => 'Roteer';

  @override
  String get horizontalFlip => 'H.S.';

  @override
  String get verticalFlip => 'V.S.';

  @override
  String get innerOuterFlip => 'B/B S.';

  @override
  String get transparentCanvas => 'Transparant Canvas';

  @override
  String get restrictRepeatedMillsFormation => 'Beperk herhaalde molenvorming';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Een stuk verplaatst van de ene molen naar de andere kan niet onmiddellijk terugkeren naar het oorspronkelijke punt op de volgende beurt om weer een molen te vormen. Eerst is een andere zet nodig.';

  @override
  String get oneTimeUseMill => 'Eenmalig gebruik molen';

  @override
  String get oneTimeUseMill_Detail =>
      'Elke molen kan slechts één keer een stuk van de tegenstander verwijderen. Je kunt het opnieuw vormen, maar het kan niet worden gebruikt voor extra verwijderingen.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'De huidige regels die je hebt ingesteld, hebben geen overeenkomstige perfecte database. Voor meer informatie over de perfecte database, klik hier.';

  @override
  String get focusOnBlockingPaths => 'Richt je op het blokkeren van paden';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Geef prioriteit aan het blokkeren van de beweging van de tegenstander boven het vormen van molens. In plaats van je te concentreren op het verwijderen van stukken door molens te voltooien, probeert de AI de tegenstander in de val te lokken, waardoor ze niet kunnen bewegen en een overwinning te behalen door uithoudingsvermogen in plaats van agressief spel. Deze strategie blokkeert de molens van de tegenstander niet actief.';

  @override
  String get pieceImage => 'Stuk afbeelding';

  @override
  String get importColorSettings => 'Kleurinstellingen importeren';

  @override
  String get exportColorSettings => 'Kleurinstellingen exporteren';

  @override
  String get import => 'Importeren';

  @override
  String get export => 'Exporteren';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Kopieer de instellingen in JSON-indeling eerst naar het klembord.';

  @override
  String get copiedToClipboard => 'Gekopieerd naar klembord.';

  @override
  String get imported => 'Geïmporteerd.';

  @override
  String get boardImage => 'Bordafbeelding';

  @override
  String get autumnLeaves => 'Herfstbladeren';

  @override
  String get legendaryLand => 'Legendarisch Land';

  @override
  String get vignetteEffect => 'Vignetteringseffect';

  @override
  String get promptMakeToolbarTransparent =>
      'Wil je de werkbalk volledig transparant maken wanneer een achtergrondafbeelding voor het bord is ingesteld?';

  @override
  String get vibration => 'Trilling inschakelen in het spel';

  @override
  String get soundTheme => 'Geluids thema';

  @override
  String get ball => 'Bal';

  @override
  String get liquid => 'Vloeistof';

  @override
  String get wood => 'Hout';

  @override
  String get placeEffectAnimation => 'Animatie-effect bij plaatsen van stuk';

  @override
  String get removeEffectAnimation =>
      'Animatie-effect bij verwijderen van stuk';

  @override
  String get isToolbarAtBottom => 'Werkbalk onderaan weergeven';

  @override
  String get boardCornerRadius => 'Hoekstraal van het bord';

  @override
  String get useOpeningBook => 'Gebruik openingsboek';

  @override
  String get currentRule => 'Huidig';

  @override
  String get nineMensMorris => 'Molenspel';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Regelset';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Laat de AI openingszetten gebruiken die vaak worden gebruikt door professionele menselijke spelers in het vroege spel. Opmerking: Deze functie is momenteel alleen beschikbaar voor specifieke regelsets.';

  @override
  String get showAdvantageGraph => 'Voordeelgrafiek weergeven';

  @override
  String get advantageGraphHint =>
      'De voordeelgrafiek wordt alleen getekend nadat de AI een zet heeft gedaan. Hij wordt niet getekend wanneer de menselijke speler een zet doet.';

  @override
  String get removalBasedOnMillCounts =>
      'Schakel het verwijderen uit totdat alle stukken zijn geplaatst. Spelers verwijderen stukken op basis van het aantal molens.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Schakel het verwijderen uit totdat alle stukken zijn geplaatst. Spelers verwijderen stukken op basis van het aantal molens: als het gelijk is, verwijderen beide spelers hetzelfde aantal stukken; als de één er meer heeft, verwijdert hij een extra stuk, waarmee het verschil op één stuk blijft. Als slechts één speler een molen vormt, verwijdert hij twee stukken, terwijl de andere speler er één verwijdert. Als geen van beide een molen vormt, verwijderen beide spelers één stuk.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Selecteer een van je stukken.';

  @override
  String get notYourTurn => 'Het is niet jouw beur.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Achtergrondkleur annotatiewerkbalk';

  @override
  String get annotationToolbarIconColor => 'Pictogramkleur annotatiewerkbalk';

  @override
  String get isAnnotationToolbarShown => 'Annotatiewerkbalk weergeven';

  @override
  String get enterAnnotationMode => 'Annotatiemodus starten';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Weet je zeker dat je alle annotaties wilt wissen?';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM-prompt naar klembord gekopieerd.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Verbinding geweigerd, de server is mogelijk uitgevallen.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Detectie geslaagd, wachten op verbinding...';

  @override
  String get noLanConnection => 'Geen LAN-verbinding';

  @override
  String get takeScreenshot => 'Schermafbeelding maken';

  @override
  String get disconnectedFromOpponent =>
      'Verbinding met tegenstander verbroken.';

  @override
  String get takeBackRequest => 'Terugnameverzoek';

  @override
  String get nothingToShow => 'Niets weer te geven.';

  @override
  String get stopHosting => 'Hosten stoppen';

  @override
  String get connectionResetByPeer => 'Verbinding door peer gereset.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Verbinding verloren door heartbeat-timeout. Verbind opnieuw.';

  @override
  String get startHosting => 'Hosten starten';

  @override
  String get restartRequestRejected => 'Herstartverzoek afgewezen.';

  @override
  String get notConnectedToLanOpponent =>
      'Niet verbonden met LAN-tegenstander.';

  @override
  String get llmPrompt => 'LLM-prompt';

  @override
  String get gameRestarted => 'Spel herstart.';

  @override
  String get takeBackRejected => 'Terugname geweigerd.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Weet je zeker dat je dit spel wilt opgeven?';

  @override
  String get opponentResignedYouWin =>
      'Tegenstander heeft opgegeven. Jij wint!';

  @override
  String get clearAllAnnotations => 'Alle annotaties wissen';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Verbonden, wachten op tegenstanders zet...';

  @override
  String get networkStatusDisconnected => 'Netwerkstatus: Verbinding verbroken';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Terugnameverzoek naar tegenstander gestuurd.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Tegenstander heeft mogelijk het spel verlaten';

  @override
  String get connectedToHostSuccessfully => 'Succesvol verbonden met host.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Verbinding verbroken: heartbeat-timeout';

  @override
  String get noHostDiscovered => 'Geen host gevonden.';

  @override
  String get confirmResignation => 'Opgeven bevestigen';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Hosten gestart, wachten op spelers...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Verbindingstijd verlopen, netwerkverbinding instabiel.';

  @override
  String get noLlmPromptAvailable => 'Geen LLM-prompt beschikbaar.';

  @override
  String get youResignedGameOver => 'Je hebt opgegeven. Spel afgelopen.';

  @override
  String get serverIp => 'Server-IP';

  @override
  String get confirmClear => 'Wissen bevestigen';

  @override
  String get opponentSTurn => 'Beurt van tegenstander.';

  @override
  String get waitingAClientConnection => 'Wachten op clientverbinding...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Terugnameverzoek afgewezen of mislukt.';

  @override
  String get addText => 'Tekst toevoegen';

  @override
  String get exitAnnotationMode => 'Annotatiemodus verlaten';

  @override
  String get typeYourAnnotation => 'Typ je annotatie';

  @override
  String get attemptingToReconnect => 'Bezig met opnieuw verbinden...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Herstartverzoek verzonden. Wachten op reactie tegenstander...';

  @override
  String get serverIsStopped => 'Server is gestopt.';

  @override
  String get restartRequest => 'Herstartverzoek';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Kan geen terugname vragen als het niet jouw beurt is.';

  @override
  String get takeBackAccepted => 'Terugname geaccepteerd.';

  @override
  String get localNetworkSettings => 'Lokaal netwerkinstellingen';

  @override
  String get reconnectedSuccessfully => 'Succesvol opnieuw verbonden!';

  @override
  String get failedToSaveImageToGallery => 'Opslaan in galerij mislukt.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Tegenstander wil spel herstarten. Accepteer je dit?';

  @override
  String get yourTurn => 'Jouw beurt.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Kan niet opnieuw verbinden. Herstart het spel.';

  @override
  String get host => 'Host';

  @override
  String get join => 'Deelnemen';

  @override
  String get port => 'Poort';

  @override
  String get invalidIpAddress => 'Ongeldig IP-adres.';

  @override
  String get invalidPort => 'Ongeldige poort.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Verbinden: Poging $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Verbinding mislukt: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Starten van host mislukt: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Host gevonden: $ip:$port';
  }

  @override
  String get stop => 'Stoppen';

  @override
  String get discover => 'Ontdekken';

  @override
  String get connect => 'Verbinden';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Client verbonden: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Bezig met ontdekken: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Opnieuw verbinden ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Verbonden';

  @override
  String get delete => 'Verwijderen';

  @override
  String get ancientEgypt => 'Oud Egypte';

  @override
  String get gothicIce => 'Gotisch Ijs';

  @override
  String get riceField => 'Rijstveld';

  @override
  String get chinesePorcelain => 'Chinees Porselein';

  @override
  String get desertDusk => 'Woestijnschemering';

  @override
  String get precisionCraft => 'Precisieambacht';

  @override
  String get folkEmbroidery => 'Volkskunst Borduurwerk';

  @override
  String get carpathianHeritage => 'Karpatisch Erfgoed';

  @override
  String get imperialGrandeur => 'Keizerlijke Pracht';

  @override
  String get bohemianCrystal => 'Boheems Kristal';

  @override
  String get savannaSunrise => 'Savanne Zonsopgang';

  @override
  String get harmonyBalance => 'Harmonie en Balans';

  @override
  String get cinnamonSpice => 'Kaneel Kruid';

  @override
  String get anatolianMosaic => 'Anatolisch Mozaïek';

  @override
  String get carnivalSpirit => 'Carnavalsgeest';

  @override
  String get custom => 'Aangepast';

  @override
  String get spiceMarket => 'Specerijenmarkt';

  @override
  String get swipeToRevealTheDrawer => 'Veeg om de lade te tonen';

  @override
  String get showGameInfoOnScreenshots =>
      'Toon spelinformatie op schermafbeeldingen';

  @override
  String get humanMoveTime => 'Menselijke tijdslimiet';

  @override
  String get noTimeLimitForHumanMoves =>
      'Geen tijdslimiet voor menselijke zetten';

  @override
  String get timeoutLoseWillBeApplied =>
      'Timeoutverlies wordt toegepast voor de menselijke speler';

  @override
  String get identifyingBoard => 'Spelbord identificeren...';

  @override
  String get youCanEnterAnyModelName => 'Je kunt elke modelnaam invoeren.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Bordpositie toegepast. FEN gekopieerd naar klembord.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Suggestie: probeer een duidelijkere foto van het spelbord te maken.';

  @override
  String get llmPromptTemplate => 'LLM prompt‑sjabloon';

  @override
  String get noValidBoardDetected => 'Geen geldig spelbord gevonden.';

  @override
  String get selectingImageFromAlbum => 'Afbeelding selecteren uit album...';

  @override
  String get configurePromptTemplate => 'Configureer prompt‑sjabloon';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Bewerk prompt‑sjabloon voor LLM‑analyse';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Kon geen FEN genereren uit herkend bord.';

  @override
  String get outputInCurrentLanguage => 'Uitvoer in huidige taal';

  @override
  String get commonBaseUrls => 'Veelvoorkomende Base URL’s';

  @override
  String get viewCommonModels => 'Bekijk veelgebruikte modellen';

  @override
  String get recognitionParametersUpdated =>
      'Herkenningsparameters bijgewerkt.';

  @override
  String get whiteSMove => 'Wit aan zet';

  @override
  String get resetToDefaults => 'Terug naar standaardwaarden';

  @override
  String get photoShoot => 'Fotoshoot';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Kon herkende bordpositie niet toepassen.';

  @override
  String get llmPromptContent => 'LLM prompt‑inhoud';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM niet geconfigureerd. Controleer je instellingen.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Stel provider, model, API Key en Base URL in';

  @override
  String get llmConfiguration => 'LLM‑configuratie';

  @override
  String get configureLlmProvider => 'Configureer LLM‑provider';

  @override
  String get llmPromptTemplateHeader => 'LLM prompt‑sjabloon koptekst';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Geen stukken herkend in de afbeelding. Probeer het opnieuw.';

  @override
  String get recognizeBoardFromImage => 'Herken bord uit afbeelding';

  @override
  String get viewTips => 'Bekijk tips';

  @override
  String get applyToBoard => 'Toepassen op bord';

  @override
  String get adjustBoardArea => 'Bordgebied aanpassen';

  @override
  String get viewCommonUrls => 'Bekijk veelgebruikte URL’s';

  @override
  String get colorAnalysisFailed => 'Kleuranalyse mislukt!';

  @override
  String get analyzingGameBoardImage =>
      'Bezig met analyseren van spelbord‑afbeelding...';

  @override
  String get selectFromAlbum => 'Selecteer uit album';

  @override
  String get noBoardPointDetected => 'Geen bordpunt gedetecteerd!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Als leeg gelaten, wordt de standaardsjabloon gebruikt';

  @override
  String get llmConfig => 'LLM‑instellingen';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Weet je zeker dat je de prompt‑sjablonen wilt terugzetten naar de standaardwaarden?';

  @override
  String get llmPromptTemplateFooter => 'LLM prompt‑sjabloon voettekst';

  @override
  String get loadingResponse => 'Antwoord laden...';

  @override
  String get applyThisResultToBoard => 'Pas dit resultaat toe op bord';

  @override
  String get takingPicture => 'Foto maken...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Selecteer een spelbord‑afbeelding om te herkennen';

  @override
  String get identificationResults => 'Herkenningsresultaten';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analyseer de zetten en geef inzicht.';

  @override
  String get getApiKey => 'API Key ophalen';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Het gehele herkenningsproces kon niet worden voltooid.';

  @override
  String get boardRecognitionResult => 'Bordherkenningsresultaat';

  @override
  String get askLlm => 'Vraag LLM';

  @override
  String get boardDetectionFailed => 'Bordherkenning mislukt!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Geen bordpunt gedetecteerd, kan stuk niet identificeren!';

  @override
  String get copyFen => 'Kopieer FEN';

  @override
  String get commonlyUsedModels => 'Veelgebruikte modellen';

  @override
  String get apiKeyOptional => 'API Key (optioneel)';

  @override
  String get noImageSelected => 'Geen afbeelding geselecteerd';

  @override
  String get blackSMove => 'Zwart aan zet';

  @override
  String get llm => 'Groot taalmodel';

  @override
  String get llmProvider => 'Provider';

  @override
  String get baseUrl => 'Basis-URL';

  @override
  String get model => 'Model';

  @override
  String get temperature => 'Temperatuur';

  @override
  String get llmCommandReceivedProcessing =>
      'Commando ontvangen! AI is aan het verwerken...';

  @override
  String get llmDeepThinkingWait => 'Diep nadenken bezig, even geduld...';

  @override
  String get llmPresentingSoon => 'Wordt binnenkort gepresenteerd...';

  @override
  String get recognitionParameters => 'Herkenningsparameters';

  @override
  String get adjustParamsDesc =>
      'Pas parameters aan om de herkenningsnauwkeurigheid te verbeteren';

  @override
  String get saveParameters => 'Parameters opslaan';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Kan beeldherkenning niet starten: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Beeldherkenning mislukt: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Positie toegepast met $whiteCount witte en $blackCount zwarte stenen';
  }

  @override
  String get fenCopiedToClipboard => '(FEN naar klembord gekopieerd)';

  @override
  String recognitionFailed(String error) {
    return 'Herkenning mislukt: $error';
  }

  @override
  String get myRating => 'Mijn beoordeling';

  @override
  String get gamesPlayed => 'Gespeelde spellen';

  @override
  String get wins => 'Gewonnen';

  @override
  String get losses => 'Verloren';

  @override
  String get draws => 'Gelijkspel';

  @override
  String get lastUpdated => 'Laatst bijgewerkt';

  @override
  String get format => 'Formaat:';

  @override
  String get resetStatistics => 'Statistieken resetten';

  @override
  String get drawRate => 'Gelijkspelpercentage';

  @override
  String get lossRate => 'Verliespercentage';

  @override
  String get aiStatistics => 'AI-statistieken';

  @override
  String get enableStatistics => 'Statistieken inschakelen';

  @override
  String get enableStatistics_Detail =>
      'Indien ingeschakeld, worden spelresultaten vastgelegd in de statistieken. Spellen waarbij zetten worden teruggenomen, worden echter niet vastgelegd. Indien uitgeschakeld, wordt het verzamelen van statistieken gepauzeerd.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Hiermee worden alle spelstatistieken gereset. Deze actie kan niet ongedaan worden gemaakt.';

  @override
  String get boardInnerRingSize => 'Grootte van de binnenring van het bord';

  @override
  String get boardShadowEnabled => 'Bordschaduw';

  @override
  String get trapAwareness => 'Valdetectie';

  @override
  String get trapAwarenessDescription =>
      'Markeer valzetten met vette cirkels en pijlen tijdens de analyse.';

  @override
  String trapExists(String trapMoves) {
    return 'Er is een val. Valzetten: $trapMoves';
  }

  @override
  String get custodianCapture => 'Flankerende vangst';

  @override
  String get custodianCaptureDescription =>
      'Voeg een van de stukken van je tegenstander tussen twee van je in een rechte lijn in om het vast te leggen.';

  @override
  String get custodianCaptureEnable => 'Laat flankerende vangst toe';

  @override
  String get interventionCapture => 'Interventie vangen';

  @override
  String get interventionCaptureDescription =>
      'Ga naar het lege punt tussen twee van de stukken van je tegenstander om ze allebei vast te leggen.';

  @override
  String get interventionCaptureEnable => 'Laat interventie vastleggen';

  @override
  String get leapCapture => 'Springvang';

  @override
  String get leapCaptureDescription =>
      'Vastleggen door over het stuk van een aangrenzende tegenstander te springen in het lege punt daarachter.';

  @override
  String get leapCaptureEnable => 'Laat vastleggen door te springen';

  @override
  String get captureApplicableLines => 'Toepasselijke lijnen';

  @override
  String get captureSquareEdges => 'Langs de randen van het plein';

  @override
  String get captureCrossLines =>
      'Langs orthogonale lijnen die het vierkant kruisen';

  @override
  String get captureDiagonalLines =>
      'Langs diagonale lijnen die het vierkant oversteken';

  @override
  String get captureExecutionPhases => 'Uitvoeringsfasen';

  @override
  String get capturePiecesCondition =>
      'Beschikbaarheid tijdens de bewegende fase op basis van resterende stukken';

  @override
  String get capturePiecesConditionUnlimited => 'Geen beperking';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Beschikbaar als je drie of minder stukken hebt';
}
