// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Norwegian Bokmål (`nb`).
class SNb extends S {
  SNb([String locale = 'nb']) : super(locale);

  @override
  String get appName => 'Mølle';

  @override
  String get welcome => 'Velkommen';

  @override
  String get yes => 'Ja';

  @override
  String get no => 'Nei';

  @override
  String get game => 'Spill';

  @override
  String get humanVsAi => 'Human vs. AI';

  @override
  String get humanVsHuman => 'Human vs. Menneskelig';

  @override
  String get aiVsAi => 'AI mot AI';

  @override
  String get humanVsCloud => 'Human vs. Sky';

  @override
  String get humanVsLAN => 'Human vs. LAN';

  @override
  String get testViaLAN => 'Test via LAN';

  @override
  String get move => 'Trekk';

  @override
  String get showMoveList => 'Flytt liste';

  @override
  String get moveList => 'Flytt liste';

  @override
  String get noGameRecord => 'Ingen rekord';

  @override
  String get ok => 'OK';

  @override
  String get confirm => 'Bekrefte';

  @override
  String get cancel => 'Avbryt';

  @override
  String get tipSelectWrong => 'Velg feil brikke.';

  @override
  String get tipPlace => 'Plasser brikkene dine.';

  @override
  String get tipBanPlace => 'Du kan ikke plassere den her.';

  @override
  String get tipPlaced => 'Du plasserte.';

  @override
  String get tipRemove => 'Fjern et stykke.';

  @override
  String get tipBanRemove => 'Du kan ikke fjerne den.';

  @override
  String get tipRemoved => 'Du fjernet.';

  @override
  String get tipMove => 'Flytt et stykke.';

  @override
  String get tipCannotPlace => 'Du kan ikke plassere brikken din her.';

  @override
  String get tipCannotMove => 'Du kan ikke flytte brikken din hit.';

  @override
  String get tipMill => 'Mølle! Ta motstanderens brikke.';

  @override
  String get tipContinueMill => 'Fortsett å ta motstanderens brikke.';

  @override
  String get tipSelectOpponentsPiece => 'Velg en av motstanderens brikker.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Du kan ikke fjerne et stykke fra en mølle.';

  @override
  String get tipCanMoveOnePoint => 'Et stykke kan flytte 1 poeng.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Du kan ikke flytte motstanderens brikker.';

  @override
  String get tipSelectPieceToMove => 'Velg brikken du vil flytte.';

  @override
  String get tipHaveThreePiecesLeft => 'Du har tre stykker igjen.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Du kan flytte til et hvilket som helst punkt du vil.';

  @override
  String tipToMove(Object player) {
    return '$player for å flytte.';
  }

  @override
  String get whiteWin => 'Spiller 1 vinner!';

  @override
  String get blackWin => 'Spiller 2 vinner!';

  @override
  String get won => 'Vant';

  @override
  String get lost => 'Tapt';

  @override
  String get thinking => 'Tenker…';

  @override
  String get newGame => 'Nytt spill';

  @override
  String get importGame => 'Importer spill';

  @override
  String get exportGame => 'Eksporter spill';

  @override
  String get gameImported => 'Spill importert.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Kan ikke importere $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch =>
      'Bevegelser og regler stemmer ikke overens.';

  @override
  String get pleaseWait => 'Vennligst vent.';

  @override
  String get restartGame => 'Start det nåværende spillet på nytt?';

  @override
  String get restart => 'Omstart';

  @override
  String get gameStarted => 'Spillet startet, vær så snill å plassere det.';

  @override
  String get analyzing => 'Analyserer…';

  @override
  String error(Object message) {
    return 'Feil: $message';
  }

  @override
  String get winRate => 'Vinnsats';

  @override
  String get score => 'Resultat:';

  @override
  String get white => 'Spiller 1';

  @override
  String get black => 'Spiller 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player antall stykker er mindre enn tre.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player si opp.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player har ingen vei å gå.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Brettet er fullt, og $player har ingen vei å gå.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Tiden er over, $player tapt.';
  }

  @override
  String get drawReasonRule50 =>
      'I den bevegelige fasen er ingen brikker fjernet i det siste spesifikke antallet trekk.';

  @override
  String get drawReasonBoardIsFull => 'Det er uavgjort fordi brettet er fullt.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Det er uavgjort på grunn av tredelt repetisjon.';

  @override
  String get gameOverUnknownReason => 'Spillet er over! Ukjent årsak.';

  @override
  String get gameOver => 'Spillet er over';

  @override
  String get youWin => 'Du vinner! Gratulerer!';

  @override
  String challengeHarderLevel(int level) {
    return 'Utfordre hardere nivå? Det nye nivået vil være nivå $level!';
  }

  @override
  String get youLose => 'Du tapte!';

  @override
  String get analyze => 'Analysere';

  @override
  String get about => 'Om';

  @override
  String version(Object versionNumber) {
    return 'Versjon: $versionNumber';
  }

  @override
  String get thanks => 'Takk';

  @override
  String get settings => 'Innstillinger';

  @override
  String get options => 'Alternativer';

  @override
  String get generalSettings => 'Generelle innstillinger';

  @override
  String get skillLevel => 'Vanskelighetsnivå';

  @override
  String get moveTime => 'AI tenktid';

  @override
  String get difficulty => 'Vanskelighet';

  @override
  String get playSounds => 'Lydeffekter';

  @override
  String get playSoundsInTheGame => 'Spill lyder i spillet';

  @override
  String get keepMuteWhenTakingBack => 'Hold dempet når du tar tilbake';

  @override
  String get tone => 'Tone';

  @override
  String get whoMovesFirst => 'Første trekk';

  @override
  String get human => 'Menneskelig';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Alternere';

  @override
  String get isAutoRestart =>
      'Start spillet på nytt automatisk når spillet er over';

  @override
  String get isAutoChangeFirstMove => 'Automatisk endring av første trekk';

  @override
  String get shufflingEnabled => 'Beveg deg tilfeldig';

  @override
  String get misc => 'Diverse';

  @override
  String get rules => 'Regler';

  @override
  String get piecesCount => 'Antall brikker hver spiller har';

  @override
  String get piecesCount_Detail => 'Hvor mange brikker har hver spiller?';

  @override
  String get flyPieceCount => 'Antallet på flygende brikke';

  @override
  String get flyPieceCount_Detail =>
      'Hvis Flying er aktivert, når en spiller reduseres til et bestemt antall brikker, er brikkene hennes fritt til å bevege seg til et ledig punkt i stedet for å være begrenset til tilstøtende poeng som i resten av spillet.';

  @override
  String get piecesAtLeastCount => 'Stykker minst';

  @override
  String get hasDiagonalLines => 'Diagonale linjer';

  @override
  String get hasDiagonalLines_Detail =>
      'Legg til fire diagonale linjer på tavlen.';

  @override
  String get isDefenderMoveFirst => 'Den andre spilleren beveger seg først';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Spilleren som beveger seg andre i plasseringsfasen, beveger seg først i den bevegelige fasen.';

  @override
  String get mayRemoveMultiple => 'Fjern flere';

  @override
  String get mayRemoveMultiple_Detail =>
      'Hvis en spiller stenger mer enn en mølle samtidig, vil hun fjerne antall møller hun stengte.';

  @override
  String get mayRemoveFromMillsAlways => 'Ødelegge møller';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Som standard må spillerne fjerne alle andre brikker før de fjerner en brikke fra en dannet mølle. Aktiver dette alternativet for å deaktivere begrensningen.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Den andre spilleren taper når brettet er fullt';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Når brettet er fullt på slutten av plasseringsfasen, mister siden som plasseres først spillet. Ellers er spillet uavgjort.';

  @override
  String get isLoseButNotChangeSideWhenNoWay => 'Taper når ingen lovlige trekk';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Spilleren taper hvis motstanderen blokkerer dem slik at de ikke kan flyttes. Bytt side for å flytte hvis dette alternativet er deaktivert.';

  @override
  String get mayFly => 'Flyr';

  @override
  String get mayFly_Detail =>
      'Hvis en spiller bare har tre eller fire (konfigurerbare) brikker igjen, kan hun flytte brikken til et hvilket som helst ledig punkt.';

  @override
  String get nMoveRule => 'N-trekkregel';

  @override
  String get nMoveRule_Detail =>
      'Spillet trekkes hvis det ikke har blitt fjernet i et bestemt antall trekk.';

  @override
  String get rollback => 'Tilbakeslag';

  @override
  String get pleaseSelect => 'Vennligst velg';

  @override
  String get copy => 'Kopiere';

  @override
  String get moveHistoryCopied =>
      'Flytt historikken som er kopiert til utklippstavlen.';

  @override
  String get help => 'Hjelp';

  @override
  String get feedback => 'Tilbakemelding';

  @override
  String get exit => 'Utgang';

  @override
  String get ruleSettings => 'Regelinnstillinger';

  @override
  String get color => 'Farge';

  @override
  String get boardColor => 'Brettfarge';

  @override
  String get pieceColor => 'Brikkefarge';

  @override
  String get backgroundColor => 'Bakgrunnsfarge';

  @override
  String get lineColor => 'Board line farge';

  @override
  String get whitePieceColor => 'Spiller 1 stk farge';

  @override
  String get blackPieceColor => 'Spiller 2-delt farge';

  @override
  String get messageColor => 'Melding farge';

  @override
  String get isPieceCountInHandShown => 'Vis antall stykker i hånden';

  @override
  String get isNotationsShown => 'Vis notasjoner om bord';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Vis historikknavigasjonsverktøylinjen';

  @override
  String get display => 'Vise';

  @override
  String get boardBorderLineWidth => 'Board borderline bredde';

  @override
  String get boardInnerLineWidth => 'Board indre linjebredde';

  @override
  String get pieceWidth => 'Stykke bredde';

  @override
  String get fontSize => 'Skriftstørrelse';

  @override
  String get standardNotation => 'WMD-notasjon';

  @override
  String get restore => 'Restaurere';

  @override
  String get restoreDefaultSettings => 'Gjenopprett standardinnstillinger';

  @override
  String pick(Object element) {
    return 'Velg $element';
  }

  @override
  String get info => 'Info';

  @override
  String get hint => 'Vink';

  @override
  String get player => 'spiller';

  @override
  String get player1 => 'Spiller 1';

  @override
  String get player2 => 'Spiller 2';

  @override
  String get howToPlay => 'Hvordan spille';

  @override
  String get toPlacePiece =>
      'Trykk på et hvilket som helst tilgjengelig punkt for å plassere stykket.';

  @override
  String get toSelectPiece => 'Trykk på et stykke for å flytte det.';

  @override
  String get toMovePiece =>
      'Trykk på et punkt som er koblet til et stykke for å flytte det.';

  @override
  String get toRemovePiece => 'Trykk på motstanderens brikke for å fjerne.';

  @override
  String get needToCreateMillFirst =>
      'Du må først lage en mølle før du kan fjerne et stykke.';

  @override
  String get needToPlayWithOwnPieces => 'Du må leke med brikkene dine.';

  @override
  String get statistics => 'Statistikk';

  @override
  String get totalGames => 'Totalt antall spill';

  @override
  String get results => 'Resultater';

  @override
  String get left => 'venstre';

  @override
  String get privacyPolicy => 'Personvernregler';

  @override
  String get privacyPolicy_Detail_1 =>
      'Vennligst les nøye og sørg for at du forstår og er enig i dette ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Hvis du ikke godtar disse retningslinjene, ikke bruk denne appen. Å bruke appen innebærer at du godtar disse vilkårene.';

  @override
  String get and => ' og ';

  @override
  String get accept => 'Aksepterer';

  @override
  String get takeBack => 'Ta tilbake';

  @override
  String get takingBack => 'Tar tilbake…';

  @override
  String get waiting => 'Venter…';

  @override
  String get stepForward => 'Skritt fremover';

  @override
  String get takeBackAll => 'Ta tilbake alt';

  @override
  String get stepForwardAll => 'Gå fremover alle';

  @override
  String get moveNow => 'Flytt deg nå';

  @override
  String get done => 'Ferdig.';

  @override
  String get crackMill => 'Sprekkvern';

  @override
  String get crackMill_Detail =>
      'Hvis en spiller bare har brikker i møller, vil ikke brikkene i møllene låses for å fjerne.';

  @override
  String get animationDuration => 'Animasjonens varighet';

  @override
  String get none => 'Ingen';

  @override
  String get theme => 'Tema';

  @override
  String get helpContent =>
      'Spillet tar sikte på å gi motstanderen færre enn tre brikker eller ingen lovlige grep.\n\nSpillet trekker automatisk hvis en posisjon oppstår for tredje gang eller ikke fjerner de siste 100 (konfigurerbare) trekkene.\n\nSpillet fortsetter i tre faser:\n\n1. Plasser brikker på ledige punkter\n2. Flytte brikker til tilstøtende punkter\n3. (valgfri fase) Flytter brikker til et ledig punkt når du reduserer spilleren til tre brikker\n\nPlassering\n\nSpillet begynner med et tomt brett, som består av et rutenett med tjuefire poeng. Spillere bytter på å plassere brikkene sine på ledige poeng til hver spiller har plassert alle brikkene på brettet. Hvis en spiller kan sette tre av brikkene sine rett, har han en \"mølle\" og kan fjerne en av motstanderens brikker fra brettet.\n\nI noen regler må spillerne fjerne andre stykker først før de fjerner et stykke fra en dannet mølle.\n\nDu kan ikke plassere brikkene til punktene til fjernede brikker igjen i plasseringsfasen i noen regler.\n\nNår alle brikkene er brukt, bytter spillerne på å bevege seg.\n\nFlytter\n\nFor å flytte, flytter en spiller en av brikkene sine langs en brettelinje til et ledig tilstøtende punkt. Hvis han ikke kan gjøre det, har han tapt spillet. En spiller som justerer tre av brikkene sine på en brettlinje, har en mølle og kan fjerne en av motstanderens brikker som i plasseringsfasen. Enhver spiller reduserer til to stykker, har ingen mulighet til å danne nye møller og taper dermed spillet. En spiller kan også tape når mer enn tre brikker hvis motstanderen blokkerer dem fra å bevege seg.\n\nFlyr\n\nI noen varianter av reglene, når en spiller bare har tre brikker igjen, kan brikkene hans fly, hoppe eller hoppe til ledige punkter, ikke bare tilstøtende.';

  @override
  String get versionInfo => 'Versjonsinfo';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Tillatelse';

  @override
  String get sourceCode => 'Kildekode';

  @override
  String get appVersion => 'Appversjon';

  @override
  String get general => 'Generell';

  @override
  String get advanced => 'Avansert';

  @override
  String get placing => 'Plassering';

  @override
  String get moving => 'Flytter';

  @override
  String get removing => 'Fjerner';

  @override
  String get gameOverCondition => 'Game over tilstand';

  @override
  String get aisPlayStyle => 'AIs spillestil';

  @override
  String get passive => 'Passiv';

  @override
  String get timeout => 'Pause';

  @override
  String get appearance => 'Utseende';

  @override
  String get drawOnHumanExperience => 'Tegn på den menneskelige opplevelsen';

  @override
  String get considerMobility => 'Vurder mobilitet av stykker';

  @override
  String get pieceCount => 'Antall stykker:';

  @override
  String inHand(Object player, int count) {
    return '$player i hånden: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player om bord: $count';
  }

  @override
  String get boardTop => 'Styret forskjøvet fra toppen';

  @override
  String get notAIsTurn => 'Det er ikke AIs tur.';

  @override
  String get aiIsNotThinking => 'AI tenker ikke.';

  @override
  String get atEnd => 'Du er på slutten av trekklisten.';

  @override
  String get tapBackAgainToLeave => 'Trykk tilbake for å dra.';

  @override
  String get more => 'Mer';

  @override
  String get experimental => 'Det er en eksperimentell funksjon.';

  @override
  String get experiments => 'Eksperimenter';

  @override
  String get ossLicenses => 'Åpen kildekode lisenser';

  @override
  String get language => 'Språk';

  @override
  String get defaultLanguage => 'Standard språk';

  @override
  String get mayMoveInPlacingPhase =>
      'Brikkene kan bevege seg i plasseringsfasen';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Det er ingen distinkte plasserings- og flyttingsfaser, dvs. spillerne kan bestemme ved hvert trekk om de vil plassere et stykke på brettet eller flytte et av brikkene sine (så lenge de har gjenværende brikker å plassere).';

  @override
  String get drawerColor => 'Menyfarge';

  @override
  String get drawerTextColor => 'Menyens tekstfarge';

  @override
  String get drawerHighlightItemColor => 'Menyhøydepunktfarge';

  @override
  String get mainToolbarBackgroundColor => 'Hovedverktøylinjens bakgrunnsfarge';

  @override
  String get mainToolbarIconColor => 'Hovedverktøylinjens ikonfarge';

  @override
  String get navigationToolbarBackgroundColor =>
      'Navigasjonsverktøylinjens bakgrunnsfarge';

  @override
  String get navigationToolbarIconColor =>
      'Navigasjonsverktøylinjens ikonfarge';

  @override
  String get autoHideToolbar => 'Skjul verktøylinjen automatisk';

  @override
  String get toolbarLocationOnScreen => 'Verktøylinjeplassering på skjermen';

  @override
  String get top => 'Topp';

  @override
  String get bottom => 'Bunn';

  @override
  String get center => 'Senter';

  @override
  String get solidColor => 'Ensfarget';

  @override
  String get picture => 'Bilde';

  @override
  String get chooseYourPicture => 'Velg bildet ditt';

  @override
  String get light => 'Lys';

  @override
  String get dark => 'Mørk';

  @override
  String get themes => 'Temaer';

  @override
  String get currentTheme => 'Aktuelt tema';

  @override
  String get saveTheme => 'Lagre tema';

  @override
  String get showAnalysisGraph => 'Vis analysegraf';

  @override
  String get analysis => 'Analyse';

  @override
  String get saveGame => 'Lagre spillet';

  @override
  String get loadGame => 'Last Spill';

  @override
  String get setupPosition => 'Oppsettposisjon';

  @override
  String get showLegalMoves => 'Vis juridiske grep';

  @override
  String get showLastMove => 'Vis siste trekk';

  @override
  String get showArrows => 'Vis piler';

  @override
  String get pieces => 'Stykker';

  @override
  String get showAnalysis => 'Vis analyse';

  @override
  String get threads => 'Tråder';

  @override
  String get getInvolved => 'Bli involvert';

  @override
  String get helpImproveTranslate => 'Hjelp med å forbedre oversettelsen';

  @override
  String get tutorial => 'Opplæringen';

  @override
  String get classicMill => 'Klassisk mølle';

  @override
  String get mixedMill => 'Blandet Mill';

  @override
  String get ceylonMill => 'Ceylon Mill';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Kvernen kan bli ødelagt og omgjort gjentatte ganger';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Hvis en spiller bryter en mølle for å opprette en ny mølle med en gang, kan en slik spiller flytte en slik brikke tilbake til det opprinnelige krysset i sitt neste trekk hvis den lager en ny mølle.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Spillet trekkes hvis en spiller har tre brikker, og etter ti trekk fjerner ingen av spillerne motstanderens brikker';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Når en spiller er nede i tre brikker, og ingen av spillerne kan fjerne en motstanders brikke innen ti trekk, er spillet uavgjort.';

  @override
  String get close => 'Lukk';

  @override
  String get whitePiece => 'Hvitt stykke';

  @override
  String get blackPiece => 'Svart stykke';

  @override
  String get emptyPoint => 'Tomt poeng';

  @override
  String get noPoint => 'Ikke noe poeng';

  @override
  String get placingPhase => 'Plasseringsfase';

  @override
  String get movingPhase => 'Flyttende fase';

  @override
  String get flyingPhase => 'Flygende fase';

  @override
  String sideToMove(Object player) {
    return 'Side å flytte: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Siste trekk: $move';
  }

  @override
  String get selected => 'Valgt';

  @override
  String get accessibility => 'tilgjengelighet';

  @override
  String get screenReaderSupport => 'Støtte for skjermleser';

  @override
  String get isDraw => 'Det er uavgjort!';

  @override
  String get draw => 'Tegne';

  @override
  String get pieceHighlightColor => 'Farge på høydepunktet';

  @override
  String get algorithm => 'Algoritme';

  @override
  String get endgameNMoveRule => 'Sluttspill N-Move-regel';

  @override
  String get endgameNMoveRule_Detail =>
      'Hvis en av spillerne bare har tre brikker og ingen av spillerne fjerner en brikke innenfor et bestemt trekk, trekkes spillet.';

  @override
  String get drawReasonEndgameRule50 =>
      'Hver spiller har bare tre brikker, og ingen av spillerne fjerner en brikke innenfor et bestemt trekk.';

  @override
  String get threefoldRepetitionRule => 'Tredobbelt gjentagelsesregel';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Spillet trekkes hvis en posisjon oppstår for tredje gang.';

  @override
  String get continueToMakeMove => 'Mølle! Fortsett å gjøre et trekk.';

  @override
  String get pointStyle => 'Poengstil';

  @override
  String get pointWidth => 'Punktbredde';

  @override
  String get solid => 'Fast';

  @override
  String get hollow => 'Hul';

  @override
  String get languageName => 'Norsk bokmål';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count trekk',
      one: '$count trekk',
      zero: 'trekk',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Lasten mislyktes.';

  @override
  String get filename => 'Filnavn';

  @override
  String get browse => 'Bla gjennom…';

  @override
  String get gameFiles => 'Spillfiler';

  @override
  String get gameSavedTo => 'Spillet er lagret til';

  @override
  String get empty => 'Tømme';

  @override
  String get noMove => 'Ingen bevegelse.';

  @override
  String get restoredPosition => 'Gjenopprettet utgangsposisjon.';

  @override
  String get clean => 'Ren';

  @override
  String get cleanedUp => 'Ryddet opp.';

  @override
  String get remove => 'Fjerne';

  @override
  String get noPiecesCanBeRemoved => 'Ingen biter kan fjernes.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pieces',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 må fjernes.';
  }

  @override
  String placedCount(int count) {
    return 'Plassert ($count)';
  }

  @override
  String get placedPieceCount => 'Plassert stykktelling i plasseringsfasen.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Den nåværende spilleren har plassert $count brikker.';
  }

  @override
  String get notPlacingPhase => 'Ikke plassere fase, kan ikke endre den.';

  @override
  String get paste => 'Lim inn';

  @override
  String get pasteDone => 'Pastaen er ferdig.';

  @override
  String get cannotPaste => 'Kan ikke lime inn.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Vis uplasserte og fjernede brikker';

  @override
  String get fullScreen => 'Full skjerm';

  @override
  String get reopenToTakeEffect =>
      'Avslutt og åpne appen på nytt for at innstillingene skal tre i kraft.';

  @override
  String get forest => 'skog';

  @override
  String get desktopImage => 'Skrivebordsbilde';

  @override
  String get invalidPosition => 'Ugyldig stilling.';

  @override
  String get shareGIF => 'Del GIF';

  @override
  String get pixelRatio => 'Pikselforhold';

  @override
  String get duration => 'Varighet';

  @override
  String get gameScreenRecorder => 'Spillskjermopptaker';

  @override
  String get previous => 'Tidligere';

  @override
  String get next => 'Neste';

  @override
  String get skip => 'Hopp over';

  @override
  String get gotIt => 'Har det';

  @override
  String get youCanModifyRules =>
      'Du kan endre spillereglene i regelinnstillingene.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Du kan bruke musehjulet til å endre verdien i velgeren.';

  @override
  String get noTimeLimitForThinking =>
      'AI Tenketid satt til 0 betyr at det ikke er noen tidsbegrensning for å tenke.';

  @override
  String get whatIsMtdf =>
      'MTD(f) er en modifisert form av alfa-beta-søkealgoritmen som har som mål å forbedre effektiviteten ved å gjenbruke mellomliggende søkeresultater og bruke en god innledende gjetning for å begrense søkeområdet.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Vær oppmerksom på at AI-tenkningstidsjusteringen kanskje ikke er helt presis. Den faktiske tenketiden kan være kortere når vanskelighetsgraden er satt til en lavere verdi og kan være lengre når AI-en er midt i tanken når tiden renner ut.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Hvis du setter vanskelighetsnivået høyt, men ikke øker AI-tenketiden, kan det faktiske vanskelighetsnivået begrenses til en lavere verdi på grunn av tenketidsbegrensningen. Den faktiske verdien kan variere basert på maskinens ytelse.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) er en søkealgoritme for å finne det beste trekket i en gitt posisjon. Det er en forbedring av alfa-beta-algoritmen og bruker null- eller null-vindusøk for å bekrefte at et trekk er dårligere eller ikke dårligere enn en allerede sikker poengsum fra hovedvarianten. PVS fokuserer på de mest lovende trekkene og unngår unødvendige søk etter suboptimale grener, noe som bidrar til å forbedre søkets effektivitet.';

  @override
  String get whatIsAlphaBeta =>
      'Alfa-beta-algoritmen er en søkealgoritme for å finne det beste trekket. Den bruker minimax-prinsippet og to verdier, alfa og beta, for å beskjære søketreet og øke effektiviteten. Alfa representerer den minste poengsummen datamaskinen er sikker på at den kan få, mens beta representerer den maksimale poengsummen motstanderen kan få. Algoritmen hjelper datamaskinen med å ta smarte, effektive avgjørelser i et spill.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Ifølge menneskelig erfaring, hvis du prøver å vinne, vil du tape. Sikt i stedet på uavgjort som mål og unngå å tape spillet. Observer motstanderen din og lok dem forsiktig inn i en posisjon der de kan gjøre feil. Når de viser svakhet, grip muligheten og press forsiktig for å vinne. På denne måten kan du vinne spillet.';

  @override
  String get firstMoveDetail =>
      'I dette spillet er det lettere for den andre spilleren å vinne sammenlignet med den første spilleren.';

  @override
  String get passiveDetail =>
      'Aktivering av det passive alternativet vil få AI til å slappe av når den har en fordel i posisjonen, i stedet for aggressivt å prøve å vinne så raskt som mulig.';

  @override
  String get moveRandomlyDetail =>
      'Aktivering av dette alternativet øker tilfeldigheten og moroa i spillet, mens deaktivering kan hjelpe med å studere måter å slå AI.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Hvis AI vurderer mobiliteten til brikkene sine, vil den ikke bare ta sikte på å fange motstanderens brikker så raskt som mulig, men også vurdere å blokkere motstanderens bevegelser og hindre dem i å gjøre det samme.';

  @override
  String get whenBoardIsFull => 'Når brettet er fullt';

  @override
  String get whenBoardIsFull_Detail =>
      'På slutten av plasseringsfasen, før flyttefasen begynner, følger handlingen hvis brettet er fullt av brikker.';

  @override
  String get sideToMoveRemovePiece =>
      'Spilleren som flytter først i flyttefasen fjerner en av motstanderens brikker.';

  @override
  String get agreeToDraw => 'Begge sider er enige om uavgjort.';

  @override
  String get takeOpponentsPiece => 'Ta en av motstanderens brikker.';

  @override
  String get firstPlayerLose => 'Den første spilleren taper spillet.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Den første og andre spilleren fjerner en av motstanderens brikker.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Den andre og første spilleren fjerner en av motstanderens brikker.';

  @override
  String get enteredFlyingPhase =>
      'Nå inn i flyfasen, kan motstanderens brikker hoppe til et hvilket som helst tomt punkt på brettet. Du kan slå av flyregelen i \"Regelinnstillinger\".';

  @override
  String get whenStalemate => 'Når det står fast';

  @override
  String get whenStalemate_Detail =>
      'Hvilken handling følger når ingen brikker kan flyttes?';

  @override
  String get endWithStalemateLoss => 'Avslutt med et dødsulykketap.';

  @override
  String get changeSideToMove => 'Bytt side for å flytte.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Fjern en av motstanderens brikker og gjør neste trekk.';

  @override
  String get endWithStalemateDraw => 'Avslutt med uavgjort uavgjort.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Fjern en av motstanderens brikker og bytt side for å flytte.';

  @override
  String get aiResponseDelayTime => 'AI-responsforsinkelsestid';

  @override
  String get aiIsDelaying =>
      'AI er for tiden i en forsinket responsfase. Vennligst vent en stund før du fortsetter.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Du kan ikke fjerne en ikke-tilstøtende del.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Hvis det går i stå, kan motstanderens brikker ved siden av din fjernes, uavhengig av mølleformasjonen.';

  @override
  String get whatIsMcts =>
      'MCTS er en nybegynnervennlig algoritme som tar beslutninger ved å utforske og evaluere forskjellige bevegelser gjennom simuleringer.';

  @override
  String get goldenJade => 'Golden Jade';

  @override
  String get forestWood => 'Forest Wood';

  @override
  String get darkMystery => 'Dark Mystery';

  @override
  String get midnightBlue => 'Midnatt blå';

  @override
  String get greenForest => 'Grønn skog';

  @override
  String get greenMeadow => 'Grønn Eng';

  @override
  String get stonyPath => 'Steinete sti';

  @override
  String get pastelPink => 'Pastell rosa';

  @override
  String get turquoiseSea => 'Turkis hav';

  @override
  String get violetDream => 'Fiolett drøm';

  @override
  String get mintChocolate => 'Muntsjokolade';

  @override
  String get skyBlue => 'Himmelblå';

  @override
  String get playfulGarden => 'Leken hage';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Algoritmen for retrograd analyse bruker retrograd analyse med flere verdier for å bygge en sluttspilldatabase fra forskjellige startposisjoner, og bruker deretter denne databasen for å optimalisere spillingen. Denne tilnærmingen faller inn under kategorien Ultra-Strong-løsninger.';

  @override
  String get viewAlgorithmGuide =>
      'Vil du se brukerveiledningen for denne algoritmen?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Vis indikator for posisjonsfordel';

  @override
  String get usePerfectDatabase => 'Benytt deg av den perfekte databasen';

  @override
  String get perfectDatabaseDescription =>
      'Aktiver dette alternativet for å bruke en feilfri spilldatabase generert gjennom avanserte algoritmer. Denne funksjonen integrerer både åpnings- og sluttfasestrategier for å foreslå optimale trekk. Dette er det foretrukne valget for spillere som søker det høyeste nivået av presisjon i spillet. Databasen er skapt gjennom nitidige beregningsteknikker, og er designet for å tilby nesten perfekte spillløsninger.\n\nMerk: Hvis AI-en ikke får tilgang til databasen, vil den gå over til konvensjonelle algoritmer for spillbeslutninger. Når databasen er tilgjengelig, blir \'Vanskelighetsgrad\' praktisk talt uslåelig, og \'AI Tenketid\' reduseres drastisk. Mange innstillinger innen \'AIs Spillestil\'-alternativene vil bli overstyrt, ettersom databasens resultater har høyest prioritet.\n\nFor veiledning om hvordan du får mest mulig ut av denne feilfrie databasen, klikk her.';

  @override
  String get backgroundImage => 'Bakgrunnsbilde';

  @override
  String get whatIsRandom =>
      'Når \'Bruk perfekt database\'-alternativet ikke er aktivert, fører \'Tilfeldig\'-innstillingen til at AI flytter brikker tilfeldig uten å bruke noen algoritmer for trekkvalg. Dette resulterer vanligvis i betydelig svakere spill. På den annen side, når \'Bruk perfekt database\' er aktivert, stoler AI utelukkende på \'Perfekt Database\' for å ta beslutninger, i stedet for å blande den med tradisjonelle AI-algoritmer. I denne modusen er AI\'s trekk helt basert på databasens innhold, og unngår avhengighet av sanntidsberegninger eller søkealgoritmer.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Fjern motstanderens brikke(r) fra hånden deres; så er det motstanderens tur å plassere.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Når du danner møller under plasseringsfasen';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Fjern motstanderens brikke(r) fra brettet.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Fjern motstanderens brikke(r) fra brettet; så er det motstanderens tur å plassere.';

  @override
  String get opponentRemovesOwnPiece =>
      'Motstanderen fjerner sine egne brikker fra brettet.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'I stedet for at du tar grep, velger og fjerner motstanderen sin egen brikke(r) fra brettet, og tar effektivt en handling som er skadelig for dem selv.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Fjern motstanderens brikke(r) fra hånden deres; så er det din tur å flytte.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Fjern brikke(r) fra motstanderens hånd. Hvis flere brikker skal fjernes i henhold til innstillingen for flerfjerning, og motstanderen ikke har flere brikker i hånden, fortsetter du å fjerne motstanderens brikker fra brettet. Så er det din tur å flytte. Hvis du fortsetter å danne møller, kan du fortsette å fjerne motstanderens brikker.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Fjern brikke(r) fra motstanderens hånd. Hvis flere brikker skal fjernes i henhold til innstillingen for flerfjerning, og motstanderen ikke har flere brikker igjen på hånden, fortsetter du å fjerne motstanderens brikker fra brettet. Så er det motstanderens tur å flytte.';

  @override
  String get markAndDelayRemovingPieces =>
      'Merk og forsink fjerning av brikker.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'I løpet av plasseringsfasen merkes brikkene som skal fjernes, og ingen av spillerne kan plassere nye brikker på disse punktene. Når du går inn i flyttefasen, fjernes disse merkede brikkene helt, og spillere kan deretter flytte brikkene sine til disse nå tomme punktene.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Handlingene som kan tas når møller dannes under plasseringsfasen.';

  @override
  String get marked => 'Merket';

  @override
  String get menu => 'Meny';

  @override
  String get monochrome => 'Monokrom';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Du kan aktivere støtte for skjermleser i tilgjengelighetsinnstillingene under Generelle innstillinger.';

  @override
  String get showNumbersOnPieces => 'Vis numre på brikkene';

  @override
  String get saveImage => 'Lagre bilde';

  @override
  String get isAnalysisToolbarShown => 'Vis analyseverktøylinjen';

  @override
  String get analysisToolbarBackgroundColor =>
      'Bakgrunnsfarge for analyseverktøylinjen';

  @override
  String get analysisToolbarIconColor => 'Ikonfarge for analyseverktøylinjen';

  @override
  String get transformed => 'Transformert.';

  @override
  String get cannotTransform => 'Kan ikke transformere.';

  @override
  String get rotate => 'Roter';

  @override
  String get horizontalFlip => 'H. Snu';

  @override
  String get verticalFlip => 'V. Snu';

  @override
  String get innerOuterFlip => 'I/U Snu';

  @override
  String get transparentCanvas => 'Gjennomsiktig Lerret';

  @override
  String get restrictRepeatedMillsFormation =>
      'Begrens gjentatt mølleformasjon';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'En brikke flyttet fra én kvern til en annen kan ikke umiddelbart returnere til det opprinnelige punktet på neste trekk for å danne en kvern igjen. Et annet trekk kreves først.';

  @override
  String get oneTimeUseMill => 'Engangsbruk mølle';

  @override
  String get oneTimeUseMill_Detail =>
      'Hver mølle kan fjerne en motstanders brikke bare én gang. Du kan omforme den igjen, men den kan ikke brukes til ytterligere fjerninger.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'De gjeldende reglene du har satt har ikke en tilsvarende perfekt database. For mer informasjon om den perfekte databasen, klikk her.';

  @override
  String get focusOnBlockingPaths => 'Fokuser på å blokkere veier';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Prioriter å hindre motstanderens bevegelser over å danne møller. I stedet for å fokusere på å fjerne brikker ved å fullføre møller, har AI som mål å fange motstanderen, gjøre dem ute av stand til å bevege seg og sikre en seier gjennom utholdenhet i stedet for aggressivt spill. Denne strategien blokkerer ikke aktivt motstanderens møller.';

  @override
  String get pieceImage => 'Brikkebilde';

  @override
  String get importColorSettings => 'Importer fargeinnstillinger';

  @override
  String get exportColorSettings => 'Eksporter fargeinnstillinger';

  @override
  String get import => 'Importere';

  @override
  String get export => 'Eksportere';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Vennligst kopier JSON-formatinnstillingene til utklippstavlen først.';

  @override
  String get copiedToClipboard => 'Kopiert til utklippstavlen.';

  @override
  String get imported => 'Importert.';

  @override
  String get boardImage => 'Bilde av brett';

  @override
  String get autumnLeaves => 'Høstløv';

  @override
  String get legendaryLand => 'Legendarisk Land';

  @override
  String get vignetteEffect => 'Vignett-effekt';

  @override
  String get promptMakeToolbarTransparent =>
      'Vil du gjøre verktøylinjen helt gjennomsiktig når et bakgrunnsbilde for brettet er satt?';

  @override
  String get vibration => 'Aktiver vibrasjon i spillet';

  @override
  String get soundTheme => 'Lydtema';

  @override
  String get ball => 'Ball';

  @override
  String get liquid => 'Væske';

  @override
  String get wood => 'Tre';

  @override
  String get placeEffectAnimation =>
      'Animasjonseffekt ved plassering av brikke';

  @override
  String get removeEffectAnimation => 'Animasjonseffekt ved fjerning av brikke';

  @override
  String get isToolbarAtBottom => 'Vis verktøylinjen nederst';

  @override
  String get boardCornerRadius => 'Bordhjørneradius';

  @override
  String get useOpeningBook => 'Bruk åpningsbok';

  @override
  String get currentRule => 'Nåværende';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Regelsett';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'La AI bruke åpningsbevegelser som er vanlig brukt av profesjonelle menneskelige spillere i begynnelsen av spillet. Merk: Denne funksjonen er for øyeblikket bare tilgjengelig for spesifikke regelsett.';

  @override
  String get showAdvantageGraph => 'Vis fordelsgraf';

  @override
  String get advantageGraphHint =>
      'Fordelsgrafen tegnes bare etter at KI-en har gjort et trekk. Den vil ikke tegnes når den menneskelige spilleren gjør et trekk.';

  @override
  String get removalBasedOnMillCounts =>
      'Deaktiver fjerning til alle brikker er plassert. Spillerne fjerner brikker basert på antall møller de lager.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Deaktiver fjerning til alle brikker er plassert. Spillerne fjerner brikker basert på antall møller: hvis det er likt, fjerner begge samme antall brikker; hvis en har flere, fjerner vedkommende én ekstra brikke og opprettholder én brikkes forskjell. Hvis bare én danner en mølle, fjerner denne spilleren to brikker, mens den andre fjerner én. Hvis ingen danner en mølle, fjerner begge én brikke.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Velg en av dine brikker.';

  @override
  String get notYourTurn => 'Det er ikke din tur.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Bakgrunnsfarge for annotasjonsverktøylinje';

  @override
  String get annotationToolbarIconColor =>
      'Farge på ikoner i annotasjonsverktøylinjen';

  @override
  String get isAnnotationToolbarShown => 'Vis annotasjonsverktøylinje';

  @override
  String get enterAnnotationMode => 'Gå inn i annotasjonsmodus';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Er du sikker på at du vil slette alle annotasjoner?';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM-oppfordring kopiert til utklippstavlen.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Forbindelsen avvist, serveren kan være nede.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Søk vellykket, venter på tilkobling...';

  @override
  String get noLanConnection => 'Ingen LAN-tilkobling';

  @override
  String get takeScreenshot => 'Ta skjermbilde';

  @override
  String get disconnectedFromOpponent => 'Koblet fra motstanderen.';

  @override
  String get takeBackRequest => 'Forespørsel om å angre trekk';

  @override
  String get nothingToShow => 'Ingenting å vise.';

  @override
  String get stopHosting => 'Stopp hosting';

  @override
  String get connectionResetByPeer =>
      'Forbindelsen ble nullstilt av motparten.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Forbindelsen mistet på grunn av hjertebank-tidsavbrudd. Vennligst koble til på nytt.';

  @override
  String get startHosting => 'Start hosting';

  @override
  String get restartRequestRejected => 'Forespørsel om omstart ble avvist.';

  @override
  String get notConnectedToLanOpponent => 'Ikke tilkoblet LAN-motstander.';

  @override
  String get llmPrompt => 'LLM-oppfordring';

  @override
  String get gameRestarted => 'Spillet startet på nytt.';

  @override
  String get takeBackRejected => 'Angre trekk ble avvist.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Er du sikker på at du vil trekke deg fra dette spillet?';

  @override
  String get opponentResignedYouWin => 'Motstanderen trakk seg. Du vinner!';

  @override
  String get clearAllAnnotations => 'Fjern alle annotasjoner';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Tilkoblet, venter på motstanderens trekk...';

  @override
  String get networkStatusDisconnected => 'Nettverksstatus: Frakoblet';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Forespørsel om å angre trekk sendt til motstanderen.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Motstanderen kan ha forlatt spillet';

  @override
  String get connectedToHostSuccessfully => 'Tilkoblet til verten med suksess.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Forbindelsen mistet: hjertebank-tidsavbrudd';

  @override
  String get noHostDiscovered => 'Ingen vert oppdaget.';

  @override
  String get confirmResignation => 'Bekreft oppgivelse';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Starter hosting, venter på at spillere skal bli med...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Forbindelsen tidsavbrutt, nettverkstilkoblingen er ustabil.';

  @override
  String get noLlmPromptAvailable => 'Ingen LLM-oppfordring tilgjengelig.';

  @override
  String get youResignedGameOver => 'Du trakk deg. Spillet er over.';

  @override
  String get serverIp => 'Server-IP';

  @override
  String get confirmClear => 'Bekreft sletting';

  @override
  String get opponentSTurn => 'Motstanderens tur.';

  @override
  String get waitingAClientConnection => 'Venter på klienttilkobling...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Forespørsel om å angre trekk ble avvist eller mislyktes.';

  @override
  String get addText => 'Legg til tekst';

  @override
  String get exitAnnotationMode => 'Avslutt annotasjonsmodus';

  @override
  String get typeYourAnnotation => 'Skriv inn din annotasjon';

  @override
  String get attemptingToReconnect => 'Forsøker å koble til på nytt...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Omstartforespørsel sendt. Venter på motstanderens svar...';

  @override
  String get serverIsStopped => 'Serveren er stoppet.';

  @override
  String get restartRequest => 'Omstartforespørsel';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Kan ikke be om å angre trekk når det ikke er din tur.';

  @override
  String get takeBackAccepted => 'Angre trekk akseptert.';

  @override
  String get localNetworkSettings => 'Lokal nettverksinnstillinger';

  @override
  String get reconnectedSuccessfully => 'Koblet til på nytt med suksess!';

  @override
  String get failedToSaveImageToGallery =>
      'Kunne ikke lagre bildet i galleriet.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Motstanderen ba om å starte spillet på nytt. Godtar du det?';

  @override
  String get yourTurn => 'Din tur.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Kunne ikke koble til på nytt, vennligst start spillet på nytt.';

  @override
  String get host => 'Vert';

  @override
  String get join => 'Bli med';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'Ugyldig IP-adresse.';

  @override
  String get invalidPort => 'Ugyldig port.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Kobler til: Forsøk $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Kunne ikke koble til: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Kunne ikke starte hosting: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Vert oppdaget: $ip:$port';
  }

  @override
  String get stop => 'Stopp';

  @override
  String get discover => 'Oppdag';

  @override
  String get connect => 'Koble til';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Klient tilkoblet: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Oppdager: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Kobler til på nytt ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Tilkoblet';

  @override
  String get delete => 'Slett';

  @override
  String get ancientEgypt => 'Det gamle Egypt';

  @override
  String get gothicIce => 'Gotisk Is';

  @override
  String get riceField => 'Risåker';

  @override
  String get chinesePorcelain => 'Kinesisk Porselen';

  @override
  String get desertDusk => 'Ørkenskumring';

  @override
  String get precisionCraft => 'Presisjonsarbeid';

  @override
  String get folkEmbroidery => 'Folkebroderi';

  @override
  String get carpathianHeritage => 'Karpatenes Arv';

  @override
  String get imperialGrandeur => 'Keiserlig Prakt';

  @override
  String get bohemianCrystal => 'Bøhmisk Krystall';

  @override
  String get savannaSunrise => 'Savanne Soloppgang';

  @override
  String get harmonyBalance => 'Harmoni og Balanse';

  @override
  String get cinnamonSpice => 'Kanel Krydder';

  @override
  String get anatolianMosaic => 'Anatolsk Mosaikk';

  @override
  String get carnivalSpirit => 'Karnevalsånd';

  @override
  String get custom => 'Tilpasset';

  @override
  String get spiceMarket => 'Kryddermarked';

  @override
  String get swipeToRevealTheDrawer => 'Sveip for å åpne skuffen';

  @override
  String get showGameInfoOnScreenshots =>
      'Vis spillinformasjon på skjermbilder';

  @override
  String get humanMoveTime => 'Menneskelig tidsbegrensning';

  @override
  String get noTimeLimitForHumanMoves =>
      'Ingen tidsbegrensning for menneskelige trekk';

  @override
  String get timeoutLoseWillBeApplied =>
      'Timeout-tap vil bli brukt for menneskelig spiller';

  @override
  String get identifyingBoard => 'Identifiserer spillbrett...';

  @override
  String get youCanEnterAnyModelName =>
      'Du kan angi hvilket som helst modellnavn.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Brettposisjon brukt. FEN kopiert til utklippstavlen.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Forslag: prøv å ta et klarere bilde av spillbrettet.';

  @override
  String get llmPromptTemplate => 'LLM prompt‑mal';

  @override
  String get noValidBoardDetected => 'Ingen gyldig spillbrett registrert.';

  @override
  String get selectingImageFromAlbum => 'Velger bilde fra album...';

  @override
  String get configurePromptTemplate => 'Konfigurer prompt‑mal';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Rediger prompt‑mal for LLM‑analyse';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Kunne ikke generere FEN fra gjenkjent brett.';

  @override
  String get outputInCurrentLanguage => 'Utdata på gjeldende språk';

  @override
  String get commonBaseUrls => 'Vanlige Base URL-er';

  @override
  String get viewCommonModels => 'Vis vanlige modeller';

  @override
  String get recognitionParametersUpdated =>
      'Gjenkjenningsparametere oppdatert.';

  @override
  String get whiteSMove => 'Hvits trekk';

  @override
  String get resetToDefaults => 'Tilbakestill til standard';

  @override
  String get photoShoot => 'Fotografering';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Kunne ikke bruke gjenkjent brettposisjon.';

  @override
  String get llmPromptContent => 'LLM prompt‑innhold';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM ikke konfigurert. Vennligst sjekk innstillingene dine.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Angi leverandør, modell, API Key og Base URL';

  @override
  String get llmConfiguration => 'LLM‑konfigurasjon';

  @override
  String get configureLlmProvider => 'Konfigurer LLM‑leverandør';

  @override
  String get llmPromptTemplateHeader => 'LLM prompt‑mal overskrift';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Ingen brikker gjenkjent i bildet. Prøv igjen.';

  @override
  String get recognizeBoardFromImage => 'Gjenkjenn brett fra bilde';

  @override
  String get viewTips => 'Se tips';

  @override
  String get applyToBoard => 'Bruk på brett';

  @override
  String get adjustBoardArea => 'Juster brettområde';

  @override
  String get viewCommonUrls => 'Vis vanlige URL-er';

  @override
  String get colorAnalysisFailed => 'Fargeanalyse mislyktes!';

  @override
  String get analyzingGameBoardImage => 'Analyserer spillbrett‑bilde...';

  @override
  String get selectFromAlbum => 'Velg fra album';

  @override
  String get noBoardPointDetected => 'Ingen brettpunkt registrert!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Hvis tomt, brukes standardmalen';

  @override
  String get llmConfig => 'LLM‑innstillinger';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Er du sikker på at du vil tilbakestille prompt‑malene til standardverdiene?';

  @override
  String get llmPromptTemplateFooter => 'LLM prompt‑mal bunntekst';

  @override
  String get loadingResponse => 'Laster respons...';

  @override
  String get applyThisResultToBoard => 'Bruk dette resultatet på brett';

  @override
  String get takingPicture => 'Tar bilde...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Velg et spillbrett‑bilde for gjenkjenning';

  @override
  String get identificationResults => 'Gjenkjenningsresultater';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analyser trekkene og gi innsikt.';

  @override
  String get getApiKey => 'Hent API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Hele gjenkjenningsprosessen kunne ikke fullføres.';

  @override
  String get boardRecognitionResult => 'Brettgjenkjenningsresultat';

  @override
  String get askLlm => 'Spør LLM';

  @override
  String get boardDetectionFailed => 'Brettgjenkjenning mislyktes!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Ingen brettpunkt registrert, kan ikke identifisere brikke!';

  @override
  String get copyFen => 'Kopier FEN';

  @override
  String get commonlyUsedModels => 'Vanlig brukte modeller';

  @override
  String get apiKeyOptional => 'API Key (valgfritt)';

  @override
  String get noImageSelected => 'Ingen bilde valgt';

  @override
  String get blackSMove => 'Svarts trekk';

  @override
  String get llm => 'Stort språkmodell';

  @override
  String get llmProvider => 'Leverandør';

  @override
  String get baseUrl => 'Basis-URL';

  @override
  String get model => 'Modell';

  @override
  String get temperature => 'Temperatur';

  @override
  String get llmCommandReceivedProcessing =>
      'Kommando mottatt! KI behandler...';

  @override
  String get llmDeepThinkingWait => 'Dyp tenking pågår, vennligst vent...';

  @override
  String get llmPresentingSoon => 'Presenteres snart...';

  @override
  String get recognitionParameters => 'Gjenkjenningsparametere';

  @override
  String get adjustParamsDesc =>
      'Juster parametere for å forbedre gjenkjenningsnøyaktighet';

  @override
  String get saveParameters => 'Lagre parametere';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Kan ikke starte bildegjenkjenning: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Bildegjenkjenning mislyktes: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Posisjon med $whiteCount hvite og $blackCount svarte brikker brukt';
  }

  @override
  String get fenCopiedToClipboard => '(FEN kopiert til utklippstavlen)';

  @override
  String recognitionFailed(String error) {
    return 'Gjenkjenning mislyktes: $error';
  }

  @override
  String get myRating => 'Min vurdering';

  @override
  String get gamesPlayed => 'Spilte spill';

  @override
  String get wins => 'Seire';

  @override
  String get losses => 'Tap';

  @override
  String get draws => 'Uavgjort';

  @override
  String get lastUpdated => 'Sist oppdatert';

  @override
  String get format => 'Format:';

  @override
  String get resetStatistics => 'Tilbakestill statistikk';

  @override
  String get drawRate => 'Uavgjortrate';

  @override
  String get lossRate => 'Tapsrate';

  @override
  String get aiStatistics => 'AI-statistikk';

  @override
  String get enableStatistics => 'Aktiver statistikk';

  @override
  String get enableStatistics_Detail =>
      'Når aktivert, vil spillresultater bli registrert i statistikken. Spill som involverer tilbaketrekking av trekk vil imidlertid ikke bli registrert. Når deaktivert, pauses statistikkinnhentingen.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Dette vil tilbakestille all spillstatistikk. Denne handlingen kan ikke angres.';

  @override
  String get boardInnerRingSize => 'Størrelse på den indre ringen på brettet';

  @override
  String get boardShadowEnabled => 'Brettskygge';

  @override
  String get trapAwareness => 'Felledeteksjon';

  @override
  String get trapAwarenessDescription =>
      'Fremhev felle-trekk med fete sirkler og piler under analysen.';

  @override
  String trapExists(String trapMoves) {
    return 'Det finnes en felle. Felle-trekk: $trapMoves';
  }

  @override
  String get custodianCapture => 'Flankerende fangst';

  @override
  String get custodianCaptureDescription =>
      'Lukk en av motstanderens brikker mellom to av deg i en rett linje for å fange den.';

  @override
  String get custodianCaptureEnable => 'Tillat flankerende fangst';

  @override
  String get interventionCapture => 'Intervensjonsfangst';

  @override
  String get interventionCaptureDescription =>
      'Gå inn i det tomme punktet mellom to av motstanderens stykker for å fange dem begge.';

  @override
  String get interventionCaptureEnable => 'Tillat intervensjonsfangst';

  @override
  String get leapCapture => 'Hoppfangst';

  @override
  String get leapCaptureDescription =>
      'Fangst ved å hoppe over en tilstøtende motstanders stykke inn i det tomme punktet utenfor.';

  @override
  String get leapCaptureEnable => 'Tillat hoppfangst';

  @override
  String get captureApplicableLines => 'Gjeldende linjer';

  @override
  String get captureSquareEdges => 'Langs kvadratets kanter';

  @override
  String get captureCrossLines => 'Langs ortogonale linjer som krysser torget';

  @override
  String get captureDiagonalLines =>
      'Langs diagonale linjer som krysser torget';

  @override
  String get captureExecutionPhases => 'Utførelsesfaser';

  @override
  String get capturePiecesCondition =>
      'Tilgjengelighet i bevegelsesfasen basert på gjenværende brikker';

  @override
  String get capturePiecesConditionUnlimited => 'Ingen begrensninger';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Tilgjengelig når du har tre eller færre stykker';
}
