// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Burmese (`my`).
class SMy extends S {
  SMy([String locale = 'my']) : super(locale);

  @override
  String get appName => 'ကြိတ်';

  @override
  String get welcome => 'ကြိုဆိုပါတယ်';

  @override
  String get yes => 'ဟုတ်ကဲ့';

  @override
  String get no => 'မရှိ';

  @override
  String get game => 'ဂိမ်း';

  @override
  String get humanVsAi => 'လူသား Vs. AI';

  @override
  String get humanVsHuman => 'လူသား Vs. လူသား';

  @override
  String get aiVsAi => 'AI Vs. AI';

  @override
  String get humanVsCloud => 'လူသား Vs. မိုးတိမ်';

  @override
  String get humanVsLAN => 'လူသား Vs. LAN';

  @override
  String get testViaLAN => 'LAN မှတဆင့်စမ်းသပ်ပါ';

  @override
  String get move => 'ရွှေ့ပါ။';

  @override
  String get showMoveList => 'စာရင်းကို ရွှေ့ပါ';

  @override
  String get moveList => 'စာရင်းကို ရွှေ့ပါ';

  @override
  String get noGameRecord => 'မှတ်တမ်းမရှိပါ';

  @override
  String get ok => 'အိုကေ';

  @override
  String get confirm => 'အတည်ပြုပါ';

  @override
  String get cancel => 'မလုပ်တော့';

  @override
  String get tipSelectWrong => 'မှားသောအပိုင်းကို ရွေးပါ။';

  @override
  String get tipPlace => 'သင့်အပိုင်းအစများကို နေရာချပါ။';

  @override
  String get tipBanPlace => 'သင့်ကို ဒီနေရာမှာ ထားမရပါ။';

  @override
  String get tipPlaced => 'မင်းထားလိုက်တယ်။';

  @override
  String get tipRemove => 'အပိုင်းတစ်ခုကို ဖယ်ရှားပါ။';

  @override
  String get tipBanRemove => '၎င်းကိုသင်ဖယ်ရှား၍မရပါ။';

  @override
  String get tipRemoved => 'မင်းဖယ်လိုက်။';

  @override
  String get tipMove => 'အပိုင်းတစ်ခုကို ရွှေ့ပါ။';

  @override
  String get tipCannotPlace => 'သင့်ကို ဒီနေရာမှာ သင့်ပစ္စည်းကို ထားမရပါ။';

  @override
  String get tipCannotMove => 'သင့်အပိုင်းကို ဤနေရာတွင် ရွှေ့၍မရပါ။';

  @override
  String get tipMill => 'ကြိတ်! သင်၏ပြိုင်ဘက်၏အပိုင်းကိုယူပါ။';

  @override
  String get tipContinueMill => 'မင်းရဲ့ပြိုင်ဘက်ရဲ့ အပိုင်းကို ဆက်ယူလိုက်ပါ။';

  @override
  String get tipSelectOpponentsPiece =>
      'သင့်ပြိုင်ဘက်၏ အစိတ်အပိုင်းများထဲမှ တစ်ခုကို ရွေးပါ။';

  @override
  String get tipCannotRemovePieceFromMill =>
      'ကြိတ်စက်မှ အပိုင်းအစကို သင်မဖယ်ရှားနိုင်ပါ။';

  @override
  String get tipCanMoveOnePoint => 'အပိုင်းတစ်ခုသည် ၁ မှတ်ကို ရွှေ့နိုင်သည်။';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'သင့်ကို သင့်အနိုင်ယူဆခြင်းရဲ့ ပစ္စည်းများကို ရွေ့မရပါ။';

  @override
  String get tipSelectPieceToMove => 'ရွှေ့ရန် သင့်အပိုင်းကို ရွေးပါ။';

  @override
  String get tipHaveThreePiecesLeft => 'မင်းမှာ သုံးပုဒ်ပဲ ကျန်တော့တယ်။';

  @override
  String get tipCanMoveToAnyPoint => 'ကြိုက်တဲ့နေရာကို ရွှေ့လို့ရပါတယ်။';

  @override
  String tipToMove(Object player) {
    return '$playerကစားသည့်အခါကိုလှမ်းဆန်။';
  }

  @override
  String get whiteWin => 'ကစားသမား ၁ မြင်သွားပြီ!';

  @override
  String get blackWin => 'ကစားသမား ၂ အောင်မြင်သည်!';

  @override
  String get won => 'ဝမ်';

  @override
  String get lost => 'ပျောက်တယ်။';

  @override
  String get thinking => 'စဉ်းစားနေသည်…';

  @override
  String get newGame => 'ဂိမ်းအသစ်';

  @override
  String get importGame => 'သွင်းဂိမ်း';

  @override
  String get exportGame => 'Export ဂိမ်း';

  @override
  String get gameImported => 'ဂိမ်းကို တင်သွင်းခဲ့သည်။';

  @override
  String cannotImport(Object invalidMove) {
    return '$invalidMove ကို မတင်သွင်းနိုင်ပါ';
  }

  @override
  String get movesAndRulesNotMatch =>
      'ရွေ့လျားမှုနှင့် စည်းမျဉ်းများသည် မကိုက်ညီပါ။';

  @override
  String get pleaseWait => 'ကျေးဇူးပြုပြီးခဏစောင့်ပါ။';

  @override
  String get restartGame => 'လက်ရှိဂိမ်းကို ပြန်စမလား။';

  @override
  String get restart => 'ပြန်စတင်သည်';

  @override
  String get gameStarted => 'ဂိမ်းစတင်ခဲ့သည်၊ ကျေးဇူးပြု၍ နေရာယူပါ။';

  @override
  String get analyzing => 'ပိုင်းခြားစိတ်ဖြာနေသည်…';

  @override
  String error(Object message) {
    return 'အမှား- $message';
  }

  @override
  String get winRate => 'အနိုင်ရရှိမှုရာခိုင်နှုန်း';

  @override
  String get score => 'နိုင်ပြီ:';

  @override
  String get white => 'ကစားသမား ၁';

  @override
  String get black => 'ကစားသမား ၂';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player အပိုင်းအရေအတွက်သည် သုံးခုထက်နည်းသည်။';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player နှုတ်ထွက်ခဲ့သည်။';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player သွားစရာလမ်းမရှိ။';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'ဘုတ်အပြည့်ရှိပြီး $player သွားစရာလမ်းမရှိ။';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'အချိန်ကုန်သွားပါပြီ၊ $player ဆုံးရှုံးသွားပါပြီ။';
  }

  @override
  String get drawReasonRule50 =>
      'ရွေ့လျားမှုအဆင့်တွင်၊ နောက်ဆုံးသတ်မှတ်ထားသော ရွေ့လျားမှုအရေအတွက်တွင် မည်သည့်အပိုင်းကိုမျှ ဖယ်ရှားမထားပါ။';

  @override
  String get drawReasonBoardIsFull =>
      'ဘုတ်ပြားပြည့်နေ၍ မဲနှိုက်ခြင်းဖြစ်ပါသည်။';

  @override
  String get drawReasonThreefoldRepetition =>
      'သုံးကြိမ် ထပ်ခါထပ်ခါ ဖြစ်သောကြောင့် သရေဖြစ်သည်။';

  @override
  String get gameOverUnknownReason => 'ပြီးသွားပါပြီ! အမည်မသိအကြောင်းပြချက်။';

  @override
  String get gameOver => 'ပြီးသွားပါပြီ';

  @override
  String get youWin => 'သင့်အောင်မြင်ပါတယ်! ကျေးဇူးတင်ပါတယ်!';

  @override
  String challengeHarderLevel(int level) {
    return 'အကြီးအကြယ်ပိုများသော အဆင့်ကို ဖန်တီးမလား? အသစ်တစ်ခုမှာ အဆင့် $level ဖြစ်ပါလိမ့်မည်!';
  }

  @override
  String get youLose => 'သင်ရှုံးသည်!';

  @override
  String get analyze => 'ခွဲခြမ်းစိတ်ဖြာပါ';

  @override
  String get about => 'အကြောင်း';

  @override
  String version(Object versionNumber) {
    return 'ဗားရှင်း- $versionNumber';
  }

  @override
  String get thanks => 'ကျေးဇူးပါ';

  @override
  String get settings => 'ဆက်တင်များ';

  @override
  String get options => 'ရွေးချယ်';

  @override
  String get generalSettings => 'အထွေထွေဆက်တင်များ';

  @override
  String get skillLevel => 'ခက်ခဲမှုအဆင့်';

  @override
  String get moveTime => 'AI စဉ်းစားချိန်';

  @override
  String get difficulty => 'အခက်အခဲ';

  @override
  String get playSounds => 'အသံသက်ရောက်မှု';

  @override
  String get playSoundsInTheGame => 'ဂိမ်းတွင် အသံများကို ကစားပါ';

  @override
  String get keepMuteWhenTakingBack => 'ပြန်ယူသည့်အခါ အသံတိတ်ထားပါ';

  @override
  String get tone => 'လေသံ';

  @override
  String get whoMovesFirst => 'ပထမဆုံး ရွှေ့ပါ';

  @override
  String get human => 'လူသား';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'တလှည့်စီ';

  @override
  String get isAutoRestart =>
      'ဂိမ်းပြီးသွားသောအခါ ဂိမ်းကို အလိုအလျောက် ပြန်လည်စတင်ပါ';

  @override
  String get isAutoChangeFirstMove =>
      'ပထမအောင်မြင်ခြင်းကိုအလိုအလျောက်ပြောင်းလဲ';

  @override
  String get shufflingEnabled => 'ကျပန်းရွှေ့ပါ';

  @override
  String get misc => 'အဖြာဖြာ';

  @override
  String get rules => 'စည်းကမ်းများ';

  @override
  String get piecesCount => 'ကစားသမားတစ်ဦးစီတွင် အစိတ်အပိုင်းအရေအတွက်';

  @override
  String get piecesCount_Detail => 'ကစားသမားတစ်ဦးစီတွင် အပိုင်းမည်မျှရှိသနည်း။';

  @override
  String get flyPieceCount => 'ပျံသွားသည့် အရေအတွက်';

  @override
  String get flyPieceCount_Detail =>
      'Flying ကို ဖွင့်ထားလျှင် ကစားသမားတစ်ဦးမှ သတ်မှတ်ထားသော အပိုင်းအရေအတွက်သို့ လျှော့ချလိုက်သောအခါ၊ သူမ၏ အပိုင်းများသည် ကျန်ဂိမ်းတွင်ကဲ့သို့ ကပ်လျက်အမှတ်များကို ကန့်သတ်ထားမည့်အစား ၎င်း၏အပိုင်းများကို သိမ်းပိုက်ခြင်းမရှိသော မည်သည့်နေရာသို့မဆို လွတ်လပ်စွာ ရွှေ့ပြောင်းနိုင်သည်။';

  @override
  String get piecesAtLeastCount => 'အနည်းဆုံးအပိုင်းများ';

  @override
  String get hasDiagonalLines => 'ထောင့်ဖြတ်မျဉ်းများ';

  @override
  String get hasDiagonalLines_Detail =>
      'ဘုတ်သို့ ထောင့်ဖြတ်မျဉ်းလေးကြောင်းထည့်ပါ။';

  @override
  String get isDefenderMoveFirst => 'ဒုတိယကစားသမားက အရင်ရွှေ့တယ်';

  @override
  String get isDefenderMoveFirst_Detail =>
      'နေရာယူသည့်အဆင့်တွင် ဒုတိယရွေ့သောကစားသမားသည် ရွေ့လျားသည့်အဆင့်တွင် ပထမရွေ့သည်။';

  @override
  String get mayRemoveMultiple => 'မျိုးစုံကို ဖယ်ရှားပါ';

  @override
  String get mayRemoveMultiple_Detail =>
      'ကစားသမားတစ်ဦးသည် စက်ရုံတစ်ရုံထက်ပို၍ တစ်ပြိုင်နက်ပိတ်ပါက၊ ပိတ်ထားသောစက်အရေအတွက်ကို ဖယ်ရှားမည်ဖြစ်သည်။';

  @override
  String get mayRemoveFromMillsAlways => 'ဆန်စက်များကို ဖျက်ဆီးပါ';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'ပုံမှန်အားဖြင့်၊ ကစားသမားများသည် ဖွဲ့စည်းထားသော ကြိတ်စက်မှ အပိုင်းအစကို မဖယ်ရှားမီ အခြားအပိုင်းများကို ဦးစွာ ဖယ်ရှားရပါမည်။ ကန့်သတ်ချက်ကို ပိတ်ရန် ဤရွေးချယ်မှုကို ဖွင့်ပါ။';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'ဘုတ်အဖွဲ့ပြည့်သောအခါ ဒုတိယကစားသမားသည် ရှုံးသည်';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'နေရာချခြင်းအဆင့်၏အဆုံးတွင် ဘုတ်အဖွဲ့ပြည့်သွားသောအခါတွင် ပထမနေရာက ဂိမ်းကိုရှုံးသည်။ မဟုတ်ရင် ဂိမ်းက သရေပါပဲ။';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'တရားဥပဒေအရ ရွေ့လျားမှုမရှိတဲ့အခါ ရှုံးတယ်';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'ပြိုင်ဘက်က သူတို့ကို မရွှေ့နိုင်အောင် ပိတ်ဆို့ထားရင် ကစားသမားက ရှုံးလိမ့်မယ်။ ဤရွေးချယ်မှုကို ပိတ်ထားပါက ရွှေ့ရန် ဘေးကို ပြောင်းပါ။';

  @override
  String get mayFly => 'ပျံ';

  @override
  String get mayFly_Detail =>
      'ကစားသမားတစ်ဦးတွင် အပိုင်းသုံးပိုင်း သို့မဟုတ် လေးခုသာ ကျန်ရှိတော့မည်ဆိုလျှင် အပိုင်းအစကို အခမဲ့အမှတ်သို့ ရွှေ့နိုင်သည်။';

  @override
  String get nMoveRule => 'N-ရွှေ့စည်းမျဉ်း';

  @override
  String get nMoveRule_Detail =>
      'သတ်မှတ်ထားသော ရွေ့လျားမှုအရေအတွက်တွင် ဖယ်ရှားခြင်းမရှိပါက ဂိမ်းကို ရေးဆွဲထားသည်။';

  @override
  String get rollback => 'နောက်ပြန်လိမ့်သည်';

  @override
  String get pleaseSelect => 'ကျေးဇူးပြု၍ ရွေးချယ်ပါ';

  @override
  String get copy => 'ကော်ပီ';

  @override
  String get moveHistoryCopied =>
      'ကူးယူထားသောမှတ်တမ်းကို ကလစ်ဘုတ်သို့ ရွှေ့ပါ။';

  @override
  String get help => 'ကူညီကြပါ';

  @override
  String get feedback => 'တုံ့ပြန်ချက်';

  @override
  String get exit => 'ထွက်ပေါက်';

  @override
  String get ruleSettings => 'စည်းကမ်းများ';

  @override
  String get color => 'အရောင်';

  @override
  String get boardColor => 'ဘုတ်ရောင်';

  @override
  String get pieceColor => 'အပိုင်းအစအရောင်';

  @override
  String get backgroundColor => 'နောက်ခံအရောင်';

  @override
  String get lineColor => 'ဘုတ်လိုင်းအရောင်';

  @override
  String get whitePieceColor => 'Player 1 piece အရောင်';

  @override
  String get blackPieceColor => 'Player 2 piece အရောင်';

  @override
  String get messageColor => 'မက်ဆေ့ခ်ျအရောင်';

  @override
  String get isPieceCountInHandShown =>
      'နေရာမရှိသောအပိုင်းများ အရေအတွက်ကို ပြပါ';

  @override
  String get isNotationsShown => 'ဘုတ်ပေါ်တွင် အမှတ်အသားများကို ပြပါ';

  @override
  String get isHistoryNavigationToolbarShown =>
      'မှတ်တမ်း လမ်းညွှန်ကိရိယာဘားကို ပြပါ';

  @override
  String get display => 'ပြသခြင်း';

  @override
  String get boardBorderLineWidth => 'ဘုတ်ဘောင်ဘောင်အကျယ်';

  @override
  String get boardInnerLineWidth => 'ဘုတ်အတွင်းစည်းအကျယ်';

  @override
  String get pieceWidth => 'အပိုင်းအကျယ်';

  @override
  String get fontSize => 'ဖောင့်အရွယ်အစား';

  @override
  String get standardNotation => 'WMD အမှတ်အသား';

  @override
  String get restore => 'ပြန်ယူပါ';

  @override
  String get restoreDefaultSettings => 'မူရင်းဆက်တင်များကို ပြန်လည်ရယူပါ';

  @override
  String pick(Object element) {
    return '$element ကို ရွေးပါ';
  }

  @override
  String get info => 'အခ. အလ.';

  @override
  String get hint => 'သဲလွန်စ';

  @override
  String get player => 'ကစားသမား';

  @override
  String get player1 => 'ကစားသမား ၁';

  @override
  String get player2 => 'ကစားသမား ၂';

  @override
  String get howToPlay => 'ကစားနည်း';

  @override
  String get toPlacePiece =>
      'အပိုင်းကို နေရာချရန် ရနိုင်သော မည်သည့်အမှတ်ကို နှိပ်ပါ။';

  @override
  String get toSelectPiece => '၎င်းကိုရွှေ့ရန် အပိုင်းတစ်ခုကို နှိပ်ပါ။';

  @override
  String get toMovePiece =>
      '၎င်းကိုရွှေ့ရန် အပိုင်းတစ်ခုနှင့် ချိတ်ဆက်ထားသော အမှတ်ကို နှိပ်ပါ။';

  @override
  String get toRemovePiece => 'ဖယ်ရှားရန် ပြိုင်ဘက်၏ တစ်ပိုင်းကို နှိပ်ပါ။';

  @override
  String get needToCreateMillFirst =>
      'အပိုင်းတစ်ခုကို မဖယ်ရှားမီ ကြိတ်စက်တစ်ခု ဖန်တီးရန် လိုအပ်ပါသည်။';

  @override
  String get needToPlayWithOwnPieces => 'မင်းရဲ့အပိုင်းတွေနဲ့ ကစားရမယ်။';

  @override
  String get statistics => 'စာရင်းအင်းများ';

  @override
  String get totalGames => 'စုစုပေါင်းဂိမ်းများ';

  @override
  String get results => 'ရလဒ်များ';

  @override
  String get left => 'ဝဲ';

  @override
  String get privacyPolicy => 'ကိုယ်ရေးအချက်အလက်မူဝါဒ';

  @override
  String get privacyPolicy_Detail_1 =>
      'ကျေးဇူးပြု၍ ဂရုတစိုက်ဖတ်ပြီး ဤအချက်ကို သင်အပြည့်အဝနားလည်သဘောတူကြောင်း သေချာပါစေ။ ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. ဤမူဝါဒကို သဘောမတူပါက၊ ဤအက်ပ်ကို မသုံးပါနှင့်။ အက်ပ်ကိုအသုံးပြုခြင်းသည် ဤစည်းကမ်းချက်များကို သင်လက်ခံသည်ဟု ဆိုလိုသည်။';

  @override
  String get and => ' နှင့် ';

  @override
  String get accept => 'လက်ခံပါတယ်';

  @override
  String get takeBack => 'ပြန်ယူပါ';

  @override
  String get takingBack => 'ပြန်ယူနေသည်…';

  @override
  String get waiting => 'စောင့်နေသည်…';

  @override
  String get stepForward => 'ရှေ့သို့လှမ်းပါ';

  @override
  String get takeBackAll => 'အားလုံးကို ပြန်ယူပါ';

  @override
  String get stepForwardAll => 'အားလုံး ရှေ့ကို လှမ်းပါ';

  @override
  String get moveNow => 'ယခုရွှေ့ပါ';

  @override
  String get done => 'ပြီးပြီ။';

  @override
  String get crackMill => 'ကြိတ်ကြိတ်';

  @override
  String get crackMill_Detail =>
      'ကစားသမားတစ်ဦးသည် ကြိတ်စက်များတွင် အပိုင်းအစများသာရှိလျှင် ကြိတ်ခွဲသည့်အပိုင်းများကို ဖယ်ရှားရန် သော့ခတ်မည်မဟုတ်ပါ။';

  @override
  String get animationDuration => 'Animation ကြာချိန်';

  @override
  String get none => 'တစ်ခုမှ';

  @override
  String get theme => 'အပြင်အဆင်';

  @override
  String get helpContent =>
      'ဂိမ်းသည် ပြိုင်ဘက်ကို သုံးပိုင်းထက်နည်းသော သို့မဟုတ် တရားဝင်လှုပ်ရှားမှုမရှိစေရန် ရည်ရွယ်သည်။\n\nဂိမ်းသည် တတိယအကြိမ် အနေအထားတစ်ခု ဖြစ်ပေါ်ပါက သို့မဟုတ် နောက်ဆုံး 100 (configurable) ရွေ့လျားမှုတွင် မဖယ်ရှားပါက အလိုအလျောက်ဆွဲသည်။\n\nဂိမ်းသည် အဆင့်သုံးဆင့်ဖြင့် လုပ်ဆောင်သည်။\n\n1. လစ်လပ်သောနေရာများတွင် အပိုင်းများကို နေရာချပါ။\n2. အပိုင်းများကို ကပ်လျက်နေရာများသို့ ရွှေ့ပါ။\n3. (ရွေးချယ်နိုင်သောအဆင့်) ကစားသမားကို သုံးပိုင်းအထိ လျှော့ချလိုက်သောအခါ လစ်လပ်သည့်နေရာသို့ အပိုင်းများကို ရွှေ့ပါ။\n\nအားမရ\n\nဂိမ်းသည် အမှတ်နှစ်ဆယ့်လေးမှတ်ပါသော ဇယားကွက်အလွတ်တစ်ခုဖြင့် စတင်သည်။ ကစားသမားတစ်ဦးစီသည် ဘုတ်အဖွဲ့ပေါ်တွင် အပိုင်းအားလုံးကို မတင်မချင်း ကစားသမားများ လစ်လပ်နေသော အမှတ်များပေါ်တွင် ၎င်းတို့၏ အပိုင်းများကို အလှည့်ကျ ထားရှိကြသည်။ ကစားသမားတစ်ဦးသည် ၎င်း၏ အပိုင်းသုံးပိုင်းကို ဖြောင့်အောင်ထားနိုင်လျှင် သူ့တွင် \"ကြိတ်\" ရှိပြီး ၎င်း၏ပြိုင်ဘက်၏ အစိတ်အပိုင်းများကို ဘုတ်အဖွဲ့မှ ဖယ်ရှားနိုင်သည်။\n\nအချို့စည်းမျဉ်းများတွင် ကစားသမားများသည် ဖွဲ့စည်းထားသော ကြိတ်စက်မှ အပိုင်းအစများကို မဖယ်ရှားမီ အခြားအပိုင်းများကို ဦးစွာ ဖယ်ရှားရပါမည်။\n\nအချို့သော စည်းမျဉ်းများတွင် ဖယ်ရှားထားသော အပိုင်းများကို နေရာချသည့်အဆင့်တွင် အပိုင်းအစများ အပိုင်းများကို သင် ထား၍မရပါ။\n\nအပိုင်းအားလုံးကို အသုံးပြုပြီးသည်နှင့် ကစားသမားများသည် အလှည့်ကျ လှုပ်ရှားကြသည်။\n\nရွေ့လျား\n\nရွှေ့ရန်၊ ကစားသမားသည် ၎င်း၏ အပိုင်းတစ်ပိုင်းကို ဘုတ်လိုင်းတစ်လျှောက် လစ်လပ်နေသော ကပ်လျက်နေရာသို့ ရွှေ့သည်။ မစွမ်းဆောင်နိုင်ရင် ဂိမ်းရှုံးသွားပါပြီ။ ဘုတ်လိုင်းတစ်ခုပေါ်တွင် သူ၏အပိုင်းသုံးပိုင်းကို ချိန်ညှိပေးသော ကစားသမားသည် ကြိတ်စက်တစ်ခုရှိပြီး နေရာယူသည့်အဆင့်တွင်ကဲ့သို့ ၎င်း၏ပြိုင်ဘက်၏အပိုင်းအစများကို ဖယ်ရှားနိုင်သည်။ မည်သည့်ကစားသမားမဆို အပိုင်းနှစ်ပိုင်းအထိ လျှော့ချသည်၊ ကြိတ်ခွဲရန် ရွေးချယ်ခွင့်မရှိသဖြင့် ဂိမ်းကို ရှုံးသည်။ ကစားသမားတစ်ဦးသည် ၎င်း၏ပြိုင်ဘက်က ၎င်းတို့ကို ရွှေ့ရန် တားမြစ်ပါက သုံးပိုင်းထက်ပိုသည့်အခါတွင်လည်း ဆုံးရှုံးနိုင်သည်။\n\nပျံ\n\nစည်းမျဉ်းအချို့၏မူကွဲများတွင် ကစားသမားတစ်ဦးတွင် အပိုင်းသုံးပိုင်းသာကျန်တော့သည်နှင့် ၎င်း၏အပိုင်းများသည် ပျံသန်းနိုင်၊ ခုန်ကူးနိုင်သည် သို့မဟုတ် ကပ်လျက်နေရာများသာမက လစ်လပ်နေသောနေရာများသို့ ခုန်ဆင်းနိုင်သည်။\n';

  @override
  String get versionInfo => 'ဗားရှင်းအချက်အလက်';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'လိုင်စင်';

  @override
  String get sourceCode => 'အရင်းအမြစ်ကုဒ်';

  @override
  String get appVersion => 'အက်ပ်ဗားရှင်း';

  @override
  String get general => 'အထွေထွေ';

  @override
  String get advanced => 'အဆင့်မြင့်သည';

  @override
  String get placing => 'အားမရ';

  @override
  String get moving => 'ရွေ့လျား';

  @override
  String get removing => 'ဖယ်ရှားခြင်း';

  @override
  String get gameOverCondition => 'ဂိမ်းကျော်အခြေအနေ';

  @override
  String get aisPlayStyle => 'AI ၏ကစားဟန်';

  @override
  String get passive => 'ပိုင်းကန့်သတ်မှု';

  @override
  String get timeout => 'ခဏပွဲရပ်ခြင်း';

  @override
  String get appearance => 'အသွင်အပြင်';

  @override
  String get drawOnHumanExperience => 'လူ့အတွေ့အကြုံကို ဆွဲပါ';

  @override
  String get considerMobility => 'အပိုင်းအစများ ရွေ့လျားမှုကို ဆင်ခြင်ပါ';

  @override
  String get pieceCount => 'ပစ္စည်းအရေအတွက်:';

  @override
  String inHand(Object player, int count) {
    return 'လက်ထဲတွင် $player- $count';
  }

  @override
  String onBoard(Object player, int count) {
    return 'သင်္ဘောပေါ်ရှိ $player- $count';
  }

  @override
  String get boardTop => 'ဘုတ်ပေါ်ကနေ နှိမ်တယ်';

  @override
  String get notAIsTurn => 'အီးအိုင်းအတွက် လှည့်ကြားခြင်းမဟုတ်ပါ။';

  @override
  String get aiIsNotThinking => 'AI သင်ယူနေသည်မဟုတ်။';

  @override
  String get atEnd => 'သင်သည် ပြောင်းရွှေ့စာရင်း၏ အဆုံးတွင် ရှိနေသည်။';

  @override
  String get tapBackAgainToLeave => 'ထွက်ခွာရန် နောက်တစ်ကြိမ် ပြန်နှိပ်ပါ။';

  @override
  String get more => 'နောက်ထပ်';

  @override
  String get experimental => '၎င်းသည် စမ်းသပ်မှုအင်္ဂါရပ်တစ်ခုဖြစ်သည်။';

  @override
  String get experiments => 'စမ်းသပ်မှုများ';

  @override
  String get ossLicenses => 'Open-source လိုင်စင်များ';

  @override
  String get language => 'ဘာသာစကား';

  @override
  String get defaultLanguage => 'မူရင်းဘာသာစကား';

  @override
  String get mayMoveInPlacingPhase =>
      'အပိုင်းအစများသည် နေရာယူသည့်အဆင့်တွင် ရွေ့လျားနိုင်သည်';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'ထားသည်နှင့်ရွှေ့သည့် အဆင့်များသည် မသန်စွဲရှိပါ၊ ရုဏ်သိမ်းစရာကစားပွဲတစ်ခုချင်းစီတွင် ကစားသမားများသည် ကစားသမားတစ်ယောက်ကိုရွှေ့ရန် သို့မဟုတ် ကစားပွဲပေါ်တွင်ထားရန် အဆင့်များကိုရွေးချယ်နိုင်ပါသည် (ထားရန်ကစားသမားများကျန်ရှိပါက)။';

  @override
  String get drawerColor => 'မီနူးအရောင်';

  @override
  String get drawerTextColor => 'မီနူးစာသားအရောင်';

  @override
  String get drawerHighlightItemColor => 'မီနူး မီးမောင်းထိုးပြသည့်အရာ အရောင်';

  @override
  String get mainToolbarBackgroundColor => 'ပင်မကိရိယာဘားနောက်ခံအရောင်';

  @override
  String get mainToolbarIconColor => 'ပင်မ ကိရိယာဘား သင်္ကေတ အရောင်';

  @override
  String get navigationToolbarBackgroundColor =>
      'လမ်းညွှန်ကိရိယာဘား နောက်ခံအရောင်';

  @override
  String get navigationToolbarIconColor => 'လမ်းညွှန်ကိရိယာဘား သင်္ကေတ အရောင်';

  @override
  String get autoHideToolbar => 'ကိရိယာဘားကို အလိုအလျောက်ဖျောက်ပါ';

  @override
  String get toolbarLocationOnScreen => 'မျက်နှာပြင်ပေါ်ရှိ ကိရိယာဘားတည်နေရာ';

  @override
  String get top => 'ထိပ်တန်း';

  @override
  String get bottom => 'အောက်ခြေ';

  @override
  String get center => 'စင်တာ';

  @override
  String get solidColor => 'အစိုင်အခဲအရောင်';

  @override
  String get picture => 'ပုံ';

  @override
  String get chooseYourPicture => 'သင့်ပုံကို ရွေးပါ';

  @override
  String get light => 'အလင်း';

  @override
  String get dark => 'မှောငျမိုကျသော';

  @override
  String get themes => 'အပြင်အဆင်';

  @override
  String get currentTheme => 'လက်ရှိ အပြင်အဆင်';

  @override
  String get saveTheme => 'အပြင်အဆင်ကို သိမ်းဆည်းပါ';

  @override
  String get showAnalysisGraph => 'ခွဲခြမ်းစိတ်ဖြာမှုဂရပ်ကို ပြပါ';

  @override
  String get analysis => 'ခွဲခြမ်းစိတ်ဖြာခြင်း';

  @override
  String get saveGame => 'ဂိမ်းကိုသိမ်းဆည်းပါ';

  @override
  String get loadGame => 'ဂိမ်းကိုဖွင့်ပါ';

  @override
  String get setupPosition => 'သတ်မှတ်အနေအထား';

  @override
  String get showLegalMoves => 'ဥပဒေရေးရာလှုပ်ရှားမှုများကိုပြသပါ';

  @override
  String get showLastMove => 'နောက်ဆုံးအရွေ့ကိုပြပါ';

  @override
  String get showArrows => 'မြှားပြပါ';

  @override
  String get pieces => 'ဖဲ့';

  @override
  String get showAnalysis => 'ခွဲခြမ်းစိတ်ဖြာပြပါ';

  @override
  String get threads => 'စာကြောင်းများ';

  @override
  String get getInvolved => 'ပါဝင်လိုက်ပါ';

  @override
  String get helpImproveTranslate => 'ဘာသာပြန်ခြင်း တိုးတက်အောင် ကူညီပေးပါ';

  @override
  String get tutorial => 'ကျူတိုရီရယ်';

  @override
  String get classicMill => 'Classic Mill';

  @override
  String get mixedMill => 'ရောနှောကြိတ်';

  @override
  String get ceylonMill => 'Ceylon Mill ၊';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'ကြိတ်ကွဲပြီး ထပ်ခါထပ်ခါ ပြန်လုပ်နိုင်ပါတယ်';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'အကယ်၍ ကစားသမားတစ်ဦးသည် ကြိတ်ဆုံအသစ်တစ်ခုကိုချက်ချင်းဖန်တီးရန် ကြိတ်ခွဲပါက၊ ထိုကစားသမားသည် ၎င်းကို ကြိတ်အသစ်ပြုလုပ်ပါက ၎င်း၏နောက်အပြောင်းအရွှေ့တွင် အဆိုပါအပိုင်းကို မူလလမ်းဆုံသို့ ပြန်ရွှေ့နိုင်သည်။';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'ကစားသမားတစ်ဦးတွင် အပိုင်းသုံးပိုင်းရှိပြီး ဆယ်ကြိမ်ရွှေ့ပြီးနောက် ကစားသမားသည် ပြိုင်ဘက်၏အပိုင်းအစများကို မဖယ်ရှားပါက ဂိမ်းကို ရေးဆွဲမည်ဖြစ်သည်';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'ကစားသမားတစ်ဦးသည် ဆယ်ကြိမ်တိုင်တိုင် ပြိုင်ဘက်၏အပိုင်းအစကို ဖယ်ထုတ်နိုင်ခြင်းမရှိသည့်အခါ၊ ဂိမ်းသည် သရေဖြစ်သည်။';

  @override
  String get close => 'ပိတ်လိုက်';

  @override
  String get whitePiece => 'အဖြူကွက်';

  @override
  String get blackPiece => 'အနက်ရောင်အပိုင်းအစ';

  @override
  String get emptyPoint => 'ဗလာပွိုင့်';

  @override
  String get noPoint => 'အမှတ်မရှိ';

  @override
  String get placingPhase => 'နေရာယူခြင်းအဆင့်';

  @override
  String get movingPhase => 'ရွေ့လျားအဆင့်';

  @override
  String get flyingPhase => 'ပျံတဲ့အဆင့်';

  @override
  String sideToMove(Object player) {
    return 'ရွှေ့ရန် ဘေးဘက်- $player';
  }

  @override
  String lastMove(Object move) {
    return 'နောက်ဆုံးရွှေ့ခြင်း- $move';
  }

  @override
  String get selected => 'ရွေးချယ်ခဲ့သည်';

  @override
  String get accessibility => 'သုံးစွဲနိုင်မှု';

  @override
  String get screenReaderSupport => 'မျက်နှာပြင်ဖတ်စာ ပံ့ပိုးမှု';

  @override
  String get isDraw => 'အတူတူနေသည်!';

  @override
  String get draw => 'ဆွဲသည်။';

  @override
  String get pieceHighlightColor => 'အသားပေးအရောင်';

  @override
  String get algorithm => 'အယ်လ်ဂိုရစ်ထမ်';

  @override
  String get endgameNMoveRule => 'နောက်ဆုံးဂိမ်း N-Move စည်းမျဉ်း';

  @override
  String get endgameNMoveRule_Detail =>
      'ကစားသမားတစ်ဦးဦးတွင် အပိုင်းသုံးပိုင်းသာရှိပြီး ကစားသမားတစ်ဦးဦးမှ သီးခြားလှုပ်ရှားမှုအတွင်း အပိုင်းတစ်ခုကို မဖယ်ရှားပါက ဂိမ်းကို ရေးဆွဲမည်ဖြစ်သည်။';

  @override
  String get drawReasonEndgameRule50 =>
      'ကစားသမားတစ်ဦးစီတွင် အပိုင်းသုံးပိုင်းသာရှိပြီး ကစားသမားတစ်ဦးဦးသည် သီးခြားလှုပ်ရှားမှုအတွင်း အပိုင်းတစ်ခုကို မဖယ်ရှားပါ။';

  @override
  String get threefoldRepetitionRule => 'သုံးဆ ထပ်ခါထပ်ခါ စည်းမျဉ်း';

  @override
  String get threefoldRepetitionRule_Detail =>
      'တတိယအကြိမ် အနေအထားတစ်ခု ဖြစ်ပေါ်ပါက ဂိမ်းကို ရေးဆွဲသည်။';

  @override
  String get continueToMakeMove => 'ကြိတ်! ဆက်လက်လှုပ်ရှားပါ။';

  @override
  String get pointStyle => 'ပွိုင့်စတိုင်';

  @override
  String get pointWidth => 'ပွိုင့်အကျယ်';

  @override
  String get solid => 'အစိုင်အခဲ';

  @override
  String get hollow => 'အခေါင်းပေါက်';

  @override
  String get languageName => 'မြန်မာဘာသာ';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count ရွေ့မည်',
      one: '$count ရွေ့မည်',
      zero: 'ရွေ့မည်',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'တင်ရန် မအောင်မြင်ပါ။';

  @override
  String get filename => 'ဖိုင်နာမည်';

  @override
  String get browse => 'ကြည့်ရှုရန်…';

  @override
  String get gameFiles => 'ဂိမ်းဖိုင်များ';

  @override
  String get gameSavedTo => 'ဂိမ်းကို သိမ်းထားသည်';

  @override
  String get empty => 'ဗလာ';

  @override
  String get noMove => 'မလှုပ်နဲ့။';

  @override
  String get restoredPosition => 'မူလအနေအထားကို ပြန်လည်ရရှိခဲ့သည်။';

  @override
  String get clean => 'သန့်ရှင်း';

  @override
  String get cleanedUp => 'သန့်စင်ခဲ့သည်။';

  @override
  String get remove => 'ဖယ်ရှားပါ';

  @override
  String get noPiecesCanBeRemoved => 'အပိုင်းအစများကို ဖယ်ရှား၍မရပါ။';

  @override
  String pieceCountNeedToRemove(int count) {
    return '$count ပိုင်း ဖယ်ရှားရန် လိုအပ်သည်。';
  }

  @override
  String placedCount(int count) {
    return 'နေရာ ($count)';
  }

  @override
  String get placedPieceCount =>
      'နေရာယူသည့်အဆင့်တွင် အပိုင်းအစများကို ထည့်တွက်ပါ။';

  @override
  String hasPlacedPieceCount(int count) {
    return 'လက်ရှိကစားသမားသည် $count အပိုင်းများကို ထားရှိထားပါသည်။';
  }

  @override
  String get notPlacingPhase => 'အဆင့်မသတ်မှတ်ဘဲ ပြောင်းလို့မရပါဘူး။';

  @override
  String get paste => 'ငါးပိ';

  @override
  String get pasteDone => 'ငါးပိပြီးပြီ။';

  @override
  String get cannotPaste => 'ကူးထည့်၍မရပါ။';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'နေရာလွတ်နှင့် ဖယ်ရှားထားသောအပိုင်းများကို ပြပါ';

  @override
  String get fullScreen => 'မျက်နှာပြင်အပြည့်';

  @override
  String get reopenToTakeEffect =>
      'ဆက်တင်များအကျိုးသက်ရောက်စေရန် အက်ပ်ကိုထွက်ပြီး ပြန်ဖွင့်ပါ။';

  @override
  String get forest => 'သစ်တော';

  @override
  String get desktopImage => 'ဒက်စတော့ပုံ';

  @override
  String get invalidPosition => 'တည်နေရာမမှန်ကန်။';

  @override
  String get shareGIF => 'GIF ကိုမျှဝေပါ';

  @override
  String get pixelRatio => 'Pixel အချိုး';

  @override
  String get duration => 'သင်တန်းကာလ';

  @override
  String get gameScreenRecorder => 'ဂိမ်းစခရင်အသံဖမ်းစက်';

  @override
  String get previous => 'အရင်';

  @override
  String get next => 'နောက်တစ်ခု';

  @override
  String get skip => 'ကျော်သွားပါ။';

  @override
  String get gotIt => 'နားလည်ပြီ';

  @override
  String get youCanModifyRules =>
      'စည်းကမ်းဆက်တင်များတွင် သင်သည် ဂိမ်း၏စည်းမျဉ်းများကို ပြင်ဆင်နိုင်သည်။';

  @override
  String get youCanUseMouseWheelInPicker =>
      'ရွေးသည့်ကိရိယာရှိတန်ဖိုးကို ပြောင်းလဲရန် မောက်စ်ဘီးကို သင်သုံးနိုင်သည်။';

  @override
  String get noTimeLimitForThinking =>
      'AI Thinking time ကို 0 ဟု သတ်မှတ်သည် ဆိုသည်မှာ တွေးတောရန် အချိန် ကန့်သတ်ချက် မရှိပါ။';

  @override
  String get whatIsMtdf =>
      'MTD(f) သည် အလယ်အလတ်ရှာဖွေမှုရလဒ်များကို ပြန်လည်အသုံးပြုကာ ရှာဖွေမှုနေရာကို ကျဉ်းစေရန် ကောင်းမွန်သော ကနဦးမှန်းဆချက်အား အသုံးပြုခြင်းဖြင့် ထိရောက်မှုတိုးတက်စေရန် ရည်ရွယ်သည့် အယ်လ်ဖာဘီတာရှာဖွေမှု အယ်လဂိုရီသမ်၏ မွမ်းမံထားသောပုံစံတစ်ခုဖြစ်သည်။';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'AI တွေးခေါ်ချိန်ချိန်ညှိမှုသည် လုံးဝတိကျမည်မဟုတ်ကြောင်း ကျေးဇူးပြု၍ သတိပြုပါ။ အခက်အခဲအဆင့်ကို နိမ့်သောတန်ဖိုးအဖြစ် သတ်မှတ်သောအခါတွင် အမှန်တကယ် တွေးခေါ်ချိန်သည် တိုတောင်းနိုင်ပြီး အချိန်ကုန်သွားသောအခါတွင် AI သည် အတွေးအလယ်တွင် ပိုရှည်နိုင်သည်။';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'အခက်အခဲအဆင့်ကို မြင့်မားစွာသတ်မှတ်ထားသော်လည်း AI တွေးခေါ်ချိန်ကို မတိုးမြှင့်ပါက၊ တွေးခေါ်ချိန်ကန့်သတ်ချက်ကြောင့် အမှန်တကယ်အခက်အခဲအဆင့်သည် နည်းပါးသောတန်ဖိုးအဖြစ် ကန့်သတ်ထားနိုင်သည်။ စက်၏စွမ်းဆောင်ရည်ပေါ်မူတည်၍ အမှန်တကယ်တန်ဖိုးသည် ကွဲပြားနိုင်သည်။';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) သည် ပေးထားသည့် အနေအထားတွင် အကောင်းဆုံး ရွေ့လျားမှုကို ရှာဖွေရန် ရှာဖွေမှု အယ်လဂိုရီသမ် တစ်ခု ဖြစ်သည်။ ၎င်းသည် အယ်လ်ဖာ-ဘီတာ အယ်လဂိုရီသမ်ကို မြှင့်တင်ထားပြီး ပြောင်းရွှေ့မှုတစ်ခုသည် အဓိကကွဲလွဲချက်မှ ဘေးကင်းပြီးသားရမှတ်ထက် ပိုဆိုးသည် သို့မဟုတ် မဆိုးကြောင်း အတည်ပြုရန် null သို့မဟုတ် သုည window ရှာဖွေမှုများကို အသုံးပြုသည်။ PVS သည် အလားအလာ အကောင်းဆုံး လှုပ်ရှားမှုများကို အာရုံစိုက်ပြီး ရှာဖွေမှု၏ ထိရောက်မှုကို မြှင့်တင်ပေးသည့် မလိုအပ်သော အကိုင်းအခက်များကို မလိုအပ်သော ရှာဖွေမှုများကို ရှောင်ရှားသည်။';

  @override
  String get whatIsAlphaBeta =>
      'အယ်လ်ဖာဘီတာ အယ်လဂိုရီသမ်သည် အကောင်းဆုံး ရွေ့လျားမှုကို ရှာဖွေရန် ရှာဖွေမှု အယ်လဂိုရီသမ်တစ်ခု ဖြစ်သည်။ ၎င်းသည် ရှာဖွေမှုအပင်ကို ဖြတ်တောက်ပြီး ထိရောက်မှုတိုးမြင့်ရန် minimax နိယာမနှင့် တန်ဖိုးနှစ်ခုဖြစ်သည့် အယ်လ်ဖာနှင့် ဘီတာတို့ကို အသုံးပြုသည်။ Alpha သည် ကွန်ပြူတာမှ ရရှိနိုင်သည့် အနိမ့်ဆုံးရမှတ်ကို ကိုယ်စားပြုပြီး ဘီတာသည် ၎င်း၏ပြိုင်ဘက်ရနိုင်သော အများဆုံးရမှတ်ကို ကိုယ်စားပြုသည်။ algorithm သည် ဂိမ်းတစ်ခုတွင် ကွန်ပျူတာကို ထက်မြက်ပြီး ထိရောက်သော ဆုံးဖြတ်ချက်များချနိုင်ရန် ကူညီပေးသည်။';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'လူ့အတွေ့အကြုံအရ အနိုင်ယူဖို့ ကြိုးစားရင် ရှုံးလိမ့်မယ်။ ယင်းအစား၊ သင့်ပန်းတိုင်အဖြစ် သရေတစ်မှတ်ရရှိရန် ရည်မှန်းပြီး ဂိမ်းကို မရှုံးစေပါ။ မင်းရဲ့ပြိုင်ဘက်ကို စောင့်ကြည့်ပြီး အမှားလုပ်မိနိုင်တဲ့ အနေအထားတစ်ခုဆီ ညင်သာစွာ ဆွဲဆောင်ပါ။ အားနည်းချက်တွေပြတဲ့အခါ အခွင့်အလမ်းကို ဆုပ်ကိုင်ပြီး အနိုင်ရဖို့ ညင်သာစွာ တွန်းအားပေးပါ။ ဤနည်းဖြင့် သင်သည် ဂိမ်းကို အနိုင်ယူနိုင်သည်။';

  @override
  String get firstMoveDetail =>
      'ဤဂိမ်းတွင် ပထမကစားသမားနှင့် နှိုင်းယှဉ်ပါက ဒုတိယကစားသမားသည် အနိုင်ရရန် ပိုမိုလွယ်ကူသည်။';

  @override
  String get passiveDetail =>
      'Passive option ကိုဖွင့်ထားခြင်းဖြင့် AI သည် တတ်နိုင်သမျှမြန်မြန်အနိုင်ရရန် ပြင်းပြင်းထန်ထန်ကြိုးစားခြင်းထက် ရာထူးတွင် အားသာချက်တစ်ခုရှိနေသောအခါ အနားယူစေမည်ဖြစ်သည်။';

  @override
  String get moveRandomlyDetail =>
      'ဤရွေးချယ်မှုကို ဖွင့်ထားခြင်းဖြင့် ၎င်းသည် AI ကို အနိုင်ယူရန် နည်းလမ်းများကို လေ့လာရာတွင် အထောက်အကူဖြစ်စေချိန်တွင် ဂိမ်း၏ ကျပန်းနှင့် ပျော်ရွှင်မှုကို တိုးစေသည်။';

  @override
  String get considerMobilityOfPiecesDetail =>
      'AI သည် ၎င်း၏ အစိတ်အပိုင်းများ၏ ရွေ့လျားနိုင်မှုကို ထည့်သွင်းစဉ်းစားပါက၊ ၎င်းသည် ပြိုင်ဘက်၏ အစိတ်အပိုင်းများကို တတ်နိုင်သမျှ အမြန်ဖမ်းယူရန် ရည်ရွယ်ရုံသာမက ပြိုင်ဘက်၏ လှုပ်ရှားမှုများကို ပိတ်ဆို့ကာ ၎င်းတို့ကို တားဆီးရန်လည်း ထည့်သွင်းစဉ်းစားမည်ဖြစ်သည်။';

  @override
  String get whenBoardIsFull => 'ဘုတ်ပြားပြည့်သောအခါ';

  @override
  String get whenBoardIsFull_Detail =>
      'နေရာချခြင်းအဆင့်၏အဆုံးတွင်၊ ရွေ့လျားသည့်အဆင့်မစတင်မီ၊ ဘုတ်ပြားသည် အပိုင်းအစများပြည့်နေပါက လုပ်ဆောင်မှုနောက်ဆက်တွဲဖြစ်သည်။';

  @override
  String get sideToMoveRemovePiece =>
      'ရွေ့လျားသည့်အဆင့်တွင် ပထမရွေ့လျားသောကစားသမားသည် ပြိုင်ဘက်၏အပိုင်းအစများကို ဖယ်ရှားသည်။';

  @override
  String get agreeToDraw => 'သရေကျဖို့ နှစ်ဖက်သဘောတူတယ်။';

  @override
  String get takeOpponentsPiece => 'သင်၏ပြိုင်ဘက်၏အပိုင်းအစများကိုယူပါ။';

  @override
  String get firstPlayerLose => 'ပထမကစားသမားက ဂိမ်းကိုရှုံးတယ်။';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'ပထမနှင့် ဒုတိယကစားသမားများသည် ပြိုင်ဘက်၏အပိုင်းအစများကို ဖယ်ထုတ်သည်။';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'ဒုတိယနှင့် ပထမကစားသမားများသည် ပြိုင်ဘက်၏အပိုင်းအစများကို ဖယ်ထုတ်သည်။';

  @override
  String get enteredFlyingPhase =>
      'ယခု ပျံသန်းခြင်းအဆင့်သို့ ရောက်ရှိလာပြီး ပြိုင်ဘက်၏ အစိတ်အပိုင်းများသည် ဘုတ်ပေါ်ရှိ မည်သည့်နေရာမဆို လွတ်သွားနိုင်သည်။ \"စည်းကမ်းဆက်တင်များ\" တွင် ပျံသန်းမှုစည်းမျဉ်းကို သင်ပိတ်နိုင်သည်။';

  @override
  String get whenStalemate => 'ရှေ့မတိုးနောက်မဆုတ်ဖြစ်တဲ့အခါ';

  @override
  String get whenStalemate_Detail =>
      'မည်သည့်အရာမျှ မရွေ့နိုင်သောအခါတွင် မည်သို့လုပ်ဆောင်ရမည်နည်း။';

  @override
  String get endWithStalemateLoss =>
      'ပိတ်ဆို့ထားသောဘက်ခြမ်းအတွက် ရှေ့မတိုးနောက်မဆုတ် ဆုံးရှုံးမှုဖြင့် အဆုံးသတ်ပါ။';

  @override
  String get changeSideToMove => 'ရွှေ့ရန် ဘေးကို ပြောင်းပါ။';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'ပြိုင်ဘက်၏အပိုင်းအစများကို ဖယ်ရှားပြီး နောက်တစ်ဆင့်ကို ရွှေ့ပါ။';

  @override
  String get endWithStalemateDraw =>
      'ရှေ့မတိုးနောက်မဆုတ်သာ သရေဖြင့် အဆုံးသတ်ပါ။';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'ပြိုင်ဘက်၏အပိုင်းအစများကို ဖယ်ရှားပြီး ရွှေ့ရန် ဘေးဘက်သို့ ပြောင်းပါ။';

  @override
  String get aiResponseDelayTime => 'AI တုံ့ပြန်မှုနှောင့်နှေးချိန်';

  @override
  String get aiIsDelaying =>
      'AI သည် လက်ရှိတွင် နှောင့်နှေးသော တုံ့ပြန်မှုအဆင့်တွင် ရှိနေသည်။ ဆက်လက်မလုပ်ဆောင်မီ ခဏစောင့်ပါ။';

  @override
  String get tipCanNotRemoveNonadjacent => 'မကပ်နေသောအပိုင်းကို ဖယ်ရှား၍မရပါ။';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'ရှေ့မတိုးသာမယာဖြစ်လျှင် ကြိတ်ဖွဲ့စည်းပုံမခွဲခြားဘဲ သင့်အနီးရှိ ပြိုင်ဘက်၏အပိုင်းများကို ဖယ်ရှားနိုင်သည်။';

  @override
  String get whatIsMcts =>
      'MCTS သည် မတူညီသောရွေ့လျားမှုများကို သရုပ်ဖော်မှုများမှတစ်ဆင့် စူးစမ်းအကဲဖြတ်ခြင်းဖြင့် ဆုံးဖြတ်ချက်များချပေးသည့် အစပြုသူများအတွက် အဆင်ပြေသော အယ်လဂိုရီသမ်တစ်ခုဖြစ်သည်။';

  @override
  String get goldenJade => 'ရွှေကျောက်စိမ်း';

  @override
  String get forestWood => 'သစ်တောသစ်';

  @override
  String get darkMystery => 'နက်နဲသောအရာ';

  @override
  String get midnightBlue => 'သန်းခေါင်ယံပြာ';

  @override
  String get greenForest => 'စိမ်းလန်းသောသစ်တော';

  @override
  String get greenMeadow => 'မြက်ခင်းစိမ်းစိမ်း';

  @override
  String get stonyPath => 'Stony လမ်း';

  @override
  String get pastelPink => 'Pastel ပန်းရောင်';

  @override
  String get turquoiseSea => 'Turquoise ပင်လယ်';

  @override
  String get violetDream => 'ခရမ်းရောင်အိပ်မက်';

  @override
  String get mintChocolate => 'မင်းတျချောကလက်';

  @override
  String get skyBlue => 'ကောင်းကင်ပြာ';

  @override
  String get playfulGarden => 'ကစားစရာဥယျာဉ်';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Retrograde ခွဲခြမ်းစိတ်ဖြာမှု algorithm သည် မတူညီသော start positions များမှ endgame database တစ်ခုကို တည်ဆောက်ရန်အတွက် တန်ဖိုးများစွာရှိသော retrograde ခွဲခြမ်းစိတ်ဖြာမှုကို အသုံးပြုပြီး ဂိမ်းကစားခြင်းကို ပိုကောင်းအောင်ပြုလုပ်ရန် ဤဒေတာဘေ့စ်ကို အသုံးပြုပါသည်။ ဤချဉ်းကပ်မှုသည် အလွန်ပြင်းထန်သော ဖြေရှင်းနည်းများ အမျိုးအစားအောက်တွင် ရှိသည်။';

  @override
  String get viewAlgorithmGuide =>
      'ဤအယ်လဂိုရီသမ်အတွက် အသုံးပြုသူလမ်းညွှန်ကို သင်ကြည့်ရှုလိုပါသလား။';

  @override
  String get showPositionalAdvantageIndicator =>
      'အနေအထားအရ အားသာချက်ညွှန်ပြချက်ကို ပြပါ';

  @override
  String get usePerfectDatabase => 'ပြီးပြည့်စုံသောဒေတာဘေ့စ်ကိုသုံးပါ။';

  @override
  String get perfectDatabaseDescription =>
      'နောက်ဆုံးပေါ် အယ်လဂိုရီသမ်များမှတစ်ဆင့် ထုတ်လုပ်ထားသော ချို့ယွင်းချက်မရှိသော ဂိမ်းဒေတာဘေ့စ်ကို အသုံးပြုရန် ဤရွေးချယ်မှုကို ဖွင့်ပါ။ ဤအင်္ဂါရပ်သည် အကောင်းဆုံးလှုပ်ရှားမှုများကို အကြံပြုရန်အတွက် အဖွင့်နှင့် ဂိမ်းဗျူဟာများ နှစ်ခုလုံးကို ပေါင်းစပ်ထားသည်။ ဤသည်မှာ ဂိမ်းကစားရာတွင် တိကျမှုအမြင့်ဆုံးအဆင့်ကို ရှာဖွေသော ကစားသမားများအတွက် ဦးစားပေးရွေးချယ်မှုဖြစ်သည်။ စေ့စပ်သေချာသော တွက်ချက်နည်းစနစ်များဖြင့် ဖန်တီးထားသည့် ဒေတာဘေ့စ်သည် ပြီးပြည့်စုံလုနီးပါးရှိသော ဂိမ်းဖြေရှင်းချက်များကို ပေးဆောင်ရန် ဒီဇိုင်းထုတ်ထားသည်။\n\nမှတ်ချက်- AI သည် ဒေတာဘေ့စ်သို့ ဝင်ရောက်ရန် ပျက်ကွက်ပါက၊ ၎င်းသည် ဂိမ်းကစားခြင်းဆိုင်ရာ ဆုံးဖြတ်ချက်များအတွက် သမားရိုးကျ algorithms အဖြစ် ပြောင်းလဲသွားမည်ဖြစ်သည်။ ဒေတာဘေ့စ်ကို ရရှိနိုင်သောအခါ \'ခက်ခဲမှုအဆင့်\' သည် အနိုင်ယူ၍မရနိုင်လောက်အောင် ဖြစ်လာပြီး \'AI Thinking Time\' သည် သိသိသာသာ လျော့ပါးသွားပါသည်။ ဒေတာဘေ့စ်ရလဒ်များသည် အမြင့်ဆုံးဦးစားပေးဖြစ်သောကြောင့် \'AI\'s play style\' ရွေးစရာများအတွင်းရှိ ဆက်တင်အများအပြားကို လွှမ်းမိုးသွားပါမည်။\n\nဤအပြစ်အနာအဆာကင်းသောဒေတာဘေ့စ်ကို မည်ကဲ့သို့အသုံးပြုနည်းလမ်းညွှန်ချက်အတွက် ဤနေရာကိုနှိပ်ပါ။';

  @override
  String get backgroundImage => 'နောက်ခံပုံရိပ်';

  @override
  String get whatIsRandom =>
      '\'ပြီးပြည့်စုံသောဒေတာဘေ့စ်ကိုအသုံးပြုပါ\' ရွေးချယ်ခွင့်ကို ဖွင့်မထားသောအခါ၊ \'ကျပန်း\' ဆက်တင်သည် AI သည် ရွှေ့ရန်ရွေးချယ်မှုအတွက် မည်သည့် algorithms ကိုမျှမသုံးဘဲ အပိုင်းများကို ကျပန်းရွှေ့စေသည်။ ၎င်းသည် ပုံမှန်အားဖြင့် သိသိသာသာ အားနည်းသော ဂိမ်းကစားခြင်းကို ဖြစ်ပေါ်စေသည်။ အပြန်အလှန်အားဖြင့် \'ပြီးပြည့်စုံသောဒေတာဘေ့စ်ကိုအသုံးပြုရန်\' ကိုဖွင့်ထားသောအခါ၊ AI သည် ရိုးရာ AI အယ်လဂိုရီသမ်များနှင့် ရောနှောမည့်အစား ဆုံးဖြတ်ချက်များချရန်အတွက် \'ပြီးပြည့်စုံသောဒေတာဘေ့စ်\' ပေါ်တွင် သီးသန့်မှီခိုနေပါသည်။ ဤမုဒ်တွင်၊ AI ၏ ရွေ့လျားမှုသည် ဒေတာဘေ့စ်၏ အကြောင်းအရာပေါ်တွင် လုံးလုံးလျားလျား အခြေခံထားပြီး အချိန်နှင့်တပြေးညီ တွက်ချက်မှုများ သို့မဟုတ် ရှာဖွေမှု အယ်လဂိုရီသမ်များအပေါ် မှီခိုမှုကို ရှောင်ဖယ်ထားသည်။';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'ပြိုင်ဘက်၏ အရာဝတ္ထု(များ)ကို သူတို့၏ လက်ထဲမှ ဖယ်ရှားပါ။ ထို့နောက် ပြိုင်ဘက်၏ အလှည့်ကျ ခုန်ရန် အလှည့်ဖြစ်သည်။';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'တည်ဆောက်ခြင်း အဆင့်တွင် ကြိတ်များကို ပုံဖော်ခြင်းအခါ';

  @override
  String get removeOpponentsPieceFromBoard =>
      'ဘုတ်အဖွဲ့မှ ပြိုင်ဘက်၏ အရာဝတ္ထု(များ)ကို ဖယ်ရှားပါ။';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'ဘုတ်အဖွဲ့မှ ပြိုင်ဘက်၏ အရာဝတ္ထု(များ)ကို ဖယ်ရှားပါ။ ထို့နောက် ပြိုင်ဘက်၏ အလှည့်ကျ ခုန်ရန် အလှည့်ဖြစ်သည်။';

  @override
  String get opponentRemovesOwnPiece =>
      'ပြိုင်ဘက်သည် ဘုတ်အဖွဲ့မှ သူတို့၏အရာဝတ္ထု(များ)ကို ဖယ်ရှားသည်။';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'သင့်မှ လှုပ်ရှားမှု မယူပဲ၊ ပြိုင်ဘက်သည် သူတို့၏အရာဝတ္ထု(များ)ကို ရွေးချယ်ပြီး ဘုတ်အဖွဲ့မှ ဖယ်ရှားသည်၊ ထို့ဖြင့် သူတို့အား အန္တရာယ်ဖြစ်စေသည့် လှုပ်ရှားမှုကို ယူသည်။';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'ပြိုင်ဘက်၏ အရာဝတ္ထု(များ)ကို သူတို့၏ လက်ထဲမှ ဖယ်ရှားပါ။ ထို့နောက် သင့်အလှည့်ကျ ရွေ့လျားရန် အလှည့်ဖြစ်သည်။';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'ပြိုင်ဘက်၏ လက်ထဲမှ အရာဝတ္ထု(များ)ကို ဖယ်ရှားပါ။ Multi-remove ဆက်တင်အရ၊ အရာဝတ္ထု အများကြီးကို ဖယ်ရှားရန်ရှိပြီး ပြိုင်ဘက်တွင် လက်ထဲတွင် အရာဝတ္ထု မရှိလျှင်၊ ဘုတ်အဖွဲ့မှ ပြိုင်ဘက်၏ အရာဝတ္ထု(များ)ကို ဆက်လက် ဖယ်ရှားပါ။ ထို့နောက် သင့်အလှည့်ကျ ရွေ့လျားရန် အလှည့်ဖြစ်သည်။ သင် ကြိတ်များကို ဆက်လက် ပုံဖော်ပါက၊ ပြိုင်ဘက်၏ အရာဝတ္ထု(များ)ကို ဖယ်ရှားနိုင်သည်။';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'ပြိုင်ဘက်၏ လက်ထဲမှ အရာဝတ္ထု(များ)ကို ဖယ်ရှားပါ။ Multi-remove ဆက်တင်အရ၊ အရာဝတ္ထု အများကြီးကို ဖယ်ရှားရန်ရှိပြီး ပြိုင်ဘက်တွင် လက်ထဲတွင် အရာဝတ္ထု မရှိလျှင်၊ ဘုတ်အဖွဲ့မှ ပြိုင်ဘက်၏ အရာဝတ္ထု(များ)ကို ဆက်လက် ဖယ်ရှားပါ။ ထို့နောက် ပြိုင်ဘက်၏ အလှည့်ကျ ရွေ့လျားရန် အလှည့်ဖြစ်သည်။';

  @override
  String get markAndDelayRemovingPieces =>
      'အရာဝတ္ထုများကို မှတ်သားပြီး ဖယ်ရှားခြင်းကို နောက်ဆုတ်ပါ။';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'တည်ဆောက်ခြင်း အဆင့်တွင်၊ ဖယ်ရှားရမည့် အရာဝတ္ထုများကို မှတ်သားပြီး၊ အားလုံးသော ကစားသမားများအတွက် ထိုနေရာများတွင် အသစ်တစ်ခုမှ ထားရှိခွင့်မရှိပါ။ ရွေ့လျားခြင်း အဆင့်သို့ ဝင်ရောက်သည့်အခါ၊ ထိုမှတ်သားထားသည့် အရာဝတ္ထုများကို အားလုံးဖယ်ရှားပြီး၊ ကစားသမားများသည် ယခုဗလာနေရာများသို့ သူတို့၏ အရာဝတ္ထုများကို ရွေ့လျားနိုင်သည်။';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'အဆင့်တွင်ကစားပွဲအတွင်း၌အတူတကွတည်ဆောက်ကြသည့်အခါယူဆောင်နိုင်သောလုပ်ဆောင်ချက်များ။';

  @override
  String get marked => 'မှတ်သားထားသည်';

  @override
  String get menu => 'မီနူး';

  @override
  String get monochrome => 'တစ်ရောင်';

  @override
  String get youCanEnableScreenReaderSupport =>
      'သင့်သည် အထွေထွေဆက်တင်များ၏ ရရှိနိုင်ချက်ပြုလုပ်မှုများတွင် စကရင်ဖတ်သူပံ့ပိုးမှုကို ဖွင့်နိုင်သည်။';

  @override
  String get showNumbersOnPieces => 'အစိတ်အပိုင်းများပေါ်တွင်နံပါတ်များပြသည်';

  @override
  String get saveImage => 'ဓာတ်ပုံ သိမ်းဆည်းပါ';

  @override
  String get isAnalysisToolbarShown => 'စစ်ဆင်ရေးကွန်ယက်ပရောင်းသောစားပွဲ';

  @override
  String get analysisToolbarBackgroundColor =>
      'စစ်ဆင်ရေးကွန်ယက်ပရောင်းသောစားပွဲနောက်ပိုင်းအရောင်အဝယ်';

  @override
  String get analysisToolbarIconColor =>
      'စစ်ဆင်ရေးကွန်ယက်ပရောင်းသောစားပွဲအင်္ဂါအရောင်';

  @override
  String get transformed => 'အပြောင်းအလဲပြုလုပ်လျှင်';

  @override
  String get cannotTransform =>
      'မဆုံးအပြောင်းအလဲပြုပြီးပါးစပ်ပါးသောက်ကျသွားပါပြီ';

  @override
  String get rotate => 'တွင်ရှိတည်ရှိခြင်း';

  @override
  String get horizontalFlip => 'H Flip';

  @override
  String get verticalFlip => 'V Flip';

  @override
  String get innerOuterFlip => 'IO Flip';

  @override
  String get transparentCanvas => 'ကြည်လင်ကန်ဗတ်';

  @override
  String get restrictRepeatedMillsFormation =>
      'ထပ်ခါထပ်ခါ အလုပ်ရုံဖွဲ့စည်းခြင်းကို ကန့်သတ်ပါ';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'တစ်ခုမှ တစ်ခုသို့ ရွှေ့ပြီး မီးလုံးတစ်ခု ပြန်ဖွဲ့ဖို့ ရှေ့ရပ်နေရာသို့ နောက်တစ်ခါတွင် ချက်ချင်း မပြန်လာနိုင်ပါ။ အရင်ဆုံး ကြားရှိ ရွှေ့ချက်ကို လိုအပ်သည်။';

  @override
  String get oneTimeUseMill => 'တစ်ကြိမ်သုံးအကြိမ်';

  @override
  String get oneTimeUseMill_Detail =>
      'တစ်ကြိမ်သုံးတိုင်းပြိုင်ဘက်၏အပိုင်းတစ်ခုကိုတစ်ကြိမ်သာဖယ်ရှားနိုင်သည်။ သင်ပြန်လည်ဖွဲ့စည်းနိုင်ပါသည်၊ သို့သော်ထပ်မံဖယ်ရှားရန်အတွက်အသုံးမပြုနိုင်ပါ။';

  @override
  String get currentRulesNoPerfectDatabase =>
      'သင်အပ်နှံထားသည့် လက်ရှိစည်းကမ်းများသည် သင့်လျော်သော ပြည့်စုံသော ဒေတာဘေ့စ မရှိပါ။ ပြည့်စုံသော ဒေတာဘေ့စအကြောင်း ပိုမိုသိရှိလိုပါက ဤနေရာကိုနှိပ်ပါ။';

  @override
  String get focusOnBlockingPaths => 'ပိတ်ဆို့သောလမ်းများပေါ်တွင်အာရုံစိုက်ပါ';

  @override
  String get focusOnBlockingPaths_Detail =>
      'မီးခိုးသုံးတည်ဆောက်ခြင်းကို ဦးစားမပေးဘဲ ပြိုင်ဘက်ရဲ့ လှုပ်ရှားမှုကို တားဆီးဖို့ ဦးစားပေးပါ။ AI က မီးခိုးသုံးတွေ ပြီးမြောက်စေခြင်းအားဖြင့် အပိုင်းတွေကို ဖယ်ရှားရန် အာရုံစိုက်ခြင်းမပြုဘဲ ပြိုင်ဘက်ကို ပိတ်မိအောင် ကြိုးပမ်းပါတယ်၊ သို့ဖြစ်ပြီး ပြိုင်ဘက်ကို ရွေ့လျားနိုင်စွမ်းမရှိစေပြီး တိုက်ခိုက်စစ်မဟုတ်ဘဲ ပင်ပန်းခြင်းဖြင့် အနိုင်ရရှိစေပါတယ်။ ဤနည်းဗျူဟာ ပြိုင်ဘက်ရဲ့ မီးခိုးသုံးတွေကို တက်ကြွစွာ မတားဆီးပါ။';

  @override
  String get pieceImage => 'တရားသူကြီးဓါတ်ပုံ';

  @override
  String get importColorSettings => 'အရောင်ချိန်ညှိချက်များကိုတင်သွင်းပါ';

  @override
  String get exportColorSettings => 'အရောင်ချိန်ညှိချက်များကိုပို့ပါ';

  @override
  String get import => 'တင်သွင်းသည်';

  @override
  String get export => 'တင်ပို့သည်';

  @override
  String get pleaseCopyJsonToClipboard =>
      'ကျေးဇူးပြု၍ JSON ဖော်မတ်ချိန်ညှိချက်များကို clipboard သို့ အရင်ဆုံး ကူးယူပါ။';

  @override
  String get copiedToClipboard => 'Clipboard သို့ ကူးယူပြီး။';

  @override
  String get imported => 'တင်သွင်းပြီး။';

  @override
  String get boardImage => 'ဘုတ်ပြားပုံ';

  @override
  String get autumnLeaves => 'ဆောင်းဦးတစ်ပိုင်း';

  @override
  String get legendaryLand => 'ဒဏ္ဍာရီ မြေ';

  @override
  String get vignetteEffect => 'ဗီညာ အထိအရောက်';

  @override
  String get promptMakeToolbarTransparent =>
      'ဘုတ်နောက်ခံပုံသတ်မှတ်ထားသောအခါ ကိရိယာဘားကို အပြည့်အဝ ထင်ရှားပြတ်သားအောင် ပြုလုပ်လိုပါသလား?';

  @override
  String get vibration => 'ဂိမ်းတွင် တုန်ခါမှု ဖွင့်ပါ';

  @override
  String get soundTheme => 'အသံအကြောင်းအရာ';

  @override
  String get ball => 'ဘောလုံး';

  @override
  String get liquid => 'ရည်';

  @override
  String get wood => 'သစ်သား';

  @override
  String get placeEffectAnimation =>
      'သားကိုထားရာတွင် အန်နိမေးရှင်း အကျိုးသက်ရောက်မှု';

  @override
  String get removeEffectAnimation =>
      'သားကိုဖယ်ရှားရာတွင် အန်နိမေးရှင်း အကျိုးသက်ရောက်မှု';

  @override
  String get isToolbarAtBottom => 'ကိရိယာဘားကို အောက်ဆုံးတွင် ပြပါ';

  @override
  String get boardCornerRadius => 'ဘုတ်အနားရိုးကျော်လွန်အချင်း';

  @override
  String get useOpeningBook => 'ဖွင့်စာအုပ်ကိုသုံးပါ';

  @override
  String get currentRule => 'လက်ရှိ';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'စည်းမျဉ်းအစုံ';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'AI ကို ကစားပွဲအစမှာ ကစားသမားများက မကြာခဏသုံးစွဲတဲ့ဖွင့်ပွဲကို သုံးစွဲခွင့်ပြုပါ။ မှတ်ချက် - ယခုလိုင်းပေါ်ရှိ ဤအင်္ဂါရပ်သည် သတ်မှတ်ထားသော စည်းမျဉ်းစုံများအတွက်သာ ရရှိနိုင်သည်။';

  @override
  String get showAdvantageGraph => 'အားသာချက်ဂრაფပြပါ';

  @override
  String get advantageGraphHint =>
      'အကြွင်းမဲ့ကောင်းမွန်မှုဇယားသည် AI မှ ခလုတ်ပြုလုပ်ပြီးနောက်တွင်သာ ဆွဲရန်ရှိသည်။ လူကစားသမားမှ ခလုတ်ပြုလုပ်သည့်အခါတွင် ဆွဲမည်မဟုတ်ပါ။';

  @override
  String get removalBasedOnMillCounts =>
      'တစ်ခုချင်းစီကို တစ်လှည့်ချင်း ထည့်ပြီးဆုံးသည်တိုင် နှုတ်ယူခြင်းကို ပိတ်ထားပါ။ လူသည် မယ်လ့်အရေအတွက်အလိုက် ယူထုတ်ကြသည်။';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'တစ်ခုချင်းစီကို တစ်လှည့်ချင်း ထည့်ပြီးဆုံးသည်တိုင် နှုတ်ယူခြင်းကို ပိတ်ထားပါ။ လူသည် မယ်လ့်အရေအတွက်အလိုက် ယူထုတ်ကြသည်- အရေအတွက်တူသည်ဆိုလျှင် နှစ်ယောက်စလုံး တူညီသည့်အရေအတွက်ယူထုတ်မည်။ တစ်ယောက်မှာပိုရှိလျှင် တစ်လုံး ပိုယူထုတ်ပြီး တစ်လုံးခြားနေသည့် အခြေအနေကို ထားရှိမည်။ တစ်ယောက်ဘဲ မယ်လ့်ဖွဲ့ရာမယ်လ့်ဖြစ်သွားလျှင် ငါးလုံးနှစ်လုံးယူထုတ်ပြီး တစ်ယောက်ကတော့ တစ်လုံးသာယူထုတ်မည်။ တစ်ယောက်အနေနဲ့ မယ်လ့်မဖြစ်လျှင် နှစ်ယောက်စလုံးမှ တစ်လုံးစီယူထုတ်မည်။';

  @override
  String get elfilja => 'အယ်ဖီလ်ဂျာ';

  @override
  String get tipSelectOwnPiece => 'သင့်ဂုတ်တစ်ခုကိုရွေးပါ။';

  @override
  String get notYourTurn => 'မင်းရဲ့အလှည့်မဟုတ်ပါ။';

  @override
  String get annotationToolbarBackgroundColor => 'မှတ်စုတန်းအရောင်';

  @override
  String get annotationToolbarIconColor => 'အိုင်ကွန်အရောင်';

  @override
  String get isAnnotationToolbarShown => 'မှတ်စုတန်းပြပါ';

  @override
  String get enterAnnotationMode => 'မှတ်စုမုဒ်သို့ဝင်ပါ';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'မှတ်စုအားလုံးဖျက်မှာသေချာလား?';

  @override
  String get llmPromptCopiedToClipboard => 'LLM စာသားကိုကလစ်ဘုတ်သို့ကူးယူပြီး။';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'ချိတ်ဆက်မှုကိုငြင်းပယ်လိုက်ပါသည်၊ ဆာဗာပိတ်ထားနိုင်သည်။';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'ရှာဖွေတွေ့ရှိပြီး၊ ချိတ်ဆက်မှုစောင့်ဆိုင်းနေသည်...';

  @override
  String get noLanConnection => 'LAN ချိတ်ဆက်မှုမရှိ';

  @override
  String get takeScreenshot => 'စခရင်ရှော့ရိုက်ပါ';

  @override
  String get disconnectedFromOpponent =>
      'ပြိုင်ဘက်နှင့်ချိတ်ဆက်မှုဖြတ်လိုက်ပြီ။';

  @override
  String get takeBackRequest => 'ပြန်လည်ရယူမှုတောင်းဆိုချက်';

  @override
  String get nothingToShow => 'ပြသစရာမရှိပါ။';

  @override
  String get stopHosting => 'အိမ်ရှင်လုပ်ခြင်းရပ်ပါ';

  @override
  String get connectionResetByPeer =>
      'အခြားအသုံးပြုသူမှချိတ်ဆက်မှုပြန်လည်စတင်သည်။';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'နှလုံးခုန်အချိန်ကုန်သွားပါသည်။ ကျေးဇူးပြု၍ပြန်ချိတ်ပါ။';

  @override
  String get startHosting => 'အိမ်ရှင်စတင်ပါ';

  @override
  String get restartRequestRejected => 'ပြန်စခိုင်းမှုကိုငြင်းပယ်လိုက်ပြီ။';

  @override
  String get notConnectedToLanOpponent => 'LAN ပြိုင်ဘက်နှင့်မချိတ်ဆက်ထားပါ။';

  @override
  String get llmPrompt => 'LLM စာသား';

  @override
  String get gameRestarted => 'ဂိမ်းပြန်စပြီး။';

  @override
  String get takeBackRejected => 'ပြန်လည်ရယူမှုငြင်းပယ်ခံရသည်။';

  @override
  String get areYouSureYouWantToResignThisGame => 'ဂိမ်းမှထွက်မှာသေချာလား?';

  @override
  String get opponentResignedYouWin => 'ပြိုင်ဘက်ထွက်သွားပြီ။ သင်နိုင်ပြီ!';

  @override
  String get clearAllAnnotations => 'မှတ်စုအားလုံးဖျက်ပါ';

  @override
  String get connectedWaitingForOpponentSMove =>
      'ချိတ်ဆက်ပြီး၊ ပြိုင်ဘက်လှုပ်ရှားမှုစောင့်နေသည်...';

  @override
  String get networkStatusDisconnected => 'နက်ဝက်အခြေအနေ: ချိတ်ဆက်မှုပြတ်';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'ပြန်လည်ရယူမှုတောင်းဆိုချက်ပြိုင်ဘက်ထံပို့ပြီး။';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'ပြိုင်ဘက်ဂိမ်းမှထွက်သွားနိုင်သည်';

  @override
  String get connectedToHostSuccessfully =>
      'အိမ်ရှင်နှင့်အောင်မြင်စွာချိတ်ဆက်ပြီး။';

  @override
  String get connectionLostHeartbeatTimeout =>
      'ချိတ်ဆက်မှုပြတ်: နှလုံးခုန်အချိန်ကုန်';

  @override
  String get noHostDiscovered => 'အိမ်ရှင်မတွေ့ပါ။';

  @override
  String get confirmResignation => 'ထွက်ခွာမှုအတည်ပြုပါ';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'အိမ်ရှင်စတင်ပြီး ကစားသမားများစောင့်ဆိုင်းနေသည်...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'ချိတ်ဆက်မှုအချိန်ကုန်၊ နက်ဝက်မတည်ငြိမ်။';

  @override
  String get noLlmPromptAvailable => 'LLM စာသားမရှိပါ။';

  @override
  String get youResignedGameOver => 'သင်ထွက်သွားပြီ။ ဂိမ်းပြီးပြီ။';

  @override
  String get serverIp => 'ဆာဗာလိပ်စာ';

  @override
  String get confirmClear => 'ဖျက်မှုအတည်ပြုပါ';

  @override
  String get opponentSTurn => 'ပြိုင်ဘက်အလှည့်။';

  @override
  String get waitingAClientConnection =>
      'ကလိုင်းယင့်ချိတ်ဆက်မှုစောင့်ဆိုင်းနေသည်...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'ပြန်လည်ရယူမှုတောင်းဆိုချက်ငြင်းခံရသို့မဟုတ်မအောင်မြင်။';

  @override
  String get addText => 'စာသားထည့်ပါ';

  @override
  String get exitAnnotationMode => 'မှတ်စုမုဒ်မှထွက်ပါ';

  @override
  String get typeYourAnnotation => 'မှတ်စုရိုက်ထည့်ပါ';

  @override
  String get attemptingToReconnect => 'ပြန်ချိတ်ဆက်ရန်ကြိုးစားနေသည်...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'ပြန်စခိုင်းမှုပို့ပြီး ပြိုင်ဘက်အကြောင်းပြန်စောင့်နေသည်...';

  @override
  String get serverIsStopped => 'ဆာဗာပိတ်ထားပြီ။';

  @override
  String get restartRequest => 'ပြန်စခိုင်းမှု';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'သင့်အလှည့်မဟုတ်လျှင် ပြန်လည်ရယူမှုမတောင်းဆိုနိုင်။';

  @override
  String get takeBackAccepted => 'ပြန်လည်ရယူမှုလက်ခံပြီး။';

  @override
  String get localNetworkSettings => 'ဒေသိယနက်ဝက်ချိန်ညှိချက်များ';

  @override
  String get reconnectedSuccessfully => 'ပြန်ချိတ်ဆက်အောင်မြင်ပြီး!';

  @override
  String get failedToSaveImageToGallery => 'ဓာတ်ပုံသိမ်းဆည်းရန်မအောင်မြင်။';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'ပြိုင်ဘက်ဂိမ်းပြန်စဖို့တောင်းဆို။ လက်ခံမလား?';

  @override
  String get yourTurn => 'သင့်အလှည့်။';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'ပြန်ချိတ်ဆက်မရ၊ ဂိမ်းပြန်စပါ။';

  @override
  String get host => 'အိမ်ရှင်';

  @override
  String get join => 'ပါဝင်သည်';

  @override
  String get port => 'ပို့';

  @override
  String get invalidIpAddress => 'မမှန်ကန်သောလိပ်စာ။';

  @override
  String get invalidPort => 'မမှန်ကန်သောပို့။';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'ချိတ်ဆက်နေသည်: $attempt/$maxAttempt ကြိုးစားမှု';
  }

  @override
  String failedToConnect(Object error) {
    return 'ချိတ်ဆက်မရ: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'အိမ်ရှင်စတင်မရ: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'အိမ်ရှင်တွေ့ရှိ: $ip:$port';
  }

  @override
  String get stop => 'ရပ်';

  @override
  String get discover => 'ရှာဖွေသည်';

  @override
  String get connect => 'ချိတ်ဆက်သည်';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'ကလိုင်းယင့်ချိတ်ဆက်: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'ရှာဖွေနေသည်: $seconds စက္ကန့်';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'ပြန်ချိတ်ဆက်နေသည် ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'ချိတ်ဆက်ပြီး';

  @override
  String get delete => 'ဖျက်';

  @override
  String get ancientEgypt => 'ရှေးဟောင်းအီဂျစ်';

  @override
  String get gothicIce => 'ဂိုသစ်ရေခဲ';

  @override
  String get riceField => 'စပါးခင်း';

  @override
  String get chinesePorcelain => 'တရုတ်ကြွေထည်';

  @override
  String get desertDusk => 'သဲကန္တာရညနေဝင်ချိန်';

  @override
  String get precisionCraft => 'တိကျသောလက်မှုပညာ';

  @override
  String get folkEmbroidery => 'ရိုးရာပန်းထိုး';

  @override
  String get carpathianHeritage => 'ကာပါသီယန်အမွေအနှစ်';

  @override
  String get imperialGrandeur => 'ဧကရာဇ်ခမ်းနားမှု';

  @override
  String get bohemianCrystal => 'ဘိုဟီးမီးယန်းပုံဆောင်ခဲ';

  @override
  String get savannaSunrise => 'ဆာဗားနားနေထွက်ချိန်';

  @override
  String get harmonyBalance => 'သဟဇာတနှင့်ဟန်ချက်';

  @override
  String get cinnamonSpice => 'သစ်ကြံ့ပင်း အမွှေးအကြိုင်';

  @override
  String get anatolianMosaic => 'အနာတိုလီယန်မိုဆိုင်း';

  @override
  String get carnivalSpirit => 'ကာနီဗယ်စိတ်ဓာတ်';

  @override
  String get custom => 'စိတ်ကြိုက်';

  @override
  String get spiceMarket => 'အမွှေးအကြိုင်ဈေး';

  @override
  String get swipeToRevealTheDrawer => 'ဧဖ်ဖွင့်ရန် လွှဲဆွဲပါ';

  @override
  String get showGameInfoOnScreenshots =>
      'ဂိမ်းအချက်အလက်များကို စခရင်ရှော့တွင် ပြပါ';

  @override
  String get humanMoveTime => 'လူ၏အချိန်ကန့်သတ်ချက်';

  @override
  String get noTimeLimitForHumanMoves =>
      'လူ့လှုပ်ရှားမှုများအတွက် အချိန်ကန့်သတ်ချက်မရှိပါ။';

  @override
  String get timeoutLoseWillBeApplied =>
      'လူသားကစားသမားအတွက် အချိန်ကုန်ဆုံးရှုံးမှု ကျင့်သုံးပါမည်။';

  @override
  String get identifyingBoard => 'ဂိမ်းဘုတ် ဖော်ထုတ်နေသည်...';

  @override
  String get youCanEnterAnyModelName => 'မည်သည့်မော်ဒယ်နာမည်မဆို ထည့်နိုင်သည်။';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'ဘုတ်အနေအထားတင်ပြီး။ FEN ကို ကလစ်ဘုတ်သို့ ကူးယူပြီး။';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'အကြံပြုချက် – ဘုတ်ကို ပိုရှင်းကောက်သော ဓါတ်ပုံတစ်ပုံ ရိုက်ကြည့်ပါ။';

  @override
  String get llmPromptTemplate => 'LLM အမိန့်ပုံစံ';

  @override
  String get noValidBoardDetected => 'သင့်လျော်သော ဘုတ်မတွေ့ပါ။';

  @override
  String get selectingImageFromAlbum => 'အယ်လ်ဘမ်မှ ပုံရွေးနေသည်...';

  @override
  String get configurePromptTemplate => 'အမိန့်ပုံစံ ကို သတ်မှတ်ပါ';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'LLM ကြည့်စစ်မှုပေးရန် အမိန့်ပုံစံကို ပြင်ဆင်ပါ';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'ဖော်ထုတ်ထားသည့် ဘုတ်မှ FEN ထုတ်မရပါ။';

  @override
  String get outputInCurrentLanguage => 'လက်ရှိဘာသာစကားဖြင့် ထုတ်လွှင့်ခြင်း';

  @override
  String get commonBaseUrls => 'နှစ်သက်အသုံးများသော Base URL များ';

  @override
  String get viewCommonModels => 'နှစ်သက်အသုံးများသော မော်ဒယ်များ ကြည့်ရှုရန်';

  @override
  String get recognitionParametersUpdated =>
      'အသိအမှတ်ပြု ပုဂ္ဂိုလ်ဉာဏ် အချက်အလက်များ ပြင်ဆင်ပြီး။';

  @override
  String get whiteSMove => 'အဖြူရဲ့လှည့်';

  @override
  String get resetToDefaults => 'သတ်မှတ်ค่ျပန်စစ်ပါ';

  @override
  String get photoShoot => 'ဓါတ်ပုံရိုက်ခြင်း';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'ဖော်ထုတ်ထားသည့် ဘုတ်အနေအထား အသုံးမပြုနိုင်ပါ။';

  @override
  String get llmPromptContent => 'LLM အမိန့်အား ပါဝင်မှု';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM မတပ်ဆင်ထားပါ။ သတ်မှတ်ချက်များ စစ်ဆေးပါ။';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'ပံ့ပိုးသူ၊ မော်ဒယ်၊ API Key နှင့် Base URL သတ်မှတ်ပါ';

  @override
  String get llmConfiguration => 'LLM ဆက်တင်များ';

  @override
  String get configureLlmProvider => 'LLM ပံ့ပိုးသူ ကို သတ်မှတ်ပါ';

  @override
  String get llmPromptTemplateHeader => 'LLM အမိန့်ပုံစံ ခေါင်းစီး';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'ပုံတွင် အပိုင်းကဏ္ဍမတွေ့ပါ။ ထပ်မံစမ်းကြည့်ပါ။';

  @override
  String get recognizeBoardFromImage => 'ပုံမှ ဂိမ်းဘုတ်ကို ဖော်ထုတ်ရန်';

  @override
  String get viewTips => 'အကြံပြုချက်များ ကြည့်ရန်';

  @override
  String get applyToBoard => 'ဘုတ်တွင်အသုံးပြုရန်';

  @override
  String get adjustBoardArea => 'ဘုတ်နေရာကို ကိုက်ညီအောင် ပြင်ဆင်ရန်';

  @override
  String get viewCommonUrls => 'နှစ်သက်အသုံးများသော URLs ကြည့်ရန်';

  @override
  String get colorAnalysisFailed => 'အရောင်ခွဲခြမ်းစိတ်ဖြာမှု မအောင်မြင်ပါ!';

  @override
  String get analyzingGameBoardImage =>
      'ဂိမ်းဘုတ် ပုံကို ခွဲခြမ်းစစ်ဆေးနေသည်...';

  @override
  String get selectFromAlbum => 'အယ်လ်ဘမ်မှ ရွေးပါ';

  @override
  String get noBoardPointDetected => 'ဘုတ်အမှတ် မတွေ့ပါ!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'လှည့်မည်ဆိုပါက၊ ပုံစံ မထည့်လျှင် ပုံစံ မူရင်းအသုံးမည်။';

  @override
  String get llmConfig => 'LLM ဆက်တင်';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'အမိန့်ပုံစံများကို မူရင်းတန်ဖိုးသို့ ပြန်သတ်မှတ်မှာ မရေးမလား?';

  @override
  String get llmPromptTemplateFooter => 'LLM အမိန့်ပုံစံ ခြစ်စည်း';

  @override
  String get loadingResponse => 'ဖြေကြားချက် ဒေါင်းလုပ်နေသည်...';

  @override
  String get applyThisResultToBoard => 'ဤရလဒ်ကို ဘုတ်တွင် သုံးရန်';

  @override
  String get takingPicture => 'ဓါတ်ပုံ ရိုက်ယူနေသည်...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'ဖော်ထုတ်ရန် ဂိမ်းဘုတ် ပုံ ရွေးပါ';

  @override
  String get identificationResults => 'ဖော်ထုတ်မှု ရလဒ်များ';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'လှည့်များကို ခွဲခြမ်းစစ်ဆေးပြီး အတွေးအမြင် ပေးပါ။';

  @override
  String get getApiKey => 'API Key ရယူရန်';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'ဖော်ထုတ်ခြင်း လုပ်ငန်းစဉ် အားလုံး မအောင်မြင်ပါ။';

  @override
  String get boardRecognitionResult => 'ဘုတ်ဖော်ထုတ်မှု ရလဒ်';

  @override
  String get askLlm => 'LLM ကို မေးမည်';

  @override
  String get boardDetectionFailed => 'ဘုတ် ဖော်ထုတ်ခြင်း မအောင်မြင်ပါ!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'ဘုတ်အမှတ် မတွေ့၊ အစိတ်အပိုင်း မသိနိုင်ပါ!';

  @override
  String get copyFen => 'FEN ကူးရန်';

  @override
  String get commonlyUsedModels => 'နှစ်သက်အသုံးများသော မော်ဒယ်များ';

  @override
  String get apiKeyOptional => 'API Key (ပ.optional)';

  @override
  String get noImageSelected => 'ပုံ မရွေးထားပါ';

  @override
  String get blackSMove => 'အမည်းရဲ့လှည့်';

  @override
  String get llm => 'အကြီးစားဘာသာစကားမော်ဒယ်';

  @override
  String get llmProvider => 'ပံ့ပိုးသူ';

  @override
  String get baseUrl => 'အခြေခံ URL';

  @override
  String get model => 'မော်ဒယ်';

  @override
  String get temperature => 'အပူချိန်';

  @override
  String get llmCommandReceivedProcessing =>
      'အမိန့်ရရှိပြီ! AI သည် ဆက်လက်လုပ်ဆောင်နေသည်...';

  @override
  String get llmDeepThinkingWait =>
      'နက်ရှိုင်းစွာ စဉ်းစားဆဲဖြစ်သဖြင့် ခဏစောင့်ပါ...';

  @override
  String get llmPresentingSoon => 'မကြာမီ တင်ပြမည်...';

  @override
  String get recognitionParameters => 'အသိမှတ်ပြုအချက်အလက်များ';

  @override
  String get adjustParamsDesc =>
      'အသိမှတ်ပြုမှုတိကျမှန်ကန်မှု တိုးမြှင့်ရန် ပါရာမီတာများကို ပြင်ဆင်ပါ';

  @override
  String get saveParameters => 'ပါရာမီတာများကို သိမ်းဆည်းပါ';

  @override
  String unableToStartImageRecognition(String error) {
    return 'ပုံအတိအကျသိမြင်ခြင်းကို စတင်နိုင်ခြင်းမရှိပါ: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'ပုံအတိအကျသိမြင်ခြင်း မအောင်မြင်ပါ: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return '$whiteCount ဖြူ နှင့် $blackCount မဲ အလုံးများ ပါဝင်သည့် တည်နေရာကို အသုံးပြုပြီးပါပြီ';
  }

  @override
  String get fenCopiedToClipboard => '(FEN ကို ကလစ်ဘုတ်သို့ ကူးထည့်ပြီးပါပြီ)';

  @override
  String recognitionFailed(String error) {
    return 'အသိမှတ်ပြုမှု မအောင်မြင်ပါ: $error';
  }

  @override
  String get myRating => 'ကျွန်ုပ်၏အဆင့်သတ်မှတ်ချက်';

  @override
  String get gamesPlayed => 'ကစားခဲ့သည့်ဂိမ်းများ';

  @override
  String get wins => 'နိုင်ပွဲ';

  @override
  String get losses => 'ရှုံးပွဲ';

  @override
  String get draws => 'သရေပွဲ';

  @override
  String get lastUpdated => 'နောက်ဆုံးအပ်ဒိတ်လုပ်ထားသည်';

  @override
  String get format => 'ပုံစံ:';

  @override
  String get resetStatistics => 'စာရင်းအင်းများ ပြန်လည်သတ်မှတ်ရန်';

  @override
  String get drawRate => 'သရေပွဲနှုန်း';

  @override
  String get lossRate => 'ရှုံးပွဲနှုန်း';

  @override
  String get aiStatistics => 'AI စာရင်းအင်းများ';

  @override
  String get enableStatistics => 'စာရင်းအင်းများ ဖွင့်ပါ';

  @override
  String get enableStatistics_Detail =>
      'ဖွင့်ထားသည့်အခါ ဂိမ်းရလဒ်များကို စာရင်းအင်းများတွင် မှတ်တမ်းတင်မည်ဖြစ်သည်။ သို့သော် နောက်ပြန်ဆုတ်ခြင်းပါဝင်သည့် ဂိမ်းများကို မှတ်တမ်းတင်မည်မဟုတ်ပါ။ ပိတ်ထားသည့်အခါ စာရင်းအင်းများစုဆောင်းခြင်းကို ခေတ္တရပ်ထားသည်။';

  @override
  String get thisWillResetAllGameStatistics =>
      '၎င်းသည် ဂိမ်းစာရင်းအင်းအားလုံးကို ပြန်လည်သတ်မှတ်မည်ဖြစ်သည်။ ဤလုပ်ဆောင်ချက်ကို ပြန်မပြင်နိုင်ပါ။';

  @override
  String get boardInnerRingSize => 'ဘုတ်အတွင်းကွင်းအရွယ်အစား';

  @override
  String get boardShadowEnabled => 'ဘုတ်အရိပ်';

  @override
  String get trapAwareness => 'လှောင်ချောက် အသိအမြင်';

  @override
  String get trapAwarenessDescription =>
      'ခွဲခြမ်းလေ့လာစဉ် လှောင်ချောက် လှုပ်ရှားမှုများကို စက်ဝိုင်းနှင့် မြားများကို ထင်ရှားအောင် ပြပါ.';

  @override
  String trapExists(String trapMoves) {
    return 'လှောင်ချောက် ရှိနေသည်။ လှောင်ချောက် လှုပ်ရှားမှုများ: $trapMoves';
  }

  @override
  String get custodianCapture => 'ဝိုင်းဖမ်းယူ';

  @override
  String get custodianCaptureDescription =>
      'သင်၏ပြိုင်ဘက်နှစ် ဦး အကြားသင်၏ပြိုင်ဘက်နှစ် ဦး အနေဖြင့်၎င်းကိုဖမ်းယူရန်ဖြောင့်သောမျဉ်းကြောင်းတစ်ခုအကြားသင်၏ပြိုင်ဘက်တစ် ဦး ကိုပူးတွဲပါ။';

  @override
  String get custodianCaptureEnable => 'ဝိုင်းဖမ်းယူမှုကို ခွင့်ပြုပါ';

  @override
  String get interventionCapture => 'ဝင်ရောက်စွက်ဖက်မှုဖမ်းယူခြင်း';

  @override
  String get interventionCaptureDescription =>
      'နှစ်ခုစလုံးကိုဖမ်းယူရန်သင်၏ပြိုင်ဘက်၏အပိုင်းပိုင်းနှစ်ခုအကြားအချည်းနှီးသောအချက်သို့ရွှေ့ပါ။';

  @override
  String get interventionCaptureEnable => 'ဝင်ရောက်စွက်ဖက်မှုဖမ်းယူခွင့်ပြုပါ';

  @override
  String get leapCapture => 'ခုန်ဖမ်းယူ';

  @override
  String get leapCaptureDescription =>
      'တစ် ဦး ကပ်လျက်ပြိုင်ဘက်တစ် ဦး ၏အပိုင်းအစအပေါ်ကျော်လွန်သောအချည်းနှီးသောအချက်များအပေါ်ခုန်ခြင်းဖြင့်ဖမ်းယူခြင်းဖြင့်ဖမ်းယူ။';

  @override
  String get leapCaptureEnable => 'ခုန်ဖမ်းယူခွင့်ပြုပါ';

  @override
  String get captureApplicableLines => 'သက်ဆိုင်သောလိုင်းများ';

  @override
  String get captureSquareEdges => 'စတုရန်းရဲ့အနားတလျှောက်';

  @override
  String get captureCrossLines =>
      'စတုရန်းကိုဖြတ်ကျော် orthogonal လိုင်းများတလျှောက်';

  @override
  String get captureDiagonalLines =>
      'ထောင့်ဖြတ်လိုင်းများတလျှောက်မှာစတုရန်းဖြတ်ကူး';

  @override
  String get captureExecutionPhases => 'Execution အဆင့်';

  @override
  String get capturePiecesCondition =>
      'ကျန်ရှိသောအပိုင်းအစများအပေါ်အခြေခံပြီးရွေ့လျားအဆင့်တွင်ရရှိနိုင်';

  @override
  String get capturePiecesConditionUnlimited => 'ကန့်သတ်ချက်မရှိပါ';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'သင့်တွင်သုံးခုသို့မဟုတ်နည်းပါးလာအပိုင်းပိုင်းရှိသည့်အခါရရှိနိုင်ပါသည်';
}
