// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Malay (`ms`).
class SMs extends S {
  SMs([String locale = 'ms']) : super(locale);

  @override
  String get appName => 'Kilang';

  @override
  String get welcome => 'Selamat datang';

  @override
  String get yes => 'Ya';

  @override
  String get no => 'Tidak';

  @override
  String get game => 'Permainan';

  @override
  String get humanVsAi => 'Manusia Vs. AI';

  @override
  String get humanVsHuman => 'Manusia Vs. Manusia';

  @override
  String get aiVsAi => 'AI Vs. AI';

  @override
  String get humanVsCloud => 'Manusia Vs. Awan';

  @override
  String get humanVsLAN => 'Manusia Vs. LAN';

  @override
  String get testViaLAN => 'Uji Melalui LAN';

  @override
  String get move => 'Bergerak';

  @override
  String get showMoveList => 'Pindahkan senarai';

  @override
  String get moveList => 'Pindahkan senarai';

  @override
  String get noGameRecord => 'Tiada catatan';

  @override
  String get ok => 'okey';

  @override
  String get confirm => 'Sahkan';

  @override
  String get cancel => 'Batal';

  @override
  String get tipSelectWrong => 'Pilih bahagian yang salah.';

  @override
  String get tipPlace => 'Letakkan kepingan anda.';

  @override
  String get tipBanPlace => 'Anda tidak boleh meletakkannya di sini.';

  @override
  String get tipPlaced => 'Anda meletakkan.';

  @override
  String get tipRemove => 'Keluarkan sekeping.';

  @override
  String get tipBanRemove => 'Anda tidak boleh mengeluarkannya.';

  @override
  String get tipRemoved => 'Anda mengalih keluar.';

  @override
  String get tipMove => 'Pindahkan sehelai.';

  @override
  String get tipCannotPlace =>
      'Anda tidak boleh meletakkan barang anda di sini.';

  @override
  String get tipCannotMove =>
      'Anda tidak boleh memindahkan barang anda di sini.';

  @override
  String get tipMill => 'Kilang! Ambil bahagian lawan anda.';

  @override
  String get tipContinueMill => 'Terus ambil bahagian lawan anda.';

  @override
  String get tipSelectOpponentsPiece => 'Pilih salah satu bahagian lawan anda.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Anda tidak boleh mengeluarkan sekeping dari kilang.';

  @override
  String get tipCanMoveOnePoint => 'Sekeping boleh bergerak 1 mata.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Anda tidak boleh menggerakkan potongan lawan.';

  @override
  String get tipSelectPieceToMove => 'Pilih bahagian anda untuk bergerak.';

  @override
  String get tipHaveThreePiecesLeft => 'Anda tinggal tiga keping lagi.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Anda boleh bergerak ke mana-mana tempat yang anda suka.';

  @override
  String tipToMove(Object player) {
    return '$player untuk bergerak.';
  }

  @override
  String get whiteWin => 'Pemain 1 menang!';

  @override
  String get blackWin => 'Pemain 2 menang!';

  @override
  String get won => 'Menang';

  @override
  String get lost => 'Kalah';

  @override
  String get thinking => 'Berfikir…';

  @override
  String get newGame => 'Permainan baru';

  @override
  String get importGame => 'Permainan import';

  @override
  String get exportGame => 'Eksport permainan';

  @override
  String get gameImported => 'Permainan diimport.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Tidak boleh mengimport $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Pergerakan dan peraturan tidak sepadan.';

  @override
  String get pleaseWait => 'Sila tunggu.';

  @override
  String get restartGame => 'Mulakan semula permainan semasa?';

  @override
  String get restart => 'Mula semula';

  @override
  String get gameStarted => 'Permainan dimulakan, sila letakkan.';

  @override
  String get analyzing => 'Menganalisis…';

  @override
  String error(Object message) {
    return 'Ralat: $message';
  }

  @override
  String get winRate => 'Kadar Menang';

  @override
  String get score => 'Markah:';

  @override
  String get white => 'Pemain 1';

  @override
  String get black => 'Pemain 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player kiraan sekeping kurang daripada tiga.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player meletak jawatan.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player tiada jalan lagi.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Papan itu penuh, dan $player tiada jalan lagi.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Masa telah tamat, $player hilang.';
  }

  @override
  String get drawReasonRule50 =>
      'Dalam fasa bergerak, tidak ada potongan yang dikeluarkan dalam jumlah pergerakan tertentu yang terakhir.';

  @override
  String get drawReasonBoardIsFull =>
      'Ia adalah Cabutan kerana papannya penuh.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Ia adalah Cabutan kerana pengulangan tiga kali ganda.';

  @override
  String get gameOverUnknownReason => 'Permainan tamat! Sebab tidak diketahui.';

  @override
  String get gameOver => 'Permainan tamat';

  @override
  String get youWin => 'Awak menang! Tahniah!';

  @override
  String challengeHarderLevel(int level) {
    return 'Cabar tahap yang lebih sukar? Tahap baharu ialah tahap $level!';
  }

  @override
  String get youLose => 'Awak kalah!';

  @override
  String get analyze => 'Menganalisis';

  @override
  String get about => 'Mengenai';

  @override
  String version(Object versionNumber) {
    return 'Versi: $versionNumber';
  }

  @override
  String get thanks => 'Terima kasih';

  @override
  String get settings => 'Tetapan';

  @override
  String get options => 'Pilihan';

  @override
  String get generalSettings => 'Tetapan umum';

  @override
  String get skillLevel => 'Tahap kesukaran';

  @override
  String get moveTime => 'Masa berfikir AI';

  @override
  String get difficulty => 'Kesukaran';

  @override
  String get playSounds => 'Kesan bunyi';

  @override
  String get playSoundsInTheGame => 'Mainkan suara dalam permainan';

  @override
  String get keepMuteWhenTakingBack => 'Tetap bisu semasa mengambil semula';

  @override
  String get tone => 'Nada';

  @override
  String get whoMovesFirst => 'Langkah pertama';

  @override
  String get human => 'Manusia';

  @override
  String get ai => 'AI';

  @override
  String get alternate => 'Alternatif';

  @override
  String get isAutoRestart =>
      'Mulakan semula permainan secara automatik apabila permainan tamat';

  @override
  String get isAutoChangeFirstMove => 'Tukar Auto Langkah Pertama';

  @override
  String get shufflingEnabled => 'Pergerakan secara rawak';

  @override
  String get misc => 'Pelbagai';

  @override
  String get rules => 'Peraturan';

  @override
  String get piecesCount => 'Bilangan keping yang dimiliki oleh setiap pemain';

  @override
  String get piecesCount_Detail =>
      'Berapakah jumlah kepingan yang dimiliki oleh setiap pemain?';

  @override
  String get flyPieceCount => 'Bilangan kepingan terbang';

  @override
  String get flyPieceCount_Detail =>
      'Sekiranya Flying diaktifkan, apabila pemain dikurangkan menjadi jumlah potongan tertentu, potongannya bebas bergerak ke titik yang tidak dihuni dan bukannya dibatasi ke titik bersebelahan seperti di sepanjang permainan.';

  @override
  String get piecesAtLeastCount => 'Sekeping Paling Sedikit';

  @override
  String get hasDiagonalLines => 'Garisan pepenjuru';

  @override
  String get hasDiagonalLines_Detail =>
      'Tambahkan empat garis pepenjuru ke papan.';

  @override
  String get isDefenderMoveFirst => 'Pemain kedua bergerak terlebih dahulu';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Pemain yang bergerak kedua dalam fasa meletakkan bergerak pertama dalam fasa bergerak.';

  @override
  String get mayRemoveMultiple => 'Pembuangan berbilang';

  @override
  String get mayRemoveMultiple_Detail =>
      'Sekiranya pemain menutup lebih dari satu kilang sekaligus, dia akan membuang jumlah kilang yang ditutupnya.';

  @override
  String get mayRemoveFromMillsAlways => 'Hancurkan kilang';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Secara lalai, pemain mesti mengeluarkan kepingan lain terlebih dahulu sebelum mengeluarkan sekeping dari kilang yang dibentuk. Aktifkan pilihan ini untuk melumpuhkan had.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Pemain kedua kalah apabila papan penuh';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Apabila papan penuh pada akhir fasa penempatan, bahagian yang meletakkan pertama akan kehilangan permainan. Jika tidak, permainan ini seri.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Kalah apabila tiada pergerakan undang-undang';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Pemain akan kalah jika lawannya menyekat mereka sehingga mereka tidak dapat dipindahkan. Tukar sebelah untuk bergerak jika pilihan ini dilumpuhkan.';

  @override
  String get mayFly => 'Terbang';

  @override
  String get mayFly_Detail =>
      'Sekiranya pemain hanya tinggal tiga atau empat keping (dapat dikonfigurasi), dia boleh memindahkannya ke titik bebas.';

  @override
  String get nMoveRule => 'Peraturan N-bergerak';

  @override
  String get nMoveRule_Detail =>
      'Permainan ditarik jika tidak ada penyingkiran dalam jumlah gerakan tertentu.';

  @override
  String get rollback => 'Kembalikan';

  @override
  String get pleaseSelect => 'Sila pilih';

  @override
  String get copy => 'Salinan';

  @override
  String get moveHistoryCopied =>
      'Pindahkan sejarah yang disalin ke papan keratan.';

  @override
  String get help => 'Tolonglah';

  @override
  String get feedback => 'Maklum balas';

  @override
  String get exit => 'Keluar';

  @override
  String get ruleSettings => 'Peraturan';

  @override
  String get color => 'Warna';

  @override
  String get boardColor => 'Warna papan';

  @override
  String get pieceColor => 'Warna kepingan';

  @override
  String get backgroundColor => 'Warna latar belakang';

  @override
  String get lineColor => 'Warna garis papan';

  @override
  String get whitePieceColor => 'Pemain 1 keping warna';

  @override
  String get blackPieceColor => 'Pemain 2 keping warna';

  @override
  String get messageColor => 'Warna mesej';

  @override
  String get isPieceCountInHandShown => 'Tunjukkan jumlah kepingan di tangan';

  @override
  String get isNotationsShown => 'Tunjukkan notasi di atas kapal';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Tunjukkan bar alat navigasi sejarah';

  @override
  String get display => 'Paparan';

  @override
  String get boardBorderLineWidth => 'Lebar sempadan papan';

  @override
  String get boardInnerLineWidth => 'Lebar garis dalaman papan';

  @override
  String get pieceWidth => 'Lebar kepingan';

  @override
  String get fontSize => 'Saiz huruf';

  @override
  String get standardNotation => 'Notasi WMD';

  @override
  String get restore => 'Pulihkan';

  @override
  String get restoreDefaultSettings => 'Pulihkan tetapan lalai';

  @override
  String pick(Object element) {
    return 'Pilih $element';
  }

  @override
  String get info => 'Maklumat';

  @override
  String get hint => 'Petunjuk';

  @override
  String get player => 'pemain';

  @override
  String get player1 => 'Pemain 1';

  @override
  String get player2 => 'Pemain 2';

  @override
  String get howToPlay => 'Cara bermain';

  @override
  String get toPlacePiece =>
      'Ketuk mana-mana titik yang ada untuk meletakkan potongan itu.';

  @override
  String get toSelectPiece => 'Ketuk sekeping untuk memindahkannya.';

  @override
  String get toMovePiece =>
      'Ketuk titik yang disambungkan ke sekeping untuk menggerakkannya.';

  @override
  String get toRemovePiece => 'Ketuk satu bahagian lawan untuk dikeluarkan.';

  @override
  String get needToCreateMillFirst =>
      'Anda perlu membuat kilang terlebih dahulu sebelum dapat mengeluarkan sekepingnya.';

  @override
  String get needToPlayWithOwnPieces =>
      'Anda perlu bermain dengan kepingan anda.';

  @override
  String get statistics => 'Statistik';

  @override
  String get totalGames => 'Jumlah permainan';

  @override
  String get results => 'Keputusan';

  @override
  String get left => 'dibiarkan';

  @override
  String get privacyPolicy => 'Dasar Privasi';

  @override
  String get privacyPolicy_Detail_1 =>
      'Sila baca dengan teliti dan pastikan anda memahami dan menyetujuinya sepenuhnya ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Sekiranya anda tidak bersetuju dengan Dasar ini, jangan gunakan aplikasi ini. Menggunakan aplikasi menunjukkan bahawa anda menerima syarat ini.';

  @override
  String get and => ' dan ';

  @override
  String get accept => 'Terima';

  @override
  String get takeBack => 'Ambil semula';

  @override
  String get takingBack => 'Mengambil kembali…';

  @override
  String get waiting => 'Menunggu…';

  @override
  String get stepForward => 'Melangkah ke hadapan';

  @override
  String get takeBackAll => 'Kembalikan semua';

  @override
  String get stepForwardAll => 'Melangkah ke hadapan semua';

  @override
  String get moveNow => 'Bergerak sekarang';

  @override
  String get done => 'Selesai.';

  @override
  String get crackMill => 'Kilang retak';

  @override
  String get crackMill_Detail =>
      'Sekiranya pemain hanya mempunyai kepingan di kilang, kepingan di kilang tidak akan terkunci untuk dikeluarkan.';

  @override
  String get animationDuration => 'Tempoh animasi';

  @override
  String get none => 'Tiada';

  @override
  String get theme => 'Tema';

  @override
  String get helpContent =>
      'Permainan ini bertujuan untuk membiarkan lawan dengan kurang dari tiga keping atau tidak ada gerakan yang sah.\n\nPermainan akan menarik secara automatik jika kedudukan berlaku untuk kali ketiga atau tidak membuat penyingkiran dalam gerakan 100 terakhir (dikonfigurasi).\n\nPermainan ini berjalan dalam tiga fasa:\n\n1. Letakkan kepingan pada titik kosong\n2. Memindahkan kepingan ke titik bersebelahan\n3. (fasa pilihan) Memindahkan kepingan ke titik kosong semasa mengurangkan pemain menjadi tiga keping\n\nMeletak\n\nPermainan dimulakan dengan papan kosong, yang terdiri daripada grid dengan dua puluh empat mata. Pemain bergilir-gilir meletakkan kepingan mereka pada titik kosong sehingga setiap pemain meletakkan semua kepingan di papan. Sekiranya pemain boleh meletakkan tiga kepingannya secara lurus, dia mempunyai \"kilang\" dan boleh mengeluarkan salah satu kepingan lawannya dari papan.\n\nDalam beberapa peraturan, pemain mesti membuang kepingan lain terlebih dahulu sebelum mengeluarkan sekeping dari kilang yang dibentuk.\n\nAnda tidak boleh meletakkan kepingan ke titik kepingan yang dikeluarkan lagi dalam fasa meletakkan dalam beberapa peraturan.\n\nSetelah menggunakan semua kepingan, pemain bergilir-gilir bergerak.\n\nBergerak\n\nUntuk bergerak, pemain menggerakkan salah satu kepingannya di sepanjang garis papan ke titik bersebelahan yang kosong. Sekiranya dia tidak dapat melakukannya, dia akan kalah. Seorang pemain yang meluruskan tiga kepingannya pada garisan papan mempunyai kilang dan boleh mengeluarkan salah satu kepingan lawannya seperti dalam fasa meletakkan. Mana-mana pemain mengurangkan kepada dua bahagian, tidak mempunyai pilihan untuk membentuk kilang baru, dan dengan itu kehilangan permainan. Seorang pemain juga boleh kalah apabila lebih dari tiga keping jika lawannya menghalangnya daripada bergerak.\n\nTerbang\n\nDalam beberapa varian peraturan, setelah pemain hanya memiliki tiga keping yang tersisa, potongannya dapat terbang, melompat, atau melompat ke titik kosong, bukan hanya yang berdekatan.';

  @override
  String get versionInfo => 'Maklumat versi';

  @override
  String get eula => 'EULA';

  @override
  String get license => 'Lesen';

  @override
  String get sourceCode => 'Kod sumber';

  @override
  String get appVersion => 'Versi Aplikasi';

  @override
  String get general => 'Am';

  @override
  String get advanced => 'Mahir';

  @override
  String get placing => 'Meletak';

  @override
  String get moving => 'Bergerak';

  @override
  String get removing => 'Mengeluarkan';

  @override
  String get gameOverCondition => 'Permainan melebihi keadaan';

  @override
  String get aisPlayStyle => 'Gaya permainan AI';

  @override
  String get passive => 'Pasif';

  @override
  String get timeout => 'Masa tamat';

  @override
  String get appearance => 'Penampilan';

  @override
  String get drawOnHumanExperience => 'Ikuti pengalaman manusia';

  @override
  String get considerMobility => 'Pertimbangkan mobiliti kepingan';

  @override
  String get pieceCount => 'Kiraan kepingan:';

  @override
  String inHand(Object player, int count) {
    return '$player di tangan: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player di atas kapal: $count';
  }

  @override
  String get boardTop => 'Papan mengimbangi dari atas';

  @override
  String get notAIsTurn => 'Ini bukan giliran AI.';

  @override
  String get aiIsNotThinking => 'AI tidak berfikir.';

  @override
  String get atEnd => 'Anda berada di akhir senarai pindah.';

  @override
  String get tapBackAgainToLeave => 'Ketik kembali sekali lagi untuk pergi.';

  @override
  String get more => 'Lebih banyak lagi';

  @override
  String get experimental => 'Ini adalah ciri eksperimen.';

  @override
  String get experiments => 'Eksperimen';

  @override
  String get ossLicenses => 'Lesen sumber terbuka';

  @override
  String get language => 'Bahasa';

  @override
  String get defaultLanguage => 'Bahasa lalai';

  @override
  String get mayMoveInPlacingPhase =>
      'Potongan boleh bergerak dalam fasa penempatan';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Tidak ada fasa penempatan dan pemindahan yang berbeza, iaitu, pemain dapat memutuskan pada setiap gerakan sama ada mereka ingin meletakkan sekeping di papan atau memindahkan salah satu kepingan mereka (selagi mereka mempunyai potongan yang tersisa).';

  @override
  String get drawerColor => 'Warna menu';

  @override
  String get drawerTextColor => 'Warna teks menu';

  @override
  String get drawerHighlightItemColor => 'Warna item highlight menu';

  @override
  String get mainToolbarBackgroundColor => 'Warna latar bar alat utama';

  @override
  String get mainToolbarIconColor => 'Warna ikon bar alat utama';

  @override
  String get navigationToolbarBackgroundColor =>
      'Warna latar bar alat navigasi';

  @override
  String get navigationToolbarIconColor => 'Warna ikon bar alat navigasi';

  @override
  String get autoHideToolbar => 'Sembunyikan bar alat secara automatik';

  @override
  String get toolbarLocationOnScreen => 'Lokasi bar alat di skrin';

  @override
  String get top => 'Atas';

  @override
  String get bottom => 'Bawah';

  @override
  String get center => 'Pusat';

  @override
  String get solidColor => 'Warna pepejal';

  @override
  String get picture => 'Gambar';

  @override
  String get chooseYourPicture => 'Pilih gambar anda';

  @override
  String get light => 'Cahaya';

  @override
  String get dark => 'Gelap';

  @override
  String get themes => 'Tema';

  @override
  String get currentTheme => 'Tema semasa';

  @override
  String get saveTheme => 'Simpan tema';

  @override
  String get showAnalysisGraph => 'Tunjukkan grafik analisis';

  @override
  String get analysis => 'Analisis';

  @override
  String get saveGame => 'Simpan permainan';

  @override
  String get loadGame => 'Muatkan permainan';

  @override
  String get setupPosition => 'Kedudukan persediaan';

  @override
  String get showLegalMoves => 'Tunjukkan langkah undang-undang';

  @override
  String get showLastMove => 'Tunjukkan langkah terakhir';

  @override
  String get showArrows => 'Tunjukkan anak panah';

  @override
  String get pieces => 'Kepingan';

  @override
  String get showAnalysis => 'Tunjukkan analisis';

  @override
  String get threads => 'Benang';

  @override
  String get getInvolved => 'Melibatkan diri';

  @override
  String get helpImproveTranslate => 'Bantu meningkatkan terjemahan';

  @override
  String get tutorial => 'Tutorial';

  @override
  String get classicMill => 'Kilang Klasik';

  @override
  String get mixedMill => 'Kilang Campuran';

  @override
  String get ceylonMill => 'Kilang Ceylon';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Kilang boleh rosak dan dibuat semula berulang kali';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Sekiranya pemain memecahkan kilang untuk membuat kilang baru dengan segera, pemain tersebut dapat menggerakkan sekeping itu kembali ke persimpangan asal pada langkah seterusnya jika ia membuat kilang baru.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Permainan digambar jika pemain mempunyai tiga keping dan setelah sepuluh gerakan tidak ada pemain yang mengeluarkan potongan lawan';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Apabila pemain turun menjadi tiga keping, dan tidak ada pemain yang dapat melepaskan potongan lawan dalam sepuluh gerakan, permainan adalah seri.';

  @override
  String get close => 'Tutup';

  @override
  String get whitePiece => 'Kepingan putih';

  @override
  String get blackPiece => 'Sekeping hitam';

  @override
  String get emptyPoint => 'Titik kosong';

  @override
  String get noPoint => 'Tidak ada gunanya';

  @override
  String get placingPhase => 'Fasa meletakkan';

  @override
  String get movingPhase => 'Fasa bergerak';

  @override
  String get flyingPhase => 'Fasa terbang';

  @override
  String sideToMove(Object player) {
    return 'Sisi untuk digerakkan: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Pergerakan terakhir: $move';
  }

  @override
  String get selected => 'Terpilih';

  @override
  String get accessibility => 'Kebolehcapaian';

  @override
  String get screenReaderSupport => 'Sokongan pembaca skrin';

  @override
  String get isDraw => 'Ia adalah Cabutan!';

  @override
  String get draw => 'Lukis';

  @override
  String get pieceHighlightColor => 'Warna kemuncak kepingan';

  @override
  String get algorithm => 'Algoritma';

  @override
  String get endgameNMoveRule => 'Peraturan Endgame N-Move';

  @override
  String get endgameNMoveRule_Detail =>
      'Sekiranya mana-mana pemain hanya mempunyai tiga keping dan tidak ada pemain yang mengeluarkan satu bahagian dalam gerakan tertentu, permainan akan ditarik.';

  @override
  String get drawReasonEndgameRule50 =>
      'Sama ada pemain hanya mempunyai tiga keping dan kedua-dua pemain tidak melepaskan satu bahagian dalam gerakan tertentu.';

  @override
  String get threefoldRepetitionRule => 'Peraturan pengulangan tiga kali ganda';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Permainan dilukis sekiranya kedudukan berlaku untuk kali ketiga.';

  @override
  String get continueToMakeMove => 'Kilang! Terus bergerak.';

  @override
  String get pointStyle => 'Gaya titik';

  @override
  String get pointWidth => 'Lebar titik';

  @override
  String get solid => 'Padu';

  @override
  String get hollow => 'Berongga';

  @override
  String get languageName => 'Melayu';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Bergerak',
      one: '$count Bergerak',
      zero: 'Bergerak',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Muatan gagal.';

  @override
  String get filename => 'Nama fail';

  @override
  String get browse => 'Semak imbas…';

  @override
  String get gameFiles => 'Fail permainan';

  @override
  String get gameSavedTo => 'Permainan disimpan ke';

  @override
  String get empty => 'kosong';

  @override
  String get noMove => 'Tidak bergerak.';

  @override
  String get restoredPosition => 'Kedudukan awal dipulihkan.';

  @override
  String get clean => 'Bersih';

  @override
  String get cleanedUp => 'Dibersihkan.';

  @override
  String get remove => 'Alih keluar';

  @override
  String get noPiecesCanBeRemoved => 'Tiada kepingan boleh dikeluarkan.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count pieces',
      one: '$count piece',
      zero: 'Piece',
    );
    return '$_temp0 perlu dialih keluar.';
  }

  @override
  String placedCount(int count) {
    return 'Diletakkan ($count)';
  }

  @override
  String get placedPieceCount =>
      'Kiraan kepingan diletakkan dalam fasa meletakkan.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Pemain semasa telah meletakkan kepingan $count.';
  }

  @override
  String get notPlacingPhase =>
      'Tidak meletakkan fasa, tidak boleh mengubahnya.';

  @override
  String get paste => 'tampal';

  @override
  String get pasteDone => 'Pastu dah siap.';

  @override
  String get cannotPaste => 'Tidak boleh tampal.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Tunjukkan kepingan yang tidak diletakkan dan dialih keluar';

  @override
  String get fullScreen => 'Skrin penuh';

  @override
  String get reopenToTakeEffect =>
      'Keluar dan buka semula apl untuk tetapan berkuat kuasa.';

  @override
  String get forest => 'Hutan';

  @override
  String get desktopImage => 'Imej Desktop';

  @override
  String get invalidPosition => 'Kedudukan tidak sah.';

  @override
  String get shareGIF => 'Kongsi GIF';

  @override
  String get pixelRatio => 'Nisbah piksel';

  @override
  String get duration => 'Tempoh';

  @override
  String get gameScreenRecorder => 'Perakam skrin permainan';

  @override
  String get previous => 'Sebelumnya';

  @override
  String get next => 'Seterusnya';

  @override
  String get skip => 'Langkau';

  @override
  String get gotIt => 'faham';

  @override
  String get youCanModifyRules =>
      'Anda boleh mengubah suai peraturan permainan dalam tetapan peraturan.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Anda boleh menggunakan roda tetikus untuk menukar nilai dalam pemilih.';

  @override
  String get noTimeLimitForThinking =>
      'Masa AI Thinking ditetapkan kepada 0 bermakna tiada had masa untuk berfikir.';

  @override
  String get whatIsMtdf =>
      'MTD(f) ialah bentuk algoritma carian alfa-beta yang diubah suai yang bertujuan untuk meningkatkan kecekapan dengan menggunakan semula hasil carian perantaraan dan menggunakan tekaan awal yang baik untuk mengecilkan ruang carian.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Harap maklum bahawa pelarasan masa pemikiran AI mungkin tidak tepat sepenuhnya. Masa pemikiran sebenar mungkin lebih pendek apabila tahap kesukaran ditetapkan kepada nilai yang lebih rendah dan mungkin lebih lama apabila AI sedang difikirkan apabila masa tamat.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Jika anda menetapkan tahap kesukaran tinggi tetapi tidak meningkatkan masa berfikir AI, tahap kesukaran sebenar mungkin dihadkan kepada nilai yang lebih rendah kerana kekangan masa berfikir. Nilai sebenar mungkin berbeza-beza berdasarkan prestasi mesin.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) ialah algoritma carian untuk mencari langkah terbaik dalam kedudukan tertentu. Ia adalah peningkatan algoritma alfa-beta dan menggunakan carian tetingkap nol atau sifar untuk mengesahkan bahawa satu langkah adalah lebih teruk atau tidak lebih teruk daripada skor yang sudah selamat daripada variasi utama. PVS memfokuskan pada langkah yang paling menjanjikan dan mengelakkan carian yang tidak perlu bagi cawangan suboptimum, yang membantu meningkatkan kecekapan carian.';

  @override
  String get whatIsAlphaBeta =>
      'Algoritma alfa-beta ialah algoritma carian untuk mencari langkah terbaik. Ia menggunakan prinsip minimax dan dua nilai, alfa dan beta, untuk memangkas pokok carian dan meningkatkan kecekapan. Alfa mewakili skor minimum yang komputer pasti boleh perolehi, manakala beta mewakili skor maksimum yang boleh diperolehi oleh lawannya. Algoritma membantu komputer membuat keputusan yang bijak dan cekap dalam permainan.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Mengikut pengalaman manusia, jika anda cuba untuk menang, anda akan kalah. Sebaliknya, sasarkan untuk seri sebagai matlamat anda dan elakkan kalah dalam permainan. Perhatikan lawan anda dan perlahan-lahan tarik mereka ke posisi di mana mereka mungkin membuat kesilapan. Apabila mereka menunjukkan kelemahan, rebut peluang dan tolak perlahan-lahan untuk menang. Dengan cara ini, anda boleh memenangi permainan.';

  @override
  String get firstMoveDetail =>
      'Dalam permainan ini, lebih mudah untuk pemain kedua untuk menang berbanding dengan pemain pertama.';

  @override
  String get passiveDetail =>
      'Mendayakan pilihan Pasif akan menyebabkan AI berehat apabila ia mempunyai kelebihan dalam kedudukan, dan bukannya cuba secara agresif untuk menang secepat mungkin.';

  @override
  String get moveRandomlyDetail =>
      'Mendayakan pilihan ini meningkatkan rawak dan keseronokan permainan sambil melumpuhkannya boleh membantu mengkaji cara untuk mengalahkan AI.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Jika AI mempertimbangkan mobiliti kepingannya, ia bukan sahaja bertujuan untuk menangkap kepingan lawan secepat mungkin, tetapi juga mempertimbangkan untuk menyekat pergerakan lawan dan menghalang mereka daripada melakukan perkara yang sama.';

  @override
  String get whenBoardIsFull => 'Apabila papan penuh';

  @override
  String get whenBoardIsFull_Detail =>
      'Pada akhir fasa meletakkan, sebelum fasa bergerak bermula, tindakan akan menyusul jika papan penuh dengan kepingan.';

  @override
  String get sideToMoveRemovePiece =>
      'Pemain yang bergerak terlebih dahulu dalam fasa bergerak mengeluarkan salah satu kepingan pihak lawan.';

  @override
  String get agreeToDraw => 'Kedua-dua pihak bersetuju untuk seri.';

  @override
  String get takeOpponentsPiece => 'Ambil salah satu bahagian lawan anda.';

  @override
  String get firstPlayerLose => 'Pemain pertama kalah dalam permainan.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Pemain pertama dan kedua mengeluarkan salah satu kepingan lawan.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Pemain kedua dan pertama mengeluarkan salah satu kepingan lawan.';

  @override
  String get enteredFlyingPhase =>
      'Kini memasuki fasa terbang, kepingan lawan boleh melompat ke mana-mana titik kosong di papan. Anda boleh mematikan peraturan terbang dalam \"Tetapan Peraturan\".';

  @override
  String get whenStalemate => 'Apabila kebuntuan';

  @override
  String get whenStalemate_Detail =>
      'Apakah tindakan yang berlaku apabila tiada kepingan boleh digerakkan?';

  @override
  String get endWithStalemateLoss => 'Berakhir dengan kekalahan yang buntu.';

  @override
  String get changeSideToMove => 'Tukar sisi untuk bergerak.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Keluarkan salah satu kepingan lawan dan buat langkah seterusnya.';

  @override
  String get endWithStalemateDraw => 'Diakhiri dengan keputusan seri.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Keluarkan salah satu bahagian lawan dan tukar bahagian tepi untuk bergerak.';

  @override
  String get aiResponseDelayTime => 'Masa kelewatan tindak balas AI';

  @override
  String get aiIsDelaying =>
      'AI kini dalam fasa respons tertunda. Sila tunggu sebentar sebelum meneruskan.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Anda tidak boleh mengeluarkan bahagian yang tidak bersebelahan.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Jika kebuntuan, kepingan lawan yang bersebelahan dengan anda boleh dikeluarkan, tanpa mengira pembentukan kilang.';

  @override
  String get whatIsMcts =>
      'MCTS ialah algoritma mesra pemula yang membuat keputusan dengan meneroka dan menilai pergerakan berbeza melalui simulasi.';

  @override
  String get goldenJade => 'Jade Emas';

  @override
  String get forestWood => 'Kayu Hutan';

  @override
  String get darkMystery => 'Misteri Gelap';

  @override
  String get midnightBlue => 'Biru Tengah Malam';

  @override
  String get greenForest => 'Hutan Hijau';

  @override
  String get greenMeadow => 'Padang Rumput Hijau';

  @override
  String get stonyPath => 'Laluan Berbatu';

  @override
  String get pastelPink => 'Merah Jambu Pastel';

  @override
  String get turquoiseSea => 'Laut Turquoise';

  @override
  String get violetDream => 'Mimpi Violet';

  @override
  String get mintChocolate => 'Coklat Pudina';

  @override
  String get skyBlue => 'Biru Langit';

  @override
  String get playfulGarden => 'Taman yang suka bermain';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Algoritma Analisis Retrogred menggunakan analisis retrogred berbilang nilai untuk membina pangkalan data permainan akhir daripada kedudukan permulaan yang berbeza, kemudian menggunakan pangkalan data ini untuk mengoptimumkan permainan. Pendekatan ini termasuk dalam kategori penyelesaian Ultra-Kuat.';

  @override
  String get viewAlgorithmGuide =>
      'Adakah anda ingin melihat panduan pengguna untuk algoritma ini?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Tunjukkan penunjuk kelebihan kedudukan';

  @override
  String get usePerfectDatabase => 'Gunakan pangkalan data yang sempurna';

  @override
  String get perfectDatabaseDescription =>
      'Dayakan pilihan ini untuk menggunakan pangkalan data permainan yang sempurna yang dijana melalui algoritma canggih. Ciri ini menyepadukan kedua-dua strategi pembukaan dan akhir permainan untuk mencadangkan pergerakan yang optimum. Ini adalah pilihan pilihan untuk pemain yang mencari tahap ketepatan tertinggi dalam permainan. Dicipta melalui teknik pengiraan yang teliti, pangkalan data direka untuk menawarkan penyelesaian permainan yang hampir sempurna.\n\nNota: Sekiranya AI gagal mengakses pangkalan data, ia akan beralih kepada algoritma konvensional untuk keputusan permainan. Apabila pangkalan data tersedia, \'Tahap Kesukaran\' menjadi hampir tiada tandingan, dan \'Masa Pemikiran AI\' mengalami pengurangan drastik. Banyak tetapan dalam pilihan \'AI\'s play style\' akan ditindih, kerana hasil pangkalan data memegang keutamaan tertinggi.\n\nUntuk panduan tentang cara memanfaatkan sepenuhnya pangkalan data yang sempurna ini, klik di sini.';

  @override
  String get backgroundImage => 'Imej latar belakang';

  @override
  String get whatIsRandom =>
      'Apabila pilihan \'Gunakan pangkalan data yang sempurna\' tidak didayakan, tetapan \'Rawak\' menyebabkan AI mengalihkan kepingan secara rawak tanpa menggunakan sebarang algoritma untuk pemilihan pergerakan. Ini biasanya menghasilkan permainan yang jauh lebih lemah. Sebaliknya, apabila \'Gunakan pangkalan data yang sempurna\' didayakan, AI secara eksklusif bergantung pada \'Pangkalan Data Sempurna\' untuk membuat keputusan, dan bukannya menggabungkannya dengan algoritma AI tradisional. Dalam mod ini, pergerakan AI sepenuhnya berdasarkan kandungan pangkalan data, mengelakkan pergantungan pada pengiraan masa nyata atau algoritma carian.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Keluarkan bidak lawan daripada tangan mereka; kemudian giliran lawan untuk meletakkan bidak.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Apabila membentuk kilang semasa fasa meletakkan';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Keluarkan bidak lawan daripada papan.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Keluarkan bidak lawan daripada papan; kemudian giliran lawan untuk meletakkan bidak.';

  @override
  String get opponentRemovesOwnPiece =>
      'Lawan mengeluarkan bidak mereka sendiri daripada papan.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Daripada anda yang mengambil tindakan, pihak lawan memilih dan mengeluarkan bidak mereka sendiri daripada papan, dengan berkesan mengambil tindakan yang memudaratkan diri mereka sendiri.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Keluarkan bidak lawan daripada tangan mereka; kemudian giliran anda untuk bergerak.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Keluarkan bidak daripada tangan lawan. Jika, mengikut tetapan Alih keluar berbilang, berbilang bidak perlu dialih keluar dan lawan tidak mempunyai baki bidak di tangan, teruskan mengalihkan keluar bidak lawan daripada papan. Kemudian, giliran anda untuk bergerak. Jika anda terus membentuk kilang, anda boleh terus mengalihkan keluar bidak lawan.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Keluarkan bidak daripada tangan lawan. Jika, mengikut tetapan Alih keluar berbilang, berbilang bidak perlu dialih keluar dan lawan tidak mempunyai baki bidak di tangan, teruskan mengalihkan keluar bidak lawan daripada papan. Kemudian, giliran lawan untuk bergerak.';

  @override
  String get markAndDelayRemovingPieces =>
      'Tandakan dan lengahkan pengalihan keluar bidak.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'Semasa fasa meletakkan, bidak yang akan dialihkan keluar ditandakan, dan bagi kedua-dua pemain, tiada bidak baharu boleh diletakkan pada titik ini. Apabila memasuki fasa bergerak, bidak yang ditanda ini dialihkan keluar sekaligus, dan pemain kemudiannya boleh mengalihkan bidak mereka ke titik yang kini kosong ini.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Tindakan yang boleh diambil semasa membentuk kilang semasa fasa penempatan.';

  @override
  String get marked => 'Ditandai';

  @override
  String get menu => 'Menu';

  @override
  String get monochrome => 'Monokrom';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Anda boleh mengaktifkan sokongan pembaca skrin dalam konfigurasi Aksesibiliti di Tetapan Umum.';

  @override
  String get showNumbersOnPieces => 'Paparkan nombor pada kepingan';

  @override
  String get saveImage => 'Simpan imej';

  @override
  String get isAnalysisToolbarShown => 'Tunjukkan Bar Alat Analisis';

  @override
  String get analysisToolbarBackgroundColor =>
      'Warna Latar Belakang Bar Alat Analisis';

  @override
  String get analysisToolbarIconColor => 'Warna Ikon Bar Alat Analisis';

  @override
  String get transformed => 'Transformed.';

  @override
  String get cannotTransform => 'Tidak boleh mengubah.';

  @override
  String get rotate => 'Putar';

  @override
  String get horizontalFlip => 'Flip M.';

  @override
  String get verticalFlip => 'Flip V.';

  @override
  String get innerOuterFlip => 'Flip D/L';

  @override
  String get transparentCanvas => 'Kanvas Lutsinar';

  @override
  String get restrictRepeatedMillsFormation =>
      'Hadkan Pembentukan Kilang Berulang';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Kepingan yang dipindahkan dari satu kilang untuk membentuk satu lagi tidak boleh kembali ke titik asal pada giliran seterusnya untuk membentuk kilang lagi. Langkah berbeza diperlukan dahulu.';

  @override
  String get oneTimeUseMill => 'Kilangan penggunaan satu kali';

  @override
  String get oneTimeUseMill_Detail =>
      'Setiap kilangan hanya boleh mengeluarkan satu bahagian lawan sekali sahaja. Anda boleh membentuknya semula, tetapi ia tidak boleh digunakan untuk pengeluaran tambahan.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Peraturan semasa yang anda tetapkan tidak mempunyai pangkalan data sempurna yang sepadan. Untuk maklumat lanjut mengenai pangkalan data sempurna, sila klik di sini.';

  @override
  String get focusOnBlockingPaths => 'Tumpu pada menyekat laluan';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Utamakan untuk menghalang pergerakan lawan daripada membentuk kincir. Daripada memberi tumpuan untuk menghapuskan kepingan dengan melengkapkan kincir, AI bertujuan untuk memerangkap lawan, menjadikan mereka tidak dapat bergerak dan memastikan kemenangan melalui kepenatan dan bukan permainan agresif. Strategi ini tidak secara aktif menghalang kincir lawan.';

  @override
  String get pieceImage => 'Gambar catur';

  @override
  String get importColorSettings => 'Import tetapan warna';

  @override
  String get exportColorSettings => 'Eksport tetapan warna';

  @override
  String get import => 'Import';

  @override
  String get export => 'Eksport';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Sila salin tetapan format JSON ke papan keratan terlebih dahulu.';

  @override
  String get copiedToClipboard => 'Disalin ke papan keratan.';

  @override
  String get imported => 'Diimport.';

  @override
  String get boardImage => 'Imej papan';

  @override
  String get autumnLeaves => 'Daun Musim Gugur';

  @override
  String get legendaryLand => 'Tanah Lagenda';

  @override
  String get vignetteEffect => 'Kesan vignet';

  @override
  String get promptMakeToolbarTransparent =>
      'Adakah anda ingin menjadikan bar alat sepenuhnya telus apabila imej latar belakang papan ditetapkan?';

  @override
  String get vibration => 'Aktifkan getaran dalam permainan';

  @override
  String get soundTheme => 'Tema bunyi';

  @override
  String get ball => 'Bola';

  @override
  String get liquid => 'Cecair';

  @override
  String get wood => 'Kayu';

  @override
  String get placeEffectAnimation => 'Efek animasi meletakkan buah';

  @override
  String get removeEffectAnimation => 'Efek animasi mengeluarkan buah';

  @override
  String get isToolbarAtBottom => 'Tunjukkan bar alat di bahagian bawah';

  @override
  String get boardCornerRadius => 'Jejari sudut papan';

  @override
  String get useOpeningBook => 'Gunakan buku pembukaan';

  @override
  String get currentRule => 'Semasa';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Set peraturan';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Biarkan AI menggunakan langkah pembukaan yang biasa digunakan oleh pemain manusia profesional semasa permainan awal. Nota: Ciri ini hanya tersedia untuk set peraturan tertentu sahaja.';

  @override
  String get showAdvantageGraph => 'Tunjukkan graf kelebihan';

  @override
  String get advantageGraphHint =>
      'Graf kelebihan hanya akan dilukis selepas AI membuat gerakan. Ia tidak akan dilukis apabila pemain manusia membuat gerakan.';

  @override
  String get removalBasedOnMillCounts =>
      'Lumpuhkan penyingkiran sehingga semua kepingan diletakkan. Pemain menyingkirkan kepingan berdasarkan bilangan kilang yang terbentuk.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Lumpuhkan penyingkiran sehingga semua kepingan diletakkan. Pemain menyingkirkan kepingan berdasarkan bilangan kilang: jika sama, kedua-duanya menyingkirkan jumlah kepingan yang sama; jika seorang mempunyai lebih, dia menyingkirkan satu keping tambahan, mengekalkan perbezaan satu keping. Jika hanya seorang berjaya membentuk kilang, dia menyingkirkan dua kepingan manakala yang lain menyingkirkan satu. Jika tiada sesiapa membentuk kilang, kedua-duanya menyingkirkan satu keping.';

  @override
  String get elfilja => 'El Filja';

  @override
  String get tipSelectOwnPiece => 'Pilih salah satu buah catur anda.';

  @override
  String get notYourTurn => 'Bukan giliran anda.';

  @override
  String get annotationToolbarBackgroundColor => 'Warna latar bar alat anotasi';

  @override
  String get annotationToolbarIconColor => 'Warna ikon bar alat anotasi';

  @override
  String get isAnnotationToolbarShown => 'Tunjukkan bar alat anotasi';

  @override
  String get enterAnnotationMode => 'Masuk ke mod anotasi';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Adakah anda pasti ingin menghapus semua anotasi?';

  @override
  String get llmPromptCopiedToClipboard => 'Gesaan LLM disalin ke papan klip.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Sambungan ditolak, pelayan mungkin tidak beroperasi.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Pengesanan berjaya, menunggu sambungan...';

  @override
  String get noLanConnection => 'Tiada sambungan LAN';

  @override
  String get takeScreenshot => 'Ambil Tangkapan Skrin';

  @override
  String get disconnectedFromOpponent => 'Terputus daripada lawan.';

  @override
  String get takeBackRequest => 'Permintaan Tarik Balik';

  @override
  String get nothingToShow => 'Tiada apa untuk ditunjukkan.';

  @override
  String get stopHosting => 'Hentikan Hos';

  @override
  String get connectionResetByPeer => 'Sambungan ditetapkan semula oleh rakan.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Sambungan terputus akibat masalah sambungan. Sila sambung semula.';

  @override
  String get startHosting => 'Mula Menjadi Hos';

  @override
  String get restartRequestRejected => 'Permintaan mulakan semula ditolak.';

  @override
  String get notConnectedToLanOpponent => 'Tidak bersambung dengan lawan LAN.';

  @override
  String get llmPrompt => 'Gesaan LLM';

  @override
  String get gameRestarted => 'Permainan dimulakan semula.';

  @override
  String get takeBackRejected => 'Tarik balik ditolak.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Adakah anda pasti ingin menyerah dalam permainan ini?';

  @override
  String get opponentResignedYouWin => 'Lawan menyerah. Anda menang!';

  @override
  String get clearAllAnnotations => 'Kosongkan semua anotasi';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Bersambung, menunggu langkah lawan...';

  @override
  String get networkStatusDisconnected => 'Status rangkaian: Terputus';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Permintaan tarik balik telah dihantar kepada lawan.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Lawan mungkin telah meninggalkan permainan';

  @override
  String get connectedToHostSuccessfully => 'Berjaya bersambung ke hos.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Sambungan terputus: masalah sambungan';

  @override
  String get noHostDiscovered => 'Tiada hos dikesan.';

  @override
  String get confirmResignation => 'Sahkan Penyerahan';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Mula menjadi hos, menunggu pemain menyertai...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Sambungan terlaksana, sambungan rangkaian tidak stabil.';

  @override
  String get noLlmPromptAvailable => 'Tiada gesaan LLM tersedia.';

  @override
  String get youResignedGameOver => 'Anda menyerah. Permainan tamat.';

  @override
  String get serverIp => 'IP Pelayan';

  @override
  String get confirmClear => 'Sahkan Pengosongan';

  @override
  String get opponentSTurn => 'Giliran lawan.';

  @override
  String get waitingAClientConnection => 'Menunggu sambungan klien...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Permintaan tarik balik ditolak atau gagal.';

  @override
  String get addText => 'Tambah teks';

  @override
  String get exitAnnotationMode => 'Keluar dari mod anotasi';

  @override
  String get typeYourAnnotation => 'Taip anotasi anda';

  @override
  String get attemptingToReconnect => 'Cuba menyambung semula...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Permintaan mulakan semula dihantar. Menunggu respons lawan...';

  @override
  String get serverIsStopped => 'Pelayan dihentikan.';

  @override
  String get restartRequest => 'Permintaan Mulakan Semula';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Tidak boleh meminta tarik balik ketika bukan giliran anda.';

  @override
  String get takeBackAccepted => 'Tarik balik diterima.';

  @override
  String get localNetworkSettings => 'Tetapan Rangkaian Tempatan';

  @override
  String get reconnectedSuccessfully => 'Berjaya menyambung semula!';

  @override
  String get failedToSaveImageToGallery => 'Gagal menyimpan imej ke Galeri.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Lawan meminta untuk mulakan semula permainan. Adakah anda terima?';

  @override
  String get yourTurn => 'Giliran anda.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Gagal menyambung semula, sila mulakan semula permainan.';

  @override
  String get host => 'Hos';

  @override
  String get join => 'Sertai';

  @override
  String get port => 'Port';

  @override
  String get invalidIpAddress => 'Alamat IP tidak sah.';

  @override
  String get invalidPort => 'Port tidak sah.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Menyambung: Percubaan $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Gagal menyambung: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Gagal memulakan hos: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Hos ditemui: $ip:$port';
  }

  @override
  String get stop => 'Hentikan';

  @override
  String get discover => 'Kesan';

  @override
  String get connect => 'Sambung';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Klien disambungkan: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Mengesan: $seconds s';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Menyambung semula ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Bersambung';

  @override
  String get delete => 'Padam';

  @override
  String get ancientEgypt => 'Mesir Purba';

  @override
  String get gothicIce => 'Ais Gotik';

  @override
  String get riceField => 'Sawah Padi';

  @override
  String get chinesePorcelain => 'Porselin Cina';

  @override
  String get desertDusk => 'Senja Gurun';

  @override
  String get precisionCraft => 'Kraf Ketepatan';

  @override
  String get folkEmbroidery => 'Sulaman Rakyat';

  @override
  String get carpathianHeritage => 'Warisan Carpathian';

  @override
  String get imperialGrandeur => 'Kemegahan Imperial';

  @override
  String get bohemianCrystal => 'Kristal Bohemia';

  @override
  String get savannaSunrise => 'Matahari Terbit Savana';

  @override
  String get harmonyBalance => 'Harmoni dan Keseimbangan';

  @override
  String get cinnamonSpice => 'Rempah Kayu Manis';

  @override
  String get anatolianMosaic => 'Mozaik Anatolia';

  @override
  String get carnivalSpirit => 'Semangat Karnival';

  @override
  String get custom => 'Adat';

  @override
  String get spiceMarket => 'Pasar Rempah';

  @override
  String get swipeToRevealTheDrawer => 'Leret untuk mendedahkan Laci';

  @override
  String get showGameInfoOnScreenshots =>
      'Tunjukkan maklumat permainan pada tangkapan skrin';

  @override
  String get humanMoveTime => 'Had masa manusia';

  @override
  String get noTimeLimitForHumanMoves =>
      'Tiada had masa untuk pergerakan manusia';

  @override
  String get timeoutLoseWillBeApplied =>
      'Kalah masa tamat akan dikenakan untuk pemain manusia';

  @override
  String get identifyingBoard => 'Mengesan papan permainan...';

  @override
  String get youCanEnterAnyModelName =>
      'Anda boleh masukkan mana‑mana nama model.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Posisi papan diaplikasikan. FEN disalin ke papan klip.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Cadangan: cuba ambil gambar papan permainan yang lebih jelas.';

  @override
  String get llmPromptTemplate => 'Templat arahan LLM';

  @override
  String get noValidBoardDetected => 'Tiada papan permainan sah dikesan.';

  @override
  String get selectingImageFromAlbum => 'Memilih imej dari album...';

  @override
  String get configurePromptTemplate => 'Tetapkan templat arahan';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Sunting templat arahan untuk analisis LLM';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Gagal menjana FEN daripada papan yang dikenalpasti.';

  @override
  String get outputInCurrentLanguage => 'Keluaran dalam bahasa semasa';

  @override
  String get commonBaseUrls => 'URL Asas biasa';

  @override
  String get viewCommonModels => 'Papar model biasa';

  @override
  String get recognitionParametersUpdated =>
      'Parameter pengecaman dikemas kini.';

  @override
  String get whiteSMove => 'Giliran Putih';

  @override
  String get resetToDefaults => 'Tetapkan semula ke lalai';

  @override
  String get photoShoot => 'Ambil foto';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Gagal menggunakan posisi papan yang dikenalpasti.';

  @override
  String get llmPromptContent => 'Kandungan arahan LLM';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM tidak dikonfigurasikan. Sila semak tetapan anda.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Tetapkan pembekal, model, API Key, dan Base URL';

  @override
  String get llmConfiguration => 'Konfigurasi LLM';

  @override
  String get configureLlmProvider => 'Konfigurasi pembekal LLM';

  @override
  String get llmPromptTemplateHeader => 'Tajuk templat arahan LLM';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Tiada buah dikesan dalam imej. Sila cuba lagi.';

  @override
  String get recognizeBoardFromImage => 'Kenal pasti papan permainan dari imej';

  @override
  String get viewTips => 'Lihat petua';

  @override
  String get applyToBoard => 'Terap ke papan';

  @override
  String get adjustBoardArea => 'Laraskan kawasan papan';

  @override
  String get viewCommonUrls => 'Lihat URL biasa';

  @override
  String get colorAnalysisFailed => 'Analisis warna gagal!';

  @override
  String get analyzingGameBoardImage => 'Menganalisis imej papan permainan...';

  @override
  String get selectFromAlbum => 'Pilih dari album';

  @override
  String get noBoardPointDetected => 'Tiada titik papan dikesan!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Jika dibiarkan kosong, templat lalai akan digunakan';

  @override
  String get llmConfig => 'Konfig LLM';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Anda pasti mahu tetapkan semula templat arahan ke nilai lalai?';

  @override
  String get llmPromptTemplateFooter => 'Kaki templat arahan LLM';

  @override
  String get loadingResponse => 'Memuat respons...';

  @override
  String get applyThisResultToBoard => 'Terap hasil ini ke papan';

  @override
  String get takingPicture => 'Mengambil gambar...';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Sila pilih imej papan permainan untuk dikenalpasti';

  @override
  String get identificationResults => 'Hasil pengecaman';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Analisis langkah dan berikan pandangan.';

  @override
  String get getApiKey => 'Dapatkan API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Seluruh proses pengecaman gagal diselesaikan.';

  @override
  String get boardRecognitionResult => 'Keputusan pengecaman papan';

  @override
  String get askLlm => 'Tanya LLM';

  @override
  String get boardDetectionFailed => 'Pengesanan papan gagal!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Tiada titik papan dikesan, tidak dapat kenal pasti buah!';

  @override
  String get copyFen => 'Salin FEN';

  @override
  String get commonlyUsedModels => 'Model yang biasa digunakan';

  @override
  String get apiKeyOptional => 'API Key (pilihan)';

  @override
  String get noImageSelected => 'Tiada imej dipilih';

  @override
  String get blackSMove => 'Giliran Hitam';

  @override
  String get llm => 'Model Bahasa Besar';

  @override
  String get llmProvider => 'Penyedia';

  @override
  String get baseUrl => 'URL Asas';

  @override
  String get model => 'Model';

  @override
  String get temperature => 'Suhu';

  @override
  String get llmCommandReceivedProcessing =>
      'Arahan diterima! AI sedang memproses...';

  @override
  String get llmDeepThinkingWait =>
      'Fikiran mendalam sedang dijalankan, sila tunggu...';

  @override
  String get llmPresentingSoon => 'Akan dipersembahkan tidak lama lagi...';

  @override
  String get recognitionParameters => 'Parameter pengecaman';

  @override
  String get adjustParamsDesc =>
      'Laraskan parameter untuk meningkatkan ketepatan pengecaman';

  @override
  String get saveParameters => 'Simpan parameter';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Tidak dapat memulakan pengecaman imej: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Pengecaman imej gagal: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Kedudukan diterapkan dengan $whiteCount buah putih dan $blackCount buah hitam';
  }

  @override
  String get fenCopiedToClipboard => '(FEN disalin ke papan klip)';

  @override
  String recognitionFailed(String error) {
    return 'Pengecaman gagal: $error';
  }

  @override
  String get myRating => 'Penilaian saya';

  @override
  String get gamesPlayed => 'Permainan dimainkan';

  @override
  String get wins => 'Menang';

  @override
  String get losses => 'Kalah';

  @override
  String get draws => 'Seri';

  @override
  String get lastUpdated => 'Terakhir dikemas kini';

  @override
  String get format => 'Format:';

  @override
  String get resetStatistics => 'Tetapkan semula statistik';

  @override
  String get drawRate => 'Kadar seri';

  @override
  String get lossRate => 'Kadar kalah';

  @override
  String get aiStatistics => 'Statistik AI';

  @override
  String get enableStatistics => 'Dayakan statistik';

  @override
  String get enableStatistics_Detail =>
      'Apabila didayakan, keputusan permainan akan direkodkan dalam statistik. Walau bagaimanapun, permainan yang melibatkan pembatalan langkah tidak akan direkodkan. Apabila dilumpuhkan, pengumpulan statistik dijeda.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Ini akan menetapkan semula semua statistik permainan. Tindakan ini tidak boleh dibuat asal.';

  @override
  String get boardInnerRingSize => 'Saiz gelang dalam papan';

  @override
  String get boardShadowEnabled => 'Bayang papan';

  @override
  String get trapAwareness => 'Pengesanan perangkap';

  @override
  String get trapAwarenessDescription =>
      'Sorot gerakan perangkap dengan bulatan dan anak panah tebal semasa analisis.';

  @override
  String trapExists(String trapMoves) {
    return 'Terdapat perangkap. Gerakan perangkap: $trapMoves';
  }

  @override
  String get custodianCapture => 'Mengapit penangkapan';

  @override
  String get custodianCaptureDescription =>
      'Lampirkan salah satu kepingan lawan anda di antara dua anda dalam garis lurus untuk menangkapnya.';

  @override
  String get custodianCaptureEnable => 'Benarkan penangkapan mengapit';

  @override
  String get interventionCapture => 'Menangkap intervensi';

  @override
  String get interventionCaptureDescription =>
      'Bergerak ke titik kosong di antara dua keping lawan anda untuk menangkap mereka berdua.';

  @override
  String get interventionCaptureEnable => 'Benarkan penangkapan intervensi';

  @override
  String get leapCapture => 'Lompat menangkap';

  @override
  String get leapCaptureDescription =>
      'Tangkap dengan melompat ke atas sekeping lawan bersebelahan ke titik kosong di luar.';

  @override
  String get leapCaptureEnable => 'Benarkan penangkapan lompat';

  @override
  String get captureApplicableLines => 'Baris yang berkenaan';

  @override
  String get captureSquareEdges => 'Di sepanjang tepi dataran';

  @override
  String get captureCrossLines =>
      'Di sepanjang garis ortogonal menyeberangi dataran';

  @override
  String get captureDiagonalLines =>
      'Di sepanjang garis pepenjuru menyeberangi dataran';

  @override
  String get captureExecutionPhases => 'Fasa pelaksanaan';

  @override
  String get capturePiecesCondition =>
      'Ketersediaan semasa fasa bergerak berdasarkan kepingan yang tinggal';

  @override
  String get capturePiecesConditionUnlimited => 'Tiada sekatan';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Tersedia semasa anda mempunyai tiga atau lebih sedikit';
}
