// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'l10n.dart';

// ignore_for_file: type=lint

/// The translations for Macedonian (`mk`).
class SMk extends S {
  SMk([String locale = 'mk']) : super(locale);

  @override
  String get appName => 'Мил';

  @override
  String get welcome => 'Добредојде';

  @override
  String get yes => 'Да';

  @override
  String get no => 'Не';

  @override
  String get game => 'Игра';

  @override
  String get humanVsAi => 'Човечки наспроти АИ';

  @override
  String get humanVsHuman => 'Хуман наспроти хуман';

  @override
  String get aiVsAi => 'АИ наспроти АИ';

  @override
  String get humanVsCloud => 'Човечки Облак';

  @override
  String get humanVsLAN => 'Човечки VS LAN';

  @override
  String get testViaLAN => 'Тест преку LAN';

  @override
  String get move => 'Потег';

  @override
  String get showMoveList => 'Премести список';

  @override
  String get moveList => 'Премести список';

  @override
  String get noGameRecord => 'Нема запис';

  @override
  String get ok => 'добро';

  @override
  String get confirm => 'Потврди';

  @override
  String get cancel => 'Откажи';

  @override
  String get tipSelectWrong => 'Изберете погрешно парче.';

  @override
  String get tipPlace => 'Ставете ги вашите парчиња.';

  @override
  String get tipBanPlace => 'Не можете да го поставите тука.';

  @override
  String get tipPlaced => 'Вие поставивте.';

  @override
  String get tipRemove => 'Отстранете парче.';

  @override
  String get tipBanRemove => 'Не можете да го отстраните.';

  @override
  String get tipRemoved => 'Вие отстранети.';

  @override
  String get tipMove => 'Поместете парче.';

  @override
  String get tipCannotPlace => 'Не можете да го поставите вашето парче овде.';

  @override
  String get tipCannotMove => 'Не можете да го преместите вашето парче овде.';

  @override
  String get tipMill => 'Мил! Земете го парчето на вашиот противник.';

  @override
  String get tipContinueMill =>
      'Продолжете да ги земате парчињата на противникот.';

  @override
  String get tipSelectOpponentsPiece =>
      'Изберете една од деловите на вашиот противник.';

  @override
  String get tipCannotRemovePieceFromMill =>
      'Не можете да отстраните парче од мелницата.';

  @override
  String get tipCanMoveOnePoint => 'Парче може да помести 1 поен.';

  @override
  String get tipCannotMoveOpponentsPieces =>
      'Не можете да ги поместите фигурите на противникот.';

  @override
  String get tipSelectPieceToMove => 'Изберете го вашето парче за движење.';

  @override
  String get tipHaveThreePiecesLeft => 'Имате уште три парчиња.';

  @override
  String get tipCanMoveToAnyPoint =>
      'Може да се преселите во која било точка што ви се допаѓа.';

  @override
  String tipToMove(Object player) {
    return '$player за движење.';
  }

  @override
  String get whiteWin => 'Играчот 1 победи!';

  @override
  String get blackWin => 'Играчот 2 победи!';

  @override
  String get won => 'Победи';

  @override
  String get lost => 'Изгубени';

  @override
  String get thinking => 'Размислувајќи…';

  @override
  String get newGame => 'Нова игра';

  @override
  String get importGame => 'Увезете игра';

  @override
  String get exportGame => 'Извозна игра';

  @override
  String get gameImported => 'Играта е увезена.';

  @override
  String cannotImport(Object invalidMove) {
    return 'Не може да се увезе $invalidMove';
  }

  @override
  String get movesAndRulesNotMatch => 'Потезите и правилата не се совпаѓаат.';

  @override
  String get pleaseWait => 'Ве молам почекајте.';

  @override
  String get restartGame => 'Да ја рестартираш актуелната игра?';

  @override
  String get restart => 'Рестарт';

  @override
  String get gameStarted => 'Играта започна, ве молиме, поставете.';

  @override
  String get analyzing => 'Анализирајќи…';

  @override
  String error(Object message) {
    return 'Грешка: $message';
  }

  @override
  String get winRate => 'Стапка на победа';

  @override
  String get score => 'Резултат:';

  @override
  String get white => 'Играч 1';

  @override
  String get black => 'Играч 2';

  @override
  String loseReasonlessThanThree(Object player) {
    return '$player бројот на парчиња е помал од три.';
  }

  @override
  String loseReasonResign(Object player) {
    return '$player поднесе оставка.';
  }

  @override
  String loseReasonNoWay(Object player) {
    return '$player нема начин да оди.';
  }

  @override
  String loseReasonBoardIsFull(Object player) {
    return 'Таблата е полна и $player нема начин да оди.';
  }

  @override
  String loseReasonTimeOver(Object player) {
    return 'Времето заврши, $player изгубено.';
  }

  @override
  String get drawReasonRule50 =>
      'Во фаза на движење, ниту едно парче не е отстрането во последниот специфичен број на потези.';

  @override
  String get drawReasonBoardIsFull =>
      'Тоа е Извлекување бидејќи таблата е полна.';

  @override
  String get drawReasonThreefoldRepetition =>
      'Тоа е ждрепка заради тројно повторување.';

  @override
  String get gameOverUnknownReason => 'Играта заврши! Непозната причина.';

  @override
  String get gameOver => 'Играта заврши';

  @override
  String get youWin => 'Ти Победи! Секоја чест!';

  @override
  String challengeHarderLevel(int level) {
    return 'Предизвикувате потешко ниво? Новото ниво ќе биде ниво $level!';
  }

  @override
  String get youLose => 'Ти губиш!';

  @override
  String get analyze => 'Анализирај';

  @override
  String get about => 'За';

  @override
  String version(Object versionNumber) {
    return 'Верзија: $versionNumber';
  }

  @override
  String get thanks => 'Благодарам';

  @override
  String get settings => 'Поставки';

  @override
  String get options => 'Опции';

  @override
  String get generalSettings => 'Општи подесувања';

  @override
  String get skillLevel => 'Ниво на тешкотија';

  @override
  String get moveTime => 'Време на размислување за ВИ';

  @override
  String get difficulty => 'Тешкотија';

  @override
  String get playSounds => 'Звучни ефекти';

  @override
  String get playSoundsInTheGame => 'Играјте звуци во играта';

  @override
  String get keepMuteWhenTakingBack => 'Чувајте неми кога враќате';

  @override
  String get tone => 'Тон';

  @override
  String get whoMovesFirst => 'Прв потег';

  @override
  String get human => 'Човечки';

  @override
  String get ai => 'АИ';

  @override
  String get alternate => 'Наизменично';

  @override
  String get isAutoRestart =>
      'Автоматско рестартирајте ја играта кога ќе заврши играта';

  @override
  String get isAutoChangeFirstMove => 'Автоматско менување на првиот потег';

  @override
  String get shufflingEnabled => 'Случаен потег';

  @override
  String get misc => 'Разно';

  @override
  String get rules => 'Правила';

  @override
  String get piecesCount => 'Број на парчиња што ги има секој играч';

  @override
  String get piecesCount_Detail => 'Колку парчиња има секој играч?';

  @override
  String get flyPieceCount => 'Бројот на летачкото парче';

  @override
  String get flyPieceCount_Detail =>
      'Ако Летањето е овозможено, кога играчот ќе се сведе на одредено сметање на парчиња, нејзините фигури можат слободно да се преселат во која било неокупирана точка, наместо да бидат ограничени на соседните точки како во остатокот од играта.';

  @override
  String get piecesAtLeastCount => 'Парчиња најмалку';

  @override
  String get hasDiagonalLines => 'Дијагонални линии';

  @override
  String get hasDiagonalLines_Detail =>
      'Додадете четири дијагонални линии на таблата.';

  @override
  String get isDefenderMoveFirst => 'Вториот играч се движи прв';

  @override
  String get isDefenderMoveFirst_Detail =>
      'Играчот кој се движи втор во фазата на поставување се движи прв во фаза на движење.';

  @override
  String get mayRemoveMultiple => 'Повеќе-отстранување';

  @override
  String get mayRemoveMultiple_Detail =>
      'Ако играч затвори повеќе од една мелница одеднаш, таа ќе го отстрани бројот на мелници што ги затвори.';

  @override
  String get mayRemoveFromMillsAlways => 'Уништи мелници';

  @override
  String get mayRemoveFromMillsAlways_Detail =>
      'Стандардно, играчите мора прво да отстранат други парчиња пред да извадат парче од формираната мелница. Овозможете ја оваа опција за да го оневозможите ограничувањето.';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull =>
      'Вториот играч губи кога таблата е полна';

  @override
  String get isWhiteLoseButNotDrawWhenBoardFull_Detail =>
      'Кога таблата е полна на крајот од фазата на поставување, страната што прво се поставува ја губи играта. Инаку, играта е нерешена.';

  @override
  String get isLoseButNotChangeSideWhenNoWay =>
      'Изгуби кога нема законски потези';

  @override
  String get isLoseButNotChangeSideWhenNoWay_Detail =>
      'Играчот ќе изгуби ако неговиот противник ги блокира за да не можат да бидат поместени. Променете ја страната за да се преместите ако оваа опција е оневозможена.';

  @override
  String get mayFly => 'Летање';

  @override
  String get mayFly_Detail =>
      'Ако на играч и останат само три или четири (конфигурираат) парчиња, таа може да го премести парчето во која било слободна точка.';

  @override
  String get nMoveRule => 'Правило за движење со N';

  @override
  String get nMoveRule_Detail =>
      'Играта е извлечена ако не се отстрани одреден број потези од секој играч.';

  @override
  String get rollback => 'Враќање назад';

  @override
  String get pleaseSelect => 'Ве молиме изберете';

  @override
  String get copy => 'Копирај';

  @override
  String get moveHistoryCopied =>
      'Преместете ја историјата копирана во таблата со исечоци.';

  @override
  String get help => 'Помош';

  @override
  String get feedback => 'Повратни информации';

  @override
  String get exit => 'Излез';

  @override
  String get ruleSettings => 'Правила';

  @override
  String get color => 'Боја';

  @override
  String get boardColor => 'Боја на табла';

  @override
  String get pieceColor => 'Боја на парче';

  @override
  String get backgroundColor => 'Боја на позадина';

  @override
  String get lineColor => 'Боја на линијата на таблата';

  @override
  String get whitePieceColor => 'Плеер 1 парче боја';

  @override
  String get blackPieceColor => 'Плеер 2 парче боја';

  @override
  String get messageColor => 'Боја на пораката';

  @override
  String get isPieceCountInHandShown => 'Покажете број на парчиња во рака';

  @override
  String get isNotationsShown => 'Прикажи нотации на бродот';

  @override
  String get isHistoryNavigationToolbarShown =>
      'Покажи лента со алатки за навигација во историјата';

  @override
  String get display => 'Екран';

  @override
  String get boardBorderLineWidth => 'Ширина на границата на таблата';

  @override
  String get boardInnerLineWidth => 'Ширина на внатрешната линија на таблата';

  @override
  String get pieceWidth => 'Ширина на парче';

  @override
  String get fontSize => 'Големина на фонтот';

  @override
  String get standardNotation => 'Нотација на WMD';

  @override
  String get restore => 'Врати';

  @override
  String get restoreDefaultSettings => 'Вратете ги стандардните поставки';

  @override
  String pick(Object element) {
    return 'Изберете $element';
  }

  @override
  String get info => 'Инфо';

  @override
  String get hint => 'Навестување';

  @override
  String get player => 'играч';

  @override
  String get player1 => 'Играч 1';

  @override
  String get player2 => 'Играч 2';

  @override
  String get howToPlay => 'Како да играш';

  @override
  String get toPlacePiece =>
      'Допрете на која било достапна точка за да го поставите парчето.';

  @override
  String get toSelectPiece => 'Допрете на парче за да го преместите.';

  @override
  String get toMovePiece =>
      'Допрете на точка поврзана со парче за да ја поместите.';

  @override
  String get toRemovePiece =>
      'Допрете на едното парче на противникот за да го отстраните.';

  @override
  String get needToCreateMillFirst =>
      'Прво треба да креирате мелница пред да отстраните парче.';

  @override
  String get needToPlayWithOwnPieces => 'Треба да си играте со вашите парчиња.';

  @override
  String get statistics => 'Статистика';

  @override
  String get totalGames => 'Вкупно игри';

  @override
  String get results => 'Резултати';

  @override
  String get left => 'лево';

  @override
  String get privacyPolicy => 'Политика за приватност';

  @override
  String get privacyPolicy_Detail_1 =>
      'Прочитајте внимателно и проверете дали целосно го разбирате и согласувате со ова ';

  @override
  String get privacyPolicy_Detail_2 =>
      '. Ако не се согласувате со оваа политика, не користете ја оваа апликација. Користењето на апликацијата подразбира дека ги прифаќате овие услови.';

  @override
  String get and => ' и ';

  @override
  String get accept => 'Прифати';

  @override
  String get takeBack => 'Врати се назад';

  @override
  String get takingBack => 'Враќање назад…';

  @override
  String get waiting => 'Чекајќи…';

  @override
  String get stepForward => 'Чекор напред';

  @override
  String get takeBackAll => 'Вратете ги сите';

  @override
  String get stepForwardAll => 'Чекор напред сите';

  @override
  String get moveNow => 'Премести се сега';

  @override
  String get done => 'Направено.';

  @override
  String get crackMill => 'Мелница за пукнатини';

  @override
  String get crackMill_Detail =>
      'Ако играч има само парчиња во мелници, парчињата во мелниците нема да се заклучат за да се отстранат.';

  @override
  String get animationDuration => 'Времетраење на анимацијата';

  @override
  String get none => 'Ништо';

  @override
  String get theme => 'Тема';

  @override
  String get helpContent =>
      'Играта има за цел да го остави противникот со помалку од три парчиња или без законски потези.\n\nИграта автоматски црта ако се појави позиција по трет пат или не се отстрани во последните 100 потези (може да се конфигурира).\n\nИграта тече во три фази:\n\n1. Поставување парчиња на празни места\n2. Преместување парчиња во соседните точки\n3. (факултативна фаза) Преместување на парчињата во која било празна точка при намалување на плеерот на три дела\n\nПоставување\n\nИграта започнува со празна табла, која се состои од мрежа со дваесет и четири поени. Играчите наизменично ги поставуваат своите парчиња на празни места додека секој играч не ги постави сите парчиња на таблата. Ако играчот може да стави три свои фигури исправено, тој има „мелница“ и може да отстрани еден од неговите парчиња од таблата.\n\nСпоред некои правила, играчите мора прво да отстранат други парчиња пред да извадат парче од формираната мелница.\n\nВо некои правила не можете повторно да ги поставите парчињата до точките на отстранетите парчиња во фазата на поставување.\n\nОткако ќе ги користат сите парчиња, играчите се движат наизменично.\n\nСе движат\n\nЗа да се придвижи, играчот преместува една од неговите парчиња по линија на табла до празна соседна точка. Ако не може да го стори тоа, тој ја загуби играта. Како и во фазата на поставување, играч кој усогласува три свои парчиња на линија на табла, има воденица и може да отстрани една од неговите парчиња. Секој играч намалува на две парчиња, нема опција да формира нови мелници и со тоа ја губи играта. Играчот исто така може да изгуби кога има повеќе од три парчиња ако неговиот противник ги блокира во движење.\n\nЛетање\n\nВо некои варијанти на правила, штом играчот остане само три парчиња, неговите парчиња можат да летаат, да скокаат или да скокаат на празни места, не само на соседните.';

  @override
  String get versionInfo => 'Информации за верзијата';

  @override
  String get eula => 'ЕУЛА';

  @override
  String get license => 'Лиценца';

  @override
  String get sourceCode => 'Изворен код';

  @override
  String get appVersion => 'Верзија на апликација';

  @override
  String get general => 'Генерал';

  @override
  String get advanced => 'Напредно';

  @override
  String get placing => 'Поставување';

  @override
  String get moving => 'Се движат';

  @override
  String get removing => 'Отстранување';

  @override
  String get gameOverCondition => 'Игра над состојба';

  @override
  String get aisPlayStyle => 'Стил на играчката на АИ';

  @override
  String get passive => 'Пасивно';

  @override
  String get timeout => 'Тајм аут';

  @override
  String get appearance => 'Изглед';

  @override
  String get drawOnHumanExperience => 'Извлечете го човечкото искуство';

  @override
  String get considerMobility => 'Размислете за подвижноста на парчињата';

  @override
  String get pieceCount => 'Број на парчиња:';

  @override
  String inHand(Object player, int count) {
    return '$player во рака: $count';
  }

  @override
  String onBoard(Object player, int count) {
    return '$player на бродот: $count';
  }

  @override
  String get boardTop => 'Офсет на таблата од врвот';

  @override
  String get notAIsTurn => 'Не е редот на АИ.';

  @override
  String get aiIsNotThinking => 'АИ не размислува.';

  @override
  String get atEnd => 'Вие сте на крајот од списокот за преместување.';

  @override
  String get tapBackAgainToLeave => 'Допрете назад за да заминете.';

  @override
  String get more => 'Повеќе';

  @override
  String get experimental => 'Тоа е експериментална карактеристика.';

  @override
  String get experiments => 'Експерименти';

  @override
  String get ossLicenses => 'Лиценци со отворен извор';

  @override
  String get language => 'Јазик';

  @override
  String get defaultLanguage => 'Стандарден јазик';

  @override
  String get mayMoveInPlacingPhase =>
      'Парчињата можат да се движат во фазата на поставување';

  @override
  String get mayMoveInPlacingPhase_Detail =>
      'Нема посебни фази на поставување и движење, т.е. играчите можат да одлучат на секој потег дали сакаат да постават парче на таблата или да поместат некое од нивните парчиња (сè додека ги имаат останатите парчиња за поставување).';

  @override
  String get drawerColor => 'Боја на менито';

  @override
  String get drawerTextColor => 'Боја на текст во менито';

  @override
  String get drawerHighlightItemColor => 'Боја на обележана мени';

  @override
  String get mainToolbarBackgroundColor => 'Боја на главната лента со алатки';

  @override
  String get mainToolbarIconColor =>
      'Боја на иконата на главната лента со алатки';

  @override
  String get navigationToolbarBackgroundColor =>
      'Боја на позадина во лентата со алатки за навигација';

  @override
  String get navigationToolbarIconColor =>
      'Боја на иконата во лентата со алатки за навигација';

  @override
  String get autoHideToolbar => 'Автоматски скријте ја лентата со алатки';

  @override
  String get toolbarLocationOnScreen =>
      'Локација на лентата со алатки на екранот';

  @override
  String get top => 'Врв';

  @override
  String get bottom => 'Дното';

  @override
  String get center => 'Центар';

  @override
  String get solidColor => 'Цврста боја';

  @override
  String get picture => 'Слика';

  @override
  String get chooseYourPicture => 'Изберете ја вашата слика';

  @override
  String get light => 'Светлина';

  @override
  String get dark => 'Темно';

  @override
  String get themes => 'Теми';

  @override
  String get currentTheme => 'Тековна тема';

  @override
  String get saveTheme => 'Зачувај тема';

  @override
  String get showAnalysisGraph => 'Прикажи графикон за анализа';

  @override
  String get analysis => 'Анализа';

  @override
  String get saveGame => 'Зачувај игра';

  @override
  String get loadGame => 'Играта се вчитува';

  @override
  String get setupPosition => 'Позиција за поставување';

  @override
  String get showLegalMoves => 'Покажете законски потези';

  @override
  String get showLastMove => 'Покажете го последниот потег';

  @override
  String get showArrows => 'Покажи стрели';

  @override
  String get pieces => 'Парчиња';

  @override
  String get showAnalysis => 'Покажи анализа';

  @override
  String get threads => 'Теми';

  @override
  String get getInvolved => 'Вклучете се';

  @override
  String get helpImproveTranslate => 'Помогнете да се подобри преводот';

  @override
  String get tutorial => 'Упатство за употреба';

  @override
  String get classicMill => 'Класичен мелница';

  @override
  String get mixedMill => 'Мешана воденица';

  @override
  String get ceylonMill => 'Мелница за цејлон';

  @override
  String get mayBreakAndRemakeMillRepeatedly =>
      'Мелницата може постојано да се крши и да се преработува';

  @override
  String get mayBreakAndRemakeMillRepeatedly_Detail =>
      'Ако играч скрши мелница за да создаде нова мелница веднаш, таквиот плеер може да го премести таквиот дел назад во првобитната клучка во неговиот следен потег, ако направи нов мелница.';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft =>
      'Играта се извлекува ако играчот има три парчиња и по десет потези ниту еден играч не ги отстранува противничките парчиња';

  @override
  String get drawIfNoRemovalWithinTenMovesWhenThreeLeft_Detail =>
      'Кога играчот е спуштен на три дела, и ниту еден играч не може да отстрани противнички парче во рок од десет потези, играта е нерешена.';

  @override
  String get close => 'Затвори';

  @override
  String get whitePiece => 'Бело парче';

  @override
  String get blackPiece => 'Црно парче';

  @override
  String get emptyPoint => 'Празна точка';

  @override
  String get noPoint => 'Без смисла';

  @override
  String get placingPhase => 'Фаза на поставување';

  @override
  String get movingPhase => 'Фаза на движење';

  @override
  String get flyingPhase => 'Фаза на летање';

  @override
  String sideToMove(Object player) {
    return 'Страна за движење: $player';
  }

  @override
  String lastMove(Object move) {
    return 'Последен потег: $move';
  }

  @override
  String get selected => 'Избрано';

  @override
  String get accessibility => 'Пристапност';

  @override
  String get screenReaderSupport => 'Поддршка за читач на екран';

  @override
  String get isDraw => 'Тоа е Нерешено!';

  @override
  String get draw => 'Нацртај';

  @override
  String get pieceHighlightColor => 'Боја за истакнување на парче';

  @override
  String get algorithm => 'Алгоритам';

  @override
  String get endgameNMoveRule => 'Правило за крајна игра N-Move';

  @override
  String get endgameNMoveRule_Detail =>
      'Ако било кој играч има само три дела и ниту еден играч не отстрани парче во рамките на одреден потег, играта е извлечена.';

  @override
  String get drawReasonEndgameRule50 =>
      'Секој играч има само три парчиња и ниту еден играч не отстранува парче во одреден потег.';

  @override
  String get threefoldRepetitionRule => 'Трикратно правило за повторување';

  @override
  String get threefoldRepetitionRule_Detail =>
      'Играта е извлечена ако се појави позиција по трет пат.';

  @override
  String get continueToMakeMove => 'Мил! Продолжете да направите потег.';

  @override
  String get pointStyle => 'Стил на точка';

  @override
  String get pointWidth => 'Ширина на точка';

  @override
  String get solid => 'Цврсти';

  @override
  String get hollow => 'Шупливи';

  @override
  String get languageName => 'Македонски';

  @override
  String moveNumber(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count Поместувања',
      one: '$count Премести',
      zero: 'Премести',
    );
    return '$_temp0';
  }

  @override
  String get loadFailed => 'Вчитувањето не успеа.';

  @override
  String get filename => 'Име на датотека';

  @override
  String get browse => 'Прелистајте…';

  @override
  String get gameFiles => 'Датотеки за игри';

  @override
  String get gameSavedTo => 'Играта е зачувана во';

  @override
  String get empty => 'Празен';

  @override
  String get noMove => 'Нема потег.';

  @override
  String get restoredPosition => 'Вратена почетна положба.';

  @override
  String get clean => 'Чиста';

  @override
  String get cleanedUp => 'Исчистено.';

  @override
  String get remove => 'Отстрани';

  @override
  String get noPiecesCanBeRemoved => 'Ниту едно парче не може да се отстрани.';

  @override
  String pieceCountNeedToRemove(int count) {
    String _temp0 = intl.Intl.pluralLogic(
      count,
      locale: localeName,
      other: '$count парчиња',
      one: '$count парче',
      zero: 'Piece',
    );
    return '$_temp0 треба да се отстрани.';
  }

  @override
  String placedCount(int count) {
    return 'Поставено ($count)';
  }

  @override
  String get placedPieceCount =>
      'Број на ставени парчиња во фаза на поставување.';

  @override
  String hasPlacedPieceCount(int count) {
    return 'Тековниот играч постави $count парчиња.';
  }

  @override
  String get notPlacingPhase => 'Не се поставува фаза, не може да се промени.';

  @override
  String get paste => 'Залепи';

  @override
  String get pasteDone => 'Пастата е готова.';

  @override
  String get cannotPaste => 'Не може да се залепи.';

  @override
  String get isUnplacedAndRemovedPiecesShown =>
      'Прикажи непоставени и отстранети парчиња';

  @override
  String get fullScreen => 'Цел екран';

  @override
  String get reopenToTakeEffect =>
      'Излезете и отворете ја повторно апликацијата за поставките да стапат на сила.';

  @override
  String get forest => 'Шума';

  @override
  String get desktopImage => 'Слика на работната површина';

  @override
  String get invalidPosition => 'Невалидна позиција.';

  @override
  String get shareGIF => 'Споделете GIF';

  @override
  String get pixelRatio => 'Сооднос на пиксели';

  @override
  String get duration => 'Времетраење';

  @override
  String get gameScreenRecorder => 'Снимач на екранот на играта';

  @override
  String get previous => 'Претходна';

  @override
  String get next => 'Следно';

  @override
  String get skip => 'Прескокни';

  @override
  String get gotIt => 'Сфатив';

  @override
  String get youCanModifyRules =>
      'Можете да ги менувате правилата на играта во поставките за правила.';

  @override
  String get youCanUseMouseWheelInPicker =>
      'Можете да го користите тркалото на глувчето за да ја промените вредноста во избирачот.';

  @override
  String get noTimeLimitForThinking =>
      'AI Времето за размислување поставено на 0 значи дека нема временско ограничување за размислување.';

  @override
  String get whatIsMtdf =>
      'MTD(f) е модифицирана форма на алфа-бета алгоритам за пребарување што има за цел да ја подобри ефикасноста со повторна употреба на средни резултати од пребарувањето и користење на добра почетна претпоставка за стеснување на просторот за пребарување.';

  @override
  String get noteAiThinkingTimeMayNotBePrecise =>
      'Имајте предвид дека прилагодувањето на времето за размислување со вештачка интелигенција можеби не е целосно прецизно. Вистинското време на размислување може да биде пократко кога нивото на тежина е поставено на помала вредност и може да биде подолго кога вештачката интелигенција е во средина на размислување кога ќе истече времето.';

  @override
  String get noteActualDifficultyLevelMayBeLimited =>
      'Ако го поставите нивото на тежина високо, но не го зголемите времето за размислување со вештачка интелигенција, вистинското ниво на тежина може да биде ограничено на помала вредност поради ограничувањето на времето за размислување. Вистинската вредност може да варира врз основа на перформансите на машината.';

  @override
  String get whatIsPvs =>
      'PVS (Principal Variation Search) е алгоритам за пребарување за да се најде најдобриот потег во дадена позиција. Тоа е подобрување на алфа-бета алгоритмот и користи нула или нула пребарување на прозорци за да потврди дека потегот е полош или не полош од веќе безбедниот резултат од главната варијација. PVS се фокусира на најперспективните потези и ги избегнува непотребните пребарувања на неоптимални гранки, што помага да се подобри ефикасноста на пребарувањето.';

  @override
  String get whatIsAlphaBeta =>
      'Алфа-бета алгоритам е алгоритам за пребарување за да се најде најдобриот потег. Го користи принципот минимакс и две вредности, алфа и бета, за да го исече дрвото за пребарување и да ја зголеми ефикасноста. Алфа го претставува минималниот резултат што компјутерот е сигурен дека може да го добие, додека бета го претставува максималниот резултат што може да го добие неговиот противник. Алгоритмот му помага на компјутерот да донесува паметни, ефикасни одлуки во играта.';

  @override
  String get drawOnTheHumanExperienceDetail =>
      'Според човечкото искуство, ако се обидете да победите, ќе изгубите. Наместо тоа, целјте кон реми како ваша цел и избегнувајте да ја изгубите играта. Набљудувајте го вашиот противник и нежно намами го во позиција каде што може да направи грешки. Кога ќе покажат слабост, искористете ја шансата и нежно притискајте за победа. На овој начин, можете да ја добиете играта.';

  @override
  String get firstMoveDetail =>
      'Во оваа игра, полесно е вториот играч да победи во споредба со првиот играч.';

  @override
  String get passiveDetail =>
      'Овозможувањето на Пасивната опција ќе предизвика ВИ да се опушти кога има предност во позицијата, наместо агресивно да се обидува да победи што е можно побрзо.';

  @override
  String get moveRandomlyDetail =>
      'Овозможувањето на оваа опција ја зголемува случајноста и забавата на играта, додека нејзиното оневозможување може да помогне во проучувањето на начините како да се победи вештачката интелигенција.';

  @override
  String get considerMobilityOfPiecesDetail =>
      'Ако вештачката интелигенција ја земе предвид мобилноста на своите фигури, таа не само што ќе има за цел да ги фати фигурите на противникот што е можно побрзо, туку ќе размисли и да ги блокира движењата на противникот и да ги спречи да го прават истото.';

  @override
  String get whenBoardIsFull => 'Кога таблата е полна';

  @override
  String get whenBoardIsFull_Detail =>
      'На крајот од фазата на поставување, пред да започне фазата на поместување, следува дејство доколку таблата е полна со парчиња.';

  @override
  String get sideToMoveRemovePiece =>
      'Играчот кој се движи прв во фазата на движење отстранува една од фигурите на противникот.';

  @override
  String get agreeToDraw => 'Двете страни се согласуваат на реми.';

  @override
  String get takeOpponentsPiece => 'Земете една од фигурите на противникот.';

  @override
  String get firstPlayerLose => 'Првиот играч ја губи играта.';

  @override
  String get firstAndSecondPlayerRemovePiece =>
      'Првиот и вториот играч отстрануваат една од фигурите на противникот.';

  @override
  String get secondAndFirstPlayerRemovePiece =>
      'Вториот и првиот играч отстрануваат една од фигурите на противникот.';

  @override
  String get enteredFlyingPhase =>
      'Сега влезе во фазата на летање, фигурите на противникот можат да скокаат на која било празна точка на таблата. Можете да го исклучите правилото за летање во „Поставки за правила“.';

  @override
  String get whenStalemate => 'Кога е во ќор-сокак';

  @override
  String get whenStalemate_Detail =>
      'Какво дејство следи кога ниедно парче не може да се помести?';

  @override
  String get endWithStalemateLoss => 'Заврши со загуба во ќор-сокак.';

  @override
  String get changeSideToMove => 'Сменете ја страната за да се движите.';

  @override
  String get removeOpponentsPieceAndMakeNextMove =>
      'Отстранете една од фигурите на противникот и направете го следниот потег.';

  @override
  String get endWithStalemateDraw => 'Заврши со ќор-сокак нерешено.';

  @override
  String get removeOpponentsPieceAndChangeSideToMove =>
      'Отстранете една од фигурите на противникот и сменете ја страната за да се движите.';

  @override
  String get aiResponseDelayTime =>
      'Време на одложување на одговорот со вештачка интелигенција';

  @override
  String get aiIsDelaying =>
      'Вештачката интелигенција моментално е во фаза на одложен одговор. Ве молиме почекајте некое време пред да продолжите.';

  @override
  String get tipCanNotRemoveNonadjacent =>
      'Не можете да отстраните непосредно парче.';

  @override
  String get stalemateRemovalRegardlessOfMillFormation =>
      'Доколку дојде до ќор-сокак, противничките фигури во непосредна близина на вашите може да се отстранат, без оглед на формирањето на мелницата.';

  @override
  String get whatIsMcts =>
      'MCTS е алгоритам за почетници кој донесува одлуки со истражување и евалуација на различни потези преку симулации.';

  @override
  String get goldenJade => 'Златен жад';

  @override
  String get forestWood => 'Шумско дрво';

  @override
  String get darkMystery => 'Темна мистерија';

  @override
  String get midnightBlue => 'Полноќно сино';

  @override
  String get greenForest => 'Зелена шума';

  @override
  String get greenMeadow => 'Зелена ливада';

  @override
  String get stonyPath => 'Камената патека';

  @override
  String get pastelPink => 'Пастел розова';

  @override
  String get turquoiseSea => 'Тиркизно Море';

  @override
  String get violetDream => 'Виолетовиот сон';

  @override
  String get mintChocolate => 'Чоколадо од нане';

  @override
  String get skyBlue => 'Сино небо';

  @override
  String get playfulGarden => 'Разиграна градина';

  @override
  String get whatIsRetrogradeAnalysis =>
      'Алгоритмот за ретроградна анализа користи ретроградна анализа со повеќе вредности за да изгради база на податоци за крајната игра од различни почетни позиции, а потоа ја применува оваа база за оптимизирање на играта. Овој пристап спаѓа во категоријата Ултра-силни решенија.';

  @override
  String get viewAlgorithmGuide =>
      'Дали сакате да го погледнете корисничкото упатство за овој алгоритам?';

  @override
  String get showPositionalAdvantageIndicator =>
      'Прикажи индикатор за позициска предност';

  @override
  String get usePerfectDatabase => 'Користете совршена база на податоци';

  @override
  String get perfectDatabaseDescription =>
      'Овозможете ја оваа опција за користење беспрекорна база на податоци за игри генерирана преку врвни алгоритми. Оваа функција ги интегрира стратегиите за отворање и за крај на играта за да предложи оптимални потези. Ова е префериран избор за играчи кои бараат највисоко ниво на прецизност во играта. Создадена преку прецизни пресметковни техники, базата на податоци е дизајнирана да нуди скоро совршени решенија за игри.\n\nЗабелешка: Доколку вештачката интелигенција не успее да пристапи до базата на податоци, таа ќе се сврти кон конвенционалните алгоритми за одлуки за играње. Кога базата на податоци е достапна, „Нивото на тешкотија“ станува практично непобедливо, а „Време за размислување со вештачка интелигенција“ доживува драстично намалување. Многу поставки во рамките на опциите за „Препродукција на AI“ ќе бидат отфрлени, бидејќи резултатите од базата на податоци имаат највисок приоритет.\n\nЗа насоки како да го искористите максимумот од оваа беспрекорна база на податоци, кликнете овде.';

  @override
  String get backgroundImage => 'Позадинска слика';

  @override
  String get whatIsRandom =>
      'Кога опцијата „Користи совршена база на податоци“ не е овозможена, поставката „Случајно“ предизвикува вештачката интелигенција да поместува парчиња случајно без да користи никакви алгоритми за избор на движење. Ова обично резултира со значително послаба игра. Спротивно на тоа, кога е овозможено „Користете совршена база на податоци“, вештачката интелигенција исклучиво се потпира на „Совршена база на податоци“ за донесување одлуки, наместо да ја меша со традиционалните алгоритми за вештачка интелигенција. Во овој режим, потезите на вештачката интелигенција се целосно засновани на содржината на базата на податоци, избегнувајќи потпирање на пресметките во реално време или алгоритмите за пребарување.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn =>
      'Отстранете ја фигурата (фигурите) на противникот од неговата рака; потоа противникот е на ред да постави.';

  @override
  String get whenFormingMillsDuringPlacingPhase =>
      'Кога формирате мелници за време на фазата на поставување';

  @override
  String get removeOpponentsPieceFromBoard =>
      'Отстранете ја фигурата (фигурите) на противникот од таблата.';

  @override
  String get removeOpponentsPieceFromBoard_Detail =>
      'Отстранете ја фигурата (фигурите) на противникот од таблата; потоа противникот е на ред да постави.';

  @override
  String get opponentRemovesOwnPiece =>
      'Противникот ја отстранува својата фигура (фигури) од таблата.';

  @override
  String get opponentRemovesOwnPiece_Detail =>
      'Наместо вие да преземете акција, противникот избира и ја отстранува својата фигура (фигури) од таблата, со што ефективно презема акција што е штетна за него.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn =>
      'Отстранете ја фигурата (фигурите) на противникот од неговата рака; потоа е ваш ред да се поместите.';

  @override
  String get removeOpponentsPieceFromHandThenYourTurn_Detail =>
      'Отстранете ја фигурата (фигурите) од раката на противникот. Ако, според поставките за повеќекратно отстранување, треба да се отстранат повеќе фигури, а на противникот не му останале фигури во раката, продолжете да ги отстранувате фигурите на противникот од таблата. Потоа, вие сте на ред да се повлечете. Ако продолжите да формирате мелници, можете да продолжите да ги отстранувате фигурите на противникот.';

  @override
  String get removeOpponentsPieceFromHandThenOpponentsTurn_Detail =>
      'Отстранете ја фигурата (фигурите) од раката на противникот.Ако, според поставките за повеќекратно отстранување, треба да се отстранат повеќе фигури, а на противникот не му останале фигури во раката, продолжете да ги отстранувате фигурите на противникот од таблата. Потоа, противникот е на ред да се повлече.';

  @override
  String get markAndDelayRemovingPieces =>
      'Обележете и одложете отстранување на фигурите.';

  @override
  String get markAndDelayRemovingPieces_Detail =>
      'За време на фазата на поставување, фигурите што треба да се отстранат се означени и двајцата играчи не можат да постават нови фигури на овие точки. По влегувањето во фазата на движење, овие обележани фигури се отстрануваат сосема, а потоа играчите можат да ги преместат своите фигури на овие сега празни точки.';

  @override
  String get whenFormingMillsDuringPlacingPhase_Detail =>
      'Акциите што може да се преземат при формирање на мелници за време на фазата на поставување.';

  @override
  String get marked => 'Маркиран';

  @override
  String get menu => 'Мени';

  @override
  String get monochrome => 'Монокром';

  @override
  String get youCanEnableScreenReaderSupport =>
      'Можете да активирате поддршка за читач на екран во поставките за пристапност во Општите поставки.';

  @override
  String get showNumbersOnPieces => 'Прикажи броеви на фигурите';

  @override
  String get saveImage => 'Зачувај слика';

  @override
  String get isAnalysisToolbarShown => 'Прикажи алатник за анализа';

  @override
  String get analysisToolbarBackgroundColor =>
      'Позадинска боја на алатникот за анализа';

  @override
  String get analysisToolbarIconColor =>
      'Боја на иконата на алатникот за анализа';

  @override
  String get transformed => 'Трансформирано.';

  @override
  String get cannotTransform => 'Не може да се трансформира.';

  @override
  String get rotate => 'Ротирај';

  @override
  String get horizontalFlip => 'Х Флип';

  @override
  String get verticalFlip => 'В Флип';

  @override
  String get innerOuterFlip => 'IO Флип';

  @override
  String get transparentCanvas => 'Транспарентно Платно';

  @override
  String get restrictRepeatedMillsFormation =>
      'Ограничи повторно формирање мелници';

  @override
  String get restrictRepeatedMillsFormation_Detail =>
      'Парче што се преместува од еден млин во друг не може веднаш да се врати на почетната точка на следниот потег за да формира млин повторно. Прво е потребен различен потег.';

  @override
  String get oneTimeUseMill => 'Еднократна употреба мелница';

  @override
  String get oneTimeUseMill_Detail =>
      'Секоја мелница може да отстрани само еден дел од противникот еднаш. Можете повторно да го формирате, но не може да се користи за дополнителни отстранувања.';

  @override
  String get currentRulesNoPerfectDatabase =>
      'Тековните правила што ги поставивте немаат соодветна совршена база на податоци. За повеќе информации за совршената база на податоци, кликнете овде.';

  @override
  String get focusOnBlockingPaths => 'Фокусирајте се на блокирање на патеките';

  @override
  String get focusOnBlockingPaths_Detail =>
      'Дадете приоритет на блокирањето на движењето на противникот наместо формирање мелници. Наместо да се фокусирате на отстранување на фигури со завршување на мелници, AI има за цел да го зароби противникот, оневозможувајќи го да се движи и обезбедувајќи победа преку исцрпување наместо агресивна игра. Оваа стратегија не ги блокира активно мелниците на противникот.';

  @override
  String get pieceImage => 'Слика на фигура';

  @override
  String get importColorSettings => 'Внеси поставки за боја';

  @override
  String get exportColorSettings => 'Изнеси поставки за боја';

  @override
  String get import => 'Увези';

  @override
  String get export => 'Извези';

  @override
  String get pleaseCopyJsonToClipboard =>
      'Копирајте ги поставките на JSON форматот во таблата за сечење.';

  @override
  String get copiedToClipboard => 'Копирано во таблата за сечење.';

  @override
  String get imported => 'Увезено.';

  @override
  String get boardImage => 'Слика на табла';

  @override
  String get autumnLeaves => 'Есенски лисја';

  @override
  String get legendaryLand => 'Легендарна Земја';

  @override
  String get vignetteEffect => 'Ефект на винјета';

  @override
  String get promptMakeToolbarTransparent =>
      'Дали сакате алатната лента да биде целосно проѕирна кога е поставена слика за позадина на таблата?';

  @override
  String get vibration => 'Овозможи вибрации во играта';

  @override
  String get soundTheme => 'Тема на звук';

  @override
  String get ball => 'Топка';

  @override
  String get liquid => 'Течност';

  @override
  String get wood => 'Дрво';

  @override
  String get placeEffectAnimation =>
      'Анимациски ефект при поставување на фигура';

  @override
  String get removeEffectAnimation =>
      'Анимациски ефект при отстранување на фигура';

  @override
  String get isToolbarAtBottom => 'Прикажи ја алатникот на дното';

  @override
  String get boardCornerRadius => 'Радиус на аголот на таблата';

  @override
  String get useOpeningBook => 'Користете книга за отворање';

  @override
  String get currentRule => 'Тековен';

  @override
  String get nineMensMorris => 'Nine Men\'s Morris';

  @override
  String get twelveMensMorris => 'Twelve Men\'s Morris';

  @override
  String get morabaraba => 'Morabaraba';

  @override
  String get dooz => 'Dooz';

  @override
  String get chamGonu => 'Cham Gonu';

  @override
  String get zhiQi => 'Zhi Qi';

  @override
  String get chengSanQi => 'Cheng San Qi';

  @override
  String get mulMulan => 'Mul-Mulan';

  @override
  String get nerenchi => 'Nerenchi';

  @override
  String get ruleSet => 'Сет на правила';

  @override
  String get laskerMorris => 'Lasker Morris';

  @override
  String get oneTimeMill => 'One-Time Mill';

  @override
  String get daSanQi => 'Da San Qi';

  @override
  String get useOpeningBook_Detail =>
      'Дозволете на АИ да користи почетни потези кои обично ги користат професионални човечки играчи во раната фаза на играта. Забелешка: Оваа функционалност моментално е достапна само за одредени сетови на правила.';

  @override
  String get showAdvantageGraph => 'Прикажи график на предност';

  @override
  String get advantageGraphHint =>
      'Графикот за предност ќе биде нацртан само откако ВИ ќе направи потег. Тој нема да биде нацртан кога човечкиот играч прави потег.';

  @override
  String get removalBasedOnMillCounts =>
      'Оневозможете отстранување додека не се постават сите фигури. Играчите отстрануваат фигури врз основа на бројот на мелници.';

  @override
  String get removalBasedOnMillCounts_Detail =>
      'Оневозможете отстранување додека не се постават сите фигури. Играчите отстрануваат фигури врз основа на бројот на мелници: ако бројот е еднаков, и двајцата отстрануваат еднаков број фигури; ако еден има повеќе, отстранува дополнителна фигура, одржувајќи разлика од една фигура. Ако само еден оформува мелница, тој отстранува две фигури, а другиот една. Ако никој не оформи мелница, и двајцата отстрануваат по една фигура.';

  @override
  String get elfilja => 'Ел Филџа';

  @override
  String get tipSelectOwnPiece => 'Избери една од твоите фигури.';

  @override
  String get notYourTurn => 'Не е вашиот ред.';

  @override
  String get annotationToolbarBackgroundColor =>
      'Боја на позадината на алатката за анотации';

  @override
  String get annotationToolbarIconColor =>
      'Боја на иконата на алатката за анотации';

  @override
  String get isAnnotationToolbarShown => 'Прикажи алатката за анотации';

  @override
  String get enterAnnotationMode => 'Влез во режим на анотации';

  @override
  String get areYouSureYouWantToClearAllAnnotations =>
      'Дали сте сигурни дека сакате да ги избришете сите анотации?';

  @override
  String get llmPromptCopiedToClipboard =>
      'LLM подсказот е копиран во клипборд.';

  @override
  String get connectionRefusedTheServerMayBeDown =>
      'Поврзувањето е одбиено, серверот може да е исклучен.';

  @override
  String get discoverySuccessfulAwaitingConnection =>
      'Откривањето е успешно, чекање за врска...';

  @override
  String get noLanConnection => 'Нема LAN врска';

  @override
  String get takeScreenshot => 'Направи скриншот';

  @override
  String get disconnectedFromOpponent => 'Врската со противникот е прекинута.';

  @override
  String get takeBackRequest => 'Барање за враќање на потегот';

  @override
  String get nothingToShow => 'Нема ништо за прикажување.';

  @override
  String get stopHosting => 'Заустави хостирање';

  @override
  String get connectionResetByPeer =>
      'Поврзувањето е ресетирано од другата страна.';

  @override
  String get connectionLostDueToHeartbeatTimeoutPleaseReconnect =>
      'Врската е изгубена поради истекување на heartbeat, ве молиме повторно се поврзете.';

  @override
  String get startHosting => 'Започни хостирање';

  @override
  String get restartRequestRejected => 'Барањето за рестартирање е одбиено.';

  @override
  String get notConnectedToLanOpponent => 'Не сте поврзани со LAN противник.';

  @override
  String get llmPrompt => 'LLM подсказ';

  @override
  String get gameRestarted => 'Играта е рестартирана.';

  @override
  String get takeBackRejected => 'Барањето за враќање на потегот е одбиено.';

  @override
  String get areYouSureYouWantToResignThisGame =>
      'Дали сте сигурни дека сакате да ја предадете оваа игра?';

  @override
  String get opponentResignedYouWin =>
      'Противникот се предаде. Вие победувате!';

  @override
  String get clearAllAnnotations => 'Исчисти ги сите анотации';

  @override
  String get connectedWaitingForOpponentSMove =>
      'Поврзано, чека се потег на противникот...';

  @override
  String get networkStatusDisconnected => 'Мрежен статус: Прекинута';

  @override
  String get takeBackRequestSentToTheOpponent =>
      'Барањето за враќање на потегот е испратено до противникот.';

  @override
  String get theOpponentMayHaveLeftTheGame =>
      'Противникот можеби ја напушти играта';

  @override
  String get connectedToHostSuccessfully => 'Успешно поврзување со домаќинот.';

  @override
  String get connectionLostHeartbeatTimeout =>
      'Врската е изгубена: истекување на heartbeat';

  @override
  String get noHostDiscovered => 'Не е откриен домаќин.';

  @override
  String get confirmResignation => 'Потврди предавање';

  @override
  String get startedHostingGameWaitingForPlayersToJoin =>
      'Почна хостирање на играта, чекајќи играчи да се приклучат...';

  @override
  String get connectionTimedOutNetworkConnectionUnstable =>
      'Поврзувањето истече, мрежната врска е нестабилна.';

  @override
  String get noLlmPromptAvailable => 'Нема достапен LLM подсказ.';

  @override
  String get youResignedGameOver => 'Вие се предавте. Играта е завршена.';

  @override
  String get serverIp => 'IP на серверот';

  @override
  String get confirmClear => 'Потврди исчистување';

  @override
  String get opponentSTurn => 'Ред на противникот.';

  @override
  String get waitingAClientConnection => 'Чека се врска од клиентот...';

  @override
  String get takeBackRequestWasRejectedOrFailed =>
      'Барањето за враќање на потегот беше одбиено или не успеа.';

  @override
  String get addText => 'Додај текст';

  @override
  String get exitAnnotationMode => 'Излез од режим на анотации';

  @override
  String get typeYourAnnotation => 'Внесете ја вашата анотација';

  @override
  String get attemptingToReconnect => 'Обид за повторно поврзување...';

  @override
  String get restartRequestSentWaitingForOpponentSResponse =>
      'Барањето за рестартирање е испратено. Чека се одговор од противникот...';

  @override
  String get serverIsStopped => 'Серверот е прекинат.';

  @override
  String get restartRequest => 'Барање за рестартирање';

  @override
  String get cannotRequestATakeBackWhenItSNotYourTurn =>
      'Не може да побарате враќање на потегот кога не е вашиот ред.';

  @override
  String get takeBackAccepted => 'Барањето за враќање на потегот е прифатено.';

  @override
  String get localNetworkSettings => 'Поставки на локалната мрежа';

  @override
  String get reconnectedSuccessfully => 'Повторното поврзување е успешно!';

  @override
  String get failedToSaveImageToGallery =>
      'Не успеа да се зачува сликата во Галерија.';

  @override
  String get opponentRequestedToRestartTheGameDoYouAccept =>
      'Противникот побара рестартирање на играта. Дали прифаќате?';

  @override
  String get yourTurn => 'Ваш ред.';

  @override
  String get unableToReconnectPleaseRestartTheGame =>
      'Не може да се повторно поврзете, ве молиме рестартирајте ја играта.';

  @override
  String get host => 'Домаќин';

  @override
  String get join => 'Приклучи се';

  @override
  String get port => 'Порт';

  @override
  String get invalidIpAddress => 'Невалидна IP адреса.';

  @override
  String get invalidPort => 'Невалиден порт.';

  @override
  String connectingAttempt(Object attempt, Object maxAttempt) {
    return 'Поврзување: Обид $attempt/$maxAttempt';
  }

  @override
  String failedToConnect(Object error) {
    return 'Не успеа поврзувањето: $error';
  }

  @override
  String failedToStartHosting(Object error) {
    return 'Не успеа да се започне хостирањето: $error';
  }

  @override
  String hostDiscovered(Object ip, Object port) {
    return 'Откриен домаќин: $ip:$port';
  }

  @override
  String get stop => 'Стоп';

  @override
  String get discover => 'Откриј';

  @override
  String get connect => 'Поврзи се';

  @override
  String clientConnected(Object clientIp, Object clientPort) {
    return 'Поврзан клиент: $clientIp:$clientPort';
  }

  @override
  String discoveringSeconds(Object seconds) {
    return 'Откривање: $seconds с';
  }

  @override
  String reconnecting(Object attempt, Object maxAttempts) {
    return 'Повторно поврзување ($attempt/$maxAttempts)';
  }

  @override
  String get connected => 'Поврзано';

  @override
  String get delete => 'Избриши';

  @override
  String get ancientEgypt => 'Антички Египет';

  @override
  String get gothicIce => 'Готски Лед';

  @override
  String get riceField => 'Поле со Ориз';

  @override
  String get chinesePorcelain => 'Кинески Порцелан';

  @override
  String get desertDusk => 'Пустински Самрак';

  @override
  String get precisionCraft => 'Прецизен Занает';

  @override
  String get folkEmbroidery => 'Народна Везба';

  @override
  String get carpathianHeritage => 'Карпатско Наследство';

  @override
  String get imperialGrandeur => 'Империјална Величественост';

  @override
  String get bohemianCrystal => 'Боемски Кристал';

  @override
  String get savannaSunrise => 'Савански Изгрејсонце';

  @override
  String get harmonyBalance => 'Хармонија и Рамнотежа';

  @override
  String get cinnamonSpice => 'Цимет Зачин';

  @override
  String get anatolianMosaic => 'Анатолиски Мозаик';

  @override
  String get carnivalSpirit => 'Карневалски Дух';

  @override
  String get custom => 'Обичај';

  @override
  String get spiceMarket => 'Пазар за зачини';

  @override
  String get swipeToRevealTheDrawer => 'Провлечете за да го откриете фиоката';

  @override
  String get showGameInfoOnScreenshots =>
      'Прикажи информации за играта на екранот';

  @override
  String get humanMoveTime => 'Временско ограничување за човечки потег';

  @override
  String get noTimeLimitForHumanMoves =>
      'Нема временско ограничување за човечки потези';

  @override
  String get timeoutLoseWillBeApplied =>
      'За човечкиот играч ќе се примени загуба поради истек на времето';

  @override
  String get identifyingBoard => 'Се идентификува таблата за игра…';

  @override
  String get youCanEnterAnyModelName =>
      'Можете да внесете било кое име на модел.';

  @override
  String get boardPositionAppliedFenCopiedToClipboard =>
      'Позицијата на таблата е применета. FEN е копиран во клипбордот.';

  @override
  String get suggestionTryTakingAClearerPictureOfTheBoard =>
      'Предлог: обидете се да направите побистра фотографија на таблата.';

  @override
  String get llmPromptTemplate => 'LLM шаблон за упатување';

  @override
  String get noValidBoardDetected => 'Не е откриена валидна табла.';

  @override
  String get selectingImageFromAlbum => 'Селектирање слика од албум…';

  @override
  String get configurePromptTemplate => 'Конфигурирај шаблон за упатување';

  @override
  String get editPromptTemplateForLlmAnalysis =>
      'Уреди шаблон за упатување за LLM анализа';

  @override
  String get failedToGenerateFenFromRecognizedBoard =>
      'Не успеа да се генерира FEN од препознаената табла.';

  @override
  String get outputInCurrentLanguage => 'Излез на тековниот јазик';

  @override
  String get commonBaseUrls => 'Често користени Base URL';

  @override
  String get viewCommonModels => 'Преглед на често користени модели';

  @override
  String get recognitionParametersUpdated =>
      'Параметрите за препознавање се ажурирани.';

  @override
  String get whiteSMove => 'Потег на белите';

  @override
  String get resetToDefaults => 'Врати на стандардни поставки';

  @override
  String get photoShoot => 'Фотосесија';

  @override
  String get failedToApplyRecognizedBoardPosition =>
      'Не успеа да се примени препознаената позиција на таблата.';

  @override
  String get llmPromptContent => 'LLM содржина на упатување';

  @override
  String get llmNotConfiguredPleaseCheckYourSettings =>
      'LLM не е конфигуриран. Проверете ги вашите поставки.';

  @override
  String get setProviderModelApiKeyAndBaseUrl =>
      'Поставете добавувач, модел, API Key и Base URL';

  @override
  String get llmConfiguration => 'LLM конфигурација';

  @override
  String get configureLlmProvider => 'Конфигурирај LLM добавувач';

  @override
  String get llmPromptTemplateHeader => 'Заглавје на LLM шаблон за упатување';

  @override
  String get noPiecesWereRecognizedInTheImagePleaseTryAgain =>
      'Во сликата не беа препознаени фигури. Обидете се повторно.';

  @override
  String get recognizeBoardFromImage => 'Препознај табла од слика';

  @override
  String get viewTips => 'Прикажи совети';

  @override
  String get applyToBoard => 'Примени на таблата';

  @override
  String get adjustBoardArea => 'Прилагоди област на таблата';

  @override
  String get viewCommonUrls => 'Преглед на често користени URL';

  @override
  String get colorAnalysisFailed => 'Анализа на боите не успеа!';

  @override
  String get analyzingGameBoardImage =>
      'Се анализира слика на таблата за игра…';

  @override
  String get selectFromAlbum => 'Избери од албум';

  @override
  String get noBoardPointDetected => 'Не е откриена точка на таблата!';

  @override
  String get ifLeftEmptyDefaultTemplateWillBeUsed =>
      'Ако остане празно, ќе биде користен стандардниот шаблон';

  @override
  String get llmConfig => 'LLM конфигурација';

  @override
  String get areYouSureYouWantToResetThePromptTemplatesToDefaultValues =>
      'Дали сте сигурни дека сакате да ги вратите шаблоните за упатување на стандардните вредности?';

  @override
  String get llmPromptTemplateFooter => 'Подножје на LLM шаблон за упатување';

  @override
  String get loadingResponse => 'Се вчитува одговор…';

  @override
  String get applyThisResultToBoard => 'Примени го овој резултат на таблата';

  @override
  String get takingPicture => 'Се прави фотографија…';

  @override
  String get pleaseSelectAGameBoardImageToIdentify =>
      'Ве молиме изберете слика на таблата за игра за препознавање';

  @override
  String get identificationResults => 'Резултати од идентификација';

  @override
  String get analyzeTheMovesAndProvideInsights =>
      'Анализирај ги потезите и обезбеди согледувања.';

  @override
  String get getApiKey => 'Земи API Key';

  @override
  String get entireRecognitionProcessFailedToComplete =>
      'Целиот процес на препознавање не успеа да се заврши.';

  @override
  String get boardRecognitionResult => 'Резултат од препознавање на таблата';

  @override
  String get askLlm => 'Побарај LLM';

  @override
  String get boardDetectionFailed => 'Откривањето на таблата не успеа!';

  @override
  String get noBoardPointDetectedCannotIdentifyPiece =>
      'Не е откриена точка на таблата, не може да се идентификува фигура!';

  @override
  String get copyFen => 'Копирај FEN';

  @override
  String get commonlyUsedModels => 'Често користени модели';

  @override
  String get apiKeyOptional => 'API Key (опционо)';

  @override
  String get noImageSelected => 'Нема избрана слика';

  @override
  String get blackSMove => 'Потег на црните';

  @override
  String get llm => 'Голем јазичен модел';

  @override
  String get llmProvider => 'Доставувач';

  @override
  String get baseUrl => 'Основен URL';

  @override
  String get model => 'Модел';

  @override
  String get temperature => 'Температура';

  @override
  String get llmCommandReceivedProcessing =>
      'Командата е примена! В.И. обработува...';

  @override
  String get llmDeepThinkingWait =>
      'Во тек е длабоко размислување, ве молиме почекајте...';

  @override
  String get llmPresentingSoon => 'Набрзо ќе следи презентација...';

  @override
  String get recognitionParameters => 'Параметри за препознавање';

  @override
  String get adjustParamsDesc =>
      'Прилагодете ги параметрите за да ја подобрите точноста на препознавањето';

  @override
  String get saveParameters => 'Зачувај параметри';

  @override
  String unableToStartImageRecognition(String error) {
    return 'Не може да започне препознавање на слика: $error';
  }

  @override
  String imageRecognitionFailed(String error) {
    return 'Препознавањето на слика не успеа: $error';
  }

  @override
  String appliedPositionDetails(int whiteCount, int blackCount) {
    return 'Применета позиција со $whiteCount бели и $blackCount црни фигури';
  }

  @override
  String get fenCopiedToClipboard => '(FEN копиран во таблата за исечоци)';

  @override
  String recognitionFailed(String error) {
    return 'Неуспешно препознавање: $error';
  }

  @override
  String get myRating => 'Мој рејтинг';

  @override
  String get gamesPlayed => 'Одиграни игри';

  @override
  String get wins => 'Победи';

  @override
  String get losses => 'Порази';

  @override
  String get draws => 'Нерешени';

  @override
  String get lastUpdated => 'Последно ажурирано';

  @override
  String get format => 'Формат:';

  @override
  String get resetStatistics => 'Ресетирај статистика';

  @override
  String get drawRate => 'Стапка на нерешени';

  @override
  String get lossRate => 'Стапка на порази';

  @override
  String get aiStatistics => 'Статистика за ВИ';

  @override
  String get enableStatistics => 'Овозможи статистика';

  @override
  String get enableStatistics_Detail =>
      'Кога е овозможено, резултатите од играта ќе бидат евидентирани во статистиката. Сепак, игрите што вклучуваат враќање на потези нема да бидат евидентирани. Кога е оневозможено, собирањето статистика е паузирано.';

  @override
  String get thisWillResetAllGameStatistics =>
      'Ова ќе ја ресетира целата статистика на играта. Оваа акција не може да се врати.';

  @override
  String get boardInnerRingSize => 'Големина на внатрешниот прстен на таблата';

  @override
  String get boardShadowEnabled => 'Сенка на таблата';

  @override
  String get trapAwareness => 'Откривање замки';

  @override
  String get trapAwarenessDescription =>
      'Истакни ги потезите-замка со дебели кругови и стрели за време на анализата.';

  @override
  String trapExists(String trapMoves) {
    return 'Постои замка. Потези-замка: $trapMoves';
  }

  @override
  String get custodianCapture => 'Снимање на крило';

  @override
  String get custodianCaptureDescription =>
      'Повелете едно од парчињата на вашиот противник помеѓу две ваши во права линија за да го фатите.';

  @override
  String get custodianCaptureEnable => 'Дозволете фаќање на крило';

  @override
  String get interventionCapture => 'Фаќање интервенција';

  @override
  String get interventionCaptureDescription =>
      'Преминете во празната точка помеѓу две парчиња на вашиот противник за да ги фатите и двете.';

  @override
  String get interventionCaptureEnable => 'Дозволете фаќање на интервенција';

  @override
  String get leapCapture => 'Скокно снимање';

  @override
  String get leapCaptureDescription =>
      'Фаќајте со скокање над парчето на соседниот противник во празната точка подалеку.';

  @override
  String get leapCaptureEnable => 'Дозволете да се фати скок';

  @override
  String get captureApplicableLines => 'Применливи линии';

  @override
  String get captureSquareEdges => 'По должината на рабовите на плоштадот';

  @override
  String get captureCrossLines =>
      'По ортогоналните линии што го преминуваат плоштадот';

  @override
  String get captureDiagonalLines =>
      'По дијагоналните линии што го преминуваат плоштадот';

  @override
  String get captureExecutionPhases => 'Фази на извршување';

  @override
  String get capturePiecesCondition =>
      'Достапност за време на фазата на движење врз основа на преостанатите парчиња';

  @override
  String get capturePiecesConditionUnlimited => 'Без ограничување';

  @override
  String get capturePiecesConditionSelfLeqThree =>
      'Достапно кога имате три или помалку парчиња';
}
